/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.idp.um.api.infomodel;

import com.adobe.idp.um.api.UMUtil;
import com.adobe.idp.um.api.infomodel.GenericSearchFilter;
import java.io.Serializable;
import java.util.Set;

public class PrincipalSearchFilter
extends GenericSearchFilter
implements Serializable {
    private static final long serialVersionUID = -9034365341170661126L;
    protected boolean obtainCompletePrincipal = true;
    protected Set domainOids = null;
    public static final String SEARCH_principalOid = "PRINCIPAL_OID";
    public static final String SEARCH_principalType = "PRINCIPAL_TYPE";
    public static final String SEARCH_email = "EMAIL";
    public static final String SEARCH_userid = "USER_ID";
    public static final String SEARCH_visibility = "VISIBILITY";
    public static final String SEARCH_commonName = "COMMON_NAME";
    public static final String SEARCH_isLocal = "IS_LOCAL";
    public static final String SEARCH_domainName = "DOMAIN_NAME";
    public static final String SEARCH_domainId = "DOMAIN_ID";
    public static final String SEARCH_canonicalName = "CANONICAL_NAME";
    public static final String SEARCH_principal_status = "PRINCIPAL_STATUS";
    public static final String SEARCH_domain_status = "DOMAIN_STATUS";
    public static final String SEARCH_domain_oids = "DOMAIN_OIDS";
    public static final String STATUS_CURRENT = "CURRENT";
    public static final Object SORT_CommonName = "SORT_CommonName";
    public static final Object SORT_Email = "SORT_Email";
    public static final Object SORT_Organization = "SORT_Organization";

    public PrincipalSearchFilter() {
        this.setVisibility(1);
    }

    public void setEmail(String e) {
        e = UMUtil.parseWildCardCharacters(e);
        super.addSearch(SEARCH_email, PrincipalSearchFilter.getLikeSearchString(e), 8);
    }

    public void setPrincipalOid(String principalOid) {
        super.addSearch(SEARCH_principalOid, principalOid, 1);
    }

    public String getPrincipalOid() {
        String principalOid = (String)super.getSearchVal(SEARCH_principalOid);
        return principalOid;
    }

    public String getEmail() {
        String ret = (String)super.getSearchVal(SEARCH_email);
        if (ret != null) {
            ret = PrincipalSearchFilter.undoLikeSearchString(ret);
        }
        return ret;
    }

    public void setPrincipalType(String principalType) {
        super.addSearch(SEARCH_principalType, principalType, 1);
    }

    public String getPrincipalType() {
        String principalType = (String)super.getSearchVal(SEARCH_principalType);
        return principalType;
    }

    public void setUserid(String userId) {
        userId = UMUtil.parseWildCardCharacters(userId);
        super.addSearch(SEARCH_userid, PrincipalSearchFilter.getLikeSearchString(userId.toLowerCase()), 8);
    }

    public void setUserId(String userId) {
        userId = UMUtil.parseWildCardCharacters(userId);
        super.addSearch(SEARCH_userid, PrincipalSearchFilter.getLikeSearchString(userId.toLowerCase()), 8);
    }

    public void setUserIdAbsolute(String userId) {
        userId = UMUtil.parseWildCardCharacters(userId);
        super.addSearch(SEARCH_userid, userId.toLowerCase(), 1);
    }

    public String getUserId() {
        String userId = (String)super.getSearchVal(SEARCH_userid);
        return userId;
    }

    public void setCommonName(String cn) {
        cn = UMUtil.parseWildCardCharacters(cn);
        super.addSearch(SEARCH_commonName, PrincipalSearchFilter.getLikeSearchString(cn), 8);
    }

    public String getCommonName() {
        String ret = (String)super.getSearchVal(SEARCH_commonName);
        if (ret != null) {
            ret = PrincipalSearchFilter.undoLikeSearchString(ret);
        }
        return ret;
    }

    public void setIsLocal(boolean restrictIsLocal) {
        Boolean bl = restrictIsLocal ? Boolean.TRUE : Boolean.FALSE;
        super.addSearch(SEARCH_isLocal, bl, 1);
    }

    public Boolean isLocal() {
        Boolean bl = (Boolean)super.getSearchVal(SEARCH_isLocal);
        return bl;
    }

    public void setSpecificDomainName(String domainName) {
        domainName = UMUtil.parseWildCardCharacters(domainName);
        this.removeSearch(SEARCH_domainId);
        this.removeSearch(SEARCH_domain_oids);
        this.domainOids = null;
        super.addSearch(SEARCH_domainName, domainName, 1);
    }

    public void setSpecificDomain(String domainOid) {
        this.removeSearch(SEARCH_domainName);
        this.removeSearch(SEARCH_domain_oids);
        this.domainOids = null;
        super.addSearch(SEARCH_domainId, domainOid, 1);
    }

    public String getSpecificDomain() {
        String ret = (String)super.getSearchVal(SEARCH_domainId);
        return ret;
    }

    public void setCanonicalName(String canonicalName) {
        canonicalName = UMUtil.parseWildCardCharacters(canonicalName);
        super.addSearch(SEARCH_canonicalName, canonicalName, 1);
    }

    public String getCanonicalName() {
        String ret = (String)super.getSearchVal(SEARCH_canonicalName);
        return ret;
    }

    public void setVisibility(int visibility) {
        Integer visibilityLevel = new Integer(visibility);
        super.addSearch(SEARCH_visibility, visibilityLevel, 6);
    }

    public void setRetrieveOnlyActive() {
        super.addSearch(SEARCH_domain_status, STATUS_CURRENT, 1);
        super.addSearch(SEARCH_principal_status, STATUS_CURRENT, 1);
    }

    public void setRetrieveOnlyActive(boolean retrieveActive) {
        if (retrieveActive) {
            this.setRetrieveOnlyActive();
        }
    }

    public boolean obtainCompletePrincipal() {
        return this.obtainCompletePrincipal;
    }

    public void setObtainCompletePrincipal(boolean obtainCompletePrincipal) {
        this.obtainCompletePrincipal = obtainCompletePrincipal;
    }

    public void setDomainOids(Set domainOids) {
        this.removeSearch(SEARCH_domainId);
        this.removeSearch(SEARCH_domainName);
        super.addSearch(SEARCH_domain_oids, domainOids, 1);
        this.domainOids = domainOids;
    }

    public Set getDomainOids() {
        return this.domainOids;
    }
}

