/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.idp.um.api.impl;

import com.adobe.idp.um.api.infomodel.Domain;
import com.adobe.idp.um.api.infomodel.Group;
import com.adobe.idp.um.api.infomodel.Permission;
import com.adobe.idp.um.api.infomodel.PrincipalReference;
import com.adobe.idp.um.api.infomodel.ReliantApplication;
import com.adobe.idp.um.api.infomodel.ResourceType;
import com.adobe.idp.um.api.infomodel.ResourceTypeACL;
import com.adobe.idp.um.api.infomodel.Role;
import com.adobe.idp.um.api.infomodel.User;
import com.adobe.idp.um.api.infomodel.UserInfo;
import com.adobe.idp.um.api.infomodel.impl.DomainImpl;
import com.adobe.idp.um.api.infomodel.impl.GroupImpl;
import com.adobe.idp.um.api.infomodel.impl.PermissionImpl;
import com.adobe.idp.um.api.infomodel.impl.PrincipalReferenceImpl;
import com.adobe.idp.um.api.infomodel.impl.ReliantApplicationImpl;
import com.adobe.idp.um.api.infomodel.impl.ResourceTypeACLImpl;
import com.adobe.idp.um.api.infomodel.impl.ResourceTypeImpl;
import com.adobe.idp.um.api.infomodel.impl.RoleImpl;
import com.adobe.idp.um.api.infomodel.impl.UserImpl;
import java.util.Date;

public class UMBaseLibrary {
    public static PrincipalReference createPrincipalReference(String canonicalName, String domainCanonicalName, String principalType) {
        PrincipalReferenceImpl principalReference = new PrincipalReferenceImpl();
        principalReference.setCanonicalName(canonicalName);
        principalReference.setDomainName(domainCanonicalName);
        principalReference.setPrincipalType(principalType);
        return principalReference;
    }

    public static Group createGroup(String canonicalName, String domainCanonicalName, String groupType) {
        GroupImpl ret = (GroupImpl)UMBaseLibrary.createPrincipalGroup(canonicalName, domainCanonicalName, groupType, true);
        return ret;
    }

    public static Group createSystemGroup(String canonicalName, String domainCanonicalName, String groupType) {
        GroupImpl ret = (GroupImpl)UMBaseLibrary.createPrincipalGroup(canonicalName, domainCanonicalName, groupType, true);
        ret.setIsSystem(true);
        return ret;
    }

    public static Group createDirectoryGroup(String canonicalName, String domainCanonicalName) {
        GroupImpl ret = (GroupImpl)UMBaseLibrary.createPrincipalGroup(canonicalName, domainCanonicalName, "GROUP", false);
        return ret;
    }

    private static Group createPrincipalGroup(String canonicalName, String domainCanonicalName, String groupType, boolean isLocal) {
        GroupImpl group = new GroupImpl();
        group.setCanonicalName(canonicalName);
        group.setDomainName(domainCanonicalName);
        group.setGroupType(groupType);
        group.setLocal(isLocal);
        group.setPrincipalType("GROUP");
        group.setTimestampCreated(new Date());
        group.setTimestampUpdated(new Date());
        group.setStatus("CURRENT");
        return group;
    }

    private static User createPrincipalUser(String canonicalName, String domainCanonicalName, String userId, String principalType, boolean isLocal) {
        UserImpl ret = new UserImpl();
        ret.setCanonicalName(canonicalName);
        ret.setDomainName(domainCanonicalName);
        ret.setUserid(userId);
        ret.setLocal(isLocal);
        if (principalType.equals("SYSTEM")) {
            ret.setIsSystem(true);
            ret.setPrincipalType("USER");
        } else {
            ret.setPrincipalType(principalType);
        }
        ret.setTimestampCreated(new Date());
        ret.setTimestampUpdated(new Date());
        ret.setStatus("CURRENT");
        return ret;
    }

    public static User createSystemPrincipal(String canonicalName, String domainCanonicalName, String userId) {
        User ret = UMBaseLibrary.createPrincipalUser(canonicalName, domainCanonicalName, userId, "SYSTEM", true);
        return ret;
    }

    public static User createUser(String canonicalName, String domainCanonicalName, String userId) {
        User ret = UMBaseLibrary.createPrincipalUser(canonicalName, domainCanonicalName, userId, "USER", true);
        return ret;
    }

    public static UserInfo createUserInfo(String canonicalName, String domainName, String userId, String password) {
        User user = UMBaseLibrary.createUser(canonicalName, domainName, userId);
        return new UserInfo(user, password);
    }

    public static User createSystemUser(String canonicalName, String domainCanonicalName, String userId) {
        UserImpl ret = (UserImpl)UMBaseLibrary.createPrincipalUser(canonicalName, domainCanonicalName, userId, "USER", true);
        ret.setIsSystem(true);
        return ret;
    }

    public static User createDirectoryUser(String canonicalName, String domainCanonicalName, String userId) {
        UserImpl ret = (UserImpl)UMBaseLibrary.createPrincipalUser(canonicalName, domainCanonicalName, userId, "USER", false);
        return ret;
    }

    public static Domain createDomain(String domainName) {
        DomainImpl ret = new DomainImpl();
        ret.setDomainName(domainName);
        ret.setLocal(true);
        return ret;
    }

    public static Role createRole(String roleId) {
        RoleImpl ret = RoleImpl.create(roleId);
        return ret;
    }

    public static ReliantApplication createReliantApplication(String relAppName) {
        ReliantApplicationImpl ret = ReliantApplicationImpl.create(relAppName);
        return ret;
    }

    public static ResourceType createResourceType(String resType) {
        ResourceTypeImpl ret = ResourceTypeImpl.create(resType);
        return ret;
    }

    public static ResourceTypeACL createResourceTypeACL(String resTypeId) {
        ResourceTypeACLImpl ret = ResourceTypeACLImpl.create();
        ret.setResTypeId(resTypeId);
        return ret;
    }

    public static Permission createPermission(String perm) {
        PermissionImpl ret = PermissionImpl.create(perm);
        return ret;
    }
}

