/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.idp.um.api;

import com.adobe.idp.Context;
import com.adobe.idp.common.errors.Logger;
import com.adobe.idp.um.api.AuthorizationManager;
import com.adobe.idp.um.api.UMException;
import com.adobe.idp.um.api.UMFactory;
import com.adobe.idp.um.api.infomodel.Permission;
import com.adobe.idp.um.api.infomodel.PermissionSearchFilter;
import java.util.HashMap;

public class UMAuthorizationUtil {
    private static final String loggerCategory;
    private static final Logger logger;
    public static final String[] allUMPermissions;
    private static HashMap allUMPermissionsOids;
    static /* synthetic */ Class class$com$adobe$idp$um$api$UMAuthorizationUtil;

    private static void getAllUmPermissionOIds(Context ctx, AuthorizationManager am) throws UMException {
        allUMPermissionsOids = new HashMap();
        PermissionSearchFilter psf = new PermissionSearchFilter();
        String thisPerm = null;
        Permission thisPermObj = null;
        for (int i = 0; i < allUMPermissions.length; ++i) {
            thisPerm = allUMPermissions[i];
            psf.setSpecificPermissionName(thisPerm);
            psf.setSpecificResTypeId("00000000-0000-0000-0000-000000000032");
            thisPermObj = (Permission)am.getPermissions(psf).get(0);
            allUMPermissionsOids.put(thisPerm, thisPermObj.getOid());
        }
    }

    public static void checkForUMPermissions(Context ctx, String[] umPermsToBeCheckedForList) throws UMException {
        AuthorizationManager am = UMFactory.getInstance().getAuthorizationManager(ctx);
        if (allUMPermissionsOids == null) {
            UMAuthorizationUtil.getAllUmPermissionOIds(ctx, am);
        }
        String principalOid = ctx.getAuthenticatedUser().getOid();
        String permOid = null;
        for (int i = 0; i < umPermsToBeCheckedForList.length; ++i) {
            String perm = umPermsToBeCheckedForList[i];
            permOid = (String)allUMPermissionsOids.get(perm);
            if (am.hasPermission(principalOid, "00000000-0000-0000-0000-000000000032", permOid).hasPermission()) continue;
            throw new UMException(loggerCategory, 16386, "Context not authorized with permission : " + perm);
        }
    }

    static {
        Class<?> clazz = class$com$adobe$idp$um$api$UMAuthorizationUtil;
        if (clazz == null) {
            clazz = class$com$adobe$idp$um$api$UMAuthorizationUtil = new UMAuthorizationUtil[0].getClass().getComponentType();
        }
        loggerCategory = clazz.getName();
        Class<?> clazz2 = class$com$adobe$idp$um$api$UMAuthorizationUtil;
        if (clazz2 == null) {
            clazz2 = class$com$adobe$idp$um$api$UMAuthorizationUtil = new UMAuthorizationUtil[0].getClass().getComponentType();
        }
        logger = Logger.getLogger((Class)clazz2);
        allUMPermissions = new String[]{"Admin Console Login", "Core Settings Control", "Domain Control", "Principal Control", "Role Control", "Identity Impersonation Control", "Renew assertion"};
        allUMPermissionsOids = null;
    }
}

