/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.idp.um.api;

import com.adobe.idp.common.errors.exception.IDPException;
import com.adobe.idp.common.errors.exception.IDPLoggedException;
import com.adobe.idp.common.infomodel.StoreId;
import com.adobe.idp.storeprovider.spi.StoreEntity;
import com.adobe.idp.storeprovider.spi.StoreProvider;
import com.adobe.idp.um.api.infomodel.Principal;
import com.adobe.idp.um.api.infomodel.PrincipalReference;
import com.adobe.idp.um.api.infomodel.User;
import com.adobe.idp.um.businesslogic.directoryservices.DirectoryServicesManager;
import com.adobe.idp.um.businesslogic.directoryservices.DirectoryServicesManagerHome;
import com.adobe.idp.um.config.util.UMConfigManager;
import com.adobe.idp.um.dpl.DirectoryFactory;
import com.adobe.idp.um.entity.PrincipalEntity;
import com.adobe.idp.um.server.cache.UMCacheManager;
import com.adobe.idp.um.util.EJBUtil;
import java.io.Serializable;
import java.util.Calendar;
import java.util.Date;
import java.util.Map;
import javax.ejb.EJBLocalObject;

public class UMAuthenticationUtil {
    public static final String authenticatedUserKey = "AUTHENTICATED_USER_KEY";
    public static final String storageProviderKey = "STORAGE_PROVIDER_KEY";

    public static User getPrincipal(String username, String domain) throws IDPException {
        User user = null;
        DirectoryServicesManager dsm = null;
        try {
            DirectoryServicesManagerHome dsmHome = EJBUtil.getDirectoryServicesManagerDefaultHome();
            dsm = dsmHome.create();
            user = dsm.getExpandedAuthenticatedUser(domain, username, 2);
        }
        catch (Exception e) {
            try {
                IDPLoggedException exp = new IDPLoggedException("AuthenticationManagerBean", 12803, "Exception while getting principal from Directory manager", e);
                throw exp;
            }
            catch (Throwable throwable) {
                EJBUtil.removeLocalEJBObject(dsm);
                throw throwable;
            }
        }
        EJBUtil.removeLocalEJBObject((EJBLocalObject)dsm);
        return user;
    }

    public static User validateAuthenticatedPrincipal(Map credentials, String userName, String domain) throws IDPException {
        User user = null;
        String key1 = "" + userName.toUpperCase().hashCode() + domain.hashCode();
        Object initialValueReadFromCache = UMCacheManager.get((String)"PRINCIPAL_CACHE", (Serializable)((Object)key1));
        user = initialValueReadFromCache != null && (initialValueReadFromCache instanceof Principal || initialValueReadFromCache instanceof PrincipalReference) ? (User)initialValueReadFromCache : UMAuthenticationUtil.getPrincipal(userName, domain);
        StoreProvider sp = (StoreProvider)credentials.get(storageProviderKey);
        UMAuthenticationUtil.checkUserStatus(sp, user);
        return user;
    }

    private static void checkUserStatus(StoreProvider sp, User user) throws IDPException {
        if ("OBSOLETE".equals(user.getStatus())) {
            throw new IDPLoggedException("AuthenticationManagerBean", 12803, "The user is marked as Obsolete", true);
        }
        if (user.isDisabled()) {
            throw new IDPLoggedException("AuthenticationManagerBean", 12803, "The user is disabled", true);
        }
        PrincipalEntity pe = null;
        Object valueFromCache = UMCacheManager.get((String)"PrincipalEntityCache", (Serializable)((Object)user.getOid()));
        if (valueFromCache != null && valueFromCache instanceof PrincipalEntity) {
            pe = (PrincipalEntity)valueFromCache;
        } else {
            pe = DirectoryFactory.findPrincipalEntity((StoreProvider)sp, (StoreId)new StoreId(user.getOid()));
            UMCacheManager.put((String)"PrincipalEntityCache", (Serializable)((Object)user.getOid()), (Object)pe);
        }
        if (user.isLocked()) {
            Date lockTime = pe.getTimestampLastAuthFailure();
            if (lockTime == null) {
                pe.setCountAuthFailure(0);
                pe.setLocked(false);
                sp.save((StoreEntity)pe);
            } else {
                Calendar lastUnsuccessful = Calendar.getInstance();
                int unLockMinutes = UMConfigManager.getAccountUnLockMinutes();
                lastUnsuccessful.setTime(lockTime);
                lastUnsuccessful.add(12, unLockMinutes);
                Calendar currentTime = Calendar.getInstance();
                if (currentTime.before(lastUnsuccessful)) {
                    throw new IDPLoggedException("AuthenticationManagerBean", 12803, "Account is locked because of too many unsuccessful attempts", true);
                }
                pe.setCountAuthFailure(0);
                pe.setLocked(false);
                sp.save((StoreEntity)pe);
                String key1 = user.getOid();
                String key2 = "" + user.getUserid().toUpperCase().hashCode() + user.getDomainName().hashCode();
                UMCacheManager.invalidate((String)"PRINCIPAL_CACHE", (Serializable)((Object)key1));
                UMCacheManager.invalidate((String)"PRINCIPAL_CACHE", (Serializable)((Object)key2));
                UMCacheManager.invalidate((String)"PrincipalEntityCache", (Serializable)((Object)key1));
            }
        } else if (pe.getCountAuthFailure() > 0) {
            pe.setCountAuthFailure(0);
            pe.setLocked(false);
            sp.save((StoreEntity)pe);
            UMCacheManager.invalidate((String)"PrincipalEntityCache", (Serializable)((Object)user.getOid()));
        }
    }
}

