/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.idp.common.util;

import java.security.NoSuchAlgorithmException;
import java.security.Provider;
import java.security.SecureRandom;
import java.security.Security;

public class CryptoUtil {
    private static SecureRandom rand = null;
    private static final int SEED_SIZE_BYTES = 40;

    private static final boolean isIBM() {
        Provider[] prvs = Security.getProviders();
        boolean ibm = false;
        for (int i = 0; i < prvs.length; ++i) {
            String name = prvs[i].getName();
            if (name.indexOf("IBM") < 0) continue;
            ibm = true;
            break;
        }
        return ibm;
    }

    public static final byte[] grdb(int n) throws Exception {
        byte[] bytes = null;
        try {
            if (rand == null) {
                rand = CryptoUtil.isIBM() ? SecureRandom.getInstance("IBMSecureRandom") : SecureRandom.getInstance("SHA1PRNG");
            }
            bytes = new byte[n];
            rand.nextBytes(bytes);
        }
        catch (NoSuchAlgorithmException e) {
            throw new Exception("getRandomBytes - no such algorithm supported");
        }
        return bytes;
    }
}

