/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.idp.common.infomodel;

import com.adobe.idp.common.errors.exception.IDPException;
import com.adobe.idp.common.errors.exception.IDPLoggedException;
import com.adobe.idp.common.util.Base64;
import com.adobe.idp.common.util.CryptoUtil;
import java.io.Serializable;
import java.security.SecureRandom;

public class StoreId
implements Serializable {
    private static final long serialVersionUID = 8331532643994776494L;
    public static final int storeIdLength = 16;
    public static final int stringLength = 36;
    public static final String MINVAL = "00000000-0000-0000-0000-000000000000";
    public static final String MAXVAL = "FFFFFFFF-FFFF-FFFF-FFFF-FFFFFFFFFFFF";
    public static final String[] HARDWIRED_RANGE = new String[]{"00000000-0000-0000-0000-000000000001", "00000000-0000-0000-0000-0000000000FF"};
    public static final String className;
    private String id;
    private static SecureRandom generator;
    private static char[] charMap;
    private static int[] byteStart;
    static /* synthetic */ Class class$com$adobe$idp$common$infomodel$StoreId;

    public String encodeToBase64() {
        byte[] byteId = this.toBytes();
        return Base64.encodeBytes(byteId);
    }

    private static String encodeBytes(byte[] id) {
        StringBuffer temp = new StringBuffer(MINVAL);
        int charPos = 0;
        for (int i = 0; i < 16; ++i) {
            byte next = id[i];
            int high_nibble = (next & 0xF0) >> 4;
            int low_nibble = next & 0xF;
            if (i == 4 || i == 6 || i == 8 || i == 10) {
                ++charPos;
            }
            temp.setCharAt(charPos, charMap[high_nibble]);
            temp.setCharAt(++charPos, charMap[low_nibble]);
            ++charPos;
        }
        return temp.toString();
    }

    public StoreId(byte[] guid) {
        this.id = StoreId.encodeBytes(guid);
    }

    public static void checkString(String id) throws IDPException {
        if (id.length() != 36) {
            throw new IDPLoggedException(className, 12550, "string length wrong", null);
        }
        for (int i = 0; i < 36; ++i) {
            if (i == 8 || i == 13 || i == 18 || i == 23) {
                if (id.charAt(i) == '-') continue;
                throw new IDPLoggedException(className, 12550, "missing punctuation character", null);
            }
            char next = id.charAt(i);
            if (Character.isDigit(next) || Character.isUpperCase(next) && next >= 'A' && next <= 'F') continue;
            throw new IDPLoggedException(className, 12550, "character not hex digit", null);
        }
    }

    public StoreId(String handle) throws IDPException {
        if (handle == null || handle.length() == 0) {
            this.id = StoreId.makeId();
        } else if ((handle = handle.trim()).length() == 36) {
            StoreId.checkString(handle);
            this.id = handle;
        } else if (handle.length() == 22 || handle.length() == 23) {
            if (handle.length() == 22) {
                handle = handle + "==";
            }
            try {
                byte[] bytes = Base64.decode(handle.getBytes());
                this.id = StoreId.encodeBytes(bytes);
            }
            catch (Exception e) {
                throw new IDPLoggedException(className, 12550, "some base64 decoding problem", e);
            }
        } else {
            StoreId.checkString(handle);
        }
    }

    private static String makeId() throws IDPException {
        String idString = null;
        do {
            byte[] ticket = null;
            try {
                ticket = CryptoUtil.grdb(16);
            }
            catch (Exception e) {
                throw new IDPLoggedException(className, 12297, null, e);
            }
            idString = StoreId.encodeBytes(ticket);
        } while (idString.compareTo(HARDWIRED_RANGE[0]) >= 0 && idString.compareTo(HARDWIRED_RANGE[1]) <= 0);
        return idString;
    }

    public StoreId() throws IDPException {
        this.id = StoreId.makeId();
    }

    public String toString() {
        return this.id;
    }

    private static int mapCharToInt(char c) {
        if (Character.isDigit(c)) {
            return Character.getNumericValue(c) - Character.getNumericValue('0');
        }
        return Character.getNumericValue(c) - Character.getNumericValue('A') + 10;
    }

    public byte[] toBytes() {
        byte[] byteId = new byte[16];
        for (int i = 0; i < 16; ++i) {
            char highChar = this.id.charAt(byteStart[i]);
            char lowChar = this.id.charAt(byteStart[i] + 1);
            int lowNibble = StoreId.mapCharToInt(lowChar);
            int highNibble = StoreId.mapCharToInt(highChar);
            byteId[i] = (byte)((highNibble << 4) + lowNibble);
        }
        return byteId;
    }

    public boolean equals(Object other) {
        if (other == null) {
            return false;
        }
        if (!(other instanceof StoreId)) {
            return false;
        }
        StoreId otherStoreId = (StoreId)other;
        return this.id.equals(otherStoreId.id);
    }

    public int hashCode() {
        return this.id.hashCode();
    }

    static {
        Class<?> clazz = class$com$adobe$idp$common$infomodel$StoreId;
        if (clazz == null) {
            clazz = class$com$adobe$idp$common$infomodel$StoreId = new StoreId[0].getClass().getComponentType();
        }
        className = clazz.getName();
        generator = null;
        charMap = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F'};
        byteStart = new int[]{0, 2, 4, 6, 9, 11, 14, 16, 19, 21, 24, 26, 28, 30, 32, 34};
    }
}

