/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.idp.common.errors.exception;

import java.io.ObjectStreamException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class IDPException
extends Exception {
    private static final long serialVersionUID = -4801508085951021412L;
    private String exceptionMessages = null;
    protected int errCode;
    protected String message;
    protected List chainedExceptions;
    protected String initialClass;

    private String getExceptionMessages(List exps) {
        if (exps == null) {
            return "";
        }
        Iterator i = exps.iterator();
        StringBuffer lm = new StringBuffer();
        while (i.hasNext()) {
            Exception exp = (Exception)i.next();
            if (exp == null) continue;
            if (exp instanceof IDPException) {
                lm.append(exp.toString());
                continue;
            }
            lm.append(" chainedException:").append(exp.toString());
            lm.append("chainedExceptionMessage:").append(exp.getMessage());
            StringWriter sw = new StringWriter();
            exp.printStackTrace(new PrintWriter(sw));
            lm.append(" chainedException trace:" + sw.getBuffer().toString());
        }
        return lm.toString();
    }

    public String toString() {
        StringBuffer lm = new StringBuffer();
        lm.append("| [").append(this.initialClass).append("]");
        lm.append(" errorCode:").append(this.errCode);
        lm.append(" errorCodeHEX:0x").append(Integer.toHexString(this.errCode));
        lm.append(" message:").append(this.message);
        if (this.chainedExceptions != null) {
            lm.append(this.getExceptionMessages(this.chainedExceptions));
        } else if (this.exceptionMessages != null) {
            lm.append(this.exceptionMessages);
        }
        return lm.toString();
    }

    protected IDPException() {
    }

    private Object writeReplace() throws ObjectStreamException {
        this.chainedExceptions = null;
        return this;
    }

    public IDPException(String this_classname, int errorCode, String details) {
        this.constructor(this_classname, errorCode, details, null);
    }

    public IDPException(String this_classname, int errorCode, String details, Exception e) {
        ArrayList<Exception> exps = new ArrayList<Exception>();
        exps.add(e);
        this.constructor(this_classname, errorCode, details, exps);
    }

    public IDPException(String this_classname, int errorCode, String details, List exps) {
        this.constructor(this_classname, errorCode, details, exps);
    }

    protected void constructor(String this_classname, int errorCode, String details, List exps) {
        this.errCode = errorCode;
        this.message = details;
        this.chainedExceptions = exps;
        this.initialClass = this_classname;
        this.exceptionMessages = this.getExceptionMessages(this.chainedExceptions);
    }

    public int getErrCode() {
        return this.errCode;
    }

    public String getMessage() {
        return this.message;
    }
}

