/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.idp;

import com.adobe.idp.ContextData;
import com.adobe.idp.ContextDataExtenstionTest;
import com.adobe.idp.SerializedWeakMap;
import com.adobe.idp.um.api.infomodel.AuthResult;
import com.adobe.idp.um.api.infomodel.User;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InvalidObjectException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.ObjectStreamException;
import java.io.Serializable;
import java.io.StreamCorruptedException;
import java.util.Arrays;
import java.util.Date;

public final class Context
implements Serializable {
    private static final long serialVersionUID = -1891334033885149031L;
    private transient ContextData data = new ContextData();
    private transient User user = null;
    private transient Date expiration = null;
    private byte[] propagate = null;
    private transient ContextDataExtenstionTest allData = null;
    private byte[] propagateData = null;
    protected boolean isLocalOnly = false;
    private static SerializedWeakMap cache = new SerializedWeakMap();

    public static Context create(byte[] buf) {
        try {
            return (Context)Context.deserializeObjectFromBytes(buf);
        }
        catch (IOException e) {
            IllegalStateException e2 = new IllegalStateException();
            e2.initCause(e);
            throw e2;
        }
        catch (ClassNotFoundException e) {
            IllegalStateException e2 = new IllegalStateException();
            e2.initCause(e);
            throw e2;
        }
    }

    public byte[] toByteArray() {
        try {
            return Context.serializeObjectToBytes(this);
        }
        catch (IOException e) {
            IllegalStateException e2 = new IllegalStateException();
            e2.initCause(e);
            throw e2;
        }
    }

    public void initPrincipal(AuthResult authResult) {
        if (this.propagate != null || this.user != null) {
            throw new IllegalStateException("principal already set");
        }
        this.user = authResult.getAuthenticatedUser();
        this.data.principalAssertion = authResult.getAssertion();
        this.expiration = authResult.getExpirationHint();
    }

    public boolean isComplete() {
        if (this.user == null) {
            return false;
        }
        return !this.user.getGroupMemberships().isEmpty();
    }

    public User getAuthenticatedUser() {
        return this.user;
    }

    public Date getExpirationHint() {
        return this.expiration;
    }

    public String getUserAssertion() {
        return this.data.principalAssertion;
    }

    public void initRequestId(String requestId) {
        if (this.propagate != null || this.data.requestId != null) {
            throw new IllegalStateException("request ID already set");
        }
        this.data.requestId = requestId;
    }

    public String getRequestId() {
        return this.data.requestId;
    }

    public String toString() {
        StringBuffer buf = new StringBuffer();
        buf.append("authenticatedUser=");
        buf.append(this.getAuthenticatedUser());
        buf.append(", requestId=");
        buf.append(this.getRequestId());
        return buf.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Object writeReplace() throws ObjectStreamException {
        try {
            if (this.isLocalOnly) {
                this.isLocalOnly = false;
            }
            if (this.allData == null) {
                this.allData = new ContextDataExtenstionTest();
                this.allData.user = this.user;
                this.allData.expiration = this.expiration;
                this.propagateData = Context.serializeObjectToBytes(this.allData);
            }
            if (this.propagate == null) {
                this.propagate = Context.serializeObjectToBytes(this.data);
                SerializedWeakMap serializedWeakMap = cache;
                synchronized (serializedWeakMap) {
                    cache.put(new ByteArrayKey(this.propagate), this);
                }
            }
            return this;
        }
        catch (IOException e) {
            InvalidObjectException e2 = new InvalidObjectException("writeReplace() : serialization error for Context...");
            e2.initCause(e);
            throw e2;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Object readResolve() throws ObjectStreamException {
        try {
            if (this.isLocalOnly) {
                throw new IOException("Deserialized a Local Context for principal : Canonical name : " + this.user.getCanonicalName() + " Domain name : " + this.user.getDomainName() + ". This is invalid as Context serialisation would have made it non-local...");
            }
            ByteArrayKey key = new ByteArrayKey(this.propagate);
            SerializedWeakMap serializedWeakMap = cache;
            synchronized (serializedWeakMap) {
                Context cached = (Context)cache.get(key);
                if (cached != null) {
                    return cached;
                }
                this.data = (ContextData)Context.deserializeObjectFromBytes(this.propagate);
                this.allData = (ContextDataExtenstionTest)Context.deserializeObjectFromBytes(this.propagateData);
                this.user = this.allData.user;
                this.expiration = this.allData.expiration;
                cache.put(key, this);
            }
            return this;
        }
        catch (ObjectStreamException e) {
            throw e;
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            StreamCorruptedException e2 = new StreamCorruptedException();
            e2.initCause(e);
            throw e2;
        }
    }

    private static byte[] serializeObjectToBytes(Object obj) throws IOException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        ObjectOutputStream oos = new ObjectOutputStream(baos);
        oos.writeObject(obj);
        oos.close();
        return baos.toByteArray();
    }

    private static Object deserializeObjectFromBytes(byte[] buf) throws IOException, ClassNotFoundException {
        ByteArrayInputStream bais = new ByteArrayInputStream(buf);
        ObjectInputStream ois = new ObjectInputStream(bais);
        Object val = ois.readObject();
        ois.close();
        return val;
    }

    private final class ByteArrayKey {
        private final int hash;
        private final byte[] val;

        ByteArrayKey(byte[] val) {
            this.val = val;
            int h = 0;
            for (int i = 0; i < val.length; ++i) {
                h = 31 * h + val[i];
            }
            this.hash = h;
        }

        public final int hashCode() {
            return this.hash;
        }

        public final boolean equals(Object obj) {
            if (!(obj instanceof ByteArrayKey)) {
                return false;
            }
            ByteArrayKey k2 = (ByteArrayKey)obj;
            if (k2.hash != this.hash) {
                return false;
            }
            return Arrays.equals(k2.val, this.val);
        }
    }
}

