/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.livecycle.convertpdfservice.logging;

import com.adobe.logging.AdobeLogger;
import com.adobe.logging.Msg0;
import com.adobe.logging.Msg1;
import com.adobe.logging.Msg2;
import com.adobe.logging.Msg3;
import java.util.ResourceBundle;
import java.util.logging.Level;

public class ConvertPdfLogger {
    public static String CONVERTPDF_LOGGING_BUNDLE = "com.adobe.livecycle.convertpdfservice.logging.CNP";

    public static String getResourceString(ResourceBundle bundle, String resourceID) {
        if (bundle == null) {
            bundle = ResourceBundle.getBundle(CONVERTPDF_LOGGING_BUNDLE);
        }
        return (String)bundle.getObject(resourceID);
    }

    public static String getResourceString(String resourceID) {
        return ConvertPdfLogger.getResourceString(null, resourceID);
    }

    public static String getResourceString(ResourceBundle bundle, String resourceID, String[] args) {
        if (bundle == null) {
            bundle = ResourceBundle.getBundle(CONVERTPDF_LOGGING_BUNDLE);
        }
        String res = (String)bundle.getObject(resourceID);
        if (args != null) {
            for (int i = 0; i < args.length; ++i) {
                String tok = "{" + i + "}";
                int j = res.indexOf(tok);
                if (j < 0) continue;
                res = res.substring(0, j) + args[i] + res.substring(j + tok.length());
            }
        }
        return res;
    }

    public static String getResourceString(String resourceID, String[] args) {
        return ConvertPdfLogger.getResourceString(null, resourceID, args);
    }

    public static void logMessage(Class oClass, Level level, ResourceBundle bundle, String resourceID) {
        ConvertPdfLogger.logMessage(oClass, level, bundle, resourceID, null);
    }

    public static void logMessage(Class oClass, Level level, String resourceID) {
        ConvertPdfLogger.logMessage(oClass, level, null, resourceID);
    }

    public static void logMessage(Class oClass, Level level, String resourceID, String[] args) {
        ConvertPdfLogger.logMessage(oClass, level, null, resourceID, args);
    }

    public static void logMessage(Class oClass, Level level, ResourceBundle bundle, String resourceID, String[] args) {
        try {
            String sLogString = ConvertPdfLogger.getResourceString(bundle, resourceID);
            if (sLogString == null || sLogString.length() == 0) {
                sLogString = "** this msg not found in resources **";
            }
            AdobeLogger logger = AdobeLogger.getAdobeLogger((Class)oClass);
            if (args == null) {
                logger.log(new Msg0(resourceID, level, sLogString));
            } else if (args.length == 1) {
                logger.log(new Msg1(resourceID, level, sLogString), (Object)args[0]);
            } else if (args.length == 2) {
                logger.log(new Msg2(resourceID, level, sLogString), (Object)args[0], (Object)args[1]);
            } else if (args.length >= 3) {
                logger.log(new Msg3(resourceID, level, sLogString), (Object)args[0], (Object)args[1], (Object)args[2]);
            }
        }
        catch (Exception e) {
            String err = e.getMessage();
            if (err == null) {
                err = e.getClass().getName();
            }
            System.out.print("[Print] logMessage error: " + e + " args passed: ");
            for (int i = 0; i < args.length; ++i) {
                System.out.print(args[i]);
            }
            System.out.println("");
        }
    }

    public static String dumpLog(Object caller, Exception e, Level level) {
        StringBuffer err = new StringBuffer();
        if (e.getMessage() != null) {
            err.append(e.getMessage());
        } else {
            err.append(e.getClass().getName());
        }
        if (e.getCause() != null) {
            err.append(", cause: ");
            String msg = e.getCause().getMessage();
            if (msg == null) {
                msg = e.getCause().getClass().getName();
            }
            err.append(msg);
        }
        AdobeLogger lgr = AdobeLogger.getAdobeLogger(caller.getClass());
        lgr.log(level, err.toString());
        return err.toString();
    }

    public static String dumpLog(Object caller, Exception e) {
        return ConvertPdfLogger.dumpLog(caller, e, Level.SEVERE);
    }

    public static void dumpLog(Object caller, String msg, Level level) {
        AdobeLogger lgr = AdobeLogger.getAdobeLogger(caller.getClass());
        lgr.log(level, msg);
    }
}

