/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.livecycle.convertpdfservice.client;

import com.adobe.livecycle.convertpdfservice.client.enumeration.Color;
import com.adobe.livecycle.convertpdfservice.client.enumeration.FontInclusion;
import com.adobe.livecycle.convertpdfservice.client.enumeration.LineWeight;
import com.adobe.livecycle.convertpdfservice.client.enumeration.PSLevel;
import com.adobe.livecycle.convertpdfservice.client.enumeration.PageSize;
import com.adobe.livecycle.convertpdfservice.client.enumeration.Style;
import com.adobe.livecycle.convertpdfservice.exception.ConvertPdfException;
import java.io.Serializable;
import java.util.HashMap;
import java.util.StringTokenizer;
import java.util.logging.Level;

public final class ToPSOptionsSpec
implements Serializable {
    private static final long serialVersionUID = 3792024384757843520L;
    private PSLevel psLevel = PSLevel.LEVEL_2;
    private boolean allowBinaryContent = false;
    private FontInclusion fontInclusion = FontInclusion.embeddedFonts;
    private boolean includeComments = false;
    private boolean convertTrueTypeToType1 = true;
    private Color color = Color.composite;
    private boolean useMaxJPEGImageResolution = true;
    private boolean trimMarks = false;
    private boolean bleedMarks = false;
    private boolean registrationMarks = false;
    private boolean colorBars = false;
    private boolean pageInformation = false;
    private LineWeight lineWeight = LineWeight.point25;
    private boolean emitPSFormObjects = false;
    private boolean emitCIDFontType2 = false;
    private boolean shrinkToFit = false;
    private boolean expandToFit = false;
    private boolean rotateAndCenter = false;
    private String pageSizeWidth;
    private String pageSizeHeight;
    private boolean reverse = false;
    private Style style = Style.Default;
    private PageSize pageSize = PageSize.DetermineAutomatically;
    private String pageRange;
    private int resolution = 300;
    private static HashMap<String, Integer> propertyMap = new HashMap();

    public boolean isAllowBinaryContent() {
        return this.allowBinaryContent;
    }

    public void setAllowBinaryContent(boolean allowBinaryContent) {
        this.allowBinaryContent = allowBinaryContent;
    }

    public boolean isBleedMarks() {
        return this.bleedMarks;
    }

    public void setBleedMarks(boolean bleedMarks) {
        this.bleedMarks = bleedMarks;
    }

    public Color getColor() {
        return this.color;
    }

    public void setColor(Color color) {
        this.color = color;
    }

    public boolean isColorBars() {
        return this.colorBars;
    }

    public void setColorBars(boolean colorBars) {
        this.colorBars = colorBars;
    }

    public boolean isConvertTrueTypeToType1() {
        return this.convertTrueTypeToType1;
    }

    public void setConvertTrueTypeToType1(boolean convertTrueTypeToType1) {
        this.convertTrueTypeToType1 = convertTrueTypeToType1;
    }

    public boolean isEmitCIDFontType2() {
        return this.emitCIDFontType2;
    }

    public void setEmitCIDFontType2(boolean emitCIDFontType2) {
        this.emitCIDFontType2 = emitCIDFontType2;
    }

    public boolean isEmitPSFormObjects() {
        return this.emitPSFormObjects;
    }

    public void setEmitPSFormObjects(boolean emitPSFormObjects) {
        this.emitPSFormObjects = emitPSFormObjects;
    }

    public boolean isExpandToFit() {
        return this.expandToFit;
    }

    public void setExpandToFit(boolean expandToFit) {
        this.expandToFit = expandToFit;
    }

    public FontInclusion getFontInclusion() {
        return this.fontInclusion;
    }

    public void setFontInclusion(FontInclusion fontInclusion) {
        this.fontInclusion = fontInclusion;
    }

    public boolean isIncludeComments() {
        return this.includeComments;
    }

    public void setIncludeComments(boolean includeComments) {
        this.includeComments = includeComments;
    }

    public LineWeight getLineWeight() {
        return this.lineWeight;
    }

    public void setLineWeight(LineWeight lineWeight) {
        this.lineWeight = lineWeight;
    }

    public boolean isPageInformation() {
        return this.pageInformation;
    }

    public void setPageInformation(boolean pageInformation) {
        this.pageInformation = pageInformation;
    }

    public String getPageSizeHeight() {
        return this.pageSizeHeight;
    }

    public void setPageSizeHeight(String pageSizeHeight) {
        this.pageSizeHeight = pageSizeHeight;
    }

    public String getPageSizeWidth() {
        return this.pageSizeWidth;
    }

    public void setPageSizeWidth(String pageSizeWidth) {
        this.pageSizeWidth = pageSizeWidth;
    }

    public PSLevel getPsLevel() {
        return this.psLevel;
    }

    public void setPsLevel(PSLevel psLevel) {
        this.psLevel = psLevel;
    }

    public boolean isRegistrationMarks() {
        return this.registrationMarks;
    }

    public void setRegistrationMarks(boolean registrationMarks) {
        this.registrationMarks = registrationMarks;
    }

    public boolean isReverse() {
        return this.reverse;
    }

    public void setReverse(boolean reverse) {
        this.reverse = reverse;
    }

    public boolean isRotateAndCenter() {
        return this.rotateAndCenter;
    }

    public void setRotateAndCenter(boolean rotateAndCenter) {
        this.rotateAndCenter = rotateAndCenter;
    }

    public boolean isShrinkToFit() {
        return this.shrinkToFit;
    }

    public void setShrinkToFit(boolean shrinkToFit) {
        this.shrinkToFit = shrinkToFit;
    }

    public boolean isTrimMarks() {
        return this.trimMarks;
    }

    public void setTrimMarks(boolean trimMarks) {
        this.trimMarks = trimMarks;
    }

    public boolean isUseMaxJPEGImageResolution() {
        return this.useMaxJPEGImageResolution;
    }

    public void setUseMaxJPEGImageResolution(boolean useMaxJPEGImageResolution) {
        this.useMaxJPEGImageResolution = useMaxJPEGImageResolution;
    }

    public Style getStyle() {
        return this.style;
    }

    public void setStyle(Style style) {
        this.style = style;
    }

    public PageSize getPageSize() {
        return this.pageSize;
    }

    public void setPageSize(PageSize pageSize) {
        if (pageSize == null) {
            pageSize = PageSize.DetermineAutomatically;
        }
        this.pageSize = pageSize;
    }

    public String getPageRange() {
        return this.pageRange;
    }

    public void setPageRange(String pageRange) {
        this.pageRange = pageRange;
    }

    public int getResolution() {
        return this.resolution;
    }

    public void setResolution(int resolution) {
        this.resolution = resolution;
    }

    public String getOptions() {
        StringBuffer optStr = new StringBuffer();
        for (String key : propertyMap.keySet()) {
            String val = this.getOptionsBean(key);
            if (val == null || val.trim().length() <= 0) continue;
            optStr.append(key).append("=").append(val).append("&");
        }
        return optStr.substring(0, optStr.length() - 1);
    }

    public String getOptionsBean(String key) {
        String paramVal = "";
        int propId = this.lookupProperty(key);
        switch (propId) {
            case 1: {
                if (this.getPsLevel() == null) break;
                paramVal = Integer.toString(this.getPsLevel().getPsLevel());
                break;
            }
            case 2: {
                paramVal = Boolean.toString(this.isAllowBinaryContent());
                break;
            }
            case 3: {
                if (this.getFontInclusion() == null) break;
                paramVal = this.getFontInclusion().name();
                break;
            }
            case 4: {
                paramVal = Boolean.toString(this.isIncludeComments());
                break;
            }
            case 5: {
                paramVal = Boolean.toString(this.isConvertTrueTypeToType1());
                break;
            }
            case 6: {
                if (this.getColor() == null) break;
                paramVal = this.getColor().name();
                break;
            }
            case 7: {
                paramVal = Boolean.toString(this.isUseMaxJPEGImageResolution());
                break;
            }
            case 8: {
                paramVal = Boolean.toString(this.isTrimMarks());
                break;
            }
            case 9: {
                paramVal = Boolean.toString(this.isBleedMarks());
                break;
            }
            case 10: {
                paramVal = Boolean.toString(this.isRegistrationMarks());
                break;
            }
            case 11: {
                paramVal = Boolean.toString(this.isColorBars());
                break;
            }
            case 12: {
                paramVal = Boolean.toString(this.isPageInformation());
                break;
            }
            case 13: {
                if (this.getLineWeight() == null) break;
                paramVal = this.getLineWeight().getLineWeight();
                break;
            }
            case 14: {
                paramVal = Boolean.toString(this.isEmitPSFormObjects());
                break;
            }
            case 15: {
                paramVal = Boolean.toString(this.isEmitCIDFontType2());
                break;
            }
            case 16: {
                paramVal = Boolean.toString(this.isShrinkToFit());
                break;
            }
            case 17: {
                paramVal = Boolean.toString(this.isExpandToFit());
                break;
            }
            case 18: {
                paramVal = Boolean.toString(this.isRotateAndCenter());
                break;
            }
            case 19: {
                paramVal = this.getPageSizeWidth();
                break;
            }
            case 20: {
                paramVal = this.getPageSizeHeight();
                break;
            }
            case 21: {
                paramVal = Boolean.toString(this.isReverse());
                break;
            }
            case 22: {
                if (this.getStyle() == null) break;
                paramVal = this.getStyle().name();
                break;
            }
            case 23: {
                if (this.getPageSize() == null) break;
                paramVal = this.getPageSize().name();
                break;
            }
            case 24: {
                if (this.getPageRange() == null) break;
                paramVal = this.getPageRange().trim();
                break;
            }
            case 25: {
                paramVal = Integer.toString(this.getResolution());
            }
        }
        return paramVal;
    }

    public void updateOptionsBean(String options) throws ConvertPdfException {
        if (options == null || options.trim().equals("") || options.indexOf("=") == -1) {
            return;
        }
        StringTokenizer inToks = new StringTokenizer(options, "&");
        while (inToks.hasMoreTokens()) {
            String tok = inToks.nextToken();
            int tokEqual = tok.indexOf("=");
            if (tokEqual < 0) continue;
            this.updateOptionsBean(tok.substring(0, tokEqual), tok.substring(tokEqual + 1));
        }
    }

    public void updateOptionsBean(String key, String value) throws ConvertPdfException {
        if (value != null && value.trim().length() == 0) {
            value = null;
        }
        int propId = this.lookupProperty(key);
        try {
            switch (propId) {
                case 1: {
                    if (value == null) {
                        this.setPsLevel(null);
                        break;
                    }
                    this.setPsLevel(this.convertStringToPSLevel(value));
                    break;
                }
                case 2: {
                    this.setAllowBinaryContent(this.convertToBoolean(value));
                    break;
                }
                case 3: {
                    if (value == null) {
                        this.setFontInclusion(null);
                        break;
                    }
                    this.setFontInclusion(this.convertStringToFontInclusion(value));
                    break;
                }
                case 4: {
                    this.setIncludeComments(this.convertToBoolean(value));
                    break;
                }
                case 5: {
                    this.setConvertTrueTypeToType1(this.convertToBoolean(value));
                    break;
                }
                case 6: {
                    if (value == null) {
                        this.setColor(null);
                        break;
                    }
                    this.setColor(this.convertStringToColor(value));
                    break;
                }
                case 7: {
                    this.setUseMaxJPEGImageResolution(Boolean.valueOf(value));
                    break;
                }
                case 8: {
                    this.setTrimMarks(this.convertToBoolean(value));
                    break;
                }
                case 9: {
                    this.setBleedMarks(this.convertToBoolean(value));
                    break;
                }
                case 10: {
                    this.setRegistrationMarks(this.convertToBoolean(value));
                    break;
                }
                case 11: {
                    this.setColorBars(this.convertToBoolean(value));
                    break;
                }
                case 12: {
                    this.setPageInformation(this.convertToBoolean(value));
                    break;
                }
                case 13: {
                    if (value == null) {
                        this.setLineWeight(null);
                        break;
                    }
                    this.setLineWeight(this.convertStringToLineWeight(value));
                    break;
                }
                case 14: {
                    this.setEmitPSFormObjects(this.convertToBoolean(value));
                    break;
                }
                case 15: {
                    this.setEmitCIDFontType2(this.convertToBoolean(value));
                    break;
                }
                case 16: {
                    this.setShrinkToFit(this.convertToBoolean(value));
                    break;
                }
                case 17: {
                    this.setExpandToFit(this.convertToBoolean(value));
                    break;
                }
                case 18: {
                    this.setRotateAndCenter(this.convertToBoolean(value));
                    break;
                }
                case 19: {
                    this.setPageSizeWidth(value);
                    break;
                }
                case 20: {
                    this.setPageSizeHeight(value);
                    break;
                }
                case 21: {
                    this.setReverse(this.convertToBoolean(value));
                    break;
                }
                case 22: {
                    if (value == null) {
                        this.setStyle(null);
                        break;
                    }
                    this.setStyle(this.convertStringToStyle(value));
                    break;
                }
                case 23: {
                    if (value == null) {
                        this.setPageSize(null);
                        break;
                    }
                    this.setPageSize(this.convertStringToPageSize(value));
                    break;
                }
                case 24: {
                    this.setPageRange(value);
                    break;
                }
                case 25: {
                    if (value != null && !value.trim().equals("")) {
                        this.setResolution(Integer.valueOf(value));
                        break;
                    }
                    this.setResolution(300);
                }
            }
        }
        catch (Exception e) {
            throw new ConvertPdfException("ALC-CNP-001-002", new String[]{key, value}, Level.SEVERE, true);
        }
    }

    private PageSize convertStringToPageSize(String value) {
        for (PageSize pageSize : PageSize.values()) {
            if (!pageSize.name().equalsIgnoreCase(value)) continue;
            return pageSize;
        }
        return null;
    }

    private LineWeight convertStringToLineWeight(String value) {
        for (LineWeight lineWeight : LineWeight.values()) {
            if (!lineWeight.getLineWeight().equalsIgnoreCase(value)) continue;
            return lineWeight;
        }
        return null;
    }

    private Color convertStringToColor(String value) {
        for (Color color : Color.values()) {
            if (!color.name().equalsIgnoreCase(value)) continue;
            return color;
        }
        return null;
    }

    private FontInclusion convertStringToFontInclusion(String value) {
        for (FontInclusion fontInclusion : FontInclusion.values()) {
            if (!fontInclusion.name().equalsIgnoreCase(value)) continue;
            return fontInclusion;
        }
        return null;
    }

    private PSLevel convertStringToPSLevel(String value) {
        for (PSLevel psLevel : PSLevel.values()) {
            if (!Integer.toString(psLevel.getPsLevel()).equalsIgnoreCase(value)) continue;
            return psLevel;
        }
        return null;
    }

    private Style convertStringToStyle(String value) {
        for (Style style : Style.values()) {
            if (!style.name().equalsIgnoreCase(value)) continue;
            return style;
        }
        return null;
    }

    private int lookupProperty(String key) {
        int propId = 0;
        if (key != null && !key.trim().equals("") && propertyMap.containsKey(key)) {
            propId = propertyMap.get(key);
        }
        return propId;
    }

    private boolean convertToBoolean(String str) {
        if (str == null) {
            throw new IllegalArgumentException();
        }
        if ((str = str.trim()).equals("0") || str.equals("false")) {
            return false;
        }
        if (str.equals("1") || str.equals("true")) {
            return true;
        }
        throw new IllegalArgumentException();
    }

    public String toString() {
        return this.getOptions();
    }

    static {
        propertyMap.put("PSLevel", new Integer(1));
        propertyMap.put("AllowBinaryContent", new Integer(2));
        propertyMap.put("FontInclusion", new Integer(3));
        propertyMap.put("IncludeComments", new Integer(4));
        propertyMap.put("ConvertTrueTypeToType1", new Integer(5));
        propertyMap.put("Color", new Integer(6));
        propertyMap.put("UseMaxJPEGImageResolution", new Integer(7));
        propertyMap.put("TrimMarks", new Integer(8));
        propertyMap.put("BleedMarks", new Integer(9));
        propertyMap.put("RegistrationMarks", new Integer(10));
        propertyMap.put("ColorBars", new Integer(11));
        propertyMap.put("PageInformation", new Integer(12));
        propertyMap.put("LineWeight", new Integer(13));
        propertyMap.put("EmitPSFormObjects", new Integer(14));
        propertyMap.put("EmitCIDFontType2", new Integer(15));
        propertyMap.put("ShrinkToFit", new Integer(16));
        propertyMap.put("ExpandToFit", new Integer(17));
        propertyMap.put("RotateAndCenter", new Integer(18));
        propertyMap.put("PageSizeWidth", new Integer(19));
        propertyMap.put("PageSizeHeight", new Integer(20));
        propertyMap.put("Reverse", new Integer(21));
        propertyMap.put("Style", new Integer(22));
        propertyMap.put("PageSize", new Integer(23));
        propertyMap.put("PageRange", new Integer(24));
        propertyMap.put("Resolution", new Integer(25));
    }
}

