/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.livecycle.convertpdfservice.client;

import com.adobe.livecycle.SinceLC;
import com.adobe.livecycle.convertpdfservice.client.ToImageOptionsEnum;
import com.adobe.livecycle.convertpdfservice.client.enumeration.CMYKPolicy;
import com.adobe.livecycle.convertpdfservice.client.enumeration.ColorCompression;
import com.adobe.livecycle.convertpdfservice.client.enumeration.ColorSpace;
import com.adobe.livecycle.convertpdfservice.client.enumeration.GrayScaleCompression;
import com.adobe.livecycle.convertpdfservice.client.enumeration.GrayScalePolicy;
import com.adobe.livecycle.convertpdfservice.client.enumeration.ImageConvertFormat;
import com.adobe.livecycle.convertpdfservice.client.enumeration.Interlace;
import com.adobe.livecycle.convertpdfservice.client.enumeration.JPEGFormat;
import com.adobe.livecycle.convertpdfservice.client.enumeration.MonochromeCompression;
import com.adobe.livecycle.convertpdfservice.client.enumeration.PNGFilter;
import com.adobe.livecycle.convertpdfservice.client.enumeration.RGBPolicy;
import com.adobe.livecycle.convertpdfservice.exception.ConvertPdfException;
import java.io.Serializable;
import java.util.StringTokenizer;
import java.util.logging.Level;

public class ToImageOptionsSpec
implements Serializable {
    private static final long serialVersionUID = -7013603525632101343L;
    protected ImageConvertFormat imageConvertFormat;
    protected GrayScaleCompression grayScaleCompression;
    protected ColorCompression colorCompression;
    protected JPEGFormat format = JPEGFormat.BaselineStandard;
    protected RGBPolicy rgbPolicy = RGBPolicy.EmbedProfile;
    protected CMYKPolicy cmykPolicy = CMYKPolicy.Off;
    protected GrayScalePolicy grayScalePolicy = GrayScalePolicy.Off;
    protected ColorSpace colorSpace = ColorSpace.DetermineAutomatically;
    protected String resolution;
    protected int tileSize = 256;
    protected int rowsPerStrip = -1;
    protected Interlace interlace = Interlace.None;
    protected PNGFilter filter = PNGFilter.Adaptive;
    protected MonochromeCompression monochrome = MonochromeCompression.CCITTG4;
    protected Boolean multiPageTiff = Boolean.TRUE;
    protected boolean includeComments = true;
    protected String imageSizeWidth = null;
    protected String imageSizeHeight = null;
    protected String pageRange = null;

    public ToImageOptionsSpec() {
    }

    public ToImageOptionsSpec(String sOptions) throws ConvertPdfException {
        this.updateOptionsSpec(sOptions);
    }

    public ImageConvertFormat getImageConvertFormat() {
        return this.imageConvertFormat;
    }

    public void setImageConvertFormat(ImageConvertFormat imageConvertFormat) {
        this.imageConvertFormat = imageConvertFormat;
    }

    public CMYKPolicy getCmykPolicy() {
        return this.cmykPolicy;
    }

    public void setCmykPolicy(CMYKPolicy cmykPolicy) {
        this.cmykPolicy = cmykPolicy;
    }

    public ColorCompression getColorCompression() {
        return this.colorCompression;
    }

    public void setColorCompression(ColorCompression colorCompression) {
        this.colorCompression = colorCompression;
    }

    public ColorSpace getColorSpace() {
        return this.colorSpace;
    }

    public void setColorSpace(ColorSpace colorSpace) {
        this.colorSpace = colorSpace;
    }

    public PNGFilter getFilter() {
        return this.filter;
    }

    public void setFilter(PNGFilter filter) {
        this.filter = filter;
    }

    public JPEGFormat getFormat() {
        return this.format;
    }

    public void setFormat(JPEGFormat format) {
        this.format = format;
    }

    public GrayScaleCompression getGrayScaleCompression() {
        return this.grayScaleCompression;
    }

    public void setGrayScaleCompression(GrayScaleCompression grayScaleCompression) {
        this.grayScaleCompression = grayScaleCompression;
    }

    public GrayScalePolicy getGrayScalePolicy() {
        return this.grayScalePolicy;
    }

    public void setGrayScalePolicy(GrayScalePolicy grayScalePolicy) {
        this.grayScalePolicy = grayScalePolicy;
    }

    public Interlace getInterlace() {
        return this.interlace;
    }

    public void setInterlace(Interlace interlace) {
        this.interlace = interlace;
    }

    public MonochromeCompression getMonochrome() {
        return this.monochrome;
    }

    public void setMonochrome(MonochromeCompression monochrome) {
        this.monochrome = monochrome;
    }

    public String getResolution() {
        return this.resolution;
    }

    public void setResolution(String resolution) {
        this.resolution = resolution;
    }

    public RGBPolicy getRgbPolicy() {
        return this.rgbPolicy;
    }

    public void setRgbPolicy(RGBPolicy rgbPolicy) {
        this.rgbPolicy = rgbPolicy;
    }

    public int getTileSize() {
        return this.tileSize;
    }

    public void setTileSize(int tileSize) {
        this.tileSize = tileSize;
    }

    public int getRowsPerStrip() {
        return this.rowsPerStrip;
    }

    public void setRowsPerStrip(int rowsPerStrip) {
        this.rowsPerStrip = rowsPerStrip;
    }

    @SinceLC(value="8.2.1")
    public Boolean getMultiPageTiff() {
        return this.multiPageTiff;
    }

    public void setMultiPageTiff(Boolean multiPageTiff) {
        this.multiPageTiff = multiPageTiff;
    }

    @SinceLC(value="8.2.1")
    public boolean isIncludeComments() {
        return this.includeComments;
    }

    public void setIncludeComments(boolean includeComments) {
        this.includeComments = includeComments;
    }

    @SinceLC(value="8.2.1")
    public String getImageSizeHeight() {
        return this.imageSizeHeight;
    }

    public void setImageSizeHeight(String imageSizeHeight) {
        this.imageSizeHeight = imageSizeHeight;
    }

    @SinceLC(value="8.2.1")
    public String getImageSizeWidth() {
        return this.imageSizeWidth;
    }

    public void setImageSizeWidth(String imageSizeWidth) {
        this.imageSizeWidth = imageSizeWidth;
    }

    @SinceLC(value="8.2.1")
    public String getPageRange() {
        return this.pageRange;
    }

    public void setPageRange(String pageRange) {
        this.pageRange = pageRange;
    }

    public void updateOptionsSpec(String options) throws ConvertPdfException {
        if (ToImageOptionsSpec.isEmptyOrNull(options) || options.indexOf("=") == -1) {
            return;
        }
        StringTokenizer inToks = new StringTokenizer(options, "&");
        while (inToks.hasMoreTokens()) {
            String tok = inToks.nextToken();
            int tokEqual = tok.indexOf("=");
            if (tokEqual < 0) continue;
            this.updateOptionsBean(tok.substring(0, tokEqual), tok.substring(tokEqual + 1));
        }
    }

    public void updateOptionsBean(String key, String value) throws ConvertPdfException {
        ToImageOptionsEnum optionsEnum = this.lookupPropertyInMap(key);
        if (optionsEnum == null) {
            return;
        }
        if (value != null && value.trim().length() == 0) {
            value = null;
        }
        if (ToImageOptionsEnum.TILE_SIZE.equals((Object)optionsEnum) || ToImageOptionsEnum.ROWS_PER_STRIP.equals((Object)optionsEnum)) {
            try {
                Integer.parseInt(value);
            }
            catch (NumberFormatException nfe) {
                throw new ConvertPdfException("ALC-CNP-001-002", new String[]{key, value}, Level.SEVERE, true);
            }
        }
        switch (optionsEnum) {
            case IMAGE_CONVERT_FORMAT: {
                this.setImageConvertFormat(this.getConvertFormatEnumConst(value));
                break;
            }
            case GRAY_SCALE_COMPRESSION: {
                this.setGrayScaleCompression(this.convertStringToGrayScaleCompression(value));
                break;
            }
            case COLOR_COMPRESSION: {
                this.setColorCompression(this.convertStringToColorCompression(value));
                break;
            }
            case FORMAT: {
                this.setFormat(this.convertStringToJPEGFormat(value));
                break;
            }
            case RGB_POLICY: {
                this.setRgbPolicy(this.convertStringToRGBPolicy(value));
                break;
            }
            case CMYK_POLICY: {
                this.setCmykPolicy(this.convertStringToCMYKPolicy(value));
                break;
            }
            case GRAY_SCALE_POLICY: {
                this.setGrayScalePolicy(this.convertStringToGrayScalePolicy(value));
                break;
            }
            case COLOR_SPACE: {
                this.setColorSpace(this.convertStringToColorSpace(value));
                break;
            }
            case RESOLUTION: {
                this.setResolution(value);
                break;
            }
            case ROWS_PER_STRIP: {
                this.setRowsPerStrip(Integer.parseInt(value));
                break;
            }
            case TILE_SIZE: {
                this.setTileSize(Integer.parseInt(value));
                break;
            }
            case INTERLACE: {
                this.setInterlace(this.convertStringToInterlace(value));
                break;
            }
            case FILTER: {
                this.setFilter(this.convertStringToPNGFilter(value));
                break;
            }
            case MONOCHROME: {
                this.setMonochrome(this.convertStringToMonochromeCompression(value));
                break;
            }
            case MULTIPAGE_TIFF: {
                try {
                    if (value != null) {
                        this.setMultiPageTiff(Boolean.valueOf(value.trim()));
                        break;
                    }
                    this.setMultiPageTiff(null);
                    break;
                }
                catch (Exception e) {
                    throw new ConvertPdfException("ALC-CNP-001-002", new String[]{key, value}, Level.SEVERE, true);
                }
            }
            case INCLUDE_COMMENTS: {
                try {
                    this.setIncludeComments(Boolean.valueOf(value));
                    break;
                }
                catch (Exception e) {
                    throw new ConvertPdfException("ALC-CNP-001-002", new String[]{key, value}, Level.SEVERE, true);
                }
            }
            case IMAGE_SIZE_WIDTH: {
                this.setImageSizeWidth(value);
                break;
            }
            case IMAGE_SIZE_HEIGHT: {
                this.setImageSizeHeight(value);
                break;
            }
            case PAGE_RANGE: {
                this.setPageRange(value);
                break;
            }
        }
    }

    public String toString() {
        return this.getOptions();
    }

    public String getOptions() {
        StringBuffer optStr = new StringBuffer();
        for (ToImageOptionsEnum optionsEnum : ToImageOptionsEnum.values()) {
            String key = optionsEnum.getPropertyName();
            String val = this.getProperty(key);
            if (val != null) {
                optStr.append(key).append("=").append(val).append("&");
                continue;
            }
            optStr.append(key).append("=").append("&");
        }
        int i = optStr.lastIndexOf("&");
        if (i != -1) {
            return optStr.substring(0, i);
        }
        return optStr.toString();
    }

    public void resetProperty(String key) {
        try {
            ToImageOptionsEnum optionsEnum = this.lookupPropertyInMap(key);
            if (optionsEnum == null) {
                return;
            }
            if (ToImageOptionsEnum.TILE_SIZE.equals((Object)optionsEnum)) {
                this.updateOptionsBean(key, "256");
            } else if (ToImageOptionsEnum.ROWS_PER_STRIP.equals((Object)optionsEnum)) {
                this.updateOptionsBean(key, "-1");
            } else {
                this.updateOptionsBean(key, "");
            }
        }
        catch (ConvertPdfException convertPdfException) {
            // empty catch block
        }
    }

    public String getProperty(String key) {
        String paramVal = "";
        ToImageOptionsEnum optionsEnum = this.lookupPropertyInMap(key);
        if (optionsEnum == null) {
            return "";
        }
        switch (optionsEnum) {
            case IMAGE_CONVERT_FORMAT: {
                if (this.getImageConvertFormat() == null) break;
                paramVal = this.getImageConvertFormat().getName();
                break;
            }
            case GRAY_SCALE_COMPRESSION: {
                if (this.getGrayScaleCompression() == null) break;
                paramVal = this.getGrayScaleCompression().getValue();
                break;
            }
            case COLOR_COMPRESSION: {
                if (this.getColorCompression() == null) break;
                paramVal = this.getColorCompression().getValue();
                break;
            }
            case FORMAT: {
                if (this.getFormat() == null) break;
                paramVal = this.getFormat().getValue();
                break;
            }
            case RGB_POLICY: {
                if (this.getRgbPolicy() == null) break;
                paramVal = this.getRgbPolicy().getValue();
                break;
            }
            case CMYK_POLICY: {
                if (this.getCmykPolicy() == null) break;
                paramVal = this.getCmykPolicy().getValue();
                break;
            }
            case GRAY_SCALE_POLICY: {
                if (this.getGrayScalePolicy() == null) break;
                paramVal = this.getGrayScalePolicy().getValue();
                break;
            }
            case COLOR_SPACE: {
                if (this.getColorSpace() == null) break;
                paramVal = this.getColorSpace().getValue();
                break;
            }
            case RESOLUTION: {
                paramVal = this.getResolution();
                break;
            }
            case ROWS_PER_STRIP: {
                paramVal = Integer.toString(this.getRowsPerStrip());
                break;
            }
            case TILE_SIZE: {
                paramVal = Integer.toString(this.getTileSize());
                break;
            }
            case INTERLACE: {
                if (this.getInterlace() == null) break;
                paramVal = this.getInterlace().getValue();
                break;
            }
            case FILTER: {
                if (this.getFilter() == null) break;
                paramVal = this.getFilter().getValue();
                break;
            }
            case MONOCHROME: {
                if (this.getMonochrome() == null) break;
                paramVal = this.getMonochrome().getValue();
                break;
            }
            case MULTIPAGE_TIFF: {
                if (this.getMultiPageTiff() == null) break;
                paramVal = this.getMultiPageTiff().toString();
                break;
            }
            case INCLUDE_COMMENTS: {
                paramVal = Boolean.toString(this.isIncludeComments());
                break;
            }
            case IMAGE_SIZE_WIDTH: {
                paramVal = this.getImageSizeWidth();
                break;
            }
            case IMAGE_SIZE_HEIGHT: {
                paramVal = this.getImageSizeHeight();
                break;
            }
            case PAGE_RANGE: {
                paramVal = this.getPageRange();
                break;
            }
            default: {
                paramVal = "";
            }
        }
        return paramVal;
    }

    private ImageConvertFormat getConvertFormatEnumConst(String convertFormatValue) {
        for (ImageConvertFormat convertEnum : ImageConvertFormat.values()) {
            if (!convertEnum.getName().equalsIgnoreCase(convertFormatValue)) continue;
            return convertEnum;
        }
        return null;
    }

    private GrayScaleCompression convertStringToGrayScaleCompression(String compressionValue) {
        for (GrayScaleCompression grayScaleCompression : GrayScaleCompression.values()) {
            if (!grayScaleCompression.getValue().equalsIgnoreCase(compressionValue)) continue;
            return grayScaleCompression;
        }
        return null;
    }

    private ColorCompression convertStringToColorCompression(String compressionValue) {
        for (ColorCompression colorCompression : ColorCompression.values()) {
            if (!colorCompression.getValue().equalsIgnoreCase(compressionValue)) continue;
            return colorCompression;
        }
        return null;
    }

    private JPEGFormat convertStringToJPEGFormat(String formatValue) {
        for (JPEGFormat jpegFormat : JPEGFormat.values()) {
            if (!jpegFormat.getValue().equalsIgnoreCase(formatValue)) continue;
            return jpegFormat;
        }
        return null;
    }

    private RGBPolicy convertStringToRGBPolicy(String policyValue) {
        for (RGBPolicy rgbPolicy : RGBPolicy.values()) {
            if (!rgbPolicy.getValue().equalsIgnoreCase(policyValue)) continue;
            return rgbPolicy;
        }
        return null;
    }

    private CMYKPolicy convertStringToCMYKPolicy(String policyValue) {
        for (CMYKPolicy cmykPolicy : CMYKPolicy.values()) {
            if (!cmykPolicy.getValue().equalsIgnoreCase(policyValue)) continue;
            return cmykPolicy;
        }
        return null;
    }

    private GrayScalePolicy convertStringToGrayScalePolicy(String policyValue) {
        for (GrayScalePolicy grayScalePolicy : GrayScalePolicy.values()) {
            if (!grayScalePolicy.getValue().equalsIgnoreCase(policyValue)) continue;
            return grayScalePolicy;
        }
        return null;
    }

    private ColorSpace convertStringToColorSpace(String colorSpaceValue) {
        for (ColorSpace colorSpace : ColorSpace.values()) {
            if (!colorSpace.getValue().equalsIgnoreCase(colorSpaceValue)) continue;
            return colorSpace;
        }
        return null;
    }

    private Interlace convertStringToInterlace(String interlaceValue) {
        for (Interlace interlace : Interlace.values()) {
            if (!interlace.getValue().equalsIgnoreCase(interlaceValue)) continue;
            return interlace;
        }
        return null;
    }

    private PNGFilter convertStringToPNGFilter(String pngFilterValue) {
        for (PNGFilter pngFilter : PNGFilter.values()) {
            if (!pngFilter.getValue().equalsIgnoreCase(pngFilterValue)) continue;
            return pngFilter;
        }
        return null;
    }

    private MonochromeCompression convertStringToMonochromeCompression(String compressionValue) {
        for (MonochromeCompression monochromeCompression : MonochromeCompression.values()) {
            if (!monochromeCompression.getValue().equalsIgnoreCase(compressionValue)) continue;
            return monochromeCompression;
        }
        return null;
    }

    private ToImageOptionsEnum lookupPropertyInMap(String key) {
        if (!ToImageOptionsSpec.isEmptyOrNull(key)) {
            for (ToImageOptionsEnum optionsEnum : ToImageOptionsEnum.values()) {
                if (!optionsEnum.getPropertyName().equalsIgnoreCase(key)) continue;
                return optionsEnum;
            }
        }
        return null;
    }

    private static boolean isEmptyOrNull(String val) {
        return val == null || val.trim().length() == 0;
    }
}

