/*
 * Decompiled with CFR 0.152.
 */
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.security.Key;
import java.security.KeyStore;
import java.security.cert.Certificate;

public class KeyImport {
    private String src = null;
    private String dst = null;
    private String srcAlias = null;
    private String srcStorePass = "changeit";
    private String srcKeyPass = "changeit";
    private String dstStorePass = "changeit";
    private String dstAlias = null;
    private String trustedCertEntry = null;
    private String dstKeyPass = "changeit";

    public KeyImport(String[] stringArray) {
        for (int i = 0; stringArray.length > i; ++i) {
            int n = stringArray[i].indexOf("=");
            if (n <= 0) {
                throw new RuntimeException("Illegal Argument" + stringArray[i]);
            }
            String string = stringArray[i].substring(n + 1);
            if (stringArray[i].startsWith("srcalias")) {
                this.srcAlias = string;
                continue;
            }
            if (stringArray[i].startsWith("srcstorepass")) {
                this.srcStorePass = string;
                continue;
            }
            if (stringArray[i].startsWith("srckeypass")) {
                this.srcKeyPass = string;
                continue;
            }
            if (stringArray[i].startsWith("dststorepass")) {
                this.dstStorePass = string;
                continue;
            }
            if (stringArray[i].startsWith("srcstore")) {
                this.src = string;
                continue;
            }
            if (stringArray[i].startsWith("dststore")) {
                this.dst = string;
                continue;
            }
            if (stringArray[i].startsWith("dstalias")) {
                this.dstAlias = string;
                continue;
            }
            if (stringArray[i].startsWith("trustedentry")) {
                this.trustedCertEntry = string;
                continue;
            }
            if (!stringArray[i].startsWith("dstkeypass")) continue;
            this.dstKeyPass = string;
        }
    }

    public void copyKey() throws Exception {
        KeyStore keyStore = KeyStore.getInstance("JKS");
        KeyStore keyStore2 = KeyStore.getInstance("JKS");
        keyStore.load(new FileInputStream(this.src), this.srcStorePass.toCharArray());
        keyStore2.load(new FileInputStream(this.dst), this.dstStorePass.toCharArray());
        Key key = keyStore.getKey(this.srcAlias, this.srcKeyPass.toCharArray());
        if (key == null || "true".equals(this.trustedCertEntry)) {
            keyStore2.setCertificateEntry(this.dstAlias, keyStore.getCertificate(this.srcAlias));
            System.out.println("Added Trusted Entry  :" + this.dstAlias);
        } else {
            Certificate certificate = keyStore.getCertificate(this.srcAlias);
            Certificate[] certificateArray = new Certificate[]{certificate};
            keyStore2.setKeyEntry(this.dstAlias, key, this.dstKeyPass.toCharArray(), certificateArray);
            System.out.println("Added Key Entry  :" + this.dstAlias);
        }
        keyStore2.store(new FileOutputStream(this.dst), this.dstStorePass.toCharArray());
    }

    public static void main(String[] stringArray) throws Exception {
        KeyImport keyImport = new KeyImport(stringArray);
        keyImport.copyKey();
    }
}

