/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.security;

import java.security.Principal;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import org.jboss.security.CallerIdentity;
import org.jboss.security.SimplePrincipal;

public class RunAsIdentity
extends CallerIdentity {
    private Set runAsRoles = new HashSet();
    private static final String ANOYMOUS_PRINCIPAL = "anonymous";

    public RunAsIdentity(String roleName, String principalName) {
        super(principalName != null ? principalName : ANOYMOUS_PRINCIPAL, null);
        if (roleName == null) {
            throw new IllegalArgumentException("The run-as identity must have at least one role");
        }
        this.runAsRoles.add(new SimplePrincipal(roleName));
    }

    public RunAsIdentity(String roleName, String principalName, Set extraRoleNames) {
        this(roleName, principalName);
        if (extraRoleNames != null) {
            Iterator it = extraRoleNames.iterator();
            while (it.hasNext()) {
                String extraRoleName = (String)it.next();
                this.runAsRoles.add(new SimplePrincipal(extraRoleName));
            }
        }
    }

    public Set getRunAsRoles() {
        return new HashSet(this.runAsRoles);
    }

    public boolean doesUserHaveRole(Principal role) {
        return this.runAsRoles.contains(role);
    }

    public boolean doesUserHaveRole(Set methodRoles) {
        Iterator it = methodRoles.iterator();
        while (it.hasNext()) {
            Principal role = (Principal)it.next();
            if (!this.doesUserHaveRole(role)) continue;
            return true;
        }
        return false;
    }

    public String toString() {
        return "[roles=" + this.runAsRoles + ",principal=" + this.getName() + "]";
    }
}

