/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.remoting.transport.multiplex;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InterruptedIOException;
import java.io.OutputStream;
import java.util.Iterator;
import org.jboss.logging.Logger;
import org.jboss.remoting.transport.multiplex.MultiplexingManager;
import org.jboss.remoting.transport.multiplex.SocketId;
import org.jboss.remoting.transport.multiplex.StoppableThread;

public class InputMultiplexor {
    protected static final Logger log = Logger.getLogger(class$org$jboss$remoting$transport$multiplex$InputMultiplexor == null ? (class$org$jboss$remoting$transport$multiplex$InputMultiplexor = InputMultiplexor.class$("org.jboss.remoting.transport.multiplex.InputMultiplexor")) : class$org$jboss$remoting$transport$multiplex$InputMultiplexor);
    static /* synthetic */ Class class$org$jboss$remoting$transport$multiplex$InputMultiplexor;
    static /* synthetic */ Class class$org$jboss$remoting$transport$multiplex$InputMultiplexor$InputThread;

    static InputThread getAnInputThread(MultiplexingManager manager, InputStream is, OutputStream os) {
        return new InputThread(manager, is, os);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    public static class InputThread
    extends StoppableThread {
        private static final Logger log = Logger.getLogger(class$org$jboss$remoting$transport$multiplex$InputMultiplexor$InputThread == null ? (class$org$jboss$remoting$transport$multiplex$InputMultiplexor$InputThread = InputMultiplexor.class$("org.jboss.remoting.transport.multiplex.InputMultiplexor$InputThread")) : class$org$jboss$remoting$transport$multiplex$InputMultiplexor$InputThread);
        private static final int READING_DATA = 0;
        private static final int SAW_MARKER = 1;
        private static final int READING_ID = 2;
        private InputStream is;
        private OutputStream currentOutputStream;
        private ByteArrayOutputStream bos;
        private MultiplexingManager manager;
        private int state;
        private boolean managerShuttingDown = false;
        private int markerCount = 0;
        private int dataInCount = 0;
        private boolean trace;

        public InputThread(MultiplexingManager manager, InputStream is, OutputStream os) {
            this.is = is;
            this.manager = manager;
            this.currentOutputStream = os;
            this.bos = new ByteArrayOutputStream();
            boolean state = false;
            this.trace = log.isTraceEnabled();
        }

        public synchronized void shutdown() {
            super.shutdown();
            this.interrupt();
            this.managerShuttingDown = true;
            this.notify();
        }

        protected void doInit() {
            log.info("input thread starting");
        }

        protected void doRun() {
            int b = 0;
            try {
                b = this.is.read();
                while (b >= 0 && this.isRunning()) {
                    if (b != 255) {
                        if (this.markerCount > 0) {
                            log.debug("read " + this.markerCount + " MARKER's");
                        }
                        this.markerCount = 0;
                        log.debug("reading int: " + b);
                    }
                    switch (this.state) {
                        case 0: {
                            if (b == 255) {
                                this.state = 1;
                                break;
                            }
                            this.currentOutputStream.write(b);
                            ++this.dataInCount;
                            break;
                        }
                        case 1: {
                            if (b == 255) {
                                this.state = 0;
                                this.currentOutputStream.write(b);
                                ++this.markerCount;
                                ++this.dataInCount;
                                break;
                            }
                            this.state = 2;
                            this.currentOutputStream.flush();
                            this.bos.reset();
                            this.bos.write(b);
                            if (this.markerCount > 0) {
                                log.debug("read " + this.markerCount + " MARKER's");
                            }
                            this.markerCount = 0;
                            break;
                        }
                        case 2: {
                            if (b == 255) {
                                this.state = 0;
                                SocketId socketId = new SocketId(this.bos.toByteArray());
                                this.bos.reset();
                                this.currentOutputStream = this.manager.getOutputStreamByLocalSocket(socketId);
                                log.debug("redirecting input to socket: " + socketId.getPort());
                                if (this.currentOutputStream != null) break;
                                log.error("unknown socket id: " + socketId.getPort());
                                this.currentOutputStream = this.manager.getOutputStreamByLocalSocket(SocketId.DEADLETTER_SOCKET_ID);
                                if (this.currentOutputStream != null) break;
                                log.error("cannot find dead letter output stream");
                                this.currentOutputStream = new ByteArrayOutputStream();
                                break;
                            }
                            this.bos.write(b);
                        }
                    }
                    b = this.is.read();
                }
            }
            catch (InterruptedIOException e) {
                this.handleError("interrupted", e);
            }
            catch (IOException e) {
                this.handleError("i/o error", e);
            }
            super.shutdown();
            log.debug("last byte: " + b);
            log.debug("isRunning: " + this.isRunning());
            log.debug("read " + this.markerCount + " MARKER's");
        }

        protected void doShutDown() {
            log.info("input thread: data bytes read: " + this.dataInCount);
            this.flushPipes();
            this.stayAlive();
            log.info("input thread shutting down");
        }

        protected void handleError(String error, Throwable e) {
            if (e instanceof InterruptedException || e instanceof IOException) {
                if (this.trace) {
                    log.trace(error, e);
                }
            } else {
                log.debug(error, e);
            }
        }

        protected synchronized void stayAlive() {
            log.info("input thread entering stayAlive()");
            while (!this.managerShuttingDown) {
                try {
                    this.wait();
                }
                catch (InterruptedException e) {
                    log.debug("stayAlive(): InterruptedException");
                }
                log.debug("stayAlive(): wait ended");
            }
        }

        protected void flushPipes() {
            Iterator it = this.manager.getAllOutputStreams().iterator();
            while (it.hasNext()) {
                OutputStream os = (OutputStream)it.next();
                try {
                    os.flush();
                }
                catch (IOException ignored) {
                    log.error("unable to flush a PipedOutputStream");
                }
            }
            log.info("input thread flushed PipedOutputStream's");
        }
    }
}

