/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.invocation.pooled.interfaces;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.lang.reflect.Method;
import java.security.Principal;
import java.util.HashMap;
import java.util.Iterator;
import javax.transaction.Transaction;
import org.jboss.invocation.Invocation;
import org.jboss.invocation.InvocationType;
import org.jboss.invocation.MarshalledInvocation;
import org.jboss.invocation.MarshalledValue;
import org.jboss.invocation.pooled.interfaces.PooledMarshalledValue;

public class PooledMarshalledInvocation
extends MarshalledInvocation
implements Externalizable {
    static final long serialVersionUID = -728630295444149842L;
    private transient Transaction tx;
    private transient Object credential;
    private transient Principal principal;
    private transient Object enterpriseContext;
    private transient Object id;
    private transient PooledMarshalledValue pooledMarshalledArgs;

    public PooledMarshalledInvocation() {
    }

    public PooledMarshalledInvocation(Invocation invocation) {
        this.payload = invocation.payload;
        this.as_is_payload = invocation.as_is_payload;
        this.method = invocation.getMethod();
        this.objectName = invocation.getObjectName();
        this.args = invocation.getArguments();
        this.invocationType = invocation.getType();
    }

    public PooledMarshalledInvocation(Object id, Method m, Object[] args, Transaction tx, Principal identity, Object credential) {
        super(id, m, args, tx, identity, credential);
    }

    public Object getEnterpriseContext() {
        return this.enterpriseContext;
    }

    public void setEnterpriseContext(Object enterpriseContext) {
        this.enterpriseContext = enterpriseContext;
    }

    public Object getId() {
        if (this.id == null) {
            this.id = super.getId();
        }
        return this.id;
    }

    public void setId(Object id) {
        super.setId(id);
        this.id = id;
    }

    public void setTransaction(Transaction tx) {
        super.setTransaction(tx);
        this.tx = tx;
    }

    public Transaction getTransaction() {
        if (this.tx == null) {
            this.tx = super.getTransaction();
        }
        return this.tx;
    }

    public Object getCredential() {
        if (this.credential == null) {
            this.credential = super.getCredential();
        }
        return this.credential;
    }

    public void setCredential(Object credential) {
        super.setCredential(credential);
        this.credential = credential;
    }

    public Principal getPrincipal() {
        if (this.principal == null) {
            this.principal = super.getPrincipal();
        }
        return this.principal;
    }

    public void setPrincipal(Principal principal) {
        super.setPrincipal(principal);
        this.principal = principal;
    }

    public Object[] getArguments() {
        if (this.args == null) {
            try {
                this.args = (Object[])this.pooledMarshalledArgs.get();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return this.args;
    }

    public void writeExternal(ObjectOutput out) throws IOException {
        Object currentKey;
        Iterator keys;
        out.writeObject(this.invocationType);
        out.writeObject(this.tpc);
        long methodHash = PooledMarshalledInvocation.calculateHash(this.method);
        out.writeLong(methodHash);
        out.writeInt((Integer)this.objectName);
        out.writeObject(new PooledMarshalledValue(this.args));
        if (this.payload == null) {
            out.writeInt(0);
        } else {
            out.writeInt(this.payload.size());
            keys = this.payload.keySet().iterator();
            while (keys.hasNext()) {
                currentKey = keys.next();
                out.writeObject(currentKey);
                out.writeObject(new MarshalledValue(this.payload.get(currentKey)));
            }
        }
        if (this.as_is_payload == null) {
            out.writeInt(0);
        } else {
            out.writeInt(this.as_is_payload.size());
            keys = this.as_is_payload.keySet().iterator();
            while (keys.hasNext()) {
                currentKey = keys.next();
                out.writeObject(currentKey);
                out.writeObject(this.as_is_payload.get(currentKey));
            }
        }
    }

    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        int as_is_payloadSize;
        this.invocationType = (InvocationType)in.readObject();
        this.tpc = in.readObject();
        this.methodHash = in.readLong();
        this.objectName = new Integer(in.readInt());
        this.pooledMarshalledArgs = (PooledMarshalledValue)in.readObject();
        int payloadSize = in.readInt();
        if (payloadSize > 0) {
            this.payload = new HashMap();
            for (int i = 0; i < payloadSize; ++i) {
                Object key = in.readObject();
                Object value = in.readObject();
                this.payload.put(key, value);
            }
        }
        if ((as_is_payloadSize = in.readInt()) > 0) {
            this.as_is_payload = new HashMap();
            for (int i = 0; i < as_is_payloadSize; ++i) {
                Object key = in.readObject();
                Object value = in.readObject();
                this.as_is_payload.put(key, value);
            }
        }
    }
}

