/*
 * Decompiled with CFR 0.152.
 */
package javax.management;

import java.io.Serializable;
import java.util.Arrays;
import javax.management.MBeanFeatureInfo;

public class MBeanNotificationInfo
extends MBeanFeatureInfo
implements Cloneable,
Serializable {
    private static final long serialVersionUID = -3888371564530107064L;
    private String[] types = null;
    private transient String cacheString;
    private transient int cacheHashCode;

    public MBeanNotificationInfo(String[] notifsType, String name, String description) throws IllegalArgumentException {
        super(name, description);
        this.types = null == notifsType ? new String[]{} : (String[])notifsType.clone();
    }

    public String[] getNotifTypes() {
        return (String[])this.types.clone();
    }

    public boolean equals(Object object) {
        String[] otherTypes;
        if (this == object) {
            return true;
        }
        if (object == null || !(object instanceof MBeanNotificationInfo)) {
            return false;
        }
        MBeanNotificationInfo other = (MBeanNotificationInfo)object;
        if (!super.equals(other)) {
            return false;
        }
        String[] thisTypes = this.getNotifTypes();
        if (thisTypes.length != (otherTypes = other.getNotifTypes()).length) {
            return false;
        }
        for (int i = 0; i < thisTypes.length; ++i) {
            if (thisTypes[i].equals(otherTypes[i])) continue;
            return false;
        }
        return true;
    }

    public int hashCode() {
        if (this.cacheHashCode == 0) {
            this.cacheHashCode = super.hashCode();
        }
        return this.cacheHashCode;
    }

    public String toString() {
        if (this.cacheString == null) {
            StringBuffer buffer = new StringBuffer(100);
            buffer.append(this.getClass().getName()).append(":");
            buffer.append(" name=").append(this.getName());
            buffer.append(" description=").append(this.getDescription());
            buffer.append(" types=").append(Arrays.asList(this.types));
            this.cacheString = buffer.toString();
        }
        return this.cacheString;
    }

    public Object clone() {
        MBeanNotificationInfo clone = null;
        try {
            clone = (MBeanNotificationInfo)super.clone();
            clone.types = this.getNotifTypes();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            // empty catch block
        }
        return clone;
    }
}

