/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.livecycle.output.utils;

import com.adobe.livecycle.output.client.AcrobatVersion;
import com.adobe.livecycle.output.client.PDFAConformance;
import com.adobe.livecycle.output.client.PDFARevisionNumber;
import com.adobe.livecycle.output.client.RetainSignatureField;
import java.util.StringTokenizer;

public final class OutputServiceClientUtils {
    private OutputServiceClientUtils() {
    }

    public static boolean isEmptyOrNull(String val) {
        return val == null || val.trim().length() == 0;
    }

    public static byte[] URLDecode(String sURLEncoded) {
        byte[] cDecoded = new byte[sURLEncoded.length() * 2];
        int j = 0;
        int i = 0;
        while (i < sURLEncoded.length()) {
            char cByte = sURLEncoded.charAt(i);
            if (cByte == '+') {
                cDecoded[j++] = 32;
                ++i;
                continue;
            }
            if (cByte == '%') {
                int nFirst = sURLEncoded.charAt(i + 1);
                int nSecond = sURLEncoded.charAt(i + 2);
                if (nFirst >= 97 && nFirst <= 122) {
                    nFirst -= 32;
                }
                if (nSecond >= 97 && nSecond <= 122) {
                    nSecond -= 32;
                }
                nFirst = nFirst >= 48 && nFirst <= 57 ? (nFirst -= 48) : 10 + (nFirst - 65);
                nSecond = nSecond >= 48 && nSecond <= 57 ? (nSecond -= 48) : 10 + (nSecond - 65);
                int nDecoded = nFirst * 16 + nSecond;
                cDecoded[j++] = (byte)nDecoded;
                i += 3;
                continue;
            }
            cDecoded[j++] = (byte)cByte;
            ++i;
        }
        return OutputServiceClientUtils.resizeByteArray(cDecoded, j);
    }

    public static byte[] resizeByteArray(byte[] oldArray, int newSize) {
        int oldSize = oldArray.length;
        byte[] newArray = new byte[newSize];
        int preserveLength = Math.min(oldSize, newSize);
        if (preserveLength > 0) {
            System.arraycopy(oldArray, 0, newArray, 0, preserveLength);
        }
        return newArray;
    }

    public static String getParameter(String queryString, String parameter) {
        return OutputServiceClientUtils.getParameter(queryString, parameter, "");
    }

    public static String getParameter(String queryString, String parameter, String sEncoding) {
        String sParameter = null;
        if (queryString == null || queryString.length() == 0) {
            return null;
        }
        if (parameter == null || parameter.length() == 0) {
            return null;
        }
        StringTokenizer toks = new StringTokenizer(queryString, "&");
        while (toks.hasMoreTokens()) {
            String tok_nm;
            String tok = toks.nextToken();
            int sep = tok.indexOf("=");
            if (sep <= 0 || !(tok_nm = tok.substring(0, sep).trim()).equalsIgnoreCase(parameter)) continue;
            String sTok = tok.substring(sep + 1);
            if (sTok.indexOf(37) < 0) {
                sParameter = sTok;
                continue;
            }
            byte[] cDecoded = OutputServiceClientUtils.URLDecode(sTok);
            if (sEncoding == null || sEncoding.length() == 0) {
                sParameter = new String(cDecoded);
                continue;
            }
            try {
                sParameter = new String(cDecoded, sEncoding);
            }
            catch (Exception oException) {
                sParameter = sTok;
            }
        }
        return sParameter;
    }

    public static String mergeParameters(String queryStringBase, String queryStringOver) {
        if (queryStringBase.length() == 0) {
            return queryStringOver;
        }
        StringTokenizer inToks = new StringTokenizer(queryStringOver, "&");
        String merged = queryStringBase;
        while (inToks.hasMoreTokens()) {
            String tok = inToks.nextToken();
            int tokEqual = tok.indexOf("=");
            if (tokEqual < 0) continue;
            String tokKey = tok.substring(0, tokEqual);
            String paramValue = OutputServiceClientUtils.getParameter(queryStringBase, tokKey);
            if (paramValue != null) {
                String tokKeyLwr = tokKey.toLowerCase() + "=";
                String mergedLwr = merged.toLowerCase();
                int index = mergedLwr.indexOf(tokKeyLwr);
                int repStart = index + tokEqual + 1;
                int repEnd = repStart + paramValue.length();
                merged = merged.substring(0, repStart) + tok.substring(tokEqual + 1) + merged.substring(repEnd);
                continue;
            }
            merged = merged + "&" + tok;
        }
        return merged;
    }

    public static int findArraySegmentLimited(byte[] origArray, int start, byte[] findSegment, int origArrayLimit) {
        int origArrayLen;
        int i = start;
        int n = origArrayLen = origArrayLimit <= 0 ? origArray.length : origArrayLimit;
        if (origArrayLen > origArray.length) {
            origArrayLen = origArray.length;
        }
        while (i + findSegment.length <= origArrayLen) {
            int j;
            for (j = 0; j < findSegment.length && findSegment[j] == origArray[i + j]; ++j) {
            }
            if (j == findSegment.length) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    public static int findArraySegment(byte[] origArray, int start, byte[] findSegment) {
        return OutputServiceClientUtils.findArraySegmentLimited(origArray, start, findSegment, 0);
    }

    public static PDFARevisionNumber convertIntToPDFARevisionNumber(int revisionNumber) {
        for (PDFARevisionNumber pdfaRevisionNumber : PDFARevisionNumber.values()) {
            if (pdfaRevisionNumber.getValue() != revisionNumber) continue;
            return pdfaRevisionNumber;
        }
        return null;
    }

    public static PDFAConformance convertStringToPDFAConformance(String conformance) {
        for (PDFAConformance pdfaConformance : PDFAConformance.values()) {
            if (!pdfaConformance.name().equalsIgnoreCase(conformance)) continue;
            return pdfaConformance;
        }
        return null;
    }

    public static AcrobatVersion convertStringToAcrobatVersion(String version) {
        for (AcrobatVersion acrobatVersion : AcrobatVersion.values()) {
            if (!acrobatVersion.getVersion().equalsIgnoreCase(version)) continue;
            return acrobatVersion;
        }
        return null;
    }

    public static RetainSignatureField convertStringToRetainSignatureField(String name) {
        if (name == null) {
            return null;
        }
        for (RetainSignatureField retainSignatureField : RetainSignatureField.values()) {
            if (!retainSignatureField.name().equalsIgnoreCase(name)) continue;
            return retainSignatureField;
        }
        return null;
    }
}

