/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.livecycle.output.logging;

import com.adobe.logging.AdobeLogger;
import com.adobe.logging.Msg0;
import com.adobe.logging.Msg1;
import com.adobe.logging.Msg2;
import com.adobe.logging.Msg3;
import java.util.ArrayList;
import java.util.ResourceBundle;
import java.util.logging.Level;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OutputLogger {
    public static final int LOG_INFO = 6;
    public static final int LOG_DEBUG = 7;
    public static final String FRM_PERF_KW = "ALC-FRM-PRF:";
    public static final String OUT_PERF_KW = "ALC-OUT-PRF:";
    public static final String PERF_KW = " !PERFORMANCE! ";
    public static String OUTPUT_LOGGING_BUNDLE = "com.adobe.livecycle.output.logging.OUT";
    private static ThreadLocal<Boolean> bPerfLoggingEnabled = new ThreadLocal();
    private static ThreadLocal<ArrayList<String>> oTLOutputBuffer = new ThreadLocal();

    public static String getResourceString(ResourceBundle bundle, String resourceID) {
        if (bundle == null) {
            bundle = ResourceBundle.getBundle(OUTPUT_LOGGING_BUNDLE);
        }
        return (String)bundle.getObject(resourceID);
    }

    public static String getResourceString(String resourceID) {
        return OutputLogger.getResourceString(null, resourceID);
    }

    public static String getResourceString(ResourceBundle bundle, String resourceID, String[] args) {
        if (bundle == null) {
            bundle = ResourceBundle.getBundle(OUTPUT_LOGGING_BUNDLE);
        }
        String res = (String)bundle.getObject(resourceID);
        if (args != null) {
            for (int i = 0; i < args.length; ++i) {
                String tok = "{" + i + "}";
                int j = res.indexOf(tok);
                if (j < 0) continue;
                res = res.substring(0, j) + args[i] + res.substring(j + tok.length());
            }
        }
        return res;
    }

    public static String getResourceString(String resourceID, String[] args) {
        return OutputLogger.getResourceString(null, resourceID, args);
    }

    public static void logMessage(Class oClass, Level level, ResourceBundle bundle, String resourceID) {
        OutputLogger.logMessage(oClass, level, bundle, resourceID, null);
    }

    public static void logMessage(Class oClass, Level level, String resourceID) {
        OutputLogger.logMessage(oClass, level, null, resourceID);
    }

    public static void logMessage(Class oClass, Level level, String resourceID, String[] args) {
        OutputLogger.logMessage(oClass, level, null, resourceID, args);
    }

    public static void logMessage(Class oClass, Level level, ResourceBundle bundle, String resourceID, String[] args) {
        block12: {
            try {
                String sLogString = OutputLogger.getResourceString(bundle, resourceID);
                if (sLogString == null || sLogString.length() == 0) {
                    sLogString = "** this msg not found in resources **";
                }
                AdobeLogger logger = AdobeLogger.getAdobeLogger((Class)oClass);
                if (args == null) {
                    logger.log(new Msg0(resourceID, level, sLogString));
                } else if (args.length == 1) {
                    logger.log(new Msg1(resourceID, level, sLogString), (Object)args[0]);
                } else if (args.length == 2) {
                    logger.log(new Msg2(resourceID, level, sLogString), (Object)args[0], (Object)args[1]);
                } else if (args.length >= 3) {
                    logger.log(new Msg3(resourceID, level, sLogString), (Object)args[0], (Object)args[1], (Object)args[2]);
                }
            }
            catch (Exception e) {
                String err = e.getMessage();
                if (err == null) {
                    err = e.getClass().getName();
                }
                if (args == null) break block12;
                System.out.print("[Print] logMessage error: " + e + " args passed: ");
                for (int i = 0; i < args.length; ++i) {
                    System.out.print(args[i]);
                }
                System.out.println("");
            }
        }
    }

    public static String dumpLog(Object caller, Exception e, Level level) {
        StringBuffer err = new StringBuffer();
        if (e.getMessage() != null) {
            err.append(e.getMessage());
        } else {
            err.append(e.getClass().getName());
        }
        if (e.getCause() != null) {
            err.append(", cause: ");
            String msg = e.getCause().getMessage();
            if (msg == null) {
                msg = e.getCause().getClass().getName();
            }
            err.append(msg);
        }
        AdobeLogger lgr = AdobeLogger.getAdobeLogger(caller.getClass());
        lgr.log(level, err.toString());
        return err.toString();
    }

    public static String dumpLog(Object caller, Exception e) {
        return OutputLogger.dumpLog(caller, e, Level.SEVERE);
    }

    public static void dumpLog(Object caller, String msg, Level level) {
        AdobeLogger lgr = AdobeLogger.getAdobeLogger(caller.getClass());
        lgr.log(level, msg);
    }

    public static long logPerformance(boolean diff, long timeStamp, String text) {
        if (!OutputLogger.getPerformanceLogEnabled()) {
            return -1L;
        }
        if (!diff) {
            OutputLogger.logPMessage(new String[]{text});
            return System.nanoTime();
        }
        long difference = System.nanoTime() - timeStamp;
        OutputLogger.logPMessage(new String[]{text, "" + difference});
        return 0L;
    }

    private static void logPMessage(String[] args) {
        ArrayList<String> oThreadLocalBuffer = OutputLogger.getBuffer();
        if (oThreadLocalBuffer != null) {
            StringBuffer oMsg = new StringBuffer();
            oMsg.append(OUT_PERF_KW).append(PERF_KW);
            if (args.length == 1) {
                oMsg.append(args[0]);
            } else if (args.length == 2) {
                oMsg.append(args[0]).append(" :").append(args[1]).append("ns");
            }
            oThreadLocalBuffer.add(oMsg.toString());
        }
    }

    public static ArrayList<String> getBuffer() {
        return oTLOutputBuffer.get();
    }

    public static void setBuffer(ArrayList<String> oList) {
        oTLOutputBuffer.set(oList);
    }

    public static boolean getPerformanceLogEnabled() {
        return bPerfLoggingEnabled.get() != null && bPerfLoggingEnabled.get() != false;
    }

    public static void setPerformanceLogEnabled(boolean bEnable) {
        bPerfLoggingEnabled.set(bEnable);
    }

    public static void logInfo(Class oClass, String text) {
        OutputLogger.logMessage(oClass, 6, "ALC-OUT-001-914", new String[]{text});
    }

    public static void logDebug(Class oClass, String text) {
        OutputLogger.logMessage(oClass, 7, "ALC-OUT-001-914", new String[]{text});
    }

    public static void logMessage(Class oClass, int severity, String resourceID, String[] args) {
        OutputLogger.logMessage(oClass, com.adobe.service.logging.Level.toLevel((int)severity).jdkLevel(), null, resourceID, args);
    }
}

