/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.livecycle.output.exception;

import com.adobe.livecycle.output.logging.OutputLogger;
import java.util.logging.Level;

public class OutputException
extends Exception {
    private String result;

    public String getResult() {
        return this.result;
    }

    public void setResult(String result) {
        this.result = result;
    }

    public OutputException() {
    }

    public OutputException(Exception e) {
        super(e);
    }

    public OutputException(String reason) {
        super(reason);
    }

    public OutputException(String reason, Throwable e) {
        super(reason, e);
    }

    public OutputException(String result, String message, Throwable cause) {
        super(message);
        this.setStackTrace(cause.getStackTrace());
        this.result = result;
    }

    public OutputException(String resourceID, Level level, boolean log) {
        this(OutputLogger.getResourceString(resourceID));
        if (log) {
            OutputLogger.logMessage(this.getClass(), level, resourceID);
        }
    }

    public OutputException(String resourceID, String[] args, Level level, boolean log) {
        this(OutputLogger.getResourceString(resourceID, args));
        if (log) {
            OutputLogger.logMessage(this.getClass(), level, resourceID, args);
        }
    }

    public OutputException(String resourceID, String[] args, Level level, boolean log, Throwable cause) {
        this(OutputLogger.getResourceString(resourceID, args), cause);
        this.setStackTrace(cause.getStackTrace());
        if (log) {
            OutputLogger.logMessage(this.getClass(), level, resourceID, args);
        }
    }
}

