/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.livecycle.output.client;

import com.adobe.livecycle.SinceLC;
import com.adobe.livecycle.output.client.AcrobatVersion;
import com.adobe.livecycle.output.client.PDFAConformance;
import com.adobe.livecycle.output.client.PDFARevisionNumber;
import com.adobe.livecycle.output.client.RetainSignatureField;
import com.adobe.livecycle.output.exception.OutputException;
import com.adobe.livecycle.output.utils.OutputServiceClientUtils;
import java.io.Serializable;
import java.util.HashMap;
import java.util.StringTokenizer;
import java.util.logging.Level;

public class RenderOptionsSpec
implements Serializable {
    private static final long serialVersionUID = 1122342255038916009L;
    protected Boolean cacheEnabled = null;
    protected String pdfVersion = null;
    protected boolean taggedPDF = false;
    protected boolean linearizedPDF = false;
    protected boolean debugEnabled = false;
    protected String renderAtClient = null;
    protected PDFARevisionNumber pDFARevisionNumber = PDFARevisionNumber.Revision_1;
    protected String pDFAAmendment = "";
    protected PDFAConformance pDFAConformance = PDFAConformance.A;
    protected AcrobatVersion acrobatVersion = null;
    protected RetainSignatureField retainSignatureField = null;
    protected String internalOptions = "";
    protected static HashMap propertyMap = new HashMap(14);

    public RenderOptionsSpec() {
    }

    public RenderOptionsSpec(String sOptions) throws OutputException {
        this.updateOptionsBean(sOptions);
    }

    public RenderOptionsSpec(Boolean cacheEnabled, String pdfVersion, boolean taggedPDF, boolean linearizedPDF, boolean debugEnabled, String renderAtClient, PDFARevisionNumber pDFARevisionNumber, String pDFAAmendment, PDFAConformance pDFAConformance) {
        this.cacheEnabled = cacheEnabled;
        this.pdfVersion = pdfVersion;
        this.taggedPDF = taggedPDF;
        this.linearizedPDF = linearizedPDF;
        this.debugEnabled = debugEnabled;
        this.pDFARevisionNumber = pDFARevisionNumber;
        this.pDFAAmendment = pDFAAmendment;
        this.pDFAConformance = pDFAConformance;
        this.renderAtClient = renderAtClient;
    }

    public String getRenderAtClient() {
        return this.renderAtClient;
    }

    public void setRenderAtClient(String renderAtClient) {
        this.renderAtClient = renderAtClient;
    }

    public String getPDFAAmendment() {
        return this.pDFAAmendment;
    }

    public void setPDFAAmendment(String pDFAAmendment) {
        this.pDFAAmendment = pDFAAmendment;
    }

    public PDFAConformance getPDFAConformance() {
        return this.pDFAConformance;
    }

    public void setPDFAConformance(PDFAConformance pDFAConformance) {
        this.pDFAConformance = pDFAConformance;
    }

    public PDFARevisionNumber getPDFARevisionNumber() {
        return this.pDFARevisionNumber;
    }

    public void setPDFARevisionNumber(PDFARevisionNumber pDFARevisionNumber) {
        this.pDFARevisionNumber = pDFARevisionNumber;
    }

    public Boolean isCacheEnabled() {
        return this.cacheEnabled;
    }

    public Boolean getCacheEnabled() {
        return this.cacheEnabled;
    }

    public void setCacheEnabled(Boolean cacheEnabled) {
        this.cacheEnabled = cacheEnabled;
    }

    public boolean isDebugEnabled() {
        return this.debugEnabled;
    }

    public void setDebugEnabled(boolean debugEnabled) {
        this.debugEnabled = debugEnabled;
    }

    public boolean isLinearizedPDF() {
        return this.linearizedPDF;
    }

    public void setLinearizedPDF(boolean linearizedPDF) {
        this.linearizedPDF = linearizedPDF;
    }

    public String getPdfVersion() {
        return this.pdfVersion;
    }

    public void setPdfVersion(String pdfVersion) {
        this.pdfVersion = pdfVersion;
    }

    public boolean isTaggedPDF() {
        return this.taggedPDF;
    }

    public void setTaggedPDF(boolean taggedPDF) {
        this.taggedPDF = taggedPDF;
    }

    public String getOptions() {
        StringBuffer optStr = new StringBuffer();
        for (String key : propertyMap.keySet()) {
            String val = this.getOptionsBean(key);
            if (val == null || val.trim().length() <= 0) continue;
            optStr.append(key).append("=").append(val).append("&");
        }
        if (this.internalOptions != null && !this.internalOptions.equalsIgnoreCase("")) {
            optStr.append(this.internalOptions).append("&");
        }
        return optStr.substring(0, optStr.length() - 1);
    }

    public String getOptionsBean(String key) {
        String paramVal = "";
        boolean isInternal = false;
        int propId = this.lookupProperty(key);
        switch (propId) {
            case 1: {
                if (this.isCacheEnabled() == null) break;
                paramVal = Boolean.toString(this.isCacheEnabled());
                break;
            }
            case 2: {
                paramVal = this.getPdfVersion();
                break;
            }
            case 3: {
                paramVal = Boolean.toString(this.isTaggedPDF());
                break;
            }
            case 4: {
                paramVal = Boolean.toString(this.isLinearizedPDF());
                break;
            }
            case 7: {
                paramVal = Boolean.toString(this.isDebugEnabled());
                break;
            }
            case 9: {
                if (this.getPDFARevisionNumber() == null) break;
                paramVal = Integer.toString(this.getPDFARevisionNumber().getValue());
                break;
            }
            case 10: {
                paramVal = this.getPDFAAmendment();
                break;
            }
            case 11: {
                if (this.getPDFAConformance() == null) break;
                paramVal = this.getPDFAConformance().name();
                break;
            }
            case 12: {
                paramVal = this.getRenderAtClient();
                break;
            }
            case 13: {
                if (this.getAcrobatVersion() == null) break;
                paramVal = this.getAcrobatVersion().getVersion();
                break;
            }
            case 14: {
                if (this.getRetainSignatureField() == null) break;
                paramVal = this.getRetainSignatureField().name();
                break;
            }
            default: {
                isInternal = true;
            }
        }
        if (isInternal) {
            paramVal = this.getInternalOptions(key);
            return paramVal;
        }
        return this.decodeURL(paramVal);
    }

    public void updateOptionsBean(String key, String value) throws OutputException {
        if (value != null && value.trim().length() == 0) {
            value = null;
        }
        int propId = this.lookupProperty(key);
        if (value != null && propId == 9) {
            try {
                Integer.parseInt(value);
            }
            catch (NumberFormatException nfe) {
                throw new OutputException("ALC-OUT-001-012", new String[]{key, value}, Level.SEVERE, true);
            }
        } else if ((value != null && propId == 1 || propId == 3 || propId == 4 || propId == 7) && !"true".equalsIgnoreCase(value) && !"false".equalsIgnoreCase(value)) {
            if (!"0".equalsIgnoreCase(value) && !"1".equalsIgnoreCase(value)) {
                throw new OutputException("ALC-OUT-001-012", new String[]{key, value}, Level.SEVERE, true);
            }
            value = "1".equalsIgnoreCase(value) ? "true" : "false";
        }
        switch (propId) {
            case 1: {
                if (value == null) {
                    this.setCacheEnabled(null);
                    break;
                }
                this.setCacheEnabled((boolean)Boolean.valueOf(value));
                break;
            }
            case 2: {
                this.setPdfVersion(value);
                break;
            }
            case 3: {
                this.setTaggedPDF(Boolean.valueOf(value));
                break;
            }
            case 4: {
                this.setLinearizedPDF(Boolean.valueOf(value));
                break;
            }
            case 7: {
                this.setDebugEnabled(Boolean.valueOf(value));
                break;
            }
            case 9: {
                if (value == null) {
                    this.setPDFARevisionNumber(null);
                    break;
                }
                this.setPDFARevisionNumber(OutputServiceClientUtils.convertIntToPDFARevisionNumber(Integer.parseInt(value)));
                break;
            }
            case 10: {
                this.setPDFAAmendment(value);
                break;
            }
            case 11: {
                if (value == null) {
                    this.setPDFAConformance(null);
                    break;
                }
                this.setPDFAConformance(OutputServiceClientUtils.convertStringToPDFAConformance(value));
                break;
            }
            case 12: {
                this.setRenderAtClient(value);
                break;
            }
            case 13: {
                this.setAcrobatVersion(OutputServiceClientUtils.convertStringToAcrobatVersion(value));
                break;
            }
            case 14: {
                this.setRetainSignatureField(OutputServiceClientUtils.convertStringToRetainSignatureField(value));
                break;
            }
            default: {
                this.setInternalOptions(key, value);
            }
        }
    }

    public void updateOptionsBean(String options) throws OutputException {
        if (OutputServiceClientUtils.isEmptyOrNull(options) || options.indexOf("=") == -1) {
            return;
        }
        StringTokenizer inToks = new StringTokenizer(options, "&");
        while (inToks.hasMoreTokens()) {
            String tok = inToks.nextToken();
            int tokEqual = tok.indexOf("=");
            if (tokEqual < 0) continue;
            this.updateOptionsBean(tok.substring(0, tokEqual), tok.substring(tokEqual + 1));
        }
    }

    public String toString() {
        return this.getOptions();
    }

    private int lookupProperty(String key) {
        int propId = 0;
        if (!OutputServiceClientUtils.isEmptyOrNull(key) && propertyMap.containsKey(key = key.toLowerCase())) {
            propId = (Integer)propertyMap.get(key);
        }
        return propId;
    }

    private String decodeURL(String sURLEncoded) {
        if (sURLEncoded != null && sURLEncoded.indexOf(37) != -1) {
            byte[] cDecoded = OutputServiceClientUtils.URLDecode(sURLEncoded);
            sURLEncoded = new String(cDecoded);
        }
        return sURLEncoded;
    }

    public String getInternalOptions(String key) {
        return OutputServiceClientUtils.getParameter(this.internalOptions, key);
    }

    public void setInternalOptions(String key, String val) {
        this.internalOptions = OutputServiceClientUtils.mergeParameters(this.internalOptions, key + "=" + val);
    }

    @SinceLC(value="8.2.1")
    public AcrobatVersion getAcrobatVersion() {
        return this.acrobatVersion;
    }

    public void setAcrobatVersion(AcrobatVersion acrobatVersion) {
        this.acrobatVersion = acrobatVersion;
    }

    @SinceLC(value="8.2.1")
    public RetainSignatureField getRetainSignatureField() {
        return this.retainSignatureField;
    }

    public void setRetainSignatureField(RetainSignatureField retainSignatureField) {
        this.retainSignatureField = retainSignatureField;
    }

    static {
        propertyMap.put("cacheenabled".toLowerCase(), new Integer(1));
        propertyMap.put("pdfversion".toLowerCase(), new Integer(2));
        propertyMap.put("taggedpdf".toLowerCase(), new Integer(3));
        propertyMap.put("linearpdf".toLowerCase(), new Integer(4));
        propertyMap.put("padebug".toLowerCase(), new Integer(7));
        propertyMap.put("PDFARevisionNumber".toLowerCase(), new Integer(9));
        propertyMap.put("PDFAAmendment".toLowerCase(), new Integer(10));
        propertyMap.put("PDFAConformance".toLowerCase(), new Integer(11));
        propertyMap.put("renderatclient".toLowerCase(), new Integer(12));
        propertyMap.put("acrobatversion".toLowerCase(), new Integer(13));
        propertyMap.put("retainsignaturefield".toLowerCase(), new Integer(14));
    }
}

