/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.livecycle.output.client;

import com.adobe.livecycle.output.client.Rule;
import com.adobe.livecycle.output.exception.OutputException;
import com.adobe.livecycle.output.utils.OutputServiceClientUtils;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.StringTokenizer;
import java.util.logging.Level;

public class OutputOptionsSpec
implements Serializable {
    private static final long serialVersionUID = 1133442286738900701L;
    public static final String SINGLE_OUTPUT = "single";
    public static final String SINGLE_OUTPUT_WITH_RETURN_DATA = "single_with_return_data";
    public static final String MULTIPLE_OUTPUT = "multiple";
    public static final String POSTSCRIPT_FORMAT = "PostScript";
    public static final String PCL_FORMAT = "PCL";
    public static final String ZPL_FORMAT = "ZPL";
    private static final int DEFAULT_RECORD_LEVEL = -1;
    private static final int DEFAULT_RECORD_LEVEL_WITHOUT_NAME = -1;
    private static final int DEFAULT_LOOK_AHEAD = -1;
    private String requestor;
    private String serverPrintSpec;
    private String dataFile;
    private String recordName;
    private int recordLevel = -1;
    private int lookAhead = -1;
    private List rules;
    private String form;
    private String contentRoot;
    private String xci;
    private int copies = -1;
    private String printFormat;
    private String printUri;
    private String fileUri;
    private String emailRecipients;
    private String emailSubject;
    private String emailServer;
    private String emailBody;
    private String optionString;
    private boolean waitForResponse = true;
    private String outputStream = "single";
    private String pagination;
    private String staple;
    private String pageOffsetX;
    private String pageOffsetY;
    private String outputBin;
    private String outputJog;
    private String metaDataSpecFile;
    private boolean recordLevelMetaData = false;
    private String recordIdField;
    private String lpdURI;
    private String printerQueueName;
    protected String charset = null;
    protected String locale = null;
    protected static HashMap propertyMap = new HashMap(36);

    public OutputOptionsSpec() {
    }

    public OutputOptionsSpec(String sOptions) {
        this.updateOptionsBean(sOptions);
    }

    public OutputOptionsSpec(String requestor, String serverPrintSpec, String dataFile, String recordName, int recordLevel, int lookAhead, List rules, String form, String contentRoot, String xci, int copies, String printFormat, String printUri, String fileUri, String emailRecipients, String emailSubject, String emailServer, String emailBody, boolean waitForResponse, String outputStream, String pagination, String staple, String pageOffsetX, String pageOffsetY, String outputBin, String outputJog, String metaDataSpecFile, boolean recordLevelMetaData, String recordIdField, String lpdURI, String printerQueueName, String locale, String charset) {
        this.requestor = requestor;
        this.serverPrintSpec = serverPrintSpec;
        this.dataFile = dataFile;
        this.recordName = recordName;
        this.recordLevel = recordLevel;
        this.lookAhead = lookAhead;
        this.rules = rules;
        this.form = form;
        this.contentRoot = contentRoot;
        this.xci = xci;
        this.copies = copies;
        this.printFormat = printFormat;
        this.printUri = printUri;
        this.fileUri = fileUri;
        this.emailRecipients = emailRecipients;
        this.emailSubject = emailSubject;
        this.emailServer = emailServer;
        this.emailBody = emailBody;
        this.waitForResponse = waitForResponse;
        this.outputStream = outputStream;
        this.pagination = pagination;
        this.staple = staple;
        this.pageOffsetX = pageOffsetX;
        this.pageOffsetY = pageOffsetY;
        this.outputBin = outputBin;
        this.outputJog = outputJog;
        this.metaDataSpecFile = metaDataSpecFile;
        this.recordLevelMetaData = recordLevelMetaData;
        this.recordIdField = recordIdField;
        this.lpdURI = lpdURI;
        this.printerQueueName = printerQueueName;
        this.charset = charset;
        this.locale = locale;
    }

    public String getEmailRecipients() {
        return this.emailRecipients;
    }

    public void setEmailRecipients(String emailRecipients) {
        this.emailRecipients = emailRecipients;
    }

    public String getEmailSubject() {
        return this.emailSubject;
    }

    public void setEmailSubject(String emailSubject) {
        this.emailSubject = emailSubject;
    }

    public String getEmailServer() {
        return this.emailServer;
    }

    public void setEmailServer(String emailServer) {
        this.emailServer = emailServer;
    }

    public String getEmailBody() {
        return this.emailBody;
    }

    public void setEmailBody(String emailBody) {
        this.emailBody = emailBody;
    }

    public int getCopies() {
        return this.copies;
    }

    public void setCopies(int copies) {
        this.copies = copies;
    }

    public String getPrintFormat() {
        return this.printFormat;
    }

    public void setPrintFormat(String printFormat) {
        this.printFormat = printFormat;
    }

    public boolean isPostScriptFormat() {
        return POSTSCRIPT_FORMAT.equals(this.getPrintFormat());
    }

    public boolean isPCLFormat() {
        return PCL_FORMAT.equals(this.getPrintFormat());
    }

    public boolean isZPLFormat() {
        return ZPL_FORMAT.equals(this.getPrintFormat());
    }

    public String getPrintUri() {
        return this.printUri;
    }

    public void setPrintUri(String printUri) {
        this.printUri = printUri;
    }

    public String getFileUri() {
        return this.fileUri;
    }

    public void setFileUri(String fileUri) {
        this.fileUri = fileUri;
    }

    public String getOptionString() {
        return this.optionString;
    }

    public void setOptionString(String optionString) {
        this.optionString = optionString;
    }

    public boolean isWaitForResponse() {
        return this.waitForResponse;
    }

    public void setWaitForResponse(boolean waitForResponse) {
        this.waitForResponse = waitForResponse;
    }

    public String getOutputStream() {
        return this.outputStream;
    }

    public void setOutputStream(String outputStream) {
        this.outputStream = outputStream;
    }

    public boolean isSingleOutput() {
        String outputStream = this.getOutputStream();
        return outputStream == null ? true : outputStream.equals(SINGLE_OUTPUT) || outputStream.equals(SINGLE_OUTPUT_WITH_RETURN_DATA);
    }

    public boolean isMultipleOutput() {
        String outputStream = this.getOutputStream();
        return outputStream == null ? false : outputStream.equals(MULTIPLE_OUTPUT);
    }

    public String getRequestor() {
        return this.requestor;
    }

    public void setRequestor(String requestor) {
        this.requestor = requestor;
    }

    public String getServerPrintSpec() {
        return this.serverPrintSpec;
    }

    public void setServerPrintSpec(String serverPrintSpec) {
        this.serverPrintSpec = serverPrintSpec;
    }

    public String getDataFile() {
        return this.dataFile;
    }

    public void setDataFile(String dataFile) {
        this.dataFile = dataFile;
    }

    public String getRecordName() {
        return this.recordName;
    }

    public void setRecordName(String recordName) {
        this.recordName = recordName;
    }

    public int getRecordLevel() {
        return this.recordLevel;
    }

    public void setRecordLevel(int recordLevel) {
        this.recordLevel = recordLevel;
    }

    public boolean isBatch() {
        return this.getRecordLevel() > 1 || this.getRecordName() != null;
    }

    public String getForm() {
        return this.form;
    }

    public void setForm(String form) {
        this.form = form;
    }

    public String getContentRoot() {
        return this.contentRoot;
    }

    public void setContentRoot(String contentRoot) {
        this.contentRoot = contentRoot;
    }

    public String getXci() {
        return this.xci;
    }

    public void setXci(String xci) {
        this.xci = xci;
    }

    public String getPagination() {
        return this.pagination;
    }

    public void setPagination(String pagination) {
        this.pagination = pagination;
    }

    public String getStaple() {
        return this.staple;
    }

    public void setStaple(String staple) {
        this.staple = staple;
    }

    public String getOutputJog() {
        return this.outputJog;
    }

    public void setOutputJog(String outputJog) {
        this.outputJog = outputJog;
    }

    public String getOutputBin() {
        return this.outputBin;
    }

    public void setOutputBin(String outputBin) {
        this.outputBin = outputBin;
    }

    public String getPageOffsetX() {
        return this.pageOffsetX;
    }

    public void setPageOffsetX(String pageOffsetX) {
        this.pageOffsetX = pageOffsetX;
    }

    public String getPageOffsetY() {
        return this.pageOffsetY;
    }

    public void setPageOffsetY(String pageOffsetY) {
        this.pageOffsetY = pageOffsetY;
    }

    public int getLookAhead() {
        return this.lookAhead;
    }

    public void setLookAhead(int lookAhead) {
        this.lookAhead = lookAhead;
    }

    public List getRules() {
        return this.rules;
    }

    public void setRules(List rules) {
        this.rules = rules;
    }

    public String getMetaDataSpecFile() {
        return this.metaDataSpecFile;
    }

    public void setMetaDataSpecFile(String metaDataSpecFile) {
        this.metaDataSpecFile = metaDataSpecFile;
    }

    public boolean isRecordLevelMetaData() {
        return this.recordLevelMetaData;
    }

    public void setRecordLevelMetaData(boolean recordLevelMetaData) {
        this.recordLevelMetaData = recordLevelMetaData;
    }

    public String getCharset() {
        return this.charset;
    }

    public void setCharset(String charset) {
        this.charset = charset;
    }

    public String getLocale() {
        return this.locale;
    }

    public void setLocale(String locale) {
        this.locale = locale;
    }

    public String getOption(String key) {
        String paramVal = "";
        int propId = this.lookupProperty(key);
        switch (propId) {
            case 1: {
                paramVal = this.getRequestor();
                break;
            }
            case 2: {
                paramVal = this.getServerPrintSpec();
                break;
            }
            case 3: {
                paramVal = this.getDataFile();
                break;
            }
            case 4: {
                paramVal = this.getRecordName();
                break;
            }
            case 5: {
                paramVal = Integer.toString(this.getRecordLevel());
                break;
            }
            case 6: {
                paramVal = Integer.toString(this.getLookAhead());
                break;
            }
            case 7: {
                paramVal = this.rulesToString(this.getRules());
                break;
            }
            case 8: {
                paramVal = this.getForm();
                break;
            }
            case 9: {
                paramVal = this.getContentRoot();
                break;
            }
            case 10: {
                paramVal = this.getXci();
                break;
            }
            case 11: {
                paramVal = this.getPrinterQueueName();
                break;
            }
            case 12: {
                paramVal = Integer.toString(this.getCopies());
                break;
            }
            case 13: {
                paramVal = this.getPrintFormat();
                break;
            }
            case 14: {
                paramVal = this.getPrintUri();
                break;
            }
            case 15: {
                paramVal = this.getFileUri();
                break;
            }
            case 16: {
                paramVal = this.getEmailRecipients();
                break;
            }
            case 17: {
                paramVal = this.getEmailSubject();
                break;
            }
            case 18: {
                paramVal = this.getEmailServer();
                break;
            }
            case 19: {
                paramVal = this.getEmailBody();
                break;
            }
            case 20: {
                paramVal = Boolean.toString(this.isWaitForResponse());
                break;
            }
            case 21: {
                paramVal = this.getOutputStream();
                break;
            }
            case 22: {
                paramVal = this.getPagination();
                break;
            }
            case 23: {
                paramVal = this.getStaple();
                break;
            }
            case 24: {
                paramVal = this.getPageOffsetX();
                break;
            }
            case 25: {
                paramVal = this.getPageOffsetY();
                break;
            }
            case 26: {
                paramVal = this.getOutputBin();
                break;
            }
            case 27: {
                paramVal = this.getOutputJog();
                break;
            }
            case 28: {
                paramVal = this.getMetaDataSpecFile();
                break;
            }
            case 29: {
                paramVal = Boolean.toString(this.isRecordLevelMetaData());
                break;
            }
            case 30: {
                paramVal = this.getRecordIdField();
                break;
            }
            case 31: {
                paramVal = this.getLpdURI();
                break;
            }
            case 33: {
                paramVal = this.getCharset();
                break;
            }
            case 34: {
                paramVal = this.getLocale();
            }
        }
        return this.decodeURL(paramVal);
    }

    public String rulesToString(List rules) {
        String value = "";
        Rule rule2 = null;
        if (rules == null) {
            return value;
        }
        for (Rule rule2 : rules) {
            if (rule2.getPattern() == null) {
                rule2.setPattern("");
            }
            if (rule2.getForm() == null) {
                rule2.setForm("");
            }
            value = value + rule2.getPattern() + "=";
            value = rule2.getForm() != null ? value + rule2.getForm() : value + "";
            value = value + ";";
        }
        return value;
    }

    public List stringToRules(String rules) {
        ArrayList<Rule> rulesList = new ArrayList<Rule>();
        if (rules == null || rules.equalsIgnoreCase("")) {
            return rulesList;
        }
        Rule rule = null;
        StringTokenizer inToks = new StringTokenizer(rules, ";");
        while (inToks.hasMoreTokens()) {
            String tok = inToks.nextToken();
            int tokEqual = tok.indexOf("=");
            if (tokEqual < 0) continue;
            rule = new Rule(tok.substring(0, tokEqual), tok.substring(tokEqual + 1));
            rulesList.add(rule);
        }
        return rulesList;
    }

    private int lookupProperty(String key) {
        int propId = 0;
        if (!OutputServiceClientUtils.isEmptyOrNull(key) && propertyMap.containsKey(key = key.toLowerCase())) {
            propId = (Integer)propertyMap.get(key);
        }
        return propId;
    }

    private String decodeURL(String sURLEncoded) {
        if (sURLEncoded != null && sURLEncoded.indexOf(37) != -1) {
            byte[] cDecoded = OutputServiceClientUtils.URLDecode(sURLEncoded);
            sURLEncoded = new String(cDecoded);
        }
        return sURLEncoded;
    }

    public String getOptions() {
        StringBuffer optStr = new StringBuffer();
        for (String key : propertyMap.keySet()) {
            String val = this.getOption(key);
            if (val == null) continue;
            optStr.append(key).append("=").append(val).append("&");
        }
        int i = optStr.lastIndexOf("&");
        if (i != -1) {
            return optStr.substring(0, i);
        }
        return optStr.toString();
    }

    public void updateOptionsBean(String key, String value) throws OutputException {
        int propId = this.lookupProperty(key);
        if (propId == 5 || propId == 6 || propId == 12) {
            try {
                Integer.parseInt(value);
            }
            catch (NumberFormatException nfe) {
                throw new OutputException("ALC-OUT-001-012", new String[]{key, value}, Level.SEVERE, true);
            }
        } else if (!(propId != 20 && propId != 29 || "true".equalsIgnoreCase(value) || "false".equalsIgnoreCase(value))) {
            if (!"0".equalsIgnoreCase(value) && !"1".equalsIgnoreCase(value)) {
                throw new OutputException("ALC-OUT-001-012", new String[]{key, value}, Level.SEVERE, true);
            }
            String string = value = "1".equalsIgnoreCase(value) ? "true" : "false";
        }
        if (value != null && value.trim().length() == 0) {
            value = null;
        }
        switch (propId) {
            case 1: {
                this.setRequestor(value);
                break;
            }
            case 2: {
                this.setServerPrintSpec(value);
                break;
            }
            case 3: {
                this.setDataFile(value);
                break;
            }
            case 4: {
                this.setRecordName(value);
                break;
            }
            case 5: {
                this.setRecordLevel(Integer.parseInt(value));
                break;
            }
            case 6: {
                this.setLookAhead(Integer.parseInt(value));
                break;
            }
            case 7: {
                this.setRules(this.stringToRules(value));
                break;
            }
            case 8: {
                this.setForm(value);
                break;
            }
            case 9: {
                this.setContentRoot(value);
                break;
            }
            case 10: {
                this.setXci(value);
                break;
            }
            case 11: {
                this.setPrinterQueueName(value);
                break;
            }
            case 12: {
                this.setCopies(Integer.parseInt(value));
                break;
            }
            case 13: {
                this.setPrintFormat(value);
                break;
            }
            case 14: {
                this.setPrintUri(value);
                break;
            }
            case 15: {
                this.setFileUri(value);
                break;
            }
            case 16: {
                this.setEmailRecipients(value);
                break;
            }
            case 17: {
                this.setEmailSubject(value);
                break;
            }
            case 18: {
                this.setEmailServer(value);
                break;
            }
            case 19: {
                this.setEmailBody(value);
                break;
            }
            case 20: {
                this.setWaitForResponse(Boolean.valueOf(value));
                break;
            }
            case 21: {
                this.setOutputStream(value);
                break;
            }
            case 22: {
                this.setPagination(value);
                break;
            }
            case 23: {
                this.setStaple(value);
                break;
            }
            case 24: {
                this.setPageOffsetX(value);
                break;
            }
            case 25: {
                this.setPageOffsetY(value);
                break;
            }
            case 26: {
                this.setOutputBin(value);
                break;
            }
            case 27: {
                this.setOutputJog(value);
                break;
            }
            case 28: {
                this.setMetaDataSpecFile(value);
                break;
            }
            case 29: {
                this.setRecordLevelMetaData(Boolean.valueOf(value));
                break;
            }
            case 30: {
                this.setRecordIdField(value);
                break;
            }
            case 31: {
                this.setLpdURI(value);
                break;
            }
            case 33: {
                this.setCharset(value);
                break;
            }
            case 34: {
                this.setLocale(value);
            }
        }
    }

    public void updateOptionsBean(String options) {
        if (OutputServiceClientUtils.isEmptyOrNull(options) || options.indexOf("=") == -1) {
            return;
        }
        StringTokenizer inToks = new StringTokenizer(options, "&");
        while (inToks.hasMoreTokens()) {
            String tok = inToks.nextToken();
            int tokEqual = tok.indexOf("=");
            if (tokEqual < 0) continue;
            try {
                this.updateOptionsBean(tok.substring(0, tokEqual), tok.substring(tokEqual + 1));
            }
            catch (OutputException e) {}
        }
    }

    public String toString() {
        return this.getOptions();
    }

    public String getRecordIdField() {
        return this.recordIdField;
    }

    public void setRecordIdField(String recordIdField) {
        this.recordIdField = recordIdField;
    }

    public String getLpdURI() {
        return this.lpdURI;
    }

    public void setLpdURI(String lpdURI) {
        this.lpdURI = lpdURI;
    }

    public String getPrinterQueueName() {
        return this.printerQueueName;
    }

    public void setPrinterQueueName(String printerQueueName) {
        this.printerQueueName = printerQueueName;
    }

    static {
        propertyMap.put("requestor".toLowerCase(), new Integer(1));
        propertyMap.put("serverprintspec".toLowerCase(), new Integer(2));
        propertyMap.put("datafile".toLowerCase(), new Integer(3));
        propertyMap.put("recordname".toLowerCase(), new Integer(4));
        propertyMap.put("recordlevel".toLowerCase(), new Integer(5));
        propertyMap.put("lookahead".toLowerCase(), new Integer(6));
        propertyMap.put("rules".toLowerCase(), new Integer(7));
        propertyMap.put("form".toLowerCase(), new Integer(8));
        propertyMap.put("contentroot".toLowerCase(), new Integer(9));
        propertyMap.put("xci".toLowerCase(), new Integer(10));
        propertyMap.put("printerqueuename".toLowerCase(), new Integer(11));
        propertyMap.put("copies".toLowerCase(), new Integer(12));
        propertyMap.put("printformat".toLowerCase(), new Integer(13));
        propertyMap.put("printuri".toLowerCase(), new Integer(14));
        propertyMap.put("fileuri".toLowerCase(), new Integer(15));
        propertyMap.put("emailrecipients".toLowerCase(), new Integer(16));
        propertyMap.put("emailsubject".toLowerCase(), new Integer(17));
        propertyMap.put("emailserver".toLowerCase(), new Integer(18));
        propertyMap.put("emailbody".toLowerCase(), new Integer(19));
        propertyMap.put("waitforresponse".toLowerCase(), new Integer(20));
        propertyMap.put("outputstream".toLowerCase(), new Integer(21));
        propertyMap.put("pagination".toLowerCase(), new Integer(22));
        propertyMap.put("staple".toLowerCase(), new Integer(23));
        propertyMap.put("pageoffsetx".toLowerCase(), new Integer(24));
        propertyMap.put("pageoffsety".toLowerCase(), new Integer(25));
        propertyMap.put("outputbin".toLowerCase(), new Integer(26));
        propertyMap.put("outputjog".toLowerCase(), new Integer(27));
        propertyMap.put("metadataspecfile".toLowerCase(), new Integer(28));
        propertyMap.put("recordlevelmetadata".toLowerCase(), new Integer(29));
        propertyMap.put("recordidfield".toLowerCase(), new Integer(30));
        propertyMap.put("lpduri".toLowerCase(), new Integer(31));
        propertyMap.put("charset".toLowerCase(), new Integer(33));
        propertyMap.put("locale".toLowerCase(), new Integer(34));
    }
}

