/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.livecycle.output.client;

import com.adobe.idp.Document;
import com.adobe.idp.dsc.DSCException;
import com.adobe.idp.dsc.InvocationRequest;
import com.adobe.idp.dsc.InvocationResponse;
import com.adobe.idp.dsc.clientsdk.ServiceClientFactory;
import com.adobe.livecycle.output.client.OutputResult;
import com.adobe.livecycle.output.client.PDFAConformance;
import com.adobe.livecycle.output.client.PDFARevisionNumber;
import com.adobe.livecycle.output.client.PDFOutputOptionsSpec;
import com.adobe.livecycle.output.client.PrintFormat;
import com.adobe.livecycle.output.client.PrintedOutputOptionsSpec;
import com.adobe.livecycle.output.client.PrinterProtocol;
import com.adobe.livecycle.output.client.RenderOptionsSpec;
import com.adobe.livecycle.output.client.TransformationFormat;
import com.adobe.livecycle.output.exception.OutputException;
import java.util.HashMap;
import java.util.Map;

public class OutputClient {
    private ServiceClientFactory m_ServiceClientFactory = null;
    private final String OUTPUT_SERVICE_NAME = "OutputService";
    private boolean synchronous = true;

    public boolean isSynchronous() {
        return this.synchronous;
    }

    public void setSynchronous(boolean synchronous) {
        this.synchronous = synchronous;
    }

    public OutputClient(ServiceClientFactory serviceClientFactory) {
        this.m_ServiceClientFactory = serviceClientFactory;
    }

    public OutputResult generatePDFOutput(TransformationFormat transformationFormat, String form, String contentRoot, PDFOutputOptionsSpec pdfOutputOptionsSpec, RenderOptionsSpec renderOptionsSpec, Document inDataDoc) throws OutputException, DSCException {
        HashMap<String, Object> oInput = new HashMap<String, Object>();
        oInput.put("transformationFormat", (Object)transformationFormat);
        oInput.put("form", form);
        oInput.put("contentRoot", contentRoot);
        oInput.put("pdfOutputOptionsSpec", pdfOutputOptionsSpec);
        oInput.put("renderOptionsSpec", renderOptionsSpec);
        oInput.put("inDataDoc", inDataDoc);
        try {
            InvocationResponse oResponse = this.invokeRequest("generatePDFOutput", oInput);
            return (OutputResult)oResponse.getOutputParameter("generatePDFOutputResult");
        }
        catch (DSCException e) {
            if (e.getCause() instanceof OutputException) {
                OutputException oe = (OutputException)e.getCause();
                throw oe;
            }
            throw e;
        }
        catch (Exception e) {
            throw new OutputException(e);
        }
    }

    public OutputResult generatePrintedOutput(PrintFormat printFormat, String form, String contentRoot, String XDCURI, PrintedOutputOptionsSpec printedOutputOptionsSpec, Document inDataDoc) throws OutputException, DSCException {
        HashMap<String, Object> oInput = new HashMap<String, Object>();
        oInput.put("printFormat", (Object)printFormat);
        oInput.put("form", form);
        oInput.put("contentRoot", contentRoot);
        oInput.put("XDCURI", XDCURI);
        oInput.put("printedOutputOptionsSpec", printedOutputOptionsSpec);
        oInput.put("inDataDoc", inDataDoc);
        try {
            InvocationResponse oResponse = this.invokeRequest("generatePrintedOutput", oInput);
            return (OutputResult)oResponse.getOutputParameter("generatePrintedOutputResult");
        }
        catch (DSCException e) {
            if (e.getCause() instanceof OutputException) {
                OutputException oe = (OutputException)e.getCause();
                throw oe;
            }
            throw e;
        }
        catch (Exception e) {
            throw new OutputException(e);
        }
    }

    @Deprecated
    public Document getResult(String requestId) throws OutputException, DSCException {
        HashMap<String, String> oInput = new HashMap<String, String>();
        oInput.put("requestId", requestId);
        try {
            InvocationResponse oResponse = this.invokeRequest("getResult", oInput);
            return (Document)oResponse.getOutputParameter("outXmlDoc");
        }
        catch (DSCException e) {
            if (e.getCause() instanceof OutputException) {
                OutputException oe = (OutputException)e.getCause();
                throw oe;
            }
            throw e;
        }
        catch (Exception e) {
            throw new OutputException(e);
        }
    }

    @Deprecated
    public void print(Document inDataDoc, String printUri) throws OutputException, DSCException {
        HashMap<String, Object> oInput = new HashMap<String, Object>();
        oInput.put("inDataDoc", inDataDoc);
        oInput.put("printUri", printUri);
        try {
            InvocationResponse oResponse = this.invokeRequest("print", oInput);
            return;
        }
        catch (DSCException e) {
            if (e.getCause() instanceof OutputException) {
                OutputException oe = (OutputException)e.getCause();
                throw oe;
            }
            throw e;
        }
        catch (Exception e) {
            throw new OutputException(e);
        }
    }

    @Deprecated
    public void lprPrint(Document inDataDoc, String lpdURI, String printerQueueName) throws OutputException, DSCException {
        HashMap<String, Object> oInput = new HashMap<String, Object>();
        oInput.put("inDataDoc", inDataDoc);
        oInput.put("lpdURI", lpdURI);
        oInput.put("printerQueueName", printerQueueName);
        try {
            InvocationResponse oResponse = this.invokeRequest("LPRPrint", oInput);
            return;
        }
        catch (DSCException e) {
            if (e.getCause() instanceof OutputException) {
                OutputException oe = (OutputException)e.getCause();
                throw oe;
            }
            throw e;
        }
        catch (Exception e) {
            throw new OutputException(e);
        }
    }

    public void sendToPrinter(Document inDoc, PrinterProtocol printerProtocol, String printServer, String printerName) throws OutputException, DSCException {
        HashMap<String, Object> oInput = new HashMap<String, Object>();
        oInput.put("inDoc", inDoc);
        oInput.put("printServer", printServer);
        oInput.put("printerName", printerName);
        oInput.put("printerProtocol", (Object)printerProtocol);
        try {
            InvocationResponse oResponse = this.invokeRequest("sendToPrinter", oInput);
        }
        catch (DSCException e) {
            if (e.getCause() instanceof OutputException) {
                OutputException oe = (OutputException)e.getCause();
                throw oe;
            }
            throw e;
        }
        catch (Exception e) {
            throw new OutputException(e);
        }
    }

    public Document transformPDF(Document inPdfDoc, TransformationFormat transformationFormat, PDFARevisionNumber pdfaRevisionNumber, String pdfaAmendment, PDFAConformance pdfaConformance) throws OutputException, DSCException {
        HashMap<String, Object> oInput = new HashMap<String, Object>();
        oInput.put("inPdfDoc", inPdfDoc);
        oInput.put("transformationFormat", (Object)transformationFormat);
        oInput.put("pdfaRevisionNumber", (Object)pdfaRevisionNumber);
        oInput.put("pdfaAmendment", pdfaAmendment);
        oInput.put("pdfaConformance", (Object)pdfaConformance);
        try {
            InvocationResponse oResponse = this.invokeRequest("transformPDF", oInput);
            return (Document)oResponse.getOutputParameter("outPdfDoc");
        }
        catch (DSCException e) {
            if (e.getCause() instanceof OutputException) {
                OutputException oe = (OutputException)e.getCause();
                throw oe;
            }
            throw e;
        }
        catch (Exception e) {
            throw new OutputException(e);
        }
    }

    private InvocationResponse invokeRequest(String sOperationName, HashMap oInput) throws DSCException {
        InvocationRequest oRequest = this.m_ServiceClientFactory.createInvocationRequest("OutputService", sOperationName, (Map)oInput, this.synchronous);
        return this.m_ServiceClientFactory.getServiceClient().invoke(oRequest);
    }
}

