/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.livecycle.generatepdf.client;

import com.adobe.idp.dsc.DSCError;
import com.adobe.livecycle.generatepdf.client.ErrorCodeConversion;
import java.io.InputStream;
import java.text.MessageFormat;
import java.util.Locale;
import java.util.Properties;

public class PDFGError
extends DSCError {
    private static final long serialVersionUID = 98763679809891L;
    private static final String GenericExceptionMessage = "An Exception Occured";
    protected static String m_componentUID = "PDG";
    private int errorCode;
    private Object[] params = null;
    private String causingExceptionMessage = null;
    private String errorMessage = null;
    private static Properties errorMsgs = new Properties();

    public PDFGError(int errorCode, Throwable cause) {
        super(errorCode);
        String msg;
        this.errorCode = errorCode;
        this.causingExceptionMessage = cause != null ? ((msg = cause.getLocalizedMessage()) != null ? cause.getLocalizedMessage() : "") : "";
    }

    public PDFGError(int errorCode) {
        super(errorCode);
        this.errorCode = errorCode;
    }

    public PDFGError(int errorCode, Object message) {
        super(errorCode, message);
        this.errorCode = errorCode;
        this.params = new Object[]{message};
    }

    public PDFGError(int errorCode, Object arg1, Object arg2) {
        super(errorCode, arg1, arg2);
        this.errorCode = errorCode;
        this.params = new Object[]{arg1, arg2};
    }

    public PDFGError(int errorCode, Object[] params) {
        super(errorCode, params);
        this.params = params;
        this.errorCode = errorCode;
    }

    public String getComponentUID() {
        return m_componentUID;
    }

    public String getLocalizedMessage() {
        return this.getLocalizedMessage(Locale.getDefault());
    }

    public String getLocalizedMessage(Locale locale) {
        return this.getLocalizedMessage(locale.toString());
    }

    public String getLocalizedMessage(String localeName) {
        String errorMsg = null;
        if (errorMsg == null) {
            errorMsg = ErrorCodeConversion.getErrorString(this.errorCode, localeName);
        }
        if (this.params != null && this.params.length > 0) {
            if (errorMsg == null && this.params[0] != null) {
                errorMsg = this.params[0].toString();
            }
            try {
                errorMsg = MessageFormat.format(errorMsg, this.params);
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        if (errorMsg == null) {
            errorMsg = ErrorCodeConversion.getErrorString(1000, localeName);
        }
        if (this.causingExceptionMessage != null) {
            errorMsg = errorMsg + "\n" + this.causingExceptionMessage;
        }
        String errorCodeStr = "000" + this.errorCode + "";
        String moduleCodeStr = "0000" + this.errorCode + "";
        errorCodeStr = errorCodeStr.substring(errorCodeStr.length() - 3);
        int moduleCodeStrLen = moduleCodeStr.length();
        if (moduleCodeStrLen >= 6) {
            moduleCodeStr = moduleCodeStr.substring(moduleCodeStrLen - 6, moduleCodeStrLen - 3);
        }
        return "ALC-PDG-" + moduleCodeStr + "-" + errorCodeStr + "-" + errorMsg;
    }

    public String getMessage() {
        return this.getLocalizedMessage();
    }

    public String toString() {
        return super.toString();
    }

    static {
        try {
            InputStream is = PDFGError.class.getResourceAsStream("PDGErrorMsgs.properties");
            errorMsgs.load(is);
            is.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

