/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.livecycle.distiller.client;

import com.adobe.idp.Document;
import com.adobe.idp.dsc.DSCException;
import com.adobe.idp.dsc.InvocationRequest;
import com.adobe.idp.dsc.InvocationResponse;
import com.adobe.idp.dsc.clientsdk.ServiceClientFactory;
import com.adobe.livecycle.generatepdf.client.ConversionException;
import com.adobe.livecycle.generatepdf.client.CreatePDFResult;
import com.adobe.livecycle.generatepdf.client.FileFormatNotSupportedException;
import com.adobe.livecycle.generatepdf.client.InvalidParameterException;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;

public class DistillerServiceClient {
    private static final int CONVERSION_FAILURE = 1000;
    private ServiceClientFactory m_ClientFactory = null;
    private String m_strServiceName = "DistillerService";
    private String m_strVersionNumber = "1.0";

    public DistillerServiceClient(ServiceClientFactory factory) {
        this.m_ClientFactory = factory;
    }

    public CreatePDFResult createPDF(Document inDoc, String inputFileName, String pdfSettings, String securitySettings, Document inSettingsDoc, Document inXMPDoc) throws InvalidParameterException, ConversionException, FileFormatNotSupportedException {
        HashMap<String, Object> requestMap = new HashMap<String, Object>();
        requestMap.put("inputDocument", inDoc);
        requestMap.put("fileName", inputFileName);
        requestMap.put("pdfSettings", pdfSettings);
        requestMap.put("securitySettings", securitySettings);
        requestMap.put("settingsDocument", inSettingsDoc);
        requestMap.put("xmpDocument", inXMPDoc);
        InvocationRequest request = this.m_ClientFactory.createInvocationRequest(this.m_strServiceName, "CreatePDF", requestMap, true);
        CreatePDFResult result = new CreatePDFResult();
        try {
            InvocationResponse response = this.m_ClientFactory.getServiceClient().invoke(request);
            Map resultMap = (Map)response.getOutputParameter("Result");
            result.setCreatedDocument((Document)resultMap.get("ConvertedDoc"));
            result.setLogDocument((Document)resultMap.get("LogDoc"));
        }
        catch (DSCException e) {
            Serializable rootException = e.getCause();
            if (rootException == null) {
                rootException = new ConversionException(1000, (Throwable)e);
            }
            try {
                throw rootException;
            }
            catch (InvalidParameterException ex) {
                throw ex;
            }
            catch (FileFormatNotSupportedException ex) {
                throw ex;
            }
            catch (ConversionException ex) {
                throw ex;
            }
            catch (Throwable ex) {
                throw new ConversionException(1000, ex);
            }
        }
        return result;
    }

    public CreatePDFResult createPDF2(Document inDoc, String inputFileExtension, String pdfSettings, String securitySettings, Document inSettingsDoc, Document inXMPDoc) throws InvalidParameterException, ConversionException, FileFormatNotSupportedException {
        HashMap<String, Object> requestMap = new HashMap<String, Object>();
        requestMap.put("inputDocument", inDoc);
        requestMap.put("fileExtension", inputFileExtension);
        requestMap.put("pdfSettings", pdfSettings);
        requestMap.put("securitySettings", securitySettings);
        requestMap.put("settingsDocument", inSettingsDoc);
        requestMap.put("xmpDocument", inXMPDoc);
        InvocationRequest request = this.m_ClientFactory.createInvocationRequest(this.m_strServiceName, "CreatePDF2", requestMap, true);
        CreatePDFResult result = null;
        try {
            InvocationResponse response = this.m_ClientFactory.getServiceClient().invoke(request);
            result = (CreatePDFResult)response.getOutputParameter("Result");
        }
        catch (DSCException e) {
            Serializable rootException = e.getCause();
            if (rootException == null) {
                rootException = new ConversionException(1000, (Throwable)e);
            }
            try {
                throw rootException;
            }
            catch (InvalidParameterException ex) {
                throw ex;
            }
            catch (FileFormatNotSupportedException ex) {
                throw ex;
            }
            catch (ConversionException ex) {
                throw ex;
            }
            catch (Throwable ex) {
                throw new ConversionException(1000, ex);
            }
        }
        return result;
    }
}

