/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.livecycle.signatures.common;

import com.adobe.livecycle.signatures.pki.impl.PKIOperations;
import java.math.BigInteger;
import java.security.AlgorithmParameters;
import java.security.Key;
import java.security.KeyFactory;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.spec.DSAParameterSpec;
import java.security.spec.DSAPrivateKeySpec;
import java.security.spec.DSAPublicKeySpec;
import java.security.spec.RSAPrivateKeySpec;
import java.security.spec.RSAPublicKeySpec;
import java.util.HashMap;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class FIPSCompliance {
    private FIPSCompliance() {
    }

    public static boolean isDigestAlgoCompliant(String algName) {
        return algName != null && (algName.equalsIgnoreCase("SHA1") || algName.equalsIgnoreCase("SHA256") || algName.equalsIgnoreCase("SHA384") || algName.equalsIgnoreCase("SHA512"));
    }

    public static boolean isEncryptAlgoCompliant(String algName, Key key) {
        return FIPSCompliance.isEncryptAlgoCompliant(algName, key, null);
    }

    public static boolean isEncryptAlgoCompliant(String algName, Key key, AlgorithmParameters params) {
        if (algName == null || key == null) {
            return false;
        }
        int keyLength = FIPSCompliance.getKeyLength(key, params);
        if (algName.equalsIgnoreCase("RSA")) {
            return keyLength >= 1024 && keyLength <= 4096 && keyLength % 512 == 0;
        }
        if (algName.equalsIgnoreCase("DSA")) {
            return keyLength >= 512 && keyLength <= 1024 && keyLength % 64 == 0;
        }
        return false;
    }

    public static int getKeyLength(Key key) {
        return FIPSCompliance.getKeyLength(key, null);
    }

    public static int getKeyLength(Key key, AlgorithmParameters params) {
        String algo = key.getAlgorithm();
        try {
            BigInteger modulus = null;
            KeyFactory keyFac = KeyFactory.getInstance(algo, PKIOperations.getFIPSProvider());
            if (key instanceof PrivateKey) {
                if (algo.equalsIgnoreCase("RSA")) {
                    modulus = keyFac.getKeySpec(key, RSAPrivateKeySpec.class).getModulus();
                } else if (algo.equalsIgnoreCase("DSA")) {
                    modulus = keyFac.getKeySpec(key, DSAPrivateKeySpec.class).getP();
                }
            } else if (key instanceof PublicKey) {
                if (algo.equalsIgnoreCase("RSA")) {
                    modulus = keyFac.getKeySpec(key, RSAPublicKeySpec.class).getModulus();
                } else if (algo.equalsIgnoreCase("DSA")) {
                    DSAParameterSpec spec;
                    if (params != null && (spec = params.getParameterSpec(DSAParameterSpec.class)) != null) {
                        modulus = spec.getP();
                    }
                    if (modulus == null) {
                        modulus = keyFac.getKeySpec(key, DSAPublicKeySpec.class).getP();
                    }
                }
            }
            if (modulus != null) {
                return modulus.bitLength();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return -1;
    }

    public static Map<String, String> parseSignatureAlgo(String alg) {
        String[] rsaAlgos = alg.split("/");
        int jceBreaker = alg.indexOf("with");
        HashMap<String, String> output = new HashMap<String, String>();
        if (rsaAlgos.length >= 2) {
            output.put("digest", rsaAlgos[0]);
            output.put("encrypt", rsaAlgos[1]);
            if (rsaAlgos.length >= 3) {
                output.put("pad", rsaAlgos[2]);
            }
        }
        if (jceBreaker > 0) {
            output.put("digest", alg.substring(0, jceBreaker));
            output.put("encrypt", alg.substring(jceBreaker + 4));
        }
        return output;
    }

    public static boolean isSignatureAlgoFIPSCompliant(String alg, Key key) {
        return FIPSCompliance.isSignatureAlgoFIPSCompliant(alg, key, null);
    }

    public static boolean isSignatureAlgoFIPSCompliant(String alg, Key key, AlgorithmParameters params) {
        if (alg == null || key == null) {
            return false;
        }
        Map<String, String> map = FIPSCompliance.parseSignatureAlgo(alg);
        if (map.size() >= 2) {
            return FIPSCompliance.isDigestAlgoCompliant(map.get("digest")) && FIPSCompliance.isEncryptAlgoCompliant(map.get("encrypt"), key, params);
        }
        return false;
    }
}

