/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.livecycle.signatures.client.types;

import com.adobe.livecycle.signatures.pki.client.types.common.HashAlgorithm;
import com.adobe.livecycle.signatures.pki.client.types.common.RevocationCheckStyle;
import java.io.Serializable;

public class TSPOptionSpec
implements Serializable {
    private static final long serialVersionUID = -3920827908241085518L;
    private String tspServerURL;
    private boolean tspSendNonce;
    private HashAlgorithm tspHashAlgorithm;
    private Integer tspSize;
    private String tspServerUsername;
    private String tspServerPassword;
    private RevocationCheckStyle tspRevocationCheckStyle;
    public static final Integer MIN_TSP_SIZE = new Integer(64);
    public static final Integer MAX_TSP_SIZE = new Integer(10240);
    public static final Integer DEFAULT_TSP_SIZE = new Integer(4096);

    public TSPOptionSpec(RevocationCheckStyle revCheckStyle, HashAlgorithm hashAlgo, Integer tspSize, boolean sendNonce, String serverURL, String username, String password) {
        this.tspRevocationCheckStyle = revCheckStyle;
        this.tspHashAlgorithm = hashAlgo;
        this.tspSendNonce = sendNonce;
        this.tspServerURL = serverURL;
        this.tspServerPassword = password;
        this.tspServerUsername = username;
        this.tspSize = MIN_TSP_SIZE.compareTo(tspSize) > 0 || MAX_TSP_SIZE.compareTo(tspSize) < 0 ? DEFAULT_TSP_SIZE : tspSize;
    }

    public TSPOptionSpec() {
        this(RevocationCheckStyle.BestEffort, HashAlgorithm.SHA1, DEFAULT_TSP_SIZE, true, null, null, null);
    }

    public boolean isTspSendNonce() {
        return this.tspSendNonce;
    }

    public void setTspSendNonce(boolean sendNonce) {
        this.tspSendNonce = sendNonce;
    }

    public HashAlgorithm getTspHashAlgorithm() {
        return this.tspHashAlgorithm;
    }

    public void setTspHashAlgorithm(HashAlgorithm tspHashAlgorithm) {
        this.tspHashAlgorithm = tspHashAlgorithm;
    }

    public String getTspServerPassword() {
        return this.tspServerPassword;
    }

    public void setTspServerPassword(String tspServerPassword) {
        this.tspServerPassword = tspServerPassword;
    }

    public String getTspServerURL() {
        return this.tspServerURL;
    }

    public void setTspServerURL(String tspServerURL) {
        this.tspServerURL = tspServerURL;
    }

    public String getTspServerUsername() {
        return this.tspServerUsername;
    }

    public void setTspServerUsername(String tspServerUsername) {
        this.tspServerUsername = tspServerUsername;
    }

    public Integer getTspSize() {
        return this.tspSize;
    }

    public void setTspSize(Integer tspSize) {
        this.tspSize = tspSize;
    }

    public RevocationCheckStyle getTspRevocationCheckStyle() {
        return this.tspRevocationCheckStyle;
    }

    public void setTspRevocationCheckStyle(RevocationCheckStyle revocationCheckStyle) {
        this.tspRevocationCheckStyle = revocationCheckStyle;
    }
}

