/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.livecycle.signatures.client.types;

import com.adobe.livecycle.SinceLC;
import com.adobe.livecycle.signatures.client.types.CertificateInformation;
import com.adobe.livecycle.signatures.client.types.IdentityStatus;
import com.adobe.livecycle.signatures.pki.client.types.common.PathValidationFailureReason;
import java.io.ByteArrayInputStream;
import java.io.Serializable;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;

public class SignerCertificatePath
implements Serializable {
    private static final long serialVersionUID = 7219395461516586092L;
    private byte[][] certificateDER;
    private IdentityStatus status;
    private PathValidationFailureReason failureReason;
    private CertificateInformation[] certificateInformation;

    public byte[][] getCertificateDER() {
        return this.certificateDER;
    }

    public void setCertificateDER(byte[][] certificateDER) {
        this.certificateDER = certificateDER;
    }

    public PathValidationFailureReason getFailureReason() {
        return this.failureReason;
    }

    public void setFailureReason(PathValidationFailureReason failureReason) {
        this.failureReason = failureReason;
    }

    public IdentityStatus getStatus() {
        return this.status;
    }

    public void setStatus(IdentityStatus status) {
        this.status = status;
    }

    public String toString() {
        StringBuffer strBuff = new StringBuffer();
        if (this.certificateDER != null) {
            try {
                for (int i = 0; i < this.certificateDER.length; ++i) {
                    X509Certificate cert = (X509Certificate)CertificateFactory.getInstance("X509").generateCertificate(new ByteArrayInputStream(this.certificateDER[i]));
                    strBuff.append("Cert " + i);
                    strBuff.append("\t Subject Name:\t" + cert.getSubjectDN().getName());
                    strBuff.append("\t Issuer Name:\t" + cert.getIssuerDN().getName());
                    strBuff.append("\t Start Date:\t" + cert.getNotBefore());
                    strBuff.append("\t End Date:\t" + cert.getNotAfter());
                }
                strBuff.append("Path Status = " + (Object)((Object)this.status));
                strBuff.append("Failure Reason = " + (Object)((Object)this.failureReason));
            }
            catch (CertificateException e) {
                e.printStackTrace();
            }
        }
        return strBuff.toString();
    }

    @SinceLC(value="8.2.1")
    public CertificateInformation[] getCertificateInformation() {
        return this.certificateInformation;
    }

    public void setCertificateInformation(CertificateInformation[] certificateInfo) {
        this.certificateInformation = certificateInfo;
    }
}

