/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.livecycle.signatures.client;

import com.adobe.idp.Document;
import com.adobe.idp.dsc.DSCException;
import com.adobe.idp.dsc.InvocationRequest;
import com.adobe.idp.dsc.InvocationResponse;
import com.adobe.idp.dsc.clientsdk.ServiceClientFactory;
import com.adobe.livecycle.signatures.client.SignatureServiceClientInterface;
import com.adobe.livecycle.signatures.client.SignaturesOtherException;
import com.adobe.livecycle.signatures.client.types.CRLOptionSpec;
import com.adobe.livecycle.signatures.client.types.Credential;
import com.adobe.livecycle.signatures.client.types.FieldMDPOptionSpec;
import com.adobe.livecycle.signatures.client.types.MDPPermissions;
import com.adobe.livecycle.signatures.client.types.OCSPOptionSpec;
import com.adobe.livecycle.signatures.client.types.PDFLegalWarnings;
import com.adobe.livecycle.signatures.client.types.PDFSeedValueOptionSpec;
import com.adobe.livecycle.signatures.client.types.PDFSignature;
import com.adobe.livecycle.signatures.client.types.PDFSignatureAppearanceOptionSpec;
import com.adobe.livecycle.signatures.client.types.PDFSignatureField;
import com.adobe.livecycle.signatures.client.types.PDFSignatureFieldProperties;
import com.adobe.livecycle.signatures.client.types.PDFSignatureVerificationResult;
import com.adobe.livecycle.signatures.client.types.PathValidationOptionSpec;
import com.adobe.livecycle.signatures.client.types.PositionRectangle;
import com.adobe.livecycle.signatures.client.types.TSPOptionSpec;
import com.adobe.livecycle.signatures.client.types.VerificationTime;
import com.adobe.livecycle.signatures.client.types.XMLSignatureVerificationResult;
import com.adobe.livecycle.signatures.client.types.exceptions.CredentialLoginException;
import com.adobe.livecycle.signatures.client.types.exceptions.DuplicateSignatureFieldException;
import com.adobe.livecycle.signatures.client.types.exceptions.FIPSComplianceException;
import com.adobe.livecycle.signatures.client.types.exceptions.InvalidArgumentException;
import com.adobe.livecycle.signatures.client.types.exceptions.MissingSignatureFieldException;
import com.adobe.livecycle.signatures.client.types.exceptions.NoCertifyingSignatureException;
import com.adobe.livecycle.signatures.client.types.exceptions.PDFOperationException;
import com.adobe.livecycle.signatures.client.types.exceptions.PermissionsException;
import com.adobe.livecycle.signatures.client.types.exceptions.SeedValueValidationException;
import com.adobe.livecycle.signatures.client.types.exceptions.SignatureFieldNotSignedException;
import com.adobe.livecycle.signatures.client.types.exceptions.SignatureFieldSignedException;
import com.adobe.livecycle.signatures.client.types.exceptions.SignatureVerifyException;
import com.adobe.livecycle.signatures.client.types.exceptions.SigningException;
import com.adobe.livecycle.signatures.pki.client.types.common.HashAlgorithm;
import com.adobe.livecycle.signatures.pki.client.types.common.RevocationCheckStyle;
import java.io.Serializable;
import java.util.HashMap;
import java.util.List;

public class SignatureServiceClient
implements SignatureServiceClientInterface {
    private String serviceName = "SignatureService";
    private ServiceClientFactory m_serviceFactory;

    public SignatureServiceClient(ServiceClientFactory m_serviceFactory) {
        this.m_serviceFactory = m_serviceFactory;
    }

    public SignatureServiceClient(ServiceClientFactory m_serviceFactory, String serviceName) {
        this.m_serviceFactory = m_serviceFactory;
        this.serviceName = serviceName;
    }

    public Document sign(Document inPDFDoc, String signatureFieldName, Credential credential, HashAlgorithm hashAlgorithm, String reason, String location, String contactInfo, PDFSignatureAppearanceOptionSpec appearanceOptionSpec, Boolean embedRevocationInfo, OCSPOptionSpec ocspOptionSpec, CRLOptionSpec crlOptionSpec, TSPOptionSpec tspOptionSpec) throws PDFOperationException, SigningException, PermissionsException, InvalidArgumentException, SeedValueValidationException, MissingSignatureFieldException, SignatureFieldSignedException, CredentialLoginException, SignaturesOtherException, FIPSComplianceException {
        String opern = "sign";
        HashMap<String, Object> m_inputParams = new HashMap<String, Object>();
        m_inputParams.put(SignParameters.IN_DOC, inPDFDoc);
        m_inputParams.put(SignParameters.SIGNATURE_FIELD_NAME, signatureFieldName);
        m_inputParams.put(SignParameters.CREDENTIAL, credential);
        m_inputParams.put(SignParameters.HASHALGORITHM, (Object)hashAlgorithm);
        m_inputParams.put(SignParameters.REASON, reason);
        m_inputParams.put(SignParameters.LOCATION, location);
        m_inputParams.put(SignParameters.CONTACT_INFO, contactInfo);
        m_inputParams.put(SignParameters.APPEARANCEOPTIONSPEC, appearanceOptionSpec);
        m_inputParams.put(SignParameters.EMBEDREVOCATIONINFO, embedRevocationInfo);
        m_inputParams.put(SignParameters.OCSPOPTIONSPEC, ocspOptionSpec);
        m_inputParams.put(SignParameters.CRLOPTIONSPEC, crlOptionSpec);
        m_inputParams.put(SignParameters.TSPOPTIONSPEC, tspOptionSpec);
        InvocationRequest m_request = this.m_serviceFactory.createInvocationRequest(this.serviceName, opern, m_inputParams, true);
        try {
            InvocationResponse m_response = this.m_serviceFactory.getServiceClient().invoke(m_request);
            Document outDoc = (Document)m_response.getOutputParameter(SignParameters.OUTPUT_PDF);
            return outDoc;
        }
        catch (DSCException e) {
            Throwable cause = e;
            while ((cause = cause.getCause()) != null) {
                System.out.println(cause.getMessage());
                this.getDSSMissingSignatureFieldException(cause);
                this.getDSSInvalidArgumentException(cause);
                this.getDSSCredentialLoginException(cause);
                this.getDSSPDFOperationException(cause);
                this.getDSSPermissionsException(cause);
                this.getDSSSigningException(cause);
                this.getDSSSeedValueValidationException(cause);
                this.getDSSSignatureFieldException(cause);
                this.getDSSFIPSComplianceException(cause);
            }
            throw new SignaturesOtherException(e);
        }
    }

    public Document certify(Document inPDFDoc, String signatureFieldName, Credential credential, HashAlgorithm hashAlgorithm, String reason, String location, String contactInfo, MDPPermissions mdpPermissions, String legalAttestation, PDFSignatureAppearanceOptionSpec appearanceOptionSpec, Boolean embedRevocationInfo, Boolean lockCertifyingField, OCSPOptionSpec ocspOptionSpec, CRLOptionSpec crlOptionSpec, TSPOptionSpec tspOptionSpec) throws PDFOperationException, SigningException, PermissionsException, InvalidArgumentException, SeedValueValidationException, MissingSignatureFieldException, SignatureFieldSignedException, CredentialLoginException, SignaturesOtherException, FIPSComplianceException {
        String opern = "certify";
        HashMap<String, Object> m_inputParams = new HashMap<String, Object>();
        m_inputParams.put(CertifyParameters.IN_DOC, inPDFDoc);
        m_inputParams.put(CertifyParameters.SIGNATURE_FIELD_NAME, signatureFieldName);
        m_inputParams.put(CertifyParameters.CREDENTIAL, credential);
        m_inputParams.put(CertifyParameters.HASHALGORITHM, (Object)hashAlgorithm);
        m_inputParams.put(CertifyParameters.REASON, reason);
        m_inputParams.put(CertifyParameters.LOCATION, location);
        m_inputParams.put(CertifyParameters.CONTACT_INFO, contactInfo);
        m_inputParams.put(CertifyParameters.MDP_PERMISSIONS, (Object)mdpPermissions);
        m_inputParams.put(CertifyParameters.LEGAL_ATTESTATION, legalAttestation);
        m_inputParams.put(CertifyParameters.APPEARANCEOPTIONSPEC, appearanceOptionSpec);
        m_inputParams.put(CertifyParameters.EMBEDREVOCATIONINFO, embedRevocationInfo);
        m_inputParams.put(CertifyParameters.LOCKCERTIFYINGFIELD, lockCertifyingField);
        m_inputParams.put(CertifyParameters.OCSPOPTIONSPEC, ocspOptionSpec);
        m_inputParams.put(CertifyParameters.CRLOPTIONSPEC, crlOptionSpec);
        m_inputParams.put(CertifyParameters.TSPOPTIONSPEC, tspOptionSpec);
        InvocationRequest m_request = this.m_serviceFactory.createInvocationRequest(this.serviceName, opern, m_inputParams, true);
        try {
            InvocationResponse m_response = this.m_serviceFactory.getServiceClient().invoke(m_request);
            Document outDoc = (Document)m_response.getOutputParameter(CertifyParameters.OUTPUT_PDF);
            return outDoc;
        }
        catch (DSCException e) {
            Throwable cause = e;
            while ((cause = cause.getCause()) != null) {
                System.out.println(cause.getMessage());
                this.getDSSMissingSignatureFieldException(cause);
                this.getDSSInvalidArgumentException(cause);
                this.getDSSCredentialLoginException(cause);
                this.getDSSPDFOperationException(cause);
                this.getDSSPermissionsException(cause);
                this.getDSSSigningException(cause);
                this.getDSSSeedValueValidationException(cause);
                this.getDSSSignatureFieldException(cause);
                this.getDSSFIPSComplianceException(cause);
            }
            throw new SignaturesOtherException(e);
        }
    }

    public Document addSignatureField(Document inPDFDoc, String signatureFieldName, Integer pageNumber, PositionRectangle positionRectangle, FieldMDPOptionSpec fieldMDPOptionsSpec, PDFSeedValueOptionSpec seedValueOptionsSpec) throws PDFOperationException, PermissionsException, InvalidArgumentException, DuplicateSignatureFieldException, SignaturesOtherException {
        String opern = "addSignatureField";
        HashMap<String, Object> m_inputParams = new HashMap<String, Object>();
        m_inputParams.put(AddSignatureFieldParameters.INPUT_PDF, inPDFDoc);
        m_inputParams.put(AddSignatureFieldParameters.SIGNATURE_FIELD_NAME, signatureFieldName);
        m_inputParams.put(AddSignatureFieldParameters.PAGE_NUMBER, pageNumber);
        m_inputParams.put(AddSignatureFieldParameters.POSITION_RECTANGLE, positionRectangle);
        m_inputParams.put(AddSignatureFieldParameters.FIELD_MDP_OPTIONS, fieldMDPOptionsSpec);
        m_inputParams.put(AddSignatureFieldParameters.SEED_VALUE_OPTIONS, seedValueOptionsSpec);
        InvocationRequest m_request = this.m_serviceFactory.createInvocationRequest(this.serviceName, opern, m_inputParams, true);
        try {
            InvocationResponse m_response = this.m_serviceFactory.getServiceClient().invoke(m_request);
            Document outDoc = (Document)m_response.getOutputParameter(AddSignatureFieldParameters.OUTPUT_PDF);
            return outDoc;
        }
        catch (DSCException e) {
            Throwable cause = e;
            while ((cause = cause.getCause()) != null) {
                System.out.println(cause.getMessage());
                this.getDSSPDFOperationException(cause);
                this.getDSSPermissionsException(cause);
                this.getDSSInvalidArgumentException(cause);
                this.getDSSDuplicateSignatureFieldException(cause);
            }
            throw new SignaturesOtherException(e);
        }
    }

    public Document modifySignatureField(Document inPDFDoc, String signatureFieldName, PDFSignatureFieldProperties pdfSignatureFieldProperties) throws InvalidArgumentException, PDFOperationException, PermissionsException, MissingSignatureFieldException, SignatureFieldSignedException, SignaturesOtherException {
        String opern = "modifySignatureField";
        HashMap<String, Object> m_inputParams = new HashMap<String, Object>();
        m_inputParams.put(ModifySignatureFieldParameters.INPUT_PDF, inPDFDoc);
        m_inputParams.put("signatureFieldName", signatureFieldName);
        m_inputParams.put(ModifySignatureFieldParameters.SIGNATURE_FIELD_PROPERTIES, pdfSignatureFieldProperties);
        InvocationRequest m_request = this.m_serviceFactory.createInvocationRequest(this.serviceName, opern, m_inputParams, true);
        try {
            InvocationResponse m_response = this.m_serviceFactory.getServiceClient().invoke(m_request);
            Document outDoc = (Document)m_response.getOutputParameter(AddSignatureFieldParameters.OUTPUT_PDF);
            return outDoc;
        }
        catch (DSCException e) {
            Throwable cause = e;
            while ((cause = cause.getCause()) != null) {
                System.out.println(cause.getMessage());
                this.getDSSPDFOperationException(cause);
                this.getDSSPermissionsException(cause);
                this.getDSSInvalidArgumentException(cause);
                this.getDSSMissingSignatureFieldException(cause);
                this.getDSSSignatureFieldException(cause);
            }
            throw new SignaturesOtherException(e);
        }
    }

    public Document addInvisibleSignatureField(Document inPDFDoc, String signatureFieldName, FieldMDPOptionSpec fieldMDPOptionsSpec, PDFSeedValueOptionSpec seedValueOptionsSpec) throws PDFOperationException, PermissionsException, InvalidArgumentException, DuplicateSignatureFieldException, SignaturesOtherException {
        String opern = "addInvisibleSignatureField";
        HashMap<String, Object> m_inputParams = new HashMap<String, Object>();
        m_inputParams.put(AddInvisibleSignatureField.INPUT_PDF, inPDFDoc);
        m_inputParams.put(AddInvisibleSignatureField.SIGNATURE_FIELD_NAME, signatureFieldName);
        m_inputParams.put(AddInvisibleSignatureField.FIELD_MDP_OPTIONS, fieldMDPOptionsSpec);
        m_inputParams.put(AddInvisibleSignatureField.SEED_VALUE_OPTIONS, seedValueOptionsSpec);
        InvocationRequest m_request = this.m_serviceFactory.createInvocationRequest(this.serviceName, opern, m_inputParams, true);
        try {
            InvocationResponse m_response = this.m_serviceFactory.getServiceClient().invoke(m_request);
            Document outDoc = (Document)m_response.getOutputParameter(AddInvisibleSignatureField.OUTPUT_PDF);
            return outDoc;
        }
        catch (DSCException e) {
            Throwable cause = e;
            while ((cause = cause.getCause()) != null) {
                System.out.println(cause.getMessage());
                this.getDSSPDFOperationException(cause);
                this.getDSSPermissionsException(cause);
                this.getDSSInvalidArgumentException(cause);
                this.getDSSDuplicateSignatureFieldException(cause);
            }
            throw new SignaturesOtherException(e);
        }
    }

    public Document clearSignatureField(Document inPDFDoc, String signatureFieldName) throws PDFOperationException, PermissionsException, InvalidArgumentException, MissingSignatureFieldException, SignaturesOtherException {
        String opern = "clearSignatureField";
        HashMap<String, Object> m_inputParams = new HashMap<String, Object>();
        m_inputParams.put(ClearSignatureFieldParameters.INPUT_PDF, inPDFDoc);
        m_inputParams.put(ClearSignatureFieldParameters.SIGNATURE_FIELD_NAME, signatureFieldName);
        InvocationRequest m_request = this.m_serviceFactory.createInvocationRequest(this.serviceName, opern, m_inputParams, true);
        try {
            InvocationResponse m_response = this.m_serviceFactory.getServiceClient().invoke(m_request);
            Document outDoc = (Document)m_response.getOutputParameter(ClearSignatureFieldParameters.OUTPUT_PDF);
            return outDoc;
        }
        catch (DSCException e) {
            Throwable cause = e;
            while ((cause = cause.getCause()) != null) {
                System.out.println(cause.getMessage());
                this.getDSSPDFOperationException(cause);
                this.getDSSPermissionsException(cause);
                this.getDSSMissingSignatureFieldException(cause);
                this.getDSSInvalidArgumentException(cause);
            }
            throw new SignaturesOtherException(e);
        }
    }

    public PDFSignatureField getCertifyingSignatureField(Document inPDFDoc) throws PDFOperationException, InvalidArgumentException, NoCertifyingSignatureException, PermissionsException, SignaturesOtherException {
        String opern = "getCertifyingSignatureField";
        HashMap<String, Document> m_inputParams = new HashMap<String, Document>();
        m_inputParams.put(GetCertifyingSignatureFieldParameters.INPUT_PDF, inPDFDoc);
        InvocationRequest m_request = this.m_serviceFactory.createInvocationRequest(this.serviceName, opern, m_inputParams, true);
        try {
            InvocationResponse m_response = this.m_serviceFactory.getServiceClient().invoke(m_request);
            PDFSignatureField pdfSigFieldInfo = (PDFSignatureField)m_response.getOutputParameter(GetCertifyingSignatureFieldParameters.PDF_SIGNATURE_FIELD_INFO);
            return pdfSigFieldInfo;
        }
        catch (DSCException e) {
            Throwable cause = e;
            while ((cause = cause.getCause()) != null) {
                System.out.println(cause.getMessage());
                this.getDSSPDFOperationException(cause);
                this.getDSSPermissionsException(cause);
                this.getDSSInvalidArgumentException(cause);
                this.getDSSNoCertifyingSignatureException(cause);
            }
            throw new SignaturesOtherException(e);
        }
    }

    public PDFSignature getSignature(Document inPDFDoc, String signatureFieldName) throws PDFOperationException, PermissionsException, InvalidArgumentException, MissingSignatureFieldException, SignatureFieldNotSignedException, SignaturesOtherException {
        String opern = "getSignature";
        HashMap<String, Object> m_inputParams = new HashMap<String, Object>();
        m_inputParams.put(GetSignatureParameters.INPUT_PDF, inPDFDoc);
        m_inputParams.put(GetSignatureParameters.SIGNATURE_FIELD_NAME, signatureFieldName);
        InvocationRequest m_request = this.m_serviceFactory.createInvocationRequest(this.serviceName, opern, m_inputParams, true);
        try {
            InvocationResponse m_response = this.m_serviceFactory.getServiceClient().invoke(m_request);
            PDFSignature pdfSig = (PDFSignature)m_response.getOutputParameter(GetSignatureParameters.PDF_SIGNATURE);
            return pdfSig;
        }
        catch (DSCException e) {
            Throwable cause = e;
            while ((cause = cause.getCause()) != null) {
                System.out.println(cause.getMessage());
                this.getDSSPDFOperationException(cause);
                this.getDSSPermissionsException(cause);
                this.getDSSInvalidArgumentException(cause);
                this.getDSSMissingSignatureFieldException(cause);
                this.getDSSSignatureFieldNotSignedException(cause);
            }
            throw new SignaturesOtherException(e);
        }
    }

    public Document getSignedVersion(Document inPDFDoc, String signatureFieldName) throws PDFOperationException, PermissionsException, InvalidArgumentException, MissingSignatureFieldException, SignatureFieldNotSignedException, SignaturesOtherException {
        String opern = "getSignedVersion";
        HashMap<String, Object> m_inputParams = new HashMap<String, Object>();
        m_inputParams.put(GetSignedVersionParameters.INPUT_PDF, inPDFDoc);
        m_inputParams.put(GetSignedVersionParameters.SIGNATURE_FIELD_NAME, signatureFieldName);
        InvocationRequest m_request = this.m_serviceFactory.createInvocationRequest(this.serviceName, opern, m_inputParams, true);
        try {
            InvocationResponse m_response = this.m_serviceFactory.getServiceClient().invoke(m_request);
            Document outDoc = (Document)m_response.getOutputParameter(GetSignedVersionParameters.OUTPUT_PDF);
            return outDoc;
        }
        catch (DSCException e) {
            Throwable cause = e;
            while ((cause = cause.getCause()) != null) {
                System.out.println(cause.getMessage());
                this.getDSSPDFOperationException(cause);
                this.getDSSPermissionsException(cause);
                this.getDSSMissingSignatureFieldException(cause);
                this.getDSSInvalidArgumentException(cause);
                this.getDSSSignatureFieldNotSignedException(cause);
            }
            throw new SignaturesOtherException(e);
        }
    }

    public Document removeSignatureField(Document inPDFDoc, String signatureFieldName) throws PDFOperationException, PermissionsException, InvalidArgumentException, MissingSignatureFieldException, SignatureFieldSignedException, SignaturesOtherException {
        String opern = "removeSignatureField";
        HashMap<String, Object> m_inputParams = new HashMap<String, Object>();
        m_inputParams.put(RemoveSignatureParameters.INPUT_PDF, inPDFDoc);
        m_inputParams.put(RemoveSignatureParameters.SIGNATURE_FIELD_NAME, signatureFieldName);
        InvocationRequest m_request = this.m_serviceFactory.createInvocationRequest(this.serviceName, opern, m_inputParams, true);
        try {
            InvocationResponse m_response = this.m_serviceFactory.getServiceClient().invoke(m_request);
            Document outDoc = (Document)m_response.getOutputParameter(RemoveSignatureParameters.OUTPUT_PDF);
            return outDoc;
        }
        catch (DSCException e) {
            Throwable cause = e;
            while ((cause = cause.getCause()) != null) {
                System.out.println(cause.getMessage());
                this.getDSSPDFOperationException(cause);
                this.getDSSPermissionsException(cause);
                this.getDSSMissingSignatureFieldException(cause);
                this.getDSSInvalidArgumentException(cause);
                this.getDSSSignatureFieldSignedException(cause);
            }
            throw new SignaturesOtherException(e);
        }
    }

    public PDFSignatureVerificationResult verify(Document inPDFDoc, String signatureFieldName, RevocationCheckStyle revocationCheckStyle, VerificationTime verificationTime, OCSPOptionSpec ocspOptionSpec, CRLOptionSpec crlOptionSpec, TSPOptionSpec tspOptionSpec, PathValidationOptionSpec pathValidationOptionSpec, HashMap spiProperties) throws PDFOperationException, InvalidArgumentException, MissingSignatureFieldException, SignatureFieldNotSignedException, SignatureVerifyException, PermissionsException, SignaturesOtherException {
        String opern = "verify";
        HashMap<String, Object> m_inputParams = new HashMap<String, Object>();
        m_inputParams.put(VerifyParameters.IN_DOC, inPDFDoc);
        m_inputParams.put(VerifyParameters.SIGNATURE_FIELD_NAME, signatureFieldName);
        m_inputParams.put(VerifyParameters.REVOCATION_CHECK_STYLE, (Object)revocationCheckStyle);
        m_inputParams.put(VerifyParameters.VERIFICATION_TIME, (Object)verificationTime);
        m_inputParams.put(VerifyParameters.OCSPOPTIONSPEC, ocspOptionSpec);
        m_inputParams.put(VerifyParameters.CRLOPTIONSPEC, crlOptionSpec);
        m_inputParams.put(VerifyParameters.TSPOPTIONSPEC, tspOptionSpec);
        m_inputParams.put(VerifyParameters.PATHVALIDATIONOPTIONSPEC, pathValidationOptionSpec);
        m_inputParams.put(VerifyParameters.SPIPROPERTIES, spiProperties);
        InvocationRequest m_request = this.m_serviceFactory.createInvocationRequest(this.serviceName, opern, m_inputParams, true);
        try {
            InvocationResponse m_response = this.m_serviceFactory.getServiceClient().invoke(m_request);
            PDFSignatureVerificationResult pdfSigInfo = (PDFSignatureVerificationResult)m_response.getOutputParameter(VerifyParameters.PDF_SIGNATURE_INFO);
            return pdfSigInfo;
        }
        catch (DSCException e) {
            Throwable cause = e;
            while ((cause = cause.getCause()) != null) {
                System.out.println(cause.getMessage());
                this.getDSSMissingSignatureFieldException(cause);
                this.getDSSInvalidArgumentException(cause);
                this.getDSSPDFOperationException(cause);
                this.getDSSPermissionsException(cause);
                this.getDSSSignatureFieldNotSignedException(cause);
                this.getDSSSignatureVerifyException(cause);
            }
            throw new SignaturesOtherException(e);
        }
    }

    public PDFSignatureVerificationResult verify(Document inPDFDoc, String signatureFieldName, RevocationCheckStyle revocationCheckStyle, VerificationTime verificationTime, OCSPOptionSpec ocspOptionSpec, CRLOptionSpec crlOptionSpec, TSPOptionSpec tspOptionSpec, PathValidationOptionSpec pathValidationOptionSpec) throws PDFOperationException, InvalidArgumentException, MissingSignatureFieldException, SignatureFieldNotSignedException, SignatureVerifyException, PermissionsException, SignaturesOtherException {
        return this.verify(inPDFDoc, signatureFieldName, revocationCheckStyle, verificationTime, ocspOptionSpec, crlOptionSpec, tspOptionSpec, pathValidationOptionSpec, null);
    }

    public XMLSignatureVerificationResult verifyXMLSignature(Document inXMLDoc, String signatureFieldName, RevocationCheckStyle revocationCheckStyle, VerificationTime verificationTime, OCSPOptionSpec ocspOptionSpec, CRLOptionSpec crlOptionSpec, PathValidationOptionSpec pathValidationOptionSpec) throws SignatureVerifyException, InvalidArgumentException, MissingSignatureFieldException, SignaturesOtherException {
        String opern = "verifyXMLSignature";
        HashMap<String, Object> m_inputParams = new HashMap<String, Object>();
        m_inputParams.put(VerifyXMLParameters.IN_DOC, inXMLDoc);
        m_inputParams.put(VerifyXMLParameters.SIGNATURE_FIELD_NAME, signatureFieldName);
        m_inputParams.put(VerifyXMLParameters.REVOCATION_CHECK_STYLE, (Object)revocationCheckStyle);
        m_inputParams.put(VerifyXMLParameters.VERIFICATION_TIME, (Object)verificationTime);
        m_inputParams.put(VerifyXMLParameters.OCSPOPTIONSPEC, ocspOptionSpec);
        m_inputParams.put(VerifyXMLParameters.CRLOPTIONSPEC, crlOptionSpec);
        m_inputParams.put(VerifyXMLParameters.PATHVALIDATIONOPTIONSPEC, pathValidationOptionSpec);
        InvocationRequest m_request = this.m_serviceFactory.createInvocationRequest(this.serviceName, opern, m_inputParams, true);
        try {
            InvocationResponse m_response = this.m_serviceFactory.getServiceClient().invoke(m_request);
            XMLSignatureVerificationResult pdfSigInfo = (XMLSignatureVerificationResult)m_response.getOutputParameter(VerifyXMLParameters.XML_SIGNATURE_INFO);
            return pdfSigInfo;
        }
        catch (DSCException e) {
            Throwable cause = e;
            while ((cause = cause.getCause()) != null) {
                System.out.println(cause.getMessage());
                this.getDSSMissingSignatureFieldException(cause);
                this.getDSSInvalidArgumentException(cause);
                this.getDSSSignatureVerifyException(cause);
            }
            throw new SignaturesOtherException(e);
        }
    }

    public PDFLegalWarnings getLegalAttestation(Document inPDFDoc, Boolean generateOnTheFly) throws PDFOperationException, InvalidArgumentException, NoCertifyingSignatureException, PermissionsException, SignaturesOtherException {
        String opern = "getLegalAttestation";
        HashMap<String, Serializable> m_inputParams = new HashMap<String, Serializable>();
        m_inputParams.put(GetLegalAttestationParameters.IN_DOC, inPDFDoc);
        m_inputParams.put(GetLegalAttestationParameters.GENERATE_ON_THE_FLY, generateOnTheFly);
        InvocationRequest m_request = this.m_serviceFactory.createInvocationRequest(this.serviceName, opern, m_inputParams, true);
        try {
            InvocationResponse m_response = this.m_serviceFactory.getServiceClient().invoke(m_request);
            PDFLegalWarnings legalWarnings = (PDFLegalWarnings)m_response.getOutputParameter(GetLegalAttestationParameters.LEGAL_ATTESTATION_MAP);
            return legalWarnings;
        }
        catch (DSCException e) {
            Throwable cause = e;
            while ((cause = cause.getCause()) != null) {
                this.getDSSPDFOperationException(cause);
                this.getDSSInvalidArgumentException(cause);
                this.getDSSNoCertifyingSignatureException(cause);
                this.getDSSPermissionsException(cause);
            }
            throw new SignaturesOtherException(e);
        }
    }

    public List getSignatureFieldList(Document inPDFDoc) throws PDFOperationException, InvalidArgumentException, PermissionsException, SignaturesOtherException {
        String opern = "getSignatureFieldList";
        HashMap<String, Document> m_inputParams = new HashMap<String, Document>();
        m_inputParams.put(GetSignatureFieldListParameters.IN_DOC, inPDFDoc);
        InvocationRequest m_request = this.m_serviceFactory.createInvocationRequest(this.serviceName, opern, m_inputParams, true);
        try {
            InvocationResponse m_response = this.m_serviceFactory.getServiceClient().invoke(m_request);
            List signatureFieldList = (List)m_response.getOutputParameter(GetSignatureFieldListParameters.SIGNATURE_FIELD_LIST);
            return signatureFieldList;
        }
        catch (DSCException e) {
            Throwable cause = e;
            while ((cause = cause.getCause()) != null) {
                this.getDSSPDFOperationException(cause);
                this.getDSSInvalidArgumentException(cause);
                this.getDSSPermissionsException(cause);
            }
            throw new SignaturesOtherException(e);
        }
    }

    private void getDSSSignatureFieldException(Throwable cause) throws SignatureFieldSignedException {
        if (cause instanceof SignatureFieldSignedException) {
            SignatureFieldSignedException de = (SignatureFieldSignedException)cause;
            throw de;
        }
    }

    private void getDSSSeedValueValidationException(Throwable cause) throws SeedValueValidationException {
        if (cause instanceof SeedValueValidationException) {
            SeedValueValidationException de = (SeedValueValidationException)cause;
            throw de;
        }
    }

    private void getDSSSigningException(Throwable cause) throws SigningException {
        if (cause instanceof SigningException) {
            SigningException de = (SigningException)cause;
            throw de;
        }
    }

    private void getDSSPermissionsException(Throwable cause) throws PermissionsException {
        if (cause instanceof PermissionsException) {
            PermissionsException de = (PermissionsException)cause;
            throw de;
        }
    }

    private void getDSSPDFOperationException(Throwable cause) throws PDFOperationException {
        if (cause instanceof PDFOperationException) {
            PDFOperationException de = (PDFOperationException)cause;
            throw de;
        }
    }

    private void getDSSCredentialLoginException(Throwable cause) throws CredentialLoginException {
        if (cause instanceof CredentialLoginException) {
            CredentialLoginException de = (CredentialLoginException)cause;
            throw de;
        }
    }

    private void getDSSInvalidArgumentException(Throwable cause) throws InvalidArgumentException {
        if (cause instanceof InvalidArgumentException) {
            InvalidArgumentException de = (InvalidArgumentException)cause;
            throw de;
        }
    }

    private void getDSSMissingSignatureFieldException(Throwable cause) throws MissingSignatureFieldException {
        if (cause instanceof MissingSignatureFieldException) {
            MissingSignatureFieldException de = (MissingSignatureFieldException)cause;
            throw de;
        }
    }

    private void getDSSSignatureFieldSignedException(Throwable cause) throws SignatureFieldSignedException {
        if (cause instanceof SignatureFieldSignedException) {
            SignatureFieldSignedException de = (SignatureFieldSignedException)cause;
            throw de;
        }
    }

    private void getDSSDuplicateSignatureFieldException(Throwable cause) throws DuplicateSignatureFieldException {
        if (cause instanceof DuplicateSignatureFieldException) {
            DuplicateSignatureFieldException de = (DuplicateSignatureFieldException)cause;
            throw de;
        }
    }

    private void getDSSNoCertifyingSignatureException(Throwable cause) throws NoCertifyingSignatureException {
        if (cause instanceof NoCertifyingSignatureException) {
            NoCertifyingSignatureException de = (NoCertifyingSignatureException)cause;
            throw de;
        }
    }

    private void getDSSSignatureFieldNotSignedException(Throwable cause) throws SignatureFieldNotSignedException {
        if (cause instanceof SignatureFieldNotSignedException) {
            SignatureFieldNotSignedException de = (SignatureFieldNotSignedException)cause;
            throw de;
        }
    }

    private void getDSSSignatureVerifyException(Throwable cause) throws SignatureVerifyException {
        if (cause instanceof SignatureVerifyException) {
            SignatureVerifyException de = (SignatureVerifyException)cause;
            throw de;
        }
    }

    private void getDSSFIPSComplianceException(Throwable cause) throws FIPSComplianceException {
        if (cause instanceof FIPSComplianceException) {
            FIPSComplianceException de = (FIPSComplianceException)cause;
            throw de;
        }
    }

    private static class GetSignatureFieldListParameters {
        public static String IN_DOC = "inPDFDoc";
        public static String SIGNATURE_FIELD_LIST = "pdfSignatureFieldList";

        private GetSignatureFieldListParameters() {
        }
    }

    private static class GetLegalAttestationParameters {
        public static String IN_DOC = "inPDFDoc";
        public static String GENERATE_ON_THE_FLY = "generateOnTheFly";
        public static String LEGAL_ATTESTATION_MAP = "legalWarningsResult";

        private GetLegalAttestationParameters() {
        }
    }

    private static class VerifyXMLParameters {
        public static String IN_DOC = "inXMLDoc";
        public static String SIGNATURE_FIELD_NAME = "signatureFieldName";
        public static String REVOCATION_CHECK_STYLE = "revocationCheckStyle";
        public static String VERIFICATION_TIME = "verificationTime";
        public static String OCSPOPTIONSPEC = "ocspOptionSpec";
        public static String CRLOPTIONSPEC = "crlOptionSpec";
        public static String PATHVALIDATIONOPTIONSPEC = "pathValidationOptionSpec";
        public static String XML_SIGNATURE_INFO = "xmlSignatureVerificationResult";

        private VerifyXMLParameters() {
        }
    }

    private static class VerifyParameters {
        public static String IN_DOC = "inPDFDoc";
        public static String SIGNATURE_FIELD_NAME = "signatureFieldName";
        public static String REVOCATION_CHECK_STYLE = "revocationCheckStyle";
        public static String VERIFICATION_TIME = "verificationTime";
        public static String OCSPOPTIONSPEC = "ocspOptionSpec";
        public static String CRLOPTIONSPEC = "crlOptionSpec";
        public static String TSPOPTIONSPEC = "tspOptionSpec";
        public static String PATHVALIDATIONOPTIONSPEC = "pathValidationOptionSpec";
        public static String SPIPROPERTIES = "spiProperties";
        public static String PDF_SIGNATURE_INFO = "pdfSignatureVerificationResult";

        private VerifyParameters() {
        }
    }

    private static class RemoveSignatureParameters {
        public static String INPUT_PDF = "inPDFDoc";
        public static String SIGNATURE_FIELD_NAME = "signatureFieldName";
        public static String OUTPUT_PDF = "outPDFDoc";

        private RemoveSignatureParameters() {
        }
    }

    private static class GetSignedVersionParameters {
        public static String INPUT_PDF = "inPDFDoc";
        public static String SIGNATURE_FIELD_NAME = "signatureFieldName";
        public static String OUTPUT_PDF = "outPDFDoc";

        private GetSignedVersionParameters() {
        }
    }

    private static class GetSignatureParameters {
        public static String INPUT_PDF = "inPDFDoc";
        public static String SIGNATURE_FIELD_NAME = "signatureFieldName";
        public static String PDF_SIGNATURE = "pdfSignatureResult";

        private GetSignatureParameters() {
        }
    }

    private static class GetCertifyingSignatureFieldParameters {
        public static String INPUT_PDF = "inPDFDoc";
        public static String PDF_SIGNATURE_FIELD_INFO = "certifyingSignatureFieldResult";

        private GetCertifyingSignatureFieldParameters() {
        }
    }

    private static class ClearSignatureFieldParameters {
        public static String INPUT_PDF = "inPDFDoc";
        public static String SIGNATURE_FIELD_NAME = "signatureFieldName";
        public static String OUTPUT_PDF = "outPDFDoc";

        private ClearSignatureFieldParameters() {
        }
    }

    private static class AddInvisibleSignatureField {
        public static String INPUT_PDF = "inPDFDoc";
        public static String SIGNATURE_FIELD_NAME = "signatureFieldName";
        public static String FIELD_MDP_OPTIONS = "fieldMDPOptionsSpec";
        public static String SEED_VALUE_OPTIONS = "seedValueOptionsSpec";
        public static String OUTPUT_PDF = "outPDFDoc";

        private AddInvisibleSignatureField() {
        }
    }

    private static class ModifySignatureFieldParameters {
        public static String INPUT_PDF = "inPDFDoc";
        public static final String SIGNATURE_FIELD_NAME = "signatureFieldName";
        public static String SIGNATURE_FIELD_PROPERTIES = "pdfSignatureFieldProperties";
        public static String OUTPUT_PDF = "outPDFDoc";

        private ModifySignatureFieldParameters() {
        }
    }

    private static class AddSignatureFieldParameters {
        public static String INPUT_PDF = "inPDFDoc";
        public static String SIGNATURE_FIELD_NAME = "signatureFieldName";
        public static String PAGE_NUMBER = "pageNumber";
        public static String POSITION_RECTANGLE = "positionRectangle";
        public static String FIELD_MDP_OPTIONS = "fieldMDPOptionsSpec";
        public static String SEED_VALUE_OPTIONS = "seedValueOptionsSpec";
        public static String OUTPUT_PDF = "outPDFDoc";

        private AddSignatureFieldParameters() {
        }
    }

    private static class CertifyParameters {
        public static String IN_DOC = "inPDFDoc";
        public static String SIGNATURE_FIELD_NAME = "signatureFieldName";
        public static String CREDENTIAL = "credential";
        public static String HASHALGORITHM = "hashAlgorithm";
        public static String REASON = "reason";
        public static String LOCATION = "location";
        public static String CONTACT_INFO = "contactInfo";
        public static String MDP_PERMISSIONS = "mdpPermissions";
        public static String LEGAL_ATTESTATION = "legalAttestation";
        public static String APPEARANCEOPTIONSPEC = "appearanceOptionSpec";
        public static String EMBEDREVOCATIONINFO = "embedRevocationInfo";
        public static String LOCKCERTIFYINGFIELD = "lockCertifyingField";
        public static String OCSPOPTIONSPEC = "ocspOptionSpec";
        public static String CRLOPTIONSPEC = "crlOptionSpec";
        public static String TSPOPTIONSPEC = "tspOptionSpec";
        public static String OUTPUT_PDF = "outPDFDoc";

        private CertifyParameters() {
        }
    }

    private static class SignParameters {
        public static String IN_DOC = "inPDFDoc";
        public static String SIGNATURE_FIELD_NAME = "signatureFieldName";
        public static String CREDENTIAL = "credential";
        public static String HASHALGORITHM = "hashAlgorithm";
        public static String REASON = "reason";
        public static String LOCATION = "location";
        public static String CONTACT_INFO = "contactInfo";
        public static String APPEARANCEOPTIONSPEC = "appearanceOptionSpec";
        public static String EMBEDREVOCATIONINFO = "embedRevocationInfo";
        public static String OCSPOPTIONSPEC = "ocspOptionSpec";
        public static String CRLOPTIONSPEC = "crlOptionSpec";
        public static String TSPOPTIONSPEC = "tspOptionSpec";
        public static String OUTPUT_PDF = "outPDFDoc";

        private SignParameters() {
        }
    }
}

