package sample;

public class TTTGame {

    final public static int X = 10;
    final public static int O = 1;
    int[] board = {0, 0, 0, 0, 0, 0, 0, 0, 0};
    int turnNum = 0;
    int[][] wins = {{0, 1, 2}, {3, 4, 5,}, {6, 7, 8}, {0, 3, 6},
        {1, 4, 7}, {2, 5, 8}, {0, 4, 8}, {2, 4, 6}};
    int winner = -1;

    //return false if cell is an invalid move
    synchronized public boolean turn(int cell) {
        if (cell < 0 || cell > 8) {
            return false; // invalid move
        }
        if (winner != -1) {
            return false;
        }
        turnNum++;
        if (board[cell] != 0) {
            return false; // invalid move
        }
        if (turnNum % 2 == 1) { //then X
            board[cell] = X;
        } else { // else O
            board[cell] = O;
        }
        return true;
    }

    // return
    private int whoseTurn() {
        if (turnNum == 0 || turnNum % 2 == 0) {
            return X;
        } else {
            return O;
        }
    }

    private boolean done() {
        return (turnNum > 8);
    }


    // return -1 for no win, 0 for tie, 1 for x win, 2 for o win
    synchronized public int win() {
        if (winner != -1) {
            return winner;
        }
        for (int i = 0; i < 8; i++) {
            int winSum = board[wins[i][0]] + board[wins[i][1]] + board[wins[i][2]];
            if (winSum == 3) {
                winner = 2;
            } else if (winSum == 30) {
                winner = 1;
            }
        }
        if (winner == -1 && turnNum > 8) {
            winner = 0;
        }
        return winner;
    }

    private int[] getBoard() {
        return board;
    }

    /**
     * Create a JSON representation of the game state.  It will look something like this:
     * <code>
     * { "win": "-1", "board": ["0","0","0","0","0","0","0","0","0"] }
     * </code>
     * @return json
     */
    synchronized public String getJSON() {

        String response = "{" +
                "\"win\": \"" + win() + "\", \"board\": [";
        for (int i = 0; i < 9; i++) {
            response = response + "\"" + board[i] + "\"";
            if (i < 8) {  // no trailing comma
                response = response + ",";
            }
        }
        response = response + "]," + "\"turn\": " + whoseTurn() + " }";
        return response;

    }
}