
dojo.require("dojox.cometd");

var room = {    
    username: null,
    channel: "/chat/demo",

    join: function(name){
        dojox.cometd.init("cometd");
        room.username=name;
        dojo.byId('join').className='hidden';
        dojo.byId('joined').className='';
        dojo.byId('sendText').focus();
        dojox.cometd.subscribe(room.channel, room, "chatCallback");
        dojox.cometd.publish(room.channel, {
            user: room.username,
            text: " has joined"
        });
    },
    leave: function(){
        if (room.username==null)
            return;
        dojox.cometd.unsubscribe(room.channel, room, "chatCallback");
        dojox.cometd.publish(room.channel, {
            user: room.username,
            text: " has left"
        });
        dojox.cometd.disconnect();
        // switch the input form
        dojo.byId('join').className='';
        dojo.byId('joined').className='hidden';
        dojo.byId('sendName').focus();
        room.username=null;
    },      
    chat: function(text){
        dojox.cometd.publish(room.channel, {
            user: room.username,
            text: text
        });
    },
    next: function(text){
        dojox.cometd.publish(room.channel, {
            slide: text
        });
    },
    chatCallback: function(message){
        if(!message.data){
            alert("bad message format "+message);
            return;
        }
        var chat=dojo.byId('chat');
        var slide=dojo.byId('slide');
        var messageLog=dojo.byId('messageLog');
        var from=message.data.user;
        var text=message.data.text;
        var slideUrl=message.data.slide;
        from+=":";
        // display the next image, or chat text
        if(slideUrl){
            slide.innerHTML ="<img src='" + slideUrl + "' style='width: 540px; height: 380px;' />";
        }else{
            messageLog.innerHTML += "<span class=\"from\">"+from+"&nbsp;</span><span class=\"text\">"+text+"</span><br/>";
        }
        chat.scrollTop = chat.scrollHeight - chat.clientHeight;
    },
    //replace to make request to the slides web service
    loadSlides: function (){
        room.slideUrls=[
        "/slideshow/images/image0.jpg",
        "/slideshow/images/image1.jpg",
        "/slideshow/images/image2.jpg",
        "/slideshow/images/image3.jpg",
        "/slideshow/images/image4.jpg",
        "/slideshow/images/image5.jpg"];
    },
  
    init: function(){
        room.loadSlides();
        var i=room.slideUrls.length;

        dojo.connect(dojo.byId("joinB"),"onclick",function(){
            if (!dojo.byId("sendName").value.length) {
                alert("Please enter Name");
                return;
            }
            room.join(dojo.byId('sendName').value);
        });  
        dojo.connect(dojo.byId("sendB"),"onclick",function(){
            if (!dojo.byId("sendText").value.length) {
                alert("Please enter Text");
                return;
            }
            room.chat(dojo.byId("sendText").value);
        });
        dojo.connect(dojo.byId("nextB"),"onclick",function(){
            if (i>=room.slideUrls.length)
                i=0;
            else
                i++;
            room.next( room.slideUrls[i]);
        });
        dojo.connect(dojo.byId("previousB"),"onclick",function(){
            if (i<=0)
                i=room.slideUrls.length-1 ;
            else 
                i--;            
            room.next( room.slideUrls[i]);
        });  
        dojo.connect(dojo.byId("leaveB"),"onclick",function(){
            room.leave();
        });
    }
};

dojo.addOnLoad(room, "init");
dojo.addOnUnload(room,"leave");

