/*
 * Decompiled with CFR 0.152.
 */
package com.sun.grizzly.comet;

import com.sun.grizzly.comet.CometEngine;
import com.sun.grizzly.comet.CometTask;
import com.sun.grizzly.http.SelectorThread;
import com.sun.grizzly.util.LinkedTransferQueue;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.CancelledKeyException;
import java.nio.channels.SelectableChannel;
import java.nio.channels.SelectionKey;
import java.nio.channels.Selector;
import java.nio.channels.SocketChannel;
import java.util.concurrent.CountDownLatch;
import java.util.logging.Level;
import java.util.logging.Logger;

public class CometSelector {
    protected final CometEngine cometEngine;
    private Selector selector;
    private long lastIdleCheck;
    private final Logger logger = SelectorThread.logger();
    private final ByteBuffer dumybuffer = ByteBuffer.allocate(1);
    private final LinkedTransferQueue<CometTask> keysToRegister = new LinkedTransferQueue();

    public CometSelector(CometEngine cometEngine) {
        this.cometEngine = cometEngine;
    }

    public void start() throws InterruptedException {
        final CountDownLatch isStartedLatch = new CountDownLatch(1);
        new Thread("CometSelector"){
            {
                super(x0);
                this.setDaemon(true);
            }

            public void run() {
                try {
                    CometSelector.this.selector = Selector.open();
                }
                catch (IOException ex) {
                    CometSelector.this.logger.log(Level.SEVERE, "CometSelector.open()", ex);
                    return;
                }
                isStartedLatch.countDown();
                CometSelector.this.doSelection();
            }
        }.start();
        isStartedLatch.await();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doSelection() {
        while (true) {
            int selectorState = 0;
            try {
                block8: {
                    try {
                        selectorState = this.selector.select(1000L);
                    }
                    catch (CancelledKeyException ex) {
                        if (!this.logger.isLoggable(Level.FINEST)) break block8;
                        this.logger.log(Level.FINEST, "CometSelector.open()", ex);
                    }
                }
                this.handleSelectedKeys();
                this.expireIdleKeys();
                this.registerNewKeys();
                continue;
            }
            catch (Throwable t) {
                this.handleException(t, null);
                continue;
            }
            finally {
                if (selectorState > 0) continue;
                this.selector.selectedKeys().clear();
                continue;
            }
            break;
        }
    }

    private void handleSelectedKeys() {
        for (SelectionKey cometKey : this.selector.selectedKeys()) {
            try {
                if (cometKey.isValid()) {
                    CometTask cometTask = (CometTask)((Object)cometKey.attachment());
                    boolean asyncExec = cometTask.isComethandlerisAsyncregistered();
                    if (asyncExec) {
                        cometTask.setComethandlerisAsyncregistered(false);
                        if (cometKey.isReadable()) {
                            cometKey.interestOps(cometKey.interestOps() & 0xFFFFFFFE);
                            cometTask.upcoming_op = CometTask.OP_EVENT.READ;
                        }
                        if (cometKey.isWritable()) {
                            cometKey.interestOps(cometKey.interestOps() & 0xFFFFFFFB);
                            cometTask.upcoming_op = CometTask.OP_EVENT.WRITE;
                        }
                    }
                    if (cometTask.getSelectionKey().attachment() == null) {
                        if (!cometTask.cometHandlerNotResumed()) continue;
                        if (asyncExec) {
                            cometTask.execute();
                            continue;
                        }
                        this.checkIfclientClosedConnection(cometKey);
                        continue;
                    }
                    this.cancelKey(cometKey, false, true, true);
                    continue;
                }
                this.cancelKey(cometKey, false, true, true);
            }
            catch (Throwable t) {
                this.handleException(t, cometKey);
            }
        }
        this.selector.selectedKeys().clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void checkIfclientClosedConnection(SelectionKey cometKey) {
        boolean connectionclosed = true;
        try {
            SocketChannel socketChannel = (SocketChannel)cometKey.channel();
            this.dumybuffer.clear();
            connectionclosed = socketChannel.read(this.dumybuffer) == -1;
        }
        catch (Throwable ex) {
            this.handleException(ex, null);
        }
        finally {
            if (connectionclosed) {
                this.cancelKey(cometKey, true, true, true);
            }
        }
    }

    private void registerNewKeys() {
        CometTask cometTask;
        SelectionKey cometKey = null;
        while ((cometTask = (CometTask)((Object)this.keysToRegister.poll())) != null) {
            try {
                SelectionKey mainKey = cometTask.getSelectionKey();
                SocketChannel channel = (SocketChannel)mainKey.channel();
                if (!mainKey.isValid() || !channel.isOpen()) continue;
                cometKey = channel.register(this.selector, 1);
                cometTask.setCometKey(cometKey);
                cometKey.attach((Object)cometTask);
                cometTask.getCometContext().addActiveCometTask(cometTask);
                cometTask.getCometContext().addActiveHandler(cometTask.getCometHandler(), cometKey);
                cometKey = null;
            }
            catch (Throwable t) {
                this.handleException(t, cometKey);
            }
        }
    }

    private void expireIdleKeys() {
        if (this.selector.keys().isEmpty()) {
            return;
        }
        long current = System.currentTimeMillis();
        if (current - this.lastIdleCheck < 1000L) {
            return;
        }
        this.lastIdleCheck = current;
        for (SelectionKey cometKey : this.selector.keys()) {
            try {
                CometTask cometTask = (CometTask)((Object)cometKey.attachment());
                if (cometTask == null) continue;
                if (cometTask.hasExpired(current)) {
                    this.cancelKey(cometKey, false, true, true);
                    continue;
                }
                if (!(cometTask.getSelectionKey().attachment() instanceof Long)) continue;
                cometKey.attach(null);
                cometKey.cancel();
            }
            catch (Throwable t) {
                this.handleException(t, cometKey);
            }
        }
    }

    private void handleException(Throwable t, SelectionKey key) {
        try {
            this.cancelKey(key, false, true, true);
        }
        catch (Throwable t2) {
            this.logger.log(Level.SEVERE, "CometSelector", t2);
        }
        if (this.logger.isLoggable(Level.FINEST)) {
            this.logger.log(Level.FINEST, "CometSelector", t);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean cancelKey(SelectionKey cometKey, boolean cancelMainKey, boolean removeCometHandler, boolean notifyInterrupt) {
        if (cometKey == null) {
            return false;
        }
        boolean status = true;
        CometTask cometTask = null;
        SelectionKey selectionKey = cometKey;
        synchronized (selectionKey) {
            cometTask = (CometTask)((Object)cometKey.attach(null));
            if (cometTask != null) {
                cometKey.cancel();
            }
        }
        boolean bl = status = cometTask != null;
        if (status) {
            status = cometTask.getCometContext().interrupt(cometTask, removeCometHandler, notifyInterrupt);
            this.cometEngine.flushPostExecute(cometTask.getAsyncProcessorTask());
            if (cancelMainKey) {
                cometTask.getSelectorThread().cancelKey(cometTask.getSelectionKey());
            }
        }
        return status;
    }

    public void registerKey(CometTask cometTask) {
        if (cometTask.getSelectionKey().isValid() && this.selector != null) {
            cometTask.setExpireTime(System.currentTimeMillis());
            this.keysToRegister.offer((Object)cometTask);
            this.selector.wakeup();
        }
    }

    public void wakeup() {
        this.selector.wakeup();
    }

    public SelectionKey cometKeyFor(SelectableChannel channel) {
        return channel.keyFor(this.selector);
    }
}

