'use strict';
function search(SearchText, inHeading) {
(function () {
var Page = [];

/* Generated with Author-it 23.4.1.30004  1/5/2026 2:57:04 PM */
Page[0]=new Array("Title and Copyright Information","Copyright  1997, 2026, Oracle and/or its affiliates.","Primary Author: Oracle Corporation","Title and Copyright Information","46576.htm");
Page[1]=new Array("This document demonstrates ways that Primavera Analytics can present data. The sample data is from multiple sources and is intended for illustration only. Data and descriptions are part of the Primavera Analytics sample catalog and therefore may not reflect your environment. You can use the sample dashboards and the Primavera Data Warehouse database to replicate these analyses.","The samples are intended to provide you with a general understanding of Primavera Analytics and Oracle Analytics Server (OAS). You can use these samples to customize both content and layout to your specific requirements.","For information on the types of views, charts, and gauges that are available, see the OAS help. ","For P6 EPPM, see the P6 Data Dictionary available with your version of P6 for information on P6 fields. See the P6 EPPM documentation for information on using or configuring P6 to gather sufficient data for Primavera Analytics.","For Primavera Unifier, refer to the Unifier Reference Guide for information on Primavera Unifier fields. Refer to the Primavera Unifier documentation for information on using or configuring Primavera Unifier to gather sufficient data for Primavera Analytics.","For Oracle Primavera Cloud, see the Oracle Primavera Cloud Data Dictionary available for information on Primavera Cloud fields. ","Within our documentation, some content might be specific for cloud deployments while other content is relevant for on-premises deployments. Any content that applies to only one of these deployments is labeled accordingly.","Getting Started","81882.htm");
Page[2]=new Array("Oracle Primavera Analytics provides an in-depth and comprehensive method for analyzing and evaluating facilities and real estate management, project performance, project history, resource assignments and utilization, business processes, cash flows, and cost sheets.","Built on Oracle Analytics Server (OAS), Primavera Analytics delivers a catalog of analyses that provide an interactive way of viewing, analyzing, and evaluating P6 EPPM and Primavera Unifier data. In addition, Primavera Data Warehouse provides a repository definition that contains the data mappings between the physical data and the presentation layer of OAS.","The dashboards provide detailed insight into your P6 EPPM and Primavera Unifier data through analytical charts, tables, maps, and graphics. Dashboards allow you to navigate to other analyses to provide precise root-cause analysis. OAS allows you to configure individual analyses with P6 EPPM and Primavera Unifier Action Links, enabling you to navigate directly to your P6 and Unifier site for true &quot;Insight to Action&quot; capabilities. You can save an analysis in the OAS Presentation Catalog and integrate the analysis into any OAS dashboard. You can enhance results through options such as charting, results layout, calculations, and drill-down features.","Use Primavera Analytics to:","Perform root-cause analysis and employ management-by-exception.","Gather critical insights into current and historical performance of all projects, programs, and portfolios.","Drill down from aggregated metrics to examine the root-cause of a problem.","Make better decisions to eliminate project failure.","Quickly visualize critical project performance in early stages.","Identify and predict cost sheet and cash flow trends early in the project life cycle.","Gain visibility into resource performance through s-curve analysis.","Show staffing needs by portfolio with early warning indicators for upcoming under-staffed project work.","Roll-up business processes to understand trends and trends by various dimensions.","Use geospatial visualization to view project, activity, and resource data metrics by geographic location with full drill-down capabilities.","Primavera Analytics provides a repository definition to use with OAS. The repository definition contains:","A physical representation of Primavera Data Warehouse.","A business layer to perform customized calculations.","A presentation layer that groups all the calculated business layer fields into logical subject areas.","The repository definition delivers an extensive list of key performance indicators (KPIs) from both, Primavera Unifier, and P6 EPPM. Depending on the data source, this list includes (but is not limited to) Earned Value, Costs, Units, Percent Completes, Counts, Business Processes, Lean, Resource Assignment, Schedule Health, Cash Flow, and Cost Sheets. It also enables data to be sliced by various dimensions, including time, EPS, portfolios, projects, activities, resources, project hierarchies, cost breakdown structures, and business processes.","Primavera Analytics delivers a sample dataset, consisting of Primavera Data Warehouse data, where the dashboards and analyses in the catalog were built. You can use this sample data to view the power of dashboard and analyses delivered in the catalog, and see how you can integrate the catalog with your data.","About Oracle Primavera Analytics","81523.htm");
Page[3]=new Array("Consent notices alert you to the need to protect personal information (PI). You and your organization might be collecting, processing, storing, and transmitting PI while using Analytics. When you accept a consent notice in a source application such as P6 EPPM or Unifier, your consent covers the collection, processing, storing, and transmission of PI data, and means of retrieving data including but not limited to project export, downloaded tables, reports, documents, web services, and API. If you refuse consent in the source application you might not be able to access some areas of Analytics.","You may be asked to provide consent to show that you understand the need to treat PI as secure data. You may also be asked to provide consent for your organization to collect, process, store and transmit your PI. If you refuse consent you will be denied access to the source application and Analytics.","You can withdraw your consent at any time within a source application.","About Consent Notices","84409.htm");
Page[4]=new Array("Personal information (PI) is any piece of data which can be used on its own or with other information to identify, contact, or locate an individual in context. The information is not limited to a person's name, address and contact details. For example, a person's IP address, phone IMEI number, gender, and location at a particular time could all be personal information. Depending on local data protection laws, organizations may be responsible for ensuring the privacy of PI wherever it is stored, including in back-ups, locally stored downloads, and data stored in development environments.","Caution: Personal information (PI) may be at risk of exposure. Depending on local data protection laws organizations may be responsible for mitigating any risk of exposure.","About Personal Information","84404.htm");
Page[5]=new Array("When using Primavera Analytics and Primavera Data Warehouse, the server may generate cookies and send them to the user&#8217;s browser. The user&#8217;s machine stores the cookies, either temporarily by the browser, or permanently until they expire or are removed manually.","Oracle might use cookies for authentication, session management, remembering application behavior preferences and performance characteristics, and to provide documentation support.","Also, Oracle might use cookies to remember your login details, collect statistics to optimize site functionality, and deliver marketing based on your interests.","Cookies Usage in Primavera Analytics and Primavera Data Warehouse","84413.htm");
Page[6]=new Array("The following prerequisites need to be met before you can use Primavera Analytics:","P6 EPPM or Primavera Unifier must be installed.","Publishing must be switched on in P6 and Primavera Unifier.","You must have module access to Primavera Analytics in P6 and Primavera Unifier.","You must be an OAS user.","Your OAS user name must match your P6 user name and your Primavera Unifier user name.","The catalog must be installed.","The ETL process must be run to update the Analytics data:","For cloud service, run the StarETL process.","For on-premises installations, run either the PL/SQL-based or ODI-based StarETL process.","Set up Primavera Data Warehouse to create staruser before running the ETL. For more information, see Primavera Data Warehouse Installation and Configuration Guide for On-Premises. Work with your administrator to determine the optimal time to run this process.","Contact your administrator if you require any of the above privileges.","Prerequisites to Use Primavera Analytics","81883.htm");
Page[7]=new Array("If the DVD client does not have the CA certificate in it's keystore, you will need to manually import the CA certificate on the machine running the client as follows:","Open a browser and connect to Primavera Analytics.","In the URL, click on the lock icon.","Click on the &gt; right-arrow and then click More Information.","In the Security tab, click View Certificate.","In the Details tab, click Export....","Follow the steps to export the certificate.","Once certificate is downloaded:","Open the command prompt as an administrator.","Change the current working directory to the JRE keystore location.","For example, cd C:\\Program Files\\Oracle Data Visualization Desktop\\OracleBI1\\jdk\\jre\\lib\\security","Type the following to import the CA certificate:","&quot;C:\\Program Files\\Oracle Data Visualization Desktop\\OracleBI1\\jdk\\jre\\bin\\keytool&quot; -import -trustcacerts -alias $userdefined -file $path+keystorename -keystore &quot;C:\\Program Files\\Oracle Data Visualization Desktop\\OracleBI1\\jdk\\jre\\lib\\security\\cacerts&quot; -storepass changeit","Importing CA Certificate for DVD Client","85315.htm");
Page[8]=new Array("Analyses are queries against data (for example, P6 EPPM, Primavera Unifier data, or Oracle Primavera Cloud) that allow you to evaluate the information. Analyses let you explore and interact with information by visually presenting data in tables, charts, and pivot tables. If you have the required permissions, you can save, organize, and share the results of analyses. You can save analyses that you create in the OAS Presentation Catalog and integrate them into any OAS dashboard. You can enhance analyses through features such as compounded views, calculated items, and drilling.","Watch the following videos to create detailed analyses:","Creating an Analysis Video","Filtering an Analysis Video","Adding a Graph to an Analysis Video","About Analyses","81884.htm");
Page[9]=new Array("A subject area contains folders, measure columns, attribute columns, hierarchical columns, and hierarchy levels that represent information about the areas of an organization's business or about groups of users with an organization. Subject areas usually have names that correspond to the types of information that they contain.","A subject area corresponds to the presentation layer in an OAS metadata repository. In a repository, the subject area is the highest-level object in the presentation layer and represents the view of the data that end users see when they create or edit an analysis.","Use subject areas to organize the data you see in an analysis. To choose a subject area, select New, Analysis, and then Select Subject Area from the list.","Oracle Primavera Cloud Data ","Primavera Analytics uses Oracle Primavera Cloud data for the following subject areas:","Primavera Cloud - Activity User Defined Fields","Use this subject area to analyze activity User Defined Field (UDF) data for cost, integer, or number types. This subject area requires UDF configuration using the ETL process.","Primavera Cloud - Lean Task","Use this subject area to analyze task commitments, completion, percent complete and reason, if any, for missing commitments.","Primavera Cloud - Project User Defined Fields ","Use this subject area to analyze project UDF data for cost, integer, or number types. This subject area requires UDF configuration using the ETL process.","Primavera Cloud - Resource Assignment","Use this subject area to to analyze resource assignment details for units and hours.","Primavera Cloud - Schedule Health","Use this subject area to analyze schedule health metrics aggregated for all projects.","Primavera Cloud - Risk","Use this subject area to analyze risk data at the project level. The data can be aggregated and displayed with its associated Project, Workspace, and Risks.","P6 EPPM Data","Primavera Analytics uses P6 EPPM data for the following subject areas:","Primavera - Activity","Use this subject area to analyze project, WBS, and activity level details. This subject area includes earned value metrics and percent complete metrics, planned and actual units and hours, and project baseline comparisons.","Primavera - Activity History","Use this subject area to analyze daily, weekly, or monthly activity level history, including changes to both facts and dimensions, to better understand changes over time. This subject area requires project-specific configuration in P6.","Primavera - Activity Period Actuals ","Use this subject area to analyze activity period actuals over a period of time. ","Primavera - Activity User Defined Fields","Use this subject area to analyze activity User Defined Field (UDF) data for cost, integer, or number types. This subject area requires UDF configuration using the ETL process.","Primavera - Burn Down","Use this subject area to analyze daily project performance through burn down charts and schedule adherence metrics. Metrics include planned, actual, remaining, and emergent counts and units. Emergent data is from activities which were added after burn down began. This subject area requires project specific UDF configuration in P6.","Primavera - Project History","Use this subject area to analyze project and WBS-level history, including changes to both facts and dimensions, to better understand changes over time. This subject area requires project-specific configuration in P6.","Primavera - Project User Defined Fields","Use this subject area to analyze project UDF data for cost, integer, or number types. This subject area requires UDF configuration using the ETL process.","Primavera - Resource Assignment","Use this subject area to analyze resource assignment details for costs and units. This subject area includes information on planned, actual, remaining, staffed, unstaffed, and at completion costs and units.","Primavera - Resource Assignment History","Use this subject area to analyze daily resource assignment-level history, including changes to both facts and dimensions to help you understand changes over time. This subject area requires project specific configuration in P6.","Primavera - Resource Assignment User Defined Fields","Use this subject area to analyze resource assignment UDF data for cost, integer, or number types. This subject area requires UDF configuration using the ETL process.","Primavera - Resource Period Actuals ","Use this subject area to analyze resource period actuals over a period of time. ","Primavera - Resource User Defined Fields","Use this subject area to analyze resource UDF data for cost, integer, or number types. This subject area requires user defined field configuration using the ETL process.","Primavera - Resource Utilization","Use this subject area to analyze resource utilization details including actual, available, planned, remaining, at completion, and resource limit units.","Primavera - Role Utilization","Use this subject area to analyze role utilization details for resources.","Primavera - Spread Snapshot History ","Use this subject area to analyze how your data will appear at different points in time by creating a snapshot at different time intervals, for comparison purposes.","Primavera - WBS User Defined Fields","Use this subject area to analyze WBS UDF data for cost, integer, or number types. This subject area requires UDF configuration using the ETL process.","Primavera - Work Planning","Use this subject area to analyze weekly work planning process by comparing project scope and schedule freeze dates each week. In this way, potential risks such as activity planned start date changes can quickly be identified. This subject area requires project specific UDF configuration in P6.","System - Admin","Use this subject area to analyze all the details of your ETL process, from query run times to the amount of data that is processed during each ETL run.","Primavera Unifier Data","Primavera Analytics uses Primavera Unifier data for the following subject areas:","Primavera - Business Process","Use this subject area to analyze cost and non-cost line items in business processes.","Primavera - Business Process History","Use this subject area to analyze weekly historical business process facts to better understand changes over time. Note that dimensional business process history is not supported.","Primavera - Cash Flow","Use this subject area to analyze WBS shell-level cash flows and commitment-level cash flows. You can map columns to predefined WBS shell-level cash flow curves and commitment level cash flow curves respectively. Ten generic columns are included to support cash flow curves. ","Primavera - Cash Flow History","Use this subject area to analyze weekly historical cash flow facts and commitment level cash flow facts to better understand changes over time. Note that dimensional cash flow history is not supported. ","Primavera - Cost Sheet","Use this subject area to analyze cost sheets. You can map your data source to a predefined list of cost sheet columns. Twenty generic columns are included to support mapping of additional data sources from the cost sheet.","Primavera - Cost Sheet History","Use this subject area to analyze weekly historical cost sheet facts to better understand changes over time. Note that dimensional cost sheet history is not supported.","Primavera Earned Value Management (Unifier)","Use this subject area to analyze a project's planned value, earned value, actual costs, and the estimated cost at completion.","Primavera - Generic Cost Sheet","Use this subject area to analyze cost-related activities for a generic cost sheet. You can capture and view cost transaction information based on a timescale, such as quarterly or yearly.","Primavera - Project User Defined Fields","Use this subject area to analyze project UDF data for cost, integer, or number types. This subject area requires UDF configuration using the ETL process.","Note: A Shell must be mapped to a UDF of Numeric data type in Unifier Analytics to ensure the data will be available as a Fact in this subject area of Analytics.","Primavera - Project User Defined Fields History","Use this subject area to analyze historical project UDF data for cost, integer, or number types facts to better understand changes over time. ","Note: A Shell must be mapped to a UDF of Numeric data type in Unifier Analytics to ensure the data will be available as a Fact in this subject area of Analytics.","Primavera - Resource Cost Summary","Use this subject area to analyze resource cost information sourced from P6 Summary Sheet data stored in Primavera Unifier. Analyze cost and performance data by project hierarchy, cost breakdown structure, and resource down to the daily level.","Primavera - Space Management","Use this subject area to analyze space utilization for Facilities and Real Estate data from Primavera Unifier.","Primavera - Space Management History","Use this subject area to analyze space utilization over time for Facilities and Real Estate data from Primavera Unifier.","System - Admin","Use this subject area to analyze all the details of your ETL process, from query run times to the amount of data that is processed during each ETL run.","About Subject Areas","81885.htm");
Page[10]=new Array("Dashboards enable you to view various types of information quickly and easily. They can be made up of one or more pages, each of which can display various components of the OAS suite. For example, on the Industry Samples Routine/On-Line Maintenance page, values are based on the planned schedule for the beginning of the appropriate execution work week. The execution work week is determined by the values set in P6. This transfer of information is configured during the work planning setup.","Primavera Analytics includes several dashboards in the sample catalog. Use the sample dashboards as starting points to create custom dashboards and analyses that are tailored to your business needs. The power of Primavera Analytics is the ability to easily generate specific content for every user or role.","You can also view and edit a dashboard. For a quick lesson, watch this video on Viewing and Editing Dashboards. ","The following dashboards are included in the sample catalog:","The Main dashboard provides high-level insight into schedule progress, costs, and risks. You can find information here about the progress of Early Stage projects, the percentage of overallocated resources, and world maps showing the distribution of costs and risks.","The Admin dashboard shows details about the ETL process and Primavera Data Warehouse database configuration. This data is not in any of the Primavera Analytics subject areas, so it is obtained via direct SQL against the Primavera Data Warehouse database.","The More dashboard contains the d3 dashboards. The analyses on these dashboards contain components and technologies that are considered optional within Oracle Analytics Server. Use these advanced dashboards to manipulate data into visual representations of your analyses. For more information, consult the Primavera Data Warehouse Installation and Configuration Guide for instruction on how to install and configure these optional components.","P6 EPPM Data","The Portfolio Analysis dashboard contains important portfolio information based on project performance, project costs, risks and rewards by project, strategic objectives, and multiple ratings of project codes.","The Project Earned Value dashboard gives an overview of the earned value status of your projects, including Schedule Performance Index (SPI) and Cost Performance Index (CPI).","The Project Health dashboard offers useful tools for determining the health of your projects. In this dashboard, you can view the overall health of your project, look at schedule progress and cost trends, and determine which activities are not on track.","The Resource Analysis dashboard shows the status and usage of roles and resources, measures team progress and productivity, and tells you which roles and resources are underutilized.","The Industry Samples dashboard shows daily burn down, performance, work planning, and schedule compliance for industry related activities.","Primavera Unifier Data","The Business Processes dashboard enables you to view business process data, including business process overview analyses, business process data by geographic location, and business process history analyses.","The Cash Flow dashboard enables you to view cash flow data, including comparisons of actuals vs. forecast and forecast vs. baseline, cash flow data by geographic location, and cash flow history analyses.","The Cost Sheet dashboard enables you to view cost data, including a comparison of original and revised budget details, and cost history analyses.","The Cost Summary dashboard enables you to view cost summaries, including cost breakdowns and budget details.","The Facilities and Real Estate dashboard enables you to view space management data from Primavera Unifier.","The Workflow dashboard enables you to view workflow data, including workflow completion schedules, ownership, and progress.","Combined Data","The Project Performance Measurement dashboard combines P6 and Unifier data sources.","Each dashboard has filter selections, or prompts, to help narrow the results in the sections by the date, project, location, and so on.","About Dashboards","81886.htm");
Page[11]=new Array("To access the sample dashboards: ","Upload the catalog and RDP file for the corresponding version.","Enter the URL for OAS in a web browser. ","Enter your User ID and Password for OAS.","Note: Check with your Primavera Analytics system administrator to access the Primavera Analytics sample catalog and data.","In the navigation pane, select Catalogs, and then select Shared Folders. ","Select the dashboard you want to open. ","Logging in to OAS and Navigating to Dashboards","81887.htm");
Page[12]=new Array("If deployed by your administrator, Primavera Analytics comes with sample analyses. If you have the required access permissions, you can edit analyses to fit your needs in OAS. Contact your OAS administrator for access.","For more information on editing sample analyses, see the OAS documentation.","To edit a sample analysis in OAS:","In the left navigation pane, click Catalog .","In the Shared Folders, select any of the following folders: ","Primavera: Select for P6 EPPM and Unifier dashboards.","Oracle Primavera Cloud: Select for Oracle Primavera Cloud dashboards.","Select the Dashboard folder, and then click a dashboard.","Click Edit for one of the analyses.","Roll over an analysis and click the Properties icon which appears.","Select Edit Analysis from the Properties menu.","Edit the analysis as necessary and click Save @.","Editing Sample Analyses","81888.htm");
Page[13]=new Array("If you have the required permissions, you can create analyses. .","To create a new analysis in OAS:","Click Create, and then select Workbook.","In the Add Dataset window, select the Datasets or the Subject Area tab.","Select the datasets or subject areas you will use for this analysis and then click Add to Workbook.","In the Visualize pane: ","Add columns and filters as necessary to the subject area / datasets.","Select Visualization types to display the data as bar graphs, pie charts etc.","Manage conditional formatting rules and sort the data.","Click Save to apply all the changes to your visualization.","In the Present pane, select the canvases created in the Visualize pane to present your analysis.","In the Save As dialog box, select a location for the new analysis and give it a name.","Creating Analyses","81889.htm");
Page[14]=new Array("Primavera Analytics includes several dashboards in the sample catalog. Use the sample dashboards as starting points to create custom dashboards and analyses that are tailored to your business needs. The power of Primavera Analytics is the ability to easily generate specific content for every user or role.","Sample Primavera Dashboards","82191.htm");
Page[15]=new Array("The Main dashboard uses data from P6 EPPM and Primavera Unifier. ","This dashboard provides high level insight into schedule progress, costs, and risks. You can find information here about the progress of early stage projects, the percentage of overallocated resources, and world maps showing the distribution of costs and risks.","Main Dashboard","81890.htm");
Page[16]=new Array("This page gives overview information about budget and schedule. It contains the following narratives:","Overall Cost Variance shows the amount that the Actual Value is over or under the Planned Value. A negative value indicates that that Actual Cost has exceeded the Planned Value. This is calculated as Earned Value Cost minus the Actual Cost.","Early Stage Projects over Budget shows the percentage of early stage projects which are over budget. Early stage projects are those with a Performance Percent Complete less than 40. Over budget projects are those whose maximum activity total cost expressed as a percentage of baseline total cost is greater than zero.","Early Stage Projects behind Schedule shows the percentage of early stage projects which are behind schedule. Early stage projects are those with a Performance Percent Complete less than 40. Behind schedule projects are those with a Schedule Performance Index less than 0.95.","Resources overallocated shows the percentage of resources that are overallocated. This is calculated as the number of resources that are overallocated divided by the total number of resources. Resources are qualified as overallocated if their remaining units minus their unit limit is greater than 0. ","Overview Page","81891.htm");
Page[17]=new Array("Purpose","The stacked line-bar chart on the left displays the early stage projects that are behind schedule. The x-axis shows project names. The y-axis for the bars (left) shows At Complete Units. The y-axis for the line (right) shows Delay percentage.","The stacked line-bar chart on the right displays the projects that are overbudget. The x-axis shows project names. The y-axis for the bars (left) shows At Complete Cost. The y-axis for the line (right) shows Cost Overrun percentage.","Location","On the Home page, click Dashboards.","Under Primavera, select Main.","On the Main dashboard, click the Overview page.","On the Overview page, expand the Early Stage Projects behind Schedule section.","Subject Area","Activity","Early Stage Projects Behind Schedule Section","81893.htm");
Page[18]=new Array("Purpose","The tree map shows the relative number of projects by country.","The waterfall chart shows At Completion Total Cost amounts for the selected country.","The x-axis shows months. The y-axis shows the amounts.","Location","On the Home page, click Dashboards.","Under Primavera, select Main.","On the Main dashboard, click the Overview page.","On the Overview page, expand the At Completion Cost Summary section.","Subject Area","Activity","At Completion Cost Summary Section","83851.htm");
Page[19]=new Array("Purpose","The line graph shows lines for:","Initial Baseline (Cumulative)","Current Baseline (Cumulative)","Actuals (Cumulative)","Forecast (Cumulative)","The x-axis shows months. The y-axis shows cash flow values.","The pivot table contains columns for:","Year Name","Periodic","Initial Baseline","Current Baseline","Actuals","Forecast","Cumulative","Initial Baseline","Current Baseline","Actuals","Forecast","Right-click on Project Hierarchy elements in the Project Filter pivot table and select Keep Only to filter the contents of the pivot table and line graph.","Location","On the Home page, click Dashboards.","Under Primavera, select Main.","On the Main dashboard, click the Overview page.","On the Overview page, expand the Cash Flow Summary by Project section.","Subject Area","Activity","Cash Flow Summary by Project Section","83145.htm");
Page[20]=new Array("Purpose","The pivot table shows costs and units for each portfolio. Over budget values are highlighted in red text.","The pivot table contains columns for:","Portfolio Name","Actual (Cost)","At Completion (Cost)","Budgeted (Cost)","Variance (Cost)","Actual (Units)","At Completion (Units)","Budgeted (Units)","Variance (Units)","The stacked bar graph shows a stacked bar for the number of Remaining Units and Overallocation Units. There is a bar for any resource that is overallocated.","The x-axis shows Resource Name. The y-axis shows Units in hours. Hover over a bar for specific details.","Location","On the Home page, click Dashboards.","Under Primavera, select Main.","On the Main dashboard, click the Overview page.","On the Overview page, expand the Portfolio Summary section.","Subject Area","Activity","Portfolio Summary Section","81899.htm");
Page[21]=new Array("This page provides cost information based on country code. It contains the following narratives:","Highest At Completion Total Cost shows the cost amount for the country with the highest at completion total cost.","Highest Earned Value Cost shows the cost amount for the country with the highest earned value cost.","Lowest Earned Value Cost shows the cost amount for the country with the lowest earned value cost.","Highest Cost Performance Index shows the index number for the country with the highest cost performance index.","Lowest Cost Performance Index shows the index number for the country with the lowest cost performance index.","Location Page","81901.htm");
Page[22]=new Array("Purpose","The map shows Cost Variance Index by country code when zoomed out to country level. White areas of the map indicate that no project is located in that area.","Switch off the Cost Variance (Cost) (Color Fill) option below ALL COUNTRIES to remove the shading. Zoom in and out with the control on the left and hover over a country, state, or province to see specific information and for a link to the country code which will filter the table and bar graph. ","The pivot table uses geospatial data stored by the Location settings in P6 to show projects assigned to the country code selected. Each of the cost columns is totaled on the bottom line of the table to give a grand total for that country code.","For each project, the table contains columns for:","Project Name","City Name","At Completion Labor Cost","At Completion Nonlabor Cost","At Completion Material Cost","At Completion Expense Cost","At Completion Total Cost","The bar graph has the following cost bars for each project:","At Completion Labor Cost","At Completion Nonlabor Cost","At Completion Material Cost","At Completion Total Cost ","The x-axis shows project name. The y-axis shows Cost.","Location","On the Home page, click Dashboards.","Under Primavera, select Main.","On the Main dashboard, click the Location page.","On the Location page, expand the Completion Cost by Location section.","Subject Area","Activity","Completion Cost by Location Section","81902.htm");
Page[23]=new Array("This page shows the risk exposure for each project by country.","Risk Page","81906.htm");
Page[24]=new Array("Purpose","The map shows total risk exposure by country code.","Zoom in and out with the control on the left and hover over a country, state, or province to see specific information.","The bar graph shows a bar for each country showing Risk Exposure in dollars. Red bars denote a risk exposure greater than $100,000, yellow bars denote a risk exposure between $50,000 and $100,000, and green bars denote risk exposure less than $50,000.","The x-axis shows Risk Exposure. The y-axis shows country name.","Location","On the Home page, click Dashboards.","Under Primavera, select Main.","On the Main dashboard, click the Risk page.","On the Risk page, expand the Risk Exposure by Location section.","Subject Area","Project History","Risk Exposure by Location Section","81907.htm");
Page[25]=new Array("Purpose","The pivot table shows detailed risk information for the country selected in the Country Name prompt, broken down by project ID. The pivot table contains columns for:","Country Name","Project ID","Project Risk Score","Project Risk Exposure","Risk Name","Risk Type","Risk Status","Project Owner","Risk Score","Risk Exposure","Risk Exposure Start","Risk Exposure Finish","A link to the risks in P6 EPPM","The funnel chart shows open versus total risks by country code, with conditional formatting based on the percentage of risks that are open. Red denotes greater than 70% open risks, yellow between 50% and 70% and green less than 50% open risks.","Location","On the Home page, click Dashboards.","Under Primavera, select Main.","On Main dashboard, click the Risk page.","On the Risk page, expand the Detailed Risk by Location section.","Subject Area","Activity","Detailed Risk by Location Section","81910.htm");
Page[26]=new Array("Purpose","The table shows risk information by project. The table contains columns for:","Project ID","Project Name","Total Risks","Project Risk Score","Project Risk Exposure","Project Start Date","Project Finish Date","The bar chart shows risk counts by project and uses master-detail linking to display the counts for a project based on the Project Name that is clicked on in the table. The counts are by Cost Category.","The stacked bar chart shows the risk counts by project. The bar color is based on the Risk Status.","The line-bar chart shows the Risk Score and Risk Exposure by project.","Location","On the Home page, click Dashboards.","Under Primavera, select Main.","On Main dashboard, click the Risk page.","On the Risk page, expand the Detailed Risk by Project section.","Subject Area","Activity","Detailed Risk by Project Section","82553.htm");
Page[27]=new Array("The Business Process dashboard uses data from Primavera Unifier. ","It gives you an enterprise view across your business processes by enabling you to analyze your business process data, including amounts, counts, and quantities. You can easily slice the data by various dimensions, including vendor, portfolio, and cost breakdown structure and drill down to line item granularity.","Primavera Analytics supports the following Unifier picker and data picker elements which can be configured in the Unifier &gt; Administration Mode &gt; Analytics &gt; Business Processes option: ","BP Picker","User Picker","Shell Picker","Space Picker","BP Data Picker","Shell Data Picker","User Data Picker","Business Processes Dashboard","83082.htm");
Page[28]=new Array("This page shows business process overview analyses.","Overview Page","83085.htm");
Page[29]=new Array("Purpose","The table and pie chart show record counts for each Business Process by Business Process Type (Cost, Document, Line Item, RFB, and Simple). The table contains the following columns:","Business Process Name","# Of BP Records","Location","On the Home page, click Dashboards.","Under Primavera, select Business Processes.","On the Business Processes dashboard, click the Overview page.","On the Overview page, expand the Business Process Counts section.","Subject Area","Business Process","Business Process Counts Section","83093.htm");
Page[30]=new Array("Purpose","The tree map shows relative amounts of Business Process Records. The bar graph shows the status of the selected Business Process.","Location","On the Home page, click Dashboards.","Under Primavera, select Business Processes.","On the Business Processes dashboard, click the Overview page.","On the Overview page, expand the Company Level Business Process Summary section.","Subject Area","Business Process","Company Level Business Process Summary Section","83714.htm");
Page[31]=new Array("Purpose","Depending on the selection, the pie chart and table show amounts for each Change Order broken down by Change Order Reason. The pivot table contains the following columns:","Business Process Name","Status","Reason","# of BP Records","Amount","Location","On the Home page, click Dashboards.","Under Primavera, select Business Processes.","On the Business Processes dashboard, click the Overview page.","On the Overview page, expand the Approved Change Orders By Reason section.","Subject Area","Business Process","Approved Change Orders by Reason Section","83094.htm");
Page[32]=new Array("Purpose","The bar graph displays amounts for each Vendor Summary item by Vendor Type or Vendor Name. The x-axis shows Vendor Summary items or Vendor Names, and the y-axis shows amounts. ","Location","On the Home page, click Dashboards.","Under Primavera, select Business Processes.","On the Business Processes dashboard, click the Overview page.","On the Overview page, expand the Vendor Summary section.","Subject Area","Business Process","Vendor Summary Section","83361.htm");
Page[33]=new Array("Purpose","The pie chart and table show amounts for each Vendor business process. The pivot table contains the following columns:","Vendor Name","Amount","Location","On the Home page, click Dashboards.","Under Primavera, select Business Processes.","On the Business Processes dashboard, click the Overview page.","On the Overview page, expand the Total Commitments &gt; 300k by Vendor section.","Subject Area","Business Process","Total Commitments &gt; 300k by Vendor Section","83095.htm");
Page[34]=new Array("Purpose","The pivot table shows a summary of the contracts for each Vendor. It contains the following columns:","Vendor Name","Vendor Id","Vendor Type","Project Name","Link to Project","Record Number","Title","Amount","Location","On the Home page, click Dashboards.","Under Primavera, select Business Processes.","On the Business Processes dashboard, click the Overview page.","On the Overview page, expand the Contract Summary by Vendor section.","Subject Area","Business Process","Contract Summary by Vendor Section","83096.htm");
Page[35]=new Array("Purpose","The table and pie chart show amounts for Change Order and Contract business processes broken down by Project Phase. The table contains the following columns:","Project Phase","Amount","# of BP Records","Location","On the Home page, click Dashboards.","Under Primavera, select Business Processes.","On the Business Processes dashboard, click the Overview page.","On the Overview page, expand the Commitments by Project Phase section.","Subject Area","Business Process","Commitments by Project Phase Section","83097.htm");
Page[36]=new Array("Purpose","The chart shows Workflow duration sorted by Project Name.","The table shows open Workflows sorted by duration.  The table contains the following columns:","Project Id","Project Name","Record Number","Title","Workflow Name","Setup Name","Workflow Start Date","Workflow Duration DD:HH:MM","Location","On the Home page, click Dashboards.","Under Primavera, select Business Processes.","On the Business Processes dashboard, click the Overview page.","On the Overview page, expand the Top 10 Project Workflows by Duration section.","Subject Area","Business Process ","Top 10 Workflows by Duration Section","83363.htm");
Page[37]=new Array("This page shows business process data by geographic location.","Location Page","83088.htm");
Page[38]=new Array("Purpose","The map shows Commitments by geographic location. Hover over a highlighted area to show details for that area. Use the control to zoom in to view details by city.","Location","On the Home page, click Dashboards.","Under Primavera, select Business Processes.","On the Business Processes dashboard, click the Location page.","On the Location page, expand the Commitments by City, State section.","Subject Area","Business Process","Commitments by City, State Section","83098.htm");
Page[39]=new Array("This page shows business process history analyses.","History Page","83090.htm");
Page[40]=new Array("Purpose","The table shows the record counts for each Business Process for the selected and previous week. It shows columns for:","Business Process Name","Selected Week (number of records)","Previous Week (number of records)","Delta (selected week - previous week)","Location","On the Home page, click Dashboards.","Under Primavera, select Business Processes.","On the Business Processes dashboard, click the History page.","On the History page, expand the Historical Business Process Counts section.","Subject Area","Business Process History","Historical Business Process Counts Section","83099.htm");
Page[41]=new Array("Purpose","The line chart shows the weekly amounts of the business processes for the selected Vendor Name, Vendor Type, and Business Process Name. ","The x-axis shows weeks. The y-axis shows amounts.","Location","On the Home page, click Dashboards.","Under Primavera, select Business Processes.","On the Business Processes dashboard, click the History page.","On the History page, expand the Historical Amounts by Vendor section.","Subject Area","Business Process History","Historical Amounts by Vendor Section","83100.htm");
Page[42]=new Array("Purpose","The line chart shows weekly record counts for the selected Business Process and Project. It contains two lines: One for Approved business processes; the other for Pending business processes. ","The x-axis shows weeks. The y-axis shows counts.","Location","On the Home page, click Dashboards.","Under Primavera, select Business Processes.","On the Business Processes dashboard, click the History page.","On the History page, expand the Weekly Business Process Trend by Project and Count section.","Subject Area","Business Process History","Weekly Business Process Trend by Project and Count Section","83101.htm");
Page[43]=new Array("This page shows business process workflow analyses.","Workflow Page","83519.htm");
Page[44]=new Array("Purpose","The table contains Business Processes that are overdue for completion. The table contains the following columns:","Business Process Name","Record Number","Title","Setup Name","Days Past Due","Workflow Due Date","Subject Area","Business Process ","Location","On the Home page, click Dashboards.","Under Primavera, select Business Processes.","On the Business Processes dashboard, click the Workflow page.","On the Workflow page, expand the Past Due Workflows section.","Subject Area","Business Process ","Past Due Workflows Section","83520.htm");
Page[45]=new Array("Purpose","The chart shows completed BP workflows sorted by Project Name. The date is represented on the x-axis, and the number of closed workflows is represented on the y-axis. The chart legend indicates the number of closed workflows that are Rejected, Closed with Change, Cancelled, and Approved. The Project data represented in the chart can be selected in the Project Name menu. ","Location","On the Home page, click Dashboards.","Under Primavera, select Business Processes.","On the Business Processes dashboard, click the Workflow page.","On the Workflow page, expand the Completed BP Workflows by Month section.","Subject Area","Business Process ","Completed BP Workflows by Month Section","83522.htm");
Page[46]=new Array("Purpose","The table shows which Steps that are past due, sorted by Project. The table contains the following columns:","Project Name","Record Number","Title","Setup Name","Step Name","Task Assignee","Step Completion Policy","Step Status","Task Due Date","Days Past Due","Location","On the Home page, click Dashboards.","Under Primavera, select Business Processes.","On the Business Processes dashboard, click the Workflow page.","On the Workflow page, expand the Steps Past Due by Project section.","Subject Area","Business Process ","Steps Past Due by Project Section","83524.htm");
Page[47]=new Array("Purpose","The chart compares the Workflow Average Planned Duration (DD:HH:MM) to Workflow Average Actual Duration (DD:HH:MM). The workflow data represented in the chart can be selected in the Business Process Name menu.","Location","On the Home page, click Dashboards.","Under Primavera, select Business Processes.","On the Business Processes dashboard, click the Workflow page.","On the Workflow page, expand the Planned vs. Actual Workflow Duration section.","Subject Area","Business Process ","Planned vs. Actual Workflow Duration Section","83526.htm");
Page[48]=new Array("Purpose","The Revisited Workflow Steps table shows projects and their respective steps. The table contains the following columns:","Project Id","Project Name","Record Number","Title","Setup Name","Step Sequence","Step Name","Step Start Date","Step End Date","The steps are color coded to indicate how many times each step has been revisited:","White: The step has not been revisited.","Yellow: The step has been revisited once.","Orange: The step has been revisited twice.","Red: The step has been revisited 3 times or more.","Location","On the Home page, click Dashboards.","Under Primavera, select Business Processes.","On the Business Processes dashboard, click the Workflow page.","On the Workflow page, expand the Revisited Workflow Steps section.","Subject Area","Business Process ","Revisited Workflow Steps Section","83528.htm");
Page[49]=new Array("Purpose","The chart shows Workflow duration sorted by Project Name.","The table shows open Workflows sorted by duration.  The table contains the following columns:","Project Id","Project Name","Record Number","Title","Workflow Name","Setup Name","Workflow Start Date","Workflow Duration DD:HH:MM","Location","On the Home page, click Dashboards.","Under Primavera, select Business Processes.","On the Business Processes dashboard, click the Workflow page.","On the Workflow page, expand the Top 10 Open Workflows by Duration section.","Subject Area","Business Process ","Top 10 Open Workflows by Duration Section","83530.htm");
Page[50]=new Array("Purpose","The Completed Tasks by Month table shows the month and year on the x-axis and the number of completed tasks on the y-axis. The assignee data represented in the chart can be selected in the Assignee menu.","Location","On the Home page, click Dashboards.","Under Primavera, select Business Processes.","On the Business Processes dashboard, click the Workflow page.","On the Workflow page, expand the Completed Tasks by Month section.","Subject Area","Business Process ","Completed Tasks by Month Section","83532.htm");
Page[51]=new Array("Purpose","The Task Status Table shows assignees and the number of assigned tasks.","The Task Assignee Status Count chart shows Number of Tasks, sorted by Assignee.","The Task Assignee Counts and Percents table shows the progress of each Assignee towards assigned tasks. The table contains the following columns:","Assignee","Total Tasks","Completed Tasks","Non Response Rate","Completed Tasks (Late)","Late Response Rate","Location","On the Home page, click Dashboards.","Under Primavera, select Business Processes.","On the Business Processes dashboard, click the Workflow page.","On the Workflow page, expand the Task Assignee Details section.","Subject Area","Business Process ","Task Assignee Details Section","83534.htm");
Page[52]=new Array("The Cash Flow dashboard uses data from Primavera Unifier. ","It enables you to view aggregated cost sheet data across projects and cost codes, including comparisons of actuals vs. forecast and forecast vs. baseline. You can easily slice the data by various dimensions, including location, project owner, and portfolio.","Primavera Analytics supports the following Unifier picker and data picker elements which can be configured in the Unifier &gt; Administration Mode &gt; Analytics &gt; Business Processes option: ","BP Picker","User Picker","Shell Picker","Space Picker","BP Data Picker","Shell Data Picker","User Data Picker","Cash Flow Dashboard","83083.htm");
Page[53]=new Array("This page shows cash flow data, including comparisons of actuals vs. forecast, and forecast vs. baseline.  It contains the following narratives:","Initial Baseline shows the total of the Initial Baselines for all cash flows.","Current Baseline shows the total of the Current Baselines for all cash flows.","Actual shows the total of the Actuals for all cash flows.","Forecast shows the total of the Forecasts for all cash flows.","Overview Page","83086.htm");
Page[54]=new Array("Purpose","The line graph shows lines for:","Initial Baseline (Cumulative)","Current Baseline (Cumulative)","Actuals (Cumulative)","Forecast (Cumulative)","The x-axis shows months. The y-axis shows cash flow values.","The pivot table contains columns for:","Year Name","Periodic","Initial Baseline","Current Baseline","Actuals","Forecast","Cumulative","Initial Baseline","Current Baseline","Actuals","Forecast","Right-click on Project Hierarchy elements in the Project Filter pivot table and select Keep Only to filter the contents of the pivot table and line graph.","Location","On the Home page, click Dashboards.","Under Primavera, select Cash Flow.","On the Cash Flow dashboard, click the Overview page.","On the Overview page, expand the Cash Flow Summary by Project section.","Subject Area","Cash Flow","Cash Flow Summary by Project Section","83103.htm");
Page[55]=new Array("Purpose","The line chart shows lines for:","Initial Baseline (Cumulative)","Current Baseline (Cumulative)","Actuals (Cumulative)","Forecast (Cumulative)","The x-axis shows months. The y-axis shows cash flow values.","The pivot table contains columns for:","Year Name","Periodic","Initial Baseline","Current Baseline","Actuals","Forecast","Cumulative","Initial Baseline","Current Baseline","Actuals","Forecast","Right-click on Project Hierarchy elements in the Project Filter pivot table and select Keep Only to filter the contents of the pivot table and line chart.","Location","On the Home page, click Dashboards.","Under Primavera, select Cash Flow.","On the Cash Flow dashboard, click the Overview page.","On the Overview page, expand the Cash Flow Summary by CBS section.","Subject Area","Cash Flow","Cash Flow Summary by CBS Section","83104.htm");
Page[56]=new Array("This page shows cash flow history analyses.","History Page","83091.htm");
Page[57]=new Array("Purpose","The pivot table shows weekly details for the selected project. It shows columns for:","Week Name","Actuals","Forecast","% Complete ((Actuals / (Actuals + Forecast)) * 100)","The line-bar chart shows bars for Actuals and Forecast for the selected project. The line represents Percent Complete.","The x-axis shows weeks. The y-axis for the bars (on the left) shows cash flow values. The y-axis for the line (on the right) shows percentages.","Location","On the Home page, click Dashboards.","Under Primavera, select Cash Flow.","On the Cash Flow dashboard, click the History page.","On the History page, expand the Actual vs Forecast Weekly Trend section.","Subject Area","Cash Flow History","Actual vs Forecast Weekly Trend Section","83105.htm");
Page[58]=new Array("Purpose","The line-bar chart shows bars for Initial Baseline and Current Baseline for the selected cash flow. The line represents Budget Variance.","The x-axis shows weeks. The y-axis for the bars (on the left) shows cash flow values. The y-axis for the line (on the right) shows baseline variance values.","The pivot table shows weekly details for the selected cash flow. It shows columns for:","Week Name","Initial Baseline","Current Baseline","Baseline Variance (Current Baseline - Initial Baseline)","Location","On the Home page, click Dashboards.","Under Primavera, select Cash Flow.","On the Cash Flow dashboard, click the History page.","On the History page, expand the Baseline Variance Weekly Trend section.","Subject Area","Cash Flow History","Baseline Variance Weekly Trend Section","83106.htm");
Page[59]=new Array("The Cost Sheet dashboard uses data from Primavera Unifier.","It enables you to view aggregated cost sheet data across projects and cost codes, including a comparison of original and revised budget details, cost data by geographic location, and cost history analyses. You can easily slice the data by various dimensions, including location, project owner, and portfolio.","Primavera Analytics supports the following Unifier picker and data picker elements which can be configured in the Unifier &gt; Administration Mode &gt; Analytics &gt; Business Processes option: ","BP Picker","User Picker","Shell Picker","Space Picker","BP Data Picker","Shell Data Picker","User Data Picker","Cost Sheet Dashboard","83084.htm");
Page[60]=new Array("This page shows cost data, including a comparison of original and revised budget details.","This dashboard provides the following narratives:","Budget shows the total of the Budget cost sheet column.","Commitments shows the total of the Commitments cost sheet column.","Forecast shows the total of the Forecast cost sheet column.","Overview Page","83087.htm");
Page[61]=new Array("Purpose","The line-bar chart shows bars for Original Budget and Revised Budget. The line represents the difference between Original Budget and Revised Budget shown as a percentage.","The x-axis shows projects. The y-axis for the bars (on the left) shows cost sheet values. The y-axis for the line (on the right) shows percentages.","The table contains columns for:","Project Name (root-level)","Original Budget","Revised Budget","% Difference (((Revised Budget - Original Budget) / Original Budget) * 100)","Location","On the Home page, click Dashboards.","Under Primavera, select Cost Sheet.","On the Cost Sheet dashboard, click the Overview page.","On the Overview page, expand the Original and Revised Budgets section.","Subject Area","Cost Sheet","Original and Revised Budgets Section","83107.htm");
Page[62]=new Array("Purpose","The line-bar chart shows bars for Original Commitments and Approved Commitment Changes. The line represents the difference between Original Commitments and Revised Commitments shown as a percentage.","The x-axis shows root-level projects. The y-axis for the bars (on the left) shows cost sheet values. The y-axis for the line (on the right) shows percentages.","The table contains columns for:","Project Name (root-level)","Original Commitments","Approved Commitment Changes","% Difference (((Approved Commitment Changes - Original Commitments) / Original Commitments) * 100)","Location","On the Home page, click Dashboards.","Under Primavera, select Cost Sheet.","On the Cost Sheet dashboard, click the Overview page.","On the Overview page, expand the Original and Revised Commitments section.","Subject Area","Cost Sheet","Original and Revised Commitments Section","83109.htm");
Page[63]=new Array("Purpose","The line-bar chart shows bars for Revised Budget and Forecast. The line represents the change between Revised Budget and Forecast shown as a percentage.","The x-axis shows root-level projects. The y-axis for the bars (on the left) shows cost sheet values. The y-axis for the line (on the right) shows percentages.","The table contains columns for:","Project Name (root-level)","Revised Budget","Forecast","% Change (((Forecast - Revised Budget) / Revised Budget) * 100)","Location","On the Home page, click Dashboards.","Under Primavera, select Cost Sheet.","On the Cost Sheet dashboard, click the Overview page.","On the Overview page, expand the Budget vs. Forecast section.","Subject Area","Cost Sheet","Budget vs. Forecast Section","83110.htm");
Page[64]=new Array("Purpose","The pivot table contains columns for:","CBS Hierarchy","Budget","Original","Revised","Commitments","Original","Revised","Commitment Changes","Pending","Approved","Payment Applications","Approved","Pending","Costs","Forecast","Right-click on Project Hierarchy elements in the left pivot table and select Keep Only to filter the contents of the pivot table on the right.","Location","On the Home page, click Dashboards.","Under Primavera, select Cost Sheet.","On the Cost Sheet dashboard, click the Overview page.","On the Overview page, expand the Cost Sheet Summary section.","Subject Area","Cost Sheet","Cost Sheet Summary Section","83111.htm");
Page[65]=new Array("Purpose","The bar chart shows bars for Revised Budget and Forecast cost sheet values by Project Owner.","Location","On the Home page, click Dashboards.","Under Primavera, select Cost Sheet.","On the Cost Sheet dashboard, click the Overview page.","On the Overview page, expand the Budget by Owner section.","Subject Area","Cost Sheet","Budget by Owner Section","83112.htm");
Page[66]=new Array("This page shows cost data by geographic location.","Location Page","83089.htm");
Page[67]=new Array("Purpose","The map shows Revised Budget percentages by geographic location. Hover over a highlighted area to show details for that area. Use the control to zoom in details by state and city. ","The line-bar chart shows bars for Forecast Budget and Revised Budget for projects in the selected country.  The line represents the difference between Forecast Budget and Revised Budget shown as a percentage. The x-axis shows projects. The y-axis for the bars (left) shows cost sheet values. The y-axis for the line (right) shows percentages.","Location","On the Home page, click Dashboards.","Under Primavera, select Cost Sheet.","On the Cost Sheet dashboard, click the Location page.","On the Location page, expand the Revised Budget by Location section.","Subject Area","Cost Sheet","Revised Budget by Location Section","83113.htm");
Page[68]=new Array("This page shows cost history analyses.","History Page","83092.htm");
Page[69]=new Array("Purpose","The line chart shows weekly cost sheet values for Forecast and Revised Budget. ","The x-axis shows weeks. The y-axis shows values.","Location","On the Home page, click Dashboards.","Under Primavera, select Cost Sheet.","On the Cost Sheet dashboard, click the History page.","On the History page, expand the Revised Budget vs. Forecast Weekly Trend section.","Subject Area","Cost Sheet History","Revised Budget vs. Forecast Weekly Trend Section","83114.htm");
Page[70]=new Array("Purpose","The line-bar chart shows bars for Pending Budget Revisions, Approved Budget Revisions, and Revised Budget by week. The line represents Original Budget.","The pivot table shows weekly budget cost sheet values. It contains columns for:","Project Hierarchy","Week Name","Original Budget","Pending Budget Revisions","Approved Budget Revisions","Revised Budget","Budget Variance (Revised Budget - Original Budget)","Weekly Difference (Revised Budget for current week - Revised Budget for previous week)","Location","On the Home page, click Dashboards.","Under Primavera, select Cost Sheet.","On the Cost Sheet dashboard, click the History page.","On the History page, expand the Budget section.","Subject Area","Cost Sheet History","Budget Section","83115.htm");
Page[71]=new Array("Purpose","The line-bar chart shows weekly contract cost sheet values. The bars show Pending and Approved amounts. The lines represent Contracts and Current Commitments.","Location","On the Home page, click Dashboards.","Under Primavera, select Cost Sheet.","On the Cost Sheet dashboard, click the History page.","On the History page, expand the Contracts section.","Subject Area","Cost Sheet History","Contracts Section","83116.htm");
Page[72]=new Array("Purpose","The pivot table shows cost sheet values rolled up to the levels expanded in the Date Hierarchy. It contains columns for:","Date Hierarchy","Costs","Revised Budget","Revised Commitments","Approved Spends","Forecast","Location","On the Home page, click Dashboards.","Under Primavera, select Cost Sheet.","On the Cost Sheet dashboard, click the History page.","On the History page, expand the Cost Summary section.","Subject Area","Cost Sheet History","Cost Summary Section","83117.htm");
Page[73]=new Array("The Facilities and Real Estate dashboard uses data from Primavera Unifier.","Facilities and Real Estate Dashboard","83716.htm");
Page[74]=new Array("This page shows facilities and real estate data from Primavera Unifier, including custom facts and dimensions for buildings, levels, and spaces."," @","It contains the following narratives:","Gross Building Area","Floor Rentable Area","Floor Usable Area","Floor Common Area","You can drill down to get details for all narratives.","Overview Page","83717.htm");
Page[75]=new Array("Purpose","The map shows space by geographic location. Hover over a highlighted area to show details for that area. Use the control to zoom in details by state and city.","Location","On the Home page, click Dashboards.","Under Primavera, select Facilities and Real Estate.","On the Facilities and Real Estate dashboard, click the Overview page.","On the Overview page, expand the Space by Location section.","Subject Area","Space Management","Space by Location Section","83719.htm");
Page[76]=new Array("Purpose","The bar graph show expiring leased area for the selected project.  You can drill down to get details for each month.","The x-axis shows the expiring month. The y-axis shows expiring leased area in square feet.","Location","On the Home page, click Dashboards.","Under Primavera, select Facilities and Real Estate.","On the Facilities and Real Estate dashboard, click the Overview page.","On the Overview page, expand the Lease Expirations section.","Subject Area","Business Process","Lease Expirations Section","83720.htm");
Page[77]=new Array("Purpose","The table contains columns for:","Building","Current Monthly Rent","Rent with Multiplier","Delta","Location","On the Home page, click Dashboards.","Under Primavera, select Facilities and Real Estate.","On the Facilities and Real Estate dashboard, click the Overview page.","On the Overview page, expand the Rent by Building section.","Subject Area","Space Management","Space Management History","Cost Sheet","Rent by Building","83721.htm");
Page[78]=new Array("Purpose","The pie chart shows record counts for each status of the selected work order type.","Location","On the Home page, click Dashboards.","Under Primavera, select Facilities and Real Estate.","On the Facilities and Real Estate dashboard, click the Overview page.","On the Overview page, expand the Work Order by Status section.","Subject Area","Business Process","Work Order by Status Section","83722.htm");
Page[79]=new Array("This page shows space management level and space details.","It provides the following narratives:","Vacancy Rate","# of Vacant Spaces","You can drill down to get details for both narratives.","Space Management Page","83718.htm");
Page[80]=new Array("Purpose","The stacked area chart displays rentable area for each floor broken down by Usable Area and Common Area.  The x-axis shows the Level Name. The y-axis shows percentages.","Location","On the Home page, click Dashboards.","Under Primavera, select Facilities and Real Estate.","On the Facilities and Real Estate dashboard, click the Space Management page.","On the Space Management page, expand the Floor Rentable Area section.","Subject Area","Space Management","Floor Rentable Area Section","83723.htm");
Page[81]=new Array("Purpose","The tree map displays area by space type broken down by building name, number of space records, and area. ","Location","On the Home page, click Dashboards.","Under Primavera, select Facilities and Real Estate.","On the Facilities and Real Estate dashboard, click the Space Management page.","On the Space Management page, expand the Area by Space Type section.","Subject Area","Space Management","Area by Space Type Section","83872.htm");
Page[82]=new Array("Purpose","The pie chart displays spaces by level status broken down by level status and number of space records.","Location","On the Home page, click Dashboards.","Under Primavera, select Facilities and Real Estate.","On the Facilities and Real Estate dashboard, click the Space Management page.","On the Space Management page, expand the Spaces by Level Status section.","Subject Area","Space Management","Spaces by Level Status Section","83873.htm");
Page[83]=new Array("Purpose","The table shows space for the selected Assigned Department, and contains columns for:","Building","Space Type Name","Space Name","Area","Unit of Measure","Monthly Rent","Location","On the Home page, click Dashboards.","Under Primavera, select Facilities and Real Estate.","On the Facilities and Real Estate dashboard, click the Space Management page.","On the Space Management page, expand the Space by Assigned Department section.","Subject Area","Space Management","Space by Assigned Department Section","83724.htm");
Page[84]=new Array("Purpose","The pivot table shows space for the selected Tenant Name, and contains columns for:","Building","Space Type Name","Space Name","Area","Unit of Measure","Monthly Rent","Location","On the Home page, click Dashboards.","Under Primavera, select Facilities and Real Estate.","On the Facilities and Real Estate dashboard, click the Space Management page.","On the Space Management page, expand the Space by Tenant section.","Subject Area","Space Management","Space by Tenant Section","83874.htm");
Page[85]=new Array("Purpose","The pivot table contains columns for:","Area","Unit of Measure","Monthly Rent","Price per (UoM)","# of Space Records","Location","On the Home page, click Dashboards.","Under Primavera, select Facilities and Real Estate.","On the Facilities and Real Estate dashboard, click the Space Management page.","On the Space Management page, expand the Rents &amp; Records by Property Hierarchy section.","Subject Area","Space Management","Rent &amp; Records by Property Hierarchy Section","83725.htm");
Page[86]=new Array("Purpose","The pivot table shows Building Owners and Managers Association (BOMA) details for the selected building. It includes columns for:","Level Name","Gross Building Area","Gross Measured Area","Major Vert Pen. ","Floor Rentable Area","Useable Areas","Office Area","Store Area","Building Common Area","Floor Useable Area","Floor Common Area","Floor R/U Ratio","Combined R/U Ratio","Location","On the Home page, click Dashboards.","Under Primavera, select Facilities and Real Estate.","On the Facilities and Real Estate dashboard, click the Space Management page.","On the Space Management page, expand the Building Owners and Managers Association (BOMA) section.","Subject Area","Space Management","Building Owners and Managers Association (BOMA) Section","83726.htm");
Page[87]=new Array("This page shows historical space management level and space details.","It provides the following narratives:","Total Rent Collected","Largest month over month rent increase","Largest month over month rent decline","Month(s) with Rent Decline","You can drill down to get details for the following narratives:","Largest month over month rent increase","Month(s) with Rent Decline","Space Management History Page","83875.htm");
Page[88]=new Array("Purpose","The line-bar chart displays rent history broken down by month name and monthly rent.  The x-axis shows the year and month. The y-axis shows the cost of the monthly rent.","The pivot table shows area history details for the selected building. It includes columns for:","Month Name","This Month Vacant Area","Vacant Area Last Month","Area Vacancy Delta","Location","On the Home page, click Dashboards.","Under Primavera, select Facilities and Real Estate.","On the Facilities and Real Estate dashboard, click the Space Management History page.","On the Space Management History page, expand the Rent &amp; Area History section.","Subject Area","Space Management History","Rent &amp; Area History Section","83877.htm");
Page[89]=new Array("Purpose","The pivot table shows level summary history details for the selected building. It includes columns for:","Building","Level Name","Link to Level Log","Month Name","Gross Building Area","Floor Rentable Area","Floor Useable Area","Floor Common Area","Location","On the Home page, click Dashboards.","Under Primavera, select Facilities and Real Estate.","On the Facilities and Real Estate dashboard, click the Space Management History page.","On the Space Management History page, expand the Level Summary History section.","Subject Area","Space Management History","Level Summary History Section","83878.htm");
Page[90]=new Array("Purpose","The pivot table shows BOMA details by month for the selected building. It includes columns for:","Level Name","Gross Building Area","Gross Measured Area","Major Vert Pen. ","Floor Rentable Area","Useable Areas","Office Area","Store Area","Building Common Area","Floor Useable Area","Floor Common Area","Floor R/U Ratio","Combination R/U Ratio","Location","On the Home page, click Dashboards.","Under Primavera, select Facilities and Real Estate.","On the Facilities and Real Estate dashboard, click the Space Management History page.","On the Space Management History page, expand the BOMA Sheet by Month section.","Subject Area","Space Management History","BOMA Sheet by Month Section","83879.htm");
Page[91]=new Array("Purpose","The pie chart on the left displays the selected tenant's area broken down by building, space type name, space name, unit of measure, month name, and area. The pie chart on the right shows the selected tenant's monthly rent broken down by building, space type name, space name, unit of measure, month name, and monthly rent.","The pivot table shows space history details for the selected building. It includes columns for:","Building","Space Type Name","Space Name","Unit of Measure","Month Name","Area","Monthly Rent","Location","On the Home page, click Dashboards.","Under Primavera, select Facilities and Real Estate.","On the Facilities and Real Estate dashboard, click the Space Management History page.","On the Space Management History page, expand the Space History by Tenant section.","Subject Area","Space Management History","Space History by Tenant Section","83880.htm");
Page[92]=new Array("Purpose","The pivot table shows historical rents details for the selected building. It includes columns for:","Level Name","Level Status","Month Name","Area","Monthly Rent","Price per Square Ft.","Location","On the Home page, click Dashboards.","Under Primavera, select Facilities and Real Estate.","On the Facilities and Real Estate dashboard, click the Space Management History page.","On the Space Management History page, expand the Historical Rents by Building section.","Subject Area","Space Management History","Historical Rents by Building Section","83881.htm");
Page[93]=new Array("Purpose","The pivot table shows historical rent details for the selected department. It includes columns for:","Building","Space Type Name","Space Name","Month Name","Area","Unit of Measure","Monthly Rent","Location","On the Home page, click Dashboards.","Under Primavera, select Facilities and Real Estate.","On the Facilities and Real Estate dashboard, click the Space Management History page.","On the Space Management History page, expand the Historical Rent by Department section.","Subject Area","Space Management History","Historical Rent by Department Section","83882.htm");
Page[94]=new Array("This page shows cost sheet details. Expand the Leases and Budget sections to view the following:","It provides the following narratives:","Leases","Lease Amend. Requests","Lease Invoices","Lease Payments","Leases","Budget","Annual Budget","Budget Changes","You can drill down to get details for the following narratives:","Leases","Leases","Budget","Annual Budget","Cost Sheet Page","83876.htm");
Page[95]=new Array("Purpose","The pie chart on the right displays details of the annual budget (approved). It is broken down by the root level cost code: asset, expenses, liability, and revenue.","The table on the left shows the approved budget by root level cost code details for the selected building.","Location","On the Home page, click Dashboards.","Under Primavera, select Facilities and Real Estate.","On the Facilities and Real Estate dashboard, click the Cost Sheet page.","On the Cost Sheet page, expand the Approved Budget by Root Cost Code section.","Subject Area","Cost Sheet","Approved Budget by Root Cost Code Section","83883.htm");
Page[96]=new Array("Purpose","Depending on the selection, the bar graph on the right displays annual budget (approved), budget changes-FM (approved), purchase orders-FM (approved), or invoices-generic-FM (approved) details.  Depending on the selection, the x-axis represents the year, quarter, or month name. The y-axis represents the cost.","The pivot table to the left displays the cost code hierarchy. You can view the hierarchy and break down of each cost code: asset, equity, expenses, liability, and revenue.  ","Location","On the Home page, click Dashboards.","Under Primavera, select Facilities and Real Estate.","On the Facilities and Real Estate dashboard, click the Cost Sheet page.","On the Cost Sheet page, expand the Cost Sheet section.","Subject Area","Cost Sheet","Cost Sheet Section","83884.htm");
Page[97]=new Array("Purpose","The tree map displays lease and budget details by building name. It is broken down by project hierarchy name level, lease (active) amount, and the annual budget (approved).","Location","On the Home page, click Dashboards.","Under Primavera, select Facilities and Real Estate.","On the Facilities and Real Estate dashboard, click the Cost Sheet page.","On the Cost Sheet page, expand the Lease and Budget by Building section.","Subject Area","Cost Sheet","Lease and Budget by Building Section","83885.htm");
Page[98]=new Array("Purpose","Depending on the selection, the line-bar chart displays details of the current, revised, or remaining budget by month. It is broken down by month name and the current budget. The x-axis shows the month name . The y-axis shows the current budget.","Location","On the Home page, click Dashboards.","Under Primavera, select Facilities and Real Estate.","On the Facilities and Real Estate dashboard, click the Cost Sheet page.","On the Cost Sheet page, expand the Budget by Month section.","Subject Area","Cost Sheet","Budget by Month Section","83886.htm");
Page[99]=new Array("The Portfolio Analysis dashboard uses data from P6 EPPM. ","It contains important portfolio information based on project performance, project costs, risks, and rewards by project, strategic objectives, and multiple ratings of project codes.","Portfolio Analysis Dashboard","81912.htm");
Page[100]=new Array("This page shows ratings, performance, and cost information broken down by project or sponsor.","Overview Page","81913.htm");
Page[101]=new Array("Purpose","The bubble chart plots projects according to their financial and strategic rating.","The x-axis shows Financial Rating. The y-axis shows Strategic Rating. Bubble size represents At Completion Total Cost, with a larger bubble representing a larger value. Bubble color is used only to differentiate between bubbles. Hover over a bubble for specific details.","Location","On the Home page, click Dashboards.","Under Primavera, select Facilities and Real Estate.","On the Facilities and Real Estate dashboard, click the Overview page.","On the Overview page, expand the Project Investment Map section.","Subject Area","Activity","Project Investment Map Section","81914.htm");
Page[102]=new Array("Purpose","The pivot table shows proposed and committed costs broken down by the project codes you select in the View by lists. Use the left view by list to select the project code to be used on the left side of the table. Use the right View by list to select the project code to be used across the top of the table.","Left view by list project codes:","Sponsor","Business Segment","Project Manager","Project Type","Strategic Objective","Right view by list project codes:","Location","Business Segment","Project Manager","Project Type","Strategic Objective","Proposed Cost is displayed in blue italicized text. Committed Cost is displayed in black text.","Location","On the Home page, click Dashboards.","Under Primavera, select Portfolio Analysis.","On the Portfolio Analysis dashboard, click the Overview page.","On the Overview page, expand the Proposed vs. Committed Cost section.","Subject Area","Activity","Proposed vs. Committed Cost Section","81916.htm");
Page[103]=new Array("Purpose","The bar chart shows stacked bars plotting the At Completion Total Cost per sponsor. Each band on a bar represents a different project and bands are colored according to their project score, which is a measure of their performance. Blue bands represent projects with a project score of more than 65; red bands represent poorly performing projects with a project score of less than 65.","The x-axis shows investment Cost. The y-axis shows the project Sponsor. Hover over a bar for specific data and click on the bar to drill down to see more information about the project.","Location","On the Home page, click Dashboards.","Under Primavera, select Portfolio Analysis.","On the Portfolio Analysis dashboard, click the Overview page.","On the Overview page, expand the Project Performance by Sponsor section.","Subject Area","Activity","Project Performance by Sponsor Section","81918.htm");
Page[104]=new Array("Purpose","The table displays portfolio budget at completion (units) and budget at completion (cost) details.","Location","On the Home page, click Dashboards.","Under Primavera, select Portfolio Analysis.","On the Portfolio Analysis dashboard, click the Overview page.","On the Overview page, expand the Budget at Completion by Portfolio section.","Subject Area","Activity","Budget at Completion by Portfolio Section","83888.htm");
Page[105]=new Array("This page displays performance data for each portfolio. Find the monthly Schedule Performance Index (SPI) and Cost Performance Index (CPI), as well as units and cost statistics for every project in your portfolio.","Performance Page","81920.htm");
Page[106]=new Array("Purpose","The pivot table shows CPI and SPI per month for each portfolio. CPIs and SPIs lower than 1.000 are highlighted in red; CPIs and SPIs higher than 1.000 are highlighted in green. Values of exactly 1.000 are not highlighted.","Location","On the Home page, click Dashboards.","Under Primavera, select Portfolio Analysis.","On the Portfolio Analysis dashboard, click the Performance page.","On the Performance page, expand the Portfolio Analysis Trending section.","Subject Area","Activity","Portfolio Analysis Trending Section","81921.htm");
Page[107]=new Array(" @","Purpose","The pivot table shows cost and units for each portfolio. Values that are over budget are highlighted in red text.","The pivot table contains columns for:","Portfolio Name","Actual (Cost)","At Completion (Cost)","Budgeted (Cost)","Variance (Cost)","Actual (Units)","At Completion (Units)","Budgeted (Units)","Variance (Units)","Location","On the Home page, click Dashboards.","Under Primavera, select Portfolio Analysis.","On the Portfolio Analysis dashboard, click the Performance page.","On the Performance page, expand the Portfolio View section.","Subject Area","Activity","Portfolio View Section","81923.htm");
Page[108]=new Array("This page displays the priority of your projects. You can find information on the financial rating and risk of each project, group them by multiple ratings, or see the current phase of each project, separated by strategic rating.","Prioritization Page","81925.htm");
Page[109]=new Array("Purpose","The bubble chart plots projects according to their financial rating and risk. Bubbles in the red quadrant of the bubble chart have a low financial rating (reward) and a high risk; those in the white quadrant have a low risk but offer a high reward. Risk in this case is a project code and is not related to P6 EPPM risks functionality.","The x-axis shows Risk. The y-axis shows Financial Rating. Bubble size represents current budget, with a larger bubble representing a larger value. Bubble color is used only to differentiate between bubbles. Hover over a bubble for specific details.","The pivot table groups projects according to their priority. The pivot table contains columns for:","Project Priority","Project Name","Current Budget","Strategic Rating","Use the up and down arrows below the table to navigate to other sections of the table. Use the double-ended arrow to view the whole table in one screen (to a maximum of 500 rows per page).","Location","On the Home page, click Dashboards.","Under Primavera, select Portfolio Analysis.","On the Portfolio Analysis dashboard, click the Prioritization page.","On the Prioritization page, expand the Risk vs. Reward section.","Subject Area","Activity","Risk vs. Reward Section","81926.htm");
Page[110]=new Array("Purpose","The bar chart shows the number of projects for each strategic rating, grouped by the current phase project code. Each band on a bar represents a different value of the current phase sample project code.","The x-axis shows the number of projects. The y-axis shows Strategic Rating. Hover over a band to see specific information.","Location","On the Home page, click Dashboards.","Under Primavera, select Portfolio Analysis.","On the Portfolio Analysis dashboard, click the Prioritization page.","On the Prioritization page, expand the Project Initiation section.","Subject Area","Activity","Project Initiation Section","81929.htm");
Page[111]=new Array("Purpose","The radar chart shows project code ratings per project. ","Each colored line on the chart represents a separate project. The axes show the following project codes:","Financial Rating","Resource Rating","Strategic Rating","Technology Rating","Risk Rating","Location","On the Home page, click Dashboards.","Under Primavera, select Portfolio Analysis.","On the Portfolio Analysis dashboard, click the Prioritization page.","On the Prioritization page, expand the Rating section.","Subject Area","Activity","Rating Section","81931.htm");
Page[112]=new Array("Purpose","The pivot table sorts projects by project score (descending). Project scores above 85 are highlighted in green; project scores from 65 to 85 are highlighted in yellow; project scores below 65 are highlighted in red.","The pivot table contains columns for:","Project Name","Project Score","Financial Rating","Resource Rating","Strategic Rating","Technology Rating","Location","On the Home page, click Dashboards.","Under Primavera, select Portfolio Analysis.","On the Portfolio Analysis dashboard, click the Prioritization page.","On the Prioritization page, expand the Project Prioritization - Force Rank by Score section.","Subject Area","Activity","Project Prioritization - Force Rank by Score Section","81933.htm");
Page[113]=new Array("This page shows the investment breakdown and performance of projects by the Strategic Objective project code.","Objectives Page","81935.htm");
Page[114]=new Array("Purpose","The pie chart shows the investment (determined from At Completion Total Cost for the project) broken down by the Strategic Objective project code. The segments represent the amount of At Completion Total Cost accountable to each Strategic Objective.","The Strategic Objective project codes are:","Improved Customer Satisfaction","Increased Customer Retention","Reduced Cycle Time","Regulatory Compliance","Revenue Growth","Location","On the Home page, click Dashboards.","Under Primavera, select Portfolio Analysis.","On the Portfolio Analysis dashboard, click the Objectives page.","On the Objectives page, expand the Investment by Strategic Objective section.","Subject Area","Activity","Investment by Strategic Objective Section","81936.htm");
Page[115]=new Array("Purpose","The Improved Customer Satisfaction, Increased Customer Retention, Reduced Cycle Time, Regulatory Compliance, and Revenue Growth stacked bar charts show the investment amount for projects grouped by sponsor name. Each chart shows data for a different set of projects, selected by a project code. Each band on a bar represents a different project. Hover over a section of a bar to see specific data.","The x-axis shows Investment. The y-axis shows Sponsor.","Location","On the Home page, click Dashboards.","Under Primavera, select Portfolio Analysis.","On the Portfolio Analysis dashboard, click the Objectives page.","On the Objectives page, expand the Project Performance by Strategic Objective section.","Subject Area","Activity","Project Performance by Strategic Objective Section","81938.htm");
Page[116]=new Array("The Project Earned Value dashboard gives an overview of the earned value status of your projects, including SPI and CPI. This dashboard is available for: ","P6 EPPM","Unifier","Project Earned Value Dashboard for P6 EPPM","81940.htm");
Page[117]=new Array("This page shows statistics on a project's planned value, earned value, actual costs, and the estimated cost at completion, grouped by month or project manager.","Overview Page","81941.htm");
Page[118]=new Array("Purpose","Use the Select a View list to determine how cost information displays. The available views are:","Periodic/Cumulative","Periodic","Cumulative","The line-bar chart shows cost information dependent on the view you select:","Bars for Actual Total Cost, Earned Value (Cost), Planned Value (Cost), and Estimate At Completion (Cost)","Lines for cumulative values of Actual Cost, Earned Value, Planned Value, and Estimate At Completion","The x-axis of the chart shows the year and month. The y-axis for the bars, on the left, shows period Cost. The y-axis for the lines, on the right, shows Cost (Cumulative).","The pivot table breaks down cost data by year, quarter, and month. Depending on the selected view, the table contains columns for:","Year Name","Quarter Name","Month Name","Actual Total Cost","Actual Cost (Cumulative)","Earned Value (Cost)","Earned Value (Cumulative)","Planned Value (Cost)","Planned Value (Cumulative)","Estimate At Completion (Cost)","Estimate At Completion (Cumulative)","Location","On the Home page, click Dashboards.","Under Primavera, select Project Earned Value.","On the Project Earned Value dashboard, click the Overview page.","On the Overview page, expand the Earned Value section.","Subject Area","Activity","Earned Value Section","81942.htm");
Page[119]=new Array("Purpose","Use the Select a View list to determine whether this cost information displays as a bar chart or table. Regardless of the view chosen, the data is the same.","The bar chart breaks down data by the Project Manager project code and shows bars for:","Actual Total Cost","Earned Value (Cost)","Planned Value (Cost)","Estimate to Complete (Cost)","The x-axis shows Cost. The y-axis shows the Project Manager project code. Hover over a bar to see specific information.","The table breaks data down by Project Manager and shows columns for:","Project Manager","Actual Total Cost","Earned Value (Cost)","Planned Value (Cost)","Estimate to Complete (Cost)","Location","On the Home page, click Dashboards.","Under Primavera, select Project Earned Value.","On the Project Earned Value dashboard, click the Overview page.","On the Overview page, expand the Project Earned Value Breakdown section.","Subject Area","Activity","Project Earned Value Breakdown Section","81953.htm");
Page[120]=new Array("This page provides CPI and SPI information, helping you to identify which projects are over budget or behind schedule.","CPI/SPI Page","81944.htm");
Page[121]=new Array("Purpose","The scatter chart plots each project according to its SPI and CPI.","The x-axis shows Schedule Performance Index (Cost). The y-axis shows Cost Performance Index (Cost). Hover over a point to see specific information.","Location","On the Home page, click Dashboards.","Under Primavera, select Project Earned Value.","On the Project Earned Value dashboard, click the CPI/SPI page.","On the CPI/SPI page, expand the Cost &amp; Schedule Performance Index section.","Subject Area","Activity","Cost &amp; Schedule Performance Index Section","81945.htm");
Page[122]=new Array("Purpose","This section shows:","A line chart which plots the CPI and Cumulative CPI by month.","A line chart which plots the SPI and Cumulative SPI by month.","The x-axis shows the month and year. The y-axis shows the Cost Performance Index or the Schedule Performance Index.","Note: Cumulative SPI and Cumulative CPI are calculated from cumulative values, rather than being accumulations of CPI or SPI values from previous periods.","Location","On the Home page, click Dashboards.","Under Primavera, select Project Earned Value.","On the Project Earned Value dashboard, click the CPI/SPI page.","On the CPI/SPI page, expand the CPI/SPI section.","Subject Area","Activity","CPI/SPI Section","81949.htm");
Page[123]=new Array("Purpose","The bubble chart plots bubbles for projects according to their Cost Performance Index (Cost) and Schedule Performance Index (Cost). The location of each bubble in the chart will tell you whether the project it represents is under or over budget (above or below the horizontal center, respectively) and whether it is behind or ahead of schedule (left or right of the vertical center, respectively).","The x-axis shows Schedule Performance Index (Cost). The y-axis shows Cost Performance Index (Cost). Bubble size represents At Completion Total Cost, with larger bubbles representing larger values. Bubble color is used only to differentiate between bubbles. Hover over a bubble for specific details.","Location","On the Home page, click Dashboards.","Under Primavera, select Project Earned Value.","On the Project Earned Value dashboard, click the CPI/SPI page.","On the CPI/SPI page, expand the Performance Index section.","Subject Area","Activity","Performance Index Section","81951.htm");
Page[124]=new Array("This page provides a detailed view of a project's earned value, total costs, and estimate at completion costs.","Detailed Earned Value Page","81956.htm");
Page[125]=new Array("Purpose","The bar graph and pivot table break projects down by WBS. It shows cost and cumulative values for:","Actual Cost","Earned Value","Planned Value","Estimate At Completion","Use the expand/collapse control to drill down into the WBS structure.","Location","On the Home page, click Dashboards.","Under Primavera, select Project Earned Value.","On the Project Earned Value dashboard, click the Detailed Earned Value page.","On the Detailed Earned Value page, expand the Detailed Earned Value by WBS section.","Subject Area","Activity","Detailed Earned Value by WBS Section","81957.htm");
Page[126]=new Array("This page shows statistics on a project's planned value, earned value, actual costs, and the estimated cost at completion, grouped by month or project manager.","Unifier Page","85180.htm");
Page[127]=new Array("Purpose","The line-bar chart shows cost information:","Bars for Actual Total Cost, Earned Value (Cost), Planned Value (Cost), and Estimate At Completion (Cost)","Lines for cumulative values of Actual Cost, Earned Value, Planned Value, and Estimate At Completion","The x-axis of the chart shows the year and month. The y-axis for the bars, on the left, shows period Cost. The y-axis for the lines, on the right, shows Cost (Cumulative).","The pivot table breaks down cost data by year, quarter, and month. Depending on the Filter criteria, the table contains columns for:","Year Name","Quarter Name","Month Name","Planned Value (Cost)","Planned Value (Cumulative)","Earned Value (Cost)","Earned Value (Cumulative)","Actual Total Cost","Actual Cost (Cumulative) / ","Location","On the Home page, click Dashboards.","Under Primavera, select Project Earned Value.","On the Project Earned Value dashboard, click Unifier, and then click the Overview page.","On the Overview page, expand the Earned Value section.","Subject Area","Activity","Earned Value Section","85181.htm");
Page[128]=new Array("Purpose","Select a value from the Segment list to view &lt;TBD&gt;","Location","On the Home page, click Dashboards.","Under Primavera, select Project Earned Value.","On the Project Earned Value dashboard, click Unifier, and then click the Overview page.","On the Overview page, expand the At Completion section.","Earned Value at Completion Section","85182.htm");
Page[129]=new Array("This page provides CPI and SPI information, helping you to identify which projects are over budget or behind schedule.","CPI/SPI Page","85185.htm");
Page[130]=new Array("Purpose","This section shows:","A line chart which plots the CPI and Cumulative CPI by month.","A line chart which plots the SPI and Cumulative SPI by month.","The x-axis shows the month and year. The y-axis shows the Cost Performance Index or the Schedule Performance Index.","Note: Cumulative SPI and Cumulative CPI are calculated from cumulative values, rather than being accumulations of CPI or SPI values from previous periods.","Location","On the Home page, click Dashboards.","Under Primavera, select Project Earned Value.","On the Project Earned Value dashboard, click Unifier, and then click the CPI/SPI page.","On the CPI/SPI page, expand the CPI/SPI section.","Subject Area","Activity","CPI/SPI Section","85186.htm");
Page[131]=new Array("Purpose","The bubble chart plots bubbles for projects according to their Cost Performance Index (Cost) and Schedule Performance Index (Cost). The location of each bubble in the chart will tell you whether the project it represents is under or over budget (above or below the horizontal center, respectively) and whether it is behind or ahead of schedule (left or right of the vertical center, respectively).","The x-axis shows Schedule Performance Index (Cost). The y-axis shows Cost Performance Index (Cost). Bubble size represents At Completion Total Cost, with larger bubbles representing larger values. Bubble color is used only to differentiate between bubbles. Hover over a bubble for specific details.","Location","On the Home page, click Dashboards.","Under Primavera, select Project Earned Value.","On the Project Earned Value dashboard, click Unifier, and then click the CPI/SPI page.","On the CPI/SPI page, expand the Earned Value  section.","Subject Area","Activity","Performance Index Section","85188.htm");
Page[132]=new Array("This page provides a detailed view of a project's earned value, total costs, and estimate at completion costs.","Detailed Earned Value Page","85190.htm");
Page[133]=new Array("Purpose","Select a Project Name and a Data Date to view a bar graph and the costs and cumulative values for ","Actual Cost","Earned Value","Planned Value","Estimate At Completion","Use the expand/collapse control to drill down into the WBS structure.","Location","On the Home page, click Dashboards.","Under Primavera, select Project Earned Value.","On the Project Earned Value dashboard, click Unifier and then click the Detailed Earned Value page.","On the Detailed Earned Value page, expand the Detailed Earned Value by WBS section.","Subject Area","Activity","Detailed Earned Value by Project and Data Date","85191.htm");
Page[134]=new Array("The Project Health dashboard uses data from P6 EPPM. ","It offers useful tools for determining the health of your projects. On this dashboard, you can view the overall health of your project, look at schedule progress and cost trends, and determine which activities are not on track.","Project Health Dashboard","81959.htm");
Page[135]=new Array("This page provides statistics for your project based on numerous variables, including project codes and ratings. You can view overall health and cost variance by cost account for any of your projects.","Overview Page","81960.htm");
Page[136]=new Array("Purpose","Use the View By list to select a project code by which to view the table and pie chart. The available codes are:","Project Manager","Financial Rating","Location","Priority","Sponsor","Strategic Objective","Strategic Rating","The table shows the number of projects and activities assigned to each value of the selected project code.","The pie chart shows the number of projects assigned to each value of the selected project code expressed as a percentage of total projects. Hover over a segment of the pie chart to see more detailed information, including the number of projects assigned to the code value.","Location","On the Home page, click Dashboards.","Under Primavera, select Project Health.","On the Project Health dashboard, click the Overview page.","On the Overview page, expand the Project Count section.","Subject Area","Activity","Project Count Section","81961.htm");
Page[137]=new Array("Purpose","Use the Business Process list to determine what data the first pivot table will show. The available business processes are:","Accounting ","Billing","Construction ","Customer Relationship","Financing ","Human Resources","Information Technology","Manufacturing","Operations","Order Management","Plant Maintenance ","Supply Chain","The business process pivot table contains columns for:","Project ID","Project Name","Project Score (weighted project code)","Budget Variance","At Completion Total Cost","Current Budget","A link to the project in P6 EPPM","The second pivot table shows at completion total cost broken down by project owner and project.","Location","On the Home page, click Dashboards.","Under Primavera, select Project Health.","On the Project Health dashboard, click the Overview page.","On the Overview page, expand the Overall Project Health section.","Subject Area","Activity","Overall Project Health Section","81963.htm");
Page[138]=new Array("Purpose","The bar chart shows the cost variance for each cost account.","The x-axis shows Cost Variance. The y-axis shows the Cost Account Name ordered by Cost Variance. Red bars indicate a negative Cost Variance value, whereas black bars indicate a positive Cost Variance value. Hover over a bar to see specific information for the cost account.","The pivot table breaks data down by Cost Account Name and year. The table contains columns for:","Cost Account Name","Planned Cost","At Completion Cost","Cost Variance","Location","On the Home page, click Dashboards.","Under Primavera, select Project Health.","On the Project Health dashboard, click the Overview page.","On the Overview page, expand the Cost Account section.","Subject Area","Resource Assignment","Cost Account Section","81965.htm");
Page[139]=new Array("This page shows you which activities are behind schedule, the performance of each activity in a project, a comparison of project schedule and performance, and resources with the highest At Completion Units. It contains the following narratives:","Schedule shows the percentage of activities that are complete in all projects.","Cost shows the percentage of the total cost for activities that are complete in all projects.","Units shows the percentage of units that are complete in all projects.","Labor Units shows the percentage of labor units that are complete in all projects.","Nonlabor Units shows the percentage of nonlabor units that are complete in all projects.","Schedule Page","81967.htm");
Page[140]=new Array("Purpose","The narrative shows the percentage of critical activities which are behind schedule according to their Baseline Project Finish Date Variance.","The table is grouped by Variance At Completion units, high to low, and then by project. This allows you to see the activities with the highest variance at completion quickly and then to see the other activities which have finish variance in the same project. The table contains columns for:","Project Name","Activity ID","Activity Name","Variance at Completion (Units)","A link to the project activities","Location","On the Home page, click Dashboards.","Under Primavera, select Project Health.","On the Project Health dashboard, click the Schedule page.","On the Schedule page, expand the Critical Activities behind Schedule section.","Subject Area","Activity","Critical Activities behind Schedule Section","81968.htm");
Page[141]=new Array("Purpose","The pivot table shows the number of activities per float path grouped by primary resource.","The bar chart shows the number of activities for each primary resource in a float path.","The x-axis shows the Float Path. The y-axis shows the number of activities. Hover over a bar for specific information.","Location","On the Home page, click Dashboards.","Under Primavera, select Project Health.","On the Project Health dashboard, click the Schedule page.","On the Schedule page, expand the Float Path section.","Subject Area","Activity","Float Path Section","81970.htm");
Page[142]=new Array("Purpose","The Phase and Department line-bar charts show data for activities assigned to the Phase and Department activity codes. Both of these line-bar charts show:","Bars for the Actual and Planned labor","A line for the Percent of Plan labor units expressed as a percentage of baseline project labor units","The x-axis of the Phase line-bar chart shows Phase code values. The x-axis of the Department line-bar chart shows Department code values. On both line-bar charts the y-axis for the bars, on the left, shows labor Units. On both line-bar charts the y-axis for the line, on the right, shows the Percent of Plan.","Use the Labor Performance By pivot table to determine whether Phase or Department data is displayed. The pivot table contains columns for:","Current Phase or Department","Project","Planned (baseline project labor units)","Actual (actual labor units)","Percent of Plan (actual labor units expressed as a percentage of baseline project labor units)","Location","On the Home page, click Dashboards.","Under Primavera, select Project Health.","On the Project Health dashboard, click the Schedule page.","On the Schedule page, expand the Labor Performance section.","Subject Area","Activity","Labor Performance Section","81972.htm");
Page[143]=new Array("Purpose","Use the Select a View list to determine whether the At Completion Units for a resource displays in a bar chart or pie chart.","The bar chart shows the ten resources that had the highest At Completion Units for that year. The x-axis shows the At Completion Units. The y-axis shows Resource Name.","The pie chart shows the ten resources that had the highest At Completion Units for that year. The sections of the pie chart show the percentage of At Completion Units for each resource. The percentage for each resource is dynamically determined based on the total At Completion Units.","The line chart shows the cost for various dates.","The x-axis shows the month, day, and year. The vertical bar on the chart shows the Data Date. The y-axis shows Cost. The blue line shows Cumulative Cost and the green line shows Cumulative At Completion Total Cost."," Location","On the Home page, click Dashboards.","Under Primavera, select Project Health.","On the Project Health dashboard, click the Schedule page.","On the Schedule page, expand the Completion section.","Subject Area","Resource Assignment","Completion Section","81976.htm");
Page[144]=new Array("Purpose","These pivot tables show percent complete data grouped by project name or project ID.","The first pivot table shows percent complete information grouped by project name. The table contains columns for:","Project Name","Schedule (Overall % Complete)","Performance (Overall % Complete)","Cost (Overall % Complete)","Units (Overall % Complete)","Labor (Cost % Complete)","Nonlabor (Cost % Complete)","Expense (Cost % Complete)","Material (Cost % Complete)","Labor (Units % Complete)","Nonlabor (Units % Complete)","The second table shows percent complete information grouped by project ID and date. The table contains columns for:","Project ID","Date","Cost (% Complete)","Units (% Complete)","Schedule (% Complete)","Performance (% Complete)","Labor Cost (% Complete)","Labor Units (% Complete)","Location","On the Home page, click Dashboards.","Under Primavera, select Project Health.","On the Project Health dashboard, click the Schedule page.","On the Schedule page, expand the Percent Complete Analysis section.","Subject Area","Activity","Percent Complete Analysis Section","81974.htm");
Page[145]=new Array("Purpose","The table shows activity step details for the project selected in the Project Name drop-down. The table contains columns for:","Activity ID ","Activity Name","Activity Status","Activity Start Date","Activity Finish Date","Step Name","Step Weight","Weight Percent Complete","Step Percent Completes","Is Completed","The bar chart shows the count of open and closed activity steps by project for the portfolio selected in the Portfolio Name drop-down. ","Location","On the Home page, click Dashboards.","Under Primavera, select Project Health.","On the Project Health dashboard, click the Schedule page.","On the Schedule page, expand the Activity Steps section.","Subject Area","Activity","Activity Steps Section","82557.htm");
Page[146]=new Array("This page shows the cost trends of your project, the cost breakdown by different variables, and the different types of costs your projects incur. It contains the following narratives:","Total Cost shows what the total cost of the selected projects or portfolios will be at completion.","Labor Cost shows what the total labor cost of the selected projects or portfolios will be at completion.","Nonlabor Cost shows what the total nonlabor cost of the selected projects or portfolios will be at completion.","Material Cost shows what the total material cost of the selected projects or portfolios will be at completion.","Expense Cost shows what the total expense cost of the selected projects or portfolios will be at completion.","Use the filters to determine what information displays in the narratives. If no filters are applied, these narratives show data for all projects and portfolios.","Cost Page","81980.htm");
Page[147]=new Array("Purpose","The bar graph displays actual cost details for each cost code. It is broken down by:","Actual Expense Cost","Actual Labor Cost","Actual NonLabor Cost","Actual Total Cost","The x-axis shows the cost code. The y-axis shows the cost.","You can drill-down each cost code by selecting it on the x-axis or the table.","The table shows the cost code hierarchy broken down by actual expense cost, actual labor cost, actual nonlabor cost, and actual total cost. You can expand each cost code for additional details.","Location","On the Home page, click Dashboards.","Under Primavera, select Project Health.","On the Project Health dashboard, click the Cost page.","On the Cost page, expand the Cost Code Hierarchy section.","Subject Area","Activity","Code Cost Hierarchy Section","83889.htm");
Page[148]=new Array("Purpose","Use the Select a View list to determine whether cost information displays as a bar chart, line chart, or table.","The bar chart shows bars for:","Actual Total Cost","Remaining Total Cost","At Completion Total Cost","The x-axis shows the year and month. The y-axis shows cost. Hover over a bar to see specific information about it.","The line chart shows lines for:","Actual Total Cost","Remaining Total Cost","At Completion Total Cost","The x-axis shows the year and month. The y-axis shows cost. Hover over a point on a line to see specific information about it.","The pivot table breaks data down by project and date. The columns spread the data across five months. The table shows information per project for:","Actual Total Cost","Remaining Total Cost","At Completion Total Cost","Location","On the Home page, click Dashboards.","Under Primavera, select Project Health.","On the Project Health dashboard, click the Cost page.","On the Cost page, expand the Cost Trend section.","Subject Area","Project History","Cost Trend Section","81981.htm");
Page[149]=new Array("Purpose","Use the Select a View list to determine how cost and project code information displays. Depending on the selection, the view displays as a bar chart or table. The available views are:","Cost Breakdown by Location","Cost Breakdown by Project Manager","Cost Breakdown by Sponsor","Table by Location","Table by Project Manager","Table by Sponsor","The bar charts break data down by the Location, Project Manager, and Sponsor project codes respectively. The bar charts show bars for:","Actual Total Cost","At Completion Total Cost","Remaining Total Cost","Cost Variance (Cost)","The x-axis shows Cost. The y-axis shows the project code selected in the Select a View list.","The tables break down data by the Location, Project Manager, and Sponsor project codes respectively. The pivot tables show columns for:","Project Manager","Actual Total Cost","At Completion Total Cost","Remaining Total Cost","Cost Variance (Cost)","Location","On the Home page, click Dashboards.","Under Primavera, select Project Health.","On the Project Health dashboard, click the Cost page.","On the Cost page, expand the Project Cost Breakdown section.","Subject Area","Activity","Project Cost Breakdown Section","81985.htm");
Page[150]=new Array("Purpose","Use the Select a View list to determine how project cost information displays. The available views are: ","Expense Cost","Labor Cost","Nonlabor Cost","Material Cost","Total Cost","The bar chart and the pivot table show the same data. There are bars and columns for:","Actual &lt;Cost Type&gt; Cost","At Completion &lt;Cost Type&gt; Cost","Remaining &lt;Cost Type&gt; Cost","In the bar chart, the x-axis shows Projects. The y-axis shows the cost type selected in the Select a View list. Hover over a bar on the chart to see specific data. The table contains columns for the same data broken down by project name.","Location","On the Home page, click Dashboards.","Under Primavera, select Project Health.","On the Project Health dashboard, click the Cost page.","On the Cost page, expand the Cost by Type section.","Subject Area","Activity","Cost by Type Section","81988.htm");
Page[151]=new Array("Purpose","The table shows expense details by project for the Project Owner selected in the drop-down. The sums by project owner of the expense costs are shown above the table. The table contains columns for:","Project ID ","Project Name","Project Start Date","Project Finish Date","Project Planned Expense Cost","Project Remaining Expense Cost","Project Actual Expense Cost","The bar chart shows the expense costs by expense category for the project selected in the Project Name drop-down. It is also master-detail linked to the table; the chart displays data for a project based on the Project Name that is clicked on in the table.","Location","On the Home page, click Dashboards.","Under Primavera, select Project Health.","On the Project Health dashboard, click the Cost page.","On the Cost page, expand the Expenses section.","Subject Area","Activity","Expenses Section","82570.htm");
Page[152]=new Array("This page shows the At Completion Variance Percentage of each project in your portfolio, as well as a detailed history of each activity in a project.","History Page","81990.htm");
Page[153]=new Array("Purpose","These analyses show percent complete information broken down by date.","The table breaks down data by date and shows columns for:","Calendar Date","Project Name","Units (Today % Complete)","Cost (Today % Complete)","Units (Yesterday % Complete)","Cost (Yesterday % Complete)","Units (% Complete Change Yesterday to Today)","Cost (% Complete Change Yesterday to Today)","The line chart shows the Today Percent Complete from the start of project until the given day of analysis. There are lines for Units and Cost.","The x-axis shows the Calendar Date. The y-axis shows the Today Percent Complete on the given day from start. Hover over a point for specific information.","Location","On the Home page, click Dashboards.","Under Primavera, select Project Health.","On the Project Health dashboard, click the History page.","On the History page, expand the % Complete History section.","Subject Area","Project History","% Complete History Section","81991.htm");
Page[154]=new Array("Purpose","The pivot table shows data for all milestones whose dates have changed since the previous history interval. Data is broken down and ordered by project and date. The table contains columns for:","Project Name","Calendar Date","Activity ID","Activity Name","Activity Type","Current Planned Start","Current Planned Finish","Prior Planned Start","Prior Planned Finish","Use the up and down arrows below the table to navigate to other sections of the table. Use the double-ended arrow to view the whole table in one screen (to a maximum of 500 rows per page).","Location","On the Home page, click Dashboards.","Under Primavera, select Project Health.","On the Project Health dashboard, click the History page.","On the History page, expand the Milestone Dates that Have Slipped section.","Subject Area","Project History","Milestone Dates That Have Slipped Section","81993.htm");
Page[155]=new Array("Purpose","The chart shows progression of changes between Proposed Budget and Original Budget, sorted by date.","Location","On the Home page, click Dashboards.","Under Primavera, select Project Health.","On the Project Health dashboard, click the History page.","On the History page, expand the Proposed Budget (Project Cost UDF) History section.","Subject Area","Project History","Proposed Budget (Project Cost UDF) History Section","83366.htm");
Page[156]=new Array("This page shows the At Completion Total Cost for any of your projects by country or state.","Location Page","81995.htm");
Page[157]=new Array("Purpose","The map shows At Completion Total Cost for all projects by country. White areas of the map indicate that no project is located in that area.","Switch off the At Completion Total Cost (Color Fill) option below ALL COUNTRIES to remove the shading when zoomed out to Country level. Switch off the At Completion Total Cost (Image) option below ALL CITIES to remove the shading when zoomed in to state level. Zoom in and out with the control on the left. Hover over a country, state, or province to see specific information or click on a country, state, or province to bring up a call out with specific information.","Location","On the Home page, click Dashboards.","Under Primavera, select Project Health.","On the Project Health dashboard, click the Location page.","On the Location page, expand the At Completion Total Cost by Location section.","Subject Area","Activity","At Completion Total Cost by Location Section","81996.htm");
Page[158]=new Array("@ ","Purpose","The pivot table breaks down At Completion Total Cost by project code value. Click expand/collapse next to a value to drill down into the hierarchy.","The pie chart reflects the data shown in the pivot table and will change with the table.","The pie chart shows the At Completion Total Cost broken down by country. The segments represent the amount of At Completion Total Cost accountable to each location shown. The pie chart will update based on the displayed hierarchies in the pivot table.","Location","On the Home page, click Dashboards.","Under Primavera, select Project Health.","On the Project Health dashboard, click the Location page.","On the Location page, expand the Project Code Hierarchy section.","Subject Area","Activity","Project Code Hierarchy Section","81998.htm");
Page[159]=new Array("Purpose","The map shows At Completion Labor Units for projects by state. White areas of the map indicate that no project is located in that area.","Switch off the At Completion Labor Units (Pie Graph) option below US STATES to remove the pie charts from states. Switch off the Remaining Total Cost (Color Fill) option to remove the cost shading on a state. Zoom in and out with the control on the left. Hover over a pie chart to see specific information for that state.","Location","On the Home page, click Dashboards.","Under Primavera, select Project Health.","On the Project Health dashboard, click the Location page.","On the Location page, expand the At Completion Labor Units by State section.","Subject Area","Activity","At Completion Labor Units by State Section","82351.htm");
Page[160]=new Array("This page shows each activity associated with a project within your portfolio.","Activity Worksheet Page","82000.htm");
Page[161]=new Array("Purpose","The pivot table lists activities, grouped by WBS. Filter the data in the table by project name or activity status using the Project Name and Activity Status lists at the top of the page.","The pivot table contains columns for:","WBS Name (Project Level)","Activity Name","Status","Resource Name","Start ","Finish ","Finish Variance (Hours)","Link to the Activities in P6","Use the up and down arrows below the table to navigate to other sections of the table. Use the double-ended arrow to view the whole table in one screen (to a maximum of 500 rows per page).","Location","On the Home page, click Dashboards.","Under Primavera, select Project Health.","On the Project Health dashboard, click the Activity Worksheet page.","On the Activity Worksheet page, expand the Activity Worksheet section.","Subject Area","Activity","Activity Worksheet Section","82001.htm");
Page[162]=new Array("This page shows a schedule health assessment for your portfolio.","Assessment Page","84218.htm");
Page[163]=new Array("Location","On the Home page, click Dashboards.","Under Primavera, select Project Health.","On the Project Health dashboard, click the Assessment page.","On the Assessment page, expand the Schedule Assessment Overview section.","Subject Area","Activity","Schedule Assessment Overview","84219.htm");
Page[164]=new Array("This page shows a &quot;what-if&quot; scenario for your portfolio for Projects, Activities and Resource Assignments. The information can be reviewed in a graph or table format.","In the What if field, enter a numerical value to see effect of the change to your portfolio. ","What If Page","84303.htm");
Page[165]=new Array("Purpose","Review and compare data between the current scenario and a &quot;what-if&quot; scenario for projects in a graph or table format.","Location","On the Home page, click Dashboards.","Under Primavera, select Project Health.","On the Project Health dashboard, click the What-if page.","On the What-if page, expand the Projects section.","Subject Area","Project","What-if Projects Section","84304.htm");
Page[166]=new Array("Purpose","Review and compare data between the current scenario and a &quot;what-if&quot; scenario for activities.","Location","On the Home page, click Dashboards.","Under Primavera, select Project Health.","On the Project Health dashboard, click the What-if page.","On the What-if page, expand the Activities section.","Subject Area","Activity","What-if Activities Section","84306.htm");
Page[167]=new Array("Purpose","Review and compare data between the current scenario and a &quot;what-if&quot; scenario for resource assignment in terms of Costs or Units.","Location","On the Home page, click Dashboards.","Under Primavera, select Project Health.","On the Project Health dashboard, click the What-if page.","On the What-if page, expand the Resource Assignment section.","Subject Area","Resource Assignment","What-If Resource Assignment Section","84308.htm");
Page[168]=new Array("The Project Performance Measurement dashboard uses data from P6 EPPM and Primavera Unifier.","Project Performance Measurement","84160.htm");
Page[169]=new Array("This page provides a summary of cost, earned quantity, and earned duration for all the projects selected by the filter. In addition, a table of the projects selected is displayed with drill-down links to the project pages in P6 EPPM and Primavera Unifier.","Overview Page","84161.htm");
Page[170]=new Array("Location","On the Home page, click Dashboards.","Under Primavera, select Project Performance Measurement.","On the Project Performance Measurement dashboard, click the Overview page.","On the Overview page, expand the Cost section.","Subject Area","Cost Sheet/Activity","Cost Section","84162.htm");
Page[171]=new Array("Location","On the Home page, click Dashboards.","Under Primavera, select Project Performance Measurement.","On the Project Performance Measurement dashboard, click the Overview page.","On the Overview page, expand the Earned Quantity section.","Subject Area","Cost Sheet/Activity","Earned Quantity Section","84163.htm");
Page[172]=new Array("Location","On the Home page, click Dashboards.","Under Primavera, select Project Performance Measurement.","On the Project Performance Measurement dashboard, click the Overview page.","On the Overview page, expand the EArned Duration section.","Subject Area","Activity","Earned Duration Section","84164.htm");
Page[173]=new Array("Location","On the Home page, click Dashboards.","Under Primavera, select Project Performance Measurement.","On the Project Performance Measurement dashboard, click the Overview page.","On the Overview page, expand the Original Budget &amp; Change section.","Subject Area","Cost Sheet/Business Process","Original Budget &amp; Change Section","84165.htm");
Page[174]=new Array("Location","On the Home page, click Dashboards.","Under Primavera, select Project Performance Measurement.","On the Project Performance Measurement dashboard, click the Overview page.","On the Overview page, expand the Overview section.","Subject Area","Activity/Cost Sheet","Overview Table Section","84166.htm");
Page[175]=new Array("This page provides detailed cash flow information along with performance to plan, forecast, and estimate to complete information. The information is summarized for the projects selected by the filter.","Cost Page","84167.htm");
Page[176]=new Array("Location","On the Home page, click Dashboards.","Under Primavera, select Project Performance Measurement.","On the Project Performance Measurement dashboard, click the Cost page.","On the Cost page, expand the Cash Flow section.","Subject Area","Cash Flow/Activity","Cash Flow Section","84172.htm");
Page[177]=new Array("Location","On the Home page, click Dashboards.","Under Primavera, select Project Performance Measurement.","On the Project Performance Measurement dashboard, click the Cost page.","On the Cost page, expand the EAC section.","Subject Area","Cash Flow/Activity","EAC Section","84173.htm");
Page[178]=new Array("This page displays a detailed S curve and project earned quantity values for all the projects selected by the filter.","Earned Quantity Page","84168.htm");
Page[179]=new Array("Location","On the Home page, click Dashboards.","Under Primavera, select Project Performance Measurement.","On the Project Performance Measurement dashboard, click the Earned Quantity page.","On the Earned Quantity page, expand the SPI &amp; CPI section.","Subject Area","Activity","SPI &amp; CPI Section","84174.htm");
Page[180]=new Array("Location","On the Home page, click Dashboards.","Under Primavera, select Project Performance Measurement.","On the Project Performance Measurement dashboard, click the Earned Quantity page.","On the Earned Quantity page, expand the S Curve section.","Subject Area","Activity","S Curve Section","84175.htm");
Page[181]=new Array("Location","On the Home page, click Dashboards.","Under Primavera, select Project Performance Measurement.","On the Project Performance Measurement dashboard, click the Earned Quantity page.","On the Earned Quantity page, expand the EAC section.","Subject Area","Activity","EAC Section","84176.htm");
Page[182]=new Array("This page displays a detailed S curve for the earned duration of all the projects selected by the filter.","Earned Duration Page","84169.htm");
Page[183]=new Array("Location","On the Home page, click Dashboards.","Under Primavera, select Project Performance Measurement.","On the Project Performance Measurement dashboard, click the Earned Duration page.","On the Earned Duration page, expand the DPI section.","Subject Area","Activity","DPI Section","84177.htm");
Page[184]=new Array("Location","On the Home page, click Dashboards.","Under Primavera, select Project Performance Measurement.","On the Project Performance Measurement dashboard, click the Earned Duration page.","On the Earned Duration page, expand the S Curve section.","Subject Area","Activity","S Curve Section","84178.htm");
Page[185]=new Array("Location","On the Home page, click Dashboards.","Under Primavera, select Project Performance Measurement.","On the Project Performance Measurement dashboard, click the Earned Duration page.","On the Earned Duration page, expand the EAC section.","Subject Area","Activity","EAC Section","84179.htm");
Page[186]=new Array("This page displays change order details, including original and revised budget information.","Change Orders Page","84170.htm");
Page[187]=new Array("Location","On the Home page, click Dashboards.","Under Primavera, select Project Performance Measurement.","On the Project Performance Measurement dashboard, click the Change Orders page.","On the Change Orders page, expand the Original &amp; Revised Budget section.","Subject Area","Cost Sheet","Original &amp; Revised Budget Section","84180.htm");
Page[188]=new Array("Location","On the Home page, click Dashboards.","Under Primavera, select Project Performance Measurement.","On the Project Performance Measurement dashboard, click the Change Orders page.","On the Change Orders page, expand the Change Orders section.","Subject Area","Business Process","Change Orders Section","84181.htm");
Page[189]=new Array("This page displays activity-level earned duration and earned quantity information for the projects selected by the filter.","Activity Details Page","84171.htm");
Page[190]=new Array("Location","On the Home page, click Dashboards.","Under Primavera, select Project Performance Measurement.","On the Project Performance Measurement dashboard, click the Activity Details page.","On the Activity Details page, expand the Activity Performance section.","Subject Area","Activity","Activity Performance Table Section","84182.htm");
Page[191]=new Array("The Resource Analysis dashboard uses data from P6 EPPM. ","It shows the status and usage of your resources, measures team progress and productivity, and tells you which resources are underutilized.","Resource Analysis Dashboard","82003.htm");
Page[192]=new Array("Purpose","These analyses can be viewed as a bar chart, pie chart, or table.","The Actual Units by Strategic Objective and Remaining Units by Strategic Objective bar charts show the number of Actual Units or Remaining Units respectively broken down by Strategic Objective. It shows bars for:","Increased Customer Retention","Reduced Cycle Time","Improved Customer Satisfaction","Regulatory Compliance","Revenue Growth","Hover over a bar to see specific data. Click on a bar to drill down to see actual effort by project.","The To Date Units by Strategic Objective and Remaining Units by Strategic Objective pie charts show the number of To Date Units or Remaining Units respectively broken down by Strategic Objective. It shows segments for:","Improved Customer Satisfaction","Increased Customer Retention","Reduced Cycle Time","Regulatory Compliance","Revenue Growth","Click on a segment to drill down to see actual effort by project.","The Actual Units and Remaining Units pivot tables show strategic objective and units for each project. The tables show columns for:","Strategic Objective Description","Project Name","Actual Units or Remaining Units","Year Name (Actual Units table only)","Use the up and down arrows below the table to navigate to other sections of the table. Use the double-ended arrow to view the whole table in one screen (to a maximum of 500 rows per page).","Location","On the Home page, click Dashboards.","Under Primavera, select Resource Analysis.","On the Resource Analysis dashboard, click the Overview page.","On the Overview page, expand the Resource Alignment section.","Subject Area","Resource Assignment","Resource Alignment Section","82005.htm");
Page[193]=new Array("Purpose","The bar chart shows how resource usage is distributed over time. ","The x-axis shows calendar dates. The y-axis shows Units of time. ","The solid horizontal line represents the allocation Limit; the dotted horizontal line represents the overallocation Limit Plus 25%. The green area represents time overallocated by more than 25%; the brown area represents time overallocated by less than 25%; the blue area represents time that is not overallocated. Hover over a bar for specific details. Use the slide to view the allocation for resources in a given quarter.","The stacked bar chart shows the remaining and overallocated units for a resource.","The x-axis shows Resource Name. The y-axis shows Units of time. Blue bands on the bar represent Remaining Units. Red bands represent Overallocation Units. Hover over a bar for specific details.","Location","On the Home page, click Dashboards.","Under Primavera, select Resource Analysis.","On the Resource Analysis dashboard, click the Overview page.","On the Overview page, expand the Resource Allocation section.","Subject Area","Resource Utilization","Resource Allocation Section","82009.htm");
Page[194]=new Array("Purpose","The pivot table breaks down labor hours by resource, location, and year. Rows show data for Locations with Labor Hour totals at the right of the table. Columns show data for resources with Labor Hour totals at the bottom of the table. ","Use the Select a View list to filter data by project code. The available codes are:","At Completion by Sponsor","At Completion by Business Segment","At Completion by Priority","Click on the year to drill down to half-year.","Location","On the Home page, click Dashboards.","Under Primavera, select Resource Analysis.","On the Resource Analysis dashboard, click the Overview page.","On the Overview page, expand the Labor Hours by Resource Location section.","Subject Area","Resource Assignment","Labor Hours by Resource Location Section","82012.htm");
Page[195]=new Array("Purpose","The analysis shows Overallocated Units By Resource and Underallocated Units By Resource bar charts.","The Overallocated Units By Resource bar chart shows overallocation bars for each resource broken down by year and quarter. If no resource is overallocated in a quarter, that quarter will not appear in the chart.","The x-axis shows the year and the quarter. The y-axis shows overallocated Units. Hover over a bar for specific information about that bar.","The Underallocated Units By Resource bar chart shows underallocation bars for each resource broken down by year and quarter. If no resource is under allocated in a quarter, then that quarter will not appear in the chart.","The x-axis shows the year and the quarter. The y-axis shows underallocation Units. Hover over a bar for specific information about that bar.","Location","On the Home page, click Dashboards.","Under Primavera, select Resource Analysis.","On the Resource Analysis dashboard, click the Overview page.","On the Overview page, expand the Over/Under Allocation section.","Subject Area","Resource Utilization","Over/Under Allocation Section","82014.htm");
Page[196]=new Array("This page shows staffing activity, allocated and remaining resources remaining, hours allotted by role, and total hours by an entire team.","Staffing Page","82016.htm");
Page[197]=new Array("Purpose","The pivot table breaks down unit data by project and date. There are rows for:","Staffed","Unstaffed","Total FTE (calculated as Staffed plus Unstaffed)","Click on a project name for links to WBS Earned Value and Activity Worksheet. Click on a year-quarter label to drill down to monthly data. Use the up and down arrows below the table to navigate to other sections of the table. Use the double-ended arrow to view the whole table in one screen (to a maximum of 500 rows per page).","Location","On the Home page, click Dashboards.","Under Primavera, select Resource Analysis.","On the Resource Analysis dashboard, click the Staffing page.","On the Staffing page, expand the Staffing section.","Subject Area","Resource Assignment","Staffing Section","82017.htm");
Page[198]=new Array("Purpose","The stacked bar chart shows a stacked bar for each resource code showing Allocated Units and Overallocated units. Use the View by list to select a resource code. The available codes are:","Classification","Location","Plant","Department","The x-axis shows the resource code selected in the View by list. The y-axis shows allocation Units. Hover over a bar to show specific data.","The table breaks down unit data based on the resource code selected in the View by list.","The table contains columns for:","Remaining Units","Overallocated ","Allocated ","Table rows are determined by the View by list selection.","Location","On the Home page, click Dashboards.","Under Primavera, select Resource Analysis.","On the Resource Analysis dashboard, click the Staffing page.","On the Staffing page, expand the Allocation by Code section.","Subject Area","Resource Utilization","Allocation by Code Section","82019.htm");
Page[199]=new Array("Purpose","The analysis shows at completion units by date grouped by primary role. Use the Select a View list to determine whether the content displays as a chart or table. The chart and the table display the same information. There are bars or columns for:","Business Analyst","Developer","Quality Assurance","The x-axis shows the year, month, and date. The y-axis shows At Completion Units. Hover over a bar to see details of the data.","The pivot table breaks down At Completion Units by role and week. Columns show at Completion Units broken down by week with totals in the last row.","Click on a week name to drill down and view the data broken down by day.","Location","On the Home page, click Dashboards.","Under Primavera, select Resource Analysis.","On the Resource Analysis dashboard, click the Staffing page.","On the Staffing page, expand the Hours by Role section.","Subject Area","Resource Assignment","Hours by Role Section","82021.htm");
Page[200]=new Array("Purpose","The pivot table shows At Completion Units for each resource in a team broken down by quarter. This data is aggregated by resource team and quarter. Click a resource team name to display that team's data in the stacked bar graph. The table has columns for:","Resource Team","Quarter Name","Resource Name ","At Completion Units","The Resource Hours by Team stacked bar graph shows At Completion Units for each resource per quarter. Use the Resource Team list to filter the data by resource team.","The x-axis shows year and quarter. The y-axis shows At Completion Units. Hover over a bar for details.","Location","On the Home page, click Dashboards.","Under Primavera, select Resource Analysis.","On the Resource Analysis dashboard, click the Staffing page.","On the Staffing page, expand the Total Hours by Team section.","Subject Area","Resource Assignment","Total Hours by Team Section","82024.htm");
Page[201]=new Array("Purpose","The Resource pivot table and bar chart show units broken down by resource. Both the table and the bar chart display the same information. Hierarchy selections in the Resource table will impact the bar chart. There are columns/bars for:","Remaining Units","Planned Units","Actual Units","In the bar chart, the x-axis shows Resource. The y-axis shows Units. Hover over a bar for details.","The Role pivot table and bar chart show units broken down by role. Both the table and the bar chart display the same information. Hierarchy selections in the Role table will impact the bar chart. There are columns/bars for:","Remaining Units","Planned Units","Actual Units","In the bar chart, the x-axis shows Role. The y-axis shows Units. Hover over a bar for details.","Location","On the Home page, click Dashboards.","Under Primavera, select Resource Analysis.","On the Resource Analysis dashboard, click the Staffing page.","On the Staffing page, expand the Hierarchies section.","Subject Area","Resource Assignment","Hierarchies Section","82353.htm");
Page[202]=new Array("This page shows team progress, resource productivity, and periodic versus cumulative hours.","Productivity Page","82027.htm");
Page[203]=new Array("Purpose","The bar chart shows the utilization rate percentage for each team. Resource utilization is a measure of a resource's allocated units against the resource limit. The values for each team are an aggregation of values for individual resources (rather than being calculated at team level). When a resource's utilization is more than 100%, the resource is overallocated.","The x-axis shows the Utilization Rate Percentage. The y-axis shows the Resource Team Name.","Location","On the Home page, click Dashboards.","Under Primavera, select Resource Analysis.","On the Resource Analysis dashboard, click the Productivity page.","On the Productivity page, expand the Resource Utilization by Team section.","Subject Area","Resource Utilization","Resource Utilization by Team Section","82028.htm");
Page[204]=new Array("Purpose","The line-bar chart displays poorly performing resources broken down by resource ID, number of activities, and late percentage. ","The x-axis shows the resource ID. The y-axis for the bars, on the left, shows the number of total and late activities. The y-axis for the lines, on the right, shows late percentage. Hover over and click a bar or a point on a line to drill-down for detailed information.","Location","On the Home page, click Dashboards.","Under Primavera, select Resource Analysis.","On the Resource Analysis dashboard, click the Productivity page.","On the Productivity page, expand the Poorly Performing Resources section.","Subject Area","Activity","Poorly Performing Resources Section","83890.htm");
Page[205]=new Array("Purpose","The analysis shows labor units and cumulative labor units broken down by date. Use the Select a View list to determine whether the content displays as a chart or table. The chart and the table display the same information.","The line-bar chart shows:","Bars for Baseline Project Labor Units, At Completion Labor Units, and Actual Labor Units Cumulative","Lines for Actual Labor Units, Baseline Project Labor Units Cumulative, and Forecast Labor Units Cumulative","The x-axis shows the year and month. The y-axis for the bars, on the left, shows labor Units. The y-axis for the lines, on the right, shows labor Units (Cumulative). Hover over a bar or a point on a line to see detailed information.","The pivot table breaks data down by month and resource. The data is ordered by month. The pivot table contains columns for:","Month Name","Resource Name","Baseline Project Labor Units","Actual Labor Units","At Completion Labor Units","Baseline Project Labor Units Cumulative","Actual Labor Units Cumulative","Forecast Labor Units Cumulative","Click on a month name to drill down to weekly data. Use the up and down arrows below the table to navigate to other sections of the table. Use the double-ended arrow to view the whole table in one screen (to a maximum of 500 rows per page).","Location","On the Home page, click Dashboards.","Under Primavera, select Resource Analysis.","On the Resource Analysis dashboard, click the Productivity page.","On the Productivity page, expand the Periodic and Cumulative Labor Units by Month section.","Subject Area","Activity","Periodic and Cumulative Labor Units by Month Section","82030.htm");
Page[206]=new Array("Purpose","The Daily SPI and Average SPI line charts show the Schedule Performance Index (SPI) using a green line. The blue line shows the target (set at 1.0). The Average SPI is based on the cumulative average over time from the beginning of the chart. Once the chart exceeds 30 days, the average is of the 30 days prior to the data point.","The x-axis for both charts shows dates. The y-axis for both charts shows the SPI.","Location","On the Home page, click Dashboards.","Under Primavera, select Resource Analysis.","On the Resource Analysis dashboard, click the Productivity page.","On the Productivity page, expand the Daily vs. Average SPI by Resource section.","Subject Area","Activity","Daily vs. Average SPI by Resource Section","82033.htm");
Page[207]=new Array("This page shows resource availability, utilization, and capacity.","Utilization Page","82035.htm");
Page[208]=new Array("Purpose","The line-bar chart provides availability data for the selected resource. If no resource is selected, the selection defaults to the first resource in the list. The chart shows:","Bars for Planned Units and Available Units","A line for the % Units Available (Available Units calculated as a percentage of Available plus Planned Units)","The x-axis shows dates broken into weeks. The y-axis for the bars, on the left, shows Units. The y-axis for the line, on the right, shows Percentage of Units Available.","The pivot table shows the same data as the line-bar chart. Rows show Available Units, Planned Units, and % Available. Columns show the date broken into weeks.","Location","On the Home page, click Dashboards.","Under Primavera, select Resource Analysis.","On the Resource Analysis dashboard, click the Utilization page.","On the Utilization page, expand the Resource Availability section.","Subject Area","Resource Utilization","Resource Availability Section","82036.htm");
Page[209]=new Array("Purpose","The line-bar chart breaks data down for the selected resource by week. If no resource is selected, the selection defaults to the first resource in the list. The line-bar chart shows:","Bars for Limit, Planned Units, and Actual Units","Lines for Planned % Utilization and Actual % Utilization","The x-axis shows dates broken into weeks. The y-axis for the bars, on the left, shows Units. The y-axis for the lines, on the right, shows Percent Utilization. Hover over a bar or a point on a line to see details.","The table breaks down the selected resource's data by week, showing columns for:","Week Name","Resource Name","Limit","Planned Units","Planned % Utilization","Actual Units","Actual % Utilization","Click a week name to drill down to resource analysis information for that week.","Location","On the Home page, click Dashboards.","Under Primavera, select Resource Analysis.","On the Resource Analysis dashboard, click the Utilization page.","On the Utilization page, expand the Utilization section.","Subject Area","Resource Utilization","Utilization Section","82038.htm");
Page[210]=new Array("Purpose","The line-bar chart breaks data for the selected resource down by month. The chart shows:","Bars for Planned Units, Actual Units, Remaining Units, and Available Units","A line for Limit","The x-axis shows months. The y-axis for the bars, on the left, shows Units. The y-axis for the line, on the right, shows Limit (Units). Hover over a bar or a point on a line for details.","The pivot table breaks data down by month then resource. For each resource, the pivot table contains columns for:","Month Name","Resource Name","Planned Units","Actual Units","Limit","Available Units","Remaining Units","Use the up and down arrows below the table to navigate to other sections of the table. Use the double-ended arrow to view the whole table in one screen (to a maximum of 500 rows per page).","Location","On the Home page, click Dashboards.","Under Primavera, select Resource Analysis.","On the Resource Analysis dashboard, click the Utilization page.","On the Utilization page, expand the Capacity section.","Subject Area","Resource Assignment","Capacity Section","82040.htm");
Page[211]=new Array("This page shows location information for resources.","Location Page","82224.htm");
Page[212]=new Array("Purpose","The map shows resource locations broken down by roles. Locations are marked by gold bubbles. Hover over a gold bubble to see specific information about the resource related to the location.","Location","On the Home page, click Dashboards.","Under Primavera, select Resource Analysis.","On the Resource Analysis dashboard, click the Location page.","On the Location page, expand the Resource Location by Role section.","Subject Area","Resource Assignment","Resource Location by Role Section","82225.htm");
Page[213]=new Array("This page shows cost summary information for resources. The Cost Summary dashboard uses data from Primavera Unifier.","Cost Summary Page","83368.htm");
Page[214]=new Array("Purpose","The line chart displays the progression of Planned Cost, Actual Cost, Remaining Cost, and At Completion Cost. The date is represented on the x-axis, and the amount is represented on the y-axis.","The pivot table shows Periodic and Cumulative cost comparisons sorted by year. The table contains the following columns:","Year","Planned Cost","Actual Cost","Remaining Cost","At Completion Cost","The data in this section can be filtered by Project Hierarchy.","Location","On the Home page, click Dashboards.","Under Primavera, select Resource Analysis.","On the Resource Analysis dashboard, click the Cost Summary page.","On the Cost Summary page, expand the Cost Summary by CBS section.","Subject Area","Resource Cost Summary","Cost Summary by Project Section","83369.htm");
Page[215]=new Array("Purpose","The chart shows the progression of Planned Cost, Actual Cost, Remaining Cost, and At Completion Cost. Date is represented on the x-axis, and amount is represented on the y-axis.","The table shows Periodic and Cumulative cost comparisons sorted by year. The table contains the following columns:","Year","Planned Cost","Actual Cost","Remaining Cost","At Completion Cost","The data in this section can be filtered by Cost Code Hierarchy.","Location","On the Home page, click Dashboards.","Under Primavera, select Resource Analysis.","On the Resource Analysis dashboard, click the Cost Summary page.","On the Cost Summary page, expand the Cost Summary by CBS section.","Subject Area","Resource Cost Summary","Cost Summary by CBS Section","83371.htm");
Page[216]=new Array("Purpose","The chart shows the progression of Current Planned Cost and Baseline Planned Cost. Year is represented on the x-axis, and amount is represented on the y-axis.","The table shows Current Planned Cost and Baseline Planned Cost comparisons sorted by year. ","Location","On the Home page, click Dashboards.","Under Primavera, select Resource Analysis.","On the Resource Analysis dashboard, click the Cost Summary page.","On the Cost Summary page, expand the Current vs. Baseline Cost section.","Subject Area","Resource Cost Summary","Current vs. Baseline Cost Section","83373.htm");
Page[217]=new Array("Purpose","The chart shows the progression of Current Planned Units and Baseline Planned Units. Year is represented on the x-axis, and amount is represented on the y-axis.","The table shows Current Planned Units and Baseline Planned Units comparisons sorted by year. ","Location","On the Home page, click Dashboards.","Under Primavera, select Resource Analysis.","On the Resource Analysis dashboard, click the Cost Summary page.","On the Cost Summary page, expand the Current vs. Baseline Units section.","Subject Area","Resource Cost Summary","Current vs. Baseline Units Section","83375.htm");
Page[218]=new Array("This page shows role utilization details for resources.","Role Utilization","83737.htm");
Page[219]=new Array("Purpose","The bar chart shows role limit and primary resource limit details by day for the selected role and project. The x-axis shows the days of the selected month. The y-axis shows hours.","Location","On the Home page, click Dashboards.","Under Primavera, select Resource Analysis.","On the Resource Analysis dashboard, click the Role Utilization page.","On the Role Utilization page, expand the Role Over Limit section.","Subject Area","Role Utilization","Role Over Limit","83738.htm");
Page[220]=new Array("Purpose","The bar chart shows the top ten roles over limit. The x-axis shows roles. The y-axis shows units. ","Location","On the Home page, click Dashboards.","Under Primavera, select Resource Analysis.","On the Resource Analysis dashboard, click the Role Utilization page.","On the Role Utilization page, expand the Top 10 Roles Over Limit section.","Subject Area","Role Utilization","Top 10 Roles Over Limit","83739.htm");
Page[221]=new Array("Purpose","The bar chart shows role utilization by month for the selected role. The x-axis shows the month. The y-axis shows hours.","Location","On the Home page, click Dashboards.","Under Primavera, select Resource Analysis.","On the Resource Analysis dashboard, click the Role Utilization page.","On the Role Utilization page, expand the Role Utilization Over Time section.","Subject Area","Role Utilization","Role Utilization Over Time","83740.htm");
Page[222]=new Array("Purpose","The pivot table shows role limit details by project and by role. It contains columns for:","Project Name","Role Name","Limit (hours)","Planned Units (hours)","Remaining Units (hours)","Location","On the Home page, click Dashboards.","Under Primavera, select Resource Analysis.","On the Resource Analysis dashboard, click the Role Utilization page.","On the Role Utilization page, expand the Role Limit by Project section.","Subject Area","Role Utilization","Role Limit by Project","83741.htm");
Page[223]=new Array("Purpose","The table shows role limit detail for roles under limit for the selected week. It contains columns for:","Role ID","Role Name","Limit (hours)","Planned Units (hours)","Under Limit (hours)","Location","On the Home page, click Dashboards.","Under Primavera, select Resource Analysis.","On the Resource Analysis dashboard, click the Role Utilization page.","On the Role Utilization page, expand the Role Under Limit section.","Subject Area","Role Utilization","Role Under Limit","83742.htm");
Page[224]=new Array("This page shows past period actuals for each resource and each project. It also displays the planned and actual units for each department and by data capture date, and planned units by data capture date.","Period Actuals","85271.htm");
Page[225]=new Array("Purpose","The line graph shows the actual units in past periods for each resource. The x-axis displays the past period data capture dates. The y-axis displays the actual units of the resource.","From the Resource Name list, select a resource to review their corresponding past period actuals chart. ","Location","On the Home page, click Dashboards.","Under Primavera, select Resource Analysis.","On the Resource Analysis dashboard, click the Period Actuals page.","Expand the Past Period Actuals by Resource section.","Subject Area","Resource Period Actuals","Past Period Actuals by Resource","85296.htm");
Page[226]=new Array("Purpose","The Period Actuals by Project section displays the actuals units for each activity performed by a resource in a project. The table provides a snapshot of the resource's history over past periods. ","Location","On the Home page, click Dashboards.","Under Primavera, select Resource Analysis.","On the Resource Analysis dashboard, click the Period Actuals page.","Expand the Period Actuals by Project section.","Subject Area","Resource Period Actuals","Period Actuals by Project","85297.htm");
Page[227]=new Array("Purpose","The Department Units by Data Capture Date section displays the planned units and the actual units of each department based on a data capture date. A data capture date is a snapshot of the data at a specific point in time.","Location","On the Home page, click Dashboards.","Under Primavera, select Resource Analysis.","On the Resource Analysis dashboard, click the Period Actuals page.","Expand the Department Units by Data Capture Date section.","Subject Area","Resource Period Actuals","Department Units by Data Capture Date","85298.htm");
Page[228]=new Array("Purpose","The Planned Units by Data Capture Date section displays a bar chart for the planned units for data capture dates over a period of time. A data capture date is a snapshot of the data at a specific point in time. The x-axis displays the data capture dates. The y-axis displays the planned units.","Location","On the Home page, click Dashboards.","Under Primavera, select Resource Analysis.","On the Resource Analysis dashboard, click the Period Actuals page.","Expand the Planned Units by Data Capture Date section.","Subject Area","Resource Period Actuals","Planned Units by Data Capture Date","85299.htm");
Page[229]=new Array("The Industry Samples dashboard uses data from P6 EPPM. ","It shows daily burn down, performance, work planning, and schedule adherence for industry related activities.","Industry Samples Dashboard","82042.htm");
Page[230]=new Array("This page shows an overview of daily burn downs, schedule compliance, and other performance metrics.","Shutdown/Turnaround/Outage Page","82043.htm");
Page[231]=new Array("Purpose","The line-bar chart shows burn down hours broken down by date. Use the View list to determine how the information is displayed. The available views are:","All: This displays totals for the project.","Resource Slider: This filters the chart by resource. The chart will update as the slider is moved.","The line-bar chart shows:","Bars for Original Remaining and Emergent Remaining hours for each day","Lines for the Total Man Hours, Baseline Work Down, and Current Work Down hours for each day","The x-axis shows the date. The y-axis shows hours.","Location","On the Home page, click Dashboards.","Under Primavera, select Industry Standards.","On the Industry Standards dashboard, click the Shutdown/Turnaround/Outage page.","On the Shutdown/Turnaround/Outage page, expand the Burn Down Hours section.","Subject Area","Burn Down","Burn Down Hours Section","82044.htm");
Page[232]=new Array("Purpose","The line-bar chart shows burn down counts broken down by date. Use the View list to determine whether the information is displayed as All or Resource Slider. The line-bar chart shows:","Bars for the Original Remaining and Emergent Remaining counts for each day","Lines for Total Number of Activities, Baseline Work Down, and Current Work Down counts for each day","The x-axis shows days. The y-axis shows the number of activities.","Location","On the Home page, click Dashboards.","Under Primavera, select Industry Samples.","On the Industry Samples dashboard, click the Shutdown/Turnaround/Outage page.","On the Shutdown/Turnaround/Outage page, expand the Burn Down Counts section.","Subject Area","Burn Down","Burn Down Counts Section","82045.htm");
Page[233]=new Array("Purpose","The pivot table shows daily data organized by date and team. The table has columns for:","Calendar Date","Team","Scheduled Starts (Yest)","Actual Reported Starts (Yest)","% Scheduled vs Actual Starts (Yest)","Scheduled Finishes (Yest)","Actual Reported Finish (Yest)","% Scheduled vs Actual Finish (Yest)","Scheduled Finishes Today","Actual Completed to Date","Scheduled Finishes to Date","Total Activities","Scope Changes","% Complete to Date","The last row shows the totals for each column.","Location","On the Home page, click Dashboards.","Under Primavera, select Industry Samples.","On the Industry Samples dashboard, click the Shutdown/Turnaround/Outage page.","On the Shutdown/Turnaround/Outage page, expand the Daily Performance section.	","Subject Area","Burn Down","Daily Performance Section","82047.htm");
Page[234]=new Array(" @","Purpose","The line-bar chart shows:","Bars for Original Schedule and Completed, Original Schedule and Not Completed, Emergent and Completed, and Total Scheduled","A line for Original Schedule Compliance percentage (the percentage of activities which were completed on a day that were scheduled to be completed on that day)","The x-axis shows the month, day, and year. The y-axis for the bars, on the left, shows the Activity Count. The y-axis for the line, on the right, shows the Schedule Compliance Percentage. Filter the chart by week using the Week Name list. Click on a bar or point to show the data in a table.","Location","On the Home page, click Dashboards.","Under Primavera, select Industry Standards.","On the Industry Standards dashboard, click the Shutdown/Turnaround/Outage page.","On the Shutdown/Turnaround/Outage page, expand the Schedule Compliance section.","Subject Area","Burn Down","Schedule Compliance Section","82049.htm");
Page[235]=new Array("Purpose","The analysis shows a Baseline, Actuals line chart and a Baseline Average, Actual Average, Baseline Daily, Actual Daily line-bar chart.","The Baseline, Actuals line chart shows lines for Baseline hours and Actuals hours for each day.","The x-axis shows dates. The y-axis shows hours.","The Baseline Average, Actual Average, Baseline Daily, Actual Daily line-bar chart shows:","Bars for Baseline Daily hours and Actual Daily hours","Lines for Baseline Average hours and Actual Average hours","The x-axis shows dates. The y-axis shows hours.","Location","On the Home page, click Dashboards.","Under Primavera, select Industry Standards.","On the Industry Standards dashboard, click the Shutdown/Turnaround/Outage page.","On the Shutdown/Turnaround/Outage page, expand the Average vs. Baseline (Hours) section.","Subject Area","Burn Down","Average vs. Baseline (Hours) Section","82051.htm");
Page[236]=new Array("Purpose","The analysis shows Baseline, Daily Actuals and Baseline, Daily Actuals (AVG) line charts.","The Baseline, Daily Actuals line chart shows lines for:","Baseline (a constant, set to 1)","Daily Actuals (calculated as Actual Labor Units divided by Planned Labor Units)","The x-axis shows dates. The y-axis shows Performance Index (calculated as Actual Labor Units divided by Planned Labor Units).","The Baseline, Daily Actuals (AVG) line chart shows lines for:","Baseline (a constant, set to 1)","Daily Actuals (calculated as a 365 day average of Actual Labor Units divided by Planned Labor Units)","The x-axis shows dates. The y-axis shows Performance Index (calculated as Actual Labor Units divided by Planned Labor Units).","Location","On the Home page, click Dashboards.","Under Primavera, select Industry Standards.","On the Industry Standards dashboard, click the Shutdown/Turnaround/Outage page.","On the Shutdown/Turnaround/Outage page, expand the Daily Performance Index (Hours) section.","Subject Area","Activity","Daily Performance Index (Hours) Section","82054.htm");
Page[237]=new Array("This page shows work planning and schedule adherence.","Routine/On-Line Maintenance Page","82056.htm");
Page[238]=new Array("Purpose","The pivot table shows how Key Performance Indicators (KPIs) are performing from a planning perspective in the upcoming execution work weeks. The percentages shown are color coded to highlight where improvement needs to be made. Green shaded percentages are good, yellow highlights potential issues, and red indicates where corrective action might be needed. The thresholds that determine when an issue is green, yellow, or red are customizable. The KPIs are based on INP0 AP-928 standards, which are used by the United States nuclear power utility industry. The last four KPIs shown are based on custom activity codes.","The columns show execution workweek start dates, workweeks, and workweek indicators (from T-05 to T-01, T-01 being next week and T-05 being five weeks in the future).","Note: The workweek is often used in the nuclear industry. This is determined by taking the last two digits of the year and attaching the week number to the end. For example, the 22nd week of 2013 would have a Workweek number of 1322 and the 23rd week would be 1323.","The rows show:","Scope Stability","Schedule Stability","Scope Survival","Emergent Work","Operations Clearances Ready","Parts Identification","Parts Availability","Maintenance Walkdowns Completed","Click on a cell to drill down to activities.","Location","On the Home page, click Dashboards.","Under Primavera, select Industry Standards.","On the Industry Standards dashboard, click the Routine/On-Line Maintenance page.","On the Routine/On-Line Maintenance page, expand the Work Planning Look Ahead section.","Subject Area","Work Planning","Work Planning Look Ahead Section","82057.htm");
Page[239]=new Array("Purpose","The pivot table shows a historical perspective of a particular execution work week, shown in the table as T-00. The table allows you to see how specific Key Performance Indicators (KPIs) performed week after week. The table shows the percentages for T-10 through T-00, T-10 being 10 weeks before the execution work week.","Cells are color coded per KPI to show whether the values represent good performance or indicate that corrective work should considered or is urgently required.","The columns show execution workweek indicators (from T-10 to T-00) and workweeks.","Note: The workweek is often used in the nuclear industry. This is determined by taking the last two digits of the year and attaching the week number to the end. For example, the 22nd week of 2013 would have a Workweek number of 1322 and the 23rd week would be 1323.","The rows show:","Scope Stability","Scope Survival","Schedule Stability","Emergent Work","Use the Execution Work Week list to change to view a different week's history.","Location","On the Home page, click Dashboards.","Under Primavera, select Industry Standards.","On the Industry Standards dashboard, click the Routine/On-Line Maintenance page.","On the Routine/On-Line Maintenance page, expand the Work Planning T+1 Critique section.","Subject Area","Work Planning","Work Planning T+1 Critique Section","82058.htm");
Page[240]=new Array("Purpose","The pivot table shows schedule adherence, broken down by team. The table contains columns for:","Team","Grade","Scheduled (Per day and total)","Completed (Per day and total)","Percentage of scheduled activities which were completed (Per day and total)","Click on a day name to see a table showing only that day.","Grades represent the level of work scheduling:","A: Hourly","B: Daily","C: Weekly","D: No Tracking","Location","On the Home page, click Dashboards.","Under Primavera, select Industry Standards.","On the Industry Standards dashboard, click the Routine/On-Line Maintenance page.","On the Routine/On-Line Maintenance page, expand the On-Line Daily Schedule Adherence - Graded section.","Subject Area","Burn Down","On-Line Daily Schedule Adherence - Graded Section","82200.htm");
Page[241]=new Array("Purpose","The pivot table shows schedule adherence, broken down by team. The table contains columns for:","Team","Scheduled (Per day and total)","Completed (Per day and total)","Percentage of scheduled activities which were completed (Per day and total)","Click on a week name to see a table showing only that week.","Location","On the Home page, click Dashboards.","Under Primavera, select Industry Standards.","On the Industry Standards dashboard, click the Routine/On-Line Maintenance page.","On the Routine/On-Line Maintenance page, expand the On-Line Daily Schedule Adherence - Standard section.","Subject Area","Burn Down","On-Line Daily Schedule Adherence - Standard Section","82060.htm");
Page[242]=new Array("Purpose","The bar-line chart shows scheduled compliance for the selected week. Original Schedule Compliance percentage measures the number of activities which were completed against the number which were scheduled to complete. The line-bar chart shows:","Bars for Original Schedule and Completed, Original Schedule and Not Completed, Emergent and Completed, and Total Scheduled","A line for Original Schedule Compliance Percentage","The x-axis shows dates. The y-axis for the bars, on the left, is the Activity Count. The y-axis for the line, on the right, is Schedule Compliance Percentage.","Select the week to view from the Week Name list. Click on a bar or point to show the data in table form.","Location","On the Home page, click Dashboards.","Under Primavera, select Industry Standards.","On the Industry Standards dashboard, click the Routine/On-Line Maintenance page.","On the Routine/On-Line Maintenance page, expand the Schedule Compliance section.","Subject Area","Burn Down","Schedule Compliance Section","82062.htm");
Page[243]=new Array("The Admin dashboard uses data from P6 EPPM and Unifier. ","It offers a view into the administration of your data source. On this dashboard, you can see information about the ETL (Extract Transform and Load) process and see a list of projects in the data source.","Admin Dashboard","82572.htm");
Page[244]=new Array("This page shows information about the ETL process for the data source and a list of projects.","Admin Page","82573.htm");
Page[245]=new Array("Purpose","The table shows information on the last ETL run and ETL history for each data source. The table contains columns for:","Data source Id","Process Id","ETL Start","ETL Finish","ETL Run Time","Total Runs","Avg ETL Run Time","Min ETL Run Time","Max ETL Run Time","Location","On the Home page, click Dashboards.","Under Primavera, select Admin.","On the Admin dashboard, click the Admin page.","On the Admin page, expand the ETL Summary section.","Subject Area","Admin","ETL Summary by Datasource Section","82574.htm");
Page[246]=new Array("Purpose","The line chart shows the trend of ETL run times for the data source selected in the Datasource Id list. ","The table shows details for each step of the last ETL run. The Process Id and ETL Start and Finish times are shown above the table. The table contains columns for:","Step Name","Step Description","Rows Processed","Time Elapsed","Location","On the Home page, click Dashboards.","Under Primavera, select Admin.","On the Admin dashboard, click the Admin page.","On the Admin page, expand the ETL Performance section.","Subject Area","Admin","ETL Performance Section","82578.htm");
Page[247]=new Array("Purpose","The table shows a list of the projects for the data source selected in the ETL Performance section Datasource Id list. The table contains columns for:","Project Id","Project Name","Location","On the Home page, click Dashboards.","Under Primavera, select Admin.","On the Admin dashboard, click the Admin page.","On the Admin page, expand the ETL Performance section.","Subject Area","Admin","Project List Section","82581.htm");
Page[248]=new Array("Purpose","The table shows information on the ETL parameter configuration for the Primavera Data Warehouse database.","Location","On the Home page, click Dashboards.","Under Primavera, select Admin.","On the Admin dashboard, click the Admin page.","On the Admin page, expand the ETL Parameters section.","Subject Area","Admin","ETL Parameters Section","82576.htm");
Page[249]=new Array("The analyses on these dashboards contain components and technologies, such as R, d3, and so on, that are considered optional within OAS (Oracle Analytics Server). If an analysis does not appear, there is a missing or incorrect installation of an optional component. Please consult the Primavera Data Warehouse Installation and Configuration Guide for information on how to install and configure these optional components.","More Dashboard","83912.htm");
Page[250]=new Array("The analyses on the d3 (Data-Driven Documents) dashboard contains components and technologies that are considered optional within OAS (Oracle Analytics Server). Use this advanced dashboard to manipulate data into visual representations of your analyses. For more information, consult the Primavera Data Warehouse Installation and Configuration Guide for instruction on how to install and configure these optional components.","d3 Dashboard","83913.htm");
Page[251]=new Array("Purpose","Use the Gantt chart to display and help determine the minimum amount of time needed for the completion of a project's activities. The x-axis shows the month, day, and time. The y-axis shows the specific operation within a project. ","Location","On the Home page, click Dashboards.","Under Primavera, select More.","On the More dashboard, click the d3 page.","On the d3 page, expand the Gantt Chart - Critical Path Lookahead section.","Subject Area","Activity","Gantt Chart - Critical Path Lookahead Section","83915.htm");
Page[252]=new Array("Purpose","Use the trend analysis graph to help forecast milestone finish dates based on past data and analyses. The x-axis shows the reporting date. The y-axis shows the milestone finish date. ","Location","On the Home page, click Dashboards.","Under Primavera, select More. ","On the More dashboard, click the d3 page.","On the d3 page, expand the Milestone Trend Analysis section.","Subject Area","Activity","Milestone Trend Analysis Section","83916.htm");
Page[253]=new Array("Purpose","Use the aster chart to display costs by country. Mouse over each section to view the cost details of each featured country. ","Location","On the Home page, click Dashboards.","Under Primavera, select More.","On the More dashboard, click the d3 page.","On the d3 page, expand the Aster Chart - Costs by Country section.","Subject Area","Activity","Aster Chart - Costs by Country Section","83917.htm");
Page[254]=new Array("Purpose","Use the donut chart to display risks broken down by project owner. Mouse over each section to view details about the risk's project owner and risk exposure. ","Location","On the Home page, click Dashboards.","Under Primavera, select More.","On the More dashboard, click the d3 page.","On the d3 page, expand the Donut Chart - Risks by Project Owner section.","Subject Area","Activity","Donut Chart - Risks by Project Owner Section","83922.htm");
Page[255]=new Array("Primavera Analytics includes several dashboards in the sample catalog. Use the sample dashboards as starting points to create custom dashboards and analyses that are tailored to your business needs. The power of Primavera Analytics is the ability to easily generate specific content for every user or role.","The Overview sample dashboard is available for Primavera Cloud.","Additional analyses are also available within the catalog for Primavera Cloud. ","To access analyses:","On the Home page, click Catalog.","In the Folders pane, select Shared folders, and then select the Primavera Cloud folder.","Sample Primavera Cloud Dashboard","85317.htm");
Page[256]=new Array("The Overview dashboard provides a synopses of the following for the projects and workspaces that you have access to in Primavera Cloud:","Resource Assignments","Schedule Health","Lean","Select each tab to view detailed information.","Overview Dashboard","85318.htm");
Page[257]=new Array("Purpose","The Variance (hours) section displays the extent of variance by comparing the Actual hours, Budgeted hours, and the At Completion Units (hours) for projects that are ahead of schedule and behind schedule. Select a Project Name to review the list of activities and their corresponding Actual, At Completion, and Budgeted Units (hours) with the variance value associated with each activity. The cumulative variance of all the activities is the variance (hours) for that project.","The Actual Vs. Forecast Units section displays the cumulative Forecasted Labor Units versus the Actual Units used by resources, and calculates the variance over a period of time. Use the Select a View list, to view this information as a graph (default) or table. The bar chart shows how resource hours were distributed over a selected period. The x-axis shows months and years. The y-axis shows units of time. In the bar chart, double-click on a column bar to view the following information associated with each project worked on by a resource in a specific month:","Planned Units","Actual Units","Remaining Units","At Completion Units","Actual Units Variance (calculated as the difference of Actual Units and the At Completion Units)","If you chose the table view for Actual Vs. Forecast Units, the following information displays for each resource name: ","Actual Units","At Completion Units","Actual Units Cumulated","Forecast Labor Units Cumulated","The Resource Performance section displays the efficiency of resources in completing their activities by evaluating late activities as a percentage of the total activities for each resource. The x-axis of the bar chart displays the resource names. The y-axis displays the # Activities and Late % for each resource. Double-click on a specific column bar in the bar chart to view all the activities associated with a specific resource name, and those completed late by the resource.","The Resource Hours section displays a stacked histogram to depict the total At Completion units of each resource used in each quarter of a specific period. The total at completion units for that quarter can be spread across one or more resources. The x-axis of the bar chart displays the resource names. The y-axis displays the resource units. In the bar chart, double-click a segment of a column bar to view the At Completion Units used by a resource across one or more projects in a specific quarter. ","Alternatively, from the Resource Name list, select a resource name to view the At Completion Units used by the resource for each project across several quarters in the selected period.","In the left pane, use the Filters section to view the resource usage and variance for a specific year, month, or project.","Location","On the Home page, click Dashboards.","Under Primavera Cloud, and select Overview.","On the Overview dashboard, click the Resource tab.","Subject Area","Primavera Cloud - Resource Assignment","Resource Page","85319.htm");
Page[258]=new Array("Purpose","The Schedule Health page displays the health metrics for all projects that you have access to in Primavera Cloud. The top section displays the a set of tiles corresponding to the projects. Select a specific tile to view a list of activities associated with the project.","The Schedule Assessment Settings section displays two sets of key performance indicators (KPIs): ","High-level KPIs for projects","Low-level KPIs at the activity level for projects","Change the values of the KPIs settings to view the impact of these settings on the projects listed in the Project table. Select any cell in the Project table to view a list of activities that contributed towards the KPI value of that project.","Note: When creating an analysis, the KPIs are retrieved as fact values, and therefore can be drag-and-dropped as needed. You can also change the calculation of the KPIs as needed by selecting fields that are used for calculations from the fact tables.","Location","On the Home page, click Dashboards.","Under Primavera Cloud, and select Overview.","On the Overview dashboard, click the Schedule Health tab.","Subject Area","Primavera Cloud - Schedule Health","Schedule Health Page","85320.htm");
Page[259]=new Array("Purpose","The Lean page displays committed vs. completed task information for all the projects you have access to in Primavera Cloud that are set up for lean.","The Settings section displays a set of filters which are configurable to the needs of your organization.","The Commitments Vs. Completed by Week section displays a bar chart that captures the progress of tasks for all projects that are set up for lean. It displays a bar chart that displays the completed lean tasks in comparison those committed each week. The x-axis displays the week dates of commitments. The y-axis displays a count of the commitments.","The Commitments by Reason section allows you to review the underlying reasons for missed commitments or re-commitments for projects set up for lean. It displays a horizontal bar chart for counts of missed commitments categorized by reasons for every project. The x-axis displays the commitment count. The y-axis displays the reasons for the missed commitments.","The Percent Completes section displays a table listing all the tasks committed and completed in terms of counts and percentages for each project set up for lean.","Location","On the Home page, click Dashboards.","Under Primavera Cloud, and select Overview.","On the Overview dashboard, click the Lean tab.","Subject Area","Primavera Cloud - Lean Task","Lean Page","85321.htm");
Page[260]=new Array("In the Oracle Analytics Server URL, http://&lt;server&gt;:&lt;port&gt;/analytics, replace analytics with /dv/ui. ","The URL to access Data Visualization user interface is:","http://&lt;host&gt;:&lt;port&gt;/dv/ui","where:","&lt;server&gt; is the server name or IP address of the server where Oracle Analytics Server is installed and running","&lt;port&gt; is the listening port number for Data Visualization","/analytics is the default context for Data Visualization.","To learn more, watch this short video on Using Data Visualization. ","Accessing Data Visualization","85447.htm");
Page[261]=new Array("Location","On the Home page, click Catalog.","In the left pane, under Shared Folders, select DV Samples.","Under Business Process Overview, click Open.","Subject Area","Business Process","Amount by Business Process Type","84131.htm");
Page[262]=new Array("Location","On the Home page, click Catalog.","In the left pane, under Shared Folders, select DV Samples.","Under Business Process Overview, click Open.","Subject Area","Business Process","Vendor Summary","84132.htm");
Page[263]=new Array("Location","On the Home page, click Catalog.","In the left pane, under Shared Folders, select DV Samples.","Under Business Process Overview, click Open.","Subject Area","Business Process","# of BP Records by Business Process Type","84133.htm");
Page[264]=new Array("Location","On the Home page, click Catalog.","In the left pane, under Shared Folders, select DV Samples.","Under Business Process Overview, click Open.","Subject Area","Business Process","BP Line Item Amount by Country","84134.htm");
Page[265]=new Array("Location","On the Home page, click Catalog.","In the left pane, under Shared Folders, select DV Samples.","Under Cash Flow Summary, click Open.","Subject Area","Cash Flow","Cash Flow Summary Line","84129.htm");
Page[266]=new Array("Location","On the Home page, click Catalog.","In the left pane, under Shared Folders, select DV Samples.","Under Cash Flow Summary, click Open.","Subject Area","Cash Flow","Cash Flow Summary Table","84135.htm");
Page[267]=new Array("Location","On the Home page, click Catalog.","In the left pane, under Shared Folders, select DV Samples.","Under Cost by Location, click Open.","Subject Area","Activity","Cost by Location Map","84128.htm");
Page[268]=new Array("Location","On the Home page, click Catalog.","In the left pane, under Shared Folders, select DV Samples.","Under Cost by Location, click Open.","Subject Area","Activity","Cost by Location Horizontal Bar","84130.htm");
Page[269]=new Array("Location","On the Home page, click Catalog.","In the left pane, under Shared Folders, select DV Samples.","Under Cost Overview, click Open.","Subject Area","Activity","At Completion Cost Tree Map","84124.htm");
Page[270]=new Array("Location","On the Home page, click Catalog.","In the left pane, under Shared Folders, select DV Samples.","Under Cost Overview, click Open.","Subject Area","Activity","At Completion Cost by Country","84125.htm");
Page[271]=new Array("Location","On the Home page, click Catalog.","In the left pane, under Shared Folders, select DV Samples.","Under Cost Overview, click Open.","Subject Area","Activity","Cost by EPS Level 1","84126.htm");
Page[272]=new Array("Location","On the Home page, click Catalog.","In the left pane, under Shared Folders, select DV Samples.","Under Cost Overview, click Open.","Subject Area","Activity","Actual/Planned Cost by Month","84127.htm");
Page[273]=new Array("Location","On the Home page, click Catalog.","In the left pane, under Shared Folders, select DV Samples.","Under Cost Trend, click Open.","Subject Area","Project History","Cost Trend Table","84123.htm");
Page[274]=new Array("Location","On the Home page, click Catalog.","In the left pane, under Shared Folders, select DV Samples.","Under Cost Variance KPI, click Open.","Subject Area","Activity","Cost Variance KPI Table","84122.htm");
Page[275]=new Array("Location","On the Home page, click Catalog.","In the left pane, under Shared Folders, select DV Samples.","Under Data Mashup Example, click Open.","Subject Area","Activity","Counts by PM Category","84136.htm");
Page[276]=new Array("Location","On the Home page, click Catalog.","In the left pane, under Shared Folders, select DV Samples.","Under Data Mashup Example, click Open.","Subject Area","Activity","Data Mashup Table","84137.htm");
Page[277]=new Array("Location","On the Home page, click Catalog.","In the left pane, under Shared Folders, select DV Samples.","Under Data Mashup Example, click Open.","Subject Area","Activity","PM Planned vs. Actual Hours by Week","84138.htm");
Page[278]=new Array("Location","On the Home page, click Catalog.","In the left pane, under Shared Folders, select DV Samples.","Under Earned Value KPI, click Open.","Subject Area","Activity","Planned Value","84117.htm");
Page[279]=new Array("Location","On the Home page, click Catalog.","In the left pane, under Shared Folders, select DV Samples.","Under Earned Value KPI, click Open.","Subject Area","Activity","Earned Value","84118.htm");
Page[280]=new Array("Location","On the Home page, click Catalog.","In the left pane, under Shared Folders, select DV Samples.","Under Earned Value KPI, click Open.","Subject Area","Activity","Actual Cost","84119.htm");
Page[281]=new Array("Location","On the Home page, click Catalog.","In the left pane, under Shared Folders, select DV Samples.","Under Earned Value KPI, click Open.","Subject Area","Activity","Budget at Completion","84120.htm");
Page[282]=new Array("Location","On the Home page, click Catalog.","In the left pane, under Shared Folders, select DV Samples.","Under Earned Value KPI, click Open.","Subject Area","Activity","Earned Value KPI Table","84121.htm");
Page[283]=new Array("Location","On the Home page, click Catalog.","In the left pane, under Shared Folders, select DV Samples.","Under Floor Example, click Open.","Subject Area","Activity","Remaining Duration by Floor","84114.htm");
Page[284]=new Array("Location","On the Home page, click Catalog.","In the left pane, under Shared Folders, select DV Samples.","Under Floor Example, click Open.","Subject Area","Activity","Original Duration by Floor","84115.htm");
Page[285]=new Array("Location","On the Home page, click Catalog.","In the left pane, under Shared Folders, select DV Samples.","Under Floor Example, click Open.","Subject Area","Activity","Floor Example Table","84116.htm");
Page[286]=new Array("Location","On the Home page, click Catalog.","In the left pane, under Shared Folders, select DV Samples.","Under Labor Units History, click Open.","Subject Area","Activity History","Labor Units by Month Bar","84112.htm");
Page[287]=new Array("Location","On the Home page, click Catalog.","In the left pane, under Shared Folders, select DV Samples.","Under Labor Units History, click Open.","Subject Area","Activity History","At Completion Labor Units by Month","84113.htm");
Page[288]=new Array("Location","On the Home page, click Catalog.","In the left pane, under Shared Folders, select DV Samples.","Under Labor Units History, click Open.","Subject Area","Activity History","Labor Units by Month Table","84111.htm");
Page[289]=new Array("Location","On the Home page, click Catalog.","In the left pane, under Shared Folders, select DV Samples.","Under Overdue Tasks, click Open.","Subject Area","Activity","Overdue Tasks Table","84110.htm");
Page[290]=new Array("Location","On the Home page, click Catalog.","In the left pane, under Shared Folders, select DV Samples.","Under Portfolio Overview, click Open.","Subject Area","Activity","Portfolio Tree Map","84106.htm");
Page[291]=new Array("Location","On the Home page, click Catalog.","In the left pane, under Shared Folders, select DV Samples.","Under Portfolio Overview, click Open.","Subject Area","Activity","# of Projects by Strategic Rating","84107.htm");
Page[292]=new Array("Location","On the Home page, click Catalog.","In the left pane, under Shared Folders, select DV Samples.","Under Portfolio Overview, click Open.","Subject Area","Activity","At Completion Cost by Portfolio","84108.htm");
Page[293]=new Array("Location","On the Home page, click Catalog.","In the left pane, under Shared Folders, select DV Samples.","Under Portfolio Overview, click Open.","Subject Area","Activity","Risk Exposure","84109.htm");
Page[294]=new Array("Location","On the Home page, click Catalog.","In the left pane, under Shared Folders, select DV Samples.","Under Schedule Perf &amp; SPI, click Open.","Subject Area","Activity","Cost Performance Index (Cost)","84103.htm");
Page[295]=new Array("Location","On the Home page, click Catalog.","In the left pane, under Shared Folders, select DV Samples.","Under Schedule Perf &amp; SPI, click Open.","Subject Area","Activity","Schedule Performance Index (Units)","84104.htm");
Page[296]=new Array("Location","On the Home page, click Catalog.","In the left pane, under Shared Folders, select DV Samples.","Under Schedule Perf &amp; SPI, click Open.","Subject Area","Activity","Remaining &amp; Actual Labor Units","84105.htm");
Page[297]=new Array("The activity use cases demonstrate example activity scenarios you can encounter while using the Burn Down feature and the expected outcomes after running the ETL process.","Note: For information on scheduling Burn Down, see &quot;Using Burn Down for P6 EPPM Data&quot; in the Primavera Analytics On-Premises Administration Guide or the Primavera Analytics Cloud Service Administration Guide.","Burn Down Activity Use Cases","82192.htm");
Page[298]=new Array("The following topics show individual activity use case details for different Burn Down project activity states.","The following assumptions are made for the activity use cases:","sys_workdown_date: The project schedule uses a sys_workdown_date of 3/31/2013.","Data Date: This is equal to the project's Data Date when the ETL process is run.","ETL Process Date: The ETL process is run each day no later than 11:59 p.m. and after the schedule is updated and the Data Date is advanced.","To properly calculate Burn Down metrics, the schedule must be updated and the ETL process must be run daily.","Burn Down Activity Scenarios","82110.htm");
Page[299]=new Array("This use case describes what happens when an activity completes before the Outage Project Snapshot is taken.","P6 Values Table","Field","Planned Value","Actual Value","Start","3/30/2013 12:00 a.m.","3/30/2013 12:00 a.m.","Finish","3/30/2013 10:00 a.m.","3/30/2013 10:00 a.m.","Duration","10 hours","10 hours","Units","10","10","Burn Down Results","3/31: Only the Actual Units Burn values will be captured in Burn Down because the activity was completed before the snapshot date of 3/31/2013.","Day","Remaining Units Burn","Actual Units Burn","Completed","Emergent Count","Day 0 (3/31)","0","10","0","0","Day 1 (4/1)","0","10","0","0","Day 2 (4/2)","0","10","0","0","Day 3 (4/3)","0","10","0","0","Note: These activities can be filtered with Oracle Analytics Server.","Completed Before Outage Project Snapshot Use Case","82112.htm");
Page[300]=new Array("This use case describes what happens when an activity starts before the sys_workdown_date and ends after the Outage Project Snapshot is taken, on Day 1.","P6 Values Table","Field","Planned Value","Actual Value","Start","3/30/2013 12:00 a.m.","3/30/2013 12:00 a.m.","Finish","4/01/2013 2:00 a.m.","4/01/2013 2:00 a.m.","Duration","50 hours","50 hours","Units","50","50","Burn Down Results","3/31: When the ETL process runs, this activity has only two Remaining Units and it is scheduled to finish on Monday 4/01/2013 (Day 1).","4/01: The activity is completed in P6 on 4/01 and then it is counted as complete when the ETL runs on 4/01. The Actual Units Burn value of 50 will continue to be captured after completion so Cumulative Totals can be counted by day.","Day","Remaining Units Burn","Actual Units Burn","Completed","Emergent Count","Day 0 (3/31)","2","48","0","0","Day 1 (4/01)","0","50","1","0","Day 2 (4/02)","0","50","0","0","Day 3 (4/03)","0","50","0","0","Started Before Outage Project Snapshot Spanning into Outage Use Case","82113.htm");
Page[301]=new Array("This use case describes what happens when an activity starts and completes on the project snapshot date.","P6 Values Table","Field","Planned Value","Actual Value","Start","3/31/2013 12:00 a.m.","3/31/2013 12:00 a.m.","Finish","3/31/2013 10:00 a.m.","3/31/2013 10:00 a.m.","Duration","10 hours","10 hours","Units","10","10","Burn Down Results","3/31: The activity is completed in P6 and counted as complete when the ETL process runs. The Actual Units Burn value of 10 will continue to be captured after completion so Cumulative Totals can be counted by day.","Day","Remaining Units Burn","Actual Units Burn","Completed","Emergent Count","Day 0 (3/31)","0","10","1","0","Day 1 (4/01)","0","10","0","0","Day 2 (4/02)","0","10","0","0","Day 3 (4/03)","0","10","0","0","Completed Day of Outage Project Snapshot Use Case","82114.htm");
Page[302]=new Array("This use case describes what happens when an activity starts on the project snapshot date and completes on Day 1 of the outage.","P6 Values Table","Field","Planned Value","Actual Value","Start","3/31/2013 12:00 a.m.","3/31/2013 12:00 a.m.","Finish","4/01/2013 6:00 a.m.","4/01/2013 6:00 a.m.","Duration","30 hours","30 hours","Units","30","30","Burn Down Results","3/31: When the ETL process runs, this activity will have six Remaining Units and it will be scheduled to finish on Monday 4/01/2013 (Day 1).","4/01: The activity is completed in P6 and then it is counted as complete when the ETL process runs. The Actual Units Burn value of 30 will continue to be captured after completion so Cumulative Totals can be counted by day.","Day","Remaining Units Burn","Actual Units Burn","Completed","Emergent Count","Day 0 (3/31)","6","24","0","0","Day 1 (4/1)","0","30","1","0","Day 2 (4/2)","0","30","0","0","Day 3 (4/3)","0","30","0","0","Pre-Outage Work Spanning into Outage Use Case","82115.htm");
Page[303]=new Array("This use case describes what happens when an activity starts and completes as scheduled on Day 1 of the outage.","P6 Values Table","Field","Planned Value","Actual Value","Start","4/01/2013 12:00 a.m.","4/01/2013 12:00 a.m.","Finish","4/01/2013 10:00 a.m.","4/01/2013 10:00 a.m.","Duration","10 hours","10 hours","Units","10","10","Burn Down Results","3/31: When the ETL process runs, this activity has 10 Remaining Units and it is scheduled to finish on Monday 4/01/2013 (Day 1).","4/01: The activity is completed in P6 and counted as complete when the ETL process runs. The Actual Units Burn value of 10 will continue to be captured after completion so Cumulative Totals can be counted by day.","Day","Remaining Units Burn","Actual Units Burn","Completed","Emergent Count","Day 0 (3/31)","10","10","1","0","Day 1 (4/01)","0","10","0","0","Day 2 (4/02)","0","10","0","0","Day 3 (4/03)","0","10","0","0","Completed as Scheduled on Day 1 of Outage Use Case","82116.htm");
Page[304]=new Array("This use case describes what happens when an activity starts on Day 2 and additional Remaining Units and Duration are added to the activity causing it to not finish as scheduled. In this use case, the activity finishes on the following day, 4/03/2013.","P6 Values Table","Field","Planned Value","Actual Value","Start","4/02/2013 12:00 a.m.","4/02/2013 12:00 a.m.","Finish","4/02/2013 10:00 a.m.","4/03/2013 6:00 a.m.","Duration","10 hours","30 hours","Units","10","30 (+20)","Burn Down Results","3/31: When the ETL process runs, this activity has 10 Remaining Units and it is scheduled to finish on Monday 4/02/2013 (Day 2).","4/01: When the ETL process runs, this activity still has 10 Remaining Units and is scheduled to finish on Monday 4/02/2013 (Day 2). ","4/02: The activity has 20 additional units added.","The Remaining Units Burn increases from 0 to 6.","Actual Units Burn increases from 10 to 24.","4/03: The activity is completed in P6 and counted as complete when the ETL process runs.","Day","Remaining Units Burn","Actual Units Burn","Completed","Emergent Count","Day 0 (3/31)","10","0","0","0","Day 1 (4/01)","10","0","0","0","Day 2 (4/02)","6","24","0","0","Day 3 (4/03)","0","30","1","0","Completed Late on Day 3 of Outage Use Case","82117.htm");
Page[305]=new Array("This use case describes what happens when an activity is added to the schedule on Day 2 and completed on Day 3.","P6 Values Table","Field","Planned Value","Actual Value","Start","4/03/2013 12:00 a.m.","4/03/2013 12:00 a.m.","Finish","4/03/2013 10:00 a.m.","4/03/2013 10:00 a.m.","Duration","10 hours","10 hours","Units","10","10 (+10)","Burn Down Results","4/02: The activity is added and scheduled to complete on 4/03.","Remaining Units Burn = 10","Emergent Count = 1","4/03: The activity is completed in P6 and counted as complete when the ETL process runs.","Day","Remaining Units Burn","Actual Units Burn","Completed","Emergent Count","Day 0 (3/31)","0","0","0","0","Day 1 (4/01)","0","0","0","0","Day 2 (4/02)","10","0","0","1","Day 3 (4/03)","0","10","1","0","Emergent Activity on Day 3 of Outage Use Case","82118.htm");
Page[306]=new Array("This use case describes what happens when an activity is completed as scheduled on Day 1 and deleted on Day 3.","P6 Values Table","Field","Planned Value","Actual Value","Start","4/01/2013 12:00 a.m.","4/01/2013 12:00 a.m.","Finish","4/01/2013 10:00 a.m.","4/01/2013 10:00 a.m.","Duration","10 hours","10 hours","Units","10","10","Burn Down Results","3/31: When the ETL process runs, this activity has 10 Remaining Units and it is scheduled to finish on Monday, 4/01/2013 (Day 1).","4/01: The activity is completed in P6 and counted as complete when the ETL process runs. The Actual Units Burn value of 10 will continue to be captured after completion so Cumulative Totals can be counted by day.","4/02: There will be no change on 4/02.","4/03: The activity is deleted in P6 and, when the ETL process runs, all records for this activity are removed from the Burn Down subject area.","Day","Remaining Units Burn","Actual Units Burn","Completed","Emergent Count","Day 0 (3/31) (Day and values deleted)","0","0","0","0","Day 1 (4/01) (Day and values deleted)","0","0","0","0","Day 2 (4/02) (Day and values deleted)","10","0","0","1","Day 3 (4/03) (Day and values deleted)","0","10","1","0","Note: Alternatively, this activity can be marked or coded as deleted in P6. The activity is not physically deleted, but is filtered out in Oracle Analytics Server.","Deleted After Outage Start Use Case","82119.htm");
Page[307]=new Array("The following topics detail how the Burn Down subject area captures metrics from your P6 project on a daily basis.","Data Flow from P6 EPPM to Primavera Analytics","82120.htm");
Page[308]=new Array("sys_workdown_date: 3/31/2013","Data Date: 3/31/2013","ETL Process Date: 3/31/2013 11:59 p.m.","On Day 0, two activities are started and in-progress. One activity is started and completed on 3/31/2013. At the time the ETL process is run, the schedule is captured in the Burn Down. ","This ETL process capture point becomes the Burn Down baseline of the schedule in Primavera Analytics, as 3/31/2013 is the date specified in the sys_workdown_date Project UDF value. All activities completed on or after the 3/31/2013 date until the project&#8217;s Finish Date receive these baseline metrics.","Schedule Updates","Started before Outage Project Snapshot Spanning into Outage - AC2","Status: In-progress","Actual Units: 48","Remaining Units: 2","Completed Day of Outage Project Snapshot - AC3","Status: Complete","Actual Units: 10","Remaining Units: 0","Pre-Outage Work Spanning into Outage - AC4","Status: In-progress","Actual Units: 24","Remaining Units: 6","Burn Down Hours","Burn Down Hours Summary","38 Baseline Hours remain","38 Actual Hours remain","130 Total Hours (Actual and Remaining) ","At the time the ETL process is run on 3/31/2013 there are 38 hours remaining in the schedule. There are 130 Total Hours remaining, which is a combination of the Actual Units Burn and Remaining Units Burn.","The table shows a subset of the activity metrics that are summarized in the Burn Down Hours line-bar chart.","Burn Down Counts","Burn Down Counts Summary","5 Baseline Activities remain","5 Actual Activities remain","7 Total Activities (Complete and Remaining) ","At the time the ETL process is run on 3/31/2013, there are five activities with hours remaining in the schedule. There are seven Total Activities, which include activities with Remaining Units and all other activities included as of the sys_workdown_date ETL process snapshot.","The table shows a subset of the activity metrics that are summarized in the Burn Down Counts line-bar chart.","Day 0 (3/31/2013)","82121.htm");
Page[309]=new Array("sys_workdown_date: 3/31/2013","Data Date: 4/01/2013","ETL Process Date: 4/01/2013 11:59 p.m.","On Day 1, three activities are marked complete, leaving only two activities remaining. The Data Date is then updated accordingly. At the time the ETL process is run, the actuals are captured from the schedule in the Burn Down. ","Schedule Updates","Started before Outage Project Snapshot Spanning into Outage - AC2","Status: Complete","Actual Units: 50 (2 today)","Remaining Units: 0","Pre-Outage Work Spanning into Outage - AC4","Status: Complete","Actual Units: 30 (6 today)","Remaining Units: 0","Completed as Schedule on Day 1 of Outage - AC5","Status: Complete","Actual Units: 10","Remaining Units: 0","Burn Down Hours","Burn Down Hours Summary","20 Baseline Hours remain","20 Actual Hours remain","130 Total Hours (Actual and Remaining) ","At the time the ETL process is run on 4/01/2013 there are 20 hours remaining in the schedule. As all the activities still match the plan on 3/31/2013, there are 130 Total Hours, which is a combination of the Actual Units Burn and Remaining Units Burn.","The table shows a subset of the activity metrics that are summarized in the Burn Down Hours line-bar chart for Day 1.","Burn Down Counts","Burn Down Counts Summary","2 Baseline Activities remain","2 Actual Activities remain","6 Total Activities (Complete and Remaining) ","At the time the ETL process is run on 4/01/2013, there are two activities with hours remaining in the schedule. As all of the activities match the plan on 3/31/2013, there are seven Total Activities, which include activities with Remaining Units and all other activities included as of the sys_workdown_date ETL process snapshot.","The table shows a subset of the activity metrics that are summarized in the Burn Down Counts line-bar chart.","Day 1 (4/01/2013)","82127.htm");
Page[310]=new Array("sys_workdown_date: 3/31/2013 ","Data Date: 4/02/2013 ","ETL Process Date: 4/02/2013 11:59 p.m.","On Day 2, one activity is marked complete, one activity is started (but not completed as scheduled), and two new activities are added to the schedule to be completed on 4/03/2013. Three activities are left. The Data Date is updated accordingly and the actuals are captured from the schedule in the Burn Down. ","Schedule Updates","Completed Late on Day 3 of Outage - AC6","Status: In-progress","Actual Units: 24 (24 today)","Remaining Units: 6","Planned: 10","Emergent Activity A on Day 3 of Outage - AC7","Status: Not Started","Actual Units: 0","Remaining Units: 0","Emergent Activity B on Day 3 of Outage - AC8","Status: Not Started","Actual Units: 0","Remaining Units: 10","Deleted After Outage Start - AC9","Status: Complete","Actual Units: 10 (10 today)","Remaining Units: 0","Burn Down Hours","Burn Down Hours Summary","0 baseline hours remain","6 actual hours remain (from original activities in the schedule)","20 emergent hours remain","170 Total hours (actual and remaining)","At the time the ETL process is run on 4/02/2013, there are six hours remaining from the late activity with additional units and 20 emergent hours remaining from the activities added to the schedule. There are 170 Total Hours, which is a combination of the Actual Units Burn and Remaining Units Burn. The Baseline Hours are 0, illustrating the deviation from the plan on 3/31.","The table shows a subset of the activity metrics that are summarized in the Burn Down Hours line-bar chart.","Burn Down Counts","Burn Down Counts Summary","1 Baseline Activity remains","1 Actual Activity remains (from original activities in the schedule)","2 Emergent Activities remain","9 Total Activities (Original and Emergent)","At the time the ETL process is run on 4/02/2013 there are two emergent, one original, and one baseline activity remaining in the schedule. There are nine Total Activities as a result of the two new activities added to the schedule. ","The table shows a subset of the activity metrics that are summarized in the Burn Down Counts line-bar chart.","Day 2 (4/02/2013)","82133.htm");
Page[311]=new Array("sys_workdown_date: 3/31/2013 ","Data Date: 4/03/2013 ","ETL Process Date: 4/03/2013 11:59 p.m.","On Day 3, one activity is deleted. The late activity and two emergent activities are completed. Zero activities now remain. The Data Date is updated accordingly and the actuals are captured from the schedule in the Burn Down. ","Schedule Updates","Emergent Activity B on Day 3 of Outage - AC6","Status: Complete","Actual Units: 10","Remaining Units: 0","Emergent Activity A on Day 3 of Outage - AC7","Status: Complete","Actual Units: 30 (6 today)","Remaining Units: 0","Emergent Activity A on Day 3 of Outage - AC8","Status: Complete","Actual Units: 10","Remaining Units: 0","Deleted After Outage Start - AC9","Status: X - Deleted","Burn Down Hours","Burn Down Hours Summary","0 Baseline Hours remain","0 Actual Hours remain (from original activities in the schedule)","0 Emergent Hours remain","170 Total Hours (Actual and Remaining)","At the time the ETL is run on 4/3/2013, all activities are completed and 0 hours remain in the schedule. There are 160 Total Hours, due to the deletion of one 10 hour activity from the schedule. The Burn Down is now complete.","The table shows a subset of the activity metrics that are summarized in the Burn Down Hours line-bar chart.","Burn Down Counts","Burn Down Counts Summary","0 Baseline Activities remain","0 Actual Activities remain","0 Emergent Activities remain","6 Total activities (Original and Emergent)","At the time the ETL process is run on 4/03/2013, there are zero activities remaining in the schedule. There are eight Total Activities as a result of the activity deleted from the schedule. ","The table shows a subset of the activity metrics that are summarized in the Burn Down Counts line-chart.","Day 3 (4/03/2013)","82139.htm");
var PageCount=312;


/*
Date: 1/5/2026 2:56 PM
Source: analytics_26_dev
BookID: 81881
PubProduct: PRIMAVERA_ANALYTICS
BookTitle: Reference Guide
Version: Version 26
Lang:	en
*/
	var PageLength=Page.length;
	var Result = "";
	var ResultTemp = "";
	var ResultFound = "";
	var ResultTitleOnly = [];
	var ResultTitleAndContent = [];
	var ResultInContent = [];
	var ResultInContentTemp = [];

	var ResultCombinedTemp = [];
	var ResultCombined = [];

	var arrayIndex = 0;
	var NrRes = 0;
	var j = 0;
	var i = 0;
	var k = 0;
	var d = 0;
	var maxItems = 1000;
	var heading = 0;
	var WordPos = -1;
	var WordPosHeading = -1;
	var WordPosContentText = -1;
	var FoundWord = "";
	var FoundWordHead = "";
	var SearchInHeadingOnly = 0;
	var isChecked;
	var size = 10;
	var resGroupCounter = 0;
	var shown = "shown";
	var checkBoxInHeading;
	var searchFlag = 0;
	var DivResult;
	var SearchWord;

if (SearchText && SearchText.length >= 1) {
		SearchWord = SearchText.replace(/\+/g, " ").replace(/&/g, "&amp;").replace(/</g, "&lt;").replace(/>/g, "&gt;").replace(/"/g, "&quot;");
		searchFlag = 1;
	} else {
		SearchWord = "";
		searchFlag = 0;
	}
	

	if (searchFlag === 1) {
		Result = "";

		// checkBoxInHeading = document.getElementById("inHeading");
		if (inHeading) {

			isChecked = true;
		} else {

			isChecked = false;
		}

		if (SearchWord && SearchWord.length >= 1) {
			if (isChecked) {
				SearchInHeadingOnly = 1;
			} else {
				SearchInHeadingOnly = 0;
			}
			SearchWord = SearchWord.toLowerCase();
			window.status = "Searching, please wait...";
			for (j = 0; j < PageLength; j++) {
				k = Page[j].length - 1;
				for (i = 0; i < k; i++) {

					heading = k - 1;

					if (SearchInHeadingOnly === 1) {
						WordPosHeading = Page[j][heading].toLowerCase().indexOf(SearchWord);
						if (WordPosHeading > -1) {
							FoundWordHead = Page[j][heading].substr(WordPosHeading, SearchWord.length);

							NrRes++;
							ResultTemp = "<li>";
							ResultTemp += "<span>";
							ResultTemp += "<a href='" + Page[j][k] + "'>" + Page[j][heading].replace(FoundWordHead, FoundWordHead.bold()) + "</a><br/>\n";

							ResultTemp += "</span>";
							ResultTemp += "</li>";

							ResultTitleOnly[arrayIndex] = ResultTemp;
							arrayIndex++;

							ResultTemp = "";
							WordPosHeading = -1;
							WordPosContentText = -1;
							break;
						}
					} else if (SearchInHeadingOnly === 0) {
						WordPos = Page[j][i].toLowerCase().indexOf(SearchWord);
						WordPosHeading = Page[j][heading].toLowerCase().indexOf(SearchWord);
						if (WordPos > -1) {
							FoundWordHead = Page[j][heading].substr(WordPosHeading, SearchWord.length);
							FoundWord = Page[j][i].substr(WordPos, SearchWord.length);
							FoundWord = Page[j][i].substr(WordPos, SearchWord.length);
							NrRes++;
							ResultTemp += "<li>";
							ResultTemp += "<span>";
							if (WordPosHeading > -1) {
								ResultTemp += "<a href='" + Page[j][k] + "'>" + Page[j][heading].replace(FoundWordHead, FoundWordHead.bold()) + "</a><br/>\n";
							} else {
								// found word is not in the head
								ResultTemp += "<a href='" + Page[j][k] + "'>" + Page[j][heading] + "</a><br/>\n";

							}
							if (i < k - 1) {
								WordPosContentText = Page[j][i].toLowerCase().indexOf(SearchWord);

								if (Page[j][i].length > 300 && (WordPosContentText > -1)) {

									if (WordPosContentText > 75) {
										ResultInContentTemp.push("..." + Page[j][i].substr(WordPosContentText - 75, 175 + FoundWord.length).replace(FoundWord, FoundWord.bold()) + "...");
									} else {
										ResultInContentTemp.push("..." + Page[j][i].substr(0, 175 + FoundWord.length).replace(FoundWord, FoundWord.bold()) + "...");

									}

								} else if (WordPosContentText > -1) {

									ResultInContentTemp.push(Page[j][i].replace(FoundWord, FoundWord.bold()));

								}
							}

							ResultTemp += ResultInContentTemp.join("");

							ResultTemp += "</span>";
							ResultTemp += "</li>";

							if (WordPosHeading > -1) {
								ResultTitleAndContent[arrayIndex] = ResultTemp;
								arrayIndex++;
							} else {
								ResultInContent[arrayIndex] = ResultTemp;
								arrayIndex++;
							}

							ResultInContentTemp.length = 0;
							ResultTemp = "";
							WordPosHeading = -1;
							WordPosContentText = -1;
							break;
						}

					}
				}
			}

			ResultTitleOnly = ResultTitleOnly.filter(function (n) {
				return (n !== undefined && n !== null);
			});
			ResultTitleAndContent = ResultTitleAndContent.filter(function (n) {
				return (n !== undefined && n !== null);
			});
			ResultInContent = ResultInContent.filter(function (n) {
				return (n !== undefined && n !== null);
			});

			ResultCombinedTemp = ResultTitleOnly.concat(ResultTitleAndContent, ResultInContent);

			ResultCombinedTemp = ResultCombinedTemp.filter(function (n) {
				return (n !== undefined && n !== null);
			});

			for (d = 0; d < ResultCombinedTemp.length; d += size) {
				resGroupCounter++
				ResultCombined.push("<div id=" + "'" + "resGroup_" + resGroupCounter + "'" + " class=" + "'" + "resGroup " + shown + "'" + ">" + "<ol class='searchResults'>" + ResultCombinedTemp.slice(d, d + size).join("") + "</ol></div>");
				shown = "notshown";
			}

			ResultFound = ResultCombined.join("");

Result += "<div id='searchDetailsDiv'>";
			Result += "<p class='searchDetails'>Your Search Found&nbsp;" + NrRes + "&nbsp;items.&nbsp;";
			Result += "</p></div>";
			
			Result += "<div class='searchResultsDiv'>";
			Result += "<div id='resultsCollection' class='searchResults'>";
			Result += ResultFound;
			Result += "</div>";
			Result += "</div>";
			Result += "<div class='searchPaging'>";

			Result += '<hr />';

			Result += '<p class="bodytext"><a class="disabledAnchor" id="pBack" onclick="turnPage(\'backPage\')" href="#pBack">Back</a>&nbsp; | &nbsp;';
			
			if (resGroupCounter && resGroupCounter > 1) {
				Result += '<a id="pNext" onclick="turnPage(\'nextPage\')" href="#pNext">Next</a>';
			} else {
				Result += '<a id="pNext"  class="disabledAnchor" href="#pNext">Next</a>';
			}
			Result += '</p>\n';
			Result += '<div id="pagenofn"><p class="bodytext">Page <span id="pagen">1</span> of ' + resGroupCounter + '</p></div>';

			Result += "</div>";
			
			
		}

		DivResult = document.getElementById("s_anchor");
		if (Result && DivResult) {

			//myDivResult.append(Result);
			DivResult.innerHTML = Result;
			

		}
		window.status = "";
		
		

	}
	}())
}
