'use strict';
function search(SearchText, inHeading) {
(function () {
var Page = [];

/* Generated with Author-it 23.4.1.30004  12/19/2024 6:33:19 AM */
Page[0]=new Array("Title and Copyright Information","Copyright  1999,  2025, Oracle and/or its affiliates.","Primary Author: Oracle Corporation","Title and Copyright Information","46576.htm");
Page[1]=new Array("Primavera Virtual Desktop enables you to run P6 Professional over a secure network connection. ","Scope","This guide describes how to administer and use Primavera Virtual Desktop with P6 Professional.","Audience","P6 administrators and users working in Primavera Virtual Desktop should use this guide.","About This Guide","98314.htm");
Page[2]=new Array("This section contains information about how to access Primavera Virtual Desktop, how to export and import data, comparing schedules and printing in Primavera Virtual Desktop.","Using Primavera Virtual Desktop for Cloud","98328.htm");
Page[3]=new Array("Primavera Virtual Desktop enables you to run P6 Professional over a secure network connection.","Notes:","If the numeric lock status for your keyboard is not synchronized from your computer to Primavera Virtual Desktop, use the number keys at the top of your keyboard.","The selected database alias and file locations are not saved from the last time you logged into Primavera Virtual Desktop. Each time you log into Primavera Virtual Desktop, you will need to select the database alias and specify the locations to save files.","About Primavera Virtual Desktop","98332.htm");
Page[4]=new Array("You must do the following before using Primavera Virtual Desktop: ","Check the version of browser installed on your computer and upgrade if necessary. See Client System Requirements.","Add https://*.oraclecloud.com as a trusted site in your internet options. See Adding the Oracle Industry URL to Trusted Sites.","Install Adobe Acrobat Reader on your local computer. Adobe Acrobat Reader can be downloaded from https://get.adobe.com/reader.","Install the Secure Global Desktop (SGD) client. See Accessing P6 Professional with Primavera Virtual Desktop for Cloud","Optionally configure access to your local drives from Primavera Virtual Desktop. See Accessing Local Drives.","In addition, some further prerequisites for use of Primavera Virtual Desktop must be carried out by a P6 administrator and system administrator. For further information see: Administering Primavera Virtual Desktop for Cloud.","Prerequisites for Cloud","92804.htm");
Page[5]=new Array("To add the Oracle Industry URL to the trusted sites list:","Open the Windows Control Panel and select Internet Options.","In the Internet Options dialog box:","Select the Security tab.","Select Trusted sites.","Select the Sites button.","In the Trusted sites dialog box:","In the Add this website to the zone: field, type https://*.oraclecloud.com.","Select Add.","Select Close.","In the Internet Options dialog box, select OK.","Adding the Oracle Cloud URL to Trusted Sites","98317.htm");
Page[6]=new Array("Primavera Virtual Desktop automatically maps to all the local drives you have configured on your computer. This allows you to save documents to locations which you can access when you are not logged in to Primavera Virtual Desktop.","Accessing Local Drives","98319.htm");
Page[7]=new Array("The first time you access P6 Professional you must install the Oracle Secure Global Desktop client.","To install the Oracle Secure Global Desktop client:","Uninstall any existing versions of the Secure Global Desktop client from your system.","Browse to the Primavera Portal page.","Click the Primavera Virtual Desktop link.","Note: If you receive a prompt to launch the application, click Cancel.","On the Secure Global Desktop loading page, click the Client Options link.","On the Secure Global Desktop welcome page, click Install the Oracle Secure Global Desktop Client.","In the installation wizard:","Select the Install Only For Me option.","Note: You can select the Install For Everyone option if you have administrative privileges.","Accept the default options on all further installation screens.","When you are prompted to select the devices you wish to share, select Files, Clipboard, and Printers.","Log in to the Primavera Portal.","Click the Primavera Virtual Desktop link.","Select the option to launch the application with Oracle Secure Global Desktop Client.","Select Remember my choice for sgd links.","Click Open Link.","Note: Launching Primavera Virtual Desktop in HTML5 mode is not supported for cloud.","Tip","For information about Secure Global Desktop product and patch announcements, and up-to-date details on the latest recommended version, see the following knowledge management document:","Oracle Secure Global Desktop, Release Announcement Reference (Doc ID 2093579.2)","Ten minutes after closing the browser or logging out of Primavera Virtual Desktop, the P6 Professional session times out. If you log back in within ten minutes, the session remains active.","Prerequisites for Accessing P6 Professional with Primavera Virtual Desktop for Cloud","98352.htm");
Page[8]=new Array("Primavera Virtual Desktop enables you to access P6 Professional using your browser via the Primavera Portal. After you enter your username and password and P6 Professional has authenticated your credentials, a virtual desktop for P6 Professional launches.","Note: P6 Professional requires the Oracle Secure Global Desktop Client. See Prerequisites for Accessing P6 Professional with Primavera Virtual Desktop for Cloud","To access P6 Professional with Primavera Virtual Desktop:","Log in to the Primavera Portal.","Click Primavera Virtual Desktop for P6 Professional.","In the login dialog box:","Enter your username in the Login Name field.","Enter your password in the Password field.","Click OK.","Accessing P6 Professional with Primavera Virtual Desktop for Cloud","92803.htm");
Page[9]=new Array("You can resize the Primavera Virtual Desktop window. To resize the window, hold shift while dragging the corner of the window.","Dialog boxes which appear inside the Primavera Virtual Desktop window cannot be moved outside the window. To make dialog boxes larger, resize the entire Primavera Virtual Desktop window.","Resizing the Primavera Virtual Desktop Window","98351.htm");
Page[10]=new Array("When you attempt to export projects, roles, and resources with P6 Professional on Primavera Virtual Desktop, you must select a location on one of your network drives. ","To export project, roles, or resources: ","On the File menu, select Export. ","On the Export Format screen:","Select the Primavera PM - (XER) option.","Optionally select a version number from the list.","Click Next.","On the Export Type screen:","To export projects, select Project.","To export resources or roles, select either Resource Only or Role Only.","If you selected to export a project, on the Projects To Export screen, select the projects to export.","On the File Name screen:","Click @ Browse.","In the Save File dialog box:","Select a location on your local network.","Enter a file name.","Click Save.","Click Finish.","Exporting Project, Roles, and Resources for Cloud","92807.htm");
Page[11]=new Array("When you attempt to import projects, roles, and resources to P6 Professional on Primavera Virtual Desktop, you must select a file from a location on one of your local network drives.","To import projects, roles, or resources:","From the File menu, select Import.","In the Import dialog box:","On the Import Format screen, select the format of the file you want to import and click Next.","If you selected Primavera PM - (XER), on the Import Type screen select the type of data to import and click Next.","On the File Name or Files to Import screen:","Click @ Browse and select the file to import.","If you selected to import a Primavera P6 - (XML) file, choose whether to import all project level layouts.","If you selected to import a Microsoft Project file, click Select and select the files to import.","Click Next.","Continue through the wizard selecting options as necessary and click Next on each screen.","Click Finish.","Importing Projects, Roles, and Resources for Cloud","92808.htm");
Page[12]=new Array("When scheduling in P6 Professional, set the location for the log file to a folder on your local machine so that you can view the log when you are not logged into Primavera Virtual Desktop.","To set the location for the scheduling log file:","On the Tools menu, select Schedule.","In the Schedule dialog box:","Select Log to file.","Select Overwrite existing to overwrite the existing schedule log file with a new file.","Select Append to existing to add to the existing schedule log file.","Select @ Browse.","In the Specify Log File dialog box:","Navigate to the location on your local drive where you want to save the scheduling log files.","In the File name: field, enter a name for the file.","Select Open.","In the Schedule dialog box, select Schedule.","Configuring the Scheduling Log Location","98324.htm");
Page[13]=new Array("Schedule Comparison is used to compare the current version of a project against its baseline so that you can access a report that displays the differences between added, deleted, or changed information between projects.","When you use Schedule Comparison, you must designate a location to which your project comparison will be exported. You must export Schedule Comparison reports to your local network drive.","Using Schedule Comparison for Cloud","92810.htm");
Page[14]=new Array("Primavera Virtual Desktop offers several ways to print from P6 Professional:","Amyuni PDF Converter enables you to open a PDF of your schedule and print a hard copy.","Print to PDF enables you to create a PDF of your schedule in a location you specify. You must specify a destination for the file each time you print.","Notes:","Oracle recommends using the Print to PDF option unless you are printing a hard copy to your default printer.","If Amyuni PDF Converter is not enabled, submit a Service Request in My Oracle Support. The necessary configuration change applies to all users.","Printing Using Primavera Virtual Desktop for Cloud","92809.htm");
Page[15]=new Array("Note: At each step there might be a delay. The length of the delay depends on several factors, including the bandwidth of your connection, network latency, and the number of pages in the report. You must wait for each of these steps to be completed before continuing to work in Primavera Virtual Desktop.","To print from the file menu:","On the File menu, select Print.","In the Print Options dialog box:","In the Name list:","Select Print to PDF to print a copy of your P6 Professional screen to a PDF file in a location you specify.","Select Universal PDF Printer to print your P6 Professional screen using your default printer.","Optionally if you selected the Print to PDF option, select Properties.","In the Print To PDF Properties dialog box:","Select the File System option.","Optionally, select Options and configure any further output settings.","Click OK.","In the save dialog box:","If you see a Network icon, double click Network and then double click tsclient to list your local drives. Browse to your desired location and provide a file name for the PDF, then select OK.","If you do not see a Network icon, select the desired folder location from the list and provide a file name.","Note: To save files more efficiently, you can enter the full path and file name. The path must begin with &quot;\\\\tsclient\\D (rw)\\&quot; and the file name must include the extension &quot;.pdf&quot; at the end.<br />For example:<br />\\\\tsclient\\D (rw)\\myfiles\\myprint.pdf","In the Report Printed dialog box, select OK.","Printing From The File Menu","98331.htm");
Page[16]=new Array("Note: At each step there might be a delay. The length of the delay depends on several factors, including the bandwidth of your connection, network latency, and the number of pages in the report. You must wait for each of these steps to be completed before continuing to work in Primavera Virtual Desktop.","To print from Page Setup or Print Preview in P6 Professional:","From the File menu, select Print Setup.","In the Print Setup dialog box:","On the Name list, select Print to PDF.","In the Size section, select the paper size you want to use for the PDF file.","Optionally select Properties to configure final PDF output settings.","Click OK.","From the File menu, select Page Setup or Print Preview and select the option to print using Print to PDF.","Printing From Page Setup or Print Preview","98315.htm");
Page[17]=new Array("To view the print queue for Primavera Virtual Desktop:","Browse to the Primavera Portal page.","Click the Primavera Virtual Desktop link.","In the Navigation pane, select the List All Jobs button.","Viewing the Primavera Virtual Desktop Print Queue","98316.htm");
Page[18]=new Array("When you use the Print to PDF option, by default any existing file will be overwritten with the new file.","To change the default overwrite setting:","From the File menu, select Print Setup.","In the Print Setup dialog box:","On the Name list, select Print to PDF.","Click Properties.","Select Destination&gt;.","In the Print to PDF Properties screen, select File system and click Options.","Click Overwrite without asking and select a different action from the list.","Click OK.","Changing The Default Overwrite Setting For Print To PDF","98323.htm");
Page[19]=new Array("Secure Global Desktop Is Blocked By Virus Scanning Software","If the virus protection software installed on your computer incorrectly identifies components of Cloud Services as suspicious, contact your IT team.","Network Level Authentication Failure","If you receive an message about network level authentication having failed, see: Secure Global Desktop Error &quot;Session Failed: Network Level Authentication Failed&quot; When Attempting to Launch P6 Professional via Primavera Virtual Desktop (Doc ID 2200935.1) at https://support.oracle.com/epmos/faces/DocumentDisplay?id=2200935.1","P6 Professional Does Not Allow You to Select a File Destination","When you are printing in Primavera Virtual Desktop, if you receive a message that a report has been printed, but you are not able to select a destination for the report output:","In the Print dialog box, select Properties.","In the Print to PDF Properties dialog box, select a file location for the report.","Network Connectivity Loss","If Primavera Virtual Desktop crashes because of a loss of network connectivity, ensure that you have a reliable internet connection with your provider before logging back into Primavera Virtual Desktop.","Local Drives Are Not Available","If the local drives configured for your computer are not available inside Primavera Virtual Desktop, log out of P6 Professional and then log out of Primavera Virtual Desktop. Log in to Primavera Virtual Desktop.","Troubleshooting","98325.htm");
Page[20]=new Array("This section contains information about configuring P6 Professional users and Windows users for using Primavera Virtual Desktop.","Administering Primavera Virtual Desktop for Cloud","98327.htm");
Page[21]=new Array("Before users can log into P6 Professional using Primavera Virtual Desktop, you must:","Assign users P6 Professional module access rights and project privilege rights in P6.","Assign users the Primavera Virtual Desktop role in Primavera Administration. See the Primavera Administration Identity Management Guide for details.","Note: After you assign the role assignment, users must wait approximately 10 minutes for the assignment to take effect.","Ensure that all usernames in Primavera Administration meet the following requirements.","User names must be unique on the computer that is being administered. User names must not be the same as any group names on the computer that is being administered.","The user name can be up to 20 alphanumeric characters and symbols and is not case sensitive.","The user name cannot contain the following characters: &quot; / \\ [ ] : ; | = , + * ? &lt; &gt; @ ","The user name cannot consist solely of periods (.) or spaces.","Note: Password can contain up to 127 characters.","Administration Prerequisites","98321.htm");
var PageCount=22;


/*
Date: 12/19/2024 6:33 AM
Source: EPPM_25_dev
BookID: 98313
PubProduct: PRIMAVERA_EPPM
BookTitle: Virtual Desktop User Guide
Version: Version 25
Lang:	en
*/
	var PageLength=Page.length;
	var Result = "";
	var ResultTemp = "";
	var ResultFound = "";
	var ResultTitleOnly = [];
	var ResultTitleAndContent = [];
	var ResultInContent = [];
	var ResultInContentTemp = [];

	var ResultCombinedTemp = [];
	var ResultCombined = [];

	var arrayIndex = 0;
	var NrRes = 0;
	var j = 0;
	var i = 0;
	var k = 0;
	var d = 0;
	var maxItems = 1000;
	var heading = 0;
	var WordPos = -1;
	var WordPosHeading = -1;
	var WordPosContentText = -1;
	var FoundWord = "";
	var FoundWordHead = "";
	var SearchInHeadingOnly = 0;
	var isChecked;
	var size = 10;
	var resGroupCounter = 0;
	var shown = "shown";
	var checkBoxInHeading;
	var searchFlag = 0;
	var DivResult;
	var SearchWord;

if (SearchText && SearchText.length >= 1) {
		SearchWord = SearchText.replace(/\+/g, " ").replace(/&/g, "&amp;").replace(/</g, "&lt;").replace(/>/g, "&gt;").replace(/"/g, "&quot;");
		searchFlag = 1;
	} else {
		SearchWord = "";
		searchFlag = 0;
	}
	

	if (searchFlag === 1) {
		Result = "";

		// checkBoxInHeading = document.getElementById("inHeading");
		if (inHeading) {

			isChecked = true;
		} else {

			isChecked = false;
		}

		if (SearchWord && SearchWord.length >= 1) {
			if (isChecked) {
				SearchInHeadingOnly = 1;
			} else {
				SearchInHeadingOnly = 0;
			}
			SearchWord = SearchWord.toLowerCase();
			window.status = "Searching, please wait...";
			for (j = 0; j < PageLength; j++) {
				k = Page[j].length - 1;
				for (i = 0; i < k; i++) {

					heading = k - 1;

					if (SearchInHeadingOnly === 1) {
						WordPosHeading = Page[j][heading].toLowerCase().indexOf(SearchWord);
						if (WordPosHeading > -1) {
							FoundWordHead = Page[j][heading].substr(WordPosHeading, SearchWord.length);

							NrRes++;
							ResultTemp = "<li>";
							ResultTemp += "<span>";
							ResultTemp += "<a href='" + Page[j][k] + "'>" + Page[j][heading].replace(FoundWordHead, FoundWordHead.bold()) + "</a><br/>\n";

							ResultTemp += "</span>";
							ResultTemp += "</li>";

							ResultTitleOnly[arrayIndex] = ResultTemp;
							arrayIndex++;

							ResultTemp = "";
							WordPosHeading = -1;
							WordPosContentText = -1;
							break;
						}
					} else if (SearchInHeadingOnly === 0) {
						WordPos = Page[j][i].toLowerCase().indexOf(SearchWord);
						WordPosHeading = Page[j][heading].toLowerCase().indexOf(SearchWord);
						if (WordPos > -1) {
							FoundWordHead = Page[j][heading].substr(WordPosHeading, SearchWord.length);
							FoundWord = Page[j][i].substr(WordPos, SearchWord.length);
							FoundWord = Page[j][i].substr(WordPos, SearchWord.length);
							NrRes++;
							ResultTemp += "<li>";
							ResultTemp += "<span>";
							if (WordPosHeading > -1) {
								ResultTemp += "<a href='" + Page[j][k] + "'>" + Page[j][heading].replace(FoundWordHead, FoundWordHead.bold()) + "</a><br/>\n";
							} else {
								// found word is not in the head
								ResultTemp += "<a href='" + Page[j][k] + "'>" + Page[j][heading] + "</a><br/>\n";

							}
							if (i < k - 1) {
								WordPosContentText = Page[j][i].toLowerCase().indexOf(SearchWord);

								if (Page[j][i].length > 300 && (WordPosContentText > -1)) {

									if (WordPosContentText > 75) {
										ResultInContentTemp.push("..." + Page[j][i].substr(WordPosContentText - 75, 175 + FoundWord.length).replace(FoundWord, FoundWord.bold()) + "...");
									} else {
										ResultInContentTemp.push("..." + Page[j][i].substr(0, 175 + FoundWord.length).replace(FoundWord, FoundWord.bold()) + "...");

									}

								} else if (WordPosContentText > -1) {

									ResultInContentTemp.push(Page[j][i].replace(FoundWord, FoundWord.bold()));

								}
							}

							ResultTemp += ResultInContentTemp.join("");

							ResultTemp += "</span>";
							ResultTemp += "</li>";

							if (WordPosHeading > -1) {
								ResultTitleAndContent[arrayIndex] = ResultTemp;
								arrayIndex++;
							} else {
								ResultInContent[arrayIndex] = ResultTemp;
								arrayIndex++;
							}

							ResultInContentTemp.length = 0;
							ResultTemp = "";
							WordPosHeading = -1;
							WordPosContentText = -1;
							break;
						}

					}
				}
			}

			ResultTitleOnly = ResultTitleOnly.filter(function (n) {
				return (n !== undefined && n !== null);
			});
			ResultTitleAndContent = ResultTitleAndContent.filter(function (n) {
				return (n !== undefined && n !== null);
			});
			ResultInContent = ResultInContent.filter(function (n) {
				return (n !== undefined && n !== null);
			});

			ResultCombinedTemp = ResultTitleOnly.concat(ResultTitleAndContent, ResultInContent);

			ResultCombinedTemp = ResultCombinedTemp.filter(function (n) {
				return (n !== undefined && n !== null);
			});

			for (d = 0; d < ResultCombinedTemp.length; d += size) {
				resGroupCounter++
				ResultCombined.push("<div id=" + "'" + "resGroup_" + resGroupCounter + "'" + " class=" + "'" + "resGroup " + shown + "'" + ">" + "<ol class='searchResults'>" + ResultCombinedTemp.slice(d, d + size).join("") + "</ol></div>");
				shown = "notshown";
			}

			ResultFound = ResultCombined.join("");

Result += "<div id='searchDetailsDiv'>";
			Result += "<p class='searchDetails'>Your Search Found&nbsp;" + NrRes + "&nbsp;items.&nbsp;";
			Result += "</p></div>";
			
			Result += "<div class='searchResultsDiv'>";
			Result += "<div id='resultsCollection' class='searchResults'>";
			Result += ResultFound;
			Result += "</div>";
			Result += "</div>";
			Result += "<div class='searchPaging'>";

			Result += '<hr />';

			Result += '<p class="bodytext"><a class="disabledAnchor" id="pBack" onclick="turnPage(\'backPage\')" href="#pBack">Back</a>&nbsp; | &nbsp;';
			
			if (resGroupCounter && resGroupCounter > 1) {
				Result += '<a id="pNext" onclick="turnPage(\'nextPage\')" href="#pNext">Next</a>';
			} else {
				Result += '<a id="pNext"  class="disabledAnchor" href="#pNext">Next</a>';
			}
			Result += '</p>\n';
			Result += '<div id="pagenofn"><p class="bodytext">Page <span id="pagen">1</span> of ' + resGroupCounter + '</p></div>';

			Result += "</div>";
			
			
		}

		DivResult = document.getElementById("s_anchor");
		if (Result && DivResult) {

			//myDivResult.append(Result);
			DivResult.innerHTML = Result;
			

		}
		window.status = "";
		
		

	}
	}())
}
