'use strict';
function search(SearchText, inHeading) {
(function () {
var Page = [];

/* Generated with Author-it 23.4.1.30004  4/8/2025 6:22:37 PM */
Page[0]=new Array("Title and Copyright Information","Copyright  1998, 2025, Oracle and/or its affiliates.","Primary Author: Oracle Corporation","Title and Copyright Information","46576.htm");
Page[1]=new Array("Within the documentation, some content might be specific for cloud deployments while other content is relevant for on-premises deployments. Any content that applies to only one of these deployments is labeled accordingly.","This document explains how to set up the modules that are used in the Admin or User mode of operation.","Access to system functionality is granted through permissions. The ability to utilize a specific function depends on permissions settings (accessed in Admin mode).","The application has two modes of operation:","Admin (Administration) mode: Company administrators work inAdminmode to set up, for example, company and project/shell properties, user permissions, templates for major features, and data structures. Administrators also configure and set up business process (BP) workflows.","User mode: Users spend most of their time in User mode. User mode allows users to perform day-to-day activities, collaborate through business processes and Mailbox, maintain, for example, the Cost Manager, Activity Manager, and Document Manager, and run reports.","The Unifier General User Guide explains how to use the options that are available in User mode.","You can switch between modes using the mode icons (User mode  @  and Admin mode @).","Note: This option is not available in the Home workspace because it does not support Admin mode.","Getting Started with Modules Setup Administration Guide","10293850.htm");
Page[2]=new Array("Data views use SQL queries that are defined against system tables and business process (BP)tables. Data views are used in custom reports, user-defined reports (UDRs), and shell dashboards.","Notes:","You can create UDRs at company and project/shell levels.","Avoid using double quotation marks for column aliases in SQL queries. Using double quotation marks can cause errors in running UDRs and dashboards if they use a data view that has column aliases.","Data views must contain project_id in the SQL query for the data view to be displayed in a project/shell-level UDR&nbsp;data type list.","Note: Data views published prior to the Primavera Unifier 9.5 release must be republished (that is, set to draft status and then reset to published status) before they show up in the UDR data type list.","The system includes an Explain Plan option that you can use to evaluate your data views. Running the Explain Plan provides important feedback that can help you modify the SQL query to reduce or eliminate performance issues.","Before you begin: Define your reporting requirements first. Collaboration between business users and technical development teams helps identify the data you must collect and how to present that data so report recipients will have an easy-to-read, useful report.","Step 1: Set permissions for data view creation. See Grant Permissions for Data View Creation.","Step 2: Create data views. See Create and Publish Data Views and Metadata.","Data views must be published (as indicated by the Publish Date) before you can use them as data sources in UDRs, data cubes, or custom reports.","Test your data view SQL queries in the Development/Test environment before deploying them in the Production environment because only by testing can you be sure the query is valid and returns the desired data. Oracle recommends that you test your SQL queries in the Development environment prior to deploying them in the Test environment or Production environment.","Use the Explain Plan feature to evaluate the SQL performance and potential issues of data views that you design.","Note: For translation information, see the Unifier General Administration Guide.","Step 3: View data and metadata. See View Data (Query Results) and Metadata (Columns) in the View.","Step 4: Export data. See Export Data (Query Results).","The data views are included in:","Custom Reports that are using data views and are ready for the Production environment.","Data Cubes that are using data views and are ready for the Production environment.","UDRs that are using data views and are ready for the Production environment.","Creating Data Views","10298028.htm");
Page[3]=new Array("To grant permission for data view creation:","Go to the Company Workspace tab and switch to Admin mode.","In the left Navigator, select User Administration, and then select Access Control.","On the right pane, expand Administration Mode Access, expand Data Structure Setup, and then select Data Views.","The Module Permission Settings window opens. Here you can add, modify, or remove permission settings.","Click the Add button.","In the Permissions Setting for Data Views window, click the Add Users/Groups button.","In the Users/Groups window, select the intended users or groups and click the Add button.","To return to the Permissions Settings for Data Views window, click OK.","In the Select Users/Group section of the window, select the users or groups, and then select the applicable level of access for the user or group in the Permissions Settings section.","View: Allows users and groups to see the data view settings.","Create/Modify: Allows users and groups to define or change data view settings. This setting includes View permission.","Click the OK button.","Click Apply to save changes and keep the window open, or click OK to save changes and close the window.","Grant Permissions for Data View Creation","74188.htm");
Page[4]=new Array("After you create a data view, you must publish it to be able to use it in user-defined reports, data cubes, or custom reports.","Note: If you intend to use data views in user-defined reports, be aware that the data views must contain project_id in the SQL query for the data view to show up in a project/shell-level UDR&nbsp;data type list.","Depending on the data elements you choose, you might need to publish the metadata associated with the data view. For example, if the selected data element has a data definition type of pull-down Menu, you will have to publish the metadata to see the actual label of the pull-down rather than the value. In the case where a data element is defined as Actual Value? based on a Yes/No data element, with 0= No and 1=Yes, if Actual Value? is used in the data view, you must publish the metadata of Actual Value? to get the Yes or No value rather than 0 or 1.","To create data views:","Go to the Company Workspace tab and switch to Admin mode.","In the left Navigator, select Data Structure Setup, and then select Data Views.","The User-Defined Data Views log opens.","From the toolbar, click New.","In the Create a Data View window that opens, the Prefix is auto-populated with Unifier_.","Enter the name of the data view, the label, an optional description, and the SQL query for the data view.","For more information on how to create SQL queries used in the creation and management of data views, consult the Oracle Consulting Services team.","Click OK.","Notes:","When creating data views, the column naming convention must follow the Oracle DB guidelines. Do not use the Oracle-reserved words such as &quot;(&quot;, &quot;)&quot; and so forth to name the column. For details, refer to Oracle DB guidelines.","Avoid using double quotation marks for column aliases in SQL queries. Using double quotation marks can cause errors in running UDRs and dashboards if they use a data view that has column aliases.","To check the data view for potential issues:","Go to the Company Workspace tab and switch to Admin mode.","In the left Navigator, select Data Structure Setup, and then select Data Views.","The User-Defined Data Views log opens.","Select the applicable data view.","From the toolbar, click Explain Plan, and select Run Explain Plan.","Review the output.","If an entry in the Operation column is highlighted in yellow, hover over the highlighted entry to view additional information.","When you are done reviewing suggestions, click Close.","After you run an Explain Plan, the system displays an icon in the Performance Alert column of the User-Defined Data Views log if potential issues were identified.","To publish data views:","Go to the Company Workspace tab and switch to Admin mode.","In the left Navigator, select Data Structure Setup, and then select Data Views.","The User-Defined Data Views log opens.","Select an unpublished data view.","From the toolbar, click Status, and select Published.","Click OK.","To publish metadata:","You can associate metadata with its data set for both labels and values. Data views tend to contain technical shorthand from system and SQL abbreviations. While clear to the technical person who wrote the data view, report consumers will appreciate seeing the same field labels and field value selections that they see in their business processes and managers.","For example, in your data view you might include the data element &quot;year_pd,&quot; which represents a pull down menu with selections for different years assigned to its data set. In your user-defined report, you might want to see the label &quot;Year&quot; instead of &quot;year_pd&quot;; and you might want to query on meaningful values, such as 1999, 2001, 2002, and so on, instead of the numeric values of the data definition, 1,2,3, and so on.","Go to the Company Workspace tab and switch to Admin mode.","In the left Navigator, select Data Structure Setup, and then select Data Views.","The User-Defined Data Views log opens.","Select a published data view.","From the toolbar, click Metadata.","In the Metadata for &lt;data view&gt; window, double-click the Definition field for each data element and select the data definition for the selected element.","The data definitions available for selection are filtered by the data elements used.","Double-click the Label field for each element you want to use in the UDR, and rename it to whatever you want to see in the report.","Click Publish Metadata.","Notes:","The SQL definition will consist of the SQL query used to populate the report with specific data based on the desired output.","If using the data view as a Main view in a Project-level report, you must have a column named project_id. If using the data view in a Program-level report, you must have a column named program_id.","For example, a Project-level data view for a company registry might be:","SELECT   pu.PID as PROJECT_ID,","         p.PROJECTNUMBER as PROJECTNUMBER,","         c.COMPANYNAME as COMPANY_NAME,","         c.SHORTNAME as COMPANY_SHORT_NAME,","         c.DESCRIPTION as COMPANY_DESCRIPTION,","         c.CONTACTNAME as COMPANY_CONTACT_NAME,","         u.FULLNAME as USER_FULL_NAME,","         u.USERID as USER_ID,","         u.USERNAME as USER_NAME,","         u.EMAIL as USER_EMAIL","FROM     SYS_USER_INFO_VIEW u,","         SYS_COMPANY_INFO c,","         SYS_PROJECT_INFO p,","         SYS_PROJECTUSER pu","WHERE    c.COMPANYID = p.COMPANYID","  AND    p.PID = pu.PID","  AND    u.userid = pu.userid","Create and Publish Data Views and Metadata","74189.htm");
Page[5]=new Array("The Data button will return the query results of the view (essentially, a preview of the report results, without any user entered parameters).","The Metadata button will return all the columns in the view. The Metadata button will return the definition of the columns: names, type and labels of the columns used in the view. For example:","To view query results:","Go to the Company Workspace tab and switch to Admin mode.","In the left Navigator, select Data Structure Setup, and then select Data Views.","The User-Defined Data Views log opens.","Select a view.","From the toolbar, click Data.","The results window will display the query results.","To view columns:","Go to the Company Workspace tab and switch to Admin mode.","In the left Navigator, select Data Structure Setup, and then select Data Views.","The User-Defined Data Views log opens.","Select a view.","From the toolbar, click Metadata.","The results window will return all the columns in the view.","If the Data View is in Draft status, the metadata that you see will be based on the last Published data. If the Data View has not been published before, no data is displayed.","You can delete a Data View that was included in the configuration package, indirectly.","Note: Although deletion of a Data View is possible, if a Data View has been used in a UDR, custom Oracle Analytics Server report, or Data Cube that was included in a configuration package, the configuration package creation will fail because of the missing data views.","View Data (Query Results) and Metadata (Columns) in the View","74190.htm");
Page[6]=new Array("The results of the data query can be exported as CSV or SQL files.","To export data as CSV:","Go to the Company Workspace tab and switch to Admin mode.","In the left Navigator, select Data Structure Setup, and then select Data Views.","The User-Defined Data Views log opens.","Select a view.","From the toolbar, click Data.","In the results window, click the Export As CSV button.","Depending on your browser, the file will either download automatically or you will be prompted to download it. ","The CSV file will contain the data that is displayed on the results log. By default, the first 100 lines will be displayed. You can click the Display drop-down (in the upper-right corner of the results log) and choose 200 to display the first 200 lines. When you click Export As CSV, the CSV file will contain the 100 (or 200) lines displayed in the window.","To export data as SQL:","Go to the Company Workspace tab and switch to Admin mode.","In the left Navigator, select Data Structure Setup, and then select Data Views.","The User-Defined Data Views log opens.","Select a view.","From the toolbar, click Data.","In the results window, click the Export As SQL button.","Depending on your browser, the file will be downloaded automatically, or you will be prompted to download the file manually. ","This will export your SQL script to create the table required for the data view and the data itself.","Notes on working with the Oracle Database:","Only the 100 or 200 rows will be exported at a time. You cannot export the entire result of the view (for example, if there are more than 200 rows) in one click. You must export in groups of 200 rows at the maximum and then manually combine the exported results.","SQL export files have the .sql extension and work best with the Oracle database as the field types used in the creation of the data view are of Oracle type (for example, VARCHAR). If the exported SQL file is to be used in a database other than Oracle, you must manually modify that file to replace the field types with the types that work with the non-Oracle database.","Unifier uses a field type called TIMESTAMP for all date or time fields, so you must modify the session date format to match the timestamp used in Unifier. For example, you can run the following statement for an Oracle database: ALTER SESSION SET NLS_DATE_FORMAT = 'YYYY-MM-DD HH24:MI:SS';","If you are building multiple data views based on other data views, any changes to a data view (for example, adding a new data element) in the lower hierarchy require that the dependent views to be changed to Draft, in order to refresh, and the data views must be republished, to incorporate the changes. For example, if Dataview 2 is based on Dataview 1, and you add a new field to Dataview 1 and then republish it. You must then change Dataview 2 to Draft and then republish it so that it will contain the change you made in Dataview 1.","Additional cleaning of the data (in case of export to SQL file) might be needed if there are (&#8216;) apostrophes in the values of some fields, or if there are ampersands (&amp;). This will result in inconsistent values between the results in Unifier and the result in the local database after import.","Export Data (Query Results)","74191.htm");
Page[7]=new Array("To view reports and data cubes in which a Data View is used:","Go to the Company Workspace tab and switch to Admin mode.","In the left Navigator, select Data Structure Setup, and then select Data Views.","The User-Defined Data Views log opens.","Select a view.","From the toolbar, click Usage.","The Usage window opens, listing the reports and data cubes in which the data view is used.","View Data View Usage in Reports and Data Cubes","74192.htm");
Page[8]=new Array("Data views must be in draft mode to edit.","To edit data views:","Go to the Company Workspace tab and switch to Admin mode.","In the left Navigator, select Data Structure Setup, and then select Data Views.","The User-Defined Data Views log opens.","Select a view.","From the toolbar, click Status, and select Draft.","Click the Open button to access the SQL statement.","Edit the SQL statement and click Apply or OK to save changes.","Select the data view again, click Status and select Publish to make the data view available for use in user defined reports, data cubes, and custom reports.","Edit Data Views","74193.htm");
Page[9]=new Array("To delete Data Views:","Go to the Company Workspace tab and switch to Admin mode.","In the left Navigator, select Data Structure Setup, and then select Data Views.","The User-Defined Data Views log opens.","Select a view.","From the toolbar, click Delete.","You will receive a confirmation message that you want to delete the selected Data View.","Notes:","You cannot delete Published Data Views. You must change the Status to Draft to be able to delete a Data View.","Although deletion of a data view in Draft status is possible, if a Data View has been used in a UDR, custom Oracle Analytics Server report, or Data Cube that was included in a configuration package, the configuration package creation will fail because of the missing data views.","Delete Data Views","74203.htm");
Page[10]=new Array("Before building your SQL statement, review the database table structure.","You can find the database table name in two ways:","Using Entity Reference (ER) Views","Sign in as a Company Administrator.","Go to the Company Workspace tab and switch to Admin mode.","In the left Navigator, select Data Structure Setup, and then select ER Views.","Open Business Processes View.","Use your browser search function and search for a BP you want to report against (for example, Invoices).","The name of the table appears under the BP Name, in blue (for example, UNIFIER_UI. The word &quot;unifier&quot; is the prefix and common to all BP tables. The UI is the ID of the Invoices BP).","Using BP IDs","Sign in as a Company Administrator.","Go to the Company Workspace tab and switch to Admin mode.","In the left Navigator, select uDesigner, and then select Business Processes.","Locate the BPs that you want to use in the report and find the IDs (first column).","Add your deployment prefix and add an underscore ( _ ) to get the table name (for example, UNIFIER_UI).","Note: To access the Line Items of a BP, add _LINEITEM to the table name (for example, UNIFIER_UI_LINEITEM).","The following lists the column names:","Field Name","Definition","SQL Type","Label","Description","Review Database Table Structure","10293209.htm");
Page[11]=new Array("Data cubes comprise data that you can use to render a variety of charts (bar, area, column, line, and table) in a custom data block of a shell dashboard. In this way you can visually compare aspects of your data set.","Data cubes are either company level or shell level. The data source for data cubes can be from a business process or a manager attribute form, or from a data base query. The system does not limit the number of data cubes you can create.","To learn how to create a data cube, see the following:","Granting Permissions for Data Cube to create a data cube","Defining a Data Cube a new data cube, which includes:","Selecting the data source for the data cube","Completing the data cube properties","Publishing the data cube","Granting Permissions for Data Cube so they can view the data cube composition in Data Cube Definitions","Creating Data Cubes","74196.htm");
Page[12]=new Array("To define a data cube:","Go to the Company Workspace tab and switch to Admin mode.","In the left Navigator, select Data Structure Setup, and then select Data Cube Definitions. The Data Cubes log opens.","Click New, and then select Shell Data Cube or Company Data Cube. The Create Data Cube window opens.","Select Data Type or Data View.","A data type comprises business process and manager attribute forms","A data view comprises results from a data base query","Note: When creating data cubes, data views are only seen when you select Data View as the source. This is different from UDR creation when data views are listed with data types.","Select a business process from the drop-down menu.","Click OK. The Data Cube window opens.","Complete the General tab.","Name: enter a unique name for the data cube","Description: this field is optional","Data Type: this read-only field is automatically completed with the data type selection","Type: this read-only field is automatically completed with the level selection","Click the Data Source tab. On this tab you can add the data sources you want to include in the data cube, for example, a business process, query-based tab, workflow, or shell.","Click the Add button. The Data Sources window opens listing all available data sources for this data cube.","Select at least one data source. You cannot move to the next tab or save the data cube without a data source selection. You can add as many data sources as are available.","Click the Data Elements tab.","Select at least one data element. You cannot save the data cube without a data element selection. You can add as many data elements as are available.","The selected data elements are arranged in the Data Elements pane in a grid.","Data Source: The data element data source.","Label: The data element label. You can modify this label.","Name: The data element name.","Type: The data element type.","Group: Click to define whether the data element can be used as a Grouping element when the data cube is used.","Summary: Click to define whether the data element can be used as a Summary type.","On this pane you have the option to add functions. To do so, click Add Functions. Select a function type: Formula, Date Difference, Date Add, Date Function.","For Formula click Create. Create a formula and click OK. The data source available for the formula are based on the data sources you selected in the Data Sources tab.","For Date Difference enter a column heading name, specify the dates, and whether to show partial days. Click OK.","For Date Add enter a column heading name, specify the date and the add function. Click OK.","For Date Function enter a column heading name and specify the date. Click OK.","To modify a data element, select the data element and click the Modify button.","To remove a data element, select the data element and click the Remove button.","Use the Move Up or Move Down buttons to reorder the listed data elements.","Click the Query tab if you want to add one or more queries to the data cube. See Define Report Queries (Query Condition).","Data Cubes and Configuration Package","Data Cubes are used for creating Shell dashboards. Data Cubes defined in the Development/Test environment can be transferred to the Production environment.","You can pick and choose which Data Cubes to transfer by including the needed Data Cubes in the Component List and creating a Configuration Package by using the list. ","The Data Cubes log contains the following columns:","Name","Description","Type","Source","Last Modified","Published Date","Last Published By","When the configuration package is created, the system will check to ensure that the Data Cubes that have been included are in Publish status or not. If the Data Cubes that have been included are not in Publish status, an error message is displayed at the time of creating the configuration package.","Defining a Data Cube","10298029.htm");
Page[13]=new Array("To define queries for data cubes:","Click the Queries tab.","Build a query. See Define Report Queries (Query Condition) for details on creating queries.","When you have finished working with the Data Cube window tabs, click OK.","Defining Queries","74200.htm");
Page[14]=new Array("To grant permission for data cube creation, modification, or viewing:","Go to the Company Workspace tab and switch to Admin mode.","In the left Navigator, select User Administration, and select Access Control.","In the right pane, expand Administration Mode Access, expand Data Structure Setup, and select Data Cube Definitions.","In the Module Permission Settings window, click Add. ","In the Permission/Access Control window, click Add Users/Groups. ","In the upper section of the Users/Groups Picker window, select the intended users or groups and click Add.","Click OK&nbsp;to return to the Permission Settings window.","To assign permissions to user or groups in the Permission Settings window: ","In the upper section, users or groups selected in the previous steps display.","In the lower section, select the appropriate level of access for the users or groups selected in the upper section.","Create/Modify: You must have Create/View permission to create or define or change data cubes. This setting includes View permission.","View: You can use this setting to allow users and groups to see the data cubes.","Click OK.","Perform any of the following actions: ","Click Apply to save changes and keep the window open. ","Click OK to save changes and close the window.","Granting Permissions for Data Cube","74201.htm");
Page[15]=new Array("You must publish data cubes to make them available for use in the configurable dashboard.","To publish data cubes:","Go to the Company Workspace tab and switch to Admin mode.","In the left Navigator, select Data Structure Setup, and then select Data Cube Definitions. The Data Cubes log opens.","Select a data cube and click the Publish button.","Note: You can modify a published data cube, but you must republish it to make the changes available to users.","Publishing Data Cube","74202.htm");
Page[16]=new Array("Creating partitions for large business process (BP) tables, such as those whose number of rows exceeds 500 thousand, improves query performance. As explained in the Oracle database documentation, partitioning a database creates smaller, more manageable pieces, while not impacting the structured query language (SQL) queries. Because a large data set might cause performance issues when the system is loading BP logs, sheets, grids, pickers, and so on, you can use the Table Partitions option under Data Structure Setup to create a partition for specific BP tables that have large data sets, such as those that contain in excess of 500 thousand records.","Notes:","Partitioning is irreversible and might affect system performance while it is in process; Oracle recommends that you run partitioning during off-peak hours for your organization.","At this time, only the tables for Simple and Line Item BPs defined at the project/shell level are available for partitioning; single-record BPs and company-level BPs are excluded.","The performance improvement achieved by implementing this feature depends on your environment and how Unifier is implemented. In particular, the design of BPs and their components affects the performance of subsequent searches.","Step 1: Verify that your database meets prerequisites. To use this feature, make sure that your Oracle database meets the following prerequisites. It must:","Use Oracle Database Enterprise Edition.","Have partitioning enabled. By default, partitioning is enabled for Oracle Cloud-based Unifier environments. For more information about partitioning an Oracle database, go to the Oracle Database Documentation site, search for partitioning, and select your database version.","Step 2: Set permissions for creating, updating, and viewing table partitions. For more information, see Granting Permissions for Table Partitions.","Step 3: Create or update partitions. For more information, see Creating or Updating Table Partitions.","Step 4: Monitor partition status and history. For more information, see Monitoring Table Partitions.","Creating Partitions for BP Tables","10313001.htm");
Page[17]=new Array("You can grant view-only or create and modify permissions to groups or users of both your company (the owner/sponsor company) and to those of partner (member) companies.","Note: In addition to the following process, you can also update permissions through the Permissions tab for individual users in Company Users and Partner Users.","To grant permission for viewing, creating, or updating table partitions:","Go to the Company Workspace tab and switch to Admin mode.","In the left Navigator, select User Administration, and then select Access Control.","On the right pane, expand Administration Mode Access, expand Data Structure Setup, and then select Table Partitions.","The Module Permission Settings window opens. Here you can add, modify, or remove permission settings.","In the Module Permission Settings window, click the Add button.","In the Permissions Setting for Table Partitions dialog box, click the Add Users/Groups button.","In the Users/Groups window, select the intended users or groups and click the Add button.","To return to the Permissions Settings for Table Partitions dialog box, click OK.","In the Select Users/Group section of the window, select the users or groups, and then select the applicable level of access for the user or group in the Permissions Settings section.","Create/Modify: Lets the selected users and groups create or update table partitions. This setting includes the View permission.","View: Lets the selected users and groups view the Table Partitions log.","To save your selections and return to the Module Permission Settings window, click OK.","Click Apply to save changes and keep the window open, or click OK to save changes and close the window.","Granting Permissions for Table Partitions","10315483.htm");
Page[18]=new Array("When you access the Table Partitions page, it might display a log that lists tables that contain more than 500 thousand rows, or it might display one of the following messages:","No tables available. This message indicates that partitioning is enabled; however, there are no tables that currently exceed 500 thousand rows.","Permissions to create table partitions. If this message is displayed, particularly if you are using an on-premises environment, it indicates that you do not currently have the applicable user permission in the Oracle database schema for Unifier to create partitions. You must have the select permission for the v$option and gv$sql_monitor tables. For more information, contact your systems or database administrator.","Table partitioning is not enabled. If this message is displayed, particularly if you are using an on-premises environment, it indicates that partitioning is not enabled for your Oracle database. For more information, contact your systems or database administrator.","If there are tables that contain more than 500 thousand rows, the log lists information for each applicable table such as the name of the BP, an indication of whether the table is for a BP or a line item, a status that indicates whether the table has been partitioned, and so on.","When you create a partition, the system evaluates the selected table and provides suggestions based on the following:","Number of Rows in the Selected Table","Recommended Number Partitions","Maximum Number of Partitions","&gt;=500K and &lt;1M","4","8","&gt;=1M and &lt; 5M","8","16","&gt;=5M and &lt;10M","16","32","&gt;=10M and &lt;50M","32","64","&gt;=50M and 1B","64","128","&gt;=1B and 5B","128","256","&gt;=5B","256","256","After you have partitioned a specific table, you have the option at a later time of redistributing the data across the recommended number of partitions or selecting a higher number of partitions. This is known as repartitioning.","To create a table partition:","Go to the Company Workspace tab and switch to Admin mode.","In the left Navigator, select Data Structure Setup, and then select Table Partitions.","In the Table Partitions log, review the list of tables carefully before continuing.","As explained earlier, only the tables for Simple and Line Item BPs defined at the project/shell level are currently available for partitioning, partitioning cannot be reversed, and performance improvement is dependent on how your BPs are designed.","Select the table that you want to partition, and click Create Partitions.","In the Choose number of partitions dialog box, click Continue to accept the recommended number.","The system checks the unique ID numbers for the table and evaluates the information based on the table provided earlier. It then selects the number of partitions based on what is smaller; for example, if the number recommended for the row count is 16, but the number of unique ID numbers is 9, the recommended partition number is 8. You can choose a different option from the list instead of accepting the recommended selection.","When the Create partitions confirmation message appears, review the statements.","If you are ready to continue, click Create; otherwise, click Cancel.","If a selected table is currently in use for another reason, such as a configuration package or BP package is being deployed, the system displays a message that indicates partitioning cannot be completed at this time. When you know that the other activity has completed, you can try creating the partition again.","After partitioning commences, you can monitor its progress. For more information, see Monitoring Table Partitions. When partitioning completes successfully or an error occurs, the systems sends and email to the user who initiated the partitioning request.","Note: If a partition job is in progress for a BP table, you cannot deploy a related BP design until the partition job completes or fails.","To update (repartition) a table partition:","Go to the Company Workspace tab and switch to Admin mode.","In the left Navigator, select Data Structure Setup, and then select Table Partitions.","In the Table Partitions log, select the table that you want to partition again, and click Repartition.","If the selected table cannot be repartitioned, the system displays a message.","In the Repartition dialog box, click Repartition to accept the recommended number.","When the Repartition confirmation message appears, review the statements.","If you are ready to continue, click Create; otherwise, click Cancel.","Creating or Updating Table Partitions","10315484.htm");
Page[19]=new Array("You can use the Table Partitions log to view detailed information about each table, check the status of a partition or repartition job, and see the detailed history of each job.","Statuses displayed on the log include:","Partitioned: Indicates that this table has been partitioned.","Not Partitioned: Indicates that this table has not been partitioned.","In Progress: Indicates that this table is currently getting partitioned.","When you view the History tab for a selected table, statuses include:","In Progress: Indicates that this table is currently getting partitioned.","Completed: Indicates that this table has been partitioned.","Failed: Indicates that this table has not been partitioned.","To check the status of a job or a partition:","Go to the Company Workspace tab and switch to Admin mode.","In the left Navigator, select Data Structure Setup, and then select Table Partitions.","In the Table Partitions log, review the information displayed in the Status column for the applicable table.","To view additional information, select the applicable table and click View History.","The History tab displays more information about the status of current and previous jobs for the selected table. For example, if a job completed, the tab includes both the start date and the end date. If a job failed, it provides more information about the error that occurred.","Monitoring Table Partitions","10315485.htm");
Page[20]=new Array("A shell is where users can organize business information in one place to make managing it easy. You can use a shell to organize the information about projects, or facilities, in one place. A shell includes functions and features that are necessary for managing the information about projects, or facilities, within that shell. A shell is not required to function like a project.","Setting Up Shells","10282258.htm");
Page[21]=new Array("Shell set up involves setting up permissions at several points during configuring and creating shells, so the users can have access to various aspects of working with the shell.","Shell administration and set up involves the following steps:","Note: The following presumes that the shell types have been designed and imported to the Company Workspace.","Setting permissions for configuring the shells, in the Shell Manager.","Configuring the shells, in the Shell Manager.","Setting permissions for administering the shell templates that can be used to create shells.","Creating shell templates.","Setting permissions for adding, or modifying, shells.","Creating new shells for use.","Shell Administration and Set up","10299472.htm");
Page[22]=new Array("All designs, including shell designs, are designed in uDesigner and deployed to Unifier. See Importing Configuration Packages for more information.","About importing forms that contain data pickers","Data pickers point to a data source for the records they display. A data source can be a business process, shell, space, planning item, or manager class. If the data source that the picker is pointing to is not in the system already, the application will warn you.","The business process will not operate correctly until the data source is imported.","CSV import or RESTful Services (Create Shell)","When you create a shell instance by using CSV import or RESTful Services (Create Shell), the system copies the following into the created Shell:","The View Forms tab information from the selected shell template.","The forms added in the shell template, along with users and groups who are part of the viewers list.","Importing Shells","74303.htm");
Page[23]=new Array("After shells are created, for the Users or Groups to be able to access various aspects of working with shells, you (the administrator) need to grant access, or permissions, to the Users or Groups at several points during the shell setup, or alternatively attain all the permissions from the shell template. When a shell is created, the permissions that have been set at the template level will be copied over.","To set up permissions to configure shell types in the Shell Manager:","Go to the Company Workspace tab and switch to Admin mode.","In the left Navigator, select User Administration, and then select Access Control.","On the right pane, expand Administration Mode Access, expand Configuration, expand All, and then select Shell Manager.","For more information, see Edit User or Group Permissions Using Access Control in the Unifier General Administration Guide.","Click OK.","Setting Permissions to Configure Shell Types in the Shell Manager","74304.htm");
Page[24]=new Array("Configuring a shell consists of activating it and organizing it into a hierarchy. ","Note: Before you configure shells, Oracle recommends that you plan the shell hierarchy with your users and uDesigner user. The instance, and cost settings, affect how you will use the shell and its relationship to other shells. Planning will help you achieve the result that will meet your business needs.","As the administrator, you can configure the project numbering and the status of each project/shell type. As part of the numbering scheme, you can enable and disable automatic numbering and you can update the format and starting number. The system implements the new settings for records created after the change is implemented and ensures that unique labeling is maintained. If you change the value of Format or Start, the system cannot guarantee that the selected sequence is available due to possible conflicts with existing data and might alter the selected information to prevent a conflict. Changing this information might also create gaps in the numbering sequence.","Example: If you specify a Format of ABC and a Start of 0001, and records ABC0001 through ABC0015 have been created, and you then change the Format to DEF and the Start to 0001, the system starts generating new records with DEF0001. If you change the Format to back to the original ABC and a Start of 0001, the system will begin the sequencing of new records using ABC0016.","To configure the shell types in the Shell Manager:","Go to the Company Workspace tab and switch to Admin mode.","In the left Navigator, select Configuration, and then select Shell Manager.","Double-click the applicable shell type.","The &lt;shell name&gt;-General Configuration window opens.","On the General tab, complete the following fields:","Enable Automatic Numbering: To allow automatic numbering of projects based on the specified Format and Start values, select this option. You can deselect this check box to disable automatic numbering; it is selected by default.","Format: If you enable automatic numbering, specify the format of the numbering schema. By default, Format is blank.","Start: If you enable automatic numbering, specify the starting number. Start determines the starting number of the numeric schema. By default, Start is 0001.","Cost Codes: This read-only field displays the type of cost code specified in uDesigner for the shell type.","WBS: Standard Cost Manager","Generic: Generic Cost Manager","Status: Select the applicable status, Active or Inactive. Users cannot access shell types that have an Inactive status. The default is Inactive.","Note: If a project/shell is open and visible when its corresponding shell type is changed to Inactive, you cannot create a new shell of the applicable type but existing shells are not affected.","Click the Organize tab.","On this tab you can specify the sub-shell types that are allowed under the selected shell type. For example, assume you have configured a shell called Region, which has the sub-shell types Properties and Buildings. Also, Properties has Buildings as a sub-shell. The system performs validation during shell configuration, and manages the relationships among the shells that you configure. The table below shows the relationships among the shells described above.","To add sub-shell types from the list of imported shells, click Add and select the applicable types. You can only add shells that have an Active status.","Select the Active check box for the sub-shell types you want to activate.","You can deactivate sub-shell types that you do not want users to use for sub-shell instance creation. You can deactivate a sub-shell type even if sub-shell instances have been created with that type.","Note: You can remove a sub-shell type from the list by clicking Remove, if an instance of the sub-shell type is not created under the shell.","When you are done, click Save.","Complete the configuration steps for each shell type.","Shells-&gt;","Parent","Child","Grandchild","Sub-shells that are allowed","Parent","No","No","No","Child","Yes","No","No","Grandchild","Yes","Yes","No","Configuring Shells","74305.htm");
Page[25]=new Array("You may have a large number of codes that are used within the Generic Cost Manager. In addition, you may have a large number of shells in your implementation. To update codes and columns in your generic cost manager sheets with a minimal effort, you can push columns in a project/shell template generic cost sheet from the Columns Log to cost sheets.","About updating shell instance dashboards","A cost sheet must exist in the destination shell. Pushing a column from a template will not create a cost sheet that can receive the column.","You can push one column at a time.","If a source column is a single data source, the destination column will be created with that single data source if it does not exist. (Column A or B in example below)","If a source column is a formula with only single data sources, pushing the source column will create that column in the destination cost sheet, if it does not exist. (Column C in example below)","If a source column is a formula with columns included in the formula, if all constituent columns contain single data sources, the source column can be pushed; for any columns that do not exist in the destination cost sheet, the formula will be changed to a single data source in the formula. (Column D in example below)","If a source column is a formula with constituent columns that include logical data sources, the logical data source must exist in the destination cost sheet. The formula for the logical data source may be different in the destination cost sheet. Any column that contains a single data source will follow the rule above. (Column F in example below)","To add or update generic cost sheet columns from a template:","Go to the Company Workspace tab and switch to Admin mode.","In the left Navigator, select Templates, and then select Shells.","Open the shell-type template to update.","In the shell template, navigate to Configurable Modules, and then select Generic Cost Manager.","Select the Generic Cost Manager Sheet template and click the Structure button.","In the Generic Cost Manager Sheet log, select the cost sheet template and then click the Columns button. The Columns Log opens.","Select a cost sheet column.","Click Update Shells and choose one of the following:","Shells: You can use this option to select one or more shells to update. When the update window opens, it lists all shells in the project. You can use Find to isolate the shells you want to update. The find window contains data elements from the Find form that were designed in uDesigner. When you have isolated the shells to update, click the Update button.","All Shells: You can use this option to update all shells of that shell type.","History: You can view the update history from past updates or cancel a request before the update begins.","An Alert window opens letting you know that you are about to push changes to the selected shells; there is no undo for the update.","Click Yes if you want to proceed with the update, or No to cancel.","To update generic cost sheet rows from a template:","Go to the Company Workspace tab and switch to Admin mode.","In the left Navigator, select Templates, and then select Shells.","Open the shell template you want to update.","In the template, navigate to Configurable Modules, and then select Generic Cost Manager.","Select the template and click the Structure button.","Select a row or rows to push to the project/shell level generic cost sheet. You can select multiple rows by holding down the Shift or Ctrl keys as you click the rows.","The application will update leaf-level rows, but not summary rows.","Click Update Shells and choose one of the following:","Shells: allows you to choose which shell(s) to update. You can use Find to search for specific shells to select from the complete list of shells. You can select as many shells as you want to update. The Page and Display fields display on the Shell Update window, but are disabled in this case.","All Shells: updates all active and on-hold shells","History: allows you to view the update history from past updates or cancel a request before the update begins.","An Alert window opens, detailing the information that will be updated. Read the message carefully, as this action cannot be undone after a shell is updated.","Click Yes if you want to proceed with the update, or No to cancel.","Update Generic Cost Sheet Columns and Rows","74344.htm");
Page[26]=new Array("To update columns in your cost manager sheets, you can push columns from the Cost Sheet Columns log to cost sheets in each shell and shell template.","Note: You might want to perform this task if you are using formula-based columns that are based on BPs and you change the name of the BP; the formulas for the columns are not automatically updated when you change the name of the BP. For example, if your Project Cost Sheet includes a column such as Contract &amp; PO that displays Agreement (Approved) + Change Order &#8211; Contract (Approved) when you hover over the column heading and you subsequently update the BP name from Change Order - Contract to Change Order, the information displayed in the hover label is not updated. You can use the following process to update the applicable columns in your cost sheets. You can also manually update the hover label by right-clicking the column name, selecting Properties, clicking Select in the Formula section, and making the applicable changes.","A cost sheet must exist in the destination shell. Pushing a column from a template will not create a cost sheet that can receive the column.","To add or update cost sheet columns from a template:","Go to the Company Workspace tab and switch to Admin mode.","In the left Navigator, select Templates, and then select Shells.","Open the shell-type template to update.","In the left Navigator for the selected shell template, select Cost Manager, select Cost Sheet, and open the Cost Sheet template.","From the toolbar, click Menu Options, select Columns, and then select Manage Columns.","The Cost Sheet Column window opens.","If applicable, drag and drop the listed columns to the order that you want to use.","Select the column, or columns, that you want to use in the update.","From the toolbar, click Update Shells, and choose one of the following:","Shells: You can use this option to select one or more shells to update. When the Update Shells window opens, it lists all shells in the project. You can use Search or Find on Page to isolate the shells you want to update. The find window contains data elements from the Find form that was created in uDesigner. After you have isolated the shells to update, from the toolbar, click Update Shell(s), and select either Selected Shell(s) or All Filtered Shells.","All Shells: You can use this option to update all shells of that shell type.","History: You can view the update history from past updates or cancel a request before the update begins.","An Alert window opens letting you know that you are about to push changes to the selected shells; there is no undo for the update.","If you want to proceed with the update, click Yes; otherwise, click No to cancel.","Update Standard Cost Sheet Columns","10301422.htm");
Page[27]=new Array("The following configurations can be included in the Shell Manager Configuration Package:","General setup","All the fields included in the General Configuration (General tab).","Organize setup","All the fields included in the Organize tab.","Notes:","The sub-shells defined in the Shell hierarchy are also included in the Configuration Package.","The sub-shells defined in the Organize tab are included in the Configuration Package.","You can export the sub-shells.","For more information, see Configuration Package Management.","Configuring Shell Manager Configuration Package","10282361.htm");
Page[28]=new Array("To set Shell Template administration access:","Go to the Company Workspace tab and switch to Admin mode.","In the left Navigator, select User Administration, and then select Access Control.","On the right pane, expand Administration Mode Access, expand Templates, expand Shells, and select the [shell node].","For more information, see Edit User or Group Permissions Using Access Control in the Unifier General Administration Guide.","Click OK.","Setting Permissions to Administer Shell Templates","74307.htm");
Page[29]=new Array("From the Shells node under Templates, you can access the shell type templates that are created. You can also designate a specific shell as the default shell that should be used when projects/shells are created.","One node is created under Shells for each shell type that is imported and that has an active configuration status.","Note: Single-instance shells are not listed under Shells as there can only be one instance created for those shell types, and there is no need of a template.","To access shell templates:","Go to the Company Workspace tab and switch to Admin mode.","In the left Navigator, select Templates, and then select Shells.","Expand the Shells node.","Shell templates are grouped by shell types. One node is created for each shell type imported. For example, Buildings, Linear Assets, Projects, and so on.","Select one of the shell type nodes, for example Projects, to view the log for the shell type.","The applicable log opens. The log lists any project templates that have been created for that shell type.","To designate a shell as the default, click the gear menu ( @ ), and select Mark as Default.","The Default column displays Yes for the applicable template. If you want to clear the Default label, select Reset Default from the gear menu.","Accessing a Created Shell Template","74308.htm");
Page[30]=new Array("The following procedure describes how to create a shell template.","To create a shell template:","Go to the Company Workspace tab and switch to Admin mode.","In the left Navigator, select Templates, select Shells, and select the [shell type].","The &lt;shell&gt; Templates log opens. The log lists any shell templates that have been created under that particular shell type.","From the toolbar, click Create, and then select Manual.","The &lt;shell&gt; templates Details window opens.","On the General tab, complete the fields as described in the table below.","Note: The General tab that you see will depend on the Shell Attributes form that was imported. Required fields are marked with an asterisk (*).","On the Currency tab, click the Add button.","The New Currency window opens.","Note: The Base Currency shown at the top of the window is the Base Currency set up for your company. For example, if your company is located in the U.S., the Base Currency will likely be United States Dollar (USD). If your company does business internationally, you may make other currencies available for shell use.","Complete the New Currency window:","To access the Currency Picker dialog box, click the Select icon in the Currency Name section.","Select a currency from the list and click Select. The available currencies were defined at the time your company was set up. (The currency list is maintained in the Exchange Rates sub-node of Standards &amp; Libraries.) Contact your Company Administrator if you need additional currencies.","If the currency you selected is different from the company Base Currency, complete the following:","Rate: Enter an exchange rate to use for conversion calculations.","If Float is selected, the rate comes from the company active exchange rate set (Exchange Rates sub-node of Standards &amp; Libraries).","A Peg rate is locked at the rate set. (Only an administrator can change the Peg rate, or Peg to Float or Hedge.)","If the Hedge selection is Yes, the Hedge rate is used. Otherwise, the Float rate will be used. If an amount is entered for the Rate, then the hedge rate is used until the amount specified is reached (by spends) and then the system will revert back to the active exchange rate.","If applicable, enter information in the Comments box.","Click Save to save and exit the New Currency window.","The first currency that you add is selected as the default currency for the shell. If you add multiple currencies, you can select a different Default Currency from the drop-down list. This will be used as the default shell currency. After you have selected a shell currency and saved the template or shell, it cannot be changed. The selections are generated from the Currencies list you defined.","Note: You cannot modify this default currency after you save the changes to the template Details window.","On the Images tab, click the Browse (+) button to locate and upload any applicable graphics from your computer.","You can upload an image to display on the landing page of the shell in both Administrator and User modes.","On the Options tab, complete the applicable fields.","You can select the phase of the shell on this tab. The phases available are based on the Phase data definition.","Within the Shell Details, the user can select which attributes forms to use for the Document Manager, for both folders and documents.","From the Options tab, the user can define which attribute form (Document Manager Attribute Form) to use for the document/folder. By default , the &quot;DMS Attributes&quot; folder properties attribute form, which is system-defined in Document Manager, can be selected, and the corresponding Document Manager Attribute Form is used to determine the DMS structure. The user will have an option to choose other attributes forms as well. Only the active DM configuration forms will be available for selection.","In case a previous active Document Manager configuration (in a shell) is marked as inactive, the DMS structure keeps that attribute form structure. When you open the shell details, the Document Manager Attribute is defaulted to system-defined attribute form because the previous configuration has been marked as inactive. The Document Manager Attribute Form User will show the previous DM attribute form that is kept by the shell. If you click OK, the system displays a message, informing you of this change.","In case a previous active Document Manager configuration (in a shell) is deleted because the associate folder attribute form was deleted, the DMS structure is defaulted to the system-defined attribute form of a supported DMS structure for the shells.&nbsp;When you open the shell details, the Document Manager Attribute is defaulted to system-defined attribute form because the previous configuration has been deleted. The Document Manager Attribute Form Used will show the system defined DM attribute form that is kept by the shell. If you click OK, the system displays a message, informing you of this change.","Project/Shell Creation BP behavior","While creating Project/Shell creation BP records, the shell template that has been selected via the shell picker keeps the folder properties attribute form that is mentioned in the respective templates and have the DMS structure accordingly.","Company behavior","The Company Workspace Document Manager is defaulted to the DMS attribute, which is system-defined.","The Options tab also lets you select the entity that provides electronic signature technology (DocuSign or Acrobat Sign). For Projects/Shells, the value for the E-Signature Type drop-down list is: Default. For more information, see Selecting and Configuring a Default System for E-Signatures in the Unifier General Administration Guide.","Note: If a value (E-Signature Type) has been determined in the Acrobat Sign or DocuSign functional nodes under the Integration grouping node, the value of the E-Signature Type drop-down list (Standards tab) will be read-only.","You can select a different value from the E-Signature Type drop-down list.","The Company Administrator can use the Acrobat Sign or DocuSign functional nodes under the Integration grouping node to change the default value. This change does not impact the value of the E-Signature Type in the project, and the values will remain as:","Company Default","DocuSign","Acrobat Sign","Complete the Links tab to add links to the shell.","These links are displayed on the shell landing page in User mode. Use links to provide users with access to useful websites, your company's website, an intranet, or other destinations. Click Add and enter the name and URL for the links you want to add to the landing page. ","On the Calendar tab, create a shell calendar.","Each shell can have its own calendar. You can use the: ","Specified shell calendar to override the company calendar.","Company calendar for the shell. ","Company calendar (marked as default calendar) for the shell if there is no shell calendar, or if the shell calendar is not being used. ","Shell calendars can be based on Standard Calendars created at the Company level, or Custom Calendars created for the specific shell. The shell calendar you create applies only to the shell for which you create that calendar. The calendar selected affects shell durations and due dates. For example, companies can have multiple projects in different countries that have different working and non-working days. These working and non-working days must be considered when determining such time-driven factors as business process workflow due dates and activity dates.","Note: Unless otherwise specified, the default calendar for a shell is the Company calendar that is marked as default at the Company level.","Open the Calendar tab of the shell or Template window. The calendar you create in this tab is known as the Project/Shell Calendar.","You can select a company-level Standard Calendar, or use a Custom Calendar for your shell. The calendar that you select displays in the Calendar tab.","To use a Standard Calendar as the shell calendar, click the Standard Calendar radio button and select a calendar from the drop-down list.","To use a Custom Calendar as the shell calendar, click the Custom Calendar radio button and click Copy. You can copy a previously-created Standard Calendar and use it as the project calendar.","You can modify the displayed calendar. You can specify the working and non-working days for the calendar. Browse to the month and year using the pull-down menus at the top of the calendar. Saturdays and Sundays are set as non-working days by default. Do one of the following:","To set a particular date as a non-working day (for example, a holiday), click the date on the calendar and select Non Working. The date will appear grayed out, and will not be used in date calculations.","To set a non-working day as a working day, click a grayed cell and select Working.","To set a particular day of the week (for example, every Saturday) as a non-working day, click the day at the top of the calendar (for example, &quot;Sat&quot;), then click Non Working. All Saturdays in the calendar will be changed to non-working days (gray).","To set a particular day of the week as a working day, click the day at the top of the calendar, then click Working.","If you only want to set the day of the week in a particular month as working or non-working days, select each day individually and click Working or Non Working.","Note: If you have marked the day of the week as a non-working day throughout the calendar by selecting the day at the top of the calendar (for example &quot;Sat&quot;), then you will not be able to mark individual days (that is, individual Saturdays in this example) as working days. To be able to include both working and non-working instances of a day of the week on the calendar, you must select them individually.","Click OK. When you click OK, the calendar displayed in the Calendar tab is the shell calendar.","When you are ready to save information and exit the window, click Save.","In this field","Do this","Description","Enter a description of the shell type template.","Administrator","Select an administrator for the template.","Location","Disabled for template creation.","Status","You can activate the shell immediately, or place it On-hold and activate later. A template that is On-hold or Inactive cannot be used to create a shell. It is good practice to leave a shell or template On-hold until you have completed the setup. Shell Administrators/Users with &quot;modify shell status&quot; rights are the only ones who can change the status.","The Shell Administrator will receive email notification when the status of a shell changes. The change of shell status could occur due to a manual change, bulk update, through Web Services or a CSV file, or through automatic update.","Status definitions for shells are:","Active: Active, in-progress shell. All shell actions in User and Admin mode are available.","On-hold: The initial shell status. On-hold shells appear on the shells log. Shell administration functionality is available to shell administrators for setup and maintenance for users with permissions to perform that function. Users cannot create records in a shell that is On-Hold. If a user attempts to access a shell that is On-Hold, the system displays an alert message stating that the shell is On-Hold.","View-Only: For end users, View-Only shells can be viewed, printed, exported, and included in reports. They cannot be modified. When a shell is View-Only, the status overrides (but does not modify) access control permissions, granting only View permissions. The shell reverts to the access control permissions when the shell is made Active. View-Only shells can roll up to UDRs and dashboards. Business process records cannot be auto-created in View-Only shells. Data from View-Only shells rolls up to Generic Cost Manager cost sheets if all the shells in the hierarchy are generic. Data rolls up to dashboards on a View-Only shell from child shells in the hierarchy, and rolls up to a parent shell from a View-Only shell. No updates can occur to View-Only projects through Integration, Mobile, or through reverse auto-population. View-Only shells cannot be updated through templates. Consolidate line item functionality is disabled for View-Only shells. Users can navigate through the shell hierarchy using View-Only shell instances. View-Only shells have only view, export, and print permissions available. Tasks and Drafts are not available for View-Only shells. Messages are available, but users cannot add general comments. Mailbox is available for viewing, but users cannot send, edit or delete messages for View-Only shells. When a shell becomes View-only, all scheduled jobs associated with it are canceled. When the status of the shell changes back to Active, you must restart any scheduled jobs. Administrators can perform all actions on View-Only shells.","Inactive: Used to suspend shell usage. Inactive shells are visible from Admin mode under Sponsored Shell log only, but not visible under the Shells node (that is, only Sponsor Company can access the shell), or in User mode logs and selections. Only System and Shell Administrators (users with Modify Status rights) can reactivate the shell.","Note: &quot;Late&quot; tasks in an inactive shell may still show up in users' tasks logs. Though they can access the task, no transactions can be performed in the inactive shell. ","Auto-update Status Setup","The selections on the drop-down list are defined automatic status update setups. These setups are defined at the Company level for use in specific shells. For more information, see Setting Up Automatic Update of Shell Status. If you decide not to use the automatic status update, you can deactivate it by deselecting a setup (by literally selecting the word &quot;Select&quot;).","Shell Number","Unique number that identifies the shell.","GeoCoding","Details for mapping. This field appears if geocoding was set up in uDesigner for the shell. ","Note: After a currency is selected and saved, it cannot be modified. The remove option is made available so that you can remove the additional currencies and unsaved changes.","Create a Shell Template Manually","74309.htm");
Page[31]=new Array("You can create a Shell Template by copying from an existing shell template or an existing shell. The Copy From Shell Template and Copy From Shell pages list all templates and shells, respectively, that are designated as Active, On-hold, or View-Only. ","To create a shell template by copying an existing shell or shell template:","Go to the Company Workspace tab and switch to Admin mode.","In the left Navigator, select Templates, select Shells, and then select a shell type.","From the Create menu, select From Template or From Shell.","You can use the Search and Find on Page options to look for a specific shell or template in the list.","In the Select Modules pane, select the modules to include in the new template.","The modules available depend on the cost code type of the shell or shell template (CBS or Generic). See Shell Cloning Window Selections for the lists of available modules by cost code type.","After you are done selecting the modules to include, click Done.","In the template Details window, update the applicable tabs and fields.","Most properties are copied from the original shell or template with the following exceptions:","Currency: On the Currency tab, specify the Shell Currency","Image: On the Images tab, specify the Shell Image (optional)","The status is set to On-Hold.","Click Save. Click Yes to confirm.","Create a Shell Template by Copying a Template or Shell","74319.htm");
Page[32]=new Array("In a shell log, when you click the Copy button, the cloning window lists optional calendar, module, manager, sheet, and structure selections. You must select an item to include it in the new shell. See Create a shell by copying a template or shell.","Shell Cloning Window Selections","74320.htm");
Page[33]=new Array("The following is a list of the selections: ","User/Groups: This is not an optional selection; users and groups in a template or shell are always included by default.","BP Setup: You have the option to copy all, or none, of the business processes and their setups that are in the template or shell.","Templates do not allow record creation of multiple-record business processes, but they do allow record creation of single-record business processes (go to the shell tab and switch to User mode; in the left Navigator, select Information, and then select General). If you added a single-record business process into the template or shell and created a record, that record with all its data is cloned when you select this option.","Configurable Modules (and then select Configurable Managers (CM1 through CM25) ): Configurable Managers are designed in uDesigner and have flexible coding structures to data collection and analysis. Each manager appears in the module selection pane by its unique name.","Custom Calendars: Custom calendars provide a means to address variations in work schedules, holidays, and other non-working days. You can add custom calendars to a shell detail form on the Calendar tab.","Dashboard Setup: Shells and templates may have multiple dashboards, each governed by unique permission settings.","Document Folder Structure: Folder templates help standardize document organization in the Document Manager.","Gates Setup: Gates provide a means of automating when a project moves to the next phase.","Resource Manager: Manage personnel resources using the Resource Manager, if you have access to the feature.","Space Manager: Manage levels and facilities using the Space Manager.","User Defined Reports: You can create multiple user-defined report templates and include them in the new shell during cloning.","Cloning Window Selections for all Shell Templates and Shells (Both CBS and Generic Codes)","74321.htm");
Page[34]=new Array("The following is a list of selections. ","Commitment Summaries: In the same way the schedule of values summarizes all cost information related to a particular commitment business process, the commitment summary tracks commitment record information.","Generic Cost Manager (CM0): The Generic Cost Manager captures cost-related transactions for a generic shell. Each generic shell can have one Generic Cost Manager.","Cloning Window Selections for Only Generic Code Shell Templates and Shells","74322.htm");
Page[35]=new Array("Cash Flow: Cash flow is the distribution of cost over time&#8212; in project management terms, it is the movement of cash into or out of a project measured during a specific time period.","Commitment Funding Sheet: A funding sheet tracks project funding &#8212;where it comes from and how it is being spent. You can create one funding sheet per template or shell. See Setting up the Funding Manager.","Cost Sheet: The cost sheet provides detailed tracking of the project's budget and costs. You can create one cost sheet per template or shell. See Setting up Cost Sheets.","Schedule of Values: The schedule of values summarizes all cost information related to a particular commitment business process. See Setting Up Schedule of Values (SOV).","Rules: Project cost or funding rules impose conditions on project transactions per rule queries. See Creating Rules and Rules Templates.","Schedule Sheet: Schedule sheets track project activities and milestones. You can have multiple schedule sheets in a project. Once created, they cannot be deleted.","Cloning Window Selections only for CBS Code Shell Templates and Shells","74323.htm");
Page[36]=new Array("In shell templates you can prepare modules and managers to make standardized templates, which ensure project uniformity and greatly reduce the potential for errors. You can have different templates for different project models. For example, you can have one template for &quot;cookie-cutter&quot; projects that do not change, and you can have another template for projects that might incur substantial changes. The system will copy any prep-work when you use the template to create a new shell, a process called cloning. Manager and module availability can differ depending upon CBS or generic code specification in uDesigner. See Create a Shell by Copying a Template or Shell. ","Shell Template Modules and Managers","74310.htm");
Page[37]=new Array("The following lists the managers and modules that are available in all Shell Templates for both CBS codes and the Generic Codes.","Member Companies","To make Partner Companies that you added at the company level available in your projects, you add them in Member Companies. Member Companies added to a shell template automatically copy to a shell during cloning. For more information, see Managing Member Companies.","Access Control","For modules and managers included in a shell template, you can assign user-mode permissions. Permissions set in a template will automatically copy to a shell during cloning. Keep in mind, records created in user mode may require permission assignment in user mode.","User Administration","Users and groups added to a template are copied by default from the template to a new shell during cloning. For more information, see User Administration in the Unifier General Administration Guide.","Users: Users added to a template automatically copy to the shell during cloning. Users added to shell templates cannot be deleted, only inactivated.","Groups: Groups added to a template, and any users added to these groups, automatically copy to the shell during cloning.","Setup","Business Process: You have the option to copy all, or none, of the business processes and their setups that were added to a template. For more information, see General Procedures for Setting Up Business Processes. If you added a single-record business process to a template and created a record, that record with all its data will be copied during cloning. For more information, see Single-Record Business Processes.","Dashboards: You can define dashboards in a template and opt to include them when you clone a new shell from the template. For more information, see Creating a Shell Dashboard in a Template.","Gates: Gates provide a means of automating when a project moves to the next phase. You can define gates in a template and opt to include them when you clone a new shell from the template. For more information, see How to Set Up Gates.","Planning Manager: This is where you can plan for new projects and create proposals and forecasts for projects already running in the system.","Resource Manager: This is where you can set up and manage personnel resources in a company, project, or shell, if you have access to the Resource Manager feature.","Material Inventory Manager: This is where you can manage materials within the company, project, or shell.","Information","This is where single-record business processes exist. When you clone a template, any single-record business processes are copied as well. For more information, see Single-Record Business Processes.","Configurable Modules (and then select Configurable Managers (CM1 through CM25) ): Configurable Managers are designed in uDesigner and have flexible coding structures to allow data collection and analysis.","Document Manager: You can create a folder structure for the Document Manager that can be used across shells. These can be created from Folder Structure Templates, or folders can be added manually. Unlike Folder Structure Templates, you can also assign users folder-level permissions (if they are in the shell template) and can import folders and folder properties.","Space Manager: This is where you can manage facilities for the company, project, or shell. ","Reports: You can create one or more user-defined report templates, which will be used for shell-level user-defined reports. ","Managers and Modules Available in all Shell Templates (Both CBS and Generic Codes)","74316.htm");
Page[38]=new Array("Configurable Modules and then select Generic Cost Manager (CM0)","The Generic Cost Manager captures cost-related transactions in a Generic Shell. These can include costs like rent, lease payments, or landscape care that are based on time scales such as monthly, quarterly or yearly. Each generic shell can have one Generic Cost Manager.","Cost Manager and then select Commitment Summaries","In the same way the schedule of values summarizes all cost information related to a particular commitment business process, the commitment summary tracks commitment record information. See Setting Up the Commitment Summary Template.","Selections Available in only Generic Code Shell Templates","74317.htm");
Page[39]=new Array("Cost Manager","Cash Flow","Cash flow is the distribution of cost over time - in project management terms, it is the movement of cash into or out of a project measured during a specific time period.","Cost Sheet","The cost sheet provides detailed accounting of the project's budget and costs. You can create one cost sheet per template or shell. See Setting Up Cost Sheets. Set up the standard cost sheet template and copy it into the shell template.","Earned Value","The earned value module provides quantitative tracking information about project/shell status using earned value analysis. You can only set User mode permissions in a template.","Funding","The Funding Manager helps you to keep track of where project funding comes from and how it is being spent. You can create one funding sheet per template or shell. See Setting Up the Funding Manager.","Schedule of values (SOV)","The SOV sheet summarizes all cost information related to a particular commitment business process. This is where you define structures for General Spends, Payment Applications, or Summary Payment Applications.","You can define a General Spends SOV structure by copying from an SOV template in the Templates log.","For Payment Application SOV and Summary Payment Application SOV, the structure is copied from the line item grid structure of the Payment Application Business Process. This means that you must first complete the Business Process (BP) setup for the Payment Application BP before you can create the structure. See Setting Up Schedule of Values (SOV).","Rules","You can define shell-level cost or funding rules. See Creating Rules and Rules Templates.","Schedule Manager","Schedule Sheets","A schedule template will be used to create the schedule sheet. Like the cost sheet, once this is created, it cannot be deleted.","Activity Manager","Activity Sheet","WBS Sheet","OBS Sheet","Custom Calendars","See the Activity Manager section of the Unifier Earned Value Management User Guide to learn more about the functionality of the Activity Manager nodes. ","Shell Templates","If the Data Element (DE) &quot;uuu_int_schedule_type&quot; is not included in the attribute form, then:","The template that has the option &quot;Enable P6 sources&quot; selected is not included when you want to create a Cost Sheet by clicking New, selecting Cost Sheet, and then selecting Copy from Template.","The cost sheet that has the option &quot;Enable P6 sources&quot; selected is not included when you want to create a Cost Sheet by copying a cost sheet from a Shell instance.","If the DE &quot;uuu_int_schedule_type&quot; is included in the attribute form, then:","When you add a Cost Sheet to the template (using a standalone template or by Copy from other Shell instances), you can only select a &quot;Tree&quot; structure cost sheet.","Notes:","You can select any Cost Sheet irrespective of whether the option &quot;Enable P6 Sources&quot; is selected or not.","After you create a Cost Sheet , the option &quot;Enable P6 Sources&quot; is available for edit.","After you add columns to the Cost Sheet using &quot;P6 Data Sources&quot; you cannot clear the property.","If you remove the columns using P6 Data Sources, you can deselect the &quot;Enable P6 Sources&quot; option.","The value for the DE &quot;uuu_int_schedule_type&quot; remains blank because the DE is read-only.","Selections Available only in CBS Code Shell Templates","74318.htm");
Page[40]=new Array("Use the Document Manager template to create folders, perform actions, update shells, and find folders.","Create Folder: Create folders in the template.","Actions: Perform the following actions (Export, Import, Index Report, Move, Copy, Delete, Permissions) on a folder.","Update Shell Templates: Use this drop-down menu to update the permissions, or the Structure &amp; Permissions for a particular shell template or all shell templates. You can also view the update history.","Update Shells: Use this drop-down menu to update the permissions, or the Structure &amp; Permissions for a particular shell or all shells. You can also view the update history.","Delete: Delete a log item.","Find on Page: Find folders by filtering on the various columns.","Expand/Collapse: To open or close all sub items in the log.","Note: The Comment, Lock, Ref and BP columns are not displayed in the document template log.","Document Manager Template","10292173.htm");
Page[41]=new Array("To open the shell template:","Go to the Company Workspace tab and switch to Admin mode.","In the left Navigator, select Templates, and then select Shells.","Select a shell type. The shell templates log opens.","Select a shell template from the log and click Open.","To edit shell template properties:","From the shell template home page, click the three dots in the upper-right corner and select Details. The template Details window opens.","Click the tabs to view or edit shell template properties.","Manage Shell Templates","74324.htm");
Page[42]=new Array("You (the project administrator) can set up the View forms in shell templates. For details, see Setting Up View Forms in Shell Attributes.","When you create shells using shell templates, the View Forms tab information will be copied into the created shell. In addition:","All the View forms that are added in the template will be copied into the created shell.","All the users or groups, who are a part of the viewers list in the View forms, will become the members of the newly created shell.","Adding View Forms in Shell Template","10293787.htm");
Page[43]=new Array("To set shell instance access:","Go to the Company Workspace tab and switch to Admin mode.","In the left Navigator, select User Administration, and then select Access Control.","On the right pane, expand Administration Mode Access, expand Company Sponsored Shells, and then select the [shell node].","See Edit User or Group Permissions Using Access Control in the Unifier General Administration Guide, and select these permissions depending on what access needs to be granted:","Create: Allows the creation of new shell instances.","Modify Status: Allows the modification of the status of shell instances.","Modify Properties: Allows the modification of shell instance properties.","Configure User Dashboard: Allows the configuration of the shell dashboard in User mode. This is the dashboard listed as My Dashboard in the View Dashboard (drop-down list) that displays for the end-user in a shell instance.","Hide Audit Log: Prevents the user from viewing the Audit Log for the Shell Attribute Form, which ensures that the user is not aware of what changes are made to the shell, when they are made, and by whom.","Click OK.","Setting Permissions to Create or Modify Shell Instances","74311.htm");
Page[44]=new Array("There are multiple ways to create a shell.","Manually, from scratch","Copying from a shell template","Copying from an existing shell","Importing via a CSV file","Using a shell creation business process","When you create a shell from a shell template or by copying another shell, any shell dashboard that exists in the source template, the system copies the dashboard into the destination shell.","Creating a Shell","74312.htm");
Page[45]=new Array("To create a shell manually:","Go to the Company Workspace tab and switch to Admin mode.","In the left Navigator, select Company Sponsored Shells, and then select the applicable type from the functional nodes list.","Notes:","Ensure that you configure and test shells in the Development environment before you import them into the Test or Production environment.","The DE of type Rich Text DE is not available to be added to the Company Sponsored Shells.","From the Create menu, select Manual.","The Details window opens.","On the General tab, complete the fields as described in the table below.","Note: The table only lists the required fields that are common across most shells. The shell that was designed for your company will include other required and optional fields. Required fields are marked with an asterisk (*).","On the Currency tab, click the Add (+) button to add a default currency for the shell, and use the information in the table below for guidance.","Note: You cannot modify this default currency after you save the changes to the Details window. When you click Apply to save changes, you will receive a confirmation warning that reads:  &quot;You are about to create a new &lt;Shell Type Name&gt;. The default currency of this &lt;Shell Type Name&gt; is &lt;Currency Name&gt; (&lt;Currency Code&gt;). After the &lt;Shell Type Name&gt; has been created, this default currency cannot be changed. Are you sure you want to continue?&quot; If you click Yes, you will not be able to change the default currency.","On the Images tab, click the Browse (+) button to locate and upload any applicable graphics from your computer.","You can upload an image to display on the landing page of the shell in both Administrator and User Modes.","Click the Options tab, and complete the fields.","You can specify a phase of the shell, select a time zone for background jobs, and configure email notification. (For information on this mailbox, see Dedicated Mailbox for Shells.)","Complete the Links tab to add links to the shell.","These links are displayed on the shell landing page in User mode. Use links to provide users with access to useful websites, your company's website, an intranet, or other destinations.","Click Add and enter the name and URL for the links you want to add to the landing page.","Click the Calendar tab, and select one of the following options:","Standard Calendar: This option lets you use a standard calendar for your shell. You can select the Company Calendar (Default) or other listed calendars.","Custom Calendar: This option lets you use a custom calendar for your shell. You can use Copy to select a calendar or create a custom calendar.","If applicable, click the Gateway Integration tab, and enter the Project ID of the Source Project.","When you are ready to save information and exit the window, click Save.","In this field","Do this","Administrator","Select an administrator for the shell.","Location","The Location picker lets you change the location of a shell and is accessible when you set up a shell or modify the shell details. See Location Picker Behavior for details.","Use the Location Picker to select where the shell instance will reside. In the Location picker:","Find searches the current level","Open shows the next level of shells","Select completes the action","Location Picker will allow breadcrumbs to display through the hierarchy","Work systematically from the top of the hierarchy to the bottom","There must be an instance of a single shell to connect to","You can use the Location picker to reorganize the shell hierarchy. The shell can move across tabs, or laterally along the hierarchy. When you move a shell instance, all the shell data moves with the shell. If an auto-populated business process moves with the shell instance, the auto-populated data moves with the business process. Data for the business process will be collected from the new shell location. In addition, if a child shell has been designed with linked elements, field values on the Shell Attribute Form or single-record BPs will be automatically updated to reflect changes when the shell is moved.","Status","You can activate the shell immediately, or place it On-hold and activate it later. A shell that is On-hold or Inactive cannot be used. It is good practice to leave a shell On-hold until you have completed the setup. Shell Administrators/Users with &quot;modify shell status&quot; rights are the only ones who can change the status.","Status definitions for shells are:","Active: The default status of the shell when the shell is created in the user interface: ","manually ","from a template","from a shell ","It defaults to the status specified by the user if the shell is created by an import from a shell or template in Unifier; otherwise, it is set as Active. ","It is the status for any active, in-progress shell. All shell actions in User and Admin mode are available. It is also the default shell status if it is created using REST services when no value is provided in the request. ","On-hold: On-hold shells appear on the shells log. Shell administration functionality is available to shell administrators for setup and maintenance for users with permissions to perform that function. Users cannot create records in a shell that is On-Hold. If a user attempts to access a shell that is On-Hold, the system displays an alert message stating that the shell is On-Hold.","View-Only: For end users, View-Only shells can be viewed, printed, exported, and included in reports. They cannot be modified. When a shell is View-Only, the status overrides (but does not modify) access control permissions, granting only View permissions. The shell reverts to the access control permissions when the shell is made Active. View-Only shells can roll up to UDRs and dashboards. Business process records cannot be auto-created in View-Only shells. Data rolls up to dashboards on a View-Only shell from child shells in the hierarchy and rolls up to a parent shell from a View-Only shell. No updates can occur to View-Only projects through Integration, Mobile, or through reverse auto-population. View-Only shells cannot be updated through templates. Consolidate line item functionality is disabled for View-Only shells. Users can navigate through the shell hierarchy using View-Only shell instances. View-Only shells have only view, export, and print permissions available. Tasks and Drafts are not available for View-Only shells. Messages are available, but users cannot add comments. Mailbox is available for viewing, but users cannot send, edit or delete messages for View-Only shells. When a shell becomes View-only, all scheduled jobs associated with it are canceled. When the status of the shell changes back to Active, you must restart any scheduled jobs. Administrators can perform all actions on View-Only shells.","Inactive: Used to suspend shell usage. Inactive shells are visible from Admin mode under Sponsored Shell log only, but not visible under the Shells node (that is, only Sponsor Company can access the shell), or in User Mode logs and selections. Only System and Shell Administrators (users with Modify Status rights) can reactivate the shell.","Note: &quot;Late&quot; tasks in an inactive shell may still show up in users' tasks logs. Though they can access the task, no transactions can be performed in the inactive shell.","Currency Name","Select the currency you want to use for the cost functions in this project.","If the currency you select is other than the company Base Currency, complete the following fields.","Rate","Enter an exchange rate to use for conversion calculations. From the drop-down list select one of the following:","If Float is selected, the rate is updated automatically from the Co. Currency tab (this tab is located in the Exchange Rates sub-node of the Standards &amp; Libraries node).","A Peg rate is locked at the company rate on the day the rate is set. (Only a Project Administrator can manually modify the Peg rate to a value other than the company peg rate.).","Enable Hedge","If you select this check box, the Hedge rate is used for conversion calculations. Otherwise, the Float rate will be used.","Rate","(Optional) If an amount is entered for the Rate, the hedge rate is used until the amount specified is reached (by spends) and then the system will revert back to the normal rate.","Amount","(Optional)","If Float is specified, the system will retrieve the rate, based on today's date and time.","If Peg Rate is specified, the field will be editable.","Comments","(Optional) Add any comments that might be necessary to explain the default currency.","Create a Shell Manually","74313.htm");
Page[46]=new Array("The Location Picker opens when you click the Select button for Location.","You can use this Location picker to select a shell instance. The multiple instance shells are listed under the single shell instances, which are represented as tabs. You can select a tab on which the shell is listed on the organization configuration.","When this picker is first opened, it displays the instance of single shell. You can select an instance by highlighting it and clicking the Select button. You can expand or hide the single shell instances, and you can use the toolbar to filter or search for a shell instance.","Location Picker Behavior","74768.htm");
Page[47]=new Array("You can create shells using the shell templates you created. You can also create shells by copying from existing shells. The Copy From Shell Template and Copy From Shell pages list all templates and shells, respectively, that are designated as Active, On-hold, or View-Only. You can verify the shell properties, make changes as necessary, update status, or activate as necessary. The status of shells created using this method is set to Active by default.","Note: As Shell Administrator, you can receive email notification of the successful creation of a shell. This notification can be set up in email notifications in uDesigner. Also, you can set your User Preferences to control whether you receive these notifications.","Creating a shell from a shell template or another shell, copies shell dashboards in the source template or shell to the destination shell. You can choose to copy any existing Custom Calendars from the template or from an existing shell. The system also copies the restrictions defined on the Record Properties tab of the Business Process Setup window from the selected shell or shell template to the new shell. For example, if the Record Properties tab is used to prevent users from downloading attachments, this restriction carries forward.","To create a shell from a shell template or existing shell:","Go to the Company Workspace tab and switch to Admin mode.","In the left Navigator, select Company Sponsored Shells, and then select the applicable type from the list of functional nodes.","From the Create menu, select From Template or From Shell.","In the Copy from Shell Template or Copy from Shell window, select the applicable template or shell.","You can use the Search and Find on Page options to look for a specific shell or template in the list.","In the Select Modules pane, select the modules to include in the new shell. Users and Groups are selected by default and copied along with the shell properties.","For more information about the modules available for selection in the type of shell you are cloning, see Shell Cloning Window Selections.","Note: When you copy a shell or template, you also copy existing setups in the modules you selected. If you select BP&nbsp;Setup when you copy a template, you will copy any existing business process setups, including those for any single-record business processes (SRBPs). SRBP setups and record data are copied along with everything else.","After you are done select the modules to include, click Done.","In the Details window, update the applicable tabs and fields.","Most properties are copied from the original template or shell with the following exceptions:","Number: On the General tab, enter a Number for the shell template. If automatic numbering is specified, this field is read-only.","Currency: On the Currency tab, specify the Shell Currency.","Image: On the Options tab, specify the Shell Image (optional).","When you finish completing the shell details, click Save.","When the confirmation message appears, click Yes to create the shell.","Create a Shell by Copying a Template or Shell","74314.htm");
Page[48]=new Array("If your company has set up Partner Companies, those companies can become eligible to be added to shells. When added to a shell, these companies become Member Companies, and their users can participate in shells with any permission level you set for them.","Note: The list of eligible Partner Companies is maintained on the Partner Companies page. To view the list of Partner Companies, go to the Company Workspace tab and switch to Admin mode; in the left Navigator, select User Administration, and then select Partner Companies.","Managing Member Companies","74347.htm");
Page[49]=new Array("Active Partner Companies and their associated users (users with a unique user name and status of Active or On Hold) can be added to shells and assigned permissions, just like Sponsor Company users.","To add a Member Company to a shell:","Go to the Company Workspace tab and switch to Admin mode.","In the left Navigator, select Company Sponsored Shells, select the [shell type], and open the [shell instance].","In the left Navigator, select Member Companies.","If no Member Companies have been assigned to the shell, click Add below the Add your first member company line; otherwise, click Add  @ .","From the list of Partner Companies, locate and select the applicable companies, and then click Add.","The company is added to the list of Member Companies.","Adding a Member Company to a Shell","74348.htm");
Page[50]=new Array("To view a Member Company profile:","Go to the Company Workspace tab and switch to Admin mode.","In the left Navigator, select Company Sponsored Shells, select the [shell type], and open the [shell instance].","In the left Navigator, select Member Companies.","From the list of Member Companies, locate and select a company.","The view-only pane on the right displays basic profile information for the selected company. This information is maintained by the Partner Company's administrator.","Viewing a Member Company Profile","74349.htm");
Page[51]=new Array("You can remove a Member Company from the shell's Member Companies list. When a Member Company is removed from a shell, users belonging to the Member Company will be automatically inactivated for that shell.","To remove a member company:","Go to the Company Workspace tab and switch to Admin mode.","In the left Navigator, select Company Sponsored Shells, select the [shell type], and open the [shell instance].","In the left Navigator, select Member Companies.","From the list of Member Companies, locate and select a company.","Click the Remove button.","When the Confirmation message appears, click Remove.","The system removes the selected company from the list and deactivates any users who have been added to the shell.","Removing a Member Company from a Shell","74350.htm");
Page[52]=new Array("The User Administration grouping node (Admin mode) lets you manage the following:","Partner Companies","Company Users","Partner Users","Groups","Task Reassignment","Active User Tasks","Inactive User Tasks","Integration Users","Access Control","This section discusses adding groups and users to shells, managing shell groups, audit log, and managing shell permission levels.","For more information about integration users, refer to the Unifier Integration Interface Guide.","Managing Shell Users and Groups","74351.htm");
Page[53]=new Array("After you have created a shell, you will need to add users to the list of approved shell users. Shell users can be from your own sponsor company, or from approved member companies.","When adding users from your company to the shell:","To add users from your own (Sponsor) company, the user must be either Active or On-Hold at the company level. When added, the user will automatically be Active for the shell.","Users who are inactive at the company level cannot be added to a shell.","When adding users from a Partner Company to the shell:","To add a user from a Partner Company, the company must first be added to the Member Companies list for the shell. The user must be either Active or On-Hold at the company level. When added, the user will automatically be Active for the shell.","The user does not need to be listed in the Partner Users log at the company level to be added to a company. If the user is listed in the Partner Users log, the user must be Active or On-Hold. If the user is not already in the Partner Users log, they will be automatically added to the list of Partner Users with a status of Active.","To add users to a shell:","Go to the Company Workspace tab and switch to Admin mode.","In the left Navigator, select Company Sponsored Shells, select the [shell type], and open the [shell instance].","In the left Navigator, select User Administration, and then select Users. The Users log opens. The log lists all users that are already part of the shell.","Click New. The User/Group Picker opens.","Note: If a User Attribute form has been imported, the shell user log will reflect the design of any designed Partner Log included in that form. For more information, see Importing User Attribute Form in the Unifier General Administration Guide.","Click the List Names from drop-down list at the top of the picker window and choose the company from which to add the new shell user.","This list includes your sponsor company plus any member companies that have been added to the shell. You can click the Member Companies node under the shell to view the list of available member companies.","Note: By default, new users will have a status of Active. You can change the status or other user detail information selecting the user from the list and clicking Open.","Select one or more users to add to the shell. You can press the Shift or Ctrl keys to select multiple users at once.","Click the Add button. You can continue to select and add names to the Selected Users portion of the picker window.","Click OK to add the users to the shell. The new users are listed in the Users log.","To add a user to a shell template:","Open the shell template.","In the left Navigator, select User Administration, and then select Users.","Follow the steps above to add a sponsor company or member company user to the template.","Add a User to a Shell","74352.htm");
Page[54]=new Array("You can edit a shell user's details. These procedures apply to sponsor company users and member company users.","To view or edit a shell user profile:","Go to the Company Workspace tab and switch to Admin mode.","In the left Navigator, select Company Sponsored Shells, select the [shell type], and open the [shell instance].","In the left Navigator, select User Administration, and then select Users. The Users log opens.","Select a user from the list and click Open. The Edit Shell User window opens. The window has the following tabs: General, Groups, Permissions and Custom.","Note: If a User Administration design has been imported by your Administrator, the content of this profile can vary.","In the General tab, review the contact information for the user as it will appear in the Shell Directory. By default, the shell address (as defined in the shell details) displays as the contact address. You can edit this information as necessary.","You can also modify the user's shell status:","Active: User is listed in Shell Directory, in User/Group Picker, User can log in and participate in the shell. New users are Active by default.","Inactive: If you deactivate a shell user, the user's name will not appear anywhere for selection on any shell-related functions. The user will not be able to access the shell. Inactivating a user at the shell level does not affect their status on other shells.","On-Hold: User can be added to a shell, or assigned as a participant in a business process workflow but cannot log in.","Select the Show user on the Shell Directory option, if you want the user's information to be viewable in the Shell Directory.","In the Groups tab, you can add or remove the shell users to a shell-level group the same way that you add company users to company groups. Click the Add button to add a group to the user's list, or select a group and click Remove to remove the user from the group.","In the Permissions tab, you can assign shell-related permissions to the user, by module and mode.","In the Custom tab, you can view available custom attributes that may have been added to the user form.","View or Edit a Shell User's Profile","74353.htm");
Page[55]=new Array("Groups are a way to aggregate users together so that adding new team members to the shell and assigning permissions can be done quickly and efficiently. For example, groups can be members of the same shell team, or they can be users who share the same access privileges, or both. At the company level, groups can span shells. At the shell level, all members of a group are members of a given shell. Different members of a shell may have different access to functionality, depending on their role on the shell.","For example, a Finance person might require access to cost modules and reports dealing with finances, but not RFIs or Transmittals and their associated reports. An Executive might require access to Summary financial information and not the cost BPs.","As users are added to a Group, they will inherit the Group's permissions. If they are in more than one group, the highest level of permissions granted in any group for a module will prevail.","When adding users to the group, you can choose eligible users from the sponsor company and any partner company users. The company short name will be listed in the User Picker window next to each user.","Company level groups cannot be copied into a shell.","To create a group:","Go to the Company Workspace tab and switch to Admin mode.","In the left Navigator, select Company Sponsored Shells, select the [shell type], and open the [shell instance].","In the left Navigator, select User Administration, and then select Groups. The Groups log opens.","Click New. The Groups window opens.","Complete the General tab:","Group Name: Enter a name for the group","Manager: Click Select and select a user from the User Picker window. This is the person who will be responsible for administering the group.","Description: Enter an optional description for the group.","Click the Members tab. This is where you add and manage group membership.","Click Add.","From the User/Group Picker, select the users to add to the group and click Add.","Click Ok.","Click the Permissions tab. In this tab, you manage group permission settings. If a user is a member of the group, the user will inherit all group permissions.","Granting permissions to the group is similar to granting permissions to individual users. Choose the shell-related permissions for the group that will apply to all members assigned to this group. Choose permissions by module and mode.","In the Custom tab, you can view available custom attributes that may have been added to the group form.","To edit group information:","Go to the Company Workspace tab and switch to Admin mode.","In the left Navigator, select Company Sponsored Shells, select the [shell type], and open the [shell instance].","In the left Navigator, select User Administration, and then select Groups. The Groups log opens.","Select a group and click Open, or double-click the selected group. The Groups window opens.","Make changes as necessary and click OK.","Groups and Audit Log","The Audit Log provides the following information about any action that has been taken on the Groups:","Date","Event","Action","Field","Old Value","New Value","User Name","Proxy User","Attachment","To access the Audit Log for the Groups functional node:","Go to the shell tab and switch to Admin mode.","In the left Navigator, select User Administration, and then select Groups.","In the Groups log, select a group (select a record).","From the toolbar, click View, and then select Audit Log to open the Audit Log.","The Audit Log captures all the actions that have taken place on that selected record.","When you (the Admin) add a user to a group by using a user data picker, the user's name will be seen in the Audit Log. The Action column of the Audit Log will include the nature of the action (Member Added), indicating that a user was added by way of the &lt;data picker label&gt; user data picker. The Old Value column will remain empty (null), and the New Value column will include the name of the user that was added, followed by a colon (:), followed by the name of the company that the user belongs to &lt;firstname lastname:Company Name&gt;.","Create and Manage Shell Groups","74354.htm");
Page[56]=new Array("After you have created a shell, assign permissions to the people who need to access the shell. You can use Access Control to grant multiple Users or Groups permission simultaneously, rather than editing the properties for each User or Group individually.","To view or change a shell's access control:","Do either of the following:","Got to the project/shell tab and switch to Admin mode, and select Access Control in the left Navigator.","Go to the Company Workspace tab and switch to Admin mode. In the left Navigator, select Company Sponsored Shells, open the [shell type], open the [shell instance], and then select Access Control in the left Navigator.","The system displays a copy of the Navigator menu in the right pane of the window. In this right pane, you may click different modules of the Navigator menu to set permissions for those functions.","Grant Shell User Permissions through Shell Access Control","74355.htm");
Page[57]=new Array("You can generate and print an Access Information summary of user and group access (permission settings). The report will display all user and group permissions.","To generate the Access Information report:","Go to the Company Workspace tab and switch to Admin mode.","In the left Navigator, select Company Sponsored Shells, open the [shell type], and open the [shell instance].","In the left Navigator, select Access Control.","Click the Access Information button. The Access Information window opens. It may take several moments to generate the report.","To print the Access Information report:","Generate the Access Information report.","Click the Print button. (When the report is complete, the Print button becomes available.)","Generate and Print Access Information Report","74356.htm");
Page[58]=new Array("An Integration interface must be created for shell creation to work via CSV file.","You can create shells by importing a shell template as a CSV file. The status of shells created using this method defaults to the value provided by the user in the import file; otherwise, it is set as Active.","To create shells using an imported CSV file:","Go to the Company Workspace tab and switch to Admin mode.","In the left Navigator, select Company Sponsored Shells, and then select a shell type.","From the toolbar, click Actions, select Export Template, and then select Shell Creation Template.","Complete the shell creation template CSV file. Some hints:","The shell location must have a leading /. Be sure to use the true shell name as entered in the Shell Manager configuration.","Shell statuses are Active&#8212;which includes On-hold and View-Only&#8212;or Inactive. Use initial capitalization.","Administrators must be valid users. You might enter the user's full name (for example, Henry James) or the system user name (for example, hjames) depending on the configuration.","If using currency override, be sure the currency is active in Exchange rates and the CSV file contains a valid currency code.","Note: You cannot modify the BP Data Picker alone if it has an associated Line Item Data Picker value. You must provide both the BP Data Picker value and BP Line Item Data Picker value to modify any one of them.","From the toolbar, click Actions, select Import, and then select From Template.","Select the modules to include in the shell.","Select the template from the listed templates and click OK.","Browse for the CSV file and open it.","Click OK.","Reasons for a Shell Creation business process CSV failing to import","Any incorrect rows will cause the CSV upload to fail and an error message will display the incorrect row number.","Incorrect shell location used (this has to be set up before importing a CSV).","Invalid shell name or number.","The location on the imported CSV file is not a valid parent location.","The sub-shell of the type that you are importing was not configured under the parent location specified.","Currency override used an invalid currency code or the currency was not active in Exchange rates.","Notes:","If shell creation fails, the user who attempted to import the CSV will get an email notification of the import failure.","When creating a shell through CSV, the Document Manager Attribute Form that is associated with the template, or shell instance, will be copied over to the newly created shell.","Create Shells Using an Imported CSV File","74315.htm");
Page[59]=new Array("Before you begin, review these conditions for successful shell creation from the Shell Creation business process (BP):","Shell Creation BP must be designed and deployed in uDesigner and configured and set up in Unifier","Shell template must be created","Shell hierarchies must be correctly configured in Shell Manager","Shell number must be unique","Shell override currency, if it is to be used, must be active in Exchange Rates","The Shell Creation BP can synchronously auto-create a multiple-instance CBS or generic shell anywhere in or across a shell hierarchy. The BP uses a shell location picker to assign where the shell will reside in the hierarchy and a shell picker to select a template. This means shell organization must be correctly configured in the Shell Manager and the shell template must be created. Shells created using this method are set to Active by default if the shell status is not specified when the shell is created.","The Shell Creation BP designer can define the business process as company level or shell level. The designer may use workflow to support review and approval processes, or elect to design the BP without workflow. At run time, the system passes select information captured in the BP form to the newly created shell, thus avoiding redundant data entry. Reaching terminal status, as defined in uDesigner, triggers the synchronous shell creation process. If there is a planning item picker on the Shell Creation BP record or line item, the system will link the planning item to the new shell. If the Shell Creation BP includes a Shell Data Picker, the picker is populated and any auto-population and reverse-auto-population occurs. If the source contains a Line Item Data Picker and the Shell Attribute form of the destination contains the same Line Item Data Picker, the value is copied during creation; if the destination has any Query conditions that are not met, the value of the Line Item Data Picker is not copied. ","Notification","The system will send an email notification upon successful shell auto-creation, provided notification is set up in business process setup, the system has a valid email address for anyone selected to receive notification, and those selected subscribe to email notification in user preferences. If auto-creation fails, the system will immediately send an alert to those selected to receive notification.","There are two types of Shell Creation BPs: simple and line item.","Simple-type","The simple-type Shell Creation BP creates one shell per record. Reaching a terminal record status triggers the synchronous shell auto-creation process. The BP designer has the option to either define workflow or not. The designer can define integration; in Unifier, you can obtain the business process import template from the business process log.","It is important to note that the CSV import template must be correctly completed or the system will reject the CSV file in its entirety and not create any shells. When the system rejects a CSV file, it creates an error file that tells you which line item is in error and why it is in error. To ensure a successful upload of the Shell Creation BP CSV file, retain the column headings in the same order as exported, and complete all required fields.","Line Item-type","The line item-type Shell Creation BP creates a shell for each line item. Use the upper form to create the parent shell and each line item to create a child shell. Auto-creation happens when:","Record terminal status is reached","Line item status is met","A line item passes validation","At run time, when the system processes a line item-type Shell Creation BP record, it will create a shell from each line item that passes validation. For example, if there are 10 line items in the shell creation record, but only five pass validation, the system will create five shells. Shell creation line items can be consolidated, provided consolidation is configured.","CSV Import or RESTful Services (Create Shell)","When you create a shell instance by using CSV import or RESTful Services (Create Shell), the system copies into the created shell:","The View Forms tab information from the selected shell template.","The forms added in the shell template, along with users and groups who are part of the viewers list.","Create Shells with Shell Creation Business Process","74325.htm");
Page[60]=new Array("The Integration tab in shell template attribute window is used to map multiple P6 projects with the respective Unifier shell. ","Note: The mapping is only used for the Activity Sheet.","The Integration tab in shell template attribute window has the following options:","Add","Remove","Apply","OK","Cancel","The Integration tab in shell template attribute window has the following columns:","Project ID","An alphanumeric field that can be populated using Add. The Project ID cannot be modified or removed from this tab.","Project Name","Schedule Type","While you create the mapping, you are required to enter only the Project ID (marked as a required field). Unifier populates the other columns (Project Name and Schedule Type) when you run project synchronization.","When you add projects, using this tab, to create an Activity Sheet:","You cannot modify, or remove, a Project ID.","If the Link Multiple Projects option is not disabled, the system uses synchronization in multiple P6 projects.","If the user decides to change the existing mapping setup (Activity Sheet), Unifier replaces the existing Activity Sheet with P6 projects after the next synchronization.","If a user tries to remove (Remove) a project that is mapped to an Activity Sheet, Unifier cannot process the change because the schedule for the project is present in the Activity Sheet.","You can integrate multiple P6 projects into one Unifier project.","When you integrate (Project ID mapping) a P6 project into a Unifier project through the General tab of the Shell Attribute Form, Unifier updates the Schedule Type field in General tab. The General tab is mostly used for one-to-one integration (one P6 project mapped to one Unifier project).","When you integrate (Project ID mapping) multiple P6 projects into one Unifier project through the Integration tab of the Shell Attribute Form, Unifier does not update the Schedule Type field in the General tab. In the Integration tab, the Schedule Type column is updated. The Integration tab is mostly used for many-to-one integration (many P6 projects mapped to one Unifier project).","Integration Tab","10292199.htm");
Page[61]=new Array("Updating a CBS type shell","In a CBS type shell, when a non-EVM user opens the shell details (available through the Details option in the My Dashboard list), the user can click the Integration tab to add only one P6-related project (click the plus sign symbol: Add Project ID). If there is an Activity Sheet available and the user decides to add a schedule for the project, Unifier will display a message that the existing schedule in the Activity Sheet will be replaced with the added schedule for the project. If the user selects Yes, the new schedule will be included in the Integration tab and the Add External Project ID option becomes disabled.","Use the gear menu ( @ ) to delete the added, or existing, schedule for the project.","After a non-EVM user adds a new schedule for the project and clicks Save, the shell dashboard page opens and displays the new schedule project information in the Details block. This enables the non-EVM user to proceed with data synchronization.","To synchronize data:","In the left Navigator, select EVM, and then select Activity Sheet. The Activity Sheets log opens.","Click the Get Data icon. The Get Data window opens.","Click inside the Project field and add the schedule for the project.","From the Activity Sheets log (on the right panel), click the History tab, and click the Refresh icon.","From the Activity Sheets log (on the left panel), click the activity sheet to open it.","The Activity Sheet log lists all the activities for the added schedule for the project.","Similar to an EVM user, a non-EVM user can use the following tabs of the Activity Sheet log (on the right panel) to see more information:","General","Assignments","Audit Log","The non-EVM user can click the Assignments tab, click the gear menu of resource, and perform the following:","View Assignment Spread","Assign CBS","Assign Rate Source","The non-EVM user can click an activity (in the Activity Sheet log) and select the following options:","View Activity Spread","Assign CBS","The non-EVM user cannot add a column to the WBS Sheet (WBS Sheet sub-node, from the left Navigator). The same limitation (inability to add column) applies to the Cost Sheet (in the left Navigator, select Cost Manager, and then select Cost Sheet).","Creating a CBS type shell","When creating a new CBS type shell (go to the Company Workspace tab and switch to Admin mode; in the left Navigator, select Company Sponsored Shells, and then select Projects), a non-EVM user can use the Integration tab to add a single source project ID (click Add).","CBS Type Shell for a Non-EVM User","10293922.htm");
Page[62]=new Array("The shell Integration tab enables you to link to a single or multiple Oracle Primavera Cloud projects.","Users with access to the EVM feature can add multiple Oracle Primavera Cloud projects to be linked to a Unifier project.","Users without access to the EVM feature will be able to link to a single Oracle Primavera Cloud project using the Integration tab.","You can add the Oracle Primavera Cloud Project ID using the Add option in the Integration tab. All validations (regarding valid project ID, duplicate Project ID, and so on) will take place when you add a Project ID in the Integration tab. The Project Name and Schedule Type columns will be read-only, and the values will be populated after the Oracle Primavera Cloud project is synchronized with the Unifier project.","The Project Name value will populate with the name of the Oracle Primavera Cloud project, and the Schedule Type will be populated with the default value: Duration. The following other fields (in shell details) are populated if the shell is synchronized with the Oracle Primavera Cloud project, using the Project Number from the Shell Attribute Form:","Field","Description","Shell Status","Populated with a valid status value. It can be: Active.","Note: The Shell Status will be populated or updated only when the shell instance is created by using a new out-of-the-box (OOTB) synchronization from Gateway (Send Activity data from Primavera Cloud to Unifier). When a user gets activity data using the Get Data option in the Activity Sheets log, the value of the Shell Status will not be updated.","Project Start Date","The start date of the project, received from the Oracle Primavera Cloud project. This data element in the Shell Attribute Form will get updated only when a project is created from the Gateway.","Integrated with","This data element in the Shell Attribute Form will be populated as: Primavera Cloud.","Note: For projects that are integrated with Oracle Primavera Cloud using the shell Integration tab, the Shell Status and the Project Start Date will not be updated.","Project Mappings in Gateway","Oracle Primavera Cloud","Gateway","Unifier","projectName","Name","ProjectName","dataDate","DataDate","Data_date","projectCode","Id","ProjectNumber","Start Date","DataDate","uuu_project_start_date","status","Status","uuu_shell_status","The plus (+) option will be disabled after you add the Oracle Primavera Cloud Project ID, and the data from Oracle Primavera Cloud project will be synchronized with the Unifier project in case the user does not have an EVM license.","A user with an EVM license will be able to add multiple Oracle Primavera Cloud Project IDs, and the data from multiple Oracle Primavera Cloud projects can be synchronized with the Unifier project. Furthermore, the Schedule Type field will be shown as 'Duration' for all the Oracle Primavera Cloud projects in the Integration tab of shell details. In the shell details General tab, the field Integrated with is populated as: Oracle Primavera Cloud.","CBS Type Shell for an EVM User","10293923.htm");
Page[63]=new Array("You can verify the shell properties, make changes as necessary, update the status, or activate as necessary. Oracle recommends that you keep the information up to date to reflect the ongoing status and progress of the shell.","You can also modify shell information in a shell type template and then update one or more existing shells by &quot;pushing&quot; the information from the template to the shells (see Updating Shells).","To open a shell:","Click the tab for the shell. The shell landing page opens.","To edit an existing shell:","Go to the Company Workspace tab and switch to Admin mode.","In the left Navigator, select Company Sponsored Shells, select the [shell type], and double-click the [shell instance] in the log. The corresponding dashboard opens.","Click the more menu option (the three horizontal dots icon next to My Dashboard) to open the drop-down list, and click Details to open the shell Details window.","Modify the shell information as necessary.","Depending on your permissions, you can modify any of the shell properties any time during the shell duration, except for the shell currency. (After a shell is set up, the shell currency is locked.) For example, if you want to assign newly defined global views to the project/shell so that they are available to all users, go to the System Information section on the General tab, click Select  @ next to the Shell Templates field, select the applicable template, and click Select.","The Location picker lets you change the location of a shell and is accessible when you set up a shell or modify the shell details. See Location Picker Behavior for details.","Use the Location Picker to select where the shell instance will reside. In the Location picker:","Find searches the current level","Open shows the next level of shells","Select completes the action","Location Picker will display breadcrumbs through the hierarchy","Work systematically from the top of the hierarchy to the bottom","There must be an instance of a single shell to connect to","Note: You can use the Location picker to reorganize the shell hierarchy. The shell can move across tabs, or laterally along the hierarchy. When you move a shell instance, all the shell data moves with the shell. If an auto-populated business process moves with the shell instance, the auto-populated data moves with the business process. Data for the business process will be collected from the new shell location. In addition, if a child Shell Attribute Form or a single-record BP in a child shell has been designed with linked elements, the child shell attribute data and BP data will be automatically changed to reflect the new parent shell's current attribute values.","Click Save to save your changes and exit the Details window.","To deactivate an existing shell:","Go to the Company Workspace tab and switch to Admin mode.","In the left Navigator, select Company Sponsored Shells, select the shell instance, and double-click the applicable shell in the log. The shell window opens.","Click the more menu option (the three horizontal dots icon next to My Dashboard) to open the drop-down list and click Details to open the shell Details window.","On the General tab, go to the Status field and select Inactive.","Note: If you deactivate a single instance shell, you cannot access that shell again to activate it. The shell will persist, but not be accessible.","Click Save to save your changes and exit the Details window.","To copy the customized user attributes from the company-level directory:","You can copy (bulk) any customized user attributes from the company-level directory and paste them into the shell.","Go to the Company Workspace tab and switch to Admin mode.","In the left Navigator, select Company Sponsored Shells, and then select Projects to open the Projects log.","From the toolbar, click Actions, select Export, select Export Users, and select one of the following options:","All Shells","Selected Shells","Follow the prompts.","After your selection, the system will download (bulk) an Excel sheet (CSV file) with all the existing users. To copy the company-level directory values under the Copy Attributes column for the shell, click Yes.","If you do not click Yes, no values will be copied from the company-level directory.","To complete the importing of the values:","From the toolbar, click Actions, select Import, and then select Import Users.","Use the file selection window to select the updated CSV file.","Proceed with importing the values by uploading the Excel sheet (CSV file). The system will update (bulk) the user attributes data elements and their values.","When you create a project/shell using the Create option and Manual suboption, you must either add users manually or through a CSV file. After creating the project/shell, you can import the information. If you add a user manually, the Copy Attributes from Company Workspace option (which is available in the General tab the Users or Groups sub-node of the User Administration node for the [shell]) lets you import the values in the Copy Attributes column of the CSV file.","If you copy user attributes values from a shell template, the shell template attributes for the Users are also copied over.","By default, the system adds the project administrator to any newly created, or copied, shell. In this scenario, the additional attributes will not be copied.","Managing Shells","74327.htm");
Page[64]=new Array("As a company administrator or shell administrator, you can work with the following features:","Cash Flow","Cost Sheet","Schedule of Values (SOV)","Funding Sheet","Commitment Funding Sheet","Managing Cash Flow in Shell Templates","10315673.htm");
Page[65]=new Array("Cash flow curves are graphical presentations of the expenditures or spends. Cash flow curves enable you to:","Pull data from cost sheets, business process records, or schedule sheets","Record cash flow history by way of using snapshots","Generate cash flow curve reports"," ","The cash flow management steps (Baseline, Actuals or Spends, and Forecast) can be displayed as Cash flow curves in the system.","The following lists the cash flow curves types:","Detail Curves: Cost per period.","Rollup Curves: Each period includes sum of all previous periods. ","Summary Curves: Each project/shell cash flow has a system defined project/shell summary curve.","Cash Flow Curves and Data Sources, Types, Distribution Profiles, Detail curve templates, and Roll up curve templates Options","A cash flow curve requires a data source which your administrator can create in the Standards &amp; Libraries node.","Data Sources","Used to identify cash flow curves and Roll up data to the company worksheets. Multiple data sources can be defined per curve type, depending upon business needs. Example: &#8220;Original baseline and Current baseline&#8221; data sources can be defined for type &#8220;Baseline&#8221;. For roll ups, curves are summarized across data sources.","Curve Types","Used with pre-defined categories of cash flow curves for:","Baseline","Forecast","Actual (or Spends)","Portfolio Budget","Derived","Custom","Each curve type has its own logic to address different business requirements.","Distribution Profiles","Used to distribute data automatically in the cash flow worksheet.","Detail curve templates","Cash flow curves can be created either manually or from a template.","Cash flow templates are created in Company Workspace from project templates and are used to create cash flow worksheets.","Roll up curve templates","Used to create curves that roll up cash flow data from projects/shells.","Cash Flow Curves","10298241.htm");
Page[66]=new Array("The following explains each of the cash flow curves types in detail.","Detail Curves","The Detail Curves are referred to a family of curves that can be defined at the project/shell level, or at the company level.","Each curve, within the family, is based on a data source (one curve per unique data source).","A cash flow curve of type Detail Curves is a curve that is used to monitor the movement of cash at different detail levels in a project/shell.","The cash flow (Detail Curves) levels in a project/shell are:","Project/Shell","Commitment","CBS","Summary CBS","Note: If you select Summary CBS, the system sets the Summary CBS Level to 1 by default. You can select another level, based on what is available in the Cost Sheet.","As mentioned earlier, you can specify the following cash flow types for each detail level in a project.","Note: The first three cash flow types in the list below are the three most common, and important, standard cash flow types.","Baseline","Depicts the project budget that is spread over the duration of the project. Users can define multiple baselines for a project.","Actuals (Spends)","Depicts the expenditures (spends) that have actually incurred.","Forecast","Depicts the projection of the future costs, based on current expenditures (Actuals or Spends).","Portfolio Budget","Depicts the Baseline curve, or Forecast curve, used for portfolio optimization scenarios in the Portfolio Manager.","Derived","Depicts the Baseline curve, or Forecast curve, used for portfolio optimization scenarios in the Portfolio Manager.","The Derived curve is used to convert the sources currencies to a currency used by the Portfolio Budget curve.","Custom","Depicts cost data other than Baseline, Actuals, and so on.","The Custom curves can include any other cost data that you want to view graphically.","Roll up Cashflow Curve (Rollup Curves)","A Roll up Cashflow curve includes a group of curves with Active status summarized by data source across all projects/shells in a company.","A Roll up Cashflow curve facilitates the aggregation of cash flow data source (from projects/shells and CBS) to the company cash flow worksheets.","Note: A Roll up Cashflow curve can only be created at company levels.","You can compare curves side-by-side, in the cash flow worksheet, to view cash flow distribution over time.","Summary Curves or Summary Cash Flow Curves","A summary cash flow curve is designed to present a consolidated view of cash flows, and each project/shell cash flow has a system-defined project/shell summary curve. A summary cash flow curve:","Uses the detail cash flow curves to compare the movement of curves against the previous snapshots, and in the process show differences among curves with respect to time and schedule.","Displays Variance and Forecast analyses, similar to the detail cash flow curves.","Cash Flow Curves Types","10298242.htm");
Page[67]=new Array("There are two types of cash flow templates:","Company level templates: Created in the Company Workspace (Admin mode).","Project or shell level templates: Created in a project/shell.","When creating curves from templates, only the properties of the curve are copied; data and permissions are not copied. ","You can pre-set curve options, except, for example, the business process records and cost sheet columns, which are set at run time.","Go to the Company Workspace tab and switch to Admin mode.","In the left Navigator, select Templates, select Shells, select Projects, open the applicable [project], select Cost Manager, and then select Cash Flow.","From the toolbar, click +Create.","Enter information in the General tab of the New Cash Flow Worksheet window.","For more details, see Project or Shell Cash Flow Properties (General Pane).","Creating a Project or Shell Cash Flow Curve Template","10315675.htm");
Page[68]=new Array("The following explains the fields under the General block. The next topic explains the fields under the General block: More Options.","Note: The red asterisk by a field indicates that the field is required.","Under the General block, you can manage the following cash flow properties:","Name: Enter a unique name for the curve in the Name field.","Description: (Optional) Enter a brief description in the Description field.","Detail Level: Select a detail level option from the Detail Level box. The selected option determines the level-of-data the cash flow curves will display. Choose one:","Project/Shell: Choose this to track cash flow for the entire project/shell. For example, Baseline and Actuals curves might chart the budget and cash outlay across the entire project.","Summary CBS: Choose this option to track cash flow by summary CBS codes. To select this option, the cost sheet used in the project/shell must be a tree structure. If you select this option, the system sets the Summary CBS Level to 1 by default. You can select another level, based on what is available in the Cost Sheet.","CBS: Choose this to track cash flow within a project/shell at the CBS code level. This lets you track cash flow across the project for specific CBS codes, or for all CBS codes.","Business Process (Commitments): Choose this option to track cash flow associated with a particular commitment record and its line items. This includes, for example, a base contract and optionally their referenced Change Commits. Select a business process.","Items listed are the project/shell level business processes of type &quot;Base Commit.&quot; When creating a template, choose the one that is likely to be used in the projects/shells the template will be used in. When creating the curve in a project/shell from the template, you may need to verify that the business process chosen here is active in the project/shell or pick another from the list.","Select Base Commit Record: This is selectable in a project/shell, but not in a template. Click the Select button. Choose the commitment record from the list of available records in the project/shell. Each commitment record can be selected only once.","You can set up the automatic creation of a cash flow curve when a Base Commit record is created and completed or reaches a particular step. This is done in the BP Setup for the business process.","Select your reference element: The worksheet will display the reference elements. By default, the Record No. will display as the Number. You can click the drop-down list and choose an element to display for the Name field (Contract No., Contract Terms, or Title).","Rollup cashflow data to company/program?","Yes: The curve will roll up to company cash flow the next time the curves are refreshed.","No: The curve will not roll up to company cash flow the next time the curves are refreshed.","Time Scale: If you edit the time scale, the period close settings will be reset, and you will need to enter new ones for the new time scale.","The time scale determines the scale and format in which the data is shown on the cash flow worksheet.","By Month or Year: The default is Month.","Format: Choose the format that you want the month and year displayed on the graphs. The default is M YYYY.","To save your changes, click Save &amp; Close. You can continue adding curves that will make up the detail curves. To discard your changes, or close the Cash Flow Properties window, click Cancel.","Project or Shell Cash Flow Properties (General Pane)","10298278.htm");
Page[69]=new Array("The following explains the fields under the General block: More Options.","Note: The red asterisk next to a field box indicates that the field is a required field. You will not be able to save your changes without entering a value in that field.","When you click More Options, the More Options window opens which contains the following tabs on the left pane. Each tab provides additional options for the cash flow which are described below.","Period Close Settings tab","This tab lets you set the option: Enable auto snapshot","The Period Close Settings tab lets you choose some automatic settings that will happen at the end of each period (month or year, as chosen in the Time Scale field).","When you select the Enable auto snapshot option, you determine when the system must take an automatic snapshot of the data. ","If you selected Month for Time Scale:","You can choose a specific date each month to automatically take a snapshot, or you can specify a particular day (such as the first Monday of the month). ","If you selected Year for Time Scale:","You can specify the exact date to take the snapshot each year (or a particular day such as the first Monday of January).","After an auto snapshot is taken, the curve will be refreshed immediately. Actuals (Spends) will resume after the auto snapshot is complete.","Examples of using the options: Enable auto snapshot, Cutoff spends, and Resume Spends","Company A wants to take an auto snapshot of its cash flow data every time period. Company A would choose a particular date (such as the 3rd of the month for Month, or January 3 for Year). The system would take the snapshot and refresh the cash flow curve. They do not select the Cut off spends option.","Company B regularly reviews and revises forecast projections during fixed days every time period. Because it does not want new Spends records to hit the cash flow worksheet during this period, they choose the Cut off spends option. This option requires that you select the Enable auto snapshot first. The company sets this option so that an auto snapshot is taken of their changes just before spends are resumed. Snapshots can then be used for comparison of previous forecasts with the current month. Any spends records that came in during the forecast period are not lost; the Resume Spends option determines whether those spends records will be included in the previous month's cash flow or pushed to the next time period.","Cutoff spends","This option is applicable for Actuals (Spends) type curves.","Selecting this option will temporarily stop spends business processes (for example, Invoices) from hitting the cash flow worksheet during analysis periods.","The Enable auto snapshot option must be selected first. Actuals (Spends) will resume after the auto snapshot is complete. ","If no value is specified, the last date of the current month is presumed.","The system marks the time of the Cutoff spends date at the beginning of the day. For example, on June 30, the data can become locked at the beginning of the day and not at the end of the day, therefore, preventing the user from making any last minute changes before the start of the next month.","Apply Spends to","The selections under this period close settings option let you apply spends to an effective date or before/after a Cutoff spends date.","By default, Cutoff spends will resume immediately after an auto-snapshot is taken.","Note: If there is a gap between the Cutoff spends date and the Enable auto snapshot date, any spends that came during that period are not lost.","For example, if a Cutoff spends date is October 26 and the Enable auto snapshot on date is November 2, (and the Time Scale is monthly) that defines the freeze period. Any spends that come in on October 27, 28, 29, 30, 31, and November 1 will not hit the cash flow sheet during the freeze period. After the Enable auto snapshot on date is reached, spends will be included back in October for spends (Oct 27-31) or November for spends (Nov 1-2), and the effective date will be retained.","The same month/year as the effective date","The text of the options under Apply Spends to change based on the selection that you made for the Time Scale (By: Month or By: Year).","If this option is chosen, spends data is included back in the current period after the freeze period is lifted. The final output is similar to the case where no period close settings are applied because the effective date is retained. Spends for Oct 26-31 will be included in October and Nov. 1-2 spends will be included for November.","For example, if the cutoff date is the 26th of October and the snapshot date is the 2nd of November, the freeze period is Oct 26 - Nov 2. Any spends that come in on Oct 27, 28, 29, 30, 31 and Nov 1 and 2 will not show on the cash flow sheet during the freeze period. After the auto snapshot date is reached, these spends will be included back in either Oct for spends (Oct 27-31) or Nov for spends (Nov 1-2) and the effective date will be retained.","The next month/year if after the cutoff date","After the freeze period is lifted, spends data from the cutoff date to the end of the month will be included in the next month/year. Spends for Oct 26-31 will be included in November and Nov 1-2 spends will be included for November.","The previous month/year if on or before the cutoff date","After the freeze period is lifted, spends data from the start of the month up to the cutoff date will be included in the previous month/year. Spends for Oct 26-31 will be included in September and Nov 1-2 spends will be included for November.","During the Cutoff spends period, even if automatic refresh of the curve occurs as set in the Schedule tab, spends data will not hit the cash flow sheet until spends are resumed again.","Summary tab","This tab lets you automatically add the selected curve to a selected summary curve. This tab contains a list of available summary curves to choose from.","Decimal Options tab","This tab provides two options:","Decimal Options: To specify the number of decimal places supported for amounts throughout the cash flow, select this option.","Use Currency Decimal Precision: To ensure that the cash flow preserves the number of decimals used within areas such as Base Currency, Project Currency, and Transaction Currency, select this option.","Project or Shell Cash Flow Properties (General Pane - More Options)","10298279.htm");
Page[70]=new Array("As shown in the screen capture below, the Cash Flow Properties window Curves pane contains the Curves drop-down list, which lets you add or remove curves.","After you add a curve, the system adds an interactive image representation of the added curve to the Curves pane.","The following explains the elements of the Curves pane.","Curves","Click the Curves drop-down list to open a list that contains the list of available curves.","These curves, or data sources, have been defined by the Administrator in the Standards &amp; Libraries module. (Go to the Company Workspace tab and switch to Admin mode; in the left Navigator, select Standards &amp; Libraries, then select Cash Flow, and then select Data Sources.)","The Cashflow Datasources window, where the Administrator edits the list of data sources, contains a list of data sources that are categorized by name, curve type and color. For example, the name of a data source can be Actuals which is assigned to a Spends curve type, or the name of a data source can be Original Budget which is assigned to a Portfolio Budget curve type.","Different names can be assigned to on curve type. That is to state, depending on the curve type, the curve setup options will differ. The admin can define one curve for every data source.","Refer to the Unifier Administration Help for details.","Note: The Portfolio Budget curve is linked to scenarios in the Portfolio Manager. The Project Manager must create this curve. After it is created, the curve shows the initial budget projections.","The list of available curves include:","Baseline curve","Actual (Spends) curve","Forecast curve","Derived curve","Portfolio Budget curve","Custom curve","When you open a curve, you can view the data in the transaction currency, if the transaction currency is different than the project currency.","If a curve, or data source, is available within the Curves pane (interactive image representation of the added curve), double-click anywhere on the image to open the curve window. In this window, you can see the curve type information as well as information related to the curve, as described in the following table. If you make any changes, click Update to save your changes; otherwise, click Cancel to discard your changes or close the window.","Curve Type","Description","Granularity","Single distribution of sum of Base Commit and all changes","By individual record (base commit and all changes separately)","By line items within each individual record","Distribution Method","Manual entry of values for each cash flow period","Manual dates and manual profile selection","Business process dates and default profile selection","Select change orders you want to include","List of Business Processes and corresponding statuses are presented. Manual entry of values for each cash flow period","Manual dates and manual profile selection","Business process dates and default profile selection","You have the option to add methods to the distribution method or remove methods from the distribution method.","Variance","Your options are Inflow or Outflow. See the following topics for details about Variance values.","To add a curve:","Click the Curves drop-down list.","Select a data source, or curve, from the list (for example, select Forecast) to open the data source window.","Enter values in the fields and click Add, when finished.","Project or Shell Cash Flow Properties (Curves Pane)","10298277.htm");
Page[71]=new Array("This topic provides details about adding curves to the cash flow.","You can construct cash flow curves by:","Project/Shell","Summary CBS (Summary CBS Code) If you select this option, the system sets the Summary CBS Level to 1 by default. You can select another level, based on what is available in the Cost Sheet.","CBS (CBS Code)","Commitment (a specific commitment BP and record)","The following topics explains the process for adding the following curves to a cash flow worksheet, for comparison:","Baseline curve","Forecast curve","Notes: The procedures that follow:","Assume that you have created your data sources.","Describe how to add a curve type to an existing cash flow (using the Detail Level column of the Cash Flow log for the project/shell) that does not have a curve.","Project or Shell Cash Flow Properties Curves Pane and Curve Types","10298287.htm");
Page[72]=new Array("Add a Baseline curve for cash flow template by:","Project/Shell","Summary CBS or CBS","Note: The following procedures assume that you have created your data sources.","Baseline Curve","10315688.htm");
Page[73]=new Array("To add a Baseline curve for cash flow template:","Go to your shell template and switch to Admin mode.","In the left Navigator, select Cost Manager, and then select Cash Flow.","From the toolbar, click + Create.","In the General pane of the Cash Flow Properties window (or the Cash Flow Properties worksheet), select the Project/Shell option from the Detail Level drop-down list. ","You have the option to filter by either CBS Codes or Summary CBS Codes.","In the Curves pane of the Cash Flow Properties window Curves pane, select Baseline from the Curves drop-down list.","In the Baseline window, complete the fields using the information in the tables below.","When finished click Save &amp; Close to save your work and open the cash flow worksheet that you have added.","Set up the following curve properties in the template:","Property","Description","Cost","Note: You can choose the cost column when creating a curve in a project/shell but not in templates.","Select one of the following options:","Manual: Lets you manually enter amounts for each period. This option will be available if you have chosen Manual in the Distribution drop-down list.","You can enter cost information in the Total field on the worksheet.","Distribute amount from Cost Sheet Column: Lets you use the default distribution profile. This option will be available if you have chosen Auto by default profile in the Distribution drop-down list.","Examples of column:","Approved Budget Revisions, Approved Commitment Changes, Approved Contracts, and so forth.","Schedule","Lets you define the range of dates (what dates to start the curve and end the curve) to use to plot the cash flow data.","Note: If you choose to take dates from the schedule sheet elements, the system uses the Master schedule sheet for the project/shell.","Select one of the following options for each date:","Manual: Select this option to manually enter the date in the cash flow worksheet.","Use dates from Schedule Sheet: Select this option to select a schedule sheet (from the Select schedule sheet drop-down). You can populate the From and To dates according to the schedules available (Example: Actual Start Date and Actual Finish Date) pertinent to the schedule sheet that you have selected for the Select schedule sheet drop-down. If these dates are changed on the selected schedule sheet, then the changes will be reflected on cash flow after the next refresh of the curves.","Use dates from Activity Sheet: Lets you select an activity sheet (from the Select Activity Sheet window). After you select using dates from an activity sheet, you must determine the values for the Project Type, From Date, and To Date fields.","Project Type","If you set Schedule to Use dates from Activity Sheet, select the project as either Baseline or Current.","From Date","If you set Schedule to Use dates from Activity Sheet, select the start date to use for plotting the cash flow curve.","To Date","If you set Schedule to Use dates from Activity Sheet, select the end date to use for plotting the cash flow curve.","Distribution","Distribution profiles are used to distribute data automatically in the cash flow worksheet. This option lets you select a distribution profile to use as the default distribution profile for the curve.","Select one of the following options for how to distribute the data automatically between cash flow time periods: ","Manual: Lets you enter values into each field manually.","Company Level: Lets you select a pre-determined method for distribution. Your options are:","Linear","S curve","Front Loaded","Back Loaded","Project Level: Lets you select from a list of available project levels.","The distribution profiles are defined in the:","Go to the Company Workspace tab and switch to Admin mode. In the left Navigator, select Standards &amp; Libraries, select Cash Flow, and then select Distribution Profiles.","or ","Go to the shell tab and switch to User mode. In the left Navigator, select Cost Manager, and then select Cash Flow. From the toolbar, click Actions, and then select Manage Distribution Profiles.","The default profile is used for the initial display and calculations in the cash flow worksheet. You can change the distribution profile from the worksheet. If you do this, the default profile will automatically update to reflect the current selection.","When you build a Baseline curve for individual line items, the Schedule of Value (SOV) type influences the distribution options. ","If the SOV lists individual line items by CBS, you can distribute cost for each line item individually.","If the SOV groups line items, you cannot distribute cost for each line item individually.","Adding a Baseline Curve Template for Cash Flows","10315677.htm");
Page[74]=new Array("To add a template for a Baseline curve for cash flow by project/shell:","Go to your shell template and switch to Admin mode.","In the left Navigator, select Cost Manager, and then select Cash Flow.","From the toolbar, click + Create.","In the General pane of the Cash Flow Properties window (or the Cash Flow Properties worksheet), select the Project/Shell option from the Detail Level drop-down list. ","You can opt to filter for CBS Codes, or filter Summary CBS Codes.","In the Curves pane of the Cash Flow Properties window, select Baseline from the Curves drop-down list.","In the Baseline window, complete the fields using the information in the tables below.","When finished click Save &amp; Close to save your work and open the cash flow worksheet template that you have added.","Set up the following curve properties:","Property","Description","Cost","Note: You can choose the cost column when creating a curve in a project/shell but not in templates.","Select one of the following options:","Manual: Select this option to set up manual entry for amounts each period. This option is available if you have chosen Manual in the Distribution drop-down list. Users can enter cost information in the Total field on the worksheet.","Distribute amount from Cost Sheet Column: Select this option to set up a default distribution profile. This option is available if you have chosen Auto profile in the Distribution drop-down list. Examples of column: Approved Budget Revisions, Approved Commitment Changes, Approved Contracts, and so forth.","Schedule","Lets you define the range of dates (what dates to start the curve and end the curve) to use to plot the cash flow data.","Note: If you choose to take dates from the schedule sheet elements, the system uses the Master schedule sheet for the project/shell.","Select one of the following options for each date:","Manual: Select this option to manually enter the date in the cash flow worksheet.","Use dates from Schedule Sheet: Select this option to select a schedule sheet (from the Select schedule sheet drop-down). You can populate the From and To dates according to the schedules available (Example: Actual Start Date and Actual Finish Date) pertinent to the schedule sheet that you have selected for the Select schedule sheet drop-down. If these dates are changed on the selected schedule sheet, then the changes will be reflected on cash flow after the next refresh of the curves.","Use dates from Activity Sheet: Lets you select an activity sheet (from the Select Activity Sheet window). After you select using dates from an activity sheet, you must determine the values for the Project Type, From Date, and To Date fields.","Project Type","If you set Schedule to Use dates from Activity Sheet, select the project as either Baseline or Current.","From Date","If you set Schedule to Use dates from Activity Sheet, select the start date to use for plotting the cash flow curve.","To Date","If you set Schedule to Use dates from Activity Sheet, select the end date to use for plotting the cash flow curve.","Distribution","Distribution profiles are used to distribute data automatically in the cash flow worksheet. This option lets you select a distribution profile to use as the default distribution profile for the curve.","Select one of the following options for how to distribute the data automatically between cash flow time periods: ","Manual: Select this option to set up manual field entries.","Company Level: Select this option to set up a pre-determined method for distribution. Your options are: Linear, S curve, Front Loaded, Back Loaded.","Project Level: Select this option to set up a list of available project levels.","The distribution profiles are defined in the:","Go to the Company Workspace tab and switch to Admin mode. In the left Navigator, select Standards &amp; Libraries, select Cash Flow, and then select Distribution Profiles.","or ","Go to the shell tab and switch to User mode. In the left Navigator, select Cost Manager, and then select Cash Flow. From the toolbar, click Actions, and then select Manage Distribution Profiles.","The default profile is used for the initial display and calculations in the cash flow worksheet. You can change the distribution profile from the worksheet. If you do this, the default profile will automatically update to reflect the current selection.","When you build a Baseline curve for individual line items, the Schedule of Value (SOV) type influences the distribution options. ","If the SOV lists individual line items by CBS, you can distribute cost for each line item individually.","If the SOV groups line items, you cannot distribute cost for each line item individually.","Variance","For Project/Shell, typically, the Variance is set to Inflow for a Baseline type curve. Your choices are:","Inflow","Outflow","The value will be used to calculate variances against the Outflow type curves.","Adding a Template for Baseline Curve for Cash Flow by Project or Shell","10315691.htm");
Page[75]=new Array("To add a template for Baseline curve for cash flow by Summary CBS or CBS:","Go to your shell template and switch to Admin mode.","In the left Navigator, select Cost Manager, and then select Cash Flow.","From the toolbar, click + Create.","In the General pane of the Cash Flow Properties window (or the Cash Flow Properties worksheet), select any of the following options from the Detail Level drop-down list:","Summary CBS (for summary CBS codes)","CBS (for cash flow by individual CBS codes)","In the Curves pane of Cash Flow Properties window, select Baseline from the Curves drop-down list.","In the Baseline window, complete the fields using the information in the tables below.","You can cost-load a schedule sheet by assigning roles and resources to project-related activities. When you associate a CBS code with an activity in the schedule sheet, the system can distribute its cost over a period of time based on activity dates and the calendar. You will be able to view this distributed cost along with other cash flow curves related to the project.","You can create another Baseline curve by selecting a cost sheet as the source for cost or create a Forecast, Spends, and Custom curve. In all these cases, the list of CBS codes will be from the cost sheet and will not be filtered by the schedule sheet.","The cash flow will pull distribution data (Linear, S-Curve, On Start and Finish) from a schedule sheet. ","When finished click Save &amp; Close to save your work and open the cash flow worksheet that you have added.","Cash Flow Properties Template Setup For a Baseline Curve by Summary CBS","When you select the Summary CBS option in the Detail Level drop-down list (General pane) and in the Curves pane you add Baseline curve (from the Curves drop-down list), proceed to set up the following parameters:","Property","Description","Cost","Note: You can choose the cost column when creating a curve in a project/shell but not in templates.","Select your cost source as one of the following options:","Manual: Select this option if you want to manually enter amounts for each period. You can enter cost information in the Total field on the worksheet. This option is available if you select Manual in the Distribution drop-down list. ","Distribute amount from Cost Sheet Column: Select this option if you want to use the default distribution profile. This option is available if you select Auto in the Distribution drop-down list. For example, columns such as Approved Budget Revisions, Approved Commitment Changes, Approved Contracts.","Schedule","Define the range of dates to use for plotting the cash flow data. These are the dates you specify to start the curve and end the curve.","Note: If you choose to take dates from the schedule sheet elements, then the Master schedule sheet is used for the project/shell.","Select one of the following options:","Manual: Select this option if you want to manually enter the date in the cash flow worksheet.","Use dates from Schedule Sheet: Select this option if you want to select dates from a schedule sheet. Select a specific sheet from the Select schedule sheet list, and proceed to enter dates in the From Date and To Date fields to plot the cash flow curve from the selected schedule sheet. For example, Actual Start Date and Actual Finish Date. <br />Selecting Use dates from Schedule Sheet option allows you to access the individual Schedule Sheet. <br />The CBS (or Summary CBS) code shows the dates of the actual CBS (or Summary CBS) related activities.","Use dates from Activity Sheet: Select this option if you want to select dates from an activity sheet. Select a sheet from the Select Activity Sheet window, and proceed to specify the Project Type, From Date, To Date, and Periods for Cost Distribution to plot the cash flow curve from the selected activity sheet.","Project Type","If you set Schedule to Use dates from Activity Sheet, select the project as either Baseline or Current.","From Date","If you set Schedule to Use dates from Activity Sheet, select the start date to use for plotting the cash flow curve.","To Date","If you set Schedule to Use dates from Activity Sheet, select the end date to use for plotting the cash flow curve.","Distribution","Distribution profiles are used to distribute data automatically in the cash flow worksheet. Select a distribution profile to use as the default distribution profile for the curve. Select any of the following options:","Manual: Select this option if you want to enter values in each field manually.","Auto: Select this option if you want to specify a default distribution profile for initial display and calculations in the cash flow worksheet. If you change the distribution profile from the worksheet, the default profile is also updated to reflect the current selection.<br />To specify a default distribution profile:","Click the CBS Profile Distribution button.","In the Distribute by default profile CBS window:","Select a predetermined distribution method (at the Company Level or Project Level) from the Set Profile drop-down list.","The distribution profiles for this field are defined in the following locations:","Go to the Company Workspace tab and switch to Admin mode. In the left Navigator, select Standards &amp; Libraries, select Cash Flow, and then select Distribution Profiles.","or ","Go to the shell tab and switch to User mode. In the left Navigator, select Cost Manager, and then select Cash Flow. From the toolbar, click Actions, and then select Manage Distribution Profiles.","Select one or more WBS codes from the list, and click Update.","Variance","For CBS, typically, the Variance is set to Inflow for a Baseline type curve. This value is used to calculate variances against the Outflow type curves. Your choices are:","Inflow","Outflow","Cash Flow Properties Template Setup For a Baseline Curve by CBS","When you select the CBS option in the Detail Level drop-down list (General pane) and in the Curves pane you add Baseline curve (from the Curves drop-down list), proceed to set up the following parameters:","Property","Description","Bring Baseline Data From Distribution","Specify the source of your baseline data. Select any of the following options:","General: Select this option if you want to bring data from a general CBS code.","Schedule Sheet: Select this option if you want to choose a schedule sheet and view the cost distribution information by CBS.<br />To use data from schedule sheet, click the select icon to open and select a schedule sheet in the Select Schedule Sheet window.","P6 Summary Sheet: Select this option if you want to use cost and dates information from P6 Summary Sheet (spread), based on the P6 Data Sources. <br />Proceed to specify the Data Type.<br />The P6 Data Sources are listed in the Cashflow Data Sources window. (To access this window, go to the Company Workspace tab and switch to Admin mode; in the left Navigator, select Standards &amp; Libraries, select Cash Flow, and then select Data Sources.)","Activity Sheet: Select this option if you want to use cost and dates information from an activity sheet. <br />Proceed to specify the Sheet Name, Project Type, Cost and Schedule &amp; Distribution.","Note: Cash flow worksheet data will not show accurate amounts when multiple CBS Codes are associated with a single resource. If you assign a resource to multiple activities with multiple CBS codes in the Activity Sheet and the cash flow curve has Baseline selected as the Project Type, the curve data will be incorrect.","Data Type","This field displays if you chose to Bring Baseline Data From a P6 Summary Sheet. Select any of the following values:","At Completion: Select this option if you want to draw the Baseline curve using the At Completion Cost spread.","Planned: Select this option if you want to draw the Baseline curve using the Planned Cost spread.","Sheet Name","If you set Bring Baseline Data From Distribution to Activity Sheet, select an activity sheet. ","Schedule &amp; Distribution","If you set Bring Baseline Data From Distribution to Activity Sheet, select a column for the Schedule &amp; Distribution method.","Cost","Note: You can choose the cost column when creating a curve in a project/shell but not in templates.","Select your cost source as one of the following options:","Manual: Select this cost option if you want to manually enter amounts for each period. This option will be available if you selected the Distribution as Manual. This allows you enter cost information in the Total field on the worksheet.","From Activity Sheet Column: This cost option displays if you chose to Bring Baseline Data From an Activity Sheet. Select a column from the Activity Sheet such as At Completion Cost, Planned Cost, or Remaining Cost, and so forth.","From Cost Sheet Column: Select this cost option if you chose to Bring Baseline Data From an Activity Sheet and want to use a default distribution profile. This option is available if you selected the Distribution field value as Auto. From the drop-down list, select a column name such as Approved Budget Revisions, Approved Commitment Changes, Approved Contracts, and so forth.","Schedule","Define the range of dates to use for plotting the cash flow data. These are the dates you specify to start the curve and end the curve.","Note: If you choose to take dates from the schedule sheet elements, then the Master schedule sheet is used for the project/shell.","Select one of the following options:","Manual: Select this option if you want to manually enter the date in the cash flow worksheet.","Use dates from Schedule Sheet: Select this option if you want to select dates from a schedule sheet. Select a specific sheet from the Select schedule sheet list, and proceed to enter dates in the From Date and To Date fields to plot the cash flow curve from the selected schedule sheet. For example, Actual Start Date and Actual Finish Date. <br />Selecting Use dates from Schedule Sheet option allows you to access the individual Schedule Sheet. <br />The CBS (or Summary CBS) code shows the dates of the actual CBS (or Summary CBS) related activities.","Use dates from Activity Sheet: Select this option if you want to select dates from an activity sheet. Select a sheet from the Select Activity Sheet window, and proceed to specify the Project Type, From Date, To Date, and Periods for Cost Distribution to plot the cash flow curve from the selected activity sheet.","Project Type","If you set Schedule to Use Dates from Activity Sheet, select the project as either Baseline or Current.","From Date","If you set Schedule to Use Dates from Activity Sheet, select the start date to use for plotting the cash flow curve.","To Date","If you set Schedule as Use dates from Schedule Sheet or Use Dates from Activity Sheet, then select the end date to use for plotting the cash flow curve.","Distribution","Distribution profiles are used to distribute data automatically in the cash flow worksheet. This option lets you select a distribution profile to use as the default distribution profile for the curve. Select any of the following options:","Manual: Select this option if you want to enter values into each field manually.","Auto: Select this option if you want to specify a default distribution profile for initial display and calculations in the cash flow worksheet. If you change the distribution profile from the worksheet, the default profile is also updated to reflect the current selection.<br />To specify a default distribution profile:","Click the CBS Profile Distribution button.","In the Distribute by default profile CBS window: ","Select a predetermined method for distribution (at the Company Level or Project Level) from the Set Profile drop-down list.","The distribution profiles for this field are defined in the following locations:","Go to the Company Workspace tab and switch to Admin mode. In the left Navigator, select Standards &amp; Libraries, select Cash Flow, and then select Distribution Profiles.","or ","Go to the shell tab and switch to User mode. In the left Navigator, select Cost Manager, and then select Cash Flow. From the toolbar, click Actions, and then select Manage Distribution Profiles.","Select one or more WBS codes from the list, and click Update.","Note: The Auto option is selected by default, if you selected the Schedule option as Use Dates from Activity. Additionally, if you also selected the Periods for Cost Distribution option as Honor working days, then Auto displays as a read-only field, and you can no longer select a default distribution profile.","Periods for Cost Distribution","This field displays only if you have selected the Schedule option as Use Dates from Activity Sheet, and Distribution as Auto.","Select any of the following options to specify how to distribute the costs based on the activity schedule:","Consecutive Periods: Select this option to distribute costs based on the profile from the earliest start to the latest finish dates across activities for each CBS or Summary CBS code. This is the default option for new or existing curves if you selected Schedule as Use Dates from Activity Sheet.","Exclude Gap Periods: Select this option to distribute costs by honoring gaps between activities if there are multiple activities for the same CBS Code.","Honor Working Days: Select this option to distribute costs based on the working days of activities.","Variance","For CBS, typically, the Variance is set to Inflow for a Baseline type curve. This value is used to calculate variances against the Outflow type curves. Your choices are:","Inflow","Outflow","Adding a Template for Baseline Curve for Cash Flow by Summary CBS or CBS","10315680.htm");
Page[76]=new Array("As a part of cash flow management, forecasting is about calculating the future expenditures, based on the project schedules.","You can add a Forecast curve for cash flow by: ","Project/Shell","Summary CBS or CBS Commitment","Notes: The following procedures assume that you have created your data sources.","Forecast Curve","10315689.htm");
Page[77]=new Array("To set up an Actuals (or &quot;spends&quot;) curve for cash flow by project/shell:","Go to your shell template and switch to Admin mode.","In the left Navigator, select Cost Manager, and then select Cash Flow, the start point for all cash flow operations.","From the toolbar, click + Create.","In the General pane of the Cash Flow Properties window or New Cash Flow worksheet, select Project/Shell from the Detail Level drop-down list. ","In the Curves pane of the Cash Flow Properties window, select Forecast from the Curves drop-down list.","In the Forecast window, complete the fields using the information in the table below.","When finished click Save &amp; Close to save the forecast curve template.","Set up the following parameters:","Property","Description","Cost","Note: The distribution method that you select determines the Cost options that are available.","Select one of the following options:","Manual: Select this option to setup manual entry of amounts for each period. This option is available if you have chosen Manual in the Distribution drop-down list. Users can then enter cost information in the Total field on the worksheet.","Distribute amount from Cost Sheet Column: Select this option to setup a default distribution profile. This option is available if you have chosen Auto in the Distribution drop-down list. Examples of column: Approved Budget Revisions, Approved Commitment Changes, Approved Contracts, and so forth.","Schedule","This parameter enables you to plot the cash flow data. You can select one of the following options:","Manual","Use dates from Schedule Sheet","Lets you select a schedule sheet (from the Select schedule sheet drop-down). You can populate the From and To dates according to the schedules available (Example: Actual Start Date and Actual Finish Date) pertinent to the schedule sheet that you have selected for the Select schedule sheet drop-down.","If these dates are changed on the selected schedule sheet, then the changes will be reflected on cash flow after the next refresh of the curves.","After you select Use dates from Schedule Sheet, you must determine the values for the From Date and To Date fields.","Use dates from Activity Sheet","Enables you to select an activity sheet (from the Select Activity Sheet window).","After you select Use dates from Activity Sheet, you must determine the values for the Project Type, From Date, and To Date fields.","Project Type","If you set Schedule to Use dates from Activity Sheet, select the project as either Baseline or Current.","From Date","If you set Schedule to Use dates from Activity Sheet, select the start date to use for plotting the cash flow curve.","To Date","If you set Schedule to Use dates from Activity Sheet, select the end date to use for plotting the cash flow curve.","Distribution","Distribution profiles are used to distribute data automatically in the cash flow worksheet. This option lets you select a distribution profile to use as the default distribution profile for the curve.","Select one of the following options for how to distribute the data automatically between cash flow time periods: ","Manual: Select this option to set up manual field entries.","Company Level: Select this option to set up a pre-determined method for distribution. Your options are: Linear, S curve, Front Loaded, Back Loaded.","Project Level: Select this option to set up a list of available project levels.","The distribution profiles are defined in the:","Go to the Company Workspace tab and switch to Admin mode. In the left Navigator, select Standards &amp; Libraries, select Cash Flow, and then select Distribution Profiles.","or ","Go to the shell tab and switch to User mode. In the left Navigator, select Cost Manager, and then select Cash Flow. From the toolbar, click Actions, and then select Manage Distribution Profiles.","The default profile is used for the initial display and calculations in the cash flow worksheet. You can change the distribution profile from the worksheet. If you do this, the default profile will automatically update to reflect the current selection.","When you build a Baseline curve for individual line items, the Schedule of Value (SOV) type influences the distribution options. ","If the SOV lists individual line items by CBS, you can distribute cost for each line item individually.","If the SOV groups line items, you cannot distribute cost for each line item individually.","Variance","Your choices are:","Inflow","Outflow","For CBS, typically, the Variance is set to Outflow for an Actuals (Spends) type curve.","The value will be used to calculate variances against the Inflow type curves.","Begin calculations at end of curve","Select this option if you want to automatically start the Forecast at the end of a selected Actual (or &quot;spends&quot;) curve for each time period.","Select Begin calculations at end of curve, click the drop-down list below, and select your desired option (for example, you can select Actuals (or &quot;spends&quot;) curve, if this curve exists in the list).","Replace current period forecast with Actuals on cut off date","If you select this option and the period close settings have not been specified, the system replaces the Forecast curve with the Actuals (or &quot;spends&quot;) curve at the end of the month.","Note: The cumulative graph will not show the Forecast connected to Actuals (or &quot;spends&quot;) until the system overwrites the Forecast with the Actuals.","Allow edit of current period forecast until replacement actuals","This option lets you reconfigure the Forecast until the date set to replace the Foretasted values with Actuals (or &quot;spends&quot;).","Note: If the cutoff date is not specified, but the Replace current period forecast with Actuals on cut off date and Allow edit of current period forecast until replacement by Actuals options are selected, the system does not allow edits to the Forecast curve after the end of the month.","Distribute unassigned amounts from Spends","Your options for unassigned amounts are:","Using weighted average over all remaining periods","Using weighted average over ___ next periods","You can enter the number of time periods (1 or more) not exceeding the number of periods remaining.","The options above are available only if you have chosen to:","Select a distribution profile to use as the default distribution profile for the curve.","Select Begin calculations at end of curve option to automatically start the Forecast at the end of a selected Actual (or &quot;spends&quot;) curve for each time period.","If you use auto distribution for a Forecast Curve with Spends enabled and you want to use the same approach for rows that are manually overridden, select the Allow distribution of unassigned amount for manual override rows check box.","Select Baseline curve for comparison","Click the drop-down list and select a Baseline curve to compare with the Forecast curve.","Adding a Template for Forecast Curve for Cash Flow by Project or Shell","10315694.htm");
Page[78]=new Array("To add a Forecast curve for cash flow by Summary CBS or CBS template:","Go to your shell template and switch to Admin mode.","In the left Navigator, select Cost Manager, and then select Cash Flow, the start point for all cash flow operations.","From the toolbar, click + Create.","In the General pane of the Cash Flow Properties window or New Cash Flow worksheet, select any of the following options from the Detail Level drop-down list: ","Summary CBS (for summary CBS codes)","CBS (for cash flow by individual CBS codes)","In the Curves pane of the Cash Flow Properties window, select Forecast from the Curves drop-down list.","In the Forecast window, complete the fields using the information in the tables below.","Cash Flow Properties Template Setup For a Forecast Curve by Summary CBS","When you select the Summary CBS option in the Detail Level drop-down list (General pane) and in the Curves pane you add Forecast curve (from the Curves drop-down list), proceed to set up the following parameters:","Property","Description","Cost","Note: You can choose the cost column when creating a curve in a project/shell but not in templates.","Select your cost source as one of the following options:","Manual: Select this option if you want to manually enter amounts for each period. You can enter cost information in the Total field on the worksheet. This option is available if you select Manual in the Distribution drop-down list. ","Distribute amount from Cost Sheet Column: Select this option if you want to use a default distribution profile. This option is available if you select Auto in the Distribution drop-down list. For example, columns such as Approved Budget Revisions, Approved Commitment Changes, Approved Contracts.","Schedule","Define the range of dates to use for plotting the cash flow data. These are the dates you specify to start the curve and end the curve.","Note: If you choose to take dates from the schedule sheet elements, then the Master schedule sheet is used for the project/shell.","Select one of the following options for each date:","Manual: Select this option if you want to manually enter the date in the cash flow worksheet.","Use dates from Schedule Sheet: Select this option if you want to select dates from a schedule sheet. Select a specific sheet from the Select schedule sheet drop-down list, and proceed to enter dates in the From Date and To Date fields to plot the cash flow curve. For example, Actual Start Date and Actual Finish Date. <br />If these dates are changed on the selected schedule sheet, the changes are reflected on cash flow after the next refresh of the curves.","Use dates from Activity Sheet: Select this option if you want to select dates from an activity sheet. Select a specific sheet from the Select Activity Sheet window, and proceed to specify the Project Type, From Date, To Date, and Periods for Cost Distribution to plot the cash flow curve from the selected activity sheet.","Project Type","If you set Schedule to Use dates from Activity Sheet, select the project as either Baseline or Current.","From Date","If you set Schedule to Use dates from Activity Sheet, select the start date to use for plotting the cash flow curve. ","If the date is changed on the selected sheet, the change is reflected on the cash flow when the curve is next refreshed.","To Date","If you set Schedule to Use dates from Activity Sheet, select the end date to use for plotting the cash flow curve.","If the date is changed on the selected sheet, the change is reflected on the cash flow when the curve is next refreshed.","Distribution","Distribution profiles are used to distribute data automatically in the cash flow worksheet. Select a distribution profile to use as the default distribution profile for the curve. Select any of the following options:","Manual: Select this option if you want to enter values in each field manually.","Auto: Select this option if you want to specify a default distribution profile for initial display and calculations in the cash flow worksheet. If you change the distribution profile from the worksheet, the default profile is also updated to reflect the current selection.<br />To specify a default distribution profile:","Click CBS Profile Distribution button.","In the Distribute by default profile CBS window:","Select a predetermined distribution method (at the Company Level or Project Level) from the Set Profile drop-down list.","The distribution profiles for this field are defined in the following locations:","Go to the Company Workspace tab and switch to Admin mode. In the left Navigator, select Standards &amp; Libraries, select Cash Flow, and then select Distribution Profiles.","or ","Go to the shell tab and switch to User mode. In the left Navigator, select Cost Manager, and then select Cash Flow. From the toolbar, click Actions, and then select Manage Distribution Profiles.","Select one or more WBS codes from the list, and click Update.","Variance","For Summary CBS, typically, the Variance is set to Inflow for a Baseline type curve. This value is used to calculate variances against the Outflow type curves. Your choices are:","Inflow","Outflow","Begin calculations at end of curve","Select this option if you want to automatically start the Forecast at the end of a selected Actual (or &quot;spends&quot;) curve for each time period.","Replace current period forecast with Actuals on cut off date","If you select this option and the period close settings have not been specified, the Forecast curve is replaced with the Actuals (or &quot;spends&quot;) curve at the end of the month.","Note: The cumulative graph will not show the Forecast connected to Actuals (or &quot;spends&quot;) until the system overwrites the Forecast with the Actuals.","Allow edit of current period forecast until replacement actuals","Select this option if you want to reconfigure the Forecast until the date set to replace the Forecasted values with Actuals (or &quot;spends&quot;).","Note: If the cutoff date is not specified, but the Replace current period forecast with Actuals on cut off date and Allow edit of current period forecast until replacement by Actuals options are selected, the system does not allow edits to the Forecast curve after the end of the month.","Distribute unassigned amounts from Spends","Your options for unassigned amounts are:","Using weighted average over all remaining periods","Using weighted average over ___ next periods","You can enter the number of time periods (1 or more) not exceeding the number of periods remaining.","The options above are available only if you:","Selected a default distribution profile for the curve.","Selected the Begin calculations at end of curve option.","If you use auto distribution for a Forecast Curve with Spends enabled and you want to use the same approach for rows that are manually overridden, select the Allow distribution of unassigned amount for manual override rows check box.","Select Baseline curve for comparison","Select a Baseline curve from the drop-down list to compare with the Forecast curve.","Cash Flow Properties Template Setup For a Forecast Curve by CBS","When you select the CBS option in the Detail Level drop-down list (General pane) and in the Curves pane you add Forecast curve (from the Curves drop-down list), proceed to set up the following parameters:","Property","Description","Bring Forecast Data From","Specify the source of your baseline data. Select any of the following options:","General: Select this option if you want to bring data from a general CBS code.","Schedule Sheet: Select this option if you want to choose a schedule sheet and view the cost distribution information by CBS.<br />To use data from schedule sheet, click the select icon to open and select a schedule sheet in the Select Schedule Sheet window.","P6 Summary Sheet: Select this option if you want to use cost and dates information from P6 Summary Sheet (spread), based on the P6 Data Sources. <br />Proceed to specify the Data Type.<br />The P6 Data Sources are listed in the Cashflow Data Sources window. (To access this window, go to the Company Workspace tab and switch to Admin mode; in the left Navigator, select Standards &amp; Libraries, select Cash Flow, and then select Data Sources.)","The data picker lists all the P6 data sources. The P6 data sources are listed in the Cashflow Datasources window. (To access this window, go to the Company Workspace tab and switch to Admin mode; in the left Navigator, select Standards &amp; Libraries, select Cash Flow, and then select Data Sources.)","Activity Sheet: Select this option if you want to use cost and dates information from an activity sheet. <br />Proceed to specify the Sheet Name, Project Type, Cost and Schedule &amp; Distribution. ","Note: Cash flow worksheet data will not show accurate amounts when multiple CBS Codes are associated with a single resource. If you assign a resource to multiple activities with multiple CBS codes in the Activity Sheet and the cash flow curve has Baseline selected as the Project Type, the curve data will be incorrect.","(Required) Select your cost source from the Cost drop down list. Your options are:","From Activity Sheet Column","From Cost Sheet Column","(Required) Select the schedule and distribution method from the Schedule &amp; Distribution drop-down list."," ","Data Type","This field displays if you chose to Bring Baseline Data From a P6 Summary Sheet. Select any of the following values:","At Completion: Select this option if you want to draw the Baseline curve using the At Completion Cost spread.","Planned: Select this option if you want to draw the Baseline curve using the Planned Cost spread.","Sheet Name","If you set Bring Baseline Data From to Activity Sheet, select an activity sheet.","Project Type","If you set Bring Baseline Data From to Activity Sheet, select the project as either Baseline or Current.","Cost","Note: You can choose the cost column when creating a curve in a project/shell but not in templates.","Select one of the following options:","Manual: Select this cost option if you want to manually enter amounts for each period. This option will be available if you selected the Distribution as Manual. This allows you enter cost information in the Total field on the worksheet.","From Activity Sheet Column: This cost option displays if you chose to Bring Baseline Data From an Activity Sheet. Select a column from the Activity Sheet such as At Completion Cost, Planned Cost, or Remaining Cost, and so forth.","From Cost Sheet Column: This cost option displays if you chose to Bring Baseline Data From an Activity Sheet. and want to use a default distribution profile. This option is available if you selected the Distribution field value as Auto. From the drop-down list, select a column name such as Approved Budget Revisions, Approved Commitment Changes, Approved Contracts, and so forth.","Schedule &amp; Distribution","If you set Bring Baseline Data From to Activity Sheet, select a column for the Schedule &amp; Distribution method. ","Schedule","Define the range of dates to use for plotting the cash flow data. These are the dates you specify to start the curve and end the curve.","Note: If you choose to take dates from the schedule sheet elements, then the Master schedule sheet is used for the project/shell.","Select one of the following options for each date:","Manual: Select this option if you want to manually enter the date in the cash flow worksheet.","Use dates from Schedule Sheet: Select this option if you want to select dates from a schedule sheet. Select a specific sheet from the Select schedule sheet drop-down list, and proceed to enter dates in the From Date and To Date fields to plot the cash flow curve. For example, Actual Start Date and Actual Finish Date. <br />If these dates are changed on the selected schedule sheet, the changes are reflected on cash flow after the next refresh of the curves.","Use dates from Activity Sheet: Select this option if you want to select dates from an activity sheet. Select a specific sheet from the Select Activity Sheet window, and proceed to specify the Project Type, From Date, To Date, and Periods for Cost Distribution to plot the cash flow curve from the selected activity sheet.","From Date","If you set Schedule to Use dates from Schedule Sheet or Use dates from Activity Sheet, select the start date to use for plotting the cash flow curve.","To Date","If you set Schedule to Use dates from Schedule Sheet or Use dates from Activity Sheet, select the end date to use for plotting the cash flow curve.","Distribution","Distribution profiles are used to distribute data automatically in the cash flow worksheet. This option lets you select a distribution profile to use as the default distribution profile for the curve.","Manual: Select this option if you want to enter values into each field manually.","Auto: Select this option if you want to specify a default distribution profile for initial display and calculations in the cash flow worksheet. If you change the distribution profile from the worksheet, the default profile is also updated to reflect the current selection.<br />To specify a default distribution profile:","Click the CBS Profile Distribution button.","In the Distribute by default profile CBS window: ","Select a predetermined method for distribution (at the Company Level or Project Level) from the Set Profile drop-down list.","The distribution profiles for this field are defined in the following locations:","Go to the Company Workspace tab and switch to Admin mode. In the left Navigator, select Standards &amp; Libraries, select Cash Flow, and then select Distribution Profiles.","or ","Go to the shell tab and switch to User mode. In the left Navigator, select Cost Manager, and then select Cash Flow. From the toolbar, click Actions, and then select Manage Distribution Profiles.","Select one or more WBS codes from the list, and click Update.","Note: The Auto option is selected by default, if you selected the Schedule option as Use Dates from Activity. Additionally, if you also selected the Periods for Cost Distribution option as Honor working days, then Auto displays as a read-only field, and you can no longer select a default distribution profile.","Periods for Cost Distribution","This field displays only if you have selected the Schedule option as Use Dates from Activity Sheet, and Distribution as Auto.","Select any of the following options to specify how to distribute the costs based on the activity schedule:","Consecutive Periods: Select this option to distribute costs based on the profile from the earliest start to the latest finish dates across activities for each CBS or Summary CBS code. This is the default option for new or existing curves if you selected Schedule as Use Dates from Activity Sheet.","Exclude Gap Periods: Select this option to distribute costs by honoring gaps between activities if there are multiple activities for the same CBS Code.","Honor Working Days: Select this option to distribute costs based on the working days of activities.","Variance","For CBS, typically, the Variance is set to Inflow for an Actuals (Spends) type curve. This value is used to calculate variances against the Inflow type curves. Your choices are:","Inflow","Outflow","Begin calculations at end of curve","Select this option if you want to automatically start the Forecast at the end of a selected Actual (or &quot;spends&quot;) curve for each time period.","Replace current period forecast with Actuals on cut off date","If you select this option and the period close settings have not been specified, the Forecast curve is replaced with the Actuals (or &quot;spends&quot;) curve at the end of the month.","Note: The cumulative graph will not show the Forecast connected to Actuals (or &quot;spends&quot;) until the system overwrites the Forecast with the Actuals.","Allow edit of current period forecast until replacement actuals","Select this option if you want to reconfigure the Forecast until the date set to replace the Forecasted values with Actuals (or &quot;spends&quot;).","Note: If the cutoff date is not specified, but the Replace current period forecast with Actuals on cut off date and Allow edit of current period forecast until replacement by Actuals options are selected, the system does not allow edits to the Forecast curve after the end of the month.","Distribute unassigned amounts from Spends","Your options for unassigned amounts are:","Using weighted average over all remaining periods","Using weighted average over ___ next periods","You can enter the number of time periods (1 or more) not exceeding the number of periods remaining.","The above options are available only if you have selected:","A default distribution profile for the curve","The Begin calculations at end of curve option","If you use auto distribution for a Forecast Curve with Spends enabled and you want to use the same approach for rows that are manually overridden, select the Allow distribution of unassigned amount for manual override rows check box.","Select Baseline curve for comparison","Select a Baseline curve from the drop-down list to compare with the Forecast curve.","Adding a Template for Forecast Curve or Cash Flow by CBS Summary or CBS","10315683.htm");
Page[79]=new Array("You set up a Custom curve template to allows your users to create and compare curves in a Cash Flow worksheet, but you do not want to associate them with data sources of the other curve types (Baseline, Forecast, Actuals (or &quot;spends&quot;), or Portfolio).","The following topics explain how to add a Custom curve for cash flow by Summary CBS or CBS.","Custom curves are not available for cash flow by Business Process (Commitments).","The Custom curve setup is essentially the same as setting up Baseline curves.","Custom Curve","10315690.htm");
Page[80]=new Array("To add a custom curve for cash flow by Summary CBS or CBS template:","Go to your shell template and switch to Admin mode.","In the left Navigator, select Cost Manager, and then select Cash Flow, the start point for all cash flow operations.","From the toolbar, click + Create.","In the General pane of the Cash Flow Properties window or New Cash Flow worksheet, select Custom from the Detail Level drop-down list.","In the Curves pane of the Cash Flow Properties window, select Custom from the Curves drop-down list.","In the Custom window, complete the fields using the information in the table below.","When finished, click Save &amp; Close to save the custom curve template.","Property","Description","Cost","Note: You can choose the cost column when creating a curve in a project/shell but not in templates.","Select one of the following options:","Manual: Select this amount to set up manual entries of amounts for each period. This option is available if you have chosen Manual in the Distribution drop-down list. You can enter cost information in the Total field on the worksheet.","Distribute amount from Cost Sheet Column: Select this option set up the use of a default distribution profile. This option is available if you have chosen Auto in the Distribution drop-down list. Examples of column: Approved Budget Revisions, Approved Commitment Changes, Approved Contracts, and so forth.","Schedule","Lets you define the range of dates (what dates to start the curve and end the curve) to use to plot the cash flow data.","Note: If you choose to take dates from the schedule sheet elements, the system uses the Master schedule sheet for the project/shell.","Select one of the following options for each date:","Manual: Lets you manually enter the date in the cash flow worksheet.","Use dates from Schedule Sheet: Lets you select a schedule sheet (from the Select schedule sheet drop-down). You can populate the From and To dates according to the schedules available (Example: Actual Start Date and Actual Finish Date) pertinent to the schedule sheet that you have selected for the Select schedule sheet drop-down.","If these dates are changed on the selected schedule sheet, then the changes will be reflected on cash flow after the next refresh of the curves.","Use dates from Activity Sheet: Lets you select an activity sheet (from the Select Activity Sheet window).","After you select using dates from an activity sheet, you must determine the values for the Project Type, From Date, and To Date fields.","Distribution","Distribution profiles are used to distribute data automatically in the cash flow worksheet. This option lets you select a distribution profile to use as the default distribution profile for the curve.","Select one of the following options for how to distribute the data automatically between cash flow time periods: ","Manual: Select this option to enter values in each field manually.","Company Level: Select a pre-determined method for distribution. Your options are: Linear, S curve, Front Loaded, Back Loaded.","Project Level: Select from a list of available project levels.","Variance","Select Inflow or Outflow or leave the field empty.","Adding a Template for a Custom Curve for Cash Flow by Project or Shell","10315697.htm");
Page[81]=new Array("To add a custom curve for cash flow by Summary CBS or CBS template:","Go to your shell template and switch to Admin mode.","In the left Navigator, select Cost Manager, and then select Cash Flow, the start point for all cash flow operations.","From the toolbar, click + Create.","In the General pane of the Cash Flow Properties window or New Cash Flow worksheet, select any of the following options from the Detail Level drop-down list: ","Summary CBS (for summary CBS codes)","CBS (for cash flow by individual CBS codes)","In the Curves pane of the Cash Flow Properties window, select Custom from the Curves drop-down list.","In the Custom window, complete the fields using the information in the table below.","When finished, click Save &amp; Close to save the custom curve.","Property","Description","Cost","Select your cost source as one of the following options:","Manual: Select this option if you want to manually enter amounts for each period. You can enter cost information in the Total field on the worksheet. This option is available if you select Manual in the Distribution drop-down list.","Distribute amount from Cost Sheet Column: Select this option if you want to use the default distribution profile. This option is available if you select Auto in the Distribution drop-down list. For example, columns such as Approved Budget Revisions, Approved Commitment Changes, Approved Contracts.","Schedule","Define the range of dates to use for plotting the cash flow data. These are the dates you specify to start the curve and end the curve.","Note: If you choose to take dates from the schedule sheet elements, the system uses the Master schedule sheet for the project/shell.","Select one of the following options:","Manual: Select this option if you want to manually enter the date in the cash flow worksheet.","Use dates from Schedule Sheet: Select this option if you want to select dates from a schedule sheet. Select a specific sheet from the Select schedule sheet list, and proceed to enter dates in the From Date and To Date fields to plot the cash flow curve from the selected schedule sheet. For example, Actual Start Date and Actual Finish Date. <br />If these dates are changed on the selected schedule sheet, then the changes will be reflected on cash flow when the curves are next refreshed.","Use dates from Activity Sheet: Select this option if you want to select dates from an activity sheet. Select a sheet from the Select Activity Sheet window, and proceed to specify the Project Type, From Date, To Date, and Periods for Cost Distribution to plot the cash flow curve from the selected activity sheet.","Project Type","If you set Schedule to Use dates from Activity Sheet, select the project as either Baseline or Current.","From Date","If you set Schedule to Use dates from Activity Sheet, select the start date to use for plotting the cash flow curve.","To Date","If you set Schedule to Use dates from Activity Sheet, select the end date to use for plotting the cash flow curve.","Distribution","Manual: Select this option if you want to enter values in each field manually.","Auto: Select this option if you want to specify a default distribution profile for initial display and calculations in the cash flow worksheet. If you change the distribution profile from the worksheet, the default profile is also updated to reflect the current selection.<br />To specify a default distribution profile:","Click the CBS Profile Distribution button.","In the Distribute by default profile CBS window:","Select a predetermined distribution method (at the Company Level or Project Level) from the Set Profile drop-down list.","The distribution profiles for this field are defined in the following locations:","Go to the Company Workspace tab and switch to Admin mode. In the left Navigator, select Standards &amp; Libraries, select Cash Flow, and then select Distribution Profiles.","or ","Go to the shell tab and switch to User mode. In the left Navigator, select Cost Manager, and then select Cash Flow. From the toolbar, click Actions, and then select Manage Distribution Profiles.","Select one or more WBS codes from the list, and click Update.","Periods for Cost Distribution","This field displays only if you have selected the Schedule option as Use Dates from Activity Sheet, and Distribution as Auto.","Select any of the following options to specify how to distribute the costs based on the activity schedule:","Consecutive Periods: Select this option to distribute costs based on the profile from the earliest start to the latest finish dates across activities for each CBS or Summary CBS code. This is the default option for new or existing curves if you selected Schedule as Use Dates from Activity Sheet.","Exclude Gap Periods: Select this option to distribute costs by honoring gaps between activities if there are multiple activities for the same CBS Code.","Honor Working Days: Select this option to distribute costs based on the working days of activities.","Variance","Select Inflow or Outflow or leave the field empty.","Adding a Template for a Custom Curve for Cash Flow by CBS Summary or CBS","10315685.htm");
Page[82]=new Array("You can define multiple global views for the Detail Level of type CBS, Project/Shell, Summary CBS, and Commitment in a Cash Flow template and push them to all or specific projects/shells so that they are listed in the View menu. This improves the ability of users on the same project and different projects to view Cash Flow information in a similar way even for different Cash Flow configurations. You can also define one of the views for each cash flow curve type as the default.","You can update these views at any time and push them to all or specific projects/shells as the need arises. While these global views cannot be changed by the users, they can use them as the basis for creating their own views.","To define a Cash Flow View for a template:","Go to the Company Workspace tab and switch to Admin mode.","In the left Navigator, select Templates, select Shells, and then select Projects.","In the Projects Templates log, select and open the applicable project.","In the left Navigator, select Cost Manager, and then select Cash Flow.","In the Cash Flow log, select and open the applicable template.","From the View menu, select Create New View.","In the Save View As field of the New View window, enter a name for the new view.","To select the applicable curves for the view, use the Curves, Inflow, and Outflow tabs.","To use data elements (DEs) to refine the view, use the Filters tab.","Click the Add Filter button.","Choose a Data Element: This list includes all Cost Code Segments and CBS Attributes. It also includes specific fixed-column items such as From Date, To Date, Total, and Unassigned.","Choose a Condition: This list displays a list of conditions that is based on the selected DE.","Choose a Value: Depending on the type of DE, choose a value that the query condition must meet.","You can add multiple filters to a view, and you can use the same DE multiple times. When adding multiple filters, you can use the AND and OR operators to specify that the view must match all listed filters or that it can match one or more of the listed filters. To add additional filters, click Add Filter again, repeat the preceding steps, and click the applicable operator that should apply. You can add up to 15 filters.","To save your changes, click Save.","Defining Global Cash Flow Views for Inclusion in Templates","10316249.htm");
Page[83]=new Array("After you have defined templates, you can specify one of the templates for each Detail Level of type CBS, Project/Shell, Summary CBS, and Commitment as the default for managing views.","To specify a default template:","Go to the Company Workspace tab and switch to Admin mode.","In the left Navigator, select Templates, select Shells, and then select Projects.","In the Projects Templates log, select and open the applicable project.","In the left Navigator, select Cost Manager, and then select Cash Flow.","In the Cash Flow log, select the applicable template, click the gear menu ( @ ), and select Set as Default Template to Manage Views.","Depending on the type, the Default column displays the applicable statement, Yes for CBS Detail Level, Yes for Project Detail Level, Yes for Summary CBS Detail Level, or Yes for Commitment Detail Level.","If another template was currently set as the default, the system removes the label from the Default column for that template.","To remove a default label:","Go to the Company Workspace tab and switch to Admin mode.","In the left Navigator, select Templates, select Shells, and then select Projects.","In the Projects Templates log, select and open the applicable project.","In the left Navigator, select Cost Manager, and then select Cash Flow.","In the Cash Flow log, select the applicable template, click the gear menu ( @ ), and select Reset Default.","Setting Default Cash Flow Views for Templates","10317678.htm");
Page[84]=new Array("All shared views in a template that are set to Visible are displayed to those who have the applicable permissions when they access a cash flow curve that uses the template. If you update, hide (clear the Visible check box), or delete a view, these changes are automatically applied to the corresponding cash flow curves.","To update a Cash Flow View for a template:","Go to the Company Workspace tab and switch to Admin mode.","In the left Navigator, select Templates, select Shells, and then select Projects.","In the Projects Templates log, select and open the applicable project.","In the left Navigator, select Cost Manager, and then select Cash Flow.","In the Cash Flow log, select and open the applicable template.","From the View menu, select Manage Views.","Use the Manage Views dialog box to:","Change the order of the views in the View menu for the projects/shells.","Make a view visible or hide it.","Delete a view.","The current Active View is marked with a green check mark. ","To save your changes, click Save.","Managing Cash Flow Views for Templates","10317677.htm");
Page[85]=new Array("You can package Single Instance Shells that exist in the Development/Test environment to transfer the Configuration Package to the Production environment.","The Configuration Package that you create will include:","The Shell details data (data from all tabs in the Shell).","The currency defined in the Currency tab and if the selected currency does not exist in the destination environment, the system will create it.","Note: The Currency attributes such as Code, Name, Symbol, and so forth are not updated when you import the Configuration Package; after you create the shell, the Currency tab content will not be updated upon subsequent imports.","The calendar from the Calendar tab and if the selected calendar does not exist in the destination environment, the system will create it.","The following Shell details are included in the Single Instance Shell:","Note: The following Shell details are exported and imported to the destination environment only on the first import. No subsequent updates of Shell details data can be performed in the destination environment.","Shell data that exists in the form for the following fields: Shell Name, Shell Number, Administrator, and Shell Status.","The Shell log is a user-defined log, and the user-defined columns appear next to the system-defined columns.","When you create a Single Instance Shell Configuration Package successfully, the system stamps the Shell with the Last Packaged Date.","Shells cannot be created if they are not activated in the Configuration module, so the configuration of the Shell will be included in the Shell Configuration Package at the time of transfer between environments.","Note: The contents of the Organize tab, which defines the Shell hierarchy, will be included.","Packaging Single Instance Shells","10282380.htm");
Page[86]=new Array("The Update Shells function lets you quickly add or modify information in a shell. This will &quot;push&quot; the new information to the shells that you specify. By allowing data to be entered or modified once, this function helps to reduce set up time and ensure cross-shell uniformity.","The Update Shells function is available for select modules in shell type templates.","To access the templates:","Go to the Company Workspace tab and switch to Admin mode.","In the left Navigator, select Templates, and then select Shells.","Note: When you copy a Setup from a Shell template, all the fields in the shell details block are copied.","The modules that you can update are listed below.","Users: users, group membership, permissions","Groups: group names, permissions","Business Processes and BP Setups: Business processes, setups","User-defined Reports: Reports, report permissions","Access Control: modules, users, groups, permissions","Cost Sheet: Cost sheet columns, column access, and restrictions","SOV: General and Payment Applications structures","Commitment Funding: Commitment funding sheet structure","Cash Flow: Properties and permissions","Rules: Cost or fund rules","Schedule Sheet Properties: title, description, Master Schedule, status, auto-control, project start date, and error notification. Updating Schedule Sheet Properties from Templates","Gates: Active or Inactive setups","Shell Instance Dashboards: dashboards created at the shell level, and are available for users to view (but not edit) with granted permissions","Each of these modules has an Update function where you can use Find to isolate the shells you want to update. The find window contains data elements from the Find form (designed in uDesigner). This makes targeting shells with specific information possible. For example, if you add new users, to the company, and need to add them to many shells, but not every shell, you can add them to a shell template and use the Update Shells functional to add the users to only those shells that require them. ","Shells with a status of Active or On-Hold can be updated with this functionality. Inactive or View-Only shells can only have their users or groups updated with this functionality. Users with create permission for the shell type template modules can do this operation.","Note: You update shell information one module at a time. Any Active or On-hold shells can be updated in this way.","When you create a configuration package for your shell templates, the system includes the following configurations from the selected component list:","All shell templates that are included in the component list.","Content of the shell template.","Configuration of selected shells and business processes.","You can package the shell templates that exist in the Development/Test environment and transfer the configuration package to the Production environment, and your configuration package will include the shell details data (data from all tabs in the shell setup).","Currency","The currency, defined in the Currency tab, is included as a part of the configuration package. If the selected currency does not exist, then the system creates one in the destination environment. The currency attributes such as Code, Name, Symbol, and so forth cannot be updated by means of configuration package import. The Currency tab content is update upon every import. If the exchange rates, defined for currencies in the source shell template, do not exist in the destination environment, then the system creates a new exchange rate record for that currency and that exchange rate will be set to Active, and:","The Effective is set to the configuration package Import Date.","The Peg rate is brought over from the source environment.","The Float rate is brought over from the source environment, if the rate does not exist in the destination environment.","Calendar","The calendar, from the Calendar tab, is included as a part of the configuration package. If the selected calendar does not exist, then the system creates one in the destination environment.","Shell Details","The following shell details, in the form, will be exported and imported in the destination environment upon every import:","Text fields, Pull downs (Integer and String), Radio buttons, check boxes, Integer, Decimal and Currency Amounts and Dates. The data set values, or the default values, will not transfer unless you include those in your configuration package.","Note: Any picker that refers to some other design object like BP pickers, data pickers, and so forth will not be included.","The contents of the Organize tab (shell configuration), which defines the shell hierarchy, will be included. This includes the defined sub-shells.","Shells cannot be created if you do not activate them in the Configuration module.","The configuration package creation will fail if:","The design of the included shell is not a part of the component list.","The shell design version that is included in the component list does not match the deployed Shell design version.","Business Processes","A Shell Template can have several Business Processes in the Development/Test environment.","Only those Business Processes that have been included in the configuration package, marked as publish for production, can be transferred to the Production environment.","The configuration package can contain Workflows that have been set up (activated in Configuration module). If there are multiple Workflow setups in a Business Process, then all the setups are included in the configuration package, regardless of the status.","Business Processes, and other design objects, in a template depend on their setups in the Configuration module. Only the configuration setups of the Business Processes, and the Shell that the Business Process resides in, are included in the template can be a part of the configuration package.","In Workflow setups, where additional filtering on assignees exists for steps, the published design for user attribute form in the configuration package must include the deployed design.","In Workflow setups, in case the Advance workflow when next step is determined option is selected: ","When the user updates shells (Update Shells option), all the shells (or the selected shells) will receive the next step setup.","When the user updates a BP setup, from an environment different than the current environment, then the next step setup will be imported.","User-Defined Reports (UDRs)","You can transfer User-Defined Reports (UDRs) that have been included in a Shell Template from Development/Test environment to Production environment. The data source for the reports can be a design, a Data View, or a system-provided source.","Single Record Business Process (BP)","The data from the Single Record BP gets exported from the source environment and then gets imported into the destination environment. This includes: Text fields, Pull downs (Integer and String), Radio buttons, check boxes, Integer, Decimal and Currency Amounts and Dates. The data set values, or the default values, will not transfer unless you include those in your configuration package.","The following data/items are not included in the configuration package:","Any picker that refers to some other design object like BP pickers or data pickers.","Attachments, linked records, and general comments.","Groups and Users","Only the Shell Administrator user will be extracted for User Mapping, when importing the configuration package.","Only groups will be extracted for the selected components in the shell templates.","Access Control","For both Admin and User modes, the user can select the permissions for the Design objects in shell templates.","Updating Shells","74328.htm");
Page[87]=new Array("In general, the Update Shells feature works like this:","Step 1. In Admin mode, open a shell type template.","Step 2. Navigate to one of the modules listed above. Add or edit data.","Step 3. From the toolbar, click Update Shells. Select which information within the module to update and which of your active or on-hold shells to &quot;push&quot; the information to. New information will be added to the selected shells. Edited information will overwrite existing data.","You can also cancel a shell update before it reaches the In Process status.","Detailed instructions for updating specific types of shell information are found in the following sections.","Updating Shell Formation - General Procedure","74329.htm");
Page[88]=new Array("You can add new users to multiple shells at once by adding them to a shell template through the User Administration node and Users sub-node.","When adding new users to a shell, you can assign individual permissions directly to the new user, or add the user to a group to apply group permissions.","The Update Shells process runs in the background. Depending on the number of records and shells you are updating, it can take a considerable amount of time to complete. The process is complete when the End Date column in the Update History window shows the complete date.","Notes:","Users are identified by their unique User ID.","Any Active, Inactive or On-hold users can be pushed.","Users can be pushed to Active, Inactive, On-Hold, or View Only shells.","If the user does not exist in the shell, the user will be added to the shell with the permission settings and group membership.","If the user exists in the shell, the user information is updated (replaced) with the user information as entered in the shell template. This includes permission settings and group membership.","If a group that the user was added to does not exist in the shell, the group will be added, and the user will be added to the group. Group permissions are not updated; this is done by updating groups.","If the group exists, the user will be added to it. Group properties and permissions will not be affected.","To add or update users using Update Shells:","Go to the Company Workspace tab and switch to Admin mode.","In the left Navigator, select Templates, and then select Shells.","Open the shell type template to update.","In the left Navigator, select User Administration, and then select Users.","Add a user to the shell type template, or select a user to edit. Define user parameters and assign permissions.","Select one or more users in the Users log.","From the toolbar, click Update Shells, and choose one of the following:","Shells: You can use this option to select one or more shells to update. When the update window opens, it lists all shells in the project. You can use Find to isolate the shells you want to update. The find window contains data elements from the Find form that was designed. When you have isolated the shells to update, click the Update button and select either Selected Shell(s) or All Filtered Shells.","All Shells: You can use this option to update all shells of that shell type.","History: You can view the update history from past updates or cancel a request before the update begins.","An Alert window opens letting you know that you are about to push changes to the selected shells; there is no undo for the update.","Click Yes if you want to proceed with the update, or No to cancel.","To delete users:","Go to the Company Workspace tab and switch to Admin mode.","In the left Navigator, select Templates, and then select Shells.","Open the shell type template to update.","In the shell type template, navigate to User Administration, and then select Users.","If you are not an administrator or owner of an item in the template:","Select the shell user for deletion.","You can click on the Usage option, which downloads the usage report.","The usage report lists all the references of the selected user in the template. You can check if the deletion would impact any area of the usage report.","Select the Delete option.","A confirmation message is displayed along with Yes and No options.","If you choose Yes, then the item is deleted and all the user references are removed from the template.","The system deletes the user even if the selected user is the only user under the Assignee section of any workflow BP. You must manually open the BP and save the user to move them to an Inactive status. You can also assign a new user in the workflow.","If the selected user is an owner of a document, cost sheet, work sheet, schedule sheet, or User-defined report:","Select a user ID and click on the Delete option.","A confirmation message is displayed along with Yes and No options.","If you choose Yes, then the system closes the message and automatically downloads the usage report without performing a deletion. You can refer to the usage report to understand the impact areas and take the necessary action.","If you select multiple users and all of them are owners of a document, cost sheet, work sheet, schedule sheet, or User-defined report:","Select the user IDs and click on the Delete option.","A confirmation message is displayed along with Yes and No options.","If you choose Yes, then the system closes the message and automatically downloads the usage report for all the selected users without performing a deletion. You can refer to the usage report to understand the impact areas and take the necessary action.","If you select multiple users and none of them are owners of any content in the template:","Select the users and click on the Delete option.","You can select all the users and click on the Usage option, which downloads the combined usage report for all the selected users.","A confirmation message is displayed along with Yes and No options.","If you choose Yes, then the system deletes all the selected users.","If you select multiple users and a few of them are owners of some elements in the template:","Select the users and click on the Usage option.","The system downloads the combined usage report for all the selected users.","Select the Delete option.","A confirmation message is displayed along with Yes and No options.","If you choose Yes, then the system automatically downloads the usage report for the remaining users who are restricted from deletion.","Another confirmation message is displayed along with Yes and No options.","If you choose Yes, then the system deletes the selected users that are not owners.","You can refer to the usage report to further understand why some users cannot be deleted.","The push functionality and the copy shells work the same as they did previously. If a user is deleted and the record can no longer be selected, then a push cannot be performed. However, if a user is deleted and the shell template is copied to create a new template, then the deleted user would no longer be included. When a user is deleted and the shell is selected for download as part of a Component List in a Configuration Package, the deleted user is no longer part of the package. Any existing shells are not affected by the changes made and the deletions performed.","Updating Shells, Users","74330.htm");
Page[89]=new Array("You can add or update Group names and Group permissions by using the Update Shells option. That is to state, when you push Groups:","Groups will be added or updated","Groups Permission will be added or replaced","The update process runs in the background. Depending on the number of records and shells you are updating, it can take a considerable amount of time to complete. The process is complete when the End Date column in the Update History window shows the date that it was completed.","Groups are identified by their unique Group Name.","All group properties, including permission settings, will be added or updated in the shells that you selected.","Groups can be pushed to Active, Inactive, On-Hold, or View Only shells.","If the group does not exist, the group will be created with the permission settings. Group membership (user list) will not be updated in the shell.","If a group of that name exists, the properties and permissions of that group will be replaced with the new group, but not the list of users.","Users are not automatically added to the group; they need to be added by updating users (group membership).","To add or edit user groups using Update Shells:","Go to the Company Workspace tab and switch to Admin mode.","In the left Navigator, select Templates, and then select Shells.","Open the shell template to update.","In the left Navigator for the template, click User Administration, and then select Groups.","Select one or more groups from the Groups log.","From the toolbar, click Update Shells, and choose one of the following:","Shells: You can use this option to select one or more shells to update. When the update window opens, it lists all shells in the project. You can use Find to isolate the shells you want to update. The find window contains data elements from the Find form that was designed. When you have isolated the shells to update, click the Update button and select either Selected Shell(s) or All Filtered Shells.","All Shells: You can use this option to update all shells of that shell type.","History: You can view the update history from past updates or cancel a request before the update begins.","An Alert window opens letting you know that you are about to push changes to the selected shells; there is no undo for the update.","Click Yes if you want to proceed with the update, or No to cancel.","To delete user groups:","Go to the Company Workspace tab and switch to Admin mode.","In the left Navigator, select Templates, and then select Shells.","Open the shell template to update.","In the left Navigator for the template, click User Administration, and then select Groups.","If you select a single group in the template:","Select the shell group.","You can click the Usage option, which downloads the usage report for the selected group. This behavior is dependent on the browser you are working in.","The usage report lists all the references of the selected group in the template. You can check if the deletion would impact any area of the usage report.","Select the Delete option.","A confirmation message is displayed along with Yes and No options.","If you choose Yes, the item is deleted and all references of the selected group are removed from the template.","The system deletes the group even if the selected group is the only assignee in any workflow BP. You must manually open the BP and save the group for it to move to an Inactive status. You can also assign a new user in the workflow.","The system should not allow the deletion of the Project Administrators group. If you select the Project Administrators group and click the Delete option, a confirmation message is displayed along with an OK option. Click the OK option to proceed further. You can select the Project Administrators group and click the Usage option to download the usage report for the group.","If you select other groups apart from Project Administrators:","Select the shell groups.","You can click the Usage option, which downloads the combined usage report for the selected groups. This behavior is dependent on the browser you are working in.","The usage report lists all the references of the selected groups in the template. You can check if the deletion would impact any area of the usage report.","Select the Delete option.","A confirmation message is displayed along with Yes and No options.","If you choose Yes, the item is deleted and all references of the selected groups are removed from the template.","The system deletes the groups even if the selected group is the only group under the Assignee section of any workflow BP. You must manually open the BP and save the group for it to move to an Inactive status. You can also assign a new user in the workflow.","If you select multiple groups for deletion that include Project Administrators:","Select multiple shell groups.","You can click the Usage option, which downloads the combined usage report for the selected groups. This behavior is dependent on the browser you are working in.","The usage report lists all the references of the selected groups in the template. You can check if the deletion would impact any area of the usage report.","Select the Delete option.","A confirmation message is displayed along with Yes and No options.","If you choose Yes, the system displays another confirmation message along with Yes and No options. If you select No, the operation is aborted.","If you choose Yes, the selected groups, apart from the Project Administrators group, are deleted. If you select No, the deletion is not performed.","The push functionality and the copy shells work the same as they did previously. If a group is deleted and the record can no longer be selected, a push cannot be performed. However, if a group is deleted and the shell template is copied to create a template, the deleted group would no longer be included.","Updating Shells, Groups","74331.htm");
Page[90]=new Array("You can add and update new business processes or add additional business process (BP) setups to existing business processes.","The Update Shell process runs in the background. Depending on the number of records and shells you are updating, it can take a considerable amount of time to complete. The process is complete when the End Date column in the Update History window shows the complete date.","The business process setup is identified by the unique combination of business process name, setup name, and workflow name.","If the business process name does not exist, it will be added to project with the BP Setup and permissions.","If the BP exists, but the BP Setup does not, it will be added to the BP.","If the BP and BP Setup exist, the Setup will be replaced with the new one.","Users and Groups that are part of a BP setup as assignees are added/updated, but not permissions. If a group is created, it will be empty. Users must be added to the group separately through user administration. If a group is created, it will be empty. Users must be added to the group separately through user administration.","BP-related permissions are added/updated.","To add or update business process setups using Update Shells:","Go to the Company Workspace tab and switch to Admin mode.","In the left Navigator, select Templates, and then select Shells.","Open the shell type template to update.","In the shell type template, navigate to Setup, and then select Business Processes.","Add any new business processes, if applicable. (The BP must already have been imported into the system and configured at the company level.)","Note: You can also add multiple Base Commit BPs with Payment Applications and corresponding SOVs.","To add or edit business process setups, select the BP to update in the Business Processes log. Click Open. The BP Setup log opens.","Create a setup or modify an existing setup. You may create as many setups as you want to make available in the shell(s).","Select one or more setups from the BP Setup log.","Click Update Shells and choose one of the following:","Shells: You can use this option to select one or more shells to update. When the update window opens, it lists all shells in the project. You can use Find to isolate the shells you want to update. The find window contains data elements from the Find form that was designed. When you have isolated the shells to update, click the Update button and select either Selected Shell(s) or All Filtered Shells.","All Shells: You can use this option to update all shells of that shell type.","History: You can view the update history from past updates or cancel a request before the update begins.","An Alert window opens letting you know that you are about to push changes to the selected shells; there is no undo for the update.","Click Yes if you want to proceed with the update, or No to cancel.","Conditions for Creating a Business Process setup Configuration Package","When you include a Workflow Business Process setup for Configuration Package:","If it is a first time export, you must include the BP design in the configuration package.","For subsequent exports, you must include the latest BP design in the configuration package.","When you include a non-Workflow Business Process setup for Configuration Package:","If it is a first time export, you must include the BP design in the configuration package.","For subsequent exports, if you have included the Data Element used in the setup (for example, Auto Creation setup) in the configuration package, then:","If published, it will automatically be included in configuration package, by including the BP setup.","If not published, you must include the BP design as well.","At the time of import, the system transfers the setup information of the design object, irrespective of the Configuration status (Active/Inactive).","For best results, include your design object for Configuration Package after you change the configuration of your design.","Workflow Setup for Workflow Business Processes","You have the ability to delete (click Delete or select Edit and then select Delete) an inactive Workflow setup for Workflow Business Processes in a shell template so that they are not included when a particular BP setup is included in the component list for a configuration package.","Updating Record Properties tab in the BP Setups","In a shell template, if users or groups have access restrictions to the Audit log, Workflow Progress tab, and Record Properties tab of the BP, then when you push the BP setup to the shells (selected shells or all shells) those restrictions will be pushed as well. Also, if users or groups with access restrictions are not included in the shell, those users or groups will be added as the members of the shell.","The confirmation message (when pushing BP setup into projects/shells from template) will have additional information: &quot;Users and groups permissions, in the Record Properties tab, are added to the shell and existing permissions will be updated.&quot;","Updating Shells - Setup Node, Business Process","74332.htm");
Page[91]=new Array("You can add new dashboards to shell instances, for users to view. You can assign the user View permission to the shell instance dashboards.","The Update process runs in the background. Depending on the number of shells you are updating, it can take a considerable amount of time to complete. The process is complete when the End Date column in the Update History window shows the complete date.","Notes:","If granted View permission, users can view shell instance dashboards, but cannot modify them.","If a user or group is added to shell instance dashboard permissions and that user or group does not exist in the shell, that user or group is added to the shell upon update.","If a user has created My Dashboard in User mode for a shell, that dashboard is not overwritten by Update Shells.","The default setting for the dashboard will be added or updated. Users and groups who have view permissions to the default dashboard will have the default setting updated.","To add or update shell instance dashboards using Update:","Go to the Company Workspace tab and switch to Admin mode.","In the left Navigator, select Templates, select Shells, open the [shell type], and then open the [shell instance].","In the left Navigator, select Setup, and then select Dashboards. The Dashboards log opens.","Select one or more shell instance dashboards from the Dashboards log.","Click Update Shells and choose one of the following:","Shells: You can use this option to select one or more shells to update. When the update window opens, it lists all shells in the project. You can use Find to isolate the shells you want to update. The find window contains data elements from the Find form that was designed. When you have isolated the shells to update, click the Update button and select either Selected Shell(s) or All Filtered Shells.","All Shells: You can use this option to update all shells of that shell type.","History: You can view the update history from past updates or cancel a request before the update begins.","An Alert window opens letting you know that you are about to push changes to the selected shells; there is no undo for the update.","Click Yes if you want to proceed with the update, or No to cancel.","Updating Shells - Setup Node, Dashboards","10288641.htm");
Page[92]=new Array("Note: You must include the Data Cubes used in the Dashboard.","The first time that you export a Dashboard, you must include all design objects that form the Dashboard data source in the Configuration Package.","For subsequent exports, ensure that the design object that uses the Data Element that is specifically used in the setup is present in the Production Published Package. If this condition is met, the configuration package creation will be successful. If this condition is not met, the latest design will have to be included in the configuration package. When the data source is a business process, the setup must also be included in the configuration package; otherwise, the creation process will not complete.","Dashboards Components in the Configuration Package","The system includes the following components of a dashboard in the Configuration Package (.zip file):","Dashboards","Component","Field / Option","Dashboard","Log","Name","Dashboard","Log","Description","Dashboard","Log","Permissions","Dashboard","Tab Block","Tab Name","Dashboard","Tab Block","Tab Layout","Dashboard","Tab Block","Show option","Dashboard","Tab Block","Filters","Dashboard","Source Details / Analytics Block","Block Order","Dashboard","Source Details / Analytics Block","Block Title","Dashboard","Source Details / Analytics Block","Source Name","Dashboard","Source Details / Analytics Block","Block Type","Dashboard","Analytics Block","URL","The URL value will be blank in the Export package. Import process will plug in the default value based on the Unifier Configurator property.","Dashboard","Custom Block","Data Cube","Dashboard","Custom Block","Show Data From ","Dashboard","Custom Block","Block Title","Dashboard","Custom Block","Display Type","Dashboard","Custom Block","Source Grouped By (If Group By option is a design object then that design should also be included in the Configuration Package)","Dashboard","Custom Block","Output Type","Dashboard","Custom Block","Report On","Dashboard","Custom Block","Summary Type","Dashboard","Custom Block","Show Result","Dashboard","Custom Block","Show Total","Dashboard","Custom Block","Decimal Places","Dashboard","Custom Block","Currency Format","Dashboard","Drilldown Block","Data Cube","Dashboard","Drilldown Block","Block Title","Dashboard","Drilldown Block","Block Filter Elements (If filter elements are design objects, they must be included in the Configuration Package as well.)","Dashboard","Drilldown Block / Edit Drilldown Details","Title","Dashboard","Drilldown Block / Edit Drilldown Details","Show Data From","Dashboard","Drilldown Block / Edit Drilldown Details","Display Type","Dashboard","Drilldown Block / Edit Drilldown Details","Source Grouped By (If Group By option is a design object then that design must also be included in the Configuration Package.)","Dashboard","Drilldown Block / Edit Drilldown Details","Output Type","Dashboard","Drilldown Block / Edit Drilldown Details","Report On","Dashboard","Drilldown Block / Edit Drilldown Details","Summary Type","Dashboard","Drilldown Block / Edit Drilldown Details","Show Result","Dashboard","Drilldown Block / Edit Drilldown Details","Show Total","Dashboard","Drilldown Block / Edit Drilldown Details","Decimal Places","Dashboard","Drilldown Block / Edit Drilldown Details","Currency Format","Dashboard","Portlet Block","Name","Dashboard","Portlet Block","URL","Use Reset to reset the URL.","Use Get Parameters to get parameters from the URL as populated by the user in URL text box. When received, use the URL Parameter Mapping menu (accordion) to pass the values to the parameters in URLs, by mapping those to fields from Shell Attribute Form, and then format the values so that the URL can render in the dashboard during runtime, correctly.","Dashboard","Standard Block","Source Name","Dashboard","Standard Block","Data Type (If Data Type option is a design object then that design must also be included in the Configuration Package)","Dashboard","Standard Block","Report On","Dashboard","Standard Block","Block Title","Dashboard","Standard Block","Display Type","Dashboard","Standard Block","Show Result","Dashboard","Standard Block","Show Total","Dashboard","Standard Block","Decimal Places","Dashboard","Standard Block","Currency Format","Conditions for Creating a Dashboard Setup Configuration Package","10294018.htm");
Page[93]=new Array("You can update shells with Active or Inactive Gates setups. The Update Shells process runs in the background. Depending on the number of records and shells you are updating, it can take a considerable amount of time to complete. The process is complete when the End Date column in the Update History window shows the complete date.","Important Information About Updating Gates (Project Phase Gates) Setups:","The Gates setup update will completely overwrite any existing Gates setup, or will be added if it did not previously exist.","Previously scheduled Gates Runs are overwritten by the new Gates setup. If the pushed setup is Active, new scheduled Gates Runs are scheduled according to the schedule in the new setup.","Both Inactive and Active Gates setups can be pushed in the update.","After the update, the Gates setup reflects the status of the template.","After the update, the Current Phase in the Gates setup is reset to the First Phase.","After the update, the Gates shells will not run the scheduled refresh if the shell is On-Hold. Gates scheduling will resume automatically when the shell becomes Active.","If you have permission to create Gates setups, you can update Gates setups using Update Shell, even if you do not have permission to access the individual shells.","The phase conditions that have been completed already will reset to incomplete, by the system. ","Users and groups specified in the Email Notification field are added if they do not exist.","Newly-created groups are empty.","Any conditions that had been previously checked to be ignored will not be checked again, and the information about the user who had checked the ignore option will be lost.","If the Ignore check box has been used for any of the phase completion conditions, the project will not be set to where it was in the Phase Gates progress prior to the template update.","Note: Post update, the next time that the system picks up the scheduled runs, the status of the gate phases may vary depending on the setup.","To update Gates setups using Update Shells:","Go to the Company Workspace tab and switch to Admin mode.","In the left Navigator, select Templates, select Shells, open the [shell type], and then open the [shell instance].","In the left Navigator, select Setup, and then select Gates.","Select a Gates setup.","From the toolbar, click Update Shells, and select one of the following:","Shells: You can use this option to select one or more shells to update. When the update window opens, it lists all shells in the project. You can use Find to isolate the shells you want to update. The find window contains data elements from the Find form that was designed. When you have isolated the shells to update, click the Update button and select either Selected Shell(s) or All Filtered Shells.","All Shells: You can use this option to update all shells of that shell type.","History: You can view the update history from past updates or cancel a request before the update begins.","An Alert window opens letting you know that you are about to push changes to the selected shells; there is no undo for the update.","Click Yes if you want to proceed with the update, or No to cancel.","Conditions for Creating Gates setup Configuration Package","The first time that you export the Gates setup, you must include the data sources for the query condition used in the Gates setup.","For subsequent exports, ensure that the design which uses the Data Element that is specifically used in the setup is present in the Production Published package. If this condition is met, the package creation will be successful. If this condition is not met, the latest design will have to be included in the package.","Gates Components in the Configuration Package","The system includes the following components of Gates in the Configuration Package (.zip file):","Gates Component","Field / Option","Log","Name","Log","Status","Gates / General tab","Name","Gates / General tab","Description","Gates / General tab","Status","Gates / Settings tab","Phase name ","Gates / Settings tab / Phase Gate Configuration","Note: If the option of Start Date and Planned Completion dates are from Schedule sheet, then only the dates will get copied over. The Master schedule sheet will not get copied over.) ","All options","Gates / Settings tab / Gate Condition Elements","All Gate Condition Elements. The corresponding Data type selected for the gate condition should also be included in the Configuration Package.","Gates / Settings tab / Gate Conditions","All query conditions set up within the Gate condition","Gates / Settings tab","Advance to next Project .option","Gates / Settings tab / Additional Information block","All options including Users and Groups","Gates / Settings tab ","Reevaluate conditions on every Gates Run option","Gates / Schedule tab","All options including the users and groups set for email notifications.","Updating Shells - Setup Node, Gates","10288642.htm");
Page[94]=new Array("A Shell template might have many planning items in the Development/Test environment; however, not all the planning items might be ready for transfer to another environment.","To access the Shell template for Planning Manager:","Go to the Company Workspace tab and switch to Admin mode.","In the left Navigator, select Templates, select Shells, select the [shell type], and open the [shell template].","In the left Navigator, select Setup, and then select Planning Manager.","You can select multiple items to include in your configuration package.","Conditions for Creating a Planning Manager setup Configuration Package","The first time that you include the Planning Manager setup information in a Configuration Package, you must include the corresponding design in the Configuration Package.","For subsequent exports, you do not need to include the latest design, if the design exists in the Published Configuration Package, already.","At the time of import, the system transfers the setup information of the design object, irrespective of the Configuration status (Active/Inactive).","Oracle recommends that after changing your design you include the updated design in the Configuration Package.","Planning Manager Components in the Configuration Package","The system includes the following components of Planning Manager in the Configuration Package (.zip file):","Component","Field / Option","Planning Manager Setup / &lt;Item Name&gt; / General tab ","Setup Name","Planning Manager Setup / &lt;Item Name&gt; / General tab ","Description","Planning Manager Setup / &lt;Item Name&gt; / General tab","Help File","Access Control for Planning Manager Setup","The configuration package includes permissions settings of Users and Groups from Shell templates, Planning Manager.","To see the permission settings for Dashboards:","Go to the shell tab and switch to Admin mode.","In the left Navigator, select Access Control.","In the right pane, expand Administration Mode Access, expand Setup, and select Planning Manager to open the Module Permission Settings window.","Proceed with adding, modifying, or removing permissions.","Updating Shells - Setup Node, Planning Manager","10288639.htm");
Page[95]=new Array("To access the Shell template for Resource Manager:","Go to the Company Workspace tab and switch to Admin mode.","In the left Navigator, select Templates, select Shells, select the [shell type], and open the [shell template].","In the left Navigator, select Setup, and then select Resource Manager.","If you have access to the Resource Manager feature, you can select and include the Resource Manager in the Configuration Package.","Conditions for Creating a Resource Manager setup Configuration Package","The setup of Resource Manager does not depend on any uDesigner designs or their configuration. ","At the time of import, ensure that the Role Based Allocation value is the same between the Configuration Package and the Production environment, or destination server.","Note: The above check is applicable only when the setup has already been done.","At the time of import, the system transfers the setup information of the design object, irrespective of the Configuration status (Active/Inactive).","Oracle recommends that you include your design in the Configuration Package after you change the configuration of your design.","Resource Manager Components in the Configuration Package","The system includes the following components of Resource Manager in the Configuration Package (.zip file):","Component","Field / Option","Resource Manager Configuration / Role Based Allocation block","Selected option","Resource Manager Configuration / Resource Sheet Defaults ","Timescale Unit","Resource Manager Configuration / Resource Sheet Defaults","Date From","Resource Manager Configuration / Resource Sheet Defaults","Date To","Access Control for Planning Manager Setup","The Configuration Package includes permissions settings of Users and Groups from Shell templates, Resource Manager.","To see the permission settings for Dashboards:","Go to the shell tab and switch to Admin mode.","In the left Navigator, select Access Control.","In the right pane, expand Administration Mode Access, expand Setup, and select Resource Manager to open the Module Permission Settings window.","Proceed with adding, modifying, or removing permissions.","Updating Shells - Setup Node, Resource Manager","10288640.htm");
Page[96]=new Array("Go to the Company Workspace tab and switch to Admin mode.","In the left Navigator, select Templates, select Shells, select the [shell type], and open the [shell template].","In the left Navigator, select Setup, select [Configurable Manager], and then select [CM0 Classes]/[Class Name].","Any Configurable Manager of Code and Record type which have classes and which are setup in a Shell template can be packaged as part of the Configuration Package.","You can package any Configurable Manager of Code-type and Record-type as part of the Configuration Package, if the:","Configurable Manager has classes","Configurable Manager was set up in a Shell template","A shell template might have many CM Classes in the Development/Test environment; however not all CM Classes might be ready for transfer to another environment. ","Conditions for Creating a CM Class setup Configuration Package","The first time that you include the setup information in the Configuration Package, you must include the corresponding design in the Configuration Package.","For subsequent exports, you do not need to include the corresponding design in the Configuration Package.","At the time of import, the system transfers the setup information of the design object, irrespective of the Configuration status (Active/Inactive).","Oracle recommends that you include your design object for Configuration Package after you change the configuration of your design.","CM Class Components in the Configuration Package","The system includes the following components of CM Class in the Configuration Package (.zip file):","Component","Field / Option","CM Class Setup / General ","Setup Name","CM Class Setup / General ","Description","CM Class Setup / General ","Help File","CM Class Setup / General ","Auto Creator","CM Class Setup / General","Send Error Notification to","Access Control for CM Class Setup","The Configuration Package includes permissions settings of Users and Groups from Shell templates, CM Class.","To see the permission settings for Dashboards:","Go to the shell tab and switch to Admin mode.","In the left Navigator, select Access Control.","In the right pane, expand Administration Mode Access, expand Setup, and select Parts to open the Module Permission Settings window.","Proceed with adding, modifying, or removing permissions.","Updating Shells - Setup Node, Configurable Modules (Classes)","10288638.htm");
Page[97]=new Array("Go to the Company Workspace tab and switch to Admin mode.","In the left Navigator, select Templates, select Shells, select the [shell type], and open the [shell template].","In the left Navigator, select Setup, select [Configurable Manager], and then select [CM0 Sheet]/[Sheets Name].","The generic Cost Sheet template contains the generic cost-code type and setup of the Cost Sheet, in the shell template of a cost-code type generic shell.","You can include the CM0 setup that exists in a Shell template in the Shell Template Configuration Package.","Conditions for Creating a CM Class setup Configuration Package","The first time that you include the setup information in the Configuration Package, you must include the corresponding design in the Configuration Package. ","For subsequent exports, you do not need to include the corresponding design in the Configuration Package.","At the time of import, the system transfers the setup information of the design object, irrespective of the Configuration status (Active/Inactive).","Oracle recommends that you include your design object for Configuration Package after you change the configuration of your design.","CM Class Components in the Configuration Package","The system includes the following components of CM Class in the Configuration Package (.zip file):","Component","Field / Option","CM Class Setup / General ","Setup Name","CM Class Setup / General ","Description","CM Class Setup / General ","Help File","CM Class Setup / General ","Auto Creator","CM Class Setup / General","Send Error Notification to","Updating Shells - Configurable Modules Node (Sheets)","10288645.htm");
Page[98]=new Array("Rules can be updated in CBS code-based shells.","The Update Shells process runs in the background. Depending on the number of records and shells you are updating, it can take a considerable amount of time to complete. The process is complete when the End Date column in the Update History window shows the complete date.","Notes:","Both active and inactive rules can be pushed.","Rules are identified by the combination of rule name and the source.","If the rule does not exist, it will be added.","If a rule exists with the same name and source, that rule will be updated. This includes the status: for example, if the rule being pushed is active and the rule in the shell is inactive, the system will update the existing rule and activate it.","It is possible to have more than one rule with the same name and source in a project/shell or template. If two or more rules exist with the same name and source as the rule being pushed, the update will not occur and will give an error.","When the update process begins, the system will first attempt to validate each rule (equivalent to clicking the Validate button). This will occur whether the rule is active or inactive in the template. If the rule is validated successfully, the system will proceed with the update.","If the rule fails validation, the rule will not be pushed. The attempt will be captured in the History.","To update rules using Update Shells:","Go to the Company Workspace tab and switch to Admin mode.","In the left Navigator, select Templates, and then select Shells.","Open the shell template to update.","In the Shell Template, navigate to Rules.","Select one or more rules from the log.","From the toolbar, click Update Shells, and choose one of the following:","Shells: You can use this option to select one or more shells to update. When the update window opens, it lists all shells in the project. You can use Find to isolate the shells you want to update. The find window contains data elements from the Find form that was designed. When you have isolated the shells to update, click the Update button and select either Selected Shell(s) or All Filtered Shells.","All Shells: You can use this option to update all shells of that shell type.","History: You can view the update history from past updates or cancel a request before the update begins.","An Alert window opens letting you know that you are about to push changes to the selected shells; there is no undo for the update.","Click Yes if you want to proceed with the update, or No to cancel.","Conditions for Creating a Rules setup Configuration Package","The first time that you package the Rules Setup information, you must include the following in the package: ","Design of the Business Processes used in the Rule definition.","Corresponding designs.","The design for Configuration Package.","For subsequent exports, ensure that the design that uses the Data Element that is specifically used in the setup is present in the Production Published package. If this condition is met, the package creation will be successful. If this condition is not met, the latest design will have to be included in the package.","Importing of Rules based on Rule Status","Note: For both Active and Inactive, the system does not check for the existence of the specific CBS codes in the Cost Sheet (Applicable where the Rule definition uses CBS codes).","Rules with Active Status","At the time of Import, ensure that:","The Cost Sheet or Funding Sheet, used in Rules definition, exists either in the Package or in the destination server.","The data source is present, as a column, in the Funding sheet.","The cost sheet columns or the Funding Sheet columns used in Rule definition required for Rule Activation are present either in the package or in the destination server.","When CBS codes are used, ensure that the Cost Sheet used for Rules definition exists either in the Package or in the destination server.","Rules with Inactive Status","The system does not perform any checks at the time of import.","Rules Components in the Configuration Package","The system includes the following components of Rules in the Configuration Package (.zip file):","Component","Field / Option","Rule Properties / General","Name","Rule Properties / General","Description","Rule Properties / General","Control Source","Rule Properties / General","Rule Level","Rule Properties / General","Status","Rule Properties / General ","Users / Groups who can override field. Users and groups will be part of the Configuration Package.","(Applicable only for Rule level = Per selected CBS Codes and Per selected summary CBS codes)","Rule Properties / General","Notify Users / Groups when overridden field. Users and groups will be part of the Configuration Package.","(Applicable only for Rule level = Per selected CBS Codes and Per selected summary CBS codes)","Rule Properties / Rule","Limit expression formula: Formula string.","The formula string contains BPs.","Rule Properties / Rule","Data Expression: Might be a formula using BP data sources.","Rule Properties / Rule","Message when condition not met. ","Rule Properties / CBS Codes","CBS Codes","(Applicable only for Rule level = Per selected CBS Codes and Per selected summary CBS codes)","Updating Shells - Rules Node","74341.htm");
Page[99]=new Array("Go to the Company Workspace tab and switch to Admin mode.","In the left Navigator, select Templates, select Shells, select the [shell type], and open the [shell template].","In the left Navigator, select Cost Manager, and then select Cash Flow. ","The Cash Flow module lets you generate and compare Baseline, Actuals (or &#8220;spends&#8221;), Portfolio, Forecast, and Custom curves in a project or CBS code-based Shell.","You can use a Cash Flow Curve template to create cash flow curves in CBS-code based Shells.","All Cash Flows defined in a shell template will be included in the Configuration Package.","You can select and include multiple items in the Configuration Package.","Conditions for Creating a Cash Flow Setup Configuration Package","Detail","Curve type","Component","Check","Project/Level","Summary CBS","CBS","Commitment","Any","Cost = Distribute amount from cost sheet column ensure that the checks relevant to Cost Sheet are performed. If above conditions are not met, you will see an error.","Cost Sheet in the shell template.","Project/Level","Summary CBS","CBS","Commitment","Any","Schedule = Use dates from Schedule Sheet","Schedule Sheet in the shell template.","Project/Level","Summary CBS","CBS","Commitment","Any","Filter set to specific CBS Codes","When the Filter is set to specific CBS codes, ensure that the Cost Sheet in the Shell template has also been included.","Commitment","Any","Commitment Business Processes both Commitment and Change Orders","Commit Business Process selected must be included in the Configuration Package. If this condition is not met, throw an error.","Cash Flow Components in the Configuration Package","The system includes the following components of Cash Flow in the Configuration Package (.zip file):","Cash Flow content - Detail Level: Project/Shell","Cash Flow content - Detail Level: Summary CBS","Cash Flow content - Detail Level: CBS","Cash Flow content - Detail Level: Commitment","Note: For &quot;Additional checks required&quot; see to Conditions for Creating a Cash Flow setup Configuration Package, in this topic.","Cash Flow content - Detail Level: Project/Shell","Component","Field / Option","Cash Flow Properties / General","All fields","Cash Flow Properties / Curves ","All Curves","Cash Flow Properties / Curves / Curve type - Baseline","All fields including the selected options for Distribution, Cost and Schedule.","1 - If Distribution = Auto by default profile, the Distribution Profile will be included in the Configuration Package.","2 - If Cost = Distribute amount from cost sheet column, all the cost sheet columns available for selection will be included in the Configuration Package. In addition to this, the value selected for this field will also be included in the Configuration Package. Additional checks required. Note that Cost Sheet must always be included in the Package.","3 - If Schedule = Use dates from Schedule Sheet, the schedule sheet selected in the field should be included in the Package. Additional checks required. DEs selected in the From Date and To Date fields will also be included in the Configuration Package in addition to the possible values of the Schedule sheet DEs. ","Cash Flow Properties / Curves / Curve type - Forecast / General","All fields including the selected options for Distribution, Cost and Schedule.","Behavior to be the same as the one outlined in Cash Flow / Curves / Baseline","Cash Flow Properties / Curves / Curve type - Forecast / Options","All options selected for the Forecast Curve will be included in the Configuration Package","Cash Flow Properties / Curves / Curve type - Portfolio Budget","All fields selected for the Forecast Curve will be included in the Configuration Package","1 - Additional checks might be needed for Portfolio Manager related Configuration.","2 - Currency is a required field for Portfolio Budget curve. The default value is set to the Project Currency. However, this currency might differ from the Project Currency. It could be any of the Active and Future currencies listed in the Exchange Rate table. Therefore, if the currency differs from the Project Currency then in addition to the Currency value specified in this field, the currency and its exchange rate information will also be included in the Configuration Package.","Rules for creating Currencies and Exchange Rates","- Currency will get created if it does not exist","- Currency attributes such as Code, Name, Symbol, and so on, will not be updated by means of Package import.","- Currency tab content will get updated upon every import.","If exchange rates defined for currencies in the source shell template do not exist in the destination environment, a new exchange rate record will get created for that currency and that exchange rate will be set to Active.","- The Effective date will be set to the Package Import Date.","- The Peg rate will be brought over from the source environment.","- The float rate will be brought over if the rate does not exist in the destination environment.","Cash Flow Properties / Curves / Curve type - Actuals","All fields selected for the Forecast Curve will be included in the Configuration Package. Additional checks required.","Cash Flow Properties / Filter","Selected Filter options","If Filter = Select Summary CBS OR Select CBS codes, the selected CBS codes will be included as part of Filter options.","Cash Flow Properties / Options","The selected option, Decimal Options or Use Currency Decimal Precision, will be included in the Configuration Package.","Cash Flow Properties / Schedule","All options set in the Schedule tab will be included in the Configuration Package.","Cash Flow Properties / Summary","Not applicable in templates","Cash Flow / Permissions","Users and Groups","Cash Flow / Filters","Filters defined for the curves will also be included in the Package","Cash Flow content - Detail Level: Summary CBS","Component","Field / Option","Cash Flow Properties / General","All fields","Cash Flow Properties / Curves ","All Curves","Cash Flow Properties / Curves / Curve type - Baseline","All fields including the selected options for Distribution, Cost and Schedule.","1- If Distribution = Auto by default profile per summary CBS, the Distribution Profile for the corresponding Summary CBS code will be included in the Configuration Package. Additional checks required.","2- If Cost = Distribute amount from cost sheet column, all the cost sheet columns available for selection will be included in the Configuration Package. In addition to this, the value selected for this field will also be included in the Configuration Package. Additional checks required. Note that Cost Sheet must always be included in the Package.","3- If Schedule = Use dates from Schedule Sheet, the schedule sheet selected in the field should be included in the Package. Additional checks required. DEs selected in the From Date and To Date fields will also be included in the Configuration Package in addition to the possible values of the Schedule sheet DEs. ","Cash Flow Properties / Curves / Curve type - Forecast / General","All fields including the selected options for Distribution, Cost and Schedule. Behavior to be the same as the one outlined in Cash Flow / Curves / Baseline","Cash Flow Properties / Curves / Curve type - Forecast / Options","All options selected for the Forecast Curve will be included in the Configuration Package","Cash Flow Properties / Curves / Curve type - Portfolio Budget","All fields selected for the Portfolio Budget Curve will be included in the Configuration Package.","1- Additional checks might be needed for Portfolio Manager related Configuration.","2- Currency is a required field for Portfolio Budget curve. The default value is set to the Project Currency. However, this currency might differ from the Project Currency. It could be any of the Active and Future currencies listed in the Exchange Rate table. Therefore, if the currency differs from the Project Currency then in addition to the Currency value specified in this field, the currency and its exchange rate information will also be included in the Configuration Package.","Rules for creating Currencies and Exchange Rates","- Currency will get created if it does not exist","- Currency attributes such as Code, Name, Symbol, and so on, will not be updated by means of Package import.","- Currency tab content will get updated upon every import.","If exchange rates defined for currencies in the source shell template do not exist in the destination environment, a new exchange rate record will get created for that currency and that exchange rate will be set to Active.","- The Effective date will be set to the Package Import Date.","- The Peg rate will be brought over from the source environment.","- The float rate will be brought over if the rate does not exist in the destination environment.","Cash Flow Properties / Curves / Curve type - Actuals","All fields selected for the Forecast Curve will be included in the Configuration Package. Additional checks required.","Cash Flow Properties / Filter","Selected Filter options","If Filter = Select Summary CBS, the selected Summary CBS codes will be included as part of Filter options. Additional checks required. ","Cash Flow Properties / Options","The selected option, Decimal Options or Use Currency Decimal Precision, will be included in the Configuration Package.","Cash Flow Properties / Schedule","All options set in the Schedule tab will be included in the Configuration Package.","Cash Flow Properties / Summary","Not applicable in templates","Cash Flow / Permissions","Users and Groups","Cash Flow / Filters","Filters defined for the curves will also be included in the Package","Cash Flow content - Detail Level: CBS","Component","Field / Option","Cash Flow Properties / General","All fields","Cash Flow Properties / Curves ","All Curves","Cash Flow Properties / Curves / Curve type - Baseline","All fields including the selected options for Distribution, Cost and Schedule.","Distribution","Case 1: Auto by default profile per CBS, the Distribution Profile for the corresponding CBS code will be included in the Configuration Package. Additional checks required.","Note: Cost Sheet must always be included in the Package.","Case 2: Use data from Schedule Sheet, the schedule sheet will be included in the Configuration Package. Additional checks required.","Case 3: Use data from P6 Source, the P6 source selected in the curve will also be included in the Configuration Package.","If Cost = Distribute amount from cost sheet column, all the cost sheet columns available for selection will be included in the Configuration Package. In addition to this, the value selected for this field will also be included in the Configuration Package. Additional checks required.","Schedule","Case 1: Use dates from Schedule Sheet, the schedule sheet selected in the field should be included in the Package. Additional checks required. DEs selected in the From Date and To Date fields will also be included in the Configuration Package in addition to the possible values of the Schedule sheet DEs.","Case 2: Use dates from P6 Source, the P6 source selected in the curve will also be included in the Configuration Package. ","Cash Flow Properties / Curves / Curve type - Forecast / General","All fields including the selected options for Distribution, Cost and Schedule.","Behavior to be the same as the one outlined in Cash Flow / Curves / Baseline","Cash Flow Properties / Curves / Curve type - Portfolio Budget","All fields selected for the Portfolio Budget Curve will be included in the Configuration Package","Cash Flow Properties / Curves / Curve type - Forecast / Options","All options selected for the Forecast Curve will be included in the Configuration Package","Cash Flow Properties / Curves / Curve type - Portfolio Budget","All fields selected for the Portfolio Budget Curve will be included in the Configuration Package","1- Additional checks might be needed for Portfolio Manager related Configuration.","2- Currency is a required field for Portfolio Budget curve. The default value is set to the Project Currency. However, this currency might differ from the Project Currency. It could be any of the Active and Future currencies listed in the Exchange Rate table. Therefore, if the currency differs from the Project Currency then in addition to the Currency value specified in this field, the currency and its exchange rate information will also be included in the Configuration Package.","Rules for creating Currencies and Exchange Rates","- Currency will get created if it does not exist","- Currency attributes such as Code, Name, Symbol, and so on, will not be updated by means of Package import.","- Currency tab content will get updated upon every import.","If exchange rates defined for currencies in the source shell template do not exist in the destination environment, a new exchange rate record will get created for that currency and that exchange rate will be set to Active.","- The Effective date will be set to the Package Import Date.","- The Peg rate will be brought over from the source environment.","- The float rate will be brought over if the rate does not exist in the destination environment.","Cash Flow Properties / Curves / Curve type - Actuals","All fields selected for the Actuals Curve will be included in the Configuration Package. Additional checks required.","Cash Flow Properties / Filter","Selected Filter options","If Filter = Select CBS, the selected CBS codes will be included as part of Filter options. Additional checks required.","Cash Flow Properties / Options","The selected option, Decimal Options or Use Currency Decimal Precision, will be included in the Configuration Package.","Cash Flow Properties / Schedule","All options set in the Schedule tab will be included in the Configuration Package.","Cash Flow Properties / Summary","Not applicable in templates?","Cash Flow / Permissions","Users and Groups","Cash Flow / Filters","Filters defined for the curves will also be included in the Package","Cash Flow content - Detail Level: Commitment","Component","Field / Option","Cash Flow Properties / General","All fields. Additional checks required for Business Processes.","Cash Flow Properties / Curves ","All Curves","Cash Flow Properties / Curves / Curve type - Baseline","All fields including the selected options for Cash flow granularity, Distribution and Commit BPs. Additional checks required for Business Processes.","Cash Flow Properties / Curves / Curve type - Forecast / General","All fields including the selected options for Cash flow granularity, Distribution and Commit BPs.","If Distribution Method has a Profile, the Profile will also be included in the Configuration Package.","Behavior to be the same as the one outlined in Cash Flow / Curves / Baseline","Cash Flow Properties / Curves / Curve type - Forecast / Options","All options selected for the Forecast Curve will be included in the Configuration Package","Cash Flow Properties / Curves / Curve type - Portfolio Budget","All fields selected for the Portfolio Budget Curve will be included in the Configuration Package","1- Additional checks might be needed for Portfolio Manager related Configuration.","2- Currency is a required field for Portfolio Budget curve. The default value is set to the Project Currency. However, this currency might differ from the Project Currency. It could be any of the Active and Future currencies listed in the Exchange Rate table. Therefore, if the currency differs from the Project Currency then in addition to the Currency value specified in this field, the currency and its exchange rate information will also be included in the Configuration Package.","Rules for creating Currencies and Exchange Rates","- Currency will get created if it does not exist","- Currency attributes such as Code, Name, Symbol, and so on, will not be updated by means of Package import.","- Currency tab content will get updated upon every import.","If exchange rates defined for currencies in the source shell template do not exist in the destination environment, a new exchange rate record will get created for that currency and that exchange rate will be set to Active.","- The Effective date will be set to the Package Import Date.","- The Peg rate will be brought over from the source environment.","- The float rate will be brought over if the rate does not exist in the destination environment.","Cash Flow Properties / Curves / Curve type - Actuals","All fields selected for the Actuals Curve will be included in the Configuration Package. Additional checks required.","Cash Flow Properties / Filter","Selected Filter options","If Filter = Select CBS, the selected CBS codes will be included as part of Filter options. Additional checks required.","Cash Flow Properties / Options","The selected option, Decimal Options or Use Currency Decimal Precision, will be included in the Configuration Package.","Cash Flow Properties / Schedule","All options set in the Schedule tab will be included in the Configuration Package.","Cash Flow Properties / Summary","Not applicable in templates.","Cash Flow / Permissions","Users and Groups","Cash Flow / Filters","Filters defined for the curves will also be included in the Package","Updating Shells - Cost Manager Node, Cash Flow","10288651.htm");
Page[100]=new Array("Go to the Company Workspace tab and switch to Admin mode.","In the left Navigator, select Templates, select Shells, select the [shell type], and open the [shell template].","In the left Navigator, select Cost Manager, and then select Cost Sheet. ","Conditions for Creating a Cost Sheet setup Configuration Package","When the Sheet Setup information is packaged for the first time, the Cost Attribute design must also be included in the configuration package. If this check fails, the package creation will result in an error. For subsequent exports, the deployed version of the design must match the Published version of the design. This is mainly being done since the package includes the Cost Sheet (CBS) rows and these depend on the deployed design.","This check will not be performed for customers who do not use Cost attribute forms. If the destination server has the cost attribute form, but the Configuration Package does not include the Cost Attribute design, the import will fail and an error will be displayed.","When the Sheet Setup information is packaged for the first time, the design of any data source used in the column definition of the sheet must be part of the package. If this check fails, the package creation will result in an error. For subsequent exports, check will be made to ensure that the design which uses the Data Element (ex: Status) that is specifically used in the setup is present in the Published package. If this condition is met, the package creation will be successful. If not, the latest design will have to be included in the package.","Cost Sheet Components in the Configuration Package","The system includes the following components of Cost Sheet in the Configuration Package (.zip file): ","Component","Field / Option","Cost Sheet / Properties / General","Title","Cost Sheet / Properties / General","Description","Cost Sheet / Properties / General","Default View","Cost Sheet / Properties / Structure","Structure option","Cost Sheet / Properties / Structure","All segments","Cost Sheet / Properties / Options","Labels","Cost Sheet / Properties / Options","Forecast Details option","Cost Sheet / Properties / Options","Forecast Inclusion","Cost Sheet / Properties / Options","Forecast Type","Cost Sheet / Properties / Options","P6 Integration: Enable P6 Sources.","When this option is selected and the Cost sheet has used any of the P6 Data Sources, the Configuration Package will also include the P6 Data sources defined in Standards &amp; Libraries. If the P6 data sources do not exist in this destination, they will get created and be in a Published state.","The system currently allows up to 12 P6 data sources to be defined in the server. So, at the time of Import, checks will have to be made to ensure that the total number of P6 data sources does not exceed 12.","Cost Sheet / Columns / Column Properties","All options","Because the data source of a cost sheet column may be a Cost BP, additional checks are performed at the time of the Configuration Package creation to ensure that the BP is included in the Configuration Package as well.","If the entry method uses Work Sheet, the Worksheet must be included in the Configuration Package.","The package will also include the hidden columns. ","Cost Sheet / Columns / Restrictions","Users and Groups setup for Restrictions.","Cost Sheet / Budget Distribution","The Budget Distribution option will be disabled at the Shell template level. Hence user cannot setup any distribution.","Cost Sheet / Fund Assignment order","The Fund assignment option will be disabled at the Shell template level.","Cost Sheet / CBS Codes","All rows which include CBS as well as Summary CBS codes along with the Breakdown.","Note: If the Cost Codes do not exist in the destination environment, that is, if user has not packaged the Cost Codes by selecting the Data Structure option and then selecting the Cost Codes option at the time of Package creation, the cost codes used in the Cost sheet will be brought over. However, the value/label pair defined in the Cost Code definitions will not be brought over.","Cost Sheet / Views","Any views that exist in the template are included in the configuration package.","Updating Shells - Cost Manager Node, Cost Sheet","10288652.htm");
Page[101]=new Array("Go to the Company Workspace tab and switch to Admin mode.","In the left Navigator, select Templates, select Shells, select the [shell type], and open the [shell template].","In the left Navigator, select Cost Manager, select Funding, and then select Funding Sheet. ","A CBS Shell template can have a Funding Manager, which helps keep track of Funds. A Project/Shell Funding Sheet can be used to specify the appropriation and assignment of funds from each funding source.","The Funding Sheet setup in the shell template is included in the Configuration Package.","Note: Filters that you set up in the shell template for a Funding Sheet are not currently included in the Project/Shell Funding Sheet.","Conditions for Creating a Funding Sheet setup Configuration Package","The first time that you package the Sheet Setup information, the Fund Attribute design must also be included in the package, which means that the design must be included in the Configuration Package. If this check fails, the package creation will result in an error. The deployed version and the Published version of the design must match.","Note: Although you are not packaging the Funding Rows, the Company Fund sheet depends on the deployed version of the design. Fund codes in the Company Fund sheet are used to create the fund codes in the shell templates.","This check will not be performed for customers who do not use Fund Attribute Forms. If the destination server has the Fund Attribute Form, but the Configuration Package does not include the Fund Attribute design, the import will fail and an error will be displayed.","The first time that you package the Sheet Setup information, the design of any data source used in the column definition of the sheet must be part of the package. This means that these designs must be included in the Configuration Package. If this check fails, the package creation will result in an error. For subsequent exports, check will be made to ensure that the design that uses the Data Element (ex: Status) that is specifically used in the setup is present in the Published package. If this condition is met, the package creation will be successful. If not, the latest design will have to be included in the package.","Funding Sheet Components in the Configuration Package","The system includes the following components of Funding Sheet in the Configuration Package (.zip file):","Component","Field / Option","Funding Sheet Properties / General","Title","Funding Sheet Properties / General","Description","Funding Sheet Properties / General","Display Mode","Funding Sheet Properties / Assignment / Project block","Process Contributing Assignable Funds ","Funding Sheet Properties / Assignment / CBS block","CBS Fund Source ","Funding Sheet Properties/ Assignment / Assignment Levels block","Assignment Rules","Funding Sheet / Rows","The Fund rows are the ones that exist in the Company level Fund Sheet. As a result, this data will not be packaged.","Funding Sheet / Columns","All columns","Funding Sheet / Columns","All column properties. Because the data source of a Funding sheet column may be a Fund BP, additional checks are performed at the time of the Configuration Package creation to ensure that the Fund BP has been included in the Configuration Package as well. ","Funding Sheet / Fund assignment","Fund assignment order will not be carried over because it is dependent on the Funding rows.","Funding Sheet / Filters","All filters set in Funding sheet.","Note: Filters that you set up in the shell template for a Funding Sheet are not currently included in the project/shell fund sheet.","Updating Shells - Cost Manager Node, Funding - Funding Sheet","10288653.htm");
Page[102]=new Array("Go to the Company Workspace tab and switch to Admin mode.","In the left Navigator, select Templates, select Shells, select the [shell type], and open the [shell template].","In the left Navigator, select Cost Manager, select Funding, and then select Commitment Funding Sheet.","A commitment funding sheet is created for each base commit that has been designed for Commitment Funding Sheet.","Funds can be allocated from the Shell template Funding sheet to the Commitment Funding Sheet. This sheet works in conjunction with the Schedule of Values (SOV) sheet to track base commit and change commit line items and balances. Commitment Funding Sheet templates are created and set up in the Templates node, and they are used to create the commitment funding sheet structure in a project/shell (or in a project/shell template).","This structure is then used when sheets are created for individual base commit records. A Commitment Funding Sheet in a shell template will be included in the Configuration Package.","The Structure option changes from Create Structure to Update Structure after a selection of the Commitment Funding sheet is made.","If the Structure has not yet been created then an error message will be seen.","This same behavior will be seen in the following logs: ","General Spends SOV","Payment Applications SOV","Summary Payment Applications SOV","Document Manager (Structure creation is not applicable here)","Conditions for Creating a Commitment Funding setup Configuration Package","The first time that you package the Sheet Setup information, the design of any data source used in the column definition of the sheet must be part of the package.","This means that these designs must be included in the Configuration Package. If this check fails then the package creation will result in an error.","For subsequent exports, check will be made to ensure that the design which uses the Data Element (ex: Status) that is specifically used in the setup is present in the Published package.","If this condition is met, the package creation will be successful. If not, the latest design will have to be included in the package.","Other dependency checks performed at the time of Import:","The first time that the Sheet Setup information is imported, the Funding Sheet defined in the shell template must also be included in the package. If this check fails, the package import will result in an error.","Commitment Funding Components in the Configuration Package","The system includes the following components of Commitment Funding in the Configuration Package (.zip file):","Component","Field / Option","Commitment Funding Sheet Properties / General","All fields","Commitment Funding Sheet Properties / Assignment","All selections","Updating Shells - Cost Manager Node, Funding - Commitment Funding Sheet","10288654.htm");
Page[103]=new Array("Go to the Company Workspace tab and switch to Admin mode.","In the left Navigator, select Templates, select Shells, select the [shell type], and open the [shell template].","In the left Navigator, select Cost Manager, select Schedule of Values, and then select General Spends.","The General Spends SOV structure setup, existing in a shell template, will be included in the Configuration Package. The structure in the shell template can be created from the SOV templates that exist at the company level.","The Structure option changes from Create Structure to Update Structure after a selection of the SOV Structure is made.","Conditions for Creating a General Spends setup Configuration Package","The first time that you package the SOV Setup, the design of any data source used in the column definition of the sheet must be part of the package. This means that these designs must be included in the Configuration Package. If this check fails then the package creation will result in an error. For subsequent exports, check will be made to ensure that the design which uses the Data Element (ex: Status) that is specifically used in the setup is present in the Published package. If this condition is met, the package creation will be successful. If not, the latest design will have to be included in the package.","General Spends Components in the Configuration Package","The system includes the following components of General Spends in the Configuration Package (.zip file):","Component","Field / Option","SOV Structure Properties/ General","All fields","SOV Structure Properties/ Options","All fields","SOV Structure / Columns","All columns including the data source and formula definitions","Updating Shells - Cost Manager Node, Schedule of Values - General Spends","10288655.htm");
Page[104]=new Array("Go to the Company Workspace tab and switch to Admin mode.","In the left Navigator, select Templates, select Shells, select the [shell type], and open the [shell template].","In the left Navigator, select Cost Manager, select Schedule of Values, and then select Payment Applications.","Any Payment Application SOV structure setup existing in a shell template will be included in the Configuration Package. ","The Structure option changes from Create Structure to Update Structure after a selection of the SOV Structure is made.","Conditions for Creating a Payment Applications setup Configuration Package","The first time that you package the SOV Setup, the design of any data source used in the column definition of the sheet must be part of the package.","This means that these designs must be included in the Configuration Package. If this check fails then the package creation will result in an error.","For subsequent exports, check will be made to ensure that the design which uses the Data Element (ex: Status) that is specifically used in the setup is present in the Published package. If this condition is met, the package creation will be successful. If not, the latest design will have to be included in the package.","Other dependency checks performed at the time of Import:","The first time that the Pay App SOV Setup done in a shell Template is imported, the Cost sheet defined and set up in the shell template must also be included in the package. If this check fails then the package import will result in an error. For subsequent imports, the Cost sheet setup need not be part of the Import Package.","When the Pay App SOV Setup is packaged for the first time, the BP setup of the Payment Application BP must also be included in the package. If this check fails then the package import will result in an error. For subsequent imports, the Payment Application BP setup need not be part of the Import Package.","Payment Applications Components in the Configuration Package","The system includes the following components of Payment Applications in the Configuration Package (.zip file):","Component","Field / Option","Payment Application Properties / General","All fields","Payment Application Properties / Options","All fields","Payment Application Structure / Columns","All columns","Updating Shells - Cost Manager Node, Schedule of Values - Payment Applications","10288656.htm");
Page[105]=new Array("Go to the Company Workspace tab and switch to Admin mode.","In the left Navigator, select Templates, select Shells, select the [shell type], and open the [shell template].","In the left Navigator, select Cost Manager, select Schedule of Values, and then select Summary Payment Applications.","Any Summary Payment Application SOV structure setup existing in a shell template will be included in the Configuration Package.","The Structure option changes from Create Structure to Update Structure after a selection of the SOV Structure is made.","The content is same as the one mentioned in the &quot;Payment Application&quot; section.","Conditions for Creating a Summary Payment Applications setup Configuration Package","The first time that you package the SOV Setup, the design of any data source used in the column definition of the sheet must be part of the package.","This means that these designs must be included in the Configuration Package. If this check fails then the package creation will result in an error. ","For subsequent exports, check will be made to ensure that the design which uses the Data Element (ex: Status) that is specifically used in the setup is present in the Published package. If this condition is met, the package creation will be successful. If not, the latest design will have to be included in the package.","Other dependency checks performed at the time of Import:","The first time that you import the Pay App SOV Setup done in a shell template, Cost sheet defined and setup in the shell template must also be included in the package. If this check fails then the package import will result in an error. For subsequent imports, the Cost sheet setup need not be part of the Import Package.","The first time that you package the Pay App SOV Setup, the BP setup of the Payment Application BP must also be included in the package. If this check fails then the package import will result in an error. For subsequent imports, the Payment Application BP setup need not be part of the Import Package.","Updating Shells - Cost Manager Node, Schedule of Values - Summary Payment Applications","10288657.htm");
Page[106]=new Array("The Document Manager (DM), within a Shell template, contains the entire folder structure that a particular shell uses to manage all the relevant documents.","You can use the Document Manager template to update the structure and permissions, or just permissions across all shells or to selected shells of the same type. You can apply changes to a single or the entire folder hierarchy in the destination shell. Update rules apply to each sub-option - for example, in the Structure &amp; Permissions option, if a folder does not exist, it will be added","To push DM template changes and update shells:","Go to the Company Workspace tab and switch to Admin mode.","In the left Navigator, select Templates, select Shells, select the [shell type], and open the [shell template].","In the left Navigator, select Document Manager, and then select Documents.","To update the structure and permissions:","From the toolbar, click Update Shells, and select Structure &amp; Permissions.","To update all shells, select All Shells. To update selected shells, selects Shells. From the Shell picker, select the shells and click Update Shell(s).","To update the permissions:","From the toolbar, click Update Shells, and select Permissions only.","To update all shells, select All Shells. To update selected shells, selects Shells. From the Shell picker, select the shells and click Update Shell(s). ","To view the history of the template, select History from the Update Shells menu.","The tagged Document Manager with folders set up in a tagged Shell template will be included in the Configuration Package. ","Conditions for Creating a Document Manager setup Configuration Package","The first time that you package the Setup information, if the folder properties are based on a DM Attribute Form, the DM Attribute design must also be included in the package.","This means that the design must be included in the Configuration Package. If this check fails, the package creation will result in an error.","For subsequent exports, check will be made to ensure that the design which uses the Data Element that is specifically used in the setup is present in the Published package. If this condition is met, the package creation will be successful. If not, the latest design will have to be included in the package. This check will not be performed for customers who do not use DM Attribute Form.","Document Manager Components in the Configuration Package","The system includes the following components of Document Manager in the Configuration Package (.zip file):","Component","Field / Option","Document Manager ","All Folders","Document Manager / Folder ","All Permissions which includes users and groups","Document Manager / Folder","All Folder Properties","DM attributes","DM form attributes will get copied over.","Updating Shells - Document Manager Node","10288648.htm");
Page[107]=new Array("Go to the Company Workspace tab and switch to Admin mode.","In the left Navigator, select Templates, select Shells, select the [shell type], and open the [shell template].","In the left Navigator, select Space Manager, and then select Levels Sheet.","The Levels Sheet, in Space Manager, provides a sheet view of all the floors and associated spaces for a given Project/Shell. Tagged level sheet in a tagged Shell template will be included in the Configuration Package. ","Conditions for Creating a Level Sheet setup Configuration Package","The first time that you package the Setup information, the level design must also be included in the package.","This means that the design must be included in the configuration package. If this check fails, the package creation will result in an error.","For subsequent exports, check will be made to ensure that the Data Element used in the setup is present in the Published package. If this condition is met, the package creation will be successful. If not, the latest design will have to be included in the package.","For Levels Sheet, no checks for inclusion of Configuration setup will be done either at the time of packaging the setup for Configuration Package or at the time of importing the setup in a destination environment. At the time of import, the setup information is brought over regardless of the Configuration status (Active/Inactive) of the design object. However, as a best practice, it is recommended that any time the configuration of design object has changed it must be included in the Configuration Package.","Level Sheet Components in the Configuration Package","The system includes the following components of Level Sheet in the Configuration Package (.zip file):","Component","Field / Option","Levels Sheet Properties","Name","Levels Sheet Properties","Description","Levels Sheet / Columns","All columns. Columns in Levels sheet are the Data Elements from the Levels. Check has to be made to ensure that the latest deployed version of Level design has also been included in the Configuration Package.","Levels Sheet / Columns ","Group columns names","Updating Shells - Space Manager Node, Levels Sheet","10288658.htm");
Page[108]=new Array("Go to the Company Workspace tab and switch to Admin mode.","In the left Navigator, select Templates, select Shells, select the [shell type], and open the [shell template].","In the left Navigator, select Space Manager, and then select Stack Plans.","The Stack Plan, which is a two-dimensional graphical display of facility or building data derived from Space records for levels, can be setup in a Shell template. The Stack Plans in a shell template will be included in the Configuration Package.","You can select multiple items to include in the Configuration Package.","Conditions for Creating a Stack Plans setup Configuration Package","The first time that you package the Stack plan Setup information, the level and Space designs used in the setup must also be included in the package. This means that the designs must be included in the Configuration Package. If this check fails, the package creation will result in an error. For subsequent exports, check will be made to ensure that the design which uses the Data Element that is specifically used in the setup is present in the Published package. If this condition is met, the package creation will be successful. If not, the latest design will have to be included in the package.","Configuration Information:","For Stack Plans, no checks for inclusion of Configuration setup will be done either at the time of packaging the setup for Configuration Package or at the time of importing the setup in a destination environment. At the time of import, the setup information is brought over regardless of the Configuration status (Active/Inactive) of the design object. However, as a best practice, it is recommended that any time the configuration of design object has changed it must be included in the Configuration Package.","Stack Plans Components in the Configuration Package","The system includes the following components of Stack Plans in the Configuration Package (.zip file):","Component","Field / Option","Stack Plan Properties / General","Name","Stack Plan Properties / General","Description","Stack Plan Properties / General","Include levels option","Stack Plan Properties / Options","Space Type. Space type is a required field in Stack Plans. The latest deployed version of the associated Space type must also be part of the Configuration Package.","Updating Shells - Space Manager Node, Stack Plans","10288659.htm");
Page[109]=new Array("Go to the Company Workspace tab and switch to Admin mode.","In the left Navigator, select Templates, select Shells, select the [shell type], and open the [shell template].","In the left Navigator, select Schedule Manager, and then select Schedule Sheets.","If you have access to the Schedule Manager feature, you can include the selected Schedule Sheets for the selected Shell template in the Configuration Package.","The Schedule Sheets can be created by using templates at the company-level.","Conditions for Creating a Schedule Sheets setup Configuration Package","The first time that you package the Setup information, the Schedule Attribute and the Resource Assignment attribute designs must also be included in the package.","This means that the design must be included in the Configuration Package. If this check fails, the package creation will result in an error.","For subsequent exports, check will be made to ensure that the design which uses the Data Element that is specifically used in the setup is present in the Published package. If this condition is met, the package creation will be successful. If not, the latest design will have to be included in the package.","Schedule Sheets Components in the Configuration Package","The system includes the following components of Schedule Sheets in the Configuration Package (.zip file):","Component","Field / Option","Schedule Sheet Properties/ General","All fields. Custom calendars should also be included in the Package.","Schedule Sheet Properties / Gantt Chart","All fields ","Schedule Sheet Properties / Tracking Gantt","All fields","Schedule Sheet Properties / Options","All fields","Schedule Sheet Properties / Schedule","All fields","Schedule Sheet / Activities","No activity related information will be packaged, meaning no rows will be included.","&lt;Schedule Sheet Name&gt; / Scope Management Setup (Applicable for shell templates)","No Scope setup will be brought over since the scope is tied to an activity. ","Schedule Sheet / Data Mapping","All fields. Dependency checks for inclusion of Schedule Attribute and Resource Assignment forms will be performed to see if the relevant designs are part of the package. ","Schedule Sheet / Budget and Progress Setup","All applicable options","Schedule Sheet / Column","All columns defined in the sheet. If column definition is based on Cost Sheet definition, the Cost Sheet must also be included in the configuration package. If cost sheet column does not exist, an error will be displayed.","Updating Shells - Schedule Manager Node, Schedule Sheets","10288649.htm");
Page[110]=new Array("You can add an Activity Sheet to multiple shells at once with an Activity Sheet template. For example, you might want to assign newly defined global views to the project/shell so that they are available to all users. For more information, see Defining Activity Sheet and System Activity Sheet Views for Inclusion in Templates.","The Update Shell process runs in the background. Depending on the number of records and shells you are updating, it can take a considerable amount of time to complete. The process is complete when the End Date column in the Update History window shows the complete date.","To add an Activity Sheet to a shell using Update Shells:","Go to the Company Workspace tab and switch to Admin mode.","In the left Navigator, select Templates, select Shells, and then select Projects.","In the Projects Templates log, select and open a shell template.","In the left Navigator, select Activity Manager, and then select Activity Sheet.","In the Activity Sheets log, select an item; from the toolbar, click Update Shells, and choose one of the following:","Shells: You can use this option to select one or more shells to update. When the update window opens, it lists all shells in the project. You can use Find to isolate the shells you want to update. The find window contains data elements from the Find form that was designed. When you have isolated the shells to update, click the Update button and select either Selected Shell(s) or All Filtered Shells.","All Shells: You can use this option to update all shells of that shell type.","History: You can view the update history from past updates or cancel a request before the update begins.","An Alert window opens letting you know that you are about to push changes to the selected active and on-hold shells; there is no undo for the update. If you proceed with the update, the following changes will be made: ","If the Activity Sheet with the same name does not exist, it will be added.","If the Activity Sheet exists with the same name, it will not be updated or replaced.","Assigned WBS attributes to the Activities will be added to the Project WBS Sheet.","If Project WBS Sheet does not exist, it will be added.","Assigned OBS attributes to the WBS will be added to the OBS Sheet.","If OBS Sheet does not exist, it will be added.","Sheet permissions will be added","Users and Groups will be added if they do not exist.","If Group is created, it will be empty.","Custom calendars assigned to Activity Sheet will be added.","Click Yes if you want to proceed with the update, or No to cancel.","Note: The views that have been defined in the Activity Sheets templates will not be carried over to the Activity Sheet in the shell.","Configuration Packages","The Activity Manager sub-node, in the configuration package component list, lists all the Activity and WBS Sheet templates defined in the shell templates. You can select one or more Activity Sheets, Project WBS Sheet, and OBS Sheet per shell template that needs to be exported in a package. ","If you select Activity Sheet and the attribute form design is not selected, the following error is displayed upon error check in the component list or when creating a component package:","The design manual Activity attributes is missing in the component list.","Similarly, when you select an Activity Sheet but have not selected the associated WBS Sheet in the component list, the following error will appear upon error check in the component list. When creating a configuration package make sure along with the Activity Sheet template, the associated WBS Sheet template is also a part of the component list.","The OBS Name from the OBS Sheet &lt;Sheet name&gt; included in the WBS Sheet &lt;WBS Sheet Name&gt; in &lt;Shell Template Name&gt; shell template is missing in the component list.","When the WBS Sheet in shell templates is selected in the component list, but not the design, the following error is displayed:","The design WBS Sheet attributes is missing in the component list.","When the WBS sheet is selected, but not the OBS Sheet, the following error is displayed. The same error will appear in the configuration package creation if the associated OBS Sheet is not selected: ","The OBS Name from the OBS Sheet &lt;Sheet name&gt; included in the WBS Sheet &lt;WBS Sheet Name&gt; in &lt;Shell Template Name&gt; shell template is missing in the component list.","When the OBS Sheet is selected in the component list but not the OBS attribute design, the following error is displayed:","The design OBS Sheet attributes is missing in the component list.","There will be no error check for the Cost Codes while creating the package.","Add-on Configuration Packages","You can create configuration packages based on the component lists having activity sheet templates, along with WBS Sheet and OBS Sheet templates and be able to import the package in the destination environment. The above validations mentioned in the Component Lists will apply when creating a package if the associated WBS Sheet or OBS Sheet template or design is not selected in the add on component list.","Import Package","When a user imports the configuration package that has shell templates with Activity/WBS/OBS Sheets, all the following components should be added in the destination.","Activity Sheets along with activities, activity attributes, dependencies, assigned WBS Codes, assigned CBS codes (if cost sheet is selected in package or cost sheet exists in destination with same CBS code structure)","Project WBS Sheet with all WBS attributes.","OBS Sheet with all OBS attributes.","Cost Sheet with all Cost codes (if selected in Package).","Note: If the Cost Sheet is not included in the Activity Sheet that is included in the Configuration Package, the Activity Sheet will not have the cost codes when the import is completed.","Updating Shells - Activity Manager Node, Activity Sheet","10299903.htm");
Page[111]=new Array("You can edit access control parameters and update across shells.","The Update Shell process runs in the background. Depending on the number of records and shells you are updating, it can take a considerable amount of time to complete. The process is complete when the End Date column in the Update History window shows the complete date.","Notes:","Modules are identified by name.","If the module exists in the shell, the module is updated, users/groups are created or updated, and permissions are updated for the module.","If the module does not exist, the module is added to the shell. Users/groups are created and permissions are created for that module.","To update access control using Update Shells:","Go to the Company Workspace tab and switch to Admin mode.","In the left Navigator, select Templates, and then select Shells.","Open the shell template to update.","In the shell-type template, navigate to Access Control and assign user or group permissions to the modules as needed.","From the toolbar, click Update Shells. The Update Shells window opens, displaying the list of modules for which the access control settings can be updated.","Select the module(s) that you want to update.","Click Update Shells and choose one of the following:","Shells: You can use this option to select one or more shells to update. When the update window opens, it lists all shells in the project. You can use Find to isolate the shells you want to update. The find window contains data elements from the Find form that was designed. When you have isolated the shells to update, click the Update button and select either Selected Shell(s) or All Filtered Shells.","All Shells: You can use this option to update all shells of that shell type.","History: You can view the update history from past updates or cancel a request before the update begins.","An Alert window opens letting you know that you are about to push changes to the selected shells; there is no undo for the update.","Click Yes if you want to proceed with the update, or No to cancel.","Updating Shells - Access Control Node","74334.htm");
Page[112]=new Array("Cost sheet columns can be updated in CBS code-based shells.","The Update Shell process runs in the background. Depending on the number of records and shells you are updating, it can take a considerable amount of time to complete. The process is complete when the End Date column in the Shell History window shows the complete date.","Notes:","A column is identified by a unique data source.","If the cost sheet does not exist in the shell, the column is not added.","If the shell cost sheet is present but the column does not exist, the column definition is created, and the column is added. Column restrictions are added. Users/Groups are created or updated.","For formula columns, be sure to first push the columns or data sources that make up the formula (if they do not exist in the cost sheet), and then push the formula column. Formula-based columns that are based on BPs are not automatically updated if you change the name of the BP. To update the hover label, you can use the Update Shells feature. You can also right-click the column name, select Properties, click Select in the Formula section, and make the applicable changes.","Any new column that is created will use the column to its immediate left as the reference point for positioning. When a column is added to the cost sheet via an update, this means: If the column to the left of the column that is being pushed exists in both the template and cost sheet, the column will be positioned in the cost sheet according to its position in the template. If the column to the left of the column being pushed exists in the template but does not exist in the cost sheet, the column will be added to the end (far right) in the cost sheet.","Updating Cost Sheet Columns in a Shell","74335.htm");
Page[113]=new Array("If a cost sheet column of the same name exists, it will be replaced according to the following matrix.","If this template (source):","Is used for this shell (destination):","The template will:","Single Date Source","Column exists","Update the column","Column does not exist","Create column with the same definition","Logical Data source (Formula entry)","Logical Data source Column Exists (Formula entry)","Update and replace the formula","Logical Data source column exists (Manual entry)","Not update the column or formula","Column does not exist","Create column with same definition","Logical Data source (Manual entry)","Logical Data source Column Exists (Manual entry)","Update the column","Logical Data source Column Exists (Formula entry)","Update the column and change it to manual entry","Column does not exist","Create column with same definition","To add or update cost sheet columns using Update Shells:","Go to the Company Workspace tab and switch to Admin mode.","In the left Navigator, select Templates, and then select Shells.","Open the template to update.","In the left Navigator, select Cost Manager, select Cost Sheet, and open the Cost Sheet template.","From the toolbar, click Menu Options, select Columns, and then select Manage Columns.","The Cost Sheet Columns window opens.","If applicable, drag and drop the listed columns to the order that you want to use.","Select the column, or columns that you want to use in the update.","Click Update Shells, and choose one of the following:","Shells: You can use this option to select one or more shells to update. When the update window opens, it lists all shells in the project. You can use Find on Page to isolate the shells you want to update. The find window contains data elements from the Find form that was designed. When you have isolated the shells to update, click the Update button.","All Shells: You can use this option to update all shells of that shell type.","History: You can view the update history from past updates or cancel a request before the update begins.","An Alert window opens letting you know that you are about to push changes to the selected shells; there is no undo for the update.","If you want to proceed with the update, click Yes; otherwise, click No to cancel.","Cost Column Shell Updating Rules","74336.htm");
Page[114]=new Array("After a snapshot schedule is created, you can use the Update Shells option to push the schedule to the selected shells. Changes made to the schedule after it is saved must be saved again before it can be pushed to the selected shells.","To add or update snapshots using Update Shells:","Go to the Company Workspace tab and switch to Admin mode.","In the left Navigator, select Templates, and then select Shells.","Open the template that you want to update.","In the left Navigator, select Cost Manager, select Cost Sheet, and open the Cost Sheet template.","From the toolbar, click Menu Options, select Snapshots, and then select Enable Auto Snapshot.","In the Schedule Snapshot dialog box, select the Enable Auto Snapshot check box.","By default, Update Shells is disabled until you create a snapshot schedule.","From the Select Snapshot Frequency list, select the applicable option and then complete the corresponding steps.","If you select Weekly, select the day of the week.","If you select Monthly, select:","Day, and specify a date from 1 through 31. For months that have fewer than 31 days, the system automatically adjusts the schedule depending on the month.","The, and select First, Second, Third, or Fourth, and then select the day of the week.","If you select Quarterly, specify a Day from 1 through 90. Quarters are based on the calendar year.","If you select Yearly, specify a Day from 1 through 365.","In the Range of Occurrence section, specify the Start Date (required) and End Date (optional).","If you want the system to update the Prior Forecast column in the sheet after each snapshot, select the Update Prior Forecasts check box.","To create the scheduled snapshot, click Save.","At the top of the Schedule Snapshot dialog box, click Update Shells, and choose one of the following:","Shells: Use this option to select one or more shells to update. When the update window opens, it lists all shells in the project. You can use Find on Page to isolate the shells you want to update. The find window contains data elements from the Find form that was designed. When you have isolated the shells to update, click the Update button.","All Shells: Use this option to update all shells of that shell type.","History: Use this option view the update history from past updates or cancel a request before the update begins.","An Alert window opens letting you know that you are about to push changes to the selected shells; there is no undo for the update.","If you want to proceed with the update, click Yes; otherwise, click No to cancel.","Updating Cost Sheet Snapshots in a Shell","10312818.htm");
Page[115]=new Array("You can update the SOV structure for general spends or payment applications in CBS code-based shells.","The Update Shell process runs in the background. Depending on the number of records and shells you are updating, it can take a considerable amount of time to complete. The process is complete when the End Date column in the Update History window shows the complete date.","Notes:","Update Shell can be used to create or update the SOV structure. If the structure exists, it will be updated. If not, it will be created (restrictions apply for payment applications; see below).","When creating or updating the structure of Payment Applications SOV and Summary Payment Applications SOV, the Payment Application Business Process must be set up in the target shell first. If the business process has an active setup, then Update Shell will create or update the structure.","To update SOV structure using Update Shells:","Go to the Company Workspace tab and switch to Admin mode.","In the left Navigator, select Templates, select Shells, select the [shell type], and open the [shell template] to update.","In the left Navigator, select Cost Manager, select Schedule of Values, and then select one of these options: General Spends, Payment Applications, or Summary Payment Applications (Contracts with summary - SOV).","From the toolbar, click Update Shells, and select one of the following:","Shells: You can use this option to select one or more shells to update. When the update window opens, it lists all shells in the project. You can use Find to isolate the shells you want to update. The find window contains data elements from the Find form that was designed in uDesigner. When you have isolated the shells to update, click the Update button and select either Selected Shell(s) or All Filtered Shells.","All Shells: You can use this option to update all shells of that shell type.","History: You can view the update history from past updates or cancel a request before the update begins.","An Alert window opens letting you know that you are about to push changes to the selected shells; there is no undo for the update.","Click Yes if you want to proceed with the update, or No to cancel.","Update Schedule of Values Structure","74337.htm");
Page[116]=new Array("You can add and update user-defined reports. ","The Update Shell process runs in the background. Depending on the number of records and shells you are updating, it can take a considerable amount of time to complete. The process is complete when the End Date column in the Update History window shows the complete date.","Important information about updating reports in Project/Shell: ","Reports are identified by the combination of Name and Data Type.","Report names do not have to be unique.","If the report name and data type does not exist, the new one will be added.","The original owner of the report is added to the Users or Groups of the report in the receiving Project/Shell (Permission tab).","The administrator of the receiving Project/Shell becomes the report owner.","If a report exists with the same name and data type in the receiving Project/Shell, the existing report will be replaced with the new report, and the following information will be according to the new report:","Report updates","Added or changed Users or groups","Added or changed permissions","To add or update user-defined reports using Update Shells:","Go to the Company Workspace tab and switch to Admin mode.","In the left Navigator, select Templates, and then select Shells.","Open the shell template to update.","In the left Navigator, select Reports, and then select User-Defined.","Add a UDR to the shell type template, or select UDR to edit. Define properties.","Select one or more reports from the User-Defined Reports log.","Click Update Shells and choose one of the following:","Shells: You can use this option to select one or more shells to update. When the update window opens, it lists all shells in the project. You can use Find to isolate the shells you want to update. The find window contains data elements from the Find form that was designed. When you have isolated the shells to update, click the Update button and select either Selected Shell(s) or All Filtered Shells.","All Shells: You can use this option to update all shells of that shell type.","History: You can view the update history from past updates or cancel a request before the update begins.","An Alert window opens letting you know that you are about to push changes to the selected shells; there is no undo for the update.","Click Yes if you want to proceed with the update, or No to cancel.","Updating Shells - Reports Node","74333.htm");
Page[117]=new Array("You can update the structure used to create commitment funding sheets in CBS code-based shells.","The Update Shells process runs in the background. Depending on the number of records and projects you are updating, it can take a considerable amount of time to complete. The process is complete when the End Date column in the Update History window shows the complete date.","Notes:","Update Project can be used to create or update the commitment funding structure in the project. If the structure exists, it will be updated. If not, it will be created.","Updating the structure in a project will not affect existing commitment funding sheets. New sheets will reflect the updated structure.","To update commitment funding structure using Update Shell:","Go to the Company Workspace tab and switch to Admin mode.","In the left Navigator, select Templates, select Shells, select the [shell type], and open the [shell template].","In the left Navigator, select Cost Manager, select Funding, and then select Commitment Funding Sheet.","From the toolbar, click Update Shells, and choose one of the following:","Shells: You can use this option to select one or more shells to update. When the update window opens, it lists all shells in the project. You can use Find to isolate the shells you want to update. The find window contains data elements from the Find form that was designed. When you have isolated the shells to update, click the Update button and select either Selected Shell(s) or All Filtered Shells.","All Shells: You can use this option to update all shells of that shell type.","History: You can view the update history from past updates or cancel a request before the update begins.","An Alert window opens letting you know that you are about to push changes to the selected shells; there is no undo for the update.","Click Yes if you want to proceed with the update, or No to cancel.","Update Commitment Funding Structure","74338.htm");
Page[118]=new Array("You can push cash flow detail curve properties and permissions from a shell template to a shell. This is available for CBS-code based shells and templates.","The Update Shell process runs in the background. Depending on the number of records and projects you are updating, it can take a considerable amount of time to complete. The process is complete when the End Date column in the Update History window shows the complete date.","Notes about updating cash flow curve properties:","Both detail curve properties and permissions are pushed from the template to the project.","Cash flow detail curves are identified by name.","If a detail curve with the same name exists in the project, it will be replaced. All properties, including detail level and time scale, and permission settings will be updated.","If a detail curve with the same name does not exist in the project, a new one will be created.","Users and groups will be added if they do not exist. If a group is created, it will be empty.","To push a curve, the destination project must have a cost sheet.","Commitment detail level curves will not be pushed.","A Summary CBS curve cannot be pushed to a project where the cost sheet is flat.","After a successful update, the updated destination curves will be refreshed.","To update cash flow curve properties and permissions using Update Shell:","Go to the Company Workspace tab and switch to Admin mode.","In the left Navigator, select Templates, and then select Shells.","Open the shell template that you want to update.","In the left Navigator for the shell template, select Cost Manager, and then select Cash Flow.","Add a cash flow curve to the shell template, or select one to edit, and define the properties.","You can define views for each cash flow detail level to include in the shell. You can also select one view per detail level to function as the default view. For more information, see Defining Global Cash Flow Views for Inclusion in Templates.","From the Cash Flow log, select a curve.","Click Update Shells and choose one of the following:","Shells: You can use this option to select one or more shells to update. When the update window opens, it lists all shells in the project. You can use Find to isolate the shells you want to update. The find window contains data elements from the Find form that was designed. When you have isolated the shells to update, click the Update button and select either Selected Shell(s) or All Filtered Shells.","All Shells: You can use this option to update all shells of that shell type.","History: You can view the update history from past updates or cancel a request before the update begins.","An Alert window opens letting you know that you are about to push changes to the selected shells; there is no undo for the update.","Read the message carefully, and then click Yes to proceed with the update.","Update Cash Flow Properties and Permissions","74339.htm");

Page[119]=new Array("You can view details about previously updated shell modules.","To view Update Shell History:","In the shell type template, navigate to the module to view the update history.","From the toolbar, click Update Shells, and choose History. The Update Projects/Shells: History window opens. It lists any previous incidents of using Update Shells.","Select an instance from the list and click Open. The History Details window opens, detailing the module information that was updated. History Details displays:","Requestor: User who initiated the update process","Shells: Either user-selected or all shells","Submitted date: When the update request was submitted","Start date: When the update process started","End date: When the update process ended","View Update history","74345.htm");
Page[120]=new Array("You can cancel an update request that has not yet started; that is, any request that does not have a status of In Process or Finished.","To cancel a shell update request:","In the shell type template, navigate to the module in which you want to cancel the update request.","From the toolbar, click Update Shells, and select History. The Update Projects/Shells: History window opens.","Select an update that has not yet started.","From the toolbar, click Cancel Request.","Cancel a Shell Update Request","74346.htm");
Page[121]=new Array("You (the Administrator) can create or update Shell Template components from another Shell Template.","Within a shell template, you can use the Update Shell Templates (toolbar option) and push the shell template data from source shell template to destination shell template or shell templates of the same shell type for the modules described in the following topics.","Updating Shell Templates","10299979.htm");
Page[122]=new Array("For specific modules, you can update the Access Control information in the destination shell templates from a source shell template. To do so, use the Update Shell Templates toolbar option. After the update completes successfully, all the selected destination shell templates will have the Access Control information updated.","The modules that do not exist in the destination shell template will get added. ","Also, Groups or Users associated with the modules are added. The modules that exist in the destination shell template will have the Access Control information replaced. In this case, new Groups or Users that do not exist in the destination shell template will get added.","To access and work with the Update Shell Templates toolbar option:","Go to the Company Workspace tab and switch to Admin mode.","In the left Navigator, select Templates, select Shells, and then select Projects.","In the Projects Templates log, select and open a project.","In the left Navigator for the project, select Access Control to open the Access Control window.","From the toolbar, click Update Shell Templates.","From the Update Shell Templates window select as many records (modules, BPs, and so on) as you need, click the Update drop-down list, and select the Shell Templates menu item to open the Select Shell Templates pop-up window.","From the Projects list (Projects - Current View: All), select the projects that you want to update, and click Update.","When the Confirmation appears, click Yes to update the selected shell templates.","When the Update Shell Templates window appears, close the window to return to the Access Control window.","In the Update Shell Templates window, when you select as many records (modules, BPs, and so on) as you need and click the Update drop-down list, the following menu items are available:","Shell Templates","All other Shell Templates","History","The Shell Templates menu item is explained above.","All other Shell Templates","If you click the All other Shell Templates menu item, click Yes to update all the shell templates when the Confirmation message appears, or click No to cancel. When you click Yes, the selected modules Access Control information (permissions) are sent (pushed) to all the other shell templates of same shell type, excluding the current source shell template.","History","If you click the History menu item, the Update Shell Templates: History window opens. This window shows the details&#8212;such as Requestor, Shell Templates, Submit Date, and so on&#8212;of the submitted update requests.","In the case of Access Control information, the history details the actions performed as part of Access Control information push to the destination shell templates (all shell templates or the user-selected shell templates).","In the case where in certain shell templates the job is not successful, the history details lists the shell templates where the update has failed and displays the reason for the failure.","Configuration Package and Access Control","For specific modules, you can send Access Control information of a component (or selection of components) into a destination shell template (or a selection of shell templates), from the source shell templates.","If any of the selected components exists in the destination shell template, the Access Control information will be replaced in the destination shell template. ","If any of the selected components do not exist in the destination shell template, the Access Control information will be added in the destination shell template. ","The associated Groups and Users will also be added into the destination shell templates.","Access Control","10299980.htm");
Page[123]=new Array("For specific modules, you can update the Business Process Setup for workflow and non-workflow business processes information in the destination shell templates from a source shell template. For specific modules, you can also update the Workflow Setup information in the destination shell templates from a source shell template. To perform either or both steps, you can use the Update Shell Templates toolbar option. After the update completes successfully, all the selected destination shell templates will have the business process setup for workflow or non-workflow business processes information updated. The modules that do not exist in the destination shell template will get added.","Business Process Setup","To access and work with the Update Shell Templates toolbar option:","Go to the Company Workspace tab and switch to Admin mode.","In the left Navigator, select Templates, select Shells, and then select Projects.","In the Projects Templates log, select and open a project.","In the left Navigator for the project, select Setup, and then select Business Process.","In the Business Processes log, select a BP and open the record.","In the BP record log, select the BP record.","From the toolbar, click Update Shell Templates, and select one of the following:","Shells Templates","If you select this option, the Select Shell Templates window opens, which displays a list of projects that you can select. The projects are listed in the Projects log, and the details of each project are displayed in columns.","Select the projects that you want to update. From the toolbar, click Update. When the Confirmation message appears, click Yes to update the selected shell templates or click No to cancel.","If you click Yes, you will return to the Update Shell Templates window. In the Update Shell Templates window, click Close to exit.","All Other Shell Templates","If you select this option, when the Confirmation message appears, click Yes to update all the shell templates or click No to cancel.","History","If you select this option, the Update Shell Templates: History window opens. This window shows the details of the submitted update requests. In the case of business process setup for workflow and non-workflow business processes, the history details the actions performed as part of information push to the destination shell templates (all shell templates or the user-selected shell templates).","If the job is not successful for specific shell templates, the history details lists the shell templates where the update has failed and displays the reason for the failure.","You can select an item in the list and click Open to see the details about that item.","Note: If the Record Status defined in the source has been inactivated, an error is displayed that requires selection of an active Record Status to continue.","The following cases explain the results of sending various non-workflow and workflow BP setups to the destination shell templates.","When you select a non-workflow BP setup to send or push to the destination shell template and the BP setup does not exist in the destination shell template:","A new BP setup will be added, and the following information (from all the tabs) will be added as part of the business process setup creation. The following tabs information will be added into the destination shell templates, upon successful push from the source shell template. ","General tab","All the information in the General tab (such as setup name, description, help file, default record status, and so on) will be added.","Any Groups or Users who are part of the BP setup will be brought over to the current shell template as members.","If Groups or Users do not exist in the destination shell template, they will be added as shell template members. This could be both Owner Company or Sponsor Company or Partner Company or Member Company users.","If Users exist in the destination shell template, they will be added to the BP setup. Additionally, the system validates whether the user's company exists. If not, the system adds the Partner Company as a Member Company.","Record Editors tab","All the record editors of the existing BP setup will be added.","The Groups or Users selected as record editors will be added as members to the destination shell template, if they do not exist.","View Forms tab","All the View Forms that are associated with the BP setup will be added.","Record Properties tab","All the record properties associated with the BP setup will be added.","Notifications tab","All the options under the Notifications selected will be added in the BP setup that is created in the destination shell template.","Auto creation Setup","All the autocreation settings, including the autocreator, will be added in the BP setup that is created in the destination shell template.","Empty Groups will be added, if they do not exist. The permissions related to the BP setup will be added as part of this update or push. The Last Modified Date value in the BP setup log will be updated to show the latest updated, or added, date.","When you select a non-workflow BP setup to send or push to the destination shell template and the BP setup does exist in the destination shell template:","If the BP setup exists in the destination shell template, the existing BP setup will be replaced.","The tabs information will be replaced with the source shell template BP setup information. ","Groups or Users who do not exist in the destination shell template will be added as part of the BP setup update or push.","When you select a workflow BP setup to send or push to the destination shell template and the BP setup does not exist in the destination shell template:","If the BP setup does not exist in the destination shell template, the BP setup information, tabs information, and autocreation setup information will be replaced.","All the workflows associated to the BP will be added.","The following tabs information will be added into the destination shell templates, upon successful push from the source shell template.","General tab","All the information in the General tab (description, help file, default record status, and so on) will be added.","Any Groups or Users who are part of the BP setup will be brought over to the current shell template as members. Additionally, the system validates whether the user's company exists. If not, the system adds the Partner Company as a Member Company.","Record Editors tab","All the record editors of the existing BP setup will be added.","The Groups or Users selected as record editors will be added as members to the destination shell template, if they do not exist.","View Forms tab","All the View Forms that are associated with the BP setup will be added.","Record Properties tab","All the record properties associated with the BP setup will be added.","Notifications tab","All the options under the Notifications selected will be added in the BP setup that is created in the destination shell template.","Auto creation Setup","Only the autocreation settings will be added in the BP setup that is created in the destination shell template.","You must send or push a workflow BP setup separately.","By sending or pushing the BP setup, you can set up changes in other shell templates without the need to bring in the workflow setups.","For any new workflow BP that must be sent or pushed into shell templates, you can select the Update Shell Templates option from the workflow setup log. This enables the selected workflow, BP setup information, and autocreation workflow setup to be sent or pushed to the destination shell templates.","When you select workflow BP setup to send or push to the destination shell template and the BP setup does not exist in the destination shell template:","If the BP setup exists in the destination shell template, the existing BP setup will be replaced.","The tabs information will be replaced with the source shell template BP setup information. ","Groups or Users who do not exist in the destination shell template will be added as part of the BP setup update or push. The permissions related to the BP setup will be added as part of this update or push. The Last Modified Date value in the BP setup log will be updated to show the latest updated, or added, date.","Workflow Setup","To access and work with the Update Shell Templates toolbar option:","Go to the Company Workspace tab and switch to Admin mode.","In the left Navigator, select Templates, select Shells, and then select Projects.","In the Projects Templates log, select and open a project.","In the left Navigator for the project, select Setup, and then select Business Process.","In the Business Processes log, select and open a BP.","In the left Navigator, select the Workflow Setup functional node to open the Workflow Setup log for the selected BP.","Modify the workflow settings in the General, Settings, and Integration tabs.","Note: The Integration tab displays only if a connection with Oracle Integration is set up and enabled for workflow BPs.","Click Apply and then click OK.","In the Setup log, select the applicable workflow, and from the toolbar click the Update Shell Templates menu and select any of the following options:","Shells Templates","If you select this option, the Select Shell Templates window opens, which displays a list of projects that you can select. The projects are listed in the Projects log, and the details of each project are displayed in columns.","Select the projects that you want to update and click Update. When the Confirmation message appears, click Yes to update the selected shell templates.","All Other Shell Templates","Select this option if you want to update all shell templates. When the Confirmation message appears, click Yes to update to all templates.","History","If you select this option, the Update Shell Templates: History window opens. This window shows the details of the submitted update requests. The history details the actions performed as part of information push to the destination shell templates (all shell templates or the user-selected shell templates).","If the job is not successful for specific shell templates, the history lists the shell templates where the update has failed and displays the reason for the failure.","You can select an item in the list and click Open to see the details about that item.","The following cases explain the results of sending various workflow setups to the destination shell templates.","When you select workflow setups to send or push to the destination shell template, along with the BP setup where the BP does not exist:","Upon successful completion of the push job, the destination shell template will have the workflow setups along with the BP setup. ","New Groups or Users who are associated with either the workflow setup or the BP setup will be added and permissions related to the BP setup will be copied. Additionally, the system validates whether the user's company exists. If not, the system adds the Partner Company as a Member Company.","The last modified date in the BP setup log will be updated to reflect the newly pushed date.","When you select workflow setups to send or push to the destination shell template, along with the BP setup where the BP exists:","In the destination shell template, the BP setup will be replaced with the source shell template BP setup information.","All the existing workflow setups will be replaced with the workflow setups of the source shell template.","New Groups or Users who are associated with either the workflow setup or the BP setup will be added and permissions related to the BP setup will be copied. Similarly, the existing user's permissions related to the BP setup will be updated. Additionally, the system validates whether the user's company exists. If not, the system adds the Partner Company as a Member Company.","The last modified date in the BP setup log will be updated to reflect the newly pushed date.","Business Process and Workflow Setups","10299981.htm");
Page[124]=new Array("To update the destination shell templates with Gates setup:","Go to the Company Workspace tab and switch to Admin mode.","In the left Navigator, select Templates, select Shells, and then select Projects.","In the Projects Templates log, select and open a project.","In the left Navigator for the project, select Setup, and then select Gates to open the Gates Setup log.","Select an item.","From the toolbar, click Update Shell Templates, and select one of the following:","Shells Templates","All Other Shell Templates","History","The following explores each option in detail.","Shells Templates","If you select this option, the Select Shell Templates window opens that displays a list of projects that you can select. The projects are listed in the Projects log, and the details of each project are displayed in columns such as Project Number, Project Name, Status, and so on.","Select the projects that you want to update. From the toolbar, click Update. When the Confirmation message appears, click Yes to update the selected shell templates or click No to cancel.","If you click Yes, the push job gets initiated and the History log will show the job details. The Gates setup will be added or replaced in the destination shell template, upon successful completion of the update or push job.","If there are no existing Gates Setup in the destination shell template, a new Gates Setup will be added, and the information in the General, Settings, and Schedule tabs will be updated.","General tab:","The Setup Name, Description, and Status will be updated based on the source Gates Setup values.","The Status value (Active/Inactive) of the destination shell template Gates Setup will be updated with the source.","Settings tab:","All the phases in the Settings tab will be updated, and the Gates Setup condition elements will be added.","The Groups and Users associated with the additional Gates Setup information will be updated, and they will be added as shell template members if they do not exist. In the case of Groups, only the Groups names will be added.","The Email content and other additional Gates Setup in the Settings tab will be updated according to the Gates Setup information of the source.","Schedule tab:","The details related to the schedule runs of the Gates Setup will be updated with the Gates Setup information of the source.","The Gates Setup log information (such as Name, Status, Last Update Date, Creator, and Current Phase) will be updated with the Gates Setup information of the source.","The Last Update Date value will get updated to the current date and time.","If there are existing Gates Setup in the destination shell template and the current status of the setup is Inactive, the Gates Setup in the destination shell template will be updated, and the status will be updated based on the source Gates Setup.","All Other Shell Templates","If you select this option, when the Confirmation message appears, click Yes to update all the shell templates or click No to cancel.","History","If you click the History menu item, the Update Shell Templates: History window opens. This window shows the details&#8212;such as Requestor, Shell Templates, Submit Date, and so on&#8212;of the submitted update requests.","The History log provides details of each job by showing the actions performed as a part of Gates Setup push to the destination shell templates. ","In the case where in certain shell templates the job is not successful, the history details lists the shell templates where the update has failed and displays the reason for the failure.","You can select an item in the list and click Open, from the toolbar, to see the details about that item.","Gates","10299982.htm");
Page[125]=new Array("To update the destination shell templates with Dashboards setup:","Go to the Company Workspace tab and switch to Admin mode.","In the left Navigator, select Templates, select Shells, and then select Projects.","In the Projects Templates log, select and open a project.","In the left Navigator for the project, select Setup, and then select Dashboards to open the Dashboards log.","Select a dashboard.","From the toolbar, click Update Shell Templates, and select one of the following:","Shells Templates","All Other Shell Templates","History","The following explores each option in detail.","Shells Templates","If you select this option, the Update Shell Templates window opens that displays a list of projects that you can select. The projects are listed in the Projects log, and the details of each project are displayed in columns such as Project Number, Project Name, Status, and so on.","Select the projects that you want to update. From the toolbar, click Update. When the Confirmation message appears, click Yes to update the selected shell templates or click No to cancel.","If you click Yes, the push job gets initiated and the History log will show the job details.","The following definitions from the existing selected Dashboards setups will be added or replaced in the destination shell templates:","Setup information (such as Name, Description, and so on)","The Last Modified Date value will be updated to the current date, and the Creator will be a logged-in user who adds the dashboard.","All the permissions related to the setup will be added or updated. ","The Groups and Users associated with the additional Dashboards setup information will be updated, and they will be added as the shell template members if they currently do not exist.","The following will be copied:","Filters associated with the Dashboards setups.","Custom, Drill-down, Portlet, Standard, and Analytics blocks, from the source Dashboards setups.","The default settings will not change in the destination shell template.","For the existing Dashboard setups, the following additional information will be updated:","New Custom, Drill-down, Portlet, Standard, and Analytics blocks within the tabs will be added or updated. The new tabs will be added to the existing setup.","All the destination shell templates where the Dashboards setups are added or replaced will be listed in the history details.","All Other Shell Templates","If you select this option, when the Confirmation message appears, click Yes to update all the shell templates or click No to cancel.","History","If you click the History menu item, the Shell Template History window opens. This window shows the details&#8212;such as Requestor, Shell Templates, Submit Date, and so on&#8212;of the submitted update requests.","The History log provides details of each job by showing the actions performed as a part of Dashboards push to the destination shell templates. ","In the case where in certain shell templates the job is not successful, the history details lists the shell templates where the update has failed and displays the reason for the failure.","You can select an item in the list and click Open, from the toolbar, to see the details about that item.","You have the option to click the Cancel Request option, from the toolbar, if the request is not in progress or has not been completed.","Dashboards","10299983.htm");
Page[126]=new Array("To update the destination shell templates with Rules setup:","Go to the Company Workspace tab and switch to Admin mode.","In the left Navigator, select Templates, and then select Shells, and then select Projects.","In the Projects Templates log, select and open a project.","In the left Navigator for the project, select Rules to open the Rules log.","Select an item.","From the toolbar, click Update Shell Templates, and select one of the following:","Shells Templates","All Other Shell Templates","History","The following explores each option in detail.","Shells Templates","If you select this option, the Select Shell Templates window opens that displays a list of projects that you can select. The projects are listed in the Projects log, and the details of each project are displayed in columns such as Project Number, Project Name, Status, and so on.","Select the projects that you want to update. From the toolbar, click Update. When the Confirmation message appears, click Yes to update the selected shell templates or click No to cancel.","If you click Yes, the push job gets initiated and the History log will show the job details.","The Rules setup will be added or replaced in the destination shell templates.","All Other Shell Templates","If you select this option, when the Confirmation message appears, click Yes to update all the shell templates or click No to cancel.","History","If you click the History menu item, the Update Shell Templates: History window opens. This window shows the details&#8212;such as Requestor, Shell Templates, Submit Date, and so on&#8212;of the submitted update requests.","The History log provides details of each job by showing the actions performed as a part of Rules push to the destination shell templates. ","In the case where in certain shell templates the job is not successful, the history details lists the shell templates where the update has failed and displays the reason for the failure.","You can select an item in the list and click Open, from the toolbar, to see the details about that item.","You have the option to click the Cancel Request option, from the toolbar, if the request is not in progress or has not been completed.","Rules","10299984.htm");
Page[127]=new Array("To update the destination shell templates with Cash Flow setup:","Go to the Company Workspace tab and switch to Admin mode.","In the left Navigator, select Templates, select Shells, and then select Projects.","In the Projects Templates log, select and open a project.","In the left Navigator for the project, select Cost Manager, and then select Cash Flow.","You can define views for each cash flow detail level to include in the templates. You can also select one view per detail level to function as the default view. For more information, see Defining Global Cash Flow Views for Inclusion in Templates.","In the Cash Flow log, select a cash flow.","If you update a shell template to use a Summary CBS Level that is available in the Cost Sheet for a selected destination, the system creates the applicable Cash Flow; otherwise, the system generates an error.","From the toolbar, click Update Shell Templates, and select one of the following:","Shells Templates","All Other Shell Templates","History","The following explores each option in detail.","Shells Templates","If you select this option, the Update Shell Templates window opens that displays a list of projects that you can select. The projects are listed in the Projects log, and the details of each project are displayed in columns such as Project Number, Project Name, Status, and so on.","Select the projects that you want to update. From the toolbar, click Update. When the Confirmation message appears, click Yes to update the selected shell templates or click No to cancel.","If you click Yes, the push job gets initiated and the History log will show the job details.","The Cash Flow setup will be added or replaced in the destination shell templates.","All Other Shell Templates","If you select this option, when the Confirmation message appears, click Yes to update all the shell templates or click No to cancel.","History","If you click the History menu item, the Shell Template History window opens. This window shows the details&#8212;such as Requestor, Shell Templates, Submit Date, and so on&#8212;of the submitted update requests.","The History log provides details of each job by showing the actions performed as a part of Cash Flow push to the destination shell templates. ","In the case where in certain shell templates the job is not successful, the history details lists the shell templates where the update has failed and displays the reason for the failure.","You can select an item in the list and click Open, from the toolbar, to see the details about that item.","You have the option to click the Cancel Request option, from the toolbar, if the request is not in progress or has not been completed. ","In the History log:","If the destination shell template does not have a Cost Sheet defined, and the user tries to add Cash Flow by CBS or Summary CBS curves, the following message will be displayed in history log: &quot;Cost Sheet is not defined.&quot;","If the selected cash flow curve is of the Commitment type and the Commits BP setup does not exist in the destination shell template, the following message will be displayed in history log: &quot;Business Process &lt;BP name&gt; setup does not exist or is in inactive status.&quot;","If the selected cash flow curve has a schedule selected either from Activity Sheet or Schedule Sheet, and the selected Activity Sheet or Schedule Sheet does not exist in the destination shell template, then when the user saves the properties of the selected cash flow curve in the destination shell template the system will display error message.","Cash Flow","10299985.htm");
Page[128]=new Array("To update the destination shell templates with Cost Sheet Columns setup:","Go to the Company Workspace tab and switch to Admin mode.","In the left Navigator, select Templates, select Shells, and then select Projects.","In the Projects Templates log, select and open a project.","In the left Navigator for the project, select Cost Manager, select Cost Sheet, and open the Project Cost Sheet.","From the toolbar, click Menu Options, select Columns, and then select Manage Columns.","The Cost Sheet Columns window opens.","If applicable, drag and drop the list columns to the order that you want to use.","Select the column, or columns, that you want to use in the update.","From the toolbar, click Update Shell Templates, and select one of the following:","Shell Templates","All Other Shell Templates","History","The following explores each option in detail.","Shell Templates","If you select this option, the Update Shell Templates window opens that displays a list of projects that you can select. You can use Search or Find on Page to isolate the shells you want to update. The projects are listed in the Projects log, and the details of each project are displayed in columns such as Project Number, Project Name, Status, and so on.","Select the projects that you want to update. From the toolbar, click Update. When the Confirmation message appears, click Yes to update the selected shell templates or click No to cancel.","If you click Yes, the push job gets initiated, and the History log will show the job details.","The Cost Sheet Columns setup will be added or replaced in the destination shell templates.","All Other Shell Templates","If you select this option, when the Confirmation message appears, click Yes to update all the shell templates or click No to cancel.","History","If you click the History menu item, the Shell Template History window opens. This window shows the details&#8212;such as Requestor, Shell Templates, Submit Date, and so on&#8212;of the submitted update requests.","The History log provides details of each job by showing the actions performed as a part of Cost Sheet Columns push to the destination shell templates. ","In the case where in certain shell templates the job is not successful, the history details lists the shell templates where the update has failed and displays the reason for the failure.","You can select an item in the list and click Open, from the toolbar, to see the details about that item.","You have the option to click the Cancel Request option, from the toolbar, if the request is not in progress or has not been completed. ","In the History log, if the destination shell template does not have a Cost Sheet defined, the following message will be displayed: Cost Sheet is not defined.","Cost Sheet Columns","10301423.htm");
Page[129]=new Array("You can schedule the creation of snapshots on a weekly, monthly, quarterly, or annual basis and push the snapshot schedule to the cost sheets in other shell templates. After a snapshot schedule is created, you can use the Update Shells Template option to push the schedule to the selected templates. Changes made to the schedule after it is saved must be saved again before it can be pushed to the selected templates.","To update the destination shell templates with a Cost Sheet Snapshots setup:","Go to the Company Workspace tab and switch to Admin mode.","In the left Navigator, select Templates, and then select Shells.","Open the template that you want to update.","In the left Navigator for the shell-type template, select Cost Manager, select Cost Sheet, and open the Cost Sheet template.","From the toolbar, click Menu Options, select Snapshots, and then select Enable Auto Snapshot.","In the Schedule Snapshot dialog box, select the Enable Auto Snapshot check box.","By default, Update Shells is disabled until you create a snapshot schedule.","From the Select Snapshot Frequency list, select the applicable option and then complete the corresponding steps.","If you select Weekly, select the day of the week.","If you select Monthly, select:","Day, and specify a date from 1 through 31. For months that have fewer than 31 days, the system automatically adjusts the schedule depending on the month.","The, and select First, Second, Third, or Fourth, and then select the day of the week.","If you select Quarterly, specify a Day from 1 through 90. Quarters are based on the calendar year.","If you select Yearly, specify a Day from 1 through 365.","In the Range of Occurrence section, specify the Start Date (required) and End Date (optional).","If you want the system to update the Prior Forecast column in the sheet after each snapshot, select the Update Prior Forecasts check box.","If you do not select the Enable Auto Snapshot check box or if you clear it later, the Update Prior Forecasts check box is disabled (dimmed).","To create the scheduled snapshot, click Save.","At the top of the Schedule Snapshot dialog box, click Update Shell Templates, and choose one of the following:","Shells: Use this option to select one or more shell templates to update. When the update window opens, it lists all shell templates in the project. You can use Find on Page to isolate the templates that you want to update. The find window contains data elements from the Find form that was designed. When you have isolated the templates to update, click the Update button.","All Shells: Use this option to update all shell templates of that shell type.","History: Use this option view the update history from past updates or cancel a request before the update begins.","An Alert window opens letting you know that you are about to push changes to the selected shell templates; there is no undo for the update.","If you want to proceed with the update, click Yes; otherwise, click No to cancel.","Cost Sheet Snapshots","10312817.htm");
Page[130]=new Array("To update the destination shell templates with Commitment Funding Sheet setup:","Go to the Company Workspace tab and switch to Admin mode.","In the left Navigator, select Templates, select Shells, and then select Projects.","In the Projects Templates log, select and open a project.","In the left Navigator, select Cost Manager, select Funding, and select Commitment Funding Sheet to open the Commitment Funding Sheet log.","From the toolbar, click Update Shell Templates, and select one of the following:","Shells Templates","All Other Shell Templates","History","The following explores each option in detail.","Shells Templates","If you select this option, the Select Shell Templates window opens that displays a list of projects that you can select. The projects are listed in the Projects log, and the details of each project are displayed in columns such as Project Number, Project Name, Status, and so on.","Select the projects that you want to update. From the toolbar, click Update. When the Confirmation message appears, click Yes to update the selected shell templates or click No to cancel.","If you click Yes, the push job gets initiated and the History log will show the job details.","The Commitment Funding Sheet setup will be added or replaced in the destination shell templates.","The History log will show the job details.","All Other Shell Templates","If you select this option, when the Confirmation message appears, click Yes to update all the shell templates or click No to cancel.","History","If you click the History menu item, the Shell Template History window opens. This window shows the details&#8212;such as Requestor, Shell Templates, Submit Date, and so on&#8212;of the submitted update requests.","The History log provides details of each job by showing the actions performed as a part of Commitment Funding Sheet setup push to the destination shell templates. ","In the case where in certain shell templates the job is not successful, the history details lists the shell templates where the update has failed and displays the reason for the failure.","You can select an item in the list and click Open, from the toolbar, to see the details about that item.","You have the option to click the Cancel Request option, from the toolbar, if the request is not in progress or has not been completed. ","Commitment Funding Sheet","10299986.htm");
Page[131]=new Array("To update the destination shell templates with Document Manager setup:","Go to the Company Workspace tab and switch to Admin mode.","In the left Navigator, select Templates, select Shells, and then select Projects.","In the Projects Templates log, select and open a project.","In the left Navigator for the project, select Document Manager, and then select Documents to open the Documents log.","The Documents log is divided into two panes. The left pane lists the Project Documents and the right pane displays the corresponding details for each document.","In the left pane of the Documents log, select a record.","From the toolbar, click Update Shell Templates, and select one of the following:","Structure &amp; Permissions","Permissions only","History","You can select to update both the structure and permissions of the documents in the destination shell template or just the permissions.","The following explores each option in detail.","Structure &amp; Permissions","The Structure &amp; Permissions option has the following menu items:","Shell Templates","All Other Shell Templates","The following explores each option in detail.","Shells Templates","If you select this option, the Select Shell Templates window opens that displays a list of projects that you can select. The projects are listed in the Projects log, and the details of each project are displayed in columns such as Project Number, Project Name, Status, and so on.","Select the projects that you want to update. From the toolbar, click Update. When the Confirmation message appears, click Yes to update the selected shell templates or click No to cancel.","If you click Yes, the push job gets initiated and the History log will show the job details.","The applicable document type setup will be added or replaced in the destination shell templates.","The History log will show the job details.","All Other Shell Templates","If you select this option, when the Confirmation message appears, click Yes to update all the shell templates or click No to cancel.","Permissions only","The Permissions only option has the following menu items:","Shell Templates","All Other Shell Templates","The following explores each option in detail.","Shells Templates","If you select this option, the Select Shell Templates window opens that displays a list of projects that you can select. The projects are listed in the Projects log, and the details of each project are displayed in columns such as Project Number, Project Name, Status, and so on.","Select the projects that you want to update. From the toolbar, click Update. When the Confirmation message appears, click Yes to update the selected shell templates or click No to cancel.","If you click Yes, the push job gets initiated and the History log will show the job details.","The applicable document type setup will be added or replaced in the destination shell templates.","The History log will show the job details.","All Other Shell Templates","If you select this option, when the Confirmation message appears, click Yes to update all the shell templates or click No to cancel.","History","If you click the History menu item, the Shell Template History window opens. This window shows the details&#8212;such as Requestor, Shell Templates, Submit Date, and so on&#8212;of the submitted update requests.","The History log provides details of each job by showing the actions performed as a part of the Documents setup push to the destination shell templates.","In the case where in certain shell templates the job is not successful, the history details lists the shell templates where the update has failed and displays the reason for the failure.","You can select an item in the list and click Open, from the toolbar, to see the details about that item.","You have the option to click the Cancel Request option, from the toolbar, if the request is not in progress or has not been completed.","Document Manager","10299987.htm");
Page[132]=new Array("To update the destination shell templates with General Spends setup:","Go to the Company Workspace tab and switch to Admin mode.","In the left Navigator, select Templates, select Shells, and then select Projects.","In the Projects Templates log, select and open a project.","In the left Navigator for the project, select Cost Manager, select Schedule of Values, and then select General Spends to open the Schedule of Values: General Spends log.","Select an item.","From the toolbar, click Update Shell Templates, and select one of the following:","Shells Templates","All Other Shell Templates","History","The following explores each option in detail.","Shells Templates","If you select this option, the Select Shell Templates window opens that displays a list of projects that you can select. The projects are listed in the Projects log, and the details of each project are displayed in columns such as Project Number, Project Name, Status, and so on.","Select the projects that you want to update. From the toolbar, click Update. When the Confirmation message appears, click Yes to update the selected shell templates or click No to cancel.","If you click Yes, the push job gets initiated and the History log will show the job details.","The General Spends setup will be added or replaced in the destination shell templates.","The History log will show the job details.","All Other Shell Templates","If you select this option, when the Confirmation message appears, click Yes to update all the shell templates or click No to cancel.","History","If you click the History menu item, the Shell Template History window opens. This window shows the details&#8212;such as Requestor, Shell Templates, Submit Date, and so on&#8212;of the submitted update requests.","The History log provides details of each job by showing the actions performed as a part of the General Spends setup push to the destination shell templates. ","In the case where in certain shell templates the job is not successful, the history details lists the shell templates where the update has failed and displays the reason for the failure.","You can select an item in the list and click Open, from the toolbar, to see the details about that item.","You have the option to click the Cancel Request option, from the toolbar, if the request is not in progress or has not been completed. ","General Spends (SOV Structure)","10299990.htm");
Page[133]=new Array("To update the destination shell templates with Payment Applications setup:","Go to the Company Workspace tab and switch to Admin mode.","In the left Navigator, select Templates, select Shells, and then select Projects.","In the Projects Templates log, select and open a project.","In the left Navigator for the project, select Cost Manager, select Schedule of Values, and then select Payment Applications to open the Schedule of Values: Payment Applications log.","Select an item.","From the toolbar, click Update Shell Templates, and select one of the following:","Shells Templates","All Other Shell Templates","History","The following explores each option in detail.","Shells Templates","If you select this option, the Select Shell Templates window opens that displays a list of projects that you can select. The projects are listed in the Projects log, and the details of each project are displayed in columns such as Project Number, Project Name, Status, and so on.","Select the projects that you want to update. From the toolbar, click Update. When the Confirmation message appears, click Yes to update the selected shell templates or click No to cancel.","If you click Yes, the push job gets initiated and the History log will show the job details.","The Payment Applications setup will be added or replaced in the destination shell templates.","The History log will show the job details.","All Other Shell Templates","If you select this option, when the Confirmation message appears, click Yes to update all the shell templates or click No to cancel.","History","If you click the History menu item, the Shell Template History window opens. This window shows the details&#8212;such as Requestor, Shell Templates, Submit Date, and so on&#8212;of the submitted update requests.","The History log provides details of each job by showing the actions performed as a part of the Payment Applications setup push to the destination shell templates. ","In the case where in certain shell templates the job is not successful, the history details lists the shell templates where the update has failed and displays the reason for the failure.","You can select an item in the list and click Open, from the toolbar, to see the details about that item.","You have the option to click the Cancel Request option, from the toolbar, if the request is not in progress or has not been completed. ","Payment Applications (SOV Structure)","10299991.htm");
Page[134]=new Array("To update the destination shell templates with Summary Payment Applications setup:","Go to the Company Workspace tab and switch to Admin mode.","In the left Navigator, select Templates, select Shells, and then select Projects.","From the Projects Templates log, select and open a project.","In the left Navigator, select Cost Manager, select Schedule of Values, select Summary Payment Applications, and then select the applicable SOV functional sub-node.","The Schedule of Values: Summary Payment Applications log appears.","From the toolbar, click Update Shell Templates, and select one of the following:","Shells Templates","All Other Shell Templates","History","The following explores each option in detail.","Shells Templates","If you select this option, the Select Shell Templates window opens that displays a list of projects that you can select. The projects are listed in the Projects log, and the details of each project are displayed in columns such as Project Number, Project Name, Status, and so on.","Select the projects that you want to update. From the toolbar, click Update. When the Confirmation message appears, click Yes to update the selected shell templates or click No to cancel.","If you click Yes, the push job gets initiated and the History log will show the job details.","The Commitment Funding Sheet setup will be added or replaced in the destination shell templates.","The History log will show the job details.","All Other Shell Templates","If you select this option, when the Confirmation message appears, click Yes to update all the shell templates or click No to cancel.","History","If you click the History menu item, the Shell Template History window opens. This window shows the details&#8212;such as Requestor, Shell Templates, Submit Date, and so on&#8212;of the submitted update requests.","The History log provides details of each job by showing the actions performed as a part of Summary Payment Applications setup push to the destination shell templates. ","In the case where in certain shell templates the job is not successful, the history details lists the shell templates where the update has failed and displays the reason for the failure.","You can select an item in the list and click Open, from the toolbar, to see the details about that item.","You have the option to click the Cancel Request option, from the toolbar, if the request is not in progress or has not been completed. ","Summary Payment Applications (SOV Structure)","10299992.htm");
Page[135]=new Array("To accommodate multiple contract types or commitments in a project, you can now include more than one Base Commit BP wherein each Base commit BP is associated with a payment application and a distinct schedule of values (SOV).","Note: With this setup, you are no longer limited to configuring only one Base Commit BP with a payment application and SOV in each project.","You can also watch the video: Using Multiple Payments in a Single Shell","Prerequisite","You have created one or more Base Commit BPs with payment applications and corresponding SOVs.","Business Process Setup Procedure for Shell Templates","To set up multiple Base Commit BPs with payment applications and corresponding SOVs in shell templates:","Select the Company Workspace tab and switch to Admin mode.","In the left Navigator, select Templates, select Shells, and select Projects.","In the Project Templates log on the right pane, select a project/shell template. ","In the left Navigator of the selected project/shell template, select Setup, and select Business Process.","In the Business Process Setup - Current View log, click New.","In the New Business Processes window, select a Base Commit BP with payment applications. ","Click OK to include the Base Commit BP in the Business Process Setup - Current View log.","Repeat the above step sequence to add multiple Base Commit BPs.","Click OK to confirm the alert message that displays when you add subsequent Base Commit BPs in the project/shell template.","With this setup, the Schedule of Values log is relocated in the left Navigator. Contact your Company Administrator if you do not have access to the new SOV log location.","To set up a workflow for each Base Commit BP added in the Business Process Setup - Current View log:","In the left Navigator, select Setup, select Business Process, select [Base Commit BP Name], and select Workflow Setup.","In the &lt;BP Name&gt; Setup - Current View log, add or modify the workflow of the Base Commit BP.","To verify that a Schedule of Values (SOV) is created for each Base Commit BP in the project/shell template: ","In the left Navigator, select Cost Manager, select Schedule of Values, and select Payment Applications.","Confirm you can view the new Schedule of Values node created for each Base Commit BP.","Proceed to create a SOV structure for each Schedule of Values node. For more details, see Payment Applications (SOV Structure).","To update the above modifications from shell templates in individual shells, see Update Schedule of Values Structure.","To grant users with permissions to access and use multiple Base Commit BPs:","If User Mode Navigator is not defined: ","In the left Navigator, select Access Control node in the selected shell template.","In the right pane, select User Mode Access, select Financial Analysis, select Schedule of Values, and select Payment Applications (a new node listing multiple Base Commit SOVs)","For example, the following nodes display in Access Control by default: ","Schedule of Values, followed by Payment Applications","Schedule of Values, followed by Payment Applications, followed by [Base commit BP Name], followed by - SOV","If User Mode Navigator is defined:","In the left Navigator, select the Access control node in the selected shell template.","In the right pane, select User Mode Access, and select [select the custom-defined node containing the multiple Base Commit SOVs].","For example, the following nodes display in Access Control by default: ","Schedule of Values, followed by Payment Applications","User Mode Navigator for project/shell displays [Base commit BP Name] - SOV","In the Access Control log on the right pane, select Schedule of Values, and select Payment applications.","Select each SOV node and set up permissions and user access. For more details, see Updating Shells - Access Control Node.","Note: It is recommended to delete user groups that will no longer be used if all users have been given access to multiple Base Commit BPs. ","Create and import a configuration package to include multiple Base Commit BPs with the associated BP setups, shell templates, shells, SOV structures, and change commits.","For more details, see Creating Configuration Packages.","Setting Up Shell Templates with Multiple Base Commit BPs with Multiple Payment Applications and SOVs","10316296.htm");
Page[136]=new Array("To update the destination shell templates with Reports setup:","Go to the Company Workspace tab and switch to Admin mode.","In the left Navigator, select Templates, select Shells, and then select Projects.","In the Projects Templates log, select and open a project.","In the left Navigator for the project, select Reports, and then select User-Defined to open the User-Defined Reports log.","In the log, select the needed reports.","From the toolbar, and Update Shell Templates and select one of the following:","Shells Templates","All Other Shell Templates","History","The following explores each option in detail.","Shells Templates","If you select this option, the Select Shell Templates window opens that displays a list of projects that you can select. The projects are listed in the Projects log, and the details of each project are displayed in columns such as Project Number, Project Name, Status, and so on.","Select the projects that you want to update. From the toolbar, click Update. When the Confirmation message appears, click Yes to update the selected shell templates or click No to cancel.","If you click Yes, the push job gets initiated and the History log will show the job details.","The User-Defined Reports setup will be added or replaced in the destination shell templates.","The History log will show the job details.","All Other Shell Templates","If you select this option, when the Confirmation message appears, click Yes to update all the shell templates or click No to cancel.","History","If you click the History menu item, the Shell Template History window opens. This window shows the details&#8212;such as Requestor, Shell Templates, Submit Date, and so on&#8212;of the submitted update requests.","The History log provides details of each job by showing the actions performed as a part of the User-Defined Reports setup push to the destination shell templates.","In the case where in certain shell templates the job is not successful, the history details lists the shell templates where the update has failed and displays the reason for the failure.","You can select an item in the list and click Open, from the toolbar, to see the details about that item.","You have the option to click the Cancel Request option, from the toolbar, if the request is not in progress or has not been completed.","Reports (User-Defined Reports)","10300238.htm");
Page[137]=new Array("You can update the Activity Sheets that are used in destination shell templates. If applicable, any views that you defined are also included in the update (for more information, see Defining Activity Sheet and System Activity Sheet Views for Inclusion in Templates).","To update the destination shell templates with Activity Sheets setup:","Go to the Company Workspace tab and switch to Admin mode.","In the left Navigator, select Templates, select Shells, and then select Projects.","In the Projects Templates log, select and open a template.","In the left Navigator, select Activity Manager, and then select Activity Sheet.","In the Activity Sheets log, select an item.","From the toolbar, click Update Shell Templates, and select one of the following:","Shells Templates","All Other Shell Templates","History","The following explores each option in detail.","Shells Templates","If you select this option, the Update Shell Templates window opens that displays a list of projects that you can select. The projects are listed in the window, and the details of each project are displayed in columns such as Project Number, Project Name, Status, and so on.","Select the projects that you want to update. From the toolbar, click Update. When the Confirmation message appears, click Yes to update the selected shell templates, or click No to cancel.","If you click Yes, the push job gets initiated and the History log will show the job details.","The Activity Sheets setup will be added or replaced in the destination shell templates.","All Other Shell Templates","If you select this option, review the message that is displayed in the Confirmation message, and click Yes to update all the shell templates or click No to cancel.","History","If you click the History menu item, the Update Shell Templates: History window opens. This window shows the details&#8212;such as Requestor, Shell Templates, Submit Date, and so on&#8212;of the submitted update requests.","The History log provides details of each job by showing the actions performed as a part of Activity Sheet push to the destination shell templates. ","In the case where in certain shell templates the job is not successful, the history details lists the shell templates where the update has failed and displays the reason for the failure.","You can select an item in the list and click Open, from the toolbar, to see the details about that item.","You have the option to click the Cancel Request option, from the toolbar, if the request is not in progress or has not been completed.","Activity Sheets","10299993.htm");
Page[138]=new Array("You can define multiple global views for multiple activity sheets and one system activity sheet and link them to all or specific projects/shells so that they are listed in the View menu. This improves the ability of users on the same project and different projects to view information in a similar way even for different configurations. You can also define one of the views for activity sheet as the default.","You can update these views at any time and link them to all or specific projects/shells as the need arises. While these global views cannot be changed by the users, they can use them as the basis for creating their own views.","To define a view for a template:","Go to the Company Workspace tab and switch to Admin mode.","In the left Navigator, select Templates, select Shells, and then select Projects.","In the Projects Templates log, select and open the applicable project.","In the left Navigator, select Activity Manager, and then select Activity Sheet.","In the Activity Sheets log, select and open the applicable template.","Note: To create a view for the system activity sheet, you are allowed to create one template and define views for it. If the system activity sheet has not been created yet, from the toolbar, click Create, and select System Activity Sheet.","From the View menu, select Create New View.","In the Save View As field of the New View window, enter a name for the new view.","Use the various tabs for adding columns and filtering, grouping, and sorting information.","Use the Columns tab to select the columns that you want displayed in the view.","The Available Columns box displays all the columns that you might want to include. The Selected Columns box displays all the columns that you select. You can move columns in and out of the Selected Columns box.","Use the following fields to set the position of the new view:","Left Lock after Column: Displays a list of all columns, except the last column from the selected columns list. By default, None is selected, which means that you have chosen no column to be locked, from the left side of the sheet.","Right Lock after Column: The default value is None, which means that you can select not to right-lock the column in the view. Other values in this field are based on the value that you have selected in the Left Lock after Column.","In addition to the previous sections, there are three options located after the Selected Columns section: Group Management, Group Selected Columns, and Delete Group.","Use the Filters tab to control what information is displayed in the selected view.","Use the Group By and Sort By tabs to identify which columns should be used for group and sorting and in what order.","When you are done, click Save.","Defining Activity Sheet and System Activity Sheet Views for Inclusion in Templates","10317727.htm");
Page[139]=new Array("After you have defined templates, you can specify one of the templates as the default for managing views.","To specify a default template:","Go to the Company Workspace tab and switch to Admin mode.","In the left Navigator, select Templates, select Shells, and then select Projects.","In the Projects Templates log, select and open the applicable project.","In the left Navigator, select Activity Manager, and then select Activity Sheet.","In the Activity Sheets log, select the applicable template, click the gear menu ( @ ), and select Mark as Default.","The Default column displays Yes for the applicable template.","If another template was currently set as the default, the system removes the label from the Default column for that template.","To remove a default label:","Go to the Company Workspace tab and switch to Admin mode.","In the left Navigator, select Templates, select Shells, and then select Projects.","In the Projects Templates log, select and open the applicable project.","In the left Navigator, select Activity Manager, and then select Activity Sheet.","In the Activity Sheets log, select the applicable template, click the gear menu ( @ ), and select Reset Default.","Setting Default Activity Sheet Views for Templates","10317728.htm");
Page[140]=new Array("All shared views in a template that are set to Visible are displayed to those who have the applicable permissions when they access a sheet that uses the template. If you update, hide (clear the Visible check box), or delete a view, these changes are automatically applied to the corresponding sheet.","To update a view for a template:","Go to the Company Workspace tab and switch to Admin mode.","In the left Navigator, select Templates, select Shells, and then select Projects.","In the Projects Templates log, select and open the applicable project.","In the left Navigator, select Activity Manager, and then select Activity Sheet.","In the Activity Sheets log, select and open the applicable template.","From the View menu, select Manage Views.","Use the Manage Views dialog box to:","Change the order of the views in the View menu for the projects/shells.","Make a view visible or hide it.","Delete a view.","The current Active View is marked with a green check mark. ","To save your changes, click Save.","Managing Activity Sheet Views for Templates","10317729.htm");
Page[141]=new Array("The shell details page (Details) displays the View Forms tab. To access the shell details page:","Go to the Company Workspace tab and switch to Admin mode.","In the left Navigator, select Company Sponsored Shells, select the [shell type], and open the [shell instance].","In the upper-right corner, click My Dashboard (three dots), and then select Details.","The View Forms tab is available in all shell types (single shell or multiple instance shell) details page, when there are View forms defined and deployed for that shell type.","The View Forms tab is not available:","If the design does not have a View form.","For shell designs deployed prior to this upgrade.","In the View Forms tab, click the add option (plus icon) to add the View forms (from a list of forms displayed in the Select View Forms window) that are associated with the shell. You, the administrator, can select multiple View forms to add. After adding the View forms, you can remove or change the forms sequence. You can use the gear menu ( @ ) to remove multiple View forms.","After you add the View forms and click Add, the system opens the User and Group Picker window which displays all active users or groups that are associated with the Shell. Multiple users and groups can be added to the viewers list.","Click Done when finished. The Details page will split in two and the right side displays the Permissions Settings block along with the Add Viewers field.","If you assign users and groups to a View form, the assigned users and groups can only see the General tab of the form.","If the users or groups have permission to view multiple View forms, they will see the View forms based on the sequence listed in the Details window, under the Form Name block.","Click Done when finished.","If a user or group has access to multiple View forms, the user or group will see the first View form that they have access to, based on the sequence of the View forms listed.","For example, if user 'U1' has access to both View Forms VF01 and VF02 both, when U1 views the General tab of the shell details, the VF01 is displayed if the VF01 is the first View form in the sequence order of forms displayed.","Setting Up View Forms in Shell Attributes","10293788.htm");
Page[142]=new Array("External emails are important communications that need to be included in shells. Such emails can come from project team members or from External Users who do not use Unifier. These email communications (and any attachments) can be collected in a central repository for the shell, called a Mailbox. After such emails reside in the shell's Mailbox, users can view them, forward them to appropriate members, flag them for review, and reply to them. In addition, these external emails can be linked to business process records.","Note: External emails that have been blind carbon-copied (Bcc) are not collected by the Mailbox.","When Unifier is installed on your system, a dedicated email address for your company is specified, and whenever a shell is created, Unifier assigns it a unique identifier. Unifier combines this email address and shell identifier to create the shell's Mailbox.","Note: To prevent spam and virus attacks, you will need to create a list of approved email addresses that will be accepted by the shell. For more information, see Creating an Approved Email List for Project/Shell Mailboxes in the Unifier General Administration Guide.","When you create a shell, you can notify all shell participants, both within and outside of Unifier, of the shell's email address. For more information, see Create a Shell Manually.","Dedicated Mailbox for Shells","74300.htm");
Page[143]=new Array("Navigation from the Landing Page to a specific place in the sub-shell hierarchy requires permissions. Permissions can be:","Granted on an instance-by-instance basis","Pushed through shell templates","Users can be managed through groups or added individually to instances","User Permissions and Navigation","74301.htm");
Page[144]=new Array("Before you begin: Verify that the list of phases resides in the Phase data definition drop-down (pull-down) data set. This is the same list that is used when selecting a phase manually in the shell properties window. You can add or modify the default list as needed. This list makes the phases available for any shell instance or shell type template; for each shell or template, you select which of the phases to use. Create any business processes that you plan to use to drive gates conditions and phase completion.","Step 1: Define Phases. For each shell instance or shell type template, you define the list of phases to include in the setup, choosing from the entire list in the Phase data set.","Step 2: Define Gate Conditions. For each phase, define one or more gate conditions. A gate condition is a combination data element and trigger condition that enable transition to the next phase.","Step 3: Schedule Gates runs. The gates run the validation of gate conditions. You can schedule runs automatically. This is optional.","Step 4: Activate the Gates setup.","Step 5: Define permissions.","Notes:","If you create a shell by copying a shell template or an existing shell, any existing gates setup in the source shell is copied into the new shell, including the gates status. The gates phases are restarted at the first phase in the new shell, and the scheduled Gates Run is activated.","The DE of type Rich Text DE is not available to be added as a Gate Condition Element (Gates, and select Settings). ","How to Set Up Gates","74364.htm");
Page[145]=new Array("You will be setting up phases in gates to represent the actual phases of a shell. For the shell to advance from one phase to another, certain conditions must be met. This example will discuss phases, conditions, and using business processes in the context of the conditions to advance a shell from one phase to another.","For example, phases for shell Zero could be:","Preliminary","Investigation","Definition","Measurement","Analysis","Start","Control","Previously, you have set up two business processes to use in the conditions for your gates setup. These are:","Schedule: A single record business process that is updated manually by a shell manager by selecting check boxes for the various phases such as Definition Phase Complete? or Measurement Phase Complete?","Funding: A workflow business process that is automatically updated through the steps of the workflow.","As the shell manager reviews the check boxes in the phases as represented in the Schedule business process, the Gates Runs keep reviewing the statuses of the check boxes. As they are checked off, the project advances to the next phase.","The exception to this procedure is the transition from the Analysis phase to the Start phase. Additional approval is needed for funding for the project to advance from Analysis to Start. The Funding business process is included in the conditions for the Analysis phase. This business process must have the status Construction Approved and have a value of greater than zero for the Analysis phase to be exited and the Start phase entered for the project.","Example of a Gates Setup and Conditions","74365.htm");
Page[146]=new Array("To view the phase list:","Go to the Company Workspace tab and switch to Admin mode.","In the left Navigator, select Data Structure Setup, select Data Definitions, and then select Basic.","Select the Phase data definition and click Open. The Modify Data Definitions window opens.","Click the Data Set tab. The active phases on this list will be available for phase setup.","Modify the list as needed. Any changes you make here will be reflected in new gates setups. Current setups will not be affected.","Define the Phase List","74366.htm");
Page[147]=new Array("You can create a gates setup in shell templates and in individual shells. There can be one setup per shell instance.","To create a gates setup:","Do one of the following:","To create the setup in a shell type template, go to the Company Workspace tab and switch to Admin mode. In the left Navigator, select Templates, and then select Shells. Open the shell template.","To create the setup in a shell instance, go to the Company Workspace tab and switch to Admin mode. In the left Navigator, select Company Sponsored Shells. Open the shell instance.","In the left Navigator, select Setup, and then select Gates. The Gates Setup log opens.","Click New. The gate setup is created automatically. Double-click the setup, or select from the list and click Open. The Gates Setup window opens. There are three tabs: General, Settings, Schedule.","In the General tab, enter a Setup Name, which displays in the log, and an optional Description. At this point, Status is Inactive by default.","In the Settings tab, define phases and gates conditions.","In the Schedule tab, schedule regular gates, if applicable.","Create a Gates Setup","74367.htm");
Page[148]=new Array("This section describes how to delete a Gates setup from a shell manually.","Note: You can delete a Gates setup from a specific shell template but not from other Projects/Shells that have been created using the template.","Go to the Company Workspace tab and switch to Admin mode.","In the left Navigator, select Templates, and then select Shells.","Open the shell template.","In the left Navigator, select Setup, and then select Gates.","Select a Gates setup for deletion.","Click Delete. ","When the prompt appears that asks you to confirm deletion, click Yes to delete the Gates setup.","Delete a Gates Setup","10293655.htm");
Page[149]=new Array("Select which of the phases to use in the shell or shell template from the available phase list. You can reorder them as necessary for the shell instance or shell type template.","To add phases to the new gates setup:","Open the Gates Setup window and click the Settings tab.","In the Phases pane, click the Add button. The Select Phases window opens, displaying the list of available phases.","Select one or more phases to add to the list. To select multiple phases, hold down the CTRL or SHIFT keys while selecting.","Click OK. The phases appear in the Phases list.","The order in which the phases appear on the list is the order they will be followed in the shell. The first phase on the list will be the first phase of the shell.","Add Phases to the Gates Setup (Settings Tab)","74368.htm");
Page[150]=new Array("To access the gate configuration view:","Select a phase. The gate configure view opens in the right pane. See the following table for more information about the gate configuration view.","The Phase Gate Configuration section in the navigator lists the Phases for the current shell. The visual order of the Phases depends on the Order specified in the General tab.","The Gates Conditions Elements section lets you define condition criteria per element. Gate Elements will be selected from all data sources and modules available in a particular shell (for the Sponsoring company).","In this field","Do this","Start Date","The Start date for a particular Phase can be manually set or auto populated from a Schedule Sheet by linking it to a particular activity or milestone (activity with zero duration and marked as milestone) where it will update dynamically based on the start date associated with this activity. If there are multiple Start dates, choose the Start date used to set Gantt Charts in Schedule Manager. ","The start date must fall within Shell date ranges.","Planned Completion","Can be manually set or auto populated from a Schedule Sheet by linking it to a particular activity or milestone (activity with zero duration and marked as milestone) where it will update dynamically based on the start date associated with this activity. If there are multiple End dates, choose the End date used to set Gantt Charts in Schedule Manager. ","Note: Dates are for reporting only. Phases cannot be date driven.","Advance to Next Phase","This check box enables automatic phase advancement. Select the check box if you want the shell to move automatically to the next phase after all Gate Elements for a particular Phase have been checked.","Notify users on Phase Completion","Lets you define users who receive phase completion notification. You can configure the body text in the notification (similar to the business process Setup on the End Step, where you can specify the message text content.","Reevaluate conditions on every Gates run","When selected, this check box specifies that processing always starts at the First phase during a scheduled Gates Run/Refresh. You might have to scroll down to see this check box.","If the check box is not selected for a phase:","If the phase is currently incomplete, incomplete conditions are evaluated and completed conditions are skipped","If the phase is currently complete, phase processing is skipped","If the check box is selected in a phase:","Every condition in that phase is reevaluated. Including conditions that were met","All conditions (except conditions that were marked as &quot;ignore&quot; manually) are marked as incomplete at the beginning of every Gates Run and refresh.","Saved Gates Run (PDF) from prior runs persist. Processing will stop at a Phase where first un-met condition is encountered. By default, this check box is deselected.","Access Gate Configuration View","74369.htm");
Page[151]=new Array("To add a Gate Condition Element:","In the Gate Conditions Elements section of the Gates Setup window, select a phase and click Add. The Data Type window opens.","Select a data type from the Data Type list, and click OK.","In the Edit Gate Condition window, complete the General tab","Name: Enter a name for the Gate Element. This can be the name of the data element or any descriptive name. This appears on the Gate Conditions Elements list. ","Description: Add an optional description for the Gate Element.","Click Apply to save changes, or OK to save changes and exit the window.","In the Edit Gate Condition window, complete the Query tab to define query and trigger conditions.","In the Query Conditions section, click Add.","In the Query Condition window, complete the Query tab:","Data Element: Click Select. ","In the Data Element Picker window: ","Data Source: Select a data source from the Data Source list. For example, select a query-based tab. ","Column: Select a data element and then click OK. ","Note: The list of data elements is generated from the data type you chose in the General tab. If the data element is a picker, drop-down (pull-down), or radio button, the Value field will display the values entered in the data set tab for the data definition associated with the data element. For a full list of data elements and data types, refer to the Unifier Data Reference Guide.","Label: The label defaults to the data element name. You can enter a different label.","Condition: Select the condition that needs to be satisfied for the Gates Element Condition from the list. The condition options vary dynamically depending on the selected Data Element. ","Values: Specify a value for the condition. The Values field varies dynamically depending on the selected Data Element and Condition. For example, if the element is a text box, the condition might be Contains, and Value might be one or more letters to search for. If the element is a drop-down (pull-down) or other data definition with a data set, you will select a value from the data set.","Show results matching any condition (Instead of all): Select this check box if you have defined multiple query conditions, for which only one needs to be satisfied to advance to the next phase","The Trigger Condition section operates similar to the Query Conditions section, except you can create a formula for the desired condition.","Configure Gate Elements","74370.htm");
Page[152]=new Array("To change the order of the phases in a gates setup:","Select a phase and click the Move Up or Move Down button.","Change the Order of Phases","74371.htm");
Page[153]=new Array("You can define a Gates Run schedule in the Gates Setup window, Schedule tab. This run evaluates gates conditions and marks completed conditions as Complete. The update process can also be invoked manually in user mode. The scheduler engine is a background process.","In this field:","Do this:","Enable Scheduled Gates Runs","Select this check box to enable scheduled updating of Gate Elements. Deselecting this check box will disable the scheduler, and any scheduled future runs will be canceled immediately.","The scheduled gates runs are disabled in the last phase provided all conditions are met, and the Enable Scheduled Gates Runs check box is automatically deselected.","Frequency","Choose Frequency of the Scheduled Gates Runs (Daily, weekly, monthly, quarterly, yearly)","Range of Recurrence","You can specify a date on which the Gate Runs will end, or no end date.","Auto-email as PDF Attachment to Gates creator","Select this check box to enable automatic emailing of the scheduled run results as a PDF attachment. The report displays the current status of each phase and gate condition.","Define Gates Runs Schedule (Schedule Tab)","74372.htm");
Page[154]=new Array("Activating a gates setup will enable the scheduled gates runs. After activation, if you must edit the gates setup, you will need to deactivate it first. To change the status of the gates setup, use the Status drop-down menu in the Gates Setup log.","You can make edits while the setup is inactive, including: adding or removing phases; reordering phases; adding, modifying, or removing conditions within a phase.","Some notes about activating/deactivating gates setup:","Reactivating an active shell: If you temporarily deactivate a shell that is in process and then reactivate it, the gates check will start over at the first phase. This is because the setup needs to check all phases for new phase additions or new gate conditions that may have been added. You can manually update the phases by clicking the Refresh button for gates in User mode. This will evaluate all phases starting from the first phase, even if the phase has been marked Complete, and mark the first phase as the current phase.","Note: This may trigger email notifications regarding gates advancement, as set up in the Settings tab (where the users who are notified are defined) and those users' email subscription settings (User Preferences).","While a gates setup is Inactive: No scheduled gates run will be done. To manually advance phases in User Mode Gates for the shell, the gates setup must be active.","View-Only and Inactive shells: If a shell has the View-Only or Inactive status, the gates setup is inactivated, and you must manually reactivate the setup.","Activate or Deactivate a Gates Setup","74373.htm");
Page[155]=new Array("To grant User Mode Gates permissions:","In Access Control or Permissions window, navigate to User Mode Access, expand Projects/Shells, and then select Gates. The permissions are: ","Change Phase: Allows the user to change gates phases.","Modify and Refresh: Allows the user to modify gates and refresh gates.","Refresh: Allows the user to refresh gates.","View: Allows the user to view gates.","Set User Permissions for Gates","74288.htm");
Page[156]=new Array("If you have a large number of shells that need similar edits, you can use bulk edit to update all of them at once. You can update a maximum of 200 records using bulk shell edit. The bulk edit must be defined in uDesigner, and you must have the Allow Bulk Edit permission set on the shells to use the bulk edit. ","The bulk edit function works only on fields from the action form (upper form) for the current step. It cannot be used to edit the following:","Auto-populated fields","Fields in a dynamic data set","Read-only fields","System-generated fields, such as record number, status, or due date","BP Line Item Data Picker","BP Data Picker if it has an associated Line Item Data Picker configured","Notes:","An Integration interface must be created for Bulk Edit to work with Shells.","You can use bulk processing to update users in shells. For more information, see Managing Users in Bulk in the Unifier General Administration Guide.","To edit shells using bulk edit:","Go to the Company Workspace tab and switch to Admin mode.","In the left Navigator, select Company Sponsored Shells.","Open a shell type and select one or more shells, or perform a Find to search for a group of shells to work with.","You can select the shells from the shell log or the Find log.","From the toolbar, click Actions, and select Bulk Edit.","The Bulk Edit window displays. The fields displayed in this window depend on what was specified for the shell.","The Bulk Edit form includes all editable fields for the shell. All system-generated elements and formula columns are automatically recalculated during the bulk edit for each record.","Modify the Bulk Edit form as needed.","Select the Update check box for the fields you want to update.","The check box is automatically selected when you type into or modify a field. You can deselect it if you do not want to modify the field at this time.","To launch the bulk update of the selected records, click Update.","The Bulk Actions Status window opens after you click Update. This window lets you monitor the progress of the bulk update.","Note: If the Record Status defined for any of the targeted shells been inactivated, an error is displayed that requires selection of an active Record Status to continue.","Click OK after all records have processed. Click Cancel if you want to cancel the bulk update in progress.","Editing Multiple Shells at Once with Bulk Edit","74374.htm");
Page[157]=new Array("Shell dashboards display project data in an at-a-glance format. You can control the dashboard appearance and content and make it specific to the shell with which you are working; however, shell dashboards cannot pull data from across shell hierarchies. For example, consider two anchor shells, which are seen as tabs, one is labeled &quot;Capital Projects,&quot; and one is labeled &quot;Facilities.&quot; The Capital Projects dashboard can display data from all levels of the Capital Projects hierarchy; however, it cannot display Facilities data because Facilities is the root of a separate, independent hierarchy.","Two types of dashboards are available in project shells:","My Dashboard: All shells have a personal dashboard that a user can define if he or she has Setup permission. A user can configure My Dashboard in User mode using the Edit Dashboard window. Users can select My Dashboard from the View Dashboard (drop-down list) on each shell.","Shell dashboards: Shell dashboards allow users to view shell and subordinate shell data. This differs from My Dashboard in that a user cannot share his or her personalized dashboard. Administrators can create multiple shell dashboards per shell and push them via templates. Users can select this type of dashboard to view from the View Dashboard (drop-down list) on each shell. These dashboards are maintained at the shell level and are available to any user to view (but not edit) provided the user has permissions.","Each shell dashboard has at least one tab and can have up to five tabs. The default tab name is Summary, which you can change. The default shell dashboard layout contains these four blocks:","Image: Displays the image your company administrator uploaded for the shell.","In the dashboards, if there are multiple images, the system displays all the images as rolling images.","When a shell has multiple images, the system uses the first image from the list to print the shell image through custom prints and reports.","Items Requiring Your Attention: Contains items that are generally listed on the Home workspace, such as tasks and messages.","Details: Lists shell details, including shell number, shell name, administrator, and other details.","Links: List of links configured for the shell by your company administrator.","On each tab, you can select a different layout to which you can add blocks of these types:","Custom: Use this selection to view data from the current shell, subordinate shells, or both (cannot cross hierarchies).","Standard: Use this selection to view project data from, for example, business process, manager, users, and active tasks.","Portlet: Use this selection to view an external URL, such as a web cam, a frequently visited website, or Analytics application.","To view Analytics in the Portlet block, you must perform additional and required configurations in Oracle Analytics Server to allow the analysis to render properly. For additional information, go to: https://docs.oracle.com/en/middleware/bi/analytics-server/index.html","Drilldown: Use this selection to slice and dice project-shell data.","Analytics: Use this selection to access the link to the Analytics application.","About Shell Dashboards","74375.htm");
Page[158]=new Array("To set shell instance dashboard permissions:","Go to the Company Workspace tab and switch to Admin mode.","In the left Navigator, select User Administration, and then select Access Control.","On the right pane, expand Administration Mode Access, expand Permissions for Projects/Shells, expand Setup, and then select Dashboards.","Set the permissions as needed:","Setup: Administrators can create a shell instance dashboard.","Setting Shell Instance Dashboard Permissions","74376.htm");
Page[159]=new Array("You can create dashboards in shell templates and push them to shells.","To create a dashboard in a shell template:","Go to the Company Workspace tab and switch to Admin mode.","In the left Navigator, select Templates, select Shells, select the [shell type], and open the [shell template].","In the left Navigator, select Setup, and then select Dashboards. The Dashboards log opens.","Click Create.","Enter the dashboard name and an optional description. The dashboard name must be unique within the shell.","Click Save. The dashboard is listed in the log.","Select the dashboard in the log and click Open from the gear menu ( @ ). The default view of the shell dashboard opens.","Notes: You might not see data in parts of the dashboard if you do not have specific permissions to access data cubes.","You can edit a dashboard in an established project shell. For details, refer to the Unifier General User Guide.","Creating a Shell Dashboard in a Template","74377.htm");
Page[160]=new Array("You can create shell dashboards by copying and modifying existing dashboards. Copying a shell dashboard does not copy the permissions associated with the dashboard, but will copy all other dashboard information.","To copy a shell dashboard:","Go to the Company Workspace tab and switch to Admin mode.","In the left Navigator, select Company Sponsored Shells, select the [shell type], and open the [shell instance].","In the left Navigator, select Setup, and then select Dashboards. The Dashboards log opens.","Select a shell dashboard.","Open the gear menu ( @ ) and click Copy.","Enter the name of the new dashboard and an optional description.","Click Save. The dashboard is listed in the log.","Select the dashboard in the log, open the gear menu and click Open. The shell dashboard editor opens.","Modify the new dashboard as needed and Save.","Copy a Shell Dashboard","74378.htm");
Page[161]=new Array("To modify shell instance dashboard properties:","Go to the Company Workspace tab and switch to Admin mode.","In the left Navigator, select Company Sponsored Shells, select the [shell type], and open the [shell instance].","In the left Navigator, select Setup, and then select Dashboards. The Dashboards log opens.","Select a shell instance dashboard.","In the right pane, click the Properties tab.","Modify the dashboard name or description as needed.","Click Save.","Modify Shell Instance Dashboard Properties","74379.htm");
Page[162]=new Array("To delete a shell instance dashboard:","Go to the Company Workspace tab and switch to Admin mode.","In the left Navigator, select Company Sponsored Shells, select the [shell type], and open the [shell instance].","In the left Navigator, select Setup, and then select Dashboards. The Dashboards log opens.","Select a shell instance dashboard and open the gear menu ( @ ).","Click Delete.","Delete a Shell Instance Dashboard","74380.htm");
Page[163]=new Array("To find a shell instance dashboard:","Go to the Company Workspace tab and switch to Admin mode.","In the left Navigator, select Company Sponsored Shells, select the [shell type], and open the [shell instance].","In the left Navigator, select Setup, and then select Dashboards. The Dashboards log opens.","Use the Find on Page button to filter the log based on column values.","Find a Shell Instance Dashboard","74381.htm");
Page[164]=new Array("To set user or group permission for a shell instance dashboard:","Go to the Company Workspace tab and switch to Admin mode.","In the left Navigator, select Company Sponsored Shells, select the [shell type], and open the [shell instance].","In the left Navigator, select Setup, and then select Dashboards. The Dashboards log opens.","Select a shell instance dashboard.","In the right pane, click the Permissions tab.","Add users or groups as needed. Select the View permission.","Click Save to save or Cancel to exit.","Set User or Group Permission for a Shell Instance Dashboard","74382.htm");
Page[165]=new Array("To set a shell instance dashboard as the default dashboard for the shell:","Go to the Company Workspace tab and switch to Admin mode.","In the left Navigator, select Company Sponsored Shells, select the [shell type], and open the [shell instance].","In the left Navigator, select Setup, and then select Dashboards. The Dashboards log opens.","Select a shell instance dashboard.","From the gear menu ( @ ), select Mark as Default. ","Click Yes to confirm. The Default column of the log will now display Yes for the default dashboard. Only one dashboard can be set as the default dashboard. ","To unmark a shell as default, click the gear menu for the default dashboard and select Unmark Default. ","Set a Default Shell Dashboard","10300354.htm");
Page[166]=new Array("You can migrate one or multiple standard projects (Projects (Standard)) of any status (Active, On-Hold, View-Only, or Inactive) to CBS shell types that you specify. After migration, the new CBS shell is created in the shell hierarchy in the location you specify, and the standard project is no longer listed in the project log. All the data that existed under the standard project can then be accessed from the newly-created CBS shell.","Note: When you migrate a standard project to a CBS shell, you cannot undo the migration and return the shell to the standard project form. The migration cannot be reversed, so be sure that you want to perform the project-to-shell migration.","After you migrate standard projects to CBS shells, you can use the features that shells offer, such as:","Hierarchical distribution, visualization and navigation of capital projects when organized under shell hierarchies based on business needs","Configurable dashboards","Roll up of cost data across the shell hierarchy","Migrating Projects (Standard) to CBS Shells","74383.htm");
Page[167]=new Array("The following are some migration limitations for you to consider:","The shell type must be a CBS shell. You cannot migrate standard projects to generic shells, only to CBS shells.","Shell name is limited to 128 characters, and shell description is limited to 250 characters. However, standard project name is limited to 250 characters, and the project description is limited to 2000 characters. For the migration from project to CBS shell to be successful, you must modify the project name and description to be within the limits for these fields that exist for the shells (128 characters for a shell name and 250 characters for a shell description).","The standard project name cannot contain any special characters, such as:","/\\:*?&quot;&lt;&gt;|","You cannot migrate a standard project to a single instance (top-level) shell. You can only migrate to multiple-instance shells.","Even if the destination CBS shell type has auto-numbering set up, the migration cannot incorporate the new shell into the shell auto-numbering; instead, it copies the project number while creating the shell. The new shell is identified by the project number of the original project.","You will have to set up a new configurable shell dashboard for the new shell that is created by the migration. Any existing project summary set up does not migrate to the new shell.","If any business processes, planning items, assets, or configurable managers in the original project use project pickers, you will have to re-create the link between these objects and the new shell.","Migration from a standard project to a CBS shell cannot be reversed. After the migration is complete, the standard project is converted to a CBS shell, and the information from that project resides in the newly-created CBS shell.","Migrating Projects (Standard) Limitations","74384.htm");
Page[168]=new Array("Before you migrate:","Be sure that you have Integration defined for the CBS shells you plan to use for migration.","Examine the shell hierarchy of your CBS shells and determine the location for the new migrated shells. You can migrate several projects at once into a shell type, creating a new shell instance under that shell type for each migrated project.","Examine the setups for the original projects and also for the destination shells, and think about the mapping from the project to the shell. You might have to add data elements on the project side or the shell side to ensure that the data you need is migrated correctly and completely. For example, the shell name is limited to 128 characters and shell description is limited to 250 characters. However, standard project name is limited to 250 characters and the project description is limited to 2000 characters. For the migration from project to CBS shell to be successful, you must modify the project name and description to be within the limits for these fields that exist for the shells (128 characters for a shell name and 250 characters for a shell description).","To ensure that the migration is successful and yields the desired result, test your migration in your Test environment before implementing it in your Production environment.","You can use user-defined reports to gather data regarding which projects to migrate and the location they should occupy in the shell hierarchy.","Understand that migration cannot be undone; when you migrate a project to a CBS shell, you cannot go back to that project. The project is converted completely to a CBS shell when the migration completes successfully.","Migrating Projects (Standard) Considerations","74385.htm");
Page[169]=new Array("The following table shows the automatic mapping of original project data elements to destination CBS shell data elements. These data elements define the fields shown on the project/shell setup window tabs. This mapping occurs automatically during the migration. When a standard project is migrated to a CBS shell, the project's data element values are automatically populated in the equivalent shell data element as listed in the table:","General tab of CBS shell","Standard project data element","CBS shell data element","Comments on action during migration","Project Number","Shell Number","One-to-one mapping occurs.","Project Name","Shell Name","One-to-one mapping occurs.","Description","Description","One-to-one mapping occurs.","Administrator","Administrator","One-to-one mapping occurs.","Project Status","Shell Status","One-to-one mapping occurs.","Auto-update Status Setup","Auto-update Status Setup","Optional on the Shell Attribute Form; if not present on the Shell form, is ignored during migration.","Currency tab of CBS shell","Standard project data element","CBS shell data element","Comments on action during migration","Currency Name","Currency Name","One-to-one mapping occurs for all defined currencies.","Rate","Rate","One-to-one mapping occurs for all defined currencies.","Type","Type","One-to-one mapping occurs for all defined currencies.","Hedge Rate","Hedge Rate","One-to-one mapping occurs for all defined currencies.","Hedge Amount","Hedge Amount","One-to-one mapping occurs for all defined currencies.","Default Currency","Default Currency","One-to-one mapping occurs.","Options tab of CBS shell","Standard project data element","CBS shell data element","Comments on action during migration","Project Image","Image","One-to-one mapping occurs.","Project Phase","Phase","One-to-one mapping occurs.","Links tab of CBS shell","Standard project data element","CBS shell data element","Comments on action during migration","Name","Name","One-to-one mapping occurs for all defined links.","URL","URL","One-to-one mapping occurs for all defined links.","Migrating Projects (Standard): Mapping of Project DEs to Shell DEs","74386.htm");
Page[170]=new Array("Before you begin: Make sure that you review the limitations, considerations, and mapping information described in the preceding topics.","Step 1: Export the migration template. Export the CSV template. This template will vary depending on the data elements included in the configuration of a particular shell type. This template contains the fields and format that the system needs to migrate the standard projects to CBS shells. See Exporting Migration Template.","Step 2: Modify the exported CSV template. Be sure that you have the correct project information ready to enter into the template. After you convert a standard project into a CBS shell, you cannot reverse the conversion. See Modifying Exported CSV Template.","Step 3: Initiate migration. Import the completed CSV file. See Initiating Migration of Standard Projects to CBS Shells.","Step 4: View migration history. See Viewing Migration History.","Step 5: Test for shell creation. See Testing for CBS Shell Creation.","You export the template, and then modify it and import it. You will export the template from a selected CBS shell, and then import the modified template back into the same CBS shell to complete the migration.","Migrating Projects (Standard) to shells","74387.htm");
Page[171]=new Array("To export the migration template:","Go to the Company Workspace tab and switch to Admin mode.","In the left Navigator, select Company Sponsored Shells, and then select the applicable [CBS shell type].","Note: The shell type must be for a CBS shell. You cannot migrate standard projects to generic shells, only to CBS shells. You cannot migrate a standard project to a single instance (top level) shell, only multiple-instance shells.","From the Actions menu in the shell type log, select Export Template, and then select Project Migration Template.","The template, which is downloaded to your computers, will be specific to the shell type of the log from which you exported the template.","Exporting Migration Template","74388.htm");
Page[172]=new Array("Be sure that you have the correct project information ready to enter into the template. After you convert a standard project into a CBS shell, you cannot reverse the conversion.","Note: You can use user-defined reports to gather data regarding which projects to migrate and where they should be in the shell hierarchy.","To modify the template:","Open and edit the CSV template, per the template content, and the description of the template content in this section.","The content of the migration template will vary depending on the shell type into which you choose to migrate.","The exported template is organized in three sections:","Instructions: This section at the top of the template explains how to fill in the template to initiate the migration. Do not modify this text.","Mapping: This section maps the available standard project attributes with the user-defined CBS shell attributes. Use this section to create mapping for data elements that you have added in addition to the data elements listed in the table in Migrating Projects (Standard): Mapping of Project DEs to Shell DEs. The Mapping section lists all the project attributes which are not automatically mapped.If you use custom project attributes, these attributes are listed and mapped in this section.The values in this section are overwritten by any literal values that you add in the Project section.","Project: This section lists the Project Number and Location and the user-defined CBS shell attributes as column headings. Project Number and Location are required; the other columns are not and are based on the attributes listed in the Mapping section. This list does not include the automatically-mapped shell attributes such as Shell Name or Shell Number. Add a row for each project you want to migrate, and enter the Project Number and the Location. The location should be delimited with /. For example: /Capital Project/Buildings/Tool Sheds. Add the literal values that are to be changed during the migration.","Note: Projects are identified by the Project Number for migration. Be sure that you enter the correct project numbers for standard projects you want to migrate to CBS shells.","Save the template CSV file.","Modifying Exported CSV Template","74389.htm");
Page[173]=new Array("You can migrate several projects at once into a shell type, creating a new shell instance under that shell type for each migrated project. Before you initiate the migration, ensure that you have the Create permission on the destination shell type. You can export the template from a selected CBS shell, and you can then import the modified template back into the same CBS shell to complete the migration.","Note: You cannot undo the migration of standard projects to CBS shells after the migration completes successfully. Verify that you have completed the CSV migration template correctly, especially in terms of the Project Number.","To initiate migration:","Go to the Company Workspace tab and switch to Admin mode.","In the left Navigator, select Company Sponsored Shells, and then select the applicable [CBS shell type].","From the Actions menu in the shell type log, select Import, and then select Migrate Projects into Shells.","Browse for the CSV file and click OK.","This imports the migration template and performs validations on the data. The migration is a background process. Each project listed in the CSV file is migrated into a CBS shell based on the mapping and values provided in the CSV. Project migration is either successful or not. Validation is performed before migration, and if there are any errors, a project is not migrated. Errors can include incorrect mapping or invalid format of the project rows (including changing column order or adding or removing columns).","Initiating Migration of Standard Projects to CBS Shells","74390.htm");
Page[174]=new Array("You can view the status of each submitted migration by using the Migration History.","To view migration history:","Go to the Company Workspace tab and switch to Admin mode.","In the left Navigator, select Company Sponsored Shells, and then select the applicable [CBS shell type].","From the Actions menu in the shell type log, select Import, and then select Migration History.","Each submitted migration is listed in Migration History with one of these statuses:","Not Started: The migration process has not started.","In Progress: The migration process is in progress.","Completed Successfully: The migration of all standard projects completed, and the corresponding CBS shells have been created.","Completed with Errors: The migration of standard projects has completed, however, there were some errors that prevented the migration of some of the projects to CBS shells.","Potential migration errors:","Location entered is invalid. This error can occur if the location does not exist or is inactive in the shell hierarchy.","Cannot create an instance of the shell type under the location entered; does not exist in the shell hierarchy.","Project number might be the same as the number of an existing shell in the hierarchy. Shell numbers must be unique.","String values are entered incorrectly. Enter the labels for sting values.","The standard project name is limited to 250 characters, and the project description is limited to 2000 characters. For the migration from project to CBS shell to be successful, you must modify the project name and description to be within the limits for these fields that exist for the shells (128 characters for a shell name and 250 characters for a shell description). Any error can result if the project name or project description are longer than the character limits for the shell name and shell description.","If any of the projects did not migrate due to errors, you can view the CSV with the rows that have errors by clicking the Completed with Errors status hyperlink.","This link allows you to download the CSV containing any errors. This file is in the same format as the submitted CSV, with all mapping information retained. However, in the Project section, only the rows that have errors in them are shown with an additional column added that contains error comments. You can use this CSV file to review the errors and then re-import the file after you correct the errors.","Click Close to close the Project Migration History window.","Viewing Migration History","74391.htm");
Page[175]=new Array("Ensure that your new CBS shell is created correctly and contains the attributes that you expect:","The shell instance should be accessible in Administrator (Admin) and User mode(for Unifier and Unifier Mobile under the parent shell it was migrated to.","Users should be able to navigate to the business process and other manager data under the new CBS shell.","Shell creation will trigger email notification.","User/groups membership should remain same as on the original standard project.","All the auto-population, reverse auto-population, linked elements, and other settings should work as they did on the original standard project.","Testing for CBS Shell Creation","74392.htm");
Page[176]=new Array("At the Company level, you can define the setup of the automatic update of project statuses of active projects based on triggering conditions which are defined using various data sources as parameters. For example:","A selected activity on the schedule sheet is in the Completed status","A single-record business process record is set to a specified status","A business process workflow reaches a specified status","Depending on the setup and the conditions that are set, the status of the shell can change from Active to a non-active status (On-Hold, View-Only, or Inactive). You can define multiple setups for each shell. After you define these setups, they can be used on shell instances, or on templates to enable the automatic update of shell status.","The data sources that you use in the triggering conditions can be either from shell level or from the Company level. These data sources can be business processes, sheets, or attribute forms. You can define the frequency at which the system evaluates the conditions to see if a particular active shell should change its status, and you can define a list of users or groups to be notified when the shell status is changed. The highest frequency is daily.","This automatic update of shell status can be useful for users that have a large number of shells and want many of these shells to change their status based on certain triggering conditions, and thus the users do not have to search for and modify these shells manually. For example, you can define a setup that contains a triggering condition that changes the status of an active shell to &quot;On-Hold&quot; if the shell funds consumption exceeds the funds appropriated for that shell. This allows the shell manager to review the shell and take appropriate action. If, in this case, the shell manager is able to get additional funding for the shell, the Administrator can change the shell status back to Active to restart the shell activities.","Note: An automatic shell status update can change the status of a shell from Active to inactive. If you want the inactive shell status to revert to Active, you must activate the shell manually.","Step 1: Create setups - general information.","Step 2: Verify the order of shell statuses.","Step 3: Define shell status triggering conditions.","Step 4: Define the schedule for automatic update of shell status.","Step 5: Activate the automatic update of shell status.","Step 6: Define permissions.","Setting Up Automatic Update of Shell Status","74357.htm");
Page[177]=new Array("Multiple setups can be defined at the company level and then used to configure individual shells.","Note: You must have imported a Shell Attribute Form that contains the uuu_au_setup_picker data element to be able to set up the automatic update of shell status.","To create a shell status update setup:","Go to the Company Workspace tab and switch to Admin mode.","In the left Navigator, select Company Workspace, and then select Auto-update Status Setup. The Auto-Update Status Setup log opens.","Click New. The Auto-update Status Setup window opens. There are three tabs: General, Settings, Schedule.","In the General tab, enter a Setup Name, which displays in the log, and an optional Description.","In the Settings tab, define the order of the non-active statuses and the status change query and trigger conditions. For details, see Choose the Order of Non-Active Statuses (Settings Tab) and Define Status Change Query and Trigger Conditions (Settings Tab).","In the Schedule tab, you can schedule the shell status update. See Define Shell Status Update Schedule (Schedule Tab).","After you have defined the setup, you must activate it to be able to apply it to a shell. See Activate or Deactivate an Auto-Update Status Setup.","Note: You must deactivate a setup to be able to modify it.","Create an Automatic Shell Status Update Setup","74358.htm");
Page[178]=new Array("By default, the order of the listed statuses is On-Hold, View-Only, and Inactive. These are listed on the left side of the Settings tab in the Status pane. You can change the order using the Move Up or Move Down buttons. You can change the order of the non-active statuses. The order of the statuses is significant because the triggering conditions for the statuses are evaluated in the order in which they are listed on this tab, with the verification of the triggering conditions occurring for each condition listed in turn.","For example, if the conditions for the first listed status are not met, the conditions for the next listed status are evaluated. If the conditions for that status are not met, the triggering conditions for the third status conditions are evaluated. As soon as the first match occurs, the system will automatically change the shell status and does not perform further evaluation.","To reorder inactive shell statuses:","Open the Auto-update Status Setup window and click the Settings tab.","In the Status pane, select the status you want to move.","Click the Move Up or Move Down button to reposition the selected status.","Click Apply to save changes, or OK to save changes and exit the window.","Choose the Order of Non-Active Statuses (Settings Tab)","74359.htm");
Page[179]=new Array("The Conditions Elements section lets you define condition criteria per element. Elements can be selected from all data sources and modules available at the Company level.","In this field:","Do this:","Notify users and groups on Status change","Lets you define the users and groups who will receive status change notification.","Email content","Enter the content of the email you want to send to notified users and groups. This content appears in the Additional Information section of the email.","To define query and trigger conditions:","Under Conditions Elements, click Add.","Select a Data Type, and click OK. The Query Condition window opens.","Complete the General tab by entering a name for the query and a brief description. The Data type and Element is auto-populated from the selection you make on the Query tab.","Click the Query tab.","Click Add.","Complete the Query tab:","Data Element: Click the Select button. The Data Element Picker opens. The list is generated from the data type you chose in the General tab. If the data element is a picker, drop-down (pull-down), or radio button, the Value field will display the values entered in the data set tab of for the data definition associated with the data element. For a full list of data elements and data types, refer to the Unifier Data Reference Guide.","Label: The label defaults to the data element name. You can enter a different label.","Condition: Define Gate Condition Element Condition. The condition options vary dynamically depending on the selected Data Element. The screen shots below list out the various options for different Data Element types. Examples include equals, does not equal.","Values: Specify value. The Values field varies dynamically depending on the selected Data Element and Condition. (For example, if the element is a text box, the condition might be Contains and value might be one or more letters to search for. If the element is a drop-down (pull-down) or other data definition with a data set, you will select a value from the data set.)","Select the trigger conditions.","Click OK.","Define Status Change Query and Trigger Conditions (Settings Tab)","74360.htm");
Page[180]=new Array("You can define a schedule to check the conditions for the automatic update in the Auto-update Status Setup window, Schedule tab.","The maximum frequency that the system will verify whether triggering conditions are met is daily. If you have a need for greater frequency of verification, you must monitor the shell with the shell manager and then change the shell status manually as needed. For example, if the triggering condition verification is performed in the morning and the shell funds are being spent during the course of the day, the shell could exceed its budget before the condition verification occurs the next morning, and the shell status is automatically changed.","In this field:","Do this:","Enable Scheduled Runs","Select this check box to enable scheduled evaluating of the automatic update status. Deselecting this check box will disable the scheduler, and any scheduled future runs will be canceled immediately.","The scheduled evaluation is disabled for the last status in the list, provided all conditions are met, and the Enable Scheduled Runs check box is automatically deselected.","Frequency","Choose Frequency of the Scheduled Runs (Daily, weekly, monthly, quarterly, yearly)","Range of Recurrence","You can specify a date on which the Scheduled Runs will end, or no end date.","Define Shell Status Update Schedule (Schedule Tab)","74361.htm");
Page[181]=new Array("You must activate a setup to be able to apply it to a shell.","Note: You must deactivate a setup to be able to modify it.","To activate or deactivate a shell status update setup:","To activate or deactivate a new setup to use in shells, go to the Company Workspace tab and switch to Admin mode.","In the left Navigator, select Company Workspace, and then select Auto-update Status Setup. The Auto-Update Status Setup log opens.","Select a setup in the log.","Click the Status button. You can choose Active or Inactive.","Activate or Deactivate an Auto-Update Status Setup","74362.htm");
Page[182]=new Array("To set permissions for automatic status update:","Go to the Company Workspace tab and switch to Admin mode.","In the left Navigator, select User Administration, and then select Access Control.","On the right pane, expand Administration Mode Access, expand Company Workspace, and then select Auto-update Status Setup. The permissions are:","Create: Allows the creation of new auto-update status setups, edit existing auto-update status setups, and activate or deactivate auto-update status setups.","Modify: Allows the edit of existing auto-update status setups and activate or deactivate auto-update status setups. This permission excludes the ability to create an auto-update status setup.","View: Allows viewing of existing auto-update status setups.","Set Permissions for Automatic Update of Shell Status","74363.htm");
Page[183]=new Array("This section explains how to set up the information in the Data Structure Setup grouping node which includes:","System Modules","Functionality is loaded into the system through various modules (grouping nodes and functional nodes).","Data Cube Definitions","A data cube definition is a query tool you can use to extract data and display it on dashboards.","Data Definitions","Data definitions describe how data is entered and stored. The definition consists of:","The data type (whether it is an alphabetical string or a number),","The data size (in number of characters for strings), and","The input method (from a text box, drop-down [pull-down] menu, radio button, or check box).","You must create data definitions before you specify the data elements for forms. A data definition can belong to one of the following categories:","Basic: Predefined or user-defined Data Definitions that contain all Data Definitions except the Cost Code definitions.","For the SYS User Date Format Data Definition, the data set supports the 24-hour time format. In the User Preferences form, under the Regions tab, the field Date Format uses SYS User Date Format Data Definition.","Cost Codes: Displays the type of cost code (fields that define the structure of the Cost Codes) specified in uDesigner for the project. The type of cost code available for Projects/Shells is CBS.","Data Picker: Data pickers work with business processes logs and can be used to fetch items from across multiple shells and configurable managers that function across a shell hierarchy. The purpose of a Data Picker is to make it easier for users to choose records:","From a business process log","From a class in a configurable manager that operates across shells","For auto-creation across shells","A data picker log, when defined accordingly, can contain navigation structure that makes it easier for users to choose records to work with.","In operation, a data picker navigates to a specific business process, shell, or configurable manager and then extracts the records to display on the data picker list (by using pre-defined Query conditions that were included on the data picker).","Line Item Data Picker: This is a system-defined Basic data definition.","Data Elements","A Data Element is a field, and it is defined by using a Data Definition. A Data Element consists of a name and label. The forms that the users see are filled by data elements. A data element can be:","A text box, where the user types in information","A drop-down (pull-down) menu of choices (also known as a picker), such as dates or names","A radio button, where the user must select one of the options presented","A check box, where the user has the option of choosing something or not","Data Views","Provides a view of data obtained via SQL query. It allows access to all Unifier database tables in a company registry (registry dependency ensures data security). Data Views enable administrators to design and deploy custom reports, create user-defined reports (UDRs), and utilize data as a source for Data Cube Definitions in dashboards.","Dynamic Data Sets","A dynamic data set is comprised of a &quot;set&quot; of data elements where one data element, known as Master Data Element, controls the values and behavior of other data elements in the set.","Reports","The Site Administrator loads the System and Custom Logs report modules.","Statuses","Statuses are created in the Data Structure Setup node and indicate the position of an asset, line item, record, and tag at any point in the business process, such as &#8220;approved,&#8221; &#8220;pending,&#8221; or &#8220;closed.&#8221; The status is what drives the workflow from one step to the next.","Assets Statuses: An asset status controls which assets are displayed on an Asset class sheet, instead of impacting the disposition of a business process or line item like other statuses.","Line Item Statuses: A line item status is the status of the line item that belongs to a business process record.","Record Statuses: At each transaction, the user must apply a status to the record. Each business process produces at least one, and sometimes many, transaction records during its workflow.","ER Views","Provides a tabular view of Data Elements and Data Definitions used in modules.","Setting Up Data Structure Setup Node","74156.htm");
Page[184]=new Array("Functionality is loaded into the system through various modules. For example, the Cost Manager and Schedule Manager are system modules that provide cost and scheduling functionality. Also, your system might contain various configurable modules created in uDesigner.","Some modules can be customized with &quot;custom attributes,&quot; which are customized data fields, described later in this section.","Working with System and Configurable Modules","74157.htm");
Page[185]=new Array("To view the System Modules log:","Go to the Company Workspace tab and switch to Admin mode.","In the left Navigator, select Data Structure Setup, and then select System Modules.","The Modules log opens, showing all the modules and functions that have been loaded into your environment.","View Available System and Configurable modules","74158.htm");
Page[186]=new Array("You can view custom attributes that were assigned to standard projects that were previously deployed.","To view custom attributes:","Go to the Company Workspace tab and switch to Admin mode.","In the left Navigator, select Data Structure Setup, and then select System Modules.","In the Modules log, double-click Project/Shell Sponsorship.","Use the Custom Attributes window to view information such as the Name and Status.","When you are done, click Close.","View Custom Attributes for the Project/Shell Sponsorship Module","74159.htm");
Page[187]=new Array("Data definitions define the data type and input type of a data element. Data elements are created from data definitions. The following lists the types of data definitions:","Basic","Cost Codes","Data Picker","Working with Data Definitions","74160.htm");
Page[188]=new Array("Data definitions can be of the following Data Types:","String: Any alphanumeric character or special character like * or #","Integer: A non-decimal number. Can be used for drop-down (pull-down) menus, radio buttons, or check box fields","Date: For date fields","Float: This is applicable to currency amounts only","Input: This determines how data is entered or displayed in the field<br />","This input method:","Does this:","Check box","Provides an option that the user can select (&quot;check&quot;) or not. &quot;Not checked&quot; is the default value.","Multi-line text area","Use this element for multiple text lines for entries up to 4000 characters long, such as descriptions or remarks.","Multi-select Input","Lets the user make multiple selections from a list.","Picker","Lets users choose from lists of items. Pickers are system-defined and cannot be created in Unifier. The system has multiple pre-defined pickers.","A Picker can be added to a BP to lets users cross-reference another record.","Pickers include, but not limited to:","BP Picker","BPO Picker","User Picker","Company Picker","Line Item Picker","SOV Picker","Fund Picker","Asset Picker","Project Picker Shell Picker","Pull-down menu","Provides a list of items the user can choose from but cannot change (for example, a date picker).","Radio buttons","Use where two values are possible and one must be selected.","Text box","A text box is usually used for smaller text (1 to 64 characters), but could be longer.","Dynamic Data Set","A dynamic data set allows one data element on the form to control both values and behavior of other data elements on the same form.","(In this example, choosing Yes in the Single Project field activated the Project Picker field below it.)","To prevent the Upper Form or Detail form of any BP, for a field with DD set as Integer data type with input-type pull-down menu (option value for DE of type Integer) from displaying the field (and the field label) in the BP record, ensure that the value of 1, or above, is assigned to the DD set as Integer data type with input-type pull-down menu (option value for DE of type Integer) to that field. Assigning the value of zero will result in the field (and the field label) to be displayed in the BP record, when the user does not enter a value in such fields during runtime.","About Data Definition Properties","74161.htm");
Page[189]=new Array("To access Basic Data Definitions:","Go to the Company Workspace tab and switch to Admin mode.","In the left Navigator, select Data Structure Setup, select Data Definitions, and then select Basic. The Basic Data Definitions log opens. The system-generated data definitions are listed as Company or System in the Category field.","Field","Description","Name","Descriptive name for the data definition. This is the database name; it accepts alphanumeric characters, spaces, - (dash) and _ (underscore).","Category","General: Defaults to Company","Cost Code: Defaults to CBS Code","Data Type","String or Integer","String: Any alphanumeric character or special character like * or #","Integer: Non-decimal numbers","If a Data Definition (DD) with the Data Type = Integer or Input Type - Pull-down Menu, and the Data Set value of 0 (zero), the value of 0 (zero) overrides the default value. If a Data Element (DE) exists for such DD and the DE is used as the master DE in a Data Definition Structure (DDS), the DDS will not override the DE value when the DD is created, if the default value of the master DE is set to a field that has the value of 0 (zero).","Data Size","This field is available for text entry fields. Displays the number of characters that the data definition will accept.","Notes:","The maximum limit for the Data Size is determined by the database being used with your installation. Check with your Site Administrator for the actual maximum allowable characters in a field.","Ensure that the data you enter is within the limit set in Unifier; otherwise, the system will ask you to shorten the number of the characters that you had entered (message: Data entered exceeds the allowed space limit for this field in the database. You must remove few characters before submitting.). This is mainly applicable to multi-byte character languages such as Japanese, Korean, and Chinese.","Input Type","Select one of the options. This determines how data is entered or displayed in the field:","Pull-down Menu: users can choose a value from a selection list","Text Box: for short text entries","Multi-line Text Area: for longer text entries","Radio Buttons: users select one of multiple options presented","Checkbox: users have the option of selecting or not","Multi-select Input: users can choose one or more values from a selection list","The following is applicable when deleting or otherwise modifying the options in the data definition design process, after the system has deployed the design and the data has been saved:","When you modify or delete an option in the data structure design, the system will not modify the existing record data. Consequently, within the BP logs, log preview panes, and UDRs, the system will display the option with the value that was originally saved in the record form, as read-only.","When you delete an option, the value will be displayed but not the label. ","When you rename an option, or when you add the option later with the same value, the existing value will be associated with a different label, but in forms only the active options are available and only the labels (not values) will be visible. ","Example","The value for the Priority drop-down field is set as High in the record details of a selected existing record.","Based on an enhancement, you must remove this value (High) from the list of originally applicable values (High, Medium, Low).","You proceed and remove High from the list of values in the record form and save your changes: Go to the Company workspace tab and switch to Admin mode; in the left Navigator, select Data Structure Setup, select Data Definitions, and then select Basic.","When you go to the BP log, preview pane, or UDRs and select that record, the system will still display the record details (in the right pane) with the value that was originally included in the Priority field (High), as read-only.","Default Value","Available for text entry fields. You may enter an optional default value to the field.","Separator","For multi-select input, where users can select one or more values to enter into a field. The separate (for example, a comma) is used to separate the values.","All the Integer-type Data Elements (DEs) will have a default value of &quot;0&quot; (zero). As a result, when processing an Integer drop-down list (Pull-down field), if the system finds &quot;0&quot; (zero) as a Data Set value, the corresponding data set value/label associated with &#8220;0&#8221; will be seen.","Example","An Integer drop-down list (Pull-down field) is named &quot;Risk Priority.&quot;","If the Data Definition (DD) has:","1. Data Set value of &quot;0&quot; (zero), and the label is &quot;No.&quot;","2. Data Set value of &quot;1,&quot; and the label is &quot;Yes.&quot;","Then, when a record is being created (in User mode), the value for the &quot;Risk Priority&quot; field will be &quot;No&quot; because the default value for an Integer drop-down list (Pull-down field) is &quot;0&quot; (zero).","View Basic Data Definitions","74163.htm");
Page[190]=new Array("Cost Code Data Definitions are used in the Cost Manager to build the identifier for a row of cost data. Your company may refer to these as Account Codes, Cost Codes or CBS Codes. For example, these could link costs on a project/shell to the General Ledger for Finance.","CBS Codes can be built with one to a maximum of 10 cost code segments. Each segment is defined by a different data definition, so a five-segment CBS Code would require five cost code data definitions.","Cost Code values may be entered one at a time or imported from a CSV file.","To access Cost Code Data Definitions:","Go to the Company Workspace tab and switch to Admin mode.","In the left Navigator, select Data Structure Setup, select Data Definitions, and then select Cost Codes. The Cost Code Data Definitions log opens.","View Cost Code Data Definitions","74164.htm");
Page[191]=new Array("The following procedures describe how to add a new Basic data definition.","To create a basic data definition:","Go to the Company Workspace tab and switch to Admin mode.","In the left Navigator, select Data Structure Setup, select Data Definitions, and then select Basic.","Click the New button. The Create New Data Definition window opens.","In the Name field, enter a unique name for the data definition.","The name can include alphanumeric characters, spaces, dashes, and underscores.","The name is case-sensitive.","The name cannot begin the name with a prefix reserved by Oracle Primavera: SYS, UUU, or Picker.","In the Data Type field, specify whether the definition will be a string or integer data type.","When you specify the data type, the system displays an additional field, Input Type.","If you choose a string data type, include the maximum number of characters in the Data Size field.","In the Input Type field, select the method the user will use to enter the data.","Click Apply to open the data set tab, or OK to close the Create New Data Definition window.","Add a Basic Data Definition","74165.htm");
Page[192]=new Array("To create a cost code data definition:","Go to the Company Workspace tab and switch to Admin mode.","In the left Navigator, select Data Structure Setup, select Data Definitions, and then select Cost Codes.","Click the New button. The Create New Data Definition window opens.","Enter a unique name for the cost code (General tab - Create New Data Definition block).","The Category field is read only.","Enter a Label for the cost code.","Select an input type: either Text Box or Pull-down Menu.","Click OK.","Add a Cost Code Data Definition","10280295.htm");
Page[193]=new Array("To create a Data Picker data definition:","Go to the Company Workspace tab and switch to Admin mode.","In the left Navigator, select Data Structure Setup, select Data Definitions, and then select Data Picker.","Click the New button. The Create New Data Definition window opens.","Enter a unique name for the Data Picker.","Click the Select drop-down list and select a category for the list.","Click the Data Source drop-down list and select a source.","Click the Display Element drop-down list and select an element.","The Data Element field is read only.","Click OK.","The Data Picker Data Definition appears in the Data Picker Data Definitions log.","Add a Data Picker Data Definition","10293861.htm");
Page[194]=new Array("Data Set Values are applicable to data definitions that provide the user with a set of values from which to choose, for example, drop-down (pull-down) menus, radio buttons, and multi-select types. Some data definitions have been supplied with data set values; others must be entered. Data Set values can be added, removed, or changed.","Some examples of Data Definitions for which data sets must be defined:","Project/Shell Type, Project/Shell Site and Project/Shell Phase","Discipline (for example, Architectural or Engineering; appears on some business process forms)","Unit of Measure (appears for Line Item entry)","Spend Category (for certain Cost-type business processes)","Adding and Managing Data Sets","74167.htm");
Page[195]=new Array("You can add or import data set values for data definitions that require data sets. These values are used to populate the available choices on drop-down (pull-down) menu fields, radio buttons, or check boxes on a form or attribute form.","Note: The default values (in a drop-down list) are populated only on creation form of the business process.","A couple of things to take note of:","If the cost code field is a text box, you can set a default value; otherwise, you cannot set a default value.","If the data definition is an integer type and will be used in a formula, the value will be used in the formula, not the label. For integer data definitions, use care when assigning the value.","Avoid semicolons and commas in data set values, as this can cause problems in the selection list.","To add data set values to a Data Definition (all except Multi-select Input):","Go to the Company Workspace tab and switch to Admin mode.","In the left Navigator, select Data Structure Setup, select Data Definitions, and then select Basic or Cost Codes.","Select a data definition and click Open (ensure that the value in the Input Type column is set as: Pull-down Menu). The Modify Data Definition window opens.","Click the Data Set tab.","Click Add. An editable row appears on the window. You can press the Tab key to move from one field to the next, or click inside a field.","Enter a Value. This value is the data that is stored in the database. This value will appear on the form if you do not enter a label.","Enter an optional Label. This is what is presented to the user as a drop-down (pull-down) menu or radio button option. This can be different from the value.","In the Status field, enter Active or Inactive. The default is Active. If you want the value to remain on the data set but not show up for users at runtime, you can Inactivate it, rather than remove it.","You can select the Default check box for one of the values on the data set list. This will display in the field at runtime. Selecting a default value is optional.","To add another row, click Add.","To insert a data set value in the middle of the list, select a value and click Add. The new row will be added above your selection.","To add a new value to the bottom of the list, be sure a row is not selected, and click Add. (Or press the Tab key and tab through the fields of the last row, until the Add button is highlighted.)","If you want the data set list to be non-editable, select the Non-Modifiable check box.","Select this if you do want other users to be able to alter the list. Use caution before selecting Non-Modifiable. After you select this check box, you will be able to rearrange the order and select a different default value, but you will not be able to modify or remove values from the data set.","If this option is selected by a user with create permissions, other users cannot modify the data set value list. If it is selected by a user with modify permissions, the option cannot be deselected again, except by a user with create permissions.","Click Apply to save your entries, or OK to save and exit.","Add Data Set Values to a Pull-down (Drop-down) Menu or Radio Button","74168.htm");
Page[196]=new Array("Multi-select input type data definitions allow users at runtime to select more than one value to enter into the field at runtime. In the field, the values the user selected are separated with the Separator displayed on the General tab of the Data Definition window (such as a comma).","Note: Do not use an apostrophe (&#8216;) in the data for a multi-select input type data definition. This can result in blank data in the selector. You cannot set a default value for this input type.","To add data set values to a Multi-select Input data definition:","Go to the Company Workspace tab and switch to Admin mode.","In the left Navigator, select Data Structure Setup, select Data Definitions, and then select Basic. The Modify Data Definition window opens.","Create or open a Multi-select Input data definition and click the Data Set tab.","Click Add. An editable row appears on the window. You can press the Tab key to move from one field to the next, or click inside a field.","Enter a Value (128 character limit). This value will appear on the form. Values can contain spaces, but cannot contain the separate value (displayed on the General tab, for example, comma).","In the Status field, enter Active or Inactive. The default is Active. If you want the value to remain on the data set but not show up for users at runtime, you can Inactivate it, rather than remove it.","To add another row, click Add. (Or press the Tab key and tab through the fields of the last row, until the Add button is selected.)","If you want the data set list to be non-editable, select the Non-Modifiable check box.","Select this if you do want other users to be able to alter the list. Use caution before selecting Non-Modifiable. After you select this, you will be able to rearrange the order and select a different default value, but you will not be able to modify or remove values from the data set.","If this option is selected by a user with create permissions, other users cannot modify the data set value list. If it is selected by a user with modify permissions, the option cannot be deselected again, except by a user with create permissions.","Click Apply to save your entries, or OK to save and exit.","Add Data Set Values to a Multi-select Input Data Definition","74169.htm");
Page[197]=new Array("If you have a large number of data set values to enter (for example, if you want to populate a State drop-down [pull-down] menu with all 50 U.S. states), you can use a CSV file to import the values. This can be done for any data definition that uses a Data Set.","Importing data set values consists of the following:","Step 1: Export the CSV template file","Open the Data Definition and click the Data Set tab.","Click the Export button.","Save the file to your local drive. The file will contain any values that have already been entered for the data set.","Step 2: Complete the CSV file","Open the CSV template file.","Note there are no column headers in the template. Start at the top left corner of the file. The first column of the CSV file is the Value and the second column is the Label.","Delete any existing values. There cannot be duplicate values in a data set.","For each row, enter the Value and the Label. Include only two columns, and do not include a header row in the file. Do not add a status column; the status will be Active by default upon import.","Save the CSV file.","Step 3: Import the CSV file","Click the Import button.","Browse to the completed CSV file and click OK.","New rows are appended to any existing entries. The system validates the import file to ensure that valid CSV format is used. Duplicate entries are not allowed. After importing, you can rearrange the order of the rows if necessary.","If you see an error message after importing, proceed to Step 4 below.","Step 4: View the import validation error file (if applicable)","If an error occurs during import and you are presented with an error message, click Yes. You can then choose Open to open the file or Save to save the file to your local machine before opening.","Open the error file, which is a CSV file. Error messages are listed next to the row in which the error occurred (for example, if you have a duplicate row).","You can use fix the errors in this file (for example, remove duplicate rows) and re-import it after fixing the listed errors. Be sure to remove all extraneous text, including the error messages, before importing.","Import Data Set Values","74170.htm");
Page[198]=new Array("You can edit or remove values in data set lists. When you modify an existing data set, the new values will become available when new records are created that use the field (for example, create a business process).","To edit a data set value:","Open a Data Definition and click the Data Set tab.","Double-click the value or label to modify. The field becomes editable. Edit the field as needed and click OK.","To activate or deactivate a data set value:","Open a Data Definition and click the Data Set tab.","Click the Status drop-down (pull-down) menu and choose Active to activate, or Inactive to deactivate. Click OK.","Inactive values do not appear on the list at runtime.","To remove a data set value from the data definition drop-down list:","Open a Data Definition and click the Data Set tab.","Do one of the following:","To permanently remove a value, select it from the list and click Remove.","To remove the value from the data definition drop-down selection list that the user is presented with, but retain it in the data set value list, click Inactive.","Click OK.","Modify or Remove Data Set Values","74171.htm");
Page[199]=new Array("You can rearrange the order of data set lists. When you modify an existing data set, the new values will become available when new records are created that use the field (for example, create a business process).","After you have added the data set values, you can rearrange the order of their appearance on drop-down lists, multi-select input fields, and radio buttons. You can do this in two ways:","Using the Move Up and Move Down keys","Changing the order of the rows by editing the Row column","To rearrange the order using the Move Up/Move Down keys:","Open the Status Definition window and click the Data Set tab.","On the Data Set tab, highlight the data element and click the Move Up or Move Down key until the element is in the order you want.","Click OK.","To rearrange the order by Editing the Row column:","Open the Status Definition window and click the Data Set tab.","On the Data Set tab, highlight (or double-click) the row number of the element you want to reorder.","Enter the new row number the element should occupy.","Repeat step 2 for any other data elements you want to reorder.","Click the Update Order button; click OK to save the change and close the window.","Reorder Data Set Values","74172.htm");
Page[200]=new Array("Row numbers on the list start at 1. When you change the order of the rows, you can enter just about any number; even positive, negative, and duplicate numbers.","If you enter:","A negative number (for example, -100): The row will move to the top, becoming row 1. If you enter two negative numbers, the &quot;most negative&quot; number becomes row 1, and the &quot;next negative&quot; number becomes row 2.","Zero (0): The row will move to the top, becoming row 1 (or the row following any negative number you entered).","A number greater than the existing number of rows (for example, 100 when there are only 50 rows): The row will move to the end, becoming row 50. If you enter two numbers greater than the existing number of rows (for example, 100 and 101), the sort will retain the order of the numbers. In this example, 100 and 101 will become rows 49 and 50.","A duplicate number (that is, the same number for two or more different rows): The duplicate-numbered rows will become adjacent rows (in no specific order).","Row Numbering follows a Relative Numerical Progression","74173.htm");
Page[201]=new Array("A data element is a data field on a business process. Data Elements and their properties are defined by Data Definitions.","You can use a Data Definition to define the properties of more than one data element. Data Elements are defined under the Data Structure Setup node as well as the attribute forms.","You can export a CSV file listing specific data elements.","You can also view the usage of each data element, that is, the list of specific business processes where the data element is used.","Working with Data Elements","74174.htm");
Page[202]=new Array("To access the Data Elements log:","Go to the Company Workspace tab and switch to Admin mode.","In the left Navigator, select Data Structure Setup, and then select Data Elements. The Data Elements log opens.","The log lists the data elements used for your company. For each data element, the log displays the Data Definition on which it is based, the Form Label, which is how the data element appears on a form, and Usage.","Access Data Elements","74175.htm");
Page[203]=new Array("You can create a CSV file containing the current list of data elements. This can be useful if you must create different combinations of data set values for Dynamic Data Sets, taking from different sources of data definition data set values.","To export data elements:","Go to the Company Workspace tab and switch to Admin mode.","In the left Navigator, select Data Structure Setup, and then select Data Elements. The Data Elements log opens.","From the Data Elements log, click the Export button. Depending on your browser, the file will be automatically downloaded or you will be prompted to download it manually.","Export Data Elements","74176.htm");
Page[204]=new Array("The Usage button in the Data Elements lets you view the business processes or attribute forms that the data element is being used.","To view data element usage:","Go to the Company Workspace tab and switch to Admin mode.","In the left Navigator, select Data Structure Setup, and then select Data Elements. The Data Elements log opens.","From the Data Elements log, select a data element and click Usage. The Usage window displays the forms that use the data element.","View Data Element Usage","74177.htm");
Page[205]=new Array("When you open a Data Element in the Data Elements log, the Modify Data Element window opens. The following fields are available in this window:","Data Element Name","Data Definition Source","Form label","Description","Tooltip","You can enter the system-level tooltip in the field.","Upper Forms:","Go to the Company Workspace tab and switch to Admin mode.","In the left Navigator, select uDesigner, and then select Business Processes.","In the Designer - Business Processes log, select and open a BP.","In the left Navigator, select Upper Forms to open the Forms log.","In the Forms log, the Tooltip toolbar option enables you to see the list of Data Elements of the combined Upper Forms.","Detail Forms:","Go to the Company Workspace tab and switch to Admin mode.","In the left Navigator, select uDesigner, and then select Business Processes.","In the Designer - Business Processes log, select and open a BP.","In the left Navigator, select Detail Form to open the Detail Form log.","In the Detail Form log, the Tooltip toolbar option enables you to see the list of Data Elements of the combined Detail Form.","RFB Business Process","There are four types of tooltip:","Requestor for Upper Forms","Requestor for Detail Form","Bidder for Upper Forms","Bidder for Detail Form","Other Business Processes","There are two types of tooltip:","Upper Forms","Detail Form","In the Tooltip window, click the Data Element (for example, status), click Update from Data Element Properties (system-level) to open the Edit Tooltip window, enter the text in the field. Use the arrows (&lt;&lt; or &gt;&gt;) to move to the next Data Element (for example, title) and enter the text in the field.","You can perform bulk update from Data Element properties. In the Tooltip window click Update from Data Element Properties to open the Update tooltip Description window. Ctrl+click multiple data elements to select and click Update.","Internationalization and Tooltips","All the tooltips are extracted as custom strings.","Go to the Company Workspace tab and switch to Admin mode.","In the left Navigator, select Configuration, and then select Internationalization.","Click Find to open the Find window.","Select uDesigner in the Source Type equals field.","Enter &quot;tooltip&quot; in the String contains field.","Modify Data Element","10293234.htm");
Page[206]=new Array("This flexible uDesigner option can be used on business processes and attributes forms. It allows one data element on the form to the control both values and behavior of other data elements on the same form. ","A dynamic data set is comprised of a &quot;set&quot; of data elements that includes a master data element and dependent data elements, which can be drop-down (pull-down) menus or radio buttons. The values that are available to users at runtime for the dependent fields are dependent on the selection the user makes for the master data element field. A dynamic data set can be used on business processes and attributes forms and allows one data element on the form to control both values and the behavior of other data elements on the same form.","For example, you can define a dynamic data set that includes a Country, State, City, Postal Code and Zip Code data elements that function as drop-down (pull-down) menus on a form. The Country field is a master data element. The set can be configured so that, at runtime, the user must select a value for Country, which dynamically controls the values that are available to be chosen for State. The user then selects a State, which drives the choices available for City.","Field behavior (such as required, or read-only) can also be controlled by the dynamic data set. For example, a dynamic data set might include data elements for Country, Zip Code and Postal Code. At runtime, depending on the selected value for the Country, the Zip code field may get become enabled and a required field, while the Postal Code field becomes disabled.","Configuring Dynamic Data Sets","74178.htm");
Page[207]=new Array("Dynamic data sets are imported automatically when you import a business process or attribute form that has the dynamic data set on it.","Setting up a dynamic data set consists of the following:","Prepare elements and data set values. View dynamic data set properties to identify elements of the dynamic data set:","Master Data Element, which drives the behavior of the set.","Value Set, which lists the data elements whose values will be controlled by the master element (for example, if the master element is Country, the value set might include a drop-down [pull-down] data element State, the values of which will change depending on the country chosen).","Behavior Set, listing elements whose behavior is controlled by the master element (for example, a field that becomes Required, Disabled, or Disabled and Clear depending on the value chosen for the master element (for example, the Country chosen might dictate whether the Postal Code or Zip Code field is enabled for the user).","Verify that data definition data sets are populated. The data elements that can be part of a dynamic data set can be drop-down (pull-down) menus or radio buttons. The values for the selections are maintained in the Data Set tab of the data definition properties. Be sure that the individual data definitions have valid data sets. (For example, if you have a State drop-down [pull-down] data element, the data set corresponding to the data definition for the State field must be populated with the state options you want to make available to users.","Define the Value Set and Behavior Set. The value set consists of the fields whose values will be controlled by the master data element selection at runtime. The Master data element is the first element on the list. You will define the values that display at runtime.","The behavior set contains the fields whose behavior (Required, Disabled, Disabled and Clear) will be controlled by the master data element selection at runtime. While Required contains a required text field and Disabled changes the field to read-only, Disabled and Clear clears any previous values in the field and then disables the field, making it read-only. With selecting Disabled and Clear, you avoid entering invalid data and therefore improve data entry.","How to Set Up a Dynamic Data Set","74179.htm");
Page[208]=new Array("Dynamic data sets are imported into the system when a business process or attribute form on which they appear are imported.","To access dynamic data sets:","Go to the Company Workspace tab and switch to Admin mode.","In the left Navigator, select Data Structure Setup, and then select Dynamic Data Sets. The Dynamic Data Sets log opens.","Access Dynamic Data Sets","74180.htm");
Page[209]=new Array("The dynamic data set properties and data elements are designed in uDesigner. The properties window identifies: ","Master Data Element, which drives the behavior of the set.","Value Set, which lists the data elements whose values will be controlled by the master element (for example, if the master element is Country, the value set might include a drop-down [pull-down] data element State, the values of which will change depending on the country chosen).","Behavior Set, listing elements whose behavior is controlled by the master element (for example, a field that becomes Required or Disabled depending on the value chosen for the master element (for example, the Country chosen might dictate whether the Postal Code or Zip Code field is enabled for the user).","To view dynamic data set properties:","Go to the Company Workspace tab and switch to Admin mode.","In the left Navigator, select Data Structure Setup, and then select Dynamic Data Sets. The Dynamic Data Sets log opens.","Select the dynamic data set to edit and click Properties. The Properties window opens. The Properties window is view-only.","The General tab displays the general information about the dynamic data set:","Name and Description","Master Data Element: the data element that serves as the master data element for the set","Data Definition: the data definition corresponding to the master data element. The data definition will be a drop-down (pull-down) menu or radio buttons. The values available for the master data element are entered in the Data Set tab for the data definition.","Form Label: the form label of the master data element","Click the Value Set tab. This tab displays the data elements of the value set, which are the fields whose values will be controlled by the master data element selection at runtime. The Master data element is the first element on the list. Values of each data element are based on the data set values defined under base Data Definition.","Click the Behavior Set tab. This tab displays the data elements of the behavior set, whose behavior (Required, Disabled) will be controlled by the master data element selection at runtime.","View Dynamic Data Set Properties","74181.htm");
Page[210]=new Array("You can add values to dynamic data sets manually one a time, or by importing multiple values from a CSV file. The following describes adding dynamic data set values manually.","Fields defined with a Value Set have values limited by the master data element. For example, a Country master data element can control the values that display for a State field.","To define the value set and behavior set combination:","Go to the Company Workspace tab and switch to Admin mode.","In the left Navigator, select Data Structure Setup, and then select Dynamic Data Sets. The Dynamic Data Sets log opens.","Select the dynamic data set and click Open. The dynamic data set log opens for the selected set.","Click New. The Add/Edit &lt;set name&gt; window opens.","Complete the window. The fields on the window will depend on how the dynamic data set was designed. It may include a value set, a behavior set, or both:","Value Set: These are the data elements that will be controlled by master data element selection at runtime. The Master data element is the first element on the list.","Click the drop-down list and select a value for each data element. The drop-down list values are based on the data set values defined under the base data definition.","In the example in the following figure, the value set is Country and State. At runtime on the form, when the user selects a Country, the State field will populate with the states that are associated with that country. These value sets determine the combinations of Country-State that display.","Behavior Set: The behavior of these data elements (Required, Disabled, Disabled and Clear) will be controlled by the master data element selection at runtime.","Click the drop-down and select Required (Field displays a *), Disabled (Field is read-only), or Disabled and Clear (Field is cleared and disabled, becoming read-only). If you leave the selection blank (or &quot;Select&quot; on the drop-down), there will be no change in behavior for the element.","In the example in the following figure, the behavior set is Mail Stop and Zip Code. In this case, at runtime, depending on the Country chosen, either Mail Stop or Zip Code will become a required field, or will be disabled.","To add another Value Set and Behavior Set combination, click Add, which will save the combination you just entered and let you add another.","When you are done adding combinations, click OK. The set displays on the dynamic data set log.","Data Elements that can be set as Disabled and Clear","The behavior set fields of all data types can be set as Disabled and Clear. Exceptions are mentioned below:","Status","Due_Date","Creator_ID","Record_No","Data elements starting with &#8220;uuu&#8221;","Data definitions starting with &#8220;SYS,&#8221; and the ones not of the following input types:","Text","Textarea","Picker","Date Picker","Date Only Picker","Bitemid","Define the Value Set and Behavior Set Values","74182.htm");
Page[211]=new Array("Importing dynamic data set values consists of:","Step 1: Export the CSV template file","Click the Export button.","Save the file to your local drive.","Step 2: Complete the CSV file","Open the CSV template file.","Enter values for each column as applicable:","Value set: The columns correspond to the date elements that make up the value set. The values you enter here must match values in the data set for the data definition.","Behavior set: The behavior set column is labeled with a (B). Valid values are Required (makes the data element a required field), Disabled (the data element is read-only), Disabled and Clear (Field is cleared and disabled, becoming read-only), or you can leave it blank.","Save the CSV file.","Notes:","When using a CSV template file, the following header is displayed: &quot;For data elements that are required, enter Required as a value. To disable a data element, enter Disabled as a value. To disable and clear any previous value, enter Disabled and Clear. Do not enter any value if there is no behavior change needed.&#8221;","If the CSV template has restricted DEs in the behavior set and the value of Disabled and Clear has been set for the restricted DEs, the system prevents the import and an alert is seen.","Step 3: Import the CSV file","Click the Import button.","Browse to the completed CSV file and click OK.","To download a CSV file containing status details of the import, click Yes at the prompt.","The rows that you completed in the CSV file are appended to existing entries. Duplicate entries are allowed.","Import Dynamic Data Set Values","74183.htm");
Page[212]=new Array("You can delete a dynamic data set combination (value set and behavior set). This removes the combination from use with the dynamic data set.","To delete a dynamic data set combination:","Go to the Company Workspace tab and switch to Admin mode.","In the left Navigator, select Data Structure Setup, and then select Dynamic Data Sets. The Dynamic Data Sets log opens.","Select the dynamic data set and click Open. The dynamic data set log opens for the selected set.","Select an entry and click Delete. Click Yes to confirm.","Delete a Dynamic Data Set Combination","74184.htm");
Page[213]=new Array("When you edit a dynamic data set, any changes you make will not reflect in forms. The data element must be deleted from the form and added again in uDesigner, and the form re-imported. ","To edit a dynamic data set:","Go to the Company Workspace tab and switch to Admin mode.","In the left Navigator, select Data Structure Setup, and then select Dynamic Data Sets. The Dynamic Data Sets log opens.","Select the dynamic data set and click Open. The dynamic data set log opens for the selected set.","Select an entry and click Open, or double-click to open it.","Make modifications to Value Set or Behavior Set as necessary and save.","Edit a Dynamic Data Set Combination","74185.htm");
Page[214]=new Array("You can view the forms on which a dynamic data set is used.","To view dynamic data set usage:","Go to the Company Workspace tab and switch to Admin mode.","In the left Navigator, select Data Structure Setup, and then select Dynamic Data Sets. The Dynamic Data Sets log opens.","Select a dynamic data set.","From the toolbar, click Usage. The Usage window opens, listing the forms on which the dynamic data set is used.","View Dynamic Data Set Usage","74186.htm");
Page[215]=new Array("The system supports multiple calendars, which lets you create a library of calendars that can be selected for use at the company, shell, and project levels. The multiple calendars let you have calendars to support varying work schedules (depending on locality) and to account for holidays and other non-working days. For example, some countries in the Middle East have weekends that are other than Saturday and Sunday. Unless otherwise specified, the default calendar for a project/shell is the Company calendar that is designated as the default calendar. The calendar selected affects project/shell durations and due dates.","The calendars can be used in project/shell templates, and are automatically applied when the template is updated. Also, users can create activity calendars to use in schedule sheets, specific activities in schedule sheets. Calendars also affect business process task dues dates, workflow due dates, and formula calculations. ","Step 1: Set permissions for multiple calendars. Grant permissions to allow the configuration of company-level multiple calendars. See Setting Multiple Calendar Permissions.","Step 2: Create and manage calendars (create, copy, modify, delete, set as default). See Creating Multiple Calendars and Modify, Delete, or Mark a Calendar as Default at Company Level.","Setting Up Multiple Company Calendars","74086.htm");
Page[216]=new Array("You must have permissions granted to be able to create, modify, or view the calendars.","To set multiple calendar permissions:","Go to the Company Workspace tab and switch to Admin mode.","In the left Navigator, select User Administration, and then select Access Control.","On the right pane, expand Administration Mode Access, expand Standards &amp; Libraries, and then select Calendars.","Set the permissions as needed:","Create: Users can create, modify, view, delete, mark as default. These calendars are known as Standard Calendars.","Modify: Users can modify and view Standard Calendars.","View: Users can view existing Standard Calendars.","Setting Multiple Calendar Permissions","74087.htm");
Page[217]=new Array("You can create a calendar and use it as the standard calendar at the company level, shell level, project level, template level, activity level, and business processes.","There is a default company calendar available titled: Company Calendar (Default). You can:","Use the default calendar as the standard calendar.","Use the default calendar to create a standard calendar.","Copy an existing calendar and modify it to create a calendar that can be used as a standard calendar.","Create a custom calendar.","You must have Create permission to be able to create standard calendars.","To create a standard calendar at company level:","Go to the Company Workspace tab and switch to Admin mode.","In the left Navigator, select Standards &amp; Libraries, and then select Calendars. The Calendars log opens.","Click New. The Calendar Properties window opens.","Enter the calendar name and an optional description.","Modify the working and non-working days that are specific to the new calendar you are creating. Select the calendar day and click the Working or Non Working options as needed, and then set the Start Time and Hours/Day. By default, the standard calendar will have Saturdays and Sundays marked as non-working days, and the Default Work Time will have a Start Time of 08:00 AM with 8 hours per day. For more information about modifying the calendar days and Default Work Time, see Modify, Delete, or Mark a Calendar as Default at Company Level.","Click OK.","To copy an existing calendar at company level:","Go to the Company Workspace tab.","In the left Navigator, select Standards &amp; Libraries, and then select Calendars. The Calendars log opens.","Select a calendar in the log.","Click Copy. The Calendar Properties window opens with the calendar description and calendars days specified.","Enter the calendar name and change the optional description as needed.","Modify the working and non-working days that are specific to the new calendar you are creating, as well as the Default Work Time.","Click OK.","Creating Multiple Calendars","74088.htm");
Page[218]=new Array("You can modify a standard calendar if you have Modify permission. You can delete a standard calendar if you have Create permission. If you use a calendar in a project/shell, schedule sheets, or schedule sheet activities, and you are asked to replace the calendar, you can delete the existing calendar and replace it with a new one. You can also specify a default standard calendar if you have Create permission. Unless otherwise specified, the default calendar for a project/shell is the company calendar that is designated as the default calendar.","Note: The calendar selected affects project/shell durations and due dates.","To modify a calendar at company level:","Go to the Company Workspace tab and switch to Admin mode.","In the left Navigator, select Standards &amp; Libraries, and then select Calendars. The Calendars log opens.","Click the company calendar to select and click Open. The Calendar Properties window opens.","Modify the calendar name and change the optional description as needed.","Modify the working and non-working days that are specific to the new calendar you are creating. Select the calendar day and click the Working or Non Working options as needed.","To change a particular date from a working to a non-working day, click the date cell to highlight and click Non Working. You can select multiple dates. This change impacts the months individually and does not impact the rest of the calendar or subsequent years.","To change Saturdays and Sundays from non- working days to working days, click the day cell for example &quot;Sat,&quot; to highlight and click Working. This will make all Saturdays, or Sundays, of the calendar as working days, including subsequent years. In this scenario, you can select individual dates under Saturdays or Sundays and mark them as non-working dates.","Click OK.","To delete a calendar at company level:","Go to the Company Workspace tab and switch to Admin mode.","In the left Navigator, select Standards &amp; Libraries, and then select Calendars. The Calendars log opens.","Select one or more calendars in the log.","Click Delete. If a calendar is not in use, it is deleted. If a calendar is in use, the Select a Calendar window displays to let you select a replacement calendar. Select an alternate calendar and click OK.","Note: You cannot delete calendars that are used by view-only projects/shells.","To specify a default calendar:","Go to the Company Workspace tab and switch to Admin mode.","In the left Navigator, select Standards &amp; Libraries, and then select Calendars. The Calendars log opens.","Select a calendar in the log.","Click Default.","To change working and non-working days on a calendar at company level:","Go to the Company Workspace tab and switch to Admin mode.","In the left Navigator, select Standards &amp; Libraries, and then select Calendars. The Calendars log opens.","Select a calendar and click Open to open the Calendar Properties window.","To change a particular date from a working to a non-working day, click the date cell to highlight and click Non Working. You can select multiple dates. This change impacts the months individually and does not impact the rest of the calendar or subsequent years.","To change Saturdays and Sundays from non- working days to working days, click the day cell for example &quot;Sat,&quot; to highlight and click Working. This will make all Saturdays, or Sundays, of the calendar as working days, including subsequent years. In this scenario, you can select individual dates under Saturdays or Sundays and mark them as non-working dates.","A non-working date appears grayed out, and it will not be used in date calculations.","To change default work time on a calendar at company level:","Go to the Company Workspace tab and switch to Admin mode.","In the left Navigator, select Standards &amp; Libraries, and then select Calendars. The Calendars log opens.","Select a calendar and click Open to open the Calendar Properties window.","Enter values for the Start Time and Hours/Day fields. ","Modify, Delete, or Mark a Calendar as Default at Company Level","74089.htm");
Page[219]=new Array("Information is entered and stored using electronic business process forms and routed via configurable workflows. Business processes&#8212;and their workflows, logs, and even search parameters&#8212;can be created and designed in uDesigner. They are then imported into Unifier, configured for use, and set up for use in specific projects/shells or the company workspace. ","Setting up business processes for use consists of the following steps:","Import and deploy business processes. For more information, see Importing Business Processes.","Configure the BPs to be set up for use. For more information, see Configure and Activate a BP.","Set up the BPs for use at the company-level or in individual projects/shells. For workflow BPs, you can create multiple setups that let you use the same BP form with any number of customized workflows. ","For more information, see Setting Up Non-Workflow Business Processes and Setting Up Workflow Business Processes","Grant User mode permission to all users (including yourself) who will need to view records or participate in a workflow.","Note: Not all BPs work in all areas of the system. For a table that lists all available BPs and the areas in which they are available for use, see Business Process Functionality.","Setting Up Business Processes","74393.htm");
Page[220]=new Array("The Master Log - Business Processes node is located in the Home workspace. The node lets you access all or a subset of records of the same type, in a single log that spans multiple projects/shells. The node also lists all business process types at the project/shell level in separate nodes for each type. This includes workflow, non-workflow, and multiple record business processes.","Note: The company-level and Single-Record business processes (BPs) are not listed under the Master Log - Business Processes node. Single-Record BPs are listed in the General section under Information in the left Navigator. You can also update the User Mode Navigator to list Single-Record BPs under the Home workspace in the Location bar.","For example, your company might have a shell hierarchy of buildings. A dispatcher who is responsible for translating service requests into work orders could use the Master Log - Business Processes node to create and edit work order records for any building shell from a single, &quot;master&quot; log, rather than drilling into each building shell to access the records.","The Master Log - Business Processes node can also be filtered to display only certain records. For example, a regional Lease Manager might need to access all the active leases in the system that have lease amounts greater than $50,000 per year. Using the filter feature, the lease manager could display only these leases in the Master Log.","Note: If you do not grant users the permission to view or access any of the business process types listed under the Master Log - Business Processes node, the users will not see the Master Log - Business Processes node in the Home workspace.","Setting the Master Log - Business Processes Node Permissions","You must give explicit permission(s) to users to access the Master Log - Business Processes node. You can grant permissions for users to access all business processes in the Master Log, or to individual business process types. To view business process records, users must also:","Be an active member in the project, shell, or sub-shell","Have access to at least one business process in the Master Log - Business Processes node","All project/shell business processes in the system (except inactive and single-record BPs) are listed alphabetically in their corresponding Master Log - Business Processes node.","To set permissions for Master Log - Business Processes node:","Go to the Company Workspace tab and switch to Admin mode.","In the left Navigator, select User Administration, and then select Access Control.","In the right pane, expand User Mode Access, expand Home, expand Master Log - Business Processes, expand All, and select the applicable &lt;business process&gt;.","Set the permissions as needed:","Allow Bulk Creation: Users can create BP records across projects/shells using Microsoft Excel and import their data into projects.  Records of only Simple and Generic Line Item BPs are supported.","View: Users can view all business process records across all projects and all records in the shell hierarchy (subject to their highest level of shell membership in the hierarchy) independent of whether they are assignees on or have permissions to view and manage individual records within a particular project/shell. These users can also view saved searches.","Allow Bulk Edit: Users can select one or more records within a Master Log and perform Bulk Edit on business process records. Selected records can potentially span across multiple projects/shells. Users having this permission automatically have View permissions.","Single Record Business Process in the Master Log - Business Processes Node Permissions","In the Master Log, you can assign theViewandAllow Bulk Editpermissions to Users and Groups for a single record business process.","To assign permissions:","Go to the Access Control functional node.","In the Access Control window, expand User Mode Access, expand Master Log - Business Processes, and select All.","Click Project Configuration to open the permissions setting window.","Add Users or Groups, if needed, and select one or both of the following permissions:","Allow Bulk Edit","View","Setting Permissions to Create Business Process Records Across Projects/Shells","In the Master Log, you can set the Allow Bulk Creation permission for users to create records for the following types of business processes across projects/shells:","Simple BPs","Generic Line Item BPs","To assign permissions:","Go to the Company Workspace tab and switch to Admin mode.","In the left Navigator, select User Administration, and select Access Control.","In the right pane, expand User Mode Access, expand Home, expand Master Log - Business Processes, and then select the applicable &lt;business process name&gt;.","In the Module Permissions Settings window of the selected business process, select the user to be assigned the permission, and click Modify.","In the Permissions Settings section of the Permission/Access Control window, click Allow Bulk Creation.","Click OK.","Click OK in the Module Permissions Settings window.","Alternative Methods","You can also set the Allow Bulk Creation permission from the following tabs:","Group Permissions tab","User Permissions tab","Additional Information about Single Record BPs in the Master Log","The system will maintain the shell-level BP permissions, when displaying the single record BPs in master log.","Based on the list at the shell level, you can:","Edit the records that you have created.","Edit the records that you are the record editor of.","Select multiple single record BPs in the master log, click Bulk Edit (Actions options), and see all the DEs that have been defined in the Integration tab with direction set as Both.","Edit multiple DEs in the Bulk Edit window and click Update. Note that this causes all the selected DE values to be updated, across all projects/shells.","Master Log - Business Processes Node","74394.htm");
Page[221]=new Array("For Business Processes, Shells, the Space Manager, and Code and Records-based managers, you can design either a Standard log or an Advanced log for display in Data Pickers. An Advanced Log creates an extra navigation structure that makes it easier for the user to choose records to work with.","Note: The default elements and fields (log layout, view, search, and so on) that are defined in uDesigner for the Standard Log determine the Standard user interface elements and fields of all logs.","Advanced Logs and Standard Logs","74395.htm");
Page[222]=new Array("All designs, including Business Processes, are designed in uDesigner and deployed to Unifier. See Importing Configuration Packages. ","Importing Business Processes","74396.htm");
Page[223]=new Array("Business process configuration lets you configure and activate the company-level information for each business process you will use. After business processes are deployed, they are available for use. Configuring allows activation of the business process and specific workflow schema that can be used in projects/shells or the company level.","Configuration consists of:","Activating or deactivating a BP (deactivating an active BP will also deactivate all its setups)","Determining which BP log the BP records will be stored in (for example, project logs, shell logs, company logs, Data Manager, and so on)","Establishing the BP record numbering sequence","For workflow BPs, activating the workflows that will be allowed for use with the BP","Creating a custom-designed print layout that can be used to print BP records","Assigning a predefined category tag to a BP for more useful, insightful reports, dashboards, and data visualization","Note: Configuration of the Data Picker and Data Elements (and when applicable: Unique and Auto Sequence settings) must be done in uDesigner.","To access the Business Process configuration log:","Go to the Company Workspace tab and switch to Admin mode.","In the left Navigator, select Configuration, and then select Business Process.","The Configuration - Business Processes log opens. The log lists the Business Processes that have been imported into the system.","The newly imported Business Processes are inactive by default and are activated during configuration. The ID column shows the short code used to identify the Business Process, as defined in uDesigner. During configuration, you can choose to include this identifier as part of the record number (for example, if a BP has an ID of uaici, individual record numbers created for the BP might be uaici-0001, uaici-0002, and so on). ","Configuring Business Processes","74399.htm");
Page[224]=new Array("The following procedure describes how to configure and activate a business process. If the business process form contains a data picker, you must also configure the data picker. ","To configure and activate a BP:","Go to the Company Workspace tab and switch to Admin mode.","In the left Navigator, select Configuration, and then select Business Process.","The Configuration - Business Processes log opens. The log lists the Business Processes that have been imported into the system.","Select a BP and then click Open to go to the Configuration - &lt;BP NAME&gt; window of the selected BP.","In the Configuration - &lt;BP NAME&gt; window, select a record, click Open, and enter values in each tab as described below.","General tab: In this tab, you can specify the log in which the BP records will appear, the numbering sequence for the records, the status, and record termination restrictions. The tab also shows whether the BP is company, project, or shell level.","Workflow tab: In this tab, you can activate one or more workflows that have been imported with the BP. A business process may have multiple workflows. Non-workflow BPs will not appear in this tab.","Query tab: In this tab, you can set query and refresh conditions.","The following explains the fields on the General tab:","In this field:","Do this:","Level","Select the level at which the BP displays:","Company","Project/Shell","Default Location","Choose where the BP records will be stored. Some BP types will default to a log and cannot be changed.","If you are using the user configurable Navigator, you might not immediately see the BP in the User Mode log, even after granting permissions. You must manually move the BP into the correct User Mode node.","Sequence Policy","This determines how the record numbers for each BP record are sequenced. The record number is displayed on the form and in the Business Process log.","Company Based: Regardless of which project a BP record is created in, the record numbering sequence starts with this number on the first record of the first project/shell.","Project/Shell Based: A new record numbering sequence begins for each new project/shell.","Sequence Format","The prefix and starting number that will be used for BP record numbers.","Use Base Commit's Record Number: This is for identifying workflow Change Commits (Line Items with CBS Code Cost BPs) at the project/shell level. For this type of change commit, you can use the base commit record number as part of the prefix of the change commit record number to identify the base commit associated with the change commit. It will also sequentially number the change commits so users can see how many change orders have been initiated for the base commit.","To specify this addition to the prefix number, you must include a separator, such as a period, and a starting number for the change commits. The maximum number of characters for the starting number is 8. For the total format, including the base commit's record number and the sequential numbers, the maximum number of characters is 20.","For example, a base commit record might be numbered PO-00123456. For a change commit record that refers to this base commit, the change commit record number could be PO-00123456, followed by a separator (such as - ) and a number for the change commit. The sequence format for change commits attached to this base commit could be numbered:","PO-00123456-001","PO-00123456-002","PO-00123456-003","This numbering sequence will be frozen after it is used for a change commit in a project/shell. Any change to this numbering sequence will only affect change commits created in a new project/shell.","Business Process Log","There are two options:","Standard ","Advanced","If standard, the option Standard is selected.","Business Process Identification Tag","Select one predefined identifier tag from the alphabetized list to assign to a BP during BP configuration. The tag will categorize and organize the BP data for use in reports, dashboards, and data visualizations.","Record Creator","Options available are:","Do not allow to terminate record: Selecting this option will remove the default permission for the record creators, and it can be set in Access Control.","Allow to modify record: This option displays only if you are setting up a workflow business process (BP).Selecting this option lets the creator of a workflow BP modify the record at any time, whether or not the creator is an assignee on the step. Additionally, the creator can modify the record while an assignee is working on the record.","Note: Updates made and saved by the creator can be viewed at any time. The system lists all changes in the audit log.","Do not allow to transfer ownership of records: Selecting this option will remove the default permission for the record creators, and it can be set in Access Control.","Enable audit of record print","Deselected by default.","If selected, the user can view the audit log entries for print and discover the number of times that a record has been printed.","When you select this option, the following user actions on a record will create an audit entry:","Printing from BP record","Single &amp; Bulk Printing from the BP log.","Single &amp; Bulk Printing from the Tasks log","For bulk print, the number of entries seen in the audit log will be the same as the number of records that were printed by way of the bulk print action.","Mobile Application","Enable: To make this business process available for the native mobile apps, select this option. You can use the Mobile Log Views setup to configure customized log views. After selecting this option, the following options are available:","Allow camera as the only source for attachments and image fields: For BP record and BP line item attachments, this option is applicable only when &quot;My Computer&quot; is a source of attachments. When selected, the user will only be allowed to take pictures from the device camera and add them as attachments and images in the image picker fields.","Allow auto filling of the latitude and longitude upon record creation: If you want the mobile application to complete the latitude and longitude fields automatically during record creation, select this option.","Email Notifications","Replace attachments with links: Use this option when the BP record and the BP line item attachments are large in size. To reduce the load on email server and accommodate to maximum email size, the user receives the links to the attachments, in the email. The user must log in to view and download the attachments.","Use the Replace attachments with links option when the BP record, and line item, attachments are large in size. When selected, to reduce the load on email server and accommodate to maximum email size, the user receives the links to the attachments in email. The user must log into the system to view and download the attachments. You (the Admin) must enable the option, if requested.","See the topic after this table for details about Email Notifications and Unifier users.","Document Publishing","Override DM Permissions: Select this option if you want to enable users to publish the attachments in a BP by overriding its Document Manager permissions.","Status","Active enables the BP to be set up and used to create BP records.","Inactive prevents set up or use of the BP.","Email Notifications and Users","The following functionalities are applicable to the following users:","Standard Users","Portal Users","Collaborator Users","Note: The user must have the appropriate permissions to access attached files.","For BPs that have the Replace attachments with links option enabled, the email notification will contain an organized list of attachment names (related to their origin) derived from the BP upper form, or the BP line item.","The attachment name:","Contains an underlying unique link that enables the user to navigate through the system and access the corresponding attachments.","Shows the file size beneath the name.","In the email notification the attachment names are listed in three columns, per row. The system will truncate any attachment name that exceeds the allocated width of the column (suffixed by ellipsis before the extension name so that extension name is evident to user). The user can hover over the attachment to see the full file name.","The system displays the list of attachments after the email notification content.","The View in Unifier option in the email notification contains a link that redirects the user to Unifier and opens the task or BP record. All email notifications have the View in Unifier option. The View in Unifier option redirects the user to Unifier, and, after the user has signed in to the system, will open the associated BP record. If the user has already signed in, clicking the View in Unifier option would open the associated BP record. ","The Download All Attachments option enables the user to download all the attachments together and at once. You can close the Your download is being prepared window and continue working. The download is triggered after it is prepared in the background. The delay is to accommodate the processing of the zip file. The zip file has the files organized; therefore, the root folder has all the record attachments, and each BP line item attachment is in separate folder with the folder name being the name of line item tab name.","If the user logs out before the download is initiated, the download preparation is canceled.","If an attachment is deleted after the email notification has been sent, the attachment will not be included in the zip file, if the name of the zip file is the same as the one that is attached to email notifications.","The system will use the current permissions, and the BP configuration, for the signed in user.","If the permissions are changed after the email notification has been sent, the user will not have the permission to download any attachments. ","If the permissions are changed to 'download only a few files,' the &quot;Download All Attachments&quot; option will only include the files that the user has permissions to download.","If the permissions for the BP record are changed, the system redirects the user to the landing page and does not open the BP record.","If the user has set up a daily digest for the email notifications, then:","Email notifications from the BPs that have the Replace attachments with links option enabled will have attachment links.","Email notifications from the BPs that do not have the Replace attachments with links option enabled will not have attachment links and instead will contain the raw file as the attachment.","If the daily digest email size exceeds the limit, the attachment links are retained while the raw files are replaced with a warning message.","As a result of the BP setup at a project level or a shell level and the user preferences:","For workflow BPs:","If the Include both record and line item attachments option (in the BP configuration) is enabled, the option will be selected, before every notification-triggering event.","Every email notification that has been sent to the user based on the user's preferences will have the &quot;Include both record and line item attachments&quot; option (in the BP configuration) selected.","For non-workflow BPs:","If the Include both record and line item attachments option (in the BP configuration) is enabled, the option will be selected, before every notification-triggering event.","After the user clicks on download and signs in to the system, the user will be redirected to the Downloading Email Attachment Landing Page. The landing page opens in a new tab when a session is active.","Note: If you are not signed in to Unifier, the system will redirect you to the Unifier sign in page when you try to download an attachment.","Configure and Activate a BP","74400.htm");
Page[225]=new Array("Workflow business processes may have one or more workflows, which, along with the BP settings, control how BP records flow through the steps of the creation, response, review, and approval process. Workflows are designed in uDesigner and included with the BP. You must activate the workflows that you plan to set up and use. ","Note: This is applicable for workflow BPs only. Non-workflow BPs will not display this tab.","To configure and activate a workflow:","Go to the Company Workspace tab and switch to Admin mode.","In the left Navigator, select Configuration, and then select Business Process.","Open the applicable BP.","In the Configuration - &lt;BP NAME&gt; window, click the Workflow tab.","To activate a workflow, select the workflow and click Activate.","Alternatively, you can select a workflow and click Modify. The Workflow Configuration window opens.","In the General tab, you can edit the name or description if necessary.","You can change the status to active in this tab.","To view the steps of the workflow, click the Step tab.","Click OK to exit the Workflow Configuration window.","If you have edited or added a workflow to an existing business process and re-imported, you may need to add the new workflow. Click Add to add newly defined workflows, if any exist.","Click Apply to save your changes, and OK to exit the Business Process Configuration window.","Configure a BP Workflow (Workflow Tab)","74405.htm");
Page[226]=new Array("You can configure a query for a Query Based Data Element (QBDE) on a business process (BP). The QBDEs give you the ability to query data from BPs and manager sheets and display the results on a BP. For example, you can create a small cost report on a BP. This reduces referring back to the cost sheet while a user is working in the BP.","When a QBDE is added in a BP form, you can define the query on which the element gets refreshed (trigger element).","Example","Go to the Company Workspace tab and switch to Admin mode. In the left Navigator, select uDesigner, and then select Business Processes. Open the Action items BP, and then select Upper Forms in the left Navigator.","Add a QBDE in an Upper Form of a BP and deploy it.","Go to the Configuration tab, select Business Process, and then select Required BP and open it to see the Query tab.","During configuration for each QBDE (up to five per BP), you can define a query formula and any conditions that will filter query results. For example, if you want to see the total project commitment, which includes the original commitment amount plus any changes to the original commitment, you can build a query formula to show that value from the cost sheet. You may limit, or filter, the query results by adding a condition. You can also define the refresh condition that will prompt a data update for these QBDEs. When a user opens the BP, the system looks at the refresh condition to determine if it can display the last calculated value or values in the BP. If you need the QBDE to recalculate after a user opens a form but before submitting the record, you can use a trigger element. In uDesigner, under the data element properties of the QBDE, you can select one or more trigger elements. If the user updates the value of any data element specified as a trigger element, the QBDE will recalculate.","Notes:","Because the system does not provide a way to specify the order of operations applied in QBDE evaluation, Oracle recommends that you do not create a QBDE that uses a formula that references another QBDE.","DEs that have been defined as a QBDE trigger element should not be evaluated as part of QBDE calculation.","This feature is not available for a single-record business process at the company level.","The difference between a refresh condition and a trigger: A refresh occurs when a user opens a business process. A trigger works when the BP is already open and a user changes a value in a &quot;trigger element&quot; on that BP form. The trigger element prompts the system to run the query again and dynamically update the value in the query-based field.","When using QBDE, be aware that query elements are rounded off to use two decimal places, even if the Base Currency and various defined currency fields are different.","To configure the query:","Go to the Company Workspace tab and switch to Admin mode.","In the left Navigator, select Configuration, and then select Business Process.","The Configuration-Business Processes log opens, displaying the BPs that have been imported into your company.","Select the business process that contains the query-based data element, click Open and go to the Query tab.","Under Query Conditions, click the Add button.","The Define Query window opens. The Define Query window shows two sections, a Definition section and a Condition section.","Fields in the Definition section:","Data Element: Select the data element you want to configure. The list shows only the query-based data elements on the form.","Data Type: Select the source from which the system will extract the values (for example, a column in the CBS Cost Sheet or a business process).","Datasource: Click the Select button and on the Formula Creation window that appears, build a formula to calculate the value you want to see in the field on the BP form. For information on creating a formula for a query, see Queries in the Unifier General Administration Guide.","To specify a condition to filter the data that is extracted by the definition and refine the condition further:","Click the Add button. The Add Query Condition window opens.","Use the instructions under About Queries to complete the query condition.","Click OK.","Note: Query conditions ignore the Timestamp for Date-type data elements. Therefore, at run-time, when queried on a date picker, search results display records that satisfy only the date criteria. For example, all records updated on April 10, 2024 display, regardless of the time they were updated.","On the Define Query window, click OK.","On the Data Elements Configuration window, under Refresh Conditions, click the Add button. The Refresh Condition window opens. Fields in the Refresh section:","Data Element: Select the data element you want to prompt the field refresh.","Condition: Select the condition this data element must meet to prompt the refresh.","Values: Enter or select the value this data element must contain to prompt the refresh.","AND/OR: Select the &quot;And&quot; or &quot;Or&quot; condition between multiple queries.","Click OK, and then click Close on the Data Elements Configuration window.","Configure a Query for a Query Based Data Element on a BP","74404.htm");
Page[227]=new Array("When users configure Business Processes (BPs), they can also create log views for the BPs.","Log views are the views which drive the content and behavior of the BP logs seen at run time. The Administrators can create customized &quot;default&quot; log views that meet the requirements of the company and users.","Note: Users can only create the view in each project for the BPs that the users have access to.","This topic explains the following:","BP Log Views","BP Log Views at Runtime","BP Log Views and Configuration Package","BP Log Views","BP log views can be created for:","Project-level BPs","Company-level BPs","The views defined for the BPs are applicable to both BP logs and the Master Log - Business Processes log.","The Business Process node (go to the Company Workspace tab and switch to Admin mode; in the left Navigator, select Configuration) has the following sub-nodes related to log views:","Log Views","Mobile Log Views","The Log Views sub-node, seen in all types of BPs, lets you:","Create your log view, similar to creating BP logs in User mode.","Reorder the BPs.","Change the status of a BP.","Delete inactive views.","Note: Users must have &quot;Configuration&quot; permission before they can access the Log Views node or create log views.","The Log Views log has the following features:","Toolbar","Create: To enable the administrator to create a view.","Manage Views: To take one of the following two actions: Activate a view (Active) or delete a view (Delete).","Status identifies whether a view is active or inactive. You can select the check box next to a view to activate or deactivate a view.","Delete lets you delete a view. You can delete a view that has been marked as inactive. If you select multiple views and delete, only the inactive views will be deleted.","Refresh: To refresh the views in the log.","Find on Page: To find a specific view on the displayed page.","Columns","No.: The system-generated number to help the user identify the sequence of the views.","Changing the sequence of the views (moving them up or down on the page) will result in change of the system-generated number.","At least one BP log view must be active. The administrator cannot deactivate all BP log views.","The user cannot create two BP log views with the same name for a single BP.","When a user changes the sequence of the BP log views that were initially provided according to the BP configuration, the system retains the user's sequence even if the administrator makes changes to the sequence.","If an administrator creates BP log views, the system appends the new BP log views to the end of the BP log views list.","Name: The name of the view.","Status: Active or Inactive","Last Modified Date: The date that the view was last modified. For a new view, this will be the creation date. The field is initially blank for existing system-defined views, when no modifications have been done.","Last Modified By: The name of the user who last modified the view. The field is initially blank for existing system-defined views, when no modifications have been done.","The gear menu ( @ ), which appears when you click a record, has the following options:","Move Up: To move a record up on the log. This option is not available for the first view on the log.","Move Down: To move a record down on the log. This option is not available for the last view on the log.","Active: Sets the view status to Active.","Inactive: Sets the view status to Inactive.","BP Log Views at Runtime","BP log views will be a part of BP configuration. Only active views will be seen at runtime. All active views pertaining to a BP can be seen by all users who have access to the log (BP logs and Master Log - Business Processes log). System provided views can also be modified in the Log Views to better suit your business needs.","All Records","Records Created by Me","Records Received by Me","Records Created and Received by Me","AI view","Create New View","Manage Views","BP Log Views and Configuration Package","Use the Log Views node (go to the Company Workspace tab and switch to Admin mode; in the left Navigator, select Configuration Package Management, select Component Lists, open the applicable [configuration], and then select Log Views) to include the designs for the selected log views in your configuration package.","BP log views in Component list/Configuration Package:","The users can include BP log views and deployed designs.","The users can include updated BP log views without any changes to the underlying columns used in the View definition.","When the configuration package is imported, it replaces any existing BP log views that were created by the administrator.","Note: The BP log view component will be included as part of the impact analysis report, error report, and print report.","Creating BP Log Views in Admin Mode","10292244.htm");
Page[228]=new Array("The information in this topic applies to the following pickers:","CBS Picker","CM0 Picker","CMx Picker","Note: Each class of CMx picker can have its own query conditions.","Funding Picker","If the picker Data Element (DE) is added on the BP form, you can also configure the query condition on the picker Data Definition (DD) to restrict the visibility of available data at runtime.","As an administrator, you can:","Configure query condition on picker DE to restrict the visibility of available data at runtime.","See whether any query condition is added. ","Perform the following actions:","Add new query condition","Modify/delete existing query","Apply And/Or condition","Add a query based on different data selection to filter data that needs to be available at runtime","Change And/Or conditions among different queries","Save so that only saved changes are applicable and data is filtered based on saved queries or cancel changes made in query conditions","See a list of all available picker attributes in the required DD field, on the Add Query Condition and Modify Query Condition windows. This lets you select an attribute value from the drop-down (pulldown) menu to apply the condition on.","See a list of all available options for the required Condition, field based on the DD field value on the Add Query Condition and Modify Query Condition windows, while adding or modifying a query condition. This lets you select the appropriate condition to apply between the DD and values. ","Note: To define a query condition, you can use the Date Picker and Date Only Picker. No other pickers are supported. Also, the cost code and cost attribute pickers cannot be used in the query condition. The query conditions you define with the BP data pickers will only return data sourced from the shell you specify. The query will not return values from other projects/shells.","Select the value (Value field) as Dynamic or Constant, if the DD and the Condition fields have values on the Add Query Condition and Modify Query Condition windows, while adding or modifying a query condition. This is so you have a choice to:","Define that a comparable value will be provided at runtime, based on the Data Source selection, or","The value can be a constant value. ","The system compares the DE value against a given or selected constant value and filters the data based on the defined condition at runtime.","Have different options (such as Cancel, Add Another, and Add or Update) while adding or modifying a query condition. You can select:","Cancel - to cancel the changes","Add Another - to add another query condition","Add - to add the query in the query log","Update - to update the existing query, in the query log","See added or modified query conditions in query log. This is so you can see all the added query conditions in one place, and if required, delete or modify the existing query condition. Also, it will provide the option to put And/Or condition in the defined query conditions.","To view the Pickers functional sub-node:","Go to the Company Workspace tab and switch to Admin mode.","In the left Navigator, select Configuration, and then select Business Process.","Open the applicable BP.","In the left Navigator, you see the Pickers functional sub-node, in addition to the other sub-nodes, such as Log Views, Mobile Log Views, and Customize Email.","The Pickers functional sub-node is available if the picker DE has been added on the BP form. The Pickers functional sub-node log has the following panes:","Pickers Configurations (the left pane) which displays the DEs, under the Data Elements block. The Data Elements block displays the available pickers.","&lt;picker name&gt; Query Conditions (the right pane) which displays the query conditions. In the &lt;picker name&gt; Query Conditions you can use the following toolbar options:","Click Add to open the Add Query Condition window, select the DE, determine the condition for the query, create and add your query conditions. ","The Data Element drop-down field is a required pulldown field that will list all the attributes. You can select any of these attributes to define the query.","The Condition field is a required field that is disabled by default. After the value for Data Element is selected, the system enables the Condition field and lists the values to select from.","For numeric type DEs, the conditions will differ from string and date type elements.","If the values for the Data Element and Condition are selected, a new section will be displayed labeled Value. The Value has the following options to select from:","Dynamic","Constant","Query condition value as Dynamic","By default, the option Dynamic is selected and there will be drop-down fields to select the data source and data element (based on Data Source value). The Data Source value can be &lt;BP Name&gt;, upper form, &lt;BP Name&gt; detail form, single instance BPs, and shell attributes. Based on the data source that you select, the list of matching DEs will be listed.","Query condition value as Constant","If you select Constant, a text box or pulldown is displayed, based on the type of the value under the Data Element field. In case of the text box, a placeholder text 'Type here' will be displayed. You can enter a constant value.","To select a value from predefined data set, a pulldown will be displayed, and you must select a constant value from the pulldown.","Example","If the Data Element value is Status, the constant will be a pulldown with values as Active or Inactive.","Query on Date type data element","When you select the Date DE for the type of the value under the Data Element field, the Condition drop-down field will list all the available conditions for the Date DE. Depending on the selection in the Condition drop-down field, different options will be displayed.","After all queries are added, they will be listed within the Query Condition log with the And condition as a check box, not selected by default.","Select the Show results matching any of the following conditions option to apply the And/Or condition to multiple query conditions. By default, this option will be deselected. You will be able to change the selection.","The &lt;picker name&gt; Query Conditions has the following columns:","Data Element","Condition","Value","And/Or","Delete","Edit ","The Cancel and Save options will appear at the bottom, when you change an existing query or add a query. When you click Save, the query conditions will be saved in the database. After you click the Save or Cancel options, the system will not display those options on the pane, until the next change.","Note: The attributes added on the detail form will be available to define query conditions even if it is a part of a hidden block.","As soon as a query is added to the log, the Delete and Edit options will be displayed in log. The Delete option will delete the selected row, and the Edit option will open the Modify Query Condition, where you can view or modify the condition. Double-clicking an existing query in the query log also lets you view or modify the condition.","After performing any action, you must click Save to save the changes.","Date Type Query Condition","If the value for the Condition drop-down is empty, or not empty, there is no need to define any value.","You can select the value for Condition as between and select a date range between two dates: Date 1 and Date 2. The available options are:","Dynamic","Selected by default. You are required to select a date for Data Source and a Data Element value to define value of the Date field.","Date","To select the date from the system calendar.","Today","To select the current date.","In the Condition field, if you select any value other than between, is empty, or is not empty, different options will be displayed for selecting the date value:","Date","You can select one of these options:","Dynamic","Selected by default and the user needs to select a date 'Data Source' and 'Data Element' to define Date.","Date","To select the date from calendar.","Today","To select the current date.","Add/Subtracts days","Your options are: Plus, Minus, and None. By default, Plus is selected.","Number of days","Displayed only if Plus or Minus is selected. You can select one of the following options:","Dynamic","Selected by default. You must select a date Data Source and a Data Element to define the Date.","Days","To set a numeric value.","Configure Pickers in Admin Mode","10301506.htm");
Page[229]=new Array("Administrators can create customized &quot;default&quot; mobile log views that meet the requirements of the company and users.","BP Mobile Log Views","To create mobile log views, you must first make sure the BP is mobile enabled. To do so:","Go to the Company Workspace tab and switch to Admin mode.","In the left Navigator, select Configuration, and then select Business Process.","Open the applicable BP.","In the left Navigator, select Mobile Log Views.","The Mobile Log Views sub-node, seen in all types of BPs, lets you:","Create your mobile log view, similar to creating BP logs in User mode.","Reorder the BPs.","Change the status of a BP.","Delete inactive views.","Note: Users must have &quot;Configuration&quot; permission before they can access the Mobile Log Views node or create log views.","The Mobile Log Views log has the following features:","Toolbar","Create: To enable the administrator to create a view.","Manage Views: To take one of the following three actions: to make the status of a view Active or hidden, to delete a view, or to reorder views.","Refresh: To refresh the page.","Find on Page: To find a specific view on the displayed page.","Columns","No.: The system-generated number to help the user identify the sequence of the views.","Changing the sequence of the views (moving them up or down on the page) will result in change of the system-generated number.","At least one BP log view must be active. The administrator cannot deactivate all BP log views.","The user cannot create two BP log views with the same name for a single BP.","When a user changes the sequence of the BP log views that were initially provided according to the BP configuration, the system retains the user's sequence even if the administrator makes changes to the sequence.","If an administrator creates BP log views, the system appends the new BP log views to the end of the BP log views list.","Name: The name of the view.","Status: Active or Inactive","Last Modified Date: The date that the view was last modified. For a new view, this will be the creation date. The field is initially blank for existing system-defined views, when no modifications have been done.","Last Modified By: The name of the user who last modified the view. The field is initially blank for existing system-defined views, when no modifications have been done.","The gear menu ( @ ), which appears when you click a record, has the following options:","Move Up: To move a record up on the log. This option is not available for the first view on the log.","Move Down: To move a record down on the log. This option is not available for the last view on the log.","Active: Sets the view status to Active.","Inactive: Sets the view status to Inactive.","BP Mobile Log Views at Runtime","BP log views will be a part of BP configuration. Only active views will be seen at runtime. All active views pertaining to a BP and can be seen by all users who have access to the log.","BP Mobile Log Views and Configuration Package","Go to the Company Workspace tab and switch to Admin mode.","In the left Navigator, select Configuration Package Management, and then select Component Lists.","Open the applicable configuration.","In the right pane, locate Mobile Log Views.","Use the Mobile Log Views node to include the designs for the selected log views in your configuration package.","BP mobile log views in Component list/Configuration Package:","The users can include BP mobile log views and deployed designs.","The users can include updated BP mobile log views without any changes to the underlying columns used in View definition.","When the configuration package is imported, it replaces any existing BP mobile log views that were created by the administrator.","Note: The BP log view component will be included as part of the impact analysis report, error report, and print report.","Creating BP Mobile Log Views in Admin Mode","10296938.htm");
Page[230]=new Array("When you send task notification emails from various trigger points, you can customize the email subject line to provide more context to those notifications. You must have the permissions to configure a Business Process to access the node Customize Email grouping node.","The majority of the BPs include email subjects for Personal Tasks, CC'd Tasks, Overdue Personal Tasks, Record Workflow Complete, and Decline Tasks. The Request for Bid (RFB) types of BPs also include email subjects for Login Information, Bid Invitation, and Due Date Change.","Note: The email subject lines can be configured only for workflow-type business processes.","The Subject Line node contains a table of email types and preferred languages. You can configure the email subject line in multiple languages as set in the Company Preferences. The language that is set to &quot;Active&quot; in the Internationalization node is the only language displayed in the right pane.","To customize the email subject line:","Go to the Company Workspace tab and switch to Admin mode.","In the left Navigator, select Configuration, and then select Business Process.","In the Configuration - Business Processes log, locate and open the applicable BP.","In the left Navigator, select Customize Email, and then select Subject Line.","Go to the column of the applicable language, and click the Configure icon for the email type.","Note: The preferred language must be selected as &quot;Active&quot; in the Internationalization node.","In the Subject Line in [language] dialog box that appears, enter or edit the subject line in the free form text field.","Notes:","The subject line can be a combination of simple text, shell information, data elements from the BP Upper Forms, and Workflow steps.","The maximum number of characters must be fewer than 299. ","Select the data elements from the grid in the lower section of the dialog box.","Note: The &lt;DE Label&gt; is displayed if the selected data element does not hold a value in the runtime.","Click Save.","The language column shows the email subject line corresponding to the email type.","Note: DEs of type Rich text are not available to be added in the email subject line configuration, or to be added to the custom email content.","Customizing Email Subject Line","10293644.htm");
Page[231]=new Array("Just like the subject line, you can also customize the email content of task notifications. ","The Content node contains a table of email types and preferred languages. You can configure email subject line in multiple languages as set in the Company Preferences. The language that is set to &quot;Active&quot; in the Internationalization node is the only language displayed in the right pane.","To customize the Email Content:","Go to the Company Workspace tab and switch to Admin mode.","In the left Navigator, select Configuration, select Business Process, and then open the applicable BP.","In the left Navigator, select Customize Email, and then select Content.","From the toolbar, click Create.","In the window that appears, select the tab for the preferred language. ","Enter a Name for the email content template.","Type the content for the email in the box below. Select data elements to include in the email as needed.","Note: The &lt;DE Label&gt; is displayed if the selected data element does not hold a value in the runtime.","Click Save.","The language column in the Email Content log shows the total size of the email content.","Customizing Email Content","10300166.htm");
Page[232]=new Array("If tagged for Configuration Package, the system allows you to include the following configurations in the Business Processes:","General setup","All the fields included in the General Configuration (General tab).","Custom Print","Word and PDF templates, if any.","BIP Custom Print","All the Oracle Analytics Server Custom Print in the Custom Prints and Reports.","Workflows","All configured Workflows.","Query","All queries that have been configured based on data elements.","For more information, see Configuration Package Management.","Configuring Business Process Configuration Package","10282357.htm");
Page[233]=new Array("Business processes must be set up before use. The general procedures apply to company-level and project/shell-level business processes, with some differences.","Workflow Business Processes","Workflow business processes can have one or more BP setups, which define the workflow setup options. These include configuring the workflow and each step. These options control step behaviors as the BP moves through the steps of the workflow. Each step can have an associated duration and the workflow (consisting of all the steps) can have an overall duration, which facilitates project/shell data flow-through and tracking. BP setup is the process of choosing a configuration, assigning users or groups to each step, configuring the actions they can take on that step, and setting the durations.","You may want to create multiple workflows per BP to accommodate different ways for the workflow to operate. For example, you can configure an RFI workflow with or without a coordinator. You may or may not have a need for both workflows on your project/shell.","Non-workflow Business Processes","For non-workflow business processes, one setup is allowed. Setup includes adding the list of users who can create a non-workflow BP.","Set up of auto-creation of business processes or line items","Both workflow and non-workflow BPs support auto-creation. Auto-creation can be based on a:","Condition that is met","Date that passes","Condition and a date","Frequency (at periodic intervals, for example)","Condition and frequency","You can auto-create BPs or line items from the upper form or the detail form, using creator elements. See Set up auto-creation for a non-workflow BP or planning item for non-workflow auto-creation setup and Set up auto-creation for a workflow BP for workflow auto-creation.","Auto-creation of BPs based on workflow steps","You can specify that some workflow BPs include steps during the workflow that enable the auto-creation of BPs from an S-Step. See Define the Business Process Workflow for details.","Special setups","There are special setup procedures for blanket purchase order BPs and Request for Bid (RFB) BPs. There is an additional option for auto-creation of a commitment-level cash flow curve in setups for base commit business processes.","General Procedures for Setting Up Business Processes","74408.htm");
Page[234]=new Array("Loading the business process is part of setting it up. In this step, you will be loading the configured business process into the area where it should reside&#8212;the Company Workspace or a project/shell. This step filters the business processes by company, shell, or project level, thereby narrowing the number of BPs so that the users do not have to sift through your company's entire list of BPs.","When you load a business process, you also load the permission infrastructure and the ability to grant permissions for this BP.","To load a business process:","Go to the Company Workspace tab and switch to Admin mode.","In the left Navigator, select one of the following:","To load a BP into the Company Workspace, select Company Workspace, and then select Business Process Setup.","To load a BP into a shell, select Company Sponsored Shells, select the [shell type], and open the [shell instance]. In the left Navigator, select Setup, and then select Business Process.","To load a BP into the templates for a shell, select Templates, select Shells, select the [shell type], and open the [shell template]. In the left Navigator, select Setup, and then select Business Process.","Click New.","The New Business Processes window opens, showing the business processes that are available for loading.","Select the business process you want to load and click OK.","The system displays the business process in the right pane.","Loading a Business Process","74409.htm");
Page[235]=new Array("Use this procedure to set up non-workflow business processes at the company-level or at the project/shell-level. The settings for each business process are specified in the Business Process Setup window.","Prerequisite: Ensure you have added the business processes to the log.","Procedure","To set up a non-workflow business process: ","Go to the shell tab or go to the Company Workspace tab for a company-level business process.","Switch to Admin mode.","Navigate to the Business Processes log.","Select the non-workflow BP and click Open. ","In the General tab of the Setup log, click New.","In the Business Process Setup window, enter information in the tabs below and click OK. ","General tab to set up basic information about the non-workflow business process.","Settings tab to designate users who can create and edit the business process.","View Forms tab to control the information visible to users and groups.","Record Properties tab to control who can view BP properties and tabs, and download attachments in user mode.","Notification tab to set up users and groups who will receive email notifications about the business process.","Auto Creation tab to specify whether line-items, records, or business processes are to be auto-created from this business process.","Select any of the following options: ","Click Yes to activate the business process (BP) and make it available to users. ","Click No to keep the business process (BP) inactive until a later date.","Additionally, you can also set up Single-Record Business Processes to single-source information that you use repeatedly in your project/shell."," ","Setting Up Non-Workflow Business Processes","74410.htm");
Page[236]=new Array("For a non-workflow business process, enter the following information in the General tab of the Business Process Setup window:","In this field:","Do this:","Setup Name","Enter a unique name (required field).","Description","Enter a description. This is optional, but recommended.","Help File","Lets you add a custom PDF help file.","Default Record Status","Use this field in setting up the creation of non-workflow business processes. The status you enter here will be used as the beginning status for a record created using any method&#8212;manual, integration, or auto-creation of any type.","Note: If the default status that you select has been set to Inactive, an error message appears when you activate the business process setup, the selected status is removed from the list, and you must select a different status.","Send error notification to:","Specify the user to receive error notifications.","Save Record Information to Document Manager","Select this check box if the records produced by this business process should be automatically saved in the Document Manager. If you select this option, the system will send a copy of the business process' records, along with their comments and attachments, to a specified folder* in the Document Manager. The owner of the published record will be the assignee of the business process that published it. If the record exists in the folder, the record will be published as a revision. If the path to the folder is invalid for any reason, the record will be sent to the Unpublished Documents node.","Depending on how you set up the business process, it can be automatically published to the Document Manager whenever an email notification is sent regarding the status of the business process.","* This folder is identified on the business process with this data element uuu_dm_record_info_path. For information about this element, refer to the Unifier Data Reference Guide.","Default Record format for Notification and Document Manager","This option has two purposes:","If you want notification sent to users whenever a business process record is created or modified, use this option to specify the format in which you want the notification to be sent.","If you have checked the Save Record Information to Document Manager check box, use this option to specify the format in which the business process records should be saved.","Cash Flow: Default Template","This option only appears in CBS code-based Base Commit business processes. It lets you enable the auto-creation of a commitment-level cash flow curve at runtime for the business process record. The curve is based on the selected commitment-level cash flow template and is created when the record is complete.","Click Add and choose a template.","For more information, see Setting Up Auto-Creation of Cash Flow Curves from Contracts.","Basic Non-workflow Set Up in the General Tab","74411.htm");
Page[237]=new Array("The following is a list of conditions applicable to Oracle Analytics Server Custom Print.","Only published Oracle Analytics Server Custom print templates can be selected while setting up the Business Process; however, if you make any changes to the Published template and do not re-publish it to the Oracle Analytics Server, the selected template will continue to remain in the Business Process (BP) setup option.","If the BP setup has been done in a Project/Shell template, the setup will get pushed when you update the setup information onto instances of Projects/Shells.","If you delete the Oracle Analytics Server Custom Print template selected in the BP Setup window, the system removes the deleted Oracle Analytics Server Custom Print template from the BP setup.","If the system does not generate the print output, for example due to server issues, the email attachment, which contains the record information, generates an error message.","Custom Print template included in the BP setup can be exported in the Configuration Package. By virtue of tagged BP design, the corresponding BP Setup from the tagged Shell template will also be included. If the Custom Print Template is not tagged, the Configuration Package export will result in an error.","Note: If the Oracle Analytics Server Custom Print output could not be generated because of connection issues to the Oracle Analytics Server or inconsistencies in between Custom Print on Unifier and the Oracle Analytics Server, the notification emails for Business Process modification will have an &quot;error.html&quot; document (as an attachment) instead of a record information document. In such a case, if the record information is Published to the Document Manager, a 0 KB document will be published.","Selecting Oracle Analytics Server Custom Print (Format / Custom)","10283694.htm");
Page[238]=new Array("For a non-workflow business process, enter the following information in the Settings tab of the Business Process Setup window to add users and groups who can create or edit business processes, or both:","In this field:","Do this:","Creator(s)","Click Select to choose the creators of the BP, that is, those users who may create a BP record from this setup. The system validates whether each selected user's company exists. If not, the system adds the Partner Company as a Member Company.","Editor(s)","Optionally, click Select to choose users or groups who can edit the business process without being granted explicit record-level permission. This allows users other than the assignee to edit the business process record. The Editors field can include users and groups that are also entered under Creator(s).","The Editors can be added on these BP types:","Line Item","Cost (all types, including Lease and Line Item with Multiple Codes)","Document","Simple","RFB","Text","Users or groups that you add as Editors can open and edit any record that they can see listed in the business process log, per their view access permission. Access permissions are View User Records, View Company Records, or View All Records. The user who is designated as an Editor must have at least one of these permissions to be able to view the record in the log to access it to edit.","Notes:","When you set up view permissions for non-workflow BPs, by design, the &quot;View Company Records&quot; option is not permitted. ","To assign proper view permission for non-workflow BPs, you (Admin) must assign the view permission on each non-workflow BP, individually.","When you change settings, the Save button is enabled. After you click Save, a spinning wheel appears while your changes are saved and then the Save button is dimmed.","Allow Quick Calendar Entry","Click Select and choose the users or groups who will be allowed to use the quick entry feature to reserve the object of this business process, or to edit or delete it from the calendar.","Note: This option will appear only on those business processes that have been calendar-enabled by design.","Set Up Creators and Editors of Non-Workflow Business Processes","10318097.htm");
Page[239]=new Array("As an Administrator, for non-workflow BPs, you can set up different view forms so that details that are relevant to users are seen.","Note: Up until now, a non-workflow business process had only one form (Action form) that held all the data.","Assigning view forms to non-workflow BPs enables administrators to control the visibility of certain data to various users or groups.","You can create view forms for all:","Non-workflow BPs regardless of the type.","Non-workflow BPs existing at both Project and Company Level.","Non-workflow BPs of both Single Record and Multiple records.","Furthermore, the validations applicable to all:","Non-workflow BPs that only have one Action form.","Non-workflow BPs that have multiple view forms.","To add, remove, or edit view reports, open the non-workflow BP and follow the instructions in Set up View Forms for Workflow Business Processes.","If users have access to a deployed view form and that view form is deleted in uDesigner, at runtime, after a user opens the BP record, the system checks that user's permission to any of the BP view forms that exist in the setup. If the user does not have access to any of the BP view forms that exist in the setup, the system displays the Action form for that BP in view-only mode.","Important information about deleting View Forms","As indicated in the Unifier uDesigner User Guide, you can design a BP form (in the Staging environment), add view forms associated with a BP form design to the Business Process Setup (View Forms tab), assign permissions to users and groups for the individual view forms, and deploy the view forms so they can be accessed through the record preview in the log (Logs and Company Logs) for viewing record details.","Due to the system limitations, an anomaly occurs when you delete a view form from the Business Process Setup. The following explains this anomaly:","You have created and deployed the following view forms for a BP form ABC:","VF01","VF02","VF03","You decide to delete one of the view forms. As a result, you navigate to uDesigner, delete the view form (for example, VF01), and ensure that the deleted view form has been remove from the Business Process Setup.","You decide to add a new view form (for example, VF04), for the BP form ABC, so you proceed to add the new view form in uDesigner and deploy the new view form, VF04.","At this point, due to the system limitations, the system will automatically add the newly created view from, VF04, to the Business Process Setup using the users and groups assignments originally assigned to the deleted view form, VF01. Furthermore, the availability of this added new view form (in the Business Process Setup) goes against the method that is used to deploy a new view form.","As an administrator, you must ensure that in such scenario, you open the newly created view form and assign appropriate permissions. ","Additional information about View Forms for Non-Workflow Business Processes","If a view form that users have access to gets deleted, at runtime (when a user opens the Non-Workflow BP record), the system checks to see whether the user has permission to any of the view forms that exist in the BP Setup. If the user does not have access to any of the other view forms, the system displays the default form, the Action form, in view mode.","Set up View Forms for Non-Workflow Business Processes","10293630.htm");
Page[240]=new Array("In both non-workflow BPs and workflow BPs (at the company and project/shell levels) you (the administrator) can use the Record Properties tab to establish: ","The availability or visibility of the BP form properties tabs for users and groups.","The ability to download attachments when users and groups access the BP records in user mode.","The Record Properties tab has the following sections:","Top: For setting up restrictions (setting restriction is done through Edit Restrictions)","Left: For Upper Form and Line Item (detail forms) properties and setting up restrictions for downloading attachments from the Upper Form and Line Items (detail forms). The left section displays all the record tabs seen in both upper and detail forms. For Simple BPs and Text-type BPs, only the Upper Form Properties tab will be seen. The Upper Form or Line Item properties options hidden in uDesigner will not be displayed. ","Right: Users info (users or groups who cannot see the properties)","The Record Properties window displays a read-only view of all the users and groups who are restricted to the visibility of selected tabs, or to download of attachments for selected tabs, in Edit Restrictions window. You can use the Edit Restrictions button to apply restrictions to users and groups.","Restricting the Audit Log and Workflow Progress options below will result in the automatic update of the same options in Permissions Settings of Access Control. The same operation applies in reverse.","The Attachments in Upper Form Properties section will not be shown for the system-defined Line Item tab in the Document type BP.","The additional section Do not allow download of Attachments will show the users and groups who are restricted to download the attachments from Upper Form or Line Item tabs in the business process record, when the attachments are visible.","The first tab seen in the Do not allow download of Attachments are the Upper Form Attachments followed by the Line Item tabs names (for example, Gauges &amp; Meters or Components) which will be in the same order as seen in the Line Item Properties.","The Upper Form Attachments tab will not be shown for the Text type and Document type BPs. Additionally, the system-defined tab will not be shown for the Document type BP, under the Do not allow download of Attachments section. ","The tabs seen in the Upper Form and Detail Form properties will be based on each BP type.","The tabs shown in Upper Form and Line item Properties will be in the same order seen in the BP record at run time.","The Upper Form Properties and Line Item Form Properties which are already hidden in uDesigner will not be shown in this list.","Example: If the Linked Records tab and Linked Mail tab from the Upper Form Properties are set to be hidden in Record Properties in uDesigner, those two tabs will not be seen in the BP Setup under the Upper Form Properties. Similarly, if the user-set Attachments tab in the Upper Form Properties is hidden in Record Properties in uDesigner, then in the Record Properties in BP Setup the user will not be able to see the following tabs:","Do not allow download of Attachments","Upper Form Attachments","Upper Form Properties","Attachments","Adding tab visibility and download of attachments restrictions to users and groups","You can add restrictions to the users and groups through the Edit Restrictions option. The restricted users and groups will be seen on the right block for the property selected on the left side.","Edit Restrictions window:","When you click the Edit Restrictions option, you can select or add user and groups, and assign attribute form restrictions. The Select Users/Groups block (the left pane of the window) will be empty if there are no existing restrictions; otherwise, the block will list the existing restricted users and groups. Use the Remove option to remove the users and groups listed in this block. You can select one or more users or groups and select the Remove option to remove users or groups from the tab visibility restrictions.","In the right section of the window, you can access and hide all the following form properties:","Hide All Upper Form Properties","Attachments","Do not allow download of Attachments","Comments","Linked Records","Linked Mail","Workflow Progress","Audit Log","Reference Records","Integration Log","Hide All Line Item Properties","&lt;Line item tab1 name&gt; Attachments","Do not allow download of Attachments","&lt;Line item tab2 name&gt; Linked Records","&lt;Line item tab2 name&gt; Attachments","Do not allow download of Attachments","&lt;Line item tab2 name&gt; Linked Records","The Detail Form Attributes will be shown based on the Line Item tabs available in the selected business process. Additionally, users and groups can be restricted to download the attachments only from the business process record.","If a single user or group is selected on the left side, the selected user or group's existing restrictions will be shown.","The Cancel and Save options will remain disabled if you do not make any changes in the right block. If you select a user or group and change the restriction options, the Cancel and Save options will be enabled. The Cancel and Save options let you save or cancel the changes that you have made in the right block.","After you close the Edit Restrictions window, the restricted users and groups will be added in the Record Properties window.","You can select multiple rows in Users/Groups section, edit the restriction check boxes, and save or cancel your changes.","If multiple users or groups (on the left block) are selected, the existing restrictions will not be shown in the right block.","For Attachments, a user who has Download restrictions can view or access the attachment but cannot download or save the attachment.","Users/Groups window","When you click Add, the User/Group window opens. This picker window displays all the users and groups that are available and selected. After the users and groups are added, you can select the users or groups (from the left block) and set the hide permissions for the form attributes (in the right block).","Note: Users or groups cannot be removed from the User/Group Picker window. You can use this picker window to add users and groups to the Edit Restrictions window. You can remove any added users or groups by selecting one or more rows in the Selected Users/Groups block.","After you add restrictions in the Edit Restrictions window, the left block displays the list of all users and groups with restrictions to the form attributes. When you select a form attribute such as Audit Log or Comments, the right block displays the list of all the restricted users and groups. A user who has restricted access to selected record attributes like Audit Log, Comments, or Linked Mail viewing in the business process record will not see those tabs.","Example: User U1 has the restriction, Hide Upper Form Properties - Comments and Linked Records. At runtime, when user U1 creates a business process (BP) record or opens an existing record, the Comments tab and the Linked Records tab will not be available in the record.","Attachments","If a user is only restricted from downloading attachments, the user can however view the attachments in User mode. The Download option is removed from the Attachments tab and also in the Review window.","In this case, a restricted user who views the attachment using the Native viewer will see the attachment open in the viewer and in read-only mode.","A user who is restricted from downloading attachments of business process (BP) records will not be able to receive attachments through email notifications received for any business process (BP) records.","Line Item Attributes","You can assign restrictions to users and groups for the Detail Form properties (Attachments and Linked Records for each Line Item tab). These additional Detail Form attributes will be seen only for the business processes that have the Detail Form defined in them.","The Detail Form properties seen in the Record Properties window will vary for each business process and is based on the design.","Users and groups can be restricted to download attachments from the Line Item tab, similar to the Upper Form, as described in the Attachments section above.","Additional information","Users and Groups who have permissions to Hide Record Audit Log and Hide Task Statuses are added to the restricted users and groups viewers list in the Record Properties tab, in the business process setup.","All the record level and Line Item tab restrictions are available for all business processes (company and project/shell levels) that support standard UI.","The restrictions are applicable to all users or creators, task assignees, step editors, record editors, and CC'd users who are part of the workflow in the record.","Visibility of tabs will be applicable to both Action and View Forms when the user has tab restrictions to the BP.","For non-workflow BPs, the Workflow Progress (under the Upper Form Properties) will not be available in the Record Properties tab, both at the design and at the setup level. ","For Company-level BPs, Linked Mail will not be available in the Form Properties.","For Simple and Text-type BPs, the option to hide the Detail Form properties will not be available.","For Document-type BPs, Attachments will not be seen in the Upper Form Properties and the system defined tab in Line Item Properties.","Note: The additional restrictions do not apply to bid users. Bidders will be able to see all the attributes even though the requestor has restricted access.","When certain form properties are hidden for a business process, those form properties are not shown in the Record Properties tab of the BP Setup.","If users or groups do not have the View permission, the BP record tabs will not be displayed at runtime. This applies to both company-sponsored and partner users.","Projects/shells do not show Rich Text type DEs in the following scenarios:","When creating conditions for auto-creation elements in a BP setup.","When editing Gate settings and setting up Gate Condition Elements.","Assigning restrictions to users and groups will impact their ability to see the Record Properties tab (tabs in the right pane, when the user opens a record) of the following nodes:","Logs","Drafts","Tasks","Master Log","Company Log","Single-Record BP Log","Portal BP Log","Set up Record Properties for Non-Workflow Business Processes","10293830.htm");
Page[241]=new Array("To set up permissions for the Record Properties tab: ","Go to the Company Workspace tab and switch to Admin mode.","In the left Navigator, select Company Sponsored Shells, select the [shell type], and open the [shell name].","In the left Navigator, select Setup, select Business Process, and select the [BP name].","Open the BP (Workflow or Non-Workflow).","Click the Records Properties tab.","Set up Permissions for Record Properties Tab (Non-Workflow)","10293832.htm");
Page[242]=new Array("Use the Notification tab in the Business Process Setup window to set up automatic email notifications to users and groups whenever a non-workflow business process is created or modified, either manually, or via auto-creation, reverse auto-population, CSV, or integration.","Note: If the business process has been designed to allow users to include additional users or groups in the email, the email notification will be sent to them as well.","Use the information in the table below to complete the Notification tab.","Click Apply to save your changes and OK to exit.","In this field:","Do this:","Send notifications to","Click Select and choose those users or groups that should be notified whenever a non-workflow business process is created or modified.","Notify creator on record modification","By default, this check box is checked. If you do not want the BP creator to be notified when the business process is modified, deselect this check box.","Notification triggering events","The fields you select here will tell the system when to notify the users or groups.","Create Record","Select this check box if notification should go out whenever a record is created.","Edit Upper Form","Select this check box if notification should go out whenever the upper form of a record is edited.","Add/Edit/Delete Line Items","Select this check box if notification should go out whenever a line item is added to the record, edited, or deleted from the record.","Add General Comment","Select this check box if notification should go out whenever comments are added to a record.","Add/Remove Attachments","Select this check box if notification should go out whenever attachments are added to or removed from a record.","Attachments","The fields you select here will tell the system how to add attachments to the record.","Include both record and line item attachments","Select this check box if the notification should include both the record and the line item attachments.","Include record information as attachment","Select this check box if the notification should include the record information as an attachment.","Override default format","If you have specified a default record format on the General tab, you can use this check box to override the default format. For example, you can use the General tab to specify that the default record format for both email notifications and records saved in the Document Manager be in PDF format. If necessary, you could then use the Override default format check box to override the format and choose Custom for the notification only.","Format PDF/Custom","Select the form.","The attachments are PDF or a custom format.","Oracle Analytics Server Custom Prints are available to be selected for the Notification format.","For custom format, select the print format defined for the business process.","Note: The system sends emails for reverse auto-population failures. There may be cases when email notifications are not sent. For such cases, you can find the reasons for the reverse auto-population (RAP) failures in the audit log of the business process record. In addition, on occasion the system generates error codes for reverse auto population failures which can be used to troubleshoot the reverse auto population failures.","Set up email notification for a non-workflow BP","74412.htm");
Page[243]=new Array("On the Auto-Creation tab, you can set up the auto-creation of another record or line item for the business process you are setting up. You can also set up the auto-creation for other business processes that will be spawned by this business process.","For information about auto-creating business processes, see Auto-creating a Business Process record or Planning Item Based on conditions or frequency.","The data elements of type rich text are not available to create conditions for auto-creation elements in a BP Setup.","To access the setup for the Company Workspace:","Go to the Company Workspace tab and switch to Admin mode.","In the left Navigator, select Company Workspace, select Business Process Setup, and then open the applicable BP.","To access the setup for a project/shell:","Go to the shell tab and switch to Admin mode.","In the left Navigator, select Setup, select Business Process, and then open the applicable BP.","When a line item is auto-created (by using the line item auto-creation logic), the values in the fields on the line item that are based on a data picker in that line item will not be auto-populated.","To set up auto-creation of a non-workflow business process or planning item:","Click the Auto Creation tab.","Under Settings for auto creation of [name of the business process, planning item, or line item you are setting up], in the Creator field, click the Select button and choose the name of the auto-creator.","Under the section Settings for auto-creation of other business process records or line items, select the BP creator element under the upper or detail form. The Auto creation of line identifies the business process or the line item that the creator element you selected will create. ","(Not an option for line item creation.) In the Assignee/Creator field, click the Select button and choose the name of the user or group who should assume ownership of the auto-created record.","The system validates whether the selected user's company exists. If not, the system adds the Partner Company as a Member Company.","Ignore the Duration field.","To create the conditions that will trigger the auto-creation, select the Enable condition based auto creation check box and continue as follows:","Note: If you leave this check box un-checked, the BP, planning item, or line item will be available for manual creation only.","To add a trigger condition, click the Add button. The Add Condition window opens.","On the General tab, enter a name for the trigger and a description.","Click the Query tab.","The Query tab is where you will define the conditions the data must meet before the system will auto-create the new business process record or line item. ","In the upper section of the window, you can specify that a field on the business process form:","Must meet a certain criteria or value","Must meet a certain value based on a formula using the numeric fields on the form","Click the Add button to specify a condition for a field on the business process form. Click the Add Formula button to create a formula that the value of the field must meet. Use the information in the Queries section of the Unifier General Administration Guide to complete the query.","Select the match ANY condition (instead of ALL) check box if the query can match any single condition to extract the information. If the query must match ALL conditions, leave this check box unmarked.","In the lower section of the window, you can specify a date condition that will trigger the auto-creation. Use the information in the Queries section of the Unifier General Administration Guide.","Date condition triggers are not available for line item auto-creation.","About Date Triggers:","If you want to create a continual date trigger condition, make sure you use the Date Trigger Condition section of the window to create it. Although you can also create a date trigger using a formula in the upper section of the window, the system will process the triggers differently.","The conditions you specify in the upper section of the window will be processed only once, when the user clicks the Finish Editing button on the form. However, the date conditions you specify in the DateTrigger Condition section will be processed daily.","This behavior is important to consider when you are creating a date condition that occurs in the future. A date trigger specified under the Date Trigger Condition section will be processed daily, and will, therefore, &quot;catch&quot; the trigger condition when the future date occurs.","Click OK.","If you want the auto-created record or line item to include attachments from the original (source) record, select the Include Attachments check box.","Note: This step is not applicable for Document type business processes.","If you select this option:","Any record-level attachments made to the source record will appear at the record level of the destination record.","Any attachments made to the line items of the source record will appear at the line item level of the destination record.","(Not an option for line item creation.) If you want to bypass the I step that this auto-creation normally creates, select the Bypass initiation step during auto creation check box.","If you select this option, the auto-created BP or planning item will skip the initiation step and will appear in the user's Tasks Log and BP Log or Planning Item Log with the status that was specified on the General tab of the business process setup window. For more information, see Auto-creating a Business Process record or Planning Item Based on conditions or frequency.","If you want to copy any records that are linked to the original record, select the Copy Linked Records check box.","(Not an option for line item creation.) If you are creating a record from a detail form, you can group line items into a single record. To do so, select the Enable grouping of line items when autocreating records from line item tabs check box.","In the Group By field, click Select and select the data element (or elements) you want to group by. If the values in these data elements match for any of the line items, the system will auto-create a single record for them. For more information, see Grouping line items into single records.","Note: If you leave the Group By field blank, the system will auto-create a single record containing all the line items on the source record.","Click Apply to save your changes, or OK to save and exit the window.","You can find the reasons for the auto-creation failures in the audit log of the business process record. In addition, on occasion the system generates error codes for auto-creation failures which can be used to troubleshoot the auto-creation failures.","Set up auto-creation for a non-workflow BP or planning item","74413.htm");
Page[244]=new Array("Use this feature to set up copy options for users when they copy a record with line items and references.","The options you specify here will give the user the ability to copy specific (rather than all) line items, as well as the ability to include attachments and linked records, and retain or remove references to auto-created records.","To set up these options, you must create a condition the data element must meet for the line item to be included for these copy options.","For example, you could create a set of options specifying that all line items with a status of &quot;open&quot; be copied and their attachments be included in the copy. Using this example, you could set up a weekly meeting minutes business process that automatically generates action item business processes for each task that arises from the meeting. Using these copy options, you could roll over action items that are still open to the next week's meeting minutes.","At runtime, the options you set up here will be given to users to choose from when they copy records. The following shows a list of BPs where the Record Copy option is supported:","Type","Sub-type","Classification","Cost","Line item with WBS Code","Generic","Transfer","Base Commit","Change Commit","General Spends","&nbsp;","&nbsp;","Line Item with Multiple Codes","Generic","Transfer","Base Commit","Change Commit","General Spends","&nbsp;","&nbsp;","&nbsp;","Line Item","Generic","Transfer","Line Items to filter company Business Process records","To set up copy options:","Open the business process for which you want to set up the copy options.","Click the Record Copy tab. The Record Copy Setup window opens.","Click the Add button. The Copy Condition Setup window opens.","In the Name field, enter a name for this copy setup. The name should be unique, and can be up to 250 characters long.","This is the name that will appear on the list of copy options the user will see when they copy a record or line item.","(Optional) In the Description field, enter a description of what this setup does.","Note: For clarity, include a precise description of what the copy options are for the setup. This description will appear on the list of copy options the user will see when they copy the record, and a good description will tell them exactly what will be copied. You can enter up to 4000 characters.","Under the Condition area of the window, click the Add button. The Query Condition window opens.","In the Data Element field, select the of the field on the line item form that you want to use to identify which lines items can be copied.","In the Condition field, select the operator that the system should use to test the data element you selected.","A condition is a state or restriction the value in the data element (field) must meet. A condition of the value might be that it must be equal to a certain number (maybe 10) or that it must contain a certain string of letters (such as &quot;due date of&quot;).","If the data element meets the condition you specify, the system will include this line item on the list the user can choose from. Use the information in the Queries section to complete the query.","Click OK.","On the Copy Condition Setup window, specify these additional copy options as shown in the table below.","Click OK.","Select this check box:","To:","Include Attachments","Include attachments in the copy operation.","Copy Linked Records","Include any linked records in the copy operation.","Retain reference to auto-created business process records on record upper form","Keep the references to business processes that were auto-created from the upper form.","Retain reference to auto-created business process records on line items across all tabs","Keep the references to business processes that were auto-created from the line item (detail) form. This applies to all line items from all tabs.","Set up record and line item copy options","74414.htm");
Page[245]=new Array("Single-record business processes (BPs) store information that you use repeatedly in your projects. Think of them as file cabinets where you keep things like industry standards; federal, state, and local regulations and statutes; policies; and FAQs. You can have multiple single-record BPs in a project, each with its own information focus. From these single records you can auto-populate fields in BPs, including constant values.","To facilitate single-sourcing of your data, create the single-record BP in the project/shell template prior to creating your project from the template. When you clone a project/shell template, you have the option to select BP Setup, which not only copies all BP setups, but all single-record BP records and their data.","Data copied from single-record BPs includes:","Attachments to records and line items, if applicable","All data pickers (Business Process, Configurable Managers, Shell Manager, User Attributes)","Any other pickers except business process pickers","Linked elements","Permissions associated with the single-record BP","Copying a single-record BP does not include:","Business process pickers","Linked records","Linked mail","General comments","You can also use CSV or web services to clone a project/shell template that contains the single-record BP.","These BPs are excluded from the Logs list in the left Navigator for the applicable project/shell; however, they are included in the General section listed under Information in the left Navigator. You can also update the User Mode Navigator to list them under the Home workspace in the Location bar. For more information, see Configuring the User Mode Navigator in the Unifier General Administration Guide.","To create a single-record BP:","Before you begin:","Ensure that you have Setup permission for the BP. For more information, see Edit User or Group Permissions Using Access Control in the Unifier General Administration Guide.","Follow the directions to set up a non-workflow BP. For more information, see Basic Non-workflow Set Up in the General Tab and Set Up Creators and Editors of Non-Workflow Business Processes.","Go to the Company Workspace tab and switch to Admin mode.","In the left Navigator, select Templates, select Shells, select the [shell type], and open the [shell template] in which the single-record BP resides.","In the left Navigator, select Information, and then select General.","On the right pane, open the single-record BP record and complete all required fields.","Click Save or Submit, as appropriate. Both actions save the record, but Save leaves the record in Edit mode, and Submit leaves the record in a read-only state.","Notes:","When you create a non-workflow BP record, you can only select a Status that is Active.","If you click Submit and the record is in a terminal status, you will not be able to edit that record again.","Assign record permissions as appropriate.","When you change settings in the Permissions window, the Save button is enabled. After you click Save, a spinning wheel appears while your changes are saved and then the Save button is dimmed.","Single-Record Business Processes","74415.htm");
Page[246]=new Array("Use this procedure to set up a workflow business processes at the company-level or at the project/shell-level. ","Prerequisite: Ensure you have added the business process to the log.","Procedure","To set up workflow business process: ","Go to the shell tab, or go to the Company Workspace tab for a company-level business process.","Switch to Admin mode."," In the left Navigator: ","For project/shell, select Setup, and then select Business Process. ","For company-level business process, select Business Process Setup.","In the Business Processes log in the right pane, select a BP, and click Open.","In the BP Name Setup log  in the right pane, select the business process (BP) and click Open. ","In the Business Process Setup window of the selected business process (BP), enter information in the following tabs and click OK: ","General tab","Settings tab","Set up View Forms for Workflow Business Processes","Record Properties tab","Notification tab","Auto Creation tab","Proceed to complete Workflow Setup in Company-Level BPs or Project-Level BPs.","Note: To configure a setup for multiple workflows, repeat this procedure for each workflow available for the business process.","Select any of the following options:","Click Yes to activate the BP and make it available to users. ","Click No to keep the BP inactive until a later date.","Important information","After a workflow record is created by using any workflow schema (unique combination of Setup Name + Workflow Name), the workflow record continues to reference the workflow schema even if the Status of the workflow schema has been set to Inactive. ","This condition includes workflow records that are in the following statuses:","Draft","Initiation Step (I-Step)","Also, this condition includes any workflow record at any other step in the workflow.","If there is an Active BP Template, the Template continues to create records referencing the Inactive workflow schema. For instructions on creating a template, see Creating BP Templates and Scheduling BP Creation in the Unifier Business Processes User Guide. ","Setting Up Workflow Business Processes","74416.htm");
Page[247]=new Array(" The business process &lt;BP Name&gt; node lets you set up specific information about that BP.","When you click the business process &lt;BP Name&gt; node (listed under the Business Process functional node), the &lt;BP Name&gt; Setup log opens. When you open the BP listed in the log, the Business Process Setup window opens showing the following tabs, which let you set specific information about that BP:","General Tab","To see the BP name and description. You can use this tab to:","Add or remove a help file for that BP","Select who to send the error notifications to","Settings Tab","To select the record editors from the User/Group Picker.","View Forms Tab","You can add View Forms to the BP setup (Add, and then select Select View Forms) and assign permissions (Permission Settings) to the users and groups (Viewers, and then select User/Group Picker) for each individual view form. This lets you set up and use a different view from the one that is assigned to the workflow step.","The users and groups will use the View Forms to preview a record and its details in the BP log.","A user or group having permissions to multiple View Forms:","Will see the View Forms based on the sequence that is seen in the Forms list","Can apply the View Forms settings for when the Task Assignees and CC'd users view records","If you select the Also apply View Form Settings when Task Assignees and CC'd users view records option in this tab, the system will override the view form of the workflow step design with the view form that the user has access to, through this setup.","Record Properties Tab","To set up restrictions for Form Tabs and Attachments.","You can restrict the ability of a user or group to view certain record tabs or download record attachments. Groups restrictions will override Users restrictions.","Restricting the Workflow Progress and Audit Log options (under the Upper Form Properties) will result in the automatic update of the same options in the Permissions Settings (or Access Control). The same operation applies in reverse.","Click the Edit Restrictions option to open the Edit Restrictions window for the BP. Use this window to select users or groups and determine restrictions for the following elements within the BP. You can also use this window to remove the users or groups and their restrictions.","Hide All Upper Form Properties","Attachments","Do not allow download of Attachments","Comments","Linked Records","Linked Mail","Workflow Progress","Audit Log","Reference Records","Integration Log","Notification Tab","To set up the details for the following elements:","Send Notifications to:","Notify Creator on Record Modification","Notify Assignee on Record Modification","Notify Cc on Record Modification","Notification Triggering Events:","Record Modification","Edit Upper Form","Add General Comments","Add/Remove Attachments ","Attachments:","Include both record and line item attachments","Include record information as attachment","Custom Notifications:","Personal Tasks","Decline Tasks","Overdue Personal Tasks","Messages","Record Workflow Complete","Record Modification","Auto Creation Tab","Use this tab to:","Set up the auto creation specifications for the BP. You can determine the action (Setup), select users or groups (Creator), and set up the specific action that the system must take (Action).","Set up auto creation of other Business Process records or line items.","The preceding and following topics provide more information about the tabs and the fields within each tab.","Business Process Node","10301255.htm");
Page[248]=new Array("For a workflow business process, enter the following information in the General tab of the Business Process Setup window:","In this field:","Do this:","Setup Name","Enter a unique name (required field).","Description","Enter an optional description of the setup.","Help File","Lets you add a custom PDF help file.","Auto Creation Workflow","The workflow to use for the auto-created BP. Workflow Setup in Company-Level BPs or Project-Level BPs.","Auto Creator","Select the name to use as the creator of any auto-created records of this BP.","Auto Action","Select the step to use as the first step in the workflow of auto-created records.","Send error notification to","Specify the user to receive error notifications.","Default Record format for Notification and Document Manager","This option has two purposes:","If you want notification sent to users whenever a business process record is created or modified, use this option to specify the format in which you want the notification to be sent.","If you have checked the Save Record Information to Document Manager check box, use this option to specify the format in which the business process records should be saved.","Basic workflow setup in General tab","74417.htm");

Page[249]=new Array("Normally, the editors of any record must be an assignee on the step of the workflow. However, there are times when a record may need editing by someone other than the step assignees. For example, the owner of a purchase order record should be able to attach revised documents to the PO at the end step of the workflow. Or an engineer who has sent a task to an architect realizes that some drawings are missing from the record. The engineer should be able to attach the documents to the record, even though the task assignee is now the architect.","The Settings tab is where you can designate non-assignee editors for business process records. (These editors must have permission to at least view the record.) Editors designated on this tab can open records and modify the upper or line item content of the record. Changes made by these editors are recorded in the audit log. Whereas step assignees will see the form that is attached to a step, the record editors you designate on this tab will see a specific form for editing. This form must be specified when the business process is created.","Note: The editors you specify on this tab are record-level editors. You can designate additional editors at the step level when you set up the workflow. See Define the Business Process Workflow.","To designate additional editors for records:","Click the Settings tab.","In the Record Editor(s) field, click the Select button and choose the users or groups who should have editing privileges on this record.","Click Apply to save these settings.","Designate additional editors for Business Process records","74418.htm");
Page[250]=new Array("A view form is the read-only version of a business process form that appears when the recipient first opens the form. The system uses the view form to show a preview of the record in the log. The view form enables the user to view record details. The fields in a view form cannot be edited. A view form may also be used when the designer does not want the user to be able to change the data on the form.","Note: Business process forms can only be printed from a view form.","As an Administrator, you can set up different view forms such that details that are relevant to users are seen. You can set user-permissions so users can view the entire form, a portion of the form, or a limited set of data on the form, for record preview in the log as well as for viewing record details.","When you set up a workflow business process (all levels and record instances), you can use the View Forms tab of the Business Process Setup window to set up different view forms such that details that are relevant to users are seen.","To access the View Forms tab:","Go to the shell tab and switch to Admin mode.","In the left Navigator, select Setup, and then select Business Process.","Open the business process that you want to set up different view forms for.","Select an item under the Setup Name column and open it.","Click the View Forms tab to open it.","Use the steps above to remove, move up, or move down existing view forms.","From the View Forms tab:","You can add view forms to a BP setup.","Assign settings to users and groups for individual view forms.","Apply your settings to task assignees and copied (cc'd) users who view the record.","If ask assignees and copied (cc'd) users have restricted access to only one of the view forms listed in the window, that view form will be displayed at runtime.","If ask assignees and copied (cc'd) users have access to none of the view forms listed in the window, the step form will be displayed at runtime.","For copied (cc'd) users the restricted view form will be seen both from Notifications and Logs.","Note: If the users or groups have permission to view multiple view forms, they will see the view forms based on the sequence listed in this window.","To add a view form:","In the View Forms tab, click Add to open the Select View Forms window.","Under the View Forms column, a list of view forms from the BP design is displayed. Select as many forms as you need and click OK to add the view forms.","After the form has been added, the right section will display the Permission Settings block. The Permission Settings block contains the Viewers field. Use the Select option to see the users or groups picker (Users/Groups) and add. The list of users and groups seen here will be the same as the ones seen when assignees are being set up in the workflow setup.","An administrator can select the view forms that need to be set up for a given project/shell. The design for a BP can have multiple view forms, but for a select project template, or shell template, the administrator can set up only one view form.","If users have access to a deployed view form and that view form is deleted in uDesigner, at runtime, after a user opens the BP record, the system checks that user's permission to any of the BP view forms that exist in the setup. If the user does not have access to any of the BP view forms that exist in the setup, the system displays the Action form for that BP in view-only mode.","Important information about deleting View Forms","As indicated in the Unifier uDesigner User Guide, you can design a BP form (in the Staging environment), add view forms associated with a BP form design to the Business Process Setup (View Forms tab), assign permissions to users and groups for the individual view forms, and deploy the view forms so they can be accessed through the record preview in the log (Logs and Company Logs) for viewing record details.","Due to the system limitations, an anomaly occurs when you delete a view form from the Business Process Setup. The following explains this anomaly:","You have created and deployed the following view forms for a BP form ABC:","VF01","VF02","VF03","You decide to delete one of the view forms. As a result, you navigate to uDesigner, delete the view form (for example, VF01), and ensure that the deleted view form has been remove from the Business Process Setup.","You decide to add a new view form (for example, VF04), for the BP form ABC, so you proceed to add the new view form in uDesigner and deploy the new view form, VF04.","At this point, due to the system limitations, the system will automatically add the newly created view from, VF04, to the Business Process Setup using the users and groups assignments originally assigned to the deleted view form, VF01. Furthermore, the availability of this added new view form (in the Business Process Setup) goes against the method that is used to deploy a new view form.","As an administrator, you must ensure that in such scenario, you open the newly created view form and assign appropriate permissions. ","Set up View Forms for Workflow Business Processes","10293624.htm");
Page[251]=new Array("In both Non-Workflow BPs and Workflow BPs (at the company and project/shell levels) you (the administrator) can use the Record Properties tab to establish: ","The availability or visibility of the BP form properties tabs for users and groups.","The ability to download attachments when users and groups access the BP records in user mode.","The Record Properties tab has the following sections:","Top: For setting up restrictions (setting restriction is done through Edit Restrictions)","Left: For Upper Form and Line Item (detail forms) properties and setting up restrictions for downloading attachments from the Upper Form and Line Items (detail forms). The left section displays all the record tabs seen in both upper and detail forms. For Simple-type and Text-type BPs, only the Upper form properties tab will be seen. The Upper Form or Line Item properties options that were hidden in uDesigner will not be displayed. ","Right: Users info (users or groups who cannot see the properties)","TheRecord Propertieswindow displays a read-only view of users and groups who are restricted from viewing or downloading attachments for selected tabs in theEdit Restrictionswindow. You can use theEdit Restrictionsbutton to apply restrictions to users and groups.","Restricting the Audit Log and Workflow Progress options below will result in the automatic update of the same options in Permissions Settings of Access Control. The same operation applies in reverse.","The Attachments in Upper Form Properties section will not be shown for the system-defined Line Item tab in the Document type BP.","The additional section Do not allow download of Attachments will show the users and groups who are restricted from downloading the attachments from Upper Form or Line Item tabs in the business process record, when the attachments are visible.","The first tab seen in theDo not allow download of Attachmentsis theUpper Form Attachmentsfollowed by theLine Itemtabs names (for example, Gauges &amp; Meters or Components) which will be in the same order as seen in theLine Item Properties.","The Upper Form Attachments tab will not be shown for the Text type and Document type BPs. Additionally, the system-defined tab will not be shown for the Document type BP, under the Do not allow download of Attachments section. ","The tabs seen in the Upper Form and Detail Form properties will be based on each BP type.","The tabs shown in Upper Form and Line item Properties will be in the same order as seen in the BP record at runtime.","The Upper Form Properties and Line Item Form Properties that are already hidden are not shown in this list.","Example: If the Linked Records tab and Linked Mail tab from the Upper Form Properties are set to be hidden in Record Properties in uDesigner, those two tabs will not be seen in the BP Setup under Upper Form Properties. Similarly, if the user-set Attachments tab in the Upper Form Properties is hidden in Record Properties in uDesigner, then in the Record Properties in BP Setup the user will not be able to see the following tabs:","Do not allow download of Attachments","Upper Form Attachments","Upper Form Properties","Attachments","Adding tab visibility and download of attachments restrictions to users and groups","You can add restrictions to the users and groups through the Edit Restrictions option. The restricted users and groups will be seen on the right block for the property selected on the left side.","Edit Restrictions window:","When you click the Edit Restrictions option, you can select or add user and groups, and assign attribute form restrictions. The Select Users/Groups block (the left pane of the window) will be empty if there are no existing restrictions; otherwise, the block will list the existing restricted users and groups. Use the Remove option to remove the users and groups listed in this block. You can select one or more users or groups and select the Remove option to remove users or groups from the tab visibility restrictions.","In the right section of the window, you can access and hide all the following form properties:","Hide All Upper Form Properties","Attachments","Do not allow download of Attachments","Comments","Linked Records","Linked Mail","Workflow Progress","Audit Log","Reference Records","Integration Log","Hide All Line Item Properties","&lt;Line item tab1 name&gt; Attachments","Do not allow download of Attachments","&lt;Line item tab2 name&gt; Linked Records","&lt;Line item tab2 name&gt; Attachments","Do not allow download of Attachments","&lt;Line item tab2 name&gt; Linked Records","The Detail Form Attributes will be shown based on the Line Item tabs available in the selected business process. Additionally, users and groups can be restricted to download the attachments only from the business process record.","If a single user or group is selected in the left block, the selected user or group's existing restrictions will be shown.","The Cancel and Save options will remain disabled if you do not make any changes in the right block. If you select a user or group and change the restriction options, the Cancel and Save options will be enabled. The Cancel and Save options let you save or cancel the changes that you have made in the right block.","After you close the Edit Restrictions window, the restricted users and groups will be added in the Record Properties window.","You can select multiple rows in Users/Groups section, edit the restriction check boxes, and click Save or click Cancel your changes.","If multiple users or groups are selected in the left block, the existing restrictions will not be shown in the right block.","For Attachments, a user who has Download restrictions can view or access the attachment but cannot download or save the attachment.","Users/Groups window","When you click Add, the User/Group window opens. This picker window displays all the users and groups that are available and selected. After the users and groups are added, you can select the users or groups (from the left block) and set the hide permissions for the form attributes (in the right block).","Note: Users or groups cannot be removed from the User/Group Picker window. You can use this picker window to add users and groups to the Edit Restrictions window. You can remove any added users or groups by selecting one or more rows in the Selected Users/Groups block.","After you add restrictions in the Edit Restrictions window, the left block displays the list of all users and groups with restrictions to the form attributes. When you select a form attribute such as Audit Log or Comments, the right block displays the list of all the restricted users and groups. A user who has restricted access to selected record attributes like Audit Log, Comments, or Linked Mail viewing in the business process record will not see those tabs.","Example: User U1 has the restriction, Hide Upper Form Properties - Comments and Linked Records.  At runtime, when user U1 creates a business process record or opens an existing record, the Comments tab and the Linked Records tab will not be available in the record.","Attachments","If a user is only restricted from downloading attachments, the user can however view the attachments in the BP record in User mode. The Download option is removed from Attachments tab and the Review window.","In this case, a restricted user who views the attachment in the Native viewer will see the attachment open in read-only mode in Unifier Viewer.","A restricted user will not be able to receive the attachments through email notifications received from a business process record for which the user has restrictions to download attachments.","Line item Attributes","You can assign restrictions to users and groups for the Detail Form properties (Attachments and Linked Records for each Line Item tab). These additional Detail Form attributes will be seen only for the business processes that have the Detail Form defined in them.","The Detail Form properties seen in the Record Properties window will vary for each business process and is based on the design.","Users and groups can be restricted to download attachments from the Line Item tab, similar to the Upper Form, as described in the Attachments section above.","Additional information","Users and Groups who have permissions to Hide Record Audit Log and Hide Task Statuses are added to the restricted users and groups viewers list in the &quot;Record Properties&quot; tab, in the business process setup.","All the record level and Line Item tab restrictions are available for all business processes (company and project/shell levels) that support standard UI.","The restrictions are applicable to all users or creators, task assignees, step editors, record editors, and CC'd users who are part of the workflow in the record.","Visibility of tabs will be applicable to both Action and View Forms when the user has tab restrictions to the BP.","For non-workflow BPs, Workflow Progress (under the Upper Form properties) will not be available in the Record Properties tab both at the design and at the setup level.","For Company-level BPs, Linked Mail will not be available in the Form Properties.","For Simple and Text-type BPs, the option to hide the Detail Form properties will not be available.","For Document-type BPs, Attachments will not be seen in the Upper Form Properties and system defined tab in the Line Item Properties.","Note: The additional restrictions do not apply to bid users. Bidders will be able to see all the attributes even though the requestor has restricted access.","When certain form properties are hidden for a business process, those form properties are not shown in the Record Properties tab in the BP setup.","If users or groups do not have View permission, the BP record tabs will not be displayed at runtime. This is applicable to both company-sponsored and partner users.","Projects/shells do not show Rich Text type DEs in the following scenarios:","When creating conditions for auto-creation elements in a BP setup.","When editing Gate settings and setting up Gate Condition Elements.","Assigning restrictions to users and groups will impact their ability to see the Record Properties tab (tabs in the right pane, when the user opens a record) of the following nodes:","Logs","Drafts","Tasks","Master Log","Company Log","Single-Record BP Log","Portal BP Log","Set up Record Properties for Workflow Business Processes","10293831.htm");
Page[252]=new Array("To set up permissions for the Record Properties tab: ","Go to the Company Workspace tab and switch to Admin mode.","In the left Navigator, select Company Sponsored Shells, select the [shell type], and open the [shell instance].","In the left Navigator, select Setup, select Business Process, and select the [BP name].","Open the BP (Workflow or Non-Workflow).","Click the Records Properties tab.","Set up Permissions for Record Properties Tab (Workflow)","10293833.htm");
Page[253]=new Array("Use the Notification tab to set up automatic email notifications to users and groups whenever a workflow business process is created or modified, either manually, or via auto-creation, reverse auto-population, CSV, or integration.","If the business process has been designed to allow users to include additional users or groups in the email, the email notification will be sent to them as well. ","The values that you must use to customize your email notification (these values appear in the drop-down fields of the Custom Notifications block in the Notifications tab) are set in the Email Content log (for more information, see Creating Custom Email Template in the Unifier General Administration Guide). You can see the existing templates, or create templates, in the Email Content log. To create a template, click Create to open the Create Template window. Enter a template name and from the right pane (Available Data Elements) select the language and the elements that you want in your new template, and click Save and Close. Your changes will appear in the Notification tab within the fields listed in the Custom Notifications block. See the following for more details.","When a notification triggering event occurs, if users or groups have been identified, the system will notify the identified users or groups through the default system notification or the customized email template (specified in the Custom Notifications block in the Notifications tab).","To set up the email notification for a workflow BP:","Note: The system sends emails for reverse auto-population failures. There may be cases when email notifications are not sent. For such cases, you can find the reasons for the reverse auto-population (RAP) failures in the audit log of the business process record. In addition, the system occasionally generates error codes for reverse auto-population failures, which can be used to troubleshoot the failures.","Go to the shell tab and switch to Admin mode.","In the left Navigator, select Setup, and then select Business Process to open the Business Processes log.","In the log, select and open the BP that you want to set up the email notification for. The Business Processes Setup window opens showing the following tabs:","General tab","Settings tab","View Forms tab","Record Properties tab","Notification tab","Auto Creation tab","Click the Notification tab.","Use the information below to complete the fields in the Notification tab. Click Apply to save your changes and OK to exit.","Send notifications to:","Click Select to select users or groups that should be notified whenever the workflow business process is created or modified.","Select one of the following options, if applicable:","Notify Creator on Record Modification: Select this option if you want the BP creator to be notified when the BP is modified.","Notify Assignee of Record Modification: Select this option if you want the step assignees to be notified when the BP is modified.","Notify Cc on Record Modification: Select this option if you want the step users or groups who have been Cc'd to be notified when the BP is modified.","Notification Triggering Events:","Based on your need, you can select all or some of the following triggering options that are listed under Record Modification:","Edit Upper Form: Select this option if you want the system to send notification when the upper form of a BP record is changed.","Add General Comments: Select this option if you want the system to send notification when a comment is added to a BP record.","Add/Remove Attachments: Select this option if you want the system to send notification when an attachment is added to, or removed from, a BP record.","Attachments:","Include both record and line item attachments: Select this option if you want the system to include both the record and the line item attachments.","Include record information as attachment: Select this option if you want the system to include the record information as an attachment.","Custom Notifications:","Personal Tasks: To select a custom email notification format for personal tasks.","Decline Tasks: To select a custom email notification format for declining tasks.","Overdue Personal Tasks: To select a custom email notification format for overdue personal tasks.","Messages: To select a custom email notification format for messages.","Record Workflow Complete: To select a custom email notification format for completed workflows.","Record Modification: To select a custom email notification format for record modifications.","Set up Email Notification for a Workflow BP","74419.htm");
Page[254]=new Array("On the Auto Creation tab, you can set up this business process to automatically create another record or line item for this business process. You can also set up this business process to automatically create other business processes, planning items, or line items if the form includes a creator element.","Note:","Because a Summary Payment Application (SPA) BP contains two sub-tabs&#8212;Line Item and Cost Breakdown&#8212;on the Detail Form, the system does not support I-Step or S-Step auto-creation of line items from a non-SPA BP to an SPA BP.","If the Completion Policy for a step is set to All-Consensus and Auto Creation is enabled, automatic creation of the applicable items begins after all assignees have agreed on the action.","For information about auto-creating business processes or planning items, see Auto-creating BP Record or Planning Item Based on Conditions or Frequency. ","The data elements of type Rich Text are not available to create conditions for auto-creation elements in a BP Setup (available by selecting BP Setup either through Company Workspace or the project/shell).","When a line item is auto-created (by using the line item auto-creation logic), the values in the fields on the line item that are based on a data picker in that line item will not be auto-populated.","Note: When the system auto-creates a project-level Cost- or Commit-type business process (BP) that contains an upper (main) form reference to a company-level commit-type BP record (such as a Blanket Purchase Order [BPO]), the value is copied to the destination record if a matching DE exists. However, if a BPO Lineitem Picker value existed in the detail form of the source record, that value is not copied over to the line items of the auto-created record.","To set up auto-creation of a workflow business process:","Click the Auto Creation tab.","Under Settings for auto creation of [name of the business process, planning item, or line item you are setting up], complete the following fields as shown in the table below (at the end of this topic).","Under the section Settings for auto-creation of other business process records or line items, select the creator element under the upper or detail form. The Auto creation of line identifies the business process or the line item that the creator element you selected will create. ","(Not an option for line item creation.) In the Assignee/Creator field, click the Select button and choose the name of the user or group who should assume ownership of the auto-created record.","The system validates whether the selected user's company exists. If not, the system adds the Partner Company as a Member Company.","(Not an option for line item creation.) In the Duration field, specify the duration of the workflow to ensure a due date is calculated and displayed for the auto-created record.","If you want the auto-created record to include attachments from the original (source) record, select the Include Attachments check box.","If you select this option:","Any record-level attachments made to the source record will appear at the record level of the destination record.","Any attachments made to the line items of the source record will appear at the line item level of the destination record.","Note: This step is not applicable for Document type business processes.","(Not an option for line item creation.) If you want to bypass the I step that this auto-creation normally creates, select the Bypass initiation step during auto creation.","If you select this option, the auto-created BP will skip the initiation step and will appear in the user's BP log at the appropriate step in the workflow. (For more information, see Auto-creating BP Record or Planning Item Based on Conditions or Frequency.)","If you want to copy any records that are linked to the original record, select the Copy Linked Records check box.","(Not an option for line item creation.) If you want to group line items into a single record, select the Enable grouping of line items when autocreating records from line item tabs check box.","In the Group By field, click Select and select the data element (or elements) you want to group by. If the values in these data elements match for any of the line items, the system will auto-create a single record for them. For more information, see Grouping line items into single records.","Copying line items is limited to a single picker or a single referenced data element.","Note: If you leave the Group By field blank, the system will auto-create a single record containing all the line items on the source record.","To create the conditions that will trigger the auto-creation, select the Enable condition based auto creation check box and continue as follows:","Note: If you leave this check box un-checked, the BP, planning item, or line item will be available for manual creation only.","To add a trigger condition, click the Add button. The Add Condition window opens.","On the General tab, enter a name for the trigger and a description.","Click the Query tab.","The Query tab is where you will define the conditions the data must meet before the system will auto-create the new business process record or line item. ","In the upper section of the window, you can specify that a field on the business process form:","Must meet a certain criteria or value","Must meet a certain value based on a formula using the numeric fields on the form","Click the Add button to specify a condition for a field on the business process form. Click the Add Formula button to create a formula that the value of the field must meet. Use the information in the Queries section to complete the query.","Select the match ANY condition (instead of ALL) check box if the query can match any single condition to extract the information. If the query must match ALL conditions, leave this check box deselected.","In the lower section of the window, you can specify a date condition that will trigger the auto-creation. Use the information in the Queries section to complete the query.","Date condition triggers are not available for line item auto-creation.","About Date Triggers:","If you want to create a continual date trigger condition, make sure you use the Date Trigger Condition section of the window to create it. Although you can also create a date trigger using a formula in the upper section of the window, the system will process the triggers differently.","The conditions you specify in the upper section of the window will be processed only once, when the user clicks the Send button on the form to send the form to the next step in the workflow. However, the date conditions you specify in the Date Trigger Condition section will be processed daily.","This behavior is important to consider when you are creating a date condition that occurs in the future. A date trigger specified under the Date Trigger Condition section will be processed daily, and will, therefore, &quot;catch&quot; the trigger condition when the future date occurs.","Click OK.","Click Apply to save your changes, or OK to save and exit the window.","In this field:","Do this:","Setup","Specify the workflow setup that the auto-created business process or planning item should use.","Creator","Click the Select button and choose the name of the person or group who should assume ownership of the auto-created record.","Action","Specify the step in the workflow that should be used as the first step in the workflow of the auto-created BP or planning item records.","You can find the reasons for the auto-creation failures in the audit log of the business process record. In addition, on occasion the system generates error codes for auto-creation failures which can be used to troubleshoot the auto-creation failures.","Set up auto-creation for a workflow BP","74420.htm");
Page[255]=new Array("This section explains how to set up workflows. Workflow setups can be time-consuming. The system offers other options of copying workflow setups. To use these options, see Copying Workflow Setups from Other Schemas.","Use any of the following methods to set up a workflow:","For a company-level business process, go to the Company Workspace tab and switch to Admin mode; in the left Navigator, select Company Workspace, and then select Business Process Setup.","For a project- or shell-level business process, go to the shell tab and switch to Admin mode; in the left Navigator, select Setup, and then select Business Process.","To set up a workflow within a template at the project/shell-level, go to the Company Workspace tab and switch to Admin mode; in the left Navigator, select Templates, select Shells, select Projects, and open the [shell instance]; in the left Navigator, select Setup, select Business Process; in the right pane, select the applicable business process.","In the left Navigator, select Workflow Setup and in the right pane, double-click on the name of the workflow you want to set up.","In the Workflow Setup window of the selected workflow, select the General tab: ","In the Setup Name field, enter a workflow business process setup name.","In the Description field, enter an optional description of the workflow setup.","In the Status field, Select Active or Inactive.","In the Error Check field, indicate whether the workflow is to be checked for errors when the workflow setup is complete.","In the Default format of record information attached to email notification field, select PDF or Custom. If you select Custom, click Add to choose the custom print format.","In the Workflow Setup window of the selected workflow, select the Settings tab to configure the workflow details. For more information, Define the Business Process Workflow.","You can filter assignees (Assignees block) and use some specific conditions on filtering the users.","To create the conditions, you must choose among the list of the user attributes that are available. After you select an assignee, from the Assignee drop-down list, for the selected workflow step, click Define (next to the Additional conditions to filter assignees option) to define the additional conditions in the pop-up window. When finished, click Add and then click the drop-down field and select:","User Attributes from the company (Company Workspace): Represented with a prefix &quot;Company/&quot;","User Attributes defined at project/shell level: Represented with a prefix &quot;Shell/&quot;","The same conditions apply to Allow Cc field.","If the BP design supports inclusion of additional task assignees or CC users, the Settings tab includes two additional options, Add additional assignees from upper form and line item tabs and Copy additional users from upper form and line item tabs, that you can enable if applicable. (The Add additional assignees from upper form and line item tabs option is not available for Creation and End steps. The Copy additional users from upper form and line item tabs option is not available for the Creation step.)","Note: When a record is routed to the next step in the workflow, the assignee list is always pulled from the subsequent step. For example, if the record gets routed from a Review step to an Update step and the additional task assignees and copied users are to appear for the Update step, the design for the Update step and the option for the Update step in the workflow setup must both be enabled.","In the Integration tab, Workflow Business Processes field, select the workflow recipe for an action in a workflow step.","Note: The Integration tab displays only if an Oracle Integration connection has been set up and enabled for your organization.","When the setup is complete, return to the General  tab and click Error Check. ","Any errors identified by the error check display in the Error window. The setup is not activated until all errors are resolved.","If there are no errors, click OK in the Setup window. You will be prompted to activate the BP. ","Select any of the following options: ","Click Yes to activate the business process (BP) and make it available to users. ","Click No to keep the business process (BP) inactive until a later date.","Workflow Setup in Company-Level BPs or Project-Level BPs","74421.htm");
Page[256]=new Array("In the Settings tab of the Workflow Setup window, you can configure the workflow details. These settings are applicable to project-level and company-level workflow business processes. The workflow step settings are arranged in a tree structure, showing all the steps. From here you can specify the following: ","Overall Workflow Settings  ","Settings for Standard Workflow Steps ","Settings for Conditional Routing Steps","Settings for Auto-Create Steps","Settings for Sub-Workflows","Alternatively, you can also Copy Workflow Setups From Other Schemas.","Define the Business Process Workflow","74422.htm");
Page[257]=new Array("The following describes the settings for the overall workflow. Select the top option in the left navigation pane to access these settings. Click the scroll bar on the right to scroll down the window and view all fields.","Enable Workflow Duration: When Yes is selected, records created with this instance will be marked as late when the defined amount of time passes.","Workflow Duration: You can optionally set the duration of the workflow.","Override Workflow Due Date: User can override the due date for the workflow. Be sure to select Yes for this option if you are using Scope Management and have selected Enforce Activity Finish Date for the Record Due Date for the activity business process. For more information, see Setting Up Scope Management for Activities.","Project Phase (Project-level BPs only): Setup is valid only during the specified project phase. This is not applicable for company-level BPs.","Notify users or groups on workflow completion: Selected users or groups will be notified after the workflow is complete.","Behavior of the Due Date (due_date) Field","In the Workflow Settings field in the Workflow Setup of a BP, if the Override Workflow Due Date field is set as Yes, you can edit the due date in the creation step. If the Override Workflow Due Date field is set as No, you cannot edit the due date in the creation step. Also, you cannot edit the Due Date if the work has started or the work has moved to the next step (is in-flight) in the workflow process.","When you create workflow BP records through file imports (CSV or Microsoft Excel), the system currently sets the Due Date automatically based on the Workflow Settings; the Due Date provided in the input file is ignored. Also, when you update workflow BP records through file imports (CSV or Microsoft Excel), the system uses the Due Date that was based on the Workflow Settings and ignores the Due Date provided in the input file.","Overall Workflow Settings","74423.htm");
Page[258]=new Array("This setup is for standard workflow steps. The Settings tab displays the steps that are available for the selected BP and therefore will vary depending upon how the BP has been designed. Not all selections discussed below will be available for all workflow steps. In addition, depending on the BP design, not all fields will be editable. The following is primarily an example of a creation step. Click the scroll bar on the right to scroll down the window and view all fields.","Select a workflow step to access these settings.","About Create and End Steps","The Create and End steps in a workflow have unique characteristics you should be aware of during the design and setup of the workflow.","For the Create step:","In uDesigner:","You can rename the Create step to something else if you want.","You can place only outgoing links on the Create step.","You can attach only action forms to the Create step.","You cannot send a link back to the Create step. If the workflow requires that a form be sent back to the creator (Create step), add a separate &quot;back step&quot; or &quot;revision step&quot; that will send the form back to the creator.","In Unifier Administration:","You cannot &quot;Cc&quot; users on the Create step.","A workflow cannot send a link back to the Create step. If the workflow requires that a form be sent back to the creator (Create step), the workflow design should include a separate &quot;back step&quot; or &quot;revision step&quot; that will send the form back to the creator. If your workflow includes such a &quot;back step,&quot; specify match step &lt;Creation&gt; for the Assignees on that step.","For the End step:","In uDesigner:","You cannot rename the End step.","You can place only incoming links on the End step","You can attach either an action form or a view form to the End step.","In Unifier Administration:","You can &quot;Cc&quot; users on the End step.","You can send the form to the editors who have been assigned to the form.","You can add comments to a business process at the End step, and also at any status in a workflow, including &quot;terminated.&quot;","In this field:","Do this:","Step Name","You can click the link to view a graphical representation of the workflow, with the current step highlighted. Be aware that workflows can often be exceptionally large. If you are viewing a large workflow, you can enlarge the canvas screen to make it easier to see all the steps to the workflow progression.","To enlarge the canvas, you can drag the window sides until the workflow fits in the window, or you can quickly maximize the canvas. To maximize the canvas, click the icon in the upper-right corner of the window. To restore the canvas window to its normal size, click the Restore icon.","Description","Enter an optional description to help identify the workflow.","Duration","Choose the time length for this step.","Override Task Due Date","Allows user to override due date for an individual task.","Allow Assignees to Decline Task","Click Yes if you want the assignees to have the ability to decline an action on an assigned task.","Enable Step for Integration","Click the radio button if you want this step to be available for integration with an external system, such as Web Services. If you make the step available for integration, the user can use the external system to view a read-only copy of the BP at that step.","Note: If you select this option, the Completion Policy field (see below) will be set to &quot;Single,&quot; and the Assignment Policy field for the following step must be set to &quot;Preassigned.&quot;","Assignment Policy","For User Select (default), the individual who creates a record (such as an invoice) from this workflow instance can choose the users to assign to this task from the list of assignees for this step. For Preassigned, every user on the assignee list is automatically assigned to the step when the record is created.","Assignees","Select the users to assign to this step. These users will receive task notifications, instructing them to act at this step. When you click the Select button, you can choose one these options:","User Picker: The system displays the User/Group Picker window. Choose one or more users or groups to add as assignees.","Dynamic: Choose a step in the workflow from the Select Step pop-up window. The assignees from that step become the assignees used on this step. You cannot choose Dynamic when adding assignees to the first step (Creation) in the workflow.","Note: The system validates whether each selected user's company exists. If not, the system adds the Partner Company as a Member Company.","You can constrain the list of assignees for this step by selecting the Additional conditions to filter assignees check box. To constrain the list of assignees, you must create a query to filter the assignees using criteria you specify. To do this, click the Define button and specify a field comparison. For information on creating this type of query, use the information in the Queries section to complete the query. If you filter the assignees, the group names will not be visible to users in the Workflow Action Details dialog. ","The filter conditions defined are used, as AND/OR, depending on the check box: Show results matching any condition (instead of All)","Allow Cc","Allows assignees to add cc users who will receive a view-only copy of the BP record. Choose one of the options:","No: Does not allow sending copies to other users.","Yes: Click Select to create the list of users or groups from whom the BP users can choose to Cc. (This option also activates the Allow Add Cc functionality.)","Preassigned: Click Select to choose the users who will be automatically cc'd. No other users can be copied.","Preassigned and Allow Add Cc: Click Select to choose the users who will be automatically cc'd. The Allow Add Cc option is set to Yes.","Note: You cannot allow Ccs on the Create step.","You can constrain the list of Cc users for this step by selecting the Additional conditions to filter Cc users check box. To constrain the list of Cc users, you must create a query to filter the Cc users using criteria you specify. To do this, click the Define button and specify a field comparison. For information on creating this type of query, use the information in the Queries section to complete the query. If you filter the Cc user list, the group names will not be visible to users in the Workflow Action Details dialog. ","The filter conditions defined are used, as AND/OR, depending on the check box: Show results matching any condition (instead of All)","Allow Add Assignees","Allows assignees to add additional assignees in addition to those defined in the Assignees field to the current step. Assignees can add the additional assignees before accepting the task. This is done by clicking the Edit menu and choosing Add Assignees to Current Step.","For example, user A has been sent a BP for review. User A wants to add user B as an assignee to the review step as well. Before clicking Accept Task, user A clicks Edit, selects Add Assignees to Current Step, and adds user B. User B is notified (depending on email preferences) of the new task. Both user A and user B can accept the task and participate in the review step of the workflow.","Note: You cannot add assignees on the Create step.","Allow Add Cc","This option has two functions:","1. When the Allow Cc field is set to Preassigned and Allow Add Cc, this option is set to Yes automatically. It enables BP users at runtime to copy additional users on a BP step that already has a preassigned cc user. This is done on the action form of the BP during the regular workflow step by selecting the Cc button. Click Select and choose the users/ or groups that can be copied.","2. This option becomes available (choose Yes or No) if Allow Cc is set to Yes. Similar to Allow Add Assignees, this option allows assignees to send a copy of the current step of the BP to additional users in addition to those defined in the Add Cc field. Assignees can add the additional cc users before accepting the task. This is done by clicking the Edit menu and choosing Copy Users to Current Step.","For example, user A has been sent a BP for review. User A wants to add user B as an assignee to the review step as well. Before clicking Accept Task, user A clicks Edit, selects Add Assignees to Current Step, and adds user B. User B is notified (depending on email preferences) of the new task. User A can accept the task and participate in the review step of the workflow. User B can review the view-only copy.","Note: You cannot add Ccs on the Create step.","Step Editors","Optionally, you can define one or more editors per each defined step in the business process workflow setup. Editors are users who can edit the business process without being granted explicit record-level permission or as assignees of the step. This allows users other than the assignee to edit the business process record. If you are an Editor on a business process step, you can open and edit any record on the step.","Editors can be added on these BP types:","Line Item","Cost (all types, including Lease and Line Item with Multiple Codes)","Document","Simple","RFB","Text","The Editor functionality has these attributes:","The user who is designated as an editor must have a minimum of View User Records to the BP log in question.","All edits are done through the BP Log.","Editors cannot edit a workflow record until the task assignee accepts the task and saves the draft.","Editors cannot be defined on the creation step of a business process.","Editors can be defined on the end step.","Editors can be defined on a workflow step only if the Completion Policy is Single. (The system will generate an error if Completion Policy is set to All Majority or Consensus.)","Editors on a task receive notification each time a draft is created.","If multiple editors and the assignee are editing the business process record draft, the data saved by the last update will overwrite all previous updates.","Edits performed on the End step of a workflow business process affect the record directly, as no draft exists.","Edits that occur on the end step are captured in the audit listing the editor who performed the edit.","Edits performed by record editors appear in the Audit log.","Note: You cannot assign editors on the Create step.","Step Revisiting","If a step is rejected and sent back for clarification or editing, this option determines to whom the BP can be sent back (which assignees will be available for selection):","Include only previous action takers: Only the assignee users who were selected when the workflow moved into that step originally are eligible to be reselected.","Include all step assignees: All assignee users are eligible to be selected.","Note: You cannot specify step revisiting on the Create step.","Completion Policy","As an administrator, you will set a completion policy on each step in a workflow. This policy determines when the step is complete and where the step proceeds from there. For more information, also see About Completion Policies, Resolving Actions, and Their Statuses.","Choose one of the following:","Single: If any assignee completes the task, no matter which action is taken, the record moves forward to the next step.","All-Majority: All assignees are required to respond. If there is no clear majority, the system uses the resolving action to determine what path through the workflow to take.","All-Consensus: All assignees are required to respond. If there is no consensus (all must agree on the action), the system uses the resolving action to determine what path through the workflow to take.","Notes:","You cannot assign a Completion Policy on the Create step.","If Completion Policy is set to All-Consensus and Auto Creation is enabled, automatic creation of the applicable items begins after all assignees have agreed on the action.","Advance workflow when next step is determined","Select this option if you want to allow the user to choose that a step be completed without all assignees having to act on it, if the result can be determined without the assignee action. This is to prevent users unnecessarily waiting to act on the record before moving it to the next step.","Note: If you select the Completion Policy as &quot;All - Majority&quot; or &quot;All - Consensus&quot;, the system enables this check box. The check box is deselected by default.","Resolving Action","This moves the step to either a following step, a previous step, or a conditional step that essentially &quot;re-addresses&quot; the task. This step must be completed before the workflow can continue. The assignees on this resolving action step can include the original task assignees and can also include new assignees.","Note: You cannot assign a resolving action on the Create step.","Overdue Policy","You can choose to send late notifications to all assignees if the step passes its duration.","Note: You cannot assign an overdue policy on the Create step.","Comments","For the Creation step, you have the option to select Do not allow creators to add hidden comments to prevent users from adding hidden comments.","For steps other than Creation, other comment-related options are available. These other options refer only to the general comments on BP forms.","Allow assignees to hide/unhide their own comments: Allows users to show or hide their own comments. The comments will remain as part of the record, and administrators and others with permissions can view the comments, which are not visible to others without the view permission.","Allow assignees to delete their own comments: Allows users with permission to delete comments that they previously added to the BP record.","Allow assignee to delete/hide/unhide all comments: Allow assignee users in the specific workflow step to hide, show, and delete their own comments and comments added by other users comments added in the previous workflow steps. It also allows users to update comments added in previous steps of the workflow.","Allow CC users to add general comments: Allows users copied on a step to add comments on the selected workflow step. Not available on the end step.","Allow CC users to add hidden comments: Allows users to hide comments that they add to a business process. This option is available only if Allow cc users to add general comments is selected.","Note: Task assignees can always add general comments without accepting the task.","Email Response: Enable response via email","By default, this check box is deselected. When enabled, if a workflow reaches the current step, the system sends an email and the user can respond to the email (in Unifier). The check box appears on all workflow steps other than the creation step. The email that the user receives includes hyperlinks to workflow actions.","When you are taking an action in a Workflow by way of email, if you include attachments, the attachments can be seen under the General Comments section of the BP record.","Notes:","- You cannot enable email response on the Create step.","- To enable the attachment of files to email responses to workflow actions, this option must be selected as well as the Add Attachments option on the Options tab in the Action Form design.","Email Attachments:","Include both record and line item attachments","Include record information as attachment","Select to specify the content and format of email attachments. You can include business process record and line item attachments, as well as business process record information. Also, you can override the attachment format set in the General tab if necessary.","Note: You cannot enable email attachments on the Create step.","Override default format","If you have specified a default record format on the General tab, you can use this check box to override the default format. For example, you can use the General tab to specify that the default record format for both email notifications and records saved in the Document Manager be in PDF format. If necessary, you could then use the Override default format check box to override the format and choose Custom for the notification only.","Note: Hidden comments on a particular step in the Workflow and permission settings applied to certain data in the UI are retained in the custom print output.","Email Content","You can add additional information that will be sent out as part of task notification.","Note: You cannot add additional information on the Create step.","Cash Flow Default Template","This option only appears in CBS code-based Base Commit business processes. It lets you enable the auto-creation of a commitment-level cash flow curve at runtime for the business process record. The curve is based on the selected commitment-level cash flow template and is created upon being sent from the step.","Click Add and choose a template.","For more information, see Setting Up Auto-Creation of Cash Flow Curves from Contracts.","Additional Information","Save Record information to Document Manager","Select this check box if the record information (including BP comments and attachments) should be automatically saved at this step in the Document Manager.","Settings for Standard Workflow Steps","74424.htm");
Page[259]=new Array("As an administrator, you will set a completion policy on each step in a workflow. This policy determines when the step is complete and where the step proceeds from there. A step can be complete under the following conditions:","Any single user can accept a task and complete it, and the record will move forward to the next step. This is called a Single completion policy.","All assignees to the task have responded to it and a majority has agreed on the action that moves the record forward to the next step. This is called an All-Majority completion policy. If there is no clear majority on the action, the system will use a resolving action to determine how the record moves forward.","All assignees to the task have responded to it and all assignees have agreed on the action that moves the record forward to the next step. This is called an All-Consensus policy. If there is no consensus on the action, the system will use a resolving action to determine how the record moves forward.","Note: If the Completion Policy field for a step is set to All-Consensus and Auto Creation is enabled, automatic creation of the applicable items begins after all assignees have agreed on the action.","A resolving action moves the step to either a following step, a previous step, or a conditional step that essentially &quot;re-addresses&quot; the task. This step must be completed before the workflow can continue. The assignees on this resolving action step can include the original task assignees and can also include new assignees.","The statuses you see on this window are internal to the system and are used only to display the status of the workflow step relative to the completion policy. These statuses are:","Not Started: The assignee has not accepted the task.","In Progress: The assignee has accepted the task.","Locked: This status is used when the step has a single completion policy and one of the assignees accepted the task. This status denotes those assignees who were also assigned to the task, but because of the single completion policy, the task was locked and these assignees no longer have access to it.","View Only: This status indicates that this user was cc'd on the task, but is not expected to act on the task.","Completed: This status is given to an assignee's action if the task was finished and needed no resolving action. At any step, a task can have only one status of &quot;Completed.&quot;","Closed: This status is given to an assignee's action if the task was finished, but triggered a resolving action. The task will either return to a previous step, move forward to a next step, or divert to a conditional step, which will resolve the condition and move the task forward in the workflow. The step the action moves to for resolution will show a status of &quot;Not Started.&quot; The number of times the task shows a &quot;Closed&quot; status indicates the number of times the step has been revisited.","About Completion Policies, Resolving Actions, and Their Statuses","74425.htm");
Page[260]=new Array("Conditional routing steps are child nodes of the steps that lead to the condition routing. Auto-routing steps are shown with a diamond in front. Set up routing conditions on these steps.","Remember that the next step in the business process workflow will be dependent upon the value entered on the BP for the data element. When you are finished setting up this conditional routing step, the Settings tab will show two steps that represent the two options for the step that follows this auto-routing step. You define both of them, but the BP will follow just one of them based on the trigger.","In this field:","Do this:","Condition Name","Name of the condition. Can be configured for each setup.","Resolving Condition","Select this check box if this routing action goes to a step that is meant to resolve the condition.","Operator","AND: All the conditions that are defined should be satisfied to satisfy a condition.","OR: At least one of the conditions should be satisfied to satisfy a condition.","Trigger Elements","Elements that are selected as part of design. Value of these elements will be resolved to route workflow. Can be one or more elements depending upon design.","Settings for Conditional Routing Steps","74426.htm");
Page[261]=new Array("Some steps include the ability to auto-create other records, depending on the status of the previous step. It is displayed as a child node from which the link is drawn out.","Notes:","For document-type BPs, the auto-creation of BP records will also copy attachments from the original record.","Because a Summary Payment Application (SPA) BP contains two sub-tabs&#8212;Line Item and Cost Breakdown&#8212;on the Detail Form, the system does not support I-Step or S-Step auto-creation of line items from a non-SPA BP to an SPA BP.","In this field:","Do this:","Auto-create records","Choose one of the following:","As per workflow design: Auto-create BPs that were configured as part of the design.","Based on user selection during execution: During execution, user will be given a list of BPs that are selected under workflow design in uDesigner. User can choose which BP record should be auto-created.","Process list: Select a list of BPs for which the system will auto-create records during execution.","Settings for Auto-Create Steps","74427.htm");
Page[262]=new Array("A sub-workflow is a mini workflow within a main workflow and is part of the uDesigner workflow design. It is a grouping of one or more steps. A sub-workflow node will be child node of the main workflow and a sibling of other steps and sub-workflow nodes. ","In this field:","Do this:","Sub-workflow Name","You can click the link to view the graphic of the sub-workflow.","Description","Capture more information about the sub-workflow.","Enable Sub-workflow duration","Similar to the main workflow. A duration can be set for the group of steps.","Overall Sub-workflow duration","Similar to the main workflow. Overall duration for the group of steps.","Override Sub-workflow due date","Similar to main workflow. User can override sub-workflow due date during execution.","Settings for Sub-Workflows","74428.htm");
Page[263]=new Array("Use the Workflow Setup node to:","Add or edit workflow setups for the selected BP","Choose a workflow design and assign a name for the workflow setup","Determine the workflow status","Select the record format to be used for Notification and Document Manager","Set the details for workflow settings such as Phases, and select users or groups who are to be notified when the workflow is complete","Note: The system validates whether each selected user's company exists. If not, the system adds the Partner Company as a Member Company.","To access the workflow setup fields:","Go to the Company Workspace tab and switch to Admin mode.","In the left Navigator, select Templates, select Shells, select Projects, and open the [shell instance].","In the left Navigator, select Setup, select Business Process, and open the applicable [BP].","In the left Navigator, select Workflow Setup.","The Workflow Setup window has the following tabs:","General tab","Use the fields in this tab to:","Setup Name: Assign a name for the workflow setup","Status: Select the status of the workflow, and click Error Check. ","Default Record format for Notification and Document Manager: Select which record format the system should use for Notification and Document Manager (you can also specify this per step as indicated in the previous section.)","Settings tab","Use the fields in this tab to set the details of the workflow and workflow steps. This tab is divided into two panes. The left pane shows the workflow and workflow steps. The right pane (Workflow Configuration) shows the properties of the workflow and workflow steps.","When you select the top node &lt;Workflow Name&gt; from the left pane, you can set the following parameters in the Workflow Configuration (the right pane):","Workflow Settings ","Enable Workflow Duration","Workflow Duration","Override Workflow Due Date","Phases ","Allowed in all phases","Allow only in phases","Additional Information","Notify users or groups on workflow completion:","Lets you select users or groups who will be notified when the workflow is complete.","Behavior of the Due Date (due_date) Field","In the Workflow Settings field in the Workflow Setup of a BP, if the Override Workflow Due Date field is set as Yes, you can edit the due date in the creation step. If the Override Workflow Due Date field is set as No, you cannot edit the due date in the creation step. Also, you cannot edit the Due Date if the work has started or the work has moved to the next step (is in-flight) in the workflow process.","When you create workflow BP records through file imports (CSV or Microsoft Excel), the system currently sets the Due Date automatically based on the Workflow Settings; the Due Date provided in the input file is ignored. Also, when you update workflow BP records through file imports (CSV or Microsoft Excel), the system uses the Due Date that was based on the Workflow Settings and ignores the Due Date provided in the input file.","As mentioned above, the Custom Notifications lets you determine whether the default notification must be sent or a customized one (determined by the email notification elements selected on the view form in the BP design).","If you select a user or group in the Send Notifications to: field (in the Notification tab) and do not select a user or group for the Notify users or groups on workflow completion field, the system will only send the email notification to the selected users (indicated in the Send Notifications to: field) if one of the following triggering events occur: Edit Upper Form, Add General Comments, or Add/Remove Attachments.","The Custom Notifications fields:","Are used only for specifying what type of email notification template to use for different email notification types","Are not related to any of the triggering events","If you want an email notification to be sent when the workflow is complete, or at the end step, configure this when you are setting up the workflow. You can determine the step-specific notifications that are to be triggered when the BP record moves from one step to the next.","When you select a sub-node &lt;Step Name&gt; from the left pane, you can set the following email notification options in the Email Notification block:","Email Response: Enable response via email","To allow the user to respond to an email. ","Email Attachments:","To allow the user to:","Include both record and line item attachments","Include record information as attachment","Override default format","Format:","To allow the user to select a print format:","PDF","Custom","Email content","To allow the user to include the email content.","Note: Within all the steps, the Additional Information block lets you select to Save Record Information to Document Manager.","Integration tab","The Integration tab displays only if Oracle Integration is enabled in the Company Workspace (Admin mode) by establishing a connection that sets the Enable Integration field to Yes. (For more connection-related information, see Enabling Oracle Integration in the Unifier General Administration Guide.) If you plan to use integrations from Oracle Integration in workflow BPs, select the specific integration name for an action in a workflow step.","Notes:","A workflow step may contain multiple actions.","Actions and steps may differ for each workflow setup.","Workflow Setup Node","10301254.htm");
Page[264]=new Array("Some workflows can encompass many steps, as well as conditional routing and sub-workflows. Most of your time as administrator can be spent setting up the workflow schemas in your company. To make setting up workflow schemas easier and faster, the system provides you the option of copying existing setups from other workflow schemas.","For example, if you have set up a large schema for an approval process that includes separate workflows for different provisos, you can copy the setup of one schema to another workflow and make incidental changes where necessary, rather than set up the entire workflow schema again.","Or, if you have a complex schema for setting up a project/shell, you can copy that schema to set up a different project/shell in your same Unifier environment.","You can copy a setup from here:","To here:","A business process in the Company Workspace","The same business process in the same Company Workspace","If any users or groups are defined in the setup, they will be copied over if they do not exist; matching will be done on the name.","A project template for a business process","Another project template for the same business process","If any users or groups are defined in the setup, they will be copied over if they do not exist; matching will be done on the name.","A business process in a project","A project template for the same business process","If any users or groups are defined in the setup, they will be copied over if they do not exist; matching will be done on the name.","A shell template for a business process","Another shell template (of any shell type) for the same business process","If any users or groups are defined in the setup, they will be copied over if they do not exist; matching will be done on the name.","A business process in a shell","A shell template (of any shell type) for the same business process","If any users or groups are defined in the setup, they will be copied over if they do not exist; matching will be done on the name.","Business Processes Must Match","In all cases, the business process name, type, sub-type, classification, studio owner, and version number must match or the copy function will fail.","About the version number","The number in the Version column of the business process log shows the uDesigner version number. This number represents the number of times the design has been changed from Draft mode to Complete.","The uDesigner module automatically increments the version number whenever a design is returned to Draft mode. When the draft is changed to Complete, it shows that number. This version of the design in uDesigner may or may not be the version that is active in Unifier.","The version number that appears on this log in Unifier shows the last deployed version that was imported. This number may not match the version number uDesigner, but it is the last active version of the design in Unifier. The version number of the BP you are copying from must match the version number of the BP you are copying into.","Copy Workflow Setups From Other Schemas","74435.htm");
Page[265]=new Array("In this copy action, you copy a setup to another setup in the same business process in the same company workspace. ","To copy a workflow setup:","Go to the Company Workspace tab and switch to Admin mode.","In the left Navigator, select Company Workspace, and then select Business Process Setup.","On the right pane, double-click the business process to open it.","In the left Navigator, select Workflow Setup, and in the right pane, select the setup you want to copy.","Click the Copy button. The Workflow Setup window opens.","On the General tab, enter a name and description for the new setup and make the status Active or Inactive as necessary.","Click Apply.","Click the Settings tab. The Settings tab opens, showing the workflow of the setup you copied.","On this tab, you can make any changes you want to the setup you copied to accommodate the new setup.","To save the new setup, click OK.","If the setup Active is active, the system performs an error check on the new setup and notifies you of any errors it encounters; otherwise, the error check will not occur until the setup is activated.","At the Company Level, Copy a Setup from Another Setup in the Same BP","74436.htm");
Page[266]=new Array("In this copy action, you copy a setup from a business process in one project/shell template to the same business process in another project/shell template.","To copy a setup from one project/shell template to another:","Go to the Company Workspace tab and switch to Admin mode.","In the left Navigator, select Templates, select Shells, select the [shell type], and open the [shell template] that contains the BP you want to copy the setup into.","In the left Navigator, select Setup, and then select Business Process.","In the right pane, double-click the name of the business process into which you want to copy the setup.","In the left Navigator, select Workflow Setup.","Click the Copy From button and choose Templates. A copy window opens, listing all the workflow templates for that BP that exist in all the projects and shells in your environment.","Select the template you want to copy and click Copy. The Workflow Setup window opens.","On the General tab, enter a name and description for the new setup and make the status Active or Inactive as necessary.","Click Apply.","Click the Settings tab. The Settings tab opens, showing the workflow of the schema you copied.","On this tab, you can make any changes you want to the setup you copied to accommodate the new setup.","To save the new setup, click OK.","The system adds the template to the workflow setup log. If the setup Active is active, the system performs an error check on the new setup and notifies you of any errors it encounters; otherwise, the error check will not occur until the setup is activated.","Copy a Setup from One Project/Shell Template to Another","74437.htm");
Page[267]=new Array("In this copy action, you copy a workflow setup from a business process in a project/shell and make it a template in the BP you copy the setup into.","To copy a setup from a project/shell to a template:","Go to the Company Workspace tab and switch to Admin mode.","In the left Navigator, select Templates, select Shells, select the [shell type], and open the [shell template] that contains the BP you want to copy into.","In the left Navigator, select Setup, and then select Business Process.","In the right pane, double-click the name of the business process into which you want to copy the setup.","In the left Navigator, select Workflow Setup. The right pane lists the workflow setups that currently exist for this business process.","Click the Copy From button and choose Project/Shell.","A copy window opens, listing all the workflow setups for that BP that exist in all the projects and shells in your environment.","Select the setup you want to copy and click Copy. The Workflow Setup window opens.","On the General tab, enter a name and description for the new setup and make the status Active or Inactive as necessary.","Click Apply.","Click the Settings tab. The Settings tab opens, showing the workflow of the setup you copied.","On this tab, you can make any changes you want to the setup you copied to accommodate the new setup.","To save the new setup, click OK.","The system makes a template of the setup you copied and adds the template to the workflow setup log. If the setup Active is active, the system performs an error check on the new schema and notifies you of any errors it encounters; otherwise, the error check will not occur until the setup is activated.","Copy a Setup from a Project/Shell to a Template","74438.htm");
Page[268]=new Array("You can set up workflow and non-workflow business processes (BPs) that use integrations from Oracle Integration.","Prerequisites","Ensure the following:","Oracle Integration is provisioned. Otherwise, complete the Initial Oracle Integration Setup task described in the Unifier General Administration Guide.","You have the relevant integration permissions to administer or use Oracle Integration in Unifier. To set these permissions, go to the Company Workspace tab and switch to Admin mode; in the left Navigator, select User Administration, and then select Access Control; in the right pane, expand Administration Mode Access, expand Integrations, and click Oracle Integration Cloud.","You have added users and groups with required permissions to create, route (for workflow BPs), or submit (for non-workflow BPs) records for business processes.","In the Business Process Setup configuration of non-workflow business processes (BPs), set up the Integration tab to be visible in the Record Properties tab. ","For non-workflow BPs, see Set up Record Properties for Non-Workflow Business Processes.","For workflow BPs, see Set up Record Properties for Workflow Business Processes.","Procedure","To set up workflow or non-workflow BPs that use integrations from Oracle Integration:","Setting Up Workflow BPs with integrations from Oracle Integration","To use integrations from Oracle Integration in workflow BPs, set up workflow BPs using any of the following methods:","Set up a shell template for workflow BPs:","Go to the Company Workspace tab and switch to Admin mode.","In the left Navigator, select Templates, select Shells, select Projects, and open the [shell instance].","In the left Navigator, select Setup, select Business Process, and open the applicable [BP].","In the left Navigator, select Workflow Setup.","In the Setup window, enter information as specified in Workflow Setup Node.","Set up company-level workflow BPs:","Go to the Company Workspace tab and switch to Admin mode.","In the left Navigator, select Company Workspace, select Business Process Setup, and open the [BP].","In the left Navigator, select Workflow Setup.","In the Setup window, enter information as specified in the Workflow Setup Node.","Set up project/shell-level workflow BPs from a project/shell tab:","Go to the shell tab and switch to Admin mode.","In the left Navigator, select Setup, select Business Process, and open the [BP].","In the left Navigator, select Workflow Setup. ","In the Setup window, enter information as specified in the Workflow Setup Node.","To use integrations from Oracle Integration in non-workflow BPs at the company or project/shell level: ","In the left Navigator, select and open a non-workflow BP at the company or project/shell level.","Select the Integration tab of the non-workflow BP. ","For a specific Status field, select the Integration Name that you have configured in step 1 for this non-workflow BP, and click OK. ","For example, select the Integration Name, Action Item, for the Update status of the non-workflow BP.","Upload the above configured integration settings of the non-workflow BP to shell templates or shells as necessary.","After the connection is established with Oracle Integration, you can temporarily disable or enable the Oracle Integration connection as needed in the Integration tab. For more information, see Disabling Oracle Integration Connection in the Unifier General Administration Guide.","Setting Up Business Processes with Oracle Integration","10315493.htm");
Page[269]=new Array("Oracle provides standard business processes.","For Cloud","If you must download, deploy, and access a local copy of the business processes help files, download the help.zip. Contact your cloud administrator for more information.","For On-Premises","If you must download, deploy, and access a local copy of the business processes help files, download the help.zip file and follow the instructions in the Unifier Installation Guide. ","You can also develop your customized business process and create your own help files.","Note: The help files must be in Adobe Acrobat PDF format.","You can add the help file to new or existing business process setups. If you add the help file after individual business process records have been created, the help file will not be available to the existing records; however, it will be available immediately from the business process log or in any new business process that is created after the help file has been added.","Note: Custom business process help files can be added to project-level or company-level BPs.","To create a custom business process help file:","Be sure that you have installed on your system Adobe Acrobat or other software application that includes a plug-in allowing the ability to create a PDF file.","In Microsoft Word or a similar software application, write the business process instructions that you want to be made available to other business process users. Save the business process help file, but do not close it.","With your business process help file still open, do one of the following to create a PDF file. This will depend on how your system is set up.","Print to PDF file: Click the File menu and choose Print. From the Printer drop-down list, select Adobe PDF as the printer, and click OK. Name the PDF file and click OK.","Save as PDF file: Click the File menu and choose Save as PDF. Name the PDF file and click OK.","The PDF file will be generated and can be viewed using Adobe Acrobat Reader.","To add a custom business process help file to a new or existing business process setup:","For a business process:","At the company level, go to the Company Workspace tab and switch to Admin mode; in the left Navigator, select Company Workspace, and then select Business Process Setup.","In a project or shell, go to the shell tab and switch to Admin mode; in the left Navigator, select Setup, and then select Business Process.","Note: Even though the help file is added to an individual setup window, it is automatically added to all setups for that business process. The help file will be available immediately to all users with access to the business process log in User mode and will be available to any individual business process record created after adding the help file.","Select the business process from the log and click Open. The Setup log for the business process opens.","Click New to create a setup, or select an existing setup from the log and click Open. The Business Process Setup window opens.","In the General tab, click the Help File Add button. The File Upload window opens.","Click Browse and navigate to the help file that you want to add. The help file must be an Adobe Acrobat PDF file. Click OK to attach the file and close the File Upload window.","When you have completed the Business Process Setup window, click OK.","To delete a business process from an existing setup:","Note: You can delete a business process from a specific shell template but not from other Projects/Shells that have been created using the template.","Go to the shell tab and switch to Admin mode.","In the left Navigator, select Setup, and then select Business Process.","Select a business process for deletion.","Click Delete.","When the prompt appears that asks you to confirm deletion, click Yes to delete the business process.","To access the business process Help link:","In User mode, navigate to the business process log.","Click the Help menu, and then click the business process name, which appears at the bottom of the Help menu. If a business process help file has been added to the business process form setup, the PDF file will open.","You can also access the file from the business process form. Open a business process record, click the Help menu, and click the business process name.","Creating, Adding, and Deleting Business Process Help Files","74429.htm");
Page[270]=new Array("Using uDesigner, users can design a form that automatically creates a new business process (BP), line item, or planning item from a source form to a destination (auto-created) form after certain criteria are met. Users who have modify ownership permissions in the source record can enable auto-creation. You can override conditional auto-creation and immediately invoke the auto-creation manually if needed.","This type of auto-creation automatically generates a new record based on:","A condition, such as a dollar amount","A frequency, such as a daily or weekly time frame","Note: Line items cannot be created with a frequency trigger.","Both a condition and a frequency","When a business process or line item reaches the trigger(s), the form will automatically create a new record or line item. This type of auto-creation uses a BP Creator, Planning Item Creator, or BP Line Item Creator data element on the upper or detail form to generate the new business process(es), line items, or planning item(s).","You can use auto-created business processes to manage repeated events, such as:","Line items of lease business process generating payment request business process records: A lease business process with a pregenerated payment schedule can use this functionality to generate payment request records at appropriate preset days in advance of the payment due date to be routed for approvals.","Preventive maintenance business process line items generating work orders business process records: A preventive maintenance type business process (Preventive Maintenance Book) can be set up to create work orders for assets at periodic intervals depending on the service needs of the asset.","For example, if you wanted to use auto-creation to create a work order business process to order maintenance on a vehicle, you would first create a preventative maintenance business process (the source business process) and have your administrator set up the auto-creation of a work order for vehicle maintenance business process (the destination business process) to order the work on the vehicle.","In this example, the uDesigner user set up which business process is the source business process and which is the destination business process. The company administrator specifies the conditions and defaults for the auto-creation. End users can set up the periodic auto-creation, based on their needs.","In the Preventive Maintenance Book, for:","Floating Line Items holding non-terminal work orders, you cannot edit the following DEs:","Family Identifier","Line Item Status","Schedule Type","Fixed Line Items holding non-terminal work orders, you can edit the following DE:","Line Item Status","Create action items from meeting minutes: Create and assign tasks to different people creating a fully automated flow for routing of action items from meeting minutes.","Create a planning item: Create a planning item when an initiative business process has been approved. The planning item could then be fleshed out with details, such as budgets, locations, personnel.","Add a new line item to an existing record: You can add a line item to an existing business process. For example, a submittal registry record could contain line items that auto-create separate submittal business process forms for each contractor on a project. In the course of work, you might realize that the original submittal registry record is missing a submittal for an architectural drawing. You could submit a new submittal business process form that would add the missing architectural drawing submittal to the original registry record.","For Line Item Creation:","Users cannot create a line item on a record that is at a terminal or terminated status.","For line items created on a non-workflow cost type business process, the cost amount(s) will roll up to the Cost Sheet.","For line items created on workflow cost type business process, the cost amount(s) will note roll up to the Cost Sheet.","After a new workflow record is created, the system sends it to the assignees as an initiation task (I Step) that appears on the user's Tasks log and the business process log to which the record belongs. If a new record is sent as an initiation task, the user must accept the task to manually launch the record.","Note: Regardless of the number of assignees or creators, only one user may accept the I-Step task.","After a new non-workflow record is created, the system sends it to the designated creators as an initiation task (I Step) that appears on the user's Tasks log and the business process log to which the record belongs. The user must accept the task to view the record.","Auto-creating BP Record or Planning Item Based on Conditions or Frequency","74430.htm");
Page[271]=new Array("The system auto-creates new business process records using a BP Creator element. If this element is on the upper form of the business process, it will auto-create a single record. If the BP Creator element is on the detail or line item form, it will auto-create a record for every line item on the source record. For example, if source tab A has a BP Creator element and 10 line items, and source tab B has the same BP Creator element and 7 line items, 17 new records will be auto-created.","Sometimes, however, creating a record for every line item is cumbersome. You can end up with 17 records that differ in only one aspect, such as a color. For cases like this, you can group line items for auto-creation to create fewer generated records. In a simple example for a lumber yard order, you might have doors made of wood or steel, both in colors of white and red. You could group the line items according to the material (wood or steel) and color (red or white) to create fewer work order records.","Notes:","If the auto-created business process is set up to include line item attachments, the attachments will be appended to the upper form of the destination business process if it is not a line item type.","If the auto-creation uses a date trigger, the system will ignore this grouping feature.","The system will not group line items if:<br />- The steps in the workflow are of different duration<br />- The task assignees are different<br />- The locations (such as shells) are different","See also Set up auto-creation for a non-workflow BP or planning item and Set up auto-creation for a workflow BP.","Grouping line items into single records","74431.htm");
Page[272]=new Array("During the business process setup, you can set up an auto-created workflow BP to skip theInitiationstep and send the record directly into the workflow, where it normally arrives at the first step after theCreatestep (or the first step in a conditional routing). For a workflow BP, you can specify the schema, the step in the workflow that the record should use as its first step, the workflow duration, and the name of the person or group who will be the owner of the auto-created record. When the record is created, data will roll up to the manager sheets at the appropriate status; however, if the system encounters errors or invalid data, the record will remain at the Create step, and roll-ups will not occur until the user resolves the errors.","For a non-workflow BP, you can set up an auto-created record to skip the Initiation step. In this case, the non-workflow BP will be created and will appear in the BP log in either an &quot;edit&quot; or &quot;finish edit&quot; mode. If it appears in an &quot;edit&quot; mode, the user will have to open the record and add or correct information on the form. If it appears in a &quot;finish edit&quot; mode, the record is considered complete, and data will roll up to manager sheets.","Bypassing the I Step","74432.htm");
Page[273]=new Array("Auto-creation uses details specified in the BP Creator element to create the record. If these details are not present in the BP Creator element, the auto-creation feature will use the following protocol to attempt to create the record.","For a Non-Workflow BP","For a Workflow BP","Checks for owner specification:","Checks the source BP setup","Checks the destination BP setup","If no owner can be identified, sends an error notification to those specified in source BP","Checks for owner specification:","Checks the source BP setup","Checks the destination BP setup","If no owner can be identified, sends an error notification to those specified in source BP.","Checks for status:","Checks the destination BP setup","If no status found, creates the record and puts it into &quot;edit&quot; mode for user to correct.","Checks for a workflow schema:","Checks the destination BP setup","If no schema is specified, the record will be sent as an I Step to the user's Tasks log and the BP log to which the record belongs. The user must accept the task to manually launch the record.","Checks for an action specification","Checks the destination BP setup","If no action is specified, the record will be sent as an I Step to the user's Tasks log and the BP log to which the record belongs. The user must accept the task to manually launch the record.","Auto-Creation Protocol for Bypassing the I Step","74433.htm");
Page[274]=new Array("There are rules that govern when the Unifier scheduler checks the conditions for auto-creation, and then if these conditions are met, it auto-creates the BP.","Rules for Checking Conditions for Auto-Creation","73205.htm");
Page[275]=new Array("The Company Administrator selected the Enable Auto creation check box for BP Creator when the auto-creation was set up.","If the Enable Auto creation check box is selected, it implies system based auto-creation, and the BP Creator Select button is not displayed in User mode.","For non-workflow BPs: The condition check occurs on Submit. If condition met, creates record and shows the link for the auto-created BP. If no condition is specified auto-creates records and shows the link for the auto-created BP.","For workflow BPs: The condition check occurs on Send. If end step reached and Action Form is used on End Step, the condition check occurs on Save instead of Send. If condition met, creates record and shows the link for the auto-created BP. If no condition specified blindly creates records and shows the link for the auto-created BP.","If the Enable Auto creation check box is not selected, it implies manual creation.","For non-workflow BPs: The condition check does not occur on Submit.","For workflow BPs: The condition check does not occur on Send.","BP Creator - Select button shown in User mode so that the user can create the business process manually. If clicked, creates BP record without checking any condition, and creates record and shows the link.","Rule 1","73206.htm");
Page[276]=new Array("Date Trigger Condition check: Are checks on the specified Date Data Element. For workflow or non-workflow BPs, this setup implies that the condition checks are done on a date instead of Finish Edit/Send, if a link does not exist next to BP creator element. If a link exists, it will not create any new records for that BP Creator element in the chosen line item of the record.","Rule 2","73207.htm");
Page[277]=new Array("Trigger Condition check based on frequency (Periodic): Are checks on frequency for BP Creator elements with Enable Auto creator checked. If specified, these are the only time condition checks are done. This overrides any other checks for date. This is the only method to create multiple records even if a link exists and a record has already been created for this BP Creator element. The link created using this will always point to last auto-created record.","Rule 3","73208.htm");
Page[278]=new Array("An additional cash flow option is available on the setup window for CBS code-based base commit business processes. This option enables the automatic creation of a commitment cash flow curve for each base commit record in a project/shell. To do this, you simply designate a commitment-level cash flow template to use for the auto-created curve.","For workflow business processes, this option is available in the Workflow Setup window Settings tab for every step other than the Create step. At runtime, when the record is sent from that step, the cash flow curve auto-creation is triggered and the curve is created in the Cash Flow log for the project/shell.","Note: The permissions will get copied over to the created Cash Flow.","For non-workflow business processes, this option is available in the Business Process Setup window on the General tab. At runtime, the cash flow curve auto-creation will be triggered when the Finish Edit button is clicked on the BP record.","When copying a cash flow to create a new one, all permissions will be copied to the new cash flow curve.","The following procedures describe enabling the auto-create cash flow option. See Setting Up a Non-Workflow Business Process and Setting Up a Workflow Business Process for more details on setting up business processes.","Notes:","This option is available for base commit business processes only; that is, cost-type business processes with sub-type of &quot;Line Items with CBS Code&quot; and classification of &quot;Base Commit.&quot; For all other types of business processes, this option will not display. The cash flow curves that are auto-created are based on commitment detail level curve templates (either company-level or curves created in project/shell templates).","Because your organization might have multiple cash flow jobs and automatic snapshots scheduled to run for a multitude of projects, you can use the Cash Flow Jobs functional node to manage the jobs and auto-snapshots and their impact on system performance. For more information, see the Unifier General Administration Guide.","To enable auto-creation of commitment-level cash flow curves in non-workflow base commit BP records:","Navigate to the Business Process Setup window for the base commit business process.","Go the project/shell tab (or project/shell template) and switch to Admin mode.","In the left Navigator, select Setup, and then select Business Process. Double-click the base commit business process from the log.","Double-click the business process again to open the Business Process Setup window.","On the General tab, locate the Cash Flow Template field.","Click Add. The Cash Flow Templates window opens. It lists all commitment detail-level cash flow templates created in the Company Workspace tab (which are available by using the left Navigator to go to Standards &amp; Libraries, selecting Cash Flow, and then selecting Templates) or in project/shell templates (in the Cash Flow node).","Choose a template and click Select.","Note: Entering a template in this field enables the cash flow auto-create feature. To disable this feature, click the Remove button to remove the cash flow template from the field.","Click OK to save and exit the Business Process Setup window.","At runtime, a commitment cash flow curve will be created in the project/shell when the base commit record is complete&#8212;that is, the user clicks the Finish Editing button on the record. The data used for the cash flow curve will be taken from the line item values on the record at the time the record is sent.","To enable auto-creation of commitment-level cash flow curves in workflow base commit BP records:","Navigate to the Business Process Setup window for the base commit business process.","Go the project/shell tab (or project/shell template) and switch to Admin mode.","In the left Navigator, select Setup, and then select Business Process. Double-click the base commit business process from the log.","Click Workflow Setup, and double-click a setup name (or create a new BP setup) to open the Workflow Setup window.","Click the Settings tab.","Select any step other than the Create step. Scroll down the Step Configuration options and locate the Cash Flow: Default Template field.","Click Add. The Cash Flow Templates window opens. It lists all commitment detail-level cash flow templates created in the Company Workspace tab (which are available by using the left Navigator to go to Standards &amp; Libraries, selecting Cash Flow, and then selecting Templates) or in project/shell templates (in the Cash Flow node).","Choose a template and click Select.","Note: Entering a template in this field enables the cash flow auto-create feature. To disable this feature, click the Remove button to remove the cash flow template from the field.","Click OK to save and exit the Workflow Setup window.","At runtime, a commitment cash flow curve will be created in the project/shell when the base commit record is sent from the selected step. The data used for the cash flow curve will be taken from the line item values on the record at the time the record is sent. If record line item values are edited during the course of the workflow, the curve values will update the next time the curve is refreshed.","Note: This option is not available in the Create step. If you designate a cash flow template in more than one workflow step, the cash flow curve will be created at the first step in which this option is enabled; the auto-creation will be ignored in any subsequent steps, because only one cash flow curve can be created per base commit record.","Setting Up Auto-Creation of Cash Flow Curves from Contracts","74434.htm");
Page[279]=new Array("If you have set up a company-level blanket purchase order (a uDesigner created, company-level cost subtype commit BP), you must then set up a summary template to enable validation against individual commit BPs that reference the blanket PO.","To set up the summary template for a blanket PO:","Go to the Company Workspace tab and switch to Admin mode.","In the left Navigator, select Company Workspace, and then select Business Process Setup. The business process log opens.","In the log, double-click the name of the blanket PO business process. A setup log opens.","On the log, select the business process and click the Summary Template button.","You may add additional columns as needed. Click Columns, and then click New. Complete the Column Properties. The data source choices for columns include:","Single source: All active cost BPs for your company (and their statuses), regardless of project. You determine which statuses you want to appear on the sheet. If you import and set up cost BPs that might reference the blanket PO, be sure to add them to the summary sheet template to track them against the total.","Logical source: Total commits and remaining balance. These should be set up as formulas, where total commits is the sum of the commits that you added as columns, and the remaining balance is the difference between the original amount and total commits.","To enable validation, include a total commits column to keep track of commit BPs that reference the blanket PO, and a remaining balance column to ensure that you do not exceed the original amount.","Setting Up a Blanket Purchase Order Summary Template","74443.htm");
Page[280]=new Array("A Base Commit classification of a Cost Type Business Process (BP) can create a schedule of values; a General Spends classification can create an invoice at the CBS level.","Use the Base Commit BP for:","For monies committed to be spent; for example, a contract or purchase order.","For creating a Schedule of Values (SOV) sheet for a General Spends, Payment Applications, or Summary Payment Applications.","Notes:","In Standard Cost Manager, the Base Commit BP creates an SOV sheet.","If you configure specific Data Elements (DEs) to auto-populate from a Base Commit BP, do not configure the same auto-population using CSV, Microsoft Excel, or REST API in an SOV sheet for General Spends, Payment Applications, or Summary Payment Applications.","With the Base Commit type of BP, you can:","Reference against a company-level commit BP","Enforce the line items against a company-level commit amount","Create a commitment summary when the BP is in a terminal status","Consolidate line items","From this type of BP, you can:","Select only a General Spends type of commitment summary","View commitment summary line items only by individual line items, or grouped by commit codes","To set up the for a Base Commit BP:","Go to the shell tab and switch to Admin mode.","In the left Navigator, select Setup, and then select Business Process to open the Business Process - Current View log.","Open the BP that you want to set up.","In the Business Process Setup window, General tab, enter values.","Continue on with entering values in the Settings, Notification, Auto Creation, and Record Copy tabs.","When finished, click Apply and OK.","Removing Restrictions Related to the Multiple Payment Application Submissions (Remove SOV restrictions)","When you create a Workflow BP record, the BP record shall remain in progress (in-flight) until the record reaches its terminal stage.","You can set up a Base Commit type of BP that is based on an existing Schedule of Value (SOV), and in progress (in-flight), to accommodate:","Multiple Payment Application records can be created for the same commit record.","Multiple Negative Change Orders can also be created for a given Base Commit.","Payment application when a negative change order is in-flight.","A negative change order refers to a Change Commit (change order) that has been issued to deduct the original committed contract amount. This means that a user has created a record of Change Commit BP type with negative line item amounts.","In the Business Process Setup window, General tab, you have the option of applying or removing restrictions on multiple payment applications or multiple negative Change Commit in the Base Commit BP. This enables users to create:","Create and submit a Payment Application when another Payment Application is in progress.","Create and submit a Payment Application when a Change Commit (change order), with a negative line item, is in progress.","Create and submit a Change Commit (change order), with a negative line item, when a Payment Application is in progress.","Create and submit a Change Commit (change order), with a negative line item, when another Change Commit (change order), with a negative line item, is in progress.","In the Business Process Setup window, General tab, you have the option of applying or removing restrictions on multiple payment applications or multiple negative Change Commit in the Base Commit BP. This enables users to create:","Create and submit a Payment Application when another Payment Application is in progress.","Create and submit a Payment Application when a Change Commit (change order), with a negative line item, is in progress.","Create and submit a Change Commit (change order), with a negative line item, when a Payment Application is in progress.","Create and submit a Change Commit (change order), with a negative line item, when another Change Commit (change order), with a negative line item, is in progress. ","Note: The options listed above are available for Base commits of SOV type = Payment Applications or Summary Payment Applications.","Additional information about Removing SOV restrictions","Users can modify the Remove SOV restrictions option at any time except when all the Payment Applications and Negative Change Orders that refer to the BP have reached the terminal step.","When you select or clear the Remove SOV restrictions option in an existing Workflow template that you plan to use for updating existing Workflow schema in the destination project/shell, the selected SOV restriction option (existing in the BP setup level) will get updated in the Project/Shell instance.","When you select or clear the Remove SOV restrictions option in an existing Workflow template that you plan to use to create Workflow schema in the destination Project/Shell, the selected SOV restriction option (existing in the BP setup level) will not get updated in the Project/Shell instance.","When you select or clear the Remove SOV restrictions option in an existing Workflow template that you plan to use to create Workflow schema in the destination Project/Shell, and if this new Workflow schema are used in the Auto Creation tab of the BP setup, the selected SOV restriction option (existing in the BP setup level) will get updated in the Project/Shell instance.","When the SOV restriction option setup is ready and you include the BP in the Configuration Package, if there are any in progress (in-flight) records for the Payment Application, or Change Commit (change order), the import will be successful but the system does not update the setup information for that BP.","If the user does not select the Remove SOV restrictions option:","Multiple payments cannot be created.","Multiple negative Change Commits cannot be created.","Positive Change Commit will not affect the in transit payment and Merge message will not be shown.","If the user selects the Remove SOV restrictions option:","Multiple payments can be created.","Multiple negative Change Commits can be created.","Merge message is shown only when another payment or Change Commit is created, while the first payment is in-flight.","Positive Change Commit impacts the SOV Sheet and not the multiple payments. To support multiple payments, merge needs to occur.","Setting Up a Base Commit Business Process","10286867.htm");
Page[281]=new Array("Construction projects typically have multiple contracts or commitments spread over a time-period. To accommodate multiple contract types or commitments in a project, you can now include more than one Base Commit BP wherein each Base Commit can be associated with a payment application and a distinct schedule of values (SOV).","Note: With this setup, you are no longer limited to configuring only one Base Commit BP with a payment application and SOV in a project.","Prerequisite","You have created one or more Base Commit BPs with Payment Applications and corresponding SOVs.","Procedure","To manually set up multiple Base Commit BPs with payment applications and corresponding SOVs for a project:","In the Location bar, select your project and switch to Admin mode.","In the left Navigator, select Setup, and then select Business Process.","In the Business Process Setup - Current View log, click New.","In the New Business Processes window, select a Base Commit BP with payment applications. ","Click OK to include the Base Commit BP in the Business Process Setup - Current View log.","Repeat the above step sequence to add multiple Base Commit BPs.","Click OK to confirm the alert message that displays when you add subsequent Base Commit BPs.","With this setup, the Schedule of Values log is relocated in the left Navigator. Contact your Company Administrator if you do not have access to the new SOV log location.","Alternative Setup Methods","You can also set up multiple Base Commit BPs by updating shell templates. For more details, see Setting Up Shell Templates with Multiple Base Commit BPs with Multiple Payment Applications and SOVs.","Setting Up a Multiple Base Commit BPs Manually with Multiple Payment Applications and SOVs","10316292.htm");
Page[282]=new Array("A Request for Bid (RFB) business process allows companies to invite bids from multiple vendors. The Request for Bid process requires the following components to operate in Unifier:","Master Vendor BP (Vendor Master BP): A simple or Line Item type BP (Company level) that lists the available vendors who can be invited to bid. A company can have only one master vendor BP. The system allows your company to only designate one Vendors business process as the RFB master vendor list.","Requestor form: This is the BP form the user uses to distribute bid requests from vendors.","Bidder form: This is the BP form the vendors use to submit their bids.","A workflow for the requestor form: This workflow or workflows can be used to approve the RFB before inviting bids, to distribute the RFB, and to approve the final bid award.","(Optional) A bid comparison sheet: This is a sheet designed specifically for your company for the purpose of comparing the bids you receive from vendors. (If your company has not designed one, the system provides a default sheet you can use.)","Setting Up a Request for Bid (RFB) Business Process","74444.htm");
Page[283]=new Array("In uDesigner:","Verify that the correct vendor list is linked to the RFB.","Open your vendor master (Master Vendor BP/Vendor Master BP) business process properties and click the Options tab.","Make sure the field Use this process as RFB master vendor list is checked. This option links the vendor list to your RFB.","Make sure the correct vendor list has been specified as the RFB's reference process.","Open the RFB and click Reference Processes in the Navigator.","Verify that the RFB references the correct vendor BP.","In uDesigner, for the RFB business process (BP), you can select a BP Data Picker that references a Line Item type BP that can be used to filter the available bidders in the Option tab.","The BP Data Picker that is available for selection is the one that has been added to the Requestor Upper Forms.","The selected BP Data Picker points to the Line Item type BP that contains the BP Data Picker (BP Picker) that is in the Detail Form and subsequently points to the Master Vendor BP/Vendor Master BP, at the Company level.","The following explains the workflow:","In the RFB BP, the Options tab enables you to set the data picker required to connect to the Line Item type BP.","The Requestor BP form contains the data picker that points to the Line Item type BP.","In the Line Item type BP, the Details Line Item record contains the BP Data Picker/BP Picker that is required to connect to the Vendor BP.","The Data Picker/BP Picker points to a Master Vendor BP/Vendor Master BP record at the Company level. You can use the query condition, on the data picker, to filter the list of vendors (for example: within the same project or before certain dates).","The Vendor BP contains the list of vendors who are available for bidding.","Verify the RFB Has Been Designed Correctly","74445.htm");
Page[284]=new Array("To enable the vendors to sign in and submit bids, you must create a &quot;bidder&quot; account. In the preferences you set up for this account, you must specify certain settings to make the bidding process possible. You will enter this bidder's account in your company's preferences.","Note: Do not link the bid management account to an actual user in your company. Create this account strictly for the bidding process so that you can set up the account preferences specifically for bidding. If you set up a special &quot;bid management&quot; user account, you can prevent users from inadvertently changing the settings.","To set up this &quot;bidder&quot; account, add the bidder as a user.","For more information, see User Administration in the Unifier General Administration Guide.","Sign in as the user with the bidder account.","In the upper-right corner of your window, click your User Name to open a contextual menu.","Click the Preferences link. The User Preferences window opens.","Click the Options tab.","Set the Time Zone field to match that of the bid requestor's (either your company's time zone, or the zone from which the bid invitation is sent).","If your bidders are in a different time zone from yours, this will protect them from mistakenly submitting bids after the bidding process is closed.","Controlling the Display of Information","On the RFB Bidder Portal, the bidder can see the Requestor Package with the Estimated Unit Cost, and the Amount.","As a requestor, there are occasions that you want to ensure that:","Bidders do not see bids offered by other bidders.","Bidders do not see the cost-related or estimate-related information on the requestor's form.","As a result, the system allows you to hide values of the requestor's detail form fields from bidder. Refer to the Unifier uDesigner User Guide to learn which options to select. ","Set Up a Bid Management Account","74446.htm");
Page[285]=new Array("To set up the RFB (in Admin mode):","Follow the standard procedures to import (Importing Business Processes), configure (Configuring Business Processes), and set up (see General Procedures for Setting Up Business Processes) the RFB.","Define a link for the bidders to use to submit bids:","Go to the Company Workspace tab and switch to Admin mode.","In the left Navigator, select Company Settings.","Click Edit.","On the General tab.","In the Bid Management section, enter the account name of the user who will be managing the bids that your company receives.","This is the account that contains the bidder's preferences you created using the instructions under Set Up a Bid Management Account.","Set Up the RFB","74447.htm");
Page[286]=new Array("Refer to the Unifier Data Reference Guide for permission settings.","Business Process Permission Settings","74448.htm");
Page[287]=new Array("Not all BPs work with all functional areas of Unifier. This table lists the available BPs and the areas in which the BP works.","Type","Subtype","Classification","Shell (CBS)","Shell (Generic)","Company","Cost","Commit at Company level","-","X","Cost","Line item with CBS code","Generic","X","Cost","Line item with CBS code","Transfer","X","Cost","Line item with CBS code","Base Commit","X","Cost","Line item with CBS code","Change Commit","X","Cost","Line item with CBS code","General Spends","X","Cost","Line item with CBS code","Payment Applications","X","Cost","Line item with fund code","Generic","X","Cost","Line item with fund code","Transfer","X","Cost","Line item with both fund and CBS code","Generic","X","Cost","Line item with both fund and CBS code","Transfer","X","Cost","Line item with company account code","Generic","X","Cost","Line item with company account code","Transfer","X","Cost","Line item with asset code","-","X","Cost","Line item with multiple codes","Generic","X","Cost","Line item with multiple codes","Transfer","X","Cost","Line item with multiple codes","Base Commit","X","Cost","Line item with multiple codes","Change Commit","X","Cost","Line item with multiple codes","General Spends","X","Cost","Line item with multiple codes","Lease","X","Line item","-","-","X","Line item","-","-","X","X","RFB","-","-","Simple","-","-","X","Simple","-","-","X","X","Document","With folder structure","No detail form","X","X","X","Document","With folder structure","With detail form","X","X","X","Document","Without folder structure","No detail form","X","X","X","Document","Without folder structure","With detail form","X","X","X","Text","-","-","X","X","X","Resource","Resource booking","-","Resource","Time sheets","-","X","Business Process Functionality","74449.htm");
Page[288]=new Array("The Query tab allows access to all Business Processes/Space/Level records, related to a Business Process, by way of Query-based Tab (QBT).","Example","To see all approved Spaces related to your BP, use the QBT to query/fetch those records. After a Query-based Tab (QBT) is successfully created and deployed using uDesigner, the Query Tabs appear in the required BP, in User mode.","A Query-based tab (QBT) is a mini business process log that displays a filtered list of business process records in the tab line item list. The QBT can be used in all:","Line Item business processes","Cost business processes","Space business processes","Document-type business processes","Example","A contract QBT can display just the change orders issued against the contract. Another QBT can display only invoices against the contract. Records displayed in the QBT line item list are from the same level (project/shell or company.)","QBTs are not supported in the following business processes:","Simple","Resource","Text","Request for Bid (RFB)","Project/Shell creation","In uDesigner, the &quot;Query Items&quot; is a new parent node in the Business Processes (left Navigator) with two sub-nodes:","Query Tabs","To define the QBTs that will be added to the business process. Query tabs can be created if the maximum number of tabs (fifteen) has not been reached.","Summary Elements","To define summary data elements to be added to the Upper Form of the business process. The summary elements specify the type of summary information (average/count/total/maximum/minimum) that will be shown from the selected query tab, for example, the total amount of records in the tab.","As a pre-process to defining the Query tab in the business process, you need to use a reference picker in one of the upper forms of the business process, Space, or Level from where you want to create the Query tab. For defining a Query tab, click the Query Tabs link in uDesigner, click New, and select a business process, Space, or Level. The system allows you to create a maximum of fifteen tabs in uDesigner, including the QBT.","Query-based tab enables the user to:","View a filtered list of business process records associated with the parent business process.","After the QBT in a business process is correctly configured and deployed, the QBT appears in the business process (User mode) for which the QBT has been configured.","Create a new business process from the QBT in the same Project/Shell, where the parent business process resides.","Users can create business process records from the QBT provided that the users have permission to create business process records for the Project/Shell that contains the business process.","Copy a business process in the same location as the parent business process.","Users can copy a business process either with or without attachments. In addition, a user can copy any of the records, in the QBT, and create a new business process record.","Note: Users can copy one record at a time.","When the user copies a business process record to create a new business process, the new business process record contains all the information present in the copied/based business process record.. So, in case of business records with attachments, the user has the option of including or excluding (copying or not copying) the attachments when copying a business process record.","Search for business process records based on user-entered criteria.","Users can find any record from the list of records included in the QBT.","Note: The fields available for the Find feature must be defined in the uDesigner for the business process.","Use the Properties option (log toolbar) to configure the tab. The options are:","Line Items","Standard","Gauges &amp; Meters","Hide current tab","User-Defined Report (UDR) and Query-Based Tab","Users will be able to use the Summary Elements, from any of the QBTs, in any of the UDRs that the user wants to use if the UDR is based on the same business process record.","Note: If a Query tab is configured using a query condition, the same query condition has to be implemented within the UDR. For example, if a query-based tab (QBT) has a condition, Status = Approved, then create a corresponding query condition in the UDR as: BP A/QBT BP B/Status = Approved.","Query Tab and Document-type Business Process","The Document-type business processes support QBTs and Line Item tabs along with the existing standard tab.","To define the Query tab in a Document-type business process, you must add a reference picker in the Upper Form of the business process that you want to run the query against. This includes business process picker, new data definition, or business process picker for the destination business process.","When users click the Properties option, for an Upper Form on a Document-type business process, the Options tab displays the following:","Standard Tab (for Document-type business process)","Line Item Tab (similar options across each line item type tab)","Query Based Tab (similar options across each QBTs)","Standard Tab (for Document-type business process)","Hide current tab","Add/Copy Line Items","Remove Line Items","Allow Modification of Line Item, except when status is","Allow Line Item Status to be modified","Add Attachments","Remove Attachments","Append Line Item Folder Structure to Auto Publish Path","Make Attachment to a Line Item mandatory","Allow comments","Allow marking of comments as 'Final'","Additional","Allow linking Mailbox","Attachment Source","Unifier Folders","My Computer","Line Item Tab (similar options across each line item type tab)","Hide current tab","Add/Copy Line Items","Remove Line Items","Allow Attachments to the line item","Allow Modification of Line Item, except when status is","Allow Line Item Status to be modified","Additional","Allow linking Mailbox","Attachment Source","Unifier Folders","My Computer","Query Based Tab (similar options across each QBTs)","Hide Tab","Additional","Allow linking Mailbox","Attachment Source","Unifier Folders","My Computer","To view, or use, a QBT:","Go to the parent business process log in Project/Shell.","Open a record to view the QBT.","Note: The source business process of the QBT must be active for the tab to display.","See the following topics for more information about creating QBTs.","Query-Based Tab in Business Processes","10283670.htm");
Page[289]=new Array("To create a Query tab:","Go to the Company Workspace tab and switch to Admin mode.","In the left Navigator, select uDesigner, and then select Business Processes.","Select and open a business process (BP).","In the left Navigator for the BP, select Query Items, and then select Query Tabs.","In the Query Tabs log, click New.","In the Select Business Process window, click the drop-down list (under Select Business Process/ Attribute field), select a business process or attribute, and click OK to open the Query Tab window.","In the Query Tab window, enter values in the Name, Description, and Reference Picker fields (this is to filter records in the Query tab).","The value for the Reference Picker field is auto-populated when a user creates a new business process record based on a QBT. In such a case, the record number of the parent record will be auto-populated and the user can edit the number and change it to a desired record number. After the business process record is successfully created, the reference graph shows the intended business process record.","When finished, click OK.","In the left Navigator, select Item Logs to begin designing the log. You can have a total of 8 (eight) tabs, including the Query tabs.","The log for the Items Log has several columns. The Type column enables you to distinguish between the Detail Form line items list and the Query Items. The Tab Name column appears before the Name column. Define query conditions in the setup for filtering the list of records returned at runtime.","Note: You can sort Item Logs using the Name, Last Saved, or Type column. You cannot sort the log using the Tab Name, Tab Order, or System Defined column.","Click to open the Query items window and click the Query tab to begin setting your condition.","Click Add to open the Query Condition window. If you do not add a query, the tab returns all the records, based on the reference process.","Select and enter values in the Data Element and Condition fields. You can add multiple conditions. the system performs the query with &quot;And&quot; operand, on the conditions.","In the left Navigator, go to the Upper Forms node to configure the Query tab options, similar to the Detail Forms.","Complete your business process.","Deploy the business process form.","Note: When setting two BPs that are dependent on each other with a Query Based Tab (QBT), ensure that you do not assign a Summary DE (Data Element) to both BPs.","Additional information:","Within a selected BP, the Query Items sub-node provides the following two links:","Query Tabs","Summary Elements","Query Tabs","You can use the Query Tabs sub-node to define and maintain the various Query tabs that are defined within the business process.","General Tab","In the General tab, you can enter the name, description, and reference picker for the required QBT.","In case, you have already included the reference picker in the Upper Form of the business process, the reference picker appears in the drop-down list of the Reference Picker field. In this case, the Name field is populated with the name of the business process, but you can change the name of the QBT, if necessary. The name and reference pickers are required fields on the General Tab, so you cannot create a QBT if you have not included the reference picker on the Upper Form of the business process.","Query Tab","The Query Tab of the QBT is used to create a query to filter the results, displayed within the QBT, based on any particular condition.","To access the Query Tab, go to Item Logs sub-node, open the QBT that was created, and switch to the Query tab.","Note: It is not required to have a query. If no queries are defined, all records display in the QBT, in User mode.","You can define multiple queries within the Query tab.","The Query Tabs log allows you to:","See all the Query Tabs","Create a new QBT (New).","Open an existing QBT to review or change content (Open).","Delete an existing QBT (Delete).","Summary Elements","You can use the summary elements on the Upper Form of the business process to show the data that is being exchanged. You can use the following types of the summary elements in QBT:","Average","Count","Total","Maximum","Minimum","You can define multiple summary elements. To create summary elements:","Go to the Company Workspace tab and switch to Admin mode.","In the left Navigator, select uDesigner, and then select Business Processes.","Go to your business process, click the Summary Elements node and use the QBT to create your summary elements. After defining the summary elements, click OK to save.","The log for the Summary Elements node allows you to:","See all the Summary Elements.","Create a new Summary Element (New).","Open an existing Summary Element to review or change content (Open).","Delete an existing Summary Element (Delete).","After you create the summary elements, you can include them in the Upper Form of your business process.","Creating Query-Based Tab in Business Processes","10287103.htm");
Page[290]=new Array("Business Processes (BPs) can be associated with a specific project/shell (Project/Shell-level BP), or they can be applicable for the entire Company (company-level BP) and not be specific to a Project/Shell.The Administrator (Project/Shell or Company) determines which forms are to be used and how the workflows operate.","To set up a BP record to receive updates in a Company or Project/Shell, do one of the following:","For a Company:","Go to the Company Workspace tab and switch to Admin mode.","In the left Navigator, select Company Workspace, and then select Business Process Updates.","For a Project or Shell:","Go to the shell tab and switch to Admin mode.","In the left Navigator, select Setup, and then select Business Process Updates.","Setting Up Updates for Business Process Records","10284647.htm");
Page[291]=new Array("To update a Business Process (BP) in the Company Workspace:","Go to the Company Workspace tab and switch to Admin mode.","In the left Navigator, select Company Workspace, and then select Business Process Updates.","Business Process Updates Log in Company Workspace","The Business Process Updates log in Company Workspace allows you to set up updates from a template to a record, at the Company level. The log consists of the following:","Menu","File","Edit","View","Help","Toolbar","New","Open","Find","Cancel Request","View Details","Note: These options can be accessed through the Business Process Updates log menu options.","Columns","Name","Source Business Process","Source Business Process Record","Submit Date","Schedule date","Start Date","Completion Date","Status","Requested By","The functions of the elements in the Business Process Updates log are explained in the following section.","Company Workspace and Business Process Updates","10284648.htm");
Page[292]=new Array("Preventive Maintenance Business Process (BP) Line Items generate Work Order BP records. You can set up a Preventive Maintenance type BP (Preventive Maintenance Book) to create Work Order BP records for assets at periodic intervals according to the service needs of the asset.","In the Preventive Maintenance Book, for:","Floating Line Items holding non-terminal work orders, you cannot edit the following DEs:","Family Identifier","Line Item Status","Schedule Type","Fixed Line Items holding non-terminal work orders, you can edit the following DE:","Line Item Status","The Work Order BP records refer to a Preventive Maintenance type BP (Preventive Maintenance Book) to view all the Work Order BP records for that Preventive Maintenance type BP (Preventive Maintenance Book).","The Business Process Updates log in Company Workspace allows you to set up updates from a PM Book Template to a PM Book record, at the Company level.","The following explains the following toolbar options: ","Note: These options can be accessed through the Business Process Updates log menu options.","New","Open","Find","Cancel Request","View Details","The New option enables you to create update requests from the PM Book Template type, and the log displays all the PM Book Template updates that exist at the Company level.","The drop-down list of the New option lists all the BPs of PM Book Template type that have been set up in the Company Workspace. If a BP is not Active, or it does not have Active setups, the system does not include the BP in this list.","Note: If there are no BPs that have Active setups, the New option will be disabled.","When you select a BP from the New option list, the BP record selection window opens which enables you to select the source PM Book Template record for the update.","The BP record selection window contains the log elements/options that have been set in the Business Process Configuration.","The toolbar of the BP record selection window has the same option as the Data Picker window.","The Open option enables you to view the request details; however, depending on the status of a record, this option may not be available, as explained here:","If the Status of a record is &quot;Completed/In Progress/Error/Failed,&quot; the log has a Close option. In this case, you can only view the update request details.","If the Status of a record is &quot;Not Started/Not Scheduled,&quot; the update setup window opens.","The Find option enables you to search for a particular request in the log, using the following search parameters:","Name","Source Business Process","Source Business Process Record","Status","Note: The logical operators are the same as in any String or Pull Down field.","The Cancel Request option enables you to cancel a scheduled update. You can only cancel a request that has not started (that is, you can cancel a record that is not stamped with a Start Date.). You can cancel multiple requests. After you cancel an update request, the system changes the:","Status of the request to: Not Started","Schedule option to: None","The View Details option enables you to view the details of an update request. When you click this option, the system opens a report in PDF format that outlines the details of all the PM Book records that were updated successfully and those that were not.","PM Book Record Update Window","After you select the source PM Book Template record for the update, the PM Book Record Update window opens which contains multiple tabs. These tabs are based on the PM Book Template design and are not query-based tabs.","Note: Depending on the design of the Asset Business Process in uDesigner, you may see other tabs (Detail Form tabs) in the PM Book Record Update window. For example, you can see Time Schedules tab, Gauge Meter Schedules tab, and so forth.","The following describes each tab in detail:","General tab","The General tab is fixed and has the following fields:","Name (required)","Description (optional)","Source Business Process (read-only): The value in this field is the name of the PM Book Template Business Process.","Source Business Process Record (read-only): The value in this field is the number of the PM Book Template record that is the source of the update.","Schedule (block): This block has two fields (date and time picker) impacting the schedule of the update (Date and None). The date that you select must be greater than the current date and time.","Main Form tab","The Main Form tab is fixed. The fields in this tab enables you to update the Upper Form field values of the PM Book record from the Upper Form field values of the PM Book Template record.","The Data Elements in the Main Form tab are based on the Data Elements that exist in the PM Book Template.","By default, all Data Elements are selected. Use the check box next to Data Element to select or deselect all other Data Elements.","The order of the fields is based on the Upper Form design.","Use the View Record Details option to open a read-only copy of a record. This is to assist the user with reviewing the existing values of the PM Book Template record.","Detail Form tabs (Other tabs)","The Update PM Book Records window displays tabs based on the design of the Detail Form (in the left Navigator, select uDesigner, select Business Processes, open PM Book Templates, and then select Design Form). For example, if the Detail Form contains Time Schedules and Gauge Meter Schedules, the Update PM Book Records window displays the Time Schedules tab, Gauge Meter Schedules tab, in addition to the fixed tabs (General tab and Main Form tab).","The Detail Form tabs enables you to select the Line Items that need to be updated in the auto-created PM Book records, from the PM Book Template.","The following elements are available in each Detail Form tab:","Line Items","From this block, you can specify the Line Items that you want to get updated in the PM Book records, from the PM Book Template. The Line Items block displays all Line Items that exist in the selected template record and includes the following information about each Line Item:","Line No.","The line number of the Line Item in the PM Book Template. The line number in the PM Book record may not have a one-to-one connection with the line number existing in the BP Book Template.","Short Description","Line Item Details","Each Line Item has a View, hyperlink, option that enables you to view the Line Item details, in View only mode.","Data Elements - &lt;name&gt; tab","This section displays the list of applicable Data Elements. Use the Data Element check box to select/deselect all elements. The Line Items listed here exist in the auto-created PM Book record.","When an Asset auto-creates a PM Book record, the Line Items, and contents, are copied over from the PM Book Template record associated with the Asset. The system associates a unique &quot;guide&quot; for each of the Line Items in the PM Book record and maintains a reference to the Line Items in the parent PM Book Template record. Since such a reference exists, the Line Item in the parent PM Book template record is changed, and the corresponding Line Item in the destination PM Book record is updated by means of this Push update.","New line items can only be added to the Time based tab. If new Line Items are added to the PM Book Template record, you need to conduct a push to add the new Line Items to the PM Book record, as new Line Items. The Data Elements of the PM Book records are updated as part of this push.","If the Line Items do not exist in the auto-created PM Book records, the system creates the Line Items. The new Line Item creation, in the PM Book records, follow the Line Item auto-creation logic, and the new Line Item creation does not refer to the Data Elements section of the tabs, at the time of update. The tab mapping that has been set in the design of the Asset BP forms the basis for copying over the field values in the PM Book records.","Company Workspace and Preventive Maintenance Type BP","10284650.htm");
Page[293]=new Array("To update a Business Process (BP) in the Project/Shell:","Go to the shell tab and switch to Admin mode.","In the left Navigator, select Setup, and then select Business Process Updates.","Business Process Updates Log in Project/Shell","The Business Process Updates log in Project/Shell allows you to set up updates from a template to a record, at the Project/Shell level. The log consists of the following:","Menu","File","Edit","View","Help","Toolbar","New","Cancel Request","Open","Find","View Details","Note: These options can be accessed through the Business Process Updates log menu options.","Columns","Name","Source Business Process","Source Business Process Record","Submit Date","Schedule date","Start Date","Completion Date","Status","Requested By","The functions of the elements in the Business Process Updates log are explained in the following section.","Project/Shell and Business Process Updates","10284649.htm");
Page[294]=new Array("Preventive Maintenance Business Process (BP) Line Items generate Work Order BP records. You can set up a Preventive Maintenance type BP (Preventive Maintenance Book) to create Work Order BP records for assets at periodic intervals according to the service needs of the asset.","In the Preventive Maintenance Book, for:","Floating Line Items holding non-terminal work orders, you cannot edit the following DEs:","Family Identifier","Line Item Status","Schedule Type","Fixed Line Items holding non-terminal work orders, you can edit the following DE:","Line Item Status","The Work Order BP records refer to a Preventive Maintenance type BP (Preventive Maintenance Book) to view all the Work Order BP records for that Preventive Maintenance type BP (Preventive Maintenance Book).","The Business Process Updates log in Project/Shell allows you to set up updates from a PM Book Template to a PM Book record, at the Project/Shell level.","If you link your Time and Meter Schedules within a PM Book BP, you can avoid generating multiple PM work orders if a meter-schedule occurs sooner than a time-schedule, or conversely. The following scenario provides a good example for this feature:","A commercial vehicle is scheduled for an oil change either when it reaches 5000 miles (meter) or 12 months (time) after the last oil change, whichever is reached first. If the vehicle reaches 5000 miles prior to 12 months, the system generates a PM work order and automatically prevents a second PM work order when the 12 months time frame comes. Conversely, if 12 months passes and the vehicle does not reach 5000 miles, the system generates a PM work order and automatically prevents a second PM work order when the vehicle reaches 5000 miles.","To prevent generating an additional work order, in such a case, you can use the &quot;uuu_rec_related_family_id&quot; data element to link the meter-schedule and the time-schedule within a PM book or PM book template. To update the &quot;uuu_rec_related_family_id&quot; data element from PM Book templates to use for all PM Books, go to either of these locations:"," Shell (switch to Admin mode; in the left Navigator, select Setup, and then select Business Process Updates)","Company Workspace tab (switch to Admin mode; in the left Navigator, select Company Workspace, and then select Business Process Updates)","Once selected, all the PM Books will be updated with correct values from the related PM Book Template, according to the push schedule defined within this log.","For more information, see Company Workspace and Preventive Maintenance Type BP.","Project/Shells and Preventive Maintenance Type BP","10284651.htm");
Page[295]=new Array("Configurable manager, as well as classes, forms, and corresponding logs are designed in uDesigner (Configurable Modules) and deployed to Unifier. You must also define the business processes that work with the configurable manager.","Note: Assign a specific name for the configurable manager in uDesigner. The generic term used in the instructions is configurable manager.","Step 1: Design Code and Records-based configurable manager in uDesigner (Configurable Modules).","Step 2: Setup the Business Process Data elements under the Options tab and deploy the manager. After the manager has been deployed, classes can be designed and deployed.","Step 3 Set permissions.","Step 4: Configure the code and records-based manager.","Step 5: Set the template administration permissions.","Step 6: Create template sheets and add columns.","Step 7: Set permissions for the user.","Setting Up the Code and Records-based Configurable Manager","74485.htm");
Page[296]=new Array("You must have modify permission to import configurable managers. You can set view permissions to allow users to view configurable modules.","To access permissions:","Go to the Company Workspace tab and switch to Admin mode.","In the left Navigator, select User Administration, and then select Access Control.","On the right pane, expand Administration Mode Access, expand Data Structure Setup, and then expand Configurable Modules.","Setting Permissions to Import Configurable Managers","74486.htm");
Page[297]=new Array("All designs, including configurable managers, are designed in uDesigner and deployed to Unifier. See Importing Configuration Packages.","Note: Importing Forms that Contain Data Pickers: Data pickers point to a data source for the records they display. If that data source&#8212;the BP, shell, or manager class&#8212;to which the picker is pointing is not already in Unifier, you will receive a warning. The business process will not operate correctly until the data source is imported.","Importing Code and Records-Based Configurable Managers","74487.htm");
Page[298]=new Array("This section describes how to manually delete a record under Material Inventory Manager from a shell template.","Note: You can delete a record under Material Inventory Manager from a specific shell template but not from other Projects/Shells that have been created using the template.","Go to the shell tab and switch to Admin mode","In the left Navigator, select Setup, and then select Material Inventory Manager.","Select a record from Material Inventory Manager for deletion.","Click Delete.","When the confirmation message appears, click Yes to delete the record from the Material Inventory Manager.","Deleting a Material Inventory Manager","10293657.htm");
Page[299]=new Array("Classes must be deployed before you can set permissions. Set permissions based on existing permissions for the uDesigner, which you can view by completing the following steps:","Go to the Company Workspace tab and switch to Admin mode.","In the left Navigator, select User Administration, and then select Access Control.","On the right pane, expand Administration Mode Access, and then expand uDesigner.","Setting Permissions to Import Classes","74488.htm");
Page[300]=new Array("To import a class into the Unifier Production environment, see Importing Configuration Packages.","Importing Classes for Code and Records-based Configurable Managers","74489.htm");
Page[301]=new Array("Imported configurable manager classes are listed in the manager configuration log, with a default status of inactive.","To configure a configurable manager class:","Go to the Company Workspace tab and switch to Admin mode.","In the left Navigator, select Configuration, and then select [configurable manager]. The Configurable Manager log opens. The log lists the classes.","Select a class record from the log and click Open. The Configuration window opens.","Complete the General tab as described in the table below.","On the Custom Print tab, using the Microsoft Word XML schema, you can create a customized printed output.","To make the class active, click Active. This enables classes and sheets to be created in User mode. The class is also available to use as a project category or shell type.","Click OK.","In this field:","Do this:","Sequence Format","Define the sequence of the record numbers for records created for this class in User mode. This is similar to business process numbering.","Help File","You can upload a PDF file to use as a help file for the manager.","Auto Creator","Select the auto-creator.","Status","Activating the configuration makes the class available in User and Admin mode for creating records, sheets, and templates.","Configure configurable manager classes","74490.htm");
Page[302]=new Array("To error-check imported classes:","Go to the Company Workspace tab and switch to Admin mode.","In the left Navigator, select uDesigner, select Configurable Modules, and open the applicable [configurable manager].","In the Configurable Manager log, select one or more classes. To select multiple classes, press the Ctrl key or Shift key while selecting the classes.","Click the Error Check button. After validation, the error check window opens, listing any errors that were found.","To fix the errors, make the changes in uDesigner.","Run an Error Check on a Class","74491.htm");
Page[303]=new Array("If your Code and Records-based manager includes a data picker or a user data picker, it must be configured to examine and extract the records that should appear on the picker list. To do this, create a database query. (For more information on data pickers, see About Data Pickers and About User Data Pickers in the Unifier uDesigner User Guide. For more information on queries, see Queries in the Unifier General Administration Guide.)","After you have set up the query or queries for a data picker, and the picker is active, the queries will be launched whenever:","The user clicks the data picker field on a form","The business process is auto-created","A record is created or updated through integration (both CSV and Web Services)","The data picker is updated via reverse-auto-population","In addition to setting up queries to extract records for the picker, you can configure the picker to filter the records that the query returns so that only certain records appear on the picker. This is particularly convenient, for example, if the manager attribute form contains a user data picker that automatically assigns users to an object as it is created.","To configure a data picker:","Go to the Company Workspace tab and switch to Admin mode.","In the left Navigator, select uDesigner, and then select any functional sub-node.","Open an item from the log (design object).","From the toolbar, click Open, and then select Data Picker to open the Data Picker Configuration window.","In the left pane, click the name of the data picker.","Create the query.","The query will search the database and extract the records to display on the data picker. The query will filter the records returned from the database according to a condition or conditions you specify. The condition(s) will &quot;test&quot; a field on the form to see if it passes or fails the criteria. If the field passes the criteria, Unifier will include it on the data picker.","Click the Add button. Unifier displays the Add Query Condition window.","In the Data Element field, select the field on the business process that you want to test with the condition.","For example, the condition might be that the status field on the shell must be &quot;Active.&quot;","The window expands to show an active Condition field and additional fields where you can specify the query criteria.","Note: If any field in the query or queries is subsequently removed from the Configurable Manager Attribute Form, the entire query operation will be ignored. That is, if one query fails because a field was removed from the design, the system will ignore all the queries. If a field has been removed from a design, you must amend the query.","In the Condition field, select the condition the value in the field must meet.","The remaining fields on this window vary, depending on the data element and the condition you specified. For help in completing these fields, use the information in the Queries section of the Unifier General Administration Guide to complete the query.","Repeat steps a through c to include additional query conditions.","(Optional) Filter the returned records.","This filtering option appears on Configurable Manager Attribute Forms that contain user data pickers. This option will filter the list of groups or users that appear on the picker. Use the instructions in the table below to filter the returned records.","When you have finished, click OK.","In this field:","Do this:","Filter list of Users/Groups based on Project/Shell Membership","Select this check box if you want to filter the list of users on the picker to show only those with project/shell membership.","In operation, the system will auto-populate and reverse-auto-populate the data picker with all users or groups, regardless of this check box. However, at runtime, the system will filter the picker for the user if you select this check box.","Note: If you select this option, the rest of the filtering options will be disabled.","Group Membership","Select the group from which you want to specify a user or users. The drop-down list shows all the groups that are at the company level.","Project/Shell Membership.","If you want the system to add this user to the shell membership, select the Add user to Project/Shell check box. If you want to also add this user to the group selected above in the Group Membership list, select the Add user as a member to the selected group check box.","Note: To use this option, the user data picker must be on the upper form, not the detail form.","Show results matching any condition","If the check box is selected, the query conditions will be &quot;OR.&quot; When this option is selected, the value in the AND/OR column will be updated to &quot;OR.&quot;","If the check box is deselected, the value in AND/OR column will be &quot;AND.&quot; If the check box is selected, records satisfying any of the query conditions would be displayed at run-time.","If the check box is cleared, records which satisfy all the query conditions will be displayed. ","Configure a Data Picker for the Manager","74492.htm");
Page[304]=new Array("After you have configured a configurable manager, you can create templates to use with the manager.","When you activate a new class, you must grant permission to yourself, another administrator, or a group such as company administrators to administer class templates and create classes in User mode.","You must have administrator permission to administer configurable managers.","To access permissions:","Go to the Company Workspace tab and switch to Admin mode.","In the left Navigator, select User Administration, and then select Access Control.","On the right pane, expand Administration Mode Access, expand Data Structure Setup, and select Configurable Modules.","Setting Template Administration Permissions","74493.htm");
Page[305]=new Array("You can create one or more class templates for each class for each configurable manager.","Managing Class Template Sheets (Classic view)","74494.htm");
Page[306]=new Array("You can create a new class template manually or by copying an existing template that is the same class as the new template.","To manually create a class template:","Go to the Company Workspace tab and switch to Admin mode.","In the left Navigator, select Templates, and then select Configurable Modules.","On the right pane, expand Administration Mode Access and then expand General Administration.","In the left Navigator, select the configurable manager. The templates log for the classes opens.","Click the New button. Select the class for which you want to create the new template. The Properties window opens. Complete the window as described in the following table and then click OK.","In this field:","Do this:","Title","Enter the name of the sheet, which reflects the class name and is read only.","Description","Enter an optional description.","Display Mode","Choose one of the following:","Tree: Lists the codes in a hierarchical manner based on the code segments, mimicking the tree structure in the Navigator.","Flat: Lists the codes in a flat structure.","Picker","Choose one of the following to include:","All Records: All records created in the class are displayed on the sheet.","Records with statuses: Only records of the selected status are displayed on the sheet. Click Select and choose one or more statuses from the list.","To copy an existing template:","To copy a template from the company level, select a class template from the log, click Copy, and then select Template. The Properties window opens with the information from the original template.","To copy a template from the project/shell level, click Copy, and then select Project or shell name.","Make changes as needed and click OK to save the new template.","To access configurable manager class templates:","In Admin mode, go to the Company Workspace tab, select Company, select Templates, and then select Configurable Modules.","In the left Navigator, select the configurable manager. The templates log for the classes opens.","To search for a class template:","In the class template log, click Find. You can search for the template based on the fields available on the form used for the template. These fields vary depending on the design.","Create a class template","74495.htm");
Page[307]=new Array("You can add columns to configurable manager sheet templates. You can use these columns to capture data from business processes or manually entered data. You can add columns to the template, but cannot add rows.","Users with create permission on class sheets are allowed to create and define columns.","To add a sheet column:","Open the sheet.","Click Columns. The Columns Log opens.","Click New. The Column Properties window opens. Complete the window as described in the following table.","In this field:","Do this:","Name","The Name field is populated with the data source value selected. You can change this name as desired. It is helpful, but not required, to use a unique name.","Datasource","Select a data source. You can use a data source only once; however, you can use the column in a formula. For example, if one data source is Commits (Approved), and another is Change Commits (Approved), you can add them together in a new column called Total Commits (Approved).","Entry Method","Choose the data-entry method to use for the column. The choices available depend on the data source selected. The options include:","Manual entry: Users can enter data directly into the cell, or data is rolled up from another source, such as the form.","Formula: The options are Numeric, Date Difference, and Date Add. See Add a formula column for details on adding formula columns.","Data Type: Applicable if the data source is SYS Business Process, a business process, or information from the project cost sheet. After selecting the data type, click Define to choose the data element or define a formula based on the data element.","Data Format","Specify how you want the data in numeric columns to appear.","Show as Percentage: Data displays as a percentage. For example, if a user enters 0.25, it displays as 25%.","Decimal Places: Select the number of decimal places to display.","Note: When entering the percentage values in your sheet, if you are working in Classic View, enter the value by using decimal number format. For example, for ten percent, enter: 0.1, and if you are working in Standard View, enter the value by using percent format. For example, for ten percent, enter: 10%. The value that Unifier uses to validate the value of the Percentage column, when applicable, will be: 0-100.","If the data element was defined in uDesigner with a specific decimal amount, it will override any decimal amount you specify here.","Use 1000 Separator (,): Data uses a separator for thousands. For example, 1,000 with a comma, not 1000.","Negative Number Format: Select whether negative values are displayed with a negative sign or in parentheses.","Display Mode","Select Hide to make the column invisible to users, or Show to display it.","Total","Controls what displays in the bottom summary row for each column:","Blank: The summary row remains blank.","Sum of All Rows: Displays the sum total of all row values for this column.","Use Formula Definition: Use the formula entered in the Formula field.","Column Position After","Determines the position of the column on the sheet. Select a column from the list.","To copy a column:","In the Column log, select a column and click Copy. The Column Properties window opens.","Make changes as necessary for the new column. You must change at least the data source.","Add columns to sheet templates","74496.htm");
Page[308]=new Array("You can add a formula column to the sheet for data sources that are based on either the data definitions SYS Numeric Logical Datasource or SYS Date Logical Datasource.","You can define formulas for the following types:","Numeric: This option is available if the data source is SYS Numeric Logical.","Date Difference: This option is available if the data source is SYS Numeric Logical. It is used for formulas that calculate the difference between two dates.","Date Add: This option is available if the data source is SYS Date Logical. It can be used to add values to a date to calculate a new date.","To create a Numeric formula:","In the column Properties window, choose Formula and select Numeric.","Click Create. The Create Formula window for numeric formulas opens.","Select either Item or Sheet from the data type drop-down list. Item lists data elements that are defined on the form. Sheet lists columns that are already defined on sheet.","Build a formula by doing the following:","To include a data source in the formula, select the data source from the list and click Select.","Click a mathematical modifier (plus, minus, and so on) and numbers on the keypad.","When the formula is complete, click OK.","To create a Date Difference formula:","In the column Properties window, choose Formula and choose Date Difference. Click Create. The Date Difference window opens.","For Earlier Date and Later Date, click Select. Select a data element. The list includes date type data elements from the form or existing date type columns on the sheet.","Choose one of the following:","Calculations based on Calendar Days: The calculation is based on calendar days and does not take company non-working days into account.","Calculations based on Work Days: The calculation is based on the company calendar working and non-working days.","Show Partial Day","Click OK.","To create a Date Add formula:","In the column Properties window, choose Formula and choose Data Add. Click Create. The Date Add window opens.","For the Date field, click Select and choose a data element from the list.","For the Add field, click Select and choose a data element from the list.","Choose one of the following:","Calculations based on Calendar Days: The calculation is based on calendar days and does not take company non-working days into account.","Calculations based on Work Days: The calculation is based on the company calendar working and non-working days.","Click OK.","Add a formula column","73404.htm");
Page[309]=new Array("You can copy one sheet for each project/shell template.","To copy a sheet under a project/shell template:","Go to the Company Workspace tab and switch to Admin mode.","In the left Navigator, select one of the following:","Select Templates, select Projects, and then select All or","Select Company, select Templates, select Shells, and then select the [shell].","To copy a template from the company level, select a class template from the log, click Copy, and select Template. The Properties window opens with the information from the original template.","To copy a template from the project/shell level, click Copy, and then select Project or Shell.","Make changes as needed and click OK to save the new template.","Copy sheets under project or shell templates","74497.htm");
Page[310]=new Array("This section describes how to manually delete a sheet associated with code-based or record-based Manager from a shell.","Note: You can delete a sheet associated with code-based or record-based Manager from a specific shell template but not from other Projects/Shells that have been created using the template.","Go to the Company Workspace tab and switch to Admin mode.","In the left Navigator, select Templates, select Configurable Modules, select Material Inventory Manager, and then select Sheets.","Select a sheet associated with code-based or record-based Managers.","Click the Delete icon.","When the confirmation message appears, click Yes to delete the sheet from the code-based or record-based Managers.","Deleting Sheets Template","10293658.htm");
Page[311]=new Array("The Properties window for the sheet maintains the name and display options.","To open the summary sheet Properties window:","In the Configurable Manager Sheets log, select the sheet and click the Properties button.","In this field:","Do this:","Title","This is the name of the sheet, which reflects the class name and is read-only.","Description","Enter an optional description.","Class","Read-only field that displays the class associated with the sheet.","Display Mode","Choose one of the following:","Tree: Lists the codes in a hierarchical manner based on the code segments, mimicking the tree structure in the Navigator.","Flat: Lists the codes in a flat structure.","Picker","Choose one of the following to include:","All Records: All records created in the class are displayed on the sheet.","Records with statuses: Only records of the selected status are displayed on the sheet. Click Select and choose one or more statuses from the list.","Manage sheet properties","74498.htm");
Page[312]=new Array("For details on how to view the code-based managers log, refer to the Unifier Managers User Guide.","View Code-Based Managers Log","10293339.htm");
Page[313]=new Array("For details on how to view the Code and Records-based managers log, refer to the Unifier Managers User Guide.","View Code and Records-based Managers Log","10293340.htm");
Page[314]=new Array("For users to be able to work with the configurable manager class sheet, you must set user permissions for the class sheet.","Go to the Company Workspace tab and switch to Admin mode.","In the left Navigator, select User Administration, and then select Access Control.","On the right pane, expand User Mode Access, expand Company Workspace, expand [configurable manager name], and select Class Sheets.","Setting User Permissions for Code and Records-Based Managers","74499.htm");
Page[315]=new Array("The Cost Manager consists of several modules designed to help you track and manage cost in projects/shells and across the company.","Setting Up the Cost Manager","74500.htm");
Page[316]=new Array("The Cost Manager consists of the modules and features listed below.","Cost Manager Overview","74501.htm");
Page[317]=new Array("Project/Shell cost sheet: The project/shell cost sheet is a detailed accounting of the project/shell's budget and costs. It works much like a spreadsheet within the system that calculates and maintains the project/shell cost information stored in the project/shell. The project/shell cost sheet rows contain unique CBS codes (or cost codes), which can be used to link project/shell costs to the general ledger for finance. Cost information can be entered manually, pulled from work packages or worksheets, or rolled up automatically from business processes when transactions occur.","Company cost sheet: The company administrator can create a company-level cost sheet to display cost data across projects/shells. Projects/shells on the company cost sheet are added by default as project/shell-level cost sheets are created. Only active and on-hold projects/shells should be rolled up to a company-level cost sheet. Projects/shells are listed in order by project/shell number in an ascending order. Data rolls up to the company cost sheet columns from individual project/shell cost sheet columns by data source.","Work packages: In addition to a project/shell cost sheet, multiple work packages may also be defined. A work package is a group of cost sheet rows that is a subset of the project/shell cost sheet. Work packages provide insight into the budget without providing full access to the details of the project/shell cost sheet.","Worksheets: Cost worksheets can be created to support the project/shell cost sheet. They can be used as sub-cost sheets, enabling specific calculations or data entry in a separate sheet, which can then be rolled up into a defined project/shell cost sheet column. For example, a worksheet can be used to offload complex calculations, which can be rolled up into a single cost sheet column. Worksheets support manual data entry and formulas. Business processes do not roll up to worksheets. Permissions can be controlled for individual worksheets. Worksheets are not independently reportable; however, cost sheet columns that reference worksheets can be reported on.","Cost Sheets","74502.htm");
Page[318]=new Array("Company funding sheets: The company funding sheet tracks all sources of funding across all projects/shells. You create only one sheet per company. Funding sources that are made available at project/shell sheet level are rolled up to the company sheet, which maintains the overall fund information. After it is created, the company funding sheet can be edited, but not deleted. The company funding sheet must be created before creating individual project/shell funding sheets.","Project/Shell funding sheets: The project/shell funding sheet tracks how funding is being allocated and consumed at the project/shell level. Project/shell fund sheets work in conjunction with the company funding sheet. Allocating funding sources at project/shell level can be done manually or through a business process. A funding template and company funding sheet must be complete before you can create a project/shell funding sheet.","Commitment funding sheets: You can optionally set up commitment level funding, which allows you to allocate specific project/shell funds to individual base commit records. This works in conjunction with the SOV sheet to track base and change commit lines and balances.","Funding Manager","74503.htm");
Page[319]=new Array("The Cash Flow module includes the ability to create multiple baseline, spends, forecast, and custom curves, and compare them on one cash flow worksheet. You can create data source, distribution profiles, and cash flow curve templates to simplify creation of cash flow in multiple projects/shells. Administrators can also set up base commit business processes to create cash flow curves automatically for the commitment record at a particular workflow step (or for non-workflow BPs, when the record is complete).","Cash Flow","74504.htm");
Page[320]=new Array("The earned value module provides quantitative tracking information about project/shell status using earned value analysis. It provides specific numerical measurements for reviewing progress as the project/shell team advances through the work tasks allotted to the project/shell schedule. The module helps project/shell managers track whether projects/shells are on schedule and on budget. It provides accurate and consistent methods to estimate the percent of budget spent, percent of work done, and percent of time elapsed.","Earned Value","74505.htm");
Page[321]=new Array("The schedule of values (SOV) module provides a way to assemble information from contract, change order and invoice/payment business processes into an SOV sheet, streamlining the process of invoicing for completed phases of a project/shell. SOV functionality is available with uDesigner-created cost BPs for which the Allow creation of Schedule of Values option is defined.","The business processes can be designed to create an SOV sheet automatically upon reaching the designated step.","The following are the SOV sheets types:","General Spends","Payment Applications","Summary Payment Applications","Schedule of Values (SOV) Sheet","74506.htm");
Page[322]=new Array("The Generic Cost Manager captures cost-related activities for a generic shell. These include costs like rent, lease payments, landscape care, building maintenance and repair, remodel of building interiors, and more.","With this manager, you can capture and view cost transaction information based on a timescale, such as quarterly or yearly. Each shell can have one Generic Cost Manager. The Generic Cost Manager uses specific generic cost business processes as a data source.","Generic Cost Manager","74507.htm");
Page[323]=new Array("You can group line items during auto-creation of BP records, in Lease type business process (BP). ","Go to the shell tab and switch to Admin mode.","In the left Navigator, select Setup, and then select Business Process to open the Business Processes log pane.","From the Business Processes log, select a Leases BP, for example, Leases - Tenant BP.","Select a BP record and click Open to open the Business Process Setup window.","Click the Auto Creation tab.","From the left pane, click Payment Request (or Payment Invoice).","On the right pane, select Enable grouping of line items when auto-creating records from line item tabs.","From the Group By field, click Select and proceed to select the data element, or elements, that you want from the Select Data Elements window.","When finished, click Apply, and then click OK.","Consolidating strings cannot take place if the field values are different. As a result:","If you select a data element other than &quot;Payment Type&quot; (uuu_lse_pay_type) in theGroup Byfield and the auto-created record has a different payment type across the grouped line items, the auto-created BP record will have a blank payment type.","Same logic is followed if a data element is present in the auto-created BP record, but the data element has a different value across the line items.","Grouping Line Items and Auto-Creation","10286935.htm");
Page[324]=new Array("The standard Cost Manager and the Generic Cost Manager work with different areas of the system. This table lists the areas and indicates which cost manager works with each area.","Cost Manager","Company","Shell (CBS)","Shell (Generic)","Cost Manager (standard CBS)","X","X","Generic Cost Manager","X","The cost data from Project (Standard) and Shell (CBS) can both roll up to the Company level. The cost data from Shell (Generic) does not roll up to Company Level.","Cost Managers and Unifier Functional Areas","74509.htm");
Page[325]=new Array("The cost management system supports multiple currencies and exchange rates. The functions that the system uses are exchange rates sets, effective dates, future exchange rates, base currency, project currency, transaction currency, project/shell currency options, and currency pickers. What follows are descriptions of each of these functions and how they are used.","About Currencies and Exchange Rates","74510.htm");
Page[326]=new Array("To configure currencies:","Go to the Company Workspace tab and switch to Admin mode.","In the left Navigator, select Standards &amp; Libraries, and then select Currencies.","The Currencies page is where an Administrator can manually add new currencies to suit the company business needs, in addition to the predefined list of currencies. You must have the applicable permission to access the Currencies sub-node. Depending on your permissions, you can use the Currencies log to add new, modify, and delete currencies. You can also search for a specific currency.","To view the Currencies node in the Permission tab of the User properties:","Go to the Company Workspace tab and switch to Admin mode.","In the left Navigator, select User Administration, and then select Access Control.","In the right pane, expand Administration Mode Access, expand Standards &amp; Libraries, and then select Currencies.","An Administrator can set up both users and Groups permissions to the Currencies sub-node.","A user that has the &quot;Create&quot; permission can add, modify, and view currencies.","A user that has the &quot;Modify&quot; permission can modify and view currencies.","A user that has the &quot;View&quot; permission can view currencies.","The Currencies log includes a list of predefined currencies displayed in alphabetical order. In addition:","Currency code is displayed for all the existing currencies.","If currency symbols exist, the currency symbols are populated under the Currency symbol column.","Users who have permissions can modify the predefined currencies.","Description lists all the countries that use that currency.","The Decimal Places field is read only, as it matches the decimal places used by the currency. ","Note: The number of decimal places can only be defined when a new currency is added. The number of decimal places for an existing currency cannot be edited. ","To add new currencies:","From the toolbar, click New.","In the Currency Details dialog box, enter the following:","Currency Name: (required) Enter a name in this text field (maximum of 250 characters). The Pipe character (|) and back slash (\\) are not allowed.","Currency Code: (required) Enter a code in this text field (maximum of 8 characters). The Pipe character (|) and back slash (\\) are not allowed.","Currency Symbol: Enter a symbol in this text field (maximum of 8 characters). The following characters and patterns are not allowed:","Single characters such as: . , () -","Characters such as: | ' &quot; \\","Patterns such as: $$ $&amp; $` $'","Description: Enter a description in this text field (maximum of 500 characters).","Decimal Places: Select the applicable number of decimal places, from 0 to 4.","Note: After the currency is saved, the Decimal Places field becomes read-only and cannot be changed.","To save the currency, click OK.","Validate the new currency by ensuring that the:","Currency Name is unique and does not exist in the predefined list.","Currency Code is unique and does not exist in the predefined list.","Number of characters entered in the text field does not exceed the limit.","To update a currency:","Double-click the applicable currency.","You can also select the currency and click Open.","Make the applicable changes.","After you have created a currency and defined the exchange rates for it, you can modify the Currency Name, Currency Symbol, and Description. You cannot modify the Currency Code.","To save your changes, click OK.","To add new currencies:","Select the applicable currency and click Delete.","Notes:","You cannot delete a currency that has been used to define exchange rates.","You cannot delete the Base Currency defined by your Company Administrator.","To search for a currency:","From the toolbar, click Find.","In the Find window, select the logical operator and enter the applicable search parameter in the Currency Code or Currency Name text field, or both.","Click Search.","To view the Audit Log:","Select the applicable currency.","From the View menu, select Audit Log.","The Audit Log displays the additions and modifications applied to currencies. Audits log lets you select a record to see the audit information.","Show Currency List window","The Show Currency List window, which you can see when you are defining the exchange rates, displays a list of currencies that you have defined in the Currencies sub-node. The Show Currency List window includes a Description field that lists the country name; if there are multiple countries that share the same Currency Name, the country names are listed and separated by a comma (for example, for Currency Name of Euro (EUR), the Description field lists: Andorra, Belgium, France, and so forth).","Note: If the currency name is modified, the existing exchange rate CSV template fails. You must export the exchange rate template again for the new currency name. The existing Web Services calls for record creations and updates fail if the currency names are modified.","Similar to other custom string translations the currency names can be translated for internationalization.","Base currency","The Base Currency is the default currency specified by your Company Administrator when that person signs into the system the first time. Upon creation, the Base Currency is fixed and cannot be changed. The Base Currency becomes the default currency for projects/shells; however, the default currency can be changed during project/shell creation. Company-level cost data roll-ups can draw from multiple projects/shells. Each of these projects/shells can have a different project currency.","Project currency","A Project Currency is the currency that was selected as the project/shell-level default currency during project/shell creation. This can be different from the Base Currency, and you must take the following steps before you save the new project/shell.","First: Before creating the project/shell, verify that the non-base currency exists in the Exchange Rate Set.","If it does not, you can add it.","If the exchange rate effective date is in the future, you cannot add it to the project/shell currency set.","Second: During project/shell creation, add the non-base currency to the project/shell.","Third: During project/shell creation, select the non-base currency as the project/shell default currency.","The system calculates and stores costs in the project currency. Business process records created in a non-project currency, such as a transaction currency, use the exchange rate that was active at the time of record creation for currency conversion to project currency.","Project/shell currency options","When adding a currency to a project or a shell, you have the options to float, hedge, or peg the currency rate. These options establish how to handle fluctuations in that currency's market rate.","Float: A currency's value fluctuates according to the foreign exchange market. The system updates currency exchange rates according to the effective date of the Exchange Rate set.","Hedge: Intended to reduce future risk of currency fluctuations.","Peg: The currency exchange rate is fixed. Pegging impedes project currency conversion in a project or a shell.","Role rates changes due to currency exchange rate changes only consider Float and disregard Hedged or Pegged rates.","Transaction currency","This is a currency that was added to the project/shell Currencies, and picked at run time using a currency picker on the commitment business process. Upon record creation, the system uses the current active currency exchange rate in the Exchange Rate table to convert a transaction currency to the project currency.","Cash flow curves display data in the transaction currency, if different from the project currency. At run time, users can switch between currency views, but they can only modify values in the transaction currency view.","Currency picker","Currency pickers are available only for the upper form of a cost-type commitment business processes such a contract or a change order. This means all line items will be in the record, or transaction, currency.","Currencies","10292952.htm");
Page[327]=new Array("To configure exchange rates:","Go to the Company Workspace tab and switch to Admin mode.","In the left Navigator, select Standards &amp; Libraries, and then select Exchange Rates.","The Exchange Rates page is where you can add currencies and define their exchange rates against the base currency, which was specified by your Company Administrator when that person signed into the system the first time. You can add currencies, manage currency exchange rates, and set currency effective dates as needed. Each line in the Exchange Rates log is considered a set.","Note: In addition to the predefined list of currencies, an Administrator can add new currencies to suit the company business needs.","Currency conversions use the exchange rate defined in the active Exchange Rates set. Until you modify a currency rate, the system uses the last active rate for that currency.","You can take the following actions to manage currencies:","Create a New Exchange Rates set. You can make the set active today, or you can set the effective date to a future date, or you can set the effective date in the past.","Modify an existing Exchange Rates set that has a future effective date. You can modify rates in a set until it reaches the effective date. You can change the effective date to as soon as tomorrow, but you cannot change the effective date to today. You can edit Exchange Rate Records whose effective dates are in the past.","Set an Effective date: On the chosen date, at 12:00 am system date and time&#8212;in your time zone&#8212;the effective date becomes active.","For example:","Your time zone is Munich, Germany (UTC + 1)","April 20 you add a future exchange rate and set the effective date as May 1","May 1 at 12:00 am the currency rate takes effect in Munich's time zone","April 30 at 3:00 pm the currency rate takes effect in Los Angeles' time zone","Note: Effective dates for the new exchange rates records can be set in the past.","View Exchange Rates","According to the date, it displays:","Currency Name","Currency Symbol","1.0 Base Currency","Effective Date","Future currency exchange rates","Future exchange rates let you plan ahead for currency fluctuations. The system uses the active exchange rate based on the effective date; however, cash flow curves show currency rate changes at the beginning of the first full month the rate is in effect.","In the Baseline details example that follows, you can see differences in values due to future exchange rate conversions.","The transaction currency is INR.","The project currency is EUR.","The distribution is linear.","The distributed values are 37,000 INR per time period.","May and June rates take effect on the first of the month, respectively.","A July future exchange rate takes effect in Unifier on 07/02/2012, so the system continues to display the value of the June rate in the cash flow.","The August rate shows up in the cash flow curve on 08/01/2012. ","Additional information","For cost transactions used in a Derived Curve, the exchange rate used is based on the latest update date of the BP record.","The uuu_effective_date is not used for determining the rate to be used on a BP Record.","Exchange Rates","10292953.htm");
Page[328]=new Array("The exchange rate set defines the currencies that are available for use within the system and their corresponding exchange rates, which are based on the company base currency. The exchange rate set that is currently active in the system will display a status of Active. All previous sets are retained, so you can view the currencies and rates that were active in the system in the past. Future currency rates are also listed in the log.","To view the company base currency:","Go to the Company Workspace tab and switch to Admin mode.","In the left Navigator, select Standards &amp; Libraries, and then select Exchange Rates. The Exchange Rates log opens, displaying the following information:","Effective Date: This is the date the base currency and its associated exchange rates became active. If you have not yet created an exchange rate set, there will be one default listed in the log, created by the Site Administrator.","Base Currency: This is the base currency used by the company.","Created By: This field identifies the user who created or modified the exchange rate set.","Status: The status indicates which set is active. Only one exchange rate set can be active at a time. View currencies and exchange rates (exchange rate set).","To view an exchange rate set:","Go to the Company Workspace tab and switch to Admin mode.","In the left Navigator, select Standards &amp; Libraries, and then select Exchange Rates. The Exchange Rates log opens.","Select a set from the list and click Open (or double-click the selection). The Edit Currency window opens, displaying the list of available currencies and their exchange rates.","Add a currency to the exchange rates","To add additional currencies, you must create a new exchange rate set. Existing exchange rate sets can be modified until the effective date is reached and that set becomes active. Old sets are inactivated and saved for archival purposes. You can add as many sets as you like, if each set uses a unique effective date.","To add a currency to the exchange rate set:","Go to the Company Workspace tab and switch to Admin mode.","In the left Navigator, select Standards &amp; Libraries, and then select Exchange Rates. The Exchange Rates log opens.","Click New. The Edit Currency window opens. The Co. Currency tab of the window displays all currencies that were added in previous exchange rates sets.","The Base Currency field is fixed.","In the Effective Date field, you can select a future effective date, or a past effective date, for any exchange rate in the exchange rate set.","Click Add. The Edit Exchange Rate window opens.","In the Currency Name field select a currency from the currency list.","In the Rate field, enter the exchange rate multiplier to convert the new rate to the company base rate. For example, if the base currency is United States Dollar (USD), and you are adding Euro (EUR), then the exchange rate is the number of EUR in $1 USD; that could look like 0.76 = $1, so in this case you would enter .76.","Click the date icon in the Effective Date field, and select the date this exchange rate set becomes effective.","If you do not select an effective date, the system uses 12:00 am local time (tomorrow morning) as the effective date.","If the effective date is in the future, the current exchange rate set remains active until the effective date of the new exchange rate set.","The future exchange rate set remains editable until the effective date is reached.","Before you save the exchange rate set, you can remove a currency that you just added. After the exchange rate set is saved, you cannot remove that currency and the system will carry forward that currency in any new currency exchange rate sets.","You can create new exchange rates records for effective dates in the past.","These past dated exchange rates can only be used to define Derived Curves within Cash Flow, in Schedule Manager and for EVA calculations.","Existing cost transactions in the system will not get updated on creation of new Exchange rate records with historical effective dates.","Click OK to save the exchange rate set.","To modify an exchange rate:","Go to the Company Workspace tab and switch to Admin mode.","In the left Navigator, select Standards &amp; Libraries, and then select Exchange Rates. The Exchange Rates log opens.","Click New. The Edit Currency window opens.","Select a currency from the list and click Modify. The Edit Exchange Rate window opens.","Enter the new rate and click OK.","Enter the Effective Date. The effective date defaults to 12:00 am local time tomorrow morning.","If you want the rate to take effect immediately, you can enter today's date.","You can enter a future effective date, and the current exchange rate set remains active until the effective date.","Click OK to save and exit the Edit Currency window.","Note: You can edit the Exchange Rates defined in existing Exchange rate records (open an existing record to open the Edit Currency window).","To copy an exchange rate set:","Go to the Company Workspace tab and switch to Admin mode.","In the left Navigator, select Standards &amp; Libraries, and then select Exchange Rates. The Exchange Rates log opens.","Select an exchange rate set.","Click the Copy button. The Edit Currency window opens.","From here you can:","Add additional currencies.","Modify exchange rates.","Set an effective date for the exchange rate set.","Click OK to save and exit the Edit Currency window.","Managing Currencies and Exchange Rates","74511.htm");
Page[329]=new Array("You can create and update exchange rates through a CSV file. For example, you can import the exchange rates you are using in your enterprise resource planning (ERP) system into the system so that the rates match in both systems.","You can import exchange rates with a CSV file by doing the following:","Export a copy of the CSV file structure.","Populate the CSV file with currency rate information.","Import the CSV file into the system.","To export a copy of the CSV file structure:","Go to the Company Workspace tab and switch to Admin mode.","In the left Navigator, select Standards &amp; Libraries, and then select Exchange Rates.","From the toolbar, click Export. ","Depending on your browser, the CSV file will be automatically downloaded or you will be prompted to download the file manually.","To populate the CSV file with exchange rate information:","Open Microsoft Excel (or another program compatible with the CSV format), and open the exported CSV file.","Enter currency exchange rate information in the spreadsheet. The fields are discussed in the table below.","Notes:","Do not delete or change the order of the columns.","Successful import creates a currency exchange rate set with the Active status.","Only the currency code is validated, but the system will add to the exchange rate set the values you specify in the CSV upload file.","Only the absolute value for the exchange rate is considered. If you enter a negative value, the negative sign is dropped and only the value is considered.","You can enter new rates, or update existing rates.","Only the first five decimal values of the exchange rate are imported; if less than five decimal values are entered, zeros are added during the import to add up to five values.","If you remove an exchange rate from the CSV file, the rate is retained in the system, and is not deleted.","If there are errors in the CSV file, the system will not import the CSV file.","Save in CSV format.","In this column:","Do this:","Currency Name","Enter the name of the currency. For example, United States Dollar. This currency name is not validated and is for reference only.","Currency Code","Enter a valid currency code. Only the Currency Code is required and validated.","1.0 Base Currency =","Enter the exchange rate for the currency. The number you enter rounds at ten decimal places. Enter numbers and decimal points only; do not enter special characters.","To import the CSV file:","Go to the Company Workspace tab and switch to Admin mode.","In the left Navigator, select Standards &amp; Libraries, and then select Exchange Rates.","From the toolbar, click Import to import the completed CSV file.","Click Browse and navigate to where you saved the file.","Click OK to import.","Only files with exchange rate information in the correct format will be imported. If the upload fails, the CSV file will contain an error message that explains why the upload failed. The user who imported the CSV file is listed in the Audit log as the User.","To fix import errors:","Re-open the CSV file.","Delete rows that were successfully imported.","Fix the rows that were not imported correctly.","Re-import the file.","To export exchange rates to your desktop:","Go to the Company Workspace tab and switch to Admin mode.","In the left Navigator, select Standards &amp; Libraries, and then select Exchange Rates.","From the toolbar, click Export. ","Depending on your browser, the CSV file will be automatically downloaded or you will be prompted to download the file manually.","Importing and Exporting Exchange Rates","74512.htm");
Page[330]=new Array("The following is provided as a reference for creating, setting up and managing the Cost Sheet portion of the Cost Manager.","Setting Up Cost Sheets","74513.htm");
Page[331]=new Array("Before you begin: Ensure that currencies and exchange rates have been set up. Verify that all Cost Codes have been added or imported. Before you can create the Cost Template, you must create the necessary Cost Codes Data Definition(s) which will be used to build your CBS Codes. CBS Cost Codes can be single or multi segment codes. See Importing and Exporting Exchange Rates, Add a Basic Data Definition.","Step 1: Design and deploy the cost attribute form. After it is deployed, the cost attribute form becomes the CBS Detail window, used to create and manage CBS codes in the project/shell cost sheet. This is an optional step. If you do not create a cost attribute, a default form will be used to create CBS codes. (See Importing the Cost Attribute Form.) ","Step 2: Configure permissions. (Refer to the Unifier Data Reference Guide for cost manager permission settings.)","Step 3: Create a cost sheet template. You must create at least one cost template before you can create cost sheets. You can use the template to create project/shell cost sheets, or a cost sheet within a project/shell template. You can add columns to the template, which can be used to capture transaction data from cost business processes, create formulas, manage the budget, manually enter data, link to the funding manager, and much more. You can create the CBS codes in the template, which are the rows on the sheet. You can also set up columns and rows on individual cost sheets, following the same procedures.","Step 4: Create a project/shell cost sheet. You can create a cost sheet directly in the project/shell, or in a project/shell template (when you create projects/shells from the template, you can include the cost sheet). (See Creating a Project or Shell Cost Sheet.)","Step 5: Define the project/shell budget. After creating the project/shell cost sheet, you can distribute the budget. This is done in User mode.","Optional steps:","Create work packages. This is done in user mode.","Create worksheets. Worksheets can be used as mini-cost sheets, linked to project/shell cost sheet columns. You create a worksheet template first. (See Creating Worksheet Templates.)","Create company cost sheets. This is optional. The company cost sheets are used to summarize project data. You can configure these sheets to display specific data by adding or removing desired columns. The rows correspond to each individual project cost sheet. The company-level cost sheet summarizes project data across the company. The company cost sheet can also be mapped to company level account codes, which can allow you to link project CBS codes with company level account codes. (See Setting Up the Company Cost Sheet.)","Design and deploy cost business processes. Use these to enable transactions against the cost sheet.","Set up a company accounts sheet. (See Setting Up a Company Accounts Sheet)","Set up SOV. (See Setting Up Schedule of Values (SOV))","Set up Funding. (See Setting Up the Funding Manager)","Set up Rules. (See Setting Up the Rules Engine)","How to Set Up the Cost Manager (Cost Sheets)","74514.htm");
Page[332]=new Array("A Cost Attribute Form (created in uDesigner) is used as the CBS Detail window. The CBS Details window is used to create rows (CBS Codes) to project/shell cost sheets.","You can have only one Cost Attribute Form per company, which will be used for CBS Details window across all projects/shells.","To import and deploy a Cost Attribute Form into Unifier Production environment, see Importing Configuration Packages.","Importing the Cost Attribute Form","74515.htm");
Page[333]=new Array("Refer to the Unifier Data Reference Guide for cost manager permission settings.","Configuring Cost Manager Permissions","74516.htm");
Page[334]=new Array("To access cost sheet templates at the Company level:","Go to the Company Workspace tab and switch to Admin mode.","In the left Navigator, select Templates, and then select Cost Sheets to open the Cost Templates log.","You can use this log (Create) to create a Cost Sheet or Worksheet.","Cost Sheet Template at Company Level","10294081.htm");
Page[335]=new Array("The following procedure describes how to create a cost sheet template at the Company level, from the Company Workspace tab.","To create the cost sheet template:","Go to the Company Workspace tab and switch to Admin mode.","In the left Navigator, select Templates, and then select Cost Sheets to open the Cost Templates log.","Click Create and select Cost Sheet. to open the Create Cost Sheet Template window.","Enter the needed information in the fields under the following blocks:","General block","Defines general properties of the template:","Enter a unique Name, which is used to identify the template in the log and when creating a project/shell cost sheet from the template. When you create a cost sheet from the template, the title will default to Project Cost Sheet and will not be editable.","Enter the CBS Code title that your company uses. For example, Account Code, Cost Code, or CBS Code.","Enter the CBS label that your company uses. For example, CBS Item, Cost Item, or Account Description.","You can select a Default View for the template. This can be edited in the Project Cost Sheet. For details, see Define Cost Sheet Default View (General tab).","Structure block","Defines the structure of the CBS Codes (or Cost Codes) for use within the cost sheet. This remains editable in cost templates, but after it is set in a project/shell cost sheet, it cannot be changed as this tab defines the CBS Code structure for the project/shell.","Options block","Defines labels for the two default columns, and details on forecast handling. For details, see Define Cost Sheet Options at Shell Level.","Click Save.","The cost template that you create appears in the Cost Templates log. After creating the cost sheet template, you must open the sheet to add columns and rows.","To open the cost sheet template:","Go to the Company Workspace tab and switch to Admin mode.","In the left Navigator, select Templates, and then select Cost Sheets to open the Cost Templates log.","Select a template and open it either by double-clicking it, or by way of the gear menu ( @ ).","Create a Cost Sheet Template at Company Level","74518.htm");
Page[336]=new Array("The cost sheet default view refers to how the cost sheet appears when it is first opened.","To define the general properties of the template::","Enter values in the following fields:","Name","Enter a unique name. This field is used to identify the template in the log and when creating a project/shell cost sheet from the template. When you create a cost sheet from the template, the title will default to Project Cost Sheet and will not be editable.","CBS Code Label (no more than 32 characters)","Enter the CBS Code title that your company uses. For example, Account Code, Cost Code, or CBS Code.","CBS Item Label (no more than 32 characters)","Enter the CBS label that your company uses. For example, CBS Item, Cost Item, or Account Description.","The labels determine how the CBS code columns will be labeled, according to your company conventions.","Note: If you will be importing cost sheet data, it is important that the column labels match those in the import files.","To define the cost column labels:","In the cost template Properties tab, go to the General Block.","Enter new labels for the CBS Code Label and CBS Item Label columns.","Click Save to save changes.","Note: You can also define the forecast (Forecast block) behavior for the sheet as well as enabling P6 as a source (P6 Integration block) in the Options block. You must select Tree as the structure of the new cost sheet template when it is enabled for P6 integration.","Define Cost Sheet Default View (General Block) at Company Level","10294083.htm");
Page[337]=new Array("You can define the structure of the cost codes used in the sheet, in the Structure block. The cost codes that are built from this structure are used throughout the project/shell, for example, in cost type business processes for cost transactions.","For an existing template, you can edit the cost template properties, rows, and columns, in the Structure block. You can also add default data to direct entry cells which can be copied to cost sheets created from the template. The following procedure describes how to edit a cost sheet template from the Company Workspace tab.","This structure remains editable in cost templates, which lets you make adjustments to the structure as needed. In project/shell cost sheets, after the structure has been defined, it cannot be edited.","The Structure block has the following elements:","Structure","This defines the structure of the CBS Code rows and how they will appear on the cost template and sheets. Choose Flat (no indenting of rows) or Tree (allows indented, nested rows, and summary).","Flat","If you choose Flat, the cost sheet will display the CBS codes (rows) in a flat structure, with no indented rows. This is useful if you want to display all CBS codes at once.","Tree","If you choose Tree, you have the option of creating indented, nested rows, which can be collapsed into summary, or grouping, rows. This is useful if you will be creating a large number of rows that can be grouped into categories.","Sort CBS","If you select the Sort CBS check box, the rows will be sorted in ascending order by CBS Code automatically when new cost codes are added (flat structure only).","The summary rows act only as grouping rows for their indented child, or leaf, rows. Data cannot be entered directly into a summary row.","Segment Preview","Segment 1","...","Segment 10","Determine how many segments to use for cost codes. For example, your company may have a three-segment CBS code based on numerical values. You may have as little as one segment (each cost code is a single entity), or as many as 10. For Segment 1, click the drop-down (pull-down) menu and choose the first segment.","The available segments correspond to the list of Cost Code Data Definitions. To view the list of definitions, go to the Company Workspace tab and switch to Admin mode; in the left Navigator, select Data Structure Setup, select Data Definitions, and then select Cost Codes. The Cost Code Data Definitions page appears.","This is where you build the CBS codes (or &quot;account&quot; codes) that will be used for the cost sheet rows. CBS codes may consist of one or multiple (up to 10) segments. Each segment consists of a separate cost code data definition, as defined on the Cost Code Data Definitions page. You must define at least one segment.","Select one or more segments, up to 10, in the order (left to right) you want them to appear in the Cost Sheet rows.","Repeat the previous step for each additional segment you want to add.","Define Cost Code Structure (Structure Block) at Company Level","10294091.htm");
Page[338]=new Array("Under the Options block, you can set the following options for the cost sheet template:","Forecast Details","User Line Items","Transactions","Forecast Inclusion","Manual","Auto","Enable Cost Sheet Forecasting","Enable p6 sources","For the Forecast Details and Forecast Inclusion options, specify the configuration for managing the Forecast column of the Cost Sheet. User Line Items/Manual is the default configuration; the following are the configuration options:","User Line Items and Manual: At any time, the cost sheet user can add, edit, or delete Line Items in the Cell Detail Window of the Project or Shell Cost Sheet for the Yet to Buy/Allowance For Change (YTB/AFC) column. The user has to manually choose which commits are included in the forecast. Options for choices are:","Auto-adjust YTB/AFC: For example, if you include a Commit for $100 in Forecast, $100 is automatically deducted from YTB","Manually adjust YTB/AFC","Make no change to YTB/AFC","User Line Items and Auto: Do not use this combination. This scenario will automatically inflate the Forecast due to the manual adjustment of Yet To Buy (YTB).","Transactions and Auto: Note the following:","Commits (for example, Base Contract, Change Order, Purchase Requisition) are automatically updated with changes to the Forecast, depending on the formula.","Adjustments are automatically included in the Forecast column upon approval as defined by the workflow.","Transactions and Manual: Line Items can be added to the Cell Detail window of the Project or Shell Cost Sheet. No deletions or modifications can occur on existing line items. The user has to manually choose which commits are included in the forecast. Options for choices are:","Auto-adjust YTB/AFC: For example, if you include a Commit for $100 in Forecast, $100 is automatically deducted from YTB","Manually adjust YTB/AFC","Make no change to YTB/AFC","To define the cost forecast details and inclusion:","In the cost Properties windows, click the Options tab.","Complete the forecast details fields as described above.","Click Save when finished.","For the P6 Integration, the Enable P6 sources allows you to enable the Cost Sheet Template in Unifier to acquire data from the P6 Summary Sheets. ","If you select this option, you must select Tree for the Cost Sheet Structure.","The Data Format in Cost Sheet Template Column &quot;Properties&quot; window shows has the &quot;Decimal&quot; option.","Define Cost Sheet Options (Options Block) at Company Level","10294089.htm");
Page[339]=new Array("Cost columns specify the data sources (business process transactions, formulas, values entered manually, and so on) that will be displayed on the cost sheet. Default columns are the CBS Code and CBS Item. Cost columns can be added to cost templates, to project/shell-level and company-level cost sheets, and to worksheets. ","These procedures apply to adding columns to a Cost Sheet, a Cost Sheet template, or a Worksheet template at the following levels:","Project or Shell","Company","Cost Sheet columns can be of the following types:","From Business Process: Data is rolled up automatically from cost type business processes when the BP reaches the specified status (Business process transaction column).","Direct Entry: Users can enter data directly to the sheet through line item or direct entries. Custom data sources can be applied to these columns to allow project/shell cost data to roll up to company cost sheets, and be reportable through user-defined reports (Manual entry column).","Line Item Content","From Worksheet","From Activity Sheet","Formula: The column values are calculated based on a formula that normally includes values from other columns. For example, if there are multiple cost type business processes affecting the sheet, you may want to have a column that shows the sum of all of them (&quot;Total Commits&quot;). Custom data sources can be applied to these columns to enable them to roll up to company cost sheets, and be reportable (Formula column). Formula-based columns that are based on BPs are not automatically updated if you change the name of the BP. For example, if your Project Cost Sheet includes a column such as Contract &amp; PO that displays Agreement (Approved) + Change Order &#8211; Contract (Approved) when you hover over the column heading and you subsequently update the BP name from Change Order - Contract to Change Order, the information displayed in the hover label is not updated. To update the hover label, you can right-click the column name, select Properties, click Select in the Formula section, and make the applicable changes. You can also update the cost sheet template and use the Update Shells feature to update the applicable projects/shells.","Fund: Provides additional functionality to work with the Funding sheet. For more information, see Add a Funding Column to Project or Shell Cost Sheet (Fund column).","SOV: Provides additional functionality to work with Schedule of Value sheets.","In a Cost Sheet:","If you set the format for the Total field as &quot;Blank&quot; in the column properties, the user will see a blank value for the Summary of All Rows (under the parent CBS Codes), and","If the user exports the Summary Sheet by way of a CSV file, the exported CSV file will also include a blank value for the Summary of All Rows.","Cost Sheet Columns at Company Level","10294094.htm");
Page[340]=new Array("This general procedure can be used for adding columns is the same whether you are adding columns to a cost sheet (project/shell or company level), a cost sheet template, or a worksheet.","Go to the Company Workspace tab and switch to Admin mode.","In the left Navigator, select Templates, and then select Cost Sheets to open the Cost Templates log.","Select a cost template from the log.","Click the gear menu ( @ ) next to the cost template and click open.","From the toolbar, click Add Column ( @ ) to open the New Column dialog box.","Complete the fields as described below.","Click:","Cancel to discard your changes","Save to save your changes","Save &amp; Add New to save your changes and begin to add a new column.","In this field:","Do this:","Name","The name you choose will appear as the column header on the Project or Shell Cost Sheet. If you leave the Name field blank, the selection you make in the Datasource field will automatically populate the Name field.","Type","Cost Sheet columns can be of the following types:","From Business Process: Data is rolled up automatically from cost type business processes when the BP reaches the specified status (Business process transaction column).","Direct Entry: Users can enter data directly to the sheet through line item or direct entries. Custom data sources can be applied to these columns to allow project/shell cost data to roll up to company cost sheets, and be reportable through user-defined reports (Manual entry column).","Line Item Content","From Worksheet","From Activity Sheet","Formula: The column values are calculated based on a formula that normally includes values from other columns. For example, if there are multiple cost type business processes affecting the sheet, you may want to have a column that shows the sum of all of them (&quot;Total Commits&quot;). Custom data sources can be applied to these columns to enable them to roll up to company cost sheets, and be reportable (Formula column).","Datasource","All columns must be associated with a data source. The data source that you choose will determine which of the following options are available. The types of Data sources available are:","Single Sources: These values roll up from other sources. These include cost type business processes, some predefined cost columns.","Logical Sources: Choose one to create Manual Entry or Formula columns.","P6 Sources: To select the P6 Summary Sheet from which cost should role up.","See Project or shell Cost Sheet Column Data Sources. ","Data Format","Currency: Right-aligns column contents and includes a currency symbol, formatting the value to the specified currency for the sheet.","Percentage: Right-aligns the contents and includes a percentage symbol","Decimal: Right-aligns column contents and presents the value for the column as a Decimal (with two decimal digits). The prefix of currency symbol, or the suffix of percent symbol, does not appear in columns with a Decimal data format.","Display Mode","Refers to whether the column is displayed on the cost sheet.","Show: This is the default choice. This indicates that column will display by default on the cost sheet to all users with at least &quot;view&quot; permission for the cost sheet.","Hide: Hidden columns are active but not displayed on the cost sheet. Hidden columns can be accessed by users with &quot;create&quot; permission on the cost sheet.","Total","Determines what will display in the &quot;Total&quot; (bottom) row for the column:","Blank: The total of this column is not applicable and will not display on the cost sheet. Choose this column for percentage columns and other columns where it does not make sense to display the sum total.","Sum of All Rows: The sum total of the column values is displayed.","Use Formula Definition: For formula columns; the formula will be applied to the &quot;Total&quot; row in the same way it is applied to other rows in the column.","Column Position After","The new column will be inserted after the column selected.","Add a Cost Sheet Column at Company Level","10294095.htm");
Page[341]=new Array("This procedure addresses how to create a formula column for use on a cost sheet. (The general procedure also applies to cost sheet templates and work sheets.)","When creating a cost sheet column, selecting a logical data source lets you build a formula in which you can include:","Other columns from this cost sheet","Single data sources, such as business processes in a certain status","Total elements, such as the tallied value of a column","Data elements from single-record, non-workflow business processes","If you are creating a formula for forecasts (unaccepted), data sources are limited to business processes flagged in uDesigner for cost sheet forecasting. For example, if base commits and change commits were enabled for cost sheet forecasting, you will see base commits (unaccepted) and change commits (unaccepted) as available data sources for use in the forecasts (unaccepted) formula. You will not see other data sources that were not flagged in uDesigner for this purpose. ","When you build your formula, think about which data sources will generate the result you want in your cost sheet column. For example, if you want to see total commitments, you can add contracts (approved) and change orders (approved).","Notes:","Use care when selecting the Cost Column that you use to build your formula. You can possibly choose from Columns (columns in the sheet), Data Sources (values of business processes), Total Elements (totals from columns), or Data Elements (data elements on Information/General record(s), typically named Project Information). The source column that you use can affect the data values in your cost sheet. If you select an incorrect source, you can get a result you do not expect. Be sure that you know the source to use before you build your formula.","Formula-based columns display a label when you hover over the column name to show what comprises the contents of the column. Formulas that are based on BPs are not automatically updated if you subsequently change the name of the BP. To update the hover label, you can right-click the column name, select Properties, click Select in the Formula section, and make the applicable changes. You can also update the cost sheet template and use the Update Shells feature to update the applicable projects/shells.","To create a formula:","Go to the Company Workspace tab and switch to Admin mode.","In the left Navigator, select Templates, and then select Cost Sheets to open the Cost Templates log.","Open the applicable cost sheet template.","From the toolbar, click Add Column ( @ ).","In the New Column dialog box, choose Formula as the type, select a Datasource, and then click the Select button in the Formula field.","Enter the first value in the formula:","To enter numerical values into the formula, click the number keys on the on-screen keypad. (Include parentheses, % or decimal point as necessary.)","To add a data element or column value (existing columns on the sheet you are working on) into the formula, double-click an item from the left pane.","As you build the formula, it appears in the Formula box in the upper portion of the window.","Click the appropriate operator: add, subtract, multiply, or divide.","Continue to alternate between choosing values and operators to add to the formula.","Note: The system applies the operators in the order of proper mathematical procedure: from left to right, with multiplication and division first, followed by addition and subtraction.","To undo (reverse) the last action, click Undo; to clear the entire formula, click Clear All.","When the formula is complete, click Save to save your formula and return to the Column Properties window.","Create a Formula in a Cost Sheet Column","74528.htm");
Page[342]=new Array("A user wants to create a &quot;Yet To Buy&quot; column that calculates 7% of the Assigned Budget column. To create this formula using the keypad in the Formula Creation window:","Click 7 and then click the percent % key. The value is displayed as 7/100.","Click the multiplier X.","Select Assigned Budget from the Cost Column pane on the left, and then click Select.","The final formula looks like this: 7/100 * Assigned Budget","Example Formula","74529.htm");
Page[343]=new Array("Project/shell cost sheets are created by copying from a cost sheet template or from an existing project/shell cost sheet in another project/shell; therefore, when you first set up the cost manager, you must start with at least one cost template that you can use to create a project/shell cost sheet (or cost sheet in a project/shell template).","To access cost sheet templates at the shell level:","Go to the Company Workspace tab and switch to Admin mode.","In the left Navigator, select Templates, select Shells, select Projects, and then open the [shell template].","In the left Navigator, select Cost Manager, and then select Cost Sheet to open the Cost Sheet log.","You can only use this log (Create) to create Worksheet with the following options:","From Template","From Projects","You cannot create a project cost sheet.","Get Data","If the activity data is integrated by way of old Get Data synchronization (by adding P6 project ID in shell details, General tab), the activity data will not roll up from the Activity Sheet to the Cost Sheet columns.","If the activity data is integrated by way of old (or new) Get Data synchronization (by adding P6 project ID in shell details, Integration tab), the activity data will roll up from the Activity Sheet to the Cost Sheet columns.","Cost Sheet Template at Shell Level","10294082.htm");
Page[344]=new Array("You cannot create a project cost sheet template at shell level; however, a Cost Sheet is created by copying from a cost template or another project/shell cost sheet. See Creating a Project or Shell Cost Sheet for details.","Create a Cost Sheet Template at Shell Level","10294084.htm");
Page[345]=new Array("To view the cost sheet properties for Shells:","Go to the Company Workspace tab and switch to Admin mode.","In the left Navigator, select Templates, select Shells, and then select Projects.","Open the applicable project template.","In the left Navigator, select Cost Manager, and then select Cost Sheet to open the Cost Sheet log.","Open a template.","Click Menu Options and select Properties. ","View Cost Sheet Properties at Shell Level","10294085.htm");
Page[346]=new Array("In the cost sheet template at the shell level Properties window, you can only define the P6 Integration option by enabling P6 as source (Enable P6 sources). This option allows you to enable the Cost Sheet Template in Unifier to acquire data from the P6 Summary Sheets. You can select this option only if Tree is selected as the Cost Sheet Structure, at the Company level (cost sheet template). ","The Properties window at shell level has the following fields and the options that are selected are based on the selection at the Company level (cost sheet template):","Name","Structure","Segments","CBS Code Label","CBS Item Label","Forecast Details","Forecast Inclusion","Enable Cost Sheet Forecasting","Enable P6 sources","Define Cost Sheet Options at Shell Level","10294090.htm");
Page[347]=new Array("Cost columns specify the data sources (business process transactions, formulas, values entered manually, and so on) that will be displayed on the cost sheet. Default columns are the CBS Code and CBS Item. Cost columns can be added to cost templates, to project/shell-level and company-level cost sheets, and to worksheets.","These procedures apply to adding columns to a Cost Sheet, a Cost Sheet template, or a Worksheet template at the following levels:","Project or Shell","Company","Cost Sheet columns can be of the following types:","From Business Process: Data is rolled up automatically from cost type business processes when the BP reaches the specified status (Business process transaction column).","Direct Entry: Users can enter data directly to the sheet through line item or direct entries. Custom data sources can be applied to these columns to allow project/shell cost data to roll up to company cost sheets, and be reportable through user-defined reports (Manual entry column).","Line Item Content","From Worksheet","From Activity Sheet","Formula: The column values are calculated based on a formula that normally includes values from other columns. For example, if there are multiple cost type business processes affecting the sheet, you may want to have a column that shows the sum of all of them (&quot;Total Commits&quot;). Custom data sources can be applied to these columns to enable them to roll up to company cost sheets, and be reportable (Formula column). Formula-based columns that are based on BPs are not automatically updated if you change the name of the BP. For example, if your Project Cost Sheet includes a column such as Contract &amp; PO that displays Agreement (Approved) + Change Order &#8211; Contract (Approved) when you hover over the column heading and you subsequently update the BP name from Change Order - Contract to Change Order, the information displayed in the hover label is not updated. To update the hover label, you can right-click the column name, select Properties, click Select in the Formula section, and make the applicable changes. You can also update the cost sheet template and use the Update Shells feature to update the applicable projects/shells.","Fund: Provides additional functionality to work with the Funding sheet. For more information, see Add a Funding Column to Project or Shell Cost Sheet (Fund column).","SOV: Provides additional functionality to work with Schedule of Value sheets.","In a Cost Sheet:","If you set the format for the Total field as &quot;Blank&quot; in the column properties, the user will see a blank value for the Summary of All Rows (under the parent CBS Codes), and","If the user exports the Summary Sheet by way of a CSV file, the exported CSV file will also include a blank value for the Summary of All Rows.","Cost Sheet Columns at Shell Level","10294093.htm");
Page[348]=new Array("You can define multiple views for a Cost Sheet template and link them to all or specific projects/shells so that they are listed in the View menu. You can update these views at any time and link them to all or specific projects/shells as the need arises. While these views cannot be changed by the users, they can use them as the basis for creating their own views.","Note: To determine what template to use, the system first checks the Shell Detail form to see whether a value for the uuu_shell_template_picker data element (DE) is defined. If the DE is not populated or is not used, the system checks to see whether a default template is specified. If so, the views associated with the default template are included.","To define a Cost Sheet View for a template:","Go to the Company Workspace tab and switch to Admin mode.","In the left Navigator, select Templates, select Shells, and then select Projects.","In the Projects Templates log, select and open the applicable project.","In the left Navigator, select Cost Manager, and then select Cost Sheet.","In the Cost Sheet log, select and open the cost sheet.","From the View menu, select Create New View.","In the Save View As field of the New View window, enter a name for the new view.","Use the following topics to complete the available tabs:","Columns Tab in the New View Window","Filters Tab in the New View Window","Group By Tab in the New View Window","Sort By Tab in the New View Window","Conditional Formatting Tab in the New View Window","When you are done, click Save.","Use Manage Views to select the views that should be visible in the template after you import a configuration package.","For more information, see Managing Cost Sheet Views.","Defining Cost Sheet Views for Inclusion in Templates","10317712.htm");
Page[349]=new Array("The sections under the Columns tab are: Available Columns, Selected Columns, Left Lock after Column, and Right Lock after Column.","In addition to the previous sections, there are three options located after the Selected Columns section: Group Management, Group Selected Columns, and Delete Group.","For a new view, the Available Columns section displays a list of all the columns from the Default view. Cost Code and Cost Name columns are not available in the list because they are part of all views by default. The columns that you have view restrictions for are also not available in the list.","The Cost columns listed under Available Column are grouped as CBS Attributes and Sheet Columns.","The CBS Attributes block items are sorted alphabetically.","In the case of a new view, the list in the Selected Columns section contains the Cost Code and Cost Name columns. You can select one or more columns from the Available Columns list and move those columns to the Selected Columns list.","Note: If you select Save without choosing a column from the Available Columns list, a view with Cost Code and Cost Name columns is created.","When you select multiple columns in the Selected Columns list and then select the Group Selected Columns option, you are prompted to enter a name for the new column group. The maximum character limit for a group name is 255 characters.","You can click two or more selected columns and group them under a new name, or you can create a column group first and then add columns to it.","The groups:","Display with a distinct color in custom views.","Only exist within the view in which they were created.","You cannot create a group just once and then use it within multiple views.","Upon choosing the Group Management option, a new window that shows the created groups as tabs is displayed. You can update the Group Title for each group, but know that the Group Title is a required field. Along with the lists of Available Columns and Selected Columns in the Group, there are also two check boxes. You can select the Show last column when group collapsed check box as well as the Collapse group by default check box.","The Available Columns list displays the columns that exist in the default view of the cost sheet. One or more columns can be selected from the Available Columns list and moved to the Selected Columns in the Group list. Columns that are part of another group are italicized. Each group must contain at least one column, as empty groups are not retained. You can re-order the columns in a group by selecting any of the arrow options.","After you create a group, the group is displayed in the Selected Columns section of the previous window with a Column Tree icon and the group name. This group name contains a hyperlink that takes you to the Group Management window and selects the previously selected column.","All changes are saved upon selecting the Save option.","If you choose a column in the Left Lock after column drop-down list, the list for Right Lock after column displays the remaining columns and, if applicable, any groups that you created, from the Selected Columns list. For example, if there are 20 columns in the Selected Columns list and you choose column 4 in Left Lock after column, Right Lock after column displays columns 4-19. Another scenario is if you select column 19 in Left Lock after column, Right Lock after column displays column 19.","The Left Lock after column drop-down list initially displays every column from the Selected Columns list, except for the last column and any groups that you created. None is selected in the drop-down list by default. When None is the value in the drop-down list, it means that no column has been chosen to be locked from the left side of the sheet.","For the Right lock after column drop-down list, None is selected by default. When None is the value in the drop-down list, it means that a right lock column has not been chosen for the view. The remaining values in the drop-down list consist of a dynamic list that gets populated based on the value chosen in the Left Lock after column drop-down list.","Columns Tab in the New View Window","10301855.htm");
Page[350]=new Array("For both Tree and Flat Structure cost sheets, there are three sections in the Data Element drop-down list on the Filters tab: Cost Code segments, CBS Attributes, and Sheet Columns. The Cost Code segments section displays each cost code segment as an attribute that can be used to apply filters to the cost sheet. The CBS Attributes section displays all &#8220;uuu&#8221; data elements (DEs), including hidden blocks but excluding Data Picker DEs and Multi Select DEs, defined for the cost breakdown structure (CBS) Attributes form in uDesigner. The Sheet Columns section displays all columns from the cost sheet in order.","Note:","Picker DEs and multiple-select input fields cannot be added as filters.","The system only applies filters to leaf-level codes within the cost sheet. The summary cost codes do not show up in the filter results.","Hidden, restricted, and deleted fields are not shown.","To create a filter:","Click the Add Filter button.","Do the following:","Choose a Data Element.","Choose a Condition: This drop-down list displays a list of conditions. This list is based on the type of data element (DE) selected. For more information, see Condition options.","Choose a Value: Depending on the type of DE, choose a value that the query condition must meet.","Data Element: Lists the DEs on the Cost Code Attribute Form.","Constant Value: You can enter a full or partial entry of the value to filter by. This is similar to entering search criteria.","Note: The default value for an integer drop-down list is 0. Therefore, the integer list can be used as a CBS attribute DE and defined as a filter with the criteria is not empty, which will result in the display of data with the default value.","To add additional filters, click Add Filter again, and repeat the preceding steps.","You can use the same data element multiple times.","If you are using multiple filters, click the applicable operator that should apply to the set:","And: To specify that the view must match all listed filters, select And.","Or: To specify that the view should match any of the listed filters, select Or.","Filters Tab in the New View Window","10301856.htm");
Page[351]=new Array("Use the Group By tab to group rows in the Cost Sheet. The drop-down field in the Group By tab contains a list of columns that the user can see in the Cost Sheet, such as the cost code and cost item, as well as items from the Cost Attribute Form.","Group By Tab in the New View Window","10301857.htm");
Page[352]=new Array("In the Sort By tab, all the columns from the default cost sheet are available, as well as items from the Cost Attribute Form.","Sort By Tab in the New View Window","10301858.htm");
Page[353]=new Array("In addition to using the Filters tab to create views that display specific data, you can use the Conditional Formatting tab to format columns based on specific conditions. This feature helps you visually identify rows within the column that match specific criteria. You can use different formats, such as background fill, font color, icons, and data bar, to customize the visual identification. You can format up to 10 columns in a sheet and use up to 5 format conditions for each column.","You can also apply conditional formats at the cell level, which lets you identify amounts or decimal-based values that match specific conditions. For example, you can use conditions to highlight amounts where the Total Cost Incurred is greater than the Forecasted amount for specific cost codes. By using a condition such as Background Fill &amp; Color, you can access your custom view and immediately identify where total costs have exceeded what was expected (forecasted). Or you might want to highlight approved contracts that exceed $500,000 or are valued at less than $50,000, which lets you visually identify the approved contracts with high or low (or both) values. ","When creating conditions, be aware of the following:","You can only apply conditions to columns and fields that you have permission to access. Hidden, restricted, and deleted columns are not shown. If a column becomes available after you create a view and set up conditional formatting, you must update the view to add the previously restricted or hidden column.","If a column that you can view when you create a condition subsequently becomes hidden or restricted, or is deleted, the system automatically updates the information shown to you when you select the view or its settings. Similarly, if the column becomes visible to you again because it is no longer hidden or restricted, the system automatically updates your customized view and settings. However, if you update and the customized settings before the column display is reinstated, the system permanently removes the applicable column from the customized view; you must manually update the view to add it.","If multiple conditions of a column are true, the conditions are applied in the order in which you created and applied them; that is, the condition that you specified first is applied first, and so on.","If none of the conditions are met, the display of the Cost Sheet remains unchanged; no message is displayed that indicates no conditions were met.","If you intend to print the Cost Sheet or export it to Microsoft Excel:","You must enable support for background graphics in your browser before printing the sheet.","Formatting is not retained during an export to Microsoft Excel, so viewing the conditions in Excel is not supported.","To create a condition:","Click + Add Column.","Select a Column.","The list contains all columns available to you in the Default view. Hidden, restricted, and deleted columns are not shown. Conditional Formatting is applied to the selected column.","Select a Format Type.","Click Add Format Condition (the plus [+] sign) to specify the elements for which you want to use different formatting.","Do the following:","Choose a Data Element. This list contains all columns available to you in the Default view. Restricted and hidden columns are not listed. The validation process to determine whether the condition is met is processed on the selected column.","Choose a Condition. The conditions listed are based on the type of data element (DE) selected. For more information, see Condition options.","Choose a Value. Depending on the type of DE, choose a value that the query condition must meet. If you chose a Condition such as is empty, the Value field does not apply.","Choose a Format. The options in this list depend on the selected Format Type.","If you chose Background Fill &amp; Color or Font Color, select the applicable color. The listed colors are the only options available; they cannot be customized for use.","If you chose Data Bar, Format displays a read-only Data Bar selection. Data Bar assumes that the associated Column contains numeric values, including negative values. A Data Bar is not displayed for summary records or totals. After the Conditional Format is applied, the selected Column is replaced with data bars whose length is proportional to the percentage value with regard to the maximum value. The values are printed inside their respective bars. Negative values are represented by red bars.","If you chose Icon Set, Format displays a read-only Icon Set selection that uses a fixed representation. Positive values are reflected by a green Up Arrow, negative values by a red Down Arrow, and zero values by a yellow Horizontal Arrow.","Note: Because you can create multiple conditions for the same column, conditions are applied in the order in which you create them; after the first condition is satisfied, the remaining conditions are ignored.","To add additional columns, click Add Column again, and repeat the preceding steps.","Conditional Formatting Tab in the New View Window","10301859.htm");
Page[354]=new Array("The following is a list of the available Condition options that you can use in the Filters tab and the Conditional Formatting tab:","contains","does not contain","equals","does not equal","is empty","is not empty","White spaces (blank characters):","Filters tab: All leading and trailing white spaces (blank characters) are included in the condition; that is, they are not trimmed.","Conditional Formatting tab: When you use any of these options on the Conditional Formatting tab, all leading and trailing white spaces are excluded; that is, they are trimmed.","Case sensitivity: When you use equals or does not equal, the results are case sensitive.","Condition Options","10310989.htm");
Page[355]=new Array("All shared views in a cost sheet that are set to Visible are displayed to those who have the applicable permissions when they access a cost sheet that uses the template. If you update, hide (clear the Visible check box), or delete a view, these changes are automatically applied to the corresponding cost sheet.","Note: When you import cost sheet views through a configuration package, they are hidden (the Visible check box is deselected) if the destination contains the same shell template and cost sheet. If the destination environment does not have the same shell template, the views are imported and visible when the cost sheet is created in the destination.","To update a Cost Sheet View for a template:","Go to the Company Workspace tab and switch to Admin mode.","In the left Navigator, select Templates, select Shells, and then select Projects.","In the Projects Templates log, select and open the applicable project.","In the left Navigator, select Cost Manager, and then select Cost Sheet.","In the Cost Sheet log, select and open the applicable cost sheet.","From the View menu, select Manage Views.","Use the Manage Views dialog box to:","Change the order of the views in the View menu for the projects/shells.","Make a view visible or hide it.","Delete a view.","The current Active View is marked with a green check mark. ","To save your changes, click Save.","Managing Cost Sheet Views","10317719.htm");
Page[356]=new Array("Data Source","Description","Single Sources","Columns in which data is manually rolled up from business processes after the appropriate terminal status is reached. Can also include other specified sources.","Cost-type Business Processes","Included in the Single Sources list are all Cost BPs that are available for your project/shell, and all their terminal statuses.","AFC","Assigned Budget","This column is closely related to budget distribution. It allows the user to create specific, detailed line-items for each CBS code in the budget. Each line item can be assigned individually.","Funded Records","This column shows records in which the CBS code is funded, that is, spend-type business process records that consume funds.","Unfunded Records","This corresponds to spend-type BP records that are not funded.","Prior Forecasts","Prior forecasts","Yet To Buy","Part of the commitment that still must be purchased. For example, a base contract is for 1000 items, and 500 have been bought. There are 500 items &quot;yet to buy.&quot; It is based on a currency amount. In Cost Sheet Properties, setting &quot;Auto&quot; &quot;Transaction&quot; options will track the yet to buy information.","Logical Sources","These values are based on formulas or user-defined entries.","Budget Remaining Balance","This is a place holder for a formula you create (optional).","Budget Variance","This is a place holder for a formula you create (optional).","Commits","This is a place holder for a formula you create (include all commit columns; optional).","Forecasts","This is a place holder for a formula you create (optional).","Forecasts (Unaccepted)","This is a place holder for a formula you create (optional).","Forecasts Variance","This is a place holder for a formula you create (optional).","CBS Funding","Requires additional setting in Funding Sheet; see Setting Up the Funding Manager.","Manual Funding by CBS","Requires additional setting in Funding Sheet; see Setting Up the Funding Manager.","Revised Budget","This is a place holder for a formula you create (optional)","Spends","This is a place holder for a formula you create (include all spend columns; optional).","Project or shell Cost 1-25","These can be used to roll up manual and formula columns to company cost sheets. Each data source can be used for one column.","Project or Shell Cost Sheet Column Data Sources","74527.htm");
Page[357]=new Array("The following procedures are applicable to Cost Templates and Cost Sheets","Each cost sheet row corresponds to the unique CBS (or Cost) codes that link costs on a project/shell to the General Ledger for Finance. They may be added manually or imported from a CSV file.","CBS codes may consist of one or a maximum of 10 segments. Each segment is defined by a different data definition. For example, a five segment CBS Code would require five data definitions. Segments can be defined via a selection list or text entry.","If the cost sheet has been set up to automatically sort CBS codes, all new rows will be sorted by ascending order.","You cannot create duplicate CBS Codes at the same row level on the sheet. If you choose a Flat structure for your cost sheet (no indented rows), you will not be allowed to create duplicate CBS Codes. If you choose a Tree structure, you can use the same CBS Code if each instance is within a different grouping (or parent) row.","To manually add rows to a cost sheet or cost template:","Open the Cost Template or Cost Sheet.","Click the Manage Rows button. The Manage Rows window opens.","Click Add. The CBS Detail window opens.","Click to edit all required fields in the row.","Click Save when finished.","To rearrange rows:","Open the Manage Rows window.","Click and drag a row to move it to another position. ","Adding Cost Rows (CBS Codes)","74530.htm");
Page[358]=new Array("Following is an overview of the fields and tabs in the CBS Detail window.","The CBS Detail window displays CBS properties. You can add notes or file attachments to the CBS code in this window. You can also specify CBS Breakdowns in this window, which are used in Schedule of Values (SOV) sheets.","The values that are available in the CBS code selection come from the Cost Codes data definitions. To view the list of Cost Code Data Definitions:","Go to the Company Workspace tab and switch to Admin mode.","In the left Navigator, select Data Structure Setup, select Data Definitions, and then select Cost Codes.","The log will show whether the code is a Text Box or Pull-down Menu.","The codes listed in the log are those that are available to use when building the CBS Code segments.","This section discusses the default CBS Detail window. If your company has designed a uDesigner-created Cost Attribute Form, the fields may differ. Fields with a red asterisk are required. ","In this field:","Do this:","CBS Code","Click Select to choose the cost code segments for the CBS code. &nbsp;The Cost Code Selection window opens.","CBS Item","Enter a label that will display on the cost sheet next to the CBS Code, this can help other users to identify what the code represents.","Description","Enter an optional description to describe the row.","Status","Select the status of the cost code. Choices include: Active, Inactive.","The status of the cost codes persist when cost sheets are updated using templates. ","Additional information about the CBS Detail window:","The appearance of the Cost Code Selection window will depend on how your cost sheet was set up, which CBS Codes (cost codes) were used in the definition, and how each code was set up.","If the CBS code segment has a Select button, click the button and choose the segment values from the list.","If the CBS code segment does not have a Select button, type the value of the segment into the field.","About the CBS Detail Window","74531.htm");
Page[359]=new Array("If you select a Tree Structure format, you can indent rows. These indented rows can be used to capture cost transactions. The parent node acts as a summary row, summarizing the information present for each of the indented &quot;child&quot; rows. You cannot enter information directly into a summary row.","To create a summary row by indenting:","In the Rows window, select the check box of the row(s) to indent under the summary row.","Click the Indent button. The row immediately above will become a summary row. All monetary values in the detail lines below a summary row will be rolled up to the summary row automatically.","To outdent a row:","In the Rows window, select an indented row by clicking its check box.","Click the Outdent button.&nbsp;The row will no longer be part of the summary row.","Create a Summary Row (Classic view)","74532.htm");
Page[360]=new Array("You can create CBS Codes in a cost sheet by importing them from a CSV file. This procedure can also be used to copy the CBS codes from one cost sheet or template to another (the structure and code segments must be the same).","Step 1: Export the file template","Open the cost sheet or template, open the Menu Options, select Export, and select CBS Details.","Depending on your browser, the CSV file will be automatically downloaded, or you will be prompted to download the file manually.","Step 2: Add the CBS code rows to the CSV file","Navigate to and open the CSV file (in Microsoft Excel or another compatible program).","If the Cost Template already contains rows, they will be listed. If summary rows exist, the CBS column will display them with two tilde symbols (~~) separating the parent row from the child row.","For example: 2000000 ~~210000, where 2000000 is the parent and 210000 is the child.","Enter information in the required fields and save the file.","Note: Do not change or delete any of the listed CBS Codes that exist in the system or you will get an error. Changes to the CBS Code must be done within the system.","Required fields:","CBS Code: must be a match to a CBS Code in the Cost Sheet","CBS Item: must be a match to the CBS Item for the associated CBS Code in the Cost Sheet","Cost Type: Capital or Expense","Status: Active or Inactive","Step 3: Import the rows","In the cost sheet or template, open the Menu Options, select Import, and select CBS Details.","In the Upload window, browse to and add the CSV file.","Click Open. After the import, your Cost Sheet will show the new rows.","To copy CBS codes from one cost sheet or template to another:","In the source cost sheet or template, click Export, and then select CBS Details. Save the CSV files. You can go in to the file and add additional codes if needed.","In the destination cost sheet or template, click Import, and then select CBS Details. Browse to the CSV file and import.","Note: The structure of the two sheets must be the same: Both must be tree or flat structure. Verify the structures by opening the Properties window and clicking the Structure tab. Be sure you are using the same CBS code segments.","Import Cost Rows (CBS Codes)","74533.htm");
Page[361]=new Array("Worksheets are extensions of the cost sheet. They can be used as &quot;sub-cost sheets,&quot; enabling specific calculations or data entry in a separate sheet, which can then be rolled up into a defined project/shell cost sheet column. For example, a worksheet can be used to off-load complex calculations, which can be rolled up into a single cost sheet column. The rows equal the CBS codes on the cost sheet. Worksheets can have multiple columns for data entry or formula calculations, but do not support data rolled up from business processes.","A cost sheet column can be associated with a worksheet as the data entry method. A worksheet column can also be associated with another worksheet, if there is not a circular reference. There can be multiple worksheets in a project/shell.","Note: A circular reference is referred to a reference in which the last field references the first field and creates a closed loop.","A worksheet template can be created in Admin mode. Permissions can be controlled for individual worksheets. Worksheets are not independently reportable; however, cost sheet columns that reference worksheets can be reported on.","Creating Worksheet Templates","74534.htm");
Page[362]=new Array("You can use this template to create worksheets for individual project/shell cost sheets, or for cost sheets in project/shell templates.","Worksheets are created similarly to cost sheets. The user who creates a worksheet will be the owner of the Worksheet. The owner can grant permissions to other users and groups in User mode.","To create a worksheet template:","Go to the Company Workspace tab and switch to Admin mode.","In the left Navigator, select Templates, and then select Cost Sheets. The Cost Templates log opens.","Click the Create button and choose Worksheet. The Worksheet Properties window opens.","Complete the Worksheet Properties window:","Name: Enter a unique title to identify the worksheet or template. This is a required field.","Description: Enter an optional description. This is especially useful if you plan to create multiple templates for use in different projects/shells, or multiple worksheets for a project/shell.","Click Save to save and exit the window. The worksheet template is listed in the log.","You can open the worksheet template and configure it by adding columns; the rows will be the CBS codes within the corresponding cost sheet.","Create a Worksheet Template","74535.htm");
Page[363]=new Array("After creating the worksheet template, you must open the sheet to add columns.","To open the worksheet template:","Go to the Company Workspace tab and switch to Admin mode.","In the left Navigator, select Templates, and then select Cost Sheets.","Select the worksheet template and click Open from the gear menu ( @ ), or double-click the selected sheet. The worksheet template window opens.","Open the Worksheet Template","74536.htm");
Page[364]=new Array("Adding a column to a worksheet is similar to adding a column to the cost sheet. You can add manual entry (direct or line item) columns or formula columns. You can also add columns that reference other worksheets. This allows interaction between worksheets.","The available data sources are Project Worksheet Cost 1 through 50.","To add a column:","Open the worksheet and click the Add Column button. The New Column window opens.","Complete the Column Properties as usual for a column.","If you are creating a formula, the data sources that are available for the formula are limited to the other columns on the worksheet.","Complete the window and click Save or Save &amp; Add New.","Create a Worksheet Column","74537.htm");
Page[365]=new Array("You can create a worksheet in the project/shell template Cost Manager by copying from a template or copying from a project/shell.","To create a worksheet from a template:","Go to the Company Workspace tab and switch to Admin mode.","In the left Navigator, select Templates, select Shells, select the [shell type], and open the [shell template].","In the left Navigator, select Cost Manager, and then select Cost Sheet.","From the toolbar, click Create, select Worksheet, and then select From Template. This option lets you create a worksheet by copying one from a company-level template.","In the Create Worksheet Template dialog box, select a worksheet template, and click Save.","To create a worksheet from another project/shell:","Go to the Company Workspace tab and switch to Admin mode.","In the left Navigator, select Templates, select Shells, select the [shell type], and open the [shell template].","In the left Navigator, select Cost Manager, and then select Cost Sheet.","From the toolbar, click Create, select Worksheet, and then select From Projects.","In the Create Worksheet from Project dialog box, click Select.","The Worksheets dialog box lists worksheets from all projects/shells.","Select any Cost Sheet, click Select, and then click the Save button to create a Cost Sheet.","Create a Worksheet in a Shell Template","74538.htm");
Page[366]=new Array("User will not be allowed to delete a Worksheet if it is referred as a Column Entry method in Cost Sheet. Only owner of Worksheet will be allowed to delete Worksheet along with user with Create permission at module level.","To delete a worksheet:","Select the worksheet in the log and click Delete from the gear menu ( @ ).","Delete a Worksheet","74539.htm");
Page[367]=new Array("You can edit the cost template properties, rows, columns, or add default data to rows.","Note: Your edits to a template will be reflected in cost sheets that are created from it, but will not affect exiting cost sheets.","To access your cost templates:","Go to the Company Workspace tab and switch to Admin mode.","In the left Navigator, select Templates, and then select Cost Sheets to open the Cost Templates log that lists the cost templates.","The Cost Templates log has the following toolbar options:","Option","Description","Create","To let you create:","Cost Sheet","Worksheet","View","To change the view of the cost sheet to the following options:","All","Group by Type","Delete","To delete a cost template.","Refresh","To refresh the items listed on the page.","Print","To print the list of cost templates with the following options:","Print","Export To CSV","Export To Excel","Find on Page","To search for an item on the page.","The Cost Templates log has the following tabs on the right pane:","Tab","Description","Properties","To view or edit the fields of your cost template.","Audit Log","To review the history of changes that have been incorporated on a selected cost template.","Managing Cost Templates","74540.htm");
Page[368]=new Array("The Properties tab of a cost template is fully editable. This lets you make changes as necessary to use when creating subsequent cost sheets from the template.","Notes:","Many of the properties that are editable in cost templates are not editable in the Properties tab of the cost sheet itself, after it has been created in the project/shell or in a project/shell template.","Any edits that you make to a cost template will affect new project/shell cost sheets created from the template, and the existing cost sheets will not be affected.","To view or edit cost template properties:","Go to the Company Workspace tab and switch to Admin mode.","In the left Navigator, select Templates, and then select Cost Sheets to open the Cost Templates log.","Select a cost template from the log. The Properties tab is displayed on the right pane. The Properties tab has the following blocks with fields that let you enter values, when permitted:","General","Name","Description","CBS Code Label","CBS Item Label","Structure","Flat","Tree","Sort CBS","Segment Preview","Options","Forecast Details: User Line Items - Transactions","Forecast Inclusion: Manual - Auto","Enable Cost Sheet Forecasting","Enable P6 source","In the Properties tab, you can make edits as necessary.","Note: Any edits that you make to a cost template will affect new project/shell cost sheets created from the template, and the existing cost sheets will not be affected.","When finished, click Save to save your changes. Click Cancel to discard your changes.","View or Edit Cost Template Properties","74541.htm");
Page[369]=new Array("You can delete a cost template from the Cost Templates log.","Note: The cost sheets in project/shell templates or in projects/shells cannot be deleted. Deleting a template will have no effect on cost sheets created from it.","To delete a template:","Go to the Company Workspace tab and switch to Admin mode.","In the left Navigator, select Templates, and then select Cost Sheets to open the Cost Templates log.","Select a cost template from the log.","Click the gear menu ( @ ) next to the cost template and click Delete.","Delete a Cost Template","74542.htm");
Page[370]=new Array("You can edit the properties of a column, including the entry method, if this is applicable for the selected data source.","Note: Although it is possible to change the entry method for a column, use caution when doing so when data exists in the column. Information such as detailed line item entries could be lost. For example, if you change the data entry method from line item entry to direct entry, the value will appear in the cell, but all line item details will be lost.","To edit Cost Templates log columns:","Go to the Company Workspace tab and switch to Admin mode.","In the left Navigator, select Templates, and then select Cost Sheets to open the Cost Templates log.","Right-click a (any) column heading, and you can:","Sort Ascending","Sort Descending","Columns (Name, Date Created, Created By, Type)","Lock after this Column","Select a cost template from the log.","Click the gear menu ( @ ) next to the cost template and click Open. The Cost Sheet &lt;name&gt; window opens. See the table below for the Cost Sheet &lt;name&gt; window elements.","You can delete a cost template from the Cost Templates log.","Note: The cost sheets in project/shell templates or in projects/shells cannot be deleted. Deleting a template will have no effect on cost sheets created from it.","Edit Cost Templates Log Columns","74543.htm");
Page[371]=new Array("To move a column of a project cost sheet:","Go to the Company Workspace tab and switch to Admin mode.","In the left Navigator, select Templates, select Shells, select Projects, and open the [shell template].","In the left Navigator, select Cost Manager, and then select Cost Sheet.","Open the Project Cost Sheet.","In the list of columns, click and drag a column header to a different spot in the log. A blue line will appear where the column will be placed.","Move a Column (Project Cost Sheet)","74544.htm");
Page[372]=new Array("If a column is being used in a formula in another column, you must remove the column from the formula before you can delete it. If the column contains a cell with line item data, you must first remove each line item before it can be deleted.","To delete a column:","Right-click a column header from the log.","Click Delete and Yes to confirm.","Delete a Column (Project Cost Sheet)","74545.htm");
Page[373]=new Array("You can hide a cost sheet column. Hidden columns are not visible on the cost sheet, but otherwise function like other cost columns. For example, you might want to hide a column that is used in a formula column, but is unnecessary to display. Hidden columns can be viewed from the Columns Log by users with &quot;create&quot; permission on the cost sheet.","To hide a cost sheet column:","Right-click a column header from the log.","Select Hide. The column is hidden.","To show (unhide) a hidden cost sheet column:","In the cost sheet template, click Menu Options ( @ ), elect Columns, and then select Unhide.","The columns are listed in alphabetical order. If there are more than 25 items, the submenu uses a fisheye menu, which lets you move through the list and read the focused items more easily.","Select the column to unhide.","Hide Cost Sheet Columns (Project Cost Sheet)","74546.htm");
Page[374]=new Array("You can edit rows in templates and cost sheets. However, in cost sheets, if you have already distributed and locked the budget, you must unlock it first before you can access the Rows window and edit rows.","To edit a row:","Go to the Company Workspace tab and switch to Admin mode.","In the left Navigator, select Templates, select Shells, and then select Cost Sheets.","Open the cost sheet. The Cost Sheet - [name] window opens.","From the toolbar, click Manage Rows  @  to open the Manage Rows window.","In the Manage Rows window, you can use the Add option to add a row, select a row, and delete it.","For the Project Cost Sheet:","Go to the Company Workspace tab and switch to Admin mode.","In the left Navigator, select Templates, select Shells, select the [shell type], and open the [shell template].","In the left Navigator, select Cost Manager, and then select Cost Sheet.","Open the cost sheet. The Cost Sheet - [name] window opens.","From the toolbar, click Manage Rows  @  to open the Manage Rows window.","In the Manage Rows window, you can use the Add option to add a row, select a row, and delete it.","Edit a Cost Row","74547.htm");
Page[375]=new Array("The CBS Detail window displays CBS properties. Notes and files can be attached to transactions via the CBS Detail window. You can also specify CBS Breakdowns in the CBS Detail window, which are used in SOV sheets.","Note: If you have locked the budget, you will need to unlock it first to access the Rows window or CBS Detail window.","To view and edit CBS Details:","Open the Cost Sheet.","From the cost sheet, click the Manage Rows button to open the Manage Rows window. Modify the values of the editable fields for each row as needed.","Click the CBS Code to be edited, which appears as a link. The right pane opens to display the Breakdown and Audit Log tabs.","Make changes to the Breakdown Tab as necessary.","Click Save.","View or Edit CBS Details","74548.htm");
Page[376]=new Array("The Cost Sheet is created by copying from a cost template or another project/shell cost sheet. Only one project/shell cost sheet may be defined per project/shell. You may define multiple work packages or work sheets.","If a worksheet is associated with the cost sheet or template (that is, if a cost sheet column definition refers to Worksheet as Data Entry method), the worksheet will also be copied.","Note: After a cost sheet has been created, it cannot be deleted. Be sure the structure (tree or flat) of the template is what you want to use for the cost sheet. The structure is not editable for cost sheets. You can add, modify or delete columns and rows to the sheet as necessary.","To create a cost sheet by copying a template:","Go to the Company Workspace tab and switch to Admin mode.","In the left Navigator, select Templates, select Shells, and then select Projects.","Open the project template.","In the left Navigator, select Cost Manager, and then select Cost Sheet.","From the toolbar, click Create, select Worksheet, and select From Template. This option will allow the user to create a Cost Sheet by copying one from a company level template.","Select a template and click Save.","To create a cost sheet by copying from another project/shell:","Go to the Company Workspace tab and switch to Admin mode.","In the left Navigator, select Templates, select Shells, and then select Projects.","Open the project template.","In the left Navigator, select Cost Manager, and then select Cost Sheet.","From the toolbar, click Create, select Worksheet, and select From Project. This option will allow the user to create a Cost Sheet by copying one from another project/shell.","Select a worksheet and click Save.","Creating a Project or Shell Cost Sheet","74549.htm");
Page[377]=new Array("Rows and columns are added to project/shell cost sheet the same way as they are to cost sheet templates.","Add Cost Sheet Columns and Rows","74550.htm");
Page[378]=new Array("Breakdowns are used in SOV sheets. Invoices can be created from SOVs that can include CBS breakdowns. The breakdowns are not accessible in any BP except Spends BPs, and are not associated with data definitions, and so are not reportable.","The breakdown applies to a single project/shell, and can be applied across projects/shells by adding CBS code rows and breakdowns to Cost templates, or creating cost sheets from previous project/shell cost sheets with breakdowns.","You may add as many breakdowns as you need. When you click OK, the system will perform a validation check. If the CBS code is already in use in a cost sheet transaction, the system will not allow the addition of a breakdown.","Note: If you have locked the budget, you will need to unlock it first to access the Rows window.","You can also add breakdowns directly to SOV sheet. This is done in User mode on the SOV sheet.","To add a CBS Breakdown:","From the Cost Sheet, click the Manage Rows button. The Rows window opens.","Click the CBS Code to be edited, which appears as a link. The right pane opens to display the Breakdown and Audit Log tabs.","Note: The Breakdown tab becomes accessible after the row has been created. To see the Breakdown tab, you must first create the CBS Code and click Save.","Click the Add Breakdown button.","Add a Breakdown Name and Description and click Save.","Add CBS Breakdown","74554.htm");
Page[379]=new Array("The cost sheet default view refers to how the cost sheet appears when it is first opened. The cost sheet Properties window offers two options regarding the cost sheet default view, described in the procedure below. These options control how the cost sheet opens for all users.","To modify the cost sheet default view:","In User mode, open the cost sheet Properties window (click the Properties button from the log toolbar, or open the cost sheet and click File, and then select Properties).","On the General tab, you may optionally choose either or both of the Default View check box options:","Open in maximized view: When the cost sheet is opened, it will automatically open maximized, or full-screen.","Open in split mode: When the cost sheet is opened, it will automatically open as split (same as clicking the Split button).","If these options are not selected, the cost sheet will open by default to a size slightly smaller than the screen, and not split.","Modify cost sheet default view","74556.htm");
Page[380]=new Array("The company cost sheet can be set up to roll up project/shell cost data across all company projects/shells.","Setting Up the Company Cost Sheet","74562.htm");
Page[381]=new Array("Company cost sheet will not be auto-created. The company administrator must create one. Cost sheets are added by default.","To create a company cost sheet:","Go to the Company Workspace tab and switch to User mode.","In the left Navigator, select Cost Manager, and then select Cost Sheet. The Cost Sheet log opens.","Click Create. After a cost sheet has been created it cannot be deleted.","Create a Company Cost Sheet","74563.htm");
Page[382]=new Array("Cost sheet columns can be added to company cost sheets the way they are added to cost templates. Predefined data sources at project/shell (CBS) level will roll up to company level automatically.","Add Company Cost Sheet Columns","74565.htm");
Page[383]=new Array("Data Source","Description","Single Sources","Data from single data sources Project Cost1 to Project Cost25 is rolled up from project-level cost sheets. Users can also view data sources based on business process data rolled up from the project level.","Business Process (All statuses)","Included in the Single Sources list are all Cost BPs that are available for your project, and all their terminal statuses.","AFC","Allowance for Change. This is a contingency value.","Funded Records","This column shows records in which the CBS code is funded, that is, spend-type business process records that consume funds.","Unfunded Records","This corresponds to spend-type BP records that are not funded.","Prior Forecasts","Prior forecasts","Yet To Buy","This is a portion of a commit that you still need to buy. This can be automated for uDesigner BPs (commit BPs can track YTB). In Cost Properties, you must set &quot;Auto&quot; &quot;Transaction&quot; options, which track YTB. ","Project Cost 1 to Project Cost 25","Roll up from all projects","All Project Single Sources","All other data sources are similar to Project Cost Sheet.","Logical Sources","These sources are formulas.","Company Budget Remaining Balance","This is a place holder for a formula you create (optional).","Company Budget Variance","This is a place holder for a formula you create (optional).","Company Commits","Can be used for company commit BPs","Company Forecasts","This is a place holder for a formula you create (optional).","Company Forecasts (Unaccepted)","This is a place holder for a formula you create (optional).","Company Forecasts Variance","This is a place holder for a formula you create (optional).","Company Funding","You can roll up all project funding here.","Company Spends","You can roll up spends BPs here.","Company CBS Funding","This requires additional setting in Funding Sheet; see Setting Up the Funding Manager.","Company Manual Funding by CBS","Company Cost 1-25","Company Cost Sheet Data Sources","74566.htm");
Page[384]=new Array("You can define mapping between a company cost sheet column and a company account code. This allows you to link an account code with project/shell cost data that is rolled up from a project/shell cost sheet into the cost sheet.","Notes:","You can map a cost column to more than one account code. For example, Column A can be mapped to both Account Code X and Account Code Y. This means that the Total will display for both account codes in that column. However, each account code can be mapped only once (Account Codes X and Y cannot be mapped to any other columns).","If you remove a column from the asset sheet that is associated with an account code, the mapping will be lost.","To map a cost sheet column to an account code:","In User mode, navigate to the company cost sheet.","Open the Properties window and click the Options tab.","Click Add. The Add Mapping window opens.","Complete the window:","Column Name: Company Cost Sheet Column drop-down will show list of all columns that are defined on the cost sheet.","Account Code: Click Select. A picker window opens displaying active codes from the accounts sheet. Select a code and click Open.","Account Name: This field is populated with the name of the account code chosen in the previous field, as defined in the accounts sheet.","Click OK to save the Add Mapping window.","Click Add to add additional mapping if necessary.","Click OK to save and exit the Properties window.","After mapping is complete, data from the company cost sheet (which reflects data rolled up from project/shell cost sheets) will be rolled up to the Accounts Sheet under the Projects data source. Only the total value will be rolled up. If the Total value in the cost sheet column changes, the change is reflected on the accounts sheet.","Note: The process used to update the accounts sheet with mapped cost sheet data runs in the background. After mapping a cost column to the accounts sheet, or updating the cost sheet data, the change may not reflect in the accounts sheet immediately.","To modify mapping:","In the Properties window, Options tab, select a mapping and click Modify. You can make changes in the Add Mapping window.","To remove mapping:","In the Properties window, Options tab, select a mapping and click Remove. This removes the mapping. Data will no longer roll up to the accounts sheet.","Map cost sheet column to an account code","74567.htm");
Page[385]=new Array("This section describes how to manually delete a cost sheet from a shell.","Note: You can delete a cost sheet from a specific shell template but not from other Projects/Shells that have been created using the template.","Go to the Company Workspace tab and switch to Admin mode.","In the left Navigator, select Templates, select Shells, select the [shell type], and open the [shell template].","In the left Navigator, select Cost Manager, and then select Cost Sheet.","Select a sheet for deletion.","Click Delete.","When the prompt appears that asks you to confirm deletion, click Yes to delete the cost sheet.","Deleting Cost Sheets","10293659.htm");
Page[386]=new Array("The company accounts sheet is used to track company level accounts information, such as assets, resources, and facility maintenance. It is similar to a project/shell cost sheet, using account codes instead of CBS codes.","Account codes are independent of CBS codes, but are similar in structure format. Company level business processes can be designed in uDesigner to roll up to the accounts sheet (line items are associated with account codes).","Setting Up a Company Accounts Sheet","74568.htm");
Page[387]=new Array("Before you begin: A Company Account Code Attribute Form must be deployed in uDesigner. This is used as the detail form for creating account codes (rows) on the accounts sheet. There is no default form available. The design also includes creating an account code picker, which can be used on BP forms used with the accounts sheet, and for mapping account codes to project/shell cost sheet columns.","Step 1: Deploy the Company Account Code Attribute Form in uDesigner, similar to other design deployment in uDesigner.","Step 2: Grant Accounts Sheet permissions.","Step 3: Create a company level accounts sheet. There is one accounts sheet per company. There is no template for an accounts sheet. After creation, you add columns and rows. The columns can be formulas, they can roll up data from company cost (accounts) business processes, or they can roll up asset data, project/shell cost data, or resource data. Adding rows to the accounts sheet creates the account codes that are used. You need to activate the account codes after adding the rows.","Optional steps: To roll up transactions to the accounts sheet, you must create and set up company-level cost business processes (also known as an account type business process). These BPs use account codes rather than the CBS codes used in project/shell level cost BPs. These are discussed in the Business Process sections. Other options assume that you have configured and set up an Assets Sheet (for rolling up asset data).","How to set up a company accounts sheet","74569.htm");
Page[388]=new Array("To import Company Account Code Attributes form, see Importing Configuration Packages.","Import Company Account Code Attributes Form","74570.htm");
Page[389]=new Array("You can create an accounts sheet to create company account codes and capture and view company level cost.","To create an accounts sheet:","Go to the Company Workspace tab and switch to User mode.","In the left Navigator, select Cost Manager, and then select Accounts Sheet. The Accounts Sheet log opens. You can have one accounts sheet per company.","Click New. The Properties window opens.","Complete the General tab.","Title: This will be displayed in the log","Description: Enter an optional description","Display Mode: Choose Flat or Tree. Account codes are segmented, similar to CBS Codes. You can switch between Flat or Tree at any time. The same data is displayed in Tree or Flat structure.","Default View: You may choose either or both of the Default View check box options:","Open in maximized view: when the sheet is opened, it will automatically open maximized, or full-screen","Open in split mode: when the sheet is opened, it will automatically open as split (same as clicking the Split button)","If these options are not selected, the accounts sheet will open by default to a size slightly smaller than the screen, and not split. The window can be resized by clicking the Minimize or Maximize/Restore buttons in the upper right corner of the window, or by dragging the edges of the window to the size that you need.","Click OK. The new accounts sheet appears in the log.","To open the company accounts sheet:","Go to the Company Workspace tab and switch to User mode.","In the left Navigator, select Cost Manager, and then select Accounts Sheet.","Select the accounts sheet in the log and click Open, or double-click the sheet to open it. The Accounts Sheet opens. You can do the following:","Add rows (account codes) or columns","Split the screen vertically, which is useful for viewing columns or entering data while keeping the account codes in view (click the Split button)","Check the Account Status","Import Account Codes or Column Details ","Create a Company Accounts Sheet","74571.htm");
Page[390]=new Array("You can add as many columns as necessary to the accounts sheet. There are two default columns: Company Account Code and Company Account Name. You can add columns for formulas, for transaction data from company level cost business processes (account type), or to roll up data from project/shell cost sheets, or resource actuals.","To add a column:","Open the accounts sheet.","Click the Columns button. The Columns log opens.","Click New. The Column Properties window opens.","Complete the columns log as described in the following table.","Click OK.","In this field:","Do this:","Name","The name is populated with the data source","Data Source","Click the drop-down and choose the data source for the column. Options include:","Single Sources:","Company account type BPs, listed by name and status. These are company level cost BPs of subtype line items with accounts code.","Projects/Shells (CBS): Data is rolled up from project/shell cost sheets into the company cost sheet, based on the mapping of cost sheet columns and account code.","Resource Actuals: Data is rolled up from company level time sheet records.","Logical Sources:","Accounts Code 1 through 25. You can use these to create a formula or manual entry column. These are reportable.","Entry Method","Select one of the options (options available are dependent on the data source; applicable when a Logical data source is selected):","Manual: User enters data directly into an accounts sheet cell","Formula: Can create a formula from other accounts sheet columns","Data Format","Choose Currency (base currency) or Percentage (%)","Display Mode","Show or Hide the column from user view","Column Position After","Select the column after which you want the current column to appear","To roll up project/shell cost sheet data to the accounts sheet:","Be sure the project/shell cost sheet data rolls up to a company cost sheet column, using a data source Project/Shell Cost 1 through 25 for the cost sheet column.","Map the company cost column to an account code. (In the company cost sheet Properties window, Options tab. See Map cost sheet column to an account code.)","Roll up the mapped company cost column data to the accounts sheet column, choosing Projects/Shell data source. The column will show the Total of the company cost column.","As project/shell level transactions take place, the company cost column will reflect the changes, which in turn will roll up to the accounts sheet.","Add a Column to an Accounts Sheet","74572.htm");
Page[391]=new Array("Regardless of the order you add or import rows, they are automatically sorted alphanumerically by account code.","Adding and Managing Accounts Sheet Rows","74573.htm");
Page[392]=new Array("You can add account codes to the accounts sheet manually or by importing.","To add a row to the accounts sheet manually:","Open the Accounts Sheet.","Click the Add Row button.","Complete the Account Code Details form. This is the attribute form and will vary based on your company's design. Account codes are built like CBS codes, from segments that can be text fields or pulldown menus.","Click OK.","Add Rows to the Accounts Sheet","74574.htm");
Page[393]=new Array("You cannot delete a row if it contains line item or rolled-up data, or if the code is mapped to a cost or asset sheet column.","To delete rows from the accounts sheet:","Open the accounts sheet.","If you are using a tree structure, click the plus (+) next to segment rows (shaded blue) to view account code rows.","Select a check box next to the account code to be deleted.","Click the Delete Rows button.","Click Yes to confirm.","Delete Accounts Sheet Rows","74575.htm");
Page[394]=new Array("Step 1: Export template","Open the accounts sheet.","Click the Export button and choose Account Codes.","In the File Download window, click Save. Enter a file name, browse to where you want to save the file, and click Save.","Step 2: Edit Template in Excel","Open the CSV file you just exported.","If the accounts sheet already contains rows, they will be listed. Note the format and structure.","Delete any existing rows.","Enter new account codes into the columns and save the file.","Step 3: Import the CSV file","On the Account Sheet toolbar, click Import and choose Account Codes.","In the Upload window, browse to and add the CSV file.","Click OK. After the import, the accounts sheet will show the new rows. Rows are sorted alphabetically by account code (adjusts for tree or flat structure).","Import Account Sheet Rows","74576.htm");
Page[395]=new Array("If an account code is inactive it should still be displayed on accounts sheet but should not be available through an account code picker.","To activate or deactivate an account code:","Open the Accounts Sheet.","Click the Account Status button. The Account Code Status window opens.","Select one or more account codes and click Activate or Deactivate.","Activate an Account Code","74577.htm");
Page[396]=new Array("The accounts sheet Properties window offers two options regarding how the sheet will appear when it is first opened. These options control how the sheet opens for all users.","To modify the accounts sheet default view:","Open the accounts sheet Properties window (select the sheet and click the Properties button from the log toolbar; or open the sheet, click File, and select Properties).","On the General tab, you may choose either or both of the Default View check box options:","Open in maximized view: when the accounts sheet is opened, it will automatically open maximized, or full-screen","Open in split mode: when the sheet is opened, it will automatically open as split (same as clicking the Split button)","If these options are not selected, the accounts sheet will open by default to a size slightly smaller than the screen, and not split.","Modify Accounts Sheet Default View","74578.htm");
Page[397]=new Array("The Funding Manager helps you to keep track of where project or shell funding comes from and how it is being spent. The Funding Manager is available in CBS shells. Use the Project or Shell Funding sheet to specify the appropriation and assignment of funds from each funding source. You can automate fund appropriation and assignment when used with cost business processes.","Sometimes, it may be necessary to allocate specific funds to use on a particular contract, and have a means to control consumption on the invoices created against that contract. This can be done through commitment-level funding. A commitment funding sheet is created for each base commit that has been designed for commitment funding. You allocate funds from the project or shell funding sheet to the commitment funding sheet. This sheet works in conjunction with the Schedule of Values (SOV) sheet to track base commit and change commit line items and balances.","Company Funding Sheet vs. Project or Shell Funding Sheets vs. Commitment Funding Sheets","The first step to setting up funding is to create and set up a company funding sheet, where individual funding sources are maintained.","For example, a corporation's funding sources may include different types of corporate accounts. For municipal or educational facilities, funds may come from bond measures, grants, donations or other sources. All these funding sources will be listed and tracked on the company funding sheet. As funds are consumed via business processes or manually in individual projects/shells, this data is rolled up to the company funding sheet.","Project/shell funding sheets track how your company's funding is being spent on each project/shell. It tracks individual transactions, which are rolled up to the company funding sheet. All project/shell funding sheets must be created based on a funding template.","If you are using commitment funding, you will start with a commitment funding template, which is used to create the commitment funding structure within a project or shell. As base commits (that are designed for commitment funding in uDesigner) are routed and approved, a commitment funding sheet is created, based on this structure, for each base commit record. This sheet works with the SOV sheet to track and control funding of each SOV line. ","Setting Up the Funding Manager","74579.htm");
Page[398]=new Array("The following is an overview of the steps needed to set up funding for use in projects/shells, plus the steps needed to set up the optional commitment level funding. Details for each step are in the sections that follow, unless otherwise noted.","Setting up company and project/shell funding","Before you begin. The fund attribute form can be designed in uDesigner. This will be used as the Fund Details window when adding new funds to the company funding sheet, or viewing fund properties. If your company does not design a fund attribute form, a simple default form is used.","Import and set up fund business processes. You can use business processes for fund allocations, fund assignment (also known as consumption; enabled on spends type business processes), and fund credits (also enabled on spends business processes). This step can be done at any point in this general procedure. Be sure you know which funding business processes you will be using for the project/shell before defining funding rules on the project/shell funding sheet.","Step 1: Import and deploy the fund attribute form. Once imported, the fund attribute form becomes the Fund Details window, used to create and manage fund codes in the company funding sheet. When designing the form, you can also design the fund picker, which is used to add funds to business processes and project/shell funding sheets, as well as &quot;Find&quot; on the picker. This is an optional step. If you do not create a fund attribute form, a default fund code form and fund picker will be used.","Step 2: Create and set up the Company Funding Sheet (User mode). You define the funds in the company funding sheet, which can then be used for funding projects/shells. Only one company-level funding may be created per company. All project/shell funding sheets refer to the company funding sheet.","Step 3: Create and set up Project/Shell Funding Template (Admin mode). The funding template is used to create project/shell funding sheets.","Step 4: Create and set up the Project/Shell Funding Sheet (User mode). The project/shell funding sheet is based on the funding template. (You can also define the project/shell funding sheet in a project/shell template.) The funding sources available for the project/shell are defined in the company funding sheet.","Step 5: Define funding assignment rules. Funding assignment rules can be defined in the project/shell funding sheet or the funding template (or both). You can also determine the order in which to consume funds if you will be using automatic fund assignment from business processes. (This step can be done any time after creating the funding template. If you define assignment rules in a template, they will be carried over to the sheets created from them.)","Additional steps: Create funding rules in the rules engine. You can create funding rules in the rules engine that can help you manage your funds and fund balances. The most common rule is to keep your company fund balances from becoming less than zero. Configure permissions. As you create funding sheets and set up funding business processes, remember to configure the permissions to go with them. Refer to the Unifier Data Reference Guide for funding permissions.","Setting up commitment level funding","Commitment level funding is optional. To set it up, first set up funding in the project/shell, and then follow these additional steps.","Commitment funding works in conjunction with general spends and payment applications SOV sheets.","Before you begin. Be sure that the project/shell funding has been set up, with funds allocated and available on the project/shell funding sheet. Data sources are available for project/shell funding sheets (and company funding sheets) to track funding that is assigned for specific base commits. Also, be sure you have added the data source &quot;Scheduled Value&quot; to the SOV structure for the project/shell. Commitment funding uses the SOV to track base commit and change commit amounts, and uses the Scheduled Value column to track remaining balances.","Import and set up business processes for commitment funding. In addition to business processes that are used for project/shell funding, you can design business processes for use with commitment funding. In uDesigner, commitment funding is enabled on the base commit (and linked change commit); automatic generation of an SOV must also be enabled. Then, the ability to create (and later access) the commitment funding sheet can be enabled on the form. Be sure the spends business process that is linked to the base commit has been enabled to consume funding.","Step 1: Create and set up Commitment Funding Template (Admin mode). This template is used to create a commitment funding structure in the project/shell, which in turn is used to create the individual commitment funding sheets for each base commit record. You can add columns to the template, but not rows.","Step 2: Define funding assignment rules. This is done in the Assignment tab of the Properties window. Assignment rules can be defined in the commitment funding template, structure or sheets. (This step can be done any time after creating the funding or commitment funding template. If you define assignment rules in a template, they will be carried over to the structure and sheets created from them.)","Step 3: Create Commitment Funding Sheet Structure (User mode). Structures are created at the project level in User mode from a commitment funding template. When commitment funding sheets are created from base commit records, this default structure is used. You can also create a commitment funding structure in a project/shell template.","Step 4: Create individual commitment funding sheets. This is done automatically the first time you click the Funding button on a base commit business process form (this button becomes available on specific steps as designed in uDesigner). After creation, the commitment funding sheet is available for viewing or modification by clicking the Funding button on the base commit or associated change commits, or from the Commitment Funding log itself.","Additional steps: Configure permissions. Module permissions must be granted to the commitment funding template, to the commitment funding sheet in a project/shell template (if using), to commitment funding sheet in a project/shell (for the node to be visible). In addition, record level permission must be granted to individual commitment funding sheets. By default, the owner of the base commit will have permissions to the sheet. Additional users must be granted view or edit permissions. Refer to the Unifier Data Reference Guide for general funding permissions. Sheet permissions are granted User mode. Additional assignment details. After the commitment funding sheet and SOV sheet are created, additional funding assignment details can be defined on the Fund Assignment window (accessed from the SOV sheet or commitment funding sheet).","How to set up the Funding Manager","74580.htm");
Page[399]=new Array("The Fund Details form can be configured by creating a Fund Attribute Form in uDesigner. With the import of this attribute form, you are also importing designs for the fund picker, which is used to add funds to business processes and project/shell funding sheets, as well as &quot;Find&quot; on the picker. If you do not create a Fund Attribute Form, a default fund code form and fund picker will be used.","Only one Fund Attribute Form may be created and imported per company.","Notes:","Use caution when modifying and re-importing an attribute form. For example, if you change a data definition, such as Fund Category after it is being used in the funding sheet, the system may not see the new data definition and will produce an error.","Oracle strongly recommends that you use the Development environment to create your uDesigner business processes and attribute forms before deploying to the Test/Production environment.","To import a Fund Attribute Form into Unifier Production environment, see Importing Configuration Packages.","Importing Fund Attribute Form","74581.htm");
Page[400]=new Array("The Company Funding Sheet tracks all sources of funding across all projects or CBS shells. You create only one sheet per company. Funding sources that are made available at project/shell sheet level or commitment level are rolled up to the company sheet, which maintains the overall fund information. ","After it is created, the company funding sheet can be edited, but not deleted. The company funding sheet must be created before creating individual project/shell funding sheets.","To create the company funding sheet:","Go to the Company Workspace tab and switch to User mode.","In the left Navigator, select Cost Manager, and then select Funding. The Company Funding Log opens.","Click New. The Properties window opens.","Enter a Title and Description.","For Display Mode, choose Flat (no indenting of rows) or Tree (allows indented, nested rows).","Click Save. The funding sheet is listed in the Company Funding log.","Creating a Company Funding Sheet","74582.htm");
Page[401]=new Array("The columns on the company funding sheet are used to track project/shell level funding, as well as commitment level funding if you are using it, and keep track of fund balances. ","To add a column to the company funding sheet:","From the Company Funding log, select the company funding sheet and click Open from the gear menu ( @ ), or double-click the company funding sheet. The Company Funding Sheet window opens.","Click the Add Columns. The New Column window opens.","Complete the fields as described in the following table.","Click Save to add the new column to the company funding sheet.","In this field:","Do this:","Name","The name you choose will appear as the column header. You may manually enter a column name, or, if you leave the Name field blank, the selection you make in the Datasource field will automatically populate the Name field.","Type","Choose one of the following types:","From Business Process","Direct Entry","Line Item Content","Formula","Datasource","All columns must be associated with a data source. The data source that you choose will determine which of the following options are available. The types of Data sources available are as follow.","Single Sources: These values roll up from a single, defined source, such as a business process or a system defined source.","Logical Sources: These include user-defined Manual Entry or Formula columns.","Single Source","Data sources that contain funding sources and consumption information; that is, Fund subtype of Cost business processes, which allocate funding, Spends business processes that consume funding, and Commit business processes that trigger commitment funding, if used.","Business Processes: List of cost-type business processes that include funding data definitions.","Project/Shell Funding: Sum of all funding sources at project/shell level for each project/shell, as rolled up from each individual project/shell funding sheet. The information that gets rolled up to this column is dependent on the project/shell funding sheet setup for each project/shell.","CBS Funding: Sum of all funding sources at CBS level for each project/shell, rolled up from each individual project/shell funding sheet. The information that gets rolled up to this column is dependent on the project/shell funding sheet setup for each project/shell.","Manual Funding by project/shell: Sum of all project/shell-level funds that are allocated at project/shell level manually.","Manual Funding by CBS: Sum of all funds that are allocated at CBS level manually.","Commitment Funding: Sum of all funds that are allocated at the commitment level (if used) for each project/shell.","Records Funded at Project/Shell Level: Sum of all records that are funded at project/shell level. These are records that have already ended their workflow or hit terminal status.","Records Funded at CBS Level: Sum of all records that are funded at CBS Level. These are records that have already ended their workflow or hit terminal status.","Records Funded at Commitment Level: Sum of all records that are funded at the commitment level (spends BPs that are linked to base commits enabled for commitment funding). These are records that have already ended their workflow or hit terminal status.","Transient Records Funded at CBS Level: Sum of all records that are funded at CBS Level. These are records that are currently in process.","Transient Records Funded at Project Level: Sum of all records that are funded at project/shell level. These are records that are currently in process.","Transient Records Funded at Commitment Level: Sum of all in-process records that are funded at the commitment level.","Fund1 to Fund25: Generic data sources that can be used for manual entry or formula columns to make the values reportable.","Logical Sources","Logical sources include the following data sources.","Company Funding: This is commonly the column to use to manually enter the starting amount for each fund.","Company Fund1 to Fund25: Generic data sources that can be used for manual entry or formula columns to make the values reportable.","Data Format","The following options are applicable for Manual Entry or Formula columns.","Currency: right-aligns column contents and includes a currency symbol, formatting the value to the specified currency for the sheet.","Percentage: right-aligns the contents and includes a percentage symbol","Display Mode","The following options refer to whether the column is displayed on the sheet.","Show: Choose this option to allow users to view this column.","Hide: Hidden columns are active but not displayed and can be accessed by users with &quot;create&quot; permission on the funding sheet.","Column Position After","The new column will be inserted after the column selected.","Note: As funding is consumed from individual funds, the new balance will not be reflected on the company funding sheet by default. You can track your fund balances by adding columns to roll up funding assignments from business process or by manual assignments from the project/shell funding sheets, and commitment funding sheets if used, then adding a formula column to keep track of the balance. You can also use the rules engine to create a rule to keep this balance from going less than zero (or another amount).","Add Columns to the Company Funding Sheet","74583.htm");
Page[402]=new Array("Each row of a Company Funding Sheet represents an individual source of funds. The funds defined here are used in individual project/shell funding sheets.","Note: After fund assignments have been made against them on project/shell funding sheets, you will not be able to edit company funding sheet rows.","To add company funding sheet rows (funds):","From the Company Funding Sheet, click Add Row.","Complete the Fund Attributes window fields:","Fund Code","Fund Description","Fund Category","Fund Name","Fund Long Description","Click Save. The fund appears as a row on the Funding Sheet in alphabetical order.","To edit a row:","Click a fund code in a row, which appears as a link. The Fund Attributes tab opens in another pane.","Make changes and click Save.","Activate or deactivate a row:","From the Company Funding Sheet, click the Menu Options and select Fund Status.","Select the check boxes for each row you want to edit.","Click Activate or Deactivate. All the selected rows will have their status changed to Active or Inactive.","Click OK to close the Confirmation message.","To delete a row:","From the Company Funding Sheet, click the Menu Options and select Fund Status.","Select the check boxes for each row you want to edit.","Click Delete and Yes to confirm. All selected rows will be deleted.","Add Rows (Funds) to the Company Funding Sheet","74584.htm");
Page[403]=new Array("Funding templates are created and set up in the Templates node, and are used to create individual project/shell funding sheets. They can also be used to create a funding sheet in a project/shell template.","Setting up the funding template consists of adding columns, which correspond to the data sources (for example, business process transactions, formulas, values you enter manually, and so on) that you want to track for each funding source. It can also include adding rows (funds).","You can specify fund assignment rules in the template or individual project/shell funding sheets. See Defining Fund Assignment Options for Project/Shell Funding.","To create a funding sheet template:","Go to the Company Workspace tab and switch to Admin mode.","In the left Navigator, select Templates, select Funding, and then select Funding Sheet.","Click the New button. The Properties window opens.","Enter a Title and Description.","For Display Mode, choose Flat (no indenting of rows) or Tree (allows indented, nested rows).","Click OK. The template is listed in the log.","After creating the funding template, you can open the sheet and define columns and add funds (rows).","Creating a Project or Shell Funding Sheet Template","74585.htm");
Page[404]=new Array("These procedures are applicable to funding sheet templates, funding sheets, and funding sheets created in project/shell templates.","Funding columns specify the data sources (business process transactions, formulas, values entered manually, and so on) that will be displayed on the project/shell funding sheet. Default columns on funding sheet are Fund Code and Fund Name. If a Fund Attribute Form has been imported, in which the label of Fund Code data element and Fund Name data element were modified, the new labels will be displayed as column headers.","Note: Some project funding columns require assignment information at the project level and cannot be created in the template (for example, Consumed Funds, CBS Funding).","To add a funding column:","Open the funding sheet or template:","Open the funding template and click the Columns button. The Column Log opens, displaying the list of existing columns.","Click New. The Column Properties window opens.","Complete the Column Properties window as described in the table below.","Click OK to add the new column.","In this field:","Do this:","Name","The name you choose will appear as the column header. You may manually enter a column name, or, if you leave the Name field blank, the selection you make in the Datasource field will automatically populate the Name field.","Datasource","All columns must be associated with a data source. The data source that you choose will determine which of the following options are available. The types of Data sources available are:","Single Sources: These values roll up from other sources. These include cost type business processes, some pre-defined cost columns.","Logical Sources: These include user-defined Manual Entry or Formula columns.","Single Source","Data sources that contain funding sources and consumption information; that is, Fund subtype of Cost business processes, which allocate funding, Spends business processes that consume funding, and Commit business processes that trigger commitment funding, if used.","Business Processes: List of cost-type business processes that include funding data definitions.","Manual Funding by CBS: Sum of all funds that are allocated at CBS level manually.","Commitment Funding: If commitment funding is used, this data source tracks funds that are allocated across base commit and change commit business process records enabled for commitment funding. Reflects sum of Funding Across All Funds and Funding By Discrete Funds data sources on commitment funding sheets. Click the link to view cell details.","Records Funded at Project/Shell Level: Sum of all records that are funded at project/shell level. These are records that have already ended their workflow or hit terminal status.","Records Funded at CBS Level: Sum of all records that are funded at CBS Level. These are records that have already ended their workflow or hit terminal status.","Records Funded at Commitment Level: Sum of all records that are funded at the commitment level (spends BPs that are linked to base commits enabled for commitment funding). These are records that have already ended their workflow or hit terminal status.","Transient Records Funded at CBS Level: Sum of all records that are funded at CBS Level. These are records that are currently in process.","Transient Records Funded at Project Level: Sum of all records that are funded at project/shell level. These are records that are currently in process.","Transient Records Funded at Commitment Level: Sum of all in-process records that are funded at the commitment level.","Logical Sources","Logical sources include:","Project/Shell Funding: Sum of all funding sources at project/shell level. The information that gets rolled up to this data source is dependent on the project/shell Funding Sheet setup for each project/shell.","CBS Funding: Sum of all funding sources at CBS level. The information that gets rolled up to this data source is dependent on the project/shell Funding Sheet setup for each project/shell.","Manual Funding by Project/Shell: Sum of all funds that are allocated at project/shell level manually.","Fund1 to Fund25: Generic data sources that can be used for manual entry columns to make the values reportable.","Entry Method","This is applicable for logical data sources.","Manual Entry: Choose Direct Entry into Cell to allow entry directly into the cell, or Line Item Content to allow data entry through a line item window.","Formula: Values are calculated based on a specified formula entered for the column. Formulas can include the values of other columns. Click the Create button to create the formula.","Data Format","Applicable for Manual Entry or Formula columns:","Currency: right-aligns column contents and includes a currency symbol, formatting the value to the specified currency for the sheet.","Percentage: right-aligns the contents and includes a percentage symbol","Display Mode","Refers to whether the column is displayed on the sheet.","Show: This is the default choice. This indicates that column will display by default on the funding sheet to all users with at least &quot;view&quot; permission for the funding sheet.","Hide: Hidden columns are active but not displayed and can be accessed by users with &quot;create&quot; permission on the funding sheet.","Column Position After","The new column will be inserted after the column selected","Add a Column to the Funding Template (or Project/Shell Funding Sheet)","74586.htm");
Page[405]=new Array("Cost sheets can show fund related information as part of a Funding Manager solution.The following section discusses funding columns you can add to the project/shell cost sheet.","To add a funding column to the Project/Shell Cost Sheet:","Open the Cost Sheet template and click the Add Column button. The New Column window opens.","Complete the fields in the New Column window. For Data Source, choose from the following:","Line Item Content type: Data sources that contain fund related information:","Funded Records: Sum of all Records that are funded at CBS Level.","Unfunded Records: Sum of all Records that are not funded at CBS Level.","Manual Funding by CBS: Sum of all funding sources that are allocated at CBS level manually.","Formula type: Data sources that are available at project/shell level:","CBS Funding: Sum of all funding sources at CBS level. The information that gets rolled up to this data source is dependent on Project/Shell Funding Sheet setup for each project/shell.","Note: You cannot select this data source unless a funding source is selected under &quot;Processes Contributing Assignable Funds&quot; for CBS level. This is located under Project Funding sheet (open the Project Funding Sheet, select Properties, and then click the Assignment tab).","Click Save to add the new funding column to the project/shell cost sheet.","To edit a column:","Click the hyperlink text in the CBS Code column. The General tab will open in a secondary pane.","Edit information as necessary. ","Note: Although it is possible to change the entry methods for a column (for example, from &quot;Line item content&quot; to &quot;Direct entry into cell&quot;), use caution when doing so if you have already entered values in the column cells. For example, if you change from line item entry to direct cell entry, the Amount value shown in the cell will appear correctly, but will be an editable direct entry amount, and detailed line item information will be lost.","To move a column:","Click and drag the column headers in the log to rearrange columns. A blue line will appear, indicating where the column will be placed.","To delete a column:","Right-click a column header and select Delete. When the Confirmation message appears, click Yes to continue.","Note: If the column is being used in a formula in another column, you must remove the column from the formula before you can delete it. &nbsp;If the column contains a cell with line item data, you must first remove each line item before it can be deleted","Add a Funding Column to Project or Shell Cost Sheet","74587.htm");
Page[406]=new Array("These procedures are applicable to funding sheet templates, funding sheets, and funding sheets created in project/shell templates.","Each row of a project/shell funding sheet represents an individual source of funds. The funds added here are funds that are active under the company funding sheet.","Note: After fund assignments have been made against them, you will not be able to edit project/shell funding sheet rows. To view the status of a fund, click the Fund Status option in the Menu Options.","To add rows (funds) to the funding template or project/shell funding sheet:","Open the funding sheet or template.","Click Rows, and then click Add Row. The Fund Detail window opens. If you have imported a Fund Attribute form, a customized Fund Detail window will open.","Select a fund from the fund picker (or Fund Code field).","You can search for a specific fund in the fund picker by clicking the Find button and opening the Find form. Enter search criteria and click Search. This limits the number of funds that are displayed to those that match the search criteria.","You can search for a specific fund in the fund picker:","Click the Find button. The Find window opens. The window that opens will depend on the design in uDesigner.","If an attribute form is not defined, the default Find window will allow you to search by Fund Code or Fund Name.","If an attribute form is defined, the Find window can also be designed in uDesigner, and you may have additional fields to search by.","Enter search criteria and click Search. This limits the number of funds that are displayed to those that match the search criteria.","Click OK. The fund appears as a row on the Funding Sheet. Funds are displayed in alphabetical order on funding sheet.","To view fund details, click a fund under fund code column. If you import a Fund Attribute form then you will see customized detail form instead of a generic fund detail form.","Add Rows to the Funding Template","74588.htm");
Page[407]=new Array("The Project/Shell Funding Sheet tracks how funding is being allocated and consumed at the project/shell level. Project/Shell Funding Sheets work in conjunction with the Company Funding Sheet. Allocating funding sources at project/shell level can be done manually or through a business process.","A Funding Template and Company Funding Sheet must be completed before you can create a Project/Shell Funding Sheet.","To create the Project/Shell Funding Sheet:","Go to the shell tab and switch to User mode.","In the left Navigator, select Cost Manager, and then select Funding. The Funding Sheet log opens.","From the toolbar, click Create. The Select Template window opens.","Select a template, and click Create.","The Funding Sheet displays in the log. You can use the Funding Sheet as it is or set it up to meet the needs of the project/shell.","Note: Filters that you set up in the shell template for a Funding Sheet are not currently included in the Project/Shell Funding Sheet. To use filters, you must set them up in the Project/Shell Funding Sheet. For more information, see Searching for Fund Codes and Creating and Applying Filters in the Unifier Managers User Guide.","Creating a Project/Shell Funding Sheet","74589.htm");
Page[408]=new Array("Columns are added to a Project/Shell Funding Sheet in the same way as they are added to a Funding Template. See Add a Column to the Funding Template (or Project/Shell Funding Sheet).","Add Columns to the Project/Shell Funding Sheet","74590.htm");
Page[409]=new Array("Rows are added to a Project/Shell Funding Sheet in the same way as they are added to a funding template. Add Rows to the Funding Template","To edit a row:","From the Funding Sheet, click the Manage Rows button.","Use the arrow buttons to move items from the Available Company Fund Codes section to the Selected section.","Select all desired columns and click Save.","To remove a row:","From the Funding Sheet, click the Manage Rows button.","Use the arrow buttons to move items out of the selected section.","Remove all desired columns and click Save.","Add Project or Shell Funds (Rows)","74591.htm");
Page[410]=new Array("The following options are available as part of assignment rules at project/shell level and CBS level. These can be defined in a funding template, or individual project/shell funding sheets.","Project and CBS Level: Specify the sources of funds for this project/shell, either manual or via fund appropriation business processes.","Assignment Levels and Rules: For each funding business process (and each status) that has been set up for the project/shell, you specify manual, Auto Order, or Auto Ratio.","For details, see the following procedures.","Defining Fund Assignment Options for Project/Shell Funding","74592.htm");
Page[411]=new Array("After you create a project/shell funding sheet, you can set up assignment options. This includes specifying whether manual assignment is allowed; defining the business processes that can be used to assign funds to projects/shells or to specific CBS codes; and defining assignment levels.","Project Level and CBS Level: Specify how funds can be added for this project or shell. This can be Manual (appropriate funds manually from the company funding sheet) or through funding appropriation business processes that appropriate company funds for the project or shell.","You can define funding appropriations at the project level (not associated with specific CBS codes) and at the CBS level (funding is specified per CBS code). You can &quot;mix and match&quot; for each project, with some business processes using project level funding, and others CBS level. Manual fund appropriations can be done at both levels.","Assignment Levels and Rules: For each funding business process that has been set up for the project/shell, you specify manual, Auto Order, or Auto Ratio. You also choose to assign funds at the Project Level (funding is consumed based on the total of the spends business process, providing greater flexibility for fund assignment), or CBS Level (funding is consumed per line item of a spends business process, which provides greater control over how funds are spent on each item).","Manual: Funds can be manually assigned. As spends business processes (for example, invoices or payment applications) are routed and reach specified statuses, the amounts to be funded are collected under the Unassigned total on the funding sheet. Funds are assigned manually to these spends records.","Auto Order: Funds are assigned automatically when a spends business process reaches a specified status. Funds are assigned based on the fund order, which is defined on the funding sheet by clicking the Fund Assignment Order button. When funds are consumed on one fund, the next funding source is used for funding. After all funds are consumed, remaining spends are collected under Unassigned.","Auto Ratio: Funds are assigned automatically when a spends business process reaches a specified status. Funds are assigned based on the fund ratio, which is automatically calculated based on current fund levels. After all funds are consumed, remaining spends are collected under Unassigned.","Note: Be sure you have imported and set up any business processes you will be using for fund appropriation and assignment in the project/shell before setting assignment rules","To set up fund assignment rules:","Go to the Company Workspace tab and switch to Admin mode.","Open the company or shell funding sheet template:","In the left Navigator, select Templates, select Funding, and then select Funding Sheets; or","In the left Navigator, select Templates, select Shells, select the [shell type], and open the [shell template]; in the left Navigator, select Cost Manager, select Funding, and then select Funding Sheet.","Select the template in the log and click the Properties button.","Click the Assignment tab.","Complete the window as described in the following table.","Click OK.","In this field:","Do this:","Funding Assignment","Select the Funding Assignments sources. The sources can be at the CBS level, where funds are assigned to specific CBS codes, or project/shell level, which allows project/shell level funding without assigning funds to specific CBS codes.","Project/Shell Level","Click Add to add project/shell level sources. Options include:","Manual: Allows manual entry of project/shell fund assignments on the sheet","Business Processes: Any cost type business process that is created with sub-type Line Items with Fund Code and Classification as Generic.","CBS Level","Click Add to add CBS level sources. Options include:","Manual: Allows manual entry of CBS level fund assignments on the sheet","Business Processes: Any cost type business process that is created with sub-type Line Items with both CBS Code and Fund Code and Classification as Generic.","Assignment Levels","Allows you to set fund assignment rule for each spend-type business process that is configured in your project/shell. The assignment level will only show those spend type business processes that consume funds. This option is available while designing a spend type business process in uDesigner.  ","Assignment Rules","Click the drop-down list and select a project/shell-level or CBS-level rule.","Project /Shell Level:","Manual (Assign by BP Record Total): All spends are collected as Unassigned. These spends should be assigned manually to one or more funds at project/shell record Level.","Manual (Assign by BP Line Item): All spends are collected as Unassigned. These spends should be assigned manually to one or more funds at the project/shell line item.","Auto Order (Assign by BP Record Total): Funding sources are arranged in a prescribed order, and spend are assigned in that order. The assignment order is defined under the project/shell Fund Assignment Order window, which you can access by selecting Funding Sheet, and then selecting Fund Assignment Order.","Auto Order (Assign by BP Line Item): Funding sources are arranged in a prescribed order, and spend are assigned in that order at line item level. The assignment order is defined under the project/shell Fund Assignment Order window, which you can access by selecting Funding Sheet, and then selecting Fund Assignment Order.","Auto Ratio (Assign by BP Record Total): Funding sources are proportionally consumed until fully depleted. The fund level itself automatically defines the ratio. After the funds are consumed, remaining spends are collected as Unassigned.","Auto Ratio (Assign by BP Line Item): Funding sources are proportionally consumed until fully depleted at line item level. The fund level itself automatically defines the ratio. After the funds are consumed, remaining spends are collected as Unassigned.","CBS Level:","Manual: All spends are collected as Unassigned, and are manually assigned to one or more funds at CBS level.","Auto Order: Funding sources assigned to that CBS are arranged in a prescribed order, and spends are assigned in that order. After all funds are consumed, remaining spends are collected as Unassigned. Fund Assignment Order for CBS can be defined under Fund Assignment Order window, which you can access by select Cost Sheet, and then selecting Fund Assignment Order.","Auto Ratio: Funding sources assigned to that CBS are proportionally consumed until fully depleted. The fund level itself automatically defines the ratio. After all funds are consumed, remaining spends are collected as Unassigned.","SOV Auto Order: This option indicates that the assignment should be at SOV level using Auto order option. The order assignment will be defined under Fund Assignment window, which you can access by selecting SOV.","SOV Auto Ratio: This option indicates that the assignment should be at SOV level using Auto ratio option. The ratio will be defined under Fund Assignment window, which you can access by selecting SOV.","Set Up Funding Assignment Options","74593.htm");
Page[412]=new Array("You can control whether a fund is available when assigning funds to spend by activating or deactivating the fund at the project/shell level. Fund assignment order is required if you decide to consume funds automatically. You can also view the Fund order. This will be the order that will be used while assigning funds with Auto Order option.","Funds can be automatically consumed at project/shell level by following fund order defined under Fund Assignment Order window on project/shell Funding Sheet.","To set the fund assignment status and assignment order:","Go to the Company Workspace tab and switch to Admin mode.","Open the project/shell Funding Sheet:","In the left Navigator, select Templates, select Shells, select the [shell type], and open the [shell template].","In the left Navigator, select Cost Manager, select Funding, and then select Funding Sheet.","Open the Funding Sheet.","From the toolbar, click Fund Assignment Order. The Fund Assignment Order window opens showing whether funds are active or inactive.","Select a fund in the table, and click Activate or Deactivate. Deactivating a fund prevents it from being available when assigning funds to spend.","If you want to change the assignment order, select a fund and click Move Up or Move Down.","Click Close to exit the window.","Set Fund Assignment Status and Order","74594.htm");
Page[413]=new Array("The Unassigned (CBS Level) link on the Project/Shell Funding Sheet displays the total of funds at the CBS level. Funds can be automatically consumed at CBS level by following fund order defined for each CBS Code from the Fund Assignment Order window on the Project/Shell Cost Sheet.","To set fund assignment order at CBS Level:","Go to the Company Workspace tab and switch to Admin mode.","In the left Navigator, select Templates, select Shells, select Projects, and open the [shell template].","In the left Navigator, select Cost Manager, and then select Cost Sheet.","Open the Project Cost Sheet. ","Click the three dots at the bottom of the sheet, and then click the Fund Assignment Order tab.","Select a CBS code from the upper pane. A list of funds that are available for this CBS will be displayed on the bottom pane.","The bottom pane will also display assignment status of funds. You can modify assignment status of a fund from the Fund Assignment Order window in the Project Funding Sheet. Funds with Inactive status will not be used as part of consumption process.","Select a fund and click Move Up or Move Down button to change fund order.","If you have defined Breakdowns for a CBS code, select breakdown to view funds.","Set Fund Assignment Order at the CBS Level","74595.htm");
Page[414]=new Array("Funds can be automatically consumed at the SOV level by following fund order or fund ratio defined for each CBS in the Fund Assignment Order window on a SOV Sheet. You have ability to defined order or ratio for each SOV.","Note: Fund assignment details can be set on the SOV sheet when you are doing project/shell level funding as well as commitment level funding. The following procedure discusses how to do SOV Auto Order at the project/shell level. If the base commit that created the SOV has been enabled for commitment funding, then fund assignment is done at the commitment level.","To set the Fund Assignment Order at the SOV Level: for CBS&#8212;SOV Auto Order:","Open the SOV Sheet.","Select the Fund Assignment tab.","You can set Fund Order or Fund Ratio. This is dependent upon the Assignment Rule that you choose for spend under the Assignment tab of the Properties window for the Project/Shell Funding Sheet.","Select a CBS code.","Select a fund and then click OK.","The assignment status of funds displays. You can modify assignment status of a fund from the Fund Assignment Order window in the Project Funding Sheet. Funds with Inactive status will not be used as part of consumption process.","Perform any of the following actions: ","Select a fund to change the fund order.","If you have defined Breakdowns for a CBS code, select breakdown to view funds.","To add a fund:","Click the + Add button.","In the Add Funds window, select a fund available for the selected CBS Code, and then click OK.","Click Save.","To set the Fund Assignment Order and Ratio at the SOV Level: for CBS&#8212;SOV Auto Ratio:","Open the SOV Sheet.","Select the Fund Assignment tab.","You can set Fund Order or Fund Ratio. This is dependent upon the Assignment Rule that you choose for spend under the Assignment tab of the Properties window for the Project/Shell Funding Sheet.","Select a CBS code.","The assignment status of funds displays. You can modify assignment status of a fund from Fund Assignment Order window in the Project Funding Sheet. Funds with Inactive status will not be used as part of consumption process.","Perform any of the following actions:","Select a fund to change the fund order.","If you have defined Breakdowns for a CBS code, select breakdown to view funds.","To add a fund, click the + Add button. ","In the Add Funds window, select a fund available for the selected CBS Code, and then click OK.","Select a fund and enter a % value.","Click Save.","Set Fund Assignment Order at the SOV Level","74596.htm");
Page[415]=new Array("Commitment Funding Sheet templates are created and set up in the Templates node, and are used to create the commitment funding sheet structure in a project/shell (or in a project/shell template). This structure is then used when sheets are created for individual base commit records.","Setting up the commitment funding template consists of adding columns, which correspond to the data sources (for example, business process transactions, formulas, values you enter manually, and so on) that you want to track for each funding source.","You can specify fund assignment rules in the template, structure or individual commitment funding sheets.","To create a new commitment funding sheet template:","Go to the Company Workspace tab and switch to Admin mode.","In the left Navigator, select Templates, select Funding, and then select Commitment Funding Sheet.","Click the New button. The Properties window opens.","Enter a Title and Description.","Click OK. The template is listed in the log.","After creating the funding template, you can open the sheet and define columns.","Creating Commitment Funding Sheet Templates","74597.htm");
Page[416]=new Array("These procedures are applicable to commitment funding sheet templates, commitment funding structures created in a project/shell, commitment funding sheet structures created in project/shell templates, or individual commitment funding sheets.","Funding columns specify the data sources (business process transactions, formulas, values entered manually, and so on) that will be displayed on commitment funding sheet.","To add a column to a commitment funding template, structure or sheet:","Open the commitment funding sheet, template or structure.","Click the Columns button. The Column Log opens, displaying the list of existing columns.","Click New. The Column Properties window opens.","Complete the Column Properties window as described in the following table.","Click OK to add the new column.","In this field:","Do this:","Name","The name you choose will appear as the column header. You may manually enter a column name, or, if you leave the Name field blank, the selection you make in the Datasource field will automatically populate the Name field.","Datasource","All columns must be associated with a data source.","Note: In these data source definitions, the terms All Funds and Discrete Fund refer to the fund assignment options. These options determine how the SOV lines (and therefore, the commit lines) will be funded, either automatically or manually from the entire list of funds available to the commit, or by one specific fund. (See Define Commitment Fund Assignment Details.)","The data sources available for commitment funding sheets are:","Funding Across All Funds: Use this column to enter (or calculate) the amount of each fund to allocate for this base commit record. The rows on the sheet are the funds that will be used to fund the commit. The value entered here will be the fund amount available for all commit lines that have &quot;All Funds&quot; as assignment. This can be a manual entry column, or a formula that uses another manual entry column as the basis of the formula.","Funding By Discrete Fund: This column displays the sum total of all the line items of base and change commits that are funded by a specific (or &quot;discrete&quot;) fund. This value can be used to determine the fund balance during consumption.","Records Funded Across All Funds: Reflects the total of funds consumed from records that are funded based on All Funds, whether funding is done manually or automatically.","Records Funded By Discrete Fund: Displays the total of funds consumed from records that are funded based on a discrete fund, whether funding is done manually or automatically.","Fund Balance Across All Funds: This column tracks the fund balance across all funds. The formula used is (Funding Across All Funds) - (Records Funded By All Funds).","Fund Balance By Discrete Fund: This column tracks the fund balance by specific fund chosen in the Fund Assignment window. The formula used is (Funding By Discrete Fund) - (Records Funded By Discrete Fund).","Funding Ratio Across All Funds: The value of this column is calculated automatically. It reflects the % ratio to use when performing fund assignment ratio during consumption. The formula is (Fund Balance Across All Funds Per Fund) / Total of Fund Balance Across All Funds).","Commitment Funding 1 to 25: Numeric data sources that are available to use to enter values manually or create formulas based on other columns. These are reportable via user-defined reports.","Entry Method","Choose one (the options that are available are dependent on the data source chosen):","Manual Entry: Users enter values directly on the sheet.","Formula: Values are calculated using the entered formula. Formulas can include the values of other columns. Click the Create button to create the formula.","Display Mode","This controls the display of numeric column data.","Show as percentage. Data is displayed as %","Decimal places. Choose 2 to 8","Total","Determines what will display in the &quot;Total&quot; (bottom) row for the column:","Blank: The total of this column is not applicable and will not display on the cost sheet. Choose this column for percentage columns and other columns where it does not make sense to display the sum total.","Sum of All Rows: The sum total of the column values is displayed.","Use Formula Definition: For formula columns; the formula will be applied to the &quot;Total&quot; row in the same way it is applied to other rows in the column.","Column Position After","The new column will be inserted after the column selected","To create a formula column:","In the Column Properties window, choose Formula as the Entry Method, and then click Create. The Formula Creation window opens.","Enter the first value in the formula:","To enter numerical values into the formula, click the number keys on the on-screen keypad. (Include parentheses, % or decimal point as necessary.)","To add a column value into the formula, select it from the list in the left pane, and then click Select (or double-click it). Options include:","Columns: These are columns that have been added to the sheet. The value in the corresponding row will be used in the formula.","Total Elements: These are the columns on the sheet that display a total (either the sum or formula definition, as defined in the Total option for that column). The value of the Total for that column will be used in the formula.","An additional default Total Element is also available: Commitment Total Funded By All Funds. It is the sum of all commit line items (base and change commits) that have the assignment option &quot;All Funds&quot; (as selected for each commit line on the Fund Assignment window).","As you build the formula, it appears in the Formula box in the upper right portion of the window.","Click the appropriate operator: add, subtract, multiply, or divide.","Continue to alternate between choosing values and operators to add to the formula.","You may click Undo at any time to undo the last action. Click the Clear All button to clear the entire formula.","When the formula is complete, click OK to save your formula and return to the Column Properties window.","To change the formula after creating it, click Modify (next to the Formula option), clear the old formula (click Undo or Clear All), and then re-enter it.","To create a column by copying an existing column:","In the Column log, select a column and click Copy. The Column Properties window opens.","Make changes as necessary for the new column. You must change at least the data source.","To edit a column:","In the Columns Log , select a column and click Open. The Column Properties window opens.","Make edits as necessary and click OK.","Note: Although it is possible to change the entry methods for a column, use caution when doing so. For example, if you change the entry method from Manual Entry to Formula, any existing values you have entered in that column will be replaced with the formula. Some column properties for some system data sources cannot be modified.","To move a column:","In the Columns Log, select a column to move, and then click Move Up (Left) or Move Down (Right). The order in which the columns appear in the Log window is the order (from left to right) that they appear on the sheet.","To delete a column:","Select a column from the Columns Log and click Delete. The column will be deleted.","Note: If the column is being used in a formula in another column, you must remove the column from the formula before you can delete it.","Add and Manage Commitment Funding Sheet Columns","74598.htm");
Page[417]=new Array("Fund Assignment refers to how funds are to be consumed as spends type business processes (for example, invoices and payment applications) come in against the base commit that is being funded.","The first step is defining the Assignment rules&#8212;whether funding is to be done manually or by auto ratio. The assignment levels and rules are defined on the Assignments tab in the Properties window of the commitment funding sheet. This step is required to do commitment level funding.","The Assignment tab lists the spends business processes that are linked to base commits enabled for commitment level funding. For each listed business process, you define how fund assignment will be done when these spends records come in against the base commit (either manually, or automatically by fund ratio).","You can define these assignment rules on the commitment funding template. When you create a commitment funding structure in a project/shell, these assignment rules will be copied to it, and when you create sheets from the structure, they will be copied to the sheets. If you need to, you can modify these rules on individual structures and sheets.","The next step is optional: define Fund Assignment details per SOV line; that is, define whether a specific fund must be used to fund a particular line on the commit. This allows you to provide details about fund assignment or consumption for each line on the base commit or any change commits. You access the Fund Assignment window by clicking the Fund Assignment button on the commitment funding sheet or SOV sheet associated with the base commit.","If you do not define any assignment options in this window, All Funds is the default selection. This means that all funds that have been allocated to the base commit on the commitment funding sheet will be available for funding each line of the spends business process created against it (either manually or by auto ratio, as defined by the assignment rules).","Fund assignment on these lines is tracked by commitment funding sheet columns using data sources that for records or fund balance &quot;across all funds.&quot; For more information, see Add and Manage Commitment Funding Sheet Columns.","Sometimes, you may need to specify that a specific fund be used to fund a specific CBS code or SOV line. For these lines, you can select a specific fund (or &quot;discrete fund&quot;). Fund assignment is then tracked by commitment funding sheet columns using data sources for records or fund balance &quot;by discrete fund.&quot;)","For details, see the following procedures.","Defining Fund Assignment Options for Commitment Funding","74599.htm");
Page[418]=new Array("The fund assignment rules define how assignment will be done on the spends business processes created against the base commit being funded: either manually or automatically by fund ratio.","Funding assignment levels and rules can be defined in the commitment funding template, structure, or individual sheets. It is easiest to set them once, in the template, and have them carried forward into the structures and sheets created from it. If necessary, these options can be modified later for individual structures and sheets. These rules must be defined on the commitment funding sheet to do commitment level funding.","To set up commitment funding assignment rules:","Open the Properties window of the commitment funding template, structure or sheet. (From the File menu, choose Properties.)","Click the Assignment tab.The list displays all General Spends and Payment Application Business Processes that are linked to a Base Commits that has been enabled for commitment funding and has been designed to consume funds according to the design.","For each listed spends business process, click the Assignment Rule drop-down and select one of the following:","Commitment Level - Manual: Funds are manually assigned at runtime. As spends business processes are routed and reach specified status, the amounts to be funded are collected under the Unassigned total on the commitment funding sheet, similar to project/shell level manual funding. You can then select each line of the spends BP and assign funds at runtime. Consumed funds roll up to the commitment funding sheet and the project funding sheet.","Commitment Level - Auto Ratio: Funds are assigned automatically when the spends business process reaches a specified status. Funds are assigned based on the fund ratio, which is calculated based on the fund levels (using the value in the column of data source Funding Ratio Across All Funds on the commitment funding sheet), and is managed and tracked on the commitment funding sheet. If all funds are consumed, any remaining spends amounts are collected under Unassigned.","Click OK.","Define Commitment Fund Assignment Rules","74600.htm");
Page[419]=new Array("This is an optional step that allows you to provide details about fund assignment or consumption for each line on the base commit or any change commits. The commitment funding sheet works in conjunction with the SOV sheet in tracking the individual line items on the base commit and any change commits. Therefore, you can define details about fund assignment per SOV line. This is done on the Fund Assignment window.","By default, all funds that have been allocated to the base commit on the commitment funding sheet will be available for funding each line of the spends business process created against it (either manually or by auto ratio, as defined by the assignment rules).","However, to specify that a specific fund must be used to fund a specific CBS code (or SOV line), you can specify a specific (or &quot;discrete&quot;) fund to use.","You can do fund assignment one row at a time, or several rows at a time (bulk assignment). See the following procedures.","Note: If you do not define fund assignment options, the default will be All Funds for each SOV line.","To set fund assignment details (one row at a time):","Open the commitment funding sheet or the SOV sheet template.","From the toolbar, click Properties, and select the Assignment tab. The fund assignment grid view displays each line that is present on the SOV sheet, including CBS breakdowns. (The Fund Assignment button is available on the commitment funding sheet after the SOV has been created for the base commit.) ","In the Assignment column, click the drop-down and choose the assignment:","All Funds: This is the default option. This means that all funds allocated to the commitment funding sheet are available to fund the SOV line or breakdown. (This option must be used if you are doing assignment by auto-ratio.)","On the commitment funding sheet at runtime, funding consumption will roll up to the column using data source &quot;Funding Across All Funds.&quot;","&lt;Fund Code-Fund Name&gt;: Each fund that has been allocated to the commitment funding sheet will display on the drop-down alphabetically. These are referred to as &quot;discrete funds.&quot; You can choose to assign a specific fund to an SOV line or breakdown. This means that only that fund will be used to fund that line. (You can choose the same fund code for multiple lines.)","On the commitment funding sheet at runtime, funding consumption will roll up to the column using data source &quot;Funding By Discrete Fund.&quot;","Note: If an SOV line has a breakdown, select an assignment for each breakdown, not the SOV line itself.","Click Save to save the sheet.","To set fund assignment on multiple rows on the SOV sheet (bulk assignment):","Open the commitment funding sheet or SOV sheet.","From the toolbar, click Properties, and open the Assignment tab. The fund assignment grid view displays each line that is present on the SOV sheet, and includes an Assignment column.","Select a row, or multiple rows by holding down the Shift key (to select a range of rows) or Ctrl key (to select rows throughout the sheet) while clicking the rows.","Click the Bulk Assignment button. The Bulk Assignment window opens.","Click the Assignment drop-down and choose the assignment. The values listed are the same as on the Fund Assignment window for the individual SOV lines.","Click the Update button.","Click Save on the Fund Assignment window to save your changes.","Define Commitment Fund Assignment Details","74601.htm");
Page[420]=new Array("The Schedule of Values (SOV) sheet provides a view of all the following information in one Sheet:","Purchase Orders (Base Commits)","Change Orders (Change Commits)","Payment History (Pay App)","The system supports the following types of SOV:","General Spends","Payment Applications","Summary Payment Applications","The needed SOV type is designed in uDesigner.","The data for the SOV sheet comes from the following BP types:","Base Commit","Change Commit","The business processes can be designed to create an SOV sheet automatically upon reaching the designated step.","When line items are added to the SOV sheet, the order of line items in the sheet is based on the time line that the line items were rolled up from the Base Commit and Change Commit records.","The data seen in the SOV sheet is based on the order in which the SOV lines were created. You can use the numeric column to sort the data based on the number that you specify.","When a Base Commits Business Process (BP) is approved, it creates a Schedule of Values (SOV) sheet. The SOV sheet is the &quot;working document&quot; on which committed monies are entered. The committed monies shown on the SOV sheet are rolled up to the Company Cost Sheet.","Note: The Change Commits BPs continue to change or add costs to the SOV during the life of the Project/Shell.","The Schedule of Values (SOV) functionality provides a way to assemble information from contract, change order, and invoice/payment BPs into a SOV sheet, streamlining the process of invoicing for completed phases of a Project/Shell.","SOV functionality is available for Cost type BPs in which the Allow creation of Schedule of Values option is defined, or selected, in the design properties. The BPs can be designed to create an SOV sheet automatically upon reaching the designated step.","You may define one SOV sheet per Commit BP, for example, a Purchase Order or a Contract. Rows are automatically populated based on the CBS/Cost/Accounts codes defined in the Commit BP.","Before you can create an SOV:","Design Commit type BP in uDesigner and deploy.","Configure and set up commit BP.","SOV functionality is available with commit BPs, for example a Purchase Order for which the Create SOV option is selected in uDesigner. For these BPs, the system automatically creates a SOV sheet upon reaching the designated step. There may be one SOV sheet per Commit Business Process. Rows are automatically populated based on the CBS/Account Codes defined in the Commit BP.","Create and set up the Project/Shell Cost sheet.","Setting Up Schedule of Values (SOV)","74602.htm");
Page[421]=new Array("Before you begin","Base Commits and Change Commits Business Processes must be set up for the Project/Shell.","Step 1: Create and set up SOV template (General Spends only)","You can create a template in the Templates log in Admin mode. If you are using General Spends SOV, the structure that will be used for the SOV sheets is created from the template.","Note: You can define a General Spends SOV structure by copying from an SOV template in the Templates log.","Step 2: Set up SOV Structure (User mode)","SOV Sheets are created, either manually or automatically, from Base Commits, based on the structure that is set up in Step 1.","For General Spends SOV, the SOV structure is copied from an SOV template.","For Payment Application SOV and Summary Payment Application SOV, the structure is copied from the line item grid structure of the Payment Application Business Process. This means that you must first complete the Business Process (BP) setup for the Payment Application BP before you can create the structure.","Step 3: Create SOV Sheets","You can create General Spends, Payment Applications, and Summary Payment Applications SOV structures in project templates. ","How to Set Up SOV","74603.htm");
Page[422]=new Array("An SOV Template needs to be created and set up before you can create a SOV sheet. SOV sheets are created using an SOV Template that defines the columns that will appear on the SOV sheet.","Note: All SOV sheets in a single Project/Shell will use the same template structure.","If an SOV Template does not exist when an SOV sheet is auto-created from a Cost type BP, one will be created automatically with the default columns CBS Code and CBS Item and Breakdown Data. You can edit this structure as needed, but the default columns are not editable.","To create an SOV Template:","Go to the Company Workspace tab and switch to Admin mode.","In the left Navigator, select Templates, select Shells, select Projects, and open the [shell template].","In the left Navigator, select Cost Manager, select Schedule of Values, and then select Payment Applications.","From the toolbar, click Update Structure to open the Payment SOV Structure window.","From the File menu, select Properties to open the Properties window.","The Properties window has two tabs: General and Options.","In the General tab, enter values in the Name and Description fields.","Click the Options tab.","Use the Options tab to define the labels (Labels block) that will be used for the SOV column headings.","The fields listed in the Labels block are the name of labels that are displayed as column headings on the SOV sheet.","You may change the labels or accept them as is.","For clarity, consider using the same labels as is used in the Cost Template and Cost sheets.","Read the following and when finished click Apply and then OK.","The following explains how to set up the fields in the Properties window, Options tab:","Field","Description","Item #","Applicable to both Company level templates and Project/Shell level templates.","At the project/shell level: Go to the Company Workspace tab and switch to Admin mode. In the left Navigator, select Templates, select Shells, select the [shell type], and open the [shell template]. In the left Navigator, select Cost Manager, select Schedule of Values, and then select Payment Applications.","At the project/shell level: Go to the Company Workspace tab and switch to Admin mode. In the left Navigator, select Templates, select Shells, select the [shell type], and open the [shell template]. In the left Navigator, select Cost Manager, select Schedule of Values, and then select Summary Payment Applications.","At the company level:  Go to the Company Workspace tab and switch to Admin mode. In the left Navigator, select Templates, and then select General Spends SOV.","The Item # field is a system-defined column, with a fixed location on the screen, and it is not available in the column structure window.","You can change the Item # column name in the SOV properties page. ","Ref","Refers to a reference number for the entire commit. (Another example of a label for this column is &quot;Order Number.&quot;)","CBS Code","This field is not editable.","CBS Item","This field is not editable.","Breakdown","The CBS Code Breakdown that you specify in the CBS Detail window for that code.","Description","This label refers to the line item description when the SOV is in line item mode.","The Schedule of Values node, under Project/Shell templates, contains the following sub-nodes:","General Spends","Payment Applications","Summary Payment Applications","The Summary Payment Applications sub-node lists the Business Processes (BPs) of the Summary Payment Applications SOV sheets that have been configured in the template.","You cannot define the structure if a Base Commits or Change Commits BP of Summary Payment Applications SOV sheet is not configured in the template.","You can define one Summary Payment Applications SOV type template for every Base Commits of Summary Payment Applications SOV type BP.","If the Summary Payment Applications SOV sheet is configured in the Project/Shell templates, you can select columns from the Data Elements that are defined on the Detail form of the Summary Payment Applications SOV sheet, and the Base Commits. ","Creating an SOV Template","74604.htm");
Page[423]=new Array("Columns determine what data is displayed on the SOV sheets. You can add, modify, delete, hide/unhide columns on the structure. Any modifications you make on the structure will be reflected on all SOV sheets for that project/shell. Columns can be added to the SOV Template or Structure. Each column represents a data source. At a minimum, include a column for Commits Remaining Balance to enable validation of Spends against the Commits. ","Note: This information is applicable to adding or editing columns in an SOV template or structure.","To add an SOV column:","Open the SOV template or structure.","Click the Columns button. The columns log opens.","The three default columns (CBS Code, CBS Item, and Breakdown) for the General Spends and Payment Applications are not editable and do not appear in the log.","The default columns (Cost Code, Code Name, Cost Line Item Type, and Description) for the Summary Payment Applications are also not editable and do not appear in the log.","Click New. The Column Properties window opens.","Complete the Column Properties window and click OK.","In this field:","Do this:","Name","The name you choose will appear as the column header. You may manually enter a column name, or, if you leave the Name field blank, the selection you make in the Datasource field will automatically populate the Name field.","Datasource","All columns must be associated with a data source. The data source that you choose will determine which of the following options are available. ","Single Sources","These values roll up from single defined sources, including business processes.","Logical Sources","The options are:","None: Lets you manually configure the column as a manual entry or formula column to suit your needs.","Commits Remaining Balance: Commits Remaining Balance is a column on the SOV Template/Structure. It reflects the amount of your commits minus the spends, according to a formula you define.","Scheduled Value: This is a formula column can be used to keep track of the remaining SOV balance. (Example formula: Base Commit (Approved) + Change Commit (Approved) - General Spends Invoice (Approved))","Note: Be sure to add a Scheduled Value column to the SOV sheet if you will be doing commitment level funding. ","Entry Method","This is applicable for logical data sources.","Manual Entry: Choose Direct Entry into Cell to allow entry directly into the cell, or Line Item Content to allow data entry through a line item window.","Formula: Values are calculated based on a specified formula entered for the column. Formulas can include the values of other columns. Click the Create button to create the formula.","Data Format","Applicable for Manual Entry or Formula columns:","Currency: right-aligns column contents and includes a currency symbol, formatting the value to the specified currency for the sheet.","Percentage: right-aligns the contents and includes a percentage symbol","Display Mode","Refers to whether the column is displayed on the cost sheet.","Show: The default choice. This indicates that column will display by default on the cost sheet to all users with at least &quot;view&quot; permission for the cost sheet.","Hide: Hidden columns are active but not displayed on the cost sheet. Hidden columns can be accessed by users with &quot;create&quot; permission on the cost sheet.","Column Position After","The new column will be inserted after the column selected","Allow sub-breakdown with validation","If this option is selected, the sum of breakdown amounts is validated against the CBS summary amount. That is, the sum of the breakdowns cannot exceed the amount of the CBS code itself.","Add SOV Columns","74605.htm");
Page[424]=new Array("This section describes how to delete a Schedule of value-based record from a specific shell template.","Note: You can delete a Schedule of value-based record from a specific shell template but not from other Projects/Shells that have been created using the template.","Go to the Company Workspace tab and switch to Admin mode.","In the left Navigator, select Templates, select Shells, select the [shell type], and open the [shell template].","In the left Navigator, select Cost Manager, select Schedule of Values, and then select Payment Applications.","Select a schedule of value-based record for deletion.","Click Delete.","When the prompt appears that asks you to confirm deletion, click Yes to delete the schedule of value-based record.","Deleting Schedule of Values","10293660.htm");
Page[425]=new Array("The Cash Flow module lets you generate and compare Baseline, Actuals (or &quot;spends&quot;), Portfolio, Forecast, Derived, and Custom curves in a project or CBS code-based shell. The curve detail levels include:","Cash Flow by Project/Shell","You can track the costs associated with an entire Project/Shell over time.","Cash Flow by CBS","The creation of a CBS detail curve is similar to cash flow by Project/Shell. Use this option if cash flow needs to be tracked at the CBS level as opposed to the Project/Shell level; this lets you plot cash flow curves by specific CBS codes, or all codes, in the Project/Shell.","Cash Flow by Summary CBS","The creation of a Summary CBS detail curve is very similar to cash flow by CBS. Use this option if cash flow needs to be tracked by summary CBS codes. To select this option, the Project/Shell cost sheet must use a tree structure (and therefore has summary CBS codes) rather than a flat structure.","Cash Flow by Commitment","This option lets you plot and analyze cash flow data for an entire commit record (including base commit, any change commits, and related invoices). You can choose a specific business process commitment record within the Project/Shell, such as a purchase order or contract, and track the cost information over time. Each commitment record can have one baseline curve.","The system displays Cash Flow curve detail level data in a Cash Flow Worksheet. The cash flow curve worksheet can display any number of Baseline, Forecast, Actual (or Spends), Portfolio Budget, Derived, or Custom curves (based on the same detail level). Depending on curve set up, you can manually enter data; pull data automatically from other sources such as business processes, cost sheet columns, and schedule manager dates (depending on the curve type); and compare multiple curves.","At runtime, the user can view the cost distribution information by CBS code from a schedule sheet.","Note: The system generates Actuals information at the start of the day and uses it to update the Forecast information. Therefore, on the last day of an Auto Snapshot (the cutoff date), the Forecast does not include changes that might have occurred between the generation of the Actuals and the generation of the Forecast, and the system might prevent you from updating Actuals information on the last day of the cycle.","To facilitate creation of cash flow curves and roll up of data to company cash flow worksheets, you can create the following in Admin mode:","Data Sources","You create data sources that can be used to create and identify cash flow curves, and roll up data to company worksheets. You will need to create data sources to create cash flow curves.","Data sources are created based on a Curve Type: Baseline, Forecast, Actual (or Spends), Portfolio Budget, Derived, or Custom curves. Each curve type has its own logic to address different business requirements.","Distribution Profiles","These are optional. Distribution profiles can be applied to cash flow curves to automatically distribute cost data across a specified time period. At runtime, you will have the option of manually distributing data in the cash flow worksheet, or automatically distributing the data using one of these profiles.","Company-level Templates","These are also optional. You can create cash flow detail curve templates, which can be used to create curves at runtime within a project/shell.","Project/Shell-level Templates","You can create cash flow curves within a project template or a CBS-code based shell template. These can be used to create curves in projects/shells; they can also be used to &quot;push&quot; out updates to existing curves. For more information, see Update Cash Flow Properties and Permissions.","Setting Up Cash Flow","74606.htm");
Page[426]=new Array("Here is an overview of the steps required to set up the cash flow module.","Note: There are two Cash Flow modules: the module in effect prior to the 9.3 release is called Cash Flow (Basic); the module introduced in 9.3 and discussed here is named Cash Flow. Each module has its own User and Admin mode permissions.","Step 1: Grant yourself permissions to configure the cash flow modules.","Step 2: Create custom cash flow data sources. These are used to create curves in projects/shells. You also define a color for each data source, which will display as the curve color on the cash flow graphs. See Creating Cash Flow Data Sources.","Step 3: Create distribution profiles. These profiles can be used to distribute cost or any value over a period of time. See Distributing Cost Data.","Step 4: Create cash flow templates. You can create any number of cash flow templates at the company level, or create cash flow curves within a project/shell template. Setting up cash flow templates is essentially the same as creating the curves manually in a project/shell (or a project/shell template), with some exceptions that are mentioned in the setup procedure details. You can use company-level and project/shell level templates to quickly create cash flow detail curves and rollup curves in projects/shells. See Cash Flow Curve Templates.","Step 5: Create cash flow in a project/shell. You can create any number of cash flow curves in a project/shell. These can be detail level or rollup curves. You can create them manually, by copying an existing curve, or by copying a template, see Cash Flow in the Unifier Managers User Guide.","Step 6: Create cash flow in a company. You can create rollup curves in the company workspace (Company Workspace tab), and roll up cash flow data from projects/shells. See Create Roll-up Templates.","Step 7: Grant cash flow permissions to users.","How to Set Up Cash Flow","74607.htm");
Page[427]=new Array("You must grant permission to yourself, another administrator, or group such as Company Administrators, to configure cash flow modules.","To grant yourself configure permissions:","Go to the Company Workspace tab and switch to Admin mode.","In the left Navigator, select User Administration, and then select Access Control.","On the right pane, expand Administration Mode Access, expand Standards &amp; Libraries, expand Cash Flow, and select Data Sources.","In the Module Permission Settings window, click the Add button. The Permission/Access Control window opens.","Click the Add Users/Groups button. The User/Group Picker opens.","Select the user(s) to whom you want to give configuration permission and click the Add button. Then click OK.","The system adds the name(s) to the Permission/Access Control window.","Under Permission Settings, select Modify and View and click OK. The system adds the name(s) to the Permission Settings window.","Repeat these instructions to grant permission to cash flow Distribution Profiles and cash flow Templates. (Give these modules Create permission.)","Click OK.","Grant Yourself Permissions to Configure Cash Flow","74608.htm");
Page[428]=new Array("You can create profiles manually or by copying an existing profile.","To create a distribution profile manually:","Go to the Company Workspace tab and switch to Admin mode.","In the left Navigator, select Standards &amp; Libraries, select Cash Flow, and then select Distribution Profiles. The Distribution Profiles log opens.","The default Distribution Profiles record displays in the log. All profiles are stored in this record.","Select Distribution Profiles in the log and click Open (or double-click Distribution Profiles). The Edit Distribution Profiles window opens.","The left side of the window displays the list of the distribution profiles. The right side of the window displays a graphical representation of the profile and is used to define it.","Click the New button. This adds a new row to the Distribution Profiles list.","Enter a unique Name for the profile (up to 30 characters).","Be sure the Active check box is selected if you want it to be available for cash flow curves. If you deselect this check box, the profile will not be available for selection on curves.","Define the distribution profile on the graph by entering values in the Profile % slots.","By default, when you create a distribution profile, the graphical display will be a linear distribution. (5% is entered into each of the 20 slots: 5% x 20=100%.) You can modify this profile by entering a value for each slot for the Profile %. The graph will reflect the values that you enter.","You can enter values with up to two decimal places per slot. Press the Tab key to move one slot to the next. The total of all the slots for the Profile % must add up to exactly 100%.","When the distribution profile is complete, click the Save button.","To create a distribution profile by copying an existing profile:","In the Edit Distribution Profiles window, select a profile and click Copy. A new row is added, and the selected profile information is copied.","Enter a new Name for the copied profile. Make any changes to the profile values as needed and click Save.","Note: Per design (for example, in a Front Loaded Distribution Profile), if the Profile % reaches 100% before the 20th bucket (the zero is displayed at this point), and there is still unallocated budget remaining, when a Cash Flow Forecasting is linked to the Spends, the remaining unallocated budget will not be automatically distributed to the buckets with zeros.","Create a Cash Flow Distribution Profile","74614.htm");
Page[429]=new Array("You can delete distribution profiles if they are not currently being used in the system. If a distribution profile is being used, you can delete it if you replace it with another profile first. This is explained in the following procedure.","To delete a distribution profile:","Open the Distribution Profile window.","Select one or more profiles from the list on the left. Press the Ctrl or Shift key to select multiple profiles.","Click the Delete button.","If the profiles you selected are not currently being used by the system, a warning message opens. Confirm that you want to delete the profiles by clicking Yes.","If you selected multiple profiles and one or more of them are being used by the system, an error message opens displaying the profiles currently in use.","To delete a profile that is currently in use, go to Step 4.","Close the error window.","You can delete the profiles that are not in use by selecting them again from the Distribution Profiles window and clicking Delete.","If you select a single profile that is being used by the system, you will be prompted to replace the profile with another profile.","The Select a Distribution Profile window opens.","Click the Select button and select a new profile from the list.","Click OK. The profile being deleted is replaced with the profile selected in this window. When the curve using the profile is refreshed at runtime, the new profile will take effect.","Delete a Distribution Profile","74615.htm");
Page[430]=new Array("You can edit a distribution profile. The change will take effect in curves that use the profile the next time the curve is refreshed.","To edit a distribution profile:","Open the Distribution profile window.","On the left side of the window, select the distribution profile to edit.","You can edit the profile Name. If the profile is used by a curve, the name change will be reflected in the curve Properties.","You can select or deselect the Active check box. Active profiles are available for selection when choosing a default profile for auto distribution. Inactive profiles will not show up on the selection list. If you inactivate a profile and a curve is already using it, the curve will not be affected; it will still use the profile.","On the right side of the window, you can change the Profile % values. Change will be reflected in curves that use the profile when the curve is refreshed.","Click Save to save the changes. If the profile is being used by one or more curves, the profile change will take affect the next time the curves are refreshed.","Edit a Distribution Profile","74616.htm");
Page[431]=new Array("You can add multiple curves to a cash flow worksheet so you can view and compare curves side by side. These curves are based on the data sources you add here.","Each data source is used to identify one of the curves on a worksheet, and therefore can be used once per worksheet. However, you can reuse the data sources on different worksheets. You can create as many data sources as you need to create cash flow curves.","When you create a data source, you associate it with a Curve Type. Each curve type has a built-in logic when creating the curve using the data source. The curve types are:","Baseline: Choose this to create a Baseline curve. You can choose to manually enter the cost data, or automatically pull the data from a cost column, such as a Budget.","Forecast: Choose this to create a curve that helps forecast future cash flow based on actual spends records.","Actuals (Spends): Choose this to plot spends data over time.","Portfolio Budget: Choose original or shared option to create a Portfolio Budget curve.","Derived: Choose to create a Derived curve.","Custom: You can create Custom curves that you can use to enter data, or to compare against other curves. The setup is similar to the Baseline curves.","To create a Cash Flow data source:","Go to the Company Workspace tab and switch to Admin mode.","In the left Navigator, select Standards &amp; Libraries, select Cash Flow, and then select Data Sources. The Data Sources log opens. By default, there is one Data Sources record displayed in the log. All data sources are stored in this record.","Select Data Sources in the log and click Open (or double-click Data Sources). The Edit Data Source window opens.","Click the Add button. This adds a new row to the window.","Enter a Name for the data source. The name must be unique and not exceed 30 characters.","Press the Tab key to move to the next field.","Select a Curve Type from the drop-down list: Baseline, Forecast, Actual (or Spends), Portfolio Budget, Derived, or Custom curves.","You can make your selection by clicking the field and selecting from the list, pressing the first letter of your selection on the keyboard (for example, press the B key to select Baseline), or you can use the arrow keys on your keyboard to browse the list and make your selection.","Press Tab to move to the next field.","Select a Color.","This color will be used on the cash flow graph at runtime when a curve is generated from the data source. There are 256 colors (including &quot;0&quot; for black) to choose from.","Like the Curve Type field, you can click the field and select from the list; press the arrow keys to browse the colors; or, if you know the number of the color that you want, you can type it directly then press Enter.","To rearrange the data sources, select on the list and click the Move Up or Move Down buttons. This is the order in which the data sources will be presented when a user creates a curve.","Click OK to save and exit the window.","Creating Cash Flow Data Sources","74609.htm");
Page[432]=new Array("You can remove a data source from the list only if it is not being used by any cash flow curves.","If a data source is in use and you want to delete it, you must first delete any curves using it (these are the curves defined in the cash flow Properties window, Curves tab).","To delete a cash flow data source:","Go to the Company Workspace tab and switch to Admin mode.","In the left Navigator, select Standards &amp; Libraries, select Cash Flow, and then select Data Sources. The Distribution Profiles log opens.","To open the Edit Data Source dialog box, double-click Data Sources.","Select the data source to delete and click the Remove button. The row is deleted.","Click OK to save and exit the window.","Delete a Cash Flow Data Source","74611.htm");
Page[433]=new Array("You can edit the data source color, which changes the color of the curves using the data source. You can also change the row order, which changes the order that data sources appear on the selection list when creating a curve.","Notes:","Curve Type is not editable.","The data source name can be changed, but use caution when doing so. If you rename a data source, the curves that use the data source will not recognize the new name, and the data will not be visible on the curves. If you change the name back to the original name, the data will appear again on the curves.","To edit a cash flow data source:","Open the Cash Flow Data Sources (Cashflow Datasources) window.","You can make changes as necessary, based on the information.","Click OK to save and exit the window.","Edit a Cash Flow Data Source","74612.htm");
Page[434]=new Array("When you create a cash flow curve, the system distributes cost data using the distribution method defined in the cash flow curve properties. Distribution can be either manual, or automatic from a defined profile.","In User mode, the system displays commitment curve cost data in the record transaction currency, but stores costs in project currency. Currency conversion uses the active exchange rate set.","Baseline curves use the exchange rate that was active at the time of record creation.","Actuals curves use the exchange rate that was active at the time the money was paid.","Forecast curves use the exchange rates in effect for each time period over the duration of the curve.","If the transaction currency is different from the project currency, you can change the currency view between transaction and project currencies. You can only edit data in the transaction currency view. If there is a more recent value in the exchange rate table, refreshing the curve will refresh the cost data. You will not see the currency menu if the business process record was created in the project currency.","Manual distribution","When you select manual distribution in the curve properties, you manually enter the data for distribution in the curve details window at run time. The system preserves cost distribution and duration when you change the From Date (start date) of baseline, custom, and forecast curves (when there are no actuals) in project/shell, summary CBS, and CBS detail curves. In other words, if you change a cash flow curve to start on a different date then it originally did, the system shifts the curve along the timeline to reflect the new date and moves the cost data to retain the integrity of the curve. The system pegs the distribution of cost data to the From Date, rather than the end or To Date. Here is how this works when the From Date changes:","If the modified curve is the same length as the original curve, the curve shifts along the timeline to reflect the new start date and all cost data remains in the curve.","If the modified curve is longer than the original curve, the curve will shift along the timeline to reflect the new start date, but existing data is not redistributed to the additional time periods. Each time period retains its original value and additional columns have values of zero.","If the modified curve is shorter than the original curve, the curve will shift along the timeline to reflect the new start date, and existing data is truncated at the new end date.","Auto by default profile distribution","A distribution profile lets you predefine the way you want the system to distribute cost data in User mode. You can add any number of profiles in the Edit Distribution Profiles window.","The left side of the window contains:","A list of previously created distribution profiles. Initially this list is empty.","The Active check box, which controls whether the profile is available for selection for a curve.","The right side of the window contains:","Graph: The graph is a graphical representation of the profile % that you enter over the duration %.","Duration %: These are the x-axis units of the graph. The x-axis starts at zero (0), with another 20 slots, equally distributed up to 100%.","Profile %: Starts at 0, with 20 remaining slots to enter the profile distribution percent values. You will enter incremental values in these slots. The total value of the profile % must add up to 100%. You cannot enter negative numbers in these slots. The values you enter will determine the shape of the curve, and distribution of the data.","By default, when you create a distribution profile, the graphical display will be a linear distribution (5% is entered in each of the 20 data slots).","Following are some distribution profile examples.","Distributing Cost Data","74613.htm");
Page[435]=new Array("You can create cash flow curve templates that can be used to create cash flow curves in projects and CBS-code based shells. If you are using company-level cash flow, you can create roll-up curve templates. See Create Roll-up Templates.","Template creation methods are manual or involve copying an existing one. After creating a template, you can set refresh frequency and activate or deactivate curves.","Creating and setting up a template is essentially the same as setting up the curves manually in a project/shell. The major difference is you cannot select individual records in the template; these must be chosen from within the projects/shells. See Cash Flow Curves in the Unifier Managers User Guide.","The detail curve creates a worksheet in the project/shell that can include several curves. You can create detail curves and detail curve templates at the following detail levels:","Cash flow by project or shell: You can track the costs associated with an entire project/shell over time.","Cash flow by CBS: The creation of a CBS detail curve is similar to cash flow by project/shell. Use this option if cash flow needs to be tracked at the CBS level as opposed to the project/shell level, which lets you plot cash flow curves by specific CBS codes, or all codes, in the project/shell.","Cash flow by Summary CBS: The creation of a Summary CBS detail curve is very similar to cash flow by CBS. Use this option if cash flow needs to be tracked by summary CBS codes. To select this option, the project/shell cost sheet must use a tree structure&#8212;and therefore has summary CBS codes&#8212;rather than a flat structure. If you select this option, the system sets the Summary CBS Level to 1 by default. You can select another level, based on what is available in the Cost Sheet.","Cash flow by commitment: This option lets you plot and analyze cash flow data for an entire commit record (including base commit, any change commits, and related invoices). You can choose the specific business process commitment record within the project/shell, such as a purchase order or contract, and track the cost information over time.","Notes:","You can set up the automatic creation of a cash flow curve when a base commit record is created and completed or reaches a particular step. This is done in the BP Setup for the business process. For more information, see Setting Up Auto-Creation of Cash Flow Curves from Contracts.","You can define views for each cash flow detail level to include in the template. You can also select one view per detail level to function as the default view. For more information, see Defining Global Cash Flow Views for Inclusion in Templates.","To create a cash flow detail level curve in a template:","Go to the Company Workspace tab and switch to Admin mode.","In the left Navigator, do one of the following:","To create a detail curve in a project/shell template, select Templates. Open the project/shell template. In the left Navigator, select Cost Manager, and then select Cash Flow. This cash flow model can be copied during project/shell cloning.","To create a template, select Standards &amp; Libraries, select Cash Flow, and then select Templates. This is a template users can select at run time. This option is available in Classic view only.","The Cash Flow log opens.","To create a cash flow detail level curve in a template from Templates:","Click Create. The New Cash Flow Worksheet window opens.","Fill out the General block of the form by defining the name, description, and detail level.","Configure the additional options as needed:","Summary CBS Level","Filter CBS Codes or Filter Summary CBS Codes","Rollup cashflow data to company?","Time Scale: Set the period type, choose by month or by year, and set the format of the curve dates. If you select Financial Period, for a project/shell template, you can define the Cutoff Spends and the snapshot date in the Period Close Settings for cash flow curves by Project, by CBS, and by Summary CBS for the shell templates.","Add curves in the right pane. Select a curve type from the drop-down list and fill out all fields.","Click Save &amp; Close when finished. ","To create a cash flow detail level curve in a template from Standards &amp; Libraries (Classic view):","Click the New button. The Properties window opens.","Fill out the following tabs, and click OK when finished.","General tab: Define the name, description, detail level, time scale and period close settings.","Curves tab: Define individual curves (Baseline, Forecast, Actual (or Spends), Portfolio Budget, Derived, and Custom curves) that will be part of the group of curves that make up the cash flow detail curve.","Filters tab: Limit the cash flow data on your curve to a particular set of CBS codes or (if the cost sheet is tree structure) summary CBS codes. If you do not specify a filter, all codes will be used for the data.","Options tab: Define the format to use for the numbers displayed on the cash flow worksheet.","Schedule tab: Enable automatic refresh of the cash flow curve, and set the refresh schedule.","Summary tab: A Summary Cash Flow Curve displays selected cash flows from your project.","Cash Flow Curve Templates","74617.htm");
Page[436]=new Array("Use roll-up curves in the company-level Cost Manager to roll up cash flow data from all projects/shells in which cash flow is being used. You can create roll-up curve templates and use the templates to create the roll-up curves.","To create a roll-up template:","Go to the Company Workspace tab and switch to Admin mode.","In the left Navigator, select Standards &amp; Libraries, select Cash Flow, and then select Templates. The Cash Flow Standard Templates log opens.","Click New. The Properties window opens in the General tab.","In the General tab, set the Rollup Status to Active. If the status is active, data can be rolled up from project/shell cash flow curves.","The rest of the process is similar to the setup of other detail curves through the Standards &amp; Libraries grouping node. See Cash Flow Curve Templates.","Create Roll-up Templates","74618.htm");
Page[437]=new Array("Rules constrain the sending of cost-type business process records, and affect making changes to Cost and Funding sheets. That is, they give some co