'use strict';
function search(SearchText, inHeading) {
(function () {
var Page = [];

/* Generated with Author-it 22.3.1.47  4/4/2023 7:54:05 AM */
Page[0]=new Array("Primavera Gateway facilitates the sharing and synchronization of project and resource data between Primavera applications and other enterprise applications.","This guide provides is intended to be used by people who have administrator access to Gateway.","Within our documentation, some content might be specific for cloud deployments while other content is relevant for on-premises deployments. Any content that applies to only one of these deployments is labeled accordingly.","About the Gateway Application Administration Guide","10298253.htm");
Page[1]=new Array("This guide describes how to configure and manage personal information (PI) in Primavera Gateway. ","Gateway administrators and Gateway developers must review this guide.","Managing Personal Information","10297983.htm");
Page[2]=new Array("Consent notices inform users how personal information (PI) is collected, processed, stored, and transmitted, along with details related to applicable regulations and policies. Consent notices also alert users that the action they are taking may risk exposing PI. Primavera Gateway helps you to ensure that you have requested the appropriate consent to collect, process, store, and transmit the PI your organization holds as part of Primavera Gateway data. ","Note: Consent notices are switched off by default in Primavera Gateway.","Consent notices must:","be written in clear language which is easy to understand.","provide the right level of detail.","identify the purpose and legal basis for your collection, processing, storage, and transmission of PI.","identify whether data will be transferred to named third parties.","identify PI categories and list the data which will be collected, processed, stored, and transmitted.","About Consent Notices","10297984.htm");
Page[3]=new Array("Personal information (PI) is any piece of data which can be used on its own or with other information to identify, contact, or locate an individual or identify an individual in context. This information is not limited to a person's name, address, and contact details. For example, a person's IP address, phone IMEI number, gender, and location at a particular time could all be personal information. Depending on local data protection laws, organizations may be responsible for ensuring the privacy of PI wherever it is stored, including in backups, locally stored downloads, and data stored in development environments.","About Personal Information","10297985.htm");
Page[4]=new Array("Oracle might use cookies for authentication, session management, remembering application behavior preferences and performance characteristics, and to provide documentation support.","Also, Oracle might use cookies to remember your log-in details, collect statistics to optimize site functionality, and deliver marketing based on your interests.","Cookies Policy in Primavera Gateway","78902.htm");
Page[5]=new Array("Information security and privacy laws can carry heavy penalties and fines for organizations which do not adequately protect PI they gather and store. If these laws apply to your organization, it is your responsibility to configure consent notices before they are required. You should work with your data security and legal teams to determine the wording of the consent notices you will configure in Primavera Gateway.","If a consent notice is declined, it is your responsibility to take any necessary action. For example, you may be required to ensure that the data is not stored or shared.","Your Responsibilities","10297988.htm");
Page[6]=new Array("PI may be visible in multiple areas of Primavera Gateway, including but not limited to user administration, resource and role administration, assignments, work products and documents, reports, issues, risks, user defined fields, codes, and timesheets.","PI may be at risk of exposure in multiple areas of Primavera Gateway, including but not limited to integrating data between applications, downloaded logs, web services, and API.","As part of Primavera Gateway Cloud Services, you may be using an identity management domain to manage your user access and entitlements across a number of cloud and on-premises applications and services. If you are using or accessing an identity management domain, you are responsible for deleting your details and data from the identity management domain. You are responsible for retrieving your content in the identity management domain during your applicable services period.","Personal Information (PI) Data in Primavera Gateway","10297989.htm");
Page[7]=new Array("Primavera Gateway only collects credentials to setup deployment connections to applications for integration. Integration data such as project data and resource data is also stored in Gateway database. Ensure users with appropriate roles have controlled access to data.","Ensuring Privacy of Data Collection","10298018.htm");
Page[8]=new Array("Integration data originates from source applications such as P6 EPPM, Primavera Cloud, and Unifier. ","Limiting Granular Access to Data","10298017.htm");
Page[9]=new Array("Primavera Gateway provides user configurable option to automatically delete application data at regular intervals. Ensure you set this up in Gateway settings. Ensure data is purged either manually or scheduled for purging.","Ensuring Data Purging and Data Deletion","10298019.htm");
Page[10]=new Array("Primavera Gateway provides options to export and import data between source and destination applications. Ensure your users have the appropriate role-based rights and access privileges to perform these tasks.","Ensuring Privacy of Data Portability","10298021.htm");
Page[11]=new Array("Primavera Gateway collects only credentials for connecting to different applications for integration. Ensure users are set up with appropriate role and access privileges to access data. Gateway does not store any other user information.","Ensuring Privacy of End User Access","10298022.htm");
Page[12]=new Array("Primavera Gateway provides options to delete connection credentials and integration data. Ensure users are set up with the correct roles to perform these tasks. Also, ensure user credentials are securely and permanently deleted upon request.","Ensuring Right to Erasure","10298023.htm");
Page[13]=new Array("Ensure you request a backup of Primavera Gateway data regularly.","Ensuring Availability","10298024.htm");
Page[14]=new Array("Primavera Gateway supports HTTPS protocol. Ensure you configure Gateway with HTTPS for data encryption in transition and also use Total Data encryption for the database.","Ensuring Secure Encryption","10298025.htm");
Page[15]=new Array("Primavera Gateway supports secure logging for cloud and on-premises customers. Access to synchronization job logs is controlled by the role and access privileges assigned to a user. Ensure users are set up with correct roles and access privileges. ","Ensuring Secure Logging","10298026.htm");
Page[16]=new Array("To configure consent notices for Primavera Gateway:","Sign in to Primavera Gateway as an administrator or developer.","Select  and then select Settings.","In the General tab, select Enable Configurable Consent Forms.","In the sidebar, select Configuration.","Select the Consent Forms tab.","In the Name field, select a consent form, and then select  Edit....","Note: The Cookies Consent is automatically enabled when any consent form is enabled.","The Edit &lt;Consent Form Name&gt; dialog box displays. For example, Edit Login Consent Form displays.","Select Enable Consent Message to allow the notice to be shown to users of the selected consent form.","For Gateway administrators, enable all consent forms.","For Gateway administrators with no data access and Gateway developers, enable all consent forms except Download Consent.","For Gateway users, enable Login Consent, and Download Consent.","For Gateway users with no data access, enable Login Consent only.","Enter and format the text for the consent notice in the Consent Message area.","Note: Work with your data security and legal teams to determine the wording of the consent notice.","Select Save.","Continue to configure consent notices for other consent forms.","Configuring Consent Notices for Primavera Gateway","10297990.htm");
Page[17]=new Array("You can see the status of consent acceptance for users. You can also reset consent acceptance for all users if there is a need to regain consent after a consent notice has changed.","To audit consent status for Primavera Gateway:","In the sidebar, select Configuration.","Select the Consent Forms tab. ","In the Name column of the top section, select a consent form.","Choose any of the following actions in the bottom section:","To see the user consent status for the selected consent form, view the Acceptance Date and Reject Date.","Select Delete to ensure the consent notice is displayed again for all users the next time they access an area of the software.","A warning message displays, Deleting all user acceptances to this consent form will require the users to re-accept again prior to accessing the specified area.","Select  Search to locate a user by their user name and view their consent status.","Auditing Consent Forms for Primavera Gateway","10297991.htm");
Page[18]=new Array("For any company that deals with sensitive data, keeping it secure is crucial to success. While hosting Primavera Gateway data on Oracle Cloud provides security measures, it can't do everything. For example, it can't prevent phishing attempts or other attacks that exploit gaps in its users' security awareness. That's why it's important for everyone who works with Primavera Gateway to understand what they can do to keep data secure.","Introduction","10299650.htm");
Page[19]=new Array("Security is everyone's business. This guide is for anyone who uses, manages, or is just interested in Primavera Gateway. If you're a security expert or administrator, this is a good place to start. It should help you see the big security picture and understand the most important guidelines related to security in Primavera Gateway. ","Who this guide is for","10299651.htm");
Page[20]=new Array("We'll use the term administrator to refer to anyone who's responsible for managing a company's data and who can access that data. For our purposes, administrators includes a wide variety of IT professionals, from those who define roles in the Primavera Gateway application to those who manage company servers.","An end user is anyone who uses Primavera Gateway to do their job. This includes developers, adminsistrators, users, and everyone else who logs into Primavera Gateway from an office or jobsite to get their work done.","Administrators should...","Set up Single Sign-On (SSO) and enable multi-factor authentication to minimize the number of passwords that users have to remember and to consolidate risk.","Educate users on how they can avoid unwittingly helping hackers. One of the best ways application administrators and security advocates can help users is by helping them to prevent security breaches.","Use a VPN to encrypt data being sent over the internet.","Stay up-to-date about security trends and best practices. ","End users should...","Follow security guidelines created by their companies and the administrators of any network applications they use.","Use strong passwords. The more random-looking the better, and avoid reusing passwords.","Learn to recognize phishing. Phishing is when someone disguises an email or some other transmission as a legitimate message in an attempt to get a user to reveal sensitive information. For example, a hacker may send you an email disguised to look like an email from your employer requesting login information. These attacks are becoming more sophisticated, but you can still protect yourself by making sure any emails you receive or websites you visit are legitimate before using them to share sensitive information. ","Some Security Basics","10299652.htm");
Page[21]=new Array("Authentication refers to the way users sign on. If possible, Administrators should implement Single Sign-on (SSO). SSO reduces the number of passwords users have to remember. It can also be used to enable multi-factor login, which is when users are asked to provide some verification in addition to their passwords, like a code that they receive via text or email.","Authentication: How Users Sign On","10299653.htm");
Page[22]=new Array("Authorization refers to what users can access. Primavera Gateway uses Groups and Roles to restrict access to the application. ","Groups: Security groups make it easier for administrators to assign permission sets to multiple users at the same time. In Gateway, administrators can create security groups with permission sets, and then assign users to these groups.","Roles: User roles in Primavera Gateway can be defined with or without data access. Users can be assigned any of the following roles in Primavera Gateway: ","Admin role: This is a super user role that enables the user to perform all actions in the Primavera Gateway application.","Admin role with no data access: This role is identical to the Admin role with the following exception: These users cannot view the details of the data passed in each flow step, or download the details of the log files when monitoring a synchronization job. However, they can view errors and warning messages associated with each step.","Developer role: This role enables the user to create data mappings and flow types. Users have access to the data dictionary, workflows, and configuration global settings.","User role: This role enables the user to synchronize data between two systems and monitor the results.","User role with no data access: This role is identical to the User role with the following exception: These users cannot view the details of the data passed in each flow step or download the details of the log files when monitoring a synchronization job. However, they can view errors and warning messages associated with each step.","Authorization: What Users can Access","10299654.htm");
Page[23]=new Array("From laptops to cellphones, organizations have to keep track of data on more devices than ever, and more devices means more risk. That's why its important to implement Enterprise Mobility Management (EMM) tools and policies.","End Point Security","10299655.htm");
Page[24]=new Array("No automated security system or protocol can make a system fully secure if those with legitimate access exploit it for illegitimate purposes or if a device falls into the wrong hands. Here are some general &quot;common sense&quot; guidelines you should follow when it comes to endpoint security:","Grant security permission conservatively. Don't give everyone permission to everything just to avoid perceived complexity. Remember, one breach can be many times more costly and time consuming than setting and following standard security protocols.","Keep up with organizational changes. If a user no longer needs access to a part of the app, for whatever reason, update that user's permissions accordingly.","Inherent Risks and Practical Policies","10299656.htm");
Page[25]=new Array("Closely related to security are matters of privacy and personal information.","View the section Managing Personal Information in Primavera Gateway in this guide to learn about what information is collected and what you can do to monitor personal information in Primavera Gateway.","Privacy and Personal Information","10299657.htm");
Page[26]=new Array("The ability to connect and exchange information with other apps is powerful, but it also presents some potential security issues that administrators must manage. It is important to understand which data flows between applications to ensure compliance with policies and regulations related to security and privacy.","For more information on integration, refer to the Setup Guide or Business Flow Designer Guide corresponding to the applications you choose to integrate with using Primavera Gateway.","Integration with Other Applications","10299658.htm");
Page[27]=new Array("With APIs, developers can use some of the data and functionality of Primavera Gateway outside of the limitations&#8212;and relative safety&#8212;of the Primavera Gateway environment. This opens many possibilities. But as with any situation where data can move in potentially unpredictable ways, it presents risk. That's why anyone who uses Primavera Gateway API should understand the security fundamentals provided in this section.","Refer to these sections and topics from the Primavera Gateway REST API Guide: ","Transport Level Security using HTTPS","Application Level Security","HTTP Basic Authentication and HTTPS (Traditional)","Cookies","Security for Developers - API Security","10299659.htm");
Page[28]=new Array("While the apps used by your organization may have some security features of their own, most security issues ultimately come down to the people who use them. When your company establishes its security procedures, it's important to also establish in-house security experts to whom other members can turn when they have security questions. Security points of contact should be continuously learning about security trends and how they can educate users to keep their data and network secure. Security contacts should also routinely update and maintain protocols that suit the security needs of their organizations.","Establishing Security Contacts","10299660.htm");
Page[29]=new Array("Primavera Gateway facilitates the sharing and synchronization of project and resource data between Primavera applications and other enterprise applications.","This chapter provides information and procedures for:","Assigning application access for Primavera Gateway users","P6 EPPM and Primavera Unifier integrations","P6 EPPM and Oracle Primavera Cloud integrations","Primavera Unifier and Oracle Primavera Cloud integrations","Primavera Unifier and 0P_ProdName_OPP_Suite&gt; integrations","Administering Gateway","10298252.htm");
Page[30]=new Array("You can assign application access to Primavera Gateway in Primavera Administration. See the Primavera Administration Identity Management Guide for details on using Primavera Administration.","Note: Users with application access to Primavera Gateway do not require application access to the source and destination applications in order to map or exchange data. ","If you want a Primavera Gateway user to access P6 EPPM applications or Primavera Unifier, assign access in Primavera Administration.","If you want a Primavera Gateway user to access Oracle Primavera Cloud, assign access in the Administration app in Oracle Primavera Cloud. See the Primavera Cloud Application Administration Guide for details.","To assign application access to Primavera Gateway:","Log in to Primavera Administration.","Add or modify a user account.","Assign application access for that user account to one of the following access types: ","Primavera Gateway Production Administrator","Primavera Gateway Production Developer","Primavera Gateway Production User","Primavera Gateway Production Administrator (Limited Access)","Primavera Gateway Production User (Limited Access)","Note: Limited access types have no access to view actual data passed in Primavera Gateway.","Assigning Application Access to Primavera Gateway (Cloud Only)","10293440.htm");
Page[31]=new Array("Data can be exchanged between the applications listed below using Primavera Gateway. In addition, applications such as Oracle Primavera Cloud, Primavera Unifier, and P6 EPPM allow you to connect with Primavera Gateway from within their native user interfaces.","You can integrate the following applications using Primavera Gateway:","Oracle Primavera Cloud and Primavera Unifier ","Oracle Primavera Cloud and P6 EPPM","Primavera Unifier and P6 EPPM","Primavera Unifier and File Provider","Oracle Primavera Cloud and File Provider","P6 EPPM and File Provider","See the corresponding Setup Guide in the Primavera Gateway documentation library for details on setting up any of these integrations.","Setting Up Integrations Using Primavera Gateway","10294545.htm");
Page[32]=new Array("The Gateway Providers Data Dictionary provides a comprehensive listing of all of business objects and associated fields that are available in Oracle Primavera Cloud, P6 EPPM, and Primavera Unifier. Review the list of supported business objects in each application to determine the data that needs to be supported for integration in Primavera Gateway.","To view these business objects in the Primavera Gateway user interface, sign in to Primavera Gateway and select the Data Dictionary menu. ","To view these business objects in the documentation library, go to the Primavera Gateway documentation and expand the Using section.","Business Objects","10290933.htm");
Page[33]=new Array("Copyright   2023, Oracle and/or its affiliates.<br />Oracle, Java, and MySQL are registered trademarks of Oracle and/or its affiliates. Other names may be trademarks of their respective owners.","Intel and Intel Inside are trademarks or registered trademarks of Intel Corporation. All SPARC trademarks are used under license and are trademarks or registered trademarks of SPARC International, Inc. AMD, Epyc, and the AMD logo are trademarks or registered trademarks of Advanced Micro Devices. UNIX is a registered trademark of The Open Group.","This software and related documentation are provided under a license agreement containing restrictions on use and disclosure and are protected by intellectual property laws. Except as expressly permitted in your license agreement or allowed by law, you may not use, copy, reproduce, translate, broadcast, modify, license, transmit, distribute, exhibit, perform, publish or display any part, in any form, or by any means. Reverse engineering, disassembly, or decompilation of this software, unless required by law for interoperability, is prohibited.","The information contained herein is subject to change without notice and is not warranted to be error-free. If you find any errors, please report them to us in writing.","If this is software or related documentation that is delivered to the U.S. Government or anyone licensing it on behalf of the U.S. Government, the following notice is applicable: ","U.S. GOVERNMENT END USERS: Oracle programs, including any operating system, integrated software, any programs installed on the hardware, and/or documentation, delivered to U.S. Government end users are &#8220;commercial computer software&quot; pursuant to the applicable Federal Acquisition Regulation and agency-specific supplemental regulations. As such, use, duplication, disclosure, modification, and adaptation of the programs, including any operating system, integrated software, any programs installed on the hardware, and/or documentation, shall be subject to license terms and license restrictions applicable to the programs. No other rights are granted to the U.S. Government.","This software or hardware is developed for general use in a variety of information management applications. It is not developed or intended for use in any inherently dangerous applications, including applications that may create a risk of personal injury. If you use this software or hardware in dangerous applications, then you shall be responsible to take all appropriate failsafe, backup, redundancy, and other measures to ensure its safe use. Oracle Corporation and its affiliates disclaim any liability for any damages caused by use of this software or hardware in dangerous applications.","This software or hardware and documentation may provide access to or information on content, products and services from third-parties. Oracle Corporation and its affiliates are not responsible for and expressly disclaim all warranties of any kind with respect to third-party content, products, and services. Oracle Corporation and its affiliates will not be responsible for any loss, costs, or damages incurred due to your access to or use of third-party content, products, or services.","Copyright","46576.htm");
var PageCount=34;


/*
Date: 4/4/2023 7:54 AM
Source: Gateway_22_prod
BookID: 10297982
PubProduct: GATEWAY
BookTitle: Administration Guide
Version: Version 22
Lang:	en
*/
	var PageLength=Page.length;
	var Result = "";
	var ResultTemp = "";
	var ResultFound = "";
	var ResultTitleOnly = [];
	var ResultTitleAndContent = [];
	var ResultInContent = [];
	var ResultInContentTemp = [];

	var ResultCombinedTemp = [];
	var ResultCombined = [];

	var arrayIndex = 0;
	var NrRes = 0;
	var j = 0;
	var i = 0;
	var k = 0;
	var d = 0;
	var maxItems = 1000;
	var heading = 0;
	var WordPos = -1;
	var WordPosHeading = -1;
	var WordPosContentText = -1;
	var FoundWord = "";
	var FoundWordHead = "";
	var SearchInHeadingOnly = 0;
	var isChecked;
	var size = 10;
	var resGroupCounter = 0;
	var shown = "shown";
	var checkBoxInHeading;
	var searchFlag = 0;
	var DivResult;
	var SearchWord;

if (SearchText && SearchText.length >= 1) {
		SearchWord = SearchText.replace(/\+/g, " ").replace(/&/g, "&amp;").replace(/</g, "&lt;").replace(/>/g, "&gt;").replace(/"/g, "&quot;");
		searchFlag = 1;
	} else {
		SearchWord = "";
		searchFlag = 0;
	}
	

	if (searchFlag === 1) {
		Result = "";

		// checkBoxInHeading = document.getElementById("inHeading");
		if (inHeading) {

			isChecked = true;
		} else {

			isChecked = false;
		}

		if (SearchWord && SearchWord.length >= 1) {
			if (isChecked) {
				SearchInHeadingOnly = 1;
			} else {
				SearchInHeadingOnly = 0;
			}
			SearchWord = SearchWord.toLowerCase();
			window.status = "Searching, please wait...";
			for (j = 0; j < PageLength; j++) {
				k = Page[j].length - 1;
				for (i = 0; i < k; i++) {

					heading = k - 1;

					if (SearchInHeadingOnly === 1) {
						WordPosHeading = Page[j][heading].toLowerCase().indexOf(SearchWord);
						if (WordPosHeading > -1) {
							FoundWordHead = Page[j][heading].substr(WordPosHeading, SearchWord.length);

							NrRes++;
							ResultTemp = "<li>";
							ResultTemp += "<span>";
							ResultTemp += "<a href='" + Page[j][k] + "'>" + Page[j][heading].replace(FoundWordHead, FoundWordHead.bold()) + "</a><br/>\n";

							ResultTemp += "</span>";
							ResultTemp += "</li>";

							ResultTitleOnly[arrayIndex] = ResultTemp;
							arrayIndex++;

							ResultTemp = "";
							WordPosHeading = -1;
							WordPosContentText = -1;
							break;
						}
					} else if (SearchInHeadingOnly === 0) {
						WordPos = Page[j][i].toLowerCase().indexOf(SearchWord);
						WordPosHeading = Page[j][heading].toLowerCase().indexOf(SearchWord);
						if (WordPos > -1) {
							FoundWordHead = Page[j][heading].substr(WordPosHeading, SearchWord.length);
							FoundWord = Page[j][i].substr(WordPos, SearchWord.length);
							FoundWord = Page[j][i].substr(WordPos, SearchWord.length);
							NrRes++;
							ResultTemp += "<li>";
							ResultTemp += "<span>";
							if (WordPosHeading > -1) {
								ResultTemp += "<a href='" + Page[j][k] + "'>" + Page[j][heading].replace(FoundWordHead, FoundWordHead.bold()) + "</a><br/>\n";
							} else {
								// found word is not in the head
								ResultTemp += "<a href='" + Page[j][k] + "'>" + Page[j][heading] + "</a><br/>\n";

							}
							if (i < k - 1) {
								WordPosContentText = Page[j][i].toLowerCase().indexOf(SearchWord);

								if (Page[j][i].length > 300 && (WordPosContentText > -1)) {

									if (WordPosContentText > 75) {
										ResultInContentTemp.push("..." + Page[j][i].substr(WordPosContentText - 75, 175 + FoundWord.length).replace(FoundWord, FoundWord.bold()) + "...");
									} else {
										ResultInContentTemp.push("..." + Page[j][i].substr(0, 175 + FoundWord.length).replace(FoundWord, FoundWord.bold()) + "...");

									}

								} else if (WordPosContentText > -1) {

									ResultInContentTemp.push(Page[j][i].replace(FoundWord, FoundWord.bold()));

								}
							}

							ResultTemp += ResultInContentTemp.join("");

							ResultTemp += "</span>";
							ResultTemp += "</li>";

							if (WordPosHeading > -1) {
								ResultTitleAndContent[arrayIndex] = ResultTemp;
								arrayIndex++;
							} else {
								ResultInContent[arrayIndex] = ResultTemp;
								arrayIndex++;
							}

							ResultInContentTemp.length = 0;
							ResultTemp = "";
							WordPosHeading = -1;
							WordPosContentText = -1;
							break;
						}

					}
				}
			}

			ResultTitleOnly = ResultTitleOnly.filter(function (n) {
				return (n !== undefined && n !== null);
			});
			ResultTitleAndContent = ResultTitleAndContent.filter(function (n) {
				return (n !== undefined && n !== null);
			});
			ResultInContent = ResultInContent.filter(function (n) {
				return (n !== undefined && n !== null);
			});

			ResultCombinedTemp = ResultTitleOnly.concat(ResultTitleAndContent, ResultInContent);

			ResultCombinedTemp = ResultCombinedTemp.filter(function (n) {
				return (n !== undefined && n !== null);
			});

			for (d = 0; d < ResultCombinedTemp.length; d += size) {
				resGroupCounter++
				ResultCombined.push("<div id=" + "'" + "resGroup_" + resGroupCounter + "'" + " class=" + "'" + "resGroup " + shown + "'" + ">" + "<ol class='searchResults'>" + ResultCombinedTemp.slice(d, d + size).join("") + "</ol></div>");
				shown = "notshown";
			}

			ResultFound = ResultCombined.join("");

Result += "<div id='searchDetailsDiv'>";
			Result += "<p class='searchDetails'>Your Search Found&nbsp;" + NrRes + "&nbsp;items.&nbsp;";
			
			Result += "</p></div>";
			
			Result += "<div class='searchResultsDiv'>";
			Result += "<div id='resultsCollection' class='searchResults'>";
			Result += ResultFound;
			Result += "</div>";
			Result += "</div>";
			Result += "<div class='searchPaging'>";

			Result += '<hr />';

			Result += '<p class="bodytext"><a class="disabledAnchor" id="pBack" onclick="turnPage(\'backPage\')" href="#pBack">Back</a>&nbsp; | &nbsp;';
			
			if (resGroupCounter && resGroupCounter > 1) {
				Result += '<a id="pNext" onclick="turnPage(\'nextPage\')" href="#pNext">Next</a>';
			} else {
				Result += '<a id="pNext"  class="disabledAnchor" href="#pNext">Next</a>';
			}
			Result += '</p>\n';
			Result += '<div id="pagenofn"><p class="bodytext">Page <span id="pagen">1</span> of ' + resGroupCounter + '</p></div>';

			Result += "</div>";
			
			
		}

		DivResult = document.getElementById("s_anchor");
		if (Result && DivResult) {

			//myDivResult.append(Result);
			DivResult.innerHTML = Result;
			

		}
		window.status = "";
		
		

	}
	}())
}
