'use strict';
document.addEventListener("DOMContentLoaded", function () {

  if (document.SearchForm) {
    document.SearchForm.SearchText.focus();
  }

  var searchWord = getSearchString();
  if(searchWord) {
	search(searchWord.SearchText, searchWord.inHeading);
  }
});

 function getSearchString() {
	var args = {};
	var query = location.search.substring(1);
	if (!query) return;
	var pairs = query.split("&");
	for (var i=0; i < pairs.length; i++) {
		var pos = pairs[i].indexOf('=');
		if (pos === -1) continue;
		var name = pairs[i].substring(0, pos);
		var value = pairs[i].substring(pos + 1);
		value = decodeURIComponent(value);
		value = value.replace(/\+/g, " ").replace(/</g, "&lt;").replace(/>/g, "&gt;").replace(/"/g, "&quot;")
		args[name] = value;
	}
	hideItemId("authoritcontent");
	hideItemId("breadcrumbContainer");
	hideItemClass("morehelp");
	hideItemClass("heading1");
	hideItemClass("heading2");
	hideItemClass("heading3");
	return args;
}
function turnPage(direction) {
  var curActiveGroupID;
  var newActiveGroupID;
  var curActiveGroupNumber;
  var newActiveGroupNumber;
  var numberOfGroups;
  var newValue;
  var newActiveGroup;
  var curActiveGroup;
  var pageDirection;
  var anchorButtonBack;
  var anchorButtonNext;

  if (direction === "nextPage" || direction === "backPage") {
    pageDirection = direction;
  } else {
    pageDirection = false;
  }

  if (pageDirection) {

    if (document.getElementsByClassName("resGroup")) {
      numberOfGroups = document.getElementsByClassName("resGroup").length
    }

    if (document.getElementsByClassName("shown")) {
      curActiveGroupID = document.getElementsByClassName("shown")[0].id;
      curActiveGroupNumber = subStrAfter(curActiveGroupID, '_', 'b');
    }

    anchorButtonNext = document.getElementById("pNext")
      anchorButtonBack = document.getElementById("pBack")

      if (curActiveGroupID && curActiveGroupNumber <= numberOfGroups) {
        if (pageDirection === "nextPage") {
          newActiveGroupNumber = Number(curActiveGroupNumber) + 1;
        } else if (pageDirection === "backPage") {
          newActiveGroupNumber = Number(curActiveGroupNumber) - 1;
        }
        newValue = (newActiveGroupNumber - 1) * 10 + 1;
        newActiveGroupID = "resGroup_" + newActiveGroupNumber;

        newActiveGroup = document.getElementById(newActiveGroupID)
          curActiveGroup = document.getElementById(curActiveGroupID)

          if (newActiveGroup && curActiveGroup) {
            curActiveGroup.removeAttribute("class")
            curActiveGroup.setAttribute("class", "resGroup notshown");

            newActiveGroup.removeAttribute("class")
            newActiveGroup.setAttribute("class", "resGroup shown");

            if (newActiveGroup.firstChild.firstChild && newActiveGroup.firstChild.firstChild.tagName.toLowerCase() === "li") {
              newActiveGroup.firstChild.firstChild.setAttribute("value", newValue)
            }

            if (document.getElementById("pagen")) {
              document.getElementById("pagen").innerText = newActiveGroupNumber;
            }

            if (anchorButtonNext && newActiveGroupNumber && numberOfGroups && (newActiveGroupNumber >= numberOfGroups)) {
              anchorButtonNext.setAttribute("class", "disabledAnchor");
              curActiveGroupNumber = newActiveGroupNumber;
            } else if (anchorButtonNext) {
              anchorButtonNext.removeAttribute("class")
            }

            if (anchorButtonBack && newActiveGroupNumber && (newActiveGroupNumber <= 1)) {
              anchorButtonBack.setAttribute("class", "disabledAnchor");
            } else if (anchorButtonBack) {
              anchorButtonBack.removeAttribute("class")
            }

          }

      }

  }

}

function subStrAfter(str, char, pos) {
  if (pos === 'b') {
    return str.substring(str.indexOf(char) + 1);
  } else if (pos === 'a') {
    return str.substring(0, str.indexOf(char));
  } else {
    return Number(str);
  }
}
 function hideItemId(item) {
	var x;
  x = document.getElementById(item);
  if (x) {
    x.style.display = "none";
  } 
 }
 
function returnToTopic() {
	showItemId("authoritcontent");
	showItemId("breadcrumbContainer");
	showItemClass("morehelp");
	showItemClass("heading1");
	showItemClass("heading2");
	showItemClass("heading3");
	hideItemId("searchDetailsDiv");
	hideItemClass("searchResultsDiv");
	hideItemClass("searchPaging");
}
 function showItemId(item) {
  	var x;
  x = document.getElementById(item);
  if (x) {
    x.style.display = "block";
  }
 }
 
function toggleItemId(item) {
 	var x;
  x = document.getElementById(item);
  if (x && x.style.display === "none") {
    x.style.display = "block";
  } else if(x && x.style.display)  {
    x.style.display = "none";
  }
 }
 
 
 function showItemClass(item) {
  var x;
  var xLength;
  
  x = document.getElementsByClassName(item);
  xLength=x.length;
  
  if (x) {
	  xLength=x.length;
  }
  
  if (xLength) {
	  for (var i = 0; i < xLength; i ++) {
		x[i].style.display = "block";
	  }
  }
 }
 
 function hideItemClass(item) {
  var x;
  var xLength;
  
  x = document.getElementsByClassName(item);
  xLength=x.length;
  
  if (x) {
	  xLength=x.length;
  }
 
  if (xLength) {
	  for (var i = 0; i < xLength; i ++) {
		x[i].style.display = "none";
	  }
  }
 }
 
 function toggleItemClass(item) {
  var x;
  var xLength;
  
  x = document.getElementsByClassName(item);
  xLength=x.length;
  
  if (x) {
	  xLength=x.length;
  }
  
  if (xLength) {
	  for (var i = 0; i < xLength; i ++) {
		  if (x[i].style.display === "none") {
			x[i].style.display = "block";
		  } else {
			x[i].style.display = "none";
		  }
	  }
  }
 }