'use strict';
function search(SearchText, inHeading) {
(function () {
var Page = [];

/* Generated with Author-it 23.4.1.30004  12/23/2024 12:56:48 PM */
Page[0]=new Array("Title and Copyright Information","Copyright  2020, 2025, Oracle and/or its affiliates.","Primary Author: Oracle Corporation","Title and Copyright Information","46576.htm");
Page[1]=new Array("This chapter provides:","an overview of the CIC Advisor Administration application","a overview of the applications that need to be configured to display data from your source application in CIC Advisor.","Getting Started","85519.htm");
Page[2]=new Array("CIC Advisor is managed using the CIC Advisor Administration application. The administration application allows you to configure and manage CIC Advisor data sources, and manage users within your organization. CIC Advisor currently supports P6 EPPM, Primavera Cloud, and Oracle Aconex as data sources. ","The administration application is packaged and delivered with a set of predefined problems that represent common and significant challenges widespread across the industry. Each problem is also delivered with a seed model which uses a sample data set.","Administrator Privileges","As a CIC Advisor administrator, you can:","configure CIC Advisor to evaluate your P6, Primavera Cloud, and Aconex data for a select set of problems ","create one or more custom ML models and train/retrain them to predict future events related to enterprise projects","enable a specific combination of features or characteristics in each model","setup benchmarking groups to compare with your projects","setup threshold settings for assessment criteria which display in the Filter pane of CIC Advisor. Users can then use these threshold settings to filter their current view of ongoing projects","Managing CIC Applications Suite","If your organization is also provisioned with CIC Analytics, then you can use the administration application to also manage CIC Analytics. For more details, see the CIC Analytics Administration Guide.","With access to both the CIC applications, you can additionally create Suite administrators and Suite consumers. For more details, see Managing CIC Suite Users.","This guide describes how to set up CIC Advisor for your organization and configure your source applications such as P6 EPPM, Primavera Cloud, and Aconex to ensure the right set of projects and users access CIC Advisor, and manage CIC Application Suite. ","CIC Advisor Administration Application Overview","85425.htm");
Page[3]=new Array("When your organization is provisioned with CIC Advisor, as a cloud administrator, you will receive the CIC Advisor Administration Application URL in a Welcome email.","To sign in as an administrator to CIC Administration application:","In your Welcome email, click the Administration application URL available in the format:","https://&lt;host&gt;:&lt;port&gt;/cicadmin","where","&lt;host&gt;: Enter the host name or the server IP address of CICadministration application.","&lt;port&gt;: Enter the unique port number associated with the CIC administration application.","Note: For a list of supported browser versions, see the Client System Requirements document.","In the Username field, enter the user name of the cloud administrator.","In the Password field, enter a unique alphanumeric password.","Click Sign In.","Accessing CIC Advisor Administration Application","86824.htm");
Page[4]=new Array("New customers receive an initial email from no-reply@oracle.com to activate their Oracle Cloud account. The link has an expiration date mentioned at the bottom of the email. Make sure to activate your account before the link expires. ","You will receive a separate welcome email from no-reply@primavera.oraclecloud.com that includes the URL to access CIC Advisor.","All other email communications coming from your CIC Advisor environment will be sent from no-reply@primavera.oraclecloud.com.","Tips","If you do not receive either email, check the spam or junk folder in your email account, or reach out to your customer success manager or CIC administrator.","In case you miss the activation window to activate your CIC Advisor account, reach out to your customer success manager or CIC administrator.","Add no-reply@oracle.com and no-reply@primavera.oraclecloud.com to your address book or list of approved contacts.","About Your Login Credentials","88788.htm");
Page[5]=new Array("You can reset your password for CIC Advisor at any time. ","To reset your password:","Navigate to the Oracle Cloud Account Sign In page.","Select the Need help Signing in? Click here link.","On the Forgot your password page, enter your username, and then click Next.","Review the on-screen message, and click Submit.","Select Password Reset in the email you receive.","On the Reset Your Password page, complete the New Password and Confirm New Password fields.","Note: The Confirm New Password field will not be active until your new password meets the specified criteria.","Click Submit.","Select Click here to continue to navigate back to the Oracle Cloud Account Sign In page, and log in with your new password.","Note: To allow time for system processing, it is recommended that you wait a few minutes before logging in with your new password.","Reset Your Password","86991.htm");
Page[6]=new Array("You can manage the following data sources in the administration application:","P6 EPPM","Oracle Primavera Cloud","Oracle Aconex","Depending on the data source set up in the administration application, the following icons may display in the sidebar.","Menu Option","Description","@ Home","Shows currently running STARETL processes for all data sources and enables you to stop a currently running STARETL process.","@ ML Workbench","Monitor and manage models for a P6 or Aconex data source.","@ User Management","Setup and manage P6 and Aconex accessing CIC Advisor.","@ Status","Manage and schedule ETL runs and ODI load plans, view ETL logs and status reports  for a selected P6 or Aconex data source.","@ Codes","Displays a master list of codes that are available and a subset of those which have been enabled for project, activity and resource data. Use this menu option to add or remove codes for a data source.","@ UDFs","Displays a list of all UDF codes that are available and a subset of those which have been enabled for project, activity, resource assignment, resource, and WBS data. Use this menu option to add or remove UDFs for a data source.","@ Publication Status","View the status of recent publication runs for a selected P6 data source.","@ Benchmark","Setup and manage the benchmark groups to compare P6 projects in CIC Advisor.","@ Custom Project Groups","Create a subset of past and current completed projects that can be used to train your model to predict outcomes for ongoing similar projects. ","@ Threshold Settings","Set up the acceptable range for project metrics displayed in CIC Advisor.","@ Config","Configure the properties of the STARETL process for each P6 data source.","Navigating the CIC Administration Application","86270.htm");
Page[7]=new Array("This topic includes guidelines and tips regarding accessible product usage. ","Oracle has also published an Accessibility Conformance Report (ACR) for the Construction Intelligence Cloud Advisor product. The latest version of the Construction Intelligence Cloud Advisor Accessibility Conformance Report can be accessed from Oracle's Accessibility Program Website at this link: https://www.oracle.com/corporate/accessibility/vpats.html#acrs-tab.","Assistive Technology","Users can use assistive technology, such as screen readers, with Construction Intelligence Cloud Advisor.","Keyboard Shortcuts","The list of keyboard shortcuts for Construction Intelligence Cloud Advisor, including page-specific and browser-specific keyboard shortcuts, can be accessed here: Keyboard Shortcuts.","Product Accessibility","89144.htm");
Page[8]=new Array("You can use your keyboard to navigate throughout the CIC Advisor Administration application, and access frequently used or important functionality. Use the Tab key to cycle through elements within the application, and press Enter or Spacebar to access them. Some keyboard shortcuts may change depending on the browser you use. ","Arrow keys(LEFT and RIGHT) to select radio buttons/within the table row","Arrow keys(UP and DOWN) to move through the dropdowns/ to select values in combo boxes","Benchmark Page","Use the following keyboard shortcuts in the Benchmark page of the CIC Advisor Administration application:","Press h to move project from Projects to cluster 1","Press j to navigate upward in Projects","Press k to navigate downward in Projects","Press l to move project from Projects to cluster 2","Keyboard Shortcuts","89145.htm");
Page[9]=new Array("To connect CIC Advisor with your application P6 EPPM, (cloud or on-premises), you have to setup the following applications as listed in the order listed below:","Primavera Administration Application","The applications you wish to connect with CIC Advisor from those listed above.","CIC Advisor Administration application","The application setup roadmap illustrates the applications you need to setup to display P6 EPPM projects in CIC Advisor.","Note: At this point in the setup sequence, ensure you have completed the required setup in the Primavera Administration Application and configured your source application. For more details, see Before you Begin.","CIC Advisor Application Setup Roadmap","85942.htm");
Page[10]=new Array("Construction Intelligence Cloud Advisor provides predictive insights by connecting to different CEGBU applications(data sources). Depending on the data source you associate with CIC Advisor, specific aspects may vary such as:","configuration properties of a data source","benchmark groups to compare the performance of your project data","The following sections serve as a guideline for configuring and managing CIC Advisor associated with your organization's product that serve as source applications forCIC Advisor or CIC Application Suite.","Customers of CIC Suite","If your organization plans to use CIC Advisor and CIC Analytics, the following chapters in this guide:","Getting Started","Managing CIC Suite Users","the relevant chapter for administering the source application: P6 EPPM, CIC Advisor for Primavera Cloud, or Aconex","Standard Administration Tasks","Working with the Machine Learning Workbench","and additionally review the CIC Analytics Administration Guide.","Customers of CIC Advisor and P6 EPPM","If your organization plans to use CIC Advisor insights for P6 EPPM only, review the following chapters in this guide to configure a P6 EPPM data source and train models in CIC Advisor:","Getting Started","CIC Advisor for P6 EPPM","Standard Administration Tasks","Working with the Machine Learning Workbench","Customers of CIC Advisor and Oracle Primavera Cloud","If your organization plans to use CIC Advisor insights for Oracle Primavera Cloud only, review the following chapters in this guide to configure a P6 EPPM data source and train models in CIC Advisor:","Getting Started ","CIC Advisor for Primavera Cloud","Standard Administration Tasks","Working with the Machine Learning Workbench","Customers of CIC Advisor and Aconex","If your organization plans to use CIC Advisor insights for Aconex only, review the following chapters to configure Aconex data sources and train models in CIC Advisor:","Getting Started","CIC Advisor for Aconex","Standard Administration Tasks","Working with the Machine Learning Workbench","Customers of CIC Advisor, P6 EPPM, and Aconex","Since your organization will be using CIC Advisor insights for P6 EPPM as well as Aconex, review the chapters listed above in each section.","How to Use this Guide","85650.htm");
Page[11]=new Array("Video ","CIC suite refers to the following applications:","CIC Advisor","CIC Analytics","If your organization is provisioned with CIC Advisor as well as CIC Analytics, as an administrator, you can additionally:","create suite administrators and suite users who have  access to both CIC applications","In addition to the standard groups, create new custom groups which are a combination of the standard groups associated with each CIC application","For example, create a new custom group by selecting the Analytics Creator standard group in CIC Analytics and the Advisor Consumer standard group in CIC Advisor.","assign users to custom groups","You can assign access to CIC suite applications to users of any of the following products:","P6 EPPM","Primavera Unifier","Oracle Primavera Cloud","Oracle Aconex","This chapter describes how to create custom groups, associate roles with custom groups and then assign users to custom groups to control their level of access in CIC Advisor and CIC Analytics.","Managing CIC Suite Users","87306.htm");
Page[12]=new Array("When your organization is provisioned with both, CIC Advisor and CIC Analytics, you can assign a user to any of the following standard groups:","Advisor Administrator","Advisor administrators can manage data sources, benchmarking groups, threshold settings, schedule ETLs, and add users and additional administrators to CIC Advisor.","Advisor Consumer","Advisor consumers can only view projects in CIC Advisor corresponding to the data sources that they have been given access to.","Analytics Administrator","Analytics administrators can manage data sources, schedule ETLs, and add users to CIC Analytics. They can also create data visualizations if required.","Analytics Creator","Analytics creators can access and create projects, data sets, and data visualizations in CIC Analytics.","Analytics Consumer","Analytics consumers can only view projects, data sets, and data visualizations in CIC Analytics.","Suite administrator","Suite administrators are super users of CIC applications. They are a combination of Advisor administrator and Analytics administrator, and therefore. can administer both applications.","Note: Assign this role judiciously in your organization.","Suite Consumer","Suite consumers are a combination of Advisor consumer and Analytics consumer. users of this group can only view data visualizations that have been given access to in CIC Analytics, and also view analyses of projects evaluated in CIC Advisor for data sources they access to.","Unassigned (default)","Initially, users are not assigned to any group by default.","About Standard Groups","87311.htm");
Page[13]=new Array("Video","Custom groups can be created if your organization is provisioned with:","a multi-product platform (MPP) environment with CIC Advisor and CIC Analytics or","CIC Analytics only","Being provisioned with the CIC application suite gives your organization greater flexibility to create custom groups of users with specific permissions based on their needs for accessing any of the CIC applications.","Create a custom group if you want to grant users access to both analytics and advisor applications or if you have created custom roles and want to grant those to users in analytics-only environment. "," ","About Custom Groups","88308.htm");
Page[14]=new Array("To meet the specific needs of your targeted user group, you can create a custom group as a combination of:","one or more standard groups or ","one or more standard groups with a custom role","Custom groups can be created only if your organization is provisioned with CIC Analytics.","Optional Prerequisite: Creating Custom Roles","To create a custom group:","Use any of the following methods to sign in to the administration application:","In your Welcome email, click on the CIC Analytics administration application URL and sign in with administrator credentials or","Sign in from the Primavera Administration Application portal and click on the Administration application URL.","https://&lt;host&gt;:&lt;port&gt;/p6rdb","In the side bar, click @ User Management and then select the Groups and Permissions tab.","The following message displays: Sync in in progress, please wait. Once sync is completed, the following message displays: &lt;n&gt; users synced, <br />where n is the number of users synced.","Click Add new group.","In the Create custom group pane, enter the following information:","In the Group Name field, enter the name of the custom group.","In the Group Description field, briefly explain the purpose of the group.","Select a standard group from the following:","In the Analytics Standard Groups,select at least one standard group. Choices include: ","Analytics Administrator","Analytics Creator","Analytics Consumer","In the Advisor Standard Groups, select at least one standard group. Choices include: ","Advisor Administrator","Advisor Consumer","(Optional) In the Roles field, select any of the custom roles previously created.","Click Save.","The new custom group will now display in the Custom Groups table in the Groups tab.","You can also:","Edit Custom Groups","Delete Custom Groups","Proceed to assign users to the custom group.","Creating Custom Groups","87307.htm");
Page[15]=new Array(" You can modify a custom group by adding or removing custom roles. Standard roles once selected for a custom group cannot be modified.","To edit a custom group:","Sign in to the CIC Administration application.","In the side bar, click @ User Management and then select the Groups tab.","The following message displays: Sync in in progress, please wait. Once sync is completed, the following message displays: &lt;n&gt; users synced, <br />where n is the number of users synced.","In the Groups table, click the Overflow Menu @  for a specific group and then click Edit Group.","Make the necessary changes and click Save.","A confirmation message displays the changes have been saved successfully.","Editing Custom Groups","87346.htm");
Page[16]=new Array(" To delete a custom group:","Sign in to the CIC Administration application.","In the side bar, click @ User Management and then select the Groups tab.","The following message displays: Sync in in progress, please wait. Once sync is completed, the following message displays: &lt;n&gt; users synced, <br />where n is the number of users synced.","In the Custom Groups table, for a specific group, click the Overflow Menu @  and then click Delete Group.","In the Confirm Delete Group dialog box, click OK.","All users belonging to this group will now be designated with an unassigned role.","Deleting Custom Groups","87347.htm");
Page[17]=new Array("After creating custom groups, assign users to custom groups as follows:","In the side bar, click @ User Management.","The following message displays: Sync in in progress, please wait. Once sync is completed, the following message displays: &lt;n&gt; users synced, <br />where n is the number of users synced.","Click the All Users tab to view a list of existing users from the following source applications who have been ported into CIC Advisor and CIC Analytics:","P6","Unifier","Oracle Aconex","Primavera Cloud","(Optional) In the search bar, click @ Filter to view a subset of users of a particular data source and a group. ","Select a Data Source and a Group of users to filter on.","Click Apply.","Note: At least one data source and a custom group must be selected.","In the Group column, select a custom group for each user.","All initially created users belong to an unassigned group by default.","Click Change Group to save the updates made to all users on this page.","Click OK to confirm the changes in the Confirm Group Change dialog box.","To revoke a user's privileges, reset the user's group to Unassigned. Note that this user will still be able to sign in to CIC.","To remove a user from accessing CIC Advisor or CIC Analytics, you will need to change the user's account status. See the Primavera Administration Application Identity Management Administration Guide (https://docs.oracle.com/cd/F33532_01/English/admin/id_mgmt/141597.htm to complete the following tasks:","Reset a user's password","Disable a user account","Enable a user account","Unlock a user account","Assigning Users to Custom Groups","87308.htm");
Page[18]=new Array("When you select @ User Management in the sidebar, users are synched between the  between the CIC administration application and Primavera Cloud portal. Users whose roles cannot be associated with any group in CIC, are classified as Unassigned by default. You will need to manually assign these users to a standard or custom group. ","To assign a group for unmatched users:","In the side bar, click @ User Management.","The following message displays: Sync in in progress, please wait. Once sync is completed, the following message displays: &lt;n&gt; users synced, <br />where n is the number of users synced.","In the Assign Users dialog:","Click Select a group in the Group column, and choose a group from the drop-down list.","Select the check box to confirm your selection.","Repeat the above step for each user.","Click Save to confirm your selections.","Assigning Groups For Unmatched Users","88295.htm");
Page[19]=new Array("When your organization is provisioned with CIC Advisor, as a cloud administrator, you will receive the CIC Advisor Administration Application URL in a Welcome email.","Note: Cloud administrators can only be setup when CIC Advisor is initially provisioned for your organization. Therefore ensure you provide contact details of those individuals you plan to designate as administrators.","As a cloud administrator, you can assign access to CIC Advisor who may be users of any of the following source applications:","P6 EPPM","Oracle Primavera Cloud","Oracle Aconex","User-level data access for Construction Intelligence Cloud (CIC Advisor) is governed by the following criteria: ","Users must be granted access to at least one CIC Advisor Data Source Cloud Service","For each applicable CIC Advisor data source Cloud Service granted access, the following applies:","If the user is licensed in the source application, CIC data access matches the source application data access privileges of each user unless further restricted within CIC.","If the user is not licensed in the source application, the user has access to all source application data transferred to CIC unless further restricted in CIC.","This chapter describes how to add users, assign a group to each user to manage their level of access in CIC Advisor.","Managing CIC Advisor Users","87153.htm");
Page[20]=new Array("Use this procedure to grant CIC Advisor access to users brought over from the source applications.","Assign any of the following groups to give users access to CIC Advisor:","Advisor Administrator: Users can manage the following: data sources, benchmarking groups, threshold settings, schedule ETLs, add other users to CIC Advisor.","Advisor Consumer: Users can only view projects in CIC Advisor corresponding to the data sources that they have been given access to.","To enable user access to CIC Advisor:","Use any of the following methods to sign in to the administration application: ","In your Welcome email, click on the CIC Advisor administration application URL and sign in with administrator credentials or","Sign in from the Primavera Administration Application portal and click on the Administration application URL.","https://&lt;host&gt;:&lt;port&gt;/p6rdb","In the side bar, click @ User Management.","Click the All Users tab to view a list of existing users from the following source applications who have been ported into CIC Advisor:","P6","Oracle Aconex","Primavera Cloud","(Optional) In the search bar, click @ Filter to view a subset of users of a particular data source and a group. ","Select a Data Source and a Group of users to filter on.","Click Apply.","Note: At least one data source and a group must be selected.","Assign each user to a group. Select any of the following groups:","Advisor Administrator","Advisor Consumer","Notes: ","All users are initially set up with the role, unassigned. ","When an Oracle Aconex or a Primavera Cloud user is assigned to a group or Unassigned a role in CIC Advisor, a corresponding lobby user profile is also created or removed for that user. ","Click Change Group to save the updates made to all users on this page.","Click OK to confirm the changes in the Confirm Group Change dialog box.","To revoke a user's privileges, reset the user's role to Unassigned. Note that this user will still be able to sign in to CIC Advisor.","To remove a user from accessing CIC Advisor, you will need to change the user's account status. See the Primavera Administration Application Identity Management Administration Guide (https://docs.oracle.com/cd/F33532_01/English/admin/id_mgmt/141597.htm to complete the following tasks:","Reset a user's password","Disable a user account","Enable a user account","Unlock a user account","Enabling CIC Advisor User Access","87154.htm");
Page[21]=new Array("Use this procedure if you want to add a new user who has not been ported from any source application. Users of this category will automatically have access to CIC Advisor. ","Note: CIC Advisor-only users cannot access links to the source applications such as Aconex, P6 or Primavera Cloud in the front end application. ","Use any of the following methods to sign in to the administration application:","In your Welcome email, click on the CIC Advisor administration application URL and sign in with administrator credentials or","Sign in from the Primavera Administration Application portal and click on the Administration application URL.","https://&lt;host&gt;:&lt;port&gt;/p6rdb","In the side bar, click @ User Management.","Click the All Users tab to view a list of existing users from the following source applications who have been ported into CIC Advisor:","P6","Oracle Aconex","Primavera Cloud","In the Search bar, enter or search for a user by their user name or email and click  Search.","If the user does not exist click Create an account to create an identity management account for this new user.","In the Create User pane, enter the following contact information of the user: ","In the Last Name field, enter the last name of the user.","In the First Name field, enter the first name of the user.","In the User ID field, enter the user name that the user will use to sign in to the CIC Advisor application.","In the Email field, enter the user's email ID that is to be associated with their User ID.","In the Mobile field, enter the primary phone number to contact the user.","In the Datasource section, select the corresponding check box to give the user access to all data brought into CIC Advisor from the selected data sources.","Caution: Judiciously assign users of this category in your organization as they will have access to all data from the source applications in CIC Advisor.","Click Create to add the new user.","The user will be assigned the role of an Advisor Consumer by default. To change the user's role, see Enabling CIC Advisor User Access.","Creating CIC Advisor Only Users","87155.htm");
Page[22]=new Array("You can modify a user's privileges by adding or removing their access to one or more data sources.","To manage a user's privileges: ","Use any of the following methods to sign in to the administration application:","In your Welcome email, click on the CIC Advisor administration application URL and sign in with administrator credentials or","Sign in from the Primavera Administration portal and click on the Administration application URL.","https://&lt;host&gt;:&lt;port&gt;/p6rdb","In the side bar, click @ User Management.","Click the All Users tab to view a list of existing users who have been ported into CIC Analytics from various source applications.","In the Actions column, click the Overflow Menu @ and then click Manage Privileges for a user.","In the Manage Privileges dialog, select or deselect datasources as needed. ","Click Update.","Managing User Privileges","88861.htm");
Page[23]=new Array("The Smart Construction Platform (SCP) is an integrated family of cloud-based applications that connect project teams across processes, empower decision-makers with accurate predictions from deep datastores, and synchronize activities and materials with up-to-the-second precision so you can make each decision with confidence. ","CIC Advisor is also supported on the Smart Construction Platform.","For a seamless user experience:","CIC Advisor users provisioned through the CIC Administration application are also provisioned to access the Smart Construction Platform, if your organization is provisioned with one or more cloud-based applications of the SCP platform.","Based on the the combination of cloud-based applications of the Smart Construction Platform, and the CIC Advisor user's role, the CIC Advisor Administration application also ensures the correct SCP application instance is rendered for each user.","Prerequisites for Oracle Aconex Users","To provision Aconex users with CIC Advisor Risk, your organization must meet the following requirements:","Aconex customers must have and use your own IDCS credentials","Your organization must get onboard the Smart Construction Platform before getting onboard CIC Advisor","A few Aconex users must first be added to SCP.","Managing CIC Advisor Users on Smart Construction Platform","88667.htm");
Page[24]=new Array("To bring data from P6 EPPM into CIC Advisor, you need to setup and configure a P6 data source in the CIC Advisor administration application.","This chapter includes:","a roadmap that outlines a setup task sequence for P6","tasks for setting up Aconex users with access to CIC Advisor","information on how to configure one or more P6 data source for CIC Advisor","configure threshold benchmarking groups to compare your P6 project","CIC Advisor for P6 EPPM","86151.htm");
Page[25]=new Array("As a CIC Advisor administrator, use the following roadmap to setup users, add additional administrators, P6 projects, and configure P6 data sources for CIC Advisor.","To configure CIC Advisor for P6: /","Setup P6 EPPM application to bring P6 projects over to CIC Advisor. For more details, see the P6 EPPM Application Setup Guide.","In the CIC Advisor Administration application complete the following tasks.","Assign CIC Advisor access to P6 users from the User Management page.","For more details, see Managing CIC Advisor Users. ","Configure P6 data sources to bring projects into CIC Advisor.","For more details, see Configuring P6 EPPM Data Sources.","Manage and load projects into CIC Advisor. These include:","Start or stop STARETL processes","Schedule STARETL runs","Run Initial Loads","Reviewing the global status of STARETL runs and status of publication services","Access log files and Access STARETL","Run reports for STARETL processes ","For more details on each task, see Standard Administration Tasks.","Based on the content displayed in CIC Advisor, configure and retrain machine learning (ML) models as necessary to obtain the desired level of accuracy for predicting outcomes in CIC Advisor.","For more details, see Working with the Machine Learning Workbench.","Note: When you deselect P6 projects or change the model used for predictions, you will need to rerun publication services and the ETL to ensure CIC Advisor reflects the current changes.","Use CIC Advisor to review the information displayed. Identify any threshold settings or project benchmarking groups that may need to be modified.","For more details on how to setup benchmarking groups, see Configuring Benchmarking Groups for P6 Projects.","For more details on how to modify threshold settings, see Configuring Threshold Settings for P6 Data.","Roadmap for Configuring CIC Advisor for P6","85527.htm");
Page[26]=new Array("CIC Advisor can be configured to display projects from P6 EPPM data sources. ","To configure the properties for any P6 data source:","Sign in to the CIC Administration application.","http://&lt;host&gt;:&lt;port&gt;/cicadmin","From the @ Home  menu, select a staretl&lt;id&gt; or a &lt;Custom Name for DataSource&gt;.","Note: &lt;id&gt; is the identifier of the data source.","Click @ Config in the sidebar for a selected P6 data source. .","Set the following properties and then select Save.","Configuration Property","Description","In the Configurable Properties section, set up the following properties as required:","Custom Name for Datasource","Enter a name for the data source for identification purposes. For example, P6 EPPM Production Data.","Enable Activity Period Actuals","Controls the display of past period actuals for activities.","Select any of the following values:","True (default): Enables pay period actuals for activities.","False: Disables pay period actuals for activities.","ODI LoadPlan Auto Restart","Controls restart of all real-time ODI Load plans.","Select any of the following values:","True (default): Auto restarts ODI load plans for a maximum count of 3 if an initial run fails.","False: Manually restart is required for all real-time ODI load plans.","Enable Resource Assignment Period Actuals","Controls the display of past period actuals for resources.","Select any of the following values:","True (default): Enables pay period actuals for resources.","False: Disables pay period actuals for resources.","Enable Relationship load","Controls the ETL from processing activity relationships.","Select any of the following values:","True (default): ETL runs will not process relationship loads.","False: ETL runs will process relationship loads.","Turn off all History, keep Slowly Changing Dimensions","Controls history tables.","Select any of the following values:","True: Turns off history tables. ","Note: SCDs will continue to be captured at the project level without the history tables.","False (default): Keeps history tables with SCDs.","Note: To delete SCD data for an effective date or a specific date range, contact Oracle Support with a service request. ","Disable Rebuild Index","Controls rebuilding of indexes in the cloud database.","Select any of the following values:","True: Does not rebuild indexes. Results in improved performance.","False (default): Rebuilds indexes.","Turn off Resource and Role Limits","Controls resource and role utilization scripts. ","Select any of the following values:","True: Turn the scripts off. ","False (default): Keeps the scripts running.","Enabled Spread Snapshot History","Controls the use of spread snapshot history in the advanced analytics dashboard.","Select any of the following values:","True: Enables spread snapshot history.","False (default): Disables spread snapshot history.","Use project filter in data source 1","Controls the source that will be used for naming a Unifier project.","Select any of the following values:","True (default): If the Unifierproject ID is identical in P6 and Unifier, then the project name from P6 will be used for the Unifier project.","False: Uses the project name from Unifier.","Include Inactive Resources","Controls resource filtration.","Select any of the following values:","True: Ensures Primavera Data Warehouse tables will not filter out inactive resources.","Note: If inactive resources are included, then spread data and other dimension tables will also be included. You may not need to process this extra resource assignment information.","False (default): Filters out inactive resources.","Enable Slowly Changing Dimensions and Spread History","Slowly changing dimensions (SCDs) are used to capture the change history of dimension fields. If SCD is enabled, any change to the field will add a new row to capture the change in the data warehouse. If SCD is disabled, a new row will not be added if a change is made to that field. This property controls the creation of SCD and spread history. ","Select any of the following values:","True (default): Captures SCD and spread history.","False: Turns off SCD and spread history.","Load all Hierarchy Codes","Builds code hierarchies.","Select any of the following values:","True: Builds code hierarchies with all codes that come from the source.","False (default): Builds hierarchies with codes from configStar. ","ODI Log Level","Controls the level of detail included in the ODI log files.","Select any of the following values:","Summary: Displays a summarized content in the log file.","Detail (default): Displays detailed information in the log file.","Degree of Parallelism for Rebuild Index","If the Disable Rebuild Index property is set to False, then select the number of threads (CPUs) you want to enable to run in parallel to rebuild the index. ","If you plan to use ODI for projects in real-time, set the following properties to poll for changes in project data in P6 EPPM. The minimum poll interval is 5 minutes, and the maximum is 1440 minutes for all poll interval settings listed below:","ODI Realtime Global Loadplan Poll Interval (in minutes)","Enter the frequency at which changes to global data is to be checked in P6 EPPM and captured in the data warehouse.","By default the poll interval is set to 10 minutes. ","ODI Realtime On Demand Loadplan Poll Interval (in minutes)","Checks for changes to projects whose Enable Publication flag is selected in P6 EPPM. This process runs when new projects are added and published to the data warehouse by triggering the ODI On Demand load plan to run for the selected projects and include it in the data warehouse.","Enter the frequency in minutes to check for changes to the Enable Publication flag for projects in P6 EPPM and send it to the data warehouse. By default the poll interval for running the On Demand ODI load plan is set to 60 minutes. ","At each check, new projects with the Enable Publication flag will be added to the data warehouse, and projects whose Enable Publication flag is disabled will be deleted in the data warehouse. ","ODI Realtime Project Loadplan Poll Interval (in minutes)","Checks for changes in current projects in P6 EPPM. This configuration property checks those projects whose Data Warehouse Update Frequency (ODI Only) field is set as Immediate in the Project Preferences dialog box in P6 EPPM.","Enter the frequency in minutes to send changes directly to the data warehouse. By default the poll interval value is set to 1440 minutes (24 hours). ","In the OBIEE Settings section set up the following properties:","Mail Prefix","Customize the text that will be displayed in the subject line of email notifications that are sent regarding the status of ETL runs. For example, enter Analytics for status updates on ETL runs.","Primavera CIC Host URL","The Primavera CIC Host URL is preset for your organization and is used for analysis.","Lobby URL","The Lobby URL is preset for your organization and is used to switch between applications accessible through the Smart Construction Platform. ","P6 Base URL","This URL is preset for your organization and is used for detailed analysis.","OBIEE Cache Purge","OBIEE cache entries are used to as a method to improve response times of OBIEE dashboards. This property controls the clearance of OBIEE cache entries.","Select any of the following values:","True: Clears OBIEE cache entries.","False (default): Retains the cache entries.","Send Email Notification","Enter the email IDs of the personnel to be notified regarding the status or issues with the STARETL runs. Also select the type of events for which they are to be notified:","Failure: Email notifications are sent only for failed ETL runs.","Success: Email notifications are sent only for successful ETL runs.","Both: Email notifications are sent for successful and failed ETL runs.","Configuring P6 EPPM Data Sources","85523.htm");
Page[27]=new Array("To extract and load P6 EPPM codes: ","Sign in to the CIC Administration application from the Cloud Landing page of the Primavera Administration Application provided in your Welcome email.","http://&lt;host&gt;:&lt;port&gt;/cicadmin","In the Home menu, select a staretl&lt;id&gt; or a &lt;Custom Name of a data source&gt;.","In the left pane, select@ Codes.","To migrate codes for the selected P6 data source, select any of the following tabs:","Project","Activity","Notes:","A maximum of 240 codes is supported for each area (Project, Activity, and Resource).","By default, only those codes that have been enabled through the CIC Administration application are exposed in the subject areas.","To select codes for migration:","From the Available Codes list, select one or more P6 codes.","Select  Move Right.","To deselect codes from being migrated:","From the Enabled Codes list, select one or more P6 codes you want to remove.","Select @ Move Left.","Select Save.","Configuring P6 Codes for Each Data Source","88559.htm");
Page[28]=new Array("To extract and load P6 EPPM user-defined fields (UDFs):","Sign in to the CIC Administration application from the Cloud Landing page of the Primavera Administration Application provided in your Welcome email.","http://&lt;host&gt;:&lt;port&gt;/cicadmin","In the Home menu, select a staretl&lt;id&gt; or a &lt;Custom Name of a data source&gt;.","In the sidebar, select @ Status.","In the All list, select staretl&lt;id&gt; or a P6 &lt;custom name for data source&gt;.","In the left pane, select @ UDFs.","Select any of the following tabs to migrate the following UDFs for the selected data source:","Project","Activity","Resource Assignment","Resource","WBS","Select any of the following tabs to migrate specific UDF types:","Cost","Date","Non-Cost","Number and Integer UDF types are displayed in the 'Non-Cost' folders.","Text","Indicator","Notes: ","Formula-driven UDF values are not brought over during the STARETL process. The calculated UDFs can be selected as columns but  with null values.","A limit of approximately 220 UDFs for each supported level (Project, WBS, Activity, Resource, and Resource Assignment) and data type (Cost limit is 220, Non-Cost limit is 220, and a combination comprising Date, Text, and Integer of 220) is allowed. The limit for Indicator type UDFs for each level is 40. For example, you can select a total of 220 UDFs that includes Project Cost UDFs, WBS Cost UDFs, Activity Cost UDFs.","By default, only those UDFs that have been enabled through the CIC Administration application are exposed in the subject areas.","To select a UDF to be migrated to Primavera Data Warehouse:","In the Available UDFs list, select a UDF from P6 EPPM.","Select  Move Right.","To deselect a UDF from being migrated:","In the Enabled UDFs list, select the UDF from P6 EPPM.","Select @ Move Left.","Select Save","Configuring P6 UDFs for Each Data Source","88558.htm");
Page[29]=new Array("To bring data from P6 EPPM to CIC Advisor, you must run ETLs or ODI load plans from the Status page of the CIC Administration application.","To access the Status page for any data source:","Sign in to the CIC Administration application.","http://&lt;host&gt;:&lt;port&gt;/cicadmin","From the @ Home @ menu, select a data source.","Item","Description","1","Navigation menu: Select the following icons in the sidebar to use the interface:","@ Home: Shows currently running STARETL processes for all data sources and enables you to stop a currently running STARETL process.","@ ML Workbench: Monitor and manage models for a P6 or Aconex data source.","@ User Management: Setup and manage P6 and Aconex accessing CIC Advisor.","@ Status: Manage and schedule ETL runs and ODI load plans, view ETL logs and status reports  for a selected P6 or Aconex data source.","@ Publication Status: View the status of recent publication runs for a selected P6 data source.","@ Benchmark: Setup and manage the benchmark groups to compare P6 projects in CIC Advisor.","@ Threshold Settings: Set up the acceptable range for project metrics displayed in CIC Advisor.","@ Config: Configure the properties of the STARETL process for each P6 data source.","2","Add menu: Select this menu to select codes from an available list.","Actions menu: Select this menu to schedule or run ETLs for the selected data source.","Refresh: Select this button to renew the current view of the page.","3","ODI Agent Status: Displays the current status or mode of the ODI agent.","4","Load Plan Status: Displays the recent runs of ODI load plans that were run for this data source. Use this section to Start or Restart ODI load runs.","5","Recently Running ETLs: Displays the recent ETL runs for this data source. Select View log to review the log file for each ETL run.","Running ETLs and ODI Loads for P6 EPPM Data Sources","85752.htm");
Page[30]=new Array("Publication services are responsible for ensuring that the data is up-to-date prior to running the STARETL process. Publication services are available for P6","To view the status of recent publication runs:","Sign in to the CIC Administration application.","http://&lt;host&gt;:&lt;port&gt;/cicadmin","From the @ Home menu, select a staretl&lt;id&gt; or a &lt;Custom Name for DataSource&gt;.","Note: &lt;id&gt; is the identifier of the data source.","In the sidebar, click @ Status.","On the Status page, click @ Publication Status.","On the Publication Status page, the following information for each publication service run:","For P6 Publication Services:","Job ID: A unique identifier for the publication service.","Job Type: The category of the publication service to which it belongs.","Job Name: The name of the publication service.","Recur Type: The recurrence of the publication service. The following values may display:","RT_WebEnabled: Indicates that the job is a recurring job and is scheduled","RT_RecurDisabled: Indicates that the job is a scheduled recurring job, but is currently disabled","RT_WebASAP: Indicates that the job is a one-time job, and must be run at the earliest","Status Code: The status of the publication service. The following values may display: ","Cancelled,: The publication service has been canceled.","CompError,: The publication service has been completed with errors.","Completed: The publication service has been completed.","Delegated: The publication service is waiting to complete child jobs.","Failed: The publication service has failed to complete.","Pending: The publication service is in the queue waiting to be run.","Running: The publication service is currently in process.","Last Run Date: The most recent date on which the publication service was run. ","Click Refresh to update the publication services run list as needed.","Reviewing the Status of P6 Publication Services","85559.htm");
Page[31]=new Array("In CIC Advisor, projects can be compared and contrasted with two benchmark groups on the Benchmark Detail page.","To set up benchmarking groups in CIC Advisor to compare your P6 project with:","Sign in to the CIC Administration application.","http://&lt;host&gt;:&lt;port&gt;/cicadmin","From the @ Home  menu, select a staretl&lt;id&gt; or a &lt;Custom Name for DataSource&gt;.","Note: &lt;id&gt; is the identifier of the data source.","In the sidebar, click @ Benchmark.","Click @ Edit and enter a name for each baseline group being created.","Note: You can set up only two benchmark groups with a maximum of 7 projects in each group that are either complete, or 85 - 90% complete.","Populate each group with projects as follows:","To add a project to a baseline group, select a project from the list of available projects brought over by the ETL, and drag and drop it into a baseline group.","To remove a project from a baseline group, select a project in a baseline group and delete it from the baseline group.","Click Save to create baseline groups for benchmarking.","Configuring Benchmarking Groups for P6 Projects","85642.htm");
Page[32]=new Array("In CIC Advisor, projects are analyzed to identify metrics responsible for a potential delay in a project schedule. These metrics are identified based on an acceptable range of values established for each metric in the Threshold Settings page of the CIC Administration application.","To establish an acceptable range for each metric in Threshold Settings page:","Sign in to the CIC Administration application.","http://&lt;host&gt;:&lt;port&gt;/ciciadmin","From the @ Home  menu, select a staretl&lt;id&gt; or a &lt;Custom Name for DataSource&gt;.","Note: &lt;id&gt; is the identifier of the data source.","In the sidebar, click @ Threshold Settings.","Each setting is set up with a default value initially.","To customize threshold values for each setting choose any of the following actions:","For each Setting Name, enter a value in the Custom Value field.","To revert to its default value, click Default Value.","To revert all threshold settings to their default values, click Set All Default. ","Configuring Threshold Settings for P6 Data","85643.htm");
Page[33]=new Array("To ensure models are trained to predict outcomes with a high level of accuracy, you can create custom project groups, by selecting a subset of similar projects that have been completed in the past to train your ML models with your data.","To set up custom project groups to train models with your data:","Sign in to the CIC Administration application.","http://&lt;host&gt;:&lt;port&gt;/cicadmin","From the @ Home  menu, select a staretl&lt;id&gt; or a &lt;Custom Name for DataSource&gt;.","Note: &lt;id&gt; is the identifier of the data source.","In the sidebar, click @ Custom Project Groups to create a maximum of three groups.","On the Custom Project Groups page, click @ Edit to rename a project group.","To add a project to a group, click and drag a project to the relevant project group column..","To remove a specific project a project from a group, select the project in the project group and click @ Remove.","Repeat the above actions as necessary to create each combination of projects  in a group. ","Click Save to confirm all changes or click Cancel to revert all changes made to the project groups.","Proceed to select any of the custom project groups created above and train a model with your data on the ML Workbench page.","Creating Custom Project Groups to Train Models","86341.htm");
Page[34]=new Array("This chapter describes how to set up CIC Advisor with data from Oracle Aconex. ","It includes:","a roadmap that outlines a task sequence to setup CIC Advisor with data from Oracle Aconex","tasks for setting up Aconex users with access to CIC Advisor","information on how to configure Aconex data sources for CIC Advisor","CIC Advisor for Aconex","86150.htm");
Page[35]=new Array("As a CIC Advisor administrator, use the following roadmap to setup users, add additional administrators, and configure Aconex data sources for CIC Advisor. ","To configure CIC Advisor for Aconex:","Assign CIC Advisor roles to add Aconex users to CIC Advisor. ","For more details, see Assigning CIC Advisor Roles in Primavera Administration Application.","In the CIC Advisor Administration application complete the following tasks.","Assign CIC Advisor access to Aconex users from the User Management page.","For more details, see Managing CIC Advisor Users. ","Configure Aconex data sources to bring Aconex data into CIC Advisor.","For more details, see Configuring Aconex Data Sources.","Manage and load projects into CIC Advisor. These include:","Start or stop STARETL processes","Run initial loads","Schedule STARETL runs","Reviewing the global status of STARETL runs and status of publication services","Access log files and Access STARETL","Run reports for STARETL processes ","For more details on each task, see Standard Administration Tasks.","Based on the content displayed in CIC Advisor, configure and retrain machine learning (ML) models as necessary to obtain the desired level of accuracy for predicting outcomes in CIC Advisor.","For more details, see Configuring and Training CIC Advisor Models with Aconex Data.","Use CIC Advisor to review the information displayed. Identify any threshold settings that may need to be modified.","For more details on how to modify threshold settings in the administration application, see Configuring Threshold Settings for Aconex Data .","Roadmap for Configuring CIC Advisor for Aconex","86147.htm");
Page[36]=new Array("To configure the properties for an Aconex data source:","Sign in to the CIC Administration application provided in your Welcome email.","http://&lt;host&gt;:&lt;port&gt;/cicadmin","From the @ Home menu, select an Aconex data source. For example, select Staretl10 or Aconex_Staging.","Click @ Config in the sidebar for a selected Aconex data source.","Set the following properties, and then click Save.","Configuration Property","Description","Custom Name for Datasource","Enter a name for the data source for identification purposes. For example Aconex Production Data.","Aconex URL","This URL is preset for your organization and is used for detailed analysis. ","Degree of Parallelism for Rebuild Index","If the Disable Rebuild Index property is set to False, then select the number of threads (CPUs) you want to enable to run in parallel to rebuild the index. ","In the OBIEE Settings section set up the following properties:","Mail Prefix","Customize the text that will be displayed in the subject line of email notifications that are sent regarding the status of ETL runs.","For example, STAR ETL email notifications for Aconex can be prefixed as  CIC for Aconex ETL.","Aconex CIC Host URL","The Aconex URL is preset for your organization and is used for analysis.","Lobby URL","The Lobby URL is preset for your organization and is used to switch between applications accessible through the Smart Construction Platform. ","OBIEE Cache Purge","OBIEE cache entries are used to as a method to improve response times of OBIEE dashboards. This property controls the clearance of OBIEE cache entries.","Select any of the following values:","True: Clears OBIEE cache entries.","False (default): Retains the cache entries.","Send Email Notification","Enter the email IDs of the personnel to be notified regarding the status or issues with the STARETL runs. Also select the type of events for which they are to be notified:","Failure: Email notifications are sent only for failed ETL runs.","Success: Email notifications are sent only for successful ETL runs.","Both: Email notifications are sent for successful and failed ETL runs.","Configuring Aconex Data Sources","86145.htm");
Page[37]=new Array("To bring data over from Aconex into CIC Advisor, you must run ETLs from the Status page of the CIC Administration application.","To access the Status page for an Aconex data source:","Sign in to the CIC Administration application.","http://&lt;host&gt;:&lt;port&gt;/cicadmin","From the @ Home @, select a data source.","Item","Description","1","Navigation menu: Select the following icons in the sidebar to use the interface:","@ Home @: Shows currently running STARETL processes for all data sources and enables you to stop a currently running STARETL process.","@ ML Workbench: Monitor and manage models for an Aconex data source.","@ User Management: Setup and manage Aconex users accessing CIC Advisor.","@ Status: Manage and schedule ETL runs and ODI load plans, view ETL logs and status reports  for a selected Aconex data source.","@ Threshold Settings: Set up the acceptable range for project metrics displayed in CIC Advisor.","@ Config: Configure the properties of the STARETL process for each Aconex data source.","2","Actions menu: Select this menu to schedule or run ETLs for the selected data source.","Refresh: Select this button to renew the current view of the page.","3","ODI Agent Status: Displays the current status or mode of the ODI agent.","4","Recently Running ETLs: Displays the recent ETL runs for this data source. Select View log to review the log file for each ETL run.","Running ETLs for Aconex Data Sources","86243.htm");
Page[38]=new Array("In CIC Advisor, projects are analyzed to identify metrics responsible for potential risks. These metrics are identified based on an acceptable range of values established for each metric in the Threshold Settings page of the CIC Administration application.","To establish an acceptable range for each metric in Threshold Settings page:","Sign in to the CIC Administration application.","http://&lt;host&gt;:&lt;port&gt;/cicadmin","From the @ Home , select a staretl&lt;id&gt; or a &lt;Custom Name for DataSource&gt;.","Note: &lt;id&gt; is the identifier of the data source.","In the sidebar, click @ Threshold Settings.","Each setting is set up with a default value initially.","To customize threshold values for each setting choose any of the following actions:","For each Setting Name, enter a value in the Custom Value field.","To revert to its default value, click Set Default.","To revert all threshold settings to their default values, click Set All Default. ","Configuring Threshold Settings for Aconex Data","86240.htm");
Page[39]=new Array("If your organization plans to use CIC Advisor with insights from P6 as well as Aconex, then complete the task sequence outlined in the following topics: ","Roadmap for Configuring CIC Advisor for P6","Roadmap for Configuring CIC Advisor for Aconex","Assigning CIC Advisor Roles in Primavera Administration Application","Managing P6 and Aconex Users for CIC Advisor","CIC Advisor for Aconex and P6 EPPM","86163.htm");
Page[40]=new Array("To add users to access insights in Construction Intelligence Cloud Advisor, complete the following procedures:","Prerequisite","Assigning CIC Advisor Roles in Primavera Administration Application","Procedure","To assign or remove CIC Advisor access for an Aconex or P6 user:","Sign in to the CIC Advisor Administration application.","In the sidebar, click @ User Management.","On the User Management page, select any of the following actions:","To assign access to CIC Advisor, select the check box for an Aconex User ID / P6 User ID.","Note: CIC Advisor does not make decisions for you. If the user already has access to CIC Advisor insights for P6 or Aconex, the system will try to match and identify the user's email ID and display it in the relevant Email column.","To remove access to CIC Advisor, deselect the check box for an Aconex User ID / P6 User ID.","Click Save Access to send a notification to the user.","Managing P6 and Aconex Users for CIC","86164.htm");
Page[41]=new Array("To bring data from Primavera Cloud into CIC Advisor, you need to setup and configure a Primavera Cloud data source in the CIC Advisor administration application.","This chapter includes:","a roadmap that outlines a setup task sequence for Primavera Cloud","tasks for setting up Primavera Cloud users with access to CIC Advisor","information on how to configure one or more Primavera Cloud data sources for CIC Advisor","configure threshold settings, benchmarking groups, and custom project groups to compare your Primavera Cloud project with ","CIC Advisor for Primavera Cloud","86264.htm");
Page[42]=new Array("As a CIC Advisor administrator, use the following roadmap to setup users, add additional administrators, and configure Oracle Primavera Cloud data sources for CIC Advisor.","To configure CIC Advisor for Primavera Cloud: ","In the CIC Advisor Administration application complete the following tasks.","Assign CIC Advisor access to Primavera Cloud users from the User Management page.","For more details, see Managing CIC Advisor Users. ","Configure Primavera Cloud data sources to bring projects into CIC Advisor.","For more details, see Configuring Primavera Cloud Data Sources.","Manage and load projects into CIC Advisor. These include:","Start or stop STARETL processes","Run initial loads","Schedule STARETL runs","Reviewing the global status of STARETL runs and status of publication services","Access log files and Access STARETL","Run reports for STARETL processes ","For more details on each task, see Standard Administration Tasks.","Based on the content displayed in Construction Intelligence Cloud Advisor, configure and retrain machine learning (ML) models as necessary to obtain the desired level of accuracy for predicting outcomes in Construction Intelligence Cloud Advisor.","For more details, see Working with the Machine Learning Workbench","Note: When you deselect Primavera Cloud projects or change the model used for predictions, you will need to rerun publication services and the ETL to ensure CIC Advisor reflects the current changes.","Use CIC Advisor to to review the information displayed. Identify any threshold settings or project benchmarking groups that may need to be modified.","For more details on how to setup benchmarking groups, see Configuring Benchmarking Groups for P6 Projects.","For more details on how to modify threshold settings, see Configuring Threshold Settings for P6 Data.","Roadmap for Configuring CIC Advisor for Primavera Cloud","86265.htm");
Page[43]=new Array("Video ","CIC can be configured to display projects from multiple Primavera Cloud data sources. ","To configure the properties for a Primavera Cloud data source:","Sign in to the CIC Administration application from the Cloud Landing page of the Primavera Administration Application provided in your Welcome email.","http://&lt;host&gt;:&lt;port&gt;/cicadmin","In the Home menu, select a staretl&lt;id&gt; or a &lt;Custom Name of a data source&gt;.","Note: &lt;id&gt; is the identifier of the data source.","Click @ Config in the sidebar for a selected Primavera Cloud data source.","In the Configurable Properties section, set the following properties, and then click Save.","Configuration Property","Description","Custom Name for Datasource","Enter a name for the data source for identification purposes. For example, Primavera Cloud Production Data.","ODI Log Level","Controls the level of detail included in the ODI log files.","Select any of the following values:","Summary: Displays a summarized content in the log file.","Detail (default): Displays detailed information in the log file.","Spread Page Size","Enter the maximum number of assignments to be calculated for spread data. It controls the data volume the server handles in one request batch. ","Primavera Cloud URL","This URL is preset for your organization and is used for detailed analysis.","Enable Loading Primavera Cloud Codes","Controls the ability to load codes. ","Select any of the following values:","True: Loads codes.","False (default): Does not load codes.","Enable Loading Primavera Cloud UDFs","Controls the ability to load user defined fields (UDFs. ","Select any of the following values:","True: Loads codes.","False (default): Does not load codes.","In the OBIEE Settings section set up the following properties:","Mail Prefix","Customize the text that will be displayed in the subject line of email notifications that are sent regarding the status of ETL runs. For example, enter Analytics for status updates on ETL runs.","Primavera CIC Host URL","The Primavera CIC Host URL is preset for your organization and is used for analysis.","Lobby URL","The Lobby URL is preset for your organization and is used to switch between applications accessible through the Smart Construction Platform. ","OBIEE Cache Purge","OBIEE cache entries are used to as a method to improve response times of OBIEE dashboards. This property controls the clearance of OBIEE cache entries.","Select any of the following values:","True: Clears OBIEE cache entries.","False (default): Retains the cache entries.","Send Email Notification","Enter the email IDs of the personnel to be notified regarding the status or issues with the STARETL runs. Also select the type of events for which they are to be notified:","Failure: Email notifications are sent only for failed ETL runs.","Success: Email notifications are sent only for successful ETL runs.","Both: Email notifications are sent for successful and failed ETL runs.","Configuring Primavera Cloud Data Sources","86267.htm");
Page[44]=new Array("To extract and load Primavera Cloud codes: ","Sign in to the CIC Administration application from the Cloud Landing page of the Primavera Administration Application provided in your Welcome email.","http://&lt;host&gt;:&lt;port&gt;/cicadmin","In the Home menu, select a staretl&lt;id&gt; or a &lt;Custom Name of a data source&gt;.","In the left pane, select @ Codes.","To migrate codes for a selected data source, select any of the following tabs:","Project","Activity","Notes:","A maximum of 300 codes is supported for each area (Project, Activity).","By default, only those codes that have been enabled in the CIC Administration application are exposed in the subject areas.","To select a code for migration:","From the Available Codes list, select a Primavera Cloud code you want to enable.","Select  Move Right.","To deselect a code from being migrated:","From the Enabled Codes list, select a Primavera Cloud code you want to remove.","Select @ Move Left.","Select Save.","Configuring Primavera Cloud Codes for Each Data Source","88555.htm");
Page[45]=new Array("To extract and load Primavera Cloud user-defined fields (UDFs): ","Sign in to the CIC Administration application from the Cloud Landing page of the Primavera Administration Application provided in your Welcome email.","http://&lt;host&gt;:&lt;port&gt;/cicadmin","In the Home menu, select a staretl&lt;id&gt; or a &lt;Custom Name of a data source&gt;.","In the left pane, select @ UDFs.","Select any of the following tabs to migrate the corresponding UDFs or the selected data source:","Activity","Project","Select any of the following sub-tabs to migrate a UDF type:","Cost","Date","Non-Cost: Number and Integer UDF types are displayed in the 'Non-Cost' folders.","Text","Notes:","A maximum of 200 UDFs are supported for each area (Project, Activity) and data type. ","By default, CIC those UDFs that have been enabled in the CIC Administration application are exposed in the subject areas.","To select a UDF to be migrated","In the Available UDFs list, select a Primavera Cloud UDF you want to enable.","Select  Move Right.","To deselect a UDF from being migrated","In the Enabled UDFs list, select the UDF you want to remove.","Select @ Move Left.","Select Save Changes.","Configuring Primavera Cloud UDFs for Each Data Source","88556.htm");
Page[46]=new Array("To bring data from Primavera Cloud to CIC Advisor, you must run ETLs or ODI load plans from the Status page of the CIC Administration application.","To access the Status page for a data source:","Sign in to the CIC Administration application.","http://&lt;host&gt;:&lt;port&gt;/cicadmin","From the@ Home  menu, select a data source.","Item","Description","1","Actions menu: Select this menu to schedule or run ETLs for the selected data source.","Refresh: Select this button to renew the current view of the page.","2 ","ODI Agent Status: Displays the current status or mode of the ODI agent. ","3","Recently Running ETLs: Displays the recent ETL runs for this data source. Select View log to review the log file for each ETL run.","Running ETLs and ODI Loads for Primavera Cloud Data Sources","86269.htm");
Page[47]=new Array("In CIC Advisor, projects can be compared and contrasted with two benchmark groups on the Benchmark Detail page.","To set up the benchmarking groups in CIC Advisor for comparison:","Sign in to the CIC Administration application.","http://&lt;host&gt;:&lt;port&gt;/cicadmin","From the @ Home  menu, select a staretl&lt;id&gt; or a &lt;Custom Name for DataSource&gt;.","Note: &lt;id&gt; is the identifier of the data source.","In the sidebar, click @ Benchmark.","Click @ Edit and enter a name for each baseline group being created.","Note: You can set up only two benchmark groups with a maximum of 7 projects in each group that are either complete, or 85 - 90% complete.","Populate each group with projects as follows:","To add a project to a baseline group, select a project from the list of available projects brought over by the ETL, and drag and drop it into a baseline group.","To remove a project from a baseline group, select a project in a baseline group and delete it from the baseline group.","Click Save to create baseline groups for benchmarking.","Configuring Benchmarking Groups for Primavera Cloud Projects","86826.htm");
Page[48]=new Array("In CIC Advisor, projects are analyzed to identify metrics responsible for a potential delay in a project schedule. These metrics are identified based on an acceptable range of values established for each metric in the Threshold Settings page of the CIC Administration application.","To establish an acceptable range for each metric in Threshold Settings page:","Sign in to the CIC Administration application.","http://&lt;host&gt;:&lt;port&gt;/cicadmin","From the @ Home  menu, select a staretl&lt;id&gt; or a &lt;Custom Name for DataSource&gt;.","Note: &lt;id&gt; is the identifier of the data source.","In the sidebar, click @ Threshold Settings.","Each setting is set up with a default value initially.","To customize threshold values for each setting choose any of the following actions:","For each Setting Name, enter a value in the Custom Value field.","To revert to its default value, click Default Value.","To revert all threshold settings to their default values, click Set All Default. ","Configuring Threshold Settings for Primavera Cloud Data","86827.htm");

Page[49]=new Array("To bring new data over from a source application into CIC Advisor, you need to run or schedule ETLs and ODI load plans (if applicable to your data source) from the Status page of the CIC Administration application.","The following source applications are currently supported:","P6 EPPM","Oracle Primavera Cloud","Aconex","This chapter describes the standard administration tasks that you will perform to manage the source data displayed in CIC Advisor. ","Standard Administration Tasks","85430.htm");
Page[50]=new Array("The CIC Administration application contains a staretl section for each data source.","To run the STARETL process for a data source:","Sign in to the CIC Administration application.","http://&lt;host&gt;:&lt;port&gt;/cicadmin","In the sidebar, click @ Status.","From the Home menu, select a staretl&lt;id&gt; or a &lt;Custom Name for DataSource&gt;.","Note: &lt;id&gt; is the identifier of the data source.","From the Actions menu, click Run ETL to run a STARETL process immediately.","Running the STARETL Process","85433.htm");
Page[51]=new Array("To stop the STARETL process run for a data source:","Sign in to the CIC Administration application.","http://&lt;host&gt;:&lt;port&gt;/cicadmin","In the sidebar, click @ Status.","Click Stop for a currently running STARETL process.","Stopping the STARETL Process","85434.htm");
Page[52]=new Array("The option to run an initial load is displayed only for the first time a data source is made available in CIC. If an initial load run fails, this option will be available until the initial load is successfully completed.","Notes: When an initial load is in process:","You cannot run an initial load of another data source simultaneously.","You cannot run an ETL process for another data source when an initial load run is in process. The ETL process will be in queue for a run. ","To run an initial load for a new data source:","Select a data source","Sign in to the CIC Administration application.","http://&lt;host&gt;:&lt;port&gt;/cicadmin","From the@ Home  menu, select a staretl&lt;id&gt; or a &lt;Custom Name for DataSource&gt;.","Note: &lt;id&gt; is the identifier of the data source.","In the sidebar, click @ Status.","Click Run Initial Load.","Upon successful completion, proceed to run an ETL. See Running the STARETL Process.","Running Initial Loads","88814.htm");
Page[53]=new Array("To schedule a STARETL process run for a data source:","Sign in to the CIC Administration application.","http://&lt;host&gt;:&lt;port&gt;/cicadmin","In the sidebar, click @ Status.","From the Home menu, select a staretl&lt;id&gt; or a &lt;Custom Name for DataSource&gt;.","Note: &lt;id&gt; is the identifier of the data source.","From the Actions menu, select Schedule Etl.","In the Schedule Frequency field, select the frequency for the STARETL process run.","If you select None, no STARETL process run will be scheduled for a data source.","If you select Daily: ","In the Run ETL at field, enter the time for the daily process run, and then select Save.","To schedule multiple ETL runs daily, click Add and enter date and time for each ETL run.","Note: Schedule multiple ETLs daily at least 2 hours apart.","If you select Weekly:","In the Run ETL at field, enter the time for the process run.","Select the days for the STARETL process run, and click Save.","Scheduling STARETL Runs","85435.htm");
Page[54]=new Array("If applicable to your data source, to manage and run ODI load plans:","Sign in to the CIC Administration application.","http://&lt;host&gt;:&lt;port&gt;/cicadmin","From the Home menu, select a staretl&lt;id&gt; or a &lt;Custom Name of a data source&gt;.","In the sidebar, click @ Status.","In the Load Plan Status section, select any of the following buttons:","Click Start to run a specific ODI load plan","Click Restart to stop and begin a currently ongoing run","Starting and Restarting ODI Load Plans","85437.htm");
Page[55]=new Array("To view details on recently run STARETL processes for all data sources: ","Sign in to CIC Advisor Administration application.","http://&lt;host&gt;:&lt;port&gt;/cicadmin","In the sidebar, click @ Status.","The following information is provided for each STARETL process:","Custom Name: The custom name given to a data source. ","ETL Name: The identifier for the data source for the STARETL process.","ETL ID: The unique identifier for the STARETL process run.","ETL Start Date: The start date and time for the STARETL process run based on the server time.","ETL End Date: The end date and time for the STARETL process run based on the server time.","Status: The status of the STARETL process run. These include:","OK: The STARETL process completed successfully.","Running: The STARETL process is currently running.","Failed: The STARETL process has failed. View the report and log for more information about the failure.","Report: The link to the status report of this STARETL process run.","Log: The link to the ETL log of this STARETL process run.","Reviewing the Global Status of STARETL Runs","85436.htm");
Page[56]=new Array("Every time you run the STARETL process, extensive log files are created that provide information about the installation and daily operations details of each step of the process. Inspect the log files after each run of the STARETL process to determine if any issues exist.","To access the log files:","Sign in to the CIC Administration Application:","http://&lt;host&gt;:&lt;port&gt;/cicadmin","In the sidebar, click @ Status.","In the ETL section, click View Log to view details of the STARETL run.","Accessing Log Files of STARETL Runs","85438.htm");
Page[57]=new Array("To access a log of a StarETL run for a data source:","Sign in to CIC Administration application.","http://&lt;host&gt;:&lt;port&gt;/cicadmin","In the sidebar, click @ Status.","From the Global Status menu select staretl&lt;id&gt; or &lt;Custom Name for data source&gt;.","In the Recently Running ETLs section,  review the following information for recent StarETL runs:","ETL Name: Identifier for the data source associated with the StarETL run.","ETL ID: Unique identifier for the StarETL run.","ETL Start Date: Start date and time for the StarETL run based on the server time.","ETL End Date: End date and time for the StarETL run based on the server time.","Status: Status of the StarETL run. These include:","OK: The StarETL run completed successfully.","Running: The StarETL runis currently running.","Failed: The StarETL run failed. View the log for more information about the failure.","Log: Links to the log file of the StarETL run.","Accessing Recent STARETL Run Reports and Logs","85439.htm");
Page[58]=new Array("The ML workbench allows you to monitor, train, and retrain the models driving predictions in CIC Advisor.","For each problem that you want to investigate, you can:","create machine learning (ML) models without having to learn complex technology and being a data scientist","train multiple models simultaneously, each with a different combination of features enabled if available","enable prediction of future outcomes within each model","The following topics describe how to set up and use the administration application to train models for Construction Intelligence Cloud Advisor application for the following products:","P6 EPPM","Primavera Cloud","Aconex","Working with the Machine Learning Workbench","85552.htm");
Page[59]=new Array("As a rule of thumb, the criteria for training machine learning models as well as selecting models to train must be determined in consultation with project stakeholders in your organization.","Note: Oracle recommends that you initially train the seed models and check the results if these provide appropriate guidance. Otherwise, retrain and select custom models to retrain.","Assessing the performance of a machine learning model is an essential step in a predictive modeling pipeline. Once a model is ready, it has to be evaluated to establish its correctness.&nbsp;There are some widely used validation metrics that are used to assess a prediction model and we have used some of them:","Accuracy: It is the ratio of correct predictions to the total number of predictions.","For example, consider a prediction model predicting an activity is going to be delayed or not with an accuracy of 0.75. If the model predicts 100 times in total, then 75 times the model will predict it correctly.","Recall: It answers how well the model can find all the positive results actually in the data. Of all the activities that are actually delayed, how many the model correctly identified. ","For example, consider a prediction model predicting an activity is going to be delayed or not. If the recall is 0.57, then it implies that for every 100 activities that are actually delayed, approximately 57 activities are correctly predicted to be delayed.","Precision: It tells us, how often are we correct when we have a positive prediction, and how many are actually delayed out of all the activities that are predicted to be delayed.","For example, consider a prediction model predicting an activity is going to be delayed or not. If the precision is 0.6, then for every 100 activities that are predicted to be delayed, 60 activities are actually delayed.","Selection Criteria for Training ML Models","85533.htm");
Page[60]=new Array("CIC Advisor makes recommendations, predict outcomes, and raise warnings for your projects. These recommendations and predictions are rendered based on the settings established to train machine learning (ML) models using your organization's data. The settings for these machine learning models are trained, retrained, and maintained on the ML Workbench page in the CIC Administration application.","As a cloud administrator, you can access the ML Workbench page as follows:","Sign in to the CIC Administration application with administration privileges.","In the sidebar, click @ ML Workbench.","In the top-right corner, click Try the New ML Workbench.","If your organization uses CIC Advisor for identifying and mitigating a variety of potential risks in your project, select the Delivery Risk tab to focus on risks in the following areas (tiles):","Change requests","Field Change Request","Field Health and Safety risks","Health and safety risks","Litigation risks","Each tile displays the following information:","Feedback since last training: The date when the model was last trained with data.","Total no: The total number of feedbacks received for the risk category","Is a risk (Yes): Indicates if risks were identified as a percentage measure.","Isn't a risk (No): Indicates if risks weren't identified as a percentage measure.","Click View details for a specific risk area (tile) to refresh data and train or retrain the associated ML model on the Delivery Risk ML Model Details page.","Working With ML Workbench - New!","87985.htm");
Page[61]=new Array("When you click View details in the Delivery Risk tab, the following information is displayed for each ML model:","Total no: The total number of user feedbacks received for the selected risk category such as Health and Safety risks or Litigation risks.","Is a risk (Yes): Indicates if risks were identified as a percentage measure.","Isn't a risk (No): Indicates if risks weren't identified as a percentage measure.","&lt;Model Name and version number&gt; associated with the risk category displays","Model status: The current status of the ML model. Displays as Enabled or ","Accuracy: The ratio of correct predictions to the total number of predictions. ","Precision: A measure of correctness on positive predictions, and a measure of how many are actually delayed out of all the activities that are predicted to be delayed.","Recall: A measure of a model's ability to  find all the positive results actually in the data. Of all the activities that are actually delayed, how many the model correctly identified.","Last trained: The number of days since the model was last trained and the current status of the model as Yet to be trained, Require training, or up to date.","You can perform any of the following actions: ","Click Refresh data and retrain to retrain the ML model. This button is enabled if new data is available for the model.","Click the Overflow Menu @ to:","View ML Model Details","Edit model","Delivery Risk ML Model Details","88291.htm");
Page[62]=new Array("In the Edit Model page, you can edit the Model name and enter a Description of the ML model, and click Save.","Edit ML Model Information","88532.htm");
Page[63]=new Array("In the View Model Details page, select any of the following tabs: ","Settings","Training and prediction","Model effectiveness","Explore these tabs to learn more about the current model being used for a risk category.","Click Edit to Edit ML Model Information.","View ML Model Details","88533.htm");
Page[64]=new Array("The Settings tab displays the following information about the model:","Date created: The date when the ML model was created.","Last updated: The date when the ML model was last updated. If the model was never updated, then it displays the creation date by default.","Description: A short description of the ML model.","Options: Indicates if the model is enabled for prediction.","ML Model Settings Details","88662.htm");
Page[65]=new Array("@ ","The following details are displayed for each model:","The Training details section displays when the ML model was last trained. This includes:","Training status: The training status when the model was last trained.","Last training date: Date when the model was last trained","Training started: Date and time when model training began.","Training finished: Date and time when model training ended.","The Feedback since last training section displays user feedback received after the data was last trained. This includes: ","No. of feedback given: The number of users who provided feedback on the data displayed in CIC Advisor Risk.","Is a risk: The percentage of users who indicated a risk.","Is not a risk: The percentage of users who indicated as not a risk.","The Prediction details section display details if prediction is enabled for the model. This includes: ","Prediction status: The status of the model when enabled for prediction. Choices include: Failed, Completed.","Prediction started: The date and time when the prediction for the model began.","Prediction finished: The date and time when the prediction for the model ended.","Click Retrain Model to retrain this ML model. ","ML Model Training and Predictions Details","88664.htm");
Page[66]=new Array("To enable CIC Advisor to make recommendations, predict outcomes, or raise warnings for large scale enterprise projects, you need to establish settings in the ML Workbench page of the CIC Advisor Administration application. The settings on this page control the data eventually displayed in CIC Advisor.","Item","Description","1","Data Source: The data from a source application that is being analyzed to predict future outcomes, success rate, risks, anomalies, etc.","2","Problem: The administration application delivers a set of predefined problems or scenarios for a product-specific data set. These problems represent recurrent issues and significant challenges that are widespread across the construction industry. ","3","Models Table: Machine learning is a technique of data analysis that uses algorithms to analyze large sets of data to identify patterns in data. Models are machine-learning algorithms that generate predictions by finding patterns in data. You train a model to learn from a data set. A model can be generated to analyze each real-life problem in a data set. The inference from this analysis is built into a model. Additionally, multiple models can be generated to analyze a specific objective for a problem.","SeedModel: Each problem is delivered with a seed model that is generated from analyzing a sample data set.","CustomModel: A custom model is generated once the seed model is retrained using a customer-specific data set. These custom models may be retrained as often as needed to ensure more accurate predictions. A custom model refers to a model that is generated from analyzing data from a customer-specific construction and engineering product data set. For example, customer feed back provided during project progress and current project progress to date in addition to customer specific P6 EPPM data set.","Note: Oracle recommends you retrain the model for each problem before using it for predictions. For each problem you can train multiple models simultaneously with a different combination of features selected in each model. However, you can only select one model for prediction for each problem. ","4","Features of a Model: A feature is a characteristic or an attribute of the data set. Feature lists can vary for each problem identified in a data set. To analyze problems, specific combination of features can be enabled or disabled in a model. Therefore, you may create multiple models each associated and enabled with a different combination of features to analyze a problem. ","5","Train Models: Train models with data and feature sets using  seed models or existing custom models with new customer-specific training data set to learn from and provide better predictions. As the model learns, its accuracy also increases over time. Models are built using trends identified in the data from past projects. These models then serve as the engine that drives predictions. These models can be retrained through user feedback to identify patterns and trends specific to the way the organization chooses to run its projects thereby enhancing the accuracy of the predictions. Initially, you will need to make decisions for a data set when the application recognizes patterns in the data set. The application begins to learn from past decisions to predict outcomes. A vast data pool provides greater exposure to train a model.","6","Training records for staretl&lt;n&gt;: View the model training history executed for a selected data source.","Using ML Workbench for P6 EPPM","85753.htm");
Page[67]=new Array("To manage information displayed in Construction Intelligence Cloud Advisor, as administrators you have to select models that need to be trained for predicting outcomes.","Note: A seed model or initial model is also delivered for each problem. Oracle recommends that you train the seed model before using it for predictions.","To set up and train models with specific features enabled:","Sign in to the administration application of CIC Advisor.","http://&lt;host&gt;:&lt;port&gt;/cicadmin","In the sidebar, click @ ML Workbench.","From the Data Source list, select a P6 data source.","From the Problem list, select a predefined area of improvement that you want to focus in CIC Advisor for the selected P6 data source.","In the Model section, add a model for the selected problem as follows:","Click @ Add Model, and then click OK to confirm your selection.","By default, the model is named as CustomModel1.","The following information is displayed for each model:","Model Name: A user-friendly name to identify a model.","Prediction Enabled: Indicates that a model is used for predictions. For each problem, only one model which has been trained can be used for predictions.","Training Enabled: Indicates that a model is being trained. Multiple models can be trained for a problem. ","Create Date: The date on which the model was added.","Update Date: The date on which the model was previously updated.","Train Status: The current status of the model being trained. Choices include: Failed, Completed.","Train Start Time: Time when the training process for the model was initiated.","Train Finish Time: Time when the training process for the model was completed.","Last Training Date: The date on which the model previously trained.","Note: Prediction can be enabled for a model only if a model has a Last Training Date.","Training Log: Click View Logs to view the log file containing details corresponding to each model that has been trained.","Prediction Status: The current status of the model enabled for prediction. Choices include: Failed, Completed.","Prediction Start Time: Time when the prediction process for the model was initiated.","Prediction Finish Time: Time when the prediction process for the model was completed.","Prediction Log: Click View Logs to view details of the prediction process run for the model that has been enabled for prediction. Accuracy: It is the ratio of correct predictions to the total number of predictions. ","In the Model Name field, click @ Edit, and rename the model.","In the Description section, enter information that describes the purpose of the model.","Enable features for a model:","In the Model section, select a row to select the model whose feature you want to enable.","In the Features section, select the Enabled check box to activate each feature for the selected model.","Select Save.","To add multiple models for each problem, repeat steps 5 and 6 for each problem.","To train the models:","In the Model section, select the Training Enabled check box for one or more models across all problems.","Click Train Model(s).","Configuring and Training CIC Advisor Models with P6 Data","85432.htm");
Page[68]=new Array("To enable CIC Advisor to make recommendations and predict potential risks based on User Feedback for your projects in Aconex, you need to train models in the ML Workbench page of the CIC Advisor Administration application. The model trained on this page controls the data eventually displayed in CIC Advisor.","Item","Description","1","Data Source: The data from a source application that is being analyzed to predict future outcomes, success rate, risks, anomalies, etc.","2","Problem: The administration application delivers a set of predefined problems or scenarios for a product-specific data set. These problems represent recurrent issues and significant challenges that are widespread across the construction industry.","3","Models Table: Machine learning is a technique of data analysis that uses algorithms to analyze large sets of data to identify patterns in data. Models are machine-learning algorithms that generate predictions by finding patterns in data. You train a model to learn from a data set. A model can be generated to analyze each real-life problem in a data set. The inference from this analysis is built into a model. Additionally, multiple models can be generated to analyze a specific objective for a problem.","Note: Oracle recommends you retrain the model for each problem before using it for predictions. For each problem you can train multiple models simultaneously. However, you can only select one model for prediction for each problem. ","4","Train Models: Train models with data using  seed models with new customer-specific training data set to learn from and provide better predictions. As the model learns, its accuracy also increases over time. Models are built using trends identified in the data from past projects. These models then serve as the engine that drives predictions. These models can be retrained through user feedback to identify patterns and trends specific to the way the organization chooses to run its projects thereby enhancing the accuracy of the predictions. Initially, you will need to make decisions for a data set when the application recognizes patterns in the data set. The application begins to learn from past decisions to predict outcomes. A vast data pool provides greater exposure to train a model.","5","Training records for staretl&lt;n&gt;: View the model training history executed for a selected data source.","Using ML Workbench for Aconex","86238.htm");
Page[69]=new Array("A model can be selected, trained or retrained for each predefined problem identified as an area of improvement in Aconex.","Note: In the CIC Advisor application, for an Aconex project, users can indicate if a risk has been identified by indicating Yes or No in the User Feedback field. You can choose to retrain the model based on the Create Date  To retrain a model, ","To train a model with Aconex data:","Sign in to the administration application of CIC Advisor.","http://&lt;host&gt;:&lt;port&gt;/cicadmin","In the sidebar, click @ ML Workbench.","From the Data Source list, select an Aconex data source.","From the Problem list, select any of the following predefined areas that you want to focus in CIC Advisor:","Change Request","Field Change Request","Field Health and Safety ","Health and Safety","Litigation","Review Delay Prediction ","In the Model section, select the Current Model check box to indicate the current model to be used for training purposes and then click Save.","The following information additionally displays for each model:","Model Name: A user-friendly name for a CIC Advisor model.","Current Model: Select the check box to indicate the model being trained currently.","Accuracy: The ratio of correct predictions to the total number of predictions.","Precision: The frequency of being correct with a positive prediction, and how many are actually delayed out of all the risks that are predicted to be delayed.","Recall: The ability of a model to find all the positive results actually in the data. That is, of all the activities that are actually delayed, how many the model correctly identified. ","Total Feedback: The total number of feedbacks provided for the model until today.","Last Run Feedback: The number of feedbacks provided after the model was last retrained. This number is treated as new data for retraining the model.","Last Run unique feedback: Displays a count of the unique feedbacks received since the last ETL run.","Create Date: The date on which the model was added.","To train a model:","Click Train Model(s).","In the confirmation dialog box, click OK.","In the Training Records section, a new row displays the following information when a model is retrained:","Custom Name: The name of the Aconex data source","Etl Name: The name of the ETL process.","Training Start Date: The start date and time when the model was trained or retrained.","Training End Date: The end date and time when the training completed.","In the Model section, a new row is displays when the model completes training or retraining.","Configuring and Training CIC Advisor Models with Aconex Data","86241.htm");
Page[70]=new Array("To enable CIC Advisor to make recommendations, predict outcomes, or raise warnings for large scale enterprise projects, you need to establish settings in the ML Workbench page of the CIC Advisor Administration application. The settings on this page control the data eventually displayed in CIC Advisor.","Item","Description","1","Data Source: The data from the Primavera Cloud source application that is being analyzed to predict future outcomes, success rate, risks, anomalies, etc.","2","Problem: The administration application delivers a set of predefined problems or scenarios for a product-specific data set. These problems represent recurrent issues and significant challenges that are widespread across the construction industry.","3","Models Table: Machine learning is a technique of data analysis that uses algorithms to analyze large sets of data to identify patterns in data. Models are machine-learning algorithms that generate predictions by finding patterns in data. You train a model to learn from a data set. A model can be generated to analyze each real-life problem in a data set. The inference from this analysis is built into a model. Additionally, multiple models can be generated to analyze a specific objective for a problem.","SeedModel: Each problem is delivered with a seed model that is generated from analyzing a sample data set.","CustomModel: A custom model is generated once the seed model is retrained using a customer-specific data set. These custom models may be retrained as often as needed to ensure more accurate predictions. A custom model refers to a model that is generated from analyzing data from a customer-specific construction and engineering product data set. For example, customer feed back provided during project progress and current project progress to date in addition to customer specific Oracle Primavera Cloud data set.","Note: Oracle recommends you retrain the model for each problem before using it for predictions. For each problem you can train multiple models simultaneously with a different combination of features selected in each model. However, you can only select one model for prediction for each problem. ","4","Features of a Model: A feature is a characteristic or an attribute of the data set. Feature lists can vary for each problem identified in a data set. To analyze problems, specific combination of features can be enabled or disabled in a model. Therefore, you may create multiple models each associated and enabled with a different combination of features to analyze a problem.","5","Train Models: Train models with data and feature sets using  seed models or existing custom models with new customer-specific training data set to learn from and provide better predictions. As the model learns, its accuracy also increases over time. Models are built using trends identified in the data from past projects. These models then serve as the engine that drives predictions. These models can be retrained through user feedback to identify patterns and trends specific to the way the organization chooses to run its projects thereby enhancing the accuracy of the predictions. Initially, you will need to make decisions for a data set when the application recognizes patterns in the data set. The application begins to learn from past decisions to predict outcomes. A vast data pool provides greater exposure to train a model.","6","Training records for staretl&lt;n&gt;: View the model training history executed for a selected data source.","For 22.2 - Using ML Workbench for Oracle Primavera Cloud","86329.htm");
Page[71]=new Array("To manage information displayed in CIC Advisor, as administrators you have to select models that need to be trained for predicting outcomes.","R2: It measures the proximity of the data points to the fitted regression line. The higher the R2 score, the better. It is calculated as: Explained Variation / Total Variation.Note: A seed model or initial model is also delivered for each problem. Oracle recommends that you train the seed model before using it for predictions.","To set up and train models with specific features enabled:","Sign in to the administration application of CIC Advisor.","http://&lt;host&gt;:&lt;port&gt;/cicadmin","In the sidebar, select @ ML Workbench.","From the Data Source list, select a Primavera Cloud data source.","From the Problem list, select a predefined area of improvement that you want to focus in CIC Advisor for the selected Primavera Cloud data source.","In the Model section, add a model for the selected problem as follows:","Select @ Add Model, and then select OK to confirm your selection.","By default, the model is named as CustomModel1.","The following information is displayed for each model:","Model Name: A user-friendly name to identify a model.","Prediction Enabled: Indicates that a model is used for predictions. For each problem, only one model which has been trained can be used for predictions.","Training Enabled: Indicates that a model is being trained. Multiple models can be trained for a problem.","Select Group: ","Accuracy: It is the ratio of correct predictions to the total number of predictions.","Precision: It is a measure of correctness on positive predictions, and a measure of how many are actually delayed out of all the activities that are predicted to be delayed. ","Recall: It is a measure of a model's ability to  find all the positive results actually in the data. Of all the activities that are actually delayed, how many the model correctly identified.","MAE: The Mean Absolute Error (MAE) measures the average magnitude of the error in the set of predictions without considering the direction. The lower the score, the better.","MAPE: The mean absolute percentage error (MAPE) measures the prediction accuracy of a forecasting method. It is expressed in terms of a percentage value.","R2: It measures the proximity of the data points to the fitted regression line. The higher the R2 score, the better. It is calculated as: Explained Variation / Total Variation.","RMSE: The Root Mean Square Error (RMSE) measures the average magnitude of the error. It's the square root of the average of the squared difference between predictions and actual observations. The lower the score, the better.","Create Date: The date on which the model was added.","Update Date: The date on which the model was previously updated.","Train Status: The current status of the model being trained. Choices include: Failed, Completed.","Train Start Time: Time when the training process for the model was initiated.","Train Finish Time: Time when the training process for the model was completed.","Last Training Date: The date on which the model previously trained.","Note: Prediction can be enabled for a model only if a model has a Last Training Date.","Training Log: Click the View Logs link to view the log file containing details corresponding to each model that has been trained.","Prediction Status: The current status of the model enabled for prediction. Choices include: Failed, Completed.","Prediction Start Time: Time when the prediction process for the model was initiated.","Prediction Finish Time: Time when the prediction process for the model was completed.","Prediction Log: Click the View Logs link to view details of the prediction process run for the model that has been enabled for prediction.","In the Model Name field, select@ Edit, and rename the model.","In the Description section, enter information that describes the purpose of the model.","Enable features for a model:","In the Model section, select a row to select the model whose feature you want to enable.","In the Features section, select the Enabled check box to activate each feature for the selected model.","Select Save.","To add multiple models for each problem, repeat steps 5 and 6 for each problem.","To train the models:","In the Model section, select the Training Enabled check box for one or more models across all problems.","Select Train Model(s).","For 22.2 - Configuring and Training CIC Advisor Models with Primavera Cloud Data","86331.htm");
Page[72]=new Array("This chapter describes how to manage personal information (PI) in Construction Intelligence Cloud Advisor.","Managing Personal Information","85492.htm");
Page[73]=new Array("Consent notices inform users how personal information (PI) is collected, processed, stored, and transmitted, along with details related to applicable regulations and policies. Consent notices also alert users that the action they are taking may risk exposing PI. Oracle Construction and Engineering products help you to ensure that you have requested the appropriate consent to collect, process, store, and transmit the PI your organization holds as part of any source application (P6 EPPM) that can be configured with Construction Intelligence Cloud Advisor.","About Consent Notices","85493.htm");
Page[74]=new Array("Personal information (PI) is any piece of data which can be used on its own or with other information to identify, contact or locate an individual or identify an individual in context. This information is not limited to a person's name, address, and contact details. For example, a person's IP address, phone IMEI number, gender, and location at a particular time could all be personal information. Depending on local data protection laws , organizations may be responsible for ensuring the privacy of PI wherever it is stored, including in back-ups, locally stored downloads, and data stored in development environments.","As part of your Primavera Analytics Cloud Service, you may be using an identity management domain to manage your user access and entitlements across a number of cloud and on-premises applications and services. If you are using or accessing an identity management domain you are responsible for deleting your details and data from the identity management domain. You are responsible for retrieving your content in the identity management domain during your applicable services period.","About Personal Information","84395.htm");
Page[75]=new Array("Construction Intelligence Cloud Advisor consumes data from source applications and makes it available to CIC Advisor users. End-users must give their consent in the source application to read and agree to the consent message to ensure they:","have access to the data in CIC Advisor","understand the responsibilities with regard to data protection and security","P6 EPPMsource applications can be configured with CIC Advisor. For detailed instructions on how to configure consent notices in P6 EPPM, refer to P6 EPPM Application Administration Guide.","Configuring Consent Notices for CIC Advisor","85494.htm");
Page[76]=new Array("Oracle might use cookies for authentication, session management, remembering application behavior preferences and performance characteristics, and to provide documentation support.","Also, Oracle might use cookies to remember your log-in details, collect statistics to optimize site functionality, and deliver marketing based on your interests.","For more information on Oracle's data collection processes and privacy commitments, see:","Oracle Cloud Services Agreement http://www.oracle.com/us/corporate/contracts/saas-online-csa-us-1894130.pdf","Oracle Privacy Policy https://www.oracle.com/legal/privacy/services-privacy-policy.html","Oracle Data Processing Agreement https://www.oracle.com/corporate/contracts/cloud-services/","Cookies Policy in Construction Intelligence Cloud","89134.htm");
Page[77]=new Array("Information security and privacy laws can carry heavy penalties and fines for organizations which do not adequately protect PI they gather and store. Data visible to an Construction Intelligence Cloud Advisor user depends on the consent notices configured and accepted by users in the source applications which can be configured with Analytics.","If these laws apply to your organization, it is your responsibility to ensure consent notices are configured in the source applications before they are required.","Your Responsibilities","85495.htm");
Page[78]=new Array("Personal information (PI) in CIC depends on the changes made in source applications such as P6 EPPM. When PI data is modified or deleted in the source applications, run the ETL process to ensure it is automatically reflected in CIC. If a user is deleted in a source application, they can no longer access &lt;0P_ProdName_CIC_Suite. ","Ensuring Privacy of Data Collection","85496.htm");
Page[79]=new Array("Products provide granular access controls, by record, data element, type of data, or logs. Ensure CIC Advisor adheres to the same user privileges and access rights as the source applications.","Limiting Granular Access to Data","85497.htm");
Page[80]=new Array("Data masking is the ability to display only a portion of a data field or prevent viewing data. Oracle database security policies can hide access to certain columns. Ensure you review this feature for CIC Advisor.","Ensuring Data Masking is Supported","85499.htm");
Page[81]=new Array("An IP white list is a list of trusted IP addresses from which your users can access domains. CIC Advisor uses OBIEE for displaying analyses and dashboards. For more details on IP white-listing, refer to OBIEE documentation.","Ensuring IP White-Listing","85500.htm");
Page[82]=new Array("CIC Advisor has control over some sensitive fields. Control can be regulated to only users that are allowed to login. Data access is generally project level and either cost or no cost, and granularity is provided for those differences. Global data is also visible but honors same security as source applications.","Controlling Access to Special Categories of Data","85501.htm");
Page[83]=new Array("Congratulations!! You have now successfully completed setting up CIC Advisor Administration application to run ETLs and bring projects into CIC Advisor.","Sign in to the CIC Advisor application and also refer to the CIC Advisor Reference Guides to review the insights delivered for your projects.","Whats Next?","85945.htm");
var PageCount=85;


/*
Date: 12/23/2024 12:56 PM
Source: analytics_25_dev
BookID: 85604
PubProduct: CIC_ADVISOR
BookTitle: Administration Guide
Version: Version 25
Lang:	en
*/
	var PageLength=Page.length;
	var Result = "";
	var ResultTemp = "";
	var ResultFound = "";
	var ResultTitleOnly = [];
	var ResultTitleAndContent = [];
	var ResultInContent = [];
	var ResultInContentTemp = [];

	var ResultCombinedTemp = [];
	var ResultCombined = [];

	var arrayIndex = 0;
	var NrRes = 0;
	var j = 0;
	var i = 0;
	var k = 0;
	var d = 0;
	var maxItems = 1000;
	var heading = 0;
	var WordPos = -1;
	var WordPosHeading = -1;
	var WordPosContentText = -1;
	var FoundWord = "";
	var FoundWordHead = "";
	var SearchInHeadingOnly = 0;
	var isChecked;
	var size = 10;
	var resGroupCounter = 0;
	var shown = "shown";
	var checkBoxInHeading;
	var searchFlag = 0;
	var DivResult;
	var SearchWord;

if (SearchText && SearchText.length >= 1) {
		SearchWord = SearchText.replace(/\+/g, " ").replace(/&/g, "&amp;").replace(/</g, "&lt;").replace(/>/g, "&gt;").replace(/"/g, "&quot;");
		searchFlag = 1;
	} else {
		SearchWord = "";
		searchFlag = 0;
	}
	

	if (searchFlag === 1) {
		Result = "";

		// checkBoxInHeading = document.getElementById("inHeading");
		if (inHeading) {

			isChecked = true;
		} else {

			isChecked = false;
		}

		if (SearchWord && SearchWord.length >= 1) {
			if (isChecked) {
				SearchInHeadingOnly = 1;
			} else {
				SearchInHeadingOnly = 0;
			}
			SearchWord = SearchWord.toLowerCase();
			window.status = "Searching, please wait...";
			for (j = 0; j < PageLength; j++) {
				k = Page[j].length - 1;
				for (i = 0; i < k; i++) {

					heading = k - 1;

					if (SearchInHeadingOnly === 1) {
						WordPosHeading = Page[j][heading].toLowerCase().indexOf(SearchWord);
						if (WordPosHeading > -1) {
							FoundWordHead = Page[j][heading].substr(WordPosHeading, SearchWord.length);

							NrRes++;
							ResultTemp = "<li>";
							ResultTemp += "<span>";
							ResultTemp += "<a href='" + Page[j][k] + "'>" + Page[j][heading].replace(FoundWordHead, FoundWordHead.bold()) + "</a><br/>\n";

							ResultTemp += "</span>";
							ResultTemp += "</li>";

							ResultTitleOnly[arrayIndex] = ResultTemp;
							arrayIndex++;

							ResultTemp = "";
							WordPosHeading = -1;
							WordPosContentText = -1;
							break;
						}
					} else if (SearchInHeadingOnly === 0) {
						WordPos = Page[j][i].toLowerCase().indexOf(SearchWord);
						WordPosHeading = Page[j][heading].toLowerCase().indexOf(SearchWord);
						if (WordPos > -1) {
							FoundWordHead = Page[j][heading].substr(WordPosHeading, SearchWord.length);
							FoundWord = Page[j][i].substr(WordPos, SearchWord.length);
							FoundWord = Page[j][i].substr(WordPos, SearchWord.length);
							NrRes++;
							ResultTemp += "<li>";
							ResultTemp += "<span>";
							if (WordPosHeading > -1) {
								ResultTemp += "<a href='" + Page[j][k] + "'>" + Page[j][heading].replace(FoundWordHead, FoundWordHead.bold()) + "</a><br/>\n";
							} else {
								// found word is not in the head
								ResultTemp += "<a href='" + Page[j][k] + "'>" + Page[j][heading] + "</a><br/>\n";

							}
							if (i < k - 1) {
								WordPosContentText = Page[j][i].toLowerCase().indexOf(SearchWord);

								if (Page[j][i].length > 300 && (WordPosContentText > -1)) {

									if (WordPosContentText > 75) {
										ResultInContentTemp.push("..." + Page[j][i].substr(WordPosContentText - 75, 175 + FoundWord.length).replace(FoundWord, FoundWord.bold()) + "...");
									} else {
										ResultInContentTemp.push("..." + Page[j][i].substr(0, 175 + FoundWord.length).replace(FoundWord, FoundWord.bold()) + "...");

									}

								} else if (WordPosContentText > -1) {

									ResultInContentTemp.push(Page[j][i].replace(FoundWord, FoundWord.bold()));

								}
							}

							ResultTemp += ResultInContentTemp.join("");

							ResultTemp += "</span>";
							ResultTemp += "</li>";

							if (WordPosHeading > -1) {
								ResultTitleAndContent[arrayIndex] = ResultTemp;
								arrayIndex++;
							} else {
								ResultInContent[arrayIndex] = ResultTemp;
								arrayIndex++;
							}

							ResultInContentTemp.length = 0;
							ResultTemp = "";
							WordPosHeading = -1;
							WordPosContentText = -1;
							break;
						}

					}
				}
			}

			ResultTitleOnly = ResultTitleOnly.filter(function (n) {
				return (n !== undefined && n !== null);
			});
			ResultTitleAndContent = ResultTitleAndContent.filter(function (n) {
				return (n !== undefined && n !== null);
			});
			ResultInContent = ResultInContent.filter(function (n) {
				return (n !== undefined && n !== null);
			});

			ResultCombinedTemp = ResultTitleOnly.concat(ResultTitleAndContent, ResultInContent);

			ResultCombinedTemp = ResultCombinedTemp.filter(function (n) {
				return (n !== undefined && n !== null);
			});

			for (d = 0; d < ResultCombinedTemp.length; d += size) {
				resGroupCounter++
				ResultCombined.push("<div id=" + "'" + "resGroup_" + resGroupCounter + "'" + " class=" + "'" + "resGroup " + shown + "'" + ">" + "<ol class='searchResults'>" + ResultCombinedTemp.slice(d, d + size).join("") + "</ol></div>");
				shown = "notshown";
			}

			ResultFound = ResultCombined.join("");

Result += "<div id='searchDetailsDiv'>";
			Result += "<p class='searchDetails'>Your Search Found&nbsp;" + NrRes + "&nbsp;items.&nbsp;";
			Result += "</p></div>";
			
			Result += "<div class='searchResultsDiv'>";
			Result += "<div id='resultsCollection' class='searchResults'>";
			Result += ResultFound;
			Result += "</div>";
			Result += "</div>";
			Result += "<div class='searchPaging'>";

			Result += '<hr />';

			Result += '<p class="bodytext"><a class="disabledAnchor" id="pBack" onclick="turnPage(\'backPage\')" href="#pBack">Back</a>&nbsp; | &nbsp;';
			
			if (resGroupCounter && resGroupCounter > 1) {
				Result += '<a id="pNext" onclick="turnPage(\'nextPage\')" href="#pNext">Next</a>';
			} else {
				Result += '<a id="pNext"  class="disabledAnchor" href="#pNext">Next</a>';
			}
			Result += '</p>\n';
			Result += '<div id="pagenofn"><p class="bodytext">Page <span id="pagen">1</span> of ' + resGroupCounter + '</p></div>';

			Result += "</div>";
			
			
		}

		DivResult = document.getElementById("s_anchor");
		if (Result && DivResult) {

			//myDivResult.append(Result);
			DivResult.innerHTML = Result;
			

		}
		window.status = "";
		
		

	}
	}())
}
