define(
{
    "toc":[
        {
            "heading":"Table of Contents",
            "topics":[
                {
                    "title":"About the REST APIs",
                    "href":"index.html"
                },
                {
                    "title":"All REST Endpoints",
                    "href":"rest-endpoints.html"
                }
            ]
        },
        {
            "heading":"Get Started",
            "topics":[
                {
                    "title":"About This Guide",
                    "href":"D109109.html"
                },
                {
                    "title":"About REST Style Architecture",
                    "href":"D109111.html"
                },
                {
                    "title":"Status Codes",
                    "href":"D109129.html"
                },
                {
                    "title":"Using the Primavera Administration API",
                    "href":"D109114.html"
                },
                {
                    "title":"Security",
                    "href":"D142269.html",
                    "topics":[
                        {
                            "title":"Using Basic Authentication",
                            "href":"D109130.html"
                        },
                        {
                            "title":"Using OAuth Authentication",
                            "href":"D142270.html",
                            "topics":[
                                {
                                    "title":"Generating OAuth Tokens",
                                    "href":"D142259.html",
                                    "topics":[
                                        {
                                            "title":"Using Resource Owner Password Credential (ROPC) Grant Type",
                                            "href":"D142272.html"
                                        },
                                        {
                                            "title":"Using JSON Web Token (JWT) Grant Type",
                                            "href":"D142280.html",
                                            "topics":[
                                                {
                                                    "title":"Prerequisite Setup",
                                                    "href":"D142281.html"
                                                },
                                                {
                                                    "title":"Using JWT User Assertion",
                                                    "href":"D142282.html"
                                                },
                                                {
                                                    "title":"Using Refresh Tokens",
                                                    "href":"D142284.html"
                                                }
                                            ]
                                        },
                                        {
                                            "title":"Generating the OAuth Access Token",
                                            "href":"D142283.html",
                                            "topics":[
                                                {
                                                    "title":"Using Client ID and Secret",
                                                    "href":"D142285.html"
                                                },
                                                {
                                                    "title":"Using JWT Client Assertion",
                                                    "href":"D142286.html"
                                                }
                                            ]
                                        }
                                    ]
                                },
                                {
                                    "title":"Using OAuth for Authentication and Authorization",
                                    "href":"D142260.html"
                                }
                            ]
                        }
                    ]
                },
                {
                    "title":"cURL Overview",
                    "href":"D109131.html"
                },
                {
                    "title":"Using cURL",
                    "href":"D109132.html"
                },
                {
                    "title":"Node.js Overview",
                    "href":"D109133.html"
                },
                {
                    "title":"Using Node.js",
                    "href":"D109134.html"
                },
                {
                    "title":"Troubleshooting the Primavera Administration API",
                    "href":"D109113.html"
                },
                {
                    "title":"Use Cases",
                    "href":"D141516.html",
                    "topics":[
                        {
                            "title":"Viewing the job id status",
                            "href":"D141517.html"
                        },
                        {
                            "title":"Exporting failed users",
                            "href":"D141518.html"
                        }
                    ]
                }
            ]
        },
        {
            "heading":"Tasks",
            "topics":[
                {
                    "title":"Background Jobs",
                    "href":"api-background-jobs.html",
                    "topics":[
                        {
                            "title":"Get Job Details",
                            "href":"op-bgjobs-bgjobname-get.html"
                        },
                        {
                            "title":"Trigger a background job",
                            "href":"op-bgjobs-bgjobname-post.html"
                        }
                    ]
                },
                {
                    "title":"Background Jobs (v3)",
                    "href":"api-background-jobs-v3.html",
                    "topics":[
                        {
                            "title":"Get Job Details",
                            "href":"op-v3-bgjobs-bgjobname-get.html"
                        },
                        {
                            "title":"Trigger a background job",
                            "href":"op-v3-bgjobs-bgjobname-post.html"
                        }
                    ]
                },
                {
                    "title":"OAuth2",
                    "href":"api-oauth2.html",
                    "topics":[
                        {
                            "title":"To Get OAuth2 Token",
                            "href":"op-oauth2-token-get.html"
                        }
                    ]
                },
                {
                    "title":"Roles",
                    "href":"api-roles.html",
                    "topics":[
                        {
                            "title":"Get Application Roles",
                            "href":"op-roles-get.html"
                        }
                    ]
                },
                {
                    "title":"Roles (v3)",
                    "href":"api-roles-v3.html",
                    "topics":[
                        {
                            "title":"Get Application Roles",
                            "href":"op-v3-roles-get.html"
                        }
                    ]
                },
                {
                    "title":"User Audit Events",
                    "href":"api-user-audit-events.html",
                    "topics":[
                        {
                            "title":"Get All Users Audit Events",
                            "href":"op-audits-get.html"
                        },
                        {
                            "title":"Get Audit Events On Date Filter",
                            "href":"op-audits-startdate-enddate-get.html"
                        },
                        {
                            "title":"Get Audit Events On Pagination Filter",
                            "href":"op-audits-page-page-count-size-get.html"
                        },
                        {
                            "title":"Get Users Specific Audit Events",
                            "href":"op-audits-useremail-grantor-get.html"
                        }
                    ]
                },
                {
                    "title":"User Audit Events (v3)",
                    "href":"api-user-audit-events-v3.html",
                    "topics":[
                        {
                            "title":"Get All Users Audit Events",
                            "href":"op-v3-audits-get.html"
                        },
                        {
                            "title":"Get Audit Events On Date Filter",
                            "href":"op-v3-audits-startdate-enddate-get.html"
                        },
                        {
                            "title":"Get Audit Events On Pagination Filter",
                            "href":"op-v3-audits-page-page-count-size-get.html"
                        },
                        {
                            "title":"Get Users Specific Audit Events",
                            "href":"op-v3-audits-useremail-grantor-get.html"
                        }
                    ]
                },
                {
                    "title":"User Management",
                    "href":"api-user-management.html",
                    "topics":[
                        {
                            "title":"Create/Update Company",
                            "href":"op-user-companies-add-list-post.html"
                        },
                        {
                            "title":"Create/Update users",
                            "href":"op-user-post.html"
                        },
                        {
                            "title":"Enable/Disable users",
                            "href":"op-user-change-status-put.html"
                        },
                        {
                            "title":"Export a Job's failed users",
                            "href":"op-user-status-jobid-draft-get.html"
                        },
                        {
                            "title":"Export a Job's log",
                            "href":"op-user-status-jobid-log-get.html"
                        },
                        {
                            "title":"Get all Users",
                            "href":"op-user-get.html"
                        },
                        {
                            "title":"Get Job status",
                            "href":"op-user-status-jobid-get.html"
                        },
                        {
                            "title":"Get User",
                            "href":"op-user-userid-get.html"
                        },
                        {
                            "title":"Reset a User password (Random Value)",
                            "href":"op-user-userid-auto-reset-pwd-put.html"
                        },
                        {
                            "title":"Reset Users passwords (Known Value)",
                            "href":"op-user-manual-reset-pwd-isemailpasswd-put.html"
                        },
                        {
                            "title":"Reset Users passwords (Random Value)",
                            "href":"op-user-auto-reset-pwd-put.html"
                        },
                        {
                            "title":"Unlock Users",
                            "href":"op-user-change-lock-put.html"
                        }
                    ]
                },
                {
                    "title":"User Management (v2)",
                    "href":"api-user-management-v2.html",
                    "topics":[
                        {
                            "title":"Enable/Disable users",
                            "href":"op-v2-user-change-status-put.html"
                        }
                    ]
                },
                {
                    "title":"User Management (v3)",
                    "href":"api-user-management-v3.html",
                    "topics":[
                        {
                            "title":"Create/Update Company",
                            "href":"op-v3-user-companies-add-list-post.html"
                        },
                        {
                            "title":"Create/Update users",
                            "href":"op-v3-user-post.html"
                        },
                        {
                            "title":"Enable/Disable users",
                            "href":"op-v3-user-change-status-put.html"
                        },
                        {
                            "title":"Export a Job's failed users",
                            "href":"op-v3-user-status-jobid-draft-get.html"
                        },
                        {
                            "title":"Export a Job's log",
                            "href":"op-v3-user-status-jobid-log-get.html"
                        },
                        {
                            "title":"Get all Users",
                            "href":"op-v3-user-get.html"
                        },
                        {
                            "title":"Get Job status",
                            "href":"op-v3-user-status-jobid-get.html"
                        },
                        {
                            "title":"Get User",
                            "href":"op-v3-user-userid-get.html"
                        },
                        {
                            "title":"Reset a User password (Random Value)",
                            "href":"op-v3-user-userid-auto-reset-pwd-put.html"
                        },
                        {
                            "title":"Reset Users passwords (Known Value)",
                            "href":"op-v3-user-manual-reset-pwd-isemailpasswd-put.html"
                        },
                        {
                            "title":"Reset Users passwords (Random Value)",
                            "href":"op-v3-user-auto-reset-pwd-put.html"
                        },
                        {
                            "title":"Unlock Users",
                            "href":"op-v3-user-change-lock-put.html"
                        }
                    ]
                }
            ]
        }
    ]
});