'use strict';
function search(SearchText, inHeading) {
(function () {
var Page = [];

/* Generated with Author-it 23.4.1.30004  12/23/2024 11:05:41 AM */
Page[0]=new Array("Copyright  1997, 2025, Oracle and/or its affiliates.","Primary Author: Oracle Corporation","Title and Copyright Information","88891.htm");
Page[1]=new Array("This guide contains the information you need to administer the Primavera Analytics cloud service. As an administrator, you will use the Primavera Analytics Administration application to provision users and perform tasks to enable the use of:","Financial Periods","History Settings","Slowly Changing Dimensions","Changing Dimensions and Daily Snapshots","Burn Down","Work Planning","Schedule Adherence","Location Data","Audience","This guide is intended to be used by cloud administrators who have application access to Primavera Analytics Production. In addition, administrators should have application access to P6 EPPM, Primavera Unifier, or both, and/or Oracle Primavera Cloud.","About This Guide","83748.htm");
Page[2]=new Array("Oracle&#8217;s Primavera Analytics is a packaged business intelligence solution that provides valuable insights into your projects and portfolios in Oracle&#8217;s Primavera P6 Enterprise Project Portfolio Management (P6 EPPM), Primavera Unifier, and Oracle Primavera Cloud. Primavera Analytics is built upon the industry leading Oracle Analytics Server (OAS) application. ","Primavera Analytics consists of a:","Repository Definition","The Primavera Analytics Repository Definition contains all of the information Oracle Analytics Server (OAS) needs to allow end users to create purposeful analysis based on data contained in the data warehouse. It also contains information such as how Oracle Analytics Server (OAS) connects to the Primavera Data Warehouse, how security is applied to each user, and how to join fact and dimension tables.","Sample catalog","The Primavera Analytics sample catalog contains over 450 pre-built analyses and dashboards. They are organized in a catalog structure to help facilitate the capabilities available by combining P6 EPPM, Primavera Unifier, and/or Oracle Primavera Cloud with Oracle Analytics Server (OAS).","About Primavera Analytics","88514.htm");
Page[3]=new Array("Primavera Data Warehouse is a data repository that collects and stores data from the following products: ","P6 EPPM","Primavera Unifier ","Oracle Primavera Cloud","It contains a process called STARETL to extract, transform, and load (ETL) data from the above applications into Primavera Data Warehouse.","Primavera Data Warehouse separates the data into:","Facts","Fact tables contain business facts or measures. For example: Actual Total Cost, Workflow Duration.","Dimensions","Dimension tables contain descriptive attributes or fields. For example: Activity Name, Cost Breakdown Structure. ","As Primavera Data Warehouse schema accumulates project and cash flow data, it provides baselines for tracking trends and for advanced business intelligence. It also provides key metrics on current data, which allow you to drill through root cause analysis.","About Primavera Data Warehouse","88513.htm");
Page[4]=new Array("Oracle Analytics Server (OAS)enables you to explore data through interactive visualizations, load and model data, and analyze data by creating reports and dashboards. It integrates data from multiple enterprise sources, and transforms it into key insights that enable strategic decision-making, drive continual business process improvements, and promote alignment across the enterprise.","Primavera Analytics provides the following default dashboards:","Main","Business Processes","Cash Flow","Cost Sheet","Facilities and Real Estate","Portfolio Analysis","Project Earned Value","Project Health","Resource Analysis","Industry Samples","Admin","About: Primavera Analytics","Primavera Cloud","More...","For more information about Oracle Analytics Server, go to the following website: https://docs.oracle.com/en/middleware/bi/analytics-server/index.html","About Oracle Analytics Server","88515.htm");
Page[5]=new Array("The Analytics Administration application gives administrators the ability to add or change settings for their deployment of Primavera Data Warehouse. Use this administration application to perform the following tasks:","Run on-demand or schedule STARETL runs","Configure multiple data sources, codes, and UDFs for P6 and Primavera Cloud","View the history and logs of previous STARETL runs","The Analytics Administration application enables you to administer Analytics from any location.","About the Analytics Administration Application","88516.htm");
Page[6]=new Array("This topic includes guidelines and tips regarding accessible product usage.","Oracle has also published an Accessibility Conformance Report (ACR) for the Primavera Analytics product. The latest version of the Primavera Analytics Accessibility Conformance Report can be accessed from Oracle's Accessibility Program Website at this link: https://www.oracle.com/corporate/accessibility/vpats.html#acrs-tab.","Assistive Technology","Users can use assistive technology, such as screen readers, with Primavera Analytics.","Keyboard Shortcuts","The list of keyboard shortcuts for Primavera Analytics, including page-specific and browser-specific keyboard shortcuts, can be accessed here: Keyboard Shortcuts.","Product Accessibility","89148.htm");
Page[7]=new Array("KeYou can use your keyboard to navigate throughout Primavera Analytics and the Analytics Administration application, and access frequently used or important functionality. Use the Tab key to cycle through elements within the application, and press Enter or Spacebar to access them. Some keyboard shortcuts may change depending on the browser you use. ","Common Shortcuts","The following shortcuts are common to all pages of Primavera Analytics:","Press Tab to navigate to any element.","Press Enter to click on the element.","Press the space bar to select a check box.","Press Shift+Tab to navigate back to any element.","Use the Arrow keys(LEFT and RIGHT) to select radio buttons/within the table row.","Use Arrow keys(UP and DOWN) to move through the drop-down lists/ to select values in combo boxes.","Keyboard Shortcuts","89149.htm");
Page[8]=new Array("Consent notices inform users how personal information (PI) is collected, processed, stored, and transmitted, along with details related to applicable regulations and policies. Consent notices also alert users that the action they are taking may risk exposing PI. Primavera products helps you to ensure that you have requested the appropriate consent to collect, process, store, and transmit the PI your organization holds as part of any source application (P6, Unifier, or Primavera Cloud) that can be configured with Primavera Analytics.","About Consent Notices","88503.htm");
Page[9]=new Array("Personal information (PI) is any piece of data which can be used on its own or with other information to identify, contact or locate an individual or identify an individual in context. This information is not limited to a person's name, address, and contact details. For example, a person's IP address, phone IMEI number, gender, and location at a particular time could all be personal information. Depending on local data protection laws , organizations may be responsible for ensuring the privacy of PI wherever it is stored, including in back-ups, locally stored downloads, and data stored in development environments.","As part of your Primavera Analytics Cloud Service, you may be using an identity management domain to manage your user access and entitlements across a number of cloud and on-premises applications and services. If you are using or accessing an identity management domain you are responsible for deleting your details and data from the identity management domain. You are responsible for retrieving your content in the identity management domain during your applicable services period.","About Consent Notices","88504.htm");
Page[10]=new Array("Analytics consumes data from source applications and makes it available to Analytics users. End-users must give their consent in the source application to read and agree to the consent message to ensure they","have access to the data in Analytics.","understand the responsibilities with regard to data protection and security.","The following source applications can be configured with Analytics:","P6 EPPM","For detailed instructions on how to configure consent notices in P6 EPPM, refer to P6 EPPM Application Administration Guide.","Primavera Unifier","For detailed instructions on how to configure consent notices in Primavera Unifier, refer to Primavera Unifier Administration Guide ","Oracle Primavera Cloud","Configuring Consent Notices for Analytics","88505.htm");
Page[11]=new Array("Information security and privacy laws can carry heavy penalties and fines for organizations which do not adequately protect PI they gather and store. Data visible to an analytics user depends on the consent notices configured and accepted by users in the source applications which can be configured with Analytics.","If these laws apply to your organization, it is your responsibility to ensure consent notices are configured in the source applications before they are required.","Your Responsibilities","88506.htm");
Page[12]=new Array("Personal information (PI) in Primavera Analytics depends on the changes made in source applications such as P6 EPPM, Primavera Unifier and Oracle Primavera Cloud. When PI data is modified or deleted in the source applications, run the ETL process to ensure it is automatically reflected in Analytics. If a user is deleted in a source application, they can no longer access Primavera Analytics. ","Ensure the user is also deleted from the historical data of Primavera Analytics.","Ensuring Privacy of Data Collection","88507.htm");
Page[13]=new Array("Products provide granular access controls, by record, data element, type of data, or logs. Ensure the same user privileges and access rights are applied as in the source applications.","Limiting Granular Access to Data","88508.htm");
Page[14]=new Array("Primavera Analytics is a Data Warehouse application. Data is not purged because Primavera Analytics maintains data history. A Delete option is available if needed but not available to all users.","ODI logging is purged weekly. ","Ensuring Data Purging and Data Deletion","88509.htm");
Page[15]=new Array("Data masking is the ability to display only a portion of a data field or prevent viewing data. Oracle database security policies can hide access to certain columns. Ensure you review this feature for Primavera Analytics.","Ensuring Data Masking is Supported","88510.htm");
Page[16]=new Array("An IP allowlist is a list of trusted IP addresses from which your users can access domains. Primavera Analytics uses Oracle Analytics Server (OAS) for creating analyses and dashboards. For more details on IP allowlists, refer to Oracle Analytics Server (OAS) documentation.","Ensuring IP Allowlists","88511.htm");
Page[17]=new Array("Primavera Analytics has control over some sensitive fields. Control can be regulated to only users that are allowed to login. Data access is generally project level and either cost or no cost, and granularity is provided for those differences. Global data is also visible but honors same security as source applications.","Controlling Access to Special Categories of Data","88512.htm");
Page[18]=new Array("This section provides guidance on establishing security for Primavera Analytics cloud service.","Security Considerations","85456.htm");
Page[19]=new Array("For any company that deals with sensitive data, keeping it secure is crucial to success. While hosting Primavera Analytics data on Oracle Cloud provides security measures, it can't do everything. For example, it can't prevent phishing attempts or other attacks that exploit gaps in its users' security awareness. That's why it's important for everyone who works with Primavera Analytics to understand what they can do to keep data secure.","Security is everyone's business. This information is for anyone who uses, manages, or is just interested in Primavera Analytics. If you're a security expert or administrator, this is a good place to start. It should help you see the big security picture and understand the most important guidelines related to security in Primavera Analytics.","Introduction","85460.htm");
Page[20]=new Array("Authentication refers to the way users sign on. If possible, Administrators should implement Single Sign-on (SSO). SSO reduces the number of passwords users have to remember. It also enables multi-factor login, which is when users are asked to provide some verification in addition to their passwords, like a code that they receive via text or email.","Authentication: How Users Sign On","85459.htm");
Page[21]=new Array("Authorization refers to what users can access. There are several ways to manage this in Primavera Analytics.","Permission Sets: In Primavera Analytics, permission sets help administrators view and set permissions for many users by listing permissions in multi-dimensional tables.","Groups: Security groups make it easier for administrators to assign permission sets to multiple users at the same time. P6 and Unifier users need to be assigned access to the Analytics module within P6 and Unifier application respectively. Also in the identity management domain, P6 users should be assigned the roles of Primavera Analytics Production and either BI Production Consumer or BI Production Author. Similarly, Unifier users should be assigned the roles of either BI Production Consumer or BI Production Author, and Primavera Analytics Production. ","Roles in Primavera Analytics: Products provide granular access controls, by record, data element, type of data, or logs. Ensure Primavera Data Warehouse adheres to the same user privileges and access rights as P6 and Primavera Unifier. ","To give access to Primavera Analytics, P6 users must be assigned with Primavera Analytics Production and either BI Production Consumer or BI Production Author. For more details on how to assign access, see Assigning Access to Primavera Analytics for P6 EPPM Users.","To give access to Primavera Analytics, Unifier users must be assigned with Primavera Analytics Production and either BI Production Consumer or BI Production Author. For more details on how to assign access, see Assigning Access to Primavera Analytics for Primavera Unifier Users.","To give access to Primavera Analytics, Oracle Primavera Cloudusers must be assigned with Primavera Analytics Production and either BI Production Consumer or BI Production Author. For more details on how to assign access, see Assigning Application Access to Primavera Cloud Users.","Authorization: What Users can Access","85461.htm");
Page[22]=new Array("From laptops to cellphones, organizations have to keep track of data on more devices than ever, and more devices means more risk. ","Endpoint Security","85462.htm");
Page[23]=new Array("No automated security system or protocol can make a system fully secure if those with legitimate access exploit it for illegitimate purposes or if a device falls into the wrong hands. Here are some general &quot;common sense&quot; guidelines you should follow when it comes to endpoint security: ","Grant security permission conservatively. Don't give everyone permission to everything just to avoid perceived complexity. Remember, one breach can be many times more costly and time consuming than setting and following standard security protocols.","Organize permission sets and credentials so they can be edited quickly. Keep user groups and their permissions organized and easy to manage. Use descriptive names for permission sets, and organize them logically to make it easier for you or anyone else to manage them quickly and confidently.","Keep up with organizational changes. If a user no longer needs access to a part of the app, for whatever reason, update that user's permissions accordingly.","Inherent Risks and Practical Policies","85463.htm");
Page[24]=new Array("Closely related to security are matters of privacy and personal information.","View the section Managing Personal Information in Primavera Analytics in the Primavera Analytics Cloud Service Administration Guide to learn about what information is collected and what you can do to monitor personal information in Primavera Analytics.","Privacy and Personal Information","85464.htm");
Page[25]=new Array("We'll use the term administrator to refer to anyone who's responsible for managing a company's data and who can access that data. For our purposes, administrators includes a wide variety of IT professionals, from those who define roles in the Primavera Analytics application to those who manage company servers.","An end user is anyone who uses Primavera Analytics to do their job. This includes project managers, executives, and everyone else who logs into Primavera Analytics from an office or jobsite to get their work done.","Administrators should...","Set up Single Sign-On (SSO) and enable multi-factor authentication to minimize the number of passwords that users have to remember and to consolidate risk.","Kindly educate users on how they can avoid unwittingly helping hackers. One of the best ways application administrators and security advocates can help users is by helping them to prevent security breaches.","Use a VPN to encrypt data being sent over the internet.","Stay up-to-date about security trends and best practices. ","End users should...","Follow security guidelines created by their companies and the administrators of any network applications they use.","Use strong passwords. The more random-looking the better, and avoid reusing passwords.","Learn to recognize phishing. Phishing is when someone disguises an email or some other transmission as a legitimate message in an attempt to get a user to reveal sensitive information. For example, a hacker may send you an email disguised to look like an email from your employer requesting login information. These attacks are becoming more sophisticated, but you can still protect yourself by making sure any emails you receive or websites you visit are legitimate before using them to share sensitive information. ","Some Security Basics","85465.htm");
Page[26]=new Array("The ability to connect and exchange information with other applications is powerful, but it also presents some potential security issues that administrators must manage. It is important to understand which data flows between applications to ensure compliance with policies and regulations related to security and privacy. ","Integration with Other Applications","85466.htm");
Page[27]=new Array("While the apps used by your organization may have some security features of their own, most security issues ultimately come down to the people who use them. When your company establishes its security procedures, it's important to also establish in-house security experts to whom other members can turn when they have security questions. Security points of contact should be continuously learning about security trends and how they can educate users to keep their data and network secure. Security contacts should also routinely update and maintain protocols that suit the security needs of their organizations.","Establishing Security Contacts","85468.htm");
Page[28]=new Array("This chapter describes how to assign access to Primavera Analytics for users of any of the following products:","P6 EPPM","Primavera Unifier","Primavera Cloud","Note: Users are assigned access to Primavera Analytics from P6 EPPM and Primavera Unifier applications respectively, whereas Primavera Cloud users are assigned access from within Primavera Analytics Administration Web application.","Assigning User Access to Primavera Analytics","84265.htm");
Page[29]=new Array("To assign application access to Primavera Analytics for P6 EPPM users:","Sign in to Primavera Administration and do the following:","Add a user.","To give access to Primavera Analytics for that user, assign the roles of Primavera Analytics Production, and either BI Production Consumer or BI Production Author.","Note: For details on Primavera Administration, see the Primavera Administration Identity Management Guide.","Sign in to P6 EPPM as an administrator and do the following:","From the Administer menu, select User Access.","From the User Access window, modify the user accounts that will need access to Primavera Analytics.","Select the user account, and in the lower section of the screen, click the Module Access tab.","In the Module Access panel, select the P6 Analytics module check box in the Access column.","Click the Save button.","Repeat these steps for each user account that will need to access data from the Primavera Analytics.","Run the Global Schedule Services. For details, see Configuring and Running P6 EPPM Publication Services.","Note: You can schedule this service to run immediately or later, but it must run to successful completion prior to running the STARETL process.","Run the STARETL process.","Assigning Access to Primavera Analytics for P6 EPPM Users","83779.htm");
Page[30]=new Array("To assign application access to Primavera Analytics for Primavera Unifier users: ","Sign in to Primavera Administration and do the following:","Add a user.","To give access to Primavera Analytics for that user, assign the roles of Primavera Analytics Production, and either BI Production Consumer or BI Production Author.","Note: For details on Primavera Administration, see the Primavera Administration Identity Management Guide.","Sign in to Primavera Unifier and do the following:","Go to the Company Workspace tab and switch to Admin mode.","In the left navigator, click Access Control.","In the right pane, select Administration Mode Access &gt; Analytics.","In the Permission Settings window, add, modify, or remove permission settings as follows:","Click Add.","In the Permissions Settings window, click Add Users/Groups.","In the Users/Groups window, select users and groups you want to add.","Click Add.","Click OK&nbsp;to return to the Permission Settings window.","To set permissions:","In the upper pane , select users and groups.","In the lower pane, select the appropriate level of access:","View: Allows users and groups to open and view the contents in Analytics node. Users with View permission cannot make any changes.","Modify: Allows users and groups to configure and modify the data required for Analytics. This setting also includes View permission. Users are also able to set schedule for publishing data, for various areas in Unifier, to the Oracle Analytics Server (OAS). The View option must be selected for the users with Modify permissions.","Click OK.","Click OK.","Note: The Permissions tab enables access to permission templates. You can copy a permission template to quickly set up the permissions for a new user or group. You can also save an existing user or group&#8217;s permission settings as a new template for later use.","Run the STARETL process.","Assigning Access to Primavera Analytics for Primavera Unifier Users","83782.htm");
Page[31]=new Array("To assign Primavera Cloud users access to Primavera Data Warehouse:","Sign in to Primavera Analytics Administration Web Application:","http://&lt;host&gt;:&lt;port&gt;/p6rdb","In the sidebar, click the .@ User Management icon.","To select users:","In the License Enabled column, select the check box to assign application access to each User Name.","Select Repopulate Security to give the selected users immediate access to their project data as an alternative to provide access subsequent to an ETL run.","Select Save.","Assigning Application Access to Primavera Cloud Users","85332.htm");
Page[32]=new Array("Primavera Data Warehouse adheres to the same user privileges and access rights as P6 EPPM and Primavera Unifier. Additional privileges may need to be granted to specific P6 EPPM and Primavera Unifier users. These privileges include Organizational Breakdown Structure (OBS), Cost access, and Resource access. Refer to the P6 EPPM Application Administration Guide for details about user privileges. ","The following table briefly describes the Primavera Data Warehouse and P6 EPPM privileges:","Type","Description","OBS Access","Users who have OBS access in P6 EPPM will have OBS access in Oracle Analytics Server.","Edit EPS Costs/Financials","Users who have access to projects in the P6 EPPM database and who have this privilege set will have the same privilege in the Primavera Data Warehouse database.","Resource Access","Resource access can be set to one of the following:","All resource access: The user will have unrestricted access to resources.","None: The user cannot access any resources.","Specific resource access: The user can only access a specific resource.","Note: After modifying any P6 EPPM security privilege that affects Primavera Data Warehouse, it is required that the &quot;Publish Security&quot; Global Scheduled Service be run prior to running the STARETL process. This ensures that the correct privileges have been applied to the user account. For more information on running Global Scheduled Services, see Configuring and Running P6 EPPM Publication Services for more details.","Primavera Unifier user privileges are controlled both at the Company and the Project levels. For more details, see Primavera Unifier documentation.","P6 EPPM and Primavera Unifier Privileges","83441.htm");
Page[33]=new Array("To give your users the ability to archive catalogs, unarchive catalogs, upload files in Oracle Analytics Server (OAS): ","Sign in to Analytics as an Oracle Analytics Server (OAS) administrator.","Click on the Administration link, and then click Manage Privileges.","To assign archive privileges to a BI Production Superusers role:","In the Catalog section, click BI Service Administrator for the Archive Catalog privilege.","Note: By default, these privileges are assigned to a BI Service Administrator.","In the Privilege: Archive Catalog dialog box, click on the + sign.","In the Add Application Roles and Users dialog box:","Search for the BI Production Superusers role.","Move the BI Production Superusers role to the Selected Members pane.","Click OK to grant Archive Catalog privileges.","Repeat the entire sequence above and assign the following privileges for the BI Production Superusers role: ","UnArchive Catalog","Upload Files","Set Ownership of Catalog Objects","Save System-Wide Column Formats","Save Content with HTML Markup","Enabling Privileges for Users in Oracle Analytics Server","86109.htm");
Page[34]=new Array("The Analytics Administration application supports the following data sources: ","Primavera Cloud","P6 EPPM","Primavera Unifier","This section describes how to configure the application for each data source.","Configuring Primavera Analytics Administration Application","83749.htm");
Page[35]=new Array("To access and use the Analytics Administration Web application:","Sign in to: http:// &lt;host&gt;:&lt;port&gt;/p6rdb","where &lt;host&gt; and &lt;port&gt; were configured when you deployed p6rdb.","Depending on the data sources setup in analytics, the following icons display in the sidebar to perform administrative tasks:","@ Home: Displays currently running STARETL processes for all data sources and enables you to stop a currently running STARETL process.","@ Status: Displays  details on recently run STARETL processes for all data sources. You can view a status report and an ETL Log for each STARETL process. Use this menu option to start, restart, or schedule ETL runs for a data source.","@ Codes: Displays a master list of codes that are available and a subset of those which have been enabled for project, activity and resource data. Use this menu option to add or remove codes for a data source.","@ UDFs: Displays a list of all UDF codes that are available and a subset of those which have been enabled for project, activity, resource assignment, resource, and WBS data. Use this menu option to add or remove UDFs for a data source.","@ User Management: Displays a list of users you can give a license to access and use this application for Primavera Cloud data source. ","@ Publication Status: Displays the status of the publication services runs for P6 and Unifier data sources. ","@ Config: Configure and setup the properties of the STARETL process for each data source, and Oracle Analytics Server (OAS) settings.","Navigation Overview","83419.htm");
Page[36]=new Array("For a P6 EPPM data source, set up the configuration properties for STARETL runs and Oracle Analytics Server (OAS) settings as follows:","Sign in to the Primavera Analytics Administration Application:","http://&lt;host&gt;:&lt;port&gt;/p6rdb","In the sidebar, select @ Status.","In the Home menu, select a staretl&lt;id&gt; or a &lt;Custom Name of a data source&gt;.","In the sidebar, select @ Config.","For a P6 EPPM data source, set the following properties and then select Save:","Configuration Property","Description","In the Configurable Properties section, set up the following properties as required:","Custom Name for Datasource","Enter a name for the data source for identification purposes. For example, P6 EPPM Staging Data.","Enable Activity Period Actuals","Controls the display of past period actuals for activities.","Select any of the following values:","True (default): Enables pay period actuals for activities.","False: Disables pay period actuals for activities.","Note:  The Primavera Data Warehouse can use two additional financial periods. To add additional financial periods, submit a Service Request to My Oracle Support.","ODI LoadPlan Auto Restart","Controls restart of all real-time ODI Load plans.","Select any of the following values:","True (default): Auto restarts ODI load plans for a maximum count of 3 if an initial run fails.","False: Manually restart is required for all real-time ODI load plans.","Enable Resource Assignment Period Actuals","Controls the display of past period actuals for resources.","Select any of the following values:","True (default): Enables pay period actuals for resources.","False: Disables pay period actuals for resources.","Note:  The Primavera Data Warehouse can use two additional financial periods. To add additional financial periods, submit a Service Request to My Oracle Support.","Enable Relationship load","Controls the ETL from processing activity relationships.","Select any of the following values:","True (default): ETL runs will process relationship loads.","False: ETL runs will not process relationship loads.","Turn off all History, keep Slowly Changing Dimensions","Controls history tables.","Select any of the following values:","True: Turns off history tables. ","Note: Slowly changing dimensions (SCDs) will continue to be captured at the project level without the history tables.","False (default): Keeps history tables with SCDs.","Note: To delete SCD data for an effective date or a specific date range, contact Oracle Support with a service request. ","Disable Rebuild Index","Controls rebuilding of indexes in the cloud database.","Select any of the following values:","True (default): Does not rebuild indexes. Results in improved performance.","False: Rebuilds indexes","Turn off Resource and Role Limits","Controls resource and role utilization scripts. ","Select any of the following values:","True: Turn the scripts off.","False (default): Keeps the scripts running.","Enabled Spread Snapshot History","Controls the use of spread snapshot history in the advanced analytics dashboard.","Select any of the following values:","True: Enables spread snapshot history.","False (default): Disables spread snapshot history","Use project filter in data source 1","Selects filtered projects only.","Select any of the following values:","True: Ensures the next ETL run includes only projects filtered with the ETLFILTER code = &#8216;&#8217;Y&#8217;.","False (default): Does not user project filters","Include Inactive Resources","Controls resource filtration.","Select any of the following values:","True: Ensures Primavera Data Warehouse tables will not filter out inactive resources. ","Note: If inactive resources are included, then spread data and other dimension tables will also be included. You may not need to process this extra resource assignment information.","False (default): Filters out inactive resources.","Enable Slowly Changing Dimensions and Spread History","Controls the creation of slowly changing dimensions (SCDs) and spread history.","Select any of the following values:","True (default) : Capture SCDs and spread history.","False: Turn off (SCDs) and spread history. ","Load all Hierarchy Codes","Builds code hierarchies.","Select any of the following values:","True: Runs codes_hier.sql script and build code hierarchies with all codes that come from the source.","False (default): Runs codes_hier_all.sql script and build hierarchies with codes from configStar. ","ODI Log Level","Controls the level of detail included in the ODI log files.","Select any of the following values:","Summary: Displays a summarized content in the log file.","Detail (default): Displays detailed information in the log file..","Degree of Parallelism for Rebuild Index","Select the number of threads running in parallel for the rebuilding index process. ","If you plan to use ODI for projects in real-time, set the following properties to poll for changes in project data in P6 EPPM. The minimum poll interval is 5 minutes, and the maximum is 1440 minutes for all poll interval settings listed below:","ODI Realtime Global Loadplan Poll Interval (in minutes)","Enter the frequency at which changes to global data is to be checked in P6 EPPM and captured in the data warehouse.","By default the poll interval for ODI Realtime Global load plan is set to 10 minutes. ","ODI Realtime On Demand Loadplan Poll Interval (in minutes)","The ODI Realtime On Demand Loadplan Poll Interval checks for changes to projects whose Enable Publication flag is selected in P6 EPPM. This process runs when new projects are added and published to the data warehouse by triggering the ODI On Demand load plan to run for the selected projects and include it in the data warehouse.","Enter the frequency in minutes to check for changes to the Enable Publication flag for projects in P6 EPPM and send it to the data warehouse. By default the poll interval for running the On Demand ODI load plan is set to 60 minutes. ","At each check, new projects with Enable Publication flag will be added to the data warehouse, and projects whose Enable Publication flag is disabled will be deleted in the data warehouse. ","ODI Realtime Project Loadplan Poll Interval (in minutes)","The ODI Realtime Project Loadplan Poll Interval setting checks for changes in current projects in P6 EPPM. This configuration property checks those projects whose Data Warehouse Update Frequency (ODI Only) field is set as Immediate in the Project Preferences dialog box in P6 EPPM. ","Note: Immediate project updates are focused more on the specific scheduling areas of the project &#8211; costs, dates, durations.&nbsp;They are geared towards outages or scenarios where live updates are required for short length projects. Immediate project updates should be used sparingly only for a small select group of projects. Not all projects should be set to Immediate, this can have side effects on update frequency and performance. If a project is completed Immediate updates should be turned off. ","Enter the frequency in minutes to send changes directly to the data warehouse. By default the poll interval value is set to 1440 minutes (24 hours). ","In the OAS Settings section, setup the following properties:","Mail Prefix","Customize the text that will be displayed in the subject line of email notifications that are sent regarding the status of ETL runs. ","For example, enter Analytics for status updates on ETL runs in Primavera Analytics. ","P6 Base URL","Enter the URL in the following format: http://&lt;host&gt;:&lt;port&gt;/p6","OAS Cache Purge","Controls the clearance of OAS cache entries.","Select any of the following values:","True: Clears the OAS cache","False: Retains the cache entries.","Send Email Notification","Enter the e-mail IDs of the personnel to be notified regarding the status or issues with the STARETL runs.. Also select the events for which you wish to be notified: ","Failure: Email notifications sent only for failed ETL runs.","Success: Email notifications sent only for successful ETL runs.","Both: Email notifications sent for successful and failed ETL runs.","Configuration Settings for P6 EPPM Data Source","85324.htm");
Page[37]=new Array("To extract and load a subset of P6 EPPM codes: ","Sign in to Primavera Analytics Administration application:","http://&lt;host&gt;:&lt;port&gt;/p6rdb","In the sidebar, select @ Status.","In the All list, select staretl&lt;id&gt; or a &lt;custom name for data source&gt;.","In the left pane, select @ Codes.","To migrate codes for the selected P6 data source, select any of the following tabs:","Project","Activity","Notes:","A maximum of 240 codes is supported for each area (Project, Activity, and Resource).","By default, only those codes that have been enabled through the Primavera Analytics Administration application are exposed in the subject areas.","To select codes for migration:","From the Available Codes list, select one or more P6 codes.","Select  Move Right.","To deselect codes from being migrated:","From the Enabled Codes list, select one or more P6 codes you want to remove.","Select @ Move Left.","Select Save.","Configuring P6 Codes for each Data Source","88500.htm");
Page[38]=new Array("To extract and load a subset of P6 EPPM user-defined fields (UDFs):","Sign in to Primavera Analytics Administration application:","http://&lt;host&gt;:&lt;port&gt;/p6rdb","In the sidebar, select @ Status.","In the All list, select staretl&lt;id&gt; or a P6 &lt;custom name for data source&gt;.","In the left pane, select @ UDFs.","Select any of the following tabs to migrate the following UDFs to Primavera Data Warehouse for the selected data source:","Project","Activity","Resource Assignment","Resource","WBS","Select any of the following tabs to migrate a UDF type. The following UDF types are supported:","Cost","Date","Non-Cost","Number and Integer UDF types are displayed in the 'Non-Cost' folders.","Text","Indicator","For additional information on configuring Indicator UDFs, see http://blogs.oracle.com/P6Analytics/entry/indicator_type_udfs_part_2.","Notes: ","Formula-driven UDF values are not brought over during the STARETL process. The calculated UDFs can be selected as columns but the values will be null in the Primavera Data Warehouse database.","Primavera Data Warehouse has a limit of approximately 220 UDFs for each supported level (Project, WBS, Activity, Resource, and Resource Assignment) and data type (Cost limit is 220, Non-Cost limit is 220, and a combination comprising Date, Text, and Integer of 220). The limit for Indicator type UDFs for each level is 40. For example, you can select a total of 220 UDFs that includes Project Cost UDFs, WBS Cost UDFs, Activity Cost UDFs.","By default, Primavera Analytics exposes only the UDFs that have been enabled in Primavera Analytics Administration application.","To select a UDF to be migrated to Primavera Data Warehouse:","In the Available UDFs list, select a UDF from P6 EPPM.","Select  Move Right.","To deselect a UDF from being migrated:","In the Enabled UDFs list, select the UDF from P6 EPPM.","Select @ Move Left.","Select Save","Configuring P6 EPPM UDFs for each Data Source","84277.htm");
Page[39]=new Array("Primavera Data Warehouse can use two additional financial periods. To add additional financial periods, submit a Service Request to Oracle Support. ","Adding Additional Financial Periods","85334.htm");
Page[40]=new Array("For a Unifier data source, set up the configuration properties for STARETL runs and OAS settings as follows:","Sign in to the Primavera Analytics Administration Application:","http://&lt;host&gt;:&lt;port&gt;/p6rdb","In the sidebar, select @ Status.","In the Home menu, select a staretl&lt;id&gt; or a &lt;Custom Name of a data source&gt;.","In the sidebar, select @ Config.","For a Unifier data source, set the following properties and then select Save:","Configuration Property","Description","In the Configurable Settings section, setup the following properties:","Custom Name for Datasource  ","Enter a name for the data source for identification purposes. For example, Unifier Production Data.","Disable Rebuild Index ","Controls rebuilding of indexes in the cloud database.","Select any of the following values:","True: Does not rebuild indexes. Results in improved performance.","False (default): Rebuilds indexes.","Degree of Parallelism for Rebuild Index","Select the number of threads running in parallel for the rebuilding index process. ","ODI Log Level","Controls the level of detail included in the ODI log files.","Select any of the following values:","Summary: Displays a summarized content in the log file.","Detail (default): Displays detailed information in the log file..","Enable Unifier EVM ","Controls the usage of Unifier Earned Value Management data.","Select any of the following values:","True: Populates the cloud database with EVM data.","False (default): Does not populate the cloud database with EVM data. Results in improved performance.","Store Unifier History","Controls Unifier history tables.","Select any of the following values:","True (default): Keeps the history tables running.","False: Disables all history tables.","If Store Unifier History is set to True, you can set the history levels for the following:","Use P6 project Name for Unifier Project","Controls the source that will be used for naming a Unifier project.","Select any of the following values:","True: if the Unifierproject ID is identical in P6 and Unifier, then the project name from P6 will be used for the Unifier project.","False: Uses the project name from Unifier.","Unifier BP Data History Level ","Controls BP history level.","Select the frequency of BP history tables as Week or Month to capture the history of BP dimensions.","Note: History Level is applicable only for history fact tables like W_BP_HIST_F and W_BP_LINE_HIST_F. ","Unifier Level Data History Level ","Controls level history (FMRE).","Select the frequency of BP history tables as Week or Month.","Unifier Cash Flow and Cost Sheet Data History Level","Controls the cash flow history and cost sheet history tables. ","Select the frequency of history tables as Week or Month.","Unifier Space Data History Level","Controls space history tables. Set this value to Month.","Enable Unifier Slowly Changing Dimensions ","Controls the capability to see how business process has changed over time. A business process history can then be generated weekly or monthly. When you select Refresh All, it overwrites all previous history and only the latest history data is made available. Use this setting for Project / Shell, BP and BP Line Items and BP UDFs to generate reports based on historical data.","Select any of the following values:","True: Captures history for all projects and business processes. This includes non-dynamic Business process related dimensional data, and dynamic dimensional data for Business process (UDFs) metadata.","False: Disables business process history ","Unifier Project Shell History Level  ","Controls project shell history levels. Select the frequency of BP history tables as Week or Month.","In the OAS Settings section, setup the following properties:","Mail Prefix","Customize the text that will be displayed in the subject line of email notifications that are sent regarding the status of ETL runs. ","For example, enter Analytics for status updates on ETL runs in Primavera Analytics. ","Unifier Base URL","Enter the URL in the following format: http://&lt;host&gt;:&lt;port&gt;/bluedoor","OAS Cache Purge","Controls the clearance of OAS cache entries.","Select any of the following values:","True: Clears OAS cache entries.","False: Retains the cache entries.","Send Email Notification On","Enter the e-mail IDs of the personnel to be notified regarding the status or issues with the STARETL runs.. Also select the type of  events for which they are to be notified:","Failure: Email notifications sent only for failed ETL runs.","Success: Email notifications sent only for successful ETL runs.","Both: Email notifications sent for successful and failed ETL runs.","Configuration Settings for Unifier Data Source","85325.htm");
Page[41]=new Array("For a Primavera Cloud data source, set up the configuration properties for STARETL runs and OAS settings as follows:","Sign in to the Primavera Analytics Administration Application:","http://&lt;host&gt;:&lt;port&gt;/p6rdb","In the sidebar, select @ Status.","In the Home menu, select a staretl&lt;id&gt; or a &lt;Custom Name of a data source&gt;.","In the sidebar, select @ Config.","For a Primavera Cloud data source, set the following properties and then select Save:","Configuration Property","Description","In the Configurable Settings section, setup the following properties:","Custom Name for Datasource","Enter a name for the data source for identification purposes. For example, Primavera Cloud Production Data.","ODI Log Level","Controls the level of detail included in the ODI log files.","Select any of the following values:","Summary (default): Displays a summarized content in the log file.","Detail: Displays detailed information in the log file..","Spread Page Size","Enter the maximum number of assignments to be calculated for spread data. It controls the data volume the server handles in one request batch.","Primavera Cloud URL","Enter the Primavera Cloud URL in the format: https://&lt;tenant_ID&gt;/web","Enable Loading Primavera Cloud Codes","Controls the ability to load Codes. ","Select any of the following values:","True: Loads codes.","False (default): Does not load codes.","Enable Loading Primavera Cloud UDFs","Controls the ability to load user defined fields (UDFs. ","Select any of the following values:","True: Loads UDFs.","False (default): Does not load UDFs.","In the OAS Settings section, setup the following property:","Mail Prefix","Customize the text that will be displayed in the subject line of email notifications that are sent regarding the status of ETL runs.","For example, enter Analytics for status updates on ETL runs in Primavera Analytics.","OAS Cache Purge","Controls the clearance of OAS cache entries.","Select any of the following values:","True: Clears OAS cache entries.","False: Retains the cache entries.","Send Email Notification","Enter the e-mail IDs of the personnel to be notified regarding the status or issues with the STARETL runs. Also select the events for which you wish to be notified:","Failure: Email notifications sent only for failed ETL runs.","Success: Email notifications sent only for successful ETL runs.","Both: Email notifications sent for successful and failed ETL runs.","Configuration Settings for Primavera Cloud Data Source","85331.htm");
Page[42]=new Array("To extract and load a subset of Primavera Cloud codes:","Sign in to Primavera Analytics Administration application:","http://&lt;host&gt;:&lt;port&gt;/p6rdb","In the sidebar, select @ Status.","In the All list, select staretl&lt;id&gt; or a &lt;custom name for data source&gt;.","In the left pane, select @ Codes.","To migrate codes for the selected data source, select any of the following tabs:","Project","Activity","Notes:","	A maximum of 300 codes is supported for each area (Project, Activity).","By default, only those codes that have been enabled through the Primavera Analytics Administration application are exposed.","To select a code for migration: ","From the Available Codes list, select a Primavera Cloud code you want to enable.","Select  Move Right.","To deselect a code from being migrated:","From the Enabled Codes list, select a Primavera Cloud code you want to remove.","Select @ Move Left.","Select Save.","Configuring Primavera Cloud Codes for Each Data Source","88493.htm");
Page[43]=new Array("To extract and load a subset of Primavera Cloud user-defined fields (UDFs):","Sign in to Analytics Administration application:","http://&lt;host&gt;:&lt;port&gt;/p6rdb","In the sidebar, select @ Status.","In the All list, select staretl&lt;id&gt; or a &lt;custom name for data source&gt;.","In the left pane, select @ UDFs.","Select any of the following tabs to migrate the corresponding UDFs for the selected data source:","Activity","Project","Select any of the following sub-tabs to migrate a UDF type:","Cost","Date","Non-Cost: Number and Integer UDF types are displayed in the 'Non-Cost' folders.","Text","Notes:","A maximum of 200 UDFs is supported for each area (Project, Activity) and data type.","By default,  only those UDFs that have been enabled through Primavera Analytics Administration application are exposed.","To select a UDF to be migrated:","In the Available UDFs list, select a Primavera Cloud UDF you want to enable.","Select  Move Right.","To deselect a UDF from being migrated:","In the Enabled UDFs list, select the UDF you want to remove.","Select @ Move Left.","Select Save Changes.","Configuring Primavera Cloud UDFs for Each Data Source","88494.htm");
Page[44]=new Array("This section describes how to accomplish the following tasks:","Using Primavera Analytics Administration Application","85328.htm");
Page[45]=new Array("The Primavera Analytics Web Administration Application contains a staretl section for each data source.","To run the STARETL process for a data source:","Sign in to the Primavera Analytics Web Administration Application. ","http://&lt;host&gt;:&lt;port&gt;/p6rdb ","In the sidebar, select @ Status.","From the @ Home @ menu, select a staretl&lt;id&gt; or a &lt;Custom Name for DataSource&gt;.","Note: &lt;id&gt; is the identifier of the data source.","From the Actions menu, select Run ETL to run a STARETL process immediately. ","Running the STARETL Process","83829.htm");
Page[46]=new Array("To stop the STARETL process run for a data source:","Sign in to Primavera Analytics Web Administration Application.","http://&lt;host&gt;:&lt;port&gt;/p6rdb","In the sidebar, select @ Status.","Select Stop for a currently running STARETL process.","View the log file, YYYYMMDDProcessID_failed.log created in the folder, &lt;PDW Install Folder&gt;\\star\\etl_homes\\STARETL&lt;id&gt;\\log.","Stopping the STARETL Process","84420.htm");
Page[47]=new Array("The option to run an initial load is displayed only for the first time a data source is made available in Analytics. If an initial load run fails, this option will be available until the initial load is successfully completed.","Notes: When an initial load is in process:","You cannot run an initial load of another data source simultaneously.","You cannot run an ETL process for another data source when an initial load run is in process. The ETL process will be in queue for a run. ","To run an initial load for a new data source:","Sign in to the Primavera Analytics Web Administration Application. ","http://&lt;host&gt;:&lt;port&gt;/p6rdb ","In the sidebar, select @ Status.","From the @ Home @ menu, select a staretl&lt;id&gt; or a &lt;Custom Name for DataSource&gt;.","Note: &lt;id&gt; is the identifier of the data source.","Click Run Initial Load.","Upon successful completion, proceed to run an ETL. See Running the STARETL Process.","Running Initial Loads","88863.htm");
Page[48]=new Array("To schedule a STARETL process run for a data source:","Sign in to the Primavera Analytics Web Administration Application. ","http://&lt;host&gt;:&lt;port&gt;/p6rdb ","In the sidebar, select @ Status.","From the @ Home @ menu, select a staretl&lt;id&gt; or a &lt;Custom Name for DataSource&gt;.","Note: &lt;id&gt; is the identifier of the data source.","Use any of the following menu options to schedule an ETL run: ","From the Actions menu, select Schedule Etl or","In the Recently Running ETLs section, select the @ Row Actions menu for a Custom Name or StarETL ID, and then select Schedule Etl.","In the Schedule Frequency field, select the frequency for the STARETL process run.","If you select None, no STARETL process run will be scheduled for a data source.","If you select Daily: ","In the Run ETL at field, enter the time for the daily process run, and select Save.","To schedule multiple ETL schedules daily, select Add and enter date and time for the ETL run.","Note: Schedule multiple ETLs daily at least 2 hours apart.","If you select Weekly:","In the Run ETL at field, enter the time for the process run.","Select the days for the STARETL process run, and select Save.","Scheduling STARETL Process Runs","83423.htm");
Page[49]=new Array("The Global Status page displays the ETL status of STARETL runs for all data sources, across multiple products. ","To access the Global Status page and view details of all STARETL runs:","Sign in to Primavera Analytics Administration Web Application.","http://&lt;host&gt;:&lt;port&gt;/p6rdb","In the sidebar, select @ Status.","The following information is displayed for each STARETL process:","Custom Name: The custom name given to a data source.","ETL Name: The identifier for the data source for the STARETL process.","ETL ID: The unique identifier for the STARETL process run.","ETL Start Date: The start date and time for the STARETL process run based on the server time.","ETL End Date: The end date and time for the STARETL process run based on the server time.","Status: The status of the STARETL process run. These include:","OK: The STARETL process completed successfully.","Running: The STARETL process is currently running.","Failed: The STARETL process has failed. View the log for more information about the failure.","Log: The link to the ETL log of the selected STARETL run.","Reviewing the Global Status of STARETL Runs","84274.htm");
Page[50]=new Array("Publication services are responsible for ensuring that the data is up-to-date prior to running the STARETL process. Publication services are available for:","P6","Unifier","To view the status of recent publication runs for the relevant product: ","Sign in to the Primavera Analytics Web Administration Application.","http://&lt;host&gt;:&lt;port&gt;/p6rdb","From the @ Home @menu, select a staretl&lt;id&gt; or a &lt;Custom Name for DataSource&gt;.","Note: &lt;id&gt; is the identifier of the data source.","In the sidebar, select @ Status.","From the Status page, select @ Publication Status in the sidebar.","On the Publication Status page, the following information for each publication service run:","For P6 Publication Services:","Job ID: A unique identifier for the publication service.","Job Type: The category of the publication service to which it belongs.","Job Name: The name of the publication service.","Recur Type: The recurrence of the publication service. The following values may display:","RT_WebEnabled: Indicates that the job is a recurring job and is scheduled","RT_RecurDisabled: Indicates that the job is a scheduled recurring job, but is currently disabled","RT_WebASAP: Indicates that the job is a one-time job, and must be run at the earliest","Status Code: The status of the publication service. The following values may display: ","Cancelled,: The publication service has been canceled.","CompError,: The publication service has been completed with errors.","Completed: The publication service has been completed.","Delegated: The publication service is waiting to complete child jobs.","Failed: The publication service has failed to complete.","Pending: The publication service is in the queue waiting to be run.","Running: The publication service is currently in process.","Last Run Date: The most recent date on which the publication service was run.","For Unifier Publication Services:","Job ID: A unique identifier for the publication service.","Start Date: The date on which the publication service was run.","Status: The status of the publication service. The following values display:","Canceled: The publication service has been canceled.","Failed: The publication service has failed to complete.","Finished: The publication service has been completed.","Not Started: The publication service is in the queue.","Running: The publication service is currently in process.","End Date: The date on which the publication service ended.","Refresh All Data: Indicator that displays if all data was refreshed before running the publication service. The following values can display: True, False. ","Type: The type of publication service. The following values can display:","On Demand: Indicates the job was set up manually.","Scheduled: Indicates the job was automatically started based on a scheduled date and time.","Submit Date: The date on which the publication service was submitted for a run.","Select Refresh to update the publication services run list as needed.","Reviewing the Status of Publication Service Runs","85549.htm");
Page[51]=new Array("To manage and run ODI load plans:","Sign in to the Primavera Analytics Administration Web Application.","http://&lt;host&gt;:&lt;port&gt;/p6rdb","From the @ Home @ menu, select a staretl&lt;id&gt; or a &lt;Custom Name of a data source&gt;.","In the Load Plan Status section of the Status page, select any of the following buttons: ","Select Start to run a specific ODI load plan.","Select Restart for a currently ongoing run.","Note: In the sidebar, select @ Config and set the ODI LoadPlan Auto Restart property to True to auto-restart for a maximum count of 3 if an initial run fails.","Starting and Restarting ODI Load Plans","85289.htm");
Page[52]=new Array("Every time you run the STARETL process, Primavera Data Warehouse&nbsp;creates extensive log files that provide information about the installation and daily operations details of each step of the process. Inspect the log files after each run of the STARETL process to determine if any issues exist.","To access the log files of ETL runs:","Sign in to Primavera Analytics Administration Application:","http://&lt;host&gt;:&lt;port&gt;/p6rdb","From the@ Home @ menu, select a staretl&lt;id&gt; or a &lt;Custom Name of a data source&gt;.","In the sidebar, select @ Status.","In the Recently Running ETLs section, select the View Log link to access the log files created for each STARETL run.","The following information is displayed in a log file:","&lt;yyyymmdd&gt;ProcessId.log: Contains the details of the SQL commands run to perform the database refresh updates.","&lt;yyyymmdd&gt;ProcessId.html: Contains results of the processes run to create the users, tables, and transfer of data. Provides the time it took for each step to run. This log is derived from the ETL_PROCESSMASTER, ETL_PROCESSINFO, and ETL_PROCESSEXCEPTION tables.","&lt;yyyymmdd&gt;: The date of the STARETL process run.","Accessing Log Files","83450.htm");
Page[53]=new Array("To access the log of a specific STARETL run of a data source:","Sign in to Primavera Analytics Administration Web Application.","http://&lt;host&gt;:&lt;port&gt;/p6rdb","In the sidebar, select @ Status.","From the Global Status menu select staretl&lt;id&gt; or &lt;Custom Name for data source&gt;.","In the Load Plan Status section, review the following information for recent load plans: ","Name: Name of the load plan associated with the data source","Status: Current status of the load plan.","Last Successful Time: Date and time that the load plan completed successfully.","Last Failed Time: Date and time that the load plan failed..","Number of Retries: Number of attempts made to rerun the load plan.","View Log: Link to the log file of the load plan.","In the Recently Running ETLs section,  review the following information for recent STARETL runs:","ETL Name: Identifier for the data source associated with the STARETL run.","ETL ID: Unique identifier for the STARETL run.","ETL Start Date: Start date and time for the STARETL run based on the server time.","ETL End Date: End date and time for the STARETL run based on the server time.","Status: Status of the STARETL run. These include:","OK: The STARETL run completed successfully.","Running: The STARETL runis currently running.","Failed: The STARETL run failed. View the log for more information about the failure.","Log: Links to the log file of the STARETL run.","Select any of the following buttons to complete the relevant task: ","Select Refresh to view an updated list of STARETL runs and ODI load plans","Select Restart if you want to restart a load plan.","Select Load Security if you want o add new P6 users without running an ETL. ","Accessing Recent STARETL and Load Plan Logs","84275.htm");
Page[54]=new Array("Primavera Analytics relies on data from P6 EPPM as a data source. Before using Primavera Analytics, configure and run P6 EPPM Publication Services to ensure current data is ready to be extracted, transformed, and loaded (ETL) into the data warehouse. ","This chapter describes how to set up P6 EPPM for Primavera Analytics.","Configuring P6 EPPM for Primavera Analytics","83397.htm");
Page[55]=new Array("If you are using P6 EPPM as a data source, Primavera Analytics relies on data from the P6 EPPM Extended Schema and related publication services. Configure the P6 EPPM publication services and run them successfully prior to running a STARETL process. The publication services are responsible for moving and transforming P6 EPPM data into the P6 EPPM Extended Schema.","There are two types of publication services within P6 EPPM that need to be run in order to ensure that the data in the P6 EPPM Extended Schema is up-to-date prior to running the STARETL process.","Global Scheduled Services: Global services are responsible for moving global/enterprise level data (Users, Security, Codes, Hierarchies, and so on) from the P6 EPPM base tables into the Extended Schema. Due to the possibility that this type of global data does not change frequently, Global Services can be configured to run at regularly scheduled intervals. Global scheduled services include the following:","Publish Enterprise Data Service calculates and publishes enterprise-level business objects containing calculated and denormalized fields, including cost accounts, currencies, calendars, codes, funding sources, resource teams, role teams, timesheet dates, UDFs and more.","Publish Enterprise Summaries Service calculates and publishes EPS-level spread data for currently published projects in a given EPS.","Publish Resource Management Service calculates and publishes the resource hierarchy, resources, resource rates, resource limits, role rates, resource role assignments, and resource security.","Publish Security Service publishes users, the OBS, and security profiles and calculates security for the P6 Extended Schema.","Project Level Service: This service updates data in the P6 EPPM Extended Schema for each project. This service can be configured to run at specific time intervals or based on a number of changes interval. This service processes projects in a queue type fashion.","See the P6 Help for details on Publication Services.","To configure and run Publication Services in P6 EPPM, complete the following steps:","Sign in to P6 EPPM as an administrator user.","From the Administration @ menu, select Application Settings.","In the Application Settings pane, click Services.","On the Services page, in the Publication section, use the following fields to set the amount and frequency of data updates in the P6 EPPM Extended Schema. For the Primavera Data Warehouse, set the following:","Start Date: Enter the start date for all time-distributed data published.","Finish date is current date plus: Enter the rolling end date for all time-distributed data published. ","Time distributed interval: Enter the spread data bucket types (day or week).","Select the Enable Publish Projects option and adjust the remaining options in this section as needed for your data.","The projects that qualify for publication publish to the P6 EPPM Extended Schema.","Note: To verify the status of each project publication job in P6, select Projects, EPS, Actions, View Service Status.","When publication is complete, run P6 EPPM Global Scheduled Services:","From the Administration @ menu, select Global Scheduled Services.","In the following order, set the following global services to run immediately by right-clicking the service name and selecting Run Service.","Publish Enterprise Data","Publish Resource Management","Publish Security","Publish Enterprise Summaries","Note: After configuring and running publication services, configure Global Scheduled Services to run at regular intervals to work in conjunction with any changes to the P6 EPPM data.","Configuring and Running P6 EPPM Publication Services","83398.htm");
Page[56]=new Array("P6 EPPM provides the ability choose the level (Project, WBS, Activity) and interval (Yearly, Quarterly, Monthly, Daily) of history data to be captured and stored in the data warehouse. The activity level includes Daily, Weekly, and Monthly options. In P6, you can define history level and interval settings on a per project basis. Use P6 to configure the type of data stored in Primavera Analytics and in what time interval.","To configure history settings:","Sign in to P6.","Note: A user must have the Edit Project Details Except Cost/Financials profile to edit the history settings.","Click Projects.","On the Projects navigation bar, click EPS.","On the EPS page:","Select a project.","From the Actions @ menu, select @ Set Project Preferences.","In the Project Preferences pane, click Analytics.","On the Analytics page:","Select the History Level and History Interval settings.","You can choose one of the following for History Level:","None (the default)","Project","WBS","Activity (Daily)","Activity (Weekly)","Activity (Monthly)","You can choose one of the following for History Interval:","Month (the default)","Week","Quarter","Year","Financial Period","Click Save to continue working or click Save and Close if you are finished.","Note: If you select Activity (Daily) or Activity (Weekly) or Activity (Monthly) as the History Level, this will automatically set the History Interval for Activity and Resource Assignment history to the corresponding activity time interval. Use caution when selecting which projects you choose to have daily history captures as this can affect the amount of time and the volume of data processed when running the ETL process. You still need to set the history interval level when selecting Activity level history, which will apply to project and WBS-level history only.","Run the publication services to publish the changes you made. ","Creating History Data for P6 EPPM","81815.htm");
Page[57]=new Array("To capture history data in P6 projects and enable predictions in Analytics, it is necessary to enable Slowly changing dimensions (also known as Type 2 dimensions) to preserve an attribute's history of values by capturing non-fact or dimensional data and associating that data with the correct version of the fact row. Captured data includes project, resource, activity, resource assignment dimensional data, and more. Slowly changing dimensions are used when is it important to preserve the historic context of facts.","When source data elements change or when the STARETL process is run, a new row is added to the dimension table and the previous row is left unchanged. Previously recorded facts remain associated with the old dimension row and new facts are associated with the new dimension row. These rows show the changes to an attribute over time. For example, if the Planned Start Date for an activity has changed between the current capture and the previous capture, the old and new date would both be recorded in the dimension table.","Dimension rows in the dimension table are distinguished by the Effective Start Date, Effective End Date, and Current Flag. The date and time the STARETL process starts becomes the Effective Start Date for the new dimension row. The new version of a dimension Effective End Date defaults to 01-Jan-3000 00:00:00. When the STARETL process is run again, the Effective End Date for the latest version of the attribute then becomes the Effective Start Date for the current version minus one second. ","For example, if the Effective Start Date for the current version of the attribute is 04-Nov-2019 9:12:28 PM, then the Effective End Date for the previous version becomes 04-Nov-2019 9:12:27 PM. The most recent dimension row in the dimension table has a value of &quot;1&quot; in the Current Flag column. All other rows have &quot;0&quot; in the Current Flag column.","Dimension Table","Daily snapshot fact tables enable the daily capture of metrics at the Resource Assignment and Activity Levels. Daily snapshot fact tables are used in conjunction with slowly changing dimensions. For example, when the Activity History daily snapshot is recorded, new fact rows will be updated with the most current version of each record in the activity dimension. Previously recorded facts remain associated with the old dimension row version.","The daily snapshot makes it easy to determine what metrics such as Remaining Units looked like at any point in time across all projects that have been opted into this level of data capture.","Using Slowly Changing Dimensions and Daily Snapshot Fact Tables for P6 EPPM Data","83500.htm");
Page[58]=new Array("To enable SCDs and daily history snapshots for a P6 project:","Sign in to P6 EPPM. ","http://&lt;host&gt;:&lt;port&gt;/p6/action/login","In P6, click Projects.","On the Projects screen navigation bar, click EPS.","On the EPS page:","Select a project.","From the @ Row Actions menu of the selected project, select Set Project Preferences.","In the Project Preferences pane:","Ensure the project is configured for publication services.","Click the Analytics &amp; Services tab.","Select the Enable Publication option in the Publication section.","Configure the project's History Level setting.","Click the Analytics &amp; Services tab.","From the History Level list, select Activity (Daily), Activity (Weekly) or Activity (Monthly).","Note: You should still configure the History Interval setting, but it will only apply to Project and WBS-level history metrics.","Click Save and Close.","Enabling Daily History Snapshots and Slowly Changing Dimensions","82094.htm");
Page[59]=new Array("If you turn off the slowly changing dimensions (SCDs) for a field, the current dimensional row can be updated with a new value without the addition of a new dimensional row.","Slowly changing dimensions can be controlled on a field-by-field level. If slowly changing dimensions are turned on, a change will cause a new row to be added. If slowly changing dimensions is turned off, a new row will not be added if a change is made to that field. For example, if the Activity Description field has slowly changing dimensions turned on, then changes made to this field will cause a new row to be added to the dimensional table the next time the STARETL process is run. If the EPS Name field has slowly changing dimensions turned off, then the STARETL process will not update the dimensional table with a new row. Have these settings configured for each field can prevent cascading updates to fact tables. For example, if a change is made to the EPS table, that change would cause a new row to be added to the dimension table for all of the activities affected by the change.","Submit a Service Request on My Oracle Support if you want to:","Enable or disable slowly changing dimensions for a field or","Delete SCD data for an effective date or a specific date range","Turning Off Slowly Changing Dimensions","83501.htm");
Page[60]=new Array("Primavera Analytics contain an additional way that data can be analyzed outside of the standard P6 EPPM methods. Primavera Analytics includes additional tables and configuration for Burn Down. ","Burn Down is a set of calculations that display how a project will progress if everything goes &quot;according to plan&quot;. Primavera Analytics includes metrics and Key Performance Indicators (KPIs) for both the current project data, as well as any point in the past for which the data was captured. These metrics and KPIs include both current and historical activity counts, units, and costs. Primavera Analytics has the ability to track and monitor how the current schedule is executing in relationship to how it was supposed to progress at the start of the project (T0). This includes, but is not limited to, any new activities that were added to the current project that did not exist at the start of the project (emergent), activities that have been removed in the current schedule that existed in the point in time capture of the project (deleted), and activities whose start or finish has changed since the point in time capture of the project.","Use the following sections to learn more about the additional functionality, how to set it up in P6 EPPM, and how to work with the data in Primavera Analytics.","Note: Oracle provides several white papers that detail aspects of Burn Down:","Burn Down Detail Data Flow: http://www.oracle.com/webfolder/technetwork/tutorials/primavera/OnlineLearning/WhitePapers/BurnDown_Details_DataFlow.pdf","Burn Down Units Details: http://www.oracle.com/webfolder/technetwork/tutorials/primavera/OnlineLearning/WhitePapers/BurnDown_Details_Units.pdf","Burn Down Counts Details: http://www.oracle.com/webfolder/technetwork/tutorials/primavera/OnlineLearning/WhitePapers/BurnDown_Details_Counts.pdf","Using Burn Down for P6 EPPM Data","83502.htm");
Page[61]=new Array("Only P6 EPPM projects can be manually included to take advantage of the Oracle Primavera Burn Down tables and functionality. This section describes how to create and configure the necessary P6 EPPM project level user-defined fields (UDFs) that the STARETL process needs to include project(s) in Burn Down. ","To create the project UDFs, complete the following steps:","Sign in to P6 EPPM with a user account that has the privilege to change enterprise data (for example, admin).","From the Administer @ menu and select Enterprise Data.","On the Enterprise Data page, expand Projects and select Project UDFs.","On the Project UDFs page:","Add a sys_workdown UDF with a data type of Text.","Add a sys_workdown_date UDF with a data type of Start Date.","Creating Project UDFs for Burn Down Subject Areas","83503.htm");
Page[62]=new Array("For a project to be included in the Burn Down tables and subject area, you must configure specific project UDF and History Level settings in P6.","To select which P6 EPPM project will be included in Burn Down tables and metrics, complete the following steps:","Sign in to P6 EPPM.","In P6, click Projects.","On the Projects navigation bar, click EPS.","On the EPS page:","Select a project.","From the Actions @ menu, select @ Set Project Preferences.","In the Project Preferences pane, click Analytics.","On the Analytics page, click the History Level list, and then select Activity.","In the Project Preferences dialog box, click Save and Close.","On the Projects navigation bar, click EPS.","On the EPS page, add the sys_workdown and sys_workdown_date UDF columns to the page.","For the projects you want to add to the Burn Down subject area:","Enter project in the sys_workdown column.","Enter a date value (for example, 09/30/2015) in the sys_workdown_date column. This value is used as the snapshot date for comparison to actual project values. If no value is entered here, the Project Start Date is used.","Note: The date used for the initial Burn Down data capture is one day before the date entered for this UDF. For example, if the sys_workdown_date is 03/31/2016, then the STARETL process uses 03/30/2016 for the Burn Down comparison.","Selecting the Project for the Burn Down Subject Area","83505.htm");
Page[63]=new Array("After adding P6 EPPM projects for inclusion in the Burn Down and/or Work Planning subject areas, it is important that the date/time period specified in P6 EPPM under Administer, Application Settings, Services in the Publication Period section is later than the latest project finish for ALL project(s) that will be included for Burn Down and/or Work Planning. For example, in P6 EPPM Publication Services settings, if you specify a start date of October 1, 2015 and the finish date is current date plus setting is two years, the finish date for all of the Burn Down/Work Planning project(s) must have a finish date before September 30, 2017. If a project extends past the finish date setting in the publication services settings, the Burn Down/Work Planning portion of the STARETL process generates an error.","Note: Setting a finish date range that is too long will affect the STARETL process run time. Each day the publication services are run, the finish date range also extends by one day.","Burn Down and Work Planning with the STARETL Process","83506.htm");
Page[64]=new Array("A project can have activities scheduled and completed before a burn down begins. This gives users the flexibility to begin the project burn down on the date specified in the sys_workdown_date UDF rather than the Project Start Date.","In a Burn Down project, the initial snapshot of the project's activities and assignments is taken the day before the date entered in the sys_workdown_date UDF. This snapshot is used as a baseline to compare against actual values. For example, the Baseline Remaining Units Burned can be compared to the Remaining Units Burned. The STARETL process must be run one day before the sys_workdown_date (or the Project Start Date if this UDF is not used) to capture this initial snapshot.","Scheduling a Burn Down Project","82096.htm");
Page[65]=new Array("When using Burn Down Metrics, you must update the schedule and run the STARETL process. Each daily STARETL process updates two sets of daily metrics:","Metrics for &#8216;Today&#8217;: All work completed today through the latest schedule update and data date change is recorded as work completed for the current date when the STARETL process occurs.","Metrics for &#8216;Yesterday&#8217;: Since the data from yesterday is only current through the latest schedule update and data date change, any additional work completed yesterday but AFTER the update is now added to the daily metrics for &#8216;yesterday&#8217;. ","For example, a project is updated at 6pm daily and then the STARETL process is run. The next day, these become metrics for &#8216;yesterday&#8217; and initially reflect work only through 6pm yesterday. When the STARETL process is run today, any additional work completed between 6pm and midnight is now included under the metrics for &#8216;yesterday&#8217;.","About the STARETL Process and Burn Down Metrics","82177.htm");
Page[66]=new Array("To capture daily trending information, complete the following steps each day to calculate the metrics in the Burn Down subject area:","Update the status of activities in the projects you configured in P6 to be included in the Burn Down subject area. For example, update the Actual and Remaining Units and which activities are completed.","Adjust the data date to correspond to the latest status update.","Run the STARETL process.","Note: The STARETL run must occur within each calendar date to properly capture daily metrics.","Calculating Metrics in the Burn Down Subject Area","82098.htm");
Page[67]=new Array("Primavera Analytics supports Work Planning for P6 EPPM data. Work Planning is a method of tracking how work is progressing based on a set of user-determined points in time. Similar to Burn Down, Work Planning also uses project-level user-defined fields (UDFs) to select the P6 EPPM projects included in the Work Planning calculations and metrics and also the point in time you want to use for the comparison.","Using Work Planning for P6 EPPM Data","83507.htm");
Page[68]=new Array("You can manually include P6 EPPM projects to take advantage of the Work Planning tables and functionality. ","You must create and configure the necessary P6 EPPM project-level user-defined fields (UDFs) that the STARETL process needs to include projects in Work Planning. To do this, complete the following steps:","Sign in to P6 EPPM.","From the Administration @ menu, select Enterprise Data.","On the Enterprise Data page, expand Projects and select Project UDFs.","On the Project UDFs page:","Add a sys_workprocess UDF with a data type of Text.","Add a sys_scope_freeze UDF with a data type of Text.","Add a sys_schedule_freeze UDF with a data type of Text.","Creating Project UDFs for Work Planning Subject Areas","82099.htm");
Page[69]=new Array("The Work Planning subject area is designed for ongoing project work typical of routine and online maintenance projects. In these projects, planning metrics are tracked week over week and workweek metrics are tracked daily. There are specific Project UDF and History Level settings required in P6 to include a project in the Work Planning subject area.","Complete the following steps to select the P6 EPPM projects for the work planning subject area:","Sign in to P6 EPPM.","In P6, click Projects.","On the Projects navigation bar, click EPS.","On the EPS page:","Select a project.","From the Actions @ menu, select @ Set Project Preferences.","In the Project Preferences dialog box:","Ensure the project is configured for publication services.","In the Project Preferences pane, click Services.","On the Services page, in the Publication pane, select the Enable Publication option.","Configure the project's History Level setting.","In the Project Preferences pane, click Analytics.","On the Analytics page, in the History Level list, select Activity.","Click Save and Close.","On the Projects navigation bar, click EPS.","On the EPS page, add the sys_workprocess, sys_scope_freeze, and sys_schedule_freeze UDF columns to the page.","For the projects you want to add to the Work Planning subject area:","Enter workweek in the sys_workprocess column.","Note: Use the format T-&lt;x&gt;w (where &lt;x&gt; equals the number of weeks prior to scope freeze and schedule freeze) must be followed exactly when entering the sys_scope_freeze and sys_schedule_freeze UDF values.","Enter a value in the sys_scope_freeze column. This is a relative value for each week in a project's schedule. For example, if you enter T-2w, scope freeze for each week in a project is calculated as two weeks prior to the Planned Start Date of that week. Scope freeze metrics, such as Scope Freeze New or Scope Freeze Lost, are captured for each week in a project schedule from each week's calculated scope freeze date up to and including its completion.","Enter a value in the sys_schedule_freeze column. This is a relative value for each week in a project's schedule. For example, if you enter T-1w, schedule freeze for each week in a project is calculated as one week prior to the Planned Start Date of that week. Schedule freeze metrics, such as Schedule Freeze New or Schedule Freeze Lost, are captured for each week in a project schedule from each week's calculated schedule freeze date up to and including its completion.","Selecting a Project for the Work Planning Subject Area","82345.htm");
Page[70]=new Array("Scope freeze, schedule freeze, and actual metrics are captured for each week of planned work in a project that has been opted into the Work Planning subject area. Each individual week in the schedule will have these metrics captured leading up to that week&#8217;s execution, allowing users to monitor their planning performance on a weekly basis for an upcoming week of work.","The sys_scope_freeze and sys_schedule_freeze UDFs control the amount of history or the number of weeks these metrics capture for each individual week leading up to the execution week.","The diagram below illustrates how the ETL process would capture Work Planning metrics for the week 12/17/2012 to 12/23/2012 given the following P6 settings:","The sys_scope_freeze equals T-2w","The sys_schedule_freeze equals T-1w","The Starting Day of Week equals Monday (this is set in the P6 Application Settings)","In this scenario, the Scope Freeze for the week starting on Monday 12/17/2012 occurs two weeks prior (T-2w) to that week&#8217;s planned start date. Schedule Freeze occurs one week prior (T-1w) to that week&#8217;s planned start date. Daily Actual Start and Finish metrics are captured throughout the week.","Once the STARETL process has run on these respective freeze dates, any changes in the schedule for an upcoming week (such as adds, deletes, or planned date changes) are recorded the next time the STARETL process runs.","Scheduling a Work Planning Project","82100.htm");
Page[71]=new Array("Graded approach to schedule adherence is a method for tracking adherence using four distinct levels of work scheduling (A, B, C, and D). ","The levels of work scheduling are:","A (Hourly): Used when you require the most control, adherence, and management oversight. Reasons include risk (probability safety analysis/risk assessment), personnel safety, or other significant concerns. Users must finish Level A activities within one hour of the target planned finish date.","B (Daily): Used for work requiring multi-discipline coordination, significant tagouts, or risk significant work. Users must finish Level B activities on the same day as the target planned finish date.","C (Weekly): Used for non-risk significant and routine work that does not require support from other work groups. Users must finish Level C activities within the week of the target planned finish date.","D (No Tracking): Used for housekeeping, shop work, and other types of work that have no impact to the plant. Level D activities are considered &#8220;fill-in&quot; work and are not tracked for schedule adherence.","For graded schedule adherence, ensure history exists for the project as of the scheduled freeze date and T-0 baseline date for the week the STARETL process will run.","During T-0 for a given week when you run the STARETL process, the Baseline Planned Finish Date (as of T-0) and the Schedule Freeze Planned Finish Date (as of schedule freeze UDF) for the activities will be captured. You can use these dates along with the assigned adherence grade to calculate the graded schedule adherence in CIC Analytics.","Using Graded Approach for Schedule Adherence","82199.htm");
Page[72]=new Array("Primavera Analytics relies on data from Primavera Unifier. Before using Primavera Analytics, configure and run Primavera Unifier Publication Services to ensure Unifier current data is ready to be extracted, transformed, and loaded (ETL) into the data warehouse.","This chapter describes how to set up Primavera Unifier for Primavera Analytics cloud.","Configuring Primavera Unifier for Primavera Analytics","88517.htm");
Page[73]=new Array("When Primavera Unifier is used as a data source, Primavera Data Warehouse relies on data from the staging tables and related publication services of Unifier. Before running the STARETL process, you must configure and run publication services to allow users to control what data to calculate and store and how often the data is updated. For detailed instructions, see Publishing Unifier Data to Analytics in the Primavera Unifier Administration Guide.","To configure publication services in Primavera Unifier, complete the following steps:","Sign in to Primavera Unifier with an account that has admin privileges (ootbadmin).","Go to the Company workspace.","Change the mode from user mode to admin mode.","Open the Analytics module.","From the toolbar, click the Schedule icon @.","In the Schedule Setup pane, set the data update frequency.","If you have made any changes to the data definition or the data mapping fields, select the Refresh all data check box.","Notes: ","If you choose to refresh all data, you may want to deselect the Refresh all data check box after the run is complete.","If you exceed the data limit of previous releases, submit a Service Request to My Oracle Support to increase the business process data element counts.","Click OK.","Configuring and Running Primavera Unifier Publication Services","83399.htm");
Page[74]=new Array("Primavera Unifier also provides the ability to capture and store history data. Data can be captured at either the Monthly or Weekly intervals, (with the exception of Space history which is monthly only). No additional settings are required.","Creating History Data for Primavera Unifier","81876.htm");
Page[75]=new Array("You can select the business process data you want to use in Primavera Analytics. ","To select business processes:","Sign in to Unifier with administration privileges.","In the navigation pane, select Analytics.","In the Name column, select Business Processes and then click Open.","In the Business Process Setup window, click Add.","In the Select Business Processes for Analytics window, select as many business processes you want to include for analysis and then click OK.","In the Business Processes tab, deselect Track History of Data Elements? option if you decide not to track the history of facts and dimensions for each business process.","In the Custom Fields tab, set the number of user-defined string, date, and numeric fields for Main Form Elements and Line Item Elements for Data Mapping.","Specify values in each field to set the number of user-defined fields for Data Mapping. The default values displayed are based on the existing user-defined fields limit that is currently set in Unifier. The total number of Main Form custom fields cannot exceed 900. Similarly, the total number of Line Item custom fields cannot exceed 900.","When entering values in the fields, use numeric values, do not use decimal points, and use numbers greater than the default values.","In the Data Mapping tab, map the fields or modify the field mapping from the Upper and Detail forms.","In the Data Source column of the top section, select a Unifier Data Element (DE) for each predefined Analytics business process field that appears in the Main form or as a line item in the Detail form.","For example, if there are ten upper forms from all the business processes, and each upper form has 10 DEs, then the drop-down list displays a consolidated unique list of DEs from all the business processes.","For example, if there are twenty Detail forms, and each Detail form has 10 DEs, then the drop-down list displays a consolidated unique list of DEs from the detail forms of all the business processes.","The fields in the drop-down list are those that have a matching Data Definition (DD) as the Name field, in the format&lt;DE Label&gt;(&lt;DE Name&gt;). For example, Department(contract_department).","Notes:","The workflow data (Steps and tasks), related to any Workflow BP, is also sent to Analytics.","The data element of type Rich Text is not available to be mapped to the UDFs from Analytics.","In the User Defined Attributes section, click Add to add custom fields in addition to the system-defined fields.","Specify values for the following properties of the attribute and click OK:","Data Type: Select the data type of the attribute as any one of the following: String (default), Date, Numeric","Source: Select the data source as Main Form or Details Form.","Name: Select the user defined string to be associated with the name. You can add up to 100 names (User Defined String Fields 1 - 100)","Data Source: Select the data source to be associated with the custom field.","Label: Defaults to the data element label selected in the Data Source list. Modify the label if necessary.","To modify a user-defined attribute, select the attribute and then click Modify.","To remove a user-defined attribute, select the attribute, and then click Remove.","Notes:","Analytics displays the value, if the label is absent.","Analytics displays the label, which has the Value/Label pair, in the case of Data Elements (DEs).","Click Apply and then click OK.","For more details, see the Primavera Unifier General Administration Guide.","Setting Up Business Processes for Analytics","89171.htm");
Page[76]=new Array("You can select the Cash Flow names that you want to use for analysis, and set up the data for the fields related to Cash Flow in the Cash Flow record.","To set up cash flow data for Primavera Analytics:","Sign in to Unifier with administration privileges.","In the navigation pane, select Analytics.","Select Business Processes and then click Open.","In the Cash Flow Setup window, select any of the following actions: ","Click Add to add a cash flows for analysis.","Click Remove to remove cash flows from analysis.","To add cash flows for analysis, click Add.","In the Cash Flow window, select as many cash flows you want to include for analysis and then click OK.","In the top section of the Data Mapping tab, map the predefined Analytics Cash Flow fields to a corresponding Unifier Cash Flow Curve type for the following fields:","Initial Baseline: Select the data source of the initial baseline based on the Baseline Cash Flow curve type, defined under the Cash Flow data sources (Cashflow Datasources window) in the Standard &amp; Libraries.","Current Baseline: Select the data source of the current baseline based on the Baseline Cash Flow curve type, defined under the Cash Flow data sources (Cashflow Datasources window) in the Standard &amp; Libraries.","Actuals (Spends): Select the Actuals mapping based on the Spends curve type.","Forecast: Select the forecast based on the Forecast curve type.","User Defined Curve 1 through User Defined Curve 10: Select a UDF curve based on the Cash Flow curve type and sorted in alphabetical order. It includes UDF curves from all cash flow data sources.","Notes: ","Cash Flow Derive curve is not supported.","The fields displayed in the Data Source drop-down list is a concatenation of the Cash Flow data source name and Cash Flow curve type.","The Analytics field name can be the same as the Data Source name. For example, you can map a User Defined Curve to data source named, &quot;Initial Baseline&quot;.","Click Apply and then click OK.","For more details, see the Primavera Unifier General Administration Guide.","Setting Up Cash Flow Data for Analytics","89173.htm");
Page[77]=new Array("You can select the Cost Sheet column data that you want to use for analyses.","To set up cost sheet data for Primavera Analytics:","Sign in to Unifier with administration privileges.","In the navigation pane, select Analytics.","Select Cost Sheet and then click Open.","In the Data Mapping-Columns tab of the Cost Sheet Setup window, specify the following information:","In the top section, for each Cost Sheet Analytics field listed in the Name column, select a corresponding Cost Sheet Data Source defined in Unifier. Data sources are classified as Single Sources and Logical Sources.","In the User Defined Columns section, ","In the Data Source column, select a data source for each User Defined Column.","The P6 data sources are included under the Single Sources, and the element is included within the parenthesis of the P6 Data Source. For example, Current Baseline (Planned Cost).","In addition to the predefined list displayed, you can add up to 10 additional mappings for the Cost Sheet data sources.","You can pick the same data source for multiple fields.","In the Label field, modify the label according to your business need. By default, the label is populated with the data source name.","A red-color asterisk (*/star symbol) appears for the columns that are mapped to a data source.","In the Data Mapping-Cost Attributes tab of the Cost Sheet Setup window, click Add.","In the Add User Defined Attribute window, enter the following information:","The Data Type field displays String by default. ","If the Data Type field is String, then the field is a dimension object in Primavera Analytics. Otherwise, the field is a fact object.","In the Name field, select a User Defined String Field 1 through 20.","In the Data Source field select the Data Elements (DEs) from the Cost Code Attributes Detail Form. Only DEs with the String type Data Definitions (DDs) are displayed in the Data Source field. The String type DDs in the list are:","Text Box","Multiple Text Lines","Pull-Down Menu","Radio Buttons","Multi-select Input","In the Label field, modify the label name as per your business needs. By default displays the Data Source field value selected in the previous field. ","Click OK.","Click Apply and then click OK.","For more details, see the Primavera Unifier General Administration Guide.","Setting Up Cost Sheet Data for Analytics","89175.htm");
Page[78]=new Array("Primavera Analytics&gt; supports reporting and analyses of data from the various cost attributes in the Generic Cost Sheet of Shells with Generic Cost Codes. You can map the Analytics fields to the corresponding Generic Cost Sheet columns.","To select business processes:","Sign in to Unifier with administration privileges.","In the navigation pane, select Analytics.","In the Name column, select Generic Cost Sheet and then click Open.","In the Data Mapping tab, map the Generic Cost sheet Analytic fields to the corresponding Generic Cost Sheet columns, defined in Unifier:","In the Data Source field, select the data source for each user defined column. ","Data source values are the single sources and logical sources existing in the Generic Cost Sheets of all the Generic type Shells. You can pick the same data source for multiple fields.","In the Label field, modify the display name for the data source based on your business needs. Defaults to the Name column for the data source, as set in the Generic Cost sheet column definition","Click OK.","For more details, see the Primavera Unifier General Administration Guide.","Setting Up Generic Cost Sheet Data for Analytics","89177.htm");
Page[79]=new Array("You can select the P6 Data Sources that you want to use in Analytics. ","To add P6 data sources:","Sign in to Unifier with administration privileges.","In the navigation pane, select Analytics.","In the Name column, select P6 Summary Sheets and then click Open.","In the Analytics P6 Summary Sheets Setup window, click Add.","In the Select P6 Data Sources for Analytics field, select any of the available data sources, and then click OK.","If fields overlap between the CBS Shells and the existing P6 Summary Sheets, then the system-defined fields in the P6 Summary Sheets will be used.","For more details, see the Primavera Unifier General Administration Guide.","Setting Up P6 Summary Sheets Data for Analytics","89178.htm");
Page[80]=new Array("You can select the Shells that you want to use for analyses. Shells are called projects in Primavera Analytics.","To add Shell data for Primavera Analytics:","Sign in to Unifier with administration privileges.","In the navigation pane, select Analytics.","In the Name column, select Shells and then click Open.","In the top section of the Data Mapping tab, specify the following information: ","In the Data Source column, select the Data Element (DE) for each predefined, read-only field listed in the Name column.","The Name column, displays which represent the fields used in Primavera Analytics.","In the User Defined Attributes section of the Data Mapping tab, click Add.","In the Add User Defined Attribute window specify values for the following properties of the attribute:","Data Type: Select the data type of the attribute as any one of the following: String (default), Date, Numeric","Source: Select the data source as Main Form or Details Form.","Name: Select the user defined string to be associated with the name. You can add up to 100 names (User Defined String Fields 1 - 30)","Data Source: Select the data source to be associated with the custom field.","Label: Defaults to the data element label selected in the Data Source list. Modify the label if necessary.","Notes:","Analytics displays the value, if the label is absent.","Analytics displays the label, which has the Value/Label pair, in the case of Data Elements (DEs).","Click OK.","For more details, see the Unifier General Administration Guide (https://docs.oracle.com/cd/F50962_01/English/User_Guides/user_general/index.html).","Setting Up Shell Data for Analytics","89180.htm");
Page[81]=new Array("You can select the Space Manager data that you want to use in Primavera Analytics. ","To add a new space manager data for Primavera Analytics:","Sign in to Unifier with administration privileges.","In the navigation pane, select Analytics.","In the Name column, select Space Manager and then click Open.","In the Space Manager Setup window:","Select the Space Types tab and choose any of the following actions: ","Click Add to add a space type for analysis.","Click Modify to update a space type data for analysis","Click Remove to remove space type from analysis.","To add space types for analysis, click Add.","In the Space Types window select one or more space types and then click OK.","Tip: Use the CTRL or Shift keys to select multiple space types.","Click Apply and then click OK.","Select the Data Mapping -Space Types tab and click Add to add custom fields from various Space Types to use in Analytics.","In the Add User Defined Attribute window specify values for the following properties for the attribute.","Data Type: Select the data type of the attribute as any one of the following: String (default), Date, Numeric","Source: Select the data source as Main Form or Details Form.","Name: Select the user defined string to be associated with the name.","Data Source: Select the data source to be associated with the custom field.","Label: Defaults to the data element label selected in the Data Source list. Modify the label if necessary.","Click OK.","Select the Data Mapping -Level tab and click Add to add custom level/floor fields from various levels to map the Analytics field to the corresponding Levels field.","In the Add User Defined Attribute window specify values for the following properties of the attribute.","Data Type: Select the data type of the attribute as any one of the following: String (default), Date, Numeric","Source: Select the data source as Main Form or Details Form.","Name: Select the user defined string to be associated with the name.","Data Source: Select the data source to be associated with the custom field.","Label: Defaults to the data element label selected in the Data Source list. Modify the label if necessary.","Click OK.","Notes:","Analytics displays the value, if the label is absent.","Analytics displays the label, which has the Value / Label pair, in the case of Data Elements (DEs).","For more details, see the Primavera Unifier General Administration Guide.","Setting Up Space Manager Data for Analytics","89179.htm");
Page[82]=new Array("You can select Unifier's vendor data that you want to use in Primavera Analytics.","To setup vendor data for Primavera Analytics:","Sign in to Unifier with administration privileges.","In the navigation pane, select Analytics.","In the Name column, select Vendors and then click Open.","In the Vendors Setup window, choose any of the following actions:","Click Add to add vendor data for analysis.","Click Remove to remove vendor data from analysis.","To add vendor data, click Add.","In the Vendors tab, select one or more vendors and then click OK.","Tip: Use CTRL or Shift keys to select multiple space types.","Click Apply and then click OK.","In the Data Mapping tab, map the predefined Analytic Vendor related fields to a corresponding Unifier Data Element (DE) in the Business Process as follows:","In the Data Source list, select the upper form DEs, for the selected Vendor in the Vendors tab for the following fields:","Vendor ID","Name","Type","Click Apply and then click OK.","For more details, see the Primavera Unifier General Administration Guide.","Setting Up Vendor Data for Analytics","89181.htm");
Page[83]=new Array("Both P6 EPPM and Primavera Unifier can store location information for projects. In addition, P6 EPPM can also store location information for activities and resources. Primavera Analytics can create intelligent analysis to evaluate measures using the geographical location data entered in P6 EPPM and Primavera Unifier. You will need spatial boundary data and maps.","Primavera Analytics now uses built-in Oracle Maps of Oracle Analytics Server by default for creating spatial analyses included with Primavera Analytics sample catalog. For more information on mapping and spatial information, see the Oracle Analytics Server documentation.","Using Location Data","83511.htm");
Page[84]=new Array("P6 EPPM supports the ability to enter location data at the dictionary level that can be assigned to Projects, Activity, and Resources and then extracted, transformed, and loaded into the data warehouse for use in Oracle Analytics Server analysis.","To create location data in P6 EPPM, complete the following steps:","Sign in to P6 EPPM with an account that has the privilege to change enterprise data (for example, admin).","From the Administer @ menu, select Enterprise Data.","In the Enterprise Data pane, expand Global, and then select Locations.","Enter the location data as appropriate for your specific needs.","Assign locations data to projects, activities, and resources as needed. ","Note: See the P6 help for information about entering and assigning location data.","After all of the location data is entered and assigned where appropriate for your environment, run all of the Global publication services to ensure that the data in the publication tables is up to date. After Publication Services have run to successful completion, run the STARETL process to extract, transform, and load the data from P6 EPPM to the data warehouse.","Entering P6 EPPM Location Data for Mapping","83512.htm");
Page[85]=new Array("There are some additional steps required to integrate Primavera Unifier location data with map data. The Primavera Unifier staging tables store columns for State and Country name (for example, United States), however some Oracle Maps layers rely on State and Country code for the mappings. Run the included script at the end of the STARETL process to ensure that the State Code and Country Code columns are populated correctly for use with map data. ","To enter location data in Primavera Unifier:","Sign in to Primavera Unifier.","Assign locations to your projects.","From the Company Admin screen, select the Analytics module.","In the Shell mapping configuration, ensure that the Country and State columns are mapped to values that represent country and state codes rather than names. ","Note: When you map a Shell to a UDF in the Unifier Analytics module, the data type of the UDF determines whether it will be available as a dimension or a fact in in analytics.","If the data type of the UDF is String or Date, the data will be mapped as a Dimension object in Analytics.","If the data type of the UDF is Numeric, then the data will be mapped as a Fact object in Analytics, and is only available in the Primavera - Project User Defined Fields and Primavera - Project User Defined Fields History subject areas.","After you have entered and assigned all of the location data where appropriate for your environment, run all of the Publication Services to ensure that the data in the publication tables is current. After Publication Services have run successfully, run the STARETL process to extract, transform, and load the data from Primavera Unifier to the Primavera Data Warehouse.","Preparing Primavera Unifier Location Data for Mapping","83514.htm");
Page[86]=new Array("You can create connections to Oracle Applications and use those connections to create data sets.","You use the Oracle Applications connection type to create connections to OBIEE. After you create a connection, you can access and use subject areas and analyses as data sets for your projects.","In the Home page of Data Visualization Data, click Create, then click Connection. to display.","In the Create Connection dialog box, click the Oracle Applications icon.","Enter the following information: A name for the new connection, the OBIEE URL, user name, and password.","In the Authentication field, specify if you want the users to be prompted to log in to access data from the Oracle Applications data source.","If you select Always use these credentials, then the login name and password you provide for the connection is always used and users aren&#8217;t prompted to log in.","If you select Require users to enter their own credentials, then users are prompted to enter their user names and passwords to use the data from the Oracle Applications data source. Users required to log in see only the data that they have the permissions, privileges, and role assignments to see.","Click Save.","Creating Oracle Applications Connections","85215.htm");
var PageCount=87;


/*
Date: 12/23/2024 11:05 AM
Source: analytics_25_dev
BookID: 83664
PubProduct: PRIMAVERA_ANALYTICS
BookTitle: Cloud Service Administration Guide
Version: Version 25
Lang:	en
*/
	var PageLength=Page.length;
	var Result = "";
	var ResultTemp = "";
	var ResultFound = "";
	var ResultTitleOnly = [];
	var ResultTitleAndContent = [];
	var ResultInContent = [];
	var ResultInContentTemp = [];

	var ResultCombinedTemp = [];
	var ResultCombined = [];

	var arrayIndex = 0;
	var NrRes = 0;
	var j = 0;
	var i = 0;
	var k = 0;
	var d = 0;
	var maxItems = 1000;
	var heading = 0;
	var WordPos = -1;
	var WordPosHeading = -1;
	var WordPosContentText = -1;
	var FoundWord = "";
	var FoundWordHead = "";
	var SearchInHeadingOnly = 0;
	var isChecked;
	var size = 10;
	var resGroupCounter = 0;
	var shown = "shown";
	var checkBoxInHeading;
	var searchFlag = 0;
	var DivResult;
	var SearchWord;

if (SearchText && SearchText.length >= 1) {
		SearchWord = SearchText.replace(/\+/g, " ").replace(/&/g, "&amp;").replace(/</g, "&lt;").replace(/>/g, "&gt;").replace(/"/g, "&quot;");
		searchFlag = 1;
	} else {
		SearchWord = "";
		searchFlag = 0;
	}
	

	if (searchFlag === 1) {
		Result = "";

		// checkBoxInHeading = document.getElementById("inHeading");
		if (inHeading) {

			isChecked = true;
		} else {

			isChecked = false;
		}

		if (SearchWord && SearchWord.length >= 1) {
			if (isChecked) {
				SearchInHeadingOnly = 1;
			} else {
				SearchInHeadingOnly = 0;
			}
			SearchWord = SearchWord.toLowerCase();
			window.status = "Searching, please wait...";
			for (j = 0; j < PageLength; j++) {
				k = Page[j].length - 1;
				for (i = 0; i < k; i++) {

					heading = k - 1;

					if (SearchInHeadingOnly === 1) {
						WordPosHeading = Page[j][heading].toLowerCase().indexOf(SearchWord);
						if (WordPosHeading > -1) {
							FoundWordHead = Page[j][heading].substr(WordPosHeading, SearchWord.length);

							NrRes++;
							ResultTemp = "<li>";
							ResultTemp += "<span>";
							ResultTemp += "<a href='" + Page[j][k] + "'>" + Page[j][heading].replace(FoundWordHead, FoundWordHead.bold()) + "</a><br/>\n";

							ResultTemp += "</span>";
							ResultTemp += "</li>";

							ResultTitleOnly[arrayIndex] = ResultTemp;
							arrayIndex++;

							ResultTemp = "";
							WordPosHeading = -1;
							WordPosContentText = -1;
							break;
						}
					} else if (SearchInHeadingOnly === 0) {
						WordPos = Page[j][i].toLowerCase().indexOf(SearchWord);
						WordPosHeading = Page[j][heading].toLowerCase().indexOf(SearchWord);
						if (WordPos > -1) {
							FoundWordHead = Page[j][heading].substr(WordPosHeading, SearchWord.length);
							FoundWord = Page[j][i].substr(WordPos, SearchWord.length);
							FoundWord = Page[j][i].substr(WordPos, SearchWord.length);
							NrRes++;
							ResultTemp += "<li>";
							ResultTemp += "<span>";
							if (WordPosHeading > -1) {
								ResultTemp += "<a href='" + Page[j][k] + "'>" + Page[j][heading].replace(FoundWordHead, FoundWordHead.bold()) + "</a><br/>\n";
							} else {
								// found word is not in the head
								ResultTemp += "<a href='" + Page[j][k] + "'>" + Page[j][heading] + "</a><br/>\n";

							}
							if (i < k - 1) {
								WordPosContentText = Page[j][i].toLowerCase().indexOf(SearchWord);

								if (Page[j][i].length > 300 && (WordPosContentText > -1)) {

									if (WordPosContentText > 75) {
										ResultInContentTemp.push("..." + Page[j][i].substr(WordPosContentText - 75, 175 + FoundWord.length).replace(FoundWord, FoundWord.bold()) + "...");
									} else {
										ResultInContentTemp.push("..." + Page[j][i].substr(0, 175 + FoundWord.length).replace(FoundWord, FoundWord.bold()) + "...");

									}

								} else if (WordPosContentText > -1) {

									ResultInContentTemp.push(Page[j][i].replace(FoundWord, FoundWord.bold()));

								}
							}

							ResultTemp += ResultInContentTemp.join("");

							ResultTemp += "</span>";
							ResultTemp += "</li>";

							if (WordPosHeading > -1) {
								ResultTitleAndContent[arrayIndex] = ResultTemp;
								arrayIndex++;
							} else {
								ResultInContent[arrayIndex] = ResultTemp;
								arrayIndex++;
							}

							ResultInContentTemp.length = 0;
							ResultTemp = "";
							WordPosHeading = -1;
							WordPosContentText = -1;
							break;
						}

					}
				}
			}

			ResultTitleOnly = ResultTitleOnly.filter(function (n) {
				return (n !== undefined && n !== null);
			});
			ResultTitleAndContent = ResultTitleAndContent.filter(function (n) {
				return (n !== undefined && n !== null);
			});
			ResultInContent = ResultInContent.filter(function (n) {
				return (n !== undefined && n !== null);
			});

			ResultCombinedTemp = ResultTitleOnly.concat(ResultTitleAndContent, ResultInContent);

			ResultCombinedTemp = ResultCombinedTemp.filter(function (n) {
				return (n !== undefined && n !== null);
			});

			for (d = 0; d < ResultCombinedTemp.length; d += size) {
				resGroupCounter++
				ResultCombined.push("<div id=" + "'" + "resGroup_" + resGroupCounter + "'" + " class=" + "'" + "resGroup " + shown + "'" + ">" + "<ol class='searchResults'>" + ResultCombinedTemp.slice(d, d + size).join("") + "</ol></div>");
				shown = "notshown";
			}

			ResultFound = ResultCombined.join("");

Result += "<div id='searchDetailsDiv'>";
			Result += "<p class='searchDetails'>Your Search Found&nbsp;" + NrRes + "&nbsp;items.&nbsp;";
			Result += "</p></div>";
			
			Result += "<div class='searchResultsDiv'>";
			Result += "<div id='resultsCollection' class='searchResults'>";
			Result += ResultFound;
			Result += "</div>";
			Result += "</div>";
			Result += "<div class='searchPaging'>";

			Result += '<hr />';

			Result += '<p class="bodytext"><a class="disabledAnchor" id="pBack" onclick="turnPage(\'backPage\')" href="#pBack">Back</a>&nbsp; | &nbsp;';
			
			if (resGroupCounter && resGroupCounter > 1) {
				Result += '<a id="pNext" onclick="turnPage(\'nextPage\')" href="#pNext">Next</a>';
			} else {
				Result += '<a id="pNext"  class="disabledAnchor" href="#pNext">Next</a>';
			}
			Result += '</p>\n';
			Result += '<div id="pagenofn"><p class="bodytext">Page <span id="pagen">1</span> of ' + resGroupCounter + '</p></div>';

			Result += "</div>";
			
			
		}

		DivResult = document.getElementById("s_anchor");
		if (Result && DivResult) {

			//myDivResult.append(Result);
			DivResult.innerHTML = Result;
			

		}
		window.status = "";
		
		

	}
	}())
}
