'use strict';
function search(SearchText, inHeading) {
(function () {
var Page = [];
/* Generated with Author-it 23.4.1.30004  12/12/2025 6:58:02 PM */
Page[0]=new Array("Title and Copyright Information","Copyright  1999, 2025, Oracle and/or its affiliates.","Primary Author: Oracle Corporation","Title and Copyright Information","46576.htm");
Page[1]=new Array("This library is intended for installers and administrators of on-premises deployments of P6 EPPM.","What is P6 EPPM?","P6 EPPM provides the most powerful, robust, and easy-to-use solution for globally prioritizing, planning, managing, and executing projects, programs, and portfolios in asset-intensive industries.","How can I find out what is different between releases?","Use the Cumulative Feature Overview (CFO) to see a list of changes we've made between releases.","To use the CFO offline, download the CFO zip file. Unzip the file to a local folder and open EPPM_CFO.html.","How do I search documentation?","Our search functionality is a full-text search, which means that it searches both the titles and the text of topics. You can enter text to search for in the search box and select whether to search all text, or to search only in titles.","Where can I find documentation for earlier versions?","If you are on a version prior to version Version 25, go to Previous Releases to access your documentation.  ","Please note that we update our version Version 25 documentation on a regular basis as we add new features to P6 EPPM. You will always see the most current content that is available. This means that if you are not on the most current version Version 25 release level, you might see documentation for features that you will not have access to until you upgrade.","Welcome to the P6 EPPM Installation and Configuration Library for On-Premises","96418.htm");
Page[2]=new Array("If you are using P6 EPPM in an on-premises deployment (rather than the Oracle Cloud), use these documents to learn more about P6 EPPM architecture, performance, and security. On-premises administrators should use these documents. ","What configurations work for an on-premises server deployment?","See the P6 EPPM Tested Configurations document to get details on the configurations that we've tested and verified to work when you deploy P6 EPPM on-premises.","HTML | PDF","How do I plan for my installation?","The P6 EPPM Planning and Implementation Guide provides details how to plan your on-premises installation and ensures you have the necessary technical specifications to successfully install, including checklists to help guide you through the installation.","HTML | PDF","How do I size my installation?","See the P6 EPPM Performance and Sizing Guide for estimates of hardware and software requirements for deploying P6 EPPM.","HTML | PDF","What security considerations should I keep in mind?","The P6 EPPM Security Guide describes how to handle security in an on-premises deployment, including information on safe deployments, authentication options, and security settings.","HTML | PDF","What is your architecture?","See the P6 EPPM System Architecture Data Sheet for an overview on how P6 EPPM components work together.","HTML | PDF","Planning","91797.htm");
Page[3]=new Array("If you are using P6 EPPM in an on-premises deployment (rather than the Oracle Cloud), use these documents to install and upgrade P6 EPPM.","On-premises administrators should use these documents. ","Installing","How do I install and configure P6 EPPM?","The P6 EPPM Installation and Configuration Guide shows how to install and configure P6 EPPM using the installation wizard.","HTML | PDF","How do I manually install P6 EPPM with an Oracle database?","We recommend that you use the installation wizard to install P6 EPPM; however, you can manually install it.","See the P6 EPPM Manual Installation Guide (Oracle Database) for details on how to manually install P6 EPPM with an Oracle database.","HTML | PDF","How do I manually install P6 EPPM with a Microsoft SQL Server database?","We recommend that you use the installation wizard to install P6 EPPM; however, you can manually install it.","See the P6 EPPM Manual Installation Guide (Microsoft SQL Server Database) for details on how to manually install with a SQL Server database.","HTML | PDF","How do I install P6 Professional for use with P6 EPPM?","The P6 Professional Installation and Configuration Guide (P6 EPPM) shows how to install and configure P6 Professional in a on-premises P6 EPPM environment.","HTML | PDF","Upgrading","What are the best practices for upgrading?","The P6 EPPM Upgrade Best Practices Guide describes is how to determine when an upgrade is appropriate for your organization, evaluate common upgrade paths, and create an upgrade agenda for your organization in an on-premises deployment.","HTML | PDF","How do I upgrade P6 EPPM?","See the P6 EPPM Upgrade and Configuration Guide for details on how to upgrade and configure your applications using a script and wizards.","HTML | PDF","How do I manually upgrade P6 EPPM with an Oracle database?","We recommend that you use the wizards to upgrade P6 EPPM; however, you can manually upgrade it.","The P6 EPPM Manual Upgrade Guide (Oracle Database) describes how to manually upgrade.","HTML | PDF","How do I manually upgrade P6 EPPM with a Microstoft SQL Server database?","We recommend that you use the wizards to upgrade P6 EPPM; however, you can manually upgrade  it.","P6 EPPM Manual Upgrade Guide (Microsoft SQL Server Database)","HTML | PDF","Installing and Upgrading","91798.htm");
Page[4]=new Array("If you are using P6 EPPM in an on-premises deployment (rather than the Oracle Cloud), use these documents to set up various supporting technologies to work with Primavera Unifier. ","On-premises administrators should use these documents. ","How do I configure Oracle Analytics Publisher?","See the P6 EPPM Oracle Analytics Publisher Configuration Guide to learn how to set up your Oracle Analytics Publisher environment and connect it to work with P6 EPPM, to support on-demand web-based reporting.","HTML | PDF","How do I configure BPM (Business Process Management)?","The P6 EPPM BPM Configuration Guide describes how to set up your BPM environment and connect it to work with P6 EPPM, to support business processes, models, and standards.","HTML | PDF","How do I configure my content repository?","See the P6 EPPM Content Repository Configuration Guide for detail on how to set up your content repository and connect it to work with P6 EPPM, to enable you to catalog, access, search, and reuse documentation.","HTML | PDF","How do I configure OAM (Oracle Access Manager)?","The Oracle Access Manager Configuration Guide describes how to integrate OAM with Primavera products, including P6 EPPM, to support Single Sign-On and SAML authentication.","HTML","How do I configure OEM (Oracle Enterprise Manager)?","The OEM For Oracle Construction and Engineering Configuration Guide describes how to integrate OEM with Primavera products to manage patch sets, view metrics, and use the Enterprise Manager for Oracle Construction and Engineering plugin.","HTML","How do I configure OIM (Oracle Identity Manager)?","The P6 EPPM Oracle Identity Manager Configuration Guide describes how to set up OIM and connect it to work with P6 EPPM, to enable you to centrally administer user accounts and access privileges. ","HTML | PDF","How do I configure WebLogic?","See the P6 EPPM WebLogic Configuration Guide to learn how to set up your WebLogic environment and connect it to work with P6 EPPM. It also describes how to configure eventing for P6.","HTML | PDF","Configuring","91800.htm");
Page[5]=new Array("Use these documents to learn how to administer various aspects of your on-premises P6 EPPM environment. ","Administrators should use these documents.","How do I create P6 EPPM configurations on-premises?","See the P6 EPPM System Administration Guide to learn how to create P6 EPPM configurations to control how various applications run on a server once you have installed them. Complete the tasks in this guide before setting up the applications with useful global data or letting your users work with the applications.","HTML | PDF","How do I administer P6 EPPM databases on-premises?","The P6 EPPM Database Administration Guide describes how to do the following:","Migrate your P6 EPPM databases between Microsoft SQL Server database and Oracle database or your database schema between P6 EPPM and P6 Professional.","Create or update configurations for the Primavera P6 Administrator using dbconfig.","Configure database settings and the scheduler for background processes and jobs.","Monitor processes and procedures by using PAUDIT audit and by monitoring BGPLOG table or high level statuses.","Perform maintenance tasks on the P6 EPPM database using the SYMON and DAMON and safe deletes as well as cleaning the PX tables and modifying database settings.","HTML | PDF","What P6 EPPM licenses are available, and what 3rd party components do you use?","See the P6 EPPM Licensing Information User Manual for lists of licenses and third-party components.","Administrators should review this document. ","HTML | PDF","Administering","91794.htm");
Page[6]=new Array("How to use MyLearn for Construction &amp; Engineering video","The MyLearn website provides free video-based training for all Construction and Engineering applications. On your first visit, create a free account with Oracle University and enjoy these benefits:","More than 300 videos","Site remembers which videos you have watched","Filter by product","Earn badges to share on social media","Video captions translated into 14 languages","Searchable transcript in English","Build your own home page based on your preferences and favorites","Track your progress and achievement on a personal dashboard","A variety of training is offered. (Not all training types offered for all products)","Get Started:  New user? These courses will get you up and running.","What's New: Learn about the new features introduced in the latest release.","Video Training: Single-topic, short duration videos provide instruction on basic functions and common tasks.","Crash Courses: Longer-duration videos (narrated by an instructor) guide you step-by-step through processes like planning a project, or take a deep-dive into a single subject.","Full Virtual Courses: Do hands-on exercises in the software and view training manuals in these comprehensive instructor-led recorded courses. Requires fee.","Training","102091.htm");
Page[7]=new Array("If you have a question about using Oracle products that you cannot resolve using information in the Help Center, visit My Oracle Support (MOS).","My Oracle Support (MOS)","To get started using MOS or review helpful tips, visit the Construction &amp; Engineering Customer Hub to review the My Oracle Support help article.","My Oracle Support help article","Register on My Oracle Support","Register as a new user on My Oracle Support (MOS), so you can create Service Requests (SRs). After you register, Oracle will ask you to verify your email address. Once verified, you can log in to your MOS account. ","After the first login, you need to request access to the Support Identifier (SI) number included in the welcome email you received from Oracle. This number identifies your organization's products and services and is required to use MOS.  ","Once you submit the SI number, you will be assigned as the Customer User Administrator (CUA) in MOS. The CUA can submit Service Requests, approve or deny user access, and assign user privileges in MOS. ","Oracle recommends having at least two CUAs for every SI. Identify additional CUAs and/or authorized users who can create Service Requests on behalf of your organization. Provide them with the SI number and instruct them to register on MOS. Once they register, you will need to approve their access and assign them as a CUA in MOS. ","For more information on the CUA role and/or how to complete tasks, reference the CUA for Cloud series in MOS. Note that you must have an MOS account with an SI number linked to view support content in that portal. ","Creating a Service Request","To learn how to create a service request, click the &quot;Service Requests (SRs)&quot; link on our My Oracle Support Portal Documentation page: https://support.oracle.com/knowledgefs/?docId=MC1","When you create a service request, be sure to enter the correct product information and problem details so that the request is assigned to the proper Oracle Support team.","On-premises users having issues with a related Oracle technology should contact the appropriate support line. Available technologies vary by product and include the following products:","Oracle Access Manager","Oracle AutoVue","Oracle BI Publisher","Oracle Analytics Publisher","Oracle BPM","Oracle Business Intelligence","Oracle Database","Oracle E-Business Suite","Oracle Enterprise Manager","Oracle Instantis EnterpriseTrack","Oracle Server","Oracle Value Chain Planning","Oracle WebCenter Content Core Capabilities (formerly Universal Content Management)","Oracle WebLogic","Using Information Centers","Information centers provide links to important support and product information. They organize documents found on My Oracle Support (MOS), providing quick access to product- and version-specific information, such as important knowledge documents, Release Value Propositions, and Oracle University training.","Visit https://support.oracle.com/support/?kmExternalId=KB337865 to access the information center for your product.","Information centers also provide access to:","Communities which are moderated by Oracle providing a place for collaboration among industry peers to share best practices. ","Recently published knowledge base alerts and articles.","Support Renewals Process","If it's time to renew support for your Oracle products, or if you would like to sign up for auto-renewal of your support services, visit the My Support Renewals site: https://supportrenewals.oracle.com.","Keeping Your On-Premises Software Current and Secure","To ensure you have the latest versions of your products, download and install all available patch sets from http://support.oracle.com.","To get the latest information about Critical Patch Updates, go to https://www.oracle.com/security-alerts/.","Support","102092.htm");
Page[8]=new Array("To view documentation for older releases, click on the release level below: ","24 Documentation Library","23 Documentation Library","22 Documentation Library","21 Documentation Library","20 Documentation Library","19 Documentation Library","18 Documentation Library","17 Documentation Library","16 R2 Documentation Library","16 R1 Documentation Library","15 R2 Documentation Library","15 R1Documentation Library","8.4 Documentation Library","8.3 Documentation Library","8.2 Documentation Library","Previous Releases","93294.htm");
var PageCount=9;


/*
Date: 12/12/2025 6:57 PM
Source: EPPM_25_dev
BookID: 91761
PubProduct: PRIMAVERA_EPPM
BookTitle: Installation and Configuration Documentation
Version: Version 25
Lang:	en
*/
/* relative_path_for_link: English\tested_configurations*** */
/* BookTitleTop: Primavera P6 EPPM Tested Configurations*** */
/* Generated with Author-it 23.4.1.30004  12/11/2025 7:34:05 PM */
Page[9]=new Array("Title and Copyright Information","Copyright   2025, Oracle and/or its affiliates.","Primary Author: Oracle Corporation","Title and Copyright Information<br /> (Primavera P6 EPPM Tested Configurations)","English\\tested_configurations\\46576.htm");
Page[10]=new Array("This document covers the tested configurations for Primavera P6 EPPM Database, P6 Web, P6 Integration API, P6 EPPM Web Services, P6 Team Member, P6 Professional Cloud Connect and P6 Professional Version 25.12.","Oracle has tested on the following configurations and only certifies this release to work on these platforms. Customers may choose to install on non-certified platforms but do so at their own risk. If customers find any problems with non-certified platforms, these may take longer to investigate and resolve by Oracle. Oracle will only test and have access to tested platforms and configurations. In addition, the resolution for an issue with a non-tested configuration might be a recommendation to deploy the product on a tested platform. If you still decide to deploy on a non-certified configuration, Oracle strongly recommends you fully test the product with the non-certified platform in a test environment before deployment to users.","Note","All platforms and technologies certified with a base P6 version are also supported with the latest P6 patch set for that version (unless specified). Before you install the latest version of a platform or technology, install the most recent P6 patch set certified for it.","Interim patches as well as quarterly Critical Patch Updates (CPUs) for tested base versions of Oracle platform technologies listed in this document (Weblogic, Oracle database, and Java) are also supported.","P6 EPPM is tested using the Enterprise Edition of the stated database, operating system, or web server and only certifies this product edition to work on the platforms as listed in this document.","Any operating system certified for use with technologies listed in this document is supported. For information on certified platforms for Oracle and other third-party technologies, refer to the certification matrix of the respective technology and select the platform compatible with your Primavera applications and the respective technology.","Refer to the link below for the specific and complete Oracle Support terms and conditions:","https://www.oracle.com/support/policies/","About This Guide<br /> (Primavera P6 EPPM Tested Configurations)","English\\tested_configurations\\100188.htm");
Page[11]=new Array("Review the table to learn about updates to this document.","Change Record","Date","Change Reference","December 2025","First published for this release.","What's Changed<br /> (Primavera P6 EPPM Tested Configurations)","English\\tested_configurations\\100238.htm");
Page[12]=new Array("P6 EPPM supports:","Oracle Virtual Machine as a virtualization platform.","EXA Hardware for database and application server platforms.","Multitenant for database platform.","Microsoft .Net framework 4.6.2.","Windows installer 4.5.","P6 Professional Cloud Connect is not supported with any version of SQL Server.","Java","JRE (Java Runtime Environment) is not a requirement for P6 EPPM; it is requirement only for AutoVue. JRE 1.8.0_311 is certified for this requirement.","Deprecated Technologies","P6 Integration API is deprecated as of version 16.1 of P6 and may be dropped in a future release.","General Information<br /> (Primavera P6 EPPM Tested Configurations)","English\\tested_configurations\\100443.htm");
Page[13]=new Array("Database Platforms","Oracle Database *","Driver","Exceptions and Additional Information","Oracle Database 23","Oracle 19.29.0.0","Oracle Autonomous Database","Oracle JDBC","*OS Version:","Tested with following fully localized international versions of Windows:","Arabic","Brazilian Portuguese","Chinese Simplified","Chinese Traditional","English","French","German","Italian","Japanese","Russian","Spanish","Korean","Dutch","*Oracle and Oracle Autonomous Database","P6 EPPM supports:","Dataguard, Oracle Advanced Compression, RAC (Real Application Cluster), database partitioning, Oracle Database Vault, and transparent data encryption features on Oracle and Oracle Autonomous Databases.","AL32UTF8, UTF 8, and Western European (WE8MSWIN1252) character sets for Oracle and Oracle Autonomous Databases.","Hardened database server environment setup on Oracle and Oracle Autonomous Database.","Systems - Oracle Database Information<br /> (Primavera P6 EPPM Tested Configurations)","English\\tested_configurations\\100189.htm");
Page[14]=new Array("Database Platforms","MS SQL Server Database *","Driver","Exceptions and Additional Information","SQL Server 2019","SQL Server 2022","Oracle JDBC","Azure SQL database is not supported.","Case-sensitive (CS) collation is not supported for SQL Server. Only case insensitive (CI) collation is supported for SQL Server.","*OS Version:","Tested with following fully localized international versions of Windows:","Arabic","Brazilian Portuguese","Chinese Simplified","Chinese Traditional","English","French","German","Italian","Japanese","Russian","Spanish","Korean","Dutch","*MS SQL Server Database","P6 EPPM supports:","Hardened database server environment setup SQL Server 2019.","Cyrillic, Japanese, Chinese/PRC, Chinese/Taiwan, and Western European collations for SQL Server databases on the respective operating system locales.","Oracle recommends LEGACY_CARDINALITY_ESTIMATION be switched on for any version of SQL Server 2019, or later.","Systems - Non Oracle Database Information<br /> (Primavera P6 EPPM Tested Configurations)","English\\tested_configurations\\100190.htm");
Page[15]=new Array("Application Servers","Product","Version","JDK","Exceptions and Additional Information","Oracle WebLogic","14.1.2","Oracle JDK 17","Web Servers","Product","Version","Exceptions and Additional Information","Oracle HTTP Server","14.1.2","Microsoft Internet Information Server","10","*Version Supported","P6 EPPM supports:","Java Application Server Cluster set up on a supported version of Oracle WebLogic with a supported version of JDK. Refer to the tables above for supported versions.","Hardened application server environment set up on a supported version of Oracle WebLogic with a supported version of JDK. Refer to the tables above for supported versions.","End to end (Database, Application Server and Client tier) SSL for a supported version of Oracle WebLogic with a supported version of JDK. Refer to the tables above for supported versions.","Oracle Virtual Machine as a virtualization platform.","EXA Hardware for database and application server platform.","Refer to the About This Guide page for further consideration relating to non-tested platforms.","Application and Web Servers<br /> (Primavera P6 EPPM Tested Configurations)","English\\tested_configurations\\100191.htm");
Page[16]=new Array("Access Provisioning","Product","Version","Exceptions and Additional Information","Oracle Identity Manager","14.1.2","Supported for P6 Web only.","Application Hosting","Product","Version","Exceptions and Additional Information","Citrix XenApp","7.18","1. Supported for P6 Professional only","2. Citrix XenApp Plugin for Hosted Apps is tested with this server version","3. P6 Professional through Citrix is supported by application publishing only","Remote Desktop Services ","2019","2022","Secure Global Desktop","5.5","Content Repository","Product","Version","Exceptions and Additional Information","Content Management Interoperability Services","n/a","1. CMIS connector supports all repositories which are 100% CMIS compliant","2. CMIS connector is tested only with Sharepoint 2016 and Alfresco content repositories.","Microsoft Sharepoint Enterprise Edition","2019","2022","1.SharePoint 2016 is supported through Connector only for upgrades.","2. Oracle AutoVue support is not available with Sharepoint 2016.","Oracle WebCenter Content Core Capabilities","14.1.2.0","Enterprise Administration","Product","Version","Exceptions and Additional Information","Oracle Enterprise Manager Grid Control","13.3.0.0.0","Java Message Service","Product","Version","Exceptions and Additional Information","Oracle WebLogic","14.1.2","P6 Reporting Software","Product","Version","Exceptions and Additional Information","Oracle Analytics Publisher (formerly Business Intelligence Publisher)","2025","Visualization","Product","Version","Exceptions and Additional Information","Oracle AutoVue 2D Professional","21.1","VueLink 20.1 for UCM is supported only with Oracle WebCenter Content Core Capabilities.","Oracle AutoVue 3D Professional Advanced","21.1","VueLink 20.1 for UCM is supported only with Oracle WebCenter Content Core Capabilities.","Workflow Repository","Product","Version","Exceptions and Additional Information","Oracle Business Process Management","14.1.2","Supported for P6 Web only.","Microsoft Office Format Support","Format","Product","Version","Exceptions and Additional Information","MS Excel (xlsx)","Microsoft Office","2019","Office 365","Microsoft Project Format Support","Format","Product","Version","Exceptions and Additional Information","MS Project (xml)","Microsoft Project","2010","2013","2016","2019","2021","2019 and 2021 were tested only for importing data from a Microsoft Project XML file into P6 EPPM. All other versions were tested both for importing and exporting.","Integrations and 3rd Party Applications<br /> (Primavera P6 EPPM Tested Configurations)","English\\tested_configurations\\100207.htm");
Page[17]=new Array("User Directory Support","Product*","Version","Exceptions and Additional Information","Active Directory","2022","2025","Oracle Access Manager","14.1.2.0","Oracle Internet Directory","14.1.2","Oracle Unified Directory","14.1.2","* Product","Failover and referrals are supported for Active Directory only.","Single Sign On Support","Product*","Version","Exceptions and Additional Information","Oracle Access Manager","14.1.2","P6 EPPM supports Oracle Identity Federation 12.2.1.4.0 and SAML 2.0","Shibboleth","3.3.3.0.0","P6 EPPM supports SAML 2.0.","Tested only with Tomcat (application server) and Apache (web server).","*Product","P6 EPPM Single Sign On support is tested only with Oracle WebLogic Server (application server) and OHTTP (web server).","LDAP and SSO<br /> (Primavera P6 EPPM Tested Configurations)","English\\tested_configurations\\100192.htm");
Page[18]=new Array("Database Client","Client OS/ Email Clients","Oracle database Client Version","Exceptions and Additional Information","Windows 11 (64 bit)","19.8","P6 EPPM supports only 64 bit versions of database clients for P6 Professional on 64 bit operating systems.","Database client is supported for P6 Professional only.","Chrome is recommended for optimal performance.","Browser","Client OS/ Email Clients","Supported Browsers","Exceptions and Additional Information","Windows 2019, 2022, 2025","Firefox 143+","Chrome 139+","Edge 139+","P6 EPPM supports only 64 bit versions of database clients for P6 Professional on 64 bit operating systems.","Database client is supported for P6 Professional only.","Chrome is recommended for optimal performance.","Mac OS 15","Safari 18.6+Firefox 143+","Chrome 139+","Windows 10 (64 bit)","(Windows Surface Pro, Windows Surface Pro2, Windows Surface Pro3)","Firefox 143+","Chrome 139+Edge 139+","Supported for P6 Team Member Web only.","iOS 18 (64 bit)","iOS 18.1 (64 bit)","(iPad)","Firefox 143+","Chrome 139+","Supported for P6 Team Member Web only.","Android Tablets 14+","Chrome 139+","Supported for P6 Team Member Web only.","Android 14","Android 13","Android 12","(Android phone and tablets)","n/a","Supported for P6 for Android native Android app only.","iOS 18.x","(iPad and iPhone)","n/a","Supported for P6 for iOS native iOS app only.","Microsoft Outlook","Mozilla Thunderbird","Apple Mail","Android","Blackberry","n/a","Supported for Email Statusing Service only.","Only English Operating System environments are certified for Email Statusing Service.","Database Client and Browser<br /> (Primavera P6 EPPM Tested Configurations)","English\\tested_configurations\\100208.htm");
Page[19]=new Array("Applications","Product","Exceptions and Additional Information","Oracle Primavera Cloud","The tested version is the most recent version available.","Primavera Gateway","The tested version is the most recent version available.","Primavera Unifier","1. The tested version is the most recent version available.","2. Integration of Primavera Unifier through Primavera Gateway is tested when P6 EPPM Web Services is configured with Oracle database only.","Primavera Portfolio Management","1. The tested version is the most recent version available.","2. Requires P6 EPPM Web Services to integrate with P6 EPPM.","3. IIS 10 with SMTP Service on Windows 2019 &amp; 2022.","4. P6 EPPM integration is supported whenP6 EPPM Web Services is configured for cookies or username token authentication.","Oracle Primavera Risk Analysis","1. The tested version is the most recent version available.","2. Requires P6 EPPM Web Services to integrate with P6 EPPM.","Primavera Data Warehouse and Primavera Analytics","Product","Version","Exceptions and Additional Information","Analytics","25.12","The tested version of Analytics is the most recent version available.","Primavera Data Warehouse","25.4","The tested version of Primavera Data Warehouse is the most recent version available.","Other Primavera Applications<br /> (Primavera P6 EPPM Tested Configurations)","English\\tested_configurations\\100209.htm");
Page[20]=new Array("Language Code","Language","Exceptions and Additional Information","AR","Arabic","English help","PT_BR","Brazilian Portuguese","English help","CH_CN","Chinese Simplified","Localized help","CH_TW","Chinese Traditional","English help","EN","English","English help","NL","Dutch","English help","FR","French","Localized help","DE","German","Localized help","IT","Italian","English help","JA","Japanese","Localized help","RU","Russian","English help","ES_ES","Spanish","English help","KO","Korean","Localized help","PL","Polish","English help, only P6 Team Member Web is supported","CS","Czech","English help, only P6 Team Member Web is supported","Localization<br /> (Primavera P6 EPPM Tested Configurations)","English\\tested_configurations\\100237.htm");
var PageCount=12;


/*
Date: 12/11/2025 7:34 PM
Source: EPPM_25_dev
BookID: 100187
PubProduct: PRIMAVERA_EPPM
BookTitle: Tested Configurations
Version: Version 25
Lang:	en
*/
/* relative_path_for_link: English\Admin\p6_eppm_database_admin*** */
/* BookTitleTop: Primavera P6 EPPM Database Administration Guide for On-Premises*** */
/* Generated with Author-it 23.4.1.30004  12/3/2025 5:56:37 PM */
Page[21]=new Array("Title and Copyright Information","Copyright  1999, 2025, Oracle and/or its affiliates.","Primary Author: Oracle Corporation","Title and Copyright Information<br /> (Primavera P6 EPPM Database Administration Guide for On-Premises)","English\\Admin\\p6_eppm_database_admin\\46576.htm");
Page[22]=new Array("Scope","This guide describes how to:","Migrate your P6 EPPM databases between Microsoft SQL Server database and Oracle database or your database schema between P6 EPPM and P6 Professional.","Create or update configurations for the Primavera P6 Administrator using dbconfig.","Configure database settings and the scheduler for background processes and jobs.","Monitor processes and procedures using PAUDIT audit, BGPLOG table, or high level statuses.","Perform database maintenance tasks using the SYMON and DAMON utilities.","Audience","Database administrators should use this guide.","Using This Guide","This guide assumes you can perform common database administration procedures and have experience using the command line.","About This Guide<br /> (Primavera P6 EPPM Database Administration Guide for On-Premises)","English\\Admin\\p6_eppm_database_admin\\93075.htm");
Page[23]=new Array("Schema User (Oracle and Oracle Autonomous Database only)","Default: ADMUSER","Description: The administrative user owns most database objects within the schema including tables, indexes and constraints, procedures, triggers, and functions, and is primarily used during database creation and upgrades.","Privileged User","Default: PRIVUSER","Description: The following is true for the privileged user: ","Owns views to most of the schema user tables that filter out logically deleted data.","Has SELECT, INSERT, UPDATE, and DELETE privileges on all of the tables owned by the schema user.","Has EXECUTE privileges on all schema procedures.","Is used to facilitate communication between P6 EPPM and P6 Professional.","Owns the synonyms for objects that do not have a view, which means that references to tables that are owned by the schema owner do not have to be fully qualified (Oracle database only).","Public User","Default: PUBUSER","Description: The public user has few permissions in the P6 EPPM database. It has SELECT privileges on the PUBUSER table, which is used to connect a P6 EPPM to the database.  ","Background Job User (Oracle database only)","Default: BGJOBUSER","Description: The background job user initiates and runs P6 EPPM background jobs.","Reporting User","Default: PXRPTUSER","Description: The reporting user owns views to the P6 EPPM extended schema for enterprise reporting.","Read-Only Administrative User (Oracle database only)","Default: ROADMUSER","Description: The read-only user has read-only access to the tables owned by the schema user. The read-only user has the same views as reporting user.","About Database Users<br /> (Primavera P6 EPPM Database Administration Guide for On-Premises)","English\\Admin\\p6_eppm_database_admin\\93709.htm");
Page[24]=new Array("Migrate.bat is a java-based tool that enables you to migrate data between Microsoft SQL Server database and Oracle database as well as database schema between P6 EPPM and P6 Professional. Migrate.bat launches the Migrate Database wizard.","For more information about migrating data between databases, see Using the Migrate Database Wizard.","For more information about migrating database schema from P6 EPPM to P6 Professional, see Migrating Database Schema.","Migrating Databases and Database Schema<br /> (Primavera P6 EPPM Database Administration Guide for On-Premises)","English\\Admin\\p6_eppm_database_admin\\93081.htm");
Page[25]=new Array("The Migrate Database wizard is a java-based tool that enables you to migrate data between relational database management systems (RDBMS). For example, you can use the Migrate Database wizard to migrate data from a database hosted on Microsoft SQL Server to a database hosted on Oracle Database.","Note Migration to and from Oracle Autonomous Databases is not yet supported.","Use the Migrate Database wizard to:","Import data into a newly created database.","Repair a damaged database to correct database object issues (such as constraints or views).","Do not use the Migrate Database wizard to:","Convert the database type from EPPM to PPM or from PPM to EPPM (schema migration).","Upgrade from one database version to another.","Import data into an existing database.","Correct data-specific issues.","Correct schema-related issues. It is not ideal for large databases (more than 10 GB) due to the performance of the wizard. For larger databases, try first to manually resolve schema-related issues.","Before running the Migrate Database wizard, you must first run a schema validation on the database. See Running a Schema Validation on the Database for details.","Migrating Databases<br /> (Primavera P6 EPPM Database Administration Guide for On-Premises)","English\\Admin\\p6_eppm_database_admin\\80394.htm");
Page[26]=new Array("The schema validation utility finds missing, extra, and modified schema objects for a P6 database. ","To run a schema validation, complete the following steps:","In the software download, locate the utility in the Database Download folder.","Edit the utility similar to the following:","@echo off","REM --------------------------------------","REM Run the Primavera Schema Validation Tool","REM --------------------------------------","SET JAR_FILE_DIR=lib","SET JAR_FILE_NAME=dbmt.jar","SET DB_SCHEMA=ppm","SET JVM_PROPERTIES=-Ddbmt.dbschema.package.location=%JAR_FILE_DIR% -Dprimavera.db.schema=%DB_SCHEMA% -Dcom.primavera.database.logfile=SchemaValidation.log","SET DBMT_ACTION=application/ppmschemaval","SET DBMT_COMMAND=schemavalpm","set JAVA_HOME=C:\\Program Files\\Java\\jre6","IF NOT EXIST &quot;%JAVA_HOME%\\bin\\java.exe&quot; ("," echo JAVA_HOME IS NOT SET"," pause"," goto :EXIT",")","Run validate.bat (with Windows) or validate.sh (with UNIX or Linux).","With an Oracle database in an Enterprise environment, enter values for the following:","Username: Use the appropriate ADMUSER username and password.","Database host address: Database server name or IP address.","Database host port: The port your Oracle listener is listening on. The default port is 1521.","Database name (SID): Enter the Oracle SID for your database.","Note Schema validation of Oracle Autonomous Databases is not yet supported.","With a Microsoft SQL Server database, enter values for the following:","Database host address: Database server name or IP address.","Database host port: The SQL port.","Database name: pmdb$primavera (default)","Note When running for an Enterprise version of the database, you will be prompted for the appropriate privileged and public usernames.","Review the results of the schema validation utility that display in the browser.","Running a Schema Validation on the Database<br /> (Primavera P6 EPPM Database Administration Guide for On-Premises)","English\\Admin\\p6_eppm_database_admin\\80395.htm");
Page[27]=new Array("To run the migrate database wizard, complete the following steps:","Note Begin with step 3 if your database is hosted on Microsoft SQL Server.","From the command line, fun the following and provide the password when prompted: sqlplus sys@&lt;db_tns_names_entry&gt; as sysdba","Go to p6suite\\database\\scripts\\install\\PM_&lt;release_level&gt;, and run manual_script_before_install.sql.","Go to the &lt;P6_EPPM_Home&gt;\\database folder.","Run migrate.bat (with Windows) or migrate.sh (with UNIX or Linux).","Follow the prompts on each screen to provide connection information for the source database and the target database.","Note When using an Oracle schema, the migrate database wizard allows you to create new tables or use existing tables in the target instance, but new schema users must be created through the migration process. The ability to map to existing schema users is not currently available through the migration process.","Running the Migrate Database Wizard<br /> (Primavera P6 EPPM Database Administration Guide for On-Premises)","English\\Admin\\p6_eppm_database_admin\\80397.htm");
Page[28]=new Array("The Migrate Database Wizard allows you to migrate between relational database management systems, that is:","from SQL Server to Oracle","from Oracle to SQL Server","from one Oracle server to another","from one SQL server to another","Note Migration to and from Oracle Autonomous Databases is not yet supported.","You cannot use the migrate database wizard to convert the database type from EPPM to PPM or from PPM to EPPM. To convert the database type between PM and EPPM databases, use the process described for migrating the database schema.","To run the migrate database wizard from the command line, complete the following steps:","Open a new command line console.","Go to \\install\\database.","Run the command with the following parameters to define the migration:","With Windows","migrate.bat -source sa/sa@sqlserver:rcgsrv:1433:vader_pmdb -target system/manager@oracle:rcgsrv:1521:rcg02 -db PM","With Windows (Creating Non-Default Oracle Users)","migrate.bat -source sa/sa@sqlserver:rcgsrv:1433:vader_pmdb -target system/manager@oracle:rcgsrv:1521:rcg02 -db PM -&lt;admuser&gt; &lt;admuser password&gt; -&lt;privuser&gt; &lt;privuser password&gt; -&lt;pubuser&gt; &lt;pubuser password&gt;","With UNIX or Linux","sh migrate.sh -source sa/sa@sqlserver:saumverm-lap\\primavera:1433:PMDB -dattbsp &lt;Name of data tblspc at target&gt; -ndxtbsp &lt;Name of index tblspc at target&gt; -pxtbsp &lt;Name of px tblspc at target&gt; -lobtbsp &lt;Name of LOB tblspc at target&gt; -&lt;admuser&gt; &lt;admuser at target&gt; -&lt;admuser password&gt; &lt;admuser password at target&gt; -&lt;privuser&gt; &lt;privuser at target&gt; -&lt;privuser password&gt; &lt;privuser password at target&gt; -pubuser &lt;pubuser at target&gt; -&lt;pubuser password&gt; &lt;pubuser password at target&gt; -&lt;pxrptuser&gt; &lt;pxrptuser at target&gt; -&lt;pxrptuser password&gt; &lt;pxrptuser password at target&gt; -&lt;bgjobuser&gt; &lt;bgjobuser at target&gt; -&lt;bgjobuser password&gt; &lt;bgjobuser password at target&gt; -target system/admin@oracle:oldb-orcl:1521:PMDB","For example:","sh migrate.sh -source sa/sa@sqlserver:saumverm-lap\\primavera:1433:PMDB -dattbsp PMDB_DAT1 -ndxtbsp PMDB_NDX1 -pxtbsp PMDB_PX_DAT1 -lobtbsp PMDB_LOB1 -admuser admuser -admpass admuser -privuser privuser -privpass privuser -pubuser pubuser -pubpass pubuser -pxrptuser pxrptuser -pxrptpass pxrptuser -bgjobuser bgjobuser -bgjobpass bgjobuser -target system/admin@oracle:oldb-orcl:1521:PMDB","Running the Migrate Database Wizard From the Command Line<br /> (Primavera P6 EPPM Database Administration Guide for On-Premises)","English\\Admin\\p6_eppm_database_admin\\80398.htm");
Page[29]=new Array("The schema migration process creates a copy of an existing source P6 EPPM or P6 Professional database and then modifies the database objects for the target database. Because the source database is not being modified, you do not need to backup your database before attempting to migrate your schema.","Note Schema migration to and from Oracle Autonomous Databases is not yet supported.","Tip","You should migrate your schema at a time when no database transactions occur.","Migrating Database Schemas<br /> (Primavera P6 EPPM Database Administration Guide for On-Premises)","English\\Admin\\p6_eppm_database_admin\\92981.htm");
Page[30]=new Array("In order to migrate schema between P6 EPPM and P6 Professional, you must be on the same version of both applications.","If you are using Oracle for your RDBMS, ensure that you have completed the following prerequisites before attempting to migrate your schema:","Create an empty Oracle database for your target database.","Set the open_cursors system parameter to a value of 1000 or greater depending on the size of your source database.","Run the manual_script_before_install.sql script from the P6 EPPM or P6 Professional installation folder on your target database. Alternatively, if you are migrating your schema to P6 Professional, you can run the following script on the P6 Professional database:","GRANT SELECT ON sys.DBA_EXTENTS ","TO SYSTEM with grant option;","If you are using Microsoft SQL Server for your RDBMS, you must enable FILESTREAM.","Prerequisites for Schema Migration<br /> (Primavera P6 EPPM Database Administration Guide for On-Premises)","English\\Admin\\p6_eppm_database_admin\\92979.htm");
Page[31]=new Array("To migrate your P6 EPPM schema to P6 Professional:","Open the Migrate Database wizard by completing the following:","Navigate to the database folder of your P6 EPPM installation. For example, C:\\P6EPPM_1\\database\\ (with Windows) or /u01/P6EPPM_1/database/ (with UNIX or Linux).","Run migrate.bat (with Windows) or migrate.sh (with UNIX or Linux). ","Note After each step, click Next.","On the Select Migration Type screen, select Schema Migration.","On the Select Source screen, select Oracle.","On the Connection Information screen, enter the connection details for the source database and private database user.","On the Select Target screen, select Oracle.","On the Connection Information screen, enter the connection details for the target database and system database user.","On the Configure Oracle Tablespaces screen, complete one of the following steps:","If you want to use the existing P6 EPPM tablespaces for P6 Professional, select Use existing tablespaces and then select the tablespace names from the lists.","If you want to create new tablespaces for P6 Professional, enter the tablespace names and sizes in the tablespace name and tablespaces size (M) fields.","Note If you chose to use an existing tablespace, omit the next step.","On the Specify Oracle Tablespace Location screen, enter the location at which you want to create each tablespace and then click Create.","On the Create Oracle Users screen, in the User Name, Password, and Confirm Password fields, enter the credentials for each database user.","On the Migrate Options screen, enter the size of the batch that will be used for the SQL insert of P6 data into the P6 Professional database.","Migrating P6 EPPM Schema to P6 Professional with Oracle Database<br /> (Primavera P6 EPPM Database Administration Guide for On-Premises)","English\\Admin\\p6_eppm_database_admin\\92956.htm");
Page[32]=new Array("To migrate your P6 EPPM schema to P6 Professional:","Open the Migrate Database wizard by completing the following:","Navigate to the database folder of your P6 EPPM installation. For example, C:\\P6EPPM_1\\database\\ (with Windows) or /u01/P6EPPM_1/database/ (with UNIX or Linux).","Run migrate.bat (with Windows) or migrate.sh (with UNIX or Linux). ","Note After each step, click Next.","On the Select Migration Type screen, select Schema Migration.","On the Select Source screen, select Microsoft SQL Server.","On the Connection Information screen, enter the connection details for the source SQL Server database and the administrative database user.","On the Select Target screen, select Microsoft SQL Server.","On the Connection Information screen, enter the connection details for the target SQL Server database and the sys admin database user.","On the Configure Database Users screen, complete one of the following steps:","If you want to use the existing P6 EPPM users for P6 Professional, complete the following:","Select the Use Existing check box. ","In each User Name list, select the username of the database user.","In each Password field, enter the password for each database user.","If you want to create database users for P6 Professional:","Enter the login credentials for each database user in the User Name, Password, and Confirm Password fields.","On the Configure Microsoft SQL Server/SQL Express Database screen, enter the required information in the Database name, Data file, Log file, and Database code page for the P6 Professional schema.","On the Migrate Options screen, enter the size of the batch that will be used for the SQL insert of P6 data into the P6 Professional database.","Migrating P6 EPPM Schema to P6 Professional with Microsoft SQL Server<br /> (Primavera P6 EPPM Database Administration Guide for On-Premises)","English\\Admin\\p6_eppm_database_admin\\92989.htm");
Page[33]=new Array("The utility that you can use to create or update the configuration settings for P6 EPPM in Primavera P6 Administrator is the Database Configuration Wizard.","When either creating or updating P6 EPPM configurations, the Database Configuration Wizard updates the admin_config table in the P6 EPPM database and modifies the BREBootStrap.xml file.","The Database Configuration Wizard can be accessed by running dbconfigpv.bat (with Windows) dbconfigpv.sh (with UNIX or Linux) at &lt;P6_EPPM_Home&gt;/p6.","Where: &lt;P6_EPPM_Home&gt; is the P6 EPPM home directory that was set during installation.","For more information about creating configurations, refer to Creating P6 EPPM Configurations.","For more information about updating configurations, refer to Updating P6 EPPM Configurations.","Creating and Updating P6 EPPM Configurations<br /> (Primavera P6 EPPM Database Administration Guide for On-Premises)","English\\Admin\\p6_eppm_database_admin\\93085.htm");
Page[34]=new Array("You would want to create a configuration if you are manually installing and configuring P6 EPPM for the first time, or if you want to create additional configurations other than the one created by the P6 EPPM Configuration Wizard. The default name of the configuration created by the P6 EPPM Configuration Wizard is &quot;Primavera P6 Configuration&quot;.","To create a P6 EPPM configuration:","Run dbconfigpv.cmd (with Windows) dbconfigpv.sh (with UNIX or Linux) at &lt;P6_EPPM_Home&gt;/p6. The Database Configuration Wizard opens.","Where: &lt;P6_EPPM_Home&gt; is the P6 EPPM home directory that was set during installation.","Note Click Next after each of the following steps.","On the Setup and Configuration of the Primavera P6 Database screen, select your database type.","On the Please enter the following information... screen:","Enter the public user credentials.","The default public username is pubuser.","Enter the connection details for your database.","For an Oracle or Microsoft SQL database, enter the connection details for your Oracle or Microsoft SQL database.","For an Oracle Autonomous Database:","In the Database Name field, enter the service name of your Oracle Autonomous Database instance.","In the Database Unzipped Wallet Location field, enter the location and name of the unzipped wallet file.","On the What would you like to do? screen, select Create a new configuration and enter a name for the configuration in the field.","On the Configuration of the Primavera P6 database completed successfully screen, click OK.","Creating P6 EPPM Configurations<br /> (Primavera P6 EPPM Database Administration Guide for On-Premises)","English\\Admin\\p6_eppm_database_admin\\93104.htm");
Page[35]=new Array("You would want to update your P6 EPPM configurations using the Database Configuration Wizard if you are manually upgrading P6 EPPM from an earlier release to the current release. ","To update an existing P6 EPPM configuration:","Run dbconfigpv.cmd (with Windows) dbconfigpv.sh (with UNIX or Linux) at &lt;P6_EPPM_Home&gt;/p6. The Database Configuration Wizard opens.","Where: &lt;P6_EPPM_Home&gt; is the P6 EPPM home directory that was set during installation.","Note Click Next after each of the following steps.","On the Setup and Configuration of the Primavera P6 Database screen, select your database type.","On the Please enter the following information... screen:","Enter the public user credentials.","The default public username is pubuser.","Enter the connection details for your database.","For an Oracle or Microsoft SQL database, enter the connection details for your Oracle or Microsoft SQL database.","For an Oracle Autonomous Database:","In the Database Name field, enter the service name of your Oracle Autonomous Database instance.","In the Database Unzipped Wallet Location field, enter the location and name of the unzipped wallet file.","On the What would you like to do? screen, select Use an Existing configuration and then select a configuration from the drop down list.","On the Configuration of the Primavera P6 database completed successfully screen, click OK.","Repeat the previous steps to update other configurations to the current release.","Updating P6 EPPM Configurations<br /> (Primavera P6 EPPM Database Administration Guide for On-Premises)","English\\Admin\\p6_eppm_database_admin\\93105.htm");
Page[36]=new Array("Use the Primavera Database Setup Wizard to install or upgrade the P6 EPPM database.","For more information about installing a P6 EPPM database, see one of the following:","Installing a P6 EPPM Database with Oracle","Installing a P6 EPPM Database with Oracle Autonomous Database","Installing a P6 EPPM Database with Microsoft SQL Server","For more information about upgrading a P6 EPPM database, see one of the following:","Upgrading a P6 EPPM Database with Oracle Database","Upgrading a P6 EPPM Database with Oracle Autonomous Database","Upgrading a P6 EPPM Database with Microsoft SQL Server","Setting Up the P6 EPPM Database<br /> (Primavera P6 EPPM Database Administration Guide for On-Premises)","English\\Admin\\p6_eppm_database_admin\\93108.htm");
Page[37]=new Array("If you want to manually install P6 EPPM, you should install a P6 EPPM database using the Primavera Database Setup Wizard.","To install a P6 EPPM database using the Primavera Database Setup Wizard:","To open the Primavera Database Setup Wizard, run dbsetup.bat (with Windows) dbsetup.sh (with UNIX or Linux) at &lt;P6_EPPM_Home&gt;/database where &lt;P6_EPPM_Home&gt; is the P6 EPPM home directory that was set during installation.","Note Click Next after each of the following steps.","On the Primavera P6 screen, complete the following:","Select Install a new database.","Select Oracle.","Note Create Read Only User is only intended for use with cloud installations of the application.","On the Connection Information screen, enter the connection details for an Oracle database using system credentials.","On the Create New Keystore screen, complete one of the following:","If you want to use an existing keystore, enter the password in the Existing Keystore Password field.","If you are creating a new keystore, do the following:","Select Create New Keystore.","In the Enter Keystore Password field, enter a password for the new keystore.","In the Confirm Keystore Password field, enter the new password again for verification.","If you do not want to create a keystore and you do not have an existing keystore, ensure all fields are clear.","On the Configure Oracle Tablespaces screen, enter a name for each tablespace and modify the tablespace size (M) if necessary.","On the Specify Oracle Tablespace Location screen, enter the location at which you want to create each tablespace and then click Create.","On the Create Oracle Users screen in the User Name, Password, and Confirm Password fields, modify the database user names and enter the credentials for each database user.","On the Configuration Options screen, complete the following:","Enter a name and password for an administrative application user.","Choose whether or not you want to load sample data.","Select your currency from the Currency list.","If synchronizing P6 EPPM and Oracle Primavera Cloud select Use Oracle Database Partitioning Option(separately licensed) to improve synchronization performance.","Click Install.","Installing a P6 EPPM Database with Oracle<br /> (Primavera P6 EPPM Database Administration Guide for On-Premises)","English\\Admin\\p6_eppm_database_admin\\93110.htm");
Page[38]=new Array("If you want to manually install P6 EPPM, you should install a P6 EPPM database using the Primavera Database Setup Wizard.","To install a P6 EPPM database using the Primavera Database Setup Wizard:","To open the Primavera Database Setup Wizard, run dbsetup.bat (with Windows) dbsetup.sh (with UNIX or Linux) at &lt;P6_EPPM_Home&gt;/database where &lt;P6_EPPM_Home&gt; is the P6 EPPM home directory that was set during installation.","Note Click Next after each of the following steps.","On the Primavera P6 screen, complete the following:","Select Install a new database.","Select Oracle Autonomous Database (ATP). ","Note Create Read Only User is only intended for use with cloud installations of the application.","Click Next.","On the Connection Information screen:","Enter the DBA user name and DBA password.","Click Browse, browse to and select the wallet zip file.","In the Database services list, select the service you want to use.","Note Oracle recommends using one of the autonomous database services with Parallel Data Manipulation Language (DML) disabled when creating the P6 EPPM schema on Oracle 19c. Parallel DML is disabled in the following services: TP, TPURGENT, and LOW. Using the MEDIUM or HIGH services with parallel DML enabled will cause dbsetup.bat to fail with an error code of either ORA-12838 or ORA-12839.","Click Next.","On the Create Oracle ATP Users screen in the User Name, Password, and Confirm Password fields, modify the database user names and enter the credentials for each database user.","On the Configuration Options screen, complete the following:","Enter a name and password for an administrative application user.","Choose whether or not you want to load sample data.","Choose whether or not you want to se Oracle Database Partitioning.","Select your currency from the Currency list.","Click Install.","Installing a P6 EPPM Database with Oracle Autonomous Database<br /> (Primavera P6 EPPM Database Administration Guide for On-Premises)","English\\Admin\\p6_eppm_database_admin\\102506.htm");
Page[39]=new Array("If you choose to use the HIGH or MEDIUM services for Oracle Autonomous Database on Oracle 19c, you must modify the orpm_admuser.sql script to disable Parallel Data Manipulation Language (Parallel DML) before you run dbsetup.bat. If Parallel DML is not disabled, dbsetup.bat will fail with an error code of either ORA-12838 or ORA-12839. ","To disable Parallel DML in the orpm_admuser.sql script:","Browse to the database directory where dbsetup resides, then open the lib directory.","Open DBS_PM_&lt;release_level&gt;.jar in an archive extraction utility.","Within the archive extraction utility:","Go to \\install\\PM_&lt;release_level&gt;.","Copy orpm_admuser.sql to a local drive.","Open the local copy of orpm_admuser.sql in a text editor.","Add following lines to the top of the orpm_admuser.sql script:","alter session disable parallel dml","/","Save your changes, then close the text editor.","Copy the modified script back into the DBS_PM_&lt;release_level&gt;.jar file.","Disabling Parallel DML for Oracle Autonomous Database on Oracle 19c<br /> (Primavera P6 EPPM Database Administration Guide for On-Premises)","English\\Admin\\p6_eppm_database_admin\\102794.htm");
Page[40]=new Array("If you want to manually install P6 EPPM, you should install a P6 EPPM database using the Primavera Database Setup Wizard.","To install a P6 EPPM database using the Primavera Database Setup Wizard:","To open the Primavera Database Setup Wizard, run dbsetup.bat (with Windows) dbsetup.sh (with UNIX or Linux) at &lt;P6_EPPM_Home&gt;/database where &lt;P6_EPPM_Home&gt; is the P6 EPPM home directory that was set during installation.","Note Click Next after each of the following steps.","On the Primavera P6 screen, complete the following:","Select Install a new database.","Select Microsoft SQL Server.","On the Connection Information screen, enter the connection details for a Microsoft SQL Server database and the administrative database user.","On the Configure Microsoft SQL Server screen, complete the following:","Enter the name of the P6 EPPM database. ","Enter the location of the Data and Log files.","Select the database code page. The default is Database default.","Enter the location of the keystore. ","On the Create New Keystore screen, complete one of the following:","If you want to use an existing keystore, enter the password in the Existing Keystore Password field.","If you are creating a new keystore, do the following:","Select Create New Keystore.","In the Enter Keystore Password field, enter a password for the new keystore.","In the Confirm Keystore Password field, enter the new password again for verification.","If you do not want to create a keystore and you do not have an existing keystore, ensure all fields are clear.","On the Create SQL Server Users screen, complete one of the following steps:","If you want to use the existing P6 EPPM users for P6 Professional, complete the following:","Select the Use Existing check box. ","In each User Name list, select the username of the database user.","In each Password field, enter the password for each database user.","If you want to create database users for P6 Professional, enter the login credentials for each database user in the User Name, Password, and Confirm Password fields.","On the Configuration Options screen, complete the following:","Enter a name and password for an administrative application user.","Choose whether or not you want to load sample data.","Select your currency from the Currency list.","Click Install.","Installing a P6 EPPM Database with Microsoft SQL Server<br /> (Primavera P6 EPPM Database Administration Guide for On-Premises)","English\\Admin\\p6_eppm_database_admin\\93109.htm");
Page[41]=new Array("If you want to manually upgrade P6 EPPM, you should upgrade your P6 EPPM database using the Primavera Database Setup Wizard.","To upgrade a P6 EPPM database using the Primavera Database Setup Wizard:","To open the Primavera Database Setup Wizard, run dbsetup.bat (with Windows) dbsetup.sh (with UNIX or Linux) at &lt;P6_EPPM_Home&gt;/database where &lt;P6_EPPM_Home&gt; is the P6 EPPM home directory that was set during installation.","Note Click Next after each of the following steps.","On the Primavera P6 screen, complete the following:","Select Upgrade an existing database.","Select Oracle.","On the Connection Information screen, enter the connection details for an Oracle database using system credentials.","On the Create New Keystore screen, do one of the following:","If you want to use an existing keystore, enter the password in the Existing Keystore Password field.","If you are creating a new keystore, do the following:","Select Create New Keystore.","In the Enter Keystore Password field, enter a password for the new keystore.","In the Confirm Keystore Password field, enter the new password again for verification.","If you do not want to create a keystore and you do not have an existing keystore, ensure all fields are clear.","On the Configure Oracle Tablespaces screen, enter the credentials for the administrative user. The default is admuser.","On the Upgrade Options screen, enter the credentials for the privileged, public, and background user. The defaults are privuser, pubuser, and bgjobuser.","On the Ready to Begin Upgrading Data screen, select Yes, upgrade my database.","Upgrading a P6 EPPM Database with Oracle Database<br /> (Primavera P6 EPPM Database Administration Guide for On-Premises)","English\\Admin\\p6_eppm_database_admin\\93111.htm");
Page[42]=new Array("If you want to manually upgrade P6 EPPM, you should upgrade your P6 EPPM database using the Primavera Database Setup Wizard.","To upgrade a P6 EPPM database using the Primavera Database Setup Wizard:","To open the Primavera Database Setup Wizard, run dbsetup.bat (with Windows) dbsetup.sh (with UNIX or Linux) at &lt;P6_EPPM_Home&gt;/database where &lt;P6_EPPM_Home&gt; is the P6 EPPM home directory that was set during installation.","Note Click Next after each of the following steps.","On the Primavera P6 screen, complete the following:","Select Upgrade an existing database.","Select Oracle Autonomous Database (ATP).","On the Connection Information screen:","Enter the DBA user name and DBA password.","Click Browse, browse to and select the wallet zip file.","In the Database services list, select the service that connects to the database you want to upgrade.","Click Next.","On the Create New Keystore screen, do one of the following:","If you want to use an existing keystore, enter the password in the Existing Keystore Password field.","If you are creating a new keystore, do the following:","Select Create New Keystore.","In the Enter Keystore Password field, enter a password for the new keystore.","In the Confirm Keystore Password field, enter the new password again for verification.","If you do not want to create a keystore and you do not have an existing keystore, ensure all fields are clear.","On the Configure Oracle Tablespaces screen, enter the credentials for the administrative user. The default is admuser.","On the Upgrade Options screen, enter the credentials for the privileged, public, and background user. The defaults are privuser, pubuser, and bgjobuser.","On the Ready to Begin Upgrading Data screen, select Yes, upgrade my database.","Upgrading a P6 EPPM Database with Oracle Autonomous Database<br /> (Primavera P6 EPPM Database Administration Guide for On-Premises)","English\\Admin\\p6_eppm_database_admin\\102508.htm");
Page[43]=new Array("If you want to manually upgrade P6 EPPM, you should upgrade your P6 EPPM database using the Primavera Database Setup Wizard.","To upgrade a P6 EPPM database using the Primavera Database Setup Wizard:","To open the Primavera Database Setup Wizard, run dbsetup.bat (with Windows) dbsetup.sh (with UNIX or Linux) at &lt;P6_EPPM_Home&gt;/database where &lt;P6_EPPM_Home&gt; is the P6 EPPM home directory that was set during installation.","Note Click Next after each of the following steps.","On the Primavera P6 screen, complete the following:","Select Upgrade an existing database.","Select Microsoft SQL Server.","On the Connection Information screen, enter the connection details for a Microsoft SQL Server database and the administrative database user.","On the Create New Keystore screen, do one of the following:","If a you want to use an existing keystore, enter the password in the Existing Keystore Password field.","If you are creating a new keystore, do the following:","Select Create New Keystore.","In the Enter Keystore Password field, enter a password for the new keystore.","In the Confirm Keystore Password field, enter the new password again for verification.","If you do not want to create a keystore and you do not have an existing keystore, ensure all fields are clear.","On the Upgrade Option screen, enter the credentials for the Px Reporting user. The default is pxrptuser.","On the Ready to Begin Upgrading Data screen, select Yes, upgrade my database.","Upgrading a P6 EPPM Database with Microsoft SQL Server<br /> (Primavera P6 EPPM Database Administration Guide for On-Premises)","English\\Admin\\p6_eppm_database_admin\\93112.htm");
Page[44]=new Array("Caution You cannot change the base currency once projects begin.","After manually creating and configuring the P6 EPPM database, you must change the base currency if you do not want the databases to use US dollars ($) as the base currency.","Changing the Database Base Currency<br /> (Primavera P6 EPPM Database Administration Guide for On-Premises)","English\\Admin\\p6_eppm_database_admin\\6825.htm");
Page[45]=new Array("The base currency is the monetary unit used to store cost data for all projects in the database and is controlled by a global administrative setting. The default base currency for P6 EPPM is US dollars ($). The view currency is the monetary unit used to display cost data in P6 EPPM and is controlled by a user preference.","The&nbsp;exchange rate for the base currency is always 1.0. When a user selects a different currency than the base currency to view cost data, the base currency value is multiplied times the current exchange rate for the view currency to calculate the values displayed in cost and price fields.","For example, if the base currency is US Dollars, the view currency is Euros, and the exchange rate for Euros is $1 = 0.75, a value of $10 stored in the database is displayed as 7.5 in cost and price fields. Similarly, if you enter 7.5 in a cost or price field, it is stored in the database as $10.","When data is displayed in a view currency that is different than the base currency, some cost and price values can vary slightly (e.g., due to rounding). As long as the correct base currency is selected during database installation, a user can view completely accurate cost and price data by changing the view currency to match the base currency.","The Base Currency<br /> (Primavera P6 EPPM Database Administration Guide for On-Premises)","English\\Admin\\p6_eppm_database_admin\\12803.htm");
Page[46]=new Array("To change the base currency you need to edit and run the P6 EPPM script provided. By default, US dollars is the base currency, and USD is the short name used in the script. To know which short name to use, review the list of available short names for P6 EPPM by running the following query on the P6 EPPM database:","select curr_type, curr_short_name from currtype;","Reviewing Currency Choices<br /> (Primavera P6 EPPM Database Administration Guide for On-Premises)","English\\Admin\\p6_eppm_database_admin\\32697.htm");
Page[47]=new Array("To change the base currency:","On the P6 EPPM physical media or download:","Browse to \\Database\\scripts\\common. ","Copy this script to a local drive:","or_set_currency.sql","If you copied the script from the physical media, turn off the script's read-only attribute.","Since files on physical media are read-only, this attribute turns on when you copy a file from a CD or DVD. ","In Windows Explorer, right-click the file.","Choose Properties.","Clear the Read-Only option.","Open the script for editing and locate the line containing v_new_base_currency: = &#8216;USD'","Replace USD with the currency short name of your choice.","Save your changes and run the modified script.","Changing the Base Currency<br /> (Primavera P6 EPPM Database Administration Guide for On-Premises)","English\\Admin\\p6_eppm_database_admin\\32698.htm");
Page[48]=new Array("The P6 server and P6 Professional components obtain their run-time database connection credentials from a credential configuration table in the P6 EPPM database. The P6 run-time database credentials (known as privuser or P6 private database login) are stored in an encrypted format in this special P6 configuration table. Any time that you change or rotate the privuser password credentials in your Oracle, Oracle Autonomous Database, or MS SQL Server database, you must re-synchronize the stored credentials in the P6 credential table by using the Database Login tool.","Because encryption algorithms are often enhanced in newer releases, Oracle highly recommends that you reset these stored privuser credentials when you perform a major version upgrade of P6 EPPM. By resetting the stored credentials, the new encryption algorithm can be applied to other stored credentials (for example, pubuser) in the P6 EPPM credential table. For information about resetting private database passwords, see Resetting Private Database Passwords.","Note","This tool does not reset database user logins or passwords. Administrators should use SQL Developer or other DBA consoles to set or reset database user passwords.","Private Database Credentials for P6 EPPM<br /> (Primavera P6 EPPM Database Administration Guide for On-Premises)","English\\Admin\\p6_eppm_database_admin\\43428.htm");
Page[49]=new Array("Password encryption algorithms are frequently improved in new releases of P6 Professional and P6 Professional. You should reset private database passwords in order to use improved password encryption algorithms.","To reset private database passwords to use the new encryption algorithm:","Go to P6 EPPM &lt;release_level&gt;\\database or P6 Professional &lt;release_level&gt;\\database.","Run databaselogins.bat (with Windows) databaselogins.sh (with UNIX or Linux).","In the Database Connection dialog box:","Select the database.","Type the user name and password of a privileged database user (for example, privuser). This login should have administrative rights on the database.","Enter the connection details for the database.","For an Oracle Database, enter the host address, host port, and database/instance name specific to your installation. The Port field displays the default port for the database type you selected.","For an Oracle Autonomous Database, enter the location of the unzipped wallet file and the service name.","For a Microsoft SQL Server Database, enter the host address, host port, and database/instance name specific to your installation. The Port field displays the default port for the database type you selected.","Click Next.","In the Private Database Logins dialog box:","Select the private database user name that you wish to reset.","Highlight the password and change it (or re-enter the existing password).","Click Update Password.","Click Save.","Click OK.","Resetting Private Database Passwords<br /> (Primavera P6 EPPM Database Administration Guide for On-Premises)","English\\Admin\\p6_eppm_database_admin\\46563.htm");
Page[50]=new Array("You can add private database users to your P6 EPPM database. ","To add private database logins for P6 EPPM:","Go to P6 EPPM &lt;release_level&gt;\\database and run databaselogins.bat (with Windows) databaselogins.sh (with UNIX or Linux).","On the Database Connection dialog box:","Select the database.","Type the user name and password of a privileged database user (for example, privuser). This login should have administrative rights on the database.","Enter the connection details for the database.","For an Oracle Database, enter the host address, host port, and database/instance name specific to your installation. The Port field displays the default port for the database type you selected.","For an Oracle Autonomous Database, enter the location of the unzipped wallet file and the service name.","For a Microsoft SQL Server Database, enter the host address, host port, and database/instance name specific to your installation. The Port field displays the default port for the database type you selected.","Click Next.","On the Private Database Logins dialog box:","Click Add.","Enter a user name.","Enter a password.","Note To reverse a change, click Undo. Undo will reverse any changes made during the current session.","Click Save.","Click OK to exit.","Adding Private Database Logins for P6 EPPM<br /> (Primavera P6 EPPM Database Administration Guide for On-Premises)","English\\Admin\\p6_eppm_database_admin\\46566.htm");
Page[51]=new Array("You can update the passwords and usernames of the private database users on your P6 EPPM database. ","To modify private database logins:","Go to P6 EPPM &lt;release_level&gt;\\database and run databaselogins.bat (with Windows) databaselogins.sh (with UNIX or Linux).","On the Database Connection dialog box:","Select the database.","Type the user name and password of a privileged database user (for example, privuser). This login should have administrative rights on the database.","Enter the connection details for the database.","For an Oracle Database, enter the host address, host port, and database/instance name specific to your installation. The Port field displays the default port for the database type you selected.","For an Oracle Autonomous Database, enter the location of the unzipped wallet file and the service name.","For a Microsoft SQL Server Database, enter the host address, host port, and database/instance name specific to your installation. The Port field displays the default port for the database type you selected.","Click Next.","On the Private Database Logins dialog box:","Select the private database user name that you wish to modify.","Enter a new user name.","Highlight the password, and change it.","Click the Update Password button.","Note To reverse a change, click Undo. Undo will reverse any changes made during the current session.","Click Save.","Click OK to exit the Database Logins tool.","Modifying Private Database Logins for P6 EPPM<br /> (Primavera P6 EPPM Database Administration Guide for On-Premises)","English\\Admin\\p6_eppm_database_admin\\46565.htm");
Page[52]=new Array("If you no longer need your private database users you can delete them. ","To delete private database logins for P6 EPPM:","Go to P6 EPPM &lt;release_level&gt;\\database and run databaselogins.bat (with Windows) databaselogins.sh (with UNIX or Linux).","On the Database Connection dialog box:","Select the database.","Type the user name and password of a privileged database user (for example, privuser). This login should have administrative rights on the database.","Enter the connection details for the database.","For an Oracle Database, enter the host address, host port, and database/instance name specific to your installation. The Port field displays the default port for the database type you selected.","For an Oracle Autonomous Database, enter the location of the unzipped wallet file and the service name.","For a Microsoft SQL Server Database, enter the host address, host port, and database/instance name specific to your installation. The Port field displays the default port for the database type you selected.","Click Next.","On the Private Database Logins dialog box:","Select the private database user name that you wish to remove.","NoteYou must have at least one private user name for the P6 EPPM database at all times.","Click Delete.","Note To reverse a change, click Undo. Undo will reverse any changes made during the current session.","Click Save.","Click OK to exit the Database Logins tool.","Deleting Private Database Logins for P6 EPPM<br /> (Primavera P6 EPPM Database Administration Guide for On-Premises)","English\\Admin\\p6_eppm_database_admin\\46567.htm");
Page[53]=new Array("Background jobs handle the maintenance of the utilities tables (for example, USESSION and REFRDEL). As a part of background jobs, the agent runs the SYMON and DAMON stored procedures at specific intervals.","Background jobs are initiated by the job scheduler supplied by the RDBMS, therefore you must ensure that the scheduler for your specific RDBMS is properly configured.","With Oracle or Oracle Autonomous Database: P6 EPPM uses DBMS_SCHEDULER to schedule background jobs.","With Microsoft SQL Server: P6 EPPM uses the SQL Agent service to automatically schedule background job execution.","RDBMS Scheduler Configuration<br /> (Primavera P6 EPPM Database Administration Guide for On-Premises)","English\\Admin\\p6_eppm_database_admin\\21473.htm");
Page[54]=new Array("Settings Table Overview","The settings table contains name-value pairs that configure the behavior of the background processes.","Namespace","The namespace component is a dot-notation string representing a formal path to the parameter.","Setting Name","The setting name identifies the name of the setting.","Value","Values in the SETTINGS table are case-sensitive. The value portion of the pair can be:","String: The string data type is a free text value. The most common string sub-type is interval which represents an interval of time by combining a numeric portion with a unit portion as depicted in the table below.","Interval Subtype Table","Unit portion","Example","Meaning","Numeric portion","+","d","&#8216;30d'","Thirty day interval","h","&#8216;2h'","Two hour interval","m","&#8216;10m'","Ten minute interval","s","&#8216;30s'","Thirty second interval","Numeric: The numeric data type consists of any number.","Boolean: The Boolean data type can have one of two values: true or false, where zero represents false and any non-zero number represents true.","Date: The date data type consists of dates.","Setting Example","The following is an example of a setting:","Namespace: database.cleanup.Usession","Setting Name: ExpiredSessionTimeout","Value: 2h (two hour interval)","Database Settings Table<br /> (Primavera P6 EPPM Database Administration Guide for On-Premises)","English\\Admin\\p6_eppm_database_admin\\6854.htm");
Page[55]=new Array("You can configure settings through the Settings API Procedures. These procedures are similar to registry or INI file procedure calls.","Reading Settings Values","Use the following SETTINGS_READ_* procedures to determine the current value of specific settings:","SETTINGS_READ_STRING(ret_val,namespace,settings_name,default)","SETTINGS_READ_DATE(ret_val,namespace,settings_name,default)","SETTINGS_READ_NUMBER(ret_val,namespace,settings_name,default)","SETTINGS_READ_BOOL(ret_val,namespace,settings_name,default)","Reading Setting Values<br /> (Primavera P6 EPPM Database Administration Guide for On-Premises)","English\\Admin\\p6_eppm_database_admin\\6855.htm");
Page[56]=new Array("The following code snippets demonstrate how the SETTINGS_READ_* procedures read the setting values with Oracle or Oracle Autonomous Database.","To retrieve the value of the KeepInterval setting:","Use the following code:","SQL&gt; variable vset varchar2(255)","SQL&gt; exec settings_read_string(:vset,'database.cleanup.Usession',<br />'ExpiredSessionTimeout');","2. The following message should appear:","PL/SQL procedure successfully completed.","SQL&gt; print vset","Using Code to Read Setting Values with Oracle or Oracle Autonomous Database<br /> (Primavera P6 EPPM Database Administration Guide for On-Premises)","English\\Admin\\p6_eppm_database_admin\\21476.htm");
Page[57]=new Array("The following code snippets demonstrate how the SETTINGS_READ_* procedures read the setting values with Microsoft SQL Server.","To retrieve the value of the KeepInterval setting:","Use the following code:","declare @vset varchar(255)","exec settings_read_string @vset OUTPUT,'database.cleanup.Usession','ExpiredSessionTimeout'","print @vset","The following message should appear:","PL/SQL procedure successfully completed.","SQL&gt; print vset","Using Code to Read Setting Values with Microsoft SQL Server<br /> (Primavera P6 EPPM Database Administration Guide for On-Premises)","English\\Admin\\p6_eppm_database_admin\\21478.htm");
Page[58]=new Array("Use the SETTINGS_WRITE_STRING procedure to set the value of a specific setting:","SETTINGS_WRITE_STRING(new value,namespace,settings_name);","Writing Setting Values<br /> (Primavera P6 EPPM Database Administration Guide for On-Premises)","English\\Admin\\p6_eppm_database_admin\\21474.htm");
Page[59]=new Array("The following code snippets demonstrate how the SETTINGS_WRITE_STRING procedure sets the value of the ExpiredSessionTimeout setting to 12 hours.","To set the value of the ExpiredSessionTimeout setting to 12 hours:","Log in to SQL*Plus with your privuser credentials.","Run the following statement:","SQL &gt; exec SETTINGS_WRITE_STRING ('12h','database.cleanup.Usession','ExpiredSessionTimeout');","Using Code to Write Setting Values with Oracle or Oracle Autonomous Database<br /> (Primavera P6 EPPM Database Administration Guide for On-Premises)","English\\Admin\\p6_eppm_database_admin\\21479.htm");
Page[60]=new Array("The following code snippets demonstrate how the SETTINGS_WRITE_STRING procedure sets the value of the ExpiredSessionTimeout setting to 12 hours with Microsoft SQL Server.","To set the value of the ExpiredSessionTimeout setting to 12 hours:","Open the Query Analyzer/SSMS and connect as privuser.","Select the P6 EPPM database, then run the following statement (using 12 hours as an example):","exec SETTINGS_WRITE_STRING&nbsp;'12h','database.cleanup.Usession',<br />'ExpiredSessionTimeout'","Using Code to Write Setting Values with Microsoft SQL Server<br /> (Primavera P6 EPPM Database Administration Guide for On-Premises)","English\\Admin\\p6_eppm_database_admin\\21480.htm");
Page[61]=new Array("You can track the execution of background jobs by monitoring the high level status settings or by inspecting the BGPLOG table.","Tracking Background Job Execution<br /> (Primavera P6 EPPM Database Administration Guide for On-Premises)","English\\Admin\\p6_eppm_database_admin\\6856.htm");
Page[62]=new Array("Each time a job runs, it will update the SETTINGS table for the setting_name&nbsp;=&nbsp;'HeartBeatTime.' The job can update this value multiple times during the execution. You can monitor the maximum difference between this time and the current date to ensure that the job is running promptly. Refer to the High Level Status Settings table below for information about the HeartBeatTime setting.","High Level Status Settings","Last date and time background job SYMON ran.","Namespace","database.background.Symon","Setting Name","HeartBeatTime","Default Setting","N/A","Last date and time background job DAMON ran.","Namespace","database.background.Damon","Setting Name","HeartBeatTime","Default Setting","N/A","High Level Status Settings<br /> (Primavera P6 EPPM Database Administration Guide for On-Premises)","English\\Admin\\p6_eppm_database_admin\\34554.htm");
Page[63]=new Array("You can also track the execution of background jobs by inspecting the BGPLOG table. The BGPLOG table holds detailed entries from the background processes including informational, elapsed time, and error entries. Refer to the BGPLOG Table Descriptions for information about what this table contains.","BGPLOG Table Descriptions","Column","Description","Value","Log_time","Time when background process made a log entry","Datetime","Source","Program generating log entry","&quot;system_monitor&quot;, &quot;data_monitor&quot;","Type","Type of message","INFORMATION, ELAPSED&nbsp;TIME, ERROR","Description","Message from the background process","A variable message followed by a number in parenthesis that represents the number of rows that processed. As an example, the message &quot;Complete BGPLOG (40)&quot; indicates that forty rows processed.","The BGPLOG Table<br /> (Primavera P6 EPPM Database Administration Guide for On-Premises)","English\\Admin\\p6_eppm_database_admin\\34555.htm");
Page[64]=new Array("PAUDIT auditing permits you to log the edits, additions, and deletions made by users of P6 EPPM applications. When users make changes, they create a Data Manipulation Language (DML) INSERT, UPDATE, or DELETE statement. PAUDIT auditing uses the Data Manipulation Language (DML) INSERT, UPDATE, or DELETE statement being processed against tables in the database schema. Since every application table in the schema has its own auditing trigger, you can log changes made to each table regardless of who made the change or when the change was made. The database schema owner owns the auditing trigger: you can bypass trigger execution.","PAUDIT Auditing<br /> (Primavera P6 EPPM Database Administration Guide for On-Premises)","English\\Admin\\p6_eppm_database_admin\\6864.htm");
Page[65]=new Array("You can adjust the amount of information that is logged by adjusting the audit level for each table. You can refine the audit further by setting the audit level individually for insert, updates, and deletes within each table.","Auditing Levels","Level","Description","Level 0","No audit.","Level 1","Row-level audit. Audit only the operation without column details","Level 2","Column-level Audit without blobs. Audit changes to the data at the column level but without blob changes","Level 3","Full Audit. Audit changes to the data at the column level.","With Oracle and Oracle Autonomous Database, column level changes to blobs are audited.","With Microsoft SQL Server, column level changes to blobs are not included.","Auditing Level Configuration<br /> (Primavera P6 EPPM Database Administration Guide for On-Premises)","English\\Admin\\p6_eppm_database_admin\\34567.htm");
Page[66]=new Array("You can use two configuration procedures to provide simple control of the auditing feature:","auditing_enable(table_name, level)","auditing_disable(table_name)","You can set the audit level on an individual table or the same audit level for all of the tables. However, the simple configuration procedures do not allow for setting individual auditing levels for insert, update, or delete operations within a table.","Oracle or Oracle Autonomous Database Examples:","Use the following examples as a guide to use the simple audit configuration procedures to control the auditing feature.","The following code snippet enables full auditing on all tables:","exec auditing_enable(null,3);","The following code snippet enables level one auditing on the task table:","exec auditing_enable('TASK',1);","The following code snippet disables auditing on PROJWBS:","exec auditing_disable('PROJWBS');","The following code snippet completely disables auditing across the entire database:","exec auditing_disable(null);","Simple Configuration<br /> (Primavera P6 EPPM Database Administration Guide for On-Premises)","English\\Admin\\p6_eppm_database_admin\\34568.htm");
Page[67]=new Array("You can configure auditing trigger behavior by changing values in the settings table that either enable or disable:","The auditing feature itself","The auditing of specific tables","The auditing of table insert, update, or delete operations within each table","Detailed Configuration<br /> (Primavera P6 EPPM Database Administration Guide for On-Premises)","English\\Admin\\p6_eppm_database_admin\\34569.htm");
Page[68]=new Array("You can enable or disable the auditing feature by using the database.audit.Enable setting. Use the settings_write_bool procedure to enable/disable the auditing feature.","Oracle or Oracle Autonomous Database Example:","To enable the auditing feature in Oracle or Oracle Autonomous Database, use the following code:","exec settings_write_bool(1,'database.audit','Enabled');","Microsoft SQL Server Example:","To enable the auditing feature in Microsoft SQL Server, use the following code:","exec settings_write_bool 1,'database.audit','Enabled'","Auditing Status<br /> (Primavera P6 EPPM Database Administration Guide for On-Premises)","English\\Admin\\p6_eppm_database_admin\\34570.htm");
Page[69]=new Array("Each table's auditing settings are controlled by the Options setting in each table's auditing namespace (for example, database.audit.TASK). The Options setting is a three character string with a numeric value in each character position representing the audit level for insert, update, and delete.","Auditing Level Options Setting by Table Operation","Operation","Insert","Update","Delete","Description","Level","0","0","0","No audit.","1","1","1","Row-level audit. Audit only the operation without column details.","2","2","2","Column-level audit without blobs. Audit changes to the data at the column level but without blob changes.","3","3","3","Full Audit. Audit changes to the data at the column level. ","With Oracle and Oracle Autonomous Database, column level changes to blobs are audited.","With Microsoft SQL Server, column level changes to blobs are not included.","The following table provides examples of the options setting:","Setting the Auditing Level Options Setting by Table Operation Examples","Namespace","Setting","Value","Description","database.audit.TASK","Options","330","Fully audit any insert and update operations. Do not audit any delete operations.","database.audit.PROJWBS","001","Row-level audit on deletes only.","database.audit.TASKRSRC","333","Fully audit.","Options Setting<br /> (Primavera P6 EPPM Database Administration Guide for On-Premises)","English\\Admin\\p6_eppm_database_admin\\34571.htm");
Page[70]=new Array("You can change table audit settings using the settings_write_string procedure.","Oracle or Oracle Autonomous Database Example:","To set the table settings to fully audit insert and update operations but ignore any delete operations, use the following code with Oracle or Oracle Autonomous Database:","exec settings_write_string('330','database.audit.TASK','Options');","Microsoft SQL Server Example:","To set the table settings to fully audit insert and update operations but ignore any delete operations, use the following code with Microsoft SQL Server:","exec settings_write_string '330','database.audit.TASK','Options'","Note Changes to auditing settings will not appear immediately in the application. The program will need to close the database connection and then reconnect to the database to get the new settings.","SETTINGS_WRITE_STRING Procedure<br /> (Primavera P6 EPPM Database Administration Guide for On-Premises)","English\\Admin\\p6_eppm_database_admin\\34572.htm");
Page[71]=new Array("Audit records are inserted into the PAUDIT table. One record is inserted into the audit table for each row changed in the database.","PAUDIT Table","Column","Type","Description","AUDIT_TS","TIMESTAMP(6)","Date and time of change","TABLE_NAME","STRING(30)","Table Name","PK1, PK2, PK3, PK4","STRING(255)","Primary key values for audited record","PROJ_ID","NUMBER","Unique object id of the audited project.","OPER","STRING(1)","I=Insert, U=Update, D=Delete","PRM_USER_NAME","STRING(32)","P6 EPPM user name if the change was made in P6 EPPM applications","AUDIT_OLD","STRING(4000)","Column changes up to 4000 characters (Level 2 and 3 only)","AUDIT_NEW","STRING(4000)","Column changes up to 4000 characters (Level 2 and 3 only)","AUDIT_EXT_OLD","BLOB","Blob changes and overflow from audit_old (Level 2 and 3 only)","AUDIT_EXT_NEW","BLOB","Blob changes and overflow from audit_new (Level 2 and 3 only)","LOGICAL_DELETE_FLAG","STRING(1)","Flag for deletes that are logical (marked) rather than a physical delete","RDBMS_USER_NAME*","STRING(255)","Database user name (usually privuser)","OS_USER_NAME*","STRING(255)","Operating system user name of connected session","Note When auditing is enabled against a SQL Server database, PAUDIT.os_user_name will always return a null value. This is because the value for os_user_name in PAUDIT table is taken from the nt_username column in master.sys.sysprocesses view and the nt_username value in master.sys.sysprocesses view is empty for the P6 Professional program because P6 is connected to SQL DB using SQL authentication. The nt_username field is filled only when we connect to SQL DB using Windows authentication.","PROGRAM*","STRING(255)","Name of program connecting to the database","HOST_NAME*","STRING(255)","Computer name of connected session","APP_NAME*","STRING(25)","Name of application connected to the database","NETADDRESS*","STRING(24)","IP or MAC address of connected session","Note Grant select privileges to the administrative user on V_$SESSION to ensure correct values for several auditing table values.","The Audit Table<br /> (Primavera P6 EPPM Database Administration Guide for On-Premises)","English\\Admin\\p6_eppm_database_admin\\34573.htm");
Page[72]=new Array("Activity for the USESSION table is audited with its own trigger and table. When an application user logs out of the system they logically delete or mark their session record in the USESSION table. One record is written to the USESSAUD table for each logout. The format of the USESSAUD table mirrors that of the USESSION table. This audit can be enabled using the usessaud_enable procedure and disabled using the usessaud_disable procedure.","Session Auditing<br /> (Primavera P6 EPPM Database Administration Guide for On-Premises)","English\\Admin\\p6_eppm_database_admin\\34575.htm");
Page[73]=new Array("The data changes for each audit are stored in the audit_info and audit_info_extended columns. The audit_info column contains all the row changes as long as they do not exceed 4000 characters. Changes over 4000 characters or any edit to a blob will be written to the audit_info_extended BLOB column.","Data in the two audit_info columns has a specific format. Each column audit within the data begins with either &quot;:O&quot; (old data) or &quot;:N&quot; (new data) to distinguish between the audit of the previous (old) or the changed (new) value (for BLOB columns the data starts with :BLOBO or :BLOBN). Directly after this is the name of the column in lowercase. Following the column name is the length of the audited value in a fixed four character field. Finally, the actual data is placed in the audit record. Updates will have both an old and new value for each change. Inserts will have only a new value and deletes only an old value.","The following is an example of the audit record for TASK to change the task_code from 'A1010'&nbsp;to 'B102:'","audit_info =&gt;:Otask_code: 5:A1010:Ntask_code: 4:B102","Column Audit Data<br /> (Primavera P6 EPPM Database Administration Guide for On-Premises)","English\\Admin\\p6_eppm_database_admin\\34576.htm");
Page[74]=new Array("The performance of the P6 EPPM database depends on an effective configuration of physical design structures, such as indexes or hints, in the database.","Oracle and SQL Server have separate tools which can be used to diagnose the need for database design performance tuning and is discussed in detail below.","Tuning the P6 EPPM Database<br /> (Primavera P6 EPPM Database Administration Guide for On-Premises)","English\\Admin\\p6_eppm_database_admin\\93117.htm");
Page[75]=new Array("The responsibility for maintaining performance of the Oracle Database is a task of the Oracle database administrator (DBA). This section describes how to tune a P6 EPPM database hosted on Oracle.","Oracle Database Tuning<br /> (Primavera P6 EPPM Database Administration Guide for On-Premises)","English\\Admin\\p6_eppm_database_admin\\93118.htm");
Page[76]=new Array("Partitioning addresses key issues in supporting very large tables and indexes by letting you decompose them into smaller and more manageable pieces called partitions. SQL queries and DML statements do not need to be modified in order to access partitioned tables. However, after partitions are defined, DDL statements can access and manipulate individuals partitions rather than entire tables or indexes. This is how partitioning can simplify the manageability of large database objects. Also, partitioning is entirely transparent to applications.","Each partition of a table or index must have the same logical attributes (for example, column names, datatypes, and constraints); however, each partition can have separate physical attributes such as pctfree, pctused, and tablespaces.","Partitioning is useful for applications that manage large volumes of data.","Table partitioning is a manual process that can be performed after you set up the P6 EPPM Database. Oracle Primavera does not provide any tools or utilities to configure table partitioning. Partitioning of an Oracle or Oracle Autonomous Database table within a schema should be performed by the Oracle DBA. ","For more information about Oracle Database partitioning, refer to the Database Performance Tuning Guide and Database Administrator's Guide. ","For more information about partitioning a non-partioned table, refer to How to Partition a Non-partitioned / Regular / Normal Table (Doc ID 1070693.6) on My Oracle Support.","Supported Tables for Partitioning","The following tables are supported for partitioning:","CALENDAR","PAUDIT","PROJWBS","PROJECT","REFRDEL","RSRCROLEASGNMENTSPREAD","UDFVALUE","Supported Partitioning Type","The LIST and RANGE partitioning types are supported. List partitioning enables you to explicitly control how rows map to partitions by specifying a list of discrete values for the partitioning key in the description for each partition. Range partitioning enables you to specify a range of values for the partitioning key in the description of each partition. Rows with values matching the specified partition range map to the partition. ","Table Partition Keys","The partitioning key is comprised of one or more columns that determine the partition where each row will be stored. Oracle and Oracle Autonomous Database automatically direct insert, update, and delete operations to the appropriate partition through the use of the partitioning key. The following list includes the partition key for each table:","The partition key for CALENDAR is CLNDR_TYPE. The partition is by list CA_BASE, CA_PROJECT, and CA_RSRC.","The partition key for PAUDIT is AUSIT_TS. The partition is by range INTERVAL of (1, 'day').","The partition key for PROJWBS is PROJ_NODE_FLAG. The partition is by list Y or N.","The partition key for PROJECT is ORIG_PROJ_ID. The partition is by list null or default (not null).","The partition key for REFERDEL is DELETE_DATE. The partition is by range INTERVAL of (1, 'day').","The partition key for RSRCROLEASGNMENTSPREAD is ROLLEDUP_RECORD. The partition is by list Y or N.","The partition key for UDFVALUE is TABLE_NAME.","TABLE_NAME is a de-normalized column and duplicates values from the UDFTYPE table. You can create a trigger to sync UDFVALUE.TABLE_NAME values with UDFTYPE.TABLE_NAME. The following script can be used to create a new trigger when partitioning UDFVALUE:","-- new trigger","CREATE OR REPLACE TRIGGER &quot;DN_TABLE_NAME_UDFVALUE&quot;","BEFORE INSERT OR UPDATE OF UDF_TYPE_ID ON UDFVALUE","FOR EACH ROW","DECLARE","BEGIN","select TABLE_NAME into :new.TABLE_NAME from UDFTYPE where udf_type_id = :new.udf_type_id;","end;","You can also enhance the login process and open project queries by changing the SETTINGS.SETTING_VALUE from N to Y in the SETTINGS table where SETTINGS.SETTINGS_NAME='UDFVALUE_DENORM'.","Partitioning Oracle or Oracle Autonomous Database Tables for P6 EPPM Schema<br /> (Primavera P6 EPPM Database Administration Guide for On-Premises)","English\\Admin\\p6_eppm_database_admin\\93121.htm");
Page[77]=new Array("Oracle and Oracle Autonomous Databases only support cost-based optimization, which relies on accurate statistics to determine the optimal access path for a query. Gathering the appropriate statistics helps the optimizer, which will improve database performance.  To gather statistics that optimize specifically for P6, use the custom P6 stored procedure gather_statistics() which is owned by the ADMUSER schema. Calling this procedure is the preferred method for gathering table statistics for P6 EPPM tables.","To call the stored procedure, run the following four lines in SQL Developer or SQLPlus:","var ret number","var retmsg varchar2(200)","exec gather_statistics(:ret, :retmsg);","select :retmsg from dual;","Note The ORPM_STATS_GATHER.sql script located in the \\Database\\scripts\\common folder of the P6 EPPM physical media is also supported and performs the same function.","Gathering Statistics for Cost Based Optimizations<br /> (Primavera P6 EPPM Database Administration Guide for On-Premises)","English\\Admin\\p6_eppm_database_admin\\93124.htm");
Page[78]=new Array("V_$TRANSACTION is a system view in Oracle Database that lists the active transactions in the system.","GET_SAFETY DATE (a procedure in the Project Management schema) accesses this view to get the oldest start time of an active transaction. If the schema owner does not have privileges to this view, then it returns a safety date using the USESSION table. V_$Transaction tunes performance during a refresh action. USESSION records the login time of the logged in user, whereas data in the V_$Transaction view is recorded at a system level. The logged in user could be logged in for more than an hour (as seen from the USESSION table), but the V_$Transaction view has the current transaction datetime, regardless of the time the user logged in.","Note Access to the V_$TRANSACTION view was built into the procedure to tune performance with refreshing operations; however, third party functions could impact performance with database refresh operations that use an older time in the V_$TRANSACTION view.","To grant access to this view, connect to the RDBMS as SYS. Run the RUN_AS_SYS.SQL script located in the \\Database\\scripts\\common folder of the P6 EPPM physical media or download.","Viewing the USESSION Table for GET_SAFETY_DATE<br /> (Primavera P6 EPPM Database Administration Guide for On-Premises)","English\\Admin\\p6_eppm_database_admin\\93125.htm");
Page[79]=new Array("Indexes can become skewed if you frequently access parts of the index and not others. As a result, disk contention may occur and create a bottleneck in SQL performance. To prevent this performance degradation, you should monitor your P6 EPPM indexes and rebuild if necessary.","You can use the analyze_P6EPPM_indexes.sql script to compute statistics on the P6 EPPM index, validate the index structure, and return a report that includes the following information:","The number of values in the index that exceed 100.","Deleted entries in the index that represents 20% or more of the current entries or the index depth is more than four levels based on index_stats result","The indexes that are returned from this report should be considered for a rebuild as they could represent a skewed tree structure and can lead to unnecessary database block reads of the index.","To run analyze_P6EPPM_indexes.sql:","Download analyze_P6EPPM_indexes.sql from https://support.oracle.com/epmos/main/downloadattachmentprocessor?parent=DOCUMENT&amp;sourceId=1327603.1&amp;attachid=1327603.1:ANALYZE_INDEXES&amp;clickstream=yes.","Save the script to your local database server.","Open a command prompt and then change the directory to the location of the script.","From the command line, run the following scripts and provide the password when prompted: ","sqlplus &lt;admuser&gt;@&lt;db_tns_names_entry&gt;","@analyze_P6EPPM_indexes.sql","If you need to rebuild an index, you can run the following script:","ALTER INDEX &lt;Index_Name&gt; REBUILD ONLINE;","Where: &lt;Index_Name&gt; is the name of the index returned in the report.","Rebuilding the P6 EPPM Index Table<br /> (Primavera P6 EPPM Database Administration Guide for On-Premises)","English\\Admin\\p6_eppm_database_admin\\93126.htm");
Page[80]=new Array("The Oracle Database 2 Day + Performance Tuning Guide is intended for Oracle database administrators (DBAs) who want to tune and optimize the performance of their Oracle database. It is meant as a quick start guide that teaches you how to perform day-to-day database performance tuning tasks using features provided by Oracle Diagnostics Pack, Oracle Tuning Pack, and Oracle Enterprise Manager (Enterprise Manager). In particular, this document is targeted toward the following groups of users:","Oracle DBAs who want to acquire database performance tuning skills.","DBAs who are new to Oracle Database.","The Oracle Database Performance Tuning Guide is an aid for people responsible for the operation, maintenance, and performance of Oracle database. This book describes detailed ways to enhance Oracle database performance by using performance tools, and optimizing instance performance. It also explains how to create an initial database for good performance and includes performance-related reference information. This book could be useful for database administrators, application designers, and programmers.","Where to Find Additional Oracle Database Tuning Information<br /> (Primavera P6 EPPM Database Administration Guide for On-Premises)","English\\Admin\\p6_eppm_database_admin\\93120.htm");
Page[81]=new Array("The responsibility for maintaining performance of the Microsoft SQL Server Database is a task of the SQL administrator (sa). This section describes how to tune a Microsoft SQL Server database for the P6 EPPM database.","Microsoft SQL Server Database Tuning<br /> (Primavera P6 EPPM Database Administration Guide for On-Premises)","English\\Admin\\p6_eppm_database_admin\\93119.htm");
Page[82]=new Array("Monitoring the performance of a database requires a periodic review of the performance of processes that the database uses. As you collect data, you can isolate processes that cause problems or you can track performance trends.","For more information about how to effectively monitor a Microsoft SQL Server database for performance, refer to the following topics in the Microsoft documentation library:","Monitor and Tune for Performance","Monitor SQL Server Components","Performance Monitoring and Tuning Tools","Establish a Performance Baseline","Isolate Performance Problems","Identity Bottlenecks","Where to Find Additional Microsoft SQL Server Database Tuning Information<br /> (Primavera P6 EPPM Database Administration Guide for On-Premises)","English\\Admin\\p6_eppm_database_admin\\93128.htm");
Page[83]=new Array("When you enable snapshots and create a transaction in your SQL Server Database, a transaction is created (with a unique sequence number before your intended transaction) in tempdb. Your transaction then relies on all of the rows that have a lower sequence number than the rows in tempdb which ensures that your transaction is run against your database as it appeared at the time the query was performed. This prevents rows that were created after a transaction begins from being utilized by current transactions.","For more information about snapshot isolation as well as instructions to enable it, refer to the Snapshot Isolation in SQL Server topic in the Microsoft documentation library.","Isolating Snapshots<br /> (Primavera P6 EPPM Database Administration Guide for On-Premises)","English\\Admin\\p6_eppm_database_admin\\93129.htm");
Page[84]=new Array("Indexes become fragmented if you frequently create, modify, or delete data within a database. When indexes become fragmented, performance degrades. You can prevent the performance of your database from degrading as a result of fragmentation by monitoring your P6 EPPM indexes and rebuilding them if necessary.","For more information about detecting fragmentation within your database and rebuilding your indexes, refer to the Reorganize and Rebuild Indexes topic in the Microsoft documentation library.","Rebuilding the P6 EPPM Index<br /> (Primavera P6 EPPM Database Administration Guide for On-Premises)","English\\Admin\\p6_eppm_database_admin\\93130.htm");
Page[85]=new Array("Statistics are an option that you can enable for your Microsoft SQL Server Database that automatically collections information about data distribution within tables and indexes, query patterns, query results, and the like. You should gather statistics so that you can optimize your interactions with your P6 EPPM database.","For example, gathering statistics can help you recognize and resolve the following issues:","Loading data that hangs at 98%","Performance issues","Projects that open slowly","Windows that disappear after loading data","For more information about enabling statistics gathering in your Microsoft SQL Server Database, refer to Introduction to the Statistics in SQL Server article in the Microsoft documentation library.","To gather statistics for all of the P6 EPPM tables:","Log in to your Microsoft SQL Server Database as a system administrator (sa) user.","Run the following query:","exec sp_updatestats","To gather statistics for the PROJECTS and TASKS tables:","Log in to your Microsoft SQL Server Database as a system administrator (sa) user.","Run the following queries:","update statistics project with fullscan ,all","update statistics task with fullscan ,all","To determine the last time statistics were gathered per index and table:","Log in to your Microsoft SQL Server Database as a system administrator (sa) user.","Run the following query:","SELECT OBJECT_NAME(A.object_id) AS Object_Name, A.name AS index_name, STATS_DATE(A.OBJECT_ID, index_id) AS StatsUpdated,","DATEDIFF(d,STATS_DATE(A.OBJECT_ID, index_id),getdate()) DaysOld","FROM sys.indexes A","INNER JOIN sys.tables B ON A.object_id = B.object_id","WHERE A.name IS NOT NULL","ORDER BY DATEDIFF(d,STATS_DATE(A.OBJECT_ID, index_id),getdate()) DESC","Gathering Statistics<br /> (Primavera P6 EPPM Database Administration Guide for On-Premises)","English\\Admin\\p6_eppm_database_admin\\93131.htm");
Page[86]=new Array("Clean up tasks can be resource intensive and time consuming. Irrespective of your RDBMS, such clean up tasks are initiated in P6 EPPM by two background jobs that run on the database server using the background job processes user name:","SYMON (System Monitor), responsible for running procedures that take less than a few seconds to complete.","DAMON (Data Monitor), responsible for running procedures that take longer than a few seconds to complete.","Both of these jobs are pre-configured with default settings. Since the default settings are optimal for most environments, you generally do not need to tune them. However, if you need to optimize your background process further, you can use the background job processes user to change the settings to tune the behavior of the background jobs for specific environments.","The background process will:","Update the BGPLOG table with a new record each time a job runs.","Update the settings table with a HeartBeatTime record for both the SYMON and DAMON processes. The background processes regularly refresh the record to indicate that they are still running.","When you initiate background jobs:","Run the stored procedure INITIALIZE_BACKGROUND_PROCS.","Locate the logs of background process activity in BPLOGS and SETTINGS tables within the Primavera database.","Background Processes and Clean Up in P6 EPPM<br /> (Primavera P6 EPPM Database Administration Guide for On-Premises)","English\\Admin\\p6_eppm_database_admin\\6851.htm");
Page[87]=new Array("SYMON runs simple P6 EPPM tasks on a quick schedule. By default, the job runs every minute; the tasks assigned to this job should take only a few seconds to complete on each run. Do not change the scheduled run time (every minute) for this procedure.","Procedures performed by SYMON","The procedures run by SYMON perform these tasks:","Processing the PRMQUEUE entries for Project Security by queuing OBSPROJ updates to the PRMQUEUE table.","Marking expired USESSION records as logically deleted.","Note You can manually run queries to assist you with tracking concurrent usage of P6 EPPM.","SYMON (System Monitor) Procedures<br /> (Primavera P6 EPPM Database Administration Guide for On-Premises)","English\\Admin\\p6_eppm_database_admin\\6857.htm");
Page[88]=new Array("OBSPROJ_PROCESS_QUEUE processes the PRMQUEUE entries for Project Security. It defers processing of OBSPROJ updates by queuing the updates to the PRMQUEUE table.","Refer to the following table for information about the settings associated with the OBSPROJ_PROCESS_QUEUE procedure.","OBSPROJ_PROCESS_QUEUE Settings","Setting Description:&nbsp;Maximum project-level queue records to process on each run.","Namespace","database.obsproj.queue","Setting Name","MaxProjectUpdates","Default Setting","1000","Type","Numeric","Setting Description:&nbsp;Maximum EPS-level queue records to process on each run.","Namespace","database.obsproj.queue","Setting Name","MaxEpsUpdate","Default Setting","25","Type","Numeric","Setting Description:&nbsp;Maximum times to re-process a failed entry before marking it as an error.","Namespace","database.obsproj.queue","Setting Name","MaxRetries","Default Setting","50","Type","Numeric","OBSPROJ_PROCESS_QUEUE Procedure<br /> (Primavera P6 EPPM Database Administration Guide for On-Premises)","English\\Admin\\p6_eppm_database_admin\\34556.htm");
Page[89]=new Array("USESSION_CLEANUP_EXPIRED logically deletes USESSION records that have not updated their last_active_time based on the Expired Session settings. Marking expired USESSION records as logically deleted maximizes the number of module access logins that are available. Since it is not cleaning up the underlying data (physically deleting rows), the task completes quickly.","Values in the SETTINGS table control the clean up of expired sessions. By default, although the clean up of expired sessions occurs every two hours, the SETTINGS table does not contain a value for this setting. Use the SETTINGS_WRITE_STRING (value, namespace, setting) stored procedure to change the default clean up value.","For example, setting the value to &quot;2d&quot; deletes expired sessions older than two days.","Note Oracle recommends that you set the ExpiredLongSessionTimeout sessions to at least one hour longer than your longest job. For example, if your longest job is a summarizer job that usually takes 12 hours, you should set the value in the SETTINGS table to at least 13.","Warning: The ExpiredSessionTimeout setting also applies to users of P6 Professional connecting to the EPPM database. P6 Professional uses a heartbeat that runs every five minutes to check that the session is still active. Therefore, users might not know that their session has timed out for up to five minutes between the point of session time out and the next time the heartbeat checks the session. If they are working without the local cache, data updates made during that period might be lost. If this scenario is likely in your environment, Oracle recommends P6 Professional users work with the local cache database configured. See: Primavera Cache Service (P6 EPPM Only) in P6 Professional Help.","Refer to the table below for information about the USESSION_CLEANUP_EXPIRED Settings.","USESSION_CLEANUP_EXPIRED Settings","Setting Description: ExpiredSessionTimeout determines how long an inactive user session will remain in the records before it is marked deleted. User sessions are created when a P6 user logs into P6.","Namespace","database.cleanup.Usession","Setting Name","ExpiredSessionTimeout","Default Setting","2h","Type","Interval","Setting Description:&nbsp;ExpiredLongSessionTimeout determines how long a session that is running a job-like operation (that is still processing) will remain in the records before it is marked deleted. Job-like operations are processed by job services and some are performed by logged in P6 users. Operations that are considered job-like are:","Scheduling","Leveling","Apply Actuals","Update Progress ","Copy/Paste Project","Create Project from Template","Maintain Baselines (create new baseline)","Approve Timesheets","Summarize","PX Publish","Export","Import","Namespace","database.cleanup.Usession","Setting Name","ExpiredLongSessionTimeout","Default Setting","12h","Type","Interval","USESSION_CLEANUP_EXPIRED Procedure<br /> (Primavera P6 EPPM Database Administration Guide for On-Premises)","English\\Admin\\p6_eppm_database_admin\\34557.htm");
Page[90]=new Array("To track concurrent usage of P6 EPPM, you can run queries against the USESSION and USESSAUD tables to perform self-audits. See sample queries below.","Note See DAMON (Data Monitor) Proceduresfor information on how to set up the USESSAUD procedure. To ensure accuracy of these queries, run them before physically deleting remaining USESSION records and cleaning up the USESSAUD table.","Against the USESSION table, run the following query to determine how many users are logged in at a given time:","select count(*) from usession where delete_session_id is null","Against the USESSION table, run the following query to determine how many users are logged into a specific P6 EPPM product at a given time:","select count (*) from usession where delete_session_id is null and app_name='P6 EPPM product name'","where P6 EPPM product name is the application abbreviation.","Note You can view all available application abbreviations by running the following query as an administrative database user: select distinct(db_engine_type) from usereng","Against the USESSAUD table, run a query similar to the following to determine how many users logged into P6 EPPM on a specific date during a specified time range. You can alter the date, time range, and P6 EPPM product as needed. The following example will search for all users who logged into P6 Professional on February 17, 2010 between 9am and 10am:","For an Oracle or Oracle Autonomous Database:","select * from usessaud where login_date between to_date('17-FEB-10 09:00:00','DD-MON-YY HH:MI:SS') and to_date('17-FEB-10 10:00:00','DD-MON-YY HH:MI:SS') and app_name='Project Management'","For a Microsoft SQL Server database:","select * from usessaud where login_date between","'2010-02-17 09:00' and '2011-02-17 10:00' and app_name='Project Management'","Tip","See &quot;Counting Users&quot; in the P6 EPPM System Administration Guide for information on counting users and how to view the total number of licenses assigned for each module.","Tracking Concurrent Usage of P6 EPPM<br /> (Primavera P6 EPPM Database Administration Guide for On-Premises)","English\\Admin\\p6_eppm_database_admin\\55433.htm");
Page[91]=new Array("The second database job is the DAMON data monitor job. The DAMON job runs the majority of the background processing and is responsible for running background clean up processes required by the application that can potentially take a relatively long time to run.","Oracle or Oracle Autonomous Database and DAMON","By default, DAMON runs every night at 1am (database timezone dependent). It uses the Oracle or Oracle Autonomous Database DBMS_SCHEDULER package to schedule the jobs. An Interval setting controls the schedule and accepts the same parameters as the DBMS_SCHEDULER interval. For more information, refer to your Oracle or Oracle Autonomous Database documentation.","Microsoft SQL Server and DAMON","By default, DAMON runs every Saturday. You can set it to run every two weeks or on a specific day. To run DAMON every two weeks, use the following command to set the interval: -eg 2W","To set DAMON to run on a specific day, use the following setting under namespace: Database.background.Damon DayOfWeek","DAMON Procedures ","DAMON cleans the following:","BGPLOG table containing the background logs","DBERRLOG table containing details of database related errors","Logically deleted records","PAUDIT table","PKXREF table","PC_PROCESS_STAT and PC_KEY_XREF tables","PRMQUEUE table","REFRDEL table","Remaining USESSION records","USESSAUD, the USESSION audit table","Orphaned data from extended schema (PX) tables.","You can also dynamically extend DAMON functionality via the user-defined procedure, USER_DEFINED_BACKGROUND.","DAMON (Data Monitor) Procedures<br /> (Primavera P6 EPPM Database Administration Guide for On-Premises)","English\\Admin\\p6_eppm_database_admin\\6859.htm");
Page[92]=new Array("This procedure keeps the BGPLOG table at a reasonable size. The default cleanup interval is 5 days which will result in a table size of about 54,000 records.","Refer to the following table for information about the settings associated with the BGPLOG_CLEANUP procedure.","BGPLOG_CLEANUP Settings","Setting Description:&nbsp;The oldest records to keep in the BGPLOG table.","Namespace","database.cleanup.BackGroundProcessLog","Setting Name","KeepInterval","Default Setting","5d","Type","Interval","BGPLOG_CLEANUP Procedure<br /> (Primavera P6 EPPM Database Administration Guide for On-Premises)","English\\Admin\\p6_eppm_database_admin\\34559.htm");
Page[93]=new Array("This procedure deletes records from the DBERRLOG table based on the KeepInterval parameter setting. All other settings are similar to the REFRDEL_CLEANUP procedure. The following table describes the settings associated with the CLEANUP_DBERRLOG procedure.","Refer to the following table for information about the settings associated with the CLEANUP_DBERRLOG procedure..","CLEANUP_DBERRLOG Settings","Setting Description:&nbsp;Identifies the number of days that records are stored in the DBERRLOG table before they can be removed.","Namespace","database.cleanup.Dberrlog","Setting Name","KeepInterval","Default Setting","30d","Type","Interval","CLEANUP_DBERRLOG Procedure<br /> (Primavera P6 EPPM Database Administration Guide for On-Premises)","English\\Admin\\p6_eppm_database_admin\\100445.htm");
Page[94]=new Array("This procedure deletes records from the REFRDEL table. REFRDEL_CLEANUP runs based on the frequency of the data monitor job, which has a default frequency of one week. Alternatively, you can run REFRDEL_CLEANUP by itself if needed.","Refer to the following table for information about the settings associated with the REFRDEL_CLEANUP procedure:","REFRDEL_CLEANUP Settings","Setting Description: Identifies the number of days that records are stored in the REFRDEL table before they can be removed. For example, the default setting keeps the REFRDEL records from the last five days.","Namespace","database.cleanup.Refrdel","Setting Name","KeepInterval","Default Setting","5d","Type","Interval","Setting Description:&nbsp;Identifies the number of days that are set to be removed from the REFRDEL table starting with the oldest record in the table.","Namespace","database.cleanup.Refrdel","Setting Name","DaysToDelete","Default Setting","1","Type","Numeric","Setting Description:&nbsp;Determines the intervals of time (in minutes) in which data is grouped and removed from the REFRDEL table. The number of IntervalSteps is equal to DaysToDelete (in minutes) divided by IntervalStep.","Namespace","database.cleanup.Refrdel","Setting Name","IntervalStep","Default Setting","15","Type","Numeric","REFRDEL_CLEANUP Procedure<br /> (Primavera P6 EPPM Database Administration Guide for On-Premises)","English\\Admin\\p6_eppm_database_admin\\34560.htm");
Page[95]=new Array("The REFRDEL table maintains a list of deleted records from P6 database tables. However, when an entire project is deleted, a large amount of detailed delete records can be inserted into the REFRDEL table resulting in the potential for downstream performance degradation when joins are made to the REFRDEL table.","The REFRDEL Bypass procedure is an alternative to inserting REFRDEL records for tracking delete records on a large scale. This procedure bypasses the REFRDEL table and simply adds a single delete record for a deleted project and project ID. ","By default, the REFRDEL BYPASS procedure is set to 0 (zero).","To enable REFRDEL Bypass, run the following procedure and set to a non-zero value:","SQL&gt; exec SET_REFRDEL_PROJECT_BYPASS(1);","Database triggers check for the value of the REFRDEL BYPASS value and process accordingly. ","Note The bypass procedure is meant only for a PROJECT DELETE operations. ","REFRDEL Bypass Procedure<br /> (Primavera P6 EPPM Database Administration Guide for On-Premises)","English\\Admin\\p6_eppm_database_admin\\80629.htm");
Page[96]=new Array("This procedure deletes records from the PRMQUEUE table based on the value of the eepInterval setting. The remaining settings are similar to the REFRDEL_CLEANUP.","Refer to the following table for information about the settings associated with the CLEANUP_PRMQUEUE procedure:","CLEANUP_PRMQUEUE Settings","Setting Description:&nbsp;The oldest records to keep in the PRMQUEUE table. Default is five days.","Namespace","database.cleanup.Prmqueue","Setting Name","KeepInterval","Default Setting","5d","Type","Interval","Setting Description:&nbsp;Determines whether the procedure will delete all of the PRMQUEUE records possible on each pass.","Namespace","database.cleanup.Prmqueue","Setting Name","DeleteAll","Default Setting","0 (false)","Type","Boolean","Setting Description:&nbsp;Determines whether all of the records are cleaned. If the total record count is less than this number then all the records are cleaned.","Namespace","database.cleanup.Prmqueue","Setting Name","DeleteAllThreshold","Default Setting","1,000","Type","Numeric","Setting Description:&nbsp;Percentage of records to delete on each pass.","Namespace","database.cleanup.Prmqueue","Setting Name","DeletePercentage","Default Setting","10(%)","Type","Numeric","Setting Description: Maximum rows to delete on each pass.","Namespace","database.cleanup.Prmqueue","Setting Name","MaxRowsToDelete","Default Setting","10,000","Type","Numeric","CLEANUP_PRMQUEUE Procedure<br /> (Primavera P6 EPPM Database Administration Guide for On-Premises)","English\\Admin\\p6_eppm_database_admin\\34561.htm");
Page[97]=new Array("This procedure physically deletes all logically deleted USESSION records. This procedure does not have settings associated with it: All logically deleted USESSION records are cleared.","USESSION_CLEAR_LOGICAL_DELETES Procedure<br /> (Primavera P6 EPPM Database Administration Guide for On-Premises)","English\\Admin\\p6_eppm_database_admin\\34562.htm");
Page[98]=new Array("This procedure removes logically deleted rows based on the value of the KeepInterval setting. Records in the database can be marked as deleted (logically deleted) by setting the DELETE_SESSION_ID column to a non-null value. By default, records that were deleted more than 5 days ago will be deleted by this procedure.","Note","The CLEANUP_LOGICAL_DELETES procedure will not delete records whose DELETE_SESSION_ID column is set to a negative value.","This procedure will not delete records older than the earliest user session in USESSION, as determined by the minimum value in the login_date column.","Refer to the following table for information about the settings associated with the CLEANUP_LOGICAL_DELETES procedure:","CLEANUP_LOGICAL_DELETES Settings","Setting Description:&nbsp;The oldest logically deleted records to keep in tables.","Namespace","database.cleanup.LogicalDelete","Setting Name","KeepInterval","Default Setting","5d","Type","Interval","Setting Description:&nbsp;Determines whether the procedure will delete all of the logically deleted records possible on each pass.","Namespace","database.cleanup.LogicalDelete","Setting Name","DeleteAll&nbsp;&nbsp;","Default Setting","0 (false)","Type","Boolean","Setting Description: Maximum rows to delete on each pass.","Namespace","database.cleanup.LogicalDelete","Setting Name","MaxRowsToDelete","Default Setting","10,000","Type","Numeric","CLEANUP_LOGICAL_DELETES Procedure<br /> (Primavera P6 EPPM Database Administration Guide for On-Premises)","English\\Admin\\p6_eppm_database_admin\\34563.htm");
Page[99]=new Array("If the auditing feature is enabled, this procedure will physically delete records from the table based on the value of the KeepInterval setting.","Refer to the following table for information about the settings associated with the PAUDIT_CLEANUP procedure:","PAUDIT_CLEANUP Settings","Setting Description:&nbsp;Should the procedure attempt PAUDIT / PAUDITX records cleanup.","Namespace","database.cleanup.auditing","Setting Name","Enabled","Default Setting","1 (true)","Type","Boolean","Setting Description: The oldest audit records to keep in PAUDIT / PAUDITX.","Namespace","database.cleanup.auditing","Setting Name","KeepInterval","Default Setting","30d","Type","Interval","Setting Description: Determines the minimum PAUDITX rows to delete after satisfying the KeepInterval parameter setting.&nbsp;This parameter is only applicable to an Oracle or Oracle Autonomous Database.","Namespace","database.cleanup.auditing","Setting Name","PauditxDeleteAllThreshold","Default Setting","1,000,000","Type","Numeric","Setting Description: Determines the maximum PAUDITX rows to delete after satisfying the KeepInterval parameter setting. This parameter is only applicable to an Oracle or Oracle Autonomous Database.","Namespace","database.cleanup.auditing","Setting Name","PauditxMaxRowsToDelete","Default Setting","10,000,000","Type","Numeric","Setting Description: Determines the percentage of PAUDITX rows to delete from PAUDITX, up to the maximum threshold, after satisfying the KeepInterval parameter setting. This parameter is only applicable to an Oracle or Oracle Autonomous Database.","Namespace","database.cleanup.auditing","Setting Name","PauditxDeletePercentage","Default Setting","50","Type","Numeric","Setting Description: Determines the commit interval of PAUDITX deleted records when the number of rows exceed value of PauditxDeleteAllThreshold parameter.  This parameter is only applicable to an Oracle or Oracle Autonomous Database.","Namespace","database.cleanup.auditing","Setting Name","PauditxBatchDelete","Default Setting","200,000","Type","Numeric","PAUDIT_CLEANUP Procedure<br /> (Primavera P6 EPPM Database Administration Guide for On-Premises)","English\\Admin\\p6_eppm_database_admin\\34564.htm");
Page[100]=new Array("The CLEANUP_PKXREF procedure deletes records from the PKXREF table based on the KeepInterval parameter setting.  The following table describes the settings associated with the CLEANUP_PKXREF procedure.","CLEANUP_PKXREF SETTINGS","Setting Description: The oldest records to keep in the PKXREF table. Default is five days.","Namespace","database.cleanup.pkxref","Setting Name","KeepInterval","Default Setting","5d","Type","Interval","Setting Description: Determines the maximum rows to delete after satisfying the KeepInterval parameter setting.  Default is 10000 rows.","Namespace","database.cleanup.pkxref","Setting Name","MaxRowsToDelete","Default Setting","100000","Type","Numeric","Setting Description: Determines the commit interval of deleted records.  Default is to issue a commit every 10,000 rows.","Namespace","database.cleanup.pkxref","Setting Name","DeleteBatchSize","Default Setting","10,000","Type","Numeric","CLEANUP_PKXREF<br /> (Primavera P6 EPPM Database Administration Guide for On-Premises)","English\\Admin\\p6_eppm_database_admin\\101133.htm");
Page[101]=new Array("This procedure deletes records from the PC_KEY_XREF and PC_PROCESS_STAT tables based on the KeepInterval parameter setting.  The following table describes the settings associated with the CLEANUP_PCKEYXREF procedure.","CLEANUP_PCKEYXREF SETTINGS","Setting Description: The oldest records to keep in the PC_KEY_XREF and PC_PROCESS_STAT tables. Default is five days.","Namespace","database.cleanup.pckeyxref","Setting Name","KeepInterval","Default Setting","5d","Type","Interval","Setting Description: Determines the maximum rows to delete after satisfying the KeepInterval parameter setting.  Default is 10000 rows.","Namespace","database.cleanup.pckeyxref","Setting Name","MaxRowsToDelete","Default Setting","100000","Type","Numeric","Setting Description: Determines the commit interval of deleted records.  Default is to issue a commit every 10000 rows.","Namespace","database.cleanup.pckeyxref","Setting Name","DeleteBatchSize","Default Setting","10000","Type","Numeric","CLEANUP_PCKEYXREF<br /> (Primavera P6 EPPM Database Administration Guide for On-Premises)","English\\Admin\\p6_eppm_database_admin\\101134.htm");
Page[102]=new Array("The CLEANUP_USESSAUD procedure deletes records from the USESSAUD table based on the KeepInterval parameter setting. All other settings are similar to the REFRDEL_CLEANUP procedure. The following table describes the settings associated with the CLEANUP_USESSAUD procedure.","CLEANUP_USESSAUD Settings","Setting Description:&nbsp;Determines the oldest records to keep in the USESSAUD table. Based on the logout time, data beyond the KeepInterval parameter value will not deleted. The KeepInterval parameter setting overrides all other CLEANUP_USESSAUD settings.","Namespace","database.cleanup.Usessaud","Setting Name","KeepInterval","Default Setting","5d","Type","Interval","Setting Description:&nbsp;Deletes all the REFRDEL records that satisfy the KeepInterval setting on each pass. The DeleteAll parameter setting overrides the settings of DeleteAllThreshold, DeletePercentage, and MaxRowsToDelete parameters.","Namespace","database.cleanup.Usessaud","Setting Name","DeleteAll","Default Setting","0 (false)","Type","Boolean","Setting Description:&nbsp;Determines the minimum number of records to delete after satisfying the KeepInterval parameter setting. By default, a minimum of 1000 records are deleted. If the total record count is less than this setting, all records are deleted. The DeleteAllThreshold parameter setting overrides the settings of the DeletePercentage and MaxRowsToDelete parameters.","Namespace","database.cleanup.Usessaud","Setting Name","DeleteAllThreshold","Default Setting","1,000","Type","Numeric","Setting Description: Determines the maximum rows to delete on each pass after satisfying the KeepInterval parameter setting. The MaxRowsToDelete parameter setting overrides the DeletePercentage parameter setting.","Namespace","database.cleanup.Usessaud","Setting Name","MaxRowsToDelete","Default Setting","10,000","Type","Numeric","Setting Description: Determines the percentage of records to delete on each pass after satisfying the DeleteAllThreshold and MaxRowsToDelete settings. However, the percentage of records deleted is limited to the default value of the MaxRowsToDelete setting.","Namespace","database.cleanup.Usessaud","Setting Name","DeletePercentage","Default Setting","10 (%)","Type","Numeric","CLEANUP_USESSAUD Procedure<br /> (Primavera P6 EPPM Database Administration Guide for On-Premises)","English\\Admin\\p6_eppm_database_admin\\34565.htm");
Page[103]=new Array("By default, data published to extended schema (PX) tables is not deleted when you delete data from P6. The CLEAN_PX_DELETE procedure cleans orphaned records from the PX tables. CLEAN_PX_DELETE runs based on the frequency of the data monitor job. Alternatively, you can run CLEAN_PX_DELETE by itself if needed.","All other settings are similar to the REFRDEL_CLEANUP procedure. The following table describes the settings associated with the CLEAN_PX_DELETE procedure.","CLEAN_PX_DELETE Settings","Setting Description: Determines the maximum amount of obsolete rows to delete from each extended schema table.&nbsp; Default is 100,000 rows.","Namespace","PxService.Cleanup","Setting Name","DeleteMaxSize","Default Setting","100000","Type","Numeric","Setting Description: Determines the commit interval of deleted records. Default is to issue a commit every 5,000 rows.","Namespace","PxService.Cleanup","Setting Name","DeleteBatchSize","Default Setting","5000","Type","Numeric","CLEAN_PX_DELETE Procedure<br /> (Primavera P6 EPPM Database Administration Guide for On-Premises)","English\\Admin\\p6_eppm_database_admin\\101147.htm");
Page[104]=new Array("This procedure is an optional customer procedure that DAMON runs. This procedure does not have settings associated with it.","USER_DEFINED_BACKGROUND Procedure<br /> (Primavera P6 EPPM Database Administration Guide for On-Premises)","English\\Admin\\p6_eppm_database_admin\\34566.htm");
Page[105]=new Array("The P6 EPPM database normally handles restoring select deleted data using a safe delete setting. While using P6 Professional, the Undo command (Edit, Undo) allows users to restore certain types of data that have been deleted. Deleted data remains in the P6 EPPM database until the CLEANUP_LOGICAL_DELETES procedure clears it&nbsp;(after 5 days, by default).","See the P6 Professional Help for more information about using undo.","Safe Deletes<br /> (Primavera P6 EPPM Database Administration Guide for On-Premises)","English\\Admin\\p6_eppm_database_admin\\6862.htm");
Page[106]=new Array("Caution Turning off safe deletes disables undo functionality and immediately clears deleted data from the P6 EPPM database.","You can turn off safe deletes to save storage space. ","To turn off safe deletes:","Verify the current state of your safe deletes setting. In&nbsp;the database, if the table ADMIN_CONFIG has the following row, a CONFIG_VALUE of 'N' means turn off safe deletes.","CONFIG_NAME = 'SAFEDELETE.ACTIVE'&nbsp;and CONFIG_TYPE = 'SETTINGS'","Note This is only loaded at startup. If you change CONFIG_VALUE while a user is running P6 Professional, the setting will not apply until the user restarts the P6 Professional session.","Once you have determined the current state of your safe deletes setting, run one of the following statements.","To turn off safe deletes for the first time:","INSERT INTO ADMIN_CONFIG (CONFIG_NAME, CONFIG_TYPE, CONFIG_VALUE) VALUES ('SAFEDELETE.ACTIVE', 'SETTINGS', 'N')","To turn on safe deletes after it has been turned off:","UPDATE ADMIN_CONFIG SET CONFIG_VALUE = 'Y' WHERE CONFIG_NAME = 'SAFEDELETE.ACTIVE' AND CONFIG_TYPE = 'SETTINGS'","To turn off safe deletes after it has been turned on:","UPDATE ADMIN_CONFIG SET CONFIG_VALUE = 'N' WHERE CONFIG_NAME = 'SAFEDELETE.ACTIVE' AND CONFIG_TYPE = 'SETTINGS'","Restart the P6 server.","Turning Off Safe Deletes<br /> (Primavera P6 EPPM Database Administration Guide for On-Premises)","English\\Admin\\p6_eppm_database_admin\\34558.htm");
var PageCount=86;


/*
Date: 12/3/2025 5:56 PM
Source: EPPM_25_dev
BookID: 93074
PubProduct: PRIMAVERA_EPPM
BookTitle: Database Administration Guide for On-Premises
Version: Version 25
Lang:	en
*/
/* relative_path_for_link: English\Admin\p6_eppm_system_admin*** */
/* BookTitleTop: Primavera P6 EPPM System Administration Guide for On-Premises*** */
/* Generated with Author-it 23.4.1.30004  12/11/2025 7:41:48 PM */
Page[107]=new Array("Title and Copyright Information","Copyright  1999, 2025, Oracle and/or its affiliates.","Primary Author: Oracle Corporation","Title and Copyright Information<br /> (Primavera P6 EPPM System Administration Guide for On-Premises)","English\\Admin\\p6_eppm_system_admin\\46576.htm");
Page[108]=new Array("Scope","P6 EPPM system administrators manage and create configurations for your P6 EPPM applications. This guide describes how to perform common system administration tasks using the Primavera P6 Administrator.","Audience","System administrators should use this guide.","Using This Guide","This guide assumes you have installed the Primavera P6 Administrator and other P6 EPPM applications. For more information, see the P6 EPPM Installation and Configuration Guide.","About This Guide<br /> (Primavera P6 EPPM System Administration Guide for On-Premises)","English\\Admin\\p6_eppm_system_admin\\94271.htm");
Page[109]=new Array("Primavera P6 Administrator is the primary application that system administrators use to review, modify, add, and delete P6 EPPM configurations. P6 EPPM configurations are stored in the database that was specified during the installation of P6. These configurations contain all of the settings used to run the application server for P6.","Caution Many of the defaults are set to maximize the performance of your database. You should change them only if you are certain a change is needed.","Primavera P6 Administrator Setup Tasks<br /> (Primavera P6 EPPM System Administration Guide for On-Premises)","English\\Admin\\p6_eppm_system_admin\\7028.htm");
Page[110]=new Array("On-Premises","You can run the Primavera P6 Administrator locally or remotely through a browser. The installation for P6 sets the default URLs for remote access to the Primavera P6 Administrator. You can use the application server's configuration utility to change the listen port number and context root. After launching the Primavera P6 Administrator, you will need to enter an Admin Superuser name and password.","Cloud","Submit a Service Request in My Oracle Support to request access to Primavera P6 Administrator. You will be provided with a URL for Primavera P6 Administrator for your environment. After launching Primavera P6 Administrator, you will need to enter the name and password for a user which has been granted access to Primavera P6 Administrator.","Launching the Primavera P6 Administrator<br /> (Primavera P6 EPPM System Administration Guide for On-Premises)","English\\Admin\\p6_eppm_system_admin\\14417.htm");
Page[111]=new Array("To launch the Primavera P6 Administrator locally with Windows:","Go to the P6 home directory (for example, C:\\P6EPPM_1\\p6).","Run adminpv.cmd.","Log in as an administrator.","Launching the Primavera P6 Administrator Locally with Windows for On-Premises<br /> (Primavera P6 EPPM System Administration Guide for On-Premises)","English\\Admin\\p6_eppm_system_admin\\41724.htm");
Page[112]=new Array("To launch the Primavera P6 Administrator locally with UNIX or Linux:","Change to the p6home directory that you specified when installing P6. For example:","/usr/P6EPPM_1/p6","Run adminpv.sh.","Log in as the privileged database user (for example, privuser).","Launching the Primavera P6 Administrator Locally with UNIX or Linux for On-Premises<br /> (Primavera P6 EPPM System Administration Guide for On-Premises)","English\\Admin\\p6_eppm_system_admin\\41725.htm");
Page[113]=new Array("To launch the Primavera P6 Administrator remotely:","Launch a supported browser.","Go to https://&lt;server IP:listenport&gt;/&lt;ContextRoot&gt;/admin.jsp","where &lt;serverIP:listenport&gt;&nbsp;is the IP address and listen port for the P6 server and &lt;ContextRoot&gt; is p6 by default.","Log in as a user with Admin Superuser privileges. ","Note","Only users with Admin Superuser privileges can log in to the Primavera P6 Administrator remotely. If you are logged in to P6, but do not have the appropriate privileges to edit settings in the Primavera P6 Administrator, you will be redirected to the P6 login page.","The Privileged database user (for example, privuser) can still access the local Primavera P6 Administrator, but will not have access to the remote Primavera P6 Administrator.","Launching the Primavera P6 Administrator Remotely for On-Premises<br /> (Primavera P6 EPPM System Administration Guide for On-Premises)","English\\Admin\\p6_eppm_system_admin\\38478.htm");
Page[114]=new Array("Scope","This guide contains information about how you can:","Review, modify, add, and delete P6 EPPM configurations using Primavera P6 Administrator","Setup and maintain each of the P6 EPPM applications","Troubleshoot P6 EPPM","Audience","This guide is intended to be used by experienced system administrators, network administrators, or database administrators.","About the P6 EPPM System Administration Guide<br /> (Primavera P6 EPPM System Administration Guide for On-Premises)","English\\Admin\\p6_eppm_system_admin\\90345.htm");
Page[115]=new Array("The Primavera P6 Administrator presents configuration settings for your P6 EPPM applications. The Configurations and Authentication tabs display the current configurations and settings. The Log tab displays a history of configuration changes.","Tip","Position the mouse over a setting to read the description.","You cannot edit the Factory Default configuration settings. You can only modify custom configurations.","The Primavera P6 Administrator warns you of any out of date configurations. Oracle recommends that you update these configurations.","If you create a new configuration, you need to click Update to latest version before changing your settings in the new configuration.","To find a setting quickly, you can use the search box below the Configurations drop-down list. Clicking the search button or hitting enter will open every file with that setting name.","Reviewing and Modifying Configurations for P6<br /> (Primavera P6 EPPM System Administration Guide for On-Premises)","English\\Admin\\p6_eppm_system_admin\\53859.htm");
Page[116]=new Array("To change a setting value:","Select either the Configurations or the Authentication tab to display a hierarchical view of the settings.","Select a heading to display the settings.","Select the field or the drop-down list that you want to change.","Enter a new value.","On the You have unsaved changes context menu, select Save Changes.","Changing a Setting in the Primavera P6 Administrator<br /> (Primavera P6 EPPM System Administration Guide for On-Premises)","English\\Admin\\p6_eppm_system_admin\\32731.htm");
Page[117]=new Array("To return a setting to its default value:","Position your mouse over the setting to display the tool tip.","Enter the Default into the field.","On the You have unsaved changes context menu, select Save Changes.","Returning a Primavera P6 Administrator Setting to its Default Value<br /> (Primavera P6 EPPM System Administration Guide for On-Premises)","English\\Admin\\p6_eppm_system_admin\\32732.htm");
Page[118]=new Array("Duplicate an existing configuration to create a new configuration. To duplicate a configuration:","Select Manage Configurations in the Configurations list.","Select the menu button next to a configuration and select Duplicate.","Double-click the new configuration.","Enter a name for the configuration.","Select Save. ","Edit settings as needed.","Click Save Changes.","Tip","To create a new configuration based on default settings, duplicate the Factory Defaults configuration.","If you create a new configuration, you must click Update to latest version before changing your settings in the new configuration.","Adding Configurations to the Primavera P6 Administrator<br /> (Primavera P6 EPPM System Administration Guide for On-Premises)","English\\Admin\\p6_eppm_system_admin\\14438.htm");
Page[119]=new Array("To add a new database instance to a configuration, duplicate an existing instance. To duplicate a database instance:","Select Database.","In the Instance drop-down list, select Manage Instances","Select the menu button next to a configuration and select Duplicate. ","Enter a unique name for the new instance.","Select Save.","Edit Database settings as needed.","Click Save Changes.","Adding Database Instances to a Configuration in the Primavera P6 Administrator for On-Premises<br /> (Primavera P6 EPPM System Administration Guide for On-Premises)","English\\Admin\\p6_eppm_system_admin\\14439.htm");
Page[120]=new Array("To delete a configuration or database instance:","Select the configuration or database instance you want to delete.","Right-click the configuration or database instance and select Delete.","Tip","You cannot delete the Factory Defaults configuration. You can delete any custom configuration, but not all of them. You must always have one custom configuration.","You can delete any database instance associated with a configuration, but not all of them. Each configuration must have at least one database instance.","You can delete the database that you specified during the database configuration. If you do so, you will need to run the Database Configuration wizard again. See About the Database Configuration Wizard for P6.","Deleting Configurations and Database Instances for P6 in the Primavera P6 Administrator for On-Premises<br /> (Primavera P6 EPPM System Administration Guide for On-Premises)","English\\Admin\\p6_eppm_system_admin\\14440.htm");
Page[121]=new Array("To export a P6 configuration using the command line:","adminpv -CopyConfig &quot;&lt;CurrentConfig&gt;&quot; &quot;&lt;ExportConfig&gt;&quot;","where &lt;CurrentConfig&gt; is the name of the configuration you want to export (by default, Primavera P6 Configuration) and &lt;ExportConfig&gt; is the name of the exported configuration.","Exporting Configurations Using the Command Line for On-Premises<br /> (Primavera P6 EPPM System Administration Guide for On-Premises)","English\\Admin\\p6_eppm_system_admin\\93741.htm");
Page[122]=new Array("Many of the settings in the configurations tab are already set for you. You should change them only if you are certain a change is needed.","Use the configurations tab to:","Create new configurations.","Delete configurations.","Configure your settings for your applications.","About the Configurations Tab in the Primavera P6 Administrator<br /> (Primavera P6 EPPM System Administration Guide for On-Premises)","English\\Admin\\p6_eppm_system_admin\\6989.htm");
Page[123]=new Array("Your localization settings specify the language you see when you log in to P6 and the country for server string constants. The Java application uses this setting to ensure all instances of P6 EPPM will use the same localization settings.","Note","The localization used by your operating system will have priority for the language used. The localization setting in P6 ensures P6 EPPM uses your preferred language if the JVM fails to recognize your operating system's localization settings.","If you change the localization of P6 on the login page, you will only change the language for your P6 user interface. It does not translate your data or change the convention followed by your region.","Changes to these settings require you to restart the P6 server.","To set your language and country:","Open the Primavera P6 Administrator.","In the Configurations drop-down list, select your configuration.","In the sidebar select Localization.","In the System Language drop-down list, select your language. The default value is English (en).","In the System Country drop-down list, select your country. The default value is US.","Tip Go to http://download.oracle.com/javase/1.5.0/docs/guide/intl/locale.doc.html or the Tested Configurations document for a list of supported languages and countries.","Configuring Localization Settings<br /> (Primavera P6 EPPM System Administration Guide for On-Premises)","English\\Admin\\p6_eppm_system_admin\\51460.htm");
Page[124]=new Array("The Maximum Session Timeout setting is the maximum length of time that a user can connect to the application server (regardless of activity) before P6 EPPM times it out.","To set your session timeout:","Open the Primavera P6 Administrator.","In the Configurations drop-down list, select your configuration.","In the sidebar selectSession Management.","In Maximum Session Timeout, enter the amount of time a user session can remain open before it times out.","The default value is 1d. ","Enter a value between 1m and 24d.","Note Changes to this setting require you to restart the P6 server.","Configuring Session Management Settings<br /> (Primavera P6 EPPM System Administration Guide for On-Premises)","English\\Admin\\p6_eppm_system_admin\\51463.htm");
Page[125]=new Array("You will use the database instance settings to specify information about your database, such as name, description, and schema.","To set your database instance settings:","Open the Primavera P6 Administrator.","In the Configurations drop-down list, select your configuration.","In the sidebar selectDatabase.","In the Instance list, select Manage Instances....","In the Manage Instances dialog box, hover over the instance that should be the default instance, click @&nbsp;Row&nbsp;Actions then select Set Default to set the selected instance as the default instance.","Note You can also remove the default database.","In the Instance list, select your database instance.","In the General Settings section:","In the Name field, enter the name of this database instance. ","Note","This determines how the database instance name will appear on the P6 login page.","The name can be a maximum of 32 characters.","In the Description field, enter a description of this database instance.","Note The description can be a maximum of 128 characters.","In the Public Group ID field, enter the database group ID of the privileged user account that will access the database. ","The default value is 1. ","In the User Name field, enter the name used to establish a connection to the database. ","The default value is pubuser, but if you created a custom Public User name, you must use your custom name.","In the Password field, enter the Public User password used to establish a connection to the database.","Select the Auto Start Services option to automatically start all services for this database when the application server starts. ","When this option is selected, all job services with a Concurrent Threads setting greater than zero will start when the application server starts. ","Select this option if you will use the Summarize or Apply Actuals features in P6 Professional.","If you do not select this option, users must manually log in to the application before the services will start.","Note If you clear the Auto Start Services option, job services will not start until someone logs in to the application for the first time.","Configuring Database Instance Settings for On-Premises<br /> (Primavera P6 EPPM System Administration Guide for On-Premises)","English\\Admin\\p6_eppm_system_admin\\51554.htm");
Page[126]=new Array("If you have more than one database instance for your configurations, you will see them all under the database folder for your configuration. You can configure these settings for a database instance:","Database information, such as name, schema, and public group ID","Driver Class and URL","User Security","Connection Pool","Content Repository, such as Oracle WebCenter Content Core Capabilities (formerly Universal Content Management), Microsoft SharePoint, Oracle Database, and CMIS-compliant content repository","AutoVue","Session Settings","Cost Based Optimization settings","Oracle Analytics Publisher","BPM Settings","About Database Instance Settings<br /> (Primavera P6 EPPM System Administration Guide for On-Premises)","English\\Admin\\p6_eppm_system_admin\\53438.htm");
Page[127]=new Array("The Driver Class and URL settings are where you configure the Java class and database URL that will connect to P6 EPPM.","To set your Driver Class and URL settings:","Open the Primavera P6 Administrator.","In the Configurations drop-down list, select your configuration.","In the sidebar selectDatabase.","Select your Instance from the drop-down list.","Expand Driver Class &amp; URL.","In the Java Class field, enter the database driver class used for communicating with the database. Your options are:","oracle.jdbc.driver.OracleDriver","com.microsoft.sqlserver.jdbc.SQLServerDriver","In the URL field, enter the database URL used to establish a connection to the P6 EPPM database.","Oracle example:","jdbc:oracle:thin:@&lt;Host_Name&gt;:&lt;Database_Port&gt;:&lt;Database_Name&gt;","Oracle Autonomous Database example:","jdbc:oracle:thin:@&lt;servicename&gt;?TNS_ADMIN=&lt;unzipped_wallet_path&gt;","Microsoft SQL Server example:","jdbc:sqlserver://&lt;Host_Name&gt;:&lt;Database_Port&gt;;database=&lt;Database_SID&gt;;","Note","If you upgrade your database and this database connection gets disconnected, you can right-click on the Driver Class &amp; URL node to reconfigure your database connection. When you right-click on the node, click Configure and the Configure URL dialog box will appear.","You can also define a custom Oracle/MSSQL driver class from the Configure URL dialog box. The jar file for your custom driver class should exist in the application server classpath. Oracle recommends copying the driver jar file to the &lt;WebLogic_Home&gt;\\user_projects\\domains\\your_domain\\lib file.","Configuring Driver Class and URL for Database Instance Settings<br /> (Primavera P6 EPPM System Administration Guide for On-Premises)","English\\Admin\\p6_eppm_system_admin\\51555.htm");
Page[128]=new Array("These settings let you specify how many times users can log in before they are locked out and for how long the users will stay locked out. You can also specify whether to allow multiple user or single machine sessions.","To set your database instance settings:","Open the Primavera P6 Administrator.","In the Configurations drop-down list, select your configuration.","In the sidebar selectDatabase.","Select your Instance from the drop-down list.","Expand User Security.","Note","Changes to these settings require you to restart the P6 server.","In the Log Login Attempts field, select whether login attempts to P6 are tracked in the logs. You can choose to log the following:","None","Failed Attempts","Successful Attempts","All","In the Login Lockout Count field, enter the number of times a user can attempt to log in before the account locks. ","The default value is 5.","Enter a value between 0 and 100000.","Note","A setting of &quot;0&quot; allows an unlimited number of attempts.","The count resets after each successful login.","In the Login Lockout Duration field, enter the length of time that a user is blocked from logging in to P6; starts when the user exceeds the Login Lockout Count.","The default value is 1h.","Enter a value between 0 and 24d.","Note","The Admin Superuser can override this setting if they manually reset a user's session. See the Resetting User Sessions section of the P6 EPPM Application Administration Guide for details.","In the Allow Multiple User Sessions field, select whether a single user can simultaneously log in to P6 on different machines. ","The default value is Yes.","You can select one of the following:","Selecting &quot;Yes&quot; allows a single user to log in multiple times on the same machine or different machines.","Note","The following restrictions apply when you select &quot;Yes&quot; for multiple user sessions:","Users must use Microsoft Edge or Google Chrome when logging in more than once on the same machine. See the Tested Configurations document for supported versions.","If you want users to log in multiple times on the same machine (either with the same user name or with different user names), you must set the Allow Multiple User Sessions setting to Yes. The other settings will not allow the user to log in multiple times.","Selecting &quot;No&quot; allows a single user to log in only once with the same user name. If the user tries to log in again while another session is active, the log in will fail. A session can still be active if the user has closed the browser without logging out of P6. The user will have to wait until the session resets before they can log in again.","Selecting &quot;Single Machine&quot; allows a user to log in once on a machine. The user can log in again on the same machine if they close their browser without logging out; they will not have to wait for the session to reset. If they close their browser without logging out, they can immediately log in again on the same machine they were using; the user won't be able to log in on a different machine unless they wait for the session to reset.","Configuring User Security for Database Instance Settings<br /> (Primavera P6 EPPM System Administration Guide for On-Premises)","English\\Admin\\p6_eppm_system_admin\\51556.htm");
Page[129]=new Array("The connection pools create and open database connections when they are first needed. When you start the P6 EPPM server, it will allocate one or two connections for initialization routines. The server will allocate and open more connections when the pool cannot satisfy requests from the current pool. You can set the connection pool settings for: ","Regular Used for the regular connection pool. Regular is the most used connection pool and has 90%+ of database access.","Long Running Used for the long running connection pool. Use this connection pool for services that will run for a long time.","Transactional Used for the transactional connection pool. Use this connection pool when you have several types of objects saved at one time. ","Note Gantt applets will use the Regular pool when loading data and the Transactional pool when creating or updating data. ","A P6 EPPM application operation requires a database connection, so it asks the connection pool for a database connection. If the connection pool contains a connection that is not currently leased, it returns that connection. If it doesn't have a connection available it will check to see if its current allocated count is below 50 (which is the default in the Maximum Connections setting). If the count is below 50, it will create a new database connection and open it, put it in the pool, and return it to the caller. The caller uses the connection, then releases it when they end the session.","If the pool could not allocate a connection because all 50 connections were leased, it will keep checking for the next 30 seconds (which is the default in the Lease Request Wait Timeout setting). If a connection becomes available within that 30 seconds, it will return that connection. If a connection does not become available, it will log the following error:  &#8220;Error: Lease request timeout while waiting for a connection to become available. Database &lt;dbname&gt;&#8221; and the caller will have to try again at a later time.","To set your connection pool settings:","Note","The defaults will provide optimal performance in most environments. Change them only if you are certain a change is needed. Contact My Oracle Support for more information.","Open the Primavera P6 Administrator.","In the Configurations drop-down list, select your configuration.","In the sidebar selectDatabase.","Select your Instance from the drop-down list.","Expand the relevant Connection Pool branch.","Note Changes to these settings require you to restart the P6 server.","Select Trace SQL to trace all SQL sent to the database.","The default is unselected.","Select Renewable Leases if you want connection leases renewed when database statements are completed within the MaxLeaseDuration time period. When selected, the code can hold onto the connection as long as it needs, provided SQL statements finish within the MaxLeaseDuration period. When selected, the connection is revoked if no SQL statements are issued within the MaxLeaseDuration period or if one statement takes longer to run than that period.","Leave this field blank if you want each connection to be leased only for the MaxLeaseDuration period.","The default for Connection Pool (Regular) is false. The default for Long Running and Transactional is true.","In the Resize Rate field, enter the timeout period when the system will close all of its unused connections. For example, if the resize rate is 4 minutes, then every 4 minutes the connection pool will attempt to close all of its unused connections.","The default value is 4m.","Enter a value between 4m and 12h.","In the Maintenance Frequency field, enter how often maintenance will run to ensure leases have not exceeded the maximum duration.","The default value is 1m.","Enter a value between 10s and 1h.","In the Lease Request Wait Timeout field, enter the amount of time a request for a database connection will wait before timing out.","If a request for a database connection times out, the user can reload the page and attempt to connect to the database again.","The default value is 30s.","Enter a value between 5s and 2h.","In the Maximum Connections field, enter the maximum number of connections the server will have to the database. ","The default for Regular and Transactional is 50 and the default for Long Running is 100.","Enter a value between 5 and 15000.","In the Fetch Size field, enter how many rows to pull from the database and send to the application server.","The default value is 120.","In the Renewable Free Limit field, enter the minimum number of connections that leases need to be renewed.","The default value is 3.","Enter a value between 3 and 5.","In the Maximum Lease Durations field, enter the maximum time a database connection can be leased before it is revoked. ","The default for Regular is 2m, with a range of 5s and 4h.","The default for Long Running is 30m, with a range of 5s and 6h.","Note During the summarization process, queries may take a long time to run if the project has a high number of WBS nodes. If you receive timeout errors, set your Long Running maximum lease duration to at least 30 minutes.","The default for Transactional is 30m, with a range of 5s and 6h.","Configuring Connection Pool for Database Instance Settings<br /> (Primavera P6 EPPM System Administration Guide for On-Premises)","English\\Admin\\p6_eppm_system_admin\\51557.htm");
Page[130]=new Array("To set your WCCC settings:","Note Ensure the settings you entered in when you configured the content repository match the settings you enter below.","Open the Primavera P6 Administrator.","In the Configurations drop-down list, select your configuration.","In the sidebar select Database.","Select your Instance from the drop-down list.","Expand Content Repository.","In the Type field, select OracleWCCC.","In the Maximum document size field, enter the maximum size in KB for documents that can be uploaded to P6. The default is 10240 KB. Enter a value between 0 and 1048576.","In the Connection Maintenance Interval field enter the frequency at which the connection to the content repository is validated. The default is 10 minutes. Enter a value between 1 second and 24 days.","In the Oracle Webcenter Content Core Capabilities area","In the Host field, enter the machine name or IP address of the content repository server.","In the Port field, enter the IntradocServerPort number of the content repository server. By default, this is 4444.","Go to WCCC_Home\\ucm\\cs\\config\\.","Edit the config.cfg file.","Find the IntradocServerPort line, which contains the port number.","In the Oracle Home field, enter the location of the framework folder.","For the framework folder, use the following format:","/&lt;FolderName&gt;","For example:","/P6EPPM","In the Oracle Security Group field, enter the name of the Security Group assigned to the document folder created in WebCenter for P6 EPPM documents, as specified when you configured the content repository. ","For Example:","Enter Oracle Security Group as Public.","In the Oracle Security Account field, enter the name of the Security Account for P6 EPPM documents, as specified when you configured the content repository. ","If you did not enable security accounts, leave this setting blank.","In the Oracle Document Type field, enter the document type for P6 EPPM documents, which can be either an existing document type or a new one, as specified when you configured the content repository. ","For example:","Enter the Document Type as Document.","In the Metadata Prefix field, enter the prefix added to P6 EPPM metadata fields, as specified when you configured the content repository. For example, Prm.","In the Admin User field, enter the user name with administrative privileges, as specified when you configured the content repository. This setting is required.","From the Authentication Mode drop-down menu, select the authentication mode used to access the content repository server. P6 EPPM users cannot access content repository functions if you do not configure this setting.","If you choose &quot;Multiple User&quot;, all P6 EPPM content repository-related user names must match the equivalent content repository user name. For example, a P6 EPPM user named &quot;Joe&quot; must have an equivalent user named &quot;Joe&quot; in the content repository. ","If you choose &quot;Single User&quot;, the administrative user specified in the setting above must have access to all appropriate SharePoint libraries to browse to documents outside of the P6 EPPM home folder.","Restart the P6 Server.","Configuring Oracle WebCenter Content Core Capabilities (WCCC) in the Database Instance Settings<br /> (Primavera P6 EPPM System Administration Guide for On-Premises)","English\\Admin\\p6_eppm_system_admin\\65657.htm");
Page[131]=new Array("You can use Oracle database as a content repository with your P6 EPPM installation.","To configure the Oracle database as your content repository:","Open the Primavera P6 Administrator.","In the Configurations drop-down list, select your configuration.","In the sidebar selectDatabase.","Select your Instance from the drop-down list.","Expand Content Repository.","Note Changes to these settings require you to restart the P6 server.","In the Type field, select Oracle Database.","This option will save documents and associated information in the P6 database schema. This option is only applicable if you are using an Oracle database on-premises or an Oracle Autonomous Database.","In the Maximum document size field, enter the maximum size in KB for documents that can be uploaded to P6. The default is 10240 KB. Enter a value between 0 and 1048576.","Note To block specific document types, enter a comma separated list of file extensions in the Invalid Document Types field in the Integration &amp; Allow Lists tab of the Application Settings in P6. Oracle recommends at least blocking the following document types: .exe,.com,.bat,.cmd,.vbs,.js,.msi.","In the Connection Maintenance Interval field enter the frequency at which the connection to the content repository is validated. The default is 10 minutes. Enter a value between 1 second and 24 days.","Note Ensure that the Enable Cloud Storage field is set to false.","Restart the P6 server.","Configuring the Oracle Database Content Repository<br /> (Primavera P6 EPPM System Administration Guide for On-Premises)","English\\Admin\\p6_eppm_system_admin\\84126.htm");
Page[132]=new Array("You can use Microsoft SharePoint with P6 by integrating SharePoint with your CMIS-compliant content repository and then configuring your CMIS-compliant content repository with P6.","To configure your CMIS-compliant content repository:","Open the Primavera P6 Administrator.","In the Configurations drop-down list, select your configuration.","In the sidebar selectDatabase.","Select your Instance from the drop-down list.","Expand Content Repository.","In the Type field, select CMIS.","Note Changes to these settings require you to restart the P6 server.","In the Maximum document size field, enter the maximum size in KB for documents that can be uploaded to P6. The default is 10240 KB. Enter a value between 0 and 1048576.","Note To block specific document types, enter a comma separated list of file extensions in the Invalid Document Types field in the Integration &amp; Allow Lists tab of the Application Settings in P6. Oracle recommends at least blocking the following document types: .exe,.com,.bat,.cmd,.vbs,.js,.msi.","In the SharePoint area:","In the Login Name field, enter the user name for your content repository.","In the Password field, enter the password for the user name you entered above.","In the Authentication Mode field, enter authentication mode used to access the content repository server. P6 EPPM users cannot access content repository functions if you do not configure this setting.","If you choose &quot;Multiple User&quot;, all P6 EPPM content repository-related user names must match the equivalent content repository user name. For example, a P6 EPPM user named &quot;Joe&quot; must have an equivalent user named &quot;Joe&quot; in the content repository.","If you choose &quot;Single User&quot;, the administrative user specified in the setting above must have access to all appropriate Security Groups to browse to documents outside of the P6 EPPM home folder.","In the Repository Name field, enter the name for your content repository.","Note For SharePoint, enter the document library name you created for P6. ","In the Document Home field, enter the location of the folder in the document library where you want to store P6 documents.","In the Web Service URL field, enter the URL for your web services home.","This is Web Service Endpoint with format http://&lt;sharepoint host&gt;/sites/&lt;site name&gt;/_vti_bin/cmissoapwsdl.aspx","Restart the P6 server.","Configuring CMIS-Compliant Content Repository in the Database Instance Settings<br /> (Primavera P6 EPPM System Administration Guide for On-Premises)","English\\Admin\\p6_eppm_system_admin\\65454.htm");
Page[133]=new Array("The session settings allow you to issue database statements to customize the database environment when the connections are created. You need to set these settings only if you have a customization you need to apply to a database environment.","To set your session settings:","Open the Primavera P6 Administrator.","In the Configurations drop-down list, select your configuration.","In the sidebar selectDatabase.","Select your Instance from the drop-down list.","Expand Session Settings.","In the Setting [n] field, enter the commands used to establish cursor sharing, rule-based mode, SQL trace, and more when database connections are created. Invalid settings in these fields are ignored. You can create five session settings.","Oracle or Oracle Autonomous Database Example:","alter session set _ = _","Microsoft SQL Server Example:","SET TRANSACTION ISOLATION LEVEL READ UNCOMMITTED","Note Changes to this setting require you to restart the P6 server.","Configuring Session Settings in the Database Instance Settings<br /> (Primavera P6 EPPM System Administration Guide for On-Premises)","English\\Admin\\p6_eppm_system_admin\\51567.htm");
Page[134]=new Array("The cost based optimization settings will enable you to manipulate base SQL queries based on optimization statistics.","Caution Do not alter these settings unless you are familiar with cost based optimization. Contact My Oracle Support for more information.","To set your cost based optimization settings:","Open the Primavera P6 Administrator.","In the Configurations drop-down list, select your configuration.","In the sidebar selectDatabase.","Select your Instance from the drop-down list.","Expand Cost Based Optimization settings.","Note Changes to these settings require you to restart the P6 server.","Select Enable, to enable Cost Based Optimization. Leave the field clear to disable it.","Select Dump Matching SQL, select to dump the SQL where a match is found in the QUERYLIB table for a given SQL statement.","Leaving the field clear to dump the SQL where a match is not found in the QUERYLIB table for a given SQL statement.","Note To see these entries, you must set your logging level to INFO in Configuring Log Settings.","Configuring Cost Based Optimization Settings in the Database Instance Settings<br /> (Primavera P6 EPPM System Administration Guide for On-Premises)","English\\Admin\\p6_eppm_system_admin\\51568.htm");
Page[135]=new Array("You must configure Oracle Analytics Publisher settings for Oracle Analytics Publisher to work with P6.","To configure your Oracle Analytics Publisher settings:","Open the Primavera P6 Administrator.","In the Configurations drop-down list, select your configuration.","In the sidebar selectDatabase.","Select your Instance from the drop-down list.","Expand BI Publisher.","Note Changes to these settings require you to restart the P6 server.","Select Personal Folders, to enable personal folders per user. If you do not want to use personal folders, leave the option clear. Users have their own personal folders where they can store their objects. Only the user who created and saved the content in the folder can access the folder.","In the Server URL field, enter the URL used to connect to the Oracle Analytics Publisher web service to P6.","For example, http://serverIP:port/xmlpserver/services/PublicReportService?wsdl","In the Folder Paths field, enter the relative path to the Oracle Analytics Publisher P6 reports folder where P6 will search for reports.","Example format (the forward slash is required):","/P6REPORTS","In the Version field, enter the version of Oracle Analytics Publisher that you want to integrate with P6.","In the Admin Username field, enter the username for a WebLogic Server Administrator.","In the Password field, enter the password for the WebLogic Server Administrator.","In the Sender Email ID field, enter the email address that you want users to see if they choose to receive reports by email.","Configuring Oracle Analytics Publisher in the Primavera P6 Administrator<br /> (Primavera P6 EPPM System Administration Guide for On-Premises)","English\\Admin\\p6_eppm_system_admin\\51591.htm");
Page[136]=new Array("To connect P6 and BPM:","Open the Primavera P6 Administrator.","In the Configurations tab, expand your configuration.","Expand Database.","Select your Instance from the drop-down list.","Expand BPM Settings.","Note Changes to these settings require you to restart the P6 server.","In the Type list, select BMP.","Note PCS is supported for SaaS environments only.","In the Connector File Location field, enter the full path (including the file name) where you copied the connector files.","For example:","c:\\oracle\\bpm1111x\\eppmjars\\prm-bpm-connector-12c-v1.0.jar or /home/oracle/bpm1111x/rm-bpm-connector-12c-v1.0.jar","In the BPM library path field, enter the path of the directory where you copied all the 12c jars.","Note If the above settings are incorrect or the BPM jar files are incomplete, you will be prompted with an error message when you try to configure the BPM. Verify that your settings and jar files are correct.","Select Configure BPM to set options from the dialog box. If you receive an error message, check your values from the previous steps in this section. ","To configure P6 to use BPM, add the following settings:","Caution Do not put a forward slash / at the end of the URL. For example, it should read only http://host:port, and not http://host:port/.","In the User field, enter the BPM user with administrative access to BPM.","In the Password field, enter the password for the user.","In the T3 URL field, enter the T3 URL for your Oracle SOA configuration. For example: t3://&lt;host_name&gt;:&lt;port&gt;/soa-infra.","In the Security Realm field, enter the name of the security realm used by BPM. This is jazn.com by default.","In the Soap URL field, enter the URL for the SOAP services. Usually this URL takes the form of http://&lt;host_name&gt;:&lt;port&gt;.","In the Workspace URL field, enter an address in the form of http://&lt;host_name&gt;:&lt;port&gt; that indicates where the BPM Workspace application is hosted.","Note The host can be an IP address or a host name such as a machine name.","In the Partition field, enter the name of the SOA partition containing the BPM composite applications you would like to use in P6. The default partition name is default.","Click Save. When the configuration is complete, you will see a BPM properties have been configured message. ","Restart the P6 application server.","Configuring P6 to Connect to Oracle BPM<br /> (Primavera P6 EPPM System Administration Guide for On-Premises)","English\\Admin\\p6_eppm_system_admin\\90216.htm");
Page[137]=new Array("To set your import/export options (Scheduled Service) settings:","Open the Primavera P6 Administrator.","In the Configurations drop-down list, select your configuration.","In the sidebar select Database.","Select your Instance from the drop-down list.","Expand Import/Export Options (Scheduled Services).","In the File Location field, enter the path you want the system to use for scheduled import and export jobs. All imports and exports, as well as all subfolders created or selected during scheduled jobs, are stored in the location specified in the File Location (Scheduled Service) field.<br />","Note There are separate File Location (Scheduled Services) fields for each of your available P6 EPPM database instances. Each field can be modified or set in Database/Instance/Import/Export Options (Scheduled Services).","Configuring Import/Export Options (Scheduled Service)<br /> (Primavera P6 EPPM System Administration Guide for On-Premises)","English\\Admin\\p6_eppm_system_admin\\94036.htm");
Page[138]=new Array("The Thread Pool performs background job work. These settings control how many thread pools are available and how long any job can use them. Oracle recommends you keep the defaults because they will provide optimal service for most environments. Change the defaults only if you are configuring a large amount of services (scheduler, leveler, apply actuals, etc.). ","To set your thread pool settings:","Open the Primavera P6 Administrator.","In the Configurations drop-down list, select your configuration.","In the sidebar selectThread Pool.","Note Changes to these settings require you to restart the P6 server.","In the Number of Threads field, enter the number of server threads.","The default value is 50.","In the Maximum Task Duration field, enter the maximum amount of time a task can use a thread from the P6 thread pool. Only the P6 activity view uses the P6 thread pool. ","The default value is 5m.","Since database transactions can run inside the P6 thread pool, Oracle recommends setting the duration to be longer than the Regular Connection Pool's Maximum Lease Duration setting.","Note","A thread from the P6 thread pool can only be interrupted when it is in a wait condition (such as waiting for a database request to complete).","See Configuring Connection Pool for Database Instance Settings for related settings.","In the Maximum Long Running Task Duration field, enter the maximum amount of time a long running task can run before being interrupted and canceled. This setting is used for Job Services (scheduler, summarizer, and leveler), which use the P6 Long Running Thread Pool. ","The default value is 20m.","Oracle recommends you set the Maximum Long Running Task Duration for the thread pool to a value longer than the Long Running Connection Pool's Maximum Lease Duration.","In the Maintenance Frequency field, enter the frequency at which threads are checked for excess time durations.","The default value is 45s.","Configuring Thread Pool Settings<br /> (Primavera P6 EPPM System Administration Guide for On-Premises)","English\\Admin\\p6_eppm_system_admin\\51469.htm");
Page[139]=new Array("Configuring AutoVue without VueLink is the native AutoVue implementation. To use this implementation, you will configure a single AutoVue server that is common across all database instances.","Note","When you configure AutoVue without VueLink, you are creating global AutoVue settings. These settings override any individual settings you may have created to configure AutoVue with VueLink.","When upgrading to Version 25 from 15 R2 or earlier, AutoVue connection details are lost and must be entered again.","To configure AutoVue without VueLink, complete the following steps:","Open the Primavera P6 Administrator.","In the Configurations drop-down list, select your configuration.","In the sidebar select Document Viewing.","Note Changes to these settings require you to restart the P6 server.","Select Enable. The default value is unselected.","Note","SSL mode does not work when the Enable option is set to false.","By default, the ESAPI resources that come with VueLink is used. You can change the location of the resource files by using -Dorg.owasp.espai.resources JAVA_OPTIONS in the WebLogic application server or in the setDomainEnv script.","By default, dmsstamp.ini and the oracle sample stamp from VueLink is used to create markup. You can change the location of the dmsstamp.ini file, which contains the stampfile location, using -Dexternal.csi.intellistamp.def.location JAVA_OPTIONS in the WebLogic application server or in the setDomainEnv script. ","If using Oracle Access Manager with your P6 EPPM deployment, add following context roots to the Oracle Access Manager exclusion list:<br />/p6/VueServlet/**<br />/p6/jvueDMS/**<br />/p6/P6AutoVueJNLPLauncher/**<br />/p6/av_cert.pem<br />For more information about protecting your resources using Oracle Access Manager's exclusion list, see the &quot;Protecting Your Resources&quot; chapter in the Oracle Access Manager Configuration Guide.","Select Enable SSL if your AutoVue server is enabled with SSL to allow communication via HTTPS.","In the Host Name field, enter the hostname for the server where AutoVue is installed. ","Note Do not put a / at the end of the URL.","In the Host Port field, enter the port for the server where AutoVue is installed. The default port is 5099.","Restart the P6 server.","Configuring AutoVue without VueLink<br /> (Primavera P6 EPPM System Administration Guide for On-Premises)","English\\Admin\\p6_eppm_system_admin\\94037.htm");
Page[140]=new Array("Outside In converts documents uploaded to your content repository into a raster-image file. ","To configure Outside In:","Open the Primavera P6 Administrator.","In the Configurations drop-down list, select your configuration.","In the sidebar selectDocument Viewing.","In the Fonts Directory field, enter the full path to your operating system-specific fonts folder. For example, C:\\Windows\\Fonts.","Note You cannot convert documents in languages that do not have a compatible font installed in the Fonts Directory. Before you convert these documents you must install the appropriate language font.","In the Images Directory field, enter the full path to your Outside In images folder. For example, P6EPPM_HOME\\P6\\outsidein\\ImageExport\\Images.","Navigate to P6EPPM_HOME\\P6.","Run outsideInConfig.cmd or outsideInConfig.sh (based on your operating system).","Configuring Outside In<br /> (Primavera P6 EPPM System Administration Guide for On-Premises)","English\\Admin\\p6_eppm_system_admin\\96417.htm");
Page[141]=new Array("You can use the log settings to set how the system logs errors and warnings.","To set your log settings:","Open the Primavera P6 Administrator.","In the Configurations drop-down list, select your configuration.","In the sidebar selectLog.","Select Asynchronous to log messages after the previous one has been logged for better performance. The default is unselected.","To configure Console Logger settings:","Select Enabled, to enable the console logger. The default is unselected.","In the Severity Level drop-down menu, select one of the following severity levels for the Console Logger:","error: Logs errors only.","warn: Logs errors and warnings only.","info: Logs errors, warnings, and informational messages only.","debug: Logs errors, warnings, informational messages, and debug comments.","Note","The default severity level is info.","The ranges are inclusive. For example, select &quot;debug&quot; to log all messages; select &quot;warning&quot; to log both warning and error level messages.","To configure File Logger settings:","Select Enabled, to enable the file logger. The default is selected.","Select HTML, to log as HTML, or leave the option clear to log as plain text.","Note Log files are created in a folder named WebAccessLogs, located in webaccesshome\\WebAccessLogs","In the Archive Size field, enter the minimum size (in Kb) a log file must be before it is archived.","The default value is 1024. ","Enter a value between 1024 and 15360.","In the Severity Level drop-down menu, select one of the following severity levels for the File Logger:","error: Logs errors only.","warn: Logs errors and warnings only.","info: Logs errors, warnings, and informational messages only.","debug: Logs errors, warnings, informational messages, and debug comments.","Note","The default severity level is error.","The ranges are inclusive. For example, select &quot;debug&quot; to log all messages; select &quot;warning&quot; to log both warning and error level messages.","In the Number of Archive Files field, enter the maximum number of log files to use. ","Enter a value between 2 and 2073600000. The default value is 6.","Note The default files are named WebAccessLog0.html through WebAccessLog5.html.","To configure Email Logger settings:","Note The email logger only sends information about Error messages.","Select Enabled, to enable the Email Logger. The default is unselected.","In the SMTP Host field, enter SMTP server that will send the email message.","In the Sender Email Address field, enter the email address that you want to send log messages.","In the Recipient Email Address field, enter the email address where you would like log messages sent.","In the Email Subject field, enter the subject line for error emails. The default value is P6 Web Access error.","Configuring Log Settings<br /> (Primavera P6 EPPM System Administration Guide for On-Premises)","English\\Admin\\p6_eppm_system_admin\\51474.htm");
Page[142]=new Array("You can use the log settings to set how the system logs errors and warnings.","To set your log settings:","Open the Primavera P6 Administrator.","In the Configurations drop-down list, select your configuration.","In the sidebar selectClient Properties.","Select Compress HTML Content to compress responses from REST API and Web Services.","In the HTTP Server And Port Override field, enter the HTTP front-end web server and port that P6 clients should use. Use URL format: http[s]://servername[:port], do not include context root.","Note This setting is only necessary if problems are encountered while using a front-end web server proxy.","In the Ajax Request Wait Timeout field, specify how long the server should wait for Business Process Management workflows and Action Required tabs to respond.","Configuring Client Properties Settings<br /> (Primavera P6 EPPM System Administration Guide for On-Premises)","English\\Admin\\p6_eppm_system_admin\\101145.htm");
Page[143]=new Array("When internal services in P6 EPPM need to access external web sites, they may need to go through your organization's firewall. You can configure that capability in the Web Proxy settings. P6 uses web proxy settings when it displays Contract Manager portlets that integrate with a Fusion server and when it connects to a Geo Code Provider server.","To set your web proxy settings:","Open the Primavera P6 Administrator.","In the Configurations drop-down list, select your configuration.","In the sidebar select Web Proxy.","In the Web Proxy Server field, enter the URL for your proxy server.","In the Web Proxy Port field, enter the port number for your proxy server.","In the Web Proxy Ignore List, type a comma separated list of the hosts that should not go through the proxy server. ","Configuring Web Proxy Settings<br /> (Primavera P6 EPPM System Administration Guide for On-Premises)","English\\Admin\\p6_eppm_system_admin\\51478.htm");
Page[144]=new Array("Once you have installed P6, you will need to set your Primavera P6 Administrator settings to create multiple databases and get items such as your help and tutorials working with P6. These settings also focus on items within P6 such as custom portlets.","About Application Settings in the Primavera P6 Administrator<br /> (Primavera P6 EPPM System Administration Guide for On-Premises)","English\\Admin\\p6_eppm_system_admin\\51595.htm");
Page[145]=new Array("P6 enables you to access data from different P6 EPPM databases. When you configure P6 to support multiple database instances, the Login page displays a Database list that enables users to choose the database instance where they want to connect.","Through the Primavera P6 Administrator, you can configure the server for P6 to manage user access to specific databases by requiring a database parameter in the URL. The database parameter, which is the name of a database instance, connects to the P6 server URL and points to that specific database instance. When users access the URL you specify, the Database list does not display in the Login page and they have login access only to the database instance defined by the database parameter. If users attempt to access the login page URL without specifying the required database parameter, a message displays to indicate that the URL is invalid and directs them to the administrator of P6.","For example, the following URL would log a user in to the database instance named Sample:","http://serverIP:listenport/login?db=Sample","As the administrator, you can specify a keyword that bypasses the database parameter requirement, so that you can access all databases through the Login page database list.","Follow instructions for the database dropdown key in Configuring Application Settings in the Primavera P6 Administrator to require a database parameter for the URL and to set a keyword to bypass the database parameter requirement.","Manage Access to Multiple Database Instances<br /> (Primavera P6 EPPM System Administration Guide for On-Premises)","English\\Admin\\p6_eppm_system_admin\\14430.htm");
Page[146]=new Array("To set your application settings:","Open the Primavera P6 Administrator.","In the Configurations drop-down list, select your configuration.","In the sidebar expandApplication and select General.","Do the following to configure your general application settings:","Select Ignore Daylight Savings Time to ignore daylight savings time or leave the field clear to use it.","Note","This setting will also impact P6 Team Member. If you notice dates and tasks are off by an hour in your P6 Team Member interfaces, the time difference could be caused by this setting.","Changes to this setting require you to restart the P6 server.","Select Allow Auto-Summarize Option to allow automatic summarization to be available in Resource Staffing user preferences.","Select Use HTTP POST for Custom Portlets to use HTTP POST requests instead of GET requests when loading custom portlets.","Select Enable Cross Site Scripting Filter to allow P6 EPPM to check for unsafe http requests from the browser and unsafe responses from P6, including requested documents. P6 EPPM considers requests and responses that contain JavaScript that P6 did not generate unsafe.","The browser will display an error message for all unsafe page requests. Internet Explorer 7 will show an error message if users attempt to download an unsafe document. Internet Explorer 8 and Firefox will prompt users to download the document file instead of viewing the document directly in the P6 browser.","Select Enable Cross Site Request Forgery Checking (CSRF) to allow CSRF for your environment.","Select Enable Session Hijack Checking to allow hijack checking.","In the Maximum Transactions for Excel Import of Resources field, enter the maximum number of transactions (activities or resources) that can be imported at once from an .xlsx or .csv file.","The default value is 2000.","Enter a value between 100 and 2000.","In the Database Dropdown Key field, enter the keyword to use for enabling database selection control in the login page. Pass this as a URL parameter db=keyword. See Manage Access to Multiple Database Instances for more information.","Set this to an empty string if you do not want to require the keyword.","You can also use the value you specify as the keyword to bypass the database requirement when logging in to the server for P6. For example, https://serverIP:listenport/login?db=bypass","In the Logout URL field, enter a specific URL that appears when the user exits with the Logout/Close icon in the banner of P6. You can use any valid URL. ","If you are using WebSSO, Oracle recommends you set the Logout URL to your SSO server's logout page to end the current SSO session.","If you do not specify a URL, P6 directs the user to the launch page of P6.","Note If you selected the &quot;Don't show this again&quot; option when you used the SSO login screen, that screen will not reappear after you logout then try to log back in. To get it to reappear, you need to clear the cookies for P6.","In the Hide Empty Project or WBS Threshold field, enter the maximum number of projects which the user can open before empty projects and WBS nodes will be hidden in the Activities view.","In the Custom Portlet URL Encryption Key field, enter Encryption key for custom portlet user password. ","In the Dashboards page of P6, users can create custom portlets. Depending on the target, P6 can pass the password of the currently logged on user to the target application. By default, the password is not encrypted. Use this setting to encrypt the password.","Note","Assigning a key encrypts the password that is part of the URL for a custom portlet.","The value can be any alphanumeric character or string of characters.","This encryption uses the Sun/Blowfish algorithm.","Changes to this setting require you to restart the P6 server.","See the P6 Help for more information on custom portlets.","In the Transaction Monitor Execution Interval field, enter how often the transaction monitor job will run. This will ensure there are no orphan transactions.","The default value is 10m. ","Enter a value between 1s and 24d20h31m23s647.","Note Changes to this setting require you to restart the P6 server.","In the P6 Help Server URL field, enter the URL used to launch P6 Help.","The default URL points to the version of the help hosted by Oracle. In contains the most up-to-date documentation.","Note If you prefer to use the local version of the P6 Help, you can use the local host URL. You can use the local help only if you installed and deployed the p6help.war file in WebLogic.","Example format:","http://&lt;server_name&gt;:&lt;listen_port&gt;/&lt;context_root&gt;","The URL might be case-sensitive, depending on your application server configuration.","In the TM Help Server URL field, enter the URL used to launch P6 Team Member Help.","The default URL points to the version hosted by Oracle. It contains the most up-to-date documentation.","Note If you prefer to use the local version of the P6 Team Member Help, you can use the local host URL. You can use the local help only if you installed and deployed the p6tmhelp.war file in WebLogic.","The URL might be case-sensitive, depending on your application server configuration.","In the System Administration Help Server URL field, enter the URL for system administration help.","Example format:","http://&lt;server_name&gt;:&lt;listen_port&gt;/&lt;context_root&gt;","Configuring Application Settings in the Primavera P6 Administrator<br /> (Primavera P6 EPPM System Administration Guide for On-Premises)","English\\Admin\\p6_eppm_system_admin\\51596.htm");
Page[147]=new Array("To set your User Productivity Kit (UPK) settings:","Open the Primavera P6 Administrator.","In the Configurations drop-down list, select your configuration.","In the sidebar selectApplication/User Productivity Kit.","Select Enable User Productivity Kit to allow tutorials to be available within P6 EPPM.","Note See the documentation included with Oracle UPK (User Productivity Kit) for details on In-Application Support.","In the User Productivity Kit URL field, enter the URL used to launch UPK content.","Note","The URL might be case-sensitive, depending on your application server configuration.","WebLogic requires that the name of the UPK file stay the same when a custom UPK file is deployed. If you change the file name, you must create a new domain in WebLogic to match the name of the new UPK file.","A UPK URL entered here is used for both P6 and P6 Team Member Web. A separate P6 EPPM configuration must be made to use different content in these products.","Configuring User Productivity Kit Settings in Application Settings<br /> (Primavera P6 EPPM System Administration Guide for On-Premises)","English\\Admin\\p6_eppm_system_admin\\51614.htm");
Page[148]=new Array("Once you have installed P6, you will need to set your Primavera P6 Administrator services settings to set items such as scheduler, leveler, and apply actuals. These services settings manage your long running services including when to run them and how many threads to use.","Oracle recommends having at least two configurations: one for application servers hosting P6 and another for the background service applications that run services, but do not process web pages. You can create more configurations as needed.","For the P6 application server, you need to limit background services and how often they run. This will allow users' requests to process more quickly.","For the background services configuration, you can have more threads configured and run them at shorter intervals. For information on setting up a separate server for job services, see Configuring a Separate Server for Job Services.","If you are running background services and P6 on the same server, Oracle recommends keeping the settings' defaults for your configuration.","About the Primavera P6 Administrator Services Settings<br /> (Primavera P6 EPPM System Administration Guide for On-Premises)","English\\Admin\\p6_eppm_system_admin\\51615.htm");
Page[149]=new Array("The availability of ASAP and Scheduled Services depends on which Primavera P6 Administrator settings you populate and whether you are using P6 or P6 Professional. The summary below will help you to determine when you need to configure the Primavera P6 Administrator for job services.","ASAP Jobs","For P6, you must populate the appropriate Primavera P6 Administrator settings for all ASAP jobs that you want to run.","For P6 Professional, you must populate the Summarizer and Apply Actuals Primavera P6 Administrator settings for those features to run. The Scheduler, Leveler, Store Period Performance, and Recalculate Assignment Costs features will run locally in P6 Professional.","Scheduled Services Jobs","For P6, you must populate the appropriate Primavera P6 Administrator settings for all scheduled services jobs that you want to run. All scheduled services jobs are run from and are displayed in P6.","P6 Professional cannot run any scheduled services jobs or display the status of P6 scheduled services jobs.","Note Scheduled Services cannot run for Project Templates; however, Scheduler, Leveler, and Recalculate Assignment Costs features can be run as ASAP jobs for templates in P6.","Configuration for ASAP and Scheduled Services<br /> (Primavera P6 EPPM System Administration Guide for On-Premises)","English\\Admin\\p6_eppm_system_admin\\45646.htm");
Page[150]=new Array("To set your services settings:","Note If you are running services and P6 on the same server, you should keep the defaults for the rates settings. If you want to apply the service immediately, set the rates low. Remember that if the server is actively applying the service, all users will experience delays in the application.","Open the Primavera P6 Administrator.","In the Configurations drop-down list, select your configuration.","In the sidebar expandServices and select General.","Select Enable All Services to enable all services without having to set concurrent threads on each service. If selected, the application will use the concurrent threads for all services. Oracle recommends enabling all services if you are using the Summarize or Apply Actuals features in P6 Professional.","Ensure the field is clear if you want the application to treat the concurrent threads of services as equal to zero. When you set to false, the values for the threads will stay the same.","Select Enable Job Cleanup on Startup to restart recurring jobs that are stuck in the running state.","Enable Job Cleanup on Startup will start when the application initially launches and will check for any recurring jobs that are running. It will set the status of all running jobs to pending for all databases that have Database/Instance/Auto Start Services enabled. It also follows the Services/Enable All Services setting and will not run if Enable All Services is set to false. ","Enable Job Cleanup on Startup can run on a full build or the separate job services application. If you are on a clustered environment, run this service in only one instance.","In the Job Service Poll Rate field, enter the rate at which the server polls the database for new jobs to run.","The default value is 10s.","Enter a value between 1s and 24d20h31m23s647.","In the ASAP Cleanup Rate field, enter the rate that the database removes completed WebASAP jobs from the database.","The default value is 1d.","Enter a value between 1d and 24d.","Once the time is met all ASAP jobs that have a status other than running or delegated will be removed from the table automatically. Running and delegated jobs will be removed if they are older than the cleanup rate or if they are older than one day, whichever is greater.","Note Confirm that the cleanup rate is greater than your longest running job.","In the Job Service Shared Folder Location field, enter the location to store temporary files while they are in the job queue.","Tip","See Configuring a Job Services Server Using p6services.jar for more information on these settings.","Configuring Services Settings<br /> (Primavera P6 EPPM System Administration Guide for On-Premises)","English\\Admin\\p6_eppm_system_admin\\51616.htm");
Page[151]=new Array("Modify publication settings to specify constraints on your report publishing jobs. ","To configure your publication settings:","Note The default settings should be the optimal settings for most environments. Change them only if your environment requires different settings.","Open the Primavera P6 Administrator.","In the Configurations drop-down list, select your configuration.","In the sidebar expandServices, then expand Publication, and select Settings.","To configure General Data:","In the Page Size field, enter the maximum number of rows of general data a job can process. This applies to each business object that falls under the general category; general data is not time-distributed (spread), not hierarchical, and not in a blob. When using this setting, each business object processes separately.","The default value is 32.","Enter a value between 1 and 8192.","In the Max Job Count field, enter the number of processes used for this service on your server.","The default value is 1.","Enter a value between 1 and 20.","To configure Blob Data:","In the Page Size field, enter the maximum number of rows of blob data that a job can process. This applies to each business object that falls under the blob category. When using this setting, each business object processes separately.","The default value is 25.","Enter a value between 1 and 8192.","In the Max Job Count field, enter the number of processes used for this service on your server.","The default value is 1.","Enter a value between 1 and 20.","To configure TimeDistributed:","In the Page Size field, enter the maximum number of rows of time-distributed (spread) data that a job can process. This applies to each business object that falls under the time-distributed category. When using this setting, each business object processes separately.","The default value is 16.","Enter a value between 1 and 8192.","In the Max Job Count field, enter the number of processes used for this service on your server.","The default value is 1.","Enter a value between 1 and 20.","To configure Log:","In the Security Level drop-down menu, select the level of information contained in the log file for all publication services. The ranges are inclusive. For example, select debug to log all messages; select info to log details about what runs, exceptions, and warnings; select warning to log both warning and error level messages.","The default value is info.","Select info, debug, warning, or error.","In the Global Service Log File Cap (Success) field, enter the number of logs to retain for successful global publication services. This will retain a log for each global service. If set to 5, the last 5 successful service runs will be retained for each global service.","The default value is 5.","Enter a value between 1 and 25.","In the Global Service Log File Cap (Fail) field, enter the number of logs to retain for failed global publication services. This will retain a log for each global service. If set to 5, the last 5 failed service runs will be retained for each global service.","The default value is 5.","Enter a value between 1 and 25.","In the Project Service Log File Cap (Success) field, enter the number of logs to retain for successful Publish Project jobs. This will retain a log for each project service. If set to 5, the last 5 successful service runs will be retained.","The default value is 5.","Enter a value between 1 and 25.","In the Project Service Log File Cap (Fail) field, enter the number of logs to retain for failed Publish Project jobs. This will retain a log for each project service. If set to 5, the last 5 failed service runs will be retained, per project.","The default value is 5.","Enter a value between 1 and 25.","Configuring Publication Settings in Services Settings<br /> (Primavera P6 EPPM System Administration Guide for On-Premises)","English\\Admin\\p6_eppm_system_admin\\51618.htm");
Page[152]=new Array("If you are running services and P6 on the same server, you should keep the defaults. If you have scheduling work that needs to be done immediately, you should set the Interval low (for example, 10s) and the Concurrent Threads high. Remember that if the server is actively applying the service, all users will experience delays in the application.","To configure your publication settings:","Open the Primavera P6 Administrator.","In the Configurations drop-down list, select your configuration.","In the sidebar expand Services, then expand Publication, and select Services.","You can use Project Arbiter to automate submitting Publish Project services for eligible projects to the service queue.","To configure Project&nbsp;Arbiter:","Select Active Mode if you want jobs processed continuously until all jobs finish. Leave this field clear if you want each job processed according to the Interval.","In the Interval field, enter the amount of time the service will wait before running the next available job.","The default value is 10s.","Enter a value between 1s and 24d20h31m23s647.","In the Concurrent Threads field, enter the number of processes used for this service on this server. A value of 0 indicates that this service will not run on this server. ","The default value is 1. ","Enter either 0 or 1.","To configure Publish Enterprise Summaries:","Note Publish Enterprise Data, Enterprise Summaries, Resource Management, and Security will recalculate data and store it in physical fields in the Extended Schema tables, and will perform other data denormalization tasks. For example, duration fields are calculated fields in the existing P6 schema tables, but will be recalculated and stored as physical fields in the extended schema tables when a project is published.","Select Active Mode if you want jobs processed continuously until all jobs finish. Leave this field clear if you want each job processed according to the Interval.","In the Interval field, enter the amount of time the service will wait before running the next available job.","The default value is 10s. ","Enter a value between 1s and 24d20h31m23s647.","In the Concurrent Threads field, enter the number of processes used for this service on this server. A value of 0 indicates that this service will not run on this server. ","The default value is 1. ","Enter either 0 or 1.","To configure Publish Resource Management:","Select Active Mode if you want jobs processed continuously until all jobs finish. Leave this field clear if you want each job processed according to the Interval.","In the Interval field, enter the amount of time the service will wait before running the next available job.","The default value is 10s. ","Enter a value between 1s and 24d20h31m23s647.","In the Concurrent Threads field, enter the number of processes used for this service on this server. A value of 0 indicates that this service will not be run on this server. ","The default value is 1. ","Enter either 0 or 1.","To configure Publish Resource Role Assignment:","Select Active Mode if you want jobs processed continuously until all jobs finish. Leave this field clear if you want each job processed according to the Interval.","In the Interval field, enter the amount of time the service will wait before running the next available job.","The default value is 10s.","Enter a value between 1s and 24d20h31m23s647.","In the Concurrent Threads field, enter the number of processes used for this service on this server. A value of 0 indicates that this service will not run on this server.","The default value is 1.","Enter either 0 or 1.","To configure Publish Project:","Select Active Mode field if you want jobs processed continuously until all jobs finish. Leave this field clear if you want each job processed according to the Interval.","In the Interval field, enter the amount of time the service will wait before running the next available job.","The default value is 10s. ","Enter a value between 1s and 24d20h31m23s647.","In the Concurrent Threads field, enter the number of processes used for this service on this server. A value of 0 indicates that this service will not be run on this server. ","The default value is 2. ","Enter a value between 0 and 20.","To configure Publish Enterprise Summaries:","Note Publish Enterprise Data, Enterprise Summaries, Resource Management, and Security will recalculate data and store it in physical fields in the Extended Schema tables, and will perform other data denormalization tasks. For example, duration fields are calculated fields in the existing P6 schema tables, but will be recalculated and stored as physical fields in the extended schema tables when a project is published.","Select Active Mode if you want jobs processed continuously until all jobs finish. Leave this field clear if you want each job processed according to the Interval.","In the Interval field, enter the amount of time the service will wait before running the next available job.","The default value is 10s. ","Enter a value between 1s and 24d20h31m23s647.","In the Concurrent Threads field, enter the number of processes used for this service on this server. A value of 0 indicates that this service will not run on this server. ","The default value is 1. ","Enter either 0 or 1.","Configuring Publication Services in Services Settings<br /> (Primavera P6 EPPM System Administration Guide for On-Premises)","English\\Admin\\p6_eppm_system_admin\\51619.htm");
Page[153]=new Array("If you are running services and P6 on the same server, you should keep the defaults.","To set your delete published data settings:","Open the Primavera P6 Administrator.","In the Configurations drop-down list, select your configuration.","In the sidebar expand Services, then expand Publication, and select Delete Published Data.","Select Active Mode if you want jobs processed continuously until all jobs finish. Leave this field clear if you want each job processed according to the Interval.","In the Interval field, enter the amount of time the DeletePublishedData service will wait before scheduling the next available job (in 1d1h1m1s format, specifying only numbers without letters implies milliseconds). When P6 initiates the DeletePublishedData service, it will attempt to run immediately but switch to running as a job service if it takes too long to start. ","The default value is 10s.","Enter a value between 1s and 24d20h31m23s647.","In the Concurrent Threads field, enter the number of processes used for the DeletePublishedData service on this server. A value of 0 indicates that the service is not available on this server.","The default value is 2.","Enter a value between 0 and 20.","Configuring Delete Published Data in Services Settings<br /> (Primavera P6 EPPM System Administration Guide for On-Premises)","English\\Admin\\p6_eppm_system_admin\\98268.htm");
Page[154]=new Array("If you are running services and P6 on the same server, you should keep the defaults. If you have scheduling work that needs to be done immediately, you should set the Interval low (for example, 10s) and the Concurrent Threads high (for example, 20). Remember that if the server is actively scheduling work, all users will experience delays in the application.","To set your scheduler settings:","Open the Primavera P6 Administrator.","In the Configurations drop-down list, select your configuration.","In the sidebar expand Services, then expand Publication and select Job Services.","Select Scheduler.","Select Active Mode if you want jobs processed continuously until all jobs finish. Clear this field if you want each job processed according to the Interval.","Select Load All Calendars Till Threshold.","In the Interval field, select the amount of time to wait before running the next available job.","The default value is 10s.","Enter a value between 1 second and 24 days.","In the Concurrent Threads field, enter the number of processes used for this service on this server. A value of 0 indicates that that this job will not run on this server.","The default value is 2.","Enter a value between 0 and 20.","Configuring Scheduler in Services Settings<br /> (Primavera P6 EPPM System Administration Guide for On-Premises)","English\\Admin\\p6_eppm_system_admin\\51628.htm");
Page[155]=new Array("If you are running services and P6 on the same server, you should keep the defaults. If you have leveling work that needs to be done immediately, you should set the Interval low (for example, 10s) and the Concurrent Threads high (for example, 20). Remember that if the server is actively doing leveling work, all users will experience delays in the application.","To set your leveler settings:","Open the Primavera P6 Administrator.","In the Configurations drop-down list, select your configuration.","In the sidebar expand Services, then expand Publication and select Job Services.","Select Leveler.","Select Active Mode if you want jobs processed continuously until all jobs finish. Clear this field if you want each job processed according to the Interval.","In the Interval field, select the amount of time to wait before running the next available job.","The default value is 10s.","Enter a value between 1 second and 24 days.","In the Concurrent Threads field, enter the number of processes used for this service on this server. A value of 0 indicates that that this job will not run on this server.","The default value is 2.","Enter a value between 0 and 20.","Configuring Leveler in Services Settings<br /> (Primavera P6 EPPM System Administration Guide for On-Premises)","English\\Admin\\p6_eppm_system_admin\\51629.htm");
Page[156]=new Array("If you are running services and P6 on the same server, you should keep the defaults. If you have summarizing work that needs to be done immediately, you should set the Interval low (for example, 10s) and the Concurrent Threads high (for example, 20). Remember that if the server is actively doing summarizing work, all users will experience delays in the application.","To set your summarizer settings:","Open the Primavera P6 Administrator.","In the Configurations drop-down list, select your configuration.","In the sidebar expand Services, then expand Publication and select Job Services.","Select Summarizer.","Select Active Mode if you want jobs processed continuously until all jobs finish. Clear this field if you want each job processed according to the Interval.","In the Interval field, select the amount of time to wait before running the next available job.","The default value is 10s.","Enter a value between 1 second and 24 days.","In the Concurrent Threads field, enter the number of processes used for this service on this server. A value of 0 indicates that that this job will not run on this server.","The default value is 2.","Enter a value between 0 and 20.","In the Maximum Duration to Summarize field, enter the maximum activity duration in hours that the summarizer will handle. Any projects that contain activities with durations longer than this setting will fail summarization and an error will be displayed for that project.","The default value is 100,000.","Configuring Summarizer in Services Settings<br /> (Primavera P6 EPPM System Administration Guide for On-Premises)","English\\Admin\\p6_eppm_system_admin\\51630.htm");
Page[157]=new Array("If you are running services and P6 on the same server, you should keep the defaults. If you have apply actuals work that needs to be done immediately, you should set the Interval low (for example, 10s) and the Concurrent Threads high (for example, 20). Remember that if the server is actively applying actuals, all users will experience delays in the application.","To set your apply actuals settings:","Open the Primavera P6 Administrator.","In the Configurations drop-down list, select your configuration.","In the sidebar expand Services, then expand Publication and select Job Services.","Select Apply Actuals.","Select Active Mode if you want jobs processed continuously until all jobs finish. Clear this field if you want each job processed according to the Interval.","In the Interval field, select the amount of time to wait before running the next available job.","The default value is 10s.","Enter a value between 1 second and 24 days.","In the Concurrent Threads field, enter the number of processes used for this service on this server. A value of 0 indicates that that this job will not run on this server.","The default value is 2.","Enter a value between 0 and 20.","Configuring Apply Actuals in Services Settings<br /> (Primavera P6 EPPM System Administration Guide for On-Premises)","English\\Admin\\p6_eppm_system_admin\\51631.htm");
Page[158]=new Array("If you are running services and P6 on the same server, you should keep the defaults. If you have store period performance work that needs to be done immediately, you should set the Interval low (for example, 10s) and the Concurrent Threads high (for example, 20). Remember that if the server is actively running store period performance work, all users will experience delays in the application.","To set your import/export settings:","Open the Primavera P6 Administrator.","In the Configurations drop-down list, select your configuration.","In the sidebar expand Services, then expand Publication and select Job Services.","Select Import/Export.","Under Import/Export Service:","Select Active Mode if you want jobs processed continuously until all jobs finish. Clear this field if you want each job processed according to the Interval.","In the Interval field, select the amount of time to wait before running the next available job.","The default value is 10s.","Enter a value between 1 second and 24 days.","In the Concurrent Threads field, enter the number of processes used for this service on this server. A value of 0 indicates that that this job will not run on this server.","The default value is 2.","Enter a value between 0 and 20..","Configuring Import/Export Service in Services Settings<br /> (Primavera P6 EPPM System Administration Guide for On-Premises)","English\\Admin\\p6_eppm_system_admin\\85633.htm");
Page[159]=new Array("To set your import/export options settings:","Open the Primavera P6 Administrator.","In the Configurations drop-down list, select your configuration.","In the sidebar expand Services, then expand Publication and select Job Services.","Select Import/Export.","Under Import/Export Options:","Select Store Files In Database if you want imported files including images to be stored in the database. Leave this field clear if you do not want files to be stored in the database.","In the Temporary File Location(ASAP Service) field, enter the location to store the temporary file during the XML import/export process or image storing process. If you do not specify a location, the temporary file is placed in the bootstrap home location, which is in the P6 home directory (for example, c:\\p6home).","In the Maximum file size field, enter the maximum file size (in KB) for XML import/export and image files. JVM settings and available space in the Temporary File Location determine the file size. Users might need to alter the memory settings in their application server if the import/export file size is greater than the maximum default file size.","The default value is 102400.","Enter a value between 1024 and 2147483647.","Note There are also settings to configure the maximum height and width of stored images in P6 on the Data Limits page of Application Settings.","Configuring Import/Export Options in Services Settings<br /> (Primavera P6 EPPM System Administration Guide for On-Premises)","English\\Admin\\p6_eppm_system_admin\\51647.htm");
Page[160]=new Array("To set your Unifier integration settings:","Open the Primavera P6 Administrator.","In the Configurations drop-down list, select your configuration.","In the sidebar expand Services, then expand Publication and select Job Services.","Select Unifier.","The SendToScheduleSheet service sends P6 data to Unifier's schedule sheet when the Send to Schedule Sheet action is used in P6.","In the SendToScheduleSheet area:","Select Active Mode if you want jobs processed continuously until all jobs finish. Clear this field if you want each job processed according to the Interval.","In the Interval field, select the amount of time to wait before running the next available job.","The default value is 10s.","Enter a value between 1 second and 24 days.","In the Concurrent Threads field, enter the number of processes used for this service on this server. A value of 0 indicates that that this job will not run on this server.","The default value is 2.","Enter a value between 0 and 20.","The SummarizeByCBS service creates either CBS Summary data or Resource and Expenses Summary and Spread data depending on a project's Schedule Type when the Send to Summary Sheet action is used in P6.","In the SummarizeByCBS area:","Select Active Mode if you want jobs processed continuously until all jobs finish. Clear this field if you want each job processed according to the Interval.","In the Interval field, select the amount of time to wait before running the next available job.","The default value is 10s.","Enter a value between 1 second and 24 days.","In the Concurrent Threads field, enter the number of processes used for this service on this server. A value of 0 indicates that that this job will not run on this server.","The default value is 2.","Enter a value between 0 and 20.","If a project has been summarized and there hasn't been any changes made to the project since it was summarized, the ProjectUpdateCheck service will prevent the SummarizeByCBS service from running.","In the ProjectUpdateCheck area:","Select Active Mode if you want jobs processed continuously until all jobs finish. Clear this field if you want each job processed according to the Interval.","In the Interval field, select the amount of time to wait before running the next available job.","The default value is 10s.","Enter a value between 1 second and 24 days.","In the Concurrent Threads field, enter the number of processes used for this service on this server. A value of 0 indicates that that this job will not run on this server.","The default value is 2.","Enter a value between 0 and 20.","Configuring Unifier in Services Settings<br /> (Primavera P6 EPPM System Administration Guide for On-Premises)","English\\Admin\\p6_eppm_system_admin\\78351.htm");
Page[161]=new Array("If you are running services and P6 on the same server, you should keep the defaults. If you want the server to check for overallocations immediately, you should set the Interval low (for example, 10s) and the Concurrent Threads high (for example, 20). Remember that if the server is actively checking for overallocations, all users will experience delays in the application.","Note Enable the Project Arbiter service because projects will be published before running the overallocation service.","To set your overallocation check settings:","Open the Primavera P6 Administrator.","In the Configurations drop-down list, select your configuration.","In the sidebar expand Services, then expand Publication and select Job Services.","Select Overallocation Check.","Select Active Mode if you want jobs processed continuously until all jobs finish. Clear this field if you want each job processed according to the Interval.","In the Interval field, select the amount of time to wait before running the next available job.","The default value is 10s.","Enter a value between 1 second and 24 days.","In the Concurrent Threads field, enter the number of processes used for this service on this server. A value of 0 indicates that that this job will not run on this server.","The default value is 2.","Enter a value between 0 and 20.","Configuring Overallocation Check in Services Settings<br /> (Primavera P6 EPPM System Administration Guide for On-Premises)","English\\Admin\\p6_eppm_system_admin\\51632.htm");
Page[162]=new Array("To set your global replace settings:","Open the Primavera P6 Administrator.","In the Configurations drop-down list, select your configuration.","In the sidebar expand Services, then expand Publication and select Job Services.","Select Global Replace.","Select Active Mode if you want jobs processed continuously until all jobs finish. Clear this field if you want each job processed according to the Interval.","In the Interval field, select the amount of time to wait before running the next available job.","The default value is 10s.","Enter a value between 1 second and 24 days.","In the Concurrent Threads field, enter the number of processes used for this service on this server. A value of 0 indicates that that this job will not run on this server.","The default value is 2.","Enter a value between 0 and 20.","Configuring Global Replace Service in Services Settings<br /> (Primavera P6 EPPM System Administration Guide for On-Premises)","English\\Admin\\p6_eppm_system_admin\\90460.htm");
Page[163]=new Array("If you are running services and P6 on the same server, you should keep the defaults. If you want to sync actuals immediately, you should set the Interval low (for example, 10s) and the Concurrent Threads high (for example, 20). Remember that if the server is actively synchronizing actuals, all users will experience delays in the application.","To set your sync actual this period settings:","Open the Primavera P6 Administrator.","In the Configurations drop-down list, select your configuration.","In the sidebar expand Services, then expand Publication and select Job Services.","Select Sync Units.","Under Sync Actual This Period:","Select Enabled to enable the service. Clear this field to disable the service.","If you enable this service, P6 automatically recalculates actual units and costs for ThisPeriod.","In the Execution Interval field, select the amount of time to wait before checking for any jobs. The service will poll the job service table and the execution interval will determine when it starts.","The default value is 5 minutes.","Enter a value between 1 second and 24 days.","In the ActivityThreshold field, determine if the SyncActualThisPeriod service will run simultaneously or as a job service. ","If the number of activities in a project is over the activity threshold, the SyncActualThisPeriod will run as a job service and add an entry to the job service table. The SyncActualThisPeriod service will poll the job service table, and the execution interval will determine when it starts. If the number of activities in a project is under the activity threshold, it will run immediately and will not add an entry to the job service table.","The default value is 8000.","Enter a value between 1 and 2147483647.","In the Concurrent Threads field, enter the number of processes used for this service on this server. A value of 0 indicates that that this job will not run on this server.","The default value is 2.","Enter a value between 0 and 20.","Configuring Sync Actual This Period in Services Settings<br /> (Primavera P6 EPPM System Administration Guide for On-Premises)","English\\Admin\\p6_eppm_system_admin\\51638.htm");
Page[164]=new Array("If you are running services and P6 on the same server, you should keep the defaults. If you want to sync immediately, you should set the Interval low (for example, 10s) and the Concurrent Threads high (for example, 20). Remember that if the server is actively synchronizing, all users will experience delays in the application.","To set your sync remaining to planned settings:","Open the Primavera P6 Administrator.","In the Configurations drop-down list, select your configuration.","In the sidebar expand Services, then expand Publication and select Job Services.","Select Sync Units.","Under Sync Remaining to Planned:","Select Enabled to enable the service. Clear this field to disable the service.","In the Execution Interval field, select the amount of time to wait before checking for any jobs. The service will poll the job service table and the execution interval will determine when it starts.","The default value is 5 minutes.","Enter a value between 1 second and 24 days.","In the ActivityThreshold field, determine if the SyncRemainingtoPlanned service will run simultaneously or as a job service.","If the number of activities in a project is over the activity threshold, the SyncRemainingtoPlanned will run as a job service and add an entry to the job service table. The SyncRemainingtoPlanned service will poll the job service table, and the execution interval will determine when it starts. If the number of activities in a project is under the activity threshold, it will run immediately and will not add an entry to the job service table.","The default value is 8000.","Enter a value between 1 and 30000.","In the Concurrent Threads field, enter the number of processes used for this service on this server. A value of 0 indicates that that this job will not run on this server.","The default value is 2.","Enter a value between 0 and 20.","Configuring Sync Remaining to Planned in Services Settings<br /> (Primavera P6 EPPM System Administration Guide for On-Premises)","English\\Admin\\p6_eppm_system_admin\\51639.htm");
Page[165]=new Array("If you are running services and P6 on the same server, you should keep the defaults. If you want to sync actuals immediately, you should set the Interval low (for example, 10s) and the Concurrent Threads high (for example, 20). Remember that if the server is actively synchronizing actuals, all users will experience delays in the application.","To set your sync actuals with duration % complete settings:","Open the Primavera P6 Administrator.","In the Configurations drop-down list, select your configuration.","In the sidebar expand Services, then expand Publication and select Job Services.","Select Sync Units.","Under Sync Actuals with Duration % Complete:","Select Enabled to enable the service. Clear this field to disable the service.","In the Execution Interval field, select the amount of time to wait before checking for any jobs. The service will poll the job service table and the execution interval will determine when it starts.","The default value is 5 minutes.","Enter a value between 1 second and 24 days.","In the ActivityThreshold field, determine if the SyncActualswithDuration%Complete service will run simultaneously or as a job service.","If the number of activities in a project is over the activity threshold, the SyncActualswithDuration%Complete will run as a job service and add an entry to the job service table. The SyncActualswithDuration%Complete service will poll the job service table, and the execution interval will determine when it starts. If the number of activities in a project is under the activity threshold, it will run immediately and will not add an entry to the job service table.","The default value is 8000.","Enter a value between 1 and 2147483647.","In the Concurrent Threads field, enter the number of processes used for this service on this server. A value of 0 indicates that that this job will not run on this server.","The default value is 2.","Enter a value between 0 and 20.","Configuring Sync Actuals with Duration % Complete in Services Settings<br /> (Primavera P6 EPPM System Administration Guide for On-Premises)","English\\Admin\\p6_eppm_system_admin\\51640.htm");
Page[166]=new Array("If you are running services and P6 on the same server, you should keep the defaults. If you want the server to check CopyProject immediately, you should set the Interval low (for example, 10s) and the Concurrent Threads high (for example, 20). Remember that if the server is actively checking for CopyProject, all users will experience delays in the application.","To configure the copy project settings:","Open the Primavera P6 Administrator.","In the Configurations drop-down list, select your configuration.","In the sidebar expand Services, then expand Publication and select Job Services.","Select CopyProject.","Select Active Mode if you want jobs processed continuously until all jobs finish. Clear this field if you want each job processed according to the Interval.","In the Interval field, select the amount of time to wait before running the next available job.","The default value is 10s.","Enter a value between 1 second and 24 days.","In the Concurrent Threads field, enter the number of processes used for this service on this server. A value of 0 indicates that that this job will not run on this server.","The default value is 2.","Enter a value between 0 and 20.","Configuring CopyProject in Services Settings<br /> (Primavera P6 EPPM System Administration Guide for On-Premises)","English\\Admin\\p6_eppm_system_admin\\85632.htm");
Page[167]=new Array("As a project progresses, you might choose to update baseline data without restoring the baseline or creating a new baseline. When a project is in progress, creating a new baseline may not yield accurate comparison results. When you update a baseline, only the data types you select will be updated. You may also create and copy baselines efficiently.","To set your baseline settings:","Open the Primavera P6 Administrator.","In the Configurations drop-down list, select your configuration.","In the sidebar expand Services, then expand Publication and select Job Services.","Select Baseline.","In the Create/Copy baseline section:","Select Active Mode if you want jobs processed continuously until all jobs finish. Clear this field if you want each job processed according to the Interval.","In the Interval field, select the amount of time to wait before running the next available job.","The default value is 10s.","Enter a value between 1 second and 24 days.","In the Concurrent Threads field, enter the number of processes used for this service on this server. A value of 0 indicates that that this job will not run on this server.","The default value is 2.","Enter a value between 0 and 20.","In the Update Baseline section:","Select Active Mode if you want jobs processed continuously until all jobs finish. Clear this field if you want each job processed according to the Interval.","In the Interval field, select the amount of time to wait before running the next available job.","The default value is 10s.","Enter a value between 1 second and 24 days.","In the Concurrent Threads field, enter the number of processes used for this service on this server. A value of 0 indicates that that this job will not run on this server.","The default value is 2.","Enter a value between 0 and 20.","Configuring Baseline in Service Settings<br /> (Primavera P6 EPPM System Administration Guide for On-Premises)","English\\Admin\\p6_eppm_system_admin\\89731.htm");
Page[168]=new Array("The GatewaySynchronization service sends information from P6 to Primavera Unifier or Oracle Primavera Cloud via Primavera Gateway.","To configure Gateway synchronization:","Open the Primavera P6 Administrator.","In the Configurations drop-down list, select your configuration.","In the sidebar expand Services, then expand Publication and select Job Services.","Select GatewaySynchronization.","Select Active Mode if you want jobs processed continuously until all jobs finish. Clear this field if you want each job processed according to the Interval.","In the Interval field, select the amount of time to wait before running the next available job.","The default value is 10s.","Enter a value between 1 second and 24 days.","In the Concurrent Threads field, enter the number of processes used for this service on this server. A value of 0 indicates that that this job will not run on this server.","The default value is 2.","Enter a value between 0 and 20.","In the Timeout for Gateway job completion field, enter the maximum time P6 will wait for a gateway job to be completed before marking its status as failed or timed out.","The default value is 12 minutes.","Enter a value between 1 minute and 2 days.","Configuring GatewaySynchronization<br /> (Primavera P6 EPPM System Administration Guide for On-Premises)","English\\Admin\\p6_eppm_system_admin\\88636.htm");
Page[169]=new Array("If you are running services and P6 on the same server, you should keep the defaults. If you have store period performance work that needs to be done immediately, you should set the Interval low (for example, 10s) and the Concurrent Threads high (for example, 20). Remember that if the server is actively running store period performance work, all users will experience delays in the application.","To set your store period performance settings:","Open the Primavera P6 Administrator.","In the Configurations drop-down list, select your configuration.","In the sidebar expand Services, then expand Publication and select Job Services.","Select Store Period Performance.","Select Active Mode if you want jobs processed continuously until all jobs finish. Clear this field if you want each job processed according to the Interval.","In the Interval field, select the amount of time to wait before running the next available job.","The default value is 10s.","Enter a value between 1 second and 24 days.","In the Concurrent Threads field, enter the number of processes used for this service on this server. A value of 0 indicates that that this job will not run on this server.","The default value is 2.","Enter a value between 0 and 20.","Configuring Store Period Performance in Services Settings<br /> (Primavera P6 EPPM System Administration Guide for On-Premises)","English\\Admin\\p6_eppm_system_admin\\51635.htm");
Page[170]=new Array("If you are running services and P6 on the same server, you should keep the defaults. If you have recalculate assignment cost work that needs to be done immediately, you should set the Interval low (for example, 10s) and the Concurrent Threads high (for example, 20). Remember that if the server is actively running recalculate assignment cost work, all users will experience delays in the application.","To set your recalculate assignment cost settings:","Open the Primavera P6 Administrator.","In the Configurations drop-down list, select your configuration.","In the sidebar expand Services, then expand Publication and select Job Services.","Select Recalculate Assignment Cost.","Select Active Mode if you want jobs processed continuously until all jobs finish. Clear this field if you want each job processed according to the Interval.","In the Interval field, select the amount of time to wait before running the next available job.","The default value is 10s.","Enter a value between 1 second and 24 days.","In the Concurrent Threads field, enter the number of processes used for this service on this server. A value of 0 indicates that that this job will not run on this server.","The default value is 2.","Enter a value between 0 and 20.","Configuring Recalculate Assignment Cost in Services Settings<br /> (Primavera P6 EPPM System Administration Guide for On-Premises)","English\\Admin\\p6_eppm_system_admin\\51636.htm");
Page[171]=new Array("If you are running services and P6 on the same server, you should keep the defaults.","To set your rename document folder settings:","Open the Primavera P6 Administrator.","In the Configurations drop-down list, select your configuration.","In the sidebar expand Services, then expand Publication and select Job Services.","Select Rename Document Folder.","Select Active Mode if you want jobs processed continuously until all jobs finish. Clear this field if you want each job processed according to the Interval.","In the Interval field, select the amount of time to wait before running the next available job.","The default value is 10s.","Enter a value between 1 second and 24 days.","In the Concurrent Threads field, enter the number of processes used for this service on this server. A value of 0 indicates that that this job will not run on this server.","The default value is 2.","Enter a value between 0 and 20.","Configuring Rename Document Folder in Services Settings<br /> (Primavera P6 EPPM System Administration Guide for On-Premises)","English\\Admin\\p6_eppm_system_admin\\98267.htm");
Page[172]=new Array("If you are running services and P6 on the same server, you should keep the defaults. If you want the server to copy WBS elements immediately, you should set the Interval low (for example, 10s) and the Concurrent Threads high (for example, 20). Remember that if the server is actively copying WBS elements, all users will experience delays in the application.","To configure the copy WBS settings:","Open the Primavera P6 Administrator.","In the Configurations drop-down list, select your configuration.","In the sidebar expand Services, then expand Publication and select Job Services.","Select CopyWBS.","Select Active Mode if you want jobs processed continuously until all jobs finish. Clear this field if you want each job processed according to the Interval.","In the Interval field, select the amount of time to wait before running the next available job.","The default value is 10s.","Enter a value between 1 second and 24 days.","In the Concurrent Threads field, enter the number of processes used for this service on this server. A value of 0 indicates that that this job will not run on this server.","The default value is 2.","Enter a value between 0 and 20.","Configuring CopyWBS in Services Settings<br /> (Primavera P6 EPPM System Administration Guide for On-Premises)","English\\Admin\\p6_eppm_system_admin\\98401.htm");
Page[173]=new Array("If you are running services and P6 on the same server, you should keep the defaults. If you have exports to Excel that need to be done immediately, you should set the Interval low (for example, 10s) and the Concurrent Threads high (for example, 20). Remember that if the server is actively exporting to Excel, all users will experience delays in the application.","To configure the export excel settings:","Open the Primavera P6 Administrator.","In the Configurations drop-down list, select your configuration.","In the sidebar expand Services, then expand Publication and select Job Services.","Select Export Excel.","Select Active Mode if you want jobs processed continuously until all jobs finish. Clear this field if you want each job processed according to the Interval.","In the Interval field, select the amount of time to wait before running the next available job.","The default value is 10s.","Enter a value between 1 second and 24 days.","In the Concurrent Threads field, enter the number of processes used for this service on this server. A value of 0 indicates that that this job will not run on this server.","The default value is 2.","Enter a value between 0 and 20.","Configuring Export Excel in Services Settings<br /> (Primavera P6 EPPM System Administration Guide for On-Premises)","English\\Admin\\p6_eppm_system_admin\\98402.htm");
Page[174]=new Array("If you are running services and P6 on the same server, you should keep the defaults. If you want the server to import or export enterprise data immediately, you should set the Interval low (for example, 10s) and the Concurrent Threads high (for example, 20). Remember that if the server is actively importing or exporting enterprise data, all users will experience delays in the application.","To configure the import/export enterprise data settings:","Open the Primavera P6 Administrator.","In the Configurations drop-down list, select your configuration.","In the sidebar expand Services, then expand Publication and select Job Services.","Select Import/Export Enterprise Data.","Select Active Mode if you want jobs processed continuously until all jobs finish. Clear this field if you want each job processed according to the Interval.","In the Interval field, select the amount of time to wait before running the next available job.","The default value is 10s.","Enter a value between 1 second and 24 days.","In the Concurrent Threads field, enter the number of processes used for this service on this server. A value of 0 indicates that that this job will not run on this server.","The default value is 2.","Enter a value between 0 and 20.","In the Maximum Duration field, enter the maximum activity duration that the Import/Export Enterprise Data service will handle.","The default value is 100,000.","Enter a value between 0 and 2147483647.","Configuring Import/Export Enterprise Data in Services Settings<br /> (Primavera P6 EPPM System Administration Guide for On-Premises)","English\\Admin\\p6_eppm_system_admin\\98403.htm");
Page[175]=new Array("If you are running services and P6 on the same server, you should keep the defaults. If you want the server to generate reports immediately, you should set the Interval low (for example, 10s) and the Concurrent Threads high (for example, 20). Remember that if the server is actively generating reports, all users will experience delays in the application.","To configure the generate reports settings:","Open the Primavera P6 Administrator.","In the Configurations drop-down list, select your configuration.","In the sidebar expand Services, then expand Publication and select Job Services.","Select Generate Reports.","Select Active Mode if you want jobs processed continuously until all jobs finish. Clear this field if you want each job processed according to the Interval.","In the Interval field, select the amount of time to wait before running the next available job.","The default value is 10s.","Enter a value between 1 second and 24 days.","In the Concurrent Threads field, enter the number of processes used for this service on this server. A value of 0 indicates that that this job will not run on this server.","The default value is 2.","Enter a value between 0 and 20.","Configuring Generate Reports in Services Settings<br /> (Primavera P6 EPPM System Administration Guide for On-Premises)","English\\Admin\\p6_eppm_system_admin\\98404.htm");
Page[176]=new Array("If you are running services and P6 on the same server, you should keep the defaults.","To configure the checkin enterprise data settings:","Open the Primavera P6 Administrator.","In the Configurations drop-down list, select your configuration.","In the sidebar expand Services, then expand Publication and select Job Services.","Select Checkin Enterprise Data.","Select Active Mode if you want jobs processed continuously until all jobs finish. Clear this field if you want each job processed according to the Interval.","In the Interval field, select the amount of time to wait before running the next available job.","The default value is 10s.","Enter a value between 1 second and 24 days.","In the Concurrent Threads field, enter the number of processes used for this service on this server. A value of 0 indicates that that this job will not run on this server.","The default value is 2.","Enter a value between 0 and 20.","Configuring Checkin Enterprise Data in Services Settings<br /> (Primavera P6 EPPM System Administration Guide for On-Premises)","English\\Admin\\p6_eppm_system_admin\\98985.htm");
Page[177]=new Array("If you are running services and P6 on the same server, you should keep the defaults.","To configure the checkout enterprise data settings:","Open the Primavera P6 Administrator.","In the Configurations drop-down list, select your configuration.","In the sidebar expand Services, then expand Publication and select Job Services.","Select Checkout Enterprise Data.","Select Active Mode if you want jobs processed continuously until all jobs finish. Clear this field if you want each job processed according to the Interval.","In the Interval field, select the amount of time to wait before running the next available job.","The default value is 10s.","Enter a value between 1 second and 24 days.","In the Concurrent Threads field, enter the number of processes used for this service on this server. A value of 0 indicates that that this job will not run on this server.","The default value is 2.","Enter a value between 0 and 20.","Configuring Checkout Enterprise Data in Services Settings<br /> (Primavera P6 EPPM System Administration Guide for On-Premises)","English\\Admin\\p6_eppm_system_admin\\98986.htm");
Page[178]=new Array("If you are running services and P6 on the same server, you should keep the defaults.","To set your preview baseline settings:","Open the Primavera P6 Administrator.","In the Configurations drop-down list, select your configuration.","In the sidebar expand Services, then expand Publication and select Job Services.","Select Preview Baseline.","Select Active Mode if you want jobs processed continuously until all jobs finish. Clear this field if you want each job processed according to the Interval.","In the Interval field, select the amount of time to wait before running the next available job.","The default value is 10s.","Enter a value between 1 second and 24 days.","In the Concurrent Threads field, enter the number of processes used for this service on this server. A value of 0 indicates that that this job will not run on this server.","The default value is 2.","Enter a value between 0 and 20.","Configuring Preview Baseline in Services Settings<br /> (Primavera P6 EPPM System Administration Guide for On-Premises)","English\\Admin\\p6_eppm_system_admin\\101143.htm");
Page[179]=new Array("If you are running services and P6 on the same server, you should keep the defaults.","To configure the check schedule settings:","Open the Primavera P6 Administrator.","In the Configurations drop-down list, select your configuration.","In the sidebar expand Services, then expand Publication and select Job Services.","Select Check Schedule.","Select Active Mode if you want jobs processed continuously until all jobs finish. Clear this field if you want each job processed according to the Interval.","In the Interval field, select the amount of time to wait before running the next available job.","The default value is 10s.","Enter a value between 1 second and 24 days.","In the Concurrent Threads field, enter the number of processes used for this service on this server. A value of 0 indicates that that this job will not run on this server.","The default value is 2.","Enter a value between 0 and 20.","Configuring Check Schedule in Services Settings<br /> (Primavera P6 EPPM System Administration Guide for On-Premises)","English\\Admin\\p6_eppm_system_admin\\103068.htm");
Page[180]=new Array("If you are running services and P6 on the same server, you should keep the defaults.","To set your project check settings:","Open the Primavera P6 Administrator.","In the Configurations drop-down list, select your configuration.","In the sidebar expand Services, then expand Publication and select Job Services.","Select Project Check.","Select Active Mode if you want jobs processed continuously until all jobs finish. Clear this field if you want each job processed according to the Interval.","In the Interval field, select the amount of time to wait before running the next available job.","The default value is 10s.","Enter a value between 1 second and 24 days.","In the Concurrent Threads field, enter the number of processes used for this service on this server. A value of 0 indicates that that this job will not run on this server.","The default value is 2.","Enter a value between 0 and 20.","Configuring Project Check in Services Settings<br /> (Primavera P6 EPPM System Administration Guide for On-Premises)","English\\Admin\\p6_eppm_system_admin\\103067.htm");
Page[181]=new Array("If you are running services and P6 on the same server, you should keep the defaults. If you want to apply the service immediately, you should set the rates low (for example, 30s). Remember that if the server is actively applying the service, all users will experience delays in the application.","To set your module access service settings:","Open the Primavera P6 Administrator.","In the Configurations drop-down list, select your configuration.","In the sidebar expand Services, then expand Publication and select Infrastructure Services.","In the Module Access Service area:","In the Update Rate field, enter the rate when a Business Rule Engine synchronizes with the database for license counts.","The default value is 30s.","Enter a value between 100 and 1m.","In the Expiration Check Rate field, enter the rate when the database checks licenses to see if they should expire. ","The default value is 2m.","Enter a value between 500 and 15m.","Configuring Module Access Service in Services Settings<br /> (Primavera P6 EPPM System Administration Guide for On-Premises)","English\\Admin\\p6_eppm_system_admin\\51620.htm");
Page[182]=new Array("When the timestamp service runs, it searches the database for what items have changed and need to be refreshed in the cache.","To set your timestamp service settings:","Open the Primavera P6 Administrator.","In the Configurations drop-down list, select your configuration.","In the sidebar expandServices, then expand Publication and select Infrastructure Services.","In the Timestamp Service area:","In the Refresh Rate field, enter the rate when the database is queried to determine if a table change notification is necessary. ","The default value is 1m.","Enter a value between 15s and 1h.","Note","If you are running services and P6 on the same server, you should keep the defaults. If you enter a longer rate, the server will run more efficiently, but the data may be out of date. If you enter a shorter time, the data will be up to date, but the server may not run as efficiently.","Changes to this setting require you to restart the P6 server.","Configuring Timestamp Service in Services Settings<br /> (Primavera P6 EPPM System Administration Guide for On-Premises)","English\\Admin\\p6_eppm_system_admin\\51621.htm");
Page[183]=new Array("If you are running services and P6 on the same server, you should keep the defaults. If you want to apply the service immediately, you should set the Interval low. Remember that if the server is actively applying the service, all users will experience delays in the application.","To set your mail service settings:","Open the Primavera P6 Administrator.","In the Configurations drop-down list, select your configuration.","In the sidebar expand Services, then expand Publication and select Infrastructure Services.","In the Mail Service section:","In the Email Server field, enter the hostname or IP address of the email notification server.","In the Security drop-down menu, select one of the following based on the security you are using:","SSL","TLS","None","In the SMTP(S) Port field, enter the TCP/IP port of the outgoing SMTP server. The default value is 465.","In the Bounce Email Address field, enter the address where emails should be sent if delivery fails.","Note Bounced emails will be sent to the person who sent them automatically. This bounce field allows you to send bounced emails to your administrators so they can investigate potential problems with emails.","In the Sender's Email ID field, enter the address to be used for all emails sent from P6.","In the Send Interval field, enter how often to send queued mail messages.","The default value is 1m.","Enter a value between 0 and 24d20h31m23s647.","In the Maximum Queue Length field, enter the maximum size of the mail message queue.","The default value is 250.","Enter a value between 0 and 2147483647.","In the Authorized User Name field, enter the name of the account to use to send mail from this mail server.","In the Authorized User password field, enter the password of the account used to send mail from this mail server.","Configuring Mail Service in Services Settings<br /> (Primavera P6 EPPM System Administration Guide for On-Premises)","English\\Admin\\p6_eppm_system_admin\\51644.htm");
Page[184]=new Array("The registry service finds changes in the Primavera P6 Administrator configuration settings and deploys those changes in the server. If you are running services and P6 on the same server, you should keep the defaults. If you enter a longer rate, the server will run more efficiently, but the data may be out of date. If you enter a shorter time, the data will be up to date, but the server may not run as efficiently.","To set your registry service settings:","Open the Primavera P6 Administrator.","In the Configurations drop-down list, select your configuration.","In the sidebar expand Services, then expand Publication and select Infrastructure Services.","In the Registry Service section:","In the Refresh Rate field, enter the rate when the Business Rule Engine status updates in the database. ","The default value is 1m30s. ","Enter a value between 15s and 1h.","In the Stale Period field, enter the duration of inactivity that indicates an inoperable Business Rule Engine. ","The default value is 4m.","Enter a value between 1m and 10m.","In the Port field, enter the TCP/IP port that will receive requests to revive dead Business Rule Engines.","The default value is 9192.","Enter a value between 1 and 65535.","Configuring Registry Service in Services Settings<br /> (Primavera P6 EPPM System Administration Guide for On-Premises)","English\\Admin\\p6_eppm_system_admin\\51622.htm");
Page[185]=new Array("The next key service finds cached keys that need updating.","To set your next key service settings:","Open the Primavera P6 Administrator.","In the Configurations drop-down list, select your configuration.","In the sidebar expandServices, then expand Publication and select Infrastructure Services.","In the Next Key Service area:","In the Refresh Rate field, enter the rate to refresh the next key cache.","The default value is 1m.","Enter a value between 15s and 1h.","Note If you are running services and P6 on the same server, you should keep the defaults. If you enter a longer rate, the server will run more efficiently, but the data may be out of date. If you enter a shorter time, the data will be up to date, but the server may not run as efficiently.","In the Maximum Cached Keys field, enter the maximum next keys to cache per table.","The default value is 10.","Enter a value between 1 and 100.","Configuring Next Key Service in Services Settings<br /> (Primavera P6 EPPM System Administration Guide for On-Premises)","English\\Admin\\p6_eppm_system_admin\\51623.htm");
Page[186]=new Array("The alert notification service controls how often the P6 database checks for alerts.","To set your alert notification service settings:","Open the Primavera P6 Administrator.","In the Configurations drop-down list, select your configuration.","In the sidebar expandServices, then expand Publication and select Infrastructure Services.","In the Alert Notification Service area.","In the Refresh Rate field, enter the rate to refresh alerts.","The default value is 30s.","Enter a value between 15s and 15m.","Note If you are running services and P6 on the same server, you should keep the defaults. If you enter a longer rate, the server will run more efficiently, but the data may be out of date. If you enter a shorter time, the data will be up to date, but the server may not run as efficiently.","Configuring Alert Notification Service in Services Settings<br /> (Primavera P6 EPPM System Administration Guide for On-Premises)","English\\Admin\\p6_eppm_system_admin\\54652.htm");
Page[187]=new Array("If you are running services and P6 on the same server, you should keep the defaults. If you want to apply the service immediately, you should set the Interval low. Remember that if the server is actively applying the service, all users will experience delays in the application.","To set your collaboration synchronization service settings:","Open the Primavera P6 Administrator.","In the Configurations drop-down list, select your configuration.","In the sidebar expand Services, then expand Publication and select Infrastructure Services.","In the Collaboration Synchronization Service area:","In the Synchronization Interval field, enter the interval when the collaboration synchronization service runs. The synchronization service deletes documents and workflows for deleted projects.","The default value is 1h.","Enter a value between 1m and 24d20h31m23s647.","Configuring Collaboration Synchronization Service in Services Settings<br /> (Primavera P6 EPPM System Administration Guide for On-Premises)","English\\Admin\\p6_eppm_system_admin\\51642.htm");
Page[188]=new Array("If you are running services and P6 on the same server, you should keep the defaults. If you want to apply the service immediately, you should set the Interval low. Remember that if the server is actively applying the service, all users will experience delays in the application.","To set your asynchronous jobs service settings:","Open the Primavera P6 Administrator.","In the Configurations drop-down list, select your configuration.","In the sidebar expand Services, then expand Publication and select Infrastructure Services.","In the Asynchronous Jobs.","In the Purge Interval field, enter how often to remove long running job records from the database.","The default value is 1h.","Enter a value between 1m and 24d20h31m23s647.","In the Grace Time field, enter the minimum age of long running job records removed during purge.","The default value is 1d.","Enter a value between 0 and 24d20h31m23s647.","Configuring Asynchronous Jobs in Services Settings<br /> (Primavera P6 EPPM System Administration Guide for On-Premises)","English\\Admin\\p6_eppm_system_admin\\51643.htm");
Page[189]=new Array("If you are running services and P6 on the same server, you should keep the defaults. If you want to apply the cache immediately, you should set the Frequency low. Remember that if the server is actively applying the cache, all users will experience delays in the application.","To set your project hierarchy cache settings:","Open the Primavera P6 Administrator.","In the Configurations drop-down list, select your configuration.","In the sidebar expandServices, then expand Publication and select Infrastructure Services.","In the Project Hierarchy Cache area:","Select Enable WBS Hierarchy Preload.","Oracle recommends keeping this setting selected for most situations since security checks rely on the WBS Hierarchy cache preload. ","Leave this field clear only if you are loading project details (for example, an API request) and the preloading cache with WBS Hierarchy details is taking a lot of time.","In the Cache Policy drop-down menu, select the cache policy to use. The cache policy determines how much data is in the cache and which data to remove to reclaim memory.","You can select one of the following:","FIFO&nbsp;First In First Out-projects are cleared from the cache in the same order they were added to memory.","LRU&nbsp;Least Recently Used projects are cleared from the cache before more recently used ones.","JVMM&nbsp;Java Virtual Machine Managed uses soft references to cache elements; memory used by soft references is reclaimed by the JVM as required.","PRR&nbsp;Projects are selected at random to be cleared from cache.","PRFIFO&nbsp;Periodic Refresh First In First Out is the same as FIFO, except policy is enforced based on MaintenanceFrequency.","PRLRU&nbsp;Periodic Refresh Least Recently Used is the same as LRU, except policy is enforced based on MaintenanceFrequency.","PRCC&nbsp;Periodic Refresh Clear Cache ignores CacheLimit to flush the entire cache, based on MaintenanceFrequency.","Note The default value is PRR.","In the Cache Limit field, enter the maximum number of projects stored in memory.","The default value is 5000.","Enter a value between 1000 and 30000.","In the Maintenance Frequency field, enter the frequency for applying the specified cache policy. If you apply the cache policy, the system can reclaim memory from the cache.","The default value is 5h.","Enter a value between 1m and 24d.","Configuring Project Hierarchy Cache in Services Settings<br /> (Primavera P6 EPPM System Administration Guide for On-Premises)","English\\Admin\\p6_eppm_system_admin\\51641.htm");
Page[190]=new Array("To configure settings for P6 Pro Cloud Connect:","Open the Primavera P6 Administrator.","In the Configurations drop-down list, select your configuration.","In the sidebar selectP6ProCloudConnect.","Note Changes to these settings require you to restart the P6 server.","In the FetchSize field, enter the maximum number of rows gathered in a database block. The default value is 254. You can enter a value between 0 and 2147483647.","In the TaskMaxTime field, enter the maximum time allowed for a P6 Pro task to complete. A job consists of one or more P6 Pro tasks. The default value is 5m.","In the TransactionMaxInactiveInterval field, enter the timeout interval for an inactive session that has a pending database transaction. The default value is 15m.","In the SessionMaxInactiveInterval field, enter the timeout interval for an inactive session. The default value is 2h.","In the Mode drop-down menu, you can select Username Token Profile or SAML Token Profile. The default value is Username Token Profile.","Configuring P6ProCloudConnect Settings<br /> (Primavera P6 EPPM System Administration Guide for On-Premises)","English\\Admin\\p6_eppm_system_admin\\85465.htm");
Page[191]=new Array("Configuring your Geo Code Provider settings will allow you to use the locations feature in P6. With the locations feature, you can assign locations to projects, activities, and resources so you can later report in Analytics based on geographical location.","To set your GeoCodeProvider settings:","Open the Primavera P6 Administrator.","In the Configurations drop-down list, select your configuration.","In the sidebar selectGeoCodeProvider.","Note Changes to these settings require you to restart the P6 server.","In the GeoCodeProvider drop-down menu, select your provider:","Oracle GeoCoder","Third Party Geocoder","None","In the Geocode Provider URL field, enter the URL for your geocode provider.","Note The P6 server may have trouble starting if it cannot connect to the Geo Code URL. On the machine where you installed P6, test the URL in a browser to ensure you can connect before you enter the URL in this setting.","For the Oracle GeoCoder, the default value is http://elocation.oracle.com/geocoder/gcserver.","For a third-party geocoder, use the URL associated with your geocoder.","Note If you use the Oracle GeoCoder, you must also set your Web Proxy Server to www-proxy.us.oracle.com on the Web Proxy page for your configuration.","Configuring GeoCodeProvider Settings<br /> (Primavera P6 EPPM System Administration Guide for On-Premises)","English\\Admin\\p6_eppm_system_admin\\51697.htm");
Page[192]=new Array("To configure P6 Integration API and P6 to work together, you will need to set the P6 Integration API settings in the Primavera P6 Administrator.","Note For more information on the Primavera P6 Administrator see Primavera P6 Administrator Setup Tasks.","To set your Integration API server settings:","Open the Primavera P6 Administrator.","In the Configurations drop-down list, select your configuration.","In the sidebar selectIntegration API Server.","In the Session Timeout field, enter the number of minutes when an idle connection will end.","The default value is 120 minutes.","Enter a value between 1 second and 24 days.","In the Security Authenticate Mode field, select one of the following modes:","Username Token Profile","SAML Token Profile","The default value is Username Token Profile.","To configure RMI settings:","Select Enable to enable the RMI server. You only need to enable the RMI server if you are using P6 Integration API.","P6 Integration API supports three modes. Depending on the mode you are using, do one of the following:","Select Enable Standard Service to enable Standard service mode.","Select Enable SSL to enable SSL service mode.","Select Enable Compression to enable compression service mode.","In the Registry Port field, enter the port for the RMI Registry. The default value is 9099.","Depending on which mode you enable, set the corresponding port for that mode:","In the Standard Service Port field, enter the port to use for Standard service mode. A setting of 0 indicates that any available port will be used. If the server will be accessed across a firewall, you must set this to a specific port.","The default value is 0.","In the SSLServicePort field, enter the port to use for SSL service mode. A setting of 0 indicates that any available port will be used. If the server will be accessed across a firewall, you must set this to a specific port. ","The default value is 0.","In the Compression ServicePort field, enter the port to use for Compression service mode. A setting of 0 indicates that any available port will be used. If the server will be accessed across a firewall, you must set this to a specific port. ","The default value is 0.","In the File Location field, enter the full path to the Keystore file.","In the Keystore Password field enter the Keystore password.","Configuring Integration API Server Settings<br /> (Primavera P6 EPPM System Administration Guide for On-Premises)","English\\Admin\\p6_eppm_system_admin\\51649.htm");
Page[193]=new Array("One P6 EPPM Web Services server instance can control more than one database and you can specify an authentication mode for a database through the Authentication Configuration wizard. ","You can use the Primavera P6 Administrator to set the authentication mode, token profiles and message protection settings. If you use SAML for P6 EPPM Web Services, you must use Single Sign-On or LDAP authentication for P6 EPPM. You must configure additional settings for LDAP authentication with secure communication (SSL) between the P6 EPPM Web Services server and the LDAP server. ","To configure P6 EPPM Web Services and P6 to work together, you must set the P6 EPPM Web Services settings in the Primavera P6 Administrator.","The server can be configured to authenticate user credentials using the following methods:","Oracle Web Services Manager (OWSM)","Username Token Profile","Security Assertion Markup Language (SAML) 1.1 or 2.0","HTTP Cookies (on-premises only)","OAuth","If you select multiple authentication modes, priority is given in the order of the list above, with OWSM being the highest priority and Cookies being the lowest priority. For example, if you select both Username Token Profile and SAML, .","Note","A P6 EPPM Web Services configuration might include database instances that are not set to the same authentication mode as the P6 EPPM Web Services server. If a user connects and requests a database that is set to a different authentication mode than the P6 EPPM Web Services server, an error message displays. The user must select a database that matches the authentication mode set for the P6 EPPM Web Services server.","For more information on the Primavera P6 Administrator see Primavera P6 Administrator Setup Tasks.","See the P6 EPPM Web Services Programming Guide for more information about using P6 EPPM Web Services.","About Configuring P6 EPPM Web Services in the Primavera P6 Administrator<br /> (Primavera P6 EPPM System Administration Guide for On-Premises)","English\\Admin\\p6_eppm_system_admin\\51698.htm");
Page[194]=new Array("To set your authentication mode:","Open the Primavera P6 Administrator.","In the Configurations drop-down list, select your configuration.","In the sidebar expandWeb Services, then expand Security and select Authentication.","On the Authentication page, select the methods you want to allow clients use for authentication. The default value is Username Token Profile. You can select multiple authentication modes.","Note If you select OWSM as the authentication mode for P6 EPPM Web Services, only OWSM authentication can be used. OWSM receives the authentication request and will perform the authentication instead of passing the authentication request to P6 EPPM Web Services.","The available authentication modes are:","Username Token Profile - SOAP and REST: This mode defines how a web service client application can supply a user name and an optional password in the message request that the web service server can use to authenticate the requester's identity.","SAML Token - SOAP: Security Assertion Markup Language (SAML) defines an XML-based mechanism for exchanging messages that contain security information in the form of assertions.","Cookies - SOAP: This option requires you to call the Authentication service Login operation to establish a session and obtain a cookie before you can use any other P6 web service.","OWSM - SOAP: This option lets you use Oracle Web Services Manager to manage P6 EPPM Web Services security policies and to monitor authentication and authorization attempts.","OAuth - SOAP and REST: This option uses a private key corresponding to a public certificate for generating user assertions and access tokens.","Note","See the P6 EPPM Web Services Programming Guide for more information.","Changes to this setting require you to restart the P6 server.","Configuring Authentication Mode for P6 EPPM Web Services<br /> (Primavera P6 EPPM System Administration Guide for On-Premises)","English\\Admin\\p6_eppm_system_admin\\51654.htm");
Page[195]=new Array("To set your Username Token Profile settings:","Open the Primavera P6 Administrator.","In the Configurations drop-down list, select your configuration.","In the sidebar expand Web Services, then expand Security and select Authentication.","Expand Username Token Profile:","In the Nonce area:","Select Require Nonce to enable nonce.","Nonce is a token that contains a random value and is used to prevent attacks.","In the Nonce Cache Timeout field, enter the value for the Nonce cache timeout. The value specified indicates how long the nonce remains cached before it is deleted.","The default value is 10m.","Enter a value between 5m and 24d.","In the Created area:","Select Require Created to enable the Username token timestamp.","Requiring a Created element allows the server to determine whether the difference between two timestamps falls within an allowable window of time and can then reject any messages that exceed the window. ","In the Timeout field, enter the value for the Created timestamp timeout. You can specify a minimum of 5m.","The default value is 10m.","Enter a value between 5m and 24d.","Configuring Username Token Profile Settings for P6 EPPM Web Services<br /> (Primavera P6 EPPM System Administration Guide for On-Premises)","English\\Admin\\p6_eppm_system_admin\\51655.htm");
Page[196]=new Array("To set your SAML Token Profile settings:","Open the Primavera P6 Administrator.","In the Configurations drop-down list, select your configuration.","In the sidebar expand Web Services, then expand Security and select Authentication.","Expand SAML Token Profile:","Select Require Signed SAML Token to require signed SAML tokens or false to require unsigned SAML tokens.","In the SAML Version field, select one of the following:","1.1","2.0","Both","To configure SAML tokens settings, in the SAML Tokens area:","Select Disable Timeout to use Issue Instant Timeout and Authentication Timeout fields.","In the Issuer field, enter the valid issuer for the SAML token. Use a space to separate multiple valid issuers. For example, ","http://your.saml.issuer.com","In the Issue Instant Timeout field, enter the value for the Issue Instant timeout. The value specified indicates the maximum time allowed between the time the token is issued and the time the token is received by the web service.","The default value is 5 minutes.","Enter a value between 5 minutes and 24 days.","In the AuthenticationInstant Timeout field, enter the value for the Authentication Issue Instant timeout. The value specified indicates the maximum time allowed between the time the token is issued, the time the user is authenticated, and the time the token is received by the web service.","The default value is 5 minutes.","Enter a value between 5 minutes and 24 days.","To configure Signed SAML Tokens settings:","In the KeyStore Type list, select the KeyStore type.","The default value is JKS. JCEKS is also supported.","In the File Location field, enter the absolute path to the keystore file. This file must exist on the local file system. For example, ","c:\\keystore\\keystore.jks","In the Keystore Password field, enter keystore password.","In the Certificate Alias field, enter alias for the client certificate containing the public key.","The default value is alias.","In the Private Key Alias field, enter the alias for the private key.","The default value is privatekeyalias.","In the Private Key Password field, enter the password for the private key alias.","Configuring SAML Token Profile Settings for P6 EPPM Web Services<br /> (Primavera P6 EPPM System Administration Guide for On-Premises)","English\\Admin\\p6_eppm_system_admin\\51656.htm");
Page[197]=new Array("To set your message protection settings:","Open the Primavera P6 Administrator.","In the Configurations drop-down list, select your configuration.","In the sidebar expandWeb Services, then expand Security and select Message Protection.","Select Require Timestamp if incoming SOAP messages must contain the WS-Security Timestamp.","Select Require Digital Signatures for Incoming Messages to require that incoming SOAP messages are signed and conform to Web Service Security 1.1 standards.","Note To access Web Services, you must configure all Web Services settings to get encryption and digital signatures to work. If you do not want to use encryption or digital signatures, you must set this setting and the Require Encryption setting to false.","Select Require Encryption for Incoming Messages to require incoming SOAP messages are encrypted and conform to Web Service Security 1.1 standards. When this setting is selected, at least one element in each P6 EPPM Web Services request message must be encrypted. ","Note","To access Web Services, you must configure all Web Services settings to get encryption and digital signatures to work. If you do not want to use encryption or digital signatures, you must set this setting and the Require Encryption setting to false.","When the Encrypt Response setting and the Require Encryption for Incoming Messages setting are both set to true, the server encrypts everything inside of the body element of P6 Web Services response messages.","When the Encrypt Response setting is Encrypt only if request is encrypted and Require Encryption for Incoming Messages setting is set to true, the server encrypts everything inside of the body element of P6 Web Services response messages.","When the Require Encryption for Incoming Messages setting is set to false, both encrypted and un-encrypted incoming messages are accepted. This setting provides flexible interoperability with multiple Web Services clients simultaneously, without compromising security.","In the Encrypt Response list, select the encryption response options for outgoing messages. This setting governs when responses will be returned as encrypted.","The default value is Encrypt only if request is encrypted.","In the Key Store Type list, select the key store type.","The default value is JKS.","In the File Location field, enter the absolute path to the key store file. This file must exist on the local file system. For example, ","c:\\keystore\\keystore.jks","In the Keystore Password field, enter key store password.","In the Private Key Alias field, enter alias for the private key in key store.","The default value is alias.","In the Private Key Password field, enter password for the private key. ","Note","When the Encrypt Response setting and the Require Encryption for Incoming Messages setting are both set to true, the server encrypts everything inside of the body element of P6 Web Services response messages.","When the Encrypt Response setting is Encrypt only if request is encrypted and Require Encryption for Incoming Messages setting is set to true, the server encrypts everything inside of the body element of P6 Web Services response messages.","When the Require Encryption for Incoming Messages setting is set to false, both encrypted and un-encrypted incoming messages are accepted. This setting provides flexible interoperability with multiple Web Services clients simultaneously, without compromising security.","Configuring Message Protection Settings for P6 EPPM Web Services<br /> (Primavera P6 EPPM System Administration Guide for On-Premises)","English\\Admin\\p6_eppm_system_admin\\51657.htm");
Page[198]=new Array("Open the Primavera P6 Administrator.","In the Configurations drop-down list, select your configuration.","In the sidebar selectTeam Member if you want to alter the following default values:","Note Changes to these settings require you to restart the P6 Team Member server.","Initial connection pool size: 10","Maximum active database connections: 150","Maximum idle database connections: -1","Minimum idle database connections: 10","Enabled: Selected","Severity Level: Error","Note Other Severity Level options include the following:","off","fatal","warn","info","debug","trace","all","Log File Name: p6tmweb.log","Configuring P6 Team Member Settings<br /> (Primavera P6 EPPM System Administration Guide for On-Premises)","English\\Admin\\p6_eppm_system_admin\\89732.htm");
Page[199]=new Array("Diagnostics Settings allows you to track specific tasks that could be causing your application to run slowly. ","To set your diagnostics settings:","Open the Primavera P6 Administrator.","In the Configurations drop-down list, select your configuration.","In the sidebar selectDiagnostics.","Note Changes to these settings require you to restart the P6 server.","To configure Metrics Collector settings:","Select Metric Collection if you want poorly performing issues to be tracked. The default value is unselected.","ThresholdLimit is the amount of time a browser request pends before being tracked as a poorly performing issue. The default value is 5 milliseconds. ","CollectionSize is the number of poorly performing issues that are tracked. The default value is 100. ","Note","The number entered for ThresholdLimit should be set to the average processing time of the application.  ","When the time taken to complete a browser request exceeds the ThresholdLimit, the task is tracked as poorly performing issue. ","CollectionSize can be adjusted based on the amount of memory in your machine. 100 is the average for a machine with 8GB of RAM available. Oracle recommends using the default value of 100 tracked issues. ","To configure Tracer settings:","Select Enable to send debugging messages to the Tracer application. Leave this option clear if you do not want debugging messages sent.","Select Use Background Send Thread to use the background thread to send TCP messages to tracer. Leave this option clear if you don't want to use the background thread to send TCP messages.","In the Server Name field, enter the destination IP address or hostname for sending tracer information.","The default value is localhost.","In the Port field, enter the port to use for the Tracer socket connection.","The default value is 9210.","Configuring Diagnostics Settings<br /> (Primavera P6 EPPM System Administration Guide for On-Premises)","English\\Admin\\p6_eppm_system_admin\\90461.htm");
Page[200]=new Array("This chapter describes the authentication modes for P6 EPPM and outlines the steps required to implement an authentication scheme. It also details steps on how to import user information from an LDAP server.","Note If you are using LDAP, you need to verify your field mappings and alter them to match the fields for your LDAP environment. See Provisioning LDAP User Information for the First Time for details.","Authentication in P6 EPPM<br /> (Primavera P6 EPPM System Administration Guide for On-Premises)","English\\Admin\\p6_eppm_system_admin\\89756.htm");
Page[201]=new Array("To manage how users can access your applications, use authentication and authorization mechanisms. Authentication is the process of validating user identity and authorization is how you control what resources and data your users can access.","P6 uses multiple settings to support authentication. These settings also control the authentication used for all P6 EPPM applications except P6 EPPM Web Services. You set authentication settings in the Primavera P6 Administrator's Authentication tab. ","P6 EPPM supports these authentication modes:","Native is the default mode for P6 EPPM. In Native mode, the P6 EPPM database acts as the authority and the application handles the authentication of the user who is logging into that application.","Single Sign-On (SSO) controls access to Web applications. In SSO mode, the applications are protected resources. When a user tries to log in, a Web agent intercepts the request and prompts the user for login credentials. The Web agent passes the user's credentials to a policy server, which authenticates them against a user data store. With SSO, once the users log in, they are logged in to all Web applications during their browser session (as long as all Web applications authenticate against the same policy server). ","Lightweight Directory Access Protocol (LDAP) authenticates users through a directory and is available for all applications. You can use LDAP referrals&nbsp;with Oracle Internet Directory and Microsoft Windows Active Directory. LDAP referrals allow authentication to extend to another domain. You can also configure multiple LDAP servers, which supports failover and enables you to search for users in multiple LDAP stores. An LDAP directory server database confirms the user's identity when they attempt to login to the application.","Note For Oracle Internet Directory, referrals only work when you configure the directories to search anonymously.","Regardless of the authentication scheme you choose, the P6 EPPM database controls user authorization.","Authentication Modes in P6 EPPM<br /> (Primavera P6 EPPM System Administration Guide for On-Premises)","English\\Admin\\p6_eppm_system_admin\\7634.htm");
Page[202]=new Array("To specify the authentication scheme you want to use for P6 EPPM applications, use the P6 EPPM Authentication tab of the Primavera P6 Administrator. Although you specify authentication modes for client/server applications and Web applications separately, you must use a consistent authentication scheme within P6 EPPM. For example, client/server and Web applications must both&nbsp;be configured for either LDAP authentication or native authentication.","Authentication mode is database-driven, so the configuration utility enables you to first specify a database connection setting, then choose authentication modes for the applications that access that database.","For LDAP authentication, the configuration utility also enables you to specify LDAP servers, map LDAP attributes to P6 EPPM database fields, and provision users.","Choosing an Authentication Scheme<br /> (Primavera P6 EPPM System Administration Guide for On-Premises)","English\\Admin\\p6_eppm_system_admin\\38149.htm");
Page[203]=new Array("The authentication modes have different login procedures:","In Native mode","P6 EPPM presents a login dialog box that prompts for a user name and password. Depending on whether you enabled the password policy option in Application Settings in P6, the user may have to create a strong password.","In LDAP mode","All P6 EPPM applications require a login password.","Since the LDAP directory stores and authenticates passwords, users cannot change their passwords in P6 EPPM.","In Single Sign-On mode","For P6, the Single Sign-On server requests and validates login credentials. Once a user is authenticated, the launch page for P6 appears so the user can select a database and language.","Users cannot change their passwords in P6 EPPM because passwords are stored and authenticated against a directory server user store.","Login Procedures and Authentication in P6 EPPM<br /> (Primavera P6 EPPM System Administration Guide for On-Premises)","English\\Admin\\p6_eppm_system_admin\\7665.htm");
Page[204]=new Array("By default, all P6 EPPM applications use Native authentication. After you install your P6 EPPM applications, you can choose a different authentication scheme.","Note If you are upgrading from a previous version of P6 EPPM, see the P6 EPPM Upgrade and Configuration Guide before modifying the authentication settings.","Your database controls your Authentication mode. ","When using SSO mode, P6 Integration API and P6 EPPM Web Services use LDAP mode.","If using LDAP authentication, you can specify LDAP servers, configure more than one LDAP server for each database instance, map LDAP attributes to P6 EPPM database fields, and provision users.","Follow the guidelines below to specify an authentication scheme and perform additional configuration tasks for authentication:","Configure administrative settings using the Primavera P6 Administrator. See About the Authentication Tab in the Primavera P6 Administrator for details on these settings.","When using LDAP mode, provision user information from the LDAP server using P6. See Provisioning LDAP User Information for the First Time for details.","Configure Oracle Analytics Publisher to use with P6 when using LDAP or SSO mode. See the P6 EPPM Oracle Analytics Publisher Configuration Guide for more information.","Tip","If multiple instances within a configuration point to the same database, P6 EPPM will use the Authentication Mode for the first instance in the list.","To enable you to configure more than one LDAP server for each database instance, you can set multiple LDAP Connection Settings for authentication. Right-click the LDAP Connection Settings folder to duplicate, delete, copy, paste, or test a configuration. When P6 authenticates a user, it will search each LDAP server in order for a user name that matches the login name and will use the first matching user to verify the password.","A configuration for P6 might include database instances that are not set to the same authentication mode as the P6 server. If a user connects and requests a database that is set to a different authentication mode than the P6 server, an error message will display; the user must select a database that matches the authentication mode set for the P6 server.","Authentication Configuration Process in P6 EPPM<br /> (Primavera P6 EPPM System Administration Guide for On-Premises)","English\\Admin\\p6_eppm_system_admin\\7637.htm");
Page[205]=new Array("The information below details all settings available from the Authentication tab of the Primavera P6 Administrator.","Note","See the procedures in the P6 EPPM Installation and Configuration Guide if you are upgrading from a previous version of P6 EPPM software before modifying the authentication settings.","See Authentication in P6 EPPM for an overview of the authentication configuration process and instructions on how to provision LDAP user information.","If you are using LDAP, you need to verify your field mappings and alter them to match the fields for your LDAP environment. See Provisioning LDAP User Information for the First Time for details.","About the Authentication Tab in the Primavera P6 Administrator<br /> (Primavera P6 EPPM System Administration Guide for On-Premises)","English\\Admin\\p6_eppm_system_admin\\51707.htm");
Page[206]=new Array("Single Sign-On (SSO) controls access to Web applications. In SSO mode, the applications are protected resources. When a user tries to log in, a Web agent intercepts the request and prompts the user for login credentials. The Web agent passes the user's credentials to a policy server, which authenticates them against a user data store. With SSO, once the users log in, they are logged in to all Web applications during their browser session (as long as all Web applications authenticate against the same policy server). ","To set your web Single Sign-On settings:","Open the Primavera P6 Administrator.","In the Authentication tab, select your configuration from the drop-down list.","SelectAuthentication.","In the Login Mode drop-down list, select WebSSO.","To configure Web Single Sign-On settings:","Note","Changes to these settings require you to restart the P6 server.","Select Allow Alternate Login Attribute when using Oracle Single Sign-On, and you want to use an SSO login attribute other than the P6 user name. For example, you will enter your email address when authenticating Oracle Single Sign-On, but your P6 user name will map to the LDAP's UID field.","In the User Name Header Key field, enter the name of the HTTP Header you specified in the policy server.","The value you specify must match the property you created under the policy domain/realm,&nbsp;where the Web server for P6 resides. ","For Oracle Single Sign-On, the value should be Proxy-Remote-User. The Proxy-Remote-User should match the LDAP server attribute that maps to the P6 EPPM database USER_NAME field. See Provisioning LDAP User Information for the First Time for details.","For Oracle Access Manager, the value should be OAM_REMOTE_USER, which is the default value.","In the Context Path Override field, enter the path used to pass web requests from the Single Sign-On Web server to the P6 server. The default listed is the value for P6 (/p6).","Note","If you enable the Allow Alternate Login Attribute setting, you must configure the Header Key and LDAP Search Attribute settings. You must also configure the LDAP settings for the appropriate database instance to establish a connection to the LDAP server. See Provisioning LDAP User Information for the First Time for details.","In the Header Key field, enter the HTTP Header Key which contains the global user ID. The default value is Osso-User-Guid.","In the LDAP Search Attribute field, enter the LDAP attribute searched by the Header Key to authenticate users. The default value is orclguid.","Note You must configure the LDAP settings for the appropriate database instance to establish a connection to the LDAP server.","Configuring Web Single Sign-On Settings in the Primavera P6 Administrator<br /> (Primavera P6 EPPM System Administration Guide for On-Premises)","English\\Admin\\p6_eppm_system_admin\\51658.htm");
Page[207]=new Array("Lightweight Directory Access Protocol (LDAP) authenticates users through a directory and is available for all applications. You can use LDAP referrals&nbsp;with Oracle Internet Directory and Microsoft Windows Active Directory. LDAP referrals allow authentication to extend to another domain. You can also configure multiple LDAP servers, which supports failover and enables you to search for users in multiple LDAP stores. An LDAP directory server database confirms the user's identity when they attempt to login to the application.","To set your LDAP settings:","Open the Primavera P6 Administrator.","In the Authentication tab, select your configuration from the drop-down list.","SelectAuthentication.","In the Login Mode drop-down list, select LDAP. ","To configure LDAP settings:","Note Changes to these settings require you to restart the P6 server.","In the SSL Certificate Store field, enter the full path to the keystore that holds the SSL certificate for the LDAP server.","In the SSL Store Password field, enter the password for the keystore that holds the SSL certificate.","Configuring LDAP Settings in the Primavera P6 Administrator<br /> (Primavera P6 EPPM System Administration Guide for On-Premises)","English\\Admin\\p6_eppm_system_admin\\51659.htm");
Page[208]=new Array("Native is the default mode for P6 EPPM. In Native mode, the P6 EPPM database acts as the authority and the application handles the authentication of the user who is logging into that application.","To set your HTTPS settings:","Open the Primavera P6 Administrator.","In the Authentication tab, select your configuration from the drop-down list.","SelectAuthentication.","In the Login Mode drop-down list, select Native.","To configure HTTPS settings:","Note Changes to these settings require you to restart the P6 server.","Select Enable HTTPS if users do not use an HTTPS URL for the login page. If selected, P6 redirects the users to an HTTPS login page to complete the login process. You must enable SSL communication for the application server or web server.","Leave this option clear if you do not want users redirected to an HTTPS URL for login.","Caution If kept as clear, the application server will receive the passwords as clear text when a user logs in to the application.","Note If you have problems accessing the P6 application and you enabled this setting, you will need to verify that you enabled the SSL listen port on your application server and that it matches the Authentication/HTTPS/Port setting below. You should also check the WebAccessLog to ensure there is not an &quot;SSL disabled&quot; error message.","In the Port field, enter the port number used for SSL. You must enter the port number only if you enable the HTTPS option. ","The default value is 443. ","Enter a value between 0 and 2147483647.","Configuring HTTPS Settings in the Primavera P6 Administrator<br /> (Primavera P6 EPPM System Administration Guide for On-Premises)","English\\Admin\\p6_eppm_system_admin\\51660.htm");
Page[209]=new Array("To set your database instance settings:","Open the Primavera P6 Administrator.","In the Authentication tab, select your configuration from the drop-down list.","Select your Database Instance.","In the Authentication Mode drop-down list, select one of the following authentication modes:","Note Changes to this setting require you to restart the P6 server.","Native","WebSSO","LDAP","Note Other authentication modes available in this list are used for P6 EPPM Cloud Service.","For more information about each authentication mode, refer to Authentication Modes in P6 EPPM.","Configuring Database Instance Settings in the Primavera P6 Administrator<br /> (Primavera P6 EPPM System Administration Guide for On-Premises)","English\\Admin\\p6_eppm_system_admin\\51661.htm");
Page[210]=new Array("To provision LDAP user information for P6 EPPM for the first time:","Caution Ensure that all users are logged out of P6 EPPM to ensure the Primavera P6 Administrator saves your new settings.","Note Verify your default global profile; the global profile will be assigned to all provisioned users.","Log in to the Primavera P6 Administrator. See Primavera P6 Administrator Setup Tasks for details.","From the Authentication tab:","Select Authentication and ensure that Login Mode is set to NATIVE.","Select Database instance and ensure that Authentication Mode is set to Native.","Restart the application server instance.","NoteIf you do not restart the application server instance, the Primavera P6 Administrator will restore settings to the previous configuration.","Log in to P6 as a user with privileges to create a new user.","Follow the instructions in the Creating User Accounts for P6 EPPM section of the P6 EPPM Application Administration Guide to add a new user (in Native mode) that matches an LDAP server user with rights to read the LDAP directory.","Note Ensure that you have a P6 user and LDAP user that match.","Assign a global profile that contains privileges to add new users and search the LDAP directory. See the Configuring User Access section of the P6 EPPM Application Administration Guide for details.","Assign the appropriate project profiles and module access. See the Configuring User Access section of the P6 EPPM Application Administration Guide for details.","Log in to the Primavera P6 Administrator.","From the Authentication tab:","Select your configuration.","Change Login Mode to LDAP.","Select your Database instance and set Authentication Mode to LDAP.","To configure your LDAP Connection Settings[n].","Select Enable SSL if you are using SSL.","Select Chase Referrals to enable chase referrals.","In the Host field, enter the host name of your LDAP server.","In the Port field, enter the port number of your LDAP server. The default value is 636.","In the Username field, enter the LDAP user name that has privileges to log in to the LDAP server and perform LDAP searches.","In the Password field, enter the password for the user name you entered above.","In the Base Directory Node field, enter the base directory node string that represents where the LDAP tree should search during login or provisioning. For example:","dc=ad, dc=Marketing, dc=CompanyABC, dc=com","In the Preferred Pool Size field, enter the preferred pool size. The default value is 10.","In the Maximum Pool Size field, enter the maximum pool size. The default value is 20.","In the Connection Timeout (in seconds) field, enter how long (in seconds) the system should try to connect to the LDAP before timing out. The default value is 300.","Expand Field Map.","Note Except where noted, these settings represent what you will enter for an Oracle Internet Directory (OID) LDAP server and a Microsoft Active Directory. ","In the Username field, enter the LDAP field name that holds the user's login ID. For example:","uid","or","samaccountname (for Microsoft Active Directory)","In the Email ID field, enter the LDAP field name that holds the user's email address. For example:","mail","In the Actual Name field, enter the LDAP field name that holds the user's full name. For example:","cn","or","displayname (for Microsoft Active Directory)","In the Office Phone field, enter the LDAP field name that holds the user's phone number. For example:","telephoneNumber","Select Test Connection.","Click Save Changes.","Restart the application server instance.","NoteIf you do not restart the application server instance, the Primavera P6 Administrator will restore settings to the previous configuration.","Log in to P6 as the new user you created when you were in Native mode.","On the Users page, click the@&nbsp;Add icon and do the following:","Add users as described in &quot;Adding Users in LDAP or SSO Authentication Mode&quot; in the P6 EPPM Application Administration Guide for details.","If needed, change the configuration settings for the new users. See &quot;Configuring User Access&quot; in the P6 EPPM Application Administration Guide for details.","Tip","When you provision users, changed records are updated in the P6 EPPM database and new users are added. However, users that have been deleted from the LDAP directory or LDIF file are not automatically removed from the P6 EPPM database. You must manually delete these users.","You can copy a current user's settings to all the new users you create when you bring them in from LDAP.","Provisioning LDAP User Information for the First Time<br /> (Primavera P6 EPPM System Administration Guide for On-Premises)","English\\Admin\\p6_eppm_system_admin\\32757.htm");
Page[211]=new Array("This section has information about how to setup your P6 deployment for end-users, such as:","Precompiling the application","Application access information","Client and Browser configuration settings","Using Oracle Secure Global Desktop","Server plug-ins","Also, this section provides information on how you can change the application's database connection and configure a separate server for Job Services.","P6 Setup Tasks<br /> (Primavera P6 EPPM System Administration Guide for On-Premises)","English\\Admin\\p6_eppm_system_admin\\90248.htm");
Page[212]=new Array("Although not required for P6, precompilation helps to reduce the amount of time it takes for users to load P6 pages for the first time. The following instructions apply to all application servers supported by P6 EPPM. You need to perform these instructions while the application server is running.","Note Your application server must be listening on a HTTP port (non-SSL) for the precompile utility to work. You can later disable the HTTP port after precompilation if you will be using only HTTPS.","To precompile P6:","Locate the precompile_utility folder. It will be in the location where you installed P6 EPPM. For example:","C:\\P6EPPM_1\\p6\\precompile_utility (with Windows)","/usr/P6EPPM_1/p6/precompile_utility (with UNIX or Linux)","Run a command similar to the following:","java -jar JSPPrecompile.jar -u &lt;baseURL&gt; -f &lt;inputfile&gt;","where &lt;baseURL&gt; is the P6 URL and &lt;inputfile&gt; is the location of the P6 EAR file.","Note The file path of the P6 EAR file cannot contain spaces.","For example, the command should look similar to the following if you have a standard P6 installation on WebLogic:","If you deployed P6 in WebLogic:","java -jar JSPPrecompile.jar -u http://localhost:7001/p6&nbsp;-f &lt;p6home&gt;/p6.ear","where &lt;p6home&gt; is the location you installed P6. For example, C:\\P6EPPM_1\\p6\\p6.ear or /usr/P6EPPM_1/p6/p6.ear.","If you used the P6 EPPM Configuration Wizard to deploy P6:","java -jar JSPPrecompile.jar -u http://localhost:8203/p6&nbsp;-f p6home/p6.ear","where p6home is the location where you installed P6. For example, C:\\P6EPPM_1\\p6\\p6.ear or /usr/P6EPPM_1/p6/p6.ear.","Precompiling P6<br /> (Primavera P6 EPPM System Administration Guide for On-Premises)","English\\Admin\\p6_eppm_system_admin\\7312.htm");
Page[213]=new Array("To access P6 from Client Browsers using WebLogic:","Launch a supported browser. ","Enter the URL using the structure,","http://serverIP:listenport/ContextRoot/login","where listenport is 7001 (if you manually deployed P6) or 8203 (if you used the wizard to deploy P6) by default and ContextRoot is p6 by default.","Examples: ","http://serverIP:7001/p6/login","http://serverIP:8203/p6/login","Tip","HTTPS settings are available in the Primavera P6 Administrator. If you have set the HTTPS/Enabled setting to true, ensure that your application server or front-end Web server is listening on the specified HTTPS port. See Configuring HTTPS Settings in the Primavera P6 Administrator for more information on the HTTPS settings.","To select the authentication mode for P6, use the Primavera P6 Administrator. See About the Authentication Tab in the Primavera P6 Administrator for information about authentication configuration settings.","On the P6 login window, SSO users can choose to bypass the login window the next time by selecting the appropriate option. See Configuring Application Settings in the Primavera P6 Administrator for more information.","You can modify the context root. For information about context root configuration, refer to your application server documentation. Also, URLs might be case-sensitive, depending on your application server configuration.","See Tested Configurations for a list of supported application servers with version numbers.","For a full list of tested configurations for P6, see Tested Configurations.","Accessing P6 from Client Browsers using WebLogic<br /> (Primavera P6 EPPM System Administration Guide for On-Premises)","English\\Admin\\p6_eppm_system_admin\\14384.htm");
Page[214]=new Array("Features, such as exporting to Excel and resolving null pointer exceptions, require additional configuration settings on client machines. Some settings are required for a feature to work, while others are only necessary under certain conditions. You must configure your settings on each client machine requiring access to the feature.","Configuring Settings on Client Machines<br /> (Primavera P6 EPPM System Administration Guide for On-Premises)","English\\Admin\\p6_eppm_system_admin\\7319.htm");
Page[215]=new Array("Note Before you begin, ensure you are using the supported version of Mozilla Firefox. See the Tested Configurations document for more information.","Open Mozilla Firefox.","Go to Tools, Options.","In the Options dialog box:","Select the Security tab.","Select the Warn me when sites try to install add-ons option.","Select the Content tab.","Deselect the Block pop-up windows option.","Click OK to save your options and close the dialog box.","Configuring Browser Settings for Mozilla Firefox<br /> (Primavera P6 EPPM System Administration Guide for On-Premises)","English\\Admin\\p6_eppm_system_admin\\78596.htm");
Page[216]=new Array("Note Before you begin, ensure you are using the supported version of Safari. See the Tested Configurations document for more information.","Open Safari.","From the Settings drop-down, select Preferences.","In the General dialog box, select Security.","In the Web Content section:","Select the following:","Enable Plug-ins","Enable Java","Enable JavaScript","Deselect Block pop-up windows.","Select Advanced.","Select Press Tab to highlight each item on a webpage.","Close the dialog box. ","Tip","Complete the following steps to enable the Java plug-in:","From the Settings drop-down, select Preferences.","In the General dialog box, select Security.","In the Java section, select Run in Unsafe Mode for the P6 URL.","Configuring Browser Settings for Safari<br /> (Primavera P6 EPPM System Administration Guide for On-Premises)","English\\Admin\\p6_eppm_system_admin\\78341.htm");
Page[217]=new Array("You can use Oracle Secure Global Desktop to publish P6 EPPM and P6 Professional to remote users.","See the Tested Configurations document for supported versions of Oracle Secure Global Desktop.","For details on publishing Windows desktops, see the Oracle Secure Global Desktop Administration Guide. You will find the Secure Global Desktop documentation library here: http://www.oracle.com/technetwork/documentation/sgd-193668.html.","Using Oracle Secure Global Desktop<br /> (Primavera P6 EPPM System Administration Guide for On-Premises)","English\\Admin\\p6_eppm_system_admin\\62800.htm");
Page[218]=new Array("Application servers offer a variety of plug-ins that enable you to configure a front-end Web server other than the one provided with the application server. For procedures on configuring a Web server plug-in, refer to the application server's documentation.","Application Server Plug-Ins for P6 EPPM<br /> (Primavera P6 EPPM System Administration Guide for On-Premises)","English\\Admin\\p6_eppm_system_admin\\7328.htm");
Page[219]=new Array("The Database Configuration wizard enables you to change the database connection settings you specified when you installed P6.","The database you select during configuration stores one or more P6 EPPM configurations, each one specifying a set of parameters that determine how P6 operates. During configuration, you select an existing P6 EPPM configuration or create a new one. Later, you can use the Database Configuration wizard to select a different P6 EPPM configuration or create a new one. ","Note","After selecting a different P6 EPPM configuration or creating a new configuration, you must stop and restart the P6 application server for the changes to take effect.","You should protect the Database Configuration file (dbconfigpv) for security reasons. Depending on which method you used to protect the file, you might have to relocate the file to the production server to run the wizard after implementation. See &quot;Files to Protect after Implementation&quot; in the P6 EPPM Security Guide.","About the Database Configuration Wizard for P6<br /> (Primavera P6 EPPM System Administration Guide for On-Premises)","English\\Admin\\p6_eppm_system_admin\\34047.htm");
Page[220]=new Array("To change database connection settings for P6:","Do one of the following:","On Windows platforms, run dbconfigpv.cmd (located in the p6home directory that you specified when installing P6).","On UNIX platforms, change to the p6home directory that you specified when installing P6, and run dbconfigpv.sh.","On the Setup and Configuration of the Primavera P6 Database dialog box, select the database type.","On the Please enter the following information. . . dialog box:","Specify the database connection parameters. Type your database user name (for example, pubuser) and password, the database name, host address, and host port. The database name, host address, and host port are specific to your database installation. The Database Host Port field displays the default port for the database type you selected. You can edit this port.","To use the SSL protocol to securely communicate between the P6 application server and the database server, select the SSL option. If you select the SSL option, you must specify an SSL-enabled port number in the Database Host Port field.","Note","See the appropriate database server documentation and the My Oracle Support's Knowledge Articles for information on configuring SSL.","Using the SSL protocol will impact database performance.","Ensure that the Public Group ID is 1 for a standard configuration.","If there is an existing Primavera configuration, on the The installer has detected. . . dialog box, choose whether you want to use it, or create a new configuration.","Note","If you are upgrading from a previous version of P6 against the same database, choose the option to create a new configuration. This is necessary to accommodate newly added configuration settings. See Primavera P6 Administrator Setup Tasks for more information about configurations.","If you have not created a Primavera configuration, the The installer has detected. . . dialog box does not appear and the installation process automatically creates a default configuration named Primavera P6 Configuration. You can edit the settings for this configuration through the Primavera P6 Administrator.","When the message displays to confirm that the database configuration has completed successfully, click OK.","On the End of Installation screen, click Exit.","Changing Database Connection Settings for P6<br /> (Primavera P6 EPPM System Administration Guide for On-Premises)","English\\Admin\\p6_eppm_system_admin\\14395.htm");
Page[221]=new Array("For medium to large deployments, Oracle recommends setting up a dedicated node for job services, and disabling job services from running on servers accepting user traffic. ","Note","For details on what constitutes a medium or large deployment, see the P6 EPPM Performance and Sizing Guide.","These instructions assume that you have already configured the server accepting user traffic.","Oracle provides the following options to configure a dedicated node for job services:","Standalone deployment of p6services.jar. This option provides a simple installation process and runs the job services from an independent java process. See Configuring a Job Services Server Using p6services.jar","Application Server deployment of p6jobservices.war: This option provides the advantages of deployment to an application server, including remote monitoring of the health of the server, remote management of the server lifecycle, and improved error logging. This option runs job services from an application server instance that will not accept user traffic. See Configuring a Job Services Server Using p6jobservices.war","Configuring a Separate Server for Job Services<br /> (Primavera P6 EPPM System Administration Guide for On-Premises)","English\\Admin\\p6_eppm_system_admin\\98910.htm");
Page[222]=new Array("Follow the guidelines below to configure the dedicated job services server using p6services.jar:","Copy the p6services.jar from the p6home directory where you installed P6 to a node that will use job services.","Ensure a supported JRE is in the system path. (See the Tested Configuration for supported JREs.)","Open a new command line or terminal window.","Navigate to the folder where p6services.jar was copied (for example, c:\\jobservices).","Run the services application by entering java -Xms&lt;MEMORY SIZE&gt; &#8211;Xmx&lt;MEMORY SIZE&gt; &#8211;jar p6services.jar in the window. (See the P6 EPPM  Performance and Sizing Guide for the correct value for the &lt;MEMORY SIZE&gt; setting for your environment. The settings in the example are the recommended values.) ","The line should look similar to the following:","java -Xms4096m &#8211;Xmx4096m &#8211;jar p6services.jar","If you are using Sun JDK, it should look similar to the following:","java -server -Xms4096m &#8211;Xmx4096m &#8211;jar p6services.jar","If a BREBootStrap.xml file is in the USER_HOME, you can specify the location to the BREBootstrap.xml file by adding the following line:","Note","USER_HOME refers to your home directory. For example, in Windows it could be C:\\Users\\&lt;USER_NAME&gt; or C:\\Documents and Settings\\&lt;USER_NAME&gt;; in UNIX, it could be /home/&lt;USER_NAME&gt;.","If this is the first time you are launching p6services.jar, and a BREBootStrap.xml file does not exist in the USER_HOME, the database configuration wizard will launch. Skip to the next step.","&#8211;Dprimavera.bootstrap.home=&lt;BOOTSTRAP_LOCATION&gt;","The line should look similar to the following:","java -Xms4096m &#8211;Xmx4096m &#8211;Dprimavera.bootstrap.home=&lt;BOOTSTRAP_LOCATION&gt; -jar p6services.jar","where &lt;BOOTSTRAP_LOCATION&gt; is the location where the BREBootStrap.xml is located (for example, C:/USER_HOME).","If your organization needs to use Unicode characters, add to the JAVA_OPTS variable -Dfile.encoding=UTF-8","The line should look similar to the following:","java -Xms4096m &#8211;Xmx4096m &#8211;Dprimavera.bootstrap.home=&lt;BOOTSTRAP_LOCATION&gt; -Dfile.encoding=UTF-8 -jar p6services.jar","where &lt;BOOTSTRAP_LOCATION&gt; is the location where the BREBootStrap.xml is located (for example, C:/USER_HOME).","If this is the first time you are launching p6services.jar, and a BREBootStrap.xml file does not exist in the &lt;USER_HOME&gt; directory (or &lt;BOOTSTRAP_HOME&gt; directory if the primavera.bootstrap.home is specified), the database configuration wizard will launch.","Follow the steps in Changing Database Connection Settings for P6.","Create a new configuration when The Installer has detected... dialog box appears and give this new configuration a distinct name. For example, if you chose &quot;P6 Users&quot; for the configuration name for the server accepting user traffic, name the new configuration &quot;P6 Job Services.&quot;","Note Create a new configuration for Job Services to ensure optimal database performance. Job Services could slow down performance if it is part of the same configuration.","In the Primavera P6 Administrator: ","Locate the Services/Enable All Services setting for the configuration created for the job services server (for example, P6 Job Services). Set the setting to true to enable all services.","Locate the Services/Enable All Services setting for the configuration created for user traffic (for example, P6 Users). Set the setting to false to disable all services.","Configuring a Job Services Server Using p6services.jar<br /> (Primavera P6 EPPM System Administration Guide for On-Premises)","English\\Admin\\p6_eppm_system_admin\\47615.htm");
Page[223]=new Array("Note  These instructions assume that you have already installed and configured WebLogic Middleware and have deployed P6.  These instructions provide single WebLogic node deployment steps, but you can target the application to a WebLogic cluster.","Follow the guidelines below to configure a dedicated job services server using p6jobservices.war:","Create a new directory in the P6 EPPM installation folder for p6jobservices.","Copy the following files from the p6home directory where you installed P6 to the new directory you created in the previous step:","p6jobservices.war","adminpv.cmd or adminpv.sh","dbconfigpv.cmd or dbconfigpv.sh","installp6keystore.bat or installp6keystore.sh","p6keystore.jks","lib folder and all files","In the new directory:","Open adminpv.cmd or adminpv.sh in a text editor.","Change the PV_HOME environment variable to match the location of the new directory.","Change the JAVA_HOME environment variable to match the location of your JDK home directory.","Save changes and close the file.","Open dbconfigpv.cmd or dbconfigpv.sh in a text editor.","Change the PV_HOME environment variable to match the location of the new directory.","Change the JAVA_HOME environment variable to match the location of your JDK home directory. ","Save changes and close the file","Open installp6keystore.bat or installp6keystore.sh in a text editor.","Change the JAVA_HOME environment variable to match the location of your JDK home directory.","Save changes and close the file","Copy the new directory to a WebLogic node where you will deploy p6jobservices.war.  ","If the WebLogic Admin Server runs on a different physical node from your managed server, copy the directory to your admin server to deploy the application.","If the PV_HOME or JAVA_HOME directory path is different from the path you modified earlier, you must update the files to reflect the actual location on the new node.","Note If you deploy p6jobservices.war to a cluster, the directory must be present on all nodes in the cluster.","If you are using external encryption, generate a new password file for reading p6keystore.jks using the following command:","Windows: installp6keystore.cmd -genpassfile","Unix: ./installp6keystore.sh -genpassfile","Note For more information on encryption keys for P6 EPPM, see: External Storage Of Encryption Keys For P6 EPPM (KB610056) at https://support.oracle.com/support/?kmExternalId=KB610056","To create a BREBootStrap.xml file in the job services directory, run dbconfigpv.cmd or dbconfigpv.sh.","In the Database Configuration Wizard:","Select your database type, then click Next.","Enter the required information for connecting to your database, then click Next.","Select the option to create a new configuration for job services, then click Next.","Click OK.","Check that a BREBootStrap.xml file was created in the job services directory.","Note If you deploy p6jobservices.war to a cluster, you must create a BREBootStrap.xml file on all nodes of the cluster.  ","Create a new managed server in your WebLogic domain and set the following JVM parameters for the managed server:","-Xms&lt;MEMORY SIZE&gt; -Xmx&lt;MEMORY SIZE&gt;","For example: -Xms4096m &#8211;Xmx4096m","Note See the P6 EPPM  Performance and Sizing Guide for the correct value for the &lt;MEMORY SIZE&gt; setting for your environment. The settings in the example are the recommended values.","-Dprimavera.bootstrap.home=&lt;BOOTSTRAP_LOCATION&gt;","Where &lt;BOOTSTRAP_LOCATION&gt; is the location of the BREBootStrap.xml file.","-Dfile.encoding=UTF-8","This is required only if your organization needs to use Unicode characters.","Deploy p6jobservices.war to the managed server.","See the P6 EPPM WebLogic Configuration Guide.","Launch adminpv.cmd or adminpv.sh.","Select the configuration used by job services.","Expand Services and select General.","Select the Enable All Services option.","Select the configurations used by all other P6 EPPM web deployments and clear the Enable All Services option.","Restart all the deployments you changed.","When upgrading your P6 EPPM environment perform the following steps:","Replace the following files in the job services directory with the upgraded files from your p6home directory:","p6jobservices.war","lib folder and all files","Launch adminpv.cmd or adminpv.sh.","On the Configurations tab, right-click the job services configuration. ","Click Update to latest version.","Click Save Changes.","To redeploy the updated p6jobservices.war to your WebLogic environment:","Login to your WebLogic Administration Console.","In the Change Center pane, click Lock &amp; Edit. ","In the Domain Structure pane, click Deployments. ","In the Configuration tab on the Summary of Deployments page, click Update.","Click Finish.","Configuring a Job Services Server Using p6jobservices.war<br /> (Primavera P6 EPPM System Administration Guide for On-Premises)","English\\Admin\\p6_eppm_system_admin\\98911.htm");
Page[224]=new Array("You can create custom URL so that users can directly access pages.","In order to create custom URLs, you must be a database user, such as privuser or admuser, that can make queries against the P6 EPPM database for project wbsids. If you do not have database access to P6 EPPM, refer to your P6 EPPM database administrator.","Users can only access custom URLs to access pages as long as they have Project module access and OBS access to projects and project templates. ","Any P6 EPPM user can use a custom URL, as long as they have Project module access. If the user does not have access to the projects listed in the URL, P6 EPPM will open to the Open Projects dialog box.","To create a custom URL:","Determine the base URL for your P6 EPPM instance. ","The base URL follows the format http://&lt;server&gt;:&lt;port&gt;/p6/bookmark?uri=navigatetopage&amp;ctx=","For example, http://corporatep6server:8203/p6/bookmark?uri=navigatetopage&amp;ctx=","Determine the wbs_ids of the projects that you want users to access by completing the following:","Log in to the P6 EPPM database with the following script and provide the relevant password when prompted:","sqlplus &lt;admuser or privuser&gt;@&lt;db_tns_names_entry&gt;","Run the following scripts for the project wbs_ids:","column wbs_short_name format a20","column wbs_name format a30","select pw.wbs_id, pw.proj_id, pw.wbs_short_name, pw.wbs_name from projwbs pw inner join project p on pw.proj_id=p.proj_id where pw.proj_node_flag = 'Y' and p.project_flag='Y' and orig_proj_id is null;","Note","In addition to returning wbs_ids and proj_ids, the last line of the script also returns the wbs_short_name and wbs_name in order to provide you more context for each wbs_id and proj_id that you return.","By default, the wbs_short_name and wbs_name have a length of 40 and 100 characters respectively. The first two lines of the script reduce the displayed characters of the wbs_short_name and wbs_name to 20 and 30 characters respectively in order to prevent the column length from overtaking the output.","Create a string of parameters and their values to describe the view. You must list the parameters in the order described in this step and separate the parameters with an ampersand. Do not include an ampersand after the last parameter. The parameters available are:","projectList: A comma-separated list of wbs_ids for the projects that you want to display.","For example, 3165,65422,984&amp;","key: Determines which page will be opened.","Supported values: activities","For example, key=activities&amp;","(Optional) showNavigation: Determines whether to show the header bar when P6 EPPM opens. If this parameter is not included or it is set to true, P6 EPPM opens with the header bar. If this parameter is set to false, P6 EPPM opens without the header bar.","Supported values: true or false","For example, showNavigation=false","Note Your string should be similar to projectList=3165,65422,984&amp;key=activities&amp;showNavigation=false","Percent-encode the string.","For example, you could use URL Encoder/Decoder at http://meyerweb.com/eric/tools/dencoder/.","Note After you percent-encode your string, the string should be similar to projectList%3D3165%2C65422%2C984%26key%3Dactivities%26showNavigation%3Dfalse","Append the string to the base URL.","For example: http://corporatep6server:8203/p6/bookmark?uri=navigatetopage&amp;ctx=projectList%3D3165%2C65422%2C984%26key%3Dactivities%26showNavigation%3Dfalse","Creating Custom URLs to Access Pages<br /> (Primavera P6 EPPM System Administration Guide for On-Premises)","English\\Admin\\p6_eppm_system_admin\\90523.htm");
Page[225]=new Array("This chapter includes information create a new configuration for P6 Team Member, configure P6 Team Member settings, configure Email Statusing Service for P6, and to configure IIS 8.5 for P6 Team Member.","P6 Team Member Setup Tasks<br /> (Primavera P6 EPPM System Administration Guide for On-Premises)","English\\Admin\\p6_eppm_system_admin\\90347.htm");
Page[226]=new Array("To create a Primavera P6 Administrator configuration:","Do one of the following:","On Windows platforms, run dbconfigpv.cmd (located in the p6home directory that you specified when installing P6).","On UNIX platforms, change to the p6home directory that you specified when installing P6, and run dbconfigpv.sh.","On the Setup and Configuration of the Primavera P6 Database dialog box, select the database type.","On the Please enter the following information... dialog box:","Specify the database connection parameters. Type your database user name and password, the database name, host address, and host port. The database name, host address, and host port are specific to your database installation. The Database Host Port field displays the default port for the database type you selected. You can edit this port.","To use the SSL protocol to securely communicate between the P6 application server and the database server, select the SSL option. If you select the SSL option, you must specify an SSL-enabled port number in the Database Host Port field.","Note","See the appropriate database server documentation and the My Oracle Support's Knowledge Articles for information on configuring SSL.","Using the SSL protocol will impact database performance.","Ensure that the Public Group ID is 1 for a standard configuration.","Select Create a new configuration and then enter the name of your new configuration (for example, Team Member Configuration).","Click Next.","Click OK.","Creating a New Primavera P6 Administrator Configuration<br /> (Primavera P6 EPPM System Administration Guide for On-Premises)","English\\Admin\\p6_eppm_system_admin\\89116.htm");
Page[227]=new Array("To configure the settings for P6 Team Member Web, you must have a P6 Team Member Admin Configuration. See Installing and Configuring P6 EPPM for more information on how to create this configuration during a new installation of P6 Team Member Web or P6 EPPM.","To configure the settings for P6 Team Member Web:","Launch Primavera P6 Administrator.","Navigate to your P6 Team Member configuration, and then expand it.","Expand Application:","Set the Help server URL to one of the following:","http://localhost:listenport/ContextRoot","where localhost is your server's host name, listenport is your P6 Team Member port number, and ContextRoot is the root for your Help.","https://docs.oracle.com/cd/E90746_01/team_member/web/help/","Note Oracle recommends that you use the second URL option because it ensures that you always access the latest version of the P6 Team Member Help, including critical corrections and enhancements.","Expand Team Member:","Expand Connection Pool if you want to alter the following default values:","Initial connection pool size: 10","Maximum active database connections: 150","Maximum idle database connections: -0","Minimum idle database connections: 10","Expand Logging if you want to alter the following default values:","Enable: enabled","Severity Level: Error","Log File Name: p6tmweb.log","Note","The primavera.bootstrap.home property determines the location of the log file.","Configuring P6 Team Member Web Settings<br /> (Primavera P6 EPPM System Administration Guide for On-Premises)","English\\Admin\\p6_eppm_system_admin\\55075.htm");
Page[228]=new Array("To configure Email Statusing Service for P6:","From the P6 Team Member home directory (for example, C:\\P6EPPM_1\\tmws), extract the files from the p6tm-email-service.zip to any location on the application server. (That location will be referred to as EMAIL_HOME).","Make a backup copy of the config.properties file before you edit it.","Edit the config.properties file to configure the settings for the email application.","Note When you are finished editing the config.properties file, move it to a secure location.","In the P6 Configuration section, locate and specify the following:","In the p6.admin.user = line, specify a P6 user who is assigned to at least one module access and has resource access.","In the p6.notify.user= line, specify the email addresses, separated by commas, of users who can send Notify Task lists to other users. As you see the P6 Help for more information on sending team members their tasks.","In the p6.max.tmusers = line, specify the maximum number of email recipients that can receive notification emails at one time. You should keep the number below 500 to avoid performance problems.","In the p6.bootstrap = line, specify the location of the BREBootstrap.xml file.","For example, the location could be one of the following: C:/P6EPPM_1/p6, C:/EMAIL_HOME, /usr/P6EPPM_1/p6, or /usr/EMAIL_HOME or you can use the following: C:\\\\P6EPPM_1\\p6, C:\\\\EMAIL_HOME.","In the mail.read.schedule = line, specify how often your email should process new messages. Use cron expressions for your formatting. For example:","0 */5 * * * ?","will process new messages every five minutes.","Note For more information on cron expressions, see https://docs.oracle.com/cd/E12058_01/doc/doc.1014/e12030/cron_expressions.htm.","In the Outgoing mail (SMTP Settings) section, locate and specify the following:","In the send.host = line, specify the SMTP server hostname or IP address that you will use to send emails.","In the send.port = line, specify the port number that connects to the SMTP server.","In the send.ssl = line, specify true to use SSL or false if you will not use SSL.","Note Oracle recommends that you always use SSL in a production environment for secure communications.","In the send.starttls = line, specify true to use TLS or false if you will not use TLS.","In the send.email = line, specify the email address or User Principal Name (UPN) where team members will send their status update requests.","In the send.replyto = line, specify an email address for team members to respond to when they receive emails. If this field is left blank, the reply address will be the send.email address you specified above.","In the send.password = line, specify the password for the email address or UPN you just specified. ","Note","If you do not specify a password now, the email application prompts you to specify one when it runs. ","You can also specify a password by running the following parameter when you run the 'run.bat' or 'run.sh' file:<br />-Dsend.password=YOUR_PASSWORD<br />where Your_Password is the password for your status email address.<br />For example: <br />In Windows: ./run.bat -Dsend.password=YOUR_PASSWORD<br />In UNIX: ./run.sh -Dsend.password=YOUR_PASSWORD","Oracle recommends using the option in the config.properties file and then moving that file to a secure location when you are finished modifying it.","If you want to set up anonymous authentication for an SMTP server, comment this field out.","In the Incoming Mail (IMAP Settings) section, locate and specify the following:","In the imap.host = line, specify the IMAP protocol host to read emails.","In the imap.port = line, specify the IMAP port number.","In the imap.ssl= line, specify true to use SSL or false if you will not use SSL.","NoteOracle recommends that you always use SSL in a production environment for secure communications.","In the imap.username = line, specify the IMAP user name (which will be your email address) or User Principal Name (UPN).","In the imap.password = line, specify the password for the user name you just specified.","Note","If you do not specify a password now, the email application will ask you to specify one when it runs. ","You can also specify a password by running the following parameter when you run the 'run.bat' or 'run.sh' file:<br />-Dimap.password=YOUR_PASSWORD<br />where Your_Password is the password for your status email address.<br />For example: <br />In Windows: ./run.bat -Dimap.password=YOUR_PASSWORD<br />In UNIX: ./run.sh -Dimap.password=YOUR_PASSWORD","Oracle recommends using the option in the config.properties file and then moving that file to a secure location when you are finished modifying it.","If you want to setup anonymous authentication for an SMTP server, comment this field out.","In the imap.search.folder = line, specify the folder to use for processing incoming emails. For example:","imap.search.folder = inbox","Note The email application will use this folder to search for incoming mail. Oracle recommends you use the inbox for this folder. If you select another folder, you must ensure that all emails get filtered there, or the email application will not be able to detect the messages.","In the IMAP Folder configuration section, locate and specify the following:","In the imap.success.folder = line, specify the folder where messages that process successfully will go. For example:","imap.success.folder = P6Success","Note The email application will automatically create this folder if you do not create it now.","In the imap.failure.folder = line, specify the folder where messages that failed will go. For example:","imap.failure.folder = P6Fail","Note The email application will automatically create this folder if you do not create it now.","In the imap.temp.folder = line, specify the folder where messages that are being processed will go. For example: ","imap.temp.folder = P6Temp","Note The email application will automatically create this folder if you do not create it now.","In the Task update options section, locate and specify the following:","In the reply.label.cleanup field, enter true if you want to remove HTML tags attached to the task field labels. Enter false if you don't want to remove the tags.","In the reply.label.tag.search field, enter the regular expression to remove unexpected HTML tags during reply message parsing.","Note See information on &quot;regular expression&quot; for more details on this field. For example, see https://developer.mozilla.org/en-US/docs/JavaScript/Guide/Regular_Expressions#Writing_a_Regular_Expression_Pattern.","In the update.debug field, enter true if you want to output the contents of the email message as it is parsed for updates. Enter false if you don't want to output the contents of the email message as it is parsed for updates. You should only enter true when you are troubleshooting issues with updating tasks. ","In the Message Format options section, locate and specify the following:","In the update.task.search.term = line, specify the text that the email application should search for in the subject line of incoming messages. For example:","update.task.search.term = Your Requested P6 Tasks","In the notify.update.task.search.term = line, specify the text that the email application should search for in the subject line of incoming messages that originated from a Notify message. For example:","update.task.search.term = Your P6 Tasks","If the EMAIL_HOME is on a different server from your P6 home, copy the BREBootstrap.xml from your P6 home to your EMAIL_HOME.","If the EMAIL_HOME is on the same server as your P6 home, you will use the BREBootstrap.xml that is in your P6 home folder.","Run one of the following:","In Windows, launch the run.bat file.","In UNIX, launch the run.sh file.","When you launch the run file, you may have to complete the following steps depending on how you configured your Email Statusing Service:","If the config.properties file and the run file are in different folders, you will need to specify the config.properties location with the -Dconfig.file parameter.","In Windows (add a space between run.bat and -Dconfig):","run.bat -Dconfig.file=C:\\home\\auser\\somelocation\\config.properties","In UNIX (add a space between run.sh and -Dconfig): ","./run.sh -Dconfig.file=/home/auser/somelocation/config.properties","If you didn't specify the send.password= or imap.password=, you can specify them now. If you do not specify them now, the email application will prompt you to do so when it runs.","In Windows: ","run.bat -Dsend.password=YOUR_PASSWORD","In UNIX:","./run.sh -Dsend.password=YOUR_PASSWORD","In Windows:","run.bat -Dimap.password=YOUR_PASSWORD","In UNIX:","./run.sh -Dimap.password=YOUR_PASSWORD","where Your_Password is the password for your status email address","If your bootstrap file contains more than one database, you need to clarify which database you are using when you launch the run file.","In Windows:","run.bat -Ddatabase.instance=db_id","where db_id is your database instance (for example, -Ddatabase.instance=2).","In UNIX: ","./run.sh -Ddatabase.instance=db_id","where db_id is your database instance (for example, -Ddatabase.instance=2).","Once the run file finishes, you can verify that the email status application works. See Verifying Email Statusing Service.","Note Anonymous SMTP authentication is supported.","Configuring Email Statusing Service for P6<br /> (Primavera P6 EPPM System Administration Guide for On-Premises)","English\\Admin\\p6_eppm_system_admin\\49980.htm");
Page[229]=new Array("Once you have installed the email status application, you can send an email to verify that the server is setup properly.","To verify your Email Statusing Service setup:","Enter an email address that P6 recognizes in the 'From' line.","Enter the email address you specified in Configuring Email Statusing Service for P6 in the 'To' line.","Enter Ping in the subject line.","Send the message.","If the message is successful, you will receive a message containing the status of the email service. The message will tell you how many users have a blank email address in the database.","If the message failed, you will not receive a message. The failed message will appear in the failure folder that you specified in the config.properties file. See Configuring Email Statusing Service for P6.","Verifying Email Statusing Service<br /> (Primavera P6 EPPM System Administration Guide for On-Premises)","English\\Admin\\p6_eppm_system_admin\\49982.htm");
Page[230]=new Array("To ensure that your instance of P6 Team Member works correctly with IIS 8.5, you will need to update your web.config file; otherwise, you might experience an error when attempting to select an option from the My Tasks drop-down list.","To configure IIS 8.5 for P6 Team Member:","Navigate to %SystemDrive%\\inetpub\\wwwroot.","Open web.config.","Add &lt;modules&gt;&lt;remove name=&quot;WebDAVModule&quot; /&gt;&lt;/modules&gt; to the inside of the &lt;system.webServer&gt;&lt;/system.webServer&gt; tag.","Add &lt;remove name=&quot;WebDAV&quot; /&gt; beneath the &lt;handlers&gt;&lt;/handlers&gt; tag, which can be found inside the &lt;system.webServer&gt;&lt;/system.webServer&gt; tag.","Save the file and the close it.","Configuring IIS 8.5 for P6 Team Member<br /> (Primavera P6 EPPM System Administration Guide for On-Premises)","English\\Admin\\p6_eppm_system_admin\\89730.htm");
Page[231]=new Array("Complete the following task to finish enabling P6 Integration API.","P6 Integration API Setup Tasks for On-Premises<br /> (Primavera P6 EPPM System Administration Guide for On-Premises)","English\\Admin\\p6_eppm_system_admin\\53247.htm");
Page[232]=new Array("The P6 Integration API Database Configuration wizard lets you create a new configuration or switch to a different configuration than the one specified during the P6 Integration API installation.","The database you connect to during the installation stores one or more P6 Integration API configurations. Each configuration specifies a set of configurable parameters that determine how the P6 Integration API operates. If no configuration exists in the database the first time you install the P6 Integration API, you must create a new configuration. For subsequent configurations, you can select an existing configuration or create a new one. After configuration, you can use the Database Configuration wizard to select a different P6 Integration API configuration or create a new one.","Note After selecting a different P6 Integration API configuration or creating a new configuration, you must stop and restart the server for the changes to take effect.","Starting the Database Configuration wizard","On Windows, go to the &lt;API_INSTALL_HOME&gt; directory and run the dbconfig.cmd script. Depending on your installation, the home directory may be: C:\\P6EPPM_1\\api.","On UNIX, change to the &lt;API_INSTALL_HOME&gt; directory and run the dbconfig.sh script. Depending on your installation, the home directory may be: /usr/P6EPPM_1/api.","Changing Database Configuration Settings for P6 Integration API<br /> (Primavera P6 EPPM System Administration Guide for On-Premises)","English\\Admin\\p6_eppm_system_admin\\38138.htm");
Page[233]=new Array("The Java security manager enables programmers to establish a custom security policy for their Java applications.","Unless you enable the security manager before you start the P6 Integration API server, the security manager is disabled. To enable/disable the security manager, edit the P6 Integration API server's startup script with a text editor and uncomment or comment the appropriate command:","For Windows, edit the startAppServer.cmd file. ","For Linux, edit the startAppServer.sh file.","Uncomment or comment one of the following:","In Windows:","SET ENABLE_JAVA_SECURITY_MANAGER=-Djava.security.manager","Linux:","ENABLE_JAVA_SECURITY_MANAGER=-Djava.security.manager","Note The P6 Integration API server can use different policy files for different application/web servers.","Enabling the Java Security Manager<br /> (Primavera P6 EPPM System Administration Guide for On-Premises)","English\\Admin\\p6_eppm_system_admin\\38140.htm");

Page[234]=new Array("Because one P6 Integration API server instance can control more than one database, in addition to specifying an authentication mode for a database through the Authentication tab of the Primavera P6 Administrator, you can use an administrative configuration setting to specify the overall mode you want to use for the P6 Integration API server. The P6 Integration API uses a single P6 Professional configuration setting, Authentication.Mode, to support authentication selection. For LDAP authentication with secure communication (SSL) between the P6 Integration API server and the LDAP server, two additional configuration settings are required.","Use the Primavera P6 Administrator to specify these configuration settings.","Note A P6 Integration API configuration might include database instances that are not set to the same authentication mode as the P6 Integration API server. If a user connects and requests a database that is set to a different authentication mode than the P6 Integration API server, an error message displays. The user must select a database that matches the authentication mode set for the P6 Integration API server.","Configuring P6 Integration API Authentication<br /> (Primavera P6 EPPM System Administration Guide for On-Premises)","English\\Admin\\p6_eppm_system_admin\\38151.htm");
Page[235]=new Array("Complete the following tasks to finish enabling P6 EPPM Web Services.","P6 EPPM Web Services Setup Tasks<br /> (Primavera P6 EPPM System Administration Guide for On-Premises)","English\\Admin\\p6_eppm_system_admin\\53293.htm");
Page[236]=new Array("The Primavera Database Configuration wizard lets you create a new configuration or switch to a different configuration than the one specified during P6 EPPM Web Services installation.","The database you connect to during the installation stores one or more P6 EPPM Web Services configurations. Each configuration specifies a set of configurable parameters that determine how P6 EPPM Web Services operates. The first time you install P6 EPPM Web Services, if no configuration exists in the database, you must create a new configuration. For subsequent installs, you can select an existing configuration or create a new one. After configuration, you can use the Database Configuration wizard to select a different P6 EPPM Web Services configuration or create a new one.","Note After selecting a different P6 EPPM Web Services configuration or creating a new configuration, you must stop and restart the server for the changes to take effect.","Starting the Database Configuration wizard","On Windows, go to the &lt;WS_INSTALL_HOME&gt;/bin directory and run the dbconfig.cmd script. Depending on your installation, the home directory may be: C:\\P6EPPM_1\\ws\\bin.","On UNIX, change to the &lt;WS_INSTALL_HOME&gt;/bin directory and run the dbconfig.sh script. Depending on your installation, the home directory may be: /usr/P6EPPM_1/ws/bin.","Changing Database Configuration Settings for P6 EPPM Web Services<br /> (Primavera P6 EPPM System Administration Guide for On-Premises)","English\\Admin\\p6_eppm_system_admin\\35677.htm");





Page[237]=new Array("To set your compression settings:","Open the Primavera P6 Administrator.","In the Configurations drop-down list, select your configuration.","In the sidebar select Web Services/Compression.","Set the minimum size for response compression. responses smaller than this will not be compressed to gzip format.","Set a value between Between 0 and 2147483647 bytes, the default is 400.","Configuring Compression Settings for P6 EPPM Web Services<br /> (Primavera P6 EPPM System Administration Guide for On-Premises)","English\\Admin\\p6_eppm_system_admin\\101144.htm");
Page[238]=new Array("By default, the P6 EPPM Configuration Wizard deploys P6 EPPM Web Services with the oracle/wss_username_token_server_policy OWSM policy. This policy does not contain message protection and encryption.","To add a new policy to OWSM for message protection and encryption:","Create a Java Keystore.","For information about Java keystores and instructions to create one, refer to the SAML Message Protection Use Case chapter of the Oracle Fusion Middleware Securing Web Services and Managing Policies with Oracle Web Services Manager guide on Oracle Technical Network.","Configure OWSM to use the JKS Keystore.","For information about Java keystores and instructions to create one, refer to the Managing OWSM Domain Configuration chapter of the Oracle Fusion Middleware Securing Web Services and Managing Policies with Oracle Web Services Manager guide on Oracle Technical Network.","Log in to WebLogic Enterprise Manager using the following URL:","http://&lt;Host_Name&gt;:&lt;Port&gt;/em","Navigate to WebLogic Domains in the Target Navigation directory and right-click owsm.","In the owsm menu, select Web Services and then click WSM Policy Sets.","Select P6WSSOAP and then click Edit.","Note Edit becomes available when a policy set is selected.","Add additional policies to the policy set by completing the following:","On the Edit Policy Set: Enter General Information page, click Next.","On the Edit Policy Set: Enter Resource Scope page, click Next.","On the Edit Policy Set : Enter Constraint page, click Next.","On the Edit Policy Set: Add Policy References page, attach one of the following policies from the Available Policies table and then click Next:","oracle/wss11_username_token_with_message_protection_server_policy"," oracle/wss11_saml20_token_with_message_protection_server_policy OWSM","Note Refer to OWSM documentation for descriptions of each policy.","On the Edit Policy Set: Summary page, click Save.","Navigate to P6WebServices in the Target Navigation directory.","Click Apply JRF Template.","Restart the P6 server.","Adding Additional Policies to Oracle Web Services Manager<br /> (Primavera P6 EPPM System Administration Guide for On-Premises)","English\\Admin\\p6_eppm_system_admin\\91758.htm");
Page[239]=new Array("The following sections detail solutions for problems you may encounter with P6 EPPM.","Troubleshooting for P6 EPPM<br /> (Primavera P6 EPPM System Administration Guide for On-Premises)","English\\Admin\\p6_eppm_system_admin\\80036.htm");
Page[240]=new Array("An enhancement was made with P6 R8.4 to store documents in folders using the short name of the project instead of the database object ID. The P6 users' documents will now be stored in a folder called 'P6Users' instead of 'Users'. If you were using a previous version of the content repository P6 but did not run the migration utility provided in the media pack when you upgraded your environment, the content repository will not work.","To fix this issue:","Shutdown the P6 server.","Go to the P6EPPM_Home/p6 folder.","Run migrationtool.cmd or migrationtool.sh (based on your operating system).","After the utility finishes:","Go to the P6EPPM_Home/p6/webaccesslogs folder and ensure it contains Document-migration.html. ","Open the Document-migration.html file and ensure all the folder names changed successfully. Ensure nothing failed.","If anything failed, log in to the content repository and manually move the documents that failed to move from the older document folders to the new document folders.","Project Documents example: ","Assume there is a Project called &#8216;Business Development Processes' whose Database ID is &#8216;4321' and Project ID &#8216;BDP001'. In the content repository, you would be able to see two folders: one with the name &#8216;4321' and one with the name &#8216;BDP001'. ","Open the 4321 folder and copy all the documents in this folder. ","Open folder BDP001 and paste all the documents in this folder. ","After you finish copying the documents, you can safely delete the 4321 folder from the content repository.","User Documents example: ","If you log in to the content repository and navigate to the Project Document home, you would see only two folders: Projects and P6Users . If you see a third folder named Users, follow these steps:","Open the P6Users folder and make a note of the folder names.","Open the Users folder and check if the above folder names are present. ","If a folder name is not present in the Users folder, copy that missing folder from P6Users to Users. Repeat this step for all the missing folders.","If a folder name is present in the Users folder, manually move the documents from that folder in P6Users to the same folder in Users folder. Repeat this step for all the matching folders.","Delete the P6Users folder.","Rename the Users folder to P6Users in the content repository.","Start the P6 server and ensure you can see all the documents.","Troubleshooting for Connecting the Content Repository<br /> (Primavera P6 EPPM System Administration Guide for On-Premises)","English\\Admin\\p6_eppm_system_admin\\80035.htm");
var PageCount=140;


/*
Date: 12/11/2025 7:41 PM
Source: EPPM_25_dev
BookID: 52385
PubProduct: PRIMAVERA_EPPM
BookTitle: System Administration Guide for On-Premises
Version: Version 25
Lang:	en
*/
/* relative_path_for_link: English\Configuring\p6_eppm_bpm_config*** */
/* BookTitleTop: Primavera P6 EPPM BPM Configuration Guide for On-Premises*** */
/* Generated with Author-it 23.4.1.30004  12/3/2025 5:52:54 PM */
Page[241]=new Array("Title and Copyright Information","Copyright  1999, 2025, Oracle and/or its affiliates.","Primary Author: Oracle Corporation","Title and Copyright Information<br /> (Primavera P6 EPPM BPM Configuration Guide for On-Premises)","English\\Configuring\\p6_eppm_bpm_config\\46576.htm");
Page[242]=new Array("Scope","This guide describes how to configure BPM for integration with P6. Additionally, this guide provides information on creating cluster environments for BPM and testing your BPM-P6 integration.","Audience","System administrators should use this guide.","Using This Guide","This guide assumes you have installed P6 and its supporting applications. For more information, see the P6 EPPM Installation and Configuration Guide.","About This Guide<br /> (Primavera P6 EPPM BPM Configuration Guide for On-Premises)","English\\Configuring\\p6_eppm_bpm_config\\94213.htm");
Page[243]=new Array("The Oracle Business Process Management (BPM) Suite provides an integrated environment for developing, administering, and using business applications centered around business processes. BPM supports BPM and Business Process Execution Language (BPEL) standards from modeling and implementation to run-time and monitoring.","P6 integrates with BPM which lets you initiate and manage workflows. You can use a sample project initiation workflow for P6 sample database.","You can expand your investment in BPM to include workflows representing more stages of your application, program, project, or product development life cycle from design-time and implementation to run-time and application management.","The Oracle BPM Suite enables you to:","Create and customize business processes, models, and standards using pre-defined components for web-based applications. ","Collaborate between process developers and process analysts.","Expand business process management to include flexible, unstructured processes.","Integrate your applications with Web Services.","Add dynamic tasks and support approval routing using declarative patterns and rules-driven flow determination.","Unify different stages of your development life cycle by addressing end-to-end requirements for developing process-based applications. Oracle BPM unifies the design, implementation, run time, and monitoring stages based on a Service-Oriented Architecture (SOA) infrastructure. This allows different personas to participate through all stages of the workflow life-cycle.","Oracle BPM Setup Tasks<br /> (Primavera P6 EPPM BPM Configuration Guide for On-Premises)","English\\Configuring\\p6_eppm_bpm_config\\49382.htm");
Page[244]=new Array("Before continuing, ensure the following required conditions have been addressed:","Note See the Tested Configurations document for information on supported versions.","On the domain where you will install P6 EPPM, configure WebLogic Middleware with Oracle Application Development Framework (Oracle ADF). This will ensure the P6 EPPM domain will have Oracle WSM Policy Manager and Oracle JRF modules, which you must have when integrating P6 EPPM with BPM.  To download the Oracle ADF, refer to the following link: http://www.oracle.com/technetwork/developer-tools/adf/downloads/index.html","Note  If you installed the Oracle Fusion Middleware SOA Suite to the same WebLogic Middleware home where you installed P6 EPPM, then the Oracle ADF is already available and you can skip this step.","Download the Oracle BPM Suite documentation from http://www.oracle.com/technetwork/middleware/soasuite/documentation/index.html. See Tested Configurations for the supported versions of BPM.","See http://www.oracle.com/technetwork/middleware/soasuite/downloads/index.html to accept a license agreement and download a BPM package.","Install Oracle BPM. See the BPM documentation at http://www.oracle.com/technetwork/middleware/soasuite/documentation/index.html to guide you. When you design and develop your own workflows in 12c, you will need JDeveloper with extensions or Oracle Business Process Composer for 12c.","Note You can use BPM with P6 EPPM.","Install and configure P6 EPPM. This includes having completed any licensing requirements and downloading any documentation for P6 EPPM, including P6 and P6 EPPM Web Services.","Make sure you have a working configuration of P6. The term P6 refers to the web application user interface for the main module in the P6 EPPM suite.","You must deploy the Oracle WSM Policy and JRF modules for P6 to work with BPM. If you use the P6 EPPM Configuration Wizard, you can use it to deploy the Oracle WSM Policy and JRF modules. You will have to have a WebLogic domain to deploy the policy and module. You can also deploy the Oracle WSM Policy and JRF modules manually in WebLogic if you choose not to use the configuration wizard to do so.","Note P6 EPPM Web Services and P6 (which includes Oracle WSM Policy manager and Oracle WSM JRF modules) can be on the same domain or separate domains. However, if OWSM is enabled for P6 EPPM Web Services, then BPM will not work with P6 .","Make sure you have installed P6 EPPM Web Services and ensure its authentication mode matches BPM's authentication mode. For example, Username Token Profile or SAML.","Note Cookie authentication is not currently supported at this time.","Configure both BPM and P6 to work together. See Integrating Oracle BPM 12c with P6 in this guide for steps.","To ensure the BPM functionality is available in P6, you must set up a username in BPM that matches an equivalent P6 username (only the username value must match; Passwords can be different between the environments).","You must assign the user in BPM the appropriate role to perform the functional requirements. Refer to Testing the Connection for P6, BPM, and Web Services.","Pre-Integration Requirements for BPM: Start Here<br /> (Primavera P6 EPPM BPM Configuration Guide for On-Premises)","English\\Configuring\\p6_eppm_bpm_config\\89465.htm");
Page[245]=new Array("To integrate Oracle BPM with P6, you must complete the following tasks in the specified order:","Modifying the P6 Environment for BPM","Configuring P6 to Connect to Oracle BPM","Integrating Oracle BPM with P6<br /> (Primavera P6 EPPM BPM Configuration Guide for On-Premises)","English\\Configuring\\p6_eppm_bpm_config\\89466.htm");
Page[246]=new Array("To configure BPM with P6:","Create a new directory on the host where P6 is running. For example, P6BPMConnector/P6 and P6BPMConnector/BPM.","In the P6 media pack Tools\\BPM Connector\\12c subfolder, locate the following file:","prm-bpm-connector-12c-v2.0.jar","Copy the connector file listed above to the P6BPMConnector/P6 folder you created. Determine the location of the BPM installation that you are using to integrate with P6. If you have multiple SOA Suite installations, ensure that you determine the location of the specific installation that you are integrating with P6.","Copy the following folders and their contents from your BPM installation to the P6BPMConnector/BPM folder you created.&nbsp;Their default locations are listed:","&lt;ORA_HOME&gt;\\soa\\soa\\modules\\oracle.bpm.client_11.1.1 ","&lt;ORA_HOME&gt;\\soa\\soa\\modules\\oracle.bpm.project_11.1.1 ","&lt;ORA_HOME&gt;\\soa\\soa\\modules\\oracle.bpm.runtime_11.1.1 ","Copy all the supporting jars from the BPM installation that you are using to integrate with P6 to the P6BPMConnector/BPM folder you created.&nbsp;Their default locations are listed:","&lt;Oracle_Home&gt;\\soa\\soa\\modules\\oracle.soa.fabric_11.x.x\\bpm-infra.jar","&lt;Oracle_Home&gt;\\soa\\soa\\modules\\oracle.soa.workflow_11.x.x\\bpm-services.jar","&lt;Oracle_Home&gt;\\soa\\soa\\modules\\oracle.soa.fabric_11.x.x\\fabric-runtime.jar","&lt;Oracle_Home&gt;\\oracle_common\\modules\\oracle.jmx_12.x.x\\jmxframework.jar","&lt;Oracle_Home&gt;\\oracle_common\\modules\\oracle.jmx_12.x.x\\jmxspi.jar","&lt;Oracle_Home&gt;\\soa\\bpm\\modules\\oracle.bpm.mgmt_11.x.x\\oracle.bpm.bpmn-em-tools.jar","&lt;Oracle_Home&gt;\\soa\\soa\\modules\\oracle.soa.mgmt_11.x.x\\soa-infra-mgmt.jar","&lt;Oracle_Home&gt;\\wlserver\\server\\lib\\wlclient.jar","&lt;Oracle_Home&gt;\\oracle_common\\modules\\oracle.xdk_12.x.x\\xml.jar","&lt;Oracle_Home&gt;\\oracle_common\\modules\\oracle.xdk_12.x.x\\xmlparserv2.jar","&lt;Oracle_Home&gt;\\soa\\soa\\modules\\oracle.soa.fabric_11.x.x\\tracking-api.jar","&lt;Oracle_Home&gt;\\soa\\soa\\modules\\oracle.rules_11.x.x\\rulesdk2.jar","Note","The jar files must be from the same BPM installation that will be integrated with P6.","Modifying the P6 Environment for BPM<br /> (Primavera P6 EPPM BPM Configuration Guide for On-Premises)","English\\Configuring\\p6_eppm_bpm_config\\89467.htm");
Page[247]=new Array("To connect P6 and BPM:","Open the Primavera P6 Administrator.","In the Configurations drop-down list, select your configuration.","In the sidebar selectDatabase/Instance[n]/BPM Settings.","In the Connector file location field, enter the full path (including the file name) where you copied the connector files.","For example:","c:/oracle/bpm&lt;release_level&gt;/eppmjars/prm-bpm-connector-12c-v1.0.jar or /home/oracle/bpm1213x/prm-bpm-connector-12c-v1.0.jar","In the BPM library path field, enter the path of the directory where you copied all the  jars.","Note If the above settings are incorrect or the BPM jar files are incomplete, you will be prompted with an error message when you try to configure the BPM. Verify that your settings and jar files are correct.","Right-click BPM Configuration, then select Configure to set options from the dialog box. If you receive an error message, check your values from the previous steps in this section. ","To configure P6 to use BPM, add the following settings:","Caution Do not put a forward slash / at the end of the URL. For example, it should read only http://&lt;host_name&gt;:&lt;port&gt;, and not http://&lt;host_name&gt;:&lt;port&gt;/.","In the bpm.user field, enter the BPM user with administrative access to BPM.","In the bpm.password field, enter the password for the user.","In the bpm.t3.url field, enter the T3 URL for your Oracle SOA configuration. For example: t3://&lt;host_name&gt;:&lt;port&gt;/soa-infra","In the bpm.security.realm field, enter the name of the security realm used by BPM.&nbsp;This is jazn.com by default.","In the bpm.soap.url field, enter the URL for the SOAP services. Usually this URL takes the form of http://&lt;host_name&gt;:&lt;port&gt;.","In the bpm.workspace.url field, enter an address in the form of http://&lt;host_name&gt;:&lt;port&gt; that indicates where the BPM Workspace application is hosted.","Note The host can be an IP address or a host name such as a machine name.","In the bpm.partition field, enter the name of the SOA partition containing the BPM composite applications you would like to use in P6.&nbsp;The default partition name is default.","Click OK and save changes. When the configuration is complete, you will see a BPM properties have been configured message. ","Restart the P6 application server.","Configuring P6 to Connect to Oracle BPM<br /> (Primavera P6 EPPM BPM Configuration Guide for On-Premises)","English\\Configuring\\p6_eppm_bpm_config\\89468.htm");
Page[248]=new Array("The sample workflow provided uses Username Token Authentication and does not implement the message protection options of Nonce, Creation Timestamp, or SSL encryption. For the sample workflow to work, you must set the following settings to false or P6 EPPM Web Services will reject the messages sent from BPM.","To verify you configured the sample workflow correctly set the following to false:","Open the Primavera P6 Administrator.","In the Configurations drop-down list, select your configuration.","In the sidebar select Web Services/Security/Authentication.","In the Mode field, select Username Token Profile.","Expand Web Services/Security/Authentication/Username Token Profile/Nonce and set Require Nonce to false.","Expand Web Services/Security/Authentication/Username Token Profile/Created and set Require Created to false.","Expand Web Services/Security/Message Protection:","Set Require Timestamp to false.","Set Require Digital Signatures for Incoming Messages to false.","Set Require Encryption for Incoming Messages to false.","Set Encrypt Response to false.","Verifying the Sample Workflow Configuration<br /> (Primavera P6 EPPM BPM Configuration Guide for On-Premises)","English\\Configuring\\p6_eppm_bpm_config\\88110.htm");
Page[249]=new Array("Follow the instructions in the following sections to create a cluster environment for BPM in WebLogic.","Creating a Cluster Environment for BPM in WebLogic<br /> (Primavera P6 EPPM BPM Configuration Guide for On-Premises)","English\\Configuring\\p6_eppm_bpm_config\\79521.htm");
Page[250]=new Array("Before you create a cluster:","Note See the Tested Configurations document for supported versions.","Install the Oracle MDS (Metadata Services) schema using the Repository Creation Unit (RCU) on a separate database instance.","Install Oracle ADF Runtime on the Middleware Home for all nodes where you configured P6 EPPM.","Create a cluster for BPM in WebLogic. Follow WebLogic's instructions to create a cluster. The following instructions will refer to the cluster as BPMCLUSTER_domain.","Prerequisites for Creating a Cluster for BPM in WebLogic<br /> (Primavera P6 EPPM BPM Configuration Guide for On-Premises)","English\\Configuring\\p6_eppm_bpm_config\\79522.htm");
Page[251]=new Array("To extend the WebLogic Domain:","Stop the P6 EPPM servers:","If you started the servers using Node Manager (for example, start_Primavera.bat), run stop_Primavera.bat to stop all running servers. ","If you started the servers using startWebLogic.cmd/startManagedWebLogic.cmd in Windows or startWebLogic.sh/startManagedWebLogic.sh in Unix, use the &quot;stop&quot; version for those files to stop the servers. ","Run the WebLogic Configuration Wizard.","In the Welcome&nbsp;window:","Select Extend an existing WebLogic domain.","Click Next. ","In the Select a WebLogic Domain Directory window:","Expand domains.","Select the BPM Cluster domain (for example, BPMCLUSTER_domain), which you must extend with policy manager.","Click Next.","In the Select Extension Source window:","Select Extend my domain automatically to support the following added products:.","Select Oracle WSM Policy Manager - 12.1.3.0 [oracle_common]. When you select this option, the wizard will automatically select Oracle JRF - 12.1.3.0 [oracle_common]. ","Click Next.","In the Configure JDBC Component Schema window:","Enter your MDS schema details. The MDS details are the DB configuration details where you installed the Oracle MDS schema.","Click Next. ","In the Test JDBC Component Schema window:","Select your schema.","Click Test Connections.","If the test is successful, click Next.","If the test fails, go back to the previous screen and ensure your credentials are correct.","In the Select Optional Configuration window:","Select Managed Servers, Clusters and Machines and Deployments and Services.","Click Next.","In the Configured Managed Servers window, do not make changes and click Next.","In the Configure Clusters window, do not make changes and click Next.","In the Assign Servers to Clusters window, do not make changes and click Next.","In the Configure Machines window, do not make changes and click Next. ","In the Assign Servers to Machines window, do not make changes and click Next.","In the Target Deployments to Clusters or Servers window: ","In the left pane, select Cluster. ","In the right pane under Applications, select wsm-pm. ","In the right pane under Library, select all options.","In the left pane, select another server.","In the right pane under Applications, select the application that corresponds to that server. For example, if you selected the P6 server, select P6 under Applications.","Clear all other options for that server.","Repeat these steps for each server.","In the left pane, select Cluster and select all the applications that belong in that cluster from the right pane. ","Click Next.","In the Target Services to Clusters or Servers window: ","In the left pane, select Cluster and select all options in the right pane.","In the left pane, select Cluster and clear all options in the right pane.","Click Next.","On the Configuration Summary screen:","Verify the configuration summary.","Click Extend.","When the extension is complete, click Done. ","Extending the WebLogic Domain to Create a New Cluster<br /> (Primavera P6 EPPM BPM Configuration Guide for On-Premises)","English\\Configuring\\p6_eppm_bpm_config\\79523.htm");
Page[252]=new Array("To finalize the extended schema for BPM:","Copy this extended domain to all node server machines that are part of the created cluster.","Set StartScriptEnabled to true:","Go to the Node Manager folder in the WebLogic home (for example, C:\\Oracle\\Middleware\\Oracle_Home\\user_projects\\&lt;P6 EPPM_Domain&gt;\\nodemanager)","Edit the nodemanager.properties file.\\","Set StartScriptEnabled = true.","Ensure that StartScriptName=startWebLogic.cmd or StartScriptName=startWebLogic.sh depending on your operating system.","Start the servers:","Run start_Primavera.bat/ start_Primavera.sh to start all the servers through node manager. ","To start the servers manually, run startWeblogic.cmd/startManagedWeblogic.cmd for Windows or startWeblogic.sh/startManagedWeblogic.sh for Unix. ","Finalizing the Extended Schema for BPM<br /> (Primavera P6 EPPM BPM Configuration Guide for On-Premises)","English\\Configuring\\p6_eppm_bpm_config\\79524.htm");
Page[253]=new Array("This section includes steps to to deploy and configure the P6ConfigValidator workflow, which you can use to test a web services call.","Testing the Connection for P6, BPM, and Web Services<br /> (Primavera P6 EPPM BPM Configuration Guide for On-Premises)","English\\Configuring\\p6_eppm_bpm_config\\78988.htm");
Page[254]=new Array("The configuration plan references the generic endpoint: p682ws:7011. The configuration plan also contains BPEL properties in the workflow to configure the target environment. In this workflow, these entries consist only of the P6 user name, password, and database instance to use when making the test Web Service call.","To prepare the configuration plan:","Unzip the files in the P6_&lt;release_level&gt;_Tools\\BPM Connector\\p6ConfigValidator 2.0 [12.1.3.0].zip folder from the Media Pack.","Edit the P6ConfigValidator_cfgplan.xml file.","Find the attribute &lt;replace /&gt; and change the following values:","Find &lt;property name=&quot;bpel.preference.p6userName&quot;&gt; and replace the P6 username value between the &quot;&lt;replace&gt; &lt;/replace&gt;&quot; elements with a P6 username from your environment. Oracle recommends using a user assigned to the Admin Superuser Global security profile.","Find &lt;property name=&quot;bpel.preference.p6password&quot;&gt; and replace the P6 password value between the &quot;&lt;replace&gt; &lt;/replace&gt;&quot; elements with the password of the user from above.","Find &lt;replace&gt;localhost:7011&lt;/replace&gt; and replace the value between the &quot;&lt;replace&gt; &lt;/replace&gt;&quot; elements with the hostname:port where you deployed P6 Web Services.","Save the changes made to the P6ConfigValidator_cfgplan.xml file and close the text editor.","Configuring WSDL Location and Service Endpoints<br /> (Primavera P6 EPPM BPM Configuration Guide for On-Premises)","English\\Configuring\\p6_eppm_bpm_config\\79087.htm");
Page[255]=new Array("To deploy the JAR for the SOA composite:","Login to Enterprise Manager on the WebLogic Server hosting SOA.","Expand SOA, soa-infra, server_name.","Right-click on the target soa-infra partition and select SOA Deployment, Deploy to This Partition....","Specify the location of the service archive file sca_P6ConfigValidator_rev1.0.jar and the edited configuration plan (P6ConfigValidator_cfgplan.xml) for this environment.","Click Next to confirm the remaining options for the target environment.","Deploy the JAR for the SOA composite.","Deploying the SOA Composite<br /> (Primavera P6 EPPM BPM Configuration Guide for On-Premises)","English\\Configuring\\p6_eppm_bpm_config\\79088.htm");
Page[256]=new Array("To deploy the P6ConfigUI.ear as a standard application deployment to the same server where the SOA is running:","Login to Enterprise Manager.","Expand WebLogic Domain, domain_name.","Right-click on the server name and select Application Deployment, Deploy.","Specify the location of P6ConfigUI.ear.","(optional) Specify the location of the deployment plan if needed.","Click Next to confirm the remaining options for the target environment.","Deploy P6ConfigUI.ear.","Deploy Client Application and Task UI Project<br /> (Primavera P6 EPPM BPM Configuration Guide for On-Premises)","English\\Configuring\\p6_eppm_bpm_config\\79091.htm");
Page[257]=new Array("To use this workflow, you need to assign a BPM role for the user to initiate the test and receive the confirmation the test was successful.","To assign the role:","Login to the BPM Workspace as a user with administrative rights.","Click Administration on the top right toolbar.","On the Organization Roles list, select P6ConfigValidator.TestConfig.","On the Details pane, make one or more BPM users or user groups a member of the TestConfig role. The BPM users or user groups assigned to the TestConfig role must match a P6 username for the workflow to be visible from P6.","Click Apply to save these changes.","Assigning the TestConfig Role to Users<br /> (Primavera P6 EPPM BPM Configuration Guide for On-Premises)","English\\Configuring\\p6_eppm_bpm_config\\79092.htm");
Page[258]=new Array("Use the BPM and P6 EPPM Web Services log viewers to troubleshoot problems if they arise and check for known issues with BPM.","Note As a general rule when troubleshooting workflow failures, first check the BPM diagnostics to determine at what point in the process the workflow failed. If the failure is related to retrieving data from P6, then you should check the P6 EPPM Web Services logs. Also be sure to check the P6 Help and other documentation for both P6 and BPM.","Troubleshooting and Known Issues for BPM<br /> (Primavera P6 EPPM BPM Configuration Guide for On-Premises)","English\\Configuring\\p6_eppm_bpm_config\\89502.htm");
Page[259]=new Array("When integrating P6 and BPM, you can use only English as the language. While both P6 and BPM both support localization, the API for integrating these two applications supports only English.","Known Issues<br /> (Primavera P6 EPPM BPM Configuration Guide for On-Premises)","English\\Configuring\\p6_eppm_bpm_config\\78589.htm");
Page[260]=new Array("The P6 EPPM Web Services uses different settings for logging errors and warnings than for logging SOAP requests and responses.","Checking the P6 EPPM Web Services Logs<br /> (Primavera P6 EPPM BPM Configuration Guide for On-Premises)","English\\Configuring\\p6_eppm_bpm_config\\54186.htm");
Page[261]=new Array("If logging is enabled and configured in Primavera P6 Administrator, P6 EPPM Web Services can output to the P6 log file.","Log settings in Primavera P6 Administrator can be set at one of four levels, each of which also incorporates all the messages logged by the previous logging level. The levels are, error, warn, info, and debug.","The output is recorded to a log file called P6WebAccess.html. The location of the log file is specified in BREBootStrap.xml located in your P6 EPPM home folder.","For more information, see the P6 EPPM System Administration Guide.","Logging Errors and Warnings<br /> (Primavera P6 EPPM BPM Configuration Guide for On-Premises)","English\\Configuring\\p6_eppm_bpm_config\\54189.htm");
Page[262]=new Array("If you want to log incoming SOAP requests and the corresponding outgoing responses, you must configure JVM startup parameters on your WebLogic server.","The SOAP requests and responses are logged to the console output and captured in the following file:","&lt;WLServerDomainFolder&gt;/servers/P6WebServices/logs/P6WebServices.out.","To configure logging of SOAP requests and responses, add the following JVM properties to your startup parameters in the Arguments section of the Server Start tab of the managed P6 EPPM Web Services server:","-Dcom.sun.xml.ws.transport.http.client.HttpTransportPipe.dump=true","-Dcom.sun.xml.internal.ws.transport.http.client.HttpTransportPipe.dump=true","-Dcom.sun.xml.ws.transport.http.HttpAdapter.dump=true","-Dcom.sun.xml.internal.ws.transport.http.HttpAdapter.dump=true","-Dcom.sun.xml.internal.ws.transport.http.HttpAdapter.dumpTreshold=999999","Note You must restart your P6 EPPM Web Services server for these settings to take effect.","Logging SOAP Requests and Responses<br /> (Primavera P6 EPPM BPM Configuration Guide for On-Premises)","English\\Configuring\\p6_eppm_bpm_config\\54191.htm");
Page[263]=new Array("Refer to the following file to access BPM messages:","&lt;weblogic_domain&gt;/servers/AdminServer/logs/AdminServer.log","In a typical BPM installation on Linux, the WebLogic domain for Fusion Middleware is:","&lt;WebLogic_domain&gt;/user_projects/domains/domain1","Oracle BPM Logging<br /> (Primavera P6 EPPM BPM Configuration Guide for On-Premises)","English\\Configuring\\p6_eppm_bpm_config\\89503.htm");
Page[264]=new Array("Outside of the scope of general issues with BPM or P6 EPPM, the P6 BPM Integration can potentially yield two types of issues:","connector configuration issues","data implementation issues rooted in either P6 or the BPM server","Troubleshooting Scenarios<br /> (Primavera P6 EPPM BPM Configuration Guide for On-Premises)","English\\Configuring\\p6_eppm_bpm_config\\54201.htm");
Page[265]=new Array("In the Primavera P6 Administrator, set the Log/Console Logger/Severity Level to debug or info. ","Check the P6 log for BPM related messages. The log file is P6WebAccess.html and its location is specified in BREBootStrap.xml located in your P6 EPPM home folder. These messages should indicate the cause of the connector failing to load.","Troubleshooting Connector Failures to Load Due to Configuration Issues<br /> (Primavera P6 EPPM BPM Configuration Guide for On-Premises)","English\\Configuring\\p6_eppm_bpm_config\\54202.htm");
Page[266]=new Array("These type of errors could have their root cause in either the P6 application or the BPM server.","In Primavera P6 Administrator, set the Log/Console Logger/Severity Level to debug or info.","Check the P6 log for BPM related messages. The log file is P6WebAccess.html and its location is specified in BREBootStrap.xml located in your P6 EPPM home folder. These messages should indicate why the BPM code failed to process normally.","Check the BPM logs in these cases to make sure that the cause of the failure is not due to the BPM server.","Troubleshooting P6 Workflows Portlet Failures To Load Data, Show Forms, Status Images, or Initiate a Process<br /> (Primavera P6 EPPM BPM Configuration Guide for On-Premises)","English\\Configuring\\p6_eppm_bpm_config\\54203.htm");

Page[267]=new Array("The following sections detail information about workflows and how to work with them.","BPM Workflows in P6<br /> (Primavera P6 EPPM BPM Configuration Guide for On-Premises)","English\\Configuring\\p6_eppm_bpm_config\\47842.htm");
Page[268]=new Array("A workflow is an automated business process that routes information and tasks between participants according to a defined set of procedures or rules designed to coordinate a specific business goal. Workflows are primarily characterized by their level of procedural automation involving one or more dynamic related series of processes, and their combination of human and machine-based tasks involving interaction with software and systems.","The following industry segments, marked by relatively high office labor costs and transaction volume, have demonstrated successful workflow implementations:","Insurance","Banking","Legal","General &amp; Administrative","Design","Engineering","Manufacturing","Business process modeling and workflow automation allow transactions to be conducted electronically without the need for manual intervention such as conducting certain validations or re-keying data. When workflow IT systems are processing repetitive, mundane, and often error-prone work, talented staff resources become available to handle activities that add real value to the enterprise. ","About Workflows<br /> (Primavera P6 EPPM BPM Configuration Guide for On-Premises)","English\\Configuring\\p6_eppm_bpm_config\\36631.htm");
Page[269]=new Array("You can use workflows to route business processes such as project initiation requests through your organization to gather information and visibility before a go/no go decision is made. Template data, routing designators, and approval rules can be set for each stage of a workflow. To illustrate these options, suppose we have a workflow involving five key approval managers. You can define the workflow such that all five must approve and even specify a particular sequence, if any. A much more relaxed approval rule would require only one out of the five to approve. The following are just some example of how you can use workflows.","Workflows are defined, deployed, and configured in BPM where your workflow designer defines the workflow tasks involved and assigns them to specific users, roles, or groups. Then, in P6, a business need kicks off an instance of the workflow and its required tasks are automatically routed to their users, roles, or groups.","When a specific user or any user assigned to a role or group logs into P6, the Workflows portlet on their dashboard will display their relevant tasks at this stage of the workflow, as authenticated by BPM. As a workflow participant, you can select a task in the workflow instance and claim ownership for it. This means you will be responsible for performing the task. The application refreshes itself to show only the actions permitted for this stage of the workflow for you (the currently logged in user). ","After your administrator sets up BPM for P6, they can configure a dashboard to display the Workflows portlet. The following list represents a list of the key Workflow elements that you can observe in the portlet depending on your configuration.","Action Required Tab: This tab shows the tasks that are important to you (the currently logged in user).","My Workflows Tab: This tab enables you to view all workflows according to role and status filters you can set.","Initiate a Workflow: Click Initiate a Workflow to start a new instance of a workflow based on a predesigned template.","BPM Workspace: Use the BPM Workspace to update the progress of tasks, initiate a change, request a project, and retrieve project information. You are also able to apply a bulk action to multiple work items.","Note If SSO authentication is not configured with BPM, you must log into BPM in the resulting window, close that window, and then return to P6 and click _ View Form again. This procedure is required whenever your BPM session expires.","Sample Workflow: A basic workflow image with tasks for a business user, two project offices, and a project manager.","Workflow History: View a chronological sequence of all the previous actions, users, and stages in the current workflow. ","Working with Workflows in P6 (On Premises only)<br /> (Primavera P6 EPPM BPM Configuration Guide for On-Premises)","English\\Configuring\\p6_eppm_bpm_config\\45215.htm");
Page[270]=new Array("Oracle Web Services Manager (WSM) includes wss11_saml_token_identity_switch_with_message_protection_client_policy, which enables identity switching. Identity switching means that the policy propagates a different identity than the one based on the authenticated Subject.","The Service-Oriented Architecture (SOA) application requires you to specify which user identity to use in client-side Web service policies, and then dynamically switches the user associated with the SAML token in the outbound Web service request. Instead of using the user name from the Subject, this policy allows you to set a new user name when sending the SAML Web service request.","The wss11_saml_token_identity_switch_with_message_protection_client_policy creates the SAML token based on the user ID set via the property javax.xml.ws.security.auth.username.","The initial identity switching policy requires message encryption, which requires the server-side policy to be the same. You will not want this policy when working in P6. To change the policy, you need to create a new client-side policy based on the existing identity switching policy (this is done through Enterprise Manager (EM), using the &quot;create like&quot; option). Within the new policy definition, you can remove the existing assertion (SAML 1.1 SAML with Certificates) and replace it with a new assertion based on an appropriate template, which in this case is WS-Security SAML Token Client.","Configuring SAML Web Service Clients for Identity Switching without Message Protection<br /> (Primavera P6 EPPM BPM Configuration Guide for On-Premises)","English\\Configuring\\p6_eppm_bpm_config\\62845.htm");
Page[271]=new Array("You can configure policies in the Web Services Policies, Edit Policy section of EM. You can also copy the custom SAML Identity Policy. To do this, copy the oracle_wss11_saml_token_identity_switch_with_message_protection_client_policy.txt file located here: http://download.oracle.com/docs/cd/E20686_01/English/Technical_Documentation/Oracle_BPM/oracle_wss11_saml_token_identity_switch_with_message_protection_client_policy.txt.","Message Protection Policy<br /> (Primavera P6 EPPM BPM Configuration Guide for On-Premises)","English\\Configuring\\p6_eppm_bpm_config\\62846.htm");
Page[272]=new Array("The Web service client (for example, the SOA reference binding component) where you attached the wss11_saml_token_identity_switch_with_message_protection_client_policy must have the oracle.wsm.security.WSIdentityPermission.","To use Fusion Middleware Control and add the oracle.wsm.security.WSIdentityPermission to the SOA reference binding component as a System Grant, perform the following steps:","In the Navigator pane, expand WebLogic Domain to show the domain where you need to configure the application. Select the domain.","Using Fusion Middleware Control, click WebLogic Domain, Security, System Policies. System policies are the system-wide policies applied to all applications deployed to the current WebLogic Domain.","From the System Policies page, select the arrow icon in the Permission field to search the system security grants.","Select one of the codebase permissions to use as a starting point and click Create Like.","In the Grant Details section of the page, enter file:${common.components.home}/modules/oracle.wsm.agent.common_11.1.1/wsm-agent-core.jar in the Codebase field.","In the Permissions section of the page, select the starting point permission class and click Edit.","In the Permission Class field, enter oracle.wsm.security.WSIdentityPermission. The resource name is the composite name for SOA and the application name for a J2EE client. The action is always assert.","Setting the WSIdentityPermission<br /> (Primavera P6 EPPM BPM Configuration Guide for On-Premises)","English\\Configuring\\p6_eppm_bpm_config\\62848.htm");
Page[273]=new Array("You also need to add the basic.credentials key to the csf store via EM. You might need to create a default keystore if you have not done that already.","Right-click Domain then select Security, Credentials.","Create a basic.credentials key.","Creating the basic.credentials Key<br /> (Primavera P6 EPPM BPM Configuration Guide for On-Premises)","English\\Configuring\\p6_eppm_bpm_config\\62849.htm");
Page[274]=new Array("Before applying the new policy, you need to import into JDeveloper. Copy the new custom policy to your JDev store directory (either use the attached policy from this document or export your custom policy from EM). The location of the store could appear as follows:","USER_HOME\\AppData\\Roaming\\JDeveloper\\system11.1.1.4.37.59.23\\DefaultDomain\\oracle\\store\\gmds\\owsm\\policies"," Apply this new client policy to your service reference in your composite app via EM.","With this policy in place you can leverage the javax.xml.ws.security.auth.username inbound service property. If you are hardcoding, set the value without quotes. The value is set to jcooper; however, you can also extract the username from the payload of execData variable.","You do not have to import the policy to JDev, you can deploy the composite without a client-side policy, and then set the client policy through EM.","EM has a feature for setting the client-side policies that shows you compatible client-side policies based on the service you are calling.","References","http://download.oracle.com/docs/cd/E17904_01/web.1111/b32511/setup_config.htm#WSSEC3585","Applying the New Policy<br /> (Primavera P6 EPPM BPM Configuration Guide for On-Premises)","English\\Configuring\\p6_eppm_bpm_config\\62850.htm");
Page[275]=new Array("Right-click your WebLogic domain and select Security Provider Configuration.","In the Keystore Section, select Configure.","Provide credentials.","Configuring a Keystore if One Is Not Configured<br /> (Primavera P6 EPPM BPM Configuration Guide for On-Premises)","English\\Configuring\\p6_eppm_bpm_config\\62851.htm");
var PageCount=36;


/*
Date: 12/3/2025 5:52 PM
Source: EPPM_25_dev
BookID: 89464
PubProduct: PRIMAVERA_EPPM
BookTitle: BPM Configuration Guide for On-Premises
Version: Version 25
Lang:	en
*/
/* relative_path_for_link: English\Configuring\p6_eppm_oim_config*** */
/* BookTitleTop: Primavera P6 EPPM Oracle Identity Manager Configuration Guide for On-Premises*** */
/* Generated with Author-it 23.4.1.30004  12/3/2025 5:49:50 PM */
Page[276]=new Array("Title and Copyright Information","Copyright  1999, 2025, Oracle and/or its affiliates.","Primary Author: Oracle Corporation","Title and Copyright Information<br /> (Primavera P6 EPPM Oracle Identity Manager Configuration Guide for On-Premises)","English\\Configuring\\p6_eppm_oim_config\\46576.htm");
Page[277]=new Array("This guide describes how to configure Oracle Identity Manager (OIM) for use with P6 EPPM. OIM is an enterprise identity management system that manages the entire user identity lifecycle to help your organization meet changing business and regulatory requirements, and provides essential auditing, reporting, and compliance functionality.","Audience","System Administrators should use this guide.","Using this Guide","This guide assumes you have already installed P6. For more information, see the P6 EPPM Installation and Configuration Guide.","About This Guide<br /> (Primavera P6 EPPM Oracle Identity Manager Configuration Guide for On-Premises)","English\\Configuring\\p6_eppm_oim_config\\52057.htm");
Page[278]=new Array("The OIM connector includes a resource directory with all user attributes and two files&#8212;a JAR file to communicate with P6 EPPM and a dynamically generated XML file representing P6 users and their properties.","As an administrator, you can take advantage of the OIM connector to provision P6 EPPM users. With the help of P6 EPPM Web Services, the OIM connector helps you administer the complete user identity life cycles of P6 users. As a primary example, when you create a new user in OIM, it will also create a new user with the same user login name, password, email address, and personal name in the P6 EPPM database.","The core attributes and operations supported by the connector are listed below.","Attributes","The following user attributes are managed:","Login Name","Password","email Address","Personal Name","Operations","The following operations are supported:","Create User: Add a new user in P6 via OIM.","Modify User: Modify an attribute, such as an email address or personal name, in P6 via OIM.","Delete User: Remove a user in P6 via OIM.","About Connecting Oracle Identity Manager to P6<br /> (Primavera P6 EPPM Oracle Identity Manager Configuration Guide for On-Premises)","English\\Configuring\\p6_eppm_oim_config\\52082.htm");
Page[279]=new Array("Follow the steps below to install OIM and the other applications needed to use OIM:","Install Oracle Identity Manager (OIM). Refer to the following URL for documentation specific to this release: http://download.oracle.com/docs/cd/E14571_01/install.1111/e12002/install001.htm#CIHEJIIG","After installing and configuring the Oracle Identity Manager Server for the first time, you must start the Oracle Identity Manager Managed Server. For information about starting the server, see &quot;Starting the Stack&quot; (http://download.oracle.com/docs/cd/E14571_01/install.1111/e12002/start_stop001.htm#CHDDIFCD) in the Oracle Identity Manager documentation (http://download.oracle.com/docs/cd/E14571_01/install.1111/e12002/oidonly009.htm).","Install P6 and P6 EPPM Web Services. Check that you have OIM, P6, and P6 EPPM Web Services up and running before moving on to the next step. P6 EPPM Web Services must be configured to run in cookie-based authentication mode.","Log in to Primavera P6 Administrator and complete the following:","Expand Primavera P6 Confguration, Web Services, Security, and Message Protection and then set the following settings as false:","Require Digital Signatures for Incoming Messages","Require Encryption for Incoming Messages","Encrypt Response","Download the Oracle Identity Manager Connector for Primavera P6. ","Extract the ZIP archive.","Copy the following Primavera-P6-EPPM.properties files to the &lt;IDM_Home&gt;\\server\\connectorResources directory:","Primavera-P6-EPPM.properties ","Primavera-P6-EPPM_de.properties ","Primavera-P6-EPPM_en.properties ","Primavera-P6-EPPM_en_US.properties ","Primavera-P6-EPPM_es_MX.properties ","Primavera-P6-EPPM_fr.properties ","Primavera-P6-EPPM_ja.properties","Primavera-P6-EPPM_pt_BR.properties","Primavera-P6-EPPM_ru.properties ","Primavera-P6-EPPM_zh_CN.properties ","Primavera-P6-EPPM_zh_TW.properties","Copy primavera-p6eppm-prov.jar to the &lt;IDM_Home&gt;\\server\\JavaTasks directory.","Copy p6ws-jaxws-client.jar to the &lt;IDM_Home&gt;\\server\\ThirdParty directory.","Note The p6ws-jaxws-client.jar is not included in the OIM Connector ZIP archive; it is in the P6 EPPM Web Services client folder (for example, &lt;EPPM_HOME&gt;\\ws\\client\\Java\\JAX-WS\\stubs).","Save PrimaveraP6EPPMProvOIM11gR2.xml to a local drive.","(Only if applicable; otherwise, skip this step.) If you are using a WebLogic application server and the default settings are unsuccessful after first skipping this step:","In Windows:","Edit the StartWebLogic.cmd file located in weblogic_home\\user_projects\\domains\\your_domain\\bin\\ directory.","Add &lt;IDM_HOME&gt;\\server\\ThirdParty\\p6ws-jaxws-client.jar as part of the CLASSPATH.","For example:","set CLASSPATH=&lt;IDM_HOME&gt;/server/ThirdParty/p6ws-jaxws-client.jar;%SAVE_CLASSPATH%","where &lt;IDM_HOME&gt; is your IDM home directory (for example, C:\\oracle\\Middleware\\Oracle_IDM1)","Copy the p6ws-jaxws-client.jar to the weblogic_home\\user_projects\\OIM_domain\\lib directory.","In Unix:","Edit the StartWebLogic.sh file located in weblogic_home/user_projects/domains/your_domain/bin/ directory.","Add &lt;IDM_HOME&gt;/server/ThirdParty/p6ws-jaxws-client.jar as part of the CLASSPATH.","For example:","SAVE_CLASSPATH=&quot;&lt;IDM_HOME&gt;/server/ThirdParty/p6ws-jaxws-client.jar:${CLASSPATH}&quot;","where &lt;IDM_HOME&gt; is your IDM home directory (for example, test/Middleware/Oracle_IDM1)","Copy the p6ws-jaxws-client.jar to the weblogic_home/user_projects/OIM_domain/lib directory.","Set the XEL_HOME variable in the setenv file:","In Windows:","Edit the setenv.bat file located in &lt;IDM_HOME&gt;\\server\\bin\\.","Set the path of the XEL_HOME variable to the absolute path of &lt;IDM_Home&gt;\\server. ","For example, if your IDM_Home is the C:\\oracle\\Middleware\\Oracle_IDM1, then your path will look as follows:","set XEL_HOME=C:\\oracle\\Middleware\\Oracle_IDM1\\server","In Unix:	","Edit the setenv.sh file located in &lt;IDM_HOME&gt;/server/bin/.","Set the path of the XEL_HOME variable to the absolute path of &lt;IDM_Home&gt;/server. ","For example, if your IDM_Home is the test/Middleware/Oracle_IDM1, then your path will look as follows:","XEL_HOME=&quot;test/Middleware/Oracle_IDM1/server&quot;","Restart the OIM WebLogic Server.","Installing the OIM Applications<br /> (Primavera P6 EPPM Oracle Identity Manager Configuration Guide for On-Premises)","English\\Configuring\\p6_eppm_oim_config\\52083.htm");
Page[280]=new Array("Complete these steps before you begin connecting OIM and P6.","Login to the OIM sysadmin console as an administrative user. ","For example:","http://OIM_Host:14000/sysadmin","In the System Configuration section, click Lookup.","Click Search and scroll to find Lookup.USR_PROCESS_TRIGGERS.","Select Lookup.USR_PROCESS_TRIGGERS.","Change the Meaning for two codes:","Click the Edit button.","Locate USR_FIRST_NAME.","In the Meaning column, enter Change Personal Name.","Locate USR_LAST_NAME.","In the Meaning column, enter Change Personal Name.","Create a new code and meaning:","Click the Create button.","In the Meaning column, enter Change Email.","In the Code column, enter USR_EMAIL.","Click Save and click OK to close the dialog box.","Configuring OIM<br /> (Primavera P6 EPPM Oracle Identity Manager Configuration Guide for On-Premises)","English\\Configuring\\p6_eppm_oim_config\\79153.htm");
Page[281]=new Array("Follow the steps below to configure OIM and the other applications needed to use OIM. After completing these steps, you can provision users through Application Instances:","Login to the OIM sysadmin console as an administrative user. ","For example:","http://OIM_Host:14000/sysadmin","In the Oracle Identity System Administration Screen, under System Management, select Import.","In the Deployment Manager - Import window, click Add File.","In the Select a file for import dialog box, browse to the location of the PrimaveraP6EPPMProv.xml file and click Open.","In the Deployment Manager wizard:","On the Substitutions screen, accept the default options and click Next.","On the Confirmation screen, select Next.","On the Provide IT Resource Instance Data screen, select Primavera P6 EPPM IT Resource:","In the Host Name field, enter the host name of the managed server hosting the P6 Web Services application.","In the Protocol field, enter the protocol used to connect to the P6 Web Services.","In the Admin User Name and Admin User Password fields, enter the user name and password of a P6 EPPM user assigned Web Services module access and either the &lt;Admin Superuser&gt; global security profile or a global security profile with the Add/Edit/Delete Users privilege assigned.","In the Port field, enter the port number of the managed server hosting the P6 Web Services application.","Click Next, then click Skip.","On the Confirmation screen, verify the details are correct, then click View Selections.","In the Deployment Manager - Import window, click Import.","In the Confirmation dialog box, click Import.","Note At step 5 in the process above, if a red X or yellow warning message displays next to the UD_PM_USER parameter, a user already attempted to import or export that UD_PM_USR version. If you receive this error:","Close the import and restart the process.","On the Substitutions screen of the wizard, note the number in the Current Name column for the PrimaveraP6EPPMProv.xml row. The default is 5. In the New Name column on the same row, type 6 (or one number higher than the Current Name)","Then continue with the remaining screens of the wizard.","To verify the creation of the resource, imported from the XML file:","In the Oracle Identity System Administration Screen, under Configuration Grouping, select IT Resource.","In the IT Resource Type list, select Primavera P6 EPPM Server.","Click Search.","Click the P6 EPPM IT Resource link.","In the View IT Resource Details and Parameters screen, verify the details are correct.","If any of the details is incorrect click Edit then modify the details.","Configuring the OIM Application to Work with P6<br /> (Primavera P6 EPPM Oracle Identity Manager Configuration Guide for On-Premises)","English\\Configuring\\p6_eppm_oim_config\\52076.htm");
Page[282]=new Array("Once you have configured OIM and P6, you will need to provision users in OIM. Provisioning users will ensure you can manage (create, delete, modify) user's profiles through both OIM and P6. For more information on provisioning, see the documentation included with OIM.","Provisioning Users for OIM<br /> (Primavera P6 EPPM Oracle Identity Manager Configuration Guide for On-Premises)","English\\Configuring\\p6_eppm_oim_config\\78590.htm");
Page[283]=new Array("To provision users from OIM for P6:","Launch OIM Identity Self Service Console.","For example:","http://OIM_Host:14000/oim","In the Manage section, click Users.","Create a new user.","In the Accounts tab, click Request Accounts.","In the Catalog, select the Application Instance and click Add to Cart.","Click Checkout.","Click Submit.","Provisioning Users for P6<br /> (Primavera P6 EPPM Oracle Identity Manager Configuration Guide for On-Premises)","English\\Configuring\\p6_eppm_oim_config\\79154.htm");
Page[284]=new Array("To modify or delete an OIM user's access to P6, follow the steps below.","To modify an account:","In User Details page:","Click Modify User.","Update the first name, last name, and email address.","Click Submit.","To delete an account:","In User Details page:","Go to the Accounts tab.","Click Modify Accounts."," Click Submit.","Click Remove Accounts.","Click Submit to revoke the user from P6.","Refer OIM documentation for more information on creating, modifying, and removing users.","Modifying or Deleting OIM Users P6 Privileges<br /> (Primavera P6 EPPM Oracle Identity Manager Configuration Guide for On-Premises)","English\\Configuring\\p6_eppm_oim_config\\79155.htm");
var PageCount=9;


/*
Date: 12/3/2025 5:49 PM
Source: EPPM_25_dev
BookID: 52079
PubProduct: PRIMAVERA_EPPM
BookTitle: Oracle Identity Manager Configuration Guide for On-Premises
Version: Version 25
Lang:	en
*/
/* relative_path_for_link: English\Configuring\p6_eppm_weblogic_config*** */
/* BookTitleTop: Primavera P6 EPPM WebLogic Configuration Guide for On-Premises*** */
/* Generated with Author-it 23.4.1.30004  12/3/2025 5:47:53 PM */
Page[285]=new Array("Title and Copyright Information","Copyright   2025, Oracle and/or its affiliates.","Primary Author: Oracle Corporation","Title and Copyright Information<br /> (Primavera P6 EPPM WebLogic Configuration Guide for On-Premises)","English\\Configuring\\p6_eppm_weblogic_config\\46576.htm");
Page[286]=new Array("Scope","Oracle WebLogic server is an application server you can use to deploy your P6 EPPM applications. This guide describes how to manage and configure WebLogic settings to optimize the performance of your P6 EPPM applications:","P6","P6 Team Member","P6 Professional Cloud Connect","P6 EPPM Web Services, and P6 Integration API)","It also describes how to configure eventing for P6.","Audience","System and network administrators should use this guide.","Using This Guide","This guide assumes that you have already installed a supported version of WebLogic and a JDK. For more information, see the Tested Configurations document.","About This Guide<br /> (Primavera P6 EPPM WebLogic Configuration Guide for On-Premises)","English\\Configuring\\p6_eppm_weblogic_config\\93096.htm");
Page[287]=new Array("To delete your P6 EPPM and help from WebLogic:","Launch the WebLogic Administration Console using the following URL:","http://serverIP:listenport/console","In the Domain Structure&nbsp;pane, click Deployments.","In the Control tab, in the Summary of Deployments&nbsp;pane, complete the following:","Select the following applications:","p6","p6procloudconnect","p6tm","p6ws","pr","PrimaveraAPI","p6help.war","p6tmhelp.war","prhelp.war","Click Stop and then click Force Stop Now.","In the Force Stop Application Assistant pane, click Yes.","For each application and help, ensure that the State column shows Prepared.","Select the applications and help that you stopped.","Click Delete.","In the Delete Application Assistant pane, click Yes.","Tip If you plan to use the same home directory for the new help or tutorial deployments, delete the existing WAR or EAR&nbsp;file from that directory to avoid conflict with the new files.","Deleting Applications and Help from WebLogic<br /> (Primavera P6 EPPM WebLogic Configuration Guide for On-Premises)","English\\Configuring\\p6_eppm_weblogic_config\\93098.htm");
Page[288]=new Array("If you are upgrading your P6 EPPM applications to the latest version, you must uninstall all earlier versions of your P6 EPPM applications. You can uninstall your P6 EPPM applications using Oracle Universal Installer.","To uninstall your P6 EPPM applications:","Delete your Applications from WebLogic. For more information, see Deleting Applications and Help from WebLogic.","From the P6 EPPM installation folder, do one of the following:","With Windows, navigate to the win\\Disk1\\install folder, and double-click setup.exe.","With UNIX or Linux, enter the following commands:","cd &lt;Operating System&gt;/Disk1/install<br />chmod 755 runInstaller<br />chmod 755 unzip<br />./runInstaller","where &lt;Operating System&gt; is linux, or solaris_64.","On the Welcome screen, click Deinstall Products.","In the Inventory dialog box, select the following:","P6 &lt;Release_Level&gt;","P6 Professional Cloud Connect &lt;Release_Level&gt;","P6 Integration API &lt;Release_Level&gt;","P6 Web Services &lt;Release_Level&gt;","P6 Team Member &lt;Release_Level&gt;","P6 Progress Reporter &lt;Release_Level&gt;","Click Remove.","On the Confirmation dialog box, click Yes.","Click Close then Cancel to exit the dialog box and Oracle Universal Installer.","Uninstalling P6 EPPM Applications<br /> (Primavera P6 EPPM WebLogic Configuration Guide for On-Premises)","English\\Configuring\\p6_eppm_weblogic_config\\93091.htm");
Page[289]=new Array("You must uninstall any previous versions of P6 before upgrading to the latest version of P6.","Cautions","Before upgrading P6, you should upgrade the P6 EPPM database to the current version. See P6 EPPM Upgrade and Configuration Guide or P6 EPPM Manual Upgrade Guide for your database for details on how to upgrade your database and for information on potential impact areas to your environment. For the full list of tested configurations for P6, go to the \\Documentation\\&lt;language&gt;\\Tested_Configurations folder of the P6 EPPM physical media or download.","If you are a current Apache JackRabbit user and want to upgrade to the latest version of P6 EPPM, JackRabbit documents data will not migrate automatically. Refer to My Oracle Support's Knowledge Articles for information on manually migrating JackRabbit documents to Oracle Universal Content Management. Oracle recommends that you migrate the data before upgrading.","If you are a current jBPM user and want to upgrade P6 EPPM, workflows and reviews data will not be available. You should close all workflows and reviews that are in progress before upgrading. You cannot migrate any of this data to the latest version of P6 EPPM.","Starting with P6 EPPM R8, all recurring job service functions are hosted by P6. Due to this change, after upgrading to P6 EPPM R8 or later, you must configure Scheduled Services settings in the Primavera P6 Administrator to use this functionality. Also, if you're upgrading from version 7.0 or earlier, you must RESUMMARIZE ALL PROJECTS to accurately reflect your summary data. See the P6 EPPM System Administration Guide for information on Scheduled Services and configuring separate servers for job services.","Tip","For security reasons, Oracle strongly recommends that on-premises users replace the default Admin Superuser (admin) immediately after a manual database installation or an upgrade from P6 version 7.0 and earlier. See information on the default Admin Superuser in the P6 EPPM Application Administration Guide for guidelines on this process. See information about the Admin Superuser in the P6 EPPM Application Administration Guide.","P6 EPPM does not support Summary-Only projects. During the P6 EPPM database upgrade, existing Summary-Only projects convert to standard projects, but lose all summary data. You can import the summary project from Microsoft Project into the converted blank project, then summarize the data. See the P6 Professional Help or the P6 Help.","During the upgrade to the latest version of P6 EPPM, some P6 Activity Views settings will reset. After the upgrade, use the Customize Detail Windows feature to modify the settings that should appear for each view. See the P6 Help for information on how to edit Activity Views.","Starting with P6 EPPM R8, P6 saves filter definitions globally. Filters still work for Activity Views, but all standard filter assignments reset during the upgrade. Due to this change, views that had Standard Filters applied will show all activities after the upgrade. Reapply filters after the upgrade finishes. See the P6 Help for information on how to edit Activity Views.","Uninstalling Previous Versions of P6<br /> (Primavera P6 EPPM WebLogic Configuration Guide for On-Premises)","English\\Configuring\\p6_eppm_weblogic_config\\7165.htm");
Page[290]=new Array("For information about how to install the P6 EPPM applications, see the P6 EPPM Installation and Configuration Guide.","Installing P6 EPPM Applications<br /> (Primavera P6 EPPM WebLogic Configuration Guide for On-Premises)","English\\Configuring\\p6_eppm_weblogic_config\\98204.htm");
Page[291]=new Array("You have two options for accessing Help:","Use the Default P6 Help URL (Recommended)","The default URL will take you to the version hosted by Oracle, and is the most up-to-date documentation. ","The default help URLs are in the Primavera P6 Administrator.","Note You can choose not to use the default help URL, but you will have to ensure you deploy it in your application server and enter the server URL into the Primavera P6 Administrator. If any updates are made to the help, these will not be visible if you are using the p6help.war file. ","Use the P6 Help WAR File","You can download the online help WAR files from the following URLs:","P6 Help: https://docs.oracle.com/cd/G18294_01/p6help/war/P6_Help.zip","P6 Team Member Help: https://docs.oracle.com/cd/G18294_01/team_member/web/help/war/TM_Help.zip","Note For the Helps to launch, you must enter the server URLs in the Primavera P6 Administrator. See the P6 EPPM System Administration Guide for more information.","Tip","If you receive a &quot;server not found&quot; or a similar error when accessing the help in the application, it means one of the following:","The application server cannot access the Internet.","The help site is not available.","If the application server cannot access the Internet, check your Primavera P6 Administrator settings and ensure they are configured to the correct URL.","If the URL is configured correctly, but you still cannot access the application help, you will need to deploy the help using the WAR file.","Help Directory Installation<br /> (Primavera P6 EPPM WebLogic Configuration Guide for On-Premises)","English\\Configuring\\p6_eppm_weblogic_config\\32720.htm");
Page[292]=new Array("This section details the basic configuration steps for P6 EPPM applications in a WebLogic environment when opting for an Admin Server and Managed Server deployment. ","Oracle recommends you create a Managed Server deployment. Each managed server requires exclusive access to its own rotating logfiles. If your managed and clustered servers are on the same machine, you must create a different P6 home folder for each managed server and then copy the BREBootstrap file into each folder. You must edit the BREBootstrap file to ensure the logDir setting is set to the folder unique to each managed server. If your Admin, Managed, and clustered servers are all on the same machine, you do not need to copy the BREBootstrap file. This section assumes that you set up separate domains for your applications; however, you can create one domain and configure all P6 EPPM applications to run in this domain.","Although not required for the P6 EPPM server setup, WebLogic has additional settings that can be used to enhance your environment. For example, when using clustering, enabling the session replication setting will seamlessly transfer users to another server if a server shuts down unexpectedly.","See the official WebLogic documentation for more information on setting up WebLogic Windows Services and all available WebLogic configuration and deployment options. ","Configuring WebLogic for P6 EPPM<br /> (Primavera P6 EPPM WebLogic Configuration Guide for On-Premises)","English\\Configuring\\p6_eppm_weblogic_config\\12890.htm");
Page[293]=new Array("A domain can include multiple WebLogic Server clusters and non-clustered WebLogic Server instances. A minimal domain can contain only one WebLogic Server instance, which functions as both an Administration Server and as a Managed server. This domain can be useful while developing applications, but it is not recommended for use in a production environment. Although the scope and purpose of a domain can vary significantly, most WebLogic Server domains contain the components described in this section.","By default, the WebLogic domain created by the P6 EPPM Configuration Wizard creates a domain with an Administration Server (AdminServer) and a Managed Server for each application that you deploy. If you are installing P6 EPPM manually, Oracle recommends you create a managed server for each P6 EPPM application you deploy, similar to the P6 EPPM Configuration Wizard. For example:","P6","P6 Team Member","P6 Professional Cloud Connect","P6 EPPM Web Services","P6 Integration API","Note If you plan to enable Oracle Web Services Manager Authentication, skip the following procedure and refer to Creating a Domain for Oracle Web Services Manager Authentication for instructions on creating a domain.","To create a domain:","To create a WebLogic Domain:","Run the WebLogic Configuration Wizard.","In the Create Domain&nbsp;window:","Select Create a new WebLogic domain.","In the Domain Location field, enter the location that you want to create the domain.","Click Next.","In the Templates&nbsp;window, select the templates that you want to apply to the domain and click Next.","In the Administrator Account&nbsp;window:","Enter the user name and password information.","Click Next.","In the Domain Mode&nbsp;window: ","Select Production Mode. ","Select a JDK. ","Click Next.","In the Advanced Configuration window:","Select the Administration Server, Managed Servers, and Managed Servers, Clusters and Coherence.","Click Next.","In the Administration Server window: ","(Optional) Select Enable SSL and set the SSL listen port if you are enabling Secure Sockets Layer communication.","Click Next.","See https://docs.oracle.com/middleware/1221/core/ASADM/sslconfig.htm for more details on setting SSL for WebLogic.","In the Node Manager window:","Select a Node Manager Type.","In the Username and Password fields, enter the credentials for the Node Manager.","Click Next.","In the Managed Servers window:","Click Add.","Enter the Name and select the Listen address information.","(Optional) Select the SSL enabled option and set the SSL listen port.","(Optional) Add or delete other managed servers.","Click Next.","In the Clusters window:","Note Do not add clusters if you are not using multiple WebLogic server instances for scalability.","(Optional) Click Add.","(Optional) Enter the name of the cluster.","(Optional) Enter the following information: Cluster messaging mode, Multicast address, Multicast port, and Cluster address.","(Optional) Add or delete other configured clusters.","Click Next.","Note For information on setting up clusters, use Oracle's WebLogic Server documentation: https://docs.oracle.com/middleware/1221/wls/CLUST/setup.htm.","(Optional) In the Assign Servers to Clusters window, assign a server to a cluster and then click Next.","Note Select the Cluster in the right pane, then select the Server in the left pane. Assign the server to the cluster by clicking the right arrow button.","In the Machines window, select Machine (with Windows) and then complete the following:","Click Add.","Enter a machine name.","(Optional) Select the Node manager listen address from the list.","Note If you specify an address for a machine that hosts the Administration Server and you need to access the WebLogic Server Node Manager, you must disable the host name verification.","(Optional) Enter the Node manager listen port.","(Optional) Add or delete configured machines.","(Optional) Click Next.","In the Machines window, select Unix Machine (with UNIX) and the complete the following:","Click Add.","Enter a machine name.","(Optional) Select the Post bind GID enabled option to enable a server running on this machine to bind to a UNIX group ID (GID) after it finishes all privileged startup actions.","(Optional) Enter the Post bind GID where a server on this machine will run after it finishes all privileged startup actions. If you do not enter a GID, the server will continue to run under the group where it was started. For this setting to work, you must select the Post bind GID enabled option.","(Optional) Select the Post bind UID enabled option to enable a server running on this machine to bind to a UNIX user ID (UID) after it finishes all privileged startup actions.","(Optional) Enter Post bind UID where a server on this machine will run after it finishes all privileged startup actions. If you do not enter a UID, the server will continue to run under the account where it was started. For this setting to work, you must select the Post bind UID enabled option.","(Optional) Add or delete configured machines.","Click Next.","Note","You might want to create machine definitions for the following situations: (1) The Administration Server uses the machine definition (along with the Node Manager application) to start remote servers. (2) WebLogic Server uses configured machine names when determining the server in a cluster that can handle certain tasks, such as HTTP session replication. The WebLogic Server then delegates those tasks to the identified server.","You must configure machines for each product installation that runs a Node Manager process. The machine configuration must include values for the listen address and port number parameters.","In the Assign Servers to Machines window:","Note A machine is a physical server that will host a WebLogic managed server. Depending on your resource needs and data load, the machines may be in the same physical server where the WebLogic Admin Server is installed or in separate physical servers.","In the Machine list, select the machine where you want to assign a WebLogic Server instance.","Assign the managed and administrative servers that you created to the selected machine.","Review the machine assignments.","Click Next.","In the Configuration Summary window, click Create.","If given the option, you can click Done now. Otherwise, continue to the next step.","If you are using Windows, in the Creating Domain window:","Select Start Admin Server.","Click Done.","When prompted, enter the administrator user name and password that you entered above.","Repeat this procedure for each new domain.","Creating a Domain with Servers<br /> (Primavera P6 EPPM WebLogic Configuration Guide for On-Premises)","English\\Configuring\\p6_eppm_weblogic_config\\93090.htm");
Page[294]=new Array("You can choose from several methods for authenticating P6 EPPM Web Services calls when you configure P6 EPPM Web Services in Primavera P6 Administrator. Oracle Web Services Manager (OWSM) is among the supported methods. ","Note If you select OWSM as the authentication mode for P6 EPPM Web Services, only OWSM authentication can be used. OWSM receives the authentication request and will perform the authentication instead of passing the authentication request to P6 EPPM Web Services.","To create a domain and administration server for P6 EPPM Web Services:","Open the Fusion Middleware Configuration Wizard by completing the following:","Navigate to &lt;Oracle_Home&gt;\\oracle_common\\common\\bin.","Run config.cmd (if Windows) or config.sh (if UNIX).","On the Configuration Type screen, complete the following:","Select Create a new domain.","Browse to the location at which the new domain will be created.","On the Template screen, complete the following:","Select Create Domain Using Product Templates:","In the Template Categories menu, select All Templates.","Select the following from the Available Templates window:","Basic WebLogic Server Domain","Oracle Enterprise Manager","Oracle WSM Policy Manager","Oracle JRF","WebLogic Coherence Cluster Extension","On the Administrator Account screen, complete the following:","In the Name field, enter a name for the domain administrator.","In the Password field, enter a password for the domain administrator.","In the Confirm Password field, enter the password that you entered in the Password field.","On the Domain Mode and JDK screen, complete the following:","Under Domain Mode, select one of the following:","Development","Production","Under JDK, select a supported JDK. For supported JDKs, see Tested Configurations.","On the Database Configuration Type screen, complete the following:","Under Specify AutoConfiguration Options Using:, select RCU Data.","Fill in each field, using the connection information that you specified for the Service Table component in the Repository Creation Utility (RCU).","Click Get RCU Configuration to retrieve the schema information.","In the Schema Password field, enter the password for the schema owner.","On the JDBC Components Schema screen, complete the following:","Fill in each field, using the connection information that you specified for the Service Table component in the Repository Creation Utility (RCU).","In the Schema Password fields of the table, enter the password for each component schema.","Select the schema in the table.","Click Test Selected Connections to ensure that the credentials for each schema are valid.","On the Advanced Configuration screen, select Administration Server.","On the Administration Server screen, complete the following:","In the Server Name field, enter a name for the administration server.","In the Listen Address field menu, select the appropriate listen address.","In the Listen Port field, enter the listen port number.","In the Server Groups menu, select the following:","WSM-CACHE-SVR","WSMPM-MAN-SVR","On the Configuration Summary screen, click Create.","After the domain has been created, complete the tasks in the Using Oracle Web Services Manager for Authentication section.","Creating a Domain for Oracle Web Services Manager Authentication<br /> (Primavera P6 EPPM WebLogic Configuration Guide for On-Premises)","English\\Configuring\\p6_eppm_weblogic_config\\91756.htm");
Page[295]=new Array("After creating your WebLogic domains, you must add your P6 EPPM applications to your WebLogic domains.","To add P6 EPPM applications to WebLogic:","In the Change Center pane, click Lock &amp; Edit.","In the Domain Structure pane, click Deployments.","In the Configuration tab on the Summary of Deployments page, click Install.","In the Install Application Assistant&nbsp;window, complete the following:","Select the EAR or WAR file for the application or Help that you want to deploy. For each application and Help, you can find the EAR and WAR files at the following locations:","For P6, &lt;P6_EPPM_Home&gt;\\p6\\p6.ear","For P6 Team Member, &lt;P6_EPPM_Home&gt;\\tmws\\p6tm.ear","For P6 Professional Cloud Connect, &lt;P6_EPPM_Home&gt;\\p6procloudconnect\\p6procloudconnect.war","For P6 Integration API, &lt;P6_EPPM_Home&gt;\\api\\applications\\PrimaveraAPI.war","For P6 EPPM Web Services, &lt;P6_EPPM_Home&gt;\\ws\\server\\p6ws.ear","For P6 and P6 Team Member helps:","Go to https://docs.oracle.com/en/industries/construction-engineering/primavera-p6-project/index.html.","Click the 25 Documentation Library link.","Navigate to the Using page.","Click the Downloadable P6_Help link and the Downloadable TM_Help link.","Note For the Help to launch, you must enter the server URL in the Primavera P6 Administrator. See the P6 EPPM System Administration Guide for more information. Oracle recommends that you do not deploy the P6 or P6 Team Member Help because the default URL will take you to the version hosted by Oracle. The hosted version contains the most up-to-date documentation. ","Click Next.","On the Install Application Assistant&nbsp;page: ","Select Install this deployment as an application.","Click Next.","On the Install Application Assistant&nbsp;page:","Select the managed server.","Click Next.","In the Install Application Assistant&nbsp;pane, click Next&nbsp;to accept the default options.","Review the configuration settings you have chosen and then click Finish&nbsp;to complete the installation.","Repeat this procedure for each application on each domain.","In the Change Center pane, click Activate Changes.","Adding Applications and Help to Managed Servers<br /> (Primavera P6 EPPM WebLogic Configuration Guide for On-Premises)","English\\Configuring\\p6_eppm_weblogic_config\\93093.htm");
Page[296]=new Array("Use these instructions for each P6 EPPM application that you deploy in a managed or clustered server. To continue configuring WebLogic for P6, you must add the following arguments to your managed or clustered server in the WebLogic Administration console.","To set WebLogic Server arguments: ","In the Change Center pane of the Administration Console, click Lock &amp; Edit.","On the Domain Structure pane, expand Environment and then click Servers.","In the Summary of Servers page, click the managed server on which you deployed your application or Help.","In Configuration tab, on the Settings for &lt;managed server name&gt; page, navigate to the Server Start tab.","In the Arguments field, enter the following arguments as necessary in the order that they appear:","-server","-Dprimavera.bootstrap.home=&lt;P6_EPPM_BootStrap_Home&gt;","where &lt;P6_EPPM_BootStrap_Home&gt; is the home directory of BREBootStrap.xml. If you do not have a BREBootStrap.xml file for your P6 EPPM implementation, you can create one by creating a P6 EPPM configuration using the Database Configuration wizard. For more information about using the Database Configuration wizard, see the P6 EPPM Database Administration Guide.","-Ddatabase.instance=db_id","Include this argument to establish a default database connection for P6 Team Member, P6 EPPM Web Services, and P6 Integration API if you use more than one database instance. You do not need to set this argument for P6.","-Dweblogic.webservice.i18n.charset=utf-8","(Optional) Include this argument to allow WebLogic to process UTF-8 characters.","-Djava.awt.headless=true","(With UNIX only) Include this argument if you are deploying P6 EPPM on a non-graphical UNIX environment. This argument sets the server's JVM to bypass server-side rendering optimizations. If you do not add the argument, you may not be able to see graphics on pages and the server logs will report NoClassDefFoundError errors.","-Djavax.xml.stream.XMLInputFactory=com.ctc.wstx.stax.WstxInputFactory","(Optional) Include this argument for improved performance when starting the WebLogic domain.","-XX:MaxPermSize=","(Optional) Include this argument to set the new generation heap size. The MaxPermSize setting should be set to at least 256m. You can modify memory settings to maximize performance.","-XX:NewSize=","(Optional) Include this argument to set the maximum size of the new generation heap size. As a general rule, set -XX:NewSize to be one-fourth the size of the heap size. Increase the value of this option for larger numbers of short-lived objects. Be sure to increase the new generation as you increase the number of processors. Memory allocation can be parallel, but garbage collection is not parallel.","-XX:MaxNewSize=","(Optional) Include this argument to set the maximum size of the new generation heap size.","-XX:SurvivorRatio=","(Optional) Include this argument to set new heap size ratios.","The New generation area is divided into three sub-areas: Eden, and two survivor spaces that are equal in size. Configure the ratio of the Eden/survivor space size. Try setting this value to 8, and then monitor your garbage collection.","-Xms -Xmx","(Optional) Include this argument to set the initial and maximum heap size. ","As a general rule, set the initial heap size (-Xms) equal to the maximum heap size (-Xmx) to minimize garbage collection.","-XX:+UseParallelGC -XX:+UseParallelOldGC -XX:GCTimeRatio=19","(Optional) Include this argument if you are running Publication Services on a larger database.","-Xloggc:&lt;Log_Path&gt;","Include this argument to collect garbage logs if you have memory issues on JVM.","For example:","(With Windows)","-server -Dprimavera.bootstrap.home=&lt;P6_EPPM_Home&gt; -Djavax.xml.stream.XMLInputFactory=com.ctc.wstx.stax.WstxInputFactory -XX:MaxPermSize=256m -XX:NewSize=256m -XX:MaxNewSize=256m -XX:SurvivorRatio=8 -Xms2048m -Xmx2048m -XX:+UseParallelGC -XX:+UseParallelOldGC -XX:GCTimeRatio=19 -Xloggc:&lt;Log_Path&gt;","(With UNIX)","-server -Dprimavera.bootstrap.home=&lt;P6_EPPM_Home&gt; -Djava.awt.headless=true -Djavax.xml.stream.XMLInputFactory=com.ctc.wstx.stax.WstxInputFactory -XX:MaxPermSize=256m -XX:NewSize=256m -XX:MaxNewSize=256m -XX:SurvivorRatio=8 -Xms2048m -Xmx2048m -XX:+UseParallelGC -XX:+UseParallelOldGC -XX:GCTimeRatio=19 -Xloggc:&lt;path to the log file&gt;","Note If you use additional arguments that are not listed here, be sure to list them in the correct sequence for your environment.","Click Save.","Add arguments to the managed servers on which applications or Help are deployed.","In the Change Center pane, click Activate Changes.","Restart your managed servers.","Setting Arguments<br /> (Primavera P6 EPPM WebLogic Configuration Guide for On-Premises)","English\\Configuring\\p6_eppm_weblogic_config\\93150.htm");
Page[297]=new Array("Use these instructions for each P6 EPPM application that you deploy on an administration server.","To edit the setDomainEnv file:","Navigate to &lt;WebLogic_Home&gt;/user_projects/&lt;Domain_Home&gt;/bin and make a backup copy of the setDomainEnv.cmd (on Windows) setDomainEnv.sh (for UNIX).","Edit the setDomainEnv file.","After %WL_HOME%/common/bin/commEnv.cmd&quot; (on Windows) ${WL_HOME}/common/bin/commEnv.sh (on UNIX), enter the following arguments as necessary in the order that they appear:","-server","-Dprimavera.bootstrap.home=&lt;P6_EPPM_BootStrap_Home&gt;","where &lt;P6_EPPM_BootStrap_Home&gt; is the home directory of BREBootStrap.xml. If you do not have a BREBootStrap.xml file for your P6 EPPM implementation, you can create one by creating a P6 EPPM configuration using the Database Configuration wizard. For more information about using the Database Configuration wizard, see the P6 EPPM Database Administration Guide.","-Ddatabase.instance=db_id","Include this argument to establish a default database connection for P6 Team Member, P6 EPPM Web Services, and P6 Integration API if you use more than one database instance. You do not need to set this argument for P6.","-Dweblogic.webservice.i18n.charset=utf-8","(Optional) Include this argument to allow WebLogic to process UTF-8 characters.","-Djava.awt.headless=true","(With UNIX only) Include this argument if you are deploying P6 EPPM on a non-graphical UNIX environment. This argument sets the server's JVM to bypass server-side rendering optimizations. If you do not add the argument, you may not be able to see graphics on pages and the server logs will report NoClassDefFoundError errors.","-Djavax.xml.stream.XMLInputFactory=com.ctc.wstx.stax.WstxInputFactory","(Optional) Include this argument for improved performance when starting the WebLogic domain.","-XX:MaxPermSize=","(Optional) Include this argument to set the new generation heap size. The MaxPermSize setting should be set to at least 256m. You can modify memory settings to maximize performance.","-XX:NewSize=","(Optional) Include this argument to set the maximum size of the new generation heap size. As a general rule, set -XX:NewSize to be one-fourth the size of the heap size. Increase the value of this option for larger numbers of short-lived objects. Be sure to increase the new generation as you increase the number of processors. Memory allocation can be parallel, but garbage collection is not parallel.","-XX:MaxNewSize=","(Optional) Include this argument to set the maximum size of the new generation heap size.","-XX:SurvivorRatio=","(Optional) Include this argument to set new heap size ratios.","The New generation area is divided into three sub-areas: Eden, and two survivor spaces that are equal in size. Configure the ratio of the Eden/survivor space size. Try setting this value to 8, and then monitor your garbage collection.","-Xms -Xmx","(Optional) Include this argument to set the initial and maximum heap size. ","As a general rule, set the initial heap size (-Xms) equal to the maximum heap size (-Xmx) to minimize garbage collection.","-XX:+UseParallelGC -XX:+UseParallelOldGC -XX:GCTimeRatio=19","(Optional) Include this argument if you are running Publication Services on a larger database.","-Xloggc:&lt;Log_Path&gt;","Include this argument to collect garbage logs if you have memory issues on JVM.","For example:","(With Windows)","-server -Dprimavera.bootstrap.home=&lt;P6_EPPM_Home&gt; -Djavax.xml.stream.XMLInputFactory=com.ctc.wstx.stax.WstxInputFactory -XX:MaxPermSize=256m -XX:NewSize=256m -XX:MaxNewSize=256m -XX:SurvivorRatio=8 -Xms2048m -Xmx2048m -XX:+UseParallelGC -XX:+UseParallelOldGC -XX:GCTimeRatio=19 -Xloggc:&lt;Log_Path&gt;","(With UNIX)","-server -Dprimavera.bootstrap.home=&lt;P6_EPPM_Home&gt; -Djava.awt.headless=true -Djavax.xml.stream.XMLInputFactory=com.ctc.wstx.stax.WstxInputFactory -XX:MaxPermSize=256m -XX:NewSize=256m -XX:MaxNewSize=256m -XX:SurvivorRatio=8 -Xms2048m -Xmx2048m -XX:+UseParallelGC -XX:+UseParallelOldGC -XX:GCTimeRatio=19 -Xloggc:&lt;path to the log file&gt;","Note If you use additional arguments that are not listed here, be sure to list them in the correct sequence for your environment.","Save and Close the file.","Restart the admin server.","Modifying setDomainEnv for Applications Deployed on Administration Servers<br /> (Primavera P6 EPPM WebLogic Configuration Guide for On-Premises)","English\\Configuring\\p6_eppm_weblogic_config\\32722.htm");
Page[298]=new Array("Use the steps in the related topics to begin using P6 mobile.","Finalizing P6 mobile<br /> (Primavera P6 EPPM WebLogic Configuration Guide for On-Premises)","English\\Configuring\\p6_eppm_weblogic_config\\54132.htm");
Page[299]=new Array("To download the P6 mobile apps, do one of the following:","If you are using an iOS device, go to the Apple App Store to download the mobile application. ","If you are using an Android device, go to the Google Play Store to download the mobile application.","Note If you are in a region without access to the Google Play Store, or your organization is using a Content Security Service or Mobile Device Management solution and requires that users do not download P6 mobile from the Apple App Store or Google Play Store, submit a Service Request in My Oracle Support to request versions of the P6 mobile apps for those scenarios.","Downloading P6 mobile Apps<br /> (Primavera P6 EPPM WebLogic Configuration Guide for On-Premises)","English\\Configuring\\p6_eppm_weblogic_config\\49001.htm");
Page[300]=new Array("Follow these steps to start the app for the first time. When you return to the app after working in other apps, the last page you were on will appear. Once you configure these settings, you won't need to perform these steps again unless your SSO cookies expire. If your cookies expire, you will need to enter your user name and password again.","Note You may need to activate your device's VPN feature to access your company's deployment of P6. Contact your administrator for more information.","To start the app:","On your device's Home screen, tap @ P6.","On the Welcome to P6 Team Member page, slide the Single Sign On (SSO) switch to either ON or OFF.","Note Team Member Web Services supports LDAP, Native, or SSO mode. Your administrator will select the authentication mode when they configure P6.","If you turn SSO on:","Tap the URL field and enter the URL to your server (for example, http://server:port/p6tmws). ","Note You will need to specify the server name and port number in the URL.","Tap Authenticate.","Enter your SSO username and password.","If you turn SSO off:","Tap the URL field and enter the URL to your server (for example, https://server:port/p6tmws). ","Enter your P6 username.","Enter your P6 password.","Tap Sign In.","Note","You will need to configure Email Statusing Service separately. See the P6 EPPM System Administration Guide.","P6 for iOS supports SSL (https) or HTTP only when it has a certificate signed by a trusted authority.","P6 for Android requires SSL (https) when you are not using SSO authentication. If you are using SSO authentication, you can use HTTP or HTTPs protocols. HTTPS requires a valid certificate from an Android trusted certifying authority.","Tip","To access server information in the app&#8212;which includes the SSO setting, the URL to access the server, and your user name&#8212;navigate to the app menu, and then tap Settings.","For more information on the different types of authentication modes (Single Sign-On, Native, or LDAP), see &quot;Authentication Modes in P6 EPPM&quot; in the P6 EPPM System Administration Guide.","You can modify the settings for the app from the Settings page on your iPhone. See the P6 Team Member User's Guide for more information.","Configuring Login and Authentication Settings to Use P6 for iOS<br /> (Primavera P6 EPPM WebLogic Configuration Guide for On-Premises)","English\\Configuring\\p6_eppm_weblogic_config\\49002.htm");
Page[301]=new Array("Follow these steps to start the app for the first time. When you return to the app after working in other apps, the last page you were on will appear. Once you configure these settings, you won't need to perform these steps again unless your SSO cookies expire. If your cookies expire, you will need to enter your user name and password again.","Note You may need to activate your device's VPN feature to access your company's deployment of P6. Contact your administrator for more information.","P6 for Android only accepts SSL certificates from a certifying authority and must use an HTTPS connection.","To start the app:","On your device's Home screen, tap @ P6.","On the Welcome to P6 Team Member page, slide the Single Sign On (SSO) switch to either ON or OFF.","Note Team Member Web Services supports LDAP, Native, or SSO mode. Your administrator will select the authentication mode when they configure P6.","If you turn SSO on:","Tap the URL field and enter the URL to your server (for example, http://server:port/p6tmws). ","Note You will need to specify the server name and port number in the URL.","Tap Authenticate.","Enter your SSO username and password.","If you turn SSO off:","Tap the URL field and enter the URL to your server (for example, https://server:port/p6tmws). ","Enter your P6 username.","Enter your P6 password.","Tap Sign In.","Note","You will need to configure Email Statusing Service separately. See the P6 EPPM System Administration Guide.","P6 for iOS supports SSL (https) or HTTP only when it has a certificate signed by a trusted authority.","P6 for Android requires SSL (https) when you are not using SSO authentication. If you are using SSO authentication, you can use HTTP or HTTPs protocols. HTTPS requires a valid certificate from an Android trusted certifying authority.","Tip","To access server information in the app&#8212;which includes the SSO setting, the URL to access the server, and your user name&#8212;navigate to the app menu, and then tap Settings.","For more information on the different types of authentication modes (Single Sign-On, Native, or LDAP), see &quot;Authentication Modes in P6 EPPM&quot; in the P6 EPPM System Administration Guide.","You can modify the settings for the app from the Settings button in the app. See the P6 Team Member User's Guide for more information.","Configuring Login and Authentication Settings to Use P6 for Android<br /> (Primavera P6 EPPM WebLogic Configuration Guide for On-Premises)","English\\Configuring\\p6_eppm_weblogic_config\\87134.htm");
Page[302]=new Array("Use the steps in the related topics to begin using P6 Team Member Web.","Finalizing P6 Team Member Web<br /> (Primavera P6 EPPM WebLogic Configuration Guide for On-Premises)","English\\Configuring\\p6_eppm_weblogic_config\\55087.htm");
Page[303]=new Array("To configure the settings for P6 Team Member Web, you must have a P6 Team Member Admin Configuration. See Installing and Configuring P6 EPPM for more information on how to create this configuration during a new installation of P6 Team Member Web or P6 EPPM.","To configure the settings for P6 Team Member Web:","Launch Primavera P6 Administrator.","Navigate to your P6 Team Member configuration, and then expand it.","Expand Application:","Set the Help server URL to one of the following:","http://localhost:listenport/ContextRoot","where localhost is your server's host name, listenport is your P6 Team Member port number, and ContextRoot is the root for your Help.","https://docs.oracle.com/cd/E90746_01/team_member/web/help/","Note Oracle recommends that you use the second URL option because it ensures that you always access the latest version of the P6 Team Member Help, including critical corrections and enhancements.","Expand Team Member:","Expand Connection Pool if you want to alter the following default values:","Initial connection pool size: 10","Maximum active database connections: 150","Maximum idle database connections: -0","Minimum idle database connections: 10","Expand Logging if you want to alter the following default values:","Enable: enabled","Severity Level: Error","Log File Name: p6tmweb.log","Note","The primavera.bootstrap.home property determines the location of the log file.","Configuring P6 Team Member Web Settings<br /> (Primavera P6 EPPM WebLogic Configuration Guide for On-Premises)","English\\Configuring\\p6_eppm_weblogic_config\\55075.htm");
Page[304]=new Array("To configure Email Statusing Service for P6:","From the P6 Team Member home directory (for example, C:\\P6EPPM_1\\tmws), extract the files from the p6tm-email-service.zip to any location on the application server. (That location will be referred to as EMAIL_HOME).","Make a backup copy of the config.properties file before you edit it.","Edit the config.properties file to configure the settings for the email application.","Note When you are finished editing the config.properties file, move it to a secure location.","In the P6 Configuration section, locate and specify the following:","In the p6.admin.user = line, specify a P6 user who is assigned to at least one module access and has resource access.","In the p6.notify.user= line, specify the email addresses, separated by commas, of users who can send Notify Task lists to other users. As you see the P6 Help for more information on sending team members their tasks.","In the p6.max.tmusers = line, specify the maximum number of email recipients that can receive notification emails at one time. You should keep the number below 500 to avoid performance problems.","In the p6.bootstrap = line, specify the location of the BREBootstrap.xml file.","For example, the location could be one of the following: C:/P6EPPM_1/p6, C:/EMAIL_HOME, /usr/P6EPPM_1/p6, or /usr/EMAIL_HOME or you can use the following: C:\\\\P6EPPM_1\\p6, C:\\\\EMAIL_HOME.","In the mail.read.schedule = line, specify how often your email should process new messages. Use cron expressions for your formatting. For example:","0 */5 * * * ?","will process new messages every five minutes.","Note For more information on cron expressions, see https://docs.oracle.com/cd/E12058_01/doc/doc.1014/e12030/cron_expressions.htm.","In the Outgoing mail (SMTP Settings) section, locate and specify the following:","In the send.host = line, specify the SMTP server hostname or IP address that you will use to send emails.","In the send.port = line, specify the port number that connects to the SMTP server.","In the send.ssl = line, specify true to use SSL or false if you will not use SSL.","Note Oracle recommends that you always use SSL in a production environment for secure communications.","In the send.starttls = line, specify true to use TLS or false if you will not use TLS.","In the send.email = line, specify the email address or User Principal Name (UPN) where team members will send their status update requests.","In the send.replyto = line, specify an email address for team members to respond to when they receive emails. If this field is left blank, the reply address will be the send.email address you specified above.","In the send.password = line, specify the password for the email address or UPN you just specified. ","Note","If you do not specify a password now, the email application prompts you to specify one when it runs. ","You can also specify a password by running the following parameter when you run the 'run.bat' or 'run.sh' file:<br />-Dsend.password=YOUR_PASSWORD<br />where Your_Password is the password for your status email address.<br />For example: <br />In Windows: ./run.bat -Dsend.password=YOUR_PASSWORD<br />In UNIX: ./run.sh -Dsend.password=YOUR_PASSWORD","Oracle recommends using the option in the config.properties file and then moving that file to a secure location when you are finished modifying it.","If you want to set up anonymous authentication for an SMTP server, comment this field out.","In the Incoming Mail (IMAP Settings) section, locate and specify the following:","In the imap.host = line, specify the IMAP protocol host to read emails.","In the imap.port = line, specify the IMAP port number.","In the imap.ssl= line, specify true to use SSL or false if you will not use SSL.","NoteOracle recommends that you always use SSL in a production environment for secure communications.","In the imap.username = line, specify the IMAP user name (which will be your email address) or User Principal Name (UPN).","In the imap.password = line, specify the password for the user name you just specified.","Note","If you do not specify a password now, the email application will ask you to specify one when it runs. ","You can also specify a password by running the following parameter when you run the 'run.bat' or 'run.sh' file:<br />-Dimap.password=YOUR_PASSWORD<br />where Your_Password is the password for your status email address.<br />For example: <br />In Windows: ./run.bat -Dimap.password=YOUR_PASSWORD<br />In UNIX: ./run.sh -Dimap.password=YOUR_PASSWORD","Oracle recommends using the option in the config.properties file and then moving that file to a secure location when you are finished modifying it.","If you want to setup anonymous authentication for an SMTP server, comment this field out.","In the imap.search.folder = line, specify the folder to use for processing incoming emails. For example:","imap.search.folder = inbox","Note The email application will use this folder to search for incoming mail. Oracle recommends you use the inbox for this folder. If you select another folder, you must ensure that all emails get filtered there, or the email application will not be able to detect the messages.","In the IMAP Folder configuration section, locate and specify the following:","In the imap.success.folder = line, specify the folder where messages that process successfully will go. For example:","imap.success.folder = P6Success","Note The email application will automatically create this folder if you do not create it now.","In the imap.failure.folder = line, specify the folder where messages that failed will go. For example:","imap.failure.folder = P6Fail","Note The email application will automatically create this folder if you do not create it now.","In the imap.temp.folder = line, specify the folder where messages that are being processed will go. For example: ","imap.temp.folder = P6Temp","Note The email application will automatically create this folder if you do not create it now.","In the Task update options section, locate and specify the following:","In the reply.label.cleanup field, enter true if you want to remove HTML tags attached to the task field labels. Enter false if you don't want to remove the tags.","In the reply.label.tag.search field, enter the regular expression to remove unexpected HTML tags during reply message parsing.","Note See information on &quot;regular expression&quot; for more details on this field. For example, see https://developer.mozilla.org/en-US/docs/JavaScript/Guide/Regular_Expressions#Writing_a_Regular_Expression_Pattern.","In the update.debug field, enter true if you want to output the contents of the email message as it is parsed for updates. Enter false if you don't want to output the contents of the email message as it is parsed for updates. You should only enter true when you are troubleshooting issues with updating tasks. ","In the Message Format options section, locate and specify the following:","In the update.task.search.term = line, specify the text that the email application should search for in the subject line of incoming messages. For example:","update.task.search.term = Your Requested P6 Tasks","In the notify.update.task.search.term = line, specify the text that the email application should search for in the subject line of incoming messages that originated from a Notify message. For example:","update.task.search.term = Your P6 Tasks","If the EMAIL_HOME is on a different server from your P6 home, copy the BREBootstrap.xml from your P6 home to your EMAIL_HOME.","If the EMAIL_HOME is on the same server as your P6 home, you will use the BREBootstrap.xml that is in your P6 home folder.","Run one of the following:","In Windows, launch the run.bat file.","In UNIX, launch the run.sh file.","When you launch the run file, you may have to complete the following steps depending on how you configured your Email Statusing Service:","If the config.properties file and the run file are in different folders, you will need to specify the config.properties location with the -Dconfig.file parameter.","In Windows (add a space between run.bat and -Dconfig):","run.bat -Dconfig.file=C:\\home\\auser\\somelocation\\config.properties","In UNIX (add a space between run.sh and -Dconfig): ","./run.sh -Dconfig.file=/home/auser/somelocation/config.properties","If you didn't specify the send.password= or imap.password=, you can specify them now. If you do not specify them now, the email application will prompt you to do so when it runs.","In Windows: ","run.bat -Dsend.password=YOUR_PASSWORD","In UNIX:","./run.sh -Dsend.password=YOUR_PASSWORD","In Windows:","run.bat -Dimap.password=YOUR_PASSWORD","In UNIX:","./run.sh -Dimap.password=YOUR_PASSWORD","where Your_Password is the password for your status email address","If your bootstrap file contains more than one database, you need to clarify which database you are using when you launch the run file.","In Windows:","run.bat -Ddatabase.instance=db_id","where db_id is your database instance (for example, -Ddatabase.instance=2).","In UNIX: ","./run.sh -Ddatabase.instance=db_id","where db_id is your database instance (for example, -Ddatabase.instance=2).","Once the run file finishes, you can verify that the email status application works. See Verifying Email Statusing Service.","Note Anonymous SMTP authentication is supported.","Configuring Email Statusing Service for P6<br /> (Primavera P6 EPPM WebLogic Configuration Guide for On-Premises)","English\\Configuring\\p6_eppm_weblogic_config\\49980.htm");
Page[305]=new Array("Once you have installed the email status application, you can send an email to verify that the server is setup properly.","To verify your Email Statusing Service setup:","Enter an email address that P6 recognizes in the 'From' line.","Enter the email address you specified in Configuring Email Statusing Service for P6 in the 'To' line.","Enter Ping in the subject line.","Send the message.","If the message is successful, you will receive a message containing the status of the email service. The message will tell you how many users have a blank email address in the database.","If the message failed, you will not receive a message. The failed message will appear in the failure folder that you specified in the config.properties file. See Configuring Email Statusing Service for P6.","Verifying Email Statusing Service<br /> (Primavera P6 EPPM WebLogic Configuration Guide for On-Premises)","English\\Configuring\\p6_eppm_weblogic_config\\49982.htm");
Page[306]=new Array("Follow the instructions to deploy P6 Integration API into the WebLogic domain.","Note","Consult WebLogic's documentation for additional methods of deploying a Web application, such as using a Managed Server or Clustering.","P6 EPPM Web Services supports the HTTPS communication protocol. See the application server documentation for instructions on configuring HTTPS on your application server.","Deploying P6 EPPM Web Services in WebLogic<br /> (Primavera P6 EPPM WebLogic Configuration Guide for On-Premises)","English\\Configuring\\p6_eppm_weblogic_config\\35676.htm");
Page[307]=new Array("If you do not have a JDK Home folder specified, you must create an endorsed folder to deploy P6 EPPM Web Services in WebLogic.","To create an endorsed folder:","Locate the folder that contains the JDK you used when you created the WebLogic domain. This folder is known as &lt;JDK_HOME&gt;.","If it does not already exist, create an endorsed folder: &lt;JDK_HOME&gt;/jre/lib/endorsed.","In the &lt;WS_INSTALL_HOME&gt;/endorsed folder, locate the saaj-impl.jar file.","Copy the saaj-impl.jar file to the endorsed folder you created (&lt;JDK_HOME&gt;/jre/lib/endorsed).","Restart the WebLogic domain.","Creating an Endorsed Folder<br /> (Primavera P6 EPPM WebLogic Configuration Guide for On-Premises)","English\\Configuring\\p6_eppm_weblogic_config\\47316.htm");
Page[308]=new Array("Before starting P6 EPPM Web Services, add the following JVM option to the startWeblogic startup script:","Make a backup copy of the startWebLogic&nbsp;file in case you need to undo any changes.","In Windows, the file is named &quot;startWebLogic.cmd&quot; and is located in:<br />weblogic_home\\user_projects\\domains\\your_domain\\bin\\","In Unix, the file is named &quot;startWebLogic.sh&quot; and is located in:<br />weblogic_home/user_projects/domains/your_domain/bin/","Right-click the startWebLogic file and select Edit.","Locate the line that begins with &quot;set JAVA_OPTIONS=&quot; and add these variables (as all one line with no space between &quot;-&quot; and &quot;Dprimavera&quot; or &quot;-&quot; and &quot;Djavax&quot;).","On Windows:","set JAVA_OPTIONS=%SAVE_JAVA_OPTIONS% -Djavax.xml.soap.MessageFactory=com.sun.xml.messaging.saaj.soap.ver1_1.SOAPMessageFactory1_1Impl -Djavax.xml.soap.SOAPConnectionFactory=weblogic.wsee.saaj.SOAPConnectionFactoryImpl<br />-Dprimavera.bootstrap.home=&lt;WS_INSTALL_HOME&gt;","where &lt;WS_INSTALL_HOME&gt; is the P6 EPPM Web Services home directory the you set during installation","On Linux:","JAVA_OPTIONS=&quot;${SAVE_JAVA_OPTIONS} -Djavax.xml.soap.MessageFactory=com.sun.xml.messaging.saaj.soap.ver1_1.SOAPMessageFactory1_1Impl -Djavax.xml.soap.SOAPConnectionFactory=weblogic.wsee.saaj.SOAPConnectionFactoryImpl<br />-Dprimavera.bootstrap.home=&lt;WS_INSTALL_HOME&gt;&quot;","where &lt;WS_INSTALL_HOME&gt; is the P6 EPPM Web Services home directory the you set during installation","Adding a JVM Option to the startWeblogic Script<br /> (Primavera P6 EPPM WebLogic Configuration Guide for On-Premises)","English\\Configuring\\p6_eppm_weblogic_config\\53292.htm");
Page[309]=new Array("Oracle Web Services Manager (OWSM) provides the business agility to respond to security threats and security breaches by allowing policy changes to be enforced in real time without interrupting running business processes.","The benefits of using OWSM with P6 EPPM include:","Centrally define and store security policies applied to P6 EPPM Web Services.","Monitor run time security events such as failed authentication or authorization.","Avoid the need for developers to understand security specifications and security implementation details.","Visibility and control of the policies through a centralized administration interface offered by Oracle Enterprise Manager.","Note If you select OWSM as the authentication mode for P6 EPPM Web Services, only OWSM authentication can be used. OWSM receives the authentication request and will perform the authentication instead of passing the authentication request to P6 EPPM Web Services.","To configure the server to authenticate user credentials using OWSM:","Launch the Primavera P6 Administrator and log in.","In the Primavera P6 Administrator, click the Configurations tab, and expand Web Services/Security.","In the Security node, click Authentication:","On the Authentication page, select OWSM - SOAP.","Click Save.","Using Oracle Web Services Manager for Authentication<br /> (Primavera P6 EPPM WebLogic Configuration Guide for On-Premises)","English\\Configuring\\p6_eppm_weblogic_config\\91745.htm");
Page[310]=new Array("Ensure that you have installed Oracle Fusion Middleware SOA Suite and have created the Oracle MDS and OPSS schema. Oracle MDS schema is a prerequisite for the Oracle Fusion Middleware SOA Suite. Oracle OPPS schema is needed to extend the P6 EPPM Web Services domain to work with the Fusion MIddleware SOA Suite. ","For information on how to create the Oracle MDS and OPSS schema, see the Oracle Fusion Middleware Creating Schemas with the Repository Creation Utility guide on Oracle Technical Network.","Prerequisites for Oracle Web Services Manager Authentication<br /> (Primavera P6 EPPM WebLogic Configuration Guide for On-Premises)","English\\Configuring\\p6_eppm_weblogic_config\\91747.htm");
Page[311]=new Array("To enable OWSM authentication using WebLogic Enterprise Manager:","Create a user in security realms of the Weblogic Administration Console.","Log in to the WebLogic Administration Console as an administrative user using the following URL:","http://&lt;Host_Name&gt;:&lt;Port&gt;/console","In the Change Center pane, select Lock &amp; Edit.","In the Domain Structure pane, select Security Realms.","Select myrealm in the security realm list. ","In the Settings for myream page, select Users and Groups.","Note The name of the tab reflects the name of the security realm that you selected.","In the Users toolbar, click New and then complete the following:","In the Name field, enter a name for the user.","In the Password field, enter a password for the user.","In the Confirm Password field, re-enter the password from the previous field.","Click OK.","Note The user added in security realms should also exist in the P6 EPPM database.","Log in to WebLogic Enterprise Manager using the following URL:","http://&lt;Host_Name&gt;:&lt;Port&gt;/em","Navigate to the P6 EPPM domain using the Target Navigation directory.","Deploy P6 EPPM Web Services, using p6ws.ear, in WebLogic Enterprise Manager. ","For information on how to deploy P6 EPPM Web Services in WebLogic Enterprise Manager, refer to the Deploying ADF Applications Using Fusion Middleware Control section of the Oracle Fusion Middleware Administering Oracle Fusion Middleware guide.","Create a WSM Policy Set using the following settings:","On the Create Policy Set: Enter Resource Scope page, in the Type of Resources menu, select SOAP Web Service.","On the Create Policy Set: Enter Resource Scope page, complete the following:","In the Domain Name field, enter the name of the domain on which &lt;0P_ProdName_P6_WS is deployed.","In the Application Module Name or Connection Name field, enter p6ws.war.","On the Edit Policy Set: Add PolicyReferences page, attach an OWSM policy to the Policy Set.","Note For detailed instructions on how to create a WSM Policy Set, refer to the instructions in Using Fusion Middleware Control section under Creating a Policy Set in the Fusion Middleware Security and Administrator's Guide for Web Services guide.","Select OWSM as the authentication mode in Primavera P6 Administrator.","Log in to Primavera P6 Administrator using the following URL:","http://&lt;Host_Name&gt;:&lt;Port&gt;/p6/action/adminconfig","Expand your P6 EPPM configuration.","Expand Web Services/Security/Authentication.","In the Mode field, select Owsm.","Click Save.","Restart the P6 EPPM Web Services server.","Enabling Oracle Web Services Manager Authentication Using WebLogic Enterprise Manager<br /> (Primavera P6 EPPM WebLogic Configuration Guide for On-Premises)","English\\Configuring\\p6_eppm_weblogic_config\\91746.htm");
Page[312]=new Array("To enable OWSM authentication for P6 Team Member using WebLogic Enterprise Manager:","Log in to WebLogic Enterprise Manager using the following URL:","http://&lt;Host_Name&gt;:&lt;Port&gt;/em","Navigate to the P6 Team Member domain using the Target Navigation directory.","Right-click the P6 Team Member domain and then select Web Services and WSM Policy Sets.","Click Create.","Create a WSM Policy Set using the following settings:","On the Create Policy Set: Enter Resource Scope page, in the Type of Resources menu, select SOAP Web Service.","On the Create Policy Set: Enter Resource Scope page, complete the following:","In the Domain Name field, enter the name of the domain on which P6 EPPM Web Services is deployed.","In the Application Module Name or Connection Name field, enter p6tm.war.","On the Edit Policy Set: Add PolicyReferences page, select oracle/multi_token_rest_service_policy.","Note For detailed instructions on how to create a WSM Policy Set, refer to the instructions in Using Fusion Middleware Control section under Creating a Policy Set in the Fusion Middleware Security and Administrator's Guide for Web Services guide.","Create a user in security realms of the Weblogic Administration Console.","Log in to the WebLogic Administration Console as an administrative user using the following URL:","http://&lt;Host_Name&gt;:&lt;Port&gt;/console","In the Change Center pane, select Lock &amp; Edit.","In the Domain Structure pane, select Security Realms.","Select myrealm in the security realm list. ","In the Settings for myream page, select Users and Groups.","Note The name of the tab reflects the name of the security realm that you selected.","Restart WebLogic and ensure that you can see the LDAP users in Users and Groups.","Note The user added in security realms should also exist in the P6 EPPM database.","Navigate to the Provider tab.","Click New.","In the Create a New Authentication Provider window, complete the following:","In the Name field, enter a name for the authentication provider.","In the Type list, select LDAPAuthenticator.","Click OK.","In the Provider tab, select the provider that you just created.","In the Control Flag list, select SUFFICIENT and then click Save.","Navigate to the Provider Specific tab.","Enter the details for your LDAP server in the Connection and Users sections.","Restart the WebLogic server.","Enabling Oracle Web Services Manager Authentication for P6 Team Member Using WebLogic Enterprise Manager<br /> (Primavera P6 EPPM WebLogic Configuration Guide for On-Premises)","English\\Configuring\\p6_eppm_weblogic_config\\92944.htm");
Page[313]=new Array("This chapter describes how to install the P6 Integration API.","Installing P6 Integration API<br /> (Primavera P6 EPPM WebLogic Configuration Guide for On-Premises)","English\\Configuring\\p6_eppm_weblogic_config\\38133.htm");
Page[314]=new Array("When P6 or p6service.jar runs on a server other than a P6 Integration API Remote Mode server and the &quot;Job Service Shared Folder Location&quot; configuration in the Primavera P6 Administrator is set to null, attempting an XML import from a P6 Professional deployment that uses Cloud Connect will cause the XML import process to fail. The import process fails because the temporary XML file for the project import is created under the P6 Integration API home directory but not the P6 or p6services.jar server, which runs the import code.","Setting the Job Service Shared Folder Location configuration to a shared directory that can be utilized by all P6 modules allows the temporary XML file to be stored in a common location that can be accessed by P6 Integration API Remote Mode server as well as the modules which have potential to run services, such as XML import.","For more information about when you must create a shared folder for P6 Integration API and P6, see the following article on My Oracle Support:","Primavera P6 XML Import Error &quot;Cannot Schedule job. Please contact administrator to correct the problem&quot; or &quot;The job request you submitted did not complete successfully&quot; And The Log File Displays &quot;$path\\importer_RMI_####.xml (No such file or directory)&quot; (Doc ID 1987004.1)","To ensure that you can successfully implement an XML import when P6 Integration API Remote Mode and P6 or p6service.jar resides on different servers:","Add a shared mount (if Linux) or commonly mapped drive (if Windows) to the following locations:","The P6 application servers","The P6 Integration API application servers","The P6 EPPM Web Services application servers","The server that runs p6services.jar","Note If you are using Windows, the drive letter that you use for the mapping must be the same across all servers.","Create a directory on the mount or drive on which temporary files can be created (for example, /P6EPPM/Temp). ","Log in to Primavera P6 Administrator.","Expand Services and then click Job Service Shared File Location.","In the Job Service Shared File Location field, enter the location of the shared directory.","Click Save Changes.","Restart the application servers that are associated with the changes.","Creating a Shared Folder for P6 Integration API and P6<br /> (Primavera P6 EPPM WebLogic Configuration Guide for On-Premises)","English\\Configuring\\p6_eppm_weblogic_config\\90013.htm");
Page[315]=new Array("This section describes how to start and stop server instances in WebLogic Server. The method you choose depends on whether you prefer using the WebLogic Server Administration Console or a command line, and on whether you are using Node Manager to manage the server's life cycle.","Starting and Stopping Servers<br /> (Primavera P6 EPPM WebLogic Configuration Guide for On-Premises)","English\\Configuring\\p6_eppm_weblogic_config\\93156.htm");
Page[316]=new Array("A domain can include multiple WebLogic Server clusters and non-clustered WebLogic Server instances. A minimal domain can contain only one WebLogic Server instance, which functions both as an Administration Server, and as a Managed server&#8212;such a domain can be useful while developing applications, but is not recommended for use in a production environment. Although the scope and purpose of a domain can vary significantly, most WebLogic Server domains contain the components described in this section.","By default, the WebLogic domain created by the P6 EPPM Configuration Wizard creates a domain with an administration server (AdminServer) and a managed server for each application that you deploy.","Starting and Stopping the Domain<br /> (Primavera P6 EPPM WebLogic Configuration Guide for On-Premises)","English\\Configuring\\p6_eppm_weblogic_config\\93157.htm");
Page[317]=new Array("To start WebLogic:","Navigate to the weblogic_home/user_projects/domains/your_domain directory.","Run startWeblogic.cmd (with Windows) startWeblogic.sh (with UNIX).","If prompted for a user name and password in the WebLogic console window, enter the administrative user name and password you specified when creating the domain.","Note If you enabled the WebLogic precompile option, the WebLogic console displays &quot;Server started in RUNNING mode&quot; when precompiling finishes. For detailed information about enabling precompilation, see your WebLogic Server documentation.","Starting the Domain<br /> (Primavera P6 EPPM WebLogic Configuration Guide for On-Premises)","English\\Configuring\\p6_eppm_weblogic_config\\41666.htm");
Page[318]=new Array("To stop WebLogic:","Navigate to &lt;WebLogic_Home&gt;/user_projects/domain/&lt;P6_EPPM_Domain&gt;/bin.","Where:","&lt;WebLogic_Home&gt; is the WebLogic home directory. The default is Oracle/Middleware/Oracle_Home. ","&lt;P6_EPPM_Domain&gt; is the WebLogic domain for P6 EPPM that was set during configuration.","Run stopWeblogic.sh.","If prompted for a user name and password in the WebLogic console window, enter  the administrative user name and password you specified when creating the domain.","Stopping the Domain<br /> (Primavera P6 EPPM WebLogic Configuration Guide for On-Premises)","English\\Configuring\\p6_eppm_weblogic_config\\93076.htm");
Page[319]=new Array("You have several options for starting and stopping managed servers. Oracle recommends that you use the startNodeManager file and start the server in the WebLogic Administration Console (see Starting a Managed Server). However, you can view other ways to stop and start managed servers at &quot;Managing Server Startup and Shutdown for Oracle WebLogic Server&quot; at https://docs.oracle.com/middleware/1221/wls/START/overview.htm.","Note You can use different ways to start the managed servers, but you must ensure that the managed servers recognize the arguments required for your application (for example, the argument for where the bootstrap is located) and how the application environment will start.","Starting and Stopping Managed Servers<br /> (Primavera P6 EPPM WebLogic Configuration Guide for On-Premises)","English\\Configuring\\p6_eppm_weblogic_config\\48157.htm");
Page[320]=new Array("Note When starting/stopping an environment using the node manager, the StartScriptEnabled setting in the nodemanager.properties file must equal true. Example: StartScriptEnabled=true","To start a managed server in the WebLogic Administration Console:","Run one of the following:","(with Windows)","&lt;weblogic_home&gt;\\server\\bin\\startNodeManager.cmd","(with UNIX or Linux)","&lt;weblogic_home&gt;\\server\\bin\\startNodeManager.sh","Launch the WebLogic Administration Console.","Note You can open the Administration Console via a web browser at http://&lt;serverIP&gt;:&lt;listenport&gt;/console. The default &lt;listenport&gt; is 7001.","In the Welcome&nbsp;window, log in using the user name and password that you created when you created your WebLogic domain.","On the Change Center pane of the Administration Console, click Lock &amp; Edit.","In the Domain Structure pane:","Expand Environment.","Click Servers.","In the Summary of Servers pane:","Select the Control tab.","Select the option for your managed server.","Click Start.","In the Server Life Cycle Assistant pane, click Yes.","In the Summary of Servers pane, click the 'Start Refresh' icon in the middle of the pane to see when the State column says 'RUNNING.'","Starting a Managed Server<br /> (Primavera P6 EPPM WebLogic Configuration Guide for On-Premises)","English\\Configuring\\p6_eppm_weblogic_config\\50104.htm");
Page[321]=new Array("To stop a managed server:","In the Change Center pane, click Lock &amp; Edit.","In the Domain Structure&nbsp;pane, click Deployments.","In the Summary of Deployments&nbsp;pane, select the managed server that you want to stop.","In the Summary of Deployments&nbsp;pane, navigate to the Control tab and then complete the following:","Click the down arrow to the right of the Stop&nbsp;button.","Click one of the options to stop the managed server.","In the Start Application Assistant&nbsp;pane, click Yes.","In the Change Center pane, click Release Configuration.","Stopping a Managed Server<br /> (Primavera P6 EPPM WebLogic Configuration Guide for On-Premises)","English\\Configuring\\p6_eppm_weblogic_config\\50105.htm");
Page[322]=new Array("Node Manager is a Java utility that runs as a separate process from WebLogic Server and allows you to perform common operations for a managed server regardless of its location to the Administration Server. The WebLogic Scripting Tool (WLST) is a command-line scripting interface that system administrators use to monitor and manage WebLogic Server instances and domains.","Using the node manager and WLST is optional, but it provides benefits if your WebLogic Server environment hosts applications with high availability requirements. If you run the node manager on a machine that hosts managed servers, you can start and stop the managed servers remotely using the WebLogic Console or from the command line using WLST as a node manager client. Using the node manager and WLST to control a WebLogic domain will ensure you do not need to manually modify the domain file to pass customized application java parameters, which eliminates the risk of distorting the files.","Oracle recommends controlling a WebLogic Domain through the node manager for the P6 EPPM WebLogic domain, instead of using individual Windows services per administration and managed server. ","Note A node manager process is not associated with a specific WebLogic domain but with a machine. You can use the same node manager process to control server instances in any WebLogic Server domain as long as the server instances reside on the same machine as the node manager process. The node manager must run on each computer that hosts WebLogic server instances -- whether administration server or managed server -- that you want to control with the node manager.","Follow the steps in the following sections to control a WebLogic domain with the node manager. If you intend to control the node manager with Windows, refer to Using the WebLogic Scripting Tool on Windows. If you intend to control the node manager with Linux or UNIX, refer to Using the WebLogic Scripting Tool on Linux or UNIX.","For more information on the node manager and WLST, refer to the Oracle WebLogic server documentation.","Configuring the Node Manager to Start and Stop Servers<br /> (Primavera P6 EPPM WebLogic Configuration Guide for On-Premises)","English\\Configuring\\p6_eppm_weblogic_config\\65779.htm");
Page[323]=new Array("Refer to the following sections to configure the node manager with Windows.","Using the WebLogic Scripting Tool on Windows<br /> (Primavera P6 EPPM WebLogic Configuration Guide for On-Premises)","English\\Configuring\\p6_eppm_weblogic_config\\88383.htm");
Page[324]=new Array("In previous releases of WebLogic, a node manager process was not associated with a specific WebLogic domain but with a host machine. You used the same node manager process to control server instances in any WebLogic domain as long as the server instances resided on the same machine, a machine-scoped, per host node manager. In this release of WebLogic Server, the node manager is now configured individually, per domain, and each domain will contain a unique node manager process.","To install the node manager as a Windows service:","Log in to the WebLogic server with administrative privileges.","Modify the installNodeMgrSvc.cmd file so that it does not hard code the node manager hostname and port in the registry.","Browse to &lt;WebLogic_Server_Home&gt;\\server\\bin.","Open installNodeMgrSvc.cmd in a text editor.","Locate the following lines in the file:","set NODEMGR_HOST=localhost","set NODEMGR_PORT=5556","Note","If lines set NODEMGR_HOST=localhost and set NODEMGR_PORT=5556 do not exist, close the file and skip steps 2d and 2e.","Comment out the lines by adding @rem to the beginning of the lines. For example:","@rem set NODEMGR_HOST=localhost","@rem set NODEMGR_PORT=5556","Save the changes, and then close the file.","Browse to &lt;WebLogic_domain_home&gt;\\bin.","Open installNodeMgrSvc.cmd in a text editor.","Locate the following lines in the file:","set NODEMGR_HOST=localhost","set NODEMGR_PORT=5556","Comment out the lines by adding @rem to the beginning of the lines. For example:","@rem set NODEMGR_HOST=localhost","@rem set NODEMGR_PORT=5556","Save the changes, and then close the file.","Open the command window, and then complete the following steps:","Change the directory to &lt;WebLogic_domain_home&gt;\\bin.","Enter the following command:","installNodeMgrSvc.cmd","Close the command window.","Browse to Windows Services, and then start the Oracle WebLogic &lt;domain_name&gt; NodeManager service.","Starting the Node Manager with WebLogic<br /> (Primavera P6 EPPM WebLogic Configuration Guide for On-Premises)","English\\Configuring\\p6_eppm_weblogic_config\\89007.htm");
Page[325]=new Array("To automate the startup of the Admin and managed server using WLST:","Note If you are using P6 EPPM R8.2 or higher and you used the P6 EPPM Configuration Wizard to create the WebLogic domain, steps 1-6 below have already been completed.","Create a userConfigFile and userKeyFile:","Start the WebLogic Domain's AdminServer by launching weblogic_home\\user_projects\\domains\\your_domain\\bin\\startWebLogic.cmd.","Browse to the P6 home directory and create a new directory called scripts.","Open the command prompt.","Change the directory to weblogic_home\\user_projects\\domains\\your_domain\\bin. ","Run the following commands:","call ","setDomainEnv.cmd","java_home\\bin\\java.exe weblogic.WLST ","where java_home is the path to the JDK installed and being used by WebLogic.","Note If the &quot;java_home&quot; directory contains a space in the path, it should include quotations around the full path and executable being called. For example: &quot;C:\\Program Files\\Java\\jdk1.6.0_27\\bin\\java.exe&quot; weblogic.WLST","At the wls:/offline&gt; prompt, enter the following command:  ","connect('weblogic','password','AdminServerHostName:AdminServerPort')","where:","weblogic is the weblogic admin user for the domain","password is the password for the weblogic admin user for the domain","AdminServerHostName is the host name where administration server was installed","AdminServerPort is the port number of administration server","At the wls:/mydomain/serverConfig&gt; prompt, enter the following command:  ","storeUserConfig('p6home/scripts/primaveraConfig.secure', 'p6home/scripts/primaveraKeyfile.secure')","where p6home is the P6 home directory the you set during installation (for example, C:/p6home).","Enter y at the following prompt:","Creating the key file can reduce the security of your system if it is not kept in a secured location after it is created. Do you want to create the key file? y or n","Note Confirm that the following two files were created under the p6home/scripts directory: primaveraConfig.secure and primaveraKeyfile.secure. If these files were not created, repeat the previous steps.","Stop the WebLogic Domain's administration server from running by launching weblogic_home\\user_projects\\domains\\your_domain\\bin\\stopWebLogic.cmd.","Ensure that AdminServer is assigned to the machine created for the WebLogic Domain:","Browse to the weblogic_home\\user_projects\\domains\\your_domain\\config directory.","Make a copy of the config.xml file to back up the existing file.","Open the config.xml file with a text editor.","Search for the following: ","&lt;name&gt;AdminServer&lt;/name&gt;","Locate the &lt;/ssl&gt; element and add the following line under the element:","&lt;machine&gt;&lt;!--NameOfMachine--&gt;&lt;/machine&gt;","where &lt;!--NameOfMachine--&gt; is the name of the logical machine created for the WebLogic domain.","Note","If an &lt;/ssl&gt; element does not exist, locate and add the line &lt;machine&gt;&lt;!--NameOfMachine--&gt;&lt;/machine&gt; above the &lt;listen-address&gt; element.","If a &lt;machine&gt; element already exists for AdminServer, this step can be skipped.","Save and close the config.xml file.","Ensure the administration server and managed servers in the weblogic domain are configured with a boot.properties file for node manager startup:","Browse to the weblogic_home\\user_projects\\domains\\your_domain\\servers\\AdminServer\\data directory.","Check if you have a directory called nodemanager. If you do not, create a directory called nodemanager.","Create a text file in the nodemanager directory called boot.properties.","Open boot.properties using a text editor and add:","usename=&lt;werblogic&gt;","where &lt;weblogic&gt; is the Administrator user created for the WebLogic domain.","password=&lt;password&gt;","where &lt;password&gt; is the password for the Administrator user created for the WebLogic domain","Save and close the file.","Repeat steps a &#8211; e for every managed server in the domain.","Example path: ","weblogic_home\\user_projects\\domains\\your_domain\\servers\\&lt;NameOfManagedServer&gt;\\data","Note The username and password variables will become encrypted in the boot.properties file the first time the servers start using the node manager.","Create a text file in the p6home/scripts directory called start_primavera.py (this is also known as a python file).","Open start_primavera.py using a text editor and add the following 6 lines (each line should be entered as a single line):","nmConnect(userConfigFile='p6home/scripts/primaveraConfig.secure',userKeyFile='p6home/scripts/primaveraKeyfile.secure',host='NodeMangerHost',port='5556',domainName='Mydomain',domainDir='DomainLocation',nmType='ssl')","arg = &quot;Arguments=\\&quot; -server -Xms128m -Xmx512m -XX:MaxPermSize=256m \\&quot;&quot;","prps = makePropertiesObject (arg)","nmStart('AdminServer',props=prps)","connect(userConfigFile='p6home/scripts/primaveraConfig.secure',userKeyFile='p6home/scripts/primaveraKeyfile.secure',url='t3://Adminserverhost:Adminserverport')","start('myManagedServer')","where: ","p6home is the home directory for one of the P6 EPPM applications. For example:  C:/p6home","NodeManagerHost is the hostname where the node manager is installed","Adminserverhost is the hostname where the administration server is running","Adminserverport is the port number of the administration server (default is 7001)","Mydomain is the name of the WebLogic domain","DomainLocation is the path to the WebLogic domain (C:/Oracle/Middleware/user_projects/domains/your_domain)","AdminServer is the Logical Name of the administration server","myManagedServer is the Logical Name of the managed server","Note If multiple managed servers exist, repeat the line &#8216;start(&#8216;myManagedServer')' with the name of each managed server.","Save and close the file.","Create a command file that will call the Python script you created above:","Open a text editor and enter the following lines:","SETLOCAL","SET CLASSPATH=","call weblogic_home\\user_projects\\domains\\your_domain\\bin\\setDomainEnv.cmd","call java_home\\bin\\java.exe weblogic.WLST p6home\\scripts\\start_primavera.py","where:","weblogic_home is the WebLogic Server home directory. The default is C:\\Oracle\\Middleware","your_domain is the domain name directory in your environment","java_home is the path to the JDK installed and being used by WebLogic","p6home is the home directory for the P6 EPPM folder containing the scripts directory. For example: C:\\p6home","Note If the &quot;java_home&quot;, &quot;p6home&quot; or &quot;weblogic_home&quot; directories contain a space in the path, it should include quotations around the full path and executable/command file being called. For example: call &quot;C:\\Program Files\\Java\\jdk1.6.0_27\\bin\\java.exe&quot; weblogic.WLST C:\\P6WebAccess\\scripts\\start_primavera.py","Save the file in the p6home\\scripts directory with the following name: start_primavera.bat.","Starting an Administration and Managed Servers Using WLST With Node Manager<br /> (Primavera P6 EPPM WebLogic Configuration Guide for On-Premises)","English\\Configuring\\p6_eppm_weblogic_config\\65782.htm");
Page[326]=new Array("To add the start_primavera.bat file to the Windows Task Scheduler:","Browse to Start, All Programs, Accessories, System Tools, Task Scheduler.","Under Actions, select Create Task.","Under the Create Task, General tab:","Provide a name for the Scheduled Task.","Provide a description of the Scheduled Task","Select Change User or Group.","Under Security Options in the Enter the object name to select field, enter System and click OK.","Select Run with the highest privileges.","Under the Create Task, Trigger tab:","Select New.","In the Begin the task list, select At Startup.","Under Advanced Settings, select Enabled.","Select OK.","Under the Create Task, Actions tab:","In the Action list, select Start a program. ","In the program/script field, browse to the start_primavera.bat file.","Select OK.","View the scheduled task by selecting Task Scheduler Library.","Adding the start_primavera.bat to the Windows Task Scheduler<br /> (Primavera P6 EPPM WebLogic Configuration Guide for On-Premises)","English\\Configuring\\p6_eppm_weblogic_config\\65807.htm");
Page[327]=new Array("Oracle recommends executing the start_primavera.bat file using the command prompt before running it through the scheduled task window so you can identify and resolve issues that occur after you create the batch file and python script. See Troubleshooting for common issues that can occur after you create the batch file and python script.","To run start_primavera.bat:","Browse to Start, Run.","In the Run window, enter cmd.","Select OK to open the command prompt.","Enter the following:  ","p6home\\scripts\\start_primavera.bat","where p6home is the home directory for one of the P6 EPPM applications. For example: C:\\p6home","Note","Each Java process that loads should run under the SYSTEM account. ","Later, if the start_primavera.bat file is not run automatically through the scheduled task, you can run it directly or run it manually using the Windows Task Scheduler.","Executing the start_primavera.bat file<br /> (Primavera P6 EPPM WebLogic Configuration Guide for On-Premises)","English\\Configuring\\p6_eppm_weblogic_config\\65870.htm");
Page[328]=new Array("To stop the WebLogic domain with WebLogic Scripting:","Create a text file in the p6home/scripts directory called stop_primavera.py.","Open stop_primavera.py using a text editor and enter the following lines:","Note You must indent the commands under &quot;try&quot; and &quot;except&quot;.","print('PRM-Stopping Primavera administration server, managed servers, and deployments')","print('PRM-This will NOT attempt to stop the node manager as it may be')","print('PRM-needed for other servers on this machine.')","connect(userConfigFile= ' p6home/scripts/primaveraConfig.secure',userKeyFile='p6home/scripts/primaveraKeyfile.secure',url='t3://Adminserverhost:Adminserverport') ","try:","   print('PRM-Shutting down managed server myManagedServer') ","   shutdown('myManagedServer','Server','true',100,'true')","except:","   print('PRM-Failed to stop managed server myManagedServer')","try:","   print('PRM-Shutting down AdminServer') ","   shutdown('AdminServer','Server','true',100,'true')","except:","   print('PRM-Failed to stop AdminServer')","print('PRM-Shutdown Complete')","exit() ","where: ","p6home is the home directory for one of the P6 EPPM applications. For example: C:\\p6home ","Adminserverhost is the hostname where the administration server is running ","Adminserverport is the port number of the administration server (default is 7001) ","myManagedServer is the Logical Name of the managed server","AdminServer is the Logical Name of the administration server ","If multiple managed servers exist, repeat the following lines from above with the name of each managed server:","Note You must indent the commands under &quot;try&quot; and &quot;except&quot;.","try:","   print('PRM-Shutting down managed server myManagedServer') ","   shutdown('myManagedServer','Server','true',100,'true')","except:","   print('PRM-Failed to stop managed server myManagedServer')","Save and close the file.","Browse to &lt;P6_EPPM_Home&gt;\\scripts and then create a text file called stop_primavera.bat.","Edit stop_primavera.bat and then add the following lines:  ","SETLOCAL","SET CLASSPATH=","call weblogic_home\\user_projects\\domains\\your_domain\\bin\\setDomainEnv.cmd ","call java_home\\bin\\java.exe weblogic.WLST p6home\\scripts\\stop_primavera.py ","where: ","weblogic_home is the WebLogic Server home directory. The default is C:\\Oracle\\Middleware ","your_domain is the domain name directory in your environment ","java_home is the path to the JDK installed and being used by WebLogic ","p6home is the home directory for the P6 EPPM folder containing the scripts directory. For example: C:\\p6home ","Note If the &quot;java_home&quot;, &quot;p6home&quot; or &quot;weblogic_home&quot; directories contain a space in the path, it should include quotations around the full path and executable/command file being called. For example: call &quot;C:\\Program Files\\Java\\jdk1.6.0_27\\bin\\java.exe&quot; weblogic.WLST C:\\P6WebAccess\\scripts\\start_primavera.py","Save and close the file.","Using WebLogic Scripting to Stop the WebLogic Domain for P6 EPPM<br /> (Primavera P6 EPPM WebLogic Configuration Guide for On-Premises)","English\\Configuring\\p6_eppm_weblogic_config\\65834.htm");
Page[329]=new Array("To troubleshoot the following start_primavera.bat error: ","WLSTException: Error occured while performing nmConnect : Cannot connect to Node Manager. : Access to domain '&lt;domainName&gt;' for user &#8216;&lt;username&gt;' denied.","Ensure that the userConfigFile and userKeyFile variables entered in the start_primavera.py file point to a valid path and file name for the primaveraConfig.secure and primaveraKeyfile.secure files.","Ensure that the node manager username and password are correct:","Start the AdminServer for the WebLogic Domain.","Launch the WebLogic Administrative Console.","In the Change Center&nbsp;pane of the Administration Console, click Lock &amp; Edit.","Under the Domain Structure pane, select the link for your domain name.","Select the Security tab and then select the Advanced Options link.","Enter the valid credentials in the console for NodeManager username and NodeManager password.","Activate the changes. ","Logout of the WebLogic Administrative Console.","Stop the AdminServer for the WebLogic Domain.","Retry executing the start_primavera.bat file.","For the following error, the managed server did not start using the Node Manager and you need to create a startup.properties file before you can start the managed server using WLST Scripting.","weblogic.management.ManagementException: Booting as administration server, but servername, &lt;ManagedServerName&gt;, does not match the administration server name, AdminServer.","To create a startup.properties file:","Start the AdminServer for the WebLogic Domain.","Launch the WebLogic Administrative Console.","Under the Domain Structure pane, select 'servers' link.","On the Servers page, select the Control tab.","Select Startup.","Once the server is in a running state, on the Servers page, select the Control tab.","Select Shutdown.","Verify the startup.properties file is in the weblogic_home\\user_projects\\domains\\&lt;domain&gt;\\servers\\&lt;managedServer&gt;\\data\\nodemanager directory. You can now startup through the WebLogic scripting files.","Troubleshooting<br /> (Primavera P6 EPPM WebLogic Configuration Guide for On-Premises)","English\\Configuring\\p6_eppm_weblogic_config\\65860.htm");
Page[330]=new Array("Refer to the following sections to configure the node manager with Linux or UNIX.","Using the WebLogic Scripting Tool on Linux or UNIX<br /> (Primavera P6 EPPM WebLogic Configuration Guide for On-Premises)","English\\Configuring\\p6_eppm_weblogic_config\\88384.htm");
Page[331]=new Array("In order to automate the startup of the administration server and managed servers of your P6 EPPM deployment, you must create a configuration (userConfigFile) and key (userKeyFile) file. For more information about configuration and key files, refer to the Oracle Fusion Middleware Command Reference for Oracle WebLogic Server guide.","To create a configuration and key file:","Start the WebLogic Domain's Administration Server by launching startWebLogic.shfrom &lt;WebLogic_Home&gt;/user_projects/domains/&lt;P6_EPPM_Domain&gt;/bin/","Where:","&lt;WebLogic_Home&gt; is the WebLogic home directory. The default is Oracle/Middleware/Oracle_Home.","&lt;P6_EPPM_Domain&gt; is the WebLogic domain for P6 EPPM that was set during configuration.","Browse to the P6 home directory and create a new directory called scripts.","Open the terminal console and run the following commands:","cd &lt;WebLogic_Home&gt;/user_projects/domains/&lt;P6_EPPM_Domain&gt;/bin","source setDomainEnv.sh","&lt;Java_Home&gt;/bin/java.exe weblogic.WLST","Note If the &lt;Java_Home&gt; directory contains a space in the path, it should include quotations around the full path and executable being called.","Where:","&lt;Java_Home&gt; is the path to the JDK that is used by WebLogic.","&lt;WebLogic_Home&gt; is the WebLogic home directory. The default is Oracle/Middleware/Oracle_Home.","&lt;P6_EPPM_Domain&gt; is the WebLogic domain for P6 EPPM that was set during configuration.","At the wls:/offline&gt; prompt, enter the following command:  ","connect('&lt;WebLogic_Username&gt;','&lt;WebLogic_User_Password&gt;','&lt;Admin_Server_Hostname&gt;:&lt;Admin_Server_Port&gt;')","Where:","&lt;WebLogic_Username&gt; is the name of the WebLogic administrator user for the domain.","&lt;WebLogic_Password&gt; is the password for the weblogic administrator.","&lt;Admin_Server_Hostname&gt; is the hostname where the administration server was installed.","&lt;Admin_Server_Port&gt; is the port number of administration server.","At the wls:/mydomain/serverConfig&gt; prompt, enter the following command:  ","storeUserConfig('&lt;P6_EPPM_Home&gt;/scripts/primaveraConfig.secure', '&lt;P6_EPPM_Home&gt;/scripts/primaveraKeyfile.secure') ","Where: &lt;P6_EPPM_Home&gt; is the P6 EPPM home directory that was set during installation.","Enter y at the following prompt:","Creating the key file can reduce the security of your system if it is not kept in a secured location after it is created. Do you want to create the key file? y or n","Confirm that the following two files were created under the &lt;P6_EPPM_Home&gt;/scripts directory: ","primaveraConfig.secure and primaveraKeyfile.secure","If these files were not created, repeat the previous steps.","Creating a Configuration and Key File<br /> (Primavera P6 EPPM WebLogic Configuration Guide for On-Premises)","English\\Configuring\\p6_eppm_weblogic_config\\93026.htm");
Page[332]=new Array("If a &lt;machine&gt; element already exists for AdminServer, this procedure can be skipped.","To associate the administration server with machines on the P6 EPPM domain:","Browse to the &lt;Weblogic_Home&gt;\\user_projects\\domains\\&lt;P6_EPPM_Domain&gt;\\config.","Make a copy of config.xml as a back up of the existing file.","Open config.xml with a text editor.","Search for &lt;name&gt;AdminServer&lt;/name&gt;.","Locate the &lt;/ssl&gt; element and then add the following line beneath it:","&lt;machine&gt;&lt;!--Machine_Name--&gt;&lt;/machine&gt;","Note If an &lt;/ssl&gt; element does not exist, locate and add the line &lt;machine&gt;&lt;Machine_Name&gt;&lt;/machine&gt; above the &lt;listen-address&gt; element.","Where:&lt;!--Machine_Name--&gt; is the logical name of the machine created for the WebLogic domain.","Save and close the file.","Associating the Administration Server with Machines on a P6 EPPM Domain<br /> (Primavera P6 EPPM WebLogic Configuration Guide for On-Premises)","English\\Configuring\\p6_eppm_weblogic_config\\93028.htm");
Page[333]=new Array("Ensure that the administration server and managed servers in the WebLogic domain are configured with a boot.properties file.","To create a boot.properties file for the administration and managed servers:","Browse the data directory of either the administration server or a managed server.","For example, &lt;Weblogic_Home&gt;\\user_projects\\domains\\&lt;P6_EPPM_Domain&gt;\\servers\\AdminServer\\data.","Check if you have a directory called nodemanager. If you do not, create a directory called nodemanager beneath the data directory.","Create a text file in the nodemanager directory called boot.properties.","Edit boot.properties and then add the following lines:","username=&lt;WebLogic_Username&gt;","password=&lt;WebLogic_Password&gt;","Note","&lt;WebLogic_Username&gt; is the name of the WebLogic administrator for the domain.","&lt;WebLogic_Password&gt; is the password for the weblogic administrator.","Save and close the file.","Repeat this procedure for the administration server and every managed server at &lt;WebLogic_Home&gt;\\user_projects\\domains\\&lt;P6_EPPM_Domain&gt;\\servers\\.","Note The username and password variables are encrypted in the boot.properties file the first time the servers start using the Node Manager.","Where:","&lt;WebLogic_Home&gt; is the WebLogic home directory. The default is Oracle/Middleware/Oracle_Home. ","&lt;P6_EPPM_Domain&gt; is the WebLogic domain for P6 EPPM.","Configure a boot.properties File for the Administration and Managed Servers<br /> (Primavera P6 EPPM WebLogic Configuration Guide for On-Premises)","English\\Configuring\\p6_eppm_weblogic_config\\93029.htm");
Page[334]=new Array("To automate the startup of the Admin and managed server using WLST:","Browse to &lt;P6_EPPM_Home&gt;\\scripts and then create a text file called start_primavera.py.","Note &lt;P6_EPPM_Home&gt; is the P6 EPPM home directory that was set during installation.","Edit start_primavera.py and then add the following lines:","nmConnect(userConfigFile='&lt;P6_EPPM_Home&gt;/scripts/primaveraConfig.secure',userKeyFile='&lt;P6_EPPM_Home&gt;/scripts/primaveraKeyfile.secure',host='&lt;Node_Manager_Hostname&gt;',port='5556',domainName='&lt;P6_EPPM_Domain&gt;',domainDir='&lt;Domain_Path&gt;',nmType='ssl')","arg = &quot;Arguments=\\&quot; -server -Xms128m -Xmx512m -XX:MaxPermSize=256m \\&quot;&quot;","prps = makePropertiesObject (arg)","nmStart('AdminServer',props=prps)","connect(userConfigFile='&lt;P6_EPPM_Home&gt;/scripts/primaveraConfig.secure',userKeyFile='&lt;P6_EPPM_Home&gt;/scripts/primaveraKeyfile.secure',url='t3://&lt;Admin_Server_Hostname&gt;:&lt;Admin_Server_Port&gt;')","start('&lt;Managed_Server_Name&gt;')","#If multiple managed servers exist, repeat the previous line for each managed server.","Where:","&lt;P6_EPPM_Home&gt; is the P6 EPPM home directory that was set during installation.","&lt;Node_Manager_Hostname&gt; is the name of the host where the Node Manager is running.","&lt;Admin_Server_Hostname&gt; is the name of the host where the administration server was installed.","&lt;Admin_Server_Port&gt; is the port number of administration server. The default is 7001.","&lt;P6_EPPM_Domain&gt; is the WebLogic domain for P6 EPPM that was set during configuration.","&lt;Domain_Path&gt; is the full path to the P6 EPPM domain. For example, &lt;WebLogic_Home&gt;\\user_projects\\domains\\&lt;P6_EPPM_Domain&gt;","&lt;Managed_Server_Name&gt; is the logical name of the managed server. The default managed server names for P6 EPPM are P6, P6IntegrationAPI, p6procloudconnect, P6WebServices, and TeamMember.","Save and close the file.","Browse to &lt;P6_EPPM_Home&gt;\\scripts and then create a text file called start_primavera.sh.","Edit start_primavera.sh and then add the following lines:","export CLASSPATH=","&lt;weblogic_home&gt;/wlserver/server/bin/setWLSEnv.sh","&lt;Java_Home&gt;/bin/java weblogic.WLST &lt;P6_EPPM_Home&gt;/scripts/start_primavera.py ","Where:","&lt;WebLogic_Home&gt; is the WebLogic home directory. The default is Oracle/Middleware/Oracle_Home. ","&lt;Java_Home&gt; is the path to the JDK that is used by WebLogic.","&lt;P6_EPPM_Home&gt; is the P6 EPPM home directory that was set during installation.","Save and close the file.","Using WebLogic Scripting to Start the P6 EPPM WebLogic Domain<br /> (Primavera P6 EPPM WebLogic Configuration Guide for On-Premises)","English\\Configuring\\p6_eppm_weblogic_config\\93022.htm");
Page[335]=new Array("To stop the WebLogic domain with WebLogic Scripting:","Browse to &lt;P6_EPPM_Home&gt;\\scripts and then create a text file called stop_primavera.py.","Note &lt;P6_EPPM_Home&gt; is the P6 home directory that was set during installation.","Edit stop_primavera.py and then add the following lines:","print('Stopping Primavera servers. This will not stop the Node Manager because it may be needed for other servers.')","scripts_dir='&lt;P6_EPPM_Home&gt;/scripts'","adminserver_host='&lt;Admin_Server_Hostname&gt;'","adminserver_port='&lt;Admin_Server_Port&gt;'","&lt;Managed_Server_Variable&gt;='&lt;Managed_Server_Name&gt;'","# Create a variable, similar to the one above, for each managed server in the P6 EPPM domain.","connect(userConfigFile=scripts_dir+'/primaveraConfig.secure',userKeyFile=scripts_dir+'/primaveraKeyfile.secure',url='t3://'+adminserver_host+':'+adminserver_port)","# The following section of the script tries to shutdown a managed server. Copy and modify this section of the script for each managed server in the P6 EPPM domain.","try:","  print('PRM-Shutting down the managed server for &lt;Managed_Server_Variable&gt;')  ","  shutdown(&lt;Managed_Server_Variable&gt;,'Server','true',100,'true')","except:","  print('PRM-Failed to stop managed server: ' + &lt;Managed_Server_Variable&gt;)","# The following section of the script tries to shutdown the administration server.","try:","  print('PRM-Shutting down &lt;Admin_Server_Name&gt;.')","  shutdown('&lt;Admin_Server_Name&gt;','Server','true',100,'true')","except:","  print('PRM-Failed to stop &lt;Admin_Server_Name&gt;.')","print('PRM-Shutdown Complete')","exit()","Note","&lt;P6_EPPM_Home&gt; is the P6 EPPM home directory that was set during installation.","&lt;Admin_Server_Hostname&gt; is the name of the host where the administration server was installed. ","&lt;Admin_Server_Port&gt; is the port number of administration server. The default is 7001.","&lt;Managed_Server_Variable&gt; is the variable that you created for a P6 EPPM application.","&lt;Managed_Server_Name&gt; is the logical name of the managed server. The default managed server names for P6 EPPM are P6, P6IntegrationAPI, p6procloudconnect, P6WebServices, and TeamMember.","&lt;Admin_Server_Name&gt;is the logical name of the administration server. The default is AdminServer.","Save and close the file.","Browse to &lt;P6_EPPM_Home&gt;\\scripts and then create a text file called stop_primavera.sh.","Edit stop_primavera.sh and then add the following lines:","export CLASSPATH=","&lt;WebLogic_Home&gt;/wlserver/server/bin/setWLSEnv.sh &lt;Java_Home&gt;/bin/java weblogic.WLST &lt;P6_EPPM_Home&gt;/scripts/stop_primavera.py","Note","&lt;WebLogic_Home&gt; is the WebLogic home directory. The default is Oracle/Middleware/Oracle_Home. ","&lt;Java_Home&gt; is the path to the JDK that is used by WebLogic.","&lt;P6_EPPM_Home&gt; is the P6 EPPM home directory that was set during installation..","Save and close the file.","Using WebLogic Scripting to Stop the WebLogic Domain for P6 EPPM<br /> (Primavera P6 EPPM WebLogic Configuration Guide for On-Premises)","English\\Configuring\\p6_eppm_weblogic_config\\88386.htm");
Page[336]=new Array("This section explains how to configure the P6 EPPM domain, when installed on Linux, as a daemon process through systemd. If your WebLogic server implementation already includes a Node Manager daemon process, uninstall it prior to completing this instruction. For more information about systemd, refer to your operating system documentation.","To daemonize the Node Manager and your P6 EPPM applications:","Open a terminal and log in to the system as a super user (root user) or as a user with sudo access.","Change the directory to the following location: ","/etc/systemd/system","Create a service file called wlsnodemgr.service.","Edit wlsnodemgr.service and add the following lines:","[Unit]","Description=WebLogic nodemanager service","After=network.target nss-lookup.target remote-fs.target","Wants=nss-lookup.target remote-fs.target","Before=p6eppm.service","[Service]","Type=simple","Environment=WebLogic_Home=&lt;WebLogic_Home_Path&gt;","Environment=P6_EPPM_Domain=${WebLogic_Home}/user_projects/domains/&lt;P6_EPPM_Domain_Name&gt;","Environment=NodeMgr_Log_File=&lt;NodeMgr_Log_Path&gt;/wlsnodemgr.log","ExecStart=/bin/bash -c './${P6_EPPM_Domain}/bin/startNodeManager.sh &gt; $NodeMgr_Log_File'","ExecStop=/bin/bash -c './${P6_EPPM_Domain}/bin/stopNodeManager.sh &gt; $NodeMgr_Log_File'","RemainAfterExit=yes","User=&lt;Linux_User&gt;","Group=&lt;Linux_Group&gt;","KillMode=process","LimitNOFILE=65535","TimeoutStartSec=120","[Install]","WantedBy=multi-user.target","Where:","&lt;WebLogic_Home_Path&gt; is the WebLogic home directory.","&lt;P6_EPPM_Domain_Name&gt; is the WebLogic domain name for P6 EPPM that was set during configuration/installation of Primavera P6","&lt;NodeMgr_Log_Path&gt; is the log path where the start and stop processes write their logs. You can use any location. ","&lt;Linux_User&gt; is the Linux user to associate with and run the daemon process.","&lt;Linux_Group&gt; is the Linux user group to associate with and run the daemon process.","Save and close the file.","Create a service file called p6eppm.service.","Edit the p6eppm.service and add the following lines:","[Unit]","Description=P6 EPPM service","After=wlsnodemgr.service","Requires=wlsnodemgr.service","BindsTo=wlsnodemgr.service","[Service]","Type=simple","Environment=P6_Log_File=&lt;P6_Log _Path&gt;/p6.log","Environment=P6_EPPM_Home=&lt;P6_EPPM_Home&gt;","ExecStart=/bin/bash -c './${P6_EPPM_Home}/scripts/start_Primavera.sh &gt; $P6_Log_File'","RemainAfterExit=yes","ExecStop=/bin/bash -c './${P6_EPPM_Home}/scripts/stop_Primavera.sh &gt; $P6_Log_File'","User=&lt;Linux_User&gt;","Group=&lt;Linux_Group&gt;","KillMode=process","TimeoutStartSec=1200","[Install]","WantedBy=multi-user.target","Where:","&lt;P6_EPPM_Home&gt; is the P6 EPPM home directory that was set during installation.","&lt;P6_Log _Path&gt; is the log path where the start and stop processes write their logs. You can use any location.","&lt;Linux_User&gt; is the Linux user you to associate with and run the daemon process.","&lt;Linux_Group&gt; is the Linux user group to associate with and run the daemon process.","Save and close the file.","Enable the services, by running:","sudo systemctl enable wlsnodemgr p6eppm","Reload the Services, by running:","sudo systemctl daemon-reload","Check the Status of the services and logs, by running:","sudo systemctl status wlsnodemgr ","sudo systemctl status p6eppm","Note The output shows - Active: inactive (dead) first time and shows - Active: active (running) after reboot of server or after manual start.","Once you have created the services, you can:","Check the start and stop logs, by running:","cat &lt;NodeMgr_Log_Path&gt;/wlsnodemgr.log ","cat &lt;P6_Log _Path&gt;/p6.log","Stop the service, by running: sudo systemctl stop p6eppm wlsnodemgr","Start the service, by running: sudo systemctl start wlsnodemgr p6eppm","Disable the service, by running: sudo systemctl disable wlsnodemgr p6eppm","Restart the service, by running: sudo systemctl restart wlsnodemgr p6eppm","Daemonizing the P6 EPPM WebLogic Domain Processes<br /> (Primavera P6 EPPM WebLogic Configuration Guide for On-Premises)","English\\Configuring\\p6_eppm_weblogic_config\\93037.htm");
Page[337]=new Array("To start the Node Manager with WebLogic:","Open a terminal console.","Run startNodeManager.sh from the bin folder of the P6 EPPM domain by using the following scripts:","cd &lt;WebLogic_Home&gt;/user_projects/domains/&lt;P6_EPPM_Domain&gt;/bin","./startNodeManager","Where:","&lt;WebLogic_Home&gt; is the WebLogic home directory. The default is Oracle/Middleware/Oracle_Home.","&lt;P6_EPPM_Domain&gt; is the WebLogic domain for P6 EPPM that was set during configuration.","Starting the Node Manager with WebLogic<br /> (Primavera P6 EPPM WebLogic Configuration Guide for On-Premises)","English\\Configuring\\p6_eppm_weblogic_config\\93021.htm");
Page[338]=new Array("You can set the WebLogic node manager as a windows service in your production environments.","To set up node manager as a windows service:","Stop any running instances of the WebLogic node manager.","Navigate to the WebLogic Server installation home directory, then navigate to server\\bin.","In the server\\bin folder modify the installNodeMgrSvc.cmd file using a text editor of your choice, and comment out the following lines:","Note Add @REM at the beginning of a line to comment out the line.","set NODEMGR_HOST=localhost","set NODEMGR_PORT=5556","Run the installNodeMgrSvc.cmd file to create the node manager windows service.","Note To modify the port number on which node manager runs, navigate to the WebLogic Server installation home directory, then navigate to common\\nodemanager. Open the nodemanager.properties file in a text editor of your choice and set the value of ListenPort to the port number you'd like to use in your environment.","Setting the Node Manager as a Windows Service<br /> (Primavera P6 EPPM WebLogic Configuration Guide for On-Premises)","English\\Configuring\\p6_eppm_weblogic_config\\94260.htm");
Page[339]=new Array("If you would like to receive notification when events occur, you must configure the JMS message queue and P6 to send the events in which you are interested.","To configure your environment to support notification:","Configure the WebLogic message queue:","(Optional) Target the JMS server to a migratable target. See Targeting the JMS Server to a Migratable Target","Determine if the WebLogic message queue will be on the same domain as P6.","See Configuring the WebLogic Message Queue if the queue and the application are on the same domain.","See Sending Events to a Remote WebLogic JMS Server if the queue and the application are on different domains.","(Optional) Configure the message queue security policy. See Configuring the Security Policy for the WebLogic Message Queue.","Configure the application settings in P6 to send event notification. See Configuring Eventing in P6.","An event may be one of two types, a business object event or a special operation event.","Configuring your Environment<br /> (Primavera P6 EPPM WebLogic Configuration Guide for On-Premises)","English\\Configuring\\p6_eppm_weblogic_config\\46783.htm");
Page[340]=new Array("JMS-related services are hosted on individual server instances within a cluster and for these services, the WebLogic Server migration framework supports failure recovery with service migration, as opposed to failover. In a clustered server environment, a recommended best practice is to target the JMS server to a migratable target, so that a member server will not be a single point of failure. Therefore, the following prerequisite instruction is required if configuring The WebLogic Message Queue In A Cluster.","Note The instruction below assumes the WebLogic domain being configured has managed servers already created and assigned to a cluster parameter.","Configure the cluster migration Basis to Consensus:","Log in into the WebLogic Administration console.","In the Change Center of the Administration Console, click Lock &amp; Edit.","Navigate to the following location under the Domain Structure:","Environment -&gt; Clusters -&gt; ClusterName -&gt; Migration","Locate the Migration Basis drop-down list and change its value to Consensus.","Select Save.","Select Active Changes.","Configure a migratable target for one of the managed servers in the cluster:","In the Change Center of the Administration Console, click Lock &amp; Edit.","In the Domain Structure tree, expand Environment, then select Migratable Targets.","On the Summary of Migratable Targets page, select the link for one of the managed servers in the list.","Select the migration tab:","In Service Migration Policy, select the Auto-Migrate Exactly-Once Services migration policy.","In Constrained Candidate Servers, move the user-preferred server and the additional managed servers in the cluster you want to support failure recovery from the Available column to the Chosen column.","Select Save.","In the Change Center of the Administration Console, click Active Changes.","Restart the Admin server and the managed servers in the cluster for changes to take effect.","Targeting the JMS Server to a Migratable Target<br /> (Primavera P6 EPPM WebLogic Configuration Guide for On-Premises)","English\\Configuring\\p6_eppm_weblogic_config\\88373.htm");
Page[341]=new Array("When an event is triggered, the P6 Event Notification system sends the event message to a message queue. To receive these notifications, you must first configure the message queue.","The following procedure indicates how to set up a WebLogic Java Messaging Service (JMS) message queue when the queue and P6 are on the same domain. See Sending Events to a Remote WebLogic JMS Server if the application and the queue are on different domains. For information about setting up other JMS-based message queues, see the vendor documentation.","To set up the WebLogic JMS message queue:","In either a new or existing WebLogic domain, launch the WebLogic Administration Console if it is not already open.","In the WebLogic Administration Console:","Create a new JMS server and persistence store. See Creating a JMS Server and Persistence Store.","Create a JMS module. See Creating a JMS Module.","Create a new connection factory. See Creating a JMS Connection Factory.","Create a new queue or topic. See Creating a JMS Message Queue and Subdeployment to see how to create a new queue.","Note Create a queue to deliver a message to a specific group of users. Create a topic to distribute a message amongst several users.","Configuring the WebLogic Message Queue<br /> (Primavera P6 EPPM WebLogic Configuration Guide for On-Premises)","English\\Configuring\\p6_eppm_weblogic_config\\38437.htm");
Page[342]=new Array("Create a JMS server to hold queues and topics.","To create a JMS server and persistence store:","If it is not already open, launch the WebLogic Administration Console on the remote or local server.","In the WebLogic Administration Console, expand Services/Messaging and click JMS Servers in the Domain Structure pane.","On the Summary of JMS Servers page, click New.","On the Create a New JMS Server page:","Under JMS Server Properties:","Enter a name in the Name field.","Click Create a New Store.","Under Select a store type, select File Store from the Type list and click Next.","Under File Store Properties:","Enter a name in the Name field.","Select a server instance from the Target list.","Note If you are configuring the WebLogic Message Queue in a cluster, select the migratable target you configured earlier.","Specify a location for the file store in the Directory field. ","This location must already exist on your machine and you must have read/write rights to this folder. No error messages appear on the WebLogic console if the filestore is not configured correctly.","Click OK.","Under JMS Server Properties, select the new store from the Persistent Store list and click Next.","Under Select Targets:","If you are deploying to a standalone server, select the administration server (for example, AdminServer) as the target from the Target list and click Finish.  ","If you are deploying to a cluster, select the migratable target configured earlier.","Creating a JMS Server and Persistence Store<br /> (Primavera P6 EPPM WebLogic Configuration Guide for On-Premises)","English\\Configuring\\p6_eppm_weblogic_config\\46942.htm");
Page[343]=new Array("Create a JMS module to manage and configure resources.","To create a JMS module:","If it is not already open, launch the WebLogic Administration Console on the remote or local server.","In the WebLogic Administration Console, expand Services/Messaging and click JMS Modules in the Domain Structure pane.","On the JMS Modules page, click New.","On the Create JMS System Module page:","Under The following properties will be used to identify your new module, enter a name in the Name field and click Next.","Note Make a note of this name, you will need to know which module to expand in the Configuring the Security Policy for the WebLogic Message Queue topic.","Under The following properties will be used to target your new JMS system module, select a target server in the Servers box and click Next.","Note If you are deploying to a cluster, select the cluster from the targets list.","Under Add resources to this JMS system module, select the Would you like to add resources to this JMS system module option and click Finish.","Creating a JMS Module<br /> (Primavera P6 EPPM WebLogic Configuration Guide for On-Premises)","English\\Configuring\\p6_eppm_weblogic_config\\46937.htm");
Page[344]=new Array("Create a connection factory to enable connections between your JMS elements.","To create a JMS connection factory:","Log in to the WebLogic Administration Console.","In the WebLogic Administration Console, expand Services/Messaging and click JMS Modules in the Domain Structure pane.","On the JMS Modules page, select the module to which you want to add the connection factory.","On the Settings page, click the Configuration tab and under Summary of Resources click New.","On the Create a New JMS System Module Resource page:","Under Choose the type of resource you want to create, select the Connection Factory option and click Next.","Under Connection Factory Properties:","Enter a name for the connection factory in the Name field.","Enter a name in the JNDI field.","Note Make note of the JNDI name. You will need to enter this name in the JMS Connection Factory field of P6 Application Settings Eventing page. If you are using a remote server, you will need to enter this name in the Remote JNDI Name field on the Connection Factories tab in the Creating a Foreign JMS Server topic.","Click Next.","Under The following properties will be used to target your new JMS system moduleresource, ensure the correct server is targeted and click Finish.","Note If you are deploying to a cluster, the cluster should be selected as the target.","Creating a JMS Connection Factory<br /> (Primavera P6 EPPM WebLogic Configuration Guide for On-Premises)","English\\Configuring\\p6_eppm_weblogic_config\\46939.htm");
Page[345]=new Array("Create a message queue to act as a receptacle for event messages sent from P6.","To create a JMS message queue and subdeployment:","Log in to the WebLogic Administration Console.","In the WebLogic Administration Console, expand Services/Messaging and click JMS Modules in the Domain Structure pane.","On the JMS Modules page, select the module to which you want to add the queue.","On the Settings page, click the Configuration tab.","On the Configuration tab under Summary of Resources, click New.","On the Create a New JMS System Module Resource page:","Under Choose the type of resource you want to create, select the Queue option and click Next.","Under JMS Destination Properties:","Enter a name for the queue in the Name field.","Enter a name in the JNDI field.","Note  Make note of the JNDI name. You will need to enter this name in the JMS Destination Name field of the P6 Application Settings Eventing page. If you are using a remote server, you will need to enter this name in the Remote JNDI Name field on the Destinations tab in the Creating a Foreign JMS Server topic.","Click Next.","Under The following properties will be used to target your new JMS system module resource, click Create a New Subdeployment.","On the Create a New Subdeployment page, enter a name in the Subdeployment Name field and click OK.","On the Create a New JMS System Module Resource page:","Select the new subdeployment from the Subdeployments list.","Select the JMS server you created when creating the Persistence Store as the target from the JMS Servers box.","Click Finish.","Creating a JMS Message Queue and Subdeployment<br /> (Primavera P6 EPPM WebLogic Configuration Guide for On-Premises)","English\\Configuring\\p6_eppm_weblogic_config\\46936.htm");
Page[346]=new Array("Depending on administrative settings, events can be triggered when P6, P6 EPPM Web Services, or the P6 Integration API is used to update or create objects in the P6 database or when one of the special operations completes. When a business object change or special operation triggers an event, the P6 Event Notification system sends an event message to a user-configured message queue. If you are planning to use P6 Event Notification with P6 EPPM products, follow the steps below to configure the notification to work with your Java Messaging Service (JMS), the application server, and P6. Refer to the message queue vendor documentation.","Configuring Eventing in the Primavera P6 Administrator<br /> (Primavera P6 EPPM WebLogic Configuration Guide for On-Premises)","English\\Configuring\\p6_eppm_weblogic_config\\38438.htm");
Page[347]=new Array("If you want events to occur when business objects are created or updated, or when an operation is performed, you must configure Eventing page in the Application Settings of P6.","To configure the Eventing page:","Launch P6.","Click Administration.","On the Administration navigation bar, click Application Settings.","On the Application Settings page, click Eventing.","Click the General tab.","In the Eventing section:","Select Eventing.","Set additional settings as appropriate for your implementation. See Eventing Settings for details on available settings.","In the Directory Services section:","In the Provider URL field, enter the URL of the JNDI provider for the Connection Factory.","For example:","If you are using a standalone server: t3://&lt;Host_Name&gt;:&lt;Port&gt;","If you are using a cluster: t3://&lt;Host_Name_1&gt;:&lt;Port_1&gt;,&lt;Host_Name_2&gt;:&lt;Port_2&gt;","In the Initial Context Factory field, enter the class name of the initial context factory for the JNDI connection. For example, weblogic.jndi.WLInitialContextFactory.","In the Lookup Name field, enter the lookup used to test the directory connection. This can be the JNDI name of the JMS connection factory created earlier or the JMS destination.","In the Security Principal field, enter the principal to connect to the JNDI provider. If you are using WebLogic, this is the name of a WebLogic user.","In the Security Credentials field, enter the credentials to connect to the JNDI provider. If you are using WebLogic, this is the password for the WebLogic user you entered in the Security Principal field.","In the Security Level field, enter the security level to use when authenticating to the directory service.","Click the Configuration tab.","In the Business Objects section:","Expand a business object type and configure the options to determine the type of notifications you will receive.","Select or clear the Create option for an object to determine whether you will receive a notification when that object is created.","Select or clear the Update option for an object to determine whether you will receive a notification when that object is updated.","In the Special Operations section:","Expand an operation type and select or clear the Enabled option for each operation to determine if it is enabled or disabled.","Click Save and Close.","Configuring Eventing in P6<br /> (Primavera P6 EPPM WebLogic Configuration Guide for On-Premises)","English\\Configuring\\p6_eppm_weblogic_config\\92569.htm");
Page[348]=new Array("Setting Name and Description","Default","Valid Ranges/Values","Eventing","Select to enable the sending of events for P6, P6 EPPM Web Services, and P6 Integration API.","selected","&#8212;","Interval","The length of time that the Event Notification System uses to determine how often it sends events to the message queue. Specifying a smaller time increases the frequency with which the Event Notification System reports event occurrences to the message queue.","5m","1s-10m","Max Queue Size","The amount of memory allocated to the queue for events. Once exceeded, events will be published immediately.","1000","10-5000","Show Costs","Select to enable the display of cost fields in event notifications.","selected","&#8212;","JMS Connection Factory","Specify the JNDI name of the JMS Connection Factory.","&#8212;","&#8212;","JMS Connection Name","Specify the JNDI name of the queue or topic where events are published.","&#8212;","&#8212;","JMS Destination Security","Select to use the user name and password specified when sending messages to JMS queue.","not selected","&#8212;","JMS Connection Username","Specify the user name to use when sending events to the specified JMS destination specified.","&#8212;","&#8212;","JMS Connection Password","Specify the password to use when sending events to the JMS Destination specified.","&#8212;","&#8212;","Eventing Settings<br /> (Primavera P6 EPPM WebLogic Configuration Guide for On-Premises)","English\\Configuring\\p6_eppm_weblogic_config\\47532.htm");
Page[349]=new Array("Test event notification to ensure event messages are sent when an event occurs.","To test event notification:","If it is not already installed, install P6. See the P6 EPPM Installation and Configuration Guide.","Note If you are using more than one server, install P6 on the local server.","Configure WebLogic for eventing:","See Configuring the WebLogic Message Queue if the queue and the application are on the same domain.","See Sending Events to a Remote WebLogic JMS Server if the queue and the application are on different servers.","Open P6 and create a project. ","In P6:","Add one or more activities to the project.","Summarize the project to test if an event is generated.","Launch the WebLogic Administration Console to verify that the event is generated and sent to the queue.","In the WebLogic Administration Console, expand Services/Messaging and click JMS Modules in the Domain Structure pane.","On the JMS Modules page, click the module you created for the remote server.","On the Settings page for the module, click the queue you created for the remote server.","On the Settings page for the queue, click the Monitoring tab.","On the Monitoring tab, select the option for the remote server destination you created and click Show Messages. The event message should be visible in the JMS Messages list.","Testing Event Notification<br /> (Primavera P6 EPPM WebLogic Configuration Guide for On-Premises)","English\\Configuring\\p6_eppm_weblogic_config\\47021.htm");
Page[350]=new Array("When an event is triggered, the P6 Event Notification system sends the event message to a message queue. If you are using a remote JMS server, then you must configure the local and remote servers to receive these notifications.","The following procedure should be used when the queue is on a different domain than P6. For information about setting up other JMS-based servers, see the vendor documentation.","Note If you are configuring the WebLogic messaging queue in a cluster, ensure that you have targetted the JMS server to a migratable target. See: Targeting the JMS Server to a Migratable Target","To send events to a remote WebLogic JMS server:","Start the WebLogic Configuration Wizard.","In the wizard, create a WebLogic domain on the remote server to which you will be sending the events. See Creating a WebLogic Domain on a Remote or Local Server. ","Note Rename the WebLogic administration server to a name that is different from the name you used to deploy the P6 application. For example, RemoteAdminServer. ","Start the new server and launch the WebLogic Administration Console. The new server will act as the remote server.","In the WebLogic Administration Console:","Create a WebLogic message queue.","Create a new JMS server. See Creating a JMS Server and Persistence Store.","Create a JMS module. See Creating a JMS Module.","Create a connection factory. See Creating a JMS Connection Factory.","Create a new queue or topic. See Creating a JMS Message Queue and Subdeployment to see how to create a queue.","Note Create a queue to deliver a message to a specific group of users. Create a topic to distribute a message amongst several users.","Configure the trust relationship on the remote server. See Configuring a Trust Relationship.","Create a WebLogic domain on the local server from which the events will be sent. See Creating a WebLogic Domain on a Remote or Local Server.","Start the local server and launch the WebLogic Administration Console.","In the WebLogic Administration Console:","Target the JMS Server to a migratable target. See Targeting the JMS Server to a Migratable Target","Create a new JMS server. See Creating a JMS Server and Persistence Store.","Create a JMS module. See Creating a JMS Module.","Create a foreign server. See Creating a Foreign JMS Server.","Configure the trust relationship on the local server. You must use the same credentials that were used on the remote server. See Configuring a Trust Relationship.","Restart both Weblogic Administration Console servers (restart the domains, not the machines).","If it is not already installed, install P6 EPPM Web Services or P6 on the local server.","Launch P6 to configure message queue settings and event notification options. See Configuring Eventing in the Primavera P6 Administrator. The values you enter in the Directory Service and Eventing sections of the P6 Application Settings Eventing page should be the the Local JNDI names of the Destination and the Connection Factory in the Foreign JMS Server. ","Sending Events to a Remote WebLogic JMS Server<br /> (Primavera P6 EPPM WebLogic Configuration Guide for On-Premises)","English\\Configuring\\p6_eppm_weblogic_config\\46904.htm");
Page[351]=new Array("Create a WebLogic domain on a remote or local server to define how the server and domain interact.","To create a WebLogic domain:","Start the Weblogic Configuration Wizard on the local or remote server.","In the Welcome window, select Create a new WebLogic domain and click Next.","In the Select Domain Source window, click Next to accept the default selections.","In the Specify Domain Name and Location window:","Enter the domain name. If you are creating a domain on both a local and remote server, give the domains a different name.","Select the domain location.","Click Next.","In the Configure Administrator User name and Password window, enter the user name and password information and click Next.","Note Make a note of the name and password, you will need this information for the JNDI Properties Credential fields and the JNDI Properties box in the Creating a Foreign JMS Server topic.","In the Configure Server Start Mode and JDK window:","Select Production Mode in the left pane.","Select an appropriate JDK in the right pane.","Click Next.","In the Select Optional Configuration window, click Next.","In the Configuration Summary window, click Create.","In the Creating Domain window, select Start Admin Server and click Done.","Creating a WebLogic Domain on a Remote or Local Server<br /> (Primavera P6 EPPM WebLogic Configuration Guide for On-Premises)","English\\Configuring\\p6_eppm_weblogic_config\\46955.htm");
Page[352]=new Array("If you are sending events between different servers, you must establish a trust relationship between the local server, on which P6 is installed, and the remote server, on which you have setup the JMS message queue.","To configure a trust relationship:","If it is not already open, launch the WebLogic Administration Console on the server where you need to configure the trust relationship.","In the WebLogic Administration Console, click the name of your domain which is the top element in the Domain Structure pane.","On the Settings page, click the Security tab and then the General tab.","On the General tab, expand the Advanced section.","In the Advanced section:","Enter and confirm credentials in the Credential and Confirm Credential fields.","Note Make a note of the credentials you enter for the remote server; you must enter the same credentials for both servers.","Click Save.","Configuring a Trust Relationship<br /> (Primavera P6 EPPM WebLogic Configuration Guide for On-Premises)","English\\Configuring\\p6_eppm_weblogic_config\\46982.htm");
Page[353]=new Array("Create a foreign JMS server to establish a link between the WebLogic domains.","To create a foreign JMS server:","If it is not already open, launch the WebLogic Administration Console.","In the WebLogic Administration Console, expand Services/Messaging and click JMS Modules in the Domain Structure pane.","On the JMS Modules page, select the module you created for the remote server.","On the Settings page, click the Configuration tab and under Summary of Resources click New.","On the Create a New JMS System Module Resource page:","Under Choose the type of resource you want to create, select the Foreign Server option and click Next.","Under Foreign Server Properties, enter a name in the Name field and click Next.","Under The following properties will be used to target your new JMS system module resource, ensure the correct server is targeted and click Finish.","Note If you are deploying to a cluster, the cluster should be selected as the target.","On the Configuration tab of the Settings page, click the name of the new foreign server.","On the Settings page, click the Configuration tab and then click the General tab.","On the General tab:","Enter the URL of the remote server created from step 4 of section Sending Events to a Remote WebLogic JMS Server in the JNDI Connection URL field. ","For example:","If you are using a standalone server: t3://&lt;hostname&gt;:7001.","If you are using a cluster: t3://&lt;hostname&gt;:7003,&lt;hostname&gt;:7004.","Enter the password that you used to log on to the remote WebLogic server in the JNDI Properties Credential field.","Reenter this password in the Confirm JNDI Properties Credential field.","Enter java.naming.security.principal=&lt;name&gt; in the JNDI Properties box, where name is the user name you used to log on to the remote WebLogic server.","Click Save.","On the Configurations tab, click the Destinations tab and click New under Foreign Destinations.","On the Create a New Foreign JMS Destination page:","Enter a name in the Name field.","Enter a JNDI name in the Local JNDI Name field.  Ensure that the Local JNDI name is different from the JNDI name that you had previously assigned to the message queue for the remote server.","Enter the JNDI name that you assigned to the message queue for the remote server in the Remote JNDI Name field.","Click OK.","On the Configurations tab, click the Connection Factories tab and click New under Foreign Connection Factories.","On the Create a New Foreign JMS Connection Factory page:","Enter a name in the Name field.","Enter a JNDI name in the Local JNDI Name field.  Ensure that the Local JNDI name is different from the JNDI name that you had previously assigned to the connection factory for the remote server.","Enter the JNDI name that you assigned to the connection factory for the remote server in the Remote JNDI Name field.","Click OK.","Creating a Foreign JMS Server<br /> (Primavera P6 EPPM WebLogic Configuration Guide for On-Premises)","English\\Configuring\\p6_eppm_weblogic_config\\46987.htm");
Page[354]=new Array("You can configure the WebLogic security policy to allow only specific users, roles, or groups to access the queue. The following is an example a security policy configured for one user. If you need more information, refer to the WebLogic documentation.","To configure the WebLogic message queue security policy for one user:","Launch the WebLogic Administration console.","In the WebLogic Administration console, click Security Realms in the Domain Structure pane.","On the Summary of Security Realms page, click the security realm you are using in the Name column under Realms.","On the Settings page for the realm, click the Users and Groups tab and then click the Users tab.","On the Users tab, under Users click New.","On the Create a New User page, enter a name and password in the appropriate fields and click OK.","Note Make a note of the name and password as they will be needed in the Configuring and Testing the WebLogic Message Queue Security topic.","On the Settings page for the user, click the Roles and Policies tab and then click the Realm Policies tab.","On the Realm Policies tab, under Policies expand JMS then expand the module you created for the remote server and click the queue you created for the remote server.","On the Settings page for the queue, click the Security tab and then click the Policies tab.","On the Policies tab:","In the Policy Conditions section, click Add Conditions.","Under Choose a Predicate, select User from the Predicate list and click Next.","Under Edit Arguments:","Enter the user name for the user you just created in the User Argument Name field and click Add. You can now use this user in P6.","Click Finish.","On the Settings page for the queue, click Save.","Log in to P6 as an administrator.","From the Administer menu, select Applications Settings.","On the Application Settings page, click Eventing.","Enter information in the required fields. For more information about information that is required for each field, refer to Configuring Eventing in P6.","Change and test the Directory Services user name and password. See Configuring and Testing the WebLogic Message Queue Security.","Configuring the Security Policy for the WebLogic Message Queue<br /> (Primavera P6 EPPM WebLogic Configuration Guide for On-Premises)","English\\Configuring\\p6_eppm_weblogic_config\\46886.htm");
Page[355]=new Array("After you create a new user on the Users and Groups tab in Security Realms, you must change the Security Principal and the Security credentials listed under Directory Services in P6.","To configure and test the WebLogic message queue security:","Log in to P6 as an administrator.","From the Administer menu, select Applications Settings.","On the Application Settings page, click Eventing.","Under Directory Services, complete the following:","Enter the new username in the Security Principal field.","Enter the new password in the Security Credentials field.","Enter the provider URL in the Provider URL field.","Enter the initial context factory name in the Initial Context Factory field.","Enter the lookup name in the Lookup Name field.","Note The user name and password were set in the Configuring the Security Policy for the WebLogic Message Queue topic.","Click Test Connection.","Repeat the steps above with the original username and password to ensure that they no longer work.","Under Eventing,enter your eventing settings and test the connection. See Configuring Eventing in P6.","Configuring and Testing the WebLogic Message Queue Security<br /> (Primavera P6 EPPM WebLogic Configuration Guide for On-Premises)","English\\Configuring\\p6_eppm_weblogic_config\\47005.htm");
Page[356]=new Array("You must configure your WebLogic deployment of P6 if you would like to use a Secure Sockets Layer (SSL) connection.","Note Please ensure that you have completed the steps in the Sending Events to a Remote WebLogic JMS Server section before attempting to configure your WebLogic deployment of P6 to use SSL.","To configure a WebLogic deployment of P6 to use SSL:","See Configuring an SSL Connection on One Server if P6 and the WebLogic message queue are on the same server.","See Configuring an SSL Connection on Different Servers if P6 and the WebLogic message queue are on different servers.","Configuring a WebLogic Deployment of P6 to Use an SSL connection<br /> (Primavera P6 EPPM WebLogic Configuration Guide for On-Premises)","English\\Configuring\\p6_eppm_weblogic_config\\46901.htm");
Page[357]=new Array("You can configure your WebLogic deployment of P6 to use a Secure Sockets Layer (SSL) connection when P6 and the WebLogic message queue are on the same server.","Note When P6 and the WebLogic message queue are on the same server, they will use the same certificate and trust store.","To configure an SSL connection on one server:","Launch the WebLogic Administration Console.","In the WebLogic Administration Console, enable the SSL port. See Enabling the SSL Port.","Log in to P6 as an administrator.","From the Administer menu, select Applications Settings.","On the Application Settings page, click Eventing.","In the Provider URL field, under Directory Services, enter the protocol over SSL (t3s:// or iiops://) and the SSL port.For example, t3s://&lt;hostname&gt;:7002","Configuring an SSL Connection on One Server<br /> (Primavera P6 EPPM WebLogic Configuration Guide for On-Premises)","English\\Configuring\\p6_eppm_weblogic_config\\47094.htm");
Page[358]=new Array("You can configure your WebLogic deployment of P6 to use a Secure Sockets Layer (SSL) connection when P6 and the WebLogic message queue are on different servers.","Note This topic assumes that you have already set up a foreign JMS server. See Creating a Foreign JMS Server.","To configure an SSL connection on different servers:","Launch the WebLogic Administration Console.","In the WebLogic Administration Console, enable the SSL port on both servers. See Enabling the SSL Port.","Log in to P6 as an administrator.","From the Administer menu, select Applications Settings.","On the Application Settings page, click Eventing.","In the Provider URL field, under Directory Services, enter the protocol over SSL (t3s:// or iiops://) and the SSL port. For example, t3s://&lt;hostname&gt;:7002.","Import the certificate of the server hosting the WebLogic message queue into the trust store of the server hosting P6. Please refer to the WebLogic documentation for detailed instructions.","http://download.oracle.com/docs/cd/E21764_01/web.1111/e13707/identity_trust.htm","http://download.oracle.com/docs/cd/E21764_01/apirefs.1111/e13952/taskhelp/security/ConfigureIdentityAndTrust.html","In the WebLogic Administration Console, expand Services and click JMS Modules in the Domain Structure pane.","On the JMS Modules page, click the module that contains the foreign JMS server you are using.","On the Settings page for the module, click the foreign JMS server on the Configuration tab.","On the Settings page for the foreign JMS server, use the protocol over SSL (t3s:// or iiops://) and the SSL port in the JNDI Connection URL on the General tab. For example, t3s://&lt;hostname&gt;:7002.","Configuring an SSL Connection on Different Servers<br /> (Primavera P6 EPPM WebLogic Configuration Guide for On-Premises)","English\\Configuring\\p6_eppm_weblogic_config\\47096.htm");
Page[359]=new Array("To enable the SSL port:","Launch the WebLogic Administration Console.","In the WebLogic Administration Console, expand Environment and click Servers in the Domain Structure pane.","On the Summary of Servers page, click your server in the Name column under Servers.","On the Settings page for the server, click the Configuration tab and then click the General tab.","On the General tab, select the SSL Listen Port Enabled option and click Save.","Enabling the SSL Port<br /> (Primavera P6 EPPM WebLogic Configuration Guide for On-Premises)","English\\Configuring\\p6_eppm_weblogic_config\\47544.htm");
Page[360]=new Array("You may configure the Java client to use a Secure Sockets Layer (SSL) connection. See the documentation for WebLogic for more information.","To configure Java to use an SSL connection:","In order to use an SSL connection, include the following jar files in you classpath:","wlfullclient.jar","wlcipher.jar (This can be found in the &lt;WL_HOME&gt;/server/lib (e.g. C:\\Oracle\\Middleware\\wlserver_10.3\\server\\lib).)","To obtain the jar file wlfullclient.jar, run java &#8211;jar wljarbuilder.jar in &lt;WL_HOME&gt;/server/lib.","To obtain the provider URL, you can use either t3s:// or iiops:// protocol (t3 or iiop over SSL).","Note Use the SSL port (7002 by default).","To obtain the keystore file that contains the server's certificate:","Export the server's certificate from the browser to a certificate file.","Import the certificate file into your keystore using java's keytool:","keytool -import -trustcacerts -alias demotrust -file server_cert.crt -keystore mykeystore.jks","When running the client, specify the following parameters:","Dweblogic.security.TrustKeyStore=CustomTrust","Dweblogic.security.CustomTrustKeyStoreFileName=mykeystore.jks","Dweblogic.security.CustomTrustKeyStorePassPhrase=&lt;your keystore password&gt;","(Optional) Dweblogic.security.SSL.ignoreHostnameVerification=true (Specify this parameter to ignore hostname verification.)","Configuring your Java client to use an SSL connection<br /> (Primavera P6 EPPM WebLogic Configuration Guide for On-Premises)","English\\Configuring\\p6_eppm_weblogic_config\\47044.htm");
Page[361]=new Array("High availability allows application processing to continue when a server instance fails and provides a reliable environment with minimal or no loss of service. High Availability is often achieved through the use of clusters, units of servers running concurrently to provide application failover and load balancing. Enterprise application deployments can benefit from the additional reliance and flexibility high availability systems provide. ","Reasons for Implementing High Availability","Mission critical computer systems need to be available 24 hours a day, 7 days a week, and 365 days a year. However, part or all of the system may be inoperable during planned or unplanned downtime. A system's availability is measured by the amount of time that it provides service over the total time elapsed since the system's initial deployment.","System downtime may be categorized as planned or unplanned. Planned downtime refers to scheduled operations that render the system unavailable. The effect of planned downtime on end users is typically minimized by scheduling downtime when system traffic is slow. Unplanned downtime is any sort of unexpected failure. Unplanned downtime may have a greater effect than planned downtime because it can happen at peak hours, disrupt business operations, or lead to lost productivity or revenue.","When designing your P6 EPPM implementation, it is important to recognize the cost of downtime to understand how your services can benefit from availability improvements.","High Availability Options for P6 EPPM","WebLogic Clustering enables you to provide high availability for P6 EPPM applications, ensuring your services remain scalable and resilient against unexpected failures. ","Introduction to High Availability<br /> (Primavera P6 EPPM WebLogic Configuration Guide for On-Premises)","English\\Configuring\\p6_eppm_weblogic_config\\93839.htm");
Page[362]=new Array("WebLogic Server clusters provide scalability and reliability for your applications by distributing the work load among multiple instances of WebLogic Server. Incoming requests can be routed to a WebLogic Server instance in the cluster based on the volume of work being processed. In case of hardware or other failures, session state is available to other cluster nodes that can resume the work of the failed node.","A WebLogic server cluster consists of multiple WebLogic server instances running simultaneously to provide increased scalability and reliability. A cluster appears to clients to be a single WebLogic server instance. The server instances that constitute a cluster can run on the same machine, or be located on different machines. You can increase a cluster's capacity by adding additional server instances to the cluster on an existing machine, or you can add machines to the cluster to host the incremental server instances.","Note Each server instance in a cluster must run the same version of WebLogic.","Relationship between Clusters and Domains","A domain is an interrelated set of WebLogic server resources that are managed as a unit. A domain includes one or more WebLogic server instances, which can be clustered, non-clustered, or a combination of clustered and non-clustered instances. A domain can include multiple clusters. A domain also contains the application components deployed in the domain, and the resources and services required by those application components and the server instances in the domain. Examples of the resources and services used by applications and server instances include machine definitions, optional network channels, connectors, and startup classes.","In each domain, one WebLogic server instance acts as the Administration Server&#8212;the server instance that configures, manages, and monitors all other server instances and resources in the domain. Each domain contains one Administration Server only. If a domain contains multiple clusters, each cluster in the domain has the same Administration Server. All server instances in a cluster must reside in the same domain; you cannot split a cluster over multiple domains. Similarly, you cannot share a configured resource or subsystem between domains.","Clustered WebLogic server instances behave similarly to non-clustered instances, except that they provide failover and load balancing. The process and tools used to configure clustered WebLogic server instances are the same as those used to configure non-clustered instances. However, to achieve the load balancing and failover benefits that clustering enables, you must adhere to certain guidelines for cluster configuration.","High Availability with WebLogic Clustering","P6 EPPM can utilize WebLogic clustering to continue processing data when a server instance fails. You cluster P6 EPPM by deploying it on multiple server instances in the cluster. If a server instance on which P6 EPPM is running fails, then another running server instance on which P6 EPPM is deployed can continue to process data.","For a more comprehensive product overview, documentation, and community forums for WebLogic and its clustering functionality, see http://www.oracle.com/technetwork/middleware/weblogic/overview/index.html","About WebLogic Clustering<br /> (Primavera P6 EPPM WebLogic Configuration Guide for On-Premises)","English\\Configuring\\p6_eppm_weblogic_config\\93841.htm");
Page[363]=new Array("Prerequisites for WebLogic Clustering","This guide assumes that you have already installed and configured P6 EPPM.","In addition to the prerequisites to enable WebLogic clustering on your initial P6 EPPM deployment, which are described in either Installation Prerequisites of the Installation and Configuration Guide or Prerequisites in Manual Deployment Guide, you will need to install a supported version of Oracle HTTP Server. For a supported version of Oracle HTTP Server, refer to Tested Configurations.","Deploying P6 EPPM with WebLogic clustering requires you to install WebLogic on each machine that will use the P6 EPPM domain, which was created by the P6 EPPM configuration wizard.","Note You must install the same version of WebLogic on each machine.","Prerequisites<br /> (Primavera P6 EPPM WebLogic Configuration Guide for On-Premises)","English\\Configuring\\p6_eppm_weblogic_config\\93842.htm");
Page[364]=new Array("After you have installed and configured P6 EPPM, you can add new machines, servers, and clusters using the WebLogic Administration Console. You must then add any new servers to different machines and create a cluster to utilize high availability for your application deployments. After creating a cluster, you must add servers to the cluster. To add new servers to your clusters and establish high availability for your P6 EPPM applications, complete the following topics in the order that they are listed:","Adding New Machines in WebLogic","Adding New Servers in WebLogic","Associating Servers with Machines","Adding New Clusters in WebLogic","Assigning Servers to Clusters","After the servers have been added to your cluster, deploy the P6 EPPM WebLogic domain to new machines by creating a zip file of the domain, extracting its contents to the domains folder in Oracle Middleware Home, and then updating nodemanager.properties with the correct ListenAddress hostname. For the procedures to deploy the P6 EPPM domain to new machines, refer to Copying the P6 EPPM Domain to Additional Machines.","When deploying P6 EPPM to managed servers in a cluster running across different physical machines to the domain's administration server, you must modify the Web Service Manager (WSM) Policy Manager on the remote machines so that the additional managed servers can use the WSM Policy Framework. To modify the WSM Policy Manager, refer to Modifying the WSM Policy Manager.","Lastly, configure the WebLogic proxy plugin driver (mod_wl_ohs) of an Oracle HTTP Server (OHS) instance to connect to the P6 EPPM WebLogic cluster using the instructions in Configuring the WebLogic Proxy Plugin Driver of an Oracle HTTP Server and then start your node managers and managed servers using the instructions in Starting the Node Managers and Managed Servers on Additional Machines.","Setting Up WebLogic Clustering for P6 EPPM Applications<br /> (Primavera P6 EPPM WebLogic Configuration Guide for On-Premises)","English\\Configuring\\p6_eppm_weblogic_config\\93844.htm");
Page[365]=new Array("To add new machines in WebLogic:","Log in to the WebLogic Administration Console with the following URL: ","http://&lt;host_name&gt;:&lt;port&gt;/console","In the Change Center pane, click Lock &amp; Edit.","In the Domain Structure pane, click Environment and then click Machines.","Click New.","On the Create a New Machine page, complete the following:","In the Name field, enter a logical name for the machine (for example, Machine 1).","In the Machine OS list, select Unix if the machine uses a Unix operating system or select Other if the machine uses a non-Unix operating system, such as Windows.","Click Next.","On the Create a New Machine page, complete the following:","In the Type list, select the protocol with which the node manager on the machine communicates with its servers. The protocol options are SSL (default option), Plain, RSH, and SSH.","In the Listen Address field, enter the hostname or IP Address of the remote server.","In the Port field, enter the port number for the remote server on which the node manager will run.","Click Finish.","Click Activate Changes.","Adding New Machines in WebLogic<br /> (Primavera P6 EPPM WebLogic Configuration Guide for On-Premises)","English\\Configuring\\p6_eppm_weblogic_config\\93845.htm");
Page[366]=new Array("To add new servers in WebLogic:","Log in to the WebLogic Administration Console with the following URL:","http://&lt;host_name&gt;:&lt;port&gt;/console","In the Change Center pane, click Lock &amp; Edit.","In the Domain Structure pane, click Environment and then click Servers.","Click New.","On the Create a New Server page, complete the following:","In the Server Name field, enter a name for the managed server.","In the Server Listen Address field, enter the hostname or IP Address of the remote server.","Note If you plan to add a new managed server on the same physical server as the Administration server, you can leave this field blank. This allows all local listening addresses on the server to be utilized.","In the Server Listen Port field, enter the port number from which you want to access the server instance.","Tip You can more easily manage and maintain the servers in your cluster by using the same port number across all of your managed servers.","Select Yes, make this server a member of an existing cluster.","Select a cluster.","Click Finish.","Click Activate Changes.","Adding New Servers in WebLogic<br /> (Primavera P6 EPPM WebLogic Configuration Guide for On-Premises)","English\\Configuring\\p6_eppm_weblogic_config\\93846.htm");
Page[367]=new Array("To add new clusters in WebLogic:","Log in to the WebLogic Administration Console with the following URL:","http://&lt;host_name&gt;:&lt;port&gt;/console","In the Change Center pane, click Lock &amp; Edit.","In the Domain Structure Pane, click Environment, then click Clusters. ","Click New, then select Cluster.","On the Create a New Cluster page, complete the following:","Enter a name for the cluster in the Name field.","Select a messaging mode for the cluster, Unicast or Multicast.","If you selected Unicast, enter a Unicast Broadcast Channel.","If you selected Multicast, enter a Multicast Address and a Multicast Port number.","Click Ok.","Click Activate Changes.","To learn more about WebLogic clusters, cluster configuration, and application deployment, refer to the official WebLogic documentation.","Adding New Clusters in WebLogic<br /> (Primavera P6 EPPM WebLogic Configuration Guide for On-Premises)","English\\Configuring\\p6_eppm_weblogic_config\\93859.htm");
Page[368]=new Array("To assign servers to clusters in WebLogic:","Log in to the WebLogic Administration Console with the following URL:","http://&lt;host_name&gt;:&lt;port&gt;/console","In the Change Center pane, click Lock &amp; Edit.","In the Domain Structure Pane, click Environment, then click Clusters. ","Click the name of the cluster you want to which you want to assign servers.","On the Settings for &lt;Cluster_Name&gt; page, click the Servers tab. ","On the Servers tab, in the Servers table, click Add.","Select Select an existing server, and add it as a member of this cluster, to add a preexisting server to the cluster. ","Select a server in the Select a server list. ","Click Next. ","Click Activate Changes.","Assigning Servers to Clusters<br /> (Primavera P6 EPPM WebLogic Configuration Guide for On-Premises)","English\\Configuring\\p6_eppm_weblogic_config\\93860.htm");
Page[369]=new Array("To associate a server with a machine:","Log in to the WebLogic Administration Console with the following URL:","http://&lt;host_name&gt;:&lt;port&gt;/console","In the Change Center pane, click Lock &amp; Edit.","In the Domain Structure pane, click Environment and then click Machines.","Click the name of the machine to which you want to add a server.","Under the Configuration tab, click Servers.","Click Add.","On the Add Server to Machine page, complete the following:","Select Select an existing server, and associate it with this machine.","In the Select a Server list, select the name of the server that you want to add to the machine.","Click Finish.","Click Activate Changes.","Associating Servers with Machines<br /> (Primavera P6 EPPM WebLogic Configuration Guide for On-Premises)","English\\Configuring\\p6_eppm_weblogic_config\\93847.htm");
Page[370]=new Array("P6 EPPM uses Fusion Middleware Infrastructure, which includes Oracle Web Services Manager (WSM) Policy Manager to manage Oracle WSM policies and run the Oracle WSM policy framework. The Oracle WSM Policy Manager reads from a configuration file called wsm-ccw-config.xml that is stored in the &lt;Primavera_Domain&gt;/config/fmwconfig directory. In wsm-ccw-config.xml, the administration server URL is referred as http://localhost:&lt;port&gt;. The wsm-ccw-config.xml file will need to be updated to change localhost references to the actual hostname of the administration server before you copy the domain for every additional managed server that has been added to the P6 EPPM cluster.","To modify the WSM Policy Manager:","Go to &lt;Oracle_Middleware_Home&gt;/user_projects/domains/&lt;Primavera_Domain&gt;/config/fmwconfig/.","Edit wsm-ccw-config.xml.","Replace localhost references with the hostname of the machine on which the administration servers runs and then save your changes.","Modifying the Web Services Manager Policy Manager<br /> (Primavera P6 EPPM WebLogic Configuration Guide for On-Premises)","English\\Configuring\\p6_eppm_weblogic_config\\93848.htm");
Page[371]=new Array("After you have added new managed servers to your P6 EPPM cluster and modified the WSM Policy Manager, you need to copy the domain to your new machines. WebLogic offers two command-line utilities for this process. The pack command creates a template that contains a snapshot of your domain. The unpack command uses this template to re-create a domain that contains the packaged applications. For more information on using pack and unpack, see the WebLogic documentation.","To copy the P6 EPPM domain:","Navigate to the &lt;WebLogic_Home&gt;/wlserver/common/bin of the machine on which you created the initial P6 EPPM domain.","Depending on your operating system, complete the following:","For Windows, run:","pack.cmd -managed=true &#8211;domain=&lt;Domain_Path&gt; -template=&lt;Template_Location&gt;\\Clustered_Domain.jar -template_name=&#8221;Clustered_Domain&#8221;","For Unix, run:","pack.sh -managed=true &#8211;domain=&lt;Domain_Path&gt; -template=&lt;Template_Location&gt;/Clustered_Domain.jar -template_name=&#8221;Clustered_Domain&#8221;","Where:","&lt;Domain_Path&gt; is the full path to the P6 EPPM domain. For example, &lt;WebLogic_Home&gt;\\user_projects\\domains\\&lt;P6_EPPM_Domain&gt;.","&lt;Template_Location&gt; is the full path where P6 EPPM Web Services creates the template. For example, C:\\oracle\\user_templates.","Copy the Clustered_Domain.jar file from &lt;Template_Location&gt; to the machines on which you have created additional servers.","Navigate to &lt;WebLogic_Home&gt;/wlsever/common/bin.","Depending on your operating system, compete the following:","For Windows, run:","Unpack.cmd &#8211;template=&lt;Copy_Location&gt;/Clustered_Domain.jar &#8211;domain=&lt;WebLogic_Home&gt;/user_projects/domains/Clustered_Domain","For Unix, run:","Unpack.sh &#8211;template=&lt;Copy_Location&gt;/Clustered_Domain.jar &#8211;domain=&lt;WebLogic_Home&gt;/user_projects/domains/Clustered_Domain","Where:","&lt;Copy_Location&gt; is the path to where you copied the Clustered_Domain.jar file. For example, C:\\temp.","&lt;WebLogic_Home&gt; is the WebLogic home directory. The default is Oracle/Middleware/Oracle_Home.","Repeat these steps for each clustered server.","Copying the P6 EPPM Domain to Additional Machines<br /> (Primavera P6 EPPM WebLogic Configuration Guide for On-Premises)","English\\Configuring\\p6_eppm_weblogic_config\\93849.htm");
Page[372]=new Array("To run the node manager as a background process upon system startup, you can run the node manager as a service on Windows or you can configure the node manager as a daemon on Unix.","For Unix","To start the node manager upon system startup and to run it in the background:","Open a terminal and run the following script:","nohup &lt;Oracle_Middleware_Home&gt;/user_projects/domains/&lt;Primavera_Domain&gt;/bin/startNodeManager.sh &gt; logfilename.log 2&gt;&amp;1 &amp;","Create a shell script using the following sample script:"," #! /bin/bash"," #"," # wlsnmd Oracle Weblogic NodeManager service"," #"," # chkconfig:   345 85 15"," # description: Oracle Weblogic NodeManager service"," case &quot;$1&quot; in","     start)","         export WL_HOME=&lt;Oracle_Middleware_Home&gt;/wlserver/","         $WL_HOME/../user_projects/domains/&lt;Primavera_Domain&gt;/bin/startNodeManager.sh","         ;;","     *)","         echo &quot;Usage: $0 {start}&quot;","         exit 1"," esac"," exit_status","Save the script to /etc/init.d/nodemgr.","Run the following command with root privileges:"," # chmod +x /etc/init.d/nodemgr"," # chkconfig --add nodemgr","For Windows","To create and run a node manager as a Windows service:","Log in to a machine with administrative privileges.","Go to &lt;Oracle_Middleware_Home&gt;/wlserver/server/bin.","Edit installNodeMgrSvc.cmd.","Comment out the following lines:","set NODEMGR_HOST=&lt;host&gt;","set NODEMGR_PORT=&lt;port&gt;","Save your changes and then close the file.","Go to &lt;Oracle_Middleware_Home&gt;/user_projects/domains/&lt;Primavera_Domain&gt;/bin.","Edit installNodeMgrSvc.cmd.","Comment out the following lines:","set NODEMGR_HOST=&lt;host&gt;","set NODEMGR_PORT=&lt;port&gt;","Save your changes and then close the file.","Open a command prompt and then complete the following:","Change your directory to &lt;Oracle_Middleware_Home&gt;/user_projects/domains/&lt;Primavera_Domain&gt;/bin.","Run installNodeMgrSvc.cmd.","Note If the node manager service has already been installed, the following message will display: CreateService failed - The specified service already exists.","Close the command prompt.","Go to Control Panel\\All Control Panel Items\\Administrative Tools and then click Services.","Right-click Oracle WebLogic &lt;primavera_domain&gt; NodeManager and then click Start.","Running Node Manager as a Service<br /> (Primavera P6 EPPM WebLogic Configuration Guide for On-Premises)","English\\Configuring\\p6_eppm_weblogic_config\\93850.htm");
Page[373]=new Array("Typically, you use Oracle HTTP Server to front end a cluster of WebLogic servers. Oracle HTTP Server acts as a front end for the cluster of WebLogic servers. When a request is made to a managed server, the mod_wl_ohs directive specifies a comma-separated list of cluster members to balance the server load. The process works as follows:","When mod_wl_ohs receives a request that requires a managed server, it sends that request to one of the WebLogic cluster members that is listed in the directive. At least one server must be available to service the request.","The Managed server processes the request and sends a complete list of cluster members back to mod_wl_ohs.","When mod_wl_ohs receives the updated list, it dynamically adds any previously unknown servers, that may have been down during the initial request, to the list of known servers, which enables all future requests to be load balanced across the full cluster member list defined in the mod_wl_ohs configuration.","This process also enables new managed servers to be added to the cluster without having to manually update mod_wl_ohs as long as the new managed server host and port is determined ahead of time.","In an example scenario, assume that the WebLogic Cluster consists of WLS1, WLS2, and WLS3. Also assume that all three managed servers have been added to the mod_wl_ohs clustering directive, but only WLS1 and WLS2 are known to mod_wl_ohs during an initial request because WLS3 is offline.","When mod_wl_ohs first receives a request, it attempts to send that request to either WLS1 or WLS2. If during the request WLS3 becomes active, the list of available servers is updated to include WLS3 for future requests. If, however, WLS1 and WLS2 are unavailable, but WLS3 becomes available during the request, the request is rejected because mod_wl_ohs has no way of knowing WLS3 exists.","To configure mod_wl_ohs:","Go to &lt;OHS_Middleware_Home&gt;/user_projects/domains/&lt;Primavera_Domain&gt;/config/fmwconfig/components/OHS/instances/&lt;instance_name&gt;.","Edit mod_wl_ohs.conf.","Add the following information to mod_wl_ohs:","&lt;Location /p6&gt;","WLSRequest On","WebLogicCluster &lt;WebLogic_server1&gt;:&lt;port1&gt;, &lt;WebLogic_server2&gt;:&lt;port2&gt;, &lt;WebLogic_server3&gt;:&lt;port3&gt;","&lt;/Location&gt;","&lt;Location /p6tmweb&gt;","WLSRequest On","WebLogicCluster &lt;WebLogic_server1&gt;:&lt;port1&gt;, &lt;WebLogic_server2&gt;:&lt;port2&gt;, &lt;WebLogic_server3&gt;:&lt;port3&gt;","&lt;/Location&gt;","&lt;Location /p6ws&gt;","WLSRequest On","WebLogicCluster &lt;WebLogic_server1&gt;:&lt;port1&gt;, &lt;WebLogic_server2&gt;:&lt;port2&gt;, &lt;WebLogic_server3&gt;:&lt;port3&gt;","&lt;/Location&gt;","Restart Oracle HTTP Server.","Go to &lt;OHS_Middleware_Home&gt;/user_projects/domains/base_domains/bin.","Depending on your operating system, complete the following:","For Unix, run the following in a terminal:","./stopComponent.sh &lt;component_name&gt;","./startComponent.sh &lt;component_name&gt;","For Windows, run the following in a command prompt:","stopComponent.bat &lt;component_name&gt;","startComponent.bat &lt;component_name&gt;","Configuring the WebLogic Proxy Plugin Driver of an Oracle HTTP Server<br /> (Primavera P6 EPPM WebLogic Configuration Guide for On-Premises)","English\\Configuring\\p6_eppm_weblogic_config\\93851.htm");
Page[374]=new Array("After the P6 EPPM domain has been modified on machines on which they reside, you must start the node manager on each machine to control the managed servers from the WebLogic Administration Console.","To start a managed server:","Log in to the Domain's Administration Console.","In the left pane of the Administration Console, expand Environment and select Servers.","In the right pane, select the Control tab.","In the Server Status table, select the check box next to the name of the server you want to start and click Start.","Click Yes to confirm.","To start the node manager:","Go to &lt;Oracle_Middleware_Home&gt;/user_projects/domains/&lt;Primavera_Domain&gt;/bin.","Depending on your operating system, complete the following:","For Windows, run:","startManagedWeblogic.bat &lt;server_name&gt; t3://&lt;administration_server_name&gt;:&lt;port&gt;","For Unix, run","./startNodeManager.sh","Starting Node Managers and Managed Servers on Additional Machines<br /> (Primavera P6 EPPM WebLogic Configuration Guide for On-Premises)","English\\Configuring\\p6_eppm_weblogic_config\\93852.htm");
Page[375]=new Array("Now that you have deployed P6 in WebLogic, you can begin using P6. You may find the following guides useful for help getting started:","P6 EPPM System Administration Guide","P6 EPPM Application Administration Guide","P6 EPPM Database Administration Guide","P6 Help","P6 Team Member User's Guide","Depending on what other applications you are using, you may also need the following guides:","P6 Professional","P6 Professional Installation and Configuration Guide for your database","Primavera Data Warehouse","Primavera Data Warehouse Installation and Configuration Guide","Analytics","Analytics Installation and Configuration Guide","Additional Applications","P6 EPPM Oracle Analytics Publisher Configuration Guide","P6 EPPM BPM Configuration Guide","P6 EPPM Content Repository Configuration Guide","P6 EPPM Oracle Identity Manager Configuration Guide","Primavera Oracle Access Manager Configuration Guide","Primavera Oracle Enterprise Manager Configuration Guide","Where to Go from Here<br /> (Primavera P6 EPPM WebLogic Configuration Guide for On-Premises)","English\\Configuring\\p6_eppm_weblogic_config\\93089.htm");
var PageCount=91;


/*
Date: 12/3/2025 5:47 PM
Source: EPPM_25_dev
BookID: 93087
PubProduct: PRIMAVERA_EPPM
BookTitle: WebLogic Configuration Guide for On-Premises
Version: Version 25
Lang:	en
*/
/* relative_path_for_link: English\Configuring\p6_eppm_content_repository_config*** */
/* BookTitleTop: Primavera P6 EPPM Content Repository Configuration Guide for On-Premises*** */
/* Generated with Author-it 23.4.1.30004  12/11/2025 7:40:38 PM */
Page[376]=new Array("Title and Copyright Information","Copyright  1999, 2025, Oracle and/or its affiliates.","Primary Author: Oracle Corporation","Title and Copyright Information<br /> (Primavera P6 EPPM Content Repository Configuration Guide for On-Premises)","English\\Configuring\\p6_eppm_content_repository_config\\46576.htm");
Page[377]=new Array("Scope","Integrate a content repository with P6 to make it easier to catalog, access, search, and reuse documentation.","This guide describes how to:","Configure Oracle Webcenter Content Core Capabilities (WCCC), Oracle Database, Microsoft SharePoint or any CMIS-compliant content repository for integration with P6. Refer to Tested Configurations for a complete list of the content repositories P6 EPPM supports.","Set your content repository settings in the Primavera P6 Administrator to connect your content repository to P6.","Note","The SharePoint connector has been removed from version 16.1 and later. New SharePoint users should configure SharePoint with a CMIS-compliant content repository, and then configure P6 EPPM to the CMIS-compliant content repository. ","Do not reconfigure SharePoint with a CMIS-compliant content repository if you previously configured your SharePoint connection using the Primavera P6 Administrator and SharePoint connector. Reconfiguring SharePoint with a CMIS repository will prevent previously stored documents from being visible. For more information, refer to documentation from Version 16.","Audience","System administrators should use this guide.","Using This Guide","This guide assumes you have installed P6 and its supporting applications. For more information, see the P6 EPPM Installation and Configuration Guide.","About This Guide<br /> (Primavera P6 EPPM Content Repository Configuration Guide for On-Premises)","English\\Configuring\\p6_eppm_content_repository_config\\53858.htm");
Page[378]=new Array("P6 EPPM offers two content repository authentication modes. You can configure authentication for either single user authentication or multiple user authentication. In single user authentication mode, all P6 EPPM users access the repository using a single administrator user login that is set during repository configuration. In multiple user authentication mode,&nbsp;each P6 EPPM user is authenticated based on their individual login.","Single User authentication mode is useful when you want users to have full access to the content repository through P6 EPPM without having to maintain an equivalent list of users for both P6 EPPM and the repository. This allows a repository administrator to maintain one set of credentials for the repository without having to share those credentials with all users. Single user authentication is also useful for quickly setting up test repositories that testers can access with ease.","Multiple User authentication mode is the default mode. Multiple user authentication mode provides increased security by restricting content repository access on an individual user basis. Because it uses native auditing fields it also allows a clear audit of who has created and modified files.","Note","When using multiple user authentication mode,&nbsp;you should disable for the Oracle content repository Guest Access. If you leave Guest Access enabled and the guest user is not part of the P6 EPPM security group, that user will not be able to access P6 repository functionality.","If you are using the Oracle Database as your content repository, you can only use multiple user.","See the P6 EPPM Application Administration Guide for more information about Single User and Multiple User settings.","About Content Repository Authentication Modes<br /> (Primavera P6 EPPM Content Repository Configuration Guide for On-Premises)","English\\Configuring\\p6_eppm_content_repository_config\\14398.htm");
Page[379]=new Array("If you are installing P6 and the content repository for the first time, follow the steps in this section.","If you are upgrading from a previous version of P6 and need to update your content repository to the latest supported version, you need to follow the steps in Upgrading the Content Repository.","Before you configure your content repository, you need to decide which authentication mode to use. Refer to the documentation included with the content repository application for detailed instructions on how to complete the guidelines in this section.","Note When P6 is configured with a content repository, it develops a dependency on that content repository. After you configure your content repository, if dependency is broken (for example, starting P6 when the content repository is not running), the content repository features will fail until the P6 Server is restarted. ","Configuring the Content Repository for P6<br /> (Primavera P6 EPPM Content Repository Configuration Guide for On-Premises)","English\\Configuring\\p6_eppm_content_repository_config\\7243.htm");
Page[380]=new Array("Depending on your organization, you can choose to use existing configurations or your own naming conventions when configuring Oracle Webcenter Content Core Capabilities (WCCC). Refer to the documentation included with WCCC for detailed instructions on how to complete the guidelines in this section. See the P6 EPPM Tested Configurations document for information on supported versions.","These instructions contain information only on configuring Oracle Webcenter Content Core Capabilities to work with P6. They do not include information on installing WCCC. For WCCC installation instructions, see the documentation included with Oracle WCCC. For more information on configuring Oracle Webcenter Core Capablities, consult the following Knowledge Base article on integrating WCCC with P6: How to Configure Local or External Users for Webcenter Content Core Capabilities (WCCC) When Integrating With P6 EPPM (KB696872).","Configuring Oracle Webcenter Content Core Capabilities to Work with P6<br /> (Primavera P6 EPPM Content Repository Configuration Guide for On-Premises)","English\\Configuring\\p6_eppm_content_repository_config\\91749.htm");
Page[381]=new Array("The Intradoc Server Port is used by P6 to communicate with WCCC. When this is enabled, a security filter list which includes the IP address of the P6 application server is required to communicate to the Content Server through the Intradoc Server Port. The security filter list must be defined because it is a trusted connection. If you are accessing WebContent Center for the first time, you must configure the Incoming Socket Connection Address Security Filter and Server Socket Port. ","To configure the Incoming Socket Connection Address Security Filter and Server Socket Port:","Log in to WebCenter Content (http://&lt;host&gt;:&lt;port&gt;/cs) as an administrator. The default is weblogic.","Enter or edit the following configuration values:","In Incoming Socket Connection Address Security Filter, enter the server IP address of the P6 application server. ","Note Separate multiple IP addresses using a pipe symbol or |. For example, 127.0.0.1|127.0.0.2.","In Server Socket Port, enter an unused port number for the Content Server. For example, 4444.","Apply the changes.","Restart the WCCC managed server for changes to take effect.","Note If this is not the first time you have installed WCCC, you must confirm or modify the server configuration Incoming Socket Connection Address Security Filter and Server Socket Port values. You can modify the values through Enterprise Manager or with the configuration file (config.cfg) using the following procedures:","Modifying the Server Configuration through Enterprise Manager","Modifying the Server Configuration using the Configuration File","Configuring an Intradoc Server Port in WCCC<br /> (Primavera P6 EPPM Content Repository Configuration Guide for On-Premises)","English\\Configuring\\p6_eppm_content_repository_config\\91726.htm");
Page[382]=new Array("To modify the server configuration through Enterprise Manager:","Connect to Enterprise Manager Fusion Middleware Control (http://&lt;server&gt;:&lt;port&gt;/em).","Log in as a domain administrative user. For example, weblogic.","In the navigation tree, expand WebCenter, Content, Content Server.","Select the Content Server instance name (for example, Oracle Content Server (WCCC_server1)).","Use the WCCC menu to select Configuration Pages, Internet Configuration.","In the Server Configuration section, in the IP Address Filter field, enter a list of IP addresses that can be used to access the server. ","Note  Separate multiple IP addresses or machine name entries using a pipe symbol or |. For example, 127.0.0.1|127.0.0.2.","In the Intradoc Server Port field, enter a server port number.","Apply the changes.","Restart the WCCC managed server for changes to take effect.","Modifying the Server Configuration through Enterprise Manager<br /> (Primavera P6 EPPM Content Repository Configuration Guide for On-Premises)","English\\Configuring\\p6_eppm_content_repository_config\\91751.htm");
Page[383]=new Array("To edit the files in the server:","Go to &lt;WCCC_Home&gt;\\ucm\\cs\\config. WCCC_Home is the location where you installed WCCC. The WCCC_Home path is \\Oracle\\Middleware\\user_projects\\domains\\$domain_name by default.","Edit the config.cfg file.","Find the SocketHostAddressSecurityFilter line and add the list of IP addresses that can be used to access the server to the end of the line. ","Note  Separate multiple IP addresses or machine name entries using a pipe symbol or |.  For example, 127.0.0.1|127.0.0.2.","Find the IntradocServerPort line and enter a server port number. For example, 4444.","Save the changes.","Restart the WCCC managed server for changes to take effect.","Modifying the Server Configuration using the Configuration File<br /> (Primavera P6 EPPM Content Repository Configuration Guide for On-Premises)","English\\Configuring\\p6_eppm_content_repository_config\\91752.htm");
Page[384]=new Array("The Framework folder interface is not enabled by default. See the WCCC documentation for more information.","To enable the Framework Folders component:","Log in to WebCenter Content (http://&lt;host&gt;:&lt;port&gt;/cs) as an administrator.","On the Main Menu, choose Administration, Admin Server, Component Manager.","On the Component Manager page, select the FrameworkFolders option.","Click Update.","Restart the WCCC managed server for changes to take effect.","Enabling Framework Folders in WCCC<br /> (Primavera P6 EPPM Content Repository Configuration Guide for On-Premises)","English\\Configuring\\p6_eppm_content_repository_config\\91727.htm");
Page[385]=new Array("To maintain your WCCC repository, create a P6 Security Group in WCCC and grant the appropriate rights to P6 EPPM users. Consider the following:","P6 user names must match the WCCC user names, unless you are using Single User for the Authentication Mode.","Note Single User Authentication Mode will log all P6 users into WCCC using the administrator user or as specified in the Database/Instance/Content Repository&nbsp;setting in P6 Admin Settings. ","All P6 EPPM-related WCCC user names must have corresponding assignments to WCCC Roles and Users. For a quick setup, you can create one P6 EPPM-specific Role to map to users with full privileges (read, write, delete, admin).","All P6 EPPM-related WCCC user names must have access to the P6 Security Group, either directly or through a role.","When you are creating users in WCCC for integrating with P6, consider the following:","If you are using Multiple User Authentication Mode when configuring P6:","You must create a WCCC user for every P6 EPPM user, and the user name created must match the P6 EPPM user.","You must assign the user to a role mapped to the security group associated with the P6 Framework folder and must have the right to read, write, and delete.","You must create an administrative user in WCCC. The user name does not have to match a P6 user.","You must assign the administrative user to a role mapped to the Security Group associated with the P6 folder. The administrator must have read, write, delete, and admin rights within the Security Group.","If you are using Single User Authentication Mode when configuring P6:","You must create an administrative user in WCCC. The user name does not have to match that of a P6 EPPM user.","You must assign the administrative user to a role mapped to the Security Group associated with the P6 folder. The administrator must have read, write, delete, and admin rights within the Security Group.","(Optional)&nbsp;If you enabled Security Accounts, create a P6 Security Account. Depending on your organization, you might need to set up a Security Account for performance and storage reasons. Security considerations include the following:","P6 EPPM user names must match the WCCC user names, unless using Single User for the Authentication Mode.","All P6-related WCCC user names must have corresponding WCCC Roles and Users.","All P6-related WCCC user names must have access to the P6 Security Account.","Creating a P6 Security Group in WCCC<br /> (Primavera P6 EPPM Content Repository Configuration Guide for On-Premises)","English\\Configuring\\p6_eppm_content_repository_config\\91734.htm");
Page[386]=new Array("To create a local P6 Security Group and administrative user:","Log in to WebCenter Content (http://&lt;host&gt;:&lt;port&gt;/cs) as an administrator.","Expand Administration, and select Admin Applets.","Select User Admin.","In the User Admin dialog box, select Security, Permission by Group.","Click Add Group.","Enter a Group Name and description.","Click OK.","Close the Permission by Group dialog box.","Select Security, Permission by Role.","Click Add New Role.","Enter a Role Name and Display Name.","Click OK.","Select newly created role and click Edit applet Rights.","Grant all rights to the administrative user.","Click OK.","In the Groups/Rights section, select the newly created group.","Click Edit Permissions.","Grant all permissions to the group.","Click OK.","Close the Permission by Role dialog box. ","In the User Admin dialog, click Add.","Set Authorization type to Local.","Click OK.","Provide user details. ","Navigate to the Roles tab.","Click Add Role.","Add the newly created role. ","Click OK.","Close the User Admin dialog box.","Creating a Local P6 Security Group in WCCC<br /> (Primavera P6 EPPM Content Repository Configuration Guide for On-Premises)","English\\Configuring\\p6_eppm_content_repository_config\\91965.htm");
Page[387]=new Array("You might choose to create external security accounts for WCCC. For instructions on creating external security groups, see:  How to Configure Local or External Users for Webcenter Content Core Capabilities (WCCC) When Integrating With P6 EPPM (KB696872).","Creating an External P6 Security Group in WCCC<br /> (Primavera P6 EPPM Content Repository Configuration Guide for On-Premises)","English\\Configuring\\p6_eppm_content_repository_config\\91966.htm");
Page[388]=new Array("(Optional) You can create document types for P6 documents in WCCC. ","Log in to WebCenter Content (http://&lt;host&gt;:&lt;port&gt;/cs) as an administrator.","Expand Administration and select Admin Applets.","Select Configuration Manager.","In the Configuration Manager, select Options, Content Types.","Create a new content type for P6 Documents.","Apply the changes.","Restart the WCCC managed server for changes to take effect.","Note","Document Type as Document is the default document type in a WCCC repository.","Creating Document Types for P6 Documents in WCCC<br /> (Primavera P6 EPPM Content Repository Configuration Guide for On-Premises)","English\\Configuring\\p6_eppm_content_repository_config\\91735.htm");
Page[389]=new Array("Create a P6 documents home folder on the WCCC server by adding a unique path to the root folder.","Log in to WebCenter Content (http://&lt;host&gt;:&lt;port&gt;/cs) as an administrator.","Expand Browse Content.","Select Folders.","Select Add.","Enter a folder name. For example, P6EPPM","Select Show Advanced Options.","Select the security group created for P6.","Apply the changes.","Creating a P6 Documents Home Folder on the WCCC Server<br /> (Primavera P6 EPPM Content Repository Configuration Guide for On-Premises)","English\\Configuring\\p6_eppm_content_repository_config\\91736.htm");
Page[390]=new Array("From the Configuration Manager applet, create the following metadata text fields in WCCC for P6:","Log in to WebCenter Content (http://&lt;host&gt;:&lt;port&gt;/cs) as an administrator.","Expand Administration and select Admin Applets.","Select Configuration Manager.","In the Configuration Manager, select the Information Fields tab.","Create the following information fields as specified (including case):","PrmUserId","PrmProjectId","PrmWorkgroupId","PrmWorkflowId","PrmWorkflowStatus","PrmWorkflowAction","PrmSecurityPolicy","PrmTemplate","PrmCheckedOutUserId","PrmCheckedOutDate","PrmLocalFilePath (set Type to Long Text)","PrmAuthorId","Note Using &quot;Prm&quot; as a prefix is optional. You can use any prefix. If you do not use a prefix, ensure that none of the P6 metadata fields conflict with existing metadata fields.","Select Update Database Design to commit the changes.","Restart the WCCC managed server for changes to take effect.","Creating Metadata Text Fields in WCCC<br /> (Primavera P6 EPPM Content Repository Configuration Guide for On-Premises)","English\\Configuring\\p6_eppm_content_repository_config\\91737.htm");
Page[391]=new Array("To configure WCCC settings for the Primavera P6 Administrator:","Note Ensure the settings you entered in when you configured the content repository match the settings you enter below.","Open the Primavera P6 Administrator.","In the Configurations drop-down list, select your configuration.","In the sidebar select Database.","Select your Instance from the drop-down list.","Expand Content Repository.","In the Type field, select OracleWCCC.","In the Maximum document size field, enter the maximum size in KB for documents that can be uploaded to P6. The default is 10240 KB. Enter a value between 0 and 1048576.","In the Connection Maintenance Interval field enter the frequency at which the connection to the content repository is validated. The default is 10 minutes. Enter a value between 1 second and 24 days.","In the Oracle Webcenter Content Core Capabilities area","In the Host field, enter the machine name or IP address of the content repository server.","In the Port field, enter the IntradocServerPort number of the content repository server. By default, this is 4444.","Go to WCCC_Home\\ucm\\cs\\config\\.","Edit the config.cfg file.","Find the IntradocServerPort line, which contains the port number.","In the Oracle Home field, enter the location of the framework folder.","For the framework folder, use the following format:","/&lt;FolderName&gt;","For example:","/P6EPPM","In the Oracle Security Group field, enter the name of the Security Group assigned to the document folder created in WebCenter for P6 EPPM documents, as specified when you configured the content repository. ","For Example:","Enter Oracle Security Group as Public.","In the Oracle Security Account field, enter the name of the Security Account for P6 EPPM documents, as specified when you configured the content repository. ","If you did not enable security accounts, leave this setting blank.","In the Oracle Document Type field, enter the document type for P6 EPPM documents, which can be either an existing document type or a new one, as specified when you configured the content repository. ","For example:","Enter the Document Type as Document.","In the Metadata Prefix field, enter the prefix added to P6 EPPM metadata fields, as specified when you configured the content repository. For example, Prm.","In the Admin User field, enter the user name with administrative privileges, as specified when you configured the content repository. This setting is required.","From the Authentication Mode drop-down menu, select the authentication mode used to access the content repository server. P6 EPPM users cannot access content repository functions if you do not configure this setting.","If you choose &quot;Multiple User&quot;, all P6 EPPM content repository-related user names must match the equivalent content repository user name. For example, a P6 EPPM user named &quot;Joe&quot; must have an equivalent user named &quot;Joe&quot; in the content repository. ","If you choose &quot;Single User&quot;, the administrative user specified in the setting above must have access to all appropriate SharePoint libraries to browse to documents outside of the P6 EPPM home folder.","Restart the P6 Server.","Configuring WCCC settings for the Primavera P6 Administrator<br /> (Primavera P6 EPPM Content Repository Configuration Guide for On-Premises)","English\\Configuring\\p6_eppm_content_repository_config\\91738.htm");
Page[392]=new Array("Content Management Interoperability Services (CMIS) is a standard that content repositories have agreed to adhere to so that a single document connector can be used to connect to any CMIS-compliant repository. ","You can connect any CMIS-compliant content repository, including SharePoint, to P6. The repository must be 100% CMIS-compliant to utilize all the features of P6 document functionality.","Configuring CMIS-Compliant Content Repository for P6<br /> (Primavera P6 EPPM Content Repository Configuration Guide for On-Premises)","English\\Configuring\\p6_eppm_content_repository_config\\65455.htm");
Page[393]=new Array("You can use Microsoft SharePoint with P6 by integrating SharePoint with your CMIS-compliant content repository and then configuring your CMIS-compliant content repository with P6.","To configure your CMIS-compliant content repository:","Open the Primavera P6 Administrator.","In the Configurations drop-down list, select your configuration.","In the sidebar selectDatabase.","Select your Instance from the drop-down list.","Expand Content Repository.","In the Type field, select CMIS.","Note Changes to these settings require you to restart the P6 server.","In the Maximum document size field, enter the maximum size in KB for documents that can be uploaded to P6. The default is 10240 KB. Enter a value between 0 and 1048576.","Note To block specific document types, enter a comma separated list of file extensions in the Invalid Document Types field in the Integration &amp; Allow Lists tab of the Application Settings in P6. Oracle recommends at least blocking the following document types: .exe,.com,.bat,.cmd,.vbs,.js,.msi.","In the SharePoint area:","In the Login Name field, enter the user name for your content repository.","In the Password field, enter the password for the user name you entered above.","In the Authentication Mode field, enter authentication mode used to access the content repository server. P6 EPPM users cannot access content repository functions if you do not configure this setting.","If you choose &quot;Multiple User&quot;, all P6 EPPM content repository-related user names must match the equivalent content repository user name. For example, a P6 EPPM user named &quot;Joe&quot; must have an equivalent user named &quot;Joe&quot; in the content repository.","If you choose &quot;Single User&quot;, the administrative user specified in the setting above must have access to all appropriate Security Groups to browse to documents outside of the P6 EPPM home folder.","In the Repository Name field, enter the name for your content repository.","Note For SharePoint, enter the document library name you created for P6. ","In the Document Home field, enter the location of the folder in the document library where you want to store P6 documents.","In the Web Service URL field, enter the URL for your web services home.","This is Web Service Endpoint with format http://&lt;sharepoint host&gt;/sites/&lt;site name&gt;/_vti_bin/cmissoapwsdl.aspx","Restart the P6 server.","Configuring CMIS-Compliant Content Repository in the Database Instance Settings<br /> (Primavera P6 EPPM Content Repository Configuration Guide for On-Premises)","English\\Configuring\\p6_eppm_content_repository_config\\65454.htm");
Page[394]=new Array("Configuring AutoVue without VueLink is the native AutoVue implementation. To use this implementation, you will configure a single AutoVue server that is common across all database instances.","Note","When you configure AutoVue without VueLink, you are creating global AutoVue settings. These settings override any individual settings you may have created to configure AutoVue with VueLink.","When upgrading to Version 25 from 15 R2 or earlier, AutoVue connection details are lost and must be entered again.","To configure AutoVue without VueLink, complete the following steps:","Open the Primavera P6 Administrator.","In the Configurations drop-down list, select your configuration.","In the sidebar select Document Viewing.","Note Changes to these settings require you to restart the P6 server.","Select Enable. The default value is unselected.","Note","SSL mode does not work when the Enable option is set to false.","By default, the ESAPI resources that come with VueLink is used. You can change the location of the resource files by using -Dorg.owasp.espai.resources JAVA_OPTIONS in the WebLogic application server or in the setDomainEnv script.","By default, dmsstamp.ini and the oracle sample stamp from VueLink is used to create markup. You can change the location of the dmsstamp.ini file, which contains the stampfile location, using -Dexternal.csi.intellistamp.def.location JAVA_OPTIONS in the WebLogic application server or in the setDomainEnv script. ","If using Oracle Access Manager with your P6 EPPM deployment, add following context roots to the Oracle Access Manager exclusion list:<br />/p6/VueServlet/**<br />/p6/jvueDMS/**<br />/p6/P6AutoVueJNLPLauncher/**<br />/p6/av_cert.pem<br />For more information about protecting your resources using Oracle Access Manager's exclusion list, see the &quot;Protecting Your Resources&quot; chapter in the Oracle Access Manager Configuration Guide.","Select Enable SSL if your AutoVue server is enabled with SSL to allow communication via HTTPS.","In the Host Name field, enter the hostname for the server where AutoVue is installed. ","Note Do not put a / at the end of the URL.","In the Host Port field, enter the port for the server where AutoVue is installed. The default port is 5099.","Restart the P6 server.","Configuring AutoVue without VueLink<br /> (Primavera P6 EPPM Content Repository Configuration Guide for On-Premises)","English\\Configuring\\p6_eppm_content_repository_config\\94037.htm");
Page[395]=new Array("Outside In converts documents uploaded to your content repository into a raster-image file. ","To configure Outside In:","Open the Primavera P6 Administrator.","In the Configurations drop-down list, select your configuration.","In the sidebar selectDocument Viewing.","In the Fonts Directory field, enter the full path to your operating system-specific fonts folder. For example, C:\\Windows\\Fonts.","Note You cannot convert documents in languages that do not have a compatible font installed in the Fonts Directory. Before you convert these documents you must install the appropriate language font.","In the Images Directory field, enter the full path to your Outside In images folder. For example, P6EPPM_HOME\\P6\\outsidein\\ImageExport\\Images.","Navigate to P6EPPM_HOME\\P6.","Run outsideInConfig.cmd or outsideInConfig.sh (based on your operating system).","Configuring Outside In<br /> (Primavera P6 EPPM Content Repository Configuration Guide for On-Premises)","English\\Configuring\\p6_eppm_content_repository_config\\96417.htm");
Page[396]=new Array("You can use Oracle database as a content repository with your P6 EPPM installation.","To configure the Oracle database as your content repository:","Open the Primavera P6 Administrator.","In the Configurations drop-down list, select your configuration.","In the sidebar selectDatabase.","Select your Instance from the drop-down list.","Expand Content Repository.","Note Changes to these settings require you to restart the P6 server.","In the Type field, select Oracle Database.","This option will save documents and associated information in the P6 database schema. This option is only applicable if you are using an Oracle database on-premises or an Oracle Autonomous Database.","In the Maximum document size field, enter the maximum size in KB for documents that can be uploaded to P6. The default is 10240 KB. Enter a value between 0 and 1048576.","Note To block specific document types, enter a comma separated list of file extensions in the Invalid Document Types field in the Integration &amp; Allow Lists tab of the Application Settings in P6. Oracle recommends at least blocking the following document types: .exe,.com,.bat,.cmd,.vbs,.js,.msi.","In the Connection Maintenance Interval field enter the frequency at which the connection to the content repository is validated. The default is 10 minutes. Enter a value between 1 second and 24 days.","Note Ensure that the Enable Cloud Storage field is set to false.","Restart the P6 server.","Configuring the Oracle Database Content Repository<br /> (Primavera P6 EPPM Content Repository Configuration Guide for On-Premises)","English\\Configuring\\p6_eppm_content_repository_config\\84126.htm");
Page[397]=new Array("If you upgraded to P6 or the content repository, you need to do one of the following:","If you upgraded from a previous P6 version, see Migrating the Content Repository if Upgrading P6.","If you upgraded UCM to 11.1.1.9 or higher, see Upgrading from Previous Universal Content Management Version to WCCC.","Upgrading the Content Repository<br /> (Primavera P6 EPPM Content Repository Configuration Guide for On-Premises)","English\\Configuring\\p6_eppm_content_repository_config\\78226.htm");
Page[398]=new Array("Run the migration utility before connecting the upgraded environment back to the Content Repository. Running the migration utility will ensure all project folder names in the Content Repository change from Database IDs to their Project ID field (from P6).","If you upgraded P6 from a previous version, you must:","Go to the P6EPPM_Home/p6 folder.","Run migrationtool.cmd or migrationtool.sh (based on your operating system).","Migrating the Content Repository if Upgrading<br /> (Primavera P6 EPPM Content Repository Configuration Guide for On-Premises)","English\\Configuring\\p6_eppm_content_repository_config\\78221.htm");
Page[399]=new Array("If you were using a previous version of Universal Content Management (UCM), you will notice many changes when you upgrade to a supported version of WCCC. To maintain your documents from P6, you should ensure that your framework folder has updated correctly. To do this, you should:","Shutdown all the P6 applications connecting to your current content repository. ","Run the migration utility.","Go to the P6EPPM_Home/p6 folder.","Run migrationtool.cmd or migrationtool.sh (based on your operating system).","Note","Users is a restricted folder name for folders within the folder structure in supported versions of WCCC.","Note the folder database converts project IDs to project short names.","Upgrade a previous version of UCM or WCCC to a supported version of WCCC or higher using the upgrade guide provided with the WCCC media packs.","Enable the framework folders components. ","After the migration:","Locate the migration_run**** folder that was created.","Move all the folders and documents under this folder to the Content repository home folder that you want to use.","Ensure you select inhibit propagation to ensure proper movement of documents and folders.","After the move completes, you can start using the documents with the correct content repository home.","Tip","Have 4-6 GB open memory space.","Don't propagate changes when given the option.","Upgrading from Previous Universal Content Management Version to WCCC<br /> (Primavera P6 EPPM Content Repository Configuration Guide for On-Premises)","English\\Configuring\\p6_eppm_content_repository_config\\65745.htm");
Page[400]=new Array("If you started using the document functionality of the P6 application without running migration utility provided with P6 on an upgraded environment, where you were using a content repository for managing documents, you will be unable to use the documents that were earlier associated with any Projects or Users.","Troubleshooting<br /> (Primavera P6 EPPM Content Repository Configuration Guide for On-Premises)","English\\Configuring\\p6_eppm_content_repository_config\\79887.htm");
var PageCount=25;


/*
Date: 12/11/2025 7:40 PM
Source: EPPM_25_dev
BookID: 50762
PubProduct: PRIMAVERA_EPPM
BookTitle: Content Repository Configuration Guide for On-Premises
Version: Version 25
Lang:	en
*/
/* relative_path_for_link: English\Configuring\p6_eppm_oas_config*** */
/* BookTitleTop: Primavera P6 EPPM Oracle Analytics Publisher Configuration Guide for On-Premises*** */
/* Generated with Author-it 23.4.1.30004  12/11/2025 7:39:18 PM */
Page[401]=new Array("Title and Copyright Information","Copyright  1999, 2025, Oracle and/or its affiliates.","Primary Author: Oracle Corporation","Title and Copyright Information<br /> (Primavera P6 EPPM Oracle Analytics Publisher Configuration Guide for On-Premises)","English\\Configuring\\p6_eppm_oas_config\\46576.htm");
Page[402]=new Array("Scope","Oracle Analytics Publisher integrates with the P6 EPPM Extended Schema to deliver on-demand web-based reporting through P6.","This guide describes how to:","Set parameters for Oracle Analytics Publisher and P6.","Configure Oracle Analytics Publisher in the Primavera P6 Administrator.","Set security settings in Oracle Analytics Publisher to work with P6.","Note These instructions only contain information on configuring Oracle Analytics Publisher to work with P6. They do not include information on installing Oracle Analytics Publisher. For Oracle Analytics Publisher installation instructions, see the documentation included with Oracle Analytics Publisher.","Audience","System administrators should use this guide.","Using This Guide","This guide assumes you have installed P6 and its supporting applications. For more information on installing P6 see the P6 EPPMInstallation and Configuration Guide.","About This Guide<br /> (Primavera P6 EPPM Oracle Analytics Publisher Configuration Guide for On-Premises)","English\\Configuring\\p6_eppm_oas_config\\50781.htm");
Page[403]=new Array("Before getting started, familiarize yourself with the way Oracle Analytics Publisher handles reports. P6 populates its list of reports from the Report Definitions that load from Oracle Analytics Publisher's web services. When you need to create or modify a report, you will use Oracle Analytics Publisher. The documentation on Oracle Analytics Publisher will help you understand how it works. Before continuing with the following sections, learn about the following Report Definitions from the Oracle Analytics Publisher documentation:","Data Model","Writing SQL queries and data templates","Parameters","Include these types: Text, Menu, Date, Boolean","Work with the &quot;List of Values&quot;","Include different settings that you can set","Templates","The graphic below will help you understand the basic flow between Oracle Analytics Publisher and P6.","Oracle Analytics Publisher Diagram","Item","Description","Log in with Oracle Analytics Publisher admin credentials and impersonate a P6 user.","Connect to the P6 EPPM Extended Schema with the PXRptUser. The PXRptUser must be in the same instance as the admuser.","You can add many other data sources for reports.","The data source you will work with to create reports will be the P6 EPPM Extended Schema database. Note that the Publication Services populate the tables and views used for reporting in the P6 EPPM Extended Schema. Configure and run the Publication Services before you run any report that uses the P6 EPPM Extended Schema. For more information on configuring Publication Services, see Working with Publication Services, Configuring Publication Settings in Services Settings, and Configuring Publication Services in Services Settings.","Note Oracle recommends you use the P6 EPPM Extended Schema database for reporting. The Primavera Data Warehouse is an optional add-on component to P6 EPPM, which supports Analytics, third-party reporting tools, off-line analysis, and the consolidation of P6 data into larger corporate data warehouses.","Getting Started with Oracle Analytics Publisher Reports<br /> (Primavera P6 EPPM Oracle Analytics Publisher Configuration Guide for On-Premises)","English\\Configuring\\p6_eppm_oas_config\\47001.htm");
Page[404]=new Array("P6 relies on Oracle Analytics Publisher and the P6 EPPM Extended Schema to produce reports. ","To configure P6 to run reports:","If not already set up, create a Oracle Analytics Publisher environment to manage reports. See the documentation included with Oracle Analytics Publisher.","Configure sample reports, roles, security, and users in Oracle Analytics Publisher. See Configuring Enterprise Reporting with Oracle Analytics Publisher.","Populate Oracle Analytics Publisher settings in the Primavera P6 Administrator. See Configuring the Primavera P6 Administrator for Oracle Analytics Publisher and Publication Services","For Publication Services, you will also need to configure the Primavera P6 Administrator settings. You can configure publication settings for General Data, Time Distributed Data, Blob Data, and Log retention. You can also configure publication services settings for Project Arbiter, Projects, Enterprise Data, Enterprise Summaries, Resource Management, and Security. For more information, see Configuring Publication Settings in Services Settings, and Configuring Publication Services in Services Settings.","Configure and deploy the Publication Services required to populate the reporting views in the P6 EPPM Extended Schema. See Working with Publication Services and Publishing P6 Data.","Configure Oracle Analytics Publisher to allow P6 to use parameter keys so users do not have to enter field values for reports. See Why Do I Need Parameters?.","When you begin working in P6, you can configure your application settings and global scheduled services. See the P6 EPPM Application Administration Guide for more information on scheduled services and application settings.","Provide users with the 'Edit EPS Costs/Financials' project privilege if they need to view project costs in a report generated from the P6 EPPM Extended Schema. See information about security profiles in the P6 EPPM Application Administration Guide.","Configuring P6 for Reporting<br /> (Primavera P6 EPPM Oracle Analytics Publisher Configuration Guide for On-Premises)","English\\Configuring\\p6_eppm_oas_config\\46852.htm");
Page[405]=new Array("The following topics describe how to configure reports in Oracle Analytics Publisher to work with P6. To follow these topics you will need to be able to access:","WebLogic Server Administration Console","&lt;host&gt;:&lt;port&gt;/console","Oracle Enterprise Manager","&lt;host&gt;:&lt;port&gt;/em","Oracle Analytics Publisher:","&lt;host&gt;:&lt;port&gt;/xmlpserver","Oracle Analytics Publisher:","&lt;host&gt;:&lt;port&gt;/analytics","Configuring Enterprise Reporting with Oracle Analytics Publisher<br /> (Primavera P6 EPPM Oracle Analytics Publisher Configuration Guide for On-Premises)","English\\Configuring\\p6_eppm_oas_config\\51738.htm");
Page[406]=new Array("Oracle Analytics Publisher requires you to connect your P6 EPPM database to Oracle Analytics Publisher using a JDBC connection string.","To create the JDBC connection string:","Log in to Oracle Analytics Publisher as an administrative user.","Click My Profile and select Administration.","Under Data Sources, click the JDBC Connection link.","Click Add Data Source or choose the data source name you want to use.","In the General section:","In the Data Source Name field, enter one of the following data source names:","For Oracle, P6RPT.","For Microsoft SQL Server, P6SSRPT.","In the Driver Type field, select your version.","In the Database Driver Class field, enter the JDBC driver class for your database.","In the Connection String field, enter your JDBC connection string for the P6 EPPM Database.","Clear the Use System User option.","In the Username field, enter your Reporting database user name (for example, pxrptuser).","In the Password field, enter your Reporting database user password.","(For an Oracle database only) In the Pre Process Function field, enter the following:","Secpac.SET_BIP_USER(:xdo_user_name)","Clear the Use Proxy Authentication option for this data source definition.","Click Test Connection.","In the Security section:","In the Available Roles list, select BI Consumer, BI Content Author, and BI Service Administrator.","Click Move selected items to other list.","Click Apply.","Creating the JDBC Connection String for Oracle Analytics Publisher<br /> (Primavera P6 EPPM Oracle Analytics Publisher Configuration Guide for On-Premises)","English\\Configuring\\p6_eppm_oas_config\\81740.htm");
Page[407]=new Array("You can use P6 sample reports to test the functionality of your Oracle Analytics Publisher integration.","Note The P6 EPPM sample reports were designed to be run against the small data set included in the sample database. These reports are provided as an example of the product's capability only. Oracle provides no guarantee, implied or explicit, that the sample reports will run against your database or will produce meaningful data when they are run against your database. You may modify the sample reports to suit your own data set, including adding filter criteria to limit data output or changing filter criteria to suit your data.","Before you can upload the sample reports to the catalog:","Extract the contents of P6Reports.zip from the P6 media pack.","Note the location of the P6Reports.xdrz file in the BIPP6reportsOracle (for Oracle) or BIPP6reportsSQLServer (for Microsoft SQL Server) folder.","To upload the sample reports to the catalog:","Log in to Oracle Analytics Publisher as an administrative user.","Click Catalog.","Click Shared Folders.","Click Upload in the Tasks pane.","In the Upload window:","Click Choose File.","Navigate to and select P6Reports.xdrz and click Open.","Click Upload.","Verify that the P6Reports folder is present under Shared Folders.","Adding P6 Sample Reports<br /> (Primavera P6 EPPM Oracle Analytics Publisher Configuration Guide for On-Premises)","English\\Configuring\\p6_eppm_oas_config\\81741.htm");
Page[408]=new Array("To read, run, schedule, and view reports, you must assign the BIConsumer role access to the objects in the P6Reports catalog.","To assign permissions to the P6Reports catalog:","Log in to Oracle Analytics Publisher as an administrative user.","Select Catalog.","Under Shared Folders, select the P6Reports folder.","In the Tasks pane, click Permissions.","In the Permissions window:","For the BI Consumer account:","In the Permissions list, select Custom, then in the Custom Permissions window, clear all options except Read, Traverse, Run Publisher Report, Schedule Publisher Report, and View Publisher Output.","For the BI Content Author account:","In the Permissions list, select Full Control.","For the BI Service Administrators account;","In the Permissions list, select Full Control.","Select the Owner option.","Select Apply permissions to sub-folders.","Select Apply permissions to items within folder.","Click OK to save.","Assigning Permissions to the P6Reports Catalog Folder<br /> (Primavera P6 EPPM Oracle Analytics Publisher Configuration Guide for On-Premises)","English\\Configuring\\p6_eppm_oas_config\\81745.htm");
Page[409]=new Array("Create groups in Oracle Analytics Publisher to contain the user accounts that will have access to reports.","To create groups in Oracle Analytics Publisher for P6 EPPM:","Log in to the WebLogic Administration Console.","In the Domain Structure pane, select Security Realms.","In the Summary of Security Realms pane, select myrealm.","Select the Users and Groups tab.","Select the Groups sub-tab.","Select New.","In the Create a New Group section, in the Name field type BIConsumers.","In the Provider list, select DefaultAuthenticator.","Click OK.","Repeat step 6 to create two further groups called BIContentAuthors and BIServiceAdministrators.","Creating Groups in Oracle Analytics Publisher<br /> (Primavera P6 EPPM Oracle Analytics Publisher Configuration Guide for On-Premises)","English\\Configuring\\p6_eppm_oas_config\\102107.htm");
Page[410]=new Array("Create groups in Oracle Analytics Publisher to contain the user accounts that will have access to reports.","To create groups in Oracle Analytics Publisher for P6 EPPM:","Log in to Oracle Enterprise Manager as an administrative user.","On the WebLogic Domain menu, select Security, Application Roles.","On the Application Stripe list, select obi.","In the Role Name field, selects Starts With and type BI into the field, then click Search application roles.","In the Role table, select BIServiceAdministrators and click Edit.","In the Edit Application Role screen, select click Add.","In the Add Principal screen:","On the Type list, select Group.","In the Display Name field, select Starts With and type BI into the field, then click Search roles.","In the Searched Principals table, select BIServiceAdministrators.","Click OK.","Repeat steps 5 to 7 to map the BIConsumers role to the BIConsumers group.","Repeat steps 5 to 7 to map the BIContentAuthors role to the BIContentAuthors group.","Mapping Roles to Groups in Oracle Analytics Publisher<br /> (Primavera P6 EPPM Oracle Analytics Publisher Configuration Guide for On-Premises)","English\\Configuring\\p6_eppm_oas_config\\102108.htm");
Page[411]=new Array("Create a reporting user in Oracle Analytics Publisher that matches an equivalent user in P6, for every user who will use the reporting feature, to ensure you have users who can run reports in both applications.","To create reporting users in Oracle Analytics Publisher for P6 EPPM:","Log in to the WebLogic Administration Console.","In the Domain Structure pane, select Security Realms.","In the Summary of Security Realms pane, select myrealm.","Select the Users and Groups tab.","Select the Users sub-tab.","Click New.","In the Create a New User screen:","On the Name field, type a name for the user.","In the Password field, type a password for the user.","In the Confirm Password field, re-type the password for the user.","Click OK.","Note","If using LDAP, complete these steps by configuring an LDAP provider.","The password for the user does not have to match the user's P6 password.","Select the newly created user.","In the Settings for User screen, select the Groups tab.","In the Parent Groups section, on the Available list, select BIConsumers, BIContentAuthors and BIServiceAdministrators, then click Move selected items from the Available list to the Chosen list.","Click Save.","Creating Reporting Users in Oracle Analytics Publisher for P6 EPPM<br /> (Primavera P6 EPPM Oracle Analytics Publisher Configuration Guide for On-Premises)","English\\Configuring\\p6_eppm_oas_config\\81749.htm");
Page[412]=new Array("Use the Primavera P6 Administrator to connect Oracle Analytics Publisher and P6 and to set your Publication services to populate reporting views.","For your publication services and settings, Oracle recommends having at least two configurations: one for application servers hosting P6 and another for the background service applications that run services but do not process web pages. You can create more configurations as needed.","For the P6 application server, limit background services and how often they run. This will allow user's requests to process more quickly.","For the background services configuration, you can have more threads configured and run them at shorter intervals. For information on setting up a separate server for job services, see the P6 EPPM System Administration Guide.","If you are running background services and P6 on the same server, Oracle recommends keeping the settings' defaults for your configuration.","Configuring the Primavera P6 Administrator for Oracle Analytics Publisher and Publication Services<br /> (Primavera P6 EPPM Oracle Analytics Publisher Configuration Guide for On-Premises)","English\\Configuring\\p6_eppm_oas_config\\53857.htm");
Page[413]=new Array("You must configure Oracle Analytics Publisher settings for Oracle Analytics Publisher to work with P6.","To configure your Oracle Analytics Publisher settings:","Open the Primavera P6 Administrator.","In the Configurations drop-down list, select your configuration.","In the sidebar selectDatabase.","Select your Instance from the drop-down list.","Expand BI Publisher.","Note Changes to these settings require you to restart the P6 server.","Select Personal Folders, to enable personal folders per user. If you do not want to use personal folders, leave the option clear. Users have their own personal folders where they can store their objects. Only the user who created and saved the content in the folder can access the folder.","In the Server URL field, enter the URL used to connect to the Oracle Analytics Publisher web service to P6.","For example, http://serverIP:port/xmlpserver/services/PublicReportService?wsdl","In the Folder Paths field, enter the relative path to the Oracle Analytics Publisher P6 reports folder where P6 will search for reports.","Example format (the forward slash is required):","/P6REPORTS","In the Version field, enter the version of Oracle Analytics Publisher that you want to integrate with P6.","In the Admin Username field, enter the username for a WebLogic Server Administrator.","In the Password field, enter the password for the WebLogic Server Administrator.","In the Sender Email ID field, enter the email address that you want users to see if they choose to receive reports by email.","Configuring Oracle Analytics Publisher in the Primavera P6 Administrator<br /> (Primavera P6 EPPM Oracle Analytics Publisher Configuration Guide for On-Premises)","English\\Configuring\\p6_eppm_oas_config\\51591.htm");
Page[414]=new Array("Modify publication settings to specify constraints on your report publishing jobs. ","To configure your publication settings:","Note The default settings should be the optimal settings for most environments. Change them only if your environment requires different settings.","Open the Primavera P6 Administrator.","In the Configurations drop-down list, select your configuration.","In the sidebar expandServices, then expand Publication, and select Settings.","To configure General Data:","In the Page Size field, enter the maximum number of rows of general data a job can process. This applies to each business object that falls under the general category; general data is not time-distributed (spread), not hierarchical, and not in a blob. When using this setting, each business object processes separately.","The default value is 32.","Enter a value between 1 and 8192.","In the Max Job Count field, enter the number of processes used for this service on your server.","The default value is 1.","Enter a value between 1 and 20.","To configure Blob Data:","In the Page Size field, enter the maximum number of rows of blob data that a job can process. This applies to each business object that falls under the blob category. When using this setting, each business object processes separately.","The default value is 25.","Enter a value between 1 and 8192.","In the Max Job Count field, enter the number of processes used for this service on your server.","The default value is 1.","Enter a value between 1 and 20.","To configure TimeDistributed:","In the Page Size field, enter the maximum number of rows of time-distributed (spread) data that a job can process. This applies to each business object that falls under the time-distributed category. When using this setting, each business object processes separately.","The default value is 16.","Enter a value between 1 and 8192.","In the Max Job Count field, enter the number of processes used for this service on your server.","The default value is 1.","Enter a value between 1 and 20.","To configure Log:","In the Security Level drop-down menu, select the level of information contained in the log file for all publication services. The ranges are inclusive. For example, select debug to log all messages; select info to log details about what runs, exceptions, and warnings; select warning to log both warning and error level messages.","The default value is info.","Select info, debug, warning, or error.","In the Global Service Log File Cap (Success) field, enter the number of logs to retain for successful global publication services. This will retain a log for each global service. If set to 5, the last 5 successful service runs will be retained for each global service.","The default value is 5.","Enter a value between 1 and 25.","In the Global Service Log File Cap (Fail) field, enter the number of logs to retain for failed global publication services. This will retain a log for each global service. If set to 5, the last 5 failed service runs will be retained for each global service.","The default value is 5.","Enter a value between 1 and 25.","In the Project Service Log File Cap (Success) field, enter the number of logs to retain for successful Publish Project jobs. This will retain a log for each project service. If set to 5, the last 5 successful service runs will be retained.","The default value is 5.","Enter a value between 1 and 25.","In the Project Service Log File Cap (Fail) field, enter the number of logs to retain for failed Publish Project jobs. This will retain a log for each project service. If set to 5, the last 5 failed service runs will be retained, per project.","The default value is 5.","Enter a value between 1 and 25.","Configuring Publication Settings in Services Settings<br /> (Primavera P6 EPPM Oracle Analytics Publisher Configuration Guide for On-Premises)","English\\Configuring\\p6_eppm_oas_config\\51618.htm");
Page[415]=new Array("If you are running services and P6 on the same server, you should keep the defaults. If you have scheduling work that needs to be done immediately, you should set the Interval low (for example, 10s) and the Concurrent Threads high. Remember that if the server is actively applying the service, all users will experience delays in the application.","To configure your publication settings:","Open the Primavera P6 Administrator.","In the Configurations drop-down list, select your configuration.","In the sidebar expand Services, then expand Publication, and select Services.","You can use Project Arbiter to automate submitting Publish Project services for eligible projects to the service queue.","To configure Project&nbsp;Arbiter:","Select Active Mode if you want jobs processed continuously until all jobs finish. Leave this field clear if you want each job processed according to the Interval.","In the Interval field, enter the amount of time the service will wait before running the next available job.","The default value is 10s.","Enter a value between 1s and 24d20h31m23s647.","In the Concurrent Threads field, enter the number of processes used for this service on this server. A value of 0 indicates that this service will not run on this server. ","The default value is 1. ","Enter either 0 or 1.","To configure Publish Enterprise Summaries:","Note Publish Enterprise Data, Enterprise Summaries, Resource Management, and Security will recalculate data and store it in physical fields in the Extended Schema tables, and will perform other data denormalization tasks. For example, duration fields are calculated fields in the existing P6 schema tables, but will be recalculated and stored as physical fields in the extended schema tables when a project is published.","Select Active Mode if you want jobs processed continuously until all jobs finish. Leave this field clear if you want each job processed according to the Interval.","In the Interval field, enter the amount of time the service will wait before running the next available job.","The default value is 10s. ","Enter a value between 1s and 24d20h31m23s647.","In the Concurrent Threads field, enter the number of processes used for this service on this server. A value of 0 indicates that this service will not run on this server. ","The default value is 1. ","Enter either 0 or 1.","To configure Publish Resource Management:","Select Active Mode if you want jobs processed continuously until all jobs finish. Leave this field clear if you want each job processed according to the Interval.","In the Interval field, enter the amount of time the service will wait before running the next available job.","The default value is 10s. ","Enter a value between 1s and 24d20h31m23s647.","In the Concurrent Threads field, enter the number of processes used for this service on this server. A value of 0 indicates that this service will not be run on this server. ","The default value is 1. ","Enter either 0 or 1.","To configure Publish Resource Role Assignment:","Select Active Mode if you want jobs processed continuously until all jobs finish. Leave this field clear if you want each job processed according to the Interval.","In the Interval field, enter the amount of time the service will wait before running the next available job.","The default value is 10s.","Enter a value between 1s and 24d20h31m23s647.","In the Concurrent Threads field, enter the number of processes used for this service on this server. A value of 0 indicates that this service will not run on this server.","The default value is 1.","Enter either 0 or 1.","To configure Publish Project:","Select Active Mode field if you want jobs processed continuously until all jobs finish. Leave this field clear if you want each job processed according to the Interval.","In the Interval field, enter the amount of time the service will wait before running the next available job.","The default value is 10s. ","Enter a value between 1s and 24d20h31m23s647.","In the Concurrent Threads field, enter the number of processes used for this service on this server. A value of 0 indicates that this service will not be run on this server. ","The default value is 2. ","Enter a value between 0 and 20.","To configure Publish Enterprise Summaries:","Note Publish Enterprise Data, Enterprise Summaries, Resource Management, and Security will recalculate data and store it in physical fields in the Extended Schema tables, and will perform other data denormalization tasks. For example, duration fields are calculated fields in the existing P6 schema tables, but will be recalculated and stored as physical fields in the extended schema tables when a project is published.","Select Active Mode if you want jobs processed continuously until all jobs finish. Leave this field clear if you want each job processed according to the Interval.","In the Interval field, enter the amount of time the service will wait before running the next available job.","The default value is 10s. ","Enter a value between 1s and 24d20h31m23s647.","In the Concurrent Threads field, enter the number of processes used for this service on this server. A value of 0 indicates that this service will not run on this server. ","The default value is 1. ","Enter either 0 or 1.","Configuring Publication Services in Services Settings<br /> (Primavera P6 EPPM Oracle Analytics Publisher Configuration Guide for On-Premises)","English\\Configuring\\p6_eppm_oas_config\\51619.htm");
Page[416]=new Array("To test P6 sample reports, you must:","Assign Enterprise Reports module access to the P6 user.","Have a Oracle Analytics Publisher user who matches your P6 user name and has the P6 Reports role.","Run publication services first to ensure the report runs successfully.","To test sample reports:","Log in to P6.","Click Reports.","On the Report page:","Click the Reports tab.","Select a report.","Click Run....","In the Run Report dialog box:","In the Schedule Name field, enter a name for the report.","In the Template list, choose a template to apply to the report.","In the Output Format list, choose a file format for the delivery of the report.","In the Delivery Type list, choose to have the report sent through email or display the file immediately.","If you chose Email, click @&nbsp;Send&nbsp;Email and enter or select email addresses for the intended report recipients.","If you chose File, the report will display after you click Run.","If you chose Email, in the Notification section, choose to send yourself a status notification of the report run.","In the Report Parameters section, specify values for the parameters in the Field Name column. You can enter values directly in the field or double-click in the field and click @&nbsp;Select to open a selection dialog box.","Note","When selecting project parameters, if you choose to add an EPS to the Selected Projects list, only the projects directly under the EPS are added. If additional EPS elements are under the parent EPS, these projects will not automatically be included in the report; however, you can select additional EPS elements and add them to the Selected Projects list.","To avoid system performance issues, be as specific as possible when entering values for reports. Narrow down your choices to include only what is absolutely necessary.","Click Run.","Tip","Refer to the sample reports included with P6 for examples on how to create Oracle Analytics Publisher reports to use with P6 on an Oracle database.","You can find sample reports in the P6reports.zip folder of the P6 EPPM physical media or download. ","Use the BIPP6reportsOracle folder.","NoteThe P6 EPPM sample reports were designed to be run against the small data set included in the sample database. These reports are provided as an example of the product's capability only. Oracle provides no guarantee, implied or explicit, that the sample reports will run against your database or will produce meaningful data when they are run against your database. You may modify the sample reports to suit your own data set, including adding filter criteria to limit data output or changing filter criteria to suit your data.","Testing P6 Sample Reports<br /> (Primavera P6 EPPM Oracle Analytics Publisher Configuration Guide for On-Premises)","English\\Configuring\\p6_eppm_oas_config\\51675.htm");
Page[417]=new Array("Use the information in this section to setup Oracle Analytics Publisher with LDAP. Before you begin, ensure you have:","Set P6 EPPM to use LDAP. See the P6 EPPM System Administration Guide for more information.","Assigned the Enterprise Reports module in P6 to each user who needs access to reports.","Restart the Oracle Analytics Publisher server.","Configuring Oracle Analytics Publisher for LDAP<br /> (Primavera P6 EPPM Oracle Analytics Publisher Configuration Guide for On-Premises)","English\\Configuring\\p6_eppm_oas_config\\54175.htm");
Page[418]=new Array("To utilize LDAP, you should configure Oracle Analytics Publisher to use the &quot;Oracle Fusion Middleware&quot; security model and configure WebLogic to use LDAP.","To configure WebLogic to use LDAP:","Log in to WebLogic.","Under Domain Structure, select Security Realms.","Select the myrealm link.","In the settings for myrealm page, select the Providers tab.","Select the DefaultAuthenticator link.","Select Lock and Edit in the Change Center.","Set the Control Flag dropdown to Sufficient.","Save your changes.","Return to the Providers page.","Select the new button to create a new provider (this will allow you to connect to an LDAP server).","In the Name field, call the provider anything you want.","In the Type dropdown, select the provider that makes sense for your environment (if active directory, select 'ActiveDirectoryProvider').","Select OK.","Select the link for the provider you created.","On the Common tab, set the Control Flag to Sufficient.","Select the Provider Specific tab.","Configure the fields to connect to one of your LDAP servers.","Save the changes.","Return to the Providers page.","Select the Reorder button and move the LDAP provider to the top of your list.","If needed, repeat these steps to create additional LDAP Server connections.","In the Change Center section, select Active Changes.","Note Do not restart Oracle Analytics Publisher until you complete the steps in the following sections.","Configuring WebLogic For Multiple LDAP Servers<br /> (Primavera P6 EPPM Oracle Analytics Publisher Configuration Guide for On-Premises)","English\\Configuring\\p6_eppm_oas_config\\85507.htm");
Page[419]=new Array("To use LDAP authentication, you must configure your Oracle Analytics Publisher deployment to connect with multiple security providers.","To connect Oracle Analytics Publisher to multiple security providers:","Log in to Enterprise Manager in the Oracle Analytics Publisher domain (http://adminserverhost:port/em) as your WebLogic admin user.","On the left pane, expand the WebLogic Domain folder.","Right-click on your domain and select Security, Security Provider configuration.","Default domain: bi","Under the Identity Store Provider grouping, click Configure.","Click Add to add a custom property:","In Property Name field, enter virtualize.","In Property Value field, enter true.","Select OK.","Log out of Enterprise Manager.","Configuring Oracle Analytics Publisher To Connect To Multiple Security Providers<br /> (Primavera P6 EPPM Oracle Analytics Publisher Configuration Guide for On-Premises)","English\\Configuring\\p6_eppm_oas_config\\85508.htm");
Page[420]=new Array("You must restart Oracle Analytics Publisher for authentication settings changes to take effect and to begin using LDAP authentication.","To confirm you have successfully configured LDAP:","Restart the Oracle Analytics Publisher server.","Log in to WebLogic Administrative console.","Under Domain Structure, select Security Realms.","Select the myrealm link.","In the settings for myrealm page, select the Users and Groups tab. You should see users from the LDAP providers you set up. This confirms successful configuration of &lt;0P_ProdName_OASs&gt;.","Restarting Oracle Analytics Publisher Domain and Confirming LDAP Setup<br /> (Primavera P6 EPPM Oracle Analytics Publisher Configuration Guide for On-Premises)","English\\Configuring\\p6_eppm_oas_config\\85509.htm");
Page[421]=new Array("Data in the P6 Extended Schema is calculated and stored by Publication Services, which gives administrators control over when data is calculated and stored in the P6 Extended Schema. Publication Services exist for project and global data. Global data includes enterprise data, as well as resource and role, portfolio, security and audit data. Project data includes all information about projects and baselines, including summaries and calculations. ","The Publish Project service is dedicated to publishing project and baseline data to the P6 Extended Schema.","Note The Publish Project service recalculates and publishes all project business objects containing calculated or denormalized data including, but not limited to: the WBS, activities, resource/role assignments, high-level planning assignments, relationships, risks, documents, expenses, steps, milestones, UDF values, notes, issues, budget change logs, timesheets, code assignments, funding source assignments.","These additional Publication Services publish global data to the P6 Extended Schema:","Publish Audit Data","Publish Enterprise Data","Project Data","Activity Data","Resource Data","Calendar Data","Enterprise Data dictionary definitions","Publish Enterprise Summaries","Publish Resource Management","Publish Security","The first time a data type is published to the P6 Extended Schema all data is recalculated and published to the extended schema tables. After a data type has been published for the first time, future publication services recalculate and publish only data that has changed since the last time that data was published.","When any of the publication services runs, each business object type processed by the service is individually timestamped, and the timestamp stored in the database. The services can accurately determine exactly which data has changed since the last time it was published using these timestamps because they exist at the individual business object type level.","Configure Publication Services in P6 as follows:","Set up automatic publication and enable P6 to publish project and global data on the Services page in Application settings. ","Enable the types of global data to be scheduled in Global Scheduled Services. ","Disable or enable publication for a selected project on the Services page in Project Preferences. ","Add, verify the status of, modify, or delete project management services on the Project Scheduled Services page. ","Tip","Run the global data services before turning on the Project Arbiter service.","Publication Services<br /> (Primavera P6 EPPM Oracle Analytics Publisher Configuration Guide for On-Premises)","English\\Configuring\\p6_eppm_oas_config\\66129.htm");
Page[422]=new Array("Before you can generate reports or view data in some areas of P6, data must be refreshed and calculations must be made in precisely arranged tables and fields. Publication Services address these needs, gathering and calculating data as close as possible to real-time. To make this happen, you can configure P6 to publish data to specific tables used for these features. An administrator must configure settings for Publication Services before you can publish data. For reports, depending on the type of data published, P6 tables may still be used to generate reports, or a combination of P6 and reporting tables may be used to generate them. ","Your organization's P6 EPPM published data has two categories: project data and global data. ","Published project data includes all information about your projects, including aggregates, calculations, and auditing data. Most pages that use published data use published project data.","You can publish project data on an ad-hoc basis using the Publish Projects item on the Actions menu of the EPS or Activities pages, allow P6 to publish automatically on the basis of how much the project has changed, or you can schedule a service to publish project data automatically.","Published global data includes enterprise data for projects (for example, codes and UDFs), activities (for example, codes and UDFs), resources, and calendars as well as the enterprise data dictionary and security data. Reports use published global data as well as published project data. ","Global data is published by services which are usually scheduled to run automatically.","P6 tracks all projects enabled for publishing and determines when each project will be published on the basis of the number of changes made to the project and the time since its data was last published. You can configure the settings guiding this process on the Services page of Application Settings.","Publish a changed project when the... Number of changes exceeds: P6 tracks the combined number of changes to the project itself as well as its WBS, activities, relationships, resource and role assignments, risks, project codes, activity codes, and UDFs.","Publish a changed project when the... Time since last publication exceeds: P6 also considers when the project was most recently published and whether that period exceeds the Time since last publication setting.","If both the number of changes is great enough and the published data is old enough, as stipulated by these two settings, P6 creates a job to publish the data.","Note P6 has checks in place to ensure that publishing jobs cannot impair system performance, no matter how many jobs are created at any given time.","About Publication Services<br /> (Primavera P6 EPPM Oracle Analytics Publisher Configuration Guide for On-Premises)","English\\Configuring\\p6_eppm_oas_config\\48710.htm");
Page[423]=new Array("To achieve near real-time reporting, usage, and analysis date, you can configure P6 to publish to tables that store updated data, including calculations and summary data. These tables also create views for generating reports. The P6 data is split into two general categories: project data and global data. Project data includes all information about your projects, including aggregates and calculations. Global data includes enterprise data, as well as resource and role, portfolio, and security data. The image below encapsulates the key concepts in the publication and reporting process.","Table of Key Publication Services Concepts","Item","Description","EPPM Database: The EPPM database captures all the data your organization generates every second of every day. However, the raw data in the EPPM database is not structured for immediate reporting.","Project Data: You can configure P6 to publish a project based on publication thresholds. Based on the options you select, you can prioritize projects for publication in a queue. If necessary, you can manually add a project to the queue. ","Global Data: You can configure services in P6 to schedule the publication of global data based on recurring intervals that you specify. If necessary, you can also immediately publish this data manually.","Project Queue: Projects publish in sequential order based on priority. Your administrator can control which projects are added to the publishing queue, when, and in what order. These options ensure the project data you need most is available for P6 in near real-time.","P6 Extended Schema Tables: The project and global services recalculate certain logical fields in the P6 EPPM database and store them as physical fields in the P6 Extended Schema tables so they are available for reporting and other purposes. Some fields in P6, such as durations, are calculated in real time as related field data is changed and are not stored in the database. Publication services recalculate these fields and store their values in the extended schema tables. Other fields, such as notebook topics, are not stored in the database in a format suitable for reporting. For these fields, publication services will convert them to a format more suitable for reporting.","Note For information about which tables are updated by the Publication Services, see the following knowledge management document:","What PX tables are updated when running Global Scheduled Services or Publish Project (KB495991)","P6 Reports: You can run reports directly against P6 Extended Schema table views.","Working with Publication Services<br /> (Primavera P6 EPPM Oracle Analytics Publisher Configuration Guide for On-Premises)","English\\Configuring\\p6_eppm_oas_config\\49312.htm");
Page[424]=new Array("Before data can be published, you must configure the settings that control publishing in P6.","Specify the timeframe for which data should be published and the distribution interval for the published data.","See Defining Publication Periods.","Enable publication and specify how often data will be published.","See Enabling Automatic Publishing of P6 Project Data.","Determine the types of enterprise and project data to publish.","See Enabling Automatic Publishing of P6 Global Data.","Specify which projects should be published and the relative priorities of projects for publishing.","See Configuring Publication Service Settings for Projects.","Optionally set up services to publish project data at scheduled intervals.","See Creating Project Scheduled Services.","Configuring Publication<br /> (Primavera P6 EPPM Oracle Analytics Publisher Configuration Guide for On-Premises)","English\\Configuring\\p6_eppm_oas_config\\101756.htm");
Page[425]=new Array("Reports based on P6 data require timely access to the most current data in order to be accurate. For example, report recipients expect to see updated enterprise data and project data including any calculations. ","Some other areas of P6 also rely on published data to provide accurate information.","In order to provide this data, P6 generates and stores data in reporting tables (the P6 Extended Schema). You can configure P6 to publish essential data to the tables automatically, schedule the publication of project data to happen at specific times of day, or you can choose to generate it on demand so that the most current data is available. You can select to be notified by email if publication services fail.","The data is split into two general categories: project data and global data. Project data includes all information about your projects, including baselines, summaries, calculations, and audit data. Global data includes enterprise data, project, activity, resource, calendar, enterprise data dictionary, resource and role data, security and audit data. Most pages that use published data access project data. Reports can use both project and global data.","Note In areas of the software that show published data, a user who has the right to view costs and financials at WBS level but not at Project level will not see financial data at the WBS level. Although the user has the privilege to view cost and financial data at WBS level, the data is only published at project level.","Publishing P6 Data<br /> (Primavera P6 EPPM Oracle Analytics Publisher Configuration Guide for On-Premises)","English\\Configuring\\p6_eppm_oas_config\\48619.htm");
Page[426]=new Array("Before publishing global or project data for reporting, define the publication period. The publication period you define should be large enough to capture all the project data you need to include in reports. Data before or after the defined publication period range is assigned to the period before or after the publication period range (respectively).","Caution You can perform these steps again at any time to modify your settings. However, if an Admin Superuser modifies the Start date, Time distributed interval, or Finish date is current date plus fields, all data will be fully recalculated. Oracle recommends that you only reconfigure publication options on weekends or during off-peak hours to prevent the disruption of other P6 features.","To define the publication period:","Click Administration.","On the Administration navigation bar, click Application Settings.","On the Application Settings page, click Services.","On the Services page, in the Publication Periods section:","In the Start date field, click @&nbsp;Select&nbsp;Date to select the exact month, day, year, and time to mark the initial start of the data publication period. Select any date in the past that represents a reasonable amount of historical spread data for your organization. For example, in order for users to be able to produce time-distributed reports for any date range, enter the earliest project start date at your organization.","In the Finish date is current date plus field, select a numeric quantity and unit of time to construct a dynamic period of time. Whenever a publication service runs, this period of time is added to the current date to determine the finish date for the publication of data. For example, if the value is 5 years, time-distributed data will always be published covering the period of time that begins with the value in the Start Date field and extends five years into the future each time a service runs.","In the Time distributed interval field, select the unit of time in which time distributed data will be recalculated and published. Time distributed interval is set to Week by default. Set this to Day if you need to see daily data.","Click Save.","Defining Publication Periods<br /> (Primavera P6 EPPM Oracle Analytics Publisher Configuration Guide for On-Premises)","English\\Configuring\\p6_eppm_oas_config\\49552.htm");
Page[427]=new Array("Perform the following procedure to enable projects for publication, and to set options for automatic project publication. Then, as you work, P6 automatically detects the changes to your projects that trigger the publication of their data.","To enable Publication Services for project data:","Click Administration.","On the Administration navigation bar, click Application Settings.","On the Application Settings page, select Services.","On the Services page, in the Project Publication section:","Select Enable Publish Projects to enable automatic project publication based on defined thresholds. Selecting this option also allows users to publish projects on demand.","In the Publish projects every field, select an interval by which projects are polled to be published.","Enter a number in the Number of changes exceeds field. This threshold setting determines the number of edits users can make to the project data before P6 publishes its data. Assuming a constant rate of change among projects, a lower value will result in more frequent publication of project data. If you enter a value of 0, projects with tracked changes will be automatically published.","Enter a time period for the Time since last publication exceeds field. This threshold setting determines how often the publication of project data should occur. For example, if you enter 12 hours, the project data will be published every 12 hours unless the threshold for the number of changes has already been reached. ","Select Publish idle projects to add projects to the service queue that are enabled for publication but have not been changed during the time threshold. This setting is only valid for the initial run of the service.","In the Maximum number to publish field, enter the maximum number of pending idle Publish Project services that can be present at once in the service queue. This prevents performance problems during peak demand when enabling the publication of a large number of projects. For example, if the service runs and queues 40 projects that have exceeded specified thresholds and must be published, or that have been published on demand by users, and you have set the maximum to 100, P6 will schedule up to 60 idle projects for publication.","Select Publish resource and role data if you want to be able to publish resource and role spread data.","Select Enable Baseline Publication if you want to be able to publish baseline data.","Select Enable Notification Email and type an email address in the Notification Email address field if you want to receive an email if publication services fail.","Click Save.","Tip","You can also schedule project data to be published at specific times of day.","If your organization is upgrading to P6, select Publish idle projects to add your migrated projects to the service queue after your database is upgraded. This will publish all your projects in the queue and refresh the available data for reporting. After an upgrade, this setting is no longer applicable, and projects will be submitted to the service queue based on threshold values specified on the Application Settings page.","Clear the Publish idle projects option if your organization does not report against completed projects.","The Maximum number to publish field is only applicable immediately following an upgrade, when all projects are considered idle. When all projects have been published, the service queue will no longer be constrained based on this setting.","A project will be automatically submitted to the service queue if you change the project baseline, calendar, or data date. Projects are also automatically submitted to the queue if you select or clear Calculate Activity % Complete from activity steps option, or modify the default price/unit value for assignments without activities, from the Set Project Preferences dialog box.","For threshold settings, projects are added to the service queue based on tracked changes to data. Only changes to activities, resource/role assignments, relationships, risk assignments, UDF values, activity code assignments, project code assignments and the WBS are tracked.","You can delete published project data by selecting Delete Published Data on the Actions&nbsp;@ menu of the EPS page.","Enabling Automatic Publishing of P6 Project Data<br /> (Primavera P6 EPPM Oracle Analytics Publisher Configuration Guide for On-Premises)","English\\Configuring\\p6_eppm_oas_config\\48877.htm");
Page[428]=new Array("Perform the steps below to configure P6 to automatically publish any of the following types of global data to reporting tables.","Enterprise Data","Project Data","Activity Data","Resource Data","Calendar Data","Enterprise Data dictionary definitions","Enterprise Summary Data including portfolio data","Resource Management Data","Security Data","Audit Data","To automatically publish P6 global data:","Click Administration.","On the Administration navigation bar, click Scheduled Services.","On the Scheduled Services page, select Global.","On the Global page:","Select a service, then configure its settings in the Service Settings detail window. For example, you might specify that the service runs daily with a start time of 08:00 AM.","Note Oracle recommends running the Publish Security service first if the Run After Previous option is selected in the Run Service list for other publication services. Running the Publish Security service first will ensure that security data updates in the extended schema as soon as possible and ensures that the security restrictions are in place before you run the report.","Select the Enabled option for any of the global services listed.","If you choose to run one or more services with the relative frequency value of After previous service, click Move Up or Move Down to arrange the services in your preferred sequence.","Click Save.","Enabling Automatic Publishing of P6 Global Data<br /> (Primavera P6 EPPM Oracle Analytics Publisher Configuration Guide for On-Premises)","English\\Configuring\\p6_eppm_oas_config\\48684.htm");
Page[429]=new Array("After enabling automatic publishing or adding a job to publish project data on a scheduled basis, perform the following procedure to configure settings for each individual project in Publication Services. Then, as you work, P6 automatically detects the changes to your project that trigger the publication of its data in the service queue.","To configure Publication Service settings for a project:","Click Projects.","On the Projects navigation bar, click EPS.","On the EPS page:","Select a project.","Click @&nbsp;Row&nbsp;Actions and select Set Project Preferences.","In the Project Preferences dialog box, select Analytics &amp;Services.","On the Analytics &amp;Services page, in the Publication section:","Select the Enable Publication option.","Adjust the relative Publication Priority up or down between 1 and 100 with 50 being the default priority value, 1 being the highest priority, and 100 being the lowest.","Click OK.","Tip","By default, all projects are enabled for publication. You only need to modify the Enable Publication setting if you want to disable publication for a project or re-enable publication of a previously disabled project.","Clearing the Enable Publication setting does not delete previously published data. You can delete published project data by selecting Delete Published Data on the Actions&nbsp;@ menu in the EPS page.","If you wish to modify publication settings for many projects at one time, you can display the Enable Publication, Last Published On, and Publication Priority fields as columns in your EPS view.","If you want to publish Baseline data, you must also publish project data for the relevant projects.","Configuring Publication Service Settings for Projects<br /> (Primavera P6 EPPM Oracle Analytics Publisher Configuration Guide for On-Premises)","English\\Configuring\\p6_eppm_oas_config\\49606.htm");
Page[430]=new Array("After enabling automatic publishing or adding a job to publish project data on a scheduled basis, perform the following procedure to configure settings for each individual project's baselines in Publication Services. Then, as you work, P6 automatically detects the changes to your baselines that trigger the publication of its data in the service queue.","To configure Publication Service settings for a baseline:","Click the Projects&nbsp;@ menu and choose Open Projects.","In the Open Projects dialog box, open one or more projects whose baselines you want to enable for publication.","On the Project navigation bar, click Activities or EPS.","On the Activities or EPS page, click Actions&nbsp;@ and select Define Baselines.","In the Define Baselines dialog box:","If you want to switch on publication for all baselines for a project, select the Publish option in the project band.","If you want to switch on publication for only some baselines for a project, expand the project band and select the Publish option for the baselines you want to publish.","Click Save.","Configuring Publication Service Settings for Baselines<br /> (Primavera P6 EPPM Oracle Analytics Publisher Configuration Guide for On-Premises)","English\\Configuring\\p6_eppm_oas_config\\78355.htm");
Page[431]=new Array("You can publish the data from projects on demand. Projects are added to the queue of projects being processed for publication the next time the Publish Projects service runs. You can check the status of the Publish Projects service after it has been added to the service queue by selecting View Service Status from the User menu. When you publish projects on demand, any of the projects' baselines which is enabled for publishing will also be published. Only projects enabled for publication are published.","To publish P6 project data on demand:","Click Projects.","On the Projects navigation bar, click EPS.","On the EPS page:","On the Actions&nbsp;@ menu, click Publish Projects.","Tip","In order to manually project data from the EPS page on demand, Publication Services must be enabled and configured.","You can publish all open projects by clicking Publish Projects on the Actions&nbsp;@ menu of the Activities page. You can also publish projects by selecting one or more projects on the EPS page, and then using the right-click menu.","If you have permission to view application settings, you can see the settings for the Publish Projects service, including how often the service runs, on the Global tab of the Secheduled Services page.","A project will be automatically submitted to the service queue if you change the project baseline, calendar, or data date. Projects are also automatically submitted to the queue if you select or clear the Calculate Activity % Complete from activity steps option, or modify the default price/unit value for assignments without activities from the Set Project Preferences dialog box available from the Actions&nbsp;@ menu the EPS page.","You can delete published project data by selecting Delete Published Data on the Actions&nbsp;@ menu of the EPS page.","Publishing P6 Project Data On Demand<br /> (Primavera P6 EPPM Oracle Analytics Publisher Configuration Guide for On-Premises)","English\\Configuring\\p6_eppm_oas_config\\48620.htm");
Page[432]=new Array("You can publish any of the following types of global data to the reporting tables on demand.","Enterprise Data","Project Data","Activity Data","Resource Data","Calendar Data","Enterprise Data dictionary definitions","Enterprise Summary Data including portfolio data","Resource Management Data","Security Data","Audit Data","To publish P6 global data on demand:","Click Administration.","On the Administration navigation bar, click Scheduled Services.","On the Scheduled Services page, select Global.","On the Global page:","Select a global service.","Click Run Service.","In the resulting message box, click OK.","Tip","If the service listed under the manually selected service is configured to run After previous service, it will run automatically when the selected service finishes. ","You must have the Administer Global Scheduled Services global security privilege to run a global scheduled service. ","Publishing P6 Global Data On Demand<br /> (Primavera P6 EPPM Oracle Analytics Publisher Configuration Guide for On-Premises)","English\\Configuring\\p6_eppm_oas_config\\48709.htm");
Page[433]=new Array("You can schedule services to run at intervals you choose on projects that you select. Available services include apply actuals, export, import, level, project checker, publish, schedule, summarize, and send to schedule sheet.","To create project scheduled services:","Click Administration.","On the Administration navigation bar, click Scheduled Services.","On the Scheduled Services page, click Project.","Click Add&nbsp;@ and select the type of service to add.","Enter a name for the new service.","In the Project Settings detail window:","Select @&nbsp;Add to add projects, EPS nodes, project code values, or portfolios to the Project table.","Note You cannot select projects for Import Primavera XML services.","Enter or select a value for every field.","Select or clear the Enabled option to determine whether the service will run.","Select Save.","Tip","You cannot schedule services for project templates.","Creating Project Scheduled Services<br /> (Primavera P6 EPPM Oracle Analytics Publisher Configuration Guide for On-Premises)","English\\Configuring\\p6_eppm_oas_config\\44525.htm");
Page[434]=new Array("If you change the start date in the Publication settings, you will need to delete the contents in the REPORTDATE table. When you delete the content from the REPORTDATE table, the publication services will refill the table the next time you run the Publish Enterprise Data service.","To delete content from the REPORTDATE table, the database administrator will need to:","Log in to the database.","Run one of the following commands:","DELETE FROM REPORTDATE;","or","TRUNCATE TABLE REPORTDATE;","Back Filling the REPORTDATE Table<br /> (Primavera P6 EPPM Oracle Analytics Publisher Configuration Guide for On-Premises)","English\\Configuring\\p6_eppm_oas_config\\50170.htm");
Page[435]=new Array("P6 supports parameter keys in Oracle Analytics Publisher. You will use these parameters in the P6 Reports section when running and scheduling reports. For most of the parameters you add, lists will be available for users when they are entering the value. The default behavior for an unrecognized parameter will be to provide a plain text box. The user will then need to type in the correct value. If the value is not in the format the report expected, the report will fail to run.","Adding parameters to your reports allows users that run or schedule a report. They can select or filter what data to include without having to first create additional reports or data templates for reports. For example, consider this scenario:","You have a report on activities and each activity has an activity code value assigned to it to determine the location of the team working on it. ","You want each team to be able to run the report, but they want to see only the activities for their location.","Without parameters, you would need to create a different report and data template for each team. All of these reports would be almost the same, except each statement pulling the activity data would have a different connection to the activity code table to match the correct location. With parameters, you can do this with just one report and data template.","Why Do I Need Parameters?<br /> (Primavera P6 EPPM Oracle Analytics Publisher Configuration Guide for On-Premises)","English\\Configuring\\p6_eppm_oas_config\\47002.htm");
Page[436]=new Array("When adding a new parameter in Oracle Analytics Publisher you will see the following fields: ","Identifier &#8211; The key for the parameter. Determines whether a list supports the parameter.","Data Type &#8211; String should be the default type. When using a supported parameter, select String for the type. See Primitive Parameters for more on Date, Boolean, and Integer parameters. ","Default Value &#8211; The value entered in this field will be the default for the parameter whenever the report runs. Users will be able to see this value in P6.","Parameter Type &#8211; Text, Menu, and Date are the common types. Unless otherwise specified, you should use Text as the default for the supported parameters. If you need to select multiple values, use Menu. ","Display Label &#8211; The text that displays in P6 for the parameter. If you do not set a display label, the identifier displays instead.","Defining Parameters in Oracle Analytics Publisher<br /> (Primavera P6 EPPM Oracle Analytics Publisher Configuration Guide for On-Premises)","English\\Configuring\\p6_eppm_oas_config\\47771.htm");
Page[437]=new Array("You can use any parameter for Oracle Analytics Publisher, but users have to ensure they enter the value correctly or the SQL statements in the data template will fail. Using supported parameters allows you to provide a user interface to enter the values for parameters. Supported parameters for P6 fall into one of the following categories: ","Enumeration parameters allow users to pick parameters from static lists.","Dynamic parameters generate the list at run time. For example, when focusing on Project ID, users see a Project list that pulls the current projects from the P6 EPPM database. ","Primitive parameters support basic selections. For example, if a parameter is a Boolean, an option appears for users to select or clear a text box instead of entering true or false.","The following are the supported parameters for P6, grouped by category:","Enumeration Parameters","Activity Priority","Activity Status","Activity Type","Assignment Proficiency","Constraint Type","Duration Type","Percent Complete Type","Project Status","Rate Source","Rate Type","Resource Type","Risk Status","Risk Type","Dynamic Parameters","Activity Code Value","Cost Account","EPS","Expense Category","Funding Source","Portfolio","Project","Project Code Value","User Defined Project Code (type and value)","User Defined Resource Code","Resource Code Value","Resource Team","Resource ID","Responsible Manager","Risk Category","Role","Role Team","Timesheet Period","User","User Defined Activity Code (type and value)","Primitive Parameters","Boolean","Date","Float","Integer","Custom Parameters","List of Values","Supported Parameters in P6<br /> (Primavera P6 EPPM Oracle Analytics Publisher Configuration Guide for On-Premises)","English\\Configuring\\p6_eppm_oas_config\\47008.htm");
Page[438]=new Array("Enumeration parameters map to fields that have a set list of possible values. When running a report with an enumeration parameter, P6 will offer a list to select one of the values. Users will see the localized text for the enumeration value's description; however, the return value will be the English description of the enumeration, which is the value the PX Views database stores.","Descriptions of enumeration parameters are in the following format:","Parameter: Name of the parameter.","Identifier: The value you must enter in the identifier field in Oracle Analytics Publisher when creating the parameter for the report.","Details: A description and technical details of the parameter.","Values: The values that will be available in P6.","Maps to field: The database field the return value maps to in the PX Views database. It could match multiple fields in the database, so only the primary table is listed.","Use case: An example of how you might use the parameter in a report.","Supported Enumeration Parameters","Parameter: Activity Priority ","Identifier: p_activity_priority","Details: Allows users to select the leveling priority of an activity. ","Values: Top, High, Normal, Low, Lowest","Maps to field: ACTIVITY.LEVELINGPRIORITY","Use case: Filter activity data by leveling priority. ","Parameter: Assignment Proficiency ","Identifier: p_assignment_proficiency","Details: Allows users to select a value for assignment proficiency.","Values: Master, Expert, Skilled, Proficient, Inexperienced","Maps to field: RESOURCEASSIGNMENT.PROFICIENCY","Use case: Filter resource assignment data by the proficiency of the assignment. ","Parameter: Activity Status","Identifier: p_activity_status","Details: Allows users to select activity status. ","Values: Not Started, In Progress, Completed","Maps to field: ACTIVITY.STATUS","Use case: Filter activity reports based on a certain status. ","Parameter: Activity Type","Identifier: p_activity_type","Details: Allows users to select the activity type. ","Values: Task Dependent, Resource Dependent, Level of Effort, Start Milestone, Finish Milestone, WBS Summary","Maps to field: ACTIVITY.TYPE","Use case: Filter activity reports based on the type of the activity. ","Parameter: Constraint Type","Identifier: p_contstraint_type","Details: Allows users to select an activity constraint type. ","Values: Start On, Start On or Before, Start On or After, Finish On, Finish On or Before, Finish On or After, As Late As Possible, Mandatory Start, Mandatory Finish","Maps to field: ACTIVITY.PRIMARYCONSTRAINTTYPE and ACTIVITY.SECONDARYCONSTRAINTTYPE","Use case: Filter activities in a report by the activity primary or secondary constraint type. ","Parameter: Duration Type","Identifier: p_duration_type","Details: Allows users to select the duration types of an activity. ","Values: Fixed Units/Time, Fixed Duration &amp; Units/Time, Fixed Units, Fixed Duration &amp; Units","Maps to field: ACTIVITY.DURATIONTYPE","Use case: Filter activities in a report based on their duration type. ","Parameter: Percent Complete Type","Identifier: p_percent_complete_type","Details: Allows users to select the percent complete type of an activity.","Values: Physical, Duration, Units","Maps to field: ACTIVITY.PERCENTCOMPLETETYPE","Use case: Filter activities in a report based on the percent complete type of the activity.","Parameter: Project Status","Identifier: p_project_status","Details: Allows users to select the status of a project.","Values: Planned, Active, Inactive, What If, Requested, Template","Maps to field: PROJECT.STATUS","Use case: Filter the projects in a report based on the desired type. For example, you might want to use this for a report that needs to display information only on planned projects.","Parameter: Rate Source","Identifier: p_rate_source","Details: Allows users to select the rate source of an assignment. ","Values: Resource, Role, Override","Maps to field: RESOURCEASSIGNMENT.RATESOURCE","Use case: Filter resource assignments included in a report based on the rate source of the assignment. ","Parameter: Rate Type","Identifier: p_rate_type","Details: Allows users to select the rate type of an assignment.","Values: Price/Unit, Price/Unit 2, Price/Unit 3, Price/Unit 4, Price/Unit 5 ","Maps to field: RESOURCEASSIGNMENT.RATETYPE","Use case: Filter resource assignments included in a report based on the rate type of the assignment. ","Parameter: Resource Type","Identifier: p_resource_type","Details: Allows users to select the resource type of an assignment. ","Values: Labor, Nonlabor, Material","Maps to field: RESOURCEASSIGNMENT.RESOURCETYPE","Use case: Filter resource assignments included in a report based on the resource type of the assignment.","Parameter: Risk Status","Identifier: p_risk_status","Details: Allows users to select the status of a risk.","Values: Proposed, Open, Active, Rejected (Closed), Managed (Closed), Impacted (Closed)","Maps to field: RISK.RISKSTATUS","Use case: Filter risks in a report based on the status of the risk. ","Parameter: Risk Type","Identifier: p_risk_type","Details: Allows users to select the type of a risk.","Values: Threat, Opportunity","Maps to field: RISK.RISKTYPE","Use case: Filter risks in a report based on the type of risk.","Enumeration Parameters<br /> (Primavera P6 EPPM Oracle Analytics Publisher Configuration Guide for On-Premises)","English\\Configuring\\p6_eppm_oas_config\\47008.htm#o47009");
Page[439]=new Array("Dynamic parameters map to fields that have a varying list of possible values. When running a report with a dynamic parameter, P6 will offer a list to select one of the available values.","Descriptions of dynamic parameters are in the following format:","Parameter:Name of the parameter.","Identifier: The value you must enter in the identifier field in Oracle Analytics Publisher when creating the parameter for the report. In some cases, identifiers can pass in context by appending short names to the end of the identifier. The character in quotations is the separator that the code splits and &lt;name&gt; represents the context you are trying to pass in.","Details: A description and technical details of the parameter.","P6: What the editor for the parameter will be in the Reports section of P6.","Return Value: The values that will be available in P6.","Maps to field: The database field the return value maps to in the PX Views database. It could match multiple fields in the database, so only the primary table is listed.","Use case: An example of how you might use the parameter in a report.","Supported Dynamic Parameters ","Parameter: Activity Code Value","Identifier: p_a_code_val__&lt;short name&gt; ","Details: Enables users to select an activity code value via a list. Context passes into the parameter by appending a colon&quot;:&quot; followed by the short name of the activity code type you want to set.","P6: Provides a list that displays the Activity Code Values for the Activity Code type passed in the context.","Return value: Short name of the Activity Code (unique per code type).","Maps to field: ACTIVITYCODE.CODEVALUE","Use case: Create a report that displays some basic information about activities. Users at five locations need to run the report, but they only want to see the data for activities with codes matching their location. Instead of creating five reports hard coding the location (for example, location=L1) on each report, you can create one report and add this parameter to it (for example, p_a_code_val__Location).","In the data template for the report, filter the activities based on this parameter. Hard code the left side of the activity filter to match the activity code you selected, which in this case is location. ","Example query: CODETYPENAME='Location' &amp; CODEVALUE=:p_a_code_val__Location","If you did not have a parameter for this, you would need different templates for each location.","Parameter: User Defined Activity Code","Identifier: p_activity_code_value &quot;.&quot; &lt;number&gt; p_activity_code_type &quot;.&quot; &lt;number&gt;","Details: Enables users to select a user defined Activity Code. The user defined Activity Code is two parameters on the report in Oracle Analytics Publisher, but will display only as one row in the report settings parameter table. ","P6: Provides a list that displays all global Activity Code types. When users expand a type, the list shows the values for that type. By selecting a value, both the type and value will return to the report. ","Return value: Short name for the Activity Code Value, primary key for the Activity Code type. ","Maps to field: ","p_activity_code_value maps to ACTIVITYCODE.CODEVALUE","p_activity_code_type maps to ACTIVITYCODE.CODETYPEOBJECTID","Use case: Create a report that can have a variable Activity Code. The report pulls activities and displays some basic statistics of the activities. The data template for the report must accommodate setting both sides of the query. While a typical parameter just sets the IN clause for a user defined field, this parameter must set both sides. The &quot;Activity Code Value&quot; parameter Use case example shows where it hard codes the CODETYPENAME to be Location. This parameter enables multiple user defined activity codes to be used on the same report. For each parameter you use, you must add p_activity_code_value.1 and p_activity_code_type.1. There must be a pair of numbers to ensure that the editor works properly.","Parameter: Cost Account","Identifier: p_cost_account","Details: Enables users to select Cost Accounts. The P6 user must have access to view Cost Accounts for the list to populate.","P6: Provides a list that displays all Cost Accounts in a hierarchical tree.","Return value: Short name of the cost account (unique).","Maps to field: COSTACCOUNT_FULL.NAME","Use case: Filter items using certain Cost Accounts or generate information on the Cost Accounts.","Parameter: EPS","Identifier: p_eps_id","Details: Enables a user to select an EPS.","P6: Provides a list that displays all of the EPS nodes where the user has access.","Return value: The short name of the EPS.","Maps to field: ","EPS_FULL.NAME","EPS_U.NAME","Use case: Use a parameter for EPS to filter a query to load all projects under an EPS for a report.","Parameter: Expense Category","Identifier: p_expense_category","Details: Enables a user to select Expense Category where the user has access.","P6: Will provide a list that displays all of the Expense Categories.","Return value: The short name of the Expense Category (unique).","Maps to field: ","EXPENSECATEGORY_FULL.NAME","EXPENSECATEGORY_U.NAME","Use case: Run a report filtered by assignments that use a certain Expense Category associated with them.","Parameter: Funding Source","Identifier: p_funding_source","Details: Enables a user to select a Funding Source.","P6: Provides a hierarchical list filled with Funding Sources where a user has access.","Return value: The short name of the Funding Source (unique).","Maps to field: ","FUNDINGSOURCE_FULL.NAME","FUNDINGSOURCE_U.NAME","Use case: Filter the report data to include only projects that have the selected Funding Source assigned.","Parameter: Portfolio ID","Identifier: p_portfolio_id","Details: Enables a user to select a Portfolio where the user has access.","P6: Provides a list of Portfolios where the user has access.","Return value: The portfolio short name (unique).","Maps to field: PROJECTPORTFOLIO_FULL.NAME","Use case: Filter the report data to include only the projects in a Portfolio.","Note If there is a user portfolio that shares the same name as one of the global portfolios, then the report will return data for both when you run it. You'll need to use the Portfolio Name and User ID to make a unique constraint.","Parameter: Project ID","Identifier: p_project_id","Details: Enables a user to select one or more projects where the user has access.","P6: Click the Projects&nbsp;@ menu, and select Open Project to display the Project list. Enables switching between Template and Regular projects.","Return value: The project short name (unique).","Maps to field: PROJECT_FULL.ID","Use case: Run a report where the data comes from selected projects.","Parameter: Project Code Value","Identifier: p_p_code_val__&lt;short name&gt;","Details: Select a Project Code value. Note that underscores (_) are the only special character allowed. Do not use other special characters.","P6: Provides a list containing the project code values for the Project Code whose short name matches the second part of the parameter. For example: If the short name was Scope, and there were four values &#8211; Local, Regional, Country, and Global &#8211; the list would display Local, Regional, Country, and Global in the list.","Return value: Activity code value short name (unique per code type).","Maps to field: PROJECTCODE_FULL.CODEVALUE","Use case: Filter the set of projects loaded to those projects that have the user-selected Project Code Value assigned to them.","Parameter: User Defined Project Code","Identifier: p_project_code_value&quot;.&quot;&lt;number&gt; p_project_code_type&quot;.&quot;&lt;number&gt;","Details: Similar to the User Defined Activity Code, this parameter consists of two parameters in Oracle Analytics Publisher: One parameter returns the selected Project Code Value, and the other parameter returns the Project Code type ID. For each parameter you use, you must add both p_project_code_value.# and p_project_code_type.#. There must be a pair of numbers for the editor to work properly. You can have multiple sets to allow for more than one User Defined Code Value.","P6: Provides a list populated with all the global Project Codes as the first level. Expanding a Project Code type will list all the values for the type. In the parameter table, only one row will represent both parameters. After you select a Project Code Value, both parameters will be set.","Return value: The short name for p_project_code_value and the object id for p_project_code_type.","Maps to field: ","p_project_code_value maps to PROJECTCODE_FULL.CODEVALUE ","p_project_code_type maps to PROJECTCODE_FULL.CODETYPEOBJECTID","Use case: Create a report that enables the projects to filter based on a Project Code that the user defines. Unlike the Project Code Value parameter, the report creator should not hard code the Project Code type. Instead, they should write the query to enable the p_project_code_type.1 parameter to determine the Project Code type. This lets a report be more flexible in the filter criteria.","Parameter: User Defined Resource Code","Identifier: p_resource_code_value &quot;.&quot; &lt;number&gt; p_resource_code_type &quot;.&quot; &lt;number&gt;","Details: Similar to the other user-defined codes this parameter consists of two parameters on the report in Oracle Analytics Publisher: One parameter returns the selected Resource Code Value, and the other parameter returns the Resource Code type ID. For each parameter you use, you must add both p_resource_code_value.# and p_resource_code_type .# There must be a pair of numbers in order for the editor to work properly. You can have multiple sets to allow for more than one user-defined code value.","P6: Provides a list populated with the Resource Codes as the first level. Expanding a Resource Code type will list all the values for the type. In the parameter table, only one row will represent both parameters. After you select a Resource Code Value, both parameters will be set.","Return value: ","p_resource_code_value: short name for the code value","p_resource_code_type: object id for the code type","Maps to field: ","p_resource_code_value maps to RESOURCECODE_FULL.CODEVALUE","p_resource_code_type maps to RESOURCE_CODE_FULL.CODETYPEOBJECTID","Use case: Create a report that allows for the resources to be filtered based on a Resource Code Value and type that the user defines. Unlike the Resource Code Value parameter, the report creator should not hard code the resource code type. Instead, they should write the query to enable the p_resource_code_type.1 parameter to determine the resource code type. This allows a report to be more flexible in the filter criteria.","Parameter: Resource Code Value","Identifier: p_r_code_val__&lt;short name&gt;","Details: Select a Resource Code value to use for filtering loaded resources for a report.","P6: Provides a list populated with the resource code values for the resource code type indicated by the &lt;short name&gt; at the end of the parameter. For example: If the short name was Department, the list would display Engineering, Marketing, Research, and Development as the values in the list.","Return value: The short name of the Resource Code Value (unique per code type).","Maps to field: RESOURCECODE_FULL.CODEVALUE","Use case: Create a report where the resources filter based on the resources that match the user-selected Resource Code Value for a particular Resource Code type. The report data query must hard code the Resource Code type for matching resources to the returned code value.","Parameter: Resource Team","Identifier: p_resource_team","Details: Enables resource team selection.","P6: Provides a list populated with resource teams that the user has access to view.","Return value: The short name of the resource team (unique).","Maps to field: RESOURCETEAM_FULL.NAME","Use case: Filter a report to load resources that are on the selected resource team.","Parameter: Resource ID","Identifier: p_resource_id","Details: Select a resource to filter a report.","P6: Provides a list populated with resources that the user has access to view.","Return value: The short name of the resource (unique).","Maps to field: RESOURCES_FULL.NAME","Use case: Filter the activities in a report based on the user-selected resource assigned to the activity.","Parameter: Responsible Manager","Identifier: p_responsible_manager","Details: Select a responsible manager (OBS).","P6 GUI: Provides a list populated with the OBS structure that the user has access to view. ","Return value: The short name of the OBS (unique).","Maps to field: PROJECT_FULL.OBSNAME and OBS_FULL.NAME","Use case: Filter a report to load only the projects that have the user-selected responsible manager.","Parameter: Risk Category","Identifier: p_risk_category","Details: Select a Risk Category.","P6: Provides a list populated with all the Risk Categories that the user has access to view. ","Return value: The name of the Risk Category (unique).","Maps to field: RISK_FULL.RISKTYPE","Use case: Filter a report to load only the Risks of the user-selected category.","Parameter: Role Team","Identifier: p_role_team","Details: Select a Role Team.","P6: Provides a list populated with all the Role Teams the user has access to view.","Return value: The name of the Role Team (unique).","Maps to field: ROLLTEAM_FULL.NAME","Use case: Filter a report of Resources to include only the Resources that are assigned to the user-selected Role Team.","Parameter: Role","Identifier: p_p6_role_id","Details: Select a Role.","P6: Provides a list populated with all the Roles the user has access to view.","Return value: The short name of the Role (unique).","Maps to field: ROLL_FULL.ID","Use case: Filter a report of Resources to include only the Resources that have the user-selected Role.","Parameter: Timesheet Period","Identifier: p_timesheet_period_start and p_timesheet_period_end","Details: This parameter consists of two parameters on the report in Oracle Analytics Publisher, but is represented by a single row in parameter list for P6. The user will select a timesheet period, and it will set the Start Date to p_timesheet_period_start and the End Date to p_timesheet_period_end.","P6: Drop down menu of the Timesheet Periods in the database. Selecting a Timesheet Period will return the Start Date and End Date in the parameters.","Return value: The Start Date and End Date of the Timesheet Period selected by the user.","Maps to field: N/A","Use case: Filter a report to look for a date between two dates of a Timesheet Period. Instead of adding two date parameters and making the user manually enter the Start and End of the period, the user can use a drop down with the Timesheet Periods in the database. ","Parameter: User","Identifier: p_p6_user_id","Details: Select a P6 EPPM user name.","P6: Provides a list populated with the P6 users that the logged-in user has access to view.","Return value: The user name (unique).","Maps to field: USERS_FULL.NAME","Dynamic Parameters<br /> (Primavera P6 EPPM Oracle Analytics Publisher Configuration Guide for On-Premises)","English\\Configuring\\p6_eppm_oas_config\\47008.htm#o47010");
Page[440]=new Array("In Oracle Analytics Publisher, when you create a parameter, a field Data Type allows the following options: String, Integer, Boolean, Float. The default type is String, and you should use it for all the supported enumeration and dynamic parameters. For primitive parameters, select the appropriate option for the parameter that you are configuring.","Type: Date","Editor: P6 will use the date picker to select the date.","Return: The date string in the format entered in Oracle Analytics Publisher.","Type: Boolean","Editor: Will use a check box editor.","Return: Either true (selected) or false (cleared).","Type: Integer","Editor: Will use a default text box without validation.","Return: The text entered in the box.","Type: Float","Editor: Will use a default text box without validation. ","Return: The text entered in the box.","Primitive Parameters<br /> (Primavera P6 EPPM Oracle Analytics Publisher Configuration Guide for On-Premises)","English\\Configuring\\p6_eppm_oas_config\\47011.htm");
Page[441]=new Array("If you need a supported parameter to return a comma separated list of values for an IN clause in the data template, do the following: ","In Oracle Analytics Publisher, set the parameter type to Menu. This will allow you to link it to a list. ","Create a hard coded list or a query to get the possible values for the parameter. ","See examples of this in Oracle Analytics Publisher's pre-packaged reports. ","Select the list of values you just created for the parameter.","Check the Multiple Selection option for the parameter. ","If a parameter allows for multiple selection, P6 will allow selecting multiple values from the list or allow users to continue to assign values without closing the list. Values will have commas to separate parameters when the return value appears.","Allowing for Multiple Values Returned via a List<br /> (Primavera P6 EPPM Oracle Analytics Publisher Configuration Guide for On-Premises)","English\\Configuring\\p6_eppm_oas_config\\47012.htm");
var PageCount=41;


/*
Date: 12/11/2025 7:39 PM
Source: EPPM_25_dev
BookID: 50840
PubProduct: PRIMAVERA_EPPM
BookTitle: Oracle Analytics Publisher Configuration Guide for On-Premises
Version: Version 25
Lang:	en
*/
/* relative_path_for_link: English\licensing_information\p6_eppm_licensing_information*** */
/* BookTitleTop: Primavera P6 EPPM Licensing Information User Manual*** */
/* Generated with Author-it 23.4.1.30004  12/12/2025 10:16:00 AM */
Page[442]=new Array("Title and Copyright Information","Copyright  1999, 2025, Oracle and/or its affiliates.","Primary Author: Oracle Corporation","Title and Copyright Information<br /> (Primavera P6 EPPM Licensing Information User Manual)","English\\licensing_information\\p6_eppm_licensing_information\\46576.htm");
Page[443]=new Array("This Licensing Information document is a part of the product or program documentation under the terms of your Oracle license agreement and is intended to help you understand the program editions, entitlements, restrictions, prerequisites, special license rights, and/or separately licensed third party technology terms associated with the Oracle software program(s) covered by this document (the &#8220;Program(s)&#8221;). Entitled or restricted use products or components identified in this document that are not provided with the particular Program may be obtained from the Oracle Software Delivery Cloud website (https://edelivery.oracle.com) or from media Oracle may provide. If you have a question about your license rights and obligations, please contact your Oracle sales representative, review the information provided in Oracle's Software Investment Guide (http://www.oracle.com/us/corporate/pricing/software-investment-guide/index.html), and/or contact the applicable Oracle License Management Services representative listed on http://www.oracle.com/us/corporate/license-management-services/index.html.","About This Guide<br /> (Primavera P6 EPPM Licensing Information User Manual)","English\\licensing_information\\p6_eppm_licensing_information\\88598.htm");
Page[444]=new Array("Certain Oracle licensed products require valid licenses for other Oracle products; licenses for these other Oracle products are included with your core license. Included licenses give you the rights to functionality limited to what is needed for your core licensed product; these are referred to as Restricted Use Licenses.  In addition, some products require that you install other Oracle products; these are referred to as Prerequisite Products. The following topics identify what technologies are included within each core product license and also any other products you need to install in order to fully use the core product. Please see your Oracle Sales Representative for details.","Note As part of any Cloud Service, Oracle may, at its discretion, compile statistical and other information related to your use of the Service and share such information and subsequent analysis with you.","Licensed Products, Restricted Use Licenses, and Prerequisite Products<br /> (Primavera P6 EPPM Licensing Information User Manual)","English\\licensing_information\\p6_eppm_licensing_information\\88603.htm");
Page[445]=new Array("Restricted Use Licenses","The following restricted use licenses are included with your Oracle Primavera P6 Enterprise Project Portfolio Management license:","WebLogic Server Standard Edition: Only allowed to run in WebLogic Server Standard Edition instance. No other web applications may be deployed in this instance of WebLogic Server Standard Edition. Restricted to only WebLogic Server Standard Edition features, not the WebLogic Server Enterprise Edition features or WebLogic Suite features. This does NOT include the use of clustering, coherence or EJBs. For example, if a customer wishes to cluster their Primavera P6 Enterprise Project Portfolio Management instance, that would trigger a full-use license of WebLogic Server Enterprise Edition (or WebLogic Suite for Oracle Applications).","JRockit JVM: Only used for Primavera P6 Enterprise Project Portfolio Management servers. This is a runtime license that does not allow customers to utilize JRockit JVM for other applications or instances. For users who change or create new workflows using web services and events from Primavera applications, Named User Plus licenses are recommended for Unified Business Process Management Suite (or Unified Business Process Management Suite for Oracle Applications), SOA Suite for Oracle Middleware (or SOA Suite for Oracle Middleware for Oracle Applications), and WebLogic Suite (or WebLogic Suite for Oracle Applications). There is no minimum Named User Plus requirement for the recommended products above.","WebCenter Content: Only valid for workspaces or folders that are built from Primavera P6 Enterprise Project Portfolio Management. Only valid for repositories that store Primavera P6 Enterprise Project Portfolio Management documents, artifacts and work products. Creating any repositories, folders, workspaces, etc. manually outside of Primavera applications will trigger full-use. Only licensed Primavera application users can access the repository. For example, creating a new departmental workspace or folder would trigger a full-use license.","Application Development Framework. This does not grant permission to customers to build, deploy or resell Application Development Framework user interface components or applications.","Oracle HTTP Server: Used for access outside corporate firewall and single sign-on (SSO). May not be used for any purposes outside of those requirements.","EclipseLink: Used only for Primavera P6 Enterprise Project Portfolio Management persistence. Run-time only and may not be used to build any other applications.","Unified Business Process Management Suite and its prerequisites (SOA Suite for Oracle Middleware and WebLogic Suite) for licensed users of the Primavera application who are consuming/participating in the Primavera workflows (workflows within Primavera applications or integrating Primavera applications with Oracle applications) or forms. Any users who need to change or create new workflows will need a full-use license of Unified Business Process Management Suite (or Unified Business Process Management Suite for Oracle Applications) and its prerequisite products. There is no minimum Named User requirement for full use licenses.","Web Center: Only for portals built using Primavera portlets. Not valid for adding non-Primavera portals, workspaces, etc. For example, a user who creates additional organizational or departmental portals would trigger full-use license of Web center. Additionally, attempts to modify Primavera portals would likewise trigger full-use license.","Primavera Gateway: For the exclusive use of integrating Primavera P6 Enterprise Project Portfolio Management with other Primavera applications.","Oracle Analytics Publisher (formerly Business Intelligence Publisher): Valid for users to schedule/process/run reports within the Primavera application. Any users who need to customize or create new reports will need a full-use license of Oracle Analytics Publisher (or Oracle Analytics Publisher for Oracle Applications). There is no minimum named user requirement for Oracle Analytics Publisher (formerly Business Intelligence Publisher) for Primavera applications.","Oracle Web Services Manager (OWSM) for the exclusive use of the protection of Primavera Web Services.","Oracle Entitlement Server Basic.","The embedded OutsideIn component should only be used in the scope of the Primavera P6 Enterprise Project Portfolio Management application and cannot be used to process documents or data outside of that application.","Oracle's Java Platform Standard Edition (Java SE) is only for use in running Primavera P6 Enterprise Project Portfolio Management.","Other included components:  Primavera P6 Professional Project Management, Primavera P6 Peripheral Access, Primavera P6 Team Member Web, Primavera Team Member for iOS, Primavera Team Member for Android, and Email Statusing.","For the purposes of the following Programs: Primavera P6 Enterprise Project Portfolio Management and Primavera P6 Peripheral Access, developers and/or users (i) who are not already licensed for the Primavera P6 Enterprise Project Portfolio Management program and (ii) who access data originating from, or submit data integrating into the Primavera P6 Enterprise Project Portfolio Management Program through third party applications using automated processes (including through one or more Access Points), must be licensed for the Primavera P6 Peripheral Access Program. &#8220;Access Points&#8221; include, but are not limited to, third party, Oracle or custom versions of the following: interfaces, API&#8217;s, web services, EDI/EFT/ETL processes, and database links.","Primavera P6 Enterprise Project Portfolio Management<br /> (Primavera P6 EPPM Licensing Information User Manual)","English\\licensing_information\\p6_eppm_licensing_information\\88624.htm");
Page[446]=new Array("Restricted Use Licenses","The following restricted use licenses are included with your Oracle Primavera P6 Enterprise Project Portfolio Management license:","WebLogic Server Standard Edition: only allowed to run in WebLogic Server Standard Edition instance.  No other web applications may be deployed in this instance of WebLogic Server Standard Edition. Restricted to only WebLogic Server Standard Edition features, not the WebLogic Server Enterprise Edition features or WebLogic Suite features. This does NOT include the use of clustering, coherence or EJBs. For example, if a customer wishes to cluster their Primavera P6 Progress Reporter instance, that would trigger a full-use license of WebLogic Server Enterprise Edition (or WebLogic Suite for Oracle Applications).","JRockit JVM: only used for Primavera P6 Progress Reporter servers. This is a runtime license that does not allow customers to utilize JRockit JVM for other applications or instances.","Application Development Framework:  This does not grant permission to customers to build, deploy or resell Application Development Framework user interface components or applications.","Oracle HTTP Server: used only for access outside corporate firewall and single sign-on (SSO). May not be used for any purposes outside of those requirements.","EclipseLink: used only for Primavera P6 Progress Reporter persistence. Run-time only and may not be used to build any other applications.","WebCenter Content: only valid for workspaces or folders that are built from Primavera P6 Progress Reporter. Only valid for repositories that store Primavera P6 Progress Reporter documents, artifacts and work products. Creating any repositories, folders, workspaces, etc. manually outside of Primavera applications will trigger full-use. Only licensed Primavera application users can access the repository. For example, creating a new departmental workspace or folder would trigger a full-use license.","Oracle Web Services Manager (OWSM) for the exclusive use of the protection of Primavera Web Services. ","Oracle Entitlement Server Basic ","Oracle's Java Platform Standard Edition (Java SE) is only for use in running Primavera P6 Progress Reporter.","Prerequisite Products","Install the following additional Oracle products to use Primavera P6 Progress Reporter:","Primavera P6 Enterprise Project Portfolio Management","Other included components: Primavera P6 Team Member Web, Primavera Team Member for iOS, Primavera Team Member for Android, and Email Statusing.","Primavera P6 Progress Reporter<br /> (Primavera P6 EPPM Licensing Information User Manual)","English\\licensing_information\\p6_eppm_licensing_information\\89020.htm");
Page[447]=new Array("Restricted Use Licenses","The following restricted use licenses are included with your Oracle Primavera P6 Enterprise Project Portfolio Management Web Services license:","WebLogic Server Standard Edition: only allowed to run in WebLogic Server Standard Edition instance. No other web applications may be deployed in this instance of WebLogic Server Standard Edition. Restricted to only WebLogic Server Standard Edition features, not the WebLogic Server Enterprise Edition features or WebLogic Suite features. This does NOT include the use of clustering, coherence or EJBs. For example, if a customer wishes to cluster their Primavera P6 Web Services instance, that would trigger a full-use license of WebLogic Server Enterprise Edition (or WebLogic Suite for Oracle Applications).","WebCenter Content: only valid for workspaces or folders that are built from Primavera Web Services. Only valid for repositories that store Primavera Web Services documents, artifacts and work products. Creating any repositories, folders, workspaces, etc. manually outside of Primavera applications will trigger full-use. Only licensed Primavera application users can access the repository. For example, creating a new departmental workspace or folder would trigger a full-use license.","Oracle Web Services Manager (OWSM) for the exclusive use of the protection of Primavera Web Services.","Oracle Entitlement Server Basic.","Oracle's Java Platform Standard Edition (Java SE) is only for use in running Primavera P6 Enterprise Project Portfolio Management Web Services. ","Other included components: P6 Web Services and Events, P6 Java APIs, and P6 e-mail statusing service.","Prerequisite Products","Primavera P6 Enterprise Project Portfolio Management","For the purposes of the following Programs: Primavera P6 Enterprise Project Portfolio Management and Primavera P6 Peripheral Access, developers and/or users (i) who are not already licensed for the Primavera P6 Enterprise Project Portfolio Management program and (ii) who access data originating from, or submit data integrating into the Primavera P6 Enterprise Project Portfolio Management Program through third party applications using automated processes (including through one or more Access Points), must be licensed for the Primavera P6 Peripheral Access Program. &#8220;Access Points&#8221; include, but are not limited to, third party, Oracle or custom versions of the following: interfaces, API&#8217;s, web services, EDI/EFT/ETL processes, and database links.","Primavera P6 Peripheral Access<br /> (Primavera P6 EPPM Licensing Information User Manual)","English\\licensing_information\\p6_eppm_licensing_information\\88625.htm");
Page[448]=new Array("Prerequisite Products","For the purposes of the following programs: Primavera P6 Enterprise Project Portfolio Management Cloud Service and Primavera P6 Peripheral Access Cloud Service, developers and/or users (i) who are not already licensed for the Primavera P6 Enterprise Project Portfolio Management Cloud Service and (ii) who access data originating from, or submit data integrating into, the Primavera P6 Enterprise Project Portfolio Management Cloud Service through third party applications using automated processes (including through one or more Access Points), must be licensed for Primavera P6 Peripheral Access Cloud Service. &#8220;Access Points&#8221; include, but are not limited to, third party, Oracle or custom versions of the following: interfaces, API&#8217;s, web services, EDI/EFT/ETL processes, and database links.","Primavera P6 Enterprise Project Portfolio Management Cloud Service<br /> (Primavera P6 EPPM Licensing Information User Manual)","English\\licensing_information\\p6_eppm_licensing_information\\95163.htm");
Page[449]=new Array("Prerequisite Products","Primavera P6 Enterprise Project Portfolio Management Cloud Service","Primavera P6 Progress Reporter Cloud Service<br /> (Primavera P6 EPPM Licensing Information User Manual)","English\\licensing_information\\p6_eppm_licensing_information\\95164.htm");
Page[450]=new Array("Prerequisite Products ","Primavera P6 Enterprise Project Portfolio Management Cloud Service","For the purposes of the following programs: Primavera P6 Enterprise Project Portfolio Management Cloud Service and Primavera P6 Peripheral Access Cloud Service, developers and/or users (i) who are not already licensed for the Primavera P6 Enterprise Project Portfolio Management Cloud Service and (ii) who access data originating from, or submit data integrating into, the Primavera P6 Enterprise Project Portfolio Management Cloud Service through third party applications using automated processes (including through one or more Access Points), must be licensed for Primavera P6 Peripheral Access Cloud Service. &#8220;Access Points&#8221; include, but are not limited to, third party, Oracle or custom versions of the following: interfaces, API&#8217;s, web services, EDI/EFT/ETL processes, and database links.","Primavera P6 Peripheral Access Cloud Service<br /> (Primavera P6 EPPM Licensing Information User Manual)","English\\licensing_information\\p6_eppm_licensing_information\\95165.htm");
Page[451]=new Array("Prerequisite Products","Primavera P6 Enterprise Project Portfolio Management Cloud Service.","Each licensed user on each Primavera P6 Cloud Service Additional Production Environment must also be a licensed user on Primavera P6 Enterprise Project Portfolio Management Cloud Service.","Primavera P6 Cloud Service, Additional Production Environment<br /> (Primavera P6 EPPM Licensing Information User Manual)","English\\licensing_information\\p6_eppm_licensing_information\\102367.htm");
Page[452]=new Array("Prerequisite Products","Primavera P6 Enterprise Project Portfolio Management Cloud Service","Primavera P6 Cloud Service, Additional Non-Production Environment<br /> (Primavera P6 EPPM Licensing Information User Manual)","English\\licensing_information\\p6_eppm_licensing_information\\102686.htm");
Page[453]=new Array("Prerequisite Products","Primavera P6 Enterprise Project Portfolio Management Cloud Service","Primavera Virtual Desktop Cloud Service<br /> (Primavera P6 EPPM Licensing Information User Manual)","English\\licensing_information\\p6_eppm_licensing_information\\102869.htm");
Page[454]=new Array("Prerequisite Products","For the purposes of the following programs: Primavera P6 Enterprise Project Portfolio Management United Kingdom Government Cloud Service and Primavera P6 Peripheral Access Cloud Service, developers and/or users (i) who are not already licensed for the Primavera P6 Enterprise Project Portfolio Management United Kingdom Government Cloud Service and (ii) who access data originating from, or submit data integrating into, the Primavera P6 Enterprise Project Portfolio Management Cloud Service through third party applications using automated processes (including through one or more Access Points), must be licensed for Primavera P6 Peripheral Access Cloud Service. &#8220;Access Points&#8221; include, but are not limited to, third party, Oracle or custom versions of the following: interfaces, API&#8217;s, web services, EDI/EFT/ETL processes, and database links.","Primavera P6 Enterprise Project Portfolio Management United Kingdom Government Cloud Service<br /> (Primavera P6 EPPM Licensing Information User Manual)","English\\licensing_information\\p6_eppm_licensing_information\\101781.htm");
Page[455]=new Array("Prerequisite Products","Primavera P6 Enterprise Project Portfolio Management United Kingdom Government Cloud Service","Primavera P6 Progress Reporter Cloud Service for United Kingdom Government<br /> (Primavera P6 EPPM Licensing Information User Manual)","English\\licensing_information\\p6_eppm_licensing_information\\106993.htm");
Page[456]=new Array("Prerequisite Products","Primavera P6 Enterprise Project Portfolio Management United Kingdom Government Cloud Service","For the purposes of the following programs: Primavera P6 Enterprise Project Portfolio Management United Kingdom Government Cloud Service and Primavera P6 Peripheral Access Cloud Service, developers and/or users (i) who are not already licensed for Primavera P6 Enterprise Project Portfolio Management United Kingdom Government Cloud Service and (ii) who access data originating from, or submit data integrating into, the Primavera P6 Enterprise Project Portfolio Management Cloud Service through third party applications using automated processes (including through one or more Access Points), must be licensed for Primavera P6 Peripheral Access Cloud Service. &#8220;Access Points&#8221; include, but are not limited to, third party, Oracle or custom versions of the following: interfaces, API&#8217;s, web services, EDI/EFT/ETL processes, and database links.","Primavera P6 Peripheral Access Cloud Service for United Kingdom Government<br /> (Primavera P6 EPPM Licensing Information User Manual)","English\\licensing_information\\p6_eppm_licensing_information\\106994.htm");
Page[457]=new Array("Prerequisite Products","Primavera P6 Enterprise Project Portfolio Management United Kingdom Government Cloud Service","Primavera P6 United Kingdom Government Cloud Service, Additional Production Environment<br /> (Primavera P6 EPPM Licensing Information User Manual)","English\\licensing_information\\p6_eppm_licensing_information\\102104.htm");
Page[458]=new Array("Prerequisite Product","Primavera P6 Enterprise Project Portfolio Management United Kingdom Government Cloud Service","Primavera P6 United Kingdom Government Cloud Service, Additional Non-Production Environment<br /> (Primavera P6 EPPM Licensing Information User Manual)","English\\licensing_information\\p6_eppm_licensing_information\\102105.htm");
Page[459]=new Array("Required notices for open source and commercial software products or components distributed in P6 EPPM are identified below, along with the applicable licensing information. Additional notices and/or licenses may be found in the included documentation or readme files of the individual third party open source software. ","Third Party Notices and/or Licenses<br /> (Primavera P6 EPPM Licensing Information User Manual)","English\\licensing_information\\p6_eppm_licensing_information\\88604.htm");
Page[460]=new Array("Licensed under the Apache Software License, Version 2.0 (the &quot;License&quot;); you may not use this file except in compliance with the License.","Bootstrap<br /> (Primavera P6 EPPM Licensing Information User Manual)","English\\licensing_information\\p6_eppm_licensing_information\\98456.htm");
Page[461]=new Array("Licensed under the Apache Software License, Version 2.0 (the &quot;License&quot;); you may not use this file except in compliance with the License.","______________________________________________","Notice:","Apache Commons Compress","Copyright 2002-2023 The Apache Software Foundation","This product includes software developed at","The Apache Software Foundation (https://www.apache.org/).","---","The files in the package org.apache.commons.compress.archivers.sevenz","were derived from the LZMA SDK, version 9.20 (C/ and CPP/7zip/),","which has been placed in the public domain:","&quot;LZMA SDK is placed in the public domain.&quot; (http://www.7-zip.org/sdk.html)","---","The test file lbzip2_32767.bz2 has been copied from libbzip2's source","repository:","This program, &quot;bzip2&quot;, the associated library &quot;libbzip2&quot;, and all","documentation, are copyright (C) 1996-2019 Julian R Seward.  All","rights reserved.","Redistribution and use in source and binary forms, with or without","modification, are permitted provided that the following conditions","are met:","1. Redistributions of source code must retain the above copyright","   notice, this list of conditions and the following disclaimer.","2. The origin of this software must not be misrepresented; you must ","   not claim that you wrote the original software.  If you use this ","   software in a product, an acknowledgment in the product ","   documentation would be appreciated but is not required.","3. Altered source versions must be plainly marked as such, and must","   not be misrepresented as being the original software","4. The name of the author may not be used to endorse or promote ","   products derived from this software without specific prior written ","   permission.","THIS SOFTWARE IS PROVIDED BY THE AUTHOR ``AS IS'' AND ANY EXPRESS","OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED","WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE","ARE DISCLAIMED.  IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR ANY","DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL","DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE","GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS","INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY,","WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING","NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS","SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.","Julian Seward, jseward@acm.org","Commons Compress<br /> (Primavera P6 EPPM Licensing Information User Manual)","English\\licensing_information\\p6_eppm_licensing_information\\102498.htm");
Page[462]=new Array("Apache Commons IO","Copyright 2002-2023 The Apache Software Foundation","Licensed under the Apache Software License, Version 2.0 (the &quot;License&quot;); you may not use this file except in compliance with the License.","Commons IO<br /> (Primavera P6 EPPM Licensing Information User Manual)","English\\licensing_information\\p6_eppm_licensing_information\\102351.htm");
Page[463]=new Array("NOTICE:","Apache Commons Lang","Copyright 2001-2020 The Apache Software Foundation","This product includes software developed at","The Apache Software Foundation (http://www.apache.org/).","Licensed under the Apache Software License, Version 2.0 (the &quot;License&quot;); you may not use this file except in compliance with the License.","Commons Lang<br /> (Primavera P6 EPPM Licensing Information User Manual)","English\\licensing_information\\p6_eppm_licensing_information\\102038.htm");
Page[464]=new Array("------------------------------- Top-level license --------------------------","Apache CXF is licensed under Apache 2.0.","Licensed under the Apache Software License, Version 2.0 (the &quot;License&quot;); you may not use this file except in compliance with the License.","---------------------------------------","4PL apache","org.apache.cxf:cxf-core:jar:compile","org.apache.cxf:cxf-rt-databinding-jaxb:jar:compile","org.apache.cxf:cxf-rt-frontend-jaxws:jar:compile","org.apache.cxf:cxf-rt-transports-http:jar:compile","org.apache.cxf:cxf-rt-wsdl:jar:compile","org.apache.cxf:cxf-rt-bindings-soap:jar:compile","org.apache.cxf:cxf-rt-frontend-simple:jar:compile","org.apache.ws.xmlschema:xmlschema-core:jar:compile","com.fasterxml.woodstox:woodstox-core:jar:compile","-----------------------------------------------","/NOTICE","Apache CXF","Copyright 2006-2022 The Apache Software Foundation","This product includes software developed at","The Apache Software Foundation (http://www.apache.org/).","This product also includes schemas and specification developed by or submitted to:","      - the W3C consortium (http://www.w3c.org)","      (http://www.w3.org/XML/1998/namespace)","      ","This product also includes WS-* schemas developed by International","   Business Machines Corporation, Microsoft Corporation, BEA Systems, ","   TIBCO Software, SAP AG, Sonic Software, and VeriSign","   (http://schemas.xmlsoap.org/wsdl/2003-02-11.xsd)","   (http://schemas.xmlsoap.org/ws/2004/08/addressing/)","   (http://schemas.xmlsoap.org/wsdl/http)","   (http://schemas.xmlsoap.org/ws/2005/02/rm/wsrm.xsd)","   (http://www.w3.org/2005/08/addressing/ws-addr.xsd)","   (http://www.w3.org/TR/ws-metadata-exchange/)","   (http://schemas.xmlsoap.org/ws/2004/09/mex/)","   (http://docs.oasis-open.org/ws-sx/ws-trust/v1.4/ws-trust.html)","The product contains code (StaxBuilder.java) that is","  Copyright (C) 2000-2004 Jason Hunter &amp; Brett McLaughlin.","  All rights reserved.","  See the NOTICE.jdom file for additional information","Java classes (source and binary) under org.apache.cxf.jaxws.javaee","are generated from schema available here:","(http://java.sun.com/xml/ns/javaee/javaee_5.xsd)","This Product also includes software developed by David Heinemeier Hansson.","(http://dev.rubyonrails.org/browser/trunk/activesupport/lib/active_support/inflections.rb)","This product includes software Copyright University of Southampton IT Innovation Centre, 2009 ","(http://www.it-innovation.soton.ac.uk). ","Portions of the included XmlSchema library are Copyright 2006 International Business Machines Corp.","Portions of the included xmlbeans library were originally based on the following:","   - software copyright (c) 2000-2003, BEA Systems, &lt;http://www.bea.com/&gt;.","Portions of the file cxf-utils.js derives from code marked:","This code was written by Tyler Akins and has been placed in the","public domain.  It would be nice if you left this header intact.","Base64 code from Tyler Akins -- http://rumkin.com","This project includes Public Suffix List copied from","https://publicsuffix.org/list/effective_tld_names.dat","licensed under the terms of the Mozilla Public License, v. 2.0","Full license text: &lt;http://mozilla.org/MPL/2.0/&gt;","This product includes software from the Spring Framework, under the Apache","License 2.0","This project includes Apache Ant. The &lt;sync&gt; task is based on code Copyright","(c) 2002, Landmark Graphics Corp that has been kindly donated to the Apache","Software Foundation.","Additional copyright notices and license terms applicable are","present in the licenses directory of this distribution.","This product includes code from the Nimbus JOSE + JWT project, under the Apache","license 2.0 (https://github.com/felx/nimbus-jose-jwt). Copyright 2012-2017,","Connect2id Ltd.","-------------------------------------------------","/rt/frontend/jaxws/src/main/appended-resources/META-INF/NOTICE","Java classes (source and binary) under org.apache.cxf.jaxws.javaee","are generated from schema available here:","(http://java.sun.com/xml/ns/javaee/javaee_5.xsd)","------------------------------------------------------","/rt/transports/http/src/main/appended-resources/META-INF/NOTICE","This project includes Public Suffix List copied from","https://publicsuffix.org/list/effective_tld_names.dat","licensed under the terms of the Mozilla Public License, v. 2.0","Full license text: &lt;http://mozilla.org/MPL/2.0/&gt;","--------------------------------------------------","/rt/databinding/aegis/src/main/resources/META-INF/NOTICE.jdom"," Copyright (C) 2000-2004 Jason Hunter &amp; Brett McLaughlin."," All rights reserved."," Redistribution and use in source and binary forms, with or without"," modification, are permitted provided that the following conditions"," are met:"," 1. Redistributions of source code must retain the above copyright"," notice, this list of conditions, and the following disclaimer."," 2. Redistributions in binary form must reproduce the above copyright"," notice, this list of conditions, and the disclaimer that follows"," these conditions in the documentation and/or other materials"," provided with the distribution."," 3. The name &quot;JDOM&quot; must not be used to endorse or promote products"," derived from this software without prior written permission.  For"," written permission, please contact &lt;request_AT_jdom_DOT_org&gt;."," 4. Products derived from this software may not be called &quot;JDOM&quot;, nor"," may &quot;JDOM&quot; appear in their name, without prior written permission"," from the JDOM Project Management &lt;request_AT_jdom_DOT_org&gt;."," In addition, we request (but do not require) that you include in the"," end-user documentation provided with the redistribution and/or in the"," software itself an acknowledgement equivalent to the following:"," &quot;This product includes software developed by the"," JDOM Project (http://www.jdom.org/).&quot;"," Alternatively, the acknowledgment may be graphical using the logos"," available at http://www.jdom.org/images/logos."," THIS SOFTWARE IS PROVIDED ``AS IS'' AND ANY EXPRESSED OR IMPLIED"," WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES"," OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE"," DISCLAIMED.  IN NO EVENT SHALL THE JDOM AUTHORS OR THE PROJECT"," CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,"," SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT"," LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF"," USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND"," ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,"," OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT"," OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF"," SUCH DAMAGE."," This software consists of voluntary contributions made by many"," individuals on behalf of the JDOM Project and was originally"," created by Jason Hunter &lt;jhunter_AT_jdom_DOT_org&gt; and"," Brett McLaughlin &lt;brett_AT_jdom_DOT_org&gt;.  For more information"," on the JDOM Project, please see &lt;http://www.jdom.org/&gt;.","------------------------------------------------------------","/rt/databinding/aegis/src/main/appended-resources/META-INF/NOTICE","The product contains code (StaxBuilder.java) that is","  Copyright (C) 2000-2004 Jason Hunter &amp; Brett McLaughlin.","  All rights reserved.","  See the NOTICE.jdom file for additional information","---------------------------------------------------------","/rt/javascript/javascript-rt/src/main/appended-resources/META-INF/NOTICE","Portions of the file cxf-utils.js derives from code marked:","This code was written by Tyler Akins and has been placed in the","public domain.  It would be nice if you left this header intact.","Base64 code from Tyler Akins -- http://rumkin.com","----------------------------------------------------------","/rt/ws/policy/src/main/appended-resources/META-INF/NOTICE","This product includes software Copyright University of Southampton IT Innovation Centre, 2009 ","(http://www.it-innovation.soton.ac.uk). ","================================================================================","4PL org.codehaus.woodstox:stax2-api","Copyright (c) 2008 FasterXML LLC info@fasterxml.com","This source code is licensed under standard BSD license, which is compatible ","with all Free and Open Software (OSS) licenses.","This copy of Stax2 API is licensed under the","Simplified BSD License (also known as &quot;2-clause BSD&quot;, or &quot;FreeBSD License&quot;)","See the License for details about distribution rights, and the","specific rights regarding derivate works.","You may obtain a copy of the License at:","http://www.opensource.org/licenses/bsd-license.php","with details of:","&lt;COPYRIGHT HOLDER&gt; = FasterXML.com","&lt;YEAR&gt; = 2010-","================================================================================","CXF<br /> (Primavera P6 EPPM Licensing Information User Manual)","English\\licensing_information\\p6_eppm_licensing_information\\102235.htm");
Page[465]=new Array("Copyright (C) 2020 The Guava Authors","Licensed under the Apache Software License, Version 2.0 (the &quot;License&quot;); you may not use this file except in compliance with the License.","====================================================================","+--- 4th party: com.google.code.findbugs:jsr305","Copyright: JSR305 expert group","=== Source URL: https://github.com/findbugsproject/findbugs/releases","License: BSD 3-Clause","Copyright (c) 2007-2009, JSR305 expert group","All rights reserved.","Redistribution and use in source and binary forms, with or without ","modification, are permitted provided that the following conditions are met:","    * Redistributions of source code must retain the above copyright notice, ","      this list of conditions and the following disclaimer.","    * Redistributions in binary form must reproduce the above copyright notice, ","      this list of conditions and the following disclaimer in the documentation ","      and/or other materials provided with the distribution.","    * Neither the name of the JSR305 expert group nor the names of its ","      contributors may be used to endorse or promote products derived from ","      this software without specific prior written permission.","THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS &quot;AS IS&quot; AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.","==  jcip-annotations relicensed to Oracle under BSD 3-clause license","Copyright (c) 2005, Brian Goetz and Tim Peierls","Redistribution and use in source and binary forms, with or without ","modification, are permitted provided that the following conditions are met:","    * Redistributions of source code must retain the above copyright notice, ","      this list of conditions and the following disclaimer.","    * Redistributions in binary form must reproduce the above copyright notice, ","      this list of conditions and the following disclaimer in the documentation ","      and/or other materials provided with the distribution.","    * Neither the name of the JSR305 expert group nor the names of its ","      contributors may be used to endorse or promote products derived from ","      this software without specific prior written permission.","THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS &quot;AS IS&quot; ","AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, ","THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ","ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE ","LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR ","CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF ","SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS ","INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN ","CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ","ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE ","POSSIBILITY OF SUCH DAMAGE."," ","   ======================================================================","+--- 4th party: com.google.errorprone:error_prone_annotations","Copyright 2015 The Error Prone Authors.","   Licensed under the Apache License, Version 2.0 (the &quot;License&quot;);","   you may not use this file except in compliance with the License.","   You may obtain a copy of the License at","       http://www.apache.org/licenses/LICENSE-2.0","   Unless required by applicable law or agreed to in writing, software","   distributed under the License is distributed on an &quot;AS IS&quot; BASIS,","   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.","   See the License for the specific language governing permissions and","   limitations under the License.","   ","  &lt; Apache License Version 2.0&gt;","  ","+--- 4th party: com.google.j2objc:j2objc-annotations","Google Inc.","Daniel Connelly","Copyright 2012 Google Inc. All Rights Reserved.","   Licensed under the Apache License, Version 2.0 (the &quot;License&quot;);","   you may not use this file except in compliance with the License.","   You may obtain a copy of the License at","       http://www.apache.org/licenses/LICENSE-2.0","   Unless required by applicable law or agreed to in writing, software","   distributed under the License is distributed on an &quot;AS IS&quot; BASIS,","   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.","   See the License for the specific language governing permissions and","   limitations under the License.","   ","   &lt; Apache License Version 2.0&gt;","===========================================================================","+--- 4th party: org.checkerframework:checker-qual","Copyright 2004-present by the Checker Framework developers","MIT License:","Permission is hereby granted, free of charge, to any person obtaining a copy","of this software and associated documentation files (the &quot;Software&quot;), to deal","in the Software without restriction, including without limitation the rights","to use, copy, modify, merge, publish, distribute, sublicense, and/or sell","copies of the Software, and to permit persons to whom the Software is","furnished to do so, subject to the following conditions:","The above copyright notice and this permission notice shall be included in","all copies or substantial portions of the Software.","THE SOFTWARE IS PROVIDED &quot;AS IS&quot;, WITHOUT WARRANTY OF ANY KIND, EXPRESS OR","IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,","FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE","AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER","LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,","OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN","THE SOFTWARE.","===========================================================================","Guava<br /> (Primavera P6 EPPM Licensing Information User Manual)","English\\licensing_information\\p6_eppm_licensing_information\\101530.htm");
Page[466]=new Array("====================","top level copyright and license","Copyright (c) 2021, Ben Fortuna","All rights reserved.","Redistribution and use in source and binary forms, with or without","modification, are permitted provided that the following conditions are met:","* Redistributions of source code must retain the above copyright notice, this","  list of conditions and the following disclaimer.","* Redistributions in binary form must reproduce the above copyright notice,","  this list of conditions and the following disclaimer in the documentation","  and/or other materials provided with the distribution.","* Neither the name of the copyright holder nor the names of its","  contributors may be used to endorse or promote products derived from","  this software without specific prior written permission.","THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS &quot;AS IS&quot;","AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE","IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE","DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT HOLDER OR CONTRIBUTORS BE LIABLE","FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL","DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR","SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER","CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,","OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE","OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.","=====================================","commons-codec ","Apache Commons Codec","Copyright 2002-2021 The Apache Software Foundation","This product includes software developed at","The Apache Software Foundation (https://www.apache.org/).","src/test/org/apache/commons/codec/language/DoubleMetaphoneTest.java","contains test data from http://aspell.net/test/orig/batch0.tab.","Copyright (C) 2002 Kevin Atkinson (kevina@gnu.org)","===============================================================================","The content of package org.apache.commons.codec.language.bm has been translated","from the original php source code available at http://stevemorse.org/phoneticinfo.htm","with permission from the original authors.","Original source copyright:","Copyright (c) 2008 Alexander Beider &amp; Stephen P. Morse.","Licensed under the Apache Software License, Version 2.0 (the &quot;License&quot;); you may not use this file except in compliance with the License.","==========================================","commons-lang3","Apache Commons Lang","Copyright 2001-2021 The Apache Software Foundation","This product includes software developed at","The Apache Software Foundation (https://www.apache.org/).","same Apache 2.0 license","===============================","Apache Commons Collections","Copyright 2001-2020 The Apache Software Foundation","This product includes software developed at","The Apache Software Foundation (http://www.apache.org/).","same Apache 2.0 license","===============================","Apache Commons Validator","Copyright 2001-2020 The Apache Software Foundation","This product includes software developed at","The Apache Software Foundation (http://www.apache.org/).","same Apache 2.0 license","==================================","slf4j-api","Copyright (c) 2004-2017 QOS.ch","All rights reserved.","Permission is hereby granted, free  of charge, to any person obtaining","a  copy  of this  software  and  associated  documentation files  (the","&quot;Software&quot;), to  deal in  the Software without  restriction, including","without limitation  the rights to  use, copy, modify,  merge, publish,","distribute,  sublicense, and/or sell  copies of  the Software,  and to","permit persons to whom the Software  is furnished to do so, subject to","the following conditions:","The  above  copyright  notice  and  this permission  notice  shall  be","included in all copies or substantial portions of the Software.","THE  SOFTWARE IS  PROVIDED  &quot;AS  IS&quot;, WITHOUT  WARRANTY  OF ANY  KIND,","EXPRESS OR  IMPLIED, INCLUDING  BUT NOT LIMITED  TO THE  WARRANTIES OF","MERCHANTABILITY,    FITNESS    FOR    A   PARTICULAR    PURPOSE    AND","NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE","LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION","OF CONTRACT, TORT OR OTHERWISE,  ARISING FROM, OUT OF OR IN CONNECTION","WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.","iCal4j<br /> (Primavera P6 EPPM Licensing Information User Manual)","English\\licensing_information\\p6_eppm_licensing_information\\49064.htm");
Page[467]=new Array("Eclipse Public License - v 2.0","    THE ACCOMPANYING PROGRAM IS PROVIDED UNDER THE TERMS OF THIS ECLIPSE","    PUBLIC LICENSE (&quot;AGREEMENT&quot;). ANY USE, REPRODUCTION OR DISTRIBUTION","    OF THE PROGRAM CONSTITUTES RECIPIENT'S ACCEPTANCE OF THIS AGREEMENT.","1. DEFINITIONS","&quot;Contribution&quot; means:","  a) in the case of the initial Contributor, the initial content","     Distributed under this Agreement, and","  b) in the case of each subsequent Contributor: ","     i) changes to the Program, and ","     ii) additions to the Program;","  where such changes and/or additions to the Program originate from","  and are Distributed by that particular Contributor. A Contribution","  &quot;originates&quot; from a Contributor if it was added to the Program by","  such Contributor itself or anyone acting on such Contributor's behalf.","  Contributions do not include changes or additions to the Program that","  are not Modified Works.","&quot;Contributor&quot; means any person or entity that Distributes the Program.","&quot;Licensed Patents&quot; mean patent claims licensable by a Contributor which","are necessarily infringed by the use or sale of its Contribution alone","or when combined with the Program.","&quot;Program&quot; means the Contributions Distributed in accordance with this","Agreement.","&quot;Recipient&quot; means anyone who receives the Program under this Agreement","or any Secondary License (as applicable), including Contributors.","&quot;Derivative Works&quot; shall mean any work, whether in Source Code or other","form, that is based on (or derived from) the Program and for which the","editorial revisions, annotations, elaborations, or other modifications","represent, as a whole, an original work of authorship.","&quot;Modified Works&quot; shall mean any work in Source Code or other form that","results from an addition to, deletion from, or modification of the","contents of the Program, including, for purposes of clarity any new file","in Source Code form that contains any contents of the Program. Modified","Works shall not include works that contain only declarations,","interfaces, types, classes, structures, or files of the Program solely","in each case in order to link to, bind by name, or subclass the Program","or Modified Works thereof.","&quot;Distribute&quot; means the acts of a) distributing or b) making available","in any manner that enables the transfer of a copy.","&quot;Source Code&quot; means the form of a Program preferred for making","modifications, including but not limited to software source code,","documentation source, and configuration files.","&quot;Secondary License&quot; means either the GNU General Public License,","Version 2.0, or any later versions of that license, including any","exceptions or additional permissions as identified by the initial","Contributor.","2. GRANT OF RIGHTS","  a) Subject to the terms of this Agreement, each Contributor hereby","  grants Recipient a non-exclusive, worldwide, royalty-free copyright","  license to reproduce, prepare Derivative Works of, publicly display,","  publicly perform, Distribute and sublicense the Contribution of such","  Contributor, if any, and such Derivative Works.","  b) Subject to the terms of this Agreement, each Contributor hereby","  grants Recipient a non-exclusive, worldwide, royalty-free patent","  license under Licensed Patents to make, use, sell, offer to sell,","  import and otherwise transfer the Contribution of such Contributor,","  if any, in Source Code or other form. This patent license shall","  apply to the combination of the Contribution and the Program if, at","  the time the Contribution is added by the Contributor, such addition","  of the Contribution causes such combination to be covered by the","  Licensed Patents. The patent license shall not apply to any other","  combinations which include the Contribution. No hardware per se is","  licensed hereunder.","  c) Recipient understands that although each Contributor grants the","  licenses to its Contributions set forth herein, no assurances are","  provided by any Contributor that the Program does not infringe the","  patent or other intellectual property rights of any other entity.","  Each Contributor disclaims any liability to Recipient for claims","  brought by any other entity based on infringement of intellectual","  property rights or otherwise. As a condition to exercising the","  rights and licenses granted hereunder, each Recipient hereby","  assumes sole responsibility to secure any other intellectual","  property rights needed, if any. For example, if a third party","  patent license is required to allow Recipient to Distribute the","  Program, it is Recipient's responsibility to acquire that license","  before distributing the Program.","  d) Each Contributor represents that to its knowledge it has","  sufficient copyright rights in its Contribution, if any, to grant","  the copyright license set forth in this Agreement.","  e) Notwithstanding the terms of any Secondary License, no","  Contributor makes additional grants to any Recipient (other than","  those set forth in this Agreement) as a result of such Recipient's","  receipt of the Program under the terms of a Secondary License","  (if permitted under the terms of Section 3).","3. REQUIREMENTS","3.1 If a Contributor Distributes the Program in any form, then:","  a) the Program must also be made available as Source Code, in","  accordance with section 3.2, and the Contributor must accompany","  the Program with a statement that the Source Code for the Program","  is available under this Agreement, and informs Recipients how to","  obtain it in a reasonable manner on or through a medium customarily","  used for software exchange; and","  b) the Contributor may Distribute the Program under a license","  different than this Agreement, provided that such license:","     i) effectively disclaims on behalf of all other Contributors all","     warranties and conditions, express and implied, including","     warranties or conditions of title and non-infringement, and","     implied warranties or conditions of merchantability and fitness","     for a particular purpose;","     ii) effectively excludes on behalf of all other Contributors all","     liability for damages, including direct, indirect, special,","     incidental and consequential damages, such as lost profits;","     iii) does not attempt to limit or alter the recipients' rights","     in the Source Code under section 3.2; and","     iv) requires any subsequent distribution of the Program by any","     party to be under a license that satisfies the requirements","     of this section 3.","3.2 When the Program is Distributed as Source Code:","  a) it must be made available under this Agreement, or if the","  Program (i) is combined with other material in a separate file or","  files made available under a Secondary License, and (ii) the initial","  Contributor attached to the Source Code the notice described in","  Exhibit A of this Agreement, then the Program may be made available","  under the terms of such Secondary Licenses, and","  b) a copy of this Agreement must be included with each copy of","  the Program.","3.3 Contributors may not remove or alter any copyright, patent,","trademark, attribution notices, disclaimers of warranty, or limitations","of liability (&quot;notices&quot;) contained within the Program from any copy of","the Program which they Distribute, provided that Contributors may add","their own appropriate notices.","4. COMMERCIAL DISTRIBUTION","Commercial distributors of software may accept certain responsibilities","with respect to end users, business partners and the like. While this","license is intended to facilitate the commercial use of the Program,","the Contributor who includes the Program in a commercial product","offering should do so in a manner which does not create potential","liability for other Contributors. Therefore, if a Contributor includes","the Program in a commercial product offering, such Contributor","(&quot;Commercial Contributor&quot;) hereby agrees to defend and indemnify every","other Contributor (&quot;Indemnified Contributor&quot;) against any losses,","damages and costs (collectively &quot;Losses&quot;) arising from claims, lawsuits","and other legal actions brought by a third party against the Indemnified","Contributor to the extent caused by the acts or omissions of such","Commercial Contributor in connection with its distribution of the Program","in a commercial product offering. The obligations in this section do not","apply to any claims or Losses relating to any actual or alleged","intellectual property infringement. In order to qualify, an Indemnified","Contributor must: a) promptly notify the Commercial Contributor in","writing of such claim, and b) allow the Commercial Contributor to control,","and cooperate with the Commercial Contributor in, the defense and any","related settlement negotiations. The Indemnified Contributor may","participate in any such claim at its own expense.","For example, a Contributor might include the Program in a commercial","product offering, Product X. That Contributor is then a Commercial","Contributor. If that Commercial Contributor then makes performance","claims, or offers warranties related to Product X, those performance","claims and warranties are such Commercial Contributor's responsibility","alone. Under this section, the Commercial Contributor would have to","defend claims against the other Contributors related to those performance","claims and warranties, and if a court requires any other Contributor to","pay any damages as a result, the Commercial Contributor must pay","those damages.","5. NO WARRANTY","EXCEPT AS EXPRESSLY SET FORTH IN THIS AGREEMENT, AND TO THE EXTENT","PERMITTED BY APPLICABLE LAW, THE PROGRAM IS PROVIDED ON AN &quot;AS IS&quot;","BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, EITHER EXPRESS OR","IMPLIED INCLUDING, WITHOUT LIMITATION, ANY WARRANTIES OR CONDITIONS OF","TITLE, NON-INFRINGEMENT, MERCHANTABILITY OR FITNESS FOR A PARTICULAR","PURPOSE. Each Recipient is solely responsible for determining the","appropriateness of using and distributing the Program and assumes all","risks associated with its exercise of rights under this Agreement,","including but not limited to the risks and costs of program errors,","compliance with applicable laws, damage to or loss of data, programs","or equipment, and unavailability or interruption of operations.","6. DISCLAIMER OF LIABILITY","EXCEPT AS EXPRESSLY SET FORTH IN THIS AGREEMENT, AND TO THE EXTENT","PERMITTED BY APPLICABLE LAW, NEITHER RECIPIENT NOR ANY CONTRIBUTORS","SHALL HAVE ANY LIABILITY FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL,","EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING WITHOUT LIMITATION LOST","PROFITS), HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN","CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)","ARISING IN ANY WAY OUT OF THE USE OR DISTRIBUTION OF THE PROGRAM OR THE","EXERCISE OF ANY RIGHTS GRANTED HEREUNDER, EVEN IF ADVISED OF THE","POSSIBILITY OF SUCH DAMAGES.","7. GENERAL","If any provision of this Agreement is invalid or unenforceable under","applicable law, it shall not affect the validity or enforceability of","the remainder of the terms of this Agreement, and without further","action by the parties hereto, such provision shall be reformed to the","minimum extent necessary to make such provision valid and enforceable.","If Recipient institutes patent litigation against any entity","(including a cross-claim or counterclaim in a lawsuit) alleging that the","Program itself (excluding combinations of the Program with other software","or hardware) infringes such Recipient's patent(s), then such Recipient's","rights granted under Section 2(b) shall terminate as of the date such","litigation is filed.","All Recipient's rights under this Agreement shall terminate if it","fails to comply with any of the material terms or conditions of this","Agreement and does not cure such failure in a reasonable period of","time after becoming aware of such noncompliance. If all Recipient's","rights under this Agreement terminate, Recipient agrees to cease use","and distribution of the Program as soon as reasonably practicable.","However, Recipient's obligations under this Agreement and any licenses","granted by Recipient relating to the Program shall continue and survive.","Everyone is permitted to copy and distribute copies of this Agreement,","but in order to avoid inconsistency the Agreement is copyrighted and","may only be modified in the following manner. The Agreement Steward","reserves the right to publish new versions (including revisions) of","this Agreement from time to time. No one other than the Agreement","Steward has the right to modify this Agreement. The Eclipse Foundation","is the initial Agreement Steward. The Eclipse Foundation may assign the","responsibility to serve as the Agreement Steward to a suitable separate","entity. Each new version of the Agreement will be given a distinguishing","version number. The Program (including Contributions) may always be","Distributed subject to the version of the Agreement under which it was","received. In addition, after a new version of the Agreement is published,","Contributor may elect to Distribute the Program (including its","Contributions) under the new version.","Except as expressly stated in Sections 2(a) and 2(b) above, Recipient","receives no rights or licenses to the intellectual property of any","Contributor under this Agreement, whether expressly, by implication,","estoppel or otherwise. All rights in the Program not expressly granted","under this Agreement are reserved. Nothing in this Agreement is intended","to be enforceable by any entity that is not a Contributor or Recipient.","No third-party beneficiary rights are created under this Agreement.","Exhibit A - Form of Secondary Licenses Notice","&quot;This Source Code may also be made available under the following ","Secondary Licenses when the conditions for such availability set forth ","in the Eclipse Public License, v. 2.0 are satisfied: {name license(s),","version(s), and exceptions or additional permissions here}.&quot;","  Simply including a copy of this Agreement, including this Exhibit A","  is not sufficient to license the Source Code under Secondary Licenses.","  If it is not possible or desirable to put the notice in a particular","  file, then You may include the notice in a location (such as a LICENSE","  file in a relevant directory) where a recipient would be likely to","  look for such a notice.","  You may add additional accurate notices of copyright ownership.","The GNU General Public License (GPL) Version 2, June 1991","Copyright (C) 1989, 1991 Free Software Foundation, Inc.","51 Franklin Street, Fifth Floor","Boston, MA 02110-1335","USA","Everyone is permitted to copy and distribute verbatim copies","of this license document, but changing it is not allowed.","Preamble","The licenses for most software are designed to take away your freedom to","share and change it. By contrast, the GNU General Public License is","intended to guarantee your freedom to share and change free software--to","make sure the software is free for all its users. This General Public","License applies to most of the Free Software Foundation's software and","to any other program whose authors commit to using it. (Some other Free","Software Foundation software is covered by the GNU Library General","Public License instead.) You can apply it to your programs, too.","When we speak of free software, we are referring to freedom, not price.","Our General Public Licenses are designed to make sure that you have the","freedom to distribute copies of free software (and charge for this","service if you wish), that you receive source code or can get it if you","want it, that you can change the software or use pieces of it in new","free programs; and that you know you can do these things.","To protect your rights, we need to make restrictions that forbid anyone","to deny you these rights or to ask you to surrender the rights. These","restrictions translate to certain responsibilities for you if you","distribute copies of the software, or if you modify it.","For example, if you distribute copies of such a program, whether gratis","or for a fee, you must give the recipients all the rights that you have.","You must make sure that they, too, receive or can get the source code.","And you must show them these terms so they know their rights.","We protect your rights with two steps: (1) copyright the software, and","(2) offer you this license which gives you legal permission to copy,","distribute and/or modify the software.","Also, for each author's protection and ours, we want to make certain","that everyone understands that there is no warranty for this free","software. If the software is modified by someone else and passed on, we","want its recipients to know that what they have is not the original, so","that any problems introduced by others will not reflect on the original","authors' reputations.","Finally, any free program is threatened constantly by software patents.","We wish to avoid the danger that redistributors of a free program will","individually obtain patent licenses, in effect making the program","proprietary. To prevent this, we have made it clear that any patent must","be licensed for everyone's free use or not licensed at all.","The precise terms and conditions for copying, distribution and","modification follow.","TERMS AND CONDITIONS FOR COPYING, DISTRIBUTION AND MODIFICATION","0. This License applies to any program or other work which contains a","notice placed by the copyright holder saying it may be distributed under","the terms of this General Public License. The &quot;Program&quot;, below, refers","to any such program or work, and a &quot;work based on the Program&quot; means","either the Program or any derivative work under copyright law: that is","to say, a work containing the Program or a portion of it, either","verbatim or with modifications and/or translated into another language.","(Hereinafter, translation is included without limitation in the term","&quot;modification&quot;.) Each licensee is addressed as &quot;you&quot;.","Activities other than copying, distribution and modification are not","covered by this License; they are outside its scope. The act of running","the Program is not restricted, and the output from the Program is","covered only if its contents constitute a work based on the Program","(independent of having been made by running the Program). Whether that","is true depends on what the Program does.","1. You may copy and distribute verbatim copies of the Program's source","code as you receive it, in any medium, provided that you conspicuously","and appropriately publish on each copy an appropriate copyright notice","and disclaimer of warranty; keep intact all the notices that refer to","this License and to the absence of any warranty; and give any other","recipients of the Program a copy of this License along with the Program.","You may charge a fee for the physical act of transferring a copy, and","you may at your option offer warranty protection in exchange for a fee.","2. You may modify your copy or copies of the Program or any portion of","it, thus forming a work based on the Program, and copy and distribute","such modifications or work under the terms of Section 1 above, provided","that you also meet all of these conditions:","    a) You must cause the modified files to carry prominent notices","    stating that you changed the files and the date of any change.","    b) You must cause any work that you distribute or publish, that in","    whole or in part contains or is derived from the Program or any part","    thereof, to be licensed as a whole at no charge to all third parties","    under the terms of this License.","    c) If the modified program normally reads commands interactively","    when run, you must cause it, when started running for such","    interactive use in the most ordinary way, to print or display an","    announcement including an appropriate copyright notice and a notice","    that there is no warranty (or else, saying that you provide a","    warranty) and that users may redistribute the program under these","    conditions, and telling the user how to view a copy of this License.","    (Exception: if the Program itself is interactive but does not","    normally print such an announcement, your work based on the Program","    is not required to print an announcement.)","These requirements apply to the modified work as a whole. If","identifiable sections of that work are not derived from the Program, and","can be reasonably considered independent and separate works in","themselves, then this License, and its terms, do not apply to those","sections when you distribute them as separate works. But when you","distribute the same sections as part of a whole which is a work based on","the Program, the distribution of the whole must be on the terms of this","License, whose permissions for other licensees extend to the entire","whole, and thus to each and every part regardless of who wrote it.","Thus, it is not the intent of this section to claim rights or contest","your rights to work written entirely by you; rather, the intent is to","exercise the right to control the distribution of derivative or","collective works based on the Program.","In addition, mere aggregation of another work not based on the Program","with the Program (or with a work based on the Program) on a volume of a","storage or distribution medium does not bring the other work under the","scope of this License.","3. You may copy and distribute the Program (or a work based on it,","under Section 2) in object code or executable form under the terms of","Sections 1 and 2 above provided that you also do one of the following:","    a) Accompany it with the complete corresponding machine-readable","    source code, which must be distributed under the terms of Sections 1","    and 2 above on a medium customarily used for software interchange; or,","    b) Accompany it with a written offer, valid for at least three","    years, to give any third party, for a charge no more than your cost","    of physically performing source distribution, a complete","    machine-readable copy of the corresponding source code, to be","    distributed under the terms of Sections 1 and 2 above on a medium","    customarily used for software interchange; or,","    c) Accompany it with the information you received as to the offer to","    distribute corresponding source code. (This alternative is allowed","    only for noncommercial distribution and only if you received the","    program in object code or executable form with such an offer, in","    accord with Subsection b above.)","The source code for a work means the preferred form of the work for","making modifications to it. For an executable work, complete source code","means all the source code for all modules it contains, plus any","associated interface definition files, plus the scripts used to control","compilation and installation of the executable. However, as a special","exception, the source code distributed need not include anything that is","normally distributed (in either source or binary form) with the major","components (compiler, kernel, and so on) of the operating system on","which the executable runs, unless that component itself accompanies the","executable.","If distribution of executable or object code is made by offering access","to copy from a designated place, then offering equivalent access to copy","the source code from the same place counts as distribution of the source","code, even though third parties are not compelled to copy the source","along with the object code.","4. You may not copy, modify, sublicense, or distribute the Program","except as expressly provided under this License. Any attempt otherwise","to copy, modify, sublicense or distribute the Program is void, and will","automatically terminate your rights under this License. However, parties","who have received copies, or rights, from you under this License will","not have their licenses terminated so long as such parties remain in","full compliance.","5. You are not required to accept this License, since you have not","signed it. However, nothing else grants you permission to modify or","distribute the Program or its derivative works. These actions are","prohibited by law if you do not accept this License. Therefore, by","modifying or distributing the Program (or any work based on the","Program), you indicate your acceptance of this License to do so, and all","its terms and conditions for copying, distributing or modifying the","Program or works based on it.","6. Each time you redistribute the Program (or any work based on the","Program), the recipient automatically receives a license from the","original licensor to copy, distribute or modify the Program subject to","these terms and conditions. You may not impose any further restrictions","on the recipients' exercise of the rights granted herein. You are not","responsible for enforcing compliance by third parties to this License.","7. If, as a consequence of a court judgment or allegation of patent","infringement or for any other reason (not limited to patent issues),","conditions are imposed on you (whether by court order, agreement or","otherwise) that contradict the conditions of this License, they do not","excuse you from the conditions of this License. If you cannot distribute","so as to satisfy simultaneously your obligations under this License and","any other pertinent obligations, then as a consequence you may not","distribute the Program at all. For example, if a patent license would","not permit royalty-free redistribution of the Program by all those who","receive copies directly or indirectly through you, then the only way you","could satisfy both it and this License would be to refrain entirely from","distribution of the Program.","If any portion of this section is held invalid or unenforceable under","any particular circumstance, the balance of the section is intended to","apply and the section as a whole is intended to apply in other","circumstances.","It is not the purpose of this section to induce you to infringe any","patents or other property right claims or to contest validity of any","such claims; this section has the sole purpose of protecting the","integrity of the free software distribution system, which is implemented","by public license practices. Many people have made generous","contributions to the wide range of software distributed through that","system in reliance on consistent application of that system; it is up to","the author/donor to decide if he or she is willing to distribute","software through any other system and a licensee cannot impose that choice.","This section is intended to make thoroughly clear what is believed to be","a consequence of the rest of this License.","8. If the distribution and/or use of the Program is restricted in","certain countries either by patents or by copyrighted interfaces, the","original copyright holder who places the Program under this License may","add an explicit geographical distribution limitation excluding those","countries, so that distribution is permitted only in or among countries","not thus excluded. In such case, this License incorporates the","limitation as if written in the body of this License.","9. The Free Software Foundation may publish revised and/or new","versions of the General Public License from time to time. Such new","versions will be similar in spirit to the present version, but may","differ in detail to address new problems or concerns.","Each version is given a distinguishing version number. If the Program","specifies a version number of this License which applies to it and &quot;any","later version&quot;, you have the option of following the terms and","conditions either of that version or of any later version published by","the Free Software Foundation. If the Program does not specify a version","number of this License, you may choose any version ever published by the","Free Software Foundation.","10. If you wish to incorporate parts of the Program into other free","programs whose distribution conditions are different, write to the","author to ask for permission. For software which is copyrighted by the","Free Software Foundation, write to the Free Software Foundation; we","sometimes make exceptions for this. Our decision will be guided by the","two goals of preserving the free status of all derivatives of our free","software and of promoting the sharing and reuse of software generally.","NO WARRANTY","11. BECAUSE THE PROGRAM IS LICENSED FREE OF CHARGE, THERE IS NO","WARRANTY FOR THE PROGRAM, TO THE EXTENT PERMITTED BY APPLICABLE LAW.","EXCEPT WHEN OTHERWISE STATED IN WRITING THE COPYRIGHT HOLDERS AND/OR","OTHER PARTIES PROVIDE THE PROGRAM &quot;AS IS&quot; WITHOUT WARRANTY OF ANY KIND,","EITHER EXPRESSED OR IMPLIED, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED","WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE. THE","ENTIRE RISK AS TO THE QUALITY AND PERFORMANCE OF THE PROGRAM IS WITH","YOU. SHOULD THE PROGRAM PROVE DEFECTIVE, YOU ASSUME THE COST OF ALL","NECESSARY SERVICING, REPAIR OR CORRECTION.","12. IN NO EVENT UNLESS REQUIRED BY APPLICABLE LAW OR AGREED TO IN","WRITING WILL ANY COPYRIGHT HOLDER, OR ANY OTHER PARTY WHO MAY MODIFY","AND/OR REDISTRIBUTE THE PROGRAM AS PERMITTED ABOVE, BE LIABLE TO YOU FOR","DAMAGES, INCLUDING ANY GENERAL, SPECIAL, INCIDENTAL OR CONSEQUENTIAL","DAMAGES ARISING OUT OF THE USE OR INABILITY TO USE THE PROGRAM","(INCLUDING BUT NOT LIMITED TO LOSS OF DATA OR DATA BEING RENDERED","INACCURATE OR LOSSES SUSTAINED BY YOU OR THIRD PARTIES OR A FAILURE OF","THE PROGRAM TO OPERATE WITH ANY OTHER PROGRAMS), EVEN IF SUCH HOLDER OR","OTHER PARTY HAS BEEN ADVISED OF THE POSSIBILITY OF SUCH DAMAGES.","END OF TERMS AND CONDITIONS","How to Apply These Terms to Your New Programs","If you develop a new program, and you want it to be of the greatest","possible use to the public, the best way to achieve this is to make it","free software which everyone can redistribute and change under these terms.","To do so, attach the following notices to the program. It is safest to","attach them to the start of each source file to most effectively convey","the exclusion of warranty; and each file should have at least the","&quot;copyright&quot; line and a pointer to where the full notice is found.","    One line to give the program's name and a brief idea of what it does.","    Copyright (C) &lt;year&gt; &lt;name of author&gt;","    This program is free software; you can redistribute it and/or modify","    it under the terms of the GNU General Public License as published by","    the Free Software Foundation; either version 2 of the License, or","    (at your option) any later version.","    This program is distributed in the hope that it will be useful, but","    WITHOUT ANY WARRANTY; without even the implied warranty of","    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU","    General Public License for more details.","    You should have received a copy of the GNU General Public License","    along with this program; if not, write to the Free Software","    Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1335 USA","Also add information on how to contact you by electronic and paper mail.","If the program is interactive, make it output a short notice like this","when it starts in an interactive mode:","    Gnomovision version 69, Copyright (C) year name of author","    Gnomovision comes with ABSOLUTELY NO WARRANTY; for details type","    `show w'. This is free software, and you are welcome to redistribute","    it under certain conditions; type `show c' for details.","The hypothetical commands `show w' and `show c' should show the","appropriate parts of the General Public License. Of course, the commands","you use may be called something other than `show w' and `show c'; they","could even be mouse-clicks or menu items--whatever suits your program.","You should also get your employer (if you work as a programmer) or your","school, if any, to sign a &quot;copyright disclaimer&quot; for the program, if","necessary. Here is a sample; alter the names:","    Yoyodyne, Inc., hereby disclaims all copyright interest in the","    program `Gnomovision' (which makes passes at compilers) written by","    James Hacker.","    signature of Ty Coon, 1 April 1989","    Ty Coon, President of Vice","This General Public License does not permit incorporating your program","into proprietary programs. If your program is a subroutine library, you","may consider it more useful to permit linking proprietary applications","with the library. If this is what you want to do, use the GNU Library","General Public License instead of this License.","CLASSPATH EXCEPTION","Linking this library statically or dynamically with other modules is","making a combined work based on this library.  Thus, the terms and","conditions of the GNU General Public License version 2 cover the whole","combination.","As a special exception, the copyright holders of this library give you","permission to link this library with independent modules to produce an","executable, regardless of the license terms of these independent","modules, and to copy and distribute the resulting executable under","terms of your choice, provided that you also meet, for each linked","independent module, the terms and conditions of the license of that","module.  An independent module is a module which is not derived from or","based on this library.  If you modify this library, you may extend this","exception to your version of the library, but you are not obligated to","do so.  If you do not wish to do so, delete this exception statement","from your version.","----------------------------------------------------------------------------------------","-----------------------------------------------------------------------------------------","Notices for Jakarta Mail","This content is produced and maintained by the Jakarta Mail project.","    Project home: https://projects.eclipse.org/projects/ee4j.mail","Trademarks","Jakarta Mail is a trademark of the Eclipse Foundation.","Copyright","All content is the property of the respective authors or their employers. For more information regarding authorship of content, please consult the listed source code repository logs.","Declared Project Licenses","This program and the accompanying materials are made available under the terms of the Eclipse Public License v. 2.0 which is available at https://www.eclipse.org/legal/epl-2.0. This Source Code may also be made available under the following Secondary Licenses when the conditions for such availability set forth in the Eclipse Public License v. 2.0 are satisfied: (secondary) GPL-2.0 with Classpath-exception-2.0 which is available at https://openjdk.java.net/legal/gplv2+ce.html.","SPDX-License-Identifier: EPL-2.0 OR GPL-2.0-only with Classpath-exception-2.0","Source Code","The project maintains the following source code repositories:","    https://github.com/jakartaee/mail-api","    https://github.com/jakartaee/mail-tck","    https://github.com/jakartaee/mail-spec","Third-party Content","This project leverages the following third party content.","Apache Ant (1.9.6)","    License: Apache License, 2.0, W3C License, Public Domain","commons-lang3 (3.5)","    License: Apache-2.0","font-awesome (4.7.0)","    License: OFL-1.1 AND MIT","jsoup (1.10.2)","    License: MIT","JTHarness (5.0)","    License: GPL-2.0 OR GPL-2.0 WITH Classpath-exception-2.0","normalize.css (3.0.2)","    License: MIT","SigTest (4.0)","    License: (GPL-2.0 OR GPL-2.0 WITH Classpath-exception-2.0)","    Project: https://wiki.openjdk.java.net/display/CodeTools/sigtest","    Source: http://hg.openjdk.java.net/code-tools/sigtest/file/c57f97e2ac2f","Cryptography","Content may contain encryption software. The country in which you are currently may have restrictions on the import, possession, and use, and/or re-export to another country, of encryption software. BEFORE using any encryption software, please check the country's laws, regulations and policies concerning the import, possession, or use, and re-export of encryption software, to see if this is permitted.","------------------------------------------------------------------------------------------------------","Fourth Party Dependency #1 : Jakarta/JavaBeans Activation Framework (JAF)","Fourth Party Dependency #1 License &amp; Copyright:","Copyright (c) 2018 Oracle and/or its affiliates. All rights reserved.","Redistribution and use in source and binary forms, with or without","modification, are permitted provided that the following conditions","are met:","  - Redistributions of source code must retain the above copyright","    notice, this list of conditions and the following disclaimer.","  - Redistributions in binary form must reproduce the above copyright","    notice, this list of conditions and the following disclaimer in the","    documentation and/or other materials provided with the distribution.","  - Neither the name of the Eclipse Foundation, Inc. nor the names of its","    contributors may be used to endorse or promote products derived","    from this software without specific prior written permission.","THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS &quot;AS","IS&quot; AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO,","THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR","PURPOSE ARE DISCLAIMED.  IN NO EVENT SHALL THE COPYRIGHT OWNER OR","CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL,","EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO,","PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR","PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF","LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING","NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS","SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.","# Notices for Jakarta Activation","This content is produced and maintained by Jakarta Activation project.","* Project home: https://projects.eclipse.org/projects/ee4j.jaf","## Copyright","All content is the property of the respective authors or their employers. For","more information regarding authorship of content, please consult the listed","source code repository logs.","## Declared Project Licenses","This program and the accompanying materials are made available under the terms","of the Eclipse Distribution License v. 1.0,","which is available at http://www.eclipse.org/org/documents/edl-v10.php.","SPDX-License-Identifier: BSD-3-Clause","## Source Code","The project maintains the following source code repositories:","* https://github.com/eclipse-ee4j/jaf","## Third-party Content","This project leverages the following third party content.","JUnit (4.12)","* License: Eclipse Public License","------------------------------------","Copyright notice present in the source code files","Copyright (c) 1997, 2021 Oracle and/or its affiliates. All rights reserved.","    This program and the accompanying materials are made available under the","    terms of the Eclipse Public License v. 2.0, which is available at","    http://www.eclipse.org/legal/epl-2.0.","    This Source Code may also be made available under the following Secondary","    Licenses when the conditions for such availability set forth in the","    Eclipse Public License v. 2.0 are satisfied: GNU General Public License,","    version 2 with the GNU Classpath Exception, which is available at","    https://www.gnu.org/software/classpath/license.html.","    SPDX-License-Identifier: EPL-2.0 OR GPL-2.0 WITH Classpath-exception-2.0","Jakarta Mail<br /> (Primavera P6 EPPM Licensing Information User Manual)","English\\licensing_information\\p6_eppm_licensing_information\\102352.htm");
Page[468]=new Array("Top Level Component : jcl-over-slf4j","----------------------------------------","Top Level Component License : Apache License","---------------------------------------------","Licensed under the Apache Software License, Version 2.0 (the &quot;License&quot;); you may not use this file except in compliance with the License.","Top Level Component Copyright:","-------------------------------","/*"," * Copyright 2001-2004 The Apache Software Foundation."," *"," * Licensed under the Apache License, Version 2.0 (the &quot;License&quot;);"," * you may not use this file except in compliance with the License."," * You may obtain a copy of the License at"," *"," *      http://www.apache.org/licenses/LICENSE-2.0"," *"," * Unless required by applicable law or agreed to in writing, software"," * distributed under the License is distributed on an &quot;AS IS&quot; BASIS,"," * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied."," * See the License for the specific language governing permissions and"," * limitations under the License."," */","=================================================================================================","4th Party Component #1	slf4j-api","--------------------------------------","4th Party Component #1	License : MIT","----------------------------------------","Copyright (c) 2004-2022 QOS.ch Sarl (Switzerland)","All rights reserved.","Permission is hereby granted, free  of charge, to any person obtaining","a  copy  of this  software  and  associated  documentation files  (the","&quot;Software&quot;), to  deal in  the Software without  restriction, including","without limitation  the rights to  use, copy, modify,  merge, publish,","distribute,  sublicense, and/or sell  copies of  the Software,  and to","permit persons to whom the Software  is furnished to do so, subject to","the following conditions:","The  above  copyright  notice  and  this permission  notice  shall  be","included in all copies or substantial portions of the Software.","THE  SOFTWARE IS  PROVIDED  &quot;AS  IS&quot;, WITHOUT  WARRANTY  OF ANY  KIND,","EXPRESS OR  IMPLIED, INCLUDING  BUT NOT LIMITED  TO THE  WARRANTIES OF","MERCHANTABILITY,    FITNESS    FOR    A   PARTICULAR    PURPOSE    AND","NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE","LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION","OF CONTRACT, TORT OR OTHERWISE,  ARISING FROM, OUT OF OR IN CONNECTION","WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.","jcl-over-slf4j<br /> (Primavera P6 EPPM Licensing Information User Manual)","English\\licensing_information\\p6_eppm_licensing_information\\101465.htm");
Page[469]=new Array("Copyright 2002-2019 JIDE Software Inc. All rights reserved.","JIDE Ultimate Suite<br /> (Primavera P6 EPPM Licensing Information User Manual)","English\\licensing_information\\p6_eppm_licensing_information\\100493.htm");
Page[470]=new Array("===================  ","Top-level Copyright notices","===================","Apache Kafka","Copyright 2022 The Apache Software Foundation.","This product includes software developed at","The Apache Software Foundation (https://www.apache.org/).","The streams-scala (streams/streams-scala) module was donated by Lightbend and the original code was copyrighted by them:","Copyright (C) 2018 Lightbend Inc. ","Copyright (C) 2017-2018 Alexis Seigneurin.","This project contains the following code copied from Apache Hadoop:","clients/src/main/java/org/apache/kafka/common/utils/PureJavaCrc32C.java","Some portions of this file Copyright (c) 2004-2006 Intel Corporation and licensed under the BSD license.","This project contains the following code copied from Apache Hive:","streams/src/main/java/org/apache/kafka/streams/state/internals/Murmur3.java","==============================","Public Licenses","==============================","Apache Kafka","Copyright 2018 The Apache Software Foundation.","                 ","                                   Apache License","                           Version 2.0, January 2004","                        http://www.apache.org/licenses/","Licensed under the Apache Software License, Version 2.0 (the &quot;License&quot;); you may not use this file except in compliance with the License.","------------------------------------------------------------------------------------------","The streams-scala (streams/streams-scala) module was donated by Lightbend and the original code was copyrighted by them:","Copyright (C) 2018 Lightbend Inc.","Copyright (C) 2017-2018 Alexis Seigneurin.","Licensed under the Apache License, Version 2.0","This project contains the following code copied from Apache Hadoop:","clients/src/main/java/org/apache/kafka/common/utils/PureJavaCrc32C.java","Licensed under the Apache License, Version 2.0","Some portions of this file Copyright (c) 2004-2006 Intel Corportation and licensed under the BSD license.","This project contains the following code copied from Apache Hive:","streams/src/main/java/org/apache/kafka/streams/state/internals/Murmur3.java","Copyright 2018 The Apache Software Foundation","Licensed under the Apache License, Version 2.0","Copyright Apache Software Foundation","Licensed under the Apache License, Version 2.0 (the &quot;License&quot;);","you may not use this file except in compliance with the License.","You may obtain a copy of the License at","http://www.apache.org/licenses/LICENSE-2.0","Unless required by applicable law or agreed to in writing, software","distributed under the License is distributed on an &quot;AS IS&quot; BASIS,","WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.","See the License for the specific language governing permissions and","limitations under the License.","------------------------------------------------------------------------------------------","------------------------------------------------------------------------------------------","4th party dependencies","------------------------------------------------------------------------------------------","com.github.luben:zstd-jni (BSD 2-Clause License)","Zstd-jni: JNI bindings to Zstd Library","Copyright (c) 2015-2016, Luben Karavelov/ All rights reserved.","BSD License","Redistribution and use in source and binary forms, with or without modification,","are permitted provided that the following conditions are met:","* Redistributions of source code must retain the above copyright notice, this","  list of conditions and the following disclaimer.","* Redistributions in binary form must reproduce the above copyright notice, this","  list of conditions and the following disclaimer in the documentation and/or","  other materials provided with the distribution.","THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS &quot;AS IS&quot; AND","ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED","WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE","DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT HOLDER OR CONTRIBUTORS BE LIABLE FOR","ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES","(INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;","LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON","ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT","(INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS","SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.","-----------------------------------------------------------------------------------------","zstd  library (BSD License or GPL-2.0)","# ################################################################","# Copyright (c) 2015-2021, Yann Collet, Facebook, Inc.","# All rights reserved.","#","# This source code is licensed under both the BSD-style license (found in the","# LICENSE file in the root directory of this source tree) and the GPLv2 (found","# in the COPYING file in the root directory of this source tree).","# You may select, at your option, one of the above-listed licenses.","# ################################################################","BSD License","For Zstandard software","Copyright (c) 2016-present, Facebook, Inc. All rights reserved.","Redistribution and use in source and binary forms, with or without modification,","are permitted provided that the following conditions are met:"," * Redistributions of source code must retain the above copyright notice, this","   list of conditions and the following disclaimer."," * Redistributions in binary form must reproduce the above copyright notice,","   this list of conditions and the following disclaimer in the documentation","   and/or other materials provided with the distribution."," * Neither the name Facebook nor the names of its contributors may be used to","   endorse or promote products derived from this software without specific","   prior written permission.","THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS &quot;AS IS&quot; AND","ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED","WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE","DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT HOLDER OR CONTRIBUTORS BE LIABLE FOR","ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES","(INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;","LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON","ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT","(INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS","SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.","                     GNU GENERAL PUBLIC LICENSE","                       Version 2, June 1991"," Copyright (C) 1989, 1991 Free Software Foundation, Inc.,"," 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA"," Everyone is permitted to copy and distribute verbatim copies"," of this license document, but changing it is not allowed.","                            Preamble","  The licenses for most software are designed to take away your","freedom to share and change it.  By contrast, the GNU General Public","License is intended to guarantee your freedom to share and change free","software--to make sure the software is free for all its users.  This","General Public License applies to most of the Free Software","Foundation's software and to any other program whose authors commit to","using it.  (Some other Free Software Foundation software is covered by","the GNU Lesser General Public License instead.)  You can apply it to","your programs, too.","  When we speak of free software, we are referring to freedom, not","price.  Our General Public Licenses are designed to make sure that you","have the freedom to distribute copies of free software (and charge for","this service if you wish), that you receive source code or can get it","if you want it, that you can change the software or use pieces of it","in new free programs; and that you know you can do these things.","  To protect your rights, we need to make restrictions that forbid","anyone to deny you these rights or to ask you to surrender the rights.","These restrictions translate to certain responsibilities for you if you","distribute copies of the software, or if you modify it.","  For example, if you distribute copies of such a program, whether","gratis or for a fee, you must give the recipients all the rights that","you have.  You must make sure that they, too, receive or can get the","source code.  And you must show them these terms so they know their","rights.","  We protect your rights with two steps: (1) copyright the software, and","(2) offer you this license which gives you legal permission to copy,","distribute and/or modify the software.","  Also, for each author's protection and ours, we want to make certain","that everyone understands that there is no warranty for this free","software.  If the software is modified by someone else and passed on, we","want its recipients to know that what they have is not the original, so","that any problems introduced by others will not reflect on the original","authors' reputations.","  Finally, any free program is threatened constantly by software","patents.  We wish to avoid the danger that redistributors of a free","program will individually obtain patent licenses, in effect making the","program proprietary.  To prevent this, we have made it clear that any","patent must be licensed for everyone's free use or not licensed at all.","  The precise terms and conditions for copying, distribution and","modification follow.","                    GNU GENERAL PUBLIC LICENSE","   TERMS AND CONDITIONS FOR COPYING, DISTRIBUTION AND MODIFICATION","  0. This License applies to any program or other work which contains","a notice placed by the copyright holder saying it may be distributed","under the terms of this General Public License.  The &quot;Program&quot;, below,","refers to any such program or work, and a &quot;work based on the Program&quot;","means either the Program or any derivative work under copyright law:","that is to say, a work containing the Program or a portion of it,","either verbatim or with modifications and/or translated into another","language.  (Hereinafter, translation is included without limitation in","the term &quot;modification&quot;.)  Each licensee is addressed as &quot;you&quot;.","Activities other than copying, distribution and modification are not","covered by this License; they are outside its scope.  The act of","running the Program is not restricted, and the output from the Program","is covered only if its contents constitute a work based on the","Program (independent of having been made by running the Program).","Whether that is true depends on what the Program does.","  1. You may copy and distribute verbatim copies of the Program's","source code as you receive it, in any medium, provided that you","conspicuously and appropriately publish on each copy an appropriate","copyright notice and disclaimer of warranty; keep intact all the","notices that refer to this License and to the absence of any warranty;","and give any other recipients of the Program a copy of this License","along with the Program.","You may charge a fee for the physical act of transferring a copy, and","you may at your option offer warranty protection in exchange for a fee.","  2. You may modify your copy or copies of the Program or any portion","of it, thus forming a work based on the Program, and copy and","distribute such modifications or work under the terms of Section 1","above, provided that you also meet all of these conditions:","    a) You must cause the modified files to carry prominent notices","    stating that you changed the files and the date of any change.","    b) You must cause any work that you distribute or publish, that in","    whole or in part contains or is derived from the Program or any","    part thereof, to be licensed as a whole at no charge to all third","    parties under the terms of this License.","    c) If the modified program normally reads commands interactively","    when run, you must cause it, when started running for such","    interactive use in the most ordinary way, to print or display an","    announcement including an appropriate copyright notice and a","    notice that there is no warranty (or else, saying that you provide","    a warranty) and that users may redistribute the program under","    these conditions, and telling the user how to view a copy of this","    License.  (Exception: if the Program itself is interactive but","    does not normally print such an announcement, your work based on","    the Program is not required to print an announcement.)","These requirements apply to the modified work as a whole.  If","identifiable sections of that work are not derived from the Program,","and can be reasonably considered independent and separate works in","themselves, then this License, and its terms, do not apply to those","sections when you distribute them as separate works.  But when you","distribute the same sections as part of a whole which is a work based","on the Program, the distribution of the whole must be on the terms of","this License, whose permissions for other licensees extend to the","entire whole, and thus to each and every part regardless of who wrote it.","Thus, it is not the intent of this section to claim rights or contest","your rights to work written entirely by you; rather, the intent is to","exercise the right to control the distribution of derivative or","collective works based on the Program.","In addition, mere aggregation of another work not based on the Program","with the Program (or with a work based on the Program) on a volume of","a storage or distribution medium does not bring the other work under","the scope of this License.","  3. You may copy and distribute the Program (or a work based on it,","under Section 2) in object code or executable form under the terms of","Sections 1 and 2 above provided that you also do one of the following:","    a) Accompany it with the complete corresponding machine-readable","    source code, which must be distributed under the terms of Sections","    1 and 2 above on a medium customarily used for software interchange; or,","    b) Accompany it with a written offer, valid for at least three","    years, to give any third party, for a charge no more than your","    cost of physically performing source distribution, a complete","    machine-readable copy of the corresponding source code, to be","    distributed under the terms of Sections 1 and 2 above on a medium","    customarily used for software interchange; or,","    c) Accompany it with the information you received as to the offer","    to distribute corresponding source code.  (This alternative is","    allowed only for noncommercial distribution and only if you","    received the program in object code or executable form with such","    an offer, in accord with Subsection b above.)","The source code for a work means the preferred form of the work for","making modifications to it.  For an executable work, complete source","code means all the source code for all modules it contains, plus any","associated interface definition files, plus the scripts used to","control compilation and installation of the executable.  However, as a","special exception, the source code distributed need not include","anything that is normally distributed (in either source or binary","form) with the major components (compiler, kernel, and so on) of the","operating system on which the executable runs, unless that component","itself accompanies the executable.","If distribution of executable or object code is made by offering","access to copy from a designated place, then offering equivalent","access to copy the source code from the same place counts as","distribution of the source code, even though third parties are not","compelled to copy the source along with the object code.","  4. You may not copy, modify, sublicense, or distribute the Program","except as expressly provided under this License.  Any attempt","otherwise to copy, modify, sublicense or distribute the Program is","void, and will automatically terminate your rights under this License.","However, parties who have received copies, or rights, from you under","this License will not have their licenses terminated so long as such","parties remain in full compliance.","  5. You are not required to accept this License, since you have not","signed it.  However, nothing else grants you permission to modify or","distribute the Program or its derivative works.  These actions are","prohibited by law if you do not accept this License.  Therefore, by","modifying or distributing the Program (or any work based on the","Program), you indicate your acceptance of this License to do so, and","all its terms and conditions for copying, distributing or modifying","the Program or works based on it.","  6. Each time you redistribute the Program (or any work based on the","Program), the recipient automatically receives a license from the","original licensor to copy, distribute or modify the Program subject to","these terms and conditions.  You may not impose any further","restrictions on the recipients' exercise of the rights granted herein.","You are not responsible for enforcing compliance by third parties to","this License.","  7. If, as a consequence of a court judgment or allegation of patent","infringement or for any other reason (not limited to patent issues),","conditions are imposed on you (whether by court order, agreement or","otherwise) that contradict the conditions of this License, they do not","excuse you from the conditions of this License.  If you cannot","distribute so as to satisfy simultaneously your obligations under this","License and any other pertinent obligations, then as a consequence you","may not distribute the Program at all.  For example, if a patent","license would not permit royalty-free redistribution of the Program by","all those who receive copies directly or indirectly through you, then","the only way you could satisfy both it and this License would be to","refrain entirely from distribution of the Program.","If any portion of this section is held invalid or unenforceable under","any particular circumstance, the balance of the section is intended to","apply and the section as a whole is intended to apply in other","circumstances.","It is not the purpose of this section to induce you to infringe any","patents or other property right claims or to contest validity of any","such claims; this section has the sole purpose of protecting the","integrity of the free software distribution system, which is","implemented by public license practices.  Many people have made","generous contributions to the wide range of software distributed","through that system in reliance on consistent application of that","system; it is up to the author/donor to decide if he or she is willing","to distribute software through any other system and a licensee cannot","impose that choice.","This section is intended to make thoroughly clear what is believed to","be a consequence of the rest of this License.","  8. If the distribution and/or use of the Program is restricted in","certain countries either by patents or by copyrighted interfaces, the","original copyright holder who places the Program under this License","may add an explicit geographical distribution limitation excluding","those countries, so that distribution is permitted only in or among","countries not thus excluded.  In such case, this License incorporates","the limitation as if written in the body of this License.","  9. The Free Software Foundation may publish revised and/or new versions","of the General Public License from time to time.  Such new versions will","be similar in spirit to the present version, but may differ in detail to","address new problems or concerns.","Each version is given a distinguishing version number.  If the Program","specifies a version number of this License which applies to it and &quot;any","later version&quot;, you have the option of following the terms and conditions","either of that version or of any later version published by the Free","Software Foundation.  If the Program does not specify a version number of","this License, you may choose any version ever published by the Free Software","Foundation.","  10. If you wish to incorporate parts of the Program into other free","programs whose distribution conditions are different, write to the author","to ask for permission.  For software which is copyrighted by the Free","Software Foundation, write to the Free Software Foundation; we sometimes","make exceptions for this.  Our decision will be guided by the two goals","of preserving the free status of all derivatives of our free software and","of promoting the sharing and reuse of software generally.","                            NO WARRANTY","  11. BECAUSE THE PROGRAM IS LICENSED FREE OF CHARGE, THERE IS NO WARRANTY","FOR THE PROGRAM, TO THE EXTENT PERMITTED BY APPLICABLE LAW.  EXCEPT WHEN","OTHERWISE STATED IN WRITING THE COPYRIGHT HOLDERS AND/OR OTHER PARTIES","PROVIDE THE PROGRAM &quot;AS IS&quot; WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED","OR IMPLIED, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF","MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE.  THE ENTIRE RISK AS","TO THE QUALITY AND PERFORMANCE OF THE PROGRAM IS WITH YOU.  SHOULD THE","PROGRAM PROVE DEFECTIVE, YOU ASSUME THE COST OF ALL NECESSARY SERVICING,","REPAIR OR CORRECTION.","  12. IN NO EVENT UNLESS REQUIRED BY APPLICABLE LAW OR AGREED TO IN WRITING","WILL ANY COPYRIGHT HOLDER, OR ANY OTHER PARTY WHO MAY MODIFY AND/OR","REDISTRIBUTE THE PROGRAM AS PERMITTED ABOVE, BE LIABLE TO YOU FOR DAMAGES,","INCLUDING ANY GENERAL, SPECIAL, INCIDENTAL OR CONSEQUENTIAL DAMAGES ARISING","OUT OF THE USE OR INABILITY TO USE THE PROGRAM (INCLUDING BUT NOT LIMITED","TO LOSS OF DATA OR DATA BEING RENDERED INACCURATE OR LOSSES SUSTAINED BY","YOU OR THIRD PARTIES OR A FAILURE OF THE PROGRAM TO OPERATE WITH ANY OTHER","PROGRAMS), EVEN IF SUCH HOLDER OR OTHER PARTY HAS BEEN ADVISED OF THE","POSSIBILITY OF SUCH DAMAGES.","                     END OF TERMS AND CONDITIONS","            How to Apply These Terms to Your New Programs","  If you develop a new program, and you want it to be of the greatest","possible use to the public, the best way to achieve this is to make it","free software which everyone can redistribute and change under these terms.","  To do so, attach the following notices to the program.  It is safest","to attach them to the start of each source file to most effectively","convey the exclusion of warranty; and each file should have at least","the &quot;copyright&quot; line and a pointer to where the full notice is found.","    &lt;one line to give the program's name and a brief idea of what it does.&gt;","    Copyright (C) &lt;year&gt;  &lt;name of author&gt;","    This program is free software; you can redistribute it and/or modify","    it under the terms of the GNU General Public License as published by","    the Free Software Foundation; either version 2 of the License, or","    (at your option) any later version.","    This program is distributed in the hope that it will be useful,","    but WITHOUT ANY WARRANTY; without even the implied warranty of","    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the","    GNU General Public License for more details.","    You should have received a copy of the GNU General Public License along","    with this program; if not, write to the Free Software Foundation, Inc.,","    51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA.","Also add information on how to contact you by electronic and paper mail.","If the program is interactive, make it output a short notice like this","when it starts in an interactive mode:","    Gnomovision version 69, Copyright (C) year name of author","    Gnomovision comes with ABSOLUTELY NO WARRANTY; for details type `show w'.","    This is free software, and you are welcome to redistribute it","    under certain conditions; type `show c' for details.","The hypothetical commands `show w' and `show c' should show the appropriate","parts of the General Public License.  Of course, the commands you use may","be called something other than `show w' and `show c'; they could even be","mouse-clicks or menu items--whatever suits your program.","You should also get your employer (if you work as a programmer) or your","school, if any, to sign a &quot;copyright disclaimer&quot; for the program, if","necessary.  Here is a sample; alter the names:","  Yoyodyne, Inc., hereby disclaims all copyright interest in the program","  `Gnomovision' (which makes passes at compilers) written by James Hacker.","  &lt;signature of Ty Coon&gt;, 1 April 1989","  Ty Coon, President of Vice","This General Public License does not permit incorporating your program into","proprietary programs.  If your program is a subroutine library, you may","consider it more useful to permit linking proprietary applications with the","library.  If this is what you want to do, use the GNU Lesser General","Public License instead of this License.","------------------------------------------------------------------------------------------","org.lz4:lz4-java (Apache 2.0)","Copyright 2020 Adrien Grand and the lz4-java contributors.","Copyright 2020 Linnaea Von Lavia and the lz4-java contributors.","Copyright 2020 Rei Odaira and the lz4-java contributors.","LZ4 Library","Copyright (c) 2011-2016, Yann Collet","All rights reserved.","Redistribution and use in source and binary forms, with or without modification,","are permitted provided that the following conditions are met:","* Redistributions of source code must retain the above copyright notice, this","  list of conditions and the following disclaimer.","* Redistributions in binary form must reproduce the above copyright notice, this","  list of conditions and the following disclaimer in the documentation and/or","  other materials provided with the distribution.","THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS &quot;AS IS&quot; AND","ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED","WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE","DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT HOLDER OR CONTRIBUTORS BE LIABLE FOR","ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES","(INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;","LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON","ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT","(INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS","SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.","------------------------------------------------------------------------------------------","org.xerial.snappy:snappy-java (Apache 2.0)","  Copyright 2008,2011 Taro L. Saito","This product includes software developed by Google"," Snappy: http://code.google.com/p/snappy/ (New BSD License)","Copyright 2011, Google Inc.","All rights reserved.","Redistribution and use in source and binary forms, with or without","modification, are permitted provided that the following conditions are","met:","    * Redistributions of source code must retain the above copyright","notice, this list of conditions and the following disclaimer.","    * Redistributions in binary form must reproduce the above","copyright notice, this list of conditions and the following disclaimer","in the documentation and/or other materials provided with the","distribution.","    * Neither the name of Google Inc. nor the names of its","contributors may be used to endorse or promote products derived from","this software without specific prior written permission.","THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS","&quot;AS IS&quot; AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT","LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR","A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT","OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,","SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT","LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,","DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY","THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT","(INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE","OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.","------------------------------------------------------------------------------------------","This product includes software developed by Apache"," PureJavaCrc32C from apache-hadoop-common http://hadoop.apache.org/"," (Apache 2.0 license)","This library containd statically linked libstdc++. This inclusion is allowed by ","&quot;GCC RUntime Library Exception&quot; ","http://gcc.gnu.org/onlinedocs/libstdc++/manual/license.html","== Contributors ==","  * Tatu Saloranta  ","    * Providing benchmark suite","  * Alec Wysoker","    * Performance and memory usage improvement","------------------------------------------------------------------------------------------","org.slf4j:slf4j-api (MIT)","Copyright (c) 2004-2017 QOS.ch","All rights reserved.","Permission is hereby granted, free  of charge, to any person obtaining","a  copy  of this  software  and  associated  documentation files  (the","&quot;Software&quot;), to  deal in  the Software without  restriction, including","without limitation  the rights to  use, copy, modify,  merge, publish,","distribute,  sublicense, and/or sell  copies of  the Software,  and to","permit persons to whom the Software  is furnished to do so, subject to","the following conditions:","The  above  copyright  notice  and  this permission  notice  shall  be","included in all copies or substantial portions of the Software.","THE  SOFTWARE IS  PROVIDED  &quot;AS  IS&quot;, WITHOUT  WARRANTY  OF ANY  KIND,","EXPRESS OR  IMPLIED, INCLUDING  BUT NOT LIMITED  TO THE  WARRANTIES OF","MERCHANTABILITY,    FITNESS    FOR    A   PARTICULAR    PURPOSE    AND","NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE","LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION","OF CONTRACT, TORT OR OTHERWISE,  ARISING FROM, OUT OF OR IN CONNECTION","WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.","---------------------------------------------------------------------","kafka-clients<br /> (Primavera P6 EPPM Licensing Information User Manual)","English\\licensing_information\\p6_eppm_licensing_information\\102597.htm");
Page[471]=new Array("org.apache.logging.log4j log4j-api","COPYRIGHT:","Apache Log4j","Copyright 1999-2021 Apache Software Foundation","This product includes software developed at","The Apache Software Foundation (http://www.apache.org/).","ResolverUtil.java","Copyright 2005-2006 Tim Fennell","Dumbster SMTP test server","Copyright 2004 Jason Paul Kitchen","TypeUtil.java","Copyright 2002-2012 Ramnivas Laddad, Juergen Hoeller, Chris Beams","picocli (http://picocli.info)","Copyright 2017 Remko Popma","Licensed under the Apache Software License, Version 2.0 (the &quot;License&quot;); you may not use this file except in compliance with the License.","log4j-api<br /> (Primavera P6 EPPM Licensing Information User Manual)","English\\licensing_information\\p6_eppm_licensing_information\\101186.htm");
Page[472]=new Array("Top Level Component Name : log4j-1.2-api  ","Dependency Component Name : org.apache.logging.log4j  log4j-api ","Top Level Component License and Dependency Component License:","Apache License","Licensed under the Apache Software License, Version 2.0 (the &quot;License&quot;); you may not use this file except in compliance with the License.","Top Level Component and dependency Copyright:","Apache Log4j","Copyright 1999-2021 Apache Software Foundation","This product includes software developed at","The Apache Software Foundation (http://www.apache.org/).","ResolverUtil.java","Copyright 2005-2006 Tim Fennell","Dumbster SMTP test server","Copyright 2004 Jason Paul Kitchen","TypeUtil.java","Copyright 2002-2012 Ramnivas Laddad, Juergen Hoeller, Chris Beams","picocli (http://picocli.info)","Copyright 2017 Remko Popma","--------------------------- Fourth Party dependencies ---------------------------","Dependency: org.apache.logging.log4j:log4j-api:","log4j-1.2-api<br /> (Primavera P6 EPPM Licensing Information User Manual)","English\\licensing_information\\p6_eppm_licensing_information\\101187.htm");
Page[473]=new Array("Top Level Component Name : log4j-1.2-api  ","Dependency Component Name : org.apache.logging.log4j  log4j-api ","Top Level Component License and Dependency Component License:","Apache License","Licensed under the Apache Software License, Version 2.0 (the &quot;License&quot;); you may not use this file except in compliance with the License.","Top Level Component and dependency Copyright:","Apache Log4j","Copyright 1999-2023 Apache Software Foundation","This product includes software developed at","The Apache Software Foundation (http://www.apache.org/).","ResolverUtil.java","Copyright 2005-2006 Tim Fennell","Dumbster SMTP test server","Copyright 2004 Jason Paul Kitchen","TypeUtil.java","Copyright 2002-2012 Ramnivas Laddad, Juergen Hoeller, Chris Beams","picocli (http://picocli.info)","Copyright 2017 Remko Popma","Apache Log4j","Copyright 1999-2021 Apache Software Foundation","This product includes software developed at","The Apache Software Foundation (http://www.apache.org/).","ResolverUtil.java","Copyright 2005-2006 Tim Fennell","Dumbster SMTP test server","Copyright 2004 Jason Paul Kitchen","TypeUtil.java","Copyright 2002-2012 Ramnivas Laddad, Juergen Hoeller, Chris Beams","picocli (http://picocli.info)","Copyright 2017 Remko Popma","TimeoutBlockingWaitStrategy.java and parts of Util.java","Copyright 2011 LMAX Ltd.","--------------------------- Fourth Party dependencies ---------------------------","Dependency: org.apache.logging.log4j:log4j-api","log4j-1.2-api<br /> (Primavera P6 EPPM Licensing Information User Manual)","English\\licensing_information\\p6_eppm_licensing_information\\102566.htm");
Page[474]=new Array("--------NOTICE---------------","Licensed under the Apache License, Version 2.0 (the &quot;License&quot;);","you may not use this file except in compliance with the License.","You may obtain a copy of the License at","    http://www.apache.org/licenses/LICENSE-2.0","Unless required by applicable law or agreed to in writing, software","distributed under the License is distributed on an &quot;AS IS&quot; BASIS,","WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.","See the License for the specific language governing permissions and","limitations under the License.","------------------------------------------LICENSE--------------------------------------------------","Apache POI release 4.1.2 is available under the Apache License, Version 2.0.","All the release artifacts that constitute POI are available under the same","Apache License 2.0, with the following exceptions:","Curves API 1.06: BSD-3-Clause license","========","This is the list of third party artifacts in the distribution and their","license terms","Dependency			License","==========			=======","curvesapi-1.06.jar		BSD-3-Clause license","xmlbeans-3.1.0.jar		Apache 2.0","poi-examples-4.1.2.jar		Apache 2.0","poi-excelant-4.1.2.jar		Apache 2.0","poi-ooxml-schemas-4.1.2.jar	Apache 2.0","poi-ooxml-4.1.2.jar		Apache 2.0","poi-scratchpad-4.1.2.jar	Apache 2.0","commons-codec-1.13.jar		Apache 2.0","commons-collections4-4.4.jar	Apache 2.0","commons-compress-1.19.jar	Apache 2.0","commons-logging-1.2.jar		Apache 2.0","commons-math3-3.6.1.jar		Apache 2.0","log4j-2.9.1 jars		Apache 2.0","SparseBitSet-1.2.jar		Apache 2.0	","	","=========","We go over the copyright notices of the artifacts in this document.","But first, we go over the details of the 4 licences governing the above","artifacts.","========","This is the text of the Apache 2.0 license:","Licensed under the Apache Software License, Version 2.0 (the &quot;License&quot;); you may not use this file except in compliance with the License.","====================================================================","For curvesapi","This is the text of the BSD-3-Clause License","Redistribution and use in source and binary forms, with or without modification, are permitted provided that the following conditions are met:","1. Redistributions of source code must retain the above copyright notice, this list of conditions and the following disclaimer.","2. Redistributions in binary form must reproduce the above copyright notice, this list of conditions and the following disclaimer in the documentation and/or other materials provided with the distribution.","3. Neither the name of the copyright holder nor the names of its contributors may be used to endorse or promote products derived from this software without specific prior written permission.","THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS &quot;AS IS&quot; AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT HOLDER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.","Copyright (c) 2005, Graph Builder","All rights reserved.","Redistribution and use in source and binary forms, with or without","modification, are permitted provided that the following conditions","are met:","-Redistributions of source code must retain the above copyright notice,","this list of conditions and the following disclaimer.","-Redistributions in binary form must reproduce the above copyright notice,","this list of conditions and the following disclaimer in the documentation","and/or other materials provided with the distribution.","-Neither the name of Graph Builder nor the names of its contributors may be","used to endorse or promote products derived from this software without","specific prior written permission.","THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS &quot;AS IS&quot;","AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE","IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE","DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE LIABLE","FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL","DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR","SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER","CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,","OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE","OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.","==============","Now we go over the copyright notices of each artifact in the POI 4.1.2 release","distribution.","POI (the main artifact)","poi-4.1.2.jar","Apache POI","Copyright 2003-2019 The Apache Software Foundation","This product includes software developed at","The Apache Software Foundation (https://www.apache.org/).","This product contains parts that were originally based on software from BEA.","Copyright (c) 2000-2003, BEA Systems,  (dead link),","which was acquired by Oracle Corporation in 2008.","This product contains W3C XML Schema documents. Copyright 2001-2003 (c)","World Wide Web Consortium (Massachusetts Institute of Technology, European","Research Consortium for Informatics and Mathematics, Keio University)","This product contains the chunks_parse_cmds.tbl file from the vsdump program.","Copyright (C) 2006-2007 Valek Filippov (frob@df.ru)","This product contains parts of the eID Applet project "," and .","Copyright (c) 2009-2014","FedICT (federal ICT department of Belgium), e-Contract.be BVBA (https://www.e-contract.be),","Bart Hanssens from FedICT","=====","ExcelAnt - Ant Tasks for Validating Excel Spreadsheets","poi-excelant-4.1.2.jar","Apache POI","Copyright 2003-2019 The Apache Software Foundation","This product includes software developed at","The Apache Software Foundation (https://www.apache.org/).","This product contains parts that were originally based on software from BEA.","Copyright (c) 2000-2003, BEA Systems,  (dead link),","which was acquired by Oracle Corporation in 2008.","This product contains W3C XML Schema documents. Copyright 2001-2003 (c)","World Wide Web Consortium (Massachusetts Institute of Technology, European","Research Consortium for Informatics and Mathematics, Keio University)","This product contains the chunks_parse_cmds.tbl file from the vsdump program.","Copyright (C) 2006-2007 Valek Filippov (frob@df.ru)","This product contains parts of the eID Applet project "," and .","Copyright (c) 2009-2014","FedICT (federal ICT department of Belgium), e-Contract.be BVBA (https://www.e-contract.be),","Bart Hanssens from FedICT","=====","============","poi-ooxml-schemas-4.1.2.jar","Required dependency of ooxml-4.1.2.jar","Apache POI","Copyright 2003-2019 The Apache Software Foundation","This product includes software developed at","The Apache Software Foundation (https://www.apache.org/).","This product contains parts that were originally based on software from BEA.","Copyright (c) 2000-2003, BEA Systems,  (dead link),","which was acquired by Oracle Corporation in 2008.","This product contains W3C XML Schema documents. Copyright 2001-2003 (c)","World Wide Web Consortium (Massachusetts Institute of Technology, European","Research Consortium for Informatics and Mathematics, Keio University)","This product contains the chunks_parse_cmds.tbl file from the vsdump program.","Copyright (C) 2006-2007 Valek Filippov (frob@df.ru)","This product contains parts of the eID Applet project "," and .","Copyright (c) 2009-2014","FedICT (federal ICT department of Belgium), e-Contract.be BVBA (https://www.e-contract.be),","Bart Hanssens from FedICT","========","A required dependency of POI.","poi-scratchpad-4.1.2.jar","Apache POI","Copyright 2003-2019 The Apache Software Foundation","This product includes software developed at","The Apache Software Foundation (https://www.apache.org/).","This product contains parts that were originally based on software from BEA.","Copyright (c) 2000-2003, BEA Systems,  (dead link),","which was acquired by Oracle Corporation in 2008.","This product contains W3C XML Schema documents. Copyright 2001-2003 (c)","World Wide Web Consortium (Massachusetts Institute of Technology, European","Research Consortium for Informatics and Mathematics, Keio University)","This product contains the chunks_parse_cmds.tbl file from the vsdump program.","Copyright (C) 2006-2007 Valek Filippov (frob@df.ru)","This product contains parts of the eID Applet project "," and .","Copyright (c) 2009-2014","FedICT (federal ICT department of Belgium), e-Contract.be BVBA (https://www.e-contract.be),","Bart Hanssens from FedICT","========","Example programs that use the POI API","poi-examples-4.1.2.jar","Apache POI","Copyright 2003-2019 The Apache Software Foundation","This product includes software developed at","The Apache Software Foundation (https://www.apache.org/).","This product contains parts that were originally based on software from BEA.","Copyright (c) 2000-2003, BEA Systems,  (dead link),","which was acquired by Oracle Corporation in 2008.","This product contains W3C XML Schema documents. Copyright 2001-2003 (c)","World Wide Web Consortium (Massachusetts Institute of Technology, European","Research Consortium for Informatics and Mathematics, Keio University)","This product contains the chunks_parse_cmds.tbl file from the vsdump program.","Copyright (C) 2006-2007 Valek Filippov (frob@df.ru)","This product contains parts of the eID Applet project "," and .","Copyright (c) 2009-2014","FedICT (federal ICT department of Belgium), e-Contract.be BVBA (https://www.e-contract.be),","Bart Hanssens from FedICT","========","XML Beans 3.1.0","This is used by POI to convert from Java object to XML and back.","   =========================================================================","   ==  NOTICE file corresponding to section 4(d) of the Apache License,   ==","   ==  Version 2.0, in this case for the Apache XmlBeans distribution.    ==","   =========================================================================","   This product includes software developed at","   The Apache Software Foundation (http://www.apache.org/).","   Portions of this software were originally based on the following:","     - software copyright (c) 2000-2003, BEA Systems, .","   Aside from contributions to the Apache XMLBeans project, this","   software also includes:","    - one or more source files from the Apache Xerces-J and Apache Axis","      products, Copyright (c) 1999-2003 Apache Software Foundation","    - W3C XML Schema documents Copyright 2001-2003 (c) World Wide Web","      Consortium (Massachusetts Institute of Technology, European Research","      Consortium for Informatics and Mathematics, Keio University)","    - resolver.jar from Apache Xml Commons project,","      Copyright (c) 2001-2003 Apache Software Foundation","===========","Apache Commons Codec 1.13","Apache Commons Codec","Copyright 2002-2019 The Apache Software Foundation","This product includes software developed at","The Apache Software Foundation (https://www.apache.org/).","src/test/org/apache/commons/codec/language/DoubleMetaphoneTest.java","contains test data from http://aspell.net/test/orig/batch0.tab.","Copyright (C) 2002 Kevin Atkinson (kevina@gnu.org)","===============================================================================","The content of package org.apache.commons.codec.language.bm has been translated","from the original php source code available at http://stevemorse.org/phoneticinfo.htm","with permission from the original authors.","Original source copyright:","Copyright (c) 2008 Alexander Beider &amp; Stephen P. Morse.","========","Apache Commons Collections4 4.4","Apache Commons Collections","Copyright 2001-2019 The Apache Software Foundation","This product includes software developed at","The Apache Software Foundation (http://www.apache.org/).","========","Apache Commons Compress 1.19","commons-compress-1.19.jar","Apache Commons Compress","Copyright 2002-2019 The Apache Software Foundation","This product includes software developed at","The Apache Software Foundation (https://www.apache.org/).","The files in the package org.apache.commons.compress.archivers.sevenz","were derived from the LZMA SDK, version 9.20 (C/ and CPP/7zip/),","which has been placed in the public domain:","&quot;LZMA SDK is placed in the public domain.&quot; (http://www.7-zip.org/sdk.html)","========","Commons Logging 1.2","commons-logging-1.2.jar","Apache Commons Logging","Copyright 2003-2014 The Apache Software Foundation","This product includes software developed at","The Apache Software Foundation (http://www.apache.org/).","========","Commons Math 3.6.1","commons-math3-3.6.1.jar","Apache Commons Math","Copyright 2001-2016 The Apache Software Foundation","This product includes software developed at","The Apache Software Foundation (http://www.apache.org/).","This product includes software developed for Orekit by","CS Systmes d'Information (http://www.c-s.fr/)","Copyright 2010-2012 CS Systmes d'Information","========","Log4j 2.9.1","There are multiple jars: log4j-api, log4j-core, log4j-web, etc.","The stated dependency version of log4j 1.2 is not acceptable for distribution,","due to known vulnerabilities.","Apache Log4j API","Copyright 1999-2017 The Apache Software Foundation","This product includes software developed at","The Apache Software Foundation (http://www.apache.org/).","========","SparseBitSet 1.2","This software is the work of Paladin Software International, Incorporated,","based upon previous work done for and by Sun Microsystems, Inc. ","========","POI<br /> (Primavera P6 EPPM Licensing Information User Manual)","English\\licensing_information\\p6_eppm_licensing_information\\100755.htm");
Page[475]=new Array("The Sentry Spelling-Checker Engine Copyright  1994-2003 Wintertree Software Inc.","Sentry Spelling Checker<br /> (Primavera P6 EPPM Licensing Information User Manual)","English\\licensing_information\\p6_eppm_licensing_information\\100450.htm");
Page[476]=new Array("Copyright (c) 2004-2023 QOS.ch"," All rights reserved."," Permission is hereby granted, free  of charge, to any person obtaining"," a  copy  of this  software  and  associated  documentation files  (the"," &quot;Software&quot;), to  deal in  the Software without  restriction, including"," without limitation  the rights to  use, copy, modify,  merge, publish,"," distribute,  sublicense, and/or sell  copies of  the Software,  and to"," permit persons to whom the Software  is furnished to do so, subject to"," the following conditions:"," "," The  above  copyright  notice  and  this permission  notice  shall  be"," included in all copies or substantial portions of the Software."," "," THE  SOFTWARE IS  PROVIDED  &quot;AS  IS&quot;, WITHOUT  WARRANTY  OF ANY  KIND,"," EXPRESS OR  IMPLIED, INCLUDING  BUT NOT LIMITED  TO THE  WARRANTIES OF"," MERCHANTABILITY,    FITNESS    FOR    A   PARTICULAR    PURPOSE    AND"," NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE"," LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION"," OF CONTRACT, TORT OR OTHERWISE,  ARISING FROM, OUT OF OR IN CONNECTION"," WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.","slf4j-api<br /> (Primavera P6 EPPM Licensing Information User Manual)","English\\licensing_information\\p6_eppm_licensing_information\\101466.htm");
Page[477]=new Array("Copyright (c) 2004-2017 QOS.ch"," All rights reserved."," Permission is hereby granted, free  of charge, to any person obtaining"," a  copy  of this  software  and  associated  documentation files  (the"," &quot;Software&quot;), to  deal in  the Software without  restriction, including"," without limitation  the rights to  use, copy, modify,  merge, publish,"," distribute,  sublicense, and/or sell  copies of  the Software,  and to"," permit persons to whom the Software  is furnished to do so, subject to"," the following conditions:"," "," The  above  copyright  notice  and  this permission  notice  shall  be"," included in all copies or substantial portions of the Software."," "," THE  SOFTWARE IS  PROVIDED  &quot;AS  IS&quot;, WITHOUT  WARRANTY  OF ANY  KIND,"," EXPRESS OR  IMPLIED, INCLUDING  BUT NOT LIMITED  TO THE  WARRANTIES OF"," MERCHANTABILITY,    FITNESS    FOR    A   PARTICULAR    PURPOSE    AND"," NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE"," LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION"," OF CONTRACT, TORT OR OTHERWISE,  ARISING FROM, OUT OF OR IN CONNECTION"," WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.","Fourth Party Dependency :","No fourth party dependency","Apache log4j","Copyright 2010 The Apache Software Foundation","This product includes software developed at","The Apache Software Foundation (http://www.apache.org/).","Licensed under the Apache Software License, Version 2.0 (the &quot;License&quot;); you may not use this file except in compliance with the License.","slf4j-log4j12<br /> (Primavera P6 EPPM Licensing Information User Manual)","English\\licensing_information\\p6_eppm_licensing_information\\101575.htm");
Page[478]=new Array("------------------------------- Top-level license --------------------------  ",".",".",".","------------------------------- Copyright notices --------------------------","                                 Apache License","                           Version 2.0, January 2004","                        http://www.apache.org/licenses/","Licensed under the Apache Software License, Version 2.0 (the &quot;License&quot;); you may not use this file except in compliance with the License.","=======================================================================","--------------------------------------------------------------------------","Copyright (c) 2010 John Resig, http://jquery.com/","Permission is hereby granted, free of charge, to any person obtaining","a copy of this software and associated documentation files (the","&quot;Software&quot;), to deal in the Software without restriction, including","without limitation the rights to use, copy, modify, merge, publish,","distribute, sublicense, and/or sell copies of the Software, and to","permit persons to whom the Software is furnished to do so, subject to","the following conditions:","The above copyright notice and this permission notice shall be","included in all copies or substantial portions of the Software.","THE SOFTWARE IS PROVIDED &quot;AS IS&quot;, WITHOUT WARRANTY OF ANY KIND,","EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF","MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND","NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE","LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION","OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION","WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.","======================================================================","a copy of Ola Bini's work which he released into the Public Domain on his","blog in 2006: https://olabini.se/blog/2006/10/openssl-in-jruby/","---------------------------- Fourth-party information ----------------------","This product includes following software ","Apache Zookeeper","Apache commons","Apache HTTP Components","Apache http2-client","Apache http2-common","Apache http2-hpack ","Apache http2-http-client-transport"," jetty-alpn-client-9.4.44.v20210927.jar"," jetty-alpn-java-client-9.4.44.v20210927.jar"," jetty-client-9.4.44.v20210927.jar"," jetty-http-9.4.44.v20210927.jar"," jetty-io-9.4.44.v20210927.jar"," jetty-util-9.4.44.v20210927.jar"," netty-buffer-4.1.68.Final.jar"," netty-codec-4.1.68.Final.jar"," netty-common-4.1.68.Final.jar"," netty-handler-4.1.68.Final.jar"," netty-resolver-4.1.68.Final.jar"," netty-transport-4.1.68.Final.jar"," netty-transport-native-epoll-4.1.68.Final.jar"," netty-transport-native-unix-common-4.1.68.Final.jar"," snappy-java-1.1.7.6.jar"," stax2-api-4.2.1.jar"," woodstox-core-6.2.4.jar","Copyright 2011 The Apache Software Foundation","with license :","                                 Apache License","                           Version 2.0, January 2004","                        http://www.apache.org/licenses/","Licensed under the Apache Software License, Version 2.0 (the &quot;License&quot;); you may not use this file except in compliance with the License.","   ","======================================================================","Copyright (c) 2004-2008 QOS.ch","All rights reserved.","MIT License","Permission is hereby granted, free  of charge, to any person obtaining","a  copy  of this  software  and  associated  documentation files  (the","&quot;Software&quot;), to  deal in  the Software without  restriction, including","without limitation  the rights to  use, copy, modify,  merge, publish,","distribute,  sublicense, and/or sell  copies of  the Software,  and to","permit persons to whom the Software  is furnished to do so, subject to","the following conditions:","The  above  copyright  notice  and  this permission  notice  shall  be","included in all copies or substantial portions of the Software.","THE  SOFTWARE IS  PROVIDED  &quot;AS  IS&quot;, WITHOUT  WARRANTY  OF ANY  KIND,","EXPRESS OR  IMPLIED, INCLUDING  BUT NOT LIMITED  TO THE  WARRANTIES OF","MERCHANTABILITY,    FITNESS    FOR    A   PARTICULAR    PURPOSE    AND","NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE","LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION","OF CONTRACT, TORT OR OTHERWISE,  ARISING FROM, OUT OF OR IN CONNECTION","WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.","-----------------------------------------------------------------","Solr-solrj<br /> (Primavera P6 EPPM Licensing Information User Manual)","English\\licensing_information\\p6_eppm_licensing_information\\102598.htm");
Page[479]=new Array("Licensed under the Apache Software License, Version 2.0 (the &quot;License&quot;); you may not use this file except in compliance with the License.","=======================================================================","SPRING FRAMEWORK ${version} SUBCOMPONENTS:","Spring Framework ${version} includes a number of subcomponents","with separate copyright notices and license terms. The product that","includes this file does not necessarily use all the open source","subcomponents referred to below. Your use of the source","code for these subcomponents is subject to the terms and","conditions of the following licenses.","&gt;&gt;&gt; org.ow2.asm:asm, org.ow2.asm:asm-commons:","Copyright (c) 2000-2011 INRIA, France Telecom","All rights reserved.","Redistribution and use in source and binary forms, with or without","modification, are permitted provided that the following conditions","are met:","1. Redistributions of source code must retain the above copyright","   notice, this list of conditions and the following disclaimer.","2. Redistributions in binary form must reproduce the above copyright","   notice, this list of conditions and the following disclaimer in the","   documentation and/or other materials provided with the distribution.","3. Neither the name of the copyright holders nor the names of its","   contributors may be used to endorse or promote products derived from","   this software without specific prior written permission.","THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS &quot;AS IS&quot;","AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE","IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE","ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE","LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR","CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF","SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS","INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN","CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)","ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF","THE POSSIBILITY OF SUCH DAMAGE.","Copyright (c) 1999-2009, OW2 Consortium ","&gt;&gt;&gt; cglib:cglib:","CGLIB is licensed under the Apache License, version 2.0, the text of which","is included above.","&gt;&gt;&gt; org.objenesis:objenesis:","Per the LICENSE file in the Objenesis ZIP distribution downloaded from","http://objenesis.org/download.html, Objenesis is licensed under the","Apache License, version 2.0, the text of which is included above.","Per the NOTICE file in the Objenesis ZIP distribution downloaded from","http://objenesis.org/download.html and corresponding to section 4d of the","Apache License, Version 2.0, in this case for Objenesis:","Objenesis","Copyright 2006-2019 Joe Walnes, Henri Tremblay, Leonardo Mesquita","===============================================================================","To the extent any open source components are licensed under the EPL and/or","other similar licenses that require the source code and/or modifications to","source code to be made available (as would be noted above), you may obtain a","copy of the source code corresponding to the binaries for such open source","components and modifications thereto, if any, (the &quot;Source Files&quot;), by","downloading the Source Files from https://spring.io/projects, Pivotal's website","at https://network.pivotal.io/open-source, or by sending a request, with your","name and address to: Pivotal Software, Inc., 875 Howard Street, 5th floor, San","Francisco, CA 94103, Attention: General Counsel. All such requests should","clearly specify: OPEN SOURCE FILES REQUEST, Attention General Counsel. Pivotal","can mail a copy of the Source Files to you on a CD or equivalent physical","medium.","This offer to obtain a copy of the Source Files is valid for three years from","the date you acquired this Software product. Alternatively, the Source Files","may accompany the Software.","--------------------------","Spring Framework ${version}","Copyright (c) 2002-${copyright} Pivotal, Inc.","This product is licensed to you under the Apache License, Version 2.0","(the &quot;License&quot;). You may not use this product except in compliance with","the License.","This product may include a number of subcomponents with separate","copyright notices and license terms. Your use of the source code for","these subcomponents is subject to the terms and conditions of the","subcomponent's license, as noted in the license.txt file.","=====================================================================","Recursive fourth party dependency:","==============================================","1. org.springframework  spring-beans","A) org.springframework  spring-core ","a) org.springframework  spring-jcl ","===========================separator===================","2. org.springframework  spring-core ","A) org.springframework  spring-jcl ","============================END===========================","spring-aop<br /> (Primavera P6 EPPM Licensing Information User Manual)","English\\licensing_information\\p6_eppm_licensing_information\\101475.htm");
Page[480]=new Array("Spring Framework 5.3.21","Copyright (c) 2002-2022 Pivotal, Inc.","This product is licensed to you under the Apache License, Version 2.0","(the &quot;License&quot;). You may not use this product except in compliance with","the License.","This product may include a number of subcomponents with separate","copyright notices and license terms. Your use of the source code for","these subcomponents is subject to the terms and conditions of the","subcomponent's license, as noted in the license.txt file.","Licensed under the Apache Software License, Version 2.0 (the &quot;License&quot;); you may not use this file except in compliance with the License.","=======================================================================","SPRING FRAMEWORK 5.3.21 SUBCOMPONENTS:","Spring Framework 5.3.21 includes a number of subcomponents","with separate copyright notices and license terms. The product that","includes this file does not necessarily use all the open source","subcomponents referred to below. Your use of the source","code for these subcomponents is subject to the terms and","conditions of the following licenses.","&gt;&gt;&gt; ASM 9.1 (org.ow2.asm:asm:9.1, org.ow2.asm:asm-commons:9.1):","Copyright (c) 2000-2011 INRIA, France Telecom","All rights reserved.","Redistribution and use in source and binary forms, with or without","modification, are permitted provided that the following conditions","are met:","1. Redistributions of source code must retain the above copyright","   notice, this list of conditions and the following disclaimer.","2. Redistributions in binary form must reproduce the above copyright","   notice, this list of conditions and the following disclaimer in the","   documentation and/or other materials provided with the distribution.","3. Neither the name of the copyright holders nor the names of its","   contributors may be used to endorse or promote products derived from","   this software without specific prior written permission.","THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS &quot;AS IS&quot;","AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE","IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE","ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE","LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR","CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF","SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS","INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN","CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)","ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF","THE POSSIBILITY OF SUCH DAMAGE.","Copyright (c) 1999-2009, OW2 Consortium &lt;https://www.ow2.org/&gt;","&gt;&gt;&gt; CGLIB 3.3 (cglib:cglib:3.3):","Per the LICENSE file in the CGLIB JAR distribution downloaded from","https://github.com/cglib/cglib/releases/download/RELEASE_3_3_0/cglib-3.3.0.jar,","CGLIB 3.3 is licensed under the Apache License, version 2.0, the text of which","is included above.","&gt;&gt;&gt; Objenesis 3.2 (org.objenesis:objenesis:3.2):","Per the LICENSE file in the Objenesis ZIP distribution downloaded from","http://objenesis.org/download.html, Objenesis 3.2 is licensed under the","Apache License, version 2.0, the text of which is included above.","Per the NOTICE file in the Objenesis ZIP distribution downloaded from","http://objenesis.org/download.html and corresponding to section 4d of the","Apache License, Version 2.0, in this case for Objenesis:","Objenesis","Copyright 2006-2019 Joe Walnes, Henri Tremblay, Leonardo Mesquita","===============================================================================","To the extent any open source components are licensed under the EPL and/or","other similar licenses that require the source code and/or modifications to","source code to be made available (as would be noted above), you may obtain a","copy of the source code corresponding to the binaries for such open source","components and modifications thereto, if any, (the &quot;Source Files&quot;), by","downloading the Source Files from https://spring.io/projects, Pivotal's website","at https://network.pivotal.io/open-source, or by sending a request, with your","name and address to: Pivotal Software, Inc., 875 Howard Street, 5th floor, San","Francisco, CA 94103, Attention: General Counsel. All such requests should","clearly specify: OPEN SOURCE FILES REQUEST, Attention General Counsel. Pivotal","can mail a copy of the Source Files to you on a CD or equivalent physical","medium.","This offer to obtain a copy of the Source Files is valid for three years from","the date you acquired this Software product. Alternatively, the Source Files","may accompany the Software.","spring-beans<br /> (Primavera P6 EPPM Licensing Information User Manual)","English\\licensing_information\\p6_eppm_licensing_information\\101476.htm");
Page[481]=new Array("org.springframework:spring-context","spring-context has following 4th party dependencies:","org.springframework:spring-aop","org.springframework:spring-beans","org.springframework:spring-core","org.springframework:spring-jcl","org.springframework:spring-expression","All the above mentioned artifacts are licensed under the Apache Software License, Version 2.0 (the &quot;License&quot;); you may not use this file except in compliance with the License.","Notice:","Spring Framework ${version}","Copyright (c) 2002-2023 Pivotal, Inc.","This product is licensed to you under the Apache License, Version 2.0","(the &quot;License&quot;). You may not use this product except in compliance with","the License.","This product may include a number of subcomponents with separate","copyright notices and license terms. Your use of the source code for","these subcomponents is subject to the terms and conditions of the","subcomponent's license, as noted in the license.txt file.","========================================================================","Recursive fourth party components:-","==================================================","1. org.springframework  spring-aop","A) org.springframework  spring-beans","a) org.springframework  spring-core","*) org.springframework  spring-jcl","B) org.springframework  spring-core","a) org.springframework  spring-jcl","=======================separator=======================","2. org.springframework  spring-beans","A) org.springframework  spring-core","a) org.springframework  spring-jcl","=======================separator=======================","3. org.springframework  spring-core","A) org.springframework  spring-jcl","=======================separator=======================","4. org.springframework  spring-expression","A) org.springframework  spring-core","a) org.springframework  spring-jcl","=========================END===============================","spring-context<br /> (Primavera P6 EPPM Licensing Information User Manual)","English\\licensing_information\\p6_eppm_licensing_information\\101470.htm");
Page[482]=new Array("Spring Framework 5.3.26","Rod Johnson, Juergen Hoeller, Keith Donald, Colin Sampaleanu, Rob Harrop, Thomas Risberg,","Alef Arendsen, Darren Davison, Dmitriy Kopylenko, Mark Pollack, Thierry Templier, Erwin","Vervaet, Portia Tung, Ben Hale, Adrian Colyer, John Lewis, Costin Leau, Mark Fisher, Sam","Brannen, Ramnivas Laddad, Arjen Poutsma, Chris Beams, Tareq Abedrabbo, Andy Clement, Dave","Syer, Oliver Gierke, Rossen Stoyanchev, Phillip Webb, Rob Winch, Brian Clozel, Stephane","Nicoll, Sebastien Deleuze, Jay Bryant, Mark Paluch","Copyright  2002 - 2022 Pivotal, Inc. All Rights Reserved.","Copies of this document may be made for your own use and for distribution to others,","provided that you do not charge any fee for such copies and further provided that each","copy contains this Copyright Notice, whether distributed in print or electronically.","This product is licensed to you under the Apache License, Version 2.0","(the &quot;License&quot;). You may not use this product except in compliance with","the License.","This product may include a number of subcomponents with separate","copyright notices and license terms. Your use of the source code for","these subcomponents is subject to the terms and conditions of the","subcomponent's license, as noted in the license.txt file.","Licensed under the Apache Software License, Version 2.0 (the &quot;License&quot;); you may not use this file except in compliance with the License.","=======================================================================","SPRING FRAMEWORK ${version} SUBCOMPONENTS:","Spring Framework ${version} includes a number of subcomponents","with separate copyright notices and license terms. The product that","includes this file does not necessarily use all the open source","subcomponents referred to below. Your use of the source","code for these subcomponents is subject to the terms and","conditions of the following licenses.","&gt;&gt;&gt; ASM 9.1 (org.ow2.asm:asm:9.1, org.ow2.asm:asm-commons:9.1):","Copyright (c) 2000-2011 INRIA, France Telecom","All rights reserved.","Redistribution and use in source and binary forms, with or without","modification, are permitted provided that the following conditions","are met:","1. Redistributions of source code must retain the above copyright","   notice, this list of conditions and the following disclaimer.","2. Redistributions in binary form must reproduce the above copyright","   notice, this list of conditions and the following disclaimer in the","   documentation and/or other materials provided with the distribution.","3. Neither the name of the copyright holders nor the names of its","   contributors may be used to endorse or promote products derived from","   this software without specific prior written permission.","THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS &quot;AS IS&quot;","AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE","IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE","ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE","LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR","CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF","SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS","INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN","CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)","ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF","THE POSSIBILITY OF SUCH DAMAGE.","Copyright (c) 1999-2009, OW2 Consortium &lt;https://www.ow2.org/&gt;","&gt;&gt;&gt; CGLIB 3.3 (cglib:cglib:3.3):","Per the LICENSE file in the CGLIB JAR distribution downloaded from","https://github.com/cglib/cglib/releases/download/RELEASE_3_3_0/cglib-3.3.0.jar,","CGLIB 3.3 is licensed under the Apache License, version 2.0, the text of which","is included above.","&gt;&gt;&gt; Objenesis 3.2 (org.objenesis:objenesis:3.2):","Per the LICENSE file in the Objenesis ZIP distribution downloaded from","http://objenesis.org/download.html, Objenesis 3.2 is licensed under the","Apache License, version 2.0, the text of which is included above.","Per the NOTICE file in the Objenesis ZIP distribution downloaded from","http://objenesis.org/download.html and corresponding to section 4d of the","Apache License, Version 2.0, in this case for Objenesis:","Objenesis","Copyright 2006-2019 Joe Walnes, Henri Tremblay, Leonardo Mesquita","===============================================================================","To the extent any open source components are licensed under the EPL and/or","other similar licenses that require the source code and/or modifications to","source code to be made available (as would be noted above), you may obtain a","copy of the source code corresponding to the binaries for such open source","components and modifications thereto, if any, (the &quot;Source Files&quot;), by","downloading the Source Files from https://spring.io/projects, Pivotal's website","at https://network.pivotal.io/open-source, or by sending a request, with your","name and address to: Pivotal Software, Inc., 875 Howard Street, 5th floor, San","Francisco, CA 94103, Attention: General Counsel. All such requests should","clearly specify: OPEN SOURCE FILES REQUEST, Attention General Counsel. Pivotal","can mail a copy of the Source Files to you on a CD or equivalent physical","medium.","This offer to obtain a copy of the Source Files is valid for three years from","the date you acquired this Software product. Alternatively, the Source Files","may accompany the Software.","spring-core<br /> (Primavera P6 EPPM Licensing Information User Manual)","English\\licensing_information\\p6_eppm_licensing_information\\101471.htm");
Page[483]=new Array("Spring Framework","Copyright (c) 2002-2023 Pivotal, Inc.","Licensed under the Apache Software License, Version 2.0 (the &quot;License&quot;); you may not use this file except in compliance with the License.","=======================================================================","SPRING FRAMEWORK SUBCOMPONENTS:","Spring Framework includes a number of subcomponents","with separate copyright notices and license terms. The product that","includes this file does not necessarily use all the open source","subcomponents referred to below. Your use of the source","code for these subcomponents is subject to the terms and","conditions of the following licenses.","&gt;&gt;&gt; ASM (org.ow2.asm:asm, org.ow2.asm:asm-commons):","Copyright (c) 2000-2011 INRIA, France Telecom","All rights reserved.","Redistribution and use in source and binary forms, with or without","modification, are permitted provided that the following conditions","are met:","1. Redistributions of source code must retain the above copyright","   notice, this list of conditions and the following disclaimer.","2. Redistributions in binary form must reproduce the above copyright","   notice, this list of conditions and the following disclaimer in the","   documentation and/or other materials provided with the distribution.","3. Neither the name of the copyright holders nor the names of its","   contributors may be used to endorse or promote products derived from","   this software without specific prior written permission.","THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS &quot;AS IS&quot;","AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE","IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE","ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE","LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR","CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF","SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS","INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN","CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)","ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF","THE POSSIBILITY OF SUCH DAMAGE.","Copyright (c) 1999-2009, OW2 Consortium &lt;https://www.ow2.org/&gt;","&gt;&gt;&gt; CGLIB (cglib:cglib):","Per the LICENSE file in the CGLIB JAR distribution, ","CGLIB is licensed under the Apache License, version 2.0, the text of which","is included above.","&gt;&gt;&gt; Objenesis (org.objenesis:objenesis):","Per the LICENSE file in the Objenesis ZIP distribution downloaded from","http://objenesis.org/download.html, Objenesis is licensed under the","Apache License, version 2.0, the text of which is included above.","Per the NOTICE file in the Objenesis ZIP distribution downloaded from","http://objenesis.org/download.html and corresponding to section 4d of the","Apache License, Version 2.0, in this case for Objenesis:","Objenesis","Copyright 2006-2019 Joe Walnes, Henri Tremblay, Leonardo Mesquita","===============================================================================","To the extent any open source components are licensed under the EPL and/or","other similar licenses that require the source code and/or modifications to","source code to be made available (as would be noted above), you may obtain a","copy of the source code corresponding to the binaries for such open source","components and modifications thereto, if any, (the &quot;Source Files&quot;), by","downloading the Source Files from https://spring.io/projects, Pivotal's website","at https://network.pivotal.io/open-source, or by sending a request, with your","name and address to: Pivotal Software, Inc., 875 Howard Street, 5th floor, San","Francisco, CA 94103, Attention: General Counsel. All such requests should","clearly specify: OPEN SOURCE FILES REQUEST, Attention General Counsel. Pivotal","can mail a copy of the Source Files to you on a CD or equivalent physical","medium.","This offer to obtain a copy of the Source Files is valid for three years from","the date you acquired this Software product. Alternatively, the Source Files","may accompany the Software.","--------------------------------------------------","org.springframework:spring-beans","org.springframework:spring-core","org.springframework:spring-tx","org.springframework:spring-jcl","spring-jdbc<br /> (Primavera P6 EPPM Licensing Information User Manual)","English\\licensing_information\\p6_eppm_licensing_information\\101478.htm");
Page[484]=new Array("Top level component:","org.springframework:spring-tx","Dependencies:","org.springframework:spring-beans","org.springframework:spring-core","================================================","Spring Framework 5.3.26","Copyright (c) 2002-2023 Pivotal, Inc.","Licensed under the Apache Software License, Version 2.0 (the &quot;License&quot;); you may not use this file except in compliance with the License.","=======================================================================","SPRING FRAMEWORK SUBCOMPONENTS:","Spring Framework includes a number of subcomponents","with separate copyright notices and license terms. The product that","includes this file does not necessarily use all the open source","subcomponents referred to below. Your use of the source","code for these subcomponents is subject to the terms and","conditions of the following licenses.","&gt;&gt;&gt; org.ow2.asm:asm, org.ow2.asm:asm-commons:","Copyright (c) 2000-2011 INRIA, France Telecom","All rights reserved.","Redistribution and use in source and binary forms, with or without","modification, are permitted provided that the following conditions","are met:","1. Redistributions of source code must retain the above copyright","   notice, this list of conditions and the following disclaimer.","2. Redistributions in binary form must reproduce the above copyright","   notice, this list of conditions and the following disclaimer in the","   documentation and/or other materials provided with the distribution.","3. Neither the name of the copyright holders nor the names of its","   contributors may be used to endorse or promote products derived from","   this software without specific prior written permission.","THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS &quot;AS IS&quot;","AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE","IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE","ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE","LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR","CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF","SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS","INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN","CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)","ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF","THE POSSIBILITY OF SUCH DAMAGE.","Copyright (c) 1999-2009, OW2 Consortium ","&gt;&gt;&gt; cglib:cglib:","CGLIB is licensed under the Apache License, version 2.0, the text of which","is included above.","&gt;&gt;&gt; org.objenesis:objenesis:","Objenesis is licensed under the","Apache License, version 2.0, the text of which is included above.","Per the NOTICE file in the Objenesis ZIP distribution downloaded from","http://objenesis.org/download.html and corresponding to section 4d of the","Apache License, Version 2.0, in this case for Objenesis:","Objenesis","Copyright 2006-2019 Joe Walnes, Henri Tremblay, Leonardo Mesquita","===============================================================================","To the extent any open source components are licensed under the EPL and/or","other similar licenses that require the source code and/or modifications to","source code to be made available (as would be noted above), you may obtain a","copy of the source code corresponding to the binaries for such open source","components and modifications thereto, if any, (the &quot;Source Files&quot;), by","downloading the Source Files from https://spring.io/projects, Pivotal's website","at https://network.pivotal.io/open-source, or by sending a request, with your","name and address to: Pivotal Software, Inc., 875 Howard Street, 5th floor, San","Francisco, CA 94103, Attention: General Counsel. All such requests should","clearly specify: OPEN SOURCE FILES REQUEST, Attention General Counsel. Pivotal","can mail a copy of the Source Files to you on a CD or equivalent physical","medium.","This offer to obtain a copy of the Source Files is valid for three years from","the date you acquired this Software product. Alternatively, the Source Files","may accompany the Software.","================================================","spring-tx<br /> (Primavera P6 EPPM Licensing Information User Manual)","English\\licensing_information\\p6_eppm_licensing_information\\101477.htm");
Page[485]=new Array("https://github.com/spring-projects/spring-framework/blob/v5.3.26/LICENSE.txt","Licensed under the Apache Software License, Version 2.0 (the &quot;License&quot;); you may not use this file except in compliance with the License.","=============SEPARATOR==============","https://github.com/spring-projects/spring-framework/blob/main/framework-docs/src/docs/dist/notice.txt","Spring Framework ${version}","Copyright (c) 2002-${copyright} Pivotal, Inc.","This product is licensed to you under the Apache License, Version 2.0","(the &quot;License&quot;). You may not use this product except in compliance with","the License.","This product may include a number of subcomponents with separate","copyright notices and license terms. Your use of the source code for","these subcomponents is subject to the terms and conditions of the","subcomponent's license, as noted in the license.txt file.","=============SEPARATOR==============","https://github.com/spring-projects/spring-framework/blob/main/framework-docs/src/docs/dist/license.txt","Licensed under the Apache Software License, Version 2.0 (the &quot;License&quot;); you may not use this file except in compliance with the License.","=======================================================================","SPRING FRAMEWORK ${version} SUBCOMPONENTS:","Spring Framework ${version} includes a number of subcomponents","with separate copyright notices and license terms. The product that","includes this file does not necessarily use all the open source","subcomponents referred to below. Your use of the source","code for these subcomponents is subject to the terms and","conditions of the following licenses.","&gt;&gt;&gt; ASM 9.1 (org.ow2.asm:asm:9.1, org.ow2.asm:asm-commons:9.1):","Copyright (c) 2000-2011 INRIA, France Telecom","All rights reserved.","Redistribution and use in source and binary forms, with or without","modification, are permitted provided that the following conditions","are met:","1. Redistributions of source code must retain the above copyright","   notice, this list of conditions and the following disclaimer.","2. Redistributions in binary form must reproduce the above copyright","   notice, this list of conditions and the following disclaimer in the","   documentation and/or other materials provided with the distribution.","3. Neither the name of the copyright holders nor the names of its","   contributors may be used to endorse or promote products derived from","   this software without specific prior written permission.","THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS &quot;AS IS&quot;","AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE","IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE","ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE","LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR","CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF","SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS","INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN","CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)","ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF","THE POSSIBILITY OF SUCH DAMAGE.","Copyright (c) 1999-2009, OW2 Consortium &lt;https://www.ow2.org/&gt;","&gt;&gt;&gt; CGLIB 3.3 (cglib:cglib:3.3):","Per the LICENSE file in the CGLIB JAR distribution downloaded from","https://github.com/cglib/cglib/releases/download/RELEASE_3_3_0/cglib-3.3.0.jar,","CGLIB 3.3 is licensed under the Apache License, version 2.0, the text of which","is included above.","&gt;&gt;&gt; JavaPoet 1.13.0 (com.squareup:javapoet:1.13.0):","Per the LICENSE file in the JavaPoet JAR distribution downloaded from","https://github.com/square/javapoet/archive/refs/tags/javapoet-1.13.0.zip,","JavaPoet 1.13.0 is licensed under the Apache License, version 2.0, the text of","which is included above.","&gt;&gt;&gt; Objenesis 3.2 (org.objenesis:objenesis:3.2):","Per the LICENSE file in the Objenesis ZIP distribution downloaded from","http://objenesis.org/download.html, Objenesis 3.2 is licensed under the","Apache License, version 2.0, the text of which is included above.","Per the NOTICE file in the Objenesis ZIP distribution downloaded from","http://objenesis.org/download.html and corresponding to section 4d of the","Apache License, Version 2.0, in this case for Objenesis:","Objenesis","Copyright 2006-2019 Joe Walnes, Henri Tremblay, Leonardo Mesquita","===============================================================================","To the extent any open source components are licensed under the EPL and/or","other similar licenses that require the source code and/or modifications to","source code to be made available (as would be noted above), you may obtain a","copy of the source code corresponding to the binaries for such open source","components and modifications thereto, if any, (the &quot;Source Files&quot;), by","downloading the Source Files from https://spring.io/projects, Pivotal's website","at https://network.pivotal.io/open-source, or by sending a request, with your","name and address to: Pivotal Software, Inc., 875 Howard Street, 5th floor, San","Francisco, CA 94103, Attention: General Counsel. All such requests should","clearly specify: OPEN SOURCE FILES REQUEST, Attention General Counsel. Pivotal","can mail a copy of the Source Files to you on a CD or equivalent physical","medium.","This offer to obtain a copy of the Source Files is valid for three years from","the date you acquired this Software product. Alternatively, the Source Files","may accompany the Software.","=============SEPARATOR==============","org.springframework:spring-beans:5.3.26","rg.springframework:spring-core:5.3.26","org.springframework:spring-jcl:5.3.26","Covered under the top level license Apache License Version 2.0","spring-web<br /> (Primavera P6 EPPM Licensing Information User Manual)","English\\licensing_information\\p6_eppm_licensing_information\\101468.htm");
Page[486]=new Array("org.springframework:spring-webmvc","Licensed under the Apache Software License, Version 2.0 (the &quot;License&quot;); you may not use this file except in compliance with the License.","=======================================================================","SPRING FRAMEWORK SUBCOMPONENTS:","Spring Framework includes a number of subcomponents","with separate copyright notices and license terms. The product that","includes this file does not necessarily use all the open source","subcomponents referred to below. Your use of the source","code for these subcomponents is subject to the terms and","conditions of the following licenses.","&gt;&gt;&gt; org.ow2.asm:asm, org.ow2.asm:asm-commons:","Copyright (c) 2000-2011 INRIA, France Telecom","All rights reserved.","Redistribution and use in source and binary forms, with or without","modification, are permitted provided that the following conditions","are met:","1. Redistributions of source code must retain the above copyright","   notice, this list of conditions and the following disclaimer.","2. Redistributions in binary form must reproduce the above copyright","   notice, this list of conditions and the following disclaimer in the","   documentation and/or other materials provided with the distribution.","3. Neither the name of the copyright holders nor the names of its","   contributors may be used to endorse or promote products derived from","   this software without specific prior written permission.","THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS &quot;AS IS&quot;","AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE","IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE","ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE","LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR","CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF","SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS","INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN","CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)","ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF","THE POSSIBILITY OF SUCH DAMAGE.","Copyright (c) 1999-2009, OW2 Consortium ","&gt;&gt;&gt; cglib:cglib:","CGLIB is licensed under the Apache License, version 2.0, the text of which","is included above.","&gt;&gt;&gt; org.objenesis:objenesis:","Per the LICENSE file in the Objenesis ZIP distribution downloaded from","http://objenesis.org/download.html, Objenesis is licensed under the","Apache License, version 2.0, the text of which is included above.","Per the NOTICE file in the Objenesis ZIP distribution downloaded from","http://objenesis.org/download.html and corresponding to section 4d of the","Apache License, Version 2.0, in this case for Objenesis:","Objenesis","Copyright 2006-2019 Joe Walnes, Henri Tremblay, Leonardo Mesquita","===============================================================================","To the extent any open source components are licensed under the EPL and/or","other similar licenses that require the source code and/or modifications to","source code to be made available (as would be noted above), you may obtain a","copy of the source code corresponding to the binaries for such open source","components and modifications thereto, if any, (the &quot;Source Files&quot;), by","downloading the Source Files from https://spring.io/projects, Pivotal's website","at https://network.pivotal.io/open-source, or by sending a request, with your","name and address to: Pivotal Software, Inc., 875 Howard Street, 5th floor, San","Francisco, CA 94103, Attention: General Counsel. All such requests should","clearly specify: OPEN SOURCE FILES REQUEST, Attention General Counsel. Pivotal","can mail a copy of the Source Files to you on a CD or equivalent physical","medium.","This offer to obtain a copy of the Source Files is valid for three years from","the date you acquired this Software product. Alternatively, the Source Files","may accompany the Software.","===================================================================","Copyright (c) 2002-2023 Pivotal, Inc.","This product is licensed to you under the Apache License, Version 2.0","(the &quot;License&quot;). You may not use this product except in compliance with","the License.","This product may include a number of subcomponents with separate","copyright notices and license terms. Your use of the source code for","these subcomponents is subject to the terms and conditions of the","subcomponent's license, as noted in the license.txt file.","===================================================================","Recursive fourth party components:-","=================================================","1. org.springframework  spring-aop	","A) org.springframework  spring-beans	","a) org.springframework  spring-core	","*) org.springframework  spring-jcl	","==================================================","B) org.springframework  spring-core	","a) org.springframework  spring-jcl	","=======================separator===========================","2. org.springframework  spring-beans	","A) org.springframework  spring-core","a) org.springframework  spring-jcl	","=======================separator===========================","3. org.springframework  spring-context	","A) org.springframework  spring-aop	","a) org.springframework  spring-beans	","*) org.springframework  spring-core	","*) org.springframework  spring-jcl	","b) org.springframework  spring-core	","*) org.springframework  spring-jcl	","==================================================","B) org.springframework  spring-beans	","a) org.springframework  spring-core	","*) org.springframework  spring-jcl	","C) org.springframework  spring-core	","*) org.springframework  spring-jcl	","D) org.springframework  spring-expression","a) org.springframework  spring-core	","*) org.springframework  spring-jcl	","========================separator==========================","4. org.springframework  spring-core	","A) org.springframework  spring-jcl	","========================separator==========================","5. org.springframework  spring-expression	","A) org.springframework  spring-core	","a) org.springframework  spring-jcl	","=========================separator=========================","6. org.springframework  spring-web	","A) org.springframework  spring-beans	","a) org.springframework  spring-core","*) org.springframework  spring-jcl	","B) org.springframework  spring-core	","a) org.springframework  spring-jcl	","============================END================================","spring-webmvc<br /> (Primavera P6 EPPM Licensing Information User Manual)","English\\licensing_information\\p6_eppm_licensing_information\\101469.htm");
Page[487]=new Array("==================================================================================","	Top level component : XML Security for Java 2.2.6","==================================================================================","	* Copyright","		Copyright 1999-2022 The Apache Software Foundation","	","	* Notice ","		Apache Santuario - XML Security for Java","		Copyright 1999-2022 The Apache Software Foundation","		This product includes software developed at","		The Apache Software Foundation (http://www.apache.org/).","		It was originally based on software copyright (c) 2001, Institute for","		Data Communications Systems, &lt;http://www.nue.et-inf.uni-siegen.de/&gt;.","		The development of this software was partly funded by the European ","		Commission in the &lt;WebSig&gt; project in the ISIS Programme. ","		This product contains software that is","		copyright (c) 2021, Oracle and/or its affiliates.","	* License","		Apache 2.0","		 Apache License","		Version 2.0, January 2004","		http://www.apache.org/licenses/","Licensed under the Apache Software License, Version 2.0 (the &quot;License&quot;); you may not use this file except in compliance with the License.","==================================================================================","	Fourth party dependency","	-----------------------","	#01 jakarta.xml.bind-api","	#02 commons-codec","	#03 slf4j-api","	#04 woodstox-core","	#05 stax2-api","==================================================================================","	Fourth party #01 jakarta.xml.bind-api","==================================================================================","	* Copyright ","		Copyright (c) 2017, 2018 Oracle and/or its affiliates. All rights reserved.","	","	* Notice ","		Notices for Eclipse Project for JAXB","		This content is produced and maintained by the Eclipse Project for JAXB project.","		Project home: https://projects.eclipse.org/projects/ee4j.jaxb","		Trademarks","		Eclipse Project for JAXB is a trademark of the Eclipse Foundation.","		Copyright","		All content is the property of the respective authors or their employers. ","		For more information regarding authorship of content, please consult the listed ","		source code repository logs.","		Declared Project Licenses","		This program and the accompanying materials are made available under the terms of the ","		Eclipse Distribution License v. 1.0 which is available at http://www.eclipse.org/org/documents/edl-v10.php.","		SPDX-License-Identifier: BSD-3-Clause","		Source Code","		The project maintains the following source code repositories:","		https://github.com/eclipse-ee4j/jaxb-api","		Third-party Content","		This project leverages the following third party content.","		None","		Cryptography","		Content may contain encryption software. The country in which you are currently may have ","		restrictions on the import, possession, and use, and/or re-export to another country, of ","		encryption software. BEFORE using any encryption software, please check the country's laws, ","		regulations and policies concerning the import, possession, or use, and re-export of ","		encryption software, to see if this is permitted.","	* License","		BSD Clause 3","			Copyright (c) 2017, 2018 Oracle and/or its affiliates. All rights reserved.","			Redistribution and use in source and binary forms, with or without","			modification, are permitted provided that the following conditions","			are met:","			  - Redistributions of source code must retain the above copyright","				notice, this list of conditions and the following disclaimer.","			  - Redistributions in binary form must reproduce the above copyright","				notice, this list of conditions and the following disclaimer in the","				documentation and/or other materials provided with the distribution.","			  - Neither the name of the Eclipse Foundation, Inc. nor the names of its","				contributors may be used to endorse or promote products derived","				from this software without specific prior written permission.","			THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS &quot;AS","			IS&quot; AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO,","			THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR","			PURPOSE ARE DISCLAIMED.  IN NO EVENT SHALL THE COPYRIGHT OWNER OR","			CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL,","			EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO,","			PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR","			PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF","			LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING","			NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS","			SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.","==================================================================================","	Fourth party #02 commons-codec","==================================================================================","	* Copyright","		Copyright 2002-2020 The Apache Software Foundation","	","	* Notice ","		Apache Commons Codec","		Copyright 2002-2020 The Apache Software Foundation","		This product includes software developed at","		The Apache Software Foundation (https://www.apache.org/).","		src/test/org/apache/commons/codec/language/DoubleMetaphoneTest.java","		contains test data from http://aspell.net/test/orig/batch0.tab.","		Copyright (C) 2002 Kevin Atkinson (kevina@gnu.org)","		===============================================================================","		The content of package org.apache.commons.codec.language.bm has been translated","		from the original php source code available at http://stevemorse.org/phoneticinfo.htm","		with permission from the original authors.","		Original source copyright:","		Copyright (c) 2008 Alexander Beider &amp; Stephen P. Morse.","	* License ","		Apache 2.0","==================================================================================","	Fourth party #03 slf4j-api","==================================================================================","	* Copyright ","		Copyright (c) 2004-2022 QOS.ch Sarl (Switzerland)","		","	* License ","		MIT License","		","		Copyright (c) 2004-2022 QOS.ch Sarl (Switzerland)","		All rights reserved.","		Permission is hereby granted, free  of charge, to any person obtaining","		a  copy  of this  software  and  associated  documentation files  (the","		&quot;Software&quot;), to  deal in  the Software without  restriction, including","		without limitation  the rights to  use, copy, modify,  merge, publish,","		distribute,  sublicense, and/or sell  copies of  the Software,  and to","		permit persons to whom the Software  is furnished to do so, subject to","		the following conditions:","		The  above  copyright  notice  and  this permission  notice  shall  be","		included in all copies or substantial portions of the Software.","		THE  SOFTWARE IS  PROVIDED  &quot;AS  IS&quot;, WITHOUT  WARRANTY  OF ANY  KIND,","		EXPRESS OR  IMPLIED, INCLUDING  BUT NOT LIMITED  TO THE  WARRANTIES OF","		MERCHANTABILITY,    FITNESS    FOR    A   PARTICULAR    PURPOSE    AND","		NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE","		LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION","		OF CONTRACT, TORT OR OTHERWISE,  ARISING FROM, OUT OF OR IN CONNECTION","		WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.","==================================================================================","	Fourth party #04 woodstox-core","==================================================================================","	* Copyright ","		Copyright 2007-present the original author or authors.","	","	* Notice","		This copy of Jackson JSON processor databind module is licensed under the","		Apache (Software) License, version 2.0 (&quot;the License&quot;).","		See the License for details about distribution rights, and the","		specific rights regarding derivate works.","		You may obtain a copy of the License at:","		http://www.apache.org/licenses/LICENSE-2.0","	* License","		Apache 2.0","==================================================================================","	Fourth party #05 stax2-api","==================================================================================","	* Copyright ","		&lt;COPYRIGHT HOLDER&gt; = FasterXML.com","		&lt;YEAR&gt; = 2010-","	* Notice","		This copy of Stax2 API is licensed under the","		Simplified BSD License (also known as &quot;2-clause BSD&quot;, or &quot;FreeBSD License&quot;)","		See the License for details about distribution rights, and the","		specific rights regarding derivate works.","		You may obtain a copy of the License at:","		http://www.opensource.org/licenses/bsd-license.php","		with details of:","		&lt;COPYRIGHT HOLDER&gt; = FasterXML.com","		&lt;YEAR&gt; = 2010-","	* License","		BSD Clause 2","			Copyright &lt;YEAR&gt; &lt;COPYRIGHT HOLDER&gt;","			Redistribution and use in source and binary forms, with or without ","			modification, are permitted provided that the following conditions ","			are met:","			1. 	Redistributions of source code must retain the above copyright notice, ","				this list of conditions and the following disclaimer.","			2. 	Redistributions in binary form must reproduce the above copyright notice, ","				this list of conditions and the following disclaimer in the documentation and/or ","				other materials provided with the distribution.","			THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS &#8220;AS IS&#8221; AND ANY ","			EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES ","			OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT ","			SHALL THE COPYRIGHT HOLDER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, ","			INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT ","			LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR ","			PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, ","			WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)","			ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY ","			OF SUCH DAMAGE.","=================================================================================","XML Security for Java<br /> (Primavera P6 EPPM Licensing Information User Manual)","English\\licensing_information\\p6_eppm_licensing_information\\102599.htm");
Page[488]=new Array("The following applies to all products licensed under the Apache 2.0 License:","You may not use the identified files except in compliance with the Apache License, Version 2.0 (the &quot;License.&quot;) You may obtain a copy of the License at http://www.apache.org/licenses/LICENSE-2.0. A copy of the license is also reproduced below. Unless required by applicable law or agreed to in writing, software distributed under the License is distributed on an &quot;AS IS&quot; BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions and limitations under the License.","Apache License<br />Version 2.0, January 2004<br />http://www.apache.org/licenses/","TERMS AND CONDITIONS FOR USE, REPRODUCTION, AND DISTRIBUTION","Definitions.","&quot;License&quot; shall mean the terms and conditions for use, reproduction, and distribution as defined by Sections 1 through 9 of this document.","&quot;Licensor&quot; shall mean the copyright owner or entity authorized by the copyright owner that is granting the License.","&quot;Legal Entity&quot; shall mean the union of the acting entity and all other entities that control, are controlled by, or are under common control with that entity. For the purposes of this definition, &quot;control&quot; means (i) the power, direct or indirect, to cause the direction or management of such entity, whether by contract or otherwise, or (ii) ownership of fifty percent (50%) or more of the outstanding shares, or (iii) beneficial ownership of such entity.","&quot;You&quot; (or &quot;Your&quot;) shall mean an individual or Legal Entity exercising permissions granted by this License.","&quot;Source&quot; form shall mean the preferred form for making modifications, including but not limited to software source code, documentation source, and configuration files.","&quot;Object&quot; form shall mean any form resulting from mechanical transformation or translation of a Source form, including but not limited to compiled object code, generated documentation, and conversions to other media types.","&quot;Work&quot; shall mean the work of authorship, whether in Source or Object form, made available under the License, as indicated by a copyright notice that is included in or attached to the work (an example is provided in the Appendix below).","&quot;Derivative Works&quot; shall mean any work, whether in Source or Object form, that is based on (or derived from) the Work and for which the editorial revisions, annotations, elaborations, or other modifications represent, as a whole, an original work of authorship. For the purposes of this License, Derivative Works shall not include works that remain separable from, or merely link (or bind by name) to the interfaces of, the Work and Derivative Works thereof.","&quot;Contribution&quot; shall mean any work of authorship, including the original version of the Work and any modifications or additions to that Work or Derivative Works thereof, that is intentionally submitted to Licensor for inclusion in the Work by the copyright owner or by an individual or Legal Entity authorized to submit on behalf of the copyright owner. For the purposes of this definition, &quot;submitted&quot; means any form of electronic, verbal, or written communication sent to the Licensor or its representatives, including but not limited to communication on electronic mailing lists, source code control systems, and issue tracking systems that are managed by, or on behalf of, the Licensor for the purpose of discussing and improving the Work, but excluding communication that is conspicuously marked or otherwise designated in writing by the copyright owner as &quot;Not a Contribution.&quot;","&quot;Contributor&quot; shall mean Licensor and any individual or Legal Entity on behalf of whom a Contribution has been received by Licensor and subsequently incorporated within the Work.","Grant of Copyright License. Subject to the terms and conditions of this License, each Contributor hereby grants to You a perpetual, worldwide, non-exclusive, no-charge, royalty-free, irrevocable copyright license to reproduce, prepare Derivative Works of, publicly display, publicly perform, sublicense, and distribute the Work and such Derivative Works in Source or Object form.","Grant of Patent License. Subject to the terms and conditions of this License, each Contributor hereby grants to You a perpetual, worldwide, non-exclusive, no-charge, royalty-free, irrevocable (except as stated in this section) patent license to make, have made, use, offer to sell, sell, import, and otherwise transfer the Work, where such license applies only to those patent claims licensable by such Contributor that are necessarily infringed by their Contribution(s) alone or by combination of their Contribution(s) with the Work to which such Contribution(s) was submitted. If You institute patent litigation against any entity (including a cross-claim or counterclaim in a lawsuit) alleging that the Work or a Contribution incorporated within the Work constitutes direct or contributory patent infringement, then any patent licenses granted to You under this License for that Work shall terminate as of the date such litigation is filed.","Redistribution. You may reproduce and distribute copies of the Work or Derivative Works thereof in any medium, with or without modifications, and in Source or Object form, provided that You meet the following conditions:","You must give any other recipients of the Work or Derivative Works a copy of this License; and","You must cause any modified files to carry prominent notices stating that You changed the files; and","You must retain, in the Source form of any Derivative Works that You distribute, all copyright, patent, trademark, and attribution notices from the Source form of the Work, excluding those notices that do not pertain to any part of the Derivative Works; and","If the Work includes a &quot;NOTICE&quot; text file as part of its distribution, then any Derivative Works that You distribute must include a readable copy of the attribution notices contained within such NOTICE file, excluding those notices that do not pertain to any part of the Derivative Works, in at least one of the following places: within a NOTICE text file distributed as part of the Derivative Works; within the Source form or documentation, if provided along with the Derivative Works; or, within a display generated by the Derivative Works, if and wherever such third-party notices normally appear. The contents of the NOTICE file are for informational purposes only and do not modify the License. You may add Your own attribution notices within Derivative Works that You distribute, alongside or as an addendum to the NOTICE text from the Work, provided that such additional attribution notices cannot be construed as modifying the License.","You may add Your own copyright statement to Your modifications and may provide additional or different license terms and conditions for use, reproduction, or distribution of Your modifications, or for any such Derivative Works as a whole, provided Your use, reproduction, and distribution of the Work otherwise complies with the conditions stated in this License.","Submission of Contributions. Unless You explicitly state otherwise, any Contribution intentionally submitted for inclusion in the Work by You to the Licensor shall be under the terms and conditions of this License, without any additional terms or conditions. Notwithstanding the above, nothing herein shall supersede or modify the terms of any separate license agreement you may have executed with Licensor regarding such Contributions.","Trademarks. This License does not grant permission to use the trade names, trademarks, service marks, or product names of the Licensor, except as required for reasonable and customary use in describing the origin of the Work and reproducing the content of the NOTICE file.","Disclaimer of Warranty. Unless required by applicable law or agreed to in writing, Licensor provides the Work (and each Contributor provides its Contributions) on an &quot;AS IS&quot; BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied, including, without limitation, any warranties or conditions of TITLE, NON-INFRINGEMENT, MERCHANTABILITY, or FITNESS FOR A PARTICULAR PURPOSE. You are solely responsible for determining the appropriateness of using or redistributing the Work and assume any risks associated with Your exercise of permissions under this License.","Limitation of Liability. In no event and under no legal theory, whether in tort (including negligence), contract, or otherwise, unless required by applicable law (such as deliberate and grossly negligent acts) or agreed to in writing, shall any Contributor be liable to You for damages, including any direct, indirect, special, incidental, or consequential damages of any character arising as a result of this License or out of the use or inability to use the Work (including but not limited to damages for loss of goodwill, work stoppage, computer failure or malfunction, or any and all other commercial damages or losses), even if such Contributor has been advised of the possibility of such damages.","Accepting Warranty or Additional Liability. While redistributing the Work or Derivative Works thereof, You may choose to offer, and charge a fee for, acceptance of support, warranty, indemnity, or other liability obligations and/or rights consistent with this License. However, in accepting such obligations, You may act only on Your own behalf and on Your sole responsibility, not on behalf of any other Contributor, and only if You agree to indemnify, defend, and hold each Contributor harmless for any liability incurred by, or claims asserted against, such Contributor by reason of your accepting any such warranty or additional liability.","Apache Software License, Version 2.0<br /> (Primavera P6 EPPM Licensing Information User Manual)","English\\licensing_information\\p6_eppm_licensing_information\\49054.htm");
Page[489]=new Array("Version 2, June 1991	","Copyright (C) 1989, 1991 Free Software Foundation, Inc.","59 Temple Place, Suite 330, Boston, MA 02111-1307 USA","Everyone is permitted to copy and distribute verbatim copies of this license document, but changing it is not allowed.","Preamble","The licenses for most software are designed to take away your freedom to share and change it. By contrast, the GNU General Public License is intended to guarantee your freedom to share and change free software--to make sure the software is free for all its users. This General Public License applies to most of the Free Software Foundation's software and to any other program whose authors commit to using it. (Some other Free Software Foundation software is covered by the GNU Library General Public License instead.) You can apply it to your programs, too.","When we speak of free software, we are referring to freedom, not price. Our General Public Licenses are designed to make sure that you have the freedom to distribute copies of free software (and charge for this service if you wish), that you receive source code or can get it if you want it, that you can change the software or use pieces of it in new free programs; and that you know you can do these things.","To protect your rights, we need to make restrictions that forbid anyone to deny you these rights or to ask you to surrender the rights. These restrictions translate to certain responsibilities for you if you distribute copies of the software, or if you modify it.","For example, if you distribute copies of such a program, whether gratis or for a fee, you must give the recipients all the rights that you have. You must make sure that they, too, receive or can get the source code. And you must show them these terms so they know their rights.","We protect your rights with two steps: (1) copyright the software, and (2) offer you this license which gives you legal permission to copy, distribute and/or modify the software.","Also, for each author's protection and ours, we want to make certain that everyone understands that there is no warranty for this free software. If the software is modified by someone else and passed on, we want its recipients to know that what they have is not the original, so that any problems introduced by others will not reflect on the original authors' reputations. ","Finally, any free program is threatened constantly by software patents. We wish to avoid the danger that redistributors of a free program will individually obtain patent licenses, in effect making the program proprietary. To prevent this, we have made it clear that any patent must be licensed for everyone's free use or not licensed at all.","The precise terms and conditions for copying, distribution and modification follow.","TERMS AND CONDITIONS FOR COPYING, DISTRIBUTION AND MODIFICATION","0. This License applies to any program or other work which contains a notice placed by the copyright holder saying it may be distributed under the terms of this General Public License. The &quot;Program&quot;, below, refers to any such program or work, and a &quot;work based on the Program&quot; means either the Program or any derivative work under copyright law: that is to say, a work containing the Program or a portion of it, either verbatim or with modifications and/or translated into another language. (Hereinafter, translation is included without limitation in the term &quot;modification&quot;.) Each licensee is addressed as&quot;you&quot;.","Activities other than copying, distribution and modification are not covered by this License; they are outside its scope. The act of running the Program is not restricted, and the output from the Program is covered only if its contents constitute a work based on the Program (independent of having been made by running the Program). Whether that is true depends on what the Program does.","1. You may copy and distribute verbatim copies of the Program's source code as you receive it, in any medium, provided that you conspicuously and appropriately publish on each copy an appropriate copyright notice and disclaimer of warranty; keep intact all the notices that refer to this License and to the absence of any warranty; and give any other recipients of the Program a copy of this License along with the Program. You may charge a fee for the physical act of transferring a copy, and you may at your option offer warranty protection in exchange for a fee.","2. You may modify your copy or copies of the Program or any portion of it, thus forming a work based on the Program, and copy and distribute such modifications or work under the terms of Section 1 above, provided that you also meet all of these conditions:","a) You must cause the modified files to carry prominent notices stating that you changed the files and the date of any change.","b) You must cause any work that you distribute or publish, that in whole or in part contains or is derived from the Program or any part thereof, to be licensed as a whole at no charge to all third parties under the terms of this License.","c) If the modified program normally reads commands interactively when run, you must cause it, when started running for such interactive use in the most ordinary way, to print or display an announcement including an appropriate copyright notice and a notice that there is no warranty (or else, saying that you provide a warranty) and that users may redistribute the program under these conditions, and telling the user how to view a copy of this License. (Exception: if the Program itself is interactive but does not normally print such an announcement, your work based on the Program is not required to print an announcement.)	","These requirements apply to the modified work as a whole. If identifiable sections of that work are not derived from the Program, and can be reasonably considered independent and separate works in themselves, then this License, and its terms, do not apply to those sections when you distribute them as separate works. But when you distribute the same sections as part of a whole which is a work based on the Program, the distribution of the whole must be on the terms of this License, whose permissions for other licensees extend to the entire whole, and thus to each and every part regardless of who wrote it.","Thus, it is not the intent of this section to claim rights or contest your rights to work written entirely by you; rather, the intent is to exercise the right to control the distribution of derivative or collective works based on the Program.","In addition, mere aggregation of another work not based on the Program with the Program (or with a work based on the Program) on a volume of a storage or distribution medium does not bring the other work under the scope of this License.","3. You may copy and distribute the Program (or a work based on it, under Section 2) in object code or executable form under the terms of Sections 1 and 2 above provided that you also do one of the following:","a) Accompany it with the complete corresponding machine-readable source code, which must be distributed under the terms of Sections 1 and 2 above on a medium customarily used for software interchange; or,","b) Accompany it with a written offer, valid for at least three years, to give any third party, for a charge no more than your cost of physically performing source distribution, a complete machine-readable copy of the corresponding source code, to be distributed under the terms of Sections 1 and 2 above on a medium customarily used for software interchange; or,","c) Accompany it with the information you received as to the offer to distribute corresponding source code. (This alternative is allowed only for noncommercial distribution and only if you received the program in object code or executable form with such an offer, in accord with Subsection b above.)","The source code for a work means the preferred form of the work for making modifications to it. For an executable work, complete source code means all the source code for all modules it contains, plus any associated interface definition files, plus the scripts used to control compilation and installation of the executable. However, as a special exception, the source code distributed need not include anything that is normally distributed (in either source or binary form) with the major components (compiler, kernel, and so on) of the operating system on which the executable runs, unless that component itself accompanies the executable.","If distribution of executable or object code is made by offering access to copy from a designated place, then offering equivalent access to copy the source code from the same place counts as distribution of the source code, even though third parties are not compelled to copy the source along with the object code.","4. You may not copy, modify, sublicense, or distribute the Program except as expressly provided under this License. Any attempt otherwise to copy, modify, sublicense or distribute the Program is void, and will automatically terminate your rights under this License. However, parties who have received copies, or rights, from you under this License will not have their licenses terminated so long as such parties remain in full compliance.","5. You are not required to accept this License, since you have not signed it. However, nothing else grants you permission to modify or distribute the Program or its derivative works. These actions are prohibited by law if you do not accept this License. Therefore, by modifying or distributing the Program (or any work based on the Program), you indicate your acceptance of this License to do so, and all its terms and conditions for copying, distributing or modifying the Program or works based on it.","6. Each time you redistribute the Program (or any work based on the Program), the recipient automatically receives a license from the original licensor to copy, distribute or modify the Program subject to these terms and conditions. You may not impose any further restrictions on the recipients' exercise of the rights granted herein. You are not responsible for enforcing compliance by third parties to this License.","7. If, as a consequence of a court judgment or allegation of patent infringement or for any other reason (not limited to patent issues), conditions are imposed on you (whether by court order, agreement or otherwise) that contradict the conditions of this License, they do not excuse you from the conditions of this License. If you cannot distribute so as to satisfy simultaneously your obligations under this License and any other pertinent obligations, then as a consequence you may not distribute the Program at all. For example, if a patent license would not permit royalty-free redistribution of the Program by all those who receive copies directly or indirectly through you, then the only way you could satisfy both it and this License would be to refrain entirely from distribution of the Program.","If any portion of this section is held invalid or unenforceable under any particular circumstance, the balance of the section is intended to apply and the section as a whole is intended to apply in other circumstances.","It is not the purpose of this section to induce you to infringe any patents or other property right claims or to contest validity of any such claims; this section has the sole purpose of protecting the integrity of the free software distribution system, which is implemented by public license practices. Many people have made generous contributions to the wide range of software distributed through that system in reliance on consistent application of that system; it is up to the author/donor to decide if he or she is willing to distribute software through any other system and a licensee cannot impose that choice. This section is intended to make thoroughly clear what is believed to be a consequence of the rest of this License.","8. If the distribution and/or use of the Program is restricted in certain countries either by patents or by copyrighted interfaces, the original copyright holder who places the Program under this License may add an explicit geographical distribution limitation excluding those countries, so that distribution is permitted only in or among countries not thus excluded. In such case, this License incorporates the limitation as if written in the body of this License.","9. The Free Software Foundation may publish revised and/or new versions of the General Public License from time to time. Such new versions will be similar in spirit to the present version, but may differ in detail to address new problems or concerns.","Each version is given a distinguishing version number. If the Program specifies a version number of this License which applies to it and &quot;any later version&quot;, you have the option of following the terms and conditions either of that version or of any later version published by the Free Software Foundation. If the Program does not specify a version number of this License, you may choose any version ever published by the Free Software Foundation.","10. If you wish to incorporate parts of the Program into other free programs whose distribution conditions are different, write to the author to ask for permission. For software which is copyrighted by the Free Software Foundation, write to the Free Software Foundation; we sometimes make exceptions for this. Our decision will be guided by the two goals of preserving the free status of all derivatives of our free software and of promoting the sharing and reuse of software generally.","NO WARRANTY","11. BECAUSE THE PROGRAM IS LICENSED FREE OF CHARGE, THERE IS NO WARRANTY FOR THE PROGRAM, TO THE EXTENT PERMITTED BY APPLICABLE LAW. EXCEPT WHEN OTHERWISE STATED IN WRITING THE COPYRIGHT HOLDERS AND/OR OTHER PARTIES PROVIDE THE PROGRAM &quot;AS IS&quot; WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE. THE ENTIRE RISK AS TO THE QUALITY AND PERFORMANCE OF THE PROGRAM IS WITH YOU. SHOULD THE PROGRAM PROVE DEFECTIVE, YOU ASSUME THE COST OF ALL NECESSARY SERVICING, REPAIR OR CORRECTION.","12. IN NO EVENT UNLESS REQUIRED BY APPLICABLE LAW OR AGREED TO IN WRITING WILL ANY COPYRIGHT HOLDER, OR ANY OTHER PARTY WHO MAY MODIFY AND/OR REDISTRIBUTE THE PROGRAM AS PERMITTED ABOVE, BE LIABLE TO YOU FOR DAMAGES, INCLUDING ANY GENERAL, SPECIAL, INCIDENTAL OR CONSEQUENTIAL DAMAGES ARISING OUT OF THE USE OR INABILITY TO USE THE PROGRAM (INCLUDING BUT NOT LIMITED TO LOSS OF DATA OR DATA BEING RENDERED INACCURATE OR LOSSES SUSTAINED BY YOU OR THIRD PARTIES OR A FAILURE OF THE PROGRAM TO OPERATE WITH ANY OTHER PROGRAMS), EVEN IF SUCH HOLDER OR OTHER PARTY HAS BEEN ADVISED OF THE POSSIBILITY OF SUCH DAMAGES.","END OF TERMS AND CONDITIONS","GNU General Public License (GPL), Version 2<br /> (Primavera P6 EPPM Licensing Information User Manual)","English\\licensing_information\\p6_eppm_licensing_information\\98809.htm");
var PageCount=48;


/*
Date: 12/12/2025 10:15 AM
Source: EPPM_25_dev
BookID: 88597
PubProduct: PRIMAVERA_EPPM
BookTitle: Licensing Information User Manual
Version: Version 25
Lang:	en
*/
/* relative_path_for_link: English\Upgrading\p6_eppm_manual_upgrade_sql_server*** */
/* BookTitleTop: Primavera P6 EPPM Manual Upgrade Guide (Microsoft SQL Server Database) for On-Premises*** */
/* Generated with Author-it 23.4.1.30004  12/8/2025 10:24:30 AM */
Page[490]=new Array("Title and Copyright Information","Copyright  1999,  2025, Oracle and/or its affiliates.","Primary Author: Oracle Corporation","Title and Copyright Information<br /> (Primavera P6 EPPM Manual Upgrade Guide (Microsoft SQL Server Database) for On-Premises)","English\\Upgrading\\p6_eppm_manual_upgrade_sql_server\\46576.htm");
Page[491]=new Array("Scope","This guide describes how to manually convert your P6 version 7.0 or later database to P6 EPPM. Complete the following sections in the order specified: ","Back up the existing P6 database (also known as PMDB).","If you are upgrading from Version 7.0, migrate all your methodologies. You cannot use Project Architect after you upgrade, so you will want to migrate your methodologies before you upgrade. (See Converting Methodologies to Projects and Creating a Project Template From Projects for manual migration instructions.) ","Run the appropriate scripts to upgrade the P6 database structure to P6 EPPM.","Perform required and recommended processes after the upgrade is complete. ","To configure an Oracle database server for SSL, see the Advanced Security Administrator's Guide included with the Oracle Database Server Documentation for configuring the Oracle Server and Oracle Client(s) for SSL.","To configure a SQL database server for SSL, use Microsoft's documentation for instructions on configuring SQL Database Server SSL. Direct questions about Installation / Configurations to the database vendor, Microsoft.","Note Prior to 15.1, any user who was granted P6 Professional module access could access both P6 Professional and P6 Visualizer applications. When you upgrade your instance of P6 EPPM to the current release, users who have P6 Professional module access will also be granted a separate P6 Visualizer module access. For more information about module access rights, see P6 Reference Manual.","Audience","Database administrators should use this guide.","Using This Guide","This guide assumes you can perform common database administration procedures and have experience using the command line.","About This Guide<br /> (Primavera P6 EPPM Manual Upgrade Guide (Microsoft SQL Server Database) for On-Premises)","English\\Upgrading\\p6_eppm_manual_upgrade_sql_server\\46869.htm");
Page[492]=new Array("You can upgrade your existing P6 EPPM database (version 7.0 and later) to the current release. You must upgrade your P6 EPPM database so it will work with the new version.","Database Upgrade Considerations for P6 EPPM<br /> (Primavera P6 EPPM Manual Upgrade Guide (Microsoft SQL Server Database) for On-Premises)","English\\Upgrading\\p6_eppm_manual_upgrade_sql_server\\46884.htm");
Page[493]=new Array("The following list summarizes requirements to upgrade from P6 EPPM R8.0 or later:","Back up your P6 EPPM database before beginning the upgrade process to ensure you will not lose any data due to unexpected problems. You should back up your database before you perform any of the steps in this document since the upgrade is not reversible. If you are unsure how to back up your database, do not proceed with the upgrade. Contact your database administrator or database vendor for assistance with backing up your database before performing the database upgrade. ","Manually run all scripts required to upgrade your existing P6 EPPM database.","Test the new database to ensure that the upgrade succeeded.","Requirements to Manually Upgrade from Version 8 or Later<br /> (Primavera P6 EPPM Manual Upgrade Guide (Microsoft SQL Server Database) for On-Premises)","English\\Upgrading\\p6_eppm_manual_upgrade_sql_server\\49796.htm");
Page[494]=new Array("You must upgrade your P6 EPPM database so it will work with the new version. The following list summarizes the procedures required to manually upgrade your database from P6 EPPM version 7.0:","Note","All risk data fields are migrated when upgrading; existing fields are mapped to new fields and others will be mapped to text fields. See Risks Migration for more information.","Back up your P6 EPPM database before beginning the upgrade process to ensure you will not lose any data due to unexpected problems. You should back up your database before you perform any of the steps in this document since the upgrade is not reversible. If you are unsure how to back up your database, do not proceed with the upgrade. Contact your database administrator or database vendor for assistance with backing up your database before performing the database upgrade. ","Manually run all scripts required to upgrade your existing P6 EPPM database.","Test the new database to ensure that the upgrade succeeded.","See Data Not Migrated During P6 EPPM Database Upgrade for details on what information will not migrate.","Convert your Methodology Management data to projects before you upgrade P6 EPPM. See Converting Methodologies to Projects and Creating a Project Template From Projects for manual migration instructions.","Cautions:","If you are a current Apache JackRabbit user and want to upgrade to the latest version of P6 EPPM, JackRabbit documents data will not migrate automatically. Refer to My Oracle Support's Knowledge Articles for information on manually migrating JackRabbit documents to Oracle Universal Content Management. Oracle recommends that you migrate the data before upgrading.","If you are a current jBPM user and want to upgrade P6 EPPM, workflows and reviews data will not be available. You should close all workflows and reviews that are in progress before upgrading. You cannot migrate any of this data to the latest version of P6 EPPM.","Requirements to Manually Upgrade from Version 7<br /> (Primavera P6 EPPM Manual Upgrade Guide (Microsoft SQL Server Database) for On-Premises)","English\\Upgrading\\p6_eppm_manual_upgrade_sql_server\\49793.htm");
Page[495]=new Array("Consider the following tips before you manually upgrade P6 EPPM:","User Name and Password Tips","All new users must create a password with at least one character, regardless of whether Password Policy is enabled. P6 EPPM will prompt existing users to follow the new requirement if they reset their password and the Password Policy is disabled.","The ADMUSER role must have DBA privileges when upgrading or applying patches.","Security Tips","P6 EPPM includes an encryption algorithm that provides enhanced security for private database logins; however, when you manually configure your database, the database does not automatically enforce the encryption algorithm. If you manually configure your database, Oracle recommends that you use this encryption algorithm. To do so, you must reset the private database login. See Resetting Private Database Passwords for instructions. If automatically installing or upgrading your database, you do not need to configure the encryption algorithm. User logins and passwords are not affected.","Starting with P6 EPPM R8, P6 performs all user security and administration. Due to this change, all Admin Superusers receive Projects module access during the upgrade.","To configure an Oracle database server for SSL, see the Advanced Security Administrator's Guide included with the Oracle Database Server Documentation for configuring the Oracle Server and Oracle Client(s) for SSL.","To configure a SQL database server for SSL, use Microsoft's documentation for instructions on configuring SQL Database Server SSL. Direct questions about Installation / Configurations to the database vendor, Microsoft.","Application Tips","P6 EPPM does not support Summary-Only projects. During the P6 EPPM database upgrade, existing Summary-Only projects convert to standard projects, but lose all summary data. You can import the summary project from Microsoft Project into the converted blank project, then summarize the data. See the P6 Professional Help.","P6 Professional no longer performs recurring job services. Use the Windows command line interface to run batch reports and export projects as a service. To view P6 Professional reports in P6, select the &quot;Store report in Work Products and Documents&quot; option when creating report batches or printing reports. See the P6 Professional Help for more information.","ANSI_PADDING for a Microsoft SQL Server Database Tips","To prevent duplicate values in P6 EPPM modules appearing due to leading or trailing spaces, ensure that the ANSI_PADDING setting in Microsoft SQL Server is Off. For example, if one user enters &quot;Equipment&quot; and another user enters &quot; Equipment&quot; (with a leading space) for resource codes, the database will store both of these as valid values if ANSI_PADDING is On. If ANSI_PADDING is Off, the database will remove the leading space in the second entry and tell the user to enter a unique ID. See the documentation included with Microsoft SQL Server for more information.","P6 EPPM Manual Upgrade Tips<br /> (Primavera P6 EPPM Manual Upgrade Guide (Microsoft SQL Server Database) for On-Premises)","English\\Upgrading\\p6_eppm_manual_upgrade_sql_server\\95932.htm");
Page[496]=new Array("When upgrading P6 EPPM, the following data will not migrate from previous releases:","When upgrading from 16 R1 or earlier, SharePoint configuration details in Primavera P6 Administrator are not automatically migrated to the CMIS configuration settings in Primavera P6 Administrator.","When upgrading from 16 R1 or earlier, AutoVue markup and rendition does not migrate if upgrading from a configuration with VueLink enabled to a configuration without VueLink enabled. If you want to retain AutoVue markup and rendition with VueLink enabled, ensure VueLink is enabled when upgrading.","When upgrading from 16 R1 or earlier, AutoVue configuration details that are associated with a specific content repository in Primavera P6 Administrator will not migrate to the new location of the AutoVue configuration settings in Primavera P6 Administrator.","Workflows Repository (supported configuration changed from jBPM to Oracle BPM).","Content Repository (if previously an Apache JackRabbit user). Refer to Knowledge Articles on My Oracle Support for information on manually migrating JackRabbit documents to Oracle Universal Content Management.","Top Down Estimation, including estimated weights (removed).","Issue Form Categories (removed).","Summary Data (new summary tables incompatible with old summary tables). Refer to My Oracle Support's Knowledge Articles for information on manually migrating Scenarios data to the new summary tables.","Methodology Management (replaced with Project Templates). See Converting Methodologies to Projects and Creating a Project Template From Projects for manual migration instructions.","Data Not Migrated During P6 EPPM Database Upgrade<br /> (Primavera P6 EPPM Manual Upgrade Guide (Microsoft SQL Server Database) for On-Premises)","English\\Upgrading\\p6_eppm_manual_upgrade_sql_server\\45315.htm");
Page[497]=new Array("The following table illustrates the risks data field mapping when upgrading from P6 EPPM database (7.0 or 7.0 service packs).","Note Some fields will migrate to text fields instead of new fields because certain fields no longer correspond. The new text fields are noted below.","Risks Fields Migration Table","P6 EPPM database (version 7.0 and 7.0 service packs) Risks Fields","P6 EPPM Risks Field","Risk Id","id","risk_name","name","risk_descr","description","status_code","status","risk_type_id","category_id","risk_control","Note","table_name","table_name","wbs_id","cause (with heading 'Applies to WBS' &lt;WBS name&gt;)","rsrc_id","cause (with heading 'Applies to Resource' &lt;resource name&gt;)","obs_id","cause (with heading 'Responsible Manager' &lt;OBS name&gt;)","priority_type","cause (with heading 'Priority' &lt;priority type&gt;)","add_date","cause (with heading 'Date Identified' &lt;add_date in mmm-dd-yyyy format &gt;)","impact_date","cause (with heading 'Date Identified' &lt;add_date in mmm-dd-yyyy format &gt;)","prbly_pct","cause (with heading 'Probability' &lt;prbly_pct&gt;)","impact_work_qty","cause (with heading 'Impact - Labor Units' &lt;impact_work_qty&gt; - 2 decimals)","impact_equip_qty","cause (with heading 'Impact - Nonlabor Units' &lt;impact_equip_qty&gt; - 2 decimals)","impact_mat_qty","cause (with heading 'Impact - Material Units' &lt;impact_mat_qty&gt; - 2 decimals)","Impact_expense_cost","cause (with heading 'Impact - Expenses' &lt;impact_expense_cost&gt; - 2 decimals)","Risks Migration<br /> (Primavera P6 EPPM Manual Upgrade Guide (Microsoft SQL Server Database) for On-Premises)","English\\Upgrading\\p6_eppm_manual_upgrade_sql_server\\38528.htm");
Page[498]=new Array("Perform the tasks in the following topics before upgrading your database.","Pre-Upgrade Procedures<br /> (Primavera P6 EPPM Manual Upgrade Guide (Microsoft SQL Server Database) for On-Premises)","English\\Upgrading\\p6_eppm_manual_upgrade_sql_server\\55267.htm");
Page[499]=new Array("Use the validate tool to ensure your database is not missing objects that could cause the database to fail to upgrade. You must perform the steps below before you download the latest media pack. For example, if you are attempting to upgrade to Version 25 and you run the Version 25 validate tool against a version 20 database, then the validate tool will not work.","Double-click validate.bat&nbsp;(validate.sh for Linux) in your current Database folder of the P6 EPPM physical media or download to start the validate tool.","Provide the following:","In the Database host address field, enter the server machine name or IP address where you installed Microsoft SQL Server.","In the Database host port field, enter the port number that Microsoft SQL Server is using. The default is 1433.","In the Database name field, enter the name of the existing database that you want to validate.","View the HTML page that the tool creates to ensure your database is not missing objects.","If your database is missing objects, do one of the following:","If upgrading from 7.0, go to the 'Client Application' media pack, then locate the \\install\\database\\scripts\\ folder to find the scripts you need to fix.","If upgrading from 8.0 or later go to the database folder of the P6 EPPM physical media or download, then locate the \\database\\scripts\\install\\ to find the scripts you need to fix.","Running the Validate Tool for a Microsoft SQL Server Database<br /> (Primavera P6 EPPM Manual Upgrade Guide (Microsoft SQL Server Database) for On-Premises)","English\\Upgrading\\p6_eppm_manual_upgrade_sql_server\\50529.htm");
Page[500]=new Array("To migrate Methodology Management version 7.0 data to the latest P6 Project Templates, you must first use Project Architect in the Project Management module to convert the data from a methodology to a project.","To convert Methodology Management data to a project:","Create a new EPS node in P6 Professional version 7.0 where you can store all your Methodology Management projects.","Use Project Architect in P6 Professional version 7.0 to create projects from Methodology Management data. For more information on using Project Architect, see version 7.0 of the Oracle Primavera P6 Project Management Reference Manual.","Note You can create only one project at a time. If you want all of your Methodology Management data moved to P6 Project Templates, contact Oracle Consulting to automate the process.","After you have converted all your Methodology Management data to projects, upgrade P6 EPPM.","Launch P6.","Convert your upgraded projects (formerly methodologies) to project templates. See Creating a Project Template From Projects.","Converting Methodologies to Projects<br /> (Primavera P6 EPPM Manual Upgrade Guide (Microsoft SQL Server Database) for On-Premises)","English\\Upgrading\\p6_eppm_manual_upgrade_sql_server\\44845.htm");
Page[501]=new Array("jobsvc.job_data_x is used to store XML data for XML import processes using the Varbinary(Max) datatype. In order to support the Varbinary(Max) datatype, you must enable FILESTREAM. For information on how to enable FILESTREAM, refer to the Microsoft SQL Server documentation for your version.","Enabling FILESTREAM<br /> (Primavera P6 EPPM Manual Upgrade Guide (Microsoft SQL Server Database) for On-Premises)","English\\Upgrading\\p6_eppm_manual_upgrade_sql_server\\91972.htm");
Page[502]=new Array("To upgrade the P6 EPPM Microsoft SQL Server Database:","If you haven't done so, download the Primavera P6 Enterprise Project Portfolio Management R&lt;release_level&gt; for &lt;platform&gt; folder and extract the contents.","Go to the location of the extracted contents and locate the P6_R&lt;release_level&gt;\\p6suite\\database folder.","Note","Make a backup copy of any files you will modify before you edit them.","You need to run all the scripts included in this section against PMDB to upgrade.","Open Microsoft SQL Server Management Studio and log in as the SA user.","Go to \\scripts\\install\\PM_&lt;release_level&gt; and run the sspm_create_plus_users.sql script.","Note","Running the sspm_create_plus_users.sql script creates the following user name: PxRptUser. If you have created another user name and wish to use that when running P6 EPPM database scripts, make sure to replace the PxRptUser name with your custom user name in all applicable scripts before running them.","Do not use special characters in the database name, privileged user, public user, or PX reporting user name, for example: { } [ ] : ; &lt; &gt; , . ? ! @ # $ % ^ &amp; * ( ) - _ | / \\ ~ `","Go to scripts\\common and run the ss_disable_triggers.sql script.","Go to \\scripts\\upgrade\\PM_&lt;release_level&gt; on your local drive. Run one of the following scripts that is closest to the version of P6 EPPM that you are trying to upgrade:","SSPM_p70sp1.sql, if upgrading from P6 version 7.0, 7.0 service pack 1, or 7.0 service pack 2","SSPM_p70sp3.sql, if upgrading from P6 version 7.0 service pack 3","SSPM_p70sp5.sql, if upgrading from P6 version 7.0 service pack 5","SSPM_p80.sql, if upgrading from P6 version 8.0","SSPM_p81.sql, if upgrading from P6 version 8.1","SSPM_p81sp3.sql, if upgrading from P6 version 8.1 service pack 3","SSPM_p82.sql, if upgrading from P6 version 8.2","SSPM_p82sp1.sql, if upgrading from P6 version 8.2 service pack 1","SSPM_p82sp2.sql, if upgrading from P6 version 8.2 service pack 2","SSPM_p82sp2f10.sql, if upgrading from P6 version 8.2 service pack 2 Hotfix 10","SSPM_p83.sql, if upgrading from P6 version 8.3","SSPM_p832.sql, if upgrading from P6 version 8.3 service pack 2","SSPM_p833.sql, if upgrading from P6 version 8.3 service pack 3","SSPM_p834.sql, if upgrading from P6 version 8.3 service pack 4","SSPM_p835.sql, if upgrading from P6 versions 8.3 service pack 5","SSPM_P84.sql, if upgrading from P6 version 8.4","SSPM_p841.sql, if upgrading from P6 versions 8.4 patch set 1","SSPM_p843.sql, if upgrading from P6 versions 8.4 patch set 3","SSPM_P151.sql, if upgrading from P6 version 15.1","SSPM_P152.sql, if upgrading from P6 version 15 R2","SSPM_P161.sql, if upgrading from P6 version 16 R1","SSPM_P162.sql, if upgrading from P6 version 16 R2","If you are using version 7.0 or later, skip to the next step.","If you are using version 6.21 or earlier, go to \\scripts\\common and run the ss_update_usereng.sql script to grant all users with P6 Professional module access rights to the Projects section in P6.","NotePrior to P6 version 7.0, users with Project Management module access also had rights to the Projects section in P6 Web Access. For security reasons, beginning with P6 version 7.0, P6 Professional module access only grants rights to log into the P6 Professional module.","Go to \\scripts\\common and run the ss_post_upgrade script.","Go to \\scripts\\upgrade\\PM_&lt;release_level&gt; and run the sspm_grants.sql script.","Note If you changed the default user names, you must update the privuser, pubuser, and PxRptUser names in this script with your custom user names.","Go to \\scripts\\upgrade\\PM_&lt;release_level&gt; and run the sspm_synonyms.sql script.","Caution: The sspm_synonyms.sql script contains a table called PUBUSER, do not replace it if you have changed the pubuser user name.","Note If you changed the default user names, you must update the privuser, pubuser, and PxRptUser names in this script with your custom user names.","Go to \\scripts\\source\\PM_&lt;release_level&gt; and run the sspm_src.plb script.","Note","If you changed the default privuser name, you must update the sspm_src.plb script with your custom privuser name.","Do not use special characters in the database name, privileged user, public user, or PX reporting user name, for example: { } [ ] : ; &lt; &gt; , . ? ! @ # $ % ^ &amp; * ( ) - _ | / \\ ~ `","Go to \\scripts\\install\\PM_&lt;release_level&gt; and run the sspm_database_version.sql and sspm_querylib.sql scripts.","Go to \\scripts\\common and run the ss_enable_constraints_triggers.sql script.","Go to \\scripts\\install\\PM_&lt;release_level&gt; and run the sspm_init_bgjobs.sql script.","Run the databaselogins.bat (on Windows) or databaselogins.sh (on Unix) to upgrade the encryption of privilege user passwords.","Log into the P6 EPPM database as PxRptUser or use your custom PX reporting user name if you created one.","Go to scripts\\source\\PM_&lt;release_level&gt; and run the sspm_px_rpt_src.sql script.","Upgrading the P6 EPPM Microsoft SQL Server Database<br /> (Primavera P6 EPPM Manual Upgrade Guide (Microsoft SQL Server Database) for On-Premises)","English\\Upgrading\\p6_eppm_manual_upgrade_sql_server\\46883.htm");
Page[503]=new Array("Consider the following after you upgrade your database.","Post-Upgrade Procedures<br /> (Primavera P6 EPPM Manual Upgrade Guide (Microsoft SQL Server Database) for On-Premises)","English\\Upgrading\\p6_eppm_manual_upgrade_sql_server\\55271.htm");
Page[504]=new Array("After you have converted your Methodology Management data to projects and upgraded your database, you can create your project templates.","To create a project template:","Click Projects.","On the Projects navigation bar, click EPS.","On the EPS page, click the Actions&nbsp;@ menu and select Add&nbsp;@ Add Project Template.","In the Add Project Template dialog box, choose the General tab.","On the General tab:","In the Template ID field, type in a unique ID for the template.","In the Template Name field, type in a unique name for the template.","In the EPS field, click the corresponding @ and choose the EPS where you want to store the template.","In the Responsible Manager field, click the corresponding @ and choose a responsible manager.","In the Copy from existing project or template field, click the corresponding @ and choose the methodology project you created in Converting Methodologies to Projects.","Click Create.","Creating a Project Template From Projects<br /> (Primavera P6 EPPM Manual Upgrade Guide (Microsoft SQL Server Database) for On-Premises)","English\\Upgrading\\p6_eppm_manual_upgrade_sql_server\\44847.htm");
Page[505]=new Array("From release 18, classic views are no longer available in P6. You can export classic views to import them as standard views. When you import the exported classic views, they are imported as user views. To make the newly imported views accessible to other users, you can cut or copy and paste the views to the Global or Multiple Users groups.","Note Although classic views can no longer be used from release 18, they are not removed from the database during the upgrade process and can still be exported after upgrade.","To convert classic views to standard views:","Click Projects or Resources.","On the Projects navigation bar, click Activities, EPS, or Assignments.","On the Resources navigation bar, click Assignments.","Click the Views&nbsp;@ menu and select Import/Export Views....","In the Import/Export Views dialog box:","Click Export.","Select the Classic Views option.","Select the views you want to export.","Click Export.","Click the Views&nbsp;@ menu and select Import/Export Views....","In the Import/Export Views dialog box:","Click Import.","In the File field, click @&nbsp;Browse and select the file you exported.","Select the views to import.","Click Import.","Tip","When you export classic views, they are exported to a file in your default download location. The file name includes the name of the page the views were exported from, your user name, and the date and time the file was exported. The file extension is .json.","You can export classic views from the EPS, Activities, and Assignments pages and convert them to standard views on each of those pages. You cannot export views from multiple pages into one file.","Some classic view settings cannot be converted to standard views, for example bar color coding. These settings will be lost when you convert your classic views into standard views.","Converting Classic Views to Standard Views<br /> (Primavera P6 EPPM Manual Upgrade Guide (Microsoft SQL Server Database) for On-Premises)","English\\Upgrading\\p6_eppm_manual_upgrade_sql_server\\98724.htm");
Page[506]=new Array("The following list summarizes the procedures to perform after the P6 EPPM upgrade:","Backup Procedures","Oracle recommends you make a backup of your newly upgraded database.","User Name and Password Procedures","For security reasons, Oracle strongly recommends that you replace the default database users' (admuser, privuser, pubuser, bgjobuser, and pxrptuser) passwords immediately after a manual database installation or an upgrade from P6 version 7.0. Do not use special characters in the database name, privileged user, public user, or PX reporting user name, for example: { } [ ] : ; &lt; &gt; , . ? ! @ # $ % ^ &amp; * ( ) - _ | / \\ ~ `","For instructions on how to replace the private database login, follow the instructions in Modifying Private Database Logins for P6 EPPM. For all other database user names and passwords, use the tools included with the database. The background job user has to be reset only for manual installations. ","Oracle recommends using strong passwords. Strong passwords in P6 EPPM contain between 8 and 20 characters and at least one numeric and one alpha character. To further strengthen the password, use a mixture of upper and lower case letters.","Application Configuration Procedures","Install the new P6, P6 Professional, and any additional components.","Starting with P6 EPPM R8, all recurring job service functions are hosted by P6. Due to this change, after upgrading to P6 EPPM R8 or later, you must configure Scheduled Services settings in the Primavera P6 Administrator to use this functionality. See the P6 EPPM System Administration Guide for details.","Assign new or modified privileges to users. See information about security profiles in the P6 EPPM Application Administration Guide.","Security Procedures","For security reasons, Oracle strongly recommends that on-premises users replace the default Admin Superuser (admin) immediately after a manual database installation or an upgrade from P6 version 7.0 and earlier. See information on the default Admin Superuser in the P6 EPPM Application Administration Guide for guidelines on this process. See the P6 EPPM Application Administration Guide for details on the default admin superuser.","Requirements After the Upgrade from P6 EPPM R8 or later<br /> (Primavera P6 EPPM Manual Upgrade Guide (Microsoft SQL Server Database) for On-Premises)","English\\Upgrading\\p6_eppm_manual_upgrade_sql_server\\49798.htm");
Page[507]=new Array("The following list summarizes the procedures you need to perform after the P6 EPPM upgrade:","Backup Procedures","Oracle recommends that you make a backup of your newly upgraded database.","User Name and Password Procedures","For security reasons, Oracle strongly recommends you replace the default database users' (admuser, privuser, pubuser, bgjobuser, and pxrptuser) passwords immediately after a manual database installation or an upgrade from P6 version 7.0. Do not use special characters in the database name, privileged user, public user, or PX reporting user name, for example: { } [ ] : ; &lt; &gt; , . ? ! @ # $ % ^ &amp; * ( ) - _ | / \\ ~ ` ","For instructions on how to replace the private database login, follow the instructions in Modifying Private Database Logins for P6 EPPM. For all other database user names and passwords, use the tools included with Oracle Database. The background job user has to be reset only for manual installations. ","Oracle recommends using strong passwords. Strong passwords in P6 EPPM contain between 8 and 20 characters and at least one numeric and one alpha character. To further strengthen the password, use a mixture of upper and lower case letters.","Application Configuration Procedures","Install the new P6, P6 Professional, and any additional components.","Starting with P6 EPPM R8, all recurring job service functions are hosted by P6. Due to this change, after upgrading to P6 EPPM R8 or later, you must configure Scheduled Services settings in the Primavera P6 Administrator to use this functionality. See the P6 EPPM System Administration Guide for more information. ","Resummarize all projects to accurately reflect your summary data. See information about configuring a separate server for job services in the P6 EPPM System Administration Guide.","Assign new or modified privileges to users. See information about security profiles in the P6 EPPM Application Administration Guide.","All previously defined module access (except Contributor module access (formerly Team Member)), security profiles, OBS access, and resource security settings will still apply to existing users after the database upgrade. For users who had Contributor and P6 Professional module access, they will keep their access during the database upgrade; however, once you edit these users post-upgrade, P6 will remove Contributor module access to comply with P6 EPPM functionality. The upgrade process will remove only Contributor access during the upgrade if users had Contributor and additional module access assignments other than P6 Professional; all other assignments will remain selected. See the P6 EPPM Application Administration Guide for information on defining module access, security profiles, OBS access, and resource security.","During the upgrade to the latest version of P6 EPPM, some P6 Activity Views settings will reset. After the upgrade, use the Customize Detail Windows feature to modify the settings that should appear for each view. See the P6 Help for information on how to edit Activity Views.","Starting with P6 EPPM R8, P6 saves filter definitions globally. Filters still work for Activity Views, but all standard filter assignments reset during the upgrade. Due to this change, views that had Standard Filters applied will show all activities after the upgrade. Reapply filters after the upgrade finishes. See the P6 Help for information on how to edit Activity Views.","Security Procedures","For security reasons, Oracle strongly recommends that on-premises users replace the default Admin Superuser (admin) immediately after a manual database installation or an upgrade from P6 version 7.0 and earlier. See information on the default Admin Superuser in the P6 EPPM Application Administration Guide for guidelines on this process. See the P6 EPPM Application Administration Guide for information on changing the default admin superuser.","Requirements After the Upgrade from 7.0 to P6 EPPM<br /> (Primavera P6 EPPM Manual Upgrade Guide (Microsoft SQL Server Database) for On-Premises)","English\\Upgrading\\p6_eppm_manual_upgrade_sql_server\\48530.htm");
Page[508]=new Array("The P6 server and P6 Professional components obtain their run-time database connection credentials from a credential configuration table in the P6 EPPM database. The P6 run-time database credentials (known as privuser or P6 private database login) are stored in an encrypted format in this special P6 configuration table. Any time that you change or rotate the privuser password credentials in your Oracle, Oracle Autonomous Database, or MS SQL Server database, you must re-synchronize the stored credentials in the P6 credential table by using the Database Login tool.","Because encryption algorithms are often enhanced in newer releases, Oracle highly recommends that you reset these stored privuser credentials when you perform a major version upgrade of P6 EPPM. By resetting the stored credentials, the new encryption algorithm can be applied to other stored credentials (for example, pubuser) in the P6 EPPM credential table. For information about resetting private database passwords, see Resetting Private Database Passwords.","Note","This tool does not reset database user logins or passwords. Administrators should use SQL Developer or other DBA consoles to set or reset database user passwords.","Private Database Credentials for P6 EPPM<br /> (Primavera P6 EPPM Manual Upgrade Guide (Microsoft SQL Server Database) for On-Premises)","English\\Upgrading\\p6_eppm_manual_upgrade_sql_server\\43428.htm");
Page[509]=new Array("Password encryption algorithms are frequently improved in new releases of P6 Professional and P6 Professional. You should reset private database passwords in order to use improved password encryption algorithms.","To reset private database passwords to use the new encryption algorithm:","Go to P6 EPPM &lt;release_level&gt;\\database or P6 Professional &lt;release_level&gt;\\database.","Run databaselogins.bat (with Windows) databaselogins.sh (with UNIX or Linux).","In the Database Connection dialog box:","Select the database.","Type the user name and password of a privileged database user (for example, privuser). This login should have administrative rights on the database.","Enter the connection details for the database.","For an Oracle Database, enter the host address, host port, and database/instance name specific to your installation. The Port field displays the default port for the database type you selected.","For an Oracle Autonomous Database, enter the location of the unzipped wallet file and the service name.","For a Microsoft SQL Server Database, enter the host address, host port, and database/instance name specific to your installation. The Port field displays the default port for the database type you selected.","Click Next.","In the Private Database Logins dialog box:","Select the private database user name that you wish to reset.","Highlight the password and change it (or re-enter the existing password).","Click Update Password.","Click Save.","Click OK.","Resetting Private Database Passwords<br /> (Primavera P6 EPPM Manual Upgrade Guide (Microsoft SQL Server Database) for On-Premises)","English\\Upgrading\\p6_eppm_manual_upgrade_sql_server\\46563.htm");
Page[510]=new Array("You can update the passwords and usernames of the private database users on your P6 EPPM database. ","To modify private database logins:","Go to P6 EPPM &lt;release_level&gt;\\database and run databaselogins.bat (with Windows) databaselogins.sh (with UNIX or Linux).","On the Database Connection dialog box:","Select the database.","Type the user name and password of a privileged database user (for example, privuser). This login should have administrative rights on the database.","Enter the connection details for the database.","For an Oracle Database, enter the host address, host port, and database/instance name specific to your installation. The Port field displays the default port for the database type you selected.","For an Oracle Autonomous Database, enter the location of the unzipped wallet file and the service name.","For a Microsoft SQL Server Database, enter the host address, host port, and database/instance name specific to your installation. The Port field displays the default port for the database type you selected.","Click Next.","On the Private Database Logins dialog box:","Select the private database user name that you wish to modify.","Enter a new user name.","Highlight the password, and change it.","Click the Update Password button.","Note To reverse a change, click Undo. Undo will reverse any changes made during the current session.","Click Save.","Click OK to exit the Database Logins tool.","Modifying Private Database Logins for P6 EPPM<br /> (Primavera P6 EPPM Manual Upgrade Guide (Microsoft SQL Server Database) for On-Premises)","English\\Upgrading\\p6_eppm_manual_upgrade_sql_server\\46565.htm");
Page[511]=new Array("You can download the media pack that contains the installer and all required install files from the Oracle Software Delivery Cloud website at https://edelivery.oracle.com.","Run setup.exe in the Primavera P6 Enterprise Project Portfolio Management physical media or download to install the following P6 EPPM applications:","Note","You do not have to install all applications; you can pick and choose what you install. However, you must install P6 to run the other P6 EPPM applications.","P6 Team Member (includes P6 Team Member Web and Email Statusing Service)","Note","You will need to configure Email Statusing Service separately. The installation wizard will provide the Email Statusing Service files and you will use the config.properties file to set up this service. See the P6 EPPM System Administration Guide.","P6 mobile supports SSL (https) only when it has a certificate signed by a valid authority.","P6 EPPM Web Services","P6 Professional Cloud Connect ","Select the P6 Professional Cloud Connect install option if you plan to use P6 Professional with an P6 EPPM Oracle or Oracle Autonomous Database database on the cloud by connecting to a remote service. The wizard sets up a remote method of access to connect to the EPPM database and the P6 APIs. For more details on establishing the P6 Professional Cloud Connect database connection in P6 Professional, see the P6 Professional Installation and Configuration Guide (P6 EPPM). ","Note The wizard will also install P6 Integration API (in remote mode) by default.","P6 Integration API (remote mode only)","Note Oracle provides a separate installer for P6 Integration API local mode. See the P6 Integration API Configuration Guide.","P6 mobile","Note","P6 mobile apps are downloaded through the Apple App Store or the Google Play Store. See the P6 Team Member User's Guide.","P6 mobile supports SSL (https) only when it has a certificate signed by a valid authority.","Based on whether you are installing or upgrading, see one of the following books:","P6 EPPM Installation and Configuration Guide","P6 EPPM Upgrade and Configuration Guide","Installing P6 EPPM Applications<br /> (Primavera P6 EPPM Manual Upgrade Guide (Microsoft SQL Server Database) for On-Premises)","English\\Upgrading\\p6_eppm_manual_upgrade_sql_server\\53137.htm");
var PageCount=22;


/*
Date: 12/8/2025 10:24 AM
Source: EPPM_25_dev
BookID: 46553
PubProduct: PRIMAVERA_EPPM
BookTitle: Manual Upgrade Guide (Microsoft SQL Server Database) for On-Premises
Version: Version 25
Lang:	en
*/
/* relative_path_for_link: English\Upgrading\p6_eppm_upgrade_config*** */
/* BookTitleTop: Primavera P6 EPPM Upgrade and Configuration Guide for On-Premises*** */
/* Generated with Author-it 23.4.1.30004  12/9/2025 11:49:14 AM */
Page[512]=new Array("Title and Copyright Information","Copyright  1999, 2025, Oracle and/or its affiliates.","Primary Author: Oracle Corporation","Title and Copyright Information<br /> (Primavera P6 EPPM Upgrade and Configuration Guide for On-Premises)","English\\Upgrading\\p6_eppm_upgrade_config\\46576.htm");
Page[513]=new Array("Scope","This guide describes how to automatically upgrade and configure your applications. Before you begin, read through the Prerequisites for P6 EPPM Configuration.","Upgrading P6 EPPM","Note","Before installing P6 EPPM, run the script, manual_script_before_upgrade.sql located in the p6suite\\database\\scripts\\install\\PM_&lt;release_level&gt;folder of the physical media to minimize the configuration change on the Oracle database server.","You should upgrade all of your applications to the latest version to ensure they work together.","Use setup.exe in the Primavera P6 Enterprise Project Portfolio Management physical media or download to install the following P6 EPPM applications:","P6 (and its help and tutorials)","P6 Team Member (includes P6 Team Member Web and Email Statusing Service)","P6 mobile (includes P6 for iOS and P6 for Android)","P6 Professional Cloud Connect","P6 EPPM Web Services","P6 Integration API","Note The wizard upgrades the remote P6 Integration API. If you want to use the local mode P6 Integration API, see the P6 Integration API Configuration Guide.","Configuring P6 EPPM","Use the P6 EPPM Configuration Wizard to configure P6 EPPM. The P6 EPPM Configuration Wizard is a wizard that you can use to create or update a P6 configuration in Primavera P6 Administrator and to configure:","A connection to an Oracle or Microsoft SQL Server database","A WebLogic domain","Connections to optional enabling technologies, such as a content repository (Oracle Webcenter Content Core Capabilities, Microsoft SharePoint, Oracle Database, or a CMIS-compliant repositories), BIP, and or BPM","Note","The SharePoint connector has been removed from version 16.1 and later. New SharePoint users should configure SharePoint with a CMIS-compliant content repository, and then configure P6 EPPM to the CMIS-compliant content repository. ","Do not reconfigure SharePoint with a CMIS-compliant content repository if you previously configured your SharePoint connection using the Primavera P6 Administrator and SharePoint connector. Reconfiguring SharePoint with a CMIS repository will prevent previously stored documents from being visible. For more information, refer to documentation from Version 16.","By default, the P6 EPPM Configuration Wizard runs automatically after you upgrade your P6 EPPM applications. If you need to manually launch the P6 EPPM Configuration Wizard, use eppmconfig.cmd(.sh) from the P6 EPPM installation folder at C:\\P6EPPM_1\\p6.","After you use the P6 EPPM Configuration Wizard, use Primavera P6 Administrator to configure P6 EPPM administration settings. For more information about Primavera P6 Administrator, see the P6 EPPM System Administrator's Guide.","Audience","Database administrators should use this guide.","Using This Guide","This guide assumes you have already installed P6 EPPM applications and a supported database. For more information, see: ","Tested Configurations","P6 EPPM Installation and Configuration Guide","About This Guide<br /> (Primavera P6 EPPM Upgrade and Configuration Guide for On-Premises)","English\\Upgrading\\p6_eppm_upgrade_config\\53682.htm");
Page[514]=new Array("Read this chapter to upgrade your P6 EPPM database to the latest version  when version 6.2.1 or later is already installed. You need to upgrade your database if you want to preserve your project data to use with the new version of P6 EPPM.&nbsp;A wizard automatically upgrades your database for you.","Oracle recommends that you upgrade your database automatically; however, if you want to manually upgrade your database, use the P6 EPPM Manual Upgrade Guide for your database.","Note Prior to 15.1, any user who was granted P6 Professional module access could access both P6 Professional and P6 Visualizer applications. When you upgrade your instance of P6 EPPM to the current release, users who have P6 Professional module access will also be granted a separate P6 Visualizer module access. For more information about module access right, see P6 Reference Manual.","Automatic Database Upgrade Considerations and Prerequisites<br /> (Primavera P6 EPPM Upgrade and Configuration Guide for On-Premises)","English\\Upgrading\\p6_eppm_upgrade_config\\6766.htm");
Page[515]=new Array("You can upgrade your existing P6 EPPM database (version 6.2.1 or later including service packs) to the latest version of P6 EPPM. You must upgrade your P6 EPPM database so it will work with the new version. Use the P6 EPPM Configuration Wizard to upgrade your database automatically. The wizard runs the necessary scripts to upgrade the database structure and an upgrade program to add data required by the new version.","Note These upgrade instructions apply only if you are upgrading from 6.2.1 or later. If you are upgrading from a version earlier than 6.2.1, you cannot directly upgrade to the latest version. For example, if you are on version 5.0, you will need to upgrade to 7.0 before you can upgrade to the latest version.","All risk data fields are migrated when upgrading; existing fields are mapped to new fields and others will be mapped to text fields.","Caution","If you are a current Apache JackRabbit user and want to upgrade to the latest version of P6 EPPM, JackRabbit documents data will not migrate automatically. Refer to My Oracle Support's Knowledge Articles for information on manually migrating JackRabbit documents to Oracle Universal Content Management. Oracle recommends that you migrate the data before upgrading.","If you are a current jBPM user and want to upgrade P6 EPPM, workflows and reviews data will not be available. You should close all workflows and reviews that are in progress before upgrading. You cannot migrate any of this data to the latest version of P6 EPPM.","Database Upgrade Considerations For Version 6.2.1 or Later<br /> (Primavera P6 EPPM Upgrade and Configuration Guide for On-Premises)","English\\Upgrading\\p6_eppm_upgrade_config\\6867.htm");
Page[516]=new Array("The following list summarizes the procedures in the order in which you are required to upgrade from P6 EPPM R8 or later:","Complete the following pre-upgrade procedures:","Back up your P6 EPPM database before beginning the upgrade process to ensure you will not lose any data due to unexpected problems.","Stop the P6 EPPM instance on your application server.","Uninstall the current instance of P6 EPPM.","Grant privileges to the system user by running the manual_script_before_upgrade.sql script.","Run the validate file for the current version of P6 EPPM, which is located in the Database folder of the P6 EPPM physical media or download. Ensure that you do not run the validate file for the latest release.","(Optional) Manually upgrade your database by running dbsetup.bat (for Windows) dbsetup.sh (for UNIX / Linux) which can be found in database folder of your P6 EPPM physical media or download.","Note If you upgrade your P6 EPPM database using dbsetup, then you must connect to an existing database when using the P6 EPPM Configuration Wizard. Alternatively, you can use the P6 EPPM Configuration Wizard to automatically upgrade you database.","Run the P6 EPPM Installation Wizard using setup.exe which can be found in your P6 EPPM physical media or download.","Connect to, or upgrade, an existing P6 EPPM database by using the P6 EPPM Configuration Wizard.","If you chose not to manually upgrade your database using dbsetup, select Upgrade an existing P6 EPPM database.","If you chose to manually upgrade your database using dbsetup, select Connect to an existing P6 EPPM database.","If necessary, update existing configurations.","Restart the P6 EPPM instance on your application server.","Clear your browser cache.","Test the new database to ensure that the upgrade has succeeded.","Requirements to Upgrade Versions 8 or Later<br /> (Primavera P6 EPPM Upgrade and Configuration Guide for On-Premises)","English\\Upgrading\\p6_eppm_upgrade_config\\49782.htm");
Page[517]=new Array("The following list summarizes the procedures required to upgrade from P6 EPPM version 7.0 or earlier (including service packs):","Back up your P6 EPPM database before beginning the upgrade process to ensure you will not lose any data due to unexpected problems. See Data that is Not Migrated during the P6 EPPM Database Upgrade for details on what information will not upgrade.","Run the validate file located in your current Database folder of the P6 EPPM physical media or download.","If you're upgrading from version 7.0 or earlier, convert your Methodology Management data to projects before you upgrade P6 EPPM. See Converting Methodologies to Projects and Creating a Project Template From Projects for manual migration instructions.","Run the P6 EPPM Configuration Wizard to automatically upgrade your existing P6 EPPM database.","Test the new database to ensure that the upgrade succeeded.","Requirements to Upgrade Versions 6.2.1 through 7.0<br /> (Primavera P6 EPPM Upgrade and Configuration Guide for On-Premises)","English\\Upgrading\\p6_eppm_upgrade_config\\49788.htm");
Page[518]=new Array("When upgrading P6 EPPM, the following data will not migrate from previous releases:","When upgrading from 16 R1 or earlier, SharePoint configuration details in Primavera P6 Administrator are not automatically migrated to the CMIS configuration settings in Primavera P6 Administrator.","When upgrading from 16 R1 or earlier, AutoVue markup and rendition does not migrate if upgrading from a configuration with VueLink enabled to a configuration without VueLink enabled. If you want to retain AutoVue markup and rendition with VueLink enabled, ensure VueLink is enabled when upgrading.","When upgrading from 16 R1 or earlier, AutoVue configuration details that are associated with a specific content repository in Primavera P6 Administrator will not migrate to the new location of the AutoVue configuration settings in Primavera P6 Administrator.","Workflows Repository (supported configuration changed from jBPM to Oracle BPM).","Content Repository (if previously an Apache JackRabbit user). Refer to Knowledge Articles on My Oracle Support for information on manually migrating JackRabbit documents to Oracle Universal Content Management.","Top Down Estimation, including estimated weights (removed).","Issue Form Categories (removed).","Summary Data (new summary tables incompatible with old summary tables). Refer to My Oracle Support's Knowledge Articles for information on manually migrating Scenarios data to the new summary tables.","Methodology Management (replaced with Project Templates). See Converting Methodologies to Projects and Creating a Project Template From Projects for manual migration instructions.","Data Not Migrated During P6 EPPM Database Upgrade<br /> (Primavera P6 EPPM Upgrade and Configuration Guide for On-Premises)","English\\Upgrading\\p6_eppm_upgrade_config\\45315.htm");
Page[519]=new Array("Consider the following tips when upgrading:","User Name and Password Tips","All new users must create a password with at least one character, regardless of whether Password Policy is enabled. P6 EPPM will prompt existing users to follow the new requirement if they reset their password and the Password Policy is disabled.","Security Tips","Starting with P6 EPPM R8, P6 performs all user security and administration. Due to this change, all Admin Superusers receive Projects module access during the upgrade.","To configure an Oracle database server for SSL, see the Advanced Security Administrator's Guide included with the Oracle Database Server Documentation for configuring the Oracle Server and Oracle Client(s) for SSL.","To configure the SQL database server for SSL, use Microsoft's documentation for instructions on configuring SQL Database Server SSL. Direct questions about Installation / Configurations to the database vendor, Microsoft.","Application Tips","P6 EPPM does not support Summary-Only projects. During the P6 EPPM database upgrade, existing Summary-Only projects convert to standard projects, but lose all summary data. You can import the summary project from Microsoft Project into the converted blank project, then summarize the data. See the P6 Professional Help or the P6 Help.","P6 Professional no longer performs recurring job services. Use the Windows command line interface to run batch reports and export projects as a service. To view P6 Professional reports in P6, select the &quot;Store report in Work Products and Documents&quot; option when creating report batches or printing reports. See the P6 Professional Help for more information.","ANSI_PADDING for Microsoft SQL Server Database Tips","To prevent duplicate values in P6 EPPM modules appearing due to leading or trailing spaces, ensure that the ANSI_PADDING setting in Microsoft SQL Server is Off. For example, if one user enters &quot;Equipment&quot; and another user enters &quot; Equipment&quot; (with a leading space) for resource codes, the database will store both of these as valid values if ANSI_PADDING is On. If ANSI_PADDING is Off, the database will remove the leading space in the second entry and tell the user to enter a unique ID. See the documentation included with Microsoft SQL Server for more information.","Tips for Upgrading<br /> (Primavera P6 EPPM Upgrade and Configuration Guide for On-Premises)","English\\Upgrading\\p6_eppm_upgrade_config\\49790.htm");
Page[520]=new Array("The following table illustrates the risks data field mapping when upgrading from P6 EPPM database (7.0 or 7.0 service packs).","Note Some fields will migrate to text fields instead of new fields because certain fields no longer correspond. The new text fields are noted below.","Risks Fields Migration Table","P6 EPPM database (version 7.0 and 7.0 service packs) Risks Fields","P6 EPPM Risks Field","Risk Id","id","risk_name","name","risk_descr","description","status_code","status","risk_type_id","category_id","risk_control","Note","table_name","table_name","wbs_id","cause (with heading 'Applies to WBS' &lt;WBS name&gt;)","rsrc_id","cause (with heading 'Applies to Resource' &lt;resource name&gt;)","obs_id","cause (with heading 'Responsible Manager' &lt;OBS name&gt;)","priority_type","cause (with heading 'Priority' &lt;priority type&gt;)","add_date","cause (with heading 'Date Identified' &lt;add_date in mmm-dd-yyyy format &gt;)","impact_date","cause (with heading 'Date Identified' &lt;add_date in mmm-dd-yyyy format &gt;)","prbly_pct","cause (with heading 'Probability' &lt;prbly_pct&gt;)","impact_work_qty","cause (with heading 'Impact - Labor Units' &lt;impact_work_qty&gt; - 2 decimals)","impact_equip_qty","cause (with heading 'Impact - Nonlabor Units' &lt;impact_equip_qty&gt; - 2 decimals)","impact_mat_qty","cause (with heading 'Impact - Material Units' &lt;impact_mat_qty&gt; - 2 decimals)","Impact_expense_cost","cause (with heading 'Impact - Expenses' &lt;impact_expense_cost&gt; - 2 decimals)","Risks Migration<br /> (Primavera P6 EPPM Upgrade and Configuration Guide for On-Premises)","English\\Upgrading\\p6_eppm_upgrade_config\\38528.htm");
Page[521]=new Array("Perform the tasks in the following topics before upgrading your database.","Pre-Upgrade Procedures<br /> (Primavera P6 EPPM Upgrade and Configuration Guide for On-Premises)","English\\Upgrading\\p6_eppm_upgrade_config\\55267.htm");
Page[522]=new Array("You must stop your application server prior to upgrading in order to prevent files that are in use from not being upgraded. In the event that the application server has not been stopped, the upgrade process will fail.","Stopping the Application Server<br /> (Primavera P6 EPPM Upgrade and Configuration Guide for On-Premises)","English\\Upgrading\\p6_eppm_upgrade_config\\89414.htm");
Page[523]=new Array("To stop WebLogic:","Navigate to &lt;weblogic_home&gt;/user_projects/domain/your_domain/bin.","Run stopWeblogic.cmd (for Windows) stopWeblogic.sh (for Linux or UNIX).","If prompted for a user name and password in the WebLogic console window, enter the administrative user name and password you specified when creating the domain.","Note The WebLogic console window that opened when you started WebLogic will close automatically when it has shutdown.","Stopping WebLogic for P6 EPPM Applications<br /> (Primavera P6 EPPM Upgrade and Configuration Guide for On-Premises)","English\\Upgrading\\p6_eppm_upgrade_config\\50096.htm");
Page[524]=new Array("When using an Oracle database, you must install Oracle Multimedia, along with these supporting components: Oracle JVM, Oracle XML DB (XDB), and XML Developer's Kit (XDK). Unless you specify otherwise, all these components automatically get installed with the latest versions of an Oracle database. If you chose not to install these components, you will need to install them before you upgrade P6 EPPM. See the Oracle Multimedia's User's Guide for information on how to install these components.","Installing Oracle Multimedia for an Oracle Database<br /> (Primavera P6 EPPM Upgrade and Configuration Guide for On-Premises)","English\\Upgrading\\p6_eppm_upgrade_config\\61563.htm");
Page[525]=new Array("Before upgrading P6 EPPM on an Oracle or Oracle Autonomous Database, run the following scripts:","Navigate to the following locations, open the designated scripts in a text editor, and modify the schema user references to match your actual schema user names:","\\scripts\\install\\PM_&lt;release level&gt;\\manual_script_before_install.sql","You must apply grant options to the SYSTEM schema user or a custom user associated with the Oracle DBA role. If you plan to use a custom schema user, other than SYSTEM, to complete steps which require a DBA role, then you must update the references to SYSTEM in the script with the new custom schema user associated with the DBA role.","\\scripts\\install\\PM_&lt;release level&gt;\\manual_script_before_upgrade.sql","If you are not using the schema names admuser or pxrptuser, update the references with your actual admuser and pxrptuser names.","Complete the following steps:","From the command line, run the following and provide the password when prompted: sqlplus sys@&lt;db_tns_names_entry&gt; as sysdba","Go to \\scripts\\install\\PM_&lt;release_level&gt; and run the manual_script_before_install.sql script.","From the command line, run the following and provide the password when prompted: sqlplus system@&lt;db_tns_names_entry&gt;","Go to \\scripts\\install\\PM_&lt;release_level&gt; and run the manual_script_before_upgrade.sql script.","Grant Privileges to the SYSTEM User<br /> (Primavera P6 EPPM Upgrade and Configuration Guide for On-Premises)","English\\Upgrading\\p6_eppm_upgrade_config\\85030.htm");
Page[526]=new Array("Use the validate tool to ensure your database is not missing objects that could cause the database to fail to upgrade. You must perform the steps below before you download the latest media pack. For example, if you are attempting to upgrade to Version 25 and you run the Version 25 validate tool against a version 20 database, then the validate tool will not work.","Double-click validate.bat&nbsp;(validate.sh for Linux) in your current Database folder of the P6 EPPM physical media or download to start the validate tool.","Note Schema validation of Oracle Autonomous Databases is not yet supported.","Provide the following:","In the Username field, enter your administrative user name (for example, admuser).","In the Database host address field, enter your database server name or TCP/IP address.","In the Database host port field, enter the port number that Oracle is using. The default is 1521.","In the Database name field, enter the Oracle Service Name. You can find it in the TNSNAMES.ORA file, which you created when you set up the Oracle client.","View the HTML page that the tool creates to ensure your database is not missing objects.","If upgrading from 7.0, go to the 'Client Application' media pack, then locate the \\install\\database\\scripts\\ folder to find the scripts you need to fix.","If upgrading from 8.0 or later, go to the database folder of the P6 EPPM physical media or download, then locate the \\database\\scripts\\install\\ to find the scripts you need to fix.","Running the Validate Tool for a Version 7 or Later Oracle Database<br /> (Primavera P6 EPPM Upgrade and Configuration Guide for On-Premises)","English\\Upgrading\\p6_eppm_upgrade_config\\50527.htm");
Page[527]=new Array("Use the validate tool to ensure your database is not missing objects that could cause the database to fail to upgrade. You must perform the steps below before you download the latest media pack. For example, if you are attempting to upgrade to Version 25 and you run the Version 25 validate tool against a version 20 database, then the validate tool will not work.","Double-click validate.bat&nbsp;(validate.sh for Linux) in your current Database folder of the P6 EPPM physical media or download to start the validate tool.","Provide the following:","In the Database host address field, enter the server machine name or IP address where you installed Microsoft SQL Server.","In the Database host port field, enter the port number that Microsoft SQL Server is using. The default is 1433.","In the Database name field, enter the name of the existing database that you want to validate.","View the HTML page that the tool creates to ensure your database is not missing objects.","If your database is missing objects, do one of the following:","If upgrading from 7.0, go to the 'Client Application' media pack, then locate the \\install\\database\\scripts\\ folder to find the scripts you need to fix.","If upgrading from 8.0 or later go to the database folder of the P6 EPPM physical media or download, then locate the \\database\\scripts\\install\\ to find the scripts you need to fix.","Running the Validate Tool for a Microsoft SQL Server Database<br /> (Primavera P6 EPPM Upgrade and Configuration Guide for On-Premises)","English\\Upgrading\\p6_eppm_upgrade_config\\50529.htm");
Page[528]=new Array("To migrate Methodology Management version 7.0 data to the latest P6 Project Templates, you must first use Project Architect in the Project Management module to convert the data from a methodology to a project.","To convert Methodology Management data to a project:","Create a new EPS node in P6 Professional version 7.0 where you can store all your Methodology Management projects.","Use Project Architect in P6 Professional version 7.0 to create projects from Methodology Management data. For more information on using Project Architect, see version 7.0 of the Oracle Primavera P6 Project Management Reference Manual.","Note You can create only one project at a time. If you want all of your Methodology Management data moved to P6 Project Templates, contact Oracle Consulting to automate the process.","After you have converted all your Methodology Management data to projects, upgrade P6 EPPM.","Launch P6.","Convert your upgraded projects (formerly methodologies) to project templates. See Creating a Project Template From Projects.","Converting Methodologies to Projects<br /> (Primavera P6 EPPM Upgrade and Configuration Guide for On-Premises)","English\\Upgrading\\p6_eppm_upgrade_config\\44845.htm");
Page[529]=new Array("When upgrading the P6 EPPM database for a new version of P6 EPPM, you can either use the P6 EPPM Configuration Wizard that is delivered with the latest media pack or you can use dbsetup.","The P6 EPPM Configuration Wizard streamlines the process of upgrading the P6 EPPM with your WebLogic server and additional components. The P6 EPPM Configuration Wizard uses dbsetup to upgrade your database. For more information about using the P6 EPPM Configuration Wizard, refer to About the P6 EPPM Configuration Wizard.","If you only want to upgrade your database, you can use dbsetup.","To upgrade the P6 EPPM database using dbsetup:","Perform a cold backup and a full database export.","If you are unsure how to back up your Oracle or Oracle Autonomous Database, do not proceed with the upgrade. Contact your database administrator, your database vendor, or Oracle Global Customer Support for assistance in backing up your database before performing the database upgrade. Also, ensure that you are familiar with the process of restoring the backup copy of the database in case you need to do so.","Double-click dbsetup.bat&nbsp;(for Windows) dbsetup.sh (for Linux) in the Database folder of the P6 EPPM physical media or download to start the Database wizard.","Note Click Next on each wizard screen to advance to the next step.","On the Primavera P6 dialog box:","Select Upgrade an existing database in the Database options section.","Select Oracle or Oracle Autonomous Database (ATP) as the Server type.","On the Connection Information dialog box, enter the following information to connect to the database:","In the DBA user name field, enter the database administrator user name. The default is System.","In the DBA password field, enter the password for the DBA user.","Provide databases connection information:","If your database is hosted on an Oracle server:","In the Database host address&nbsp;field, enter the server machine name or IP address where Oracle is installed.","In the Database host port&nbsp;field, enter the port number that Oracle is using. The default is 1521.","In the Database name&nbsp;field, enter the Service Name or SID, depending on your configuration. ","Select the Service Name or SID option, depending on the information you entered in the Database Name field.","In the Keystore Folder field, enter the full path to the keystore file.","If your database is hosted on Oracle Autonomous Database:","In the Database Wallet Location&nbsp;field, enter the path and filename of your database wallet.","In the Database Service list, select your database service.","On the Create New Keystore dialog box, complete the following information:","If a keystore exists, enter the Existing Keystore Password.","If creating a new keystore, select Create New Keystore and enter the keystore credentials.","Note","P6 EPPM databases do not require you to use a keystore.","If there is no existing keystore and you are not creating one, ensure all fields are clear and click Next.","On the Connection Information dialog box, enter the following information:","In the Administrative user name field, enter your administrative user name. The default is admuser.","In the Administrative password field, type the password associated with the user name you entered.","On the Upgrade Options&nbsp;dialog box:","Select your Privileged user name for the database. The default is privuser. ","In the Privileged user password field, type the password associated with the user name that you entered.","Select your Public user name for the database. The default is pubuser.","In the Public user password field, type the password associated with the user name that you entered.","Select your Background job user name for the database. The default is bjobuser. ","In the Background job user password field, type the password associated with the user name that you entered.","On the Upgrade Option dialog box:","Select your PX Reporting User name for the database. The default is, pxrptuser.","In the Px Reporting User Password field, type the password associated with the user name that you entered.","On the Ready to Begin Upgrading Data&nbsp;dialog box:","Choose Yes, upgrade my database. ","Click Upgrade.","The upgrade process could take several minutes, depending on its size.","On the Primavera Database Setup Wizard&nbsp;dialog box, click Next&nbsp;after the process has completed.","NoteIf the database upgrade fails, see PrimaveraDatabaseSetup.log&nbsp;located in the user home directory (for example, C:\\Documents and Settings\\Administrator). Contact Oracle Global Customer Support if you need further assistance.","On the Finish&nbsp;dialog box, click Finish to exit the wizard.","Your database is now ready to use with P6 EPPM.","Upgrading an Oracle or Oracle Autonomous Database P6 EPPM Database<br /> (Primavera P6 EPPM Upgrade and Configuration Guide for On-Premises)","English\\Upgrading\\p6_eppm_upgrade_config\\89411.htm");
Page[530]=new Array("Review and complete the prerequisites before configuring any P6 EPPM applications.","Prerequisites for P6 EPPM Configuration<br /> (Primavera P6 EPPM Upgrade and Configuration Guide for On-Premises)","English\\Upgrading\\p6_eppm_upgrade_config\\12885.htm");
Page[531]=new Array("Before you upgrade, uninstall the products mentioned in the following sections. For most P6 EPPM applications, you can use the Oracle Universal Installer and then delete the applications from WebLogic if needed. You cannot use the Oracle Universal Installer for P6 Team Member 8.1 and Email Statusing Service; for those two applications, see one of the following:","Deleting P6 EPPM 7.0 or Later Applications from WebLogic","Removing Email Statusing Service","Uninstall P6 EPPM 7.0 or Later Applications<br /> (Primavera P6 EPPM Upgrade and Configuration Guide for On-Premises)","English\\Upgrading\\p6_eppm_upgrade_config\\55315.htm");
Page[532]=new Array("This is an optional step. You can also use Oracle Universal Installer to reinstall your P6 EPPM applications for your upgrade. For more information about reinstalling your applications using the Oracle Universal Installer, see Installing P6 EPPM Applications.","To use the Universal Installer to Uninstall P6 EPPM 7.0 or Later:","From the P6 folder of the physical media or download location, run one of the following depending on your system type:","If you are installing on a Microsoft Windows system, navigate to the win\\Disk1\\install directory, and then double-click on the setup.exe file.","If you are installing on a non-Microsoft Windows system, type the following command:","cd Operating System/Disk1/install","Depending on your operating system, replace Operating System in the command above with aix_64-5L, hp_64, hpux_IA64, linux, or solaris_64, then type the following commands:","chmod 755 runInstaller<br />chmod 755 unzip<br />./runInstaller","On the Welcome screen, click Deinstall Products.","On the Inventory dialog box, under the Contents tab, select any P6 EPPM applications you want to uninstall.","Click Remove.","On the Confirmation dialog box, click Yes.","Click Close then Cancel to exit the dialog box and Oracle Universal Installer.","Using Oracle Universal Installer to Uninstall P6 EPPM 7.0 or Later<br /> (Primavera P6 EPPM Upgrade and Configuration Guide for On-Premises)","English\\Upgrading\\p6_eppm_upgrade_config\\55316.htm");
Page[533]=new Array("To delete P6 EPPM applications from WebLogic:","Launch the WebLogic Administration Console.","Note You can open the Administration Console via a web browser using this address: http://serverIP:listenport/console. The default listenport is 7001.","In the Welcome&nbsp;window, log in using the user name and password that you created when you created your WebLogic domain.","In the Change Center&nbsp;pane of the Administration Console, click Lock &amp; Edit.","In the Domain Structure&nbsp;pane, click Deployments.","In the Summary of Deployments&nbsp;pane, in the Control tab:","Select the option next to the application(s) you want to delete.","Click Stop, Force Stop Now.","On the Force Stop Application Assistant pane, click Yes.","In the Summary of Deployments&nbsp;pane, in the Control tab:","Ensure the State column shows Prepared.","Select the option next to  the application(s) you want to delete.","Click Delete.","On the Delete Application Assistant pane, click Yes.","In the Change Center pane, click Activate Changes.","Logout of the Administration Console.","If you will use the same home&nbsp;directory for the new deployments, delete the existing WAR or EAR&nbsp;file from that directory to avoid conflict with the new files.","Deleting P6 EPPM 7.0 or Later Applications from WebLogic<br /> (Primavera P6 EPPM Upgrade and Configuration Guide for On-Premises)","English\\Upgrading\\p6_eppm_upgrade_config\\55317.htm");
Page[534]=new Array("To remove Email Statusing Service:","Locate your Email Statusing Service home directory (for example, EMAIL_HOME).","Create a backup copy of the config.properties file and note the location where you saved it.","Delete the Email Statusing Service home directory.","Removing Email Statusing Service<br /> (Primavera P6 EPPM Upgrade and Configuration Guide for On-Premises)","English\\Upgrading\\p6_eppm_upgrade_config\\55161.htm");
Page[535]=new Array("To install your P6 EPPM applications:","Installing P6 EPPM Applications<br /> (Primavera P6 EPPM Upgrade and Configuration Guide for On-Premises)","English\\Upgrading\\p6_eppm_upgrade_config\\53085.htm");
Page[536]=new Array("WebLogic Server requires that you have a Java Development Kit (JDK) installed on your machine. You must manually download and install the required JDK. For a list of supported JDK versions for P6 EPPM, see the Tested Configurations document. As new releases of the software become available, you can find them at http://www.oracle.com/technetwork/java/archive-139210.html.","JDK Installation<br /> (Primavera P6 EPPM Upgrade and Configuration Guide for On-Premises)","English\\Upgrading\\p6_eppm_upgrade_config\\35523.htm");
Page[537]=new Array("You will need to install WebLogic to deploy P6 EPPM. For supported versions, see the Tested Configurations document. For more information about how to install WebLogic, see http://www.oracle.com/technetwork/middleware/weblogic/documentation/index.html","Note Oracle recommends that you install Oracle Access Manager on a new WebLogic Middleware home.","If existing Middleware applications are installed into the Middleware home (for example, Identity Management), Access Manager will fail to deploy.","Tip","After you finish installing WebLogic, ensure you can run the startNodeManager.cmd (with Windows) or startNodeManager.sh (with UNIX or Linux) before installing P6 EPPM. If you cannot run this file, contact your WebLogic administrator for help.","Installing WebLogic<br /> (Primavera P6 EPPM Upgrade and Configuration Guide for On-Premises)","English\\Upgrading\\p6_eppm_upgrade_config\\35520.htm");
Page[538]=new Array("You can use Oracle, Microsoft SQL Server, or Oracle Autonomous Database on your database server for P6 EPPM deployments. For more information about supported database versions, refer to Tested Configurations. You must install the database server before you can create the P6 EPPM database.","If you are using an Oracle or Oracle Autonomous Database, you must make sure to create a database with the Oracle Text option enabled. Oracle Text supports the Oracle or Oracle Autonomous Database content repository by using standard SQL to index, search, and analyze text and documents stored in the database, in files, and on the web. For more details, refer to the Oracle or Oracle Autonomous Database documentation.","If you are using a Microsoft SQL Server Database, you must make sure that you enable FILESTREAM before attempting your P6 EPPM installation or upgrade. For information about how to enable FILESTREAM, refer to the Microsoft SQL Server documentation for your version.","Note","If you attempt to create a database using an Oracle database, the option to create a container database is enabled by default. If you do not want to create a container database, clear the Create As Container Database option during the database creation process. If you create a container database, you must also create a pluggable database on which to install your P6 EPPM instance.","Oracle Text is enabled by default.","jobsvc.job_data_x is used to store XML data for XML import processes using the Varbinary(Max) datatype. In order to support the Varbinary(Max) datatype, you must enable FILESTREAM.","A SQL database name must not contain a space.","Installing a Database<br /> (Primavera P6 EPPM Upgrade and Configuration Guide for On-Premises)","English\\Upgrading\\p6_eppm_upgrade_config\\61564.htm");
Page[539]=new Array("For an Oracle Autonomous Database, you will need to download the Client Credentials Walle