'use strict';
function search(SearchText, inHeading) {
(function () {
var Page = [];

/* Generated with Author-it 23.4.1.30004  12/9/2025 11:49:14 AM */
Page[0]=new Array("Title and Copyright Information","Copyright  1999, 2025, Oracle and/or its affiliates.","Primary Author: Oracle Corporation","Title and Copyright Information","46576.htm");
Page[1]=new Array("Scope","This guide describes how to automatically upgrade and configure your applications. Before you begin, read through the Prerequisites for P6 EPPM Configuration.","Upgrading P6 EPPM","Note","Before installing P6 EPPM, run the script, manual_script_before_upgrade.sql located in the p6suite\\database\\scripts\\install\\PM_&lt;release_level&gt;folder of the physical media to minimize the configuration change on the Oracle database server.","You should upgrade all of your applications to the latest version to ensure they work together.","Use setup.exe in the Primavera P6 Enterprise Project Portfolio Management physical media or download to install the following P6 EPPM applications:","P6 (and its help and tutorials)","P6 Team Member (includes P6 Team Member Web and Email Statusing Service)","P6 mobile (includes P6 for iOS and P6 for Android)","P6 Professional Cloud Connect","P6 EPPM Web Services","P6 Integration API","Note The wizard upgrades the remote P6 Integration API. If you want to use the local mode P6 Integration API, see the P6 Integration API Configuration Guide.","Configuring P6 EPPM","Use the P6 EPPM Configuration Wizard to configure P6 EPPM. The P6 EPPM Configuration Wizard is a wizard that you can use to create or update a P6 configuration in Primavera P6 Administrator and to configure:","A connection to an Oracle or Microsoft SQL Server database","A WebLogic domain","Connections to optional enabling technologies, such as a content repository (Oracle Webcenter Content Core Capabilities, Microsoft SharePoint, Oracle Database, or a CMIS-compliant repositories), BIP, and or BPM","Note","The SharePoint connector has been removed from version 16.1 and later. New SharePoint users should configure SharePoint with a CMIS-compliant content repository, and then configure P6 EPPM to the CMIS-compliant content repository. ","Do not reconfigure SharePoint with a CMIS-compliant content repository if you previously configured your SharePoint connection using the Primavera P6 Administrator and SharePoint connector. Reconfiguring SharePoint with a CMIS repository will prevent previously stored documents from being visible. For more information, refer to documentation from Version 16.","By default, the P6 EPPM Configuration Wizard runs automatically after you upgrade your P6 EPPM applications. If you need to manually launch the P6 EPPM Configuration Wizard, use eppmconfig.cmd(.sh) from the P6 EPPM installation folder at C:\\P6EPPM_1\\p6.","After you use the P6 EPPM Configuration Wizard, use Primavera P6 Administrator to configure P6 EPPM administration settings. For more information about Primavera P6 Administrator, see the P6 EPPM System Administrator's Guide.","Audience","Database administrators should use this guide.","Using This Guide","This guide assumes you have already installed P6 EPPM applications and a supported database. For more information, see: ","Tested Configurations","P6 EPPM Installation and Configuration Guide","About This Guide","53682.htm");
Page[2]=new Array("Read this chapter to upgrade your P6 EPPM database to the latest version  when version 6.2.1 or later is already installed. You need to upgrade your database if you want to preserve your project data to use with the new version of P6 EPPM.&nbsp;A wizard automatically upgrades your database for you.","Oracle recommends that you upgrade your database automatically; however, if you want to manually upgrade your database, use the P6 EPPM Manual Upgrade Guide for your database.","Note Prior to 15.1, any user who was granted P6 Professional module access could access both P6 Professional and P6 Visualizer applications. When you upgrade your instance of P6 EPPM to the current release, users who have P6 Professional module access will also be granted a separate P6 Visualizer module access. For more information about module access right, see P6 Reference Manual.","Automatic Database Upgrade Considerations and Prerequisites","6766.htm");
Page[3]=new Array("You can upgrade your existing P6 EPPM database (version 6.2.1 or later including service packs) to the latest version of P6 EPPM. You must upgrade your P6 EPPM database so it will work with the new version. Use the P6 EPPM Configuration Wizard to upgrade your database automatically. The wizard runs the necessary scripts to upgrade the database structure and an upgrade program to add data required by the new version.","Note These upgrade instructions apply only if you are upgrading from 6.2.1 or later. If you are upgrading from a version earlier than 6.2.1, you cannot directly upgrade to the latest version. For example, if you are on version 5.0, you will need to upgrade to 7.0 before you can upgrade to the latest version.","All risk data fields are migrated when upgrading; existing fields are mapped to new fields and others will be mapped to text fields.","Caution","If you are a current Apache JackRabbit user and want to upgrade to the latest version of P6 EPPM, JackRabbit documents data will not migrate automatically. Refer to My Oracle Support's Knowledge Articles for information on manually migrating JackRabbit documents to Oracle Universal Content Management. Oracle recommends that you migrate the data before upgrading.","If you are a current jBPM user and want to upgrade P6 EPPM, workflows and reviews data will not be available. You should close all workflows and reviews that are in progress before upgrading. You cannot migrate any of this data to the latest version of P6 EPPM.","Database Upgrade Considerations For Version 6.2.1 or Later","6867.htm");
Page[4]=new Array("The following list summarizes the procedures in the order in which you are required to upgrade from P6 EPPM R8 or later:","Complete the following pre-upgrade procedures:","Back up your P6 EPPM database before beginning the upgrade process to ensure you will not lose any data due to unexpected problems.","Stop the P6 EPPM instance on your application server.","Uninstall the current instance of P6 EPPM.","Grant privileges to the system user by running the manual_script_before_upgrade.sql script.","Run the validate file for the current version of P6 EPPM, which is located in the Database folder of the P6 EPPM physical media or download. Ensure that you do not run the validate file for the latest release.","(Optional) Manually upgrade your database by running dbsetup.bat (for Windows) dbsetup.sh (for UNIX / Linux) which can be found in database folder of your P6 EPPM physical media or download.","Note If you upgrade your P6 EPPM database using dbsetup, then you must connect to an existing database when using the P6 EPPM Configuration Wizard. Alternatively, you can use the P6 EPPM Configuration Wizard to automatically upgrade you database.","Run the P6 EPPM Installation Wizard using setup.exe which can be found in your P6 EPPM physical media or download.","Connect to, or upgrade, an existing P6 EPPM database by using the P6 EPPM Configuration Wizard.","If you chose not to manually upgrade your database using dbsetup, select Upgrade an existing P6 EPPM database.","If you chose to manually upgrade your database using dbsetup, select Connect to an existing P6 EPPM database.","If necessary, update existing configurations.","Restart the P6 EPPM instance on your application server.","Clear your browser cache.","Test the new database to ensure that the upgrade has succeeded.","Requirements to Upgrade Versions 8 or Later","49782.htm");
Page[5]=new Array("The following list summarizes the procedures required to upgrade from P6 EPPM version 7.0 or earlier (including service packs):","Back up your P6 EPPM database before beginning the upgrade process to ensure you will not lose any data due to unexpected problems. See Data that is Not Migrated during the P6 EPPM Database Upgrade for details on what information will not upgrade.","Run the validate file located in your current Database folder of the P6 EPPM physical media or download.","If you're upgrading from version 7.0 or earlier, convert your Methodology Management data to projects before you upgrade P6 EPPM. See Converting Methodologies to Projects and Creating a Project Template From Projects for manual migration instructions.","Run the P6 EPPM Configuration Wizard to automatically upgrade your existing P6 EPPM database.","Test the new database to ensure that the upgrade succeeded.","Requirements to Upgrade Versions 6.2.1 through 7.0","49788.htm");
Page[6]=new Array("When upgrading P6 EPPM, the following data will not migrate from previous releases:","When upgrading from 16 R1 or earlier, SharePoint configuration details in Primavera P6 Administrator are not automatically migrated to the CMIS configuration settings in Primavera P6 Administrator.","When upgrading from 16 R1 or earlier, AutoVue markup and rendition does not migrate if upgrading from a configuration with VueLink enabled to a configuration without VueLink enabled. If you want to retain AutoVue markup and rendition with VueLink enabled, ensure VueLink is enabled when upgrading.","When upgrading from 16 R1 or earlier, AutoVue configuration details that are associated with a specific content repository in Primavera P6 Administrator will not migrate to the new location of the AutoVue configuration settings in Primavera P6 Administrator.","Workflows Repository (supported configuration changed from jBPM to Oracle BPM).","Content Repository (if previously an Apache JackRabbit user). Refer to Knowledge Articles on My Oracle Support for information on manually migrating JackRabbit documents to Oracle Universal Content Management.","Top Down Estimation, including estimated weights (removed).","Issue Form Categories (removed).","Summary Data (new summary tables incompatible with old summary tables). Refer to My Oracle Support's Knowledge Articles for information on manually migrating Scenarios data to the new summary tables.","Methodology Management (replaced with Project Templates). See Converting Methodologies to Projects and Creating a Project Template From Projects for manual migration instructions.","Data Not Migrated During P6 EPPM Database Upgrade","45315.htm");
Page[7]=new Array("Consider the following tips when upgrading:","User Name and Password Tips","All new users must create a password with at least one character, regardless of whether Password Policy is enabled. P6 EPPM will prompt existing users to follow the new requirement if they reset their password and the Password Policy is disabled.","Security Tips","Starting with P6 EPPM R8, P6 performs all user security and administration. Due to this change, all Admin Superusers receive Projects module access during the upgrade.","To configure an Oracle database server for SSL, see the Advanced Security Administrator's Guide included with the Oracle Database Server Documentation for configuring the Oracle Server and Oracle Client(s) for SSL.","To configure the SQL database server for SSL, use Microsoft's documentation for instructions on configuring SQL Database Server SSL. Direct questions about Installation / Configurations to the database vendor, Microsoft.","Application Tips","P6 EPPM does not support Summary-Only projects. During the P6 EPPM database upgrade, existing Summary-Only projects convert to standard projects, but lose all summary data. You can import the summary project from Microsoft Project into the converted blank project, then summarize the data. See the P6 Professional Help or the P6 Help.","P6 Professional no longer performs recurring job services. Use the Windows command line interface to run batch reports and export projects as a service. To view P6 Professional reports in P6, select the &quot;Store report in Work Products and Documents&quot; option when creating report batches or printing reports. See the P6 Professional Help for more information.","ANSI_PADDING for Microsoft SQL Server Database Tips","To prevent duplicate values in P6 EPPM modules appearing due to leading or trailing spaces, ensure that the ANSI_PADDING setting in Microsoft SQL Server is Off. For example, if one user enters &quot;Equipment&quot; and another user enters &quot; Equipment&quot; (with a leading space) for resource codes, the database will store both of these as valid values if ANSI_PADDING is On. If ANSI_PADDING is Off, the database will remove the leading space in the second entry and tell the user to enter a unique ID. See the documentation included with Microsoft SQL Server for more information.","Tips for Upgrading","49790.htm");
Page[8]=new Array("The following table illustrates the risks data field mapping when upgrading from P6 EPPM database (7.0 or 7.0 service packs).","Note Some fields will migrate to text fields instead of new fields because certain fields no longer correspond. The new text fields are noted below.","Risks Fields Migration Table","P6 EPPM database (version 7.0 and 7.0 service packs) Risks Fields","P6 EPPM Risks Field","Risk Id","id","risk_name","name","risk_descr","description","status_code","status","risk_type_id","category_id","risk_control","Note","table_name","table_name","wbs_id","cause (with heading 'Applies to WBS' &lt;WBS name&gt;)","rsrc_id","cause (with heading 'Applies to Resource' &lt;resource name&gt;)","obs_id","cause (with heading 'Responsible Manager' &lt;OBS name&gt;)","priority_type","cause (with heading 'Priority' &lt;priority type&gt;)","add_date","cause (with heading 'Date Identified' &lt;add_date in mmm-dd-yyyy format &gt;)","impact_date","cause (with heading 'Date Identified' &lt;add_date in mmm-dd-yyyy format &gt;)","prbly_pct","cause (with heading 'Probability' &lt;prbly_pct&gt;)","impact_work_qty","cause (with heading 'Impact - Labor Units' &lt;impact_work_qty&gt; - 2 decimals)","impact_equip_qty","cause (with heading 'Impact - Nonlabor Units' &lt;impact_equip_qty&gt; - 2 decimals)","impact_mat_qty","cause (with heading 'Impact - Material Units' &lt;impact_mat_qty&gt; - 2 decimals)","Impact_expense_cost","cause (with heading 'Impact - Expenses' &lt;impact_expense_cost&gt; - 2 decimals)","Risks Migration","38528.htm");
Page[9]=new Array("Perform the tasks in the following topics before upgrading your database.","Pre-Upgrade Procedures","55267.htm");
Page[10]=new Array("You must stop your application server prior to upgrading in order to prevent files that are in use from not being upgraded. In the event that the application server has not been stopped, the upgrade process will fail.","Stopping the Application Server","89414.htm");
Page[11]=new Array("To stop WebLogic:","Navigate to &lt;weblogic_home&gt;/user_projects/domain/your_domain/bin.","Run stopWeblogic.cmd (for Windows) stopWeblogic.sh (for Linux or UNIX).","If prompted for a user name and password in the WebLogic console window, enter the administrative user name and password you specified when creating the domain.","Note The WebLogic console window that opened when you started WebLogic will close automatically when it has shutdown.","Stopping WebLogic for P6 EPPM Applications","50096.htm");
Page[12]=new Array("When using an Oracle database, you must install Oracle Multimedia, along with these supporting components: Oracle JVM, Oracle XML DB (XDB), and XML Developer's Kit (XDK). Unless you specify otherwise, all these components automatically get installed with the latest versions of an Oracle database. If you chose not to install these components, you will need to install them before you upgrade P6 EPPM. See the Oracle Multimedia's User's Guide for information on how to install these components.","Installing Oracle Multimedia for an Oracle Database","61563.htm");
Page[13]=new Array("Before upgrading P6 EPPM on an Oracle or Oracle Autonomous Database, run the following scripts:","Navigate to the following locations, open the designated scripts in a text editor, and modify the schema user references to match your actual schema user names:","\\scripts\\install\\PM_&lt;release level&gt;\\manual_script_before_install.sql","You must apply grant options to the SYSTEM schema user or a custom user associated with the Oracle DBA role. If you plan to use a custom schema user, other than SYSTEM, to complete steps which require a DBA role, then you must update the references to SYSTEM in the script with the new custom schema user associated with the DBA role.","\\scripts\\install\\PM_&lt;release level&gt;\\manual_script_before_upgrade.sql","If you are not using the schema names admuser or pxrptuser, update the references with your actual admuser and pxrptuser names.","Complete the following steps:","From the command line, run the following and provide the password when prompted: sqlplus sys@&lt;db_tns_names_entry&gt; as sysdba","Go to \\scripts\\install\\PM_&lt;release_level&gt; and run the manual_script_before_install.sql script.","From the command line, run the following and provide the password when prompted: sqlplus system@&lt;db_tns_names_entry&gt;","Go to \\scripts\\install\\PM_&lt;release_level&gt; and run the manual_script_before_upgrade.sql script.","Grant Privileges to the SYSTEM User","85030.htm");
Page[14]=new Array("Use the validate tool to ensure your database is not missing objects that could cause the database to fail to upgrade. You must perform the steps below before you download the latest media pack. For example, if you are attempting to upgrade to Version 25 and you run the Version 25 validate tool against a version 20 database, then the validate tool will not work.","Double-click validate.bat&nbsp;(validate.sh for Linux) in your current Database folder of the P6 EPPM physical media or download to start the validate tool.","Note Schema validation of Oracle Autonomous Databases is not yet supported.","Provide the following:","In the Username field, enter your administrative user name (for example, admuser).","In the Database host address field, enter your database server name or TCP/IP address.","In the Database host port field, enter the port number that Oracle is using. The default is 1521.","In the Database name field, enter the Oracle Service Name. You can find it in the TNSNAMES.ORA file, which you created when you set up the Oracle client.","View the HTML page that the tool creates to ensure your database is not missing objects.","If upgrading from 7.0, go to the 'Client Application' media pack, then locate the \\install\\database\\scripts\\ folder to find the scripts you need to fix.","If upgrading from 8.0 or later, go to the database folder of the P6 EPPM physical media or download, then locate the \\database\\scripts\\install\\ to find the scripts you need to fix.","Running the Validate Tool for a Version 7 or Later Oracle Database","50527.htm");
Page[15]=new Array("Use the validate tool to ensure your database is not missing objects that could cause the database to fail to upgrade. You must perform the steps below before you download the latest media pack. For example, if you are attempting to upgrade to Version 25 and you run the Version 25 validate tool against a version 20 database, then the validate tool will not work.","Double-click validate.bat&nbsp;(validate.sh for Linux) in your current Database folder of the P6 EPPM physical media or download to start the validate tool.","Provide the following:","In the Database host address field, enter the server machine name or IP address where you installed Microsoft SQL Server.","In the Database host port field, enter the port number that Microsoft SQL Server is using. The default is 1433.","In the Database name field, enter the name of the existing database that you want to validate.","View the HTML page that the tool creates to ensure your database is not missing objects.","If your database is missing objects, do one of the following:","If upgrading from 7.0, go to the 'Client Application' media pack, then locate the \\install\\database\\scripts\\ folder to find the scripts you need to fix.","If upgrading from 8.0 or later go to the database folder of the P6 EPPM physical media or download, then locate the \\database\\scripts\\install\\ to find the scripts you need to fix.","Running the Validate Tool for a Microsoft SQL Server Database","50529.htm");
Page[16]=new Array("To migrate Methodology Management version 7.0 data to the latest P6 Project Templates, you must first use Project Architect in the Project Management module to convert the data from a methodology to a project.","To convert Methodology Management data to a project:","Create a new EPS node in P6 Professional version 7.0 where you can store all your Methodology Management projects.","Use Project Architect in P6 Professional version 7.0 to create projects from Methodology Management data. For more information on using Project Architect, see version 7.0 of the Oracle Primavera P6 Project Management Reference Manual.","Note You can create only one project at a time. If you want all of your Methodology Management data moved to P6 Project Templates, contact Oracle Consulting to automate the process.","After you have converted all your Methodology Management data to projects, upgrade P6 EPPM.","Launch P6.","Convert your upgraded projects (formerly methodologies) to project templates. See Creating a Project Template From Projects.","Converting Methodologies to Projects","44845.htm");
Page[17]=new Array("When upgrading the P6 EPPM database for a new version of P6 EPPM, you can either use the P6 EPPM Configuration Wizard that is delivered with the latest media pack or you can use dbsetup.","The P6 EPPM Configuration Wizard streamlines the process of upgrading the P6 EPPM with your WebLogic server and additional components. The P6 EPPM Configuration Wizard uses dbsetup to upgrade your database. For more information about using the P6 EPPM Configuration Wizard, refer to About the P6 EPPM Configuration Wizard.","If you only want to upgrade your database, you can use dbsetup.","To upgrade the P6 EPPM database using dbsetup:","Perform a cold backup and a full database export.","If you are unsure how to back up your Oracle or Oracle Autonomous Database, do not proceed with the upgrade. Contact your database administrator, your database vendor, or Oracle Global Customer Support for assistance in backing up your database before performing the database upgrade. Also, ensure that you are familiar with the process of restoring the backup copy of the database in case you need to do so.","Double-click dbsetup.bat&nbsp;(for Windows) dbsetup.sh (for Linux) in the Database folder of the P6 EPPM physical media or download to start the Database wizard.","Note Click Next on each wizard screen to advance to the next step.","On the Primavera P6 dialog box:","Select Upgrade an existing database in the Database options section.","Select Oracle or Oracle Autonomous Database (ATP) as the Server type.","On the Connection Information dialog box, enter the following information to connect to the database:","In the DBA user name field, enter the database administrator user name. The default is System.","In the DBA password field, enter the password for the DBA user.","Provide databases connection information:","If your database is hosted on an Oracle server:","In the Database host address&nbsp;field, enter the server machine name or IP address where Oracle is installed.","In the Database host port&nbsp;field, enter the port number that Oracle is using. The default is 1521.","In the Database name&nbsp;field, enter the Service Name or SID, depending on your configuration. ","Select the Service Name or SID option, depending on the information you entered in the Database Name field.","In the Keystore Folder field, enter the full path to the keystore file.","If your database is hosted on Oracle Autonomous Database:","In the Database Wallet Location&nbsp;field, enter the path and filename of your database wallet.","In the Database Service list, select your database service.","On the Create New Keystore dialog box, complete the following information:","If a keystore exists, enter the Existing Keystore Password.","If creating a new keystore, select Create New Keystore and enter the keystore credentials.","Note","P6 EPPM databases do not require you to use a keystore.","If there is no existing keystore and you are not creating one, ensure all fields are clear and click Next.","On the Connection Information dialog box, enter the following information:","In the Administrative user name field, enter your administrative user name. The default is admuser.","In the Administrative password field, type the password associated with the user name you entered.","On the Upgrade Options&nbsp;dialog box:","Select your Privileged user name for the database. The default is privuser. ","In the Privileged user password field, type the password associated with the user name that you entered.","Select your Public user name for the database. The default is pubuser.","In the Public user password field, type the password associated with the user name that you entered.","Select your Background job user name for the database. The default is bjobuser. ","In the Background job user password field, type the password associated with the user name that you entered.","On the Upgrade Option dialog box:","Select your PX Reporting User name for the database. The default is, pxrptuser.","In the Px Reporting User Password field, type the password associated with the user name that you entered.","On the Ready to Begin Upgrading Data&nbsp;dialog box:","Choose Yes, upgrade my database. ","Click Upgrade.","The upgrade process could take several minutes, depending on its size.","On the Primavera Database Setup Wizard&nbsp;dialog box, click Next&nbsp;after the process has completed.","NoteIf the database upgrade fails, see PrimaveraDatabaseSetup.log&nbsp;located in the user home directory (for example, C:\\Documents and Settings\\Administrator). Contact Oracle Global Customer Support if you need further assistance.","On the Finish&nbsp;dialog box, click Finish to exit the wizard.","Your database is now ready to use with P6 EPPM.","Upgrading an Oracle or Oracle Autonomous Database P6 EPPM Database","89411.htm");
Page[18]=new Array("Review and complete the prerequisites before configuring any P6 EPPM applications.","Prerequisites for P6 EPPM Configuration","12885.htm");
Page[19]=new Array("Before you upgrade, uninstall the products mentioned in the following sections. For most P6 EPPM applications, you can use the Oracle Universal Installer and then delete the applications from WebLogic if needed. You cannot use the Oracle Universal Installer for P6 Team Member 8.1 and Email Statusing Service; for those two applications, see one of the following:","Deleting P6 EPPM 7.0 or Later Applications from WebLogic","Removing Email Statusing Service","Uninstall P6 EPPM 7.0 or Later Applications","55315.htm");
Page[20]=new Array("This is an optional step. You can also use Oracle Universal Installer to reinstall your P6 EPPM applications for your upgrade. For more information about reinstalling your applications using the Oracle Universal Installer, see Installing P6 EPPM Applications.","To use the Universal Installer to Uninstall P6 EPPM 7.0 or Later:","From the P6 folder of the physical media or download location, run one of the following depending on your system type:","If you are installing on a Microsoft Windows system, navigate to the win\\Disk1\\install directory, and then double-click on the setup.exe file.","If you are installing on a non-Microsoft Windows system, type the following command:","cd Operating System/Disk1/install","Depending on your operating system, replace Operating System in the command above with aix_64-5L, hp_64, hpux_IA64, linux, or solaris_64, then type the following commands:","chmod 755 runInstaller<br />chmod 755 unzip<br />./runInstaller","On the Welcome screen, click Deinstall Products.","On the Inventory dialog box, under the Contents tab, select any P6 EPPM applications you want to uninstall.","Click Remove.","On the Confirmation dialog box, click Yes.","Click Close then Cancel to exit the dialog box and Oracle Universal Installer.","Using Oracle Universal Installer to Uninstall P6 EPPM 7.0 or Later","55316.htm");
Page[21]=new Array("To delete P6 EPPM applications from WebLogic:","Launch the WebLogic Administration Console.","Note You can open the Administration Console via a web browser using this address: http://serverIP:listenport/console. The default listenport is 7001.","In the Welcome&nbsp;window, log in using the user name and password that you created when you created your WebLogic domain.","In the Change Center&nbsp;pane of the Administration Console, click Lock &amp; Edit.","In the Domain Structure&nbsp;pane, click Deployments.","In the Summary of Deployments&nbsp;pane, in the Control tab:","Select the option next to the application(s) you want to delete.","Click Stop, Force Stop Now.","On the Force Stop Application Assistant pane, click Yes.","In the Summary of Deployments&nbsp;pane, in the Control tab:","Ensure the State column shows Prepared.","Select the option next to  the application(s) you want to delete.","Click Delete.","On the Delete Application Assistant pane, click Yes.","In the Change Center pane, click Activate Changes.","Logout of the Administration Console.","If you will use the same home&nbsp;directory for the new deployments, delete the existing WAR or EAR&nbsp;file from that directory to avoid conflict with the new files.","Deleting P6 EPPM 7.0 or Later Applications from WebLogic","55317.htm");
Page[22]=new Array("To remove Email Statusing Service:","Locate your Email Statusing Service home directory (for example, EMAIL_HOME).","Create a backup copy of the config.properties file and note the location where you saved it.","Delete the Email Statusing Service home directory.","Removing Email Statusing Service","55161.htm");
Page[23]=new Array("To install your P6 EPPM applications:","Installing P6 EPPM Applications","53085.htm");
Page[24]=new Array("WebLogic Server requires that you have a Java Development Kit (JDK) installed on your machine. You must manually download and install the required JDK. For a list of supported JDK versions for P6 EPPM, see the Tested Configurations document. As new releases of the software become available, you can find them at http://www.oracle.com/technetwork/java/archive-139210.html.","JDK Installation","35523.htm");
Page[25]=new Array("You will need to install WebLogic to deploy P6 EPPM. For supported versions, see the Tested Configurations document. For more information about how to install WebLogic, see http://www.oracle.com/technetwork/middleware/weblogic/documentation/index.html","Note Oracle recommends that you install Oracle Access Manager on a new WebLogic Middleware home.","If existing Middleware applications are installed into the Middleware home (for example, Identity Management), Access Manager will fail to deploy.","Tip","After you finish installing WebLogic, ensure you can run the startNodeManager.cmd (with Windows) or startNodeManager.sh (with UNIX or Linux) before installing P6 EPPM. If you cannot run this file, contact your WebLogic administrator for help.","Installing WebLogic","35520.htm");
Page[26]=new Array("You can use Oracle, Microsoft SQL Server, or Oracle Autonomous Database on your database server for P6 EPPM deployments. For more information about supported database versions, refer to Tested Configurations. You must install the database server before you can create the P6 EPPM database.","If you are using an Oracle or Oracle Autonomous Database, you must make sure to create a database with the Oracle Text option enabled. Oracle Text supports the Oracle or Oracle Autonomous Database content repository by using standard SQL to index, search, and analyze text and documents stored in the database, in files, and on the web. For more details, refer to the Oracle or Oracle Autonomous Database documentation.","If you are using a Microsoft SQL Server Database, you must make sure that you enable FILESTREAM before attempting your P6 EPPM installation or upgrade. For information about how to enable FILESTREAM, refer to the Microsoft SQL Server documentation for your version.","Note","If you attempt to create a database using an Oracle database, the option to create a container database is enabled by default. If you do not want to create a container database, clear the Create As Container Database option during the database creation process. If you create a container database, you must also create a pluggable database on which to install your P6 EPPM instance.","Oracle Text is enabled by default.","jobsvc.job_data_x is used to store XML data for XML import processes using the Varbinary(Max) datatype. In order to support the Varbinary(Max) datatype, you must enable FILESTREAM.","A SQL database name must not contain a space.","Installing a Database","61564.htm");
Page[27]=new Array("For an Oracle Autonomous Database, you will need to download the Client Credentials Wallet file. For more information, about accessing and downloading the Wallet, see Oracle Cloud Infrastructure documentation.","Unzip the file to a suitable location on your local machine for example, C:/OracleWallet.","Preparing the Wallet for Oracle Autonomous Databases","102514.htm");
Page[28]=new Array("The Content Repository allows users to collaboratively share and manage documents in P6. For P6 EPPM users to utilize the enhanced document management functionality, you must install Oracle Webcenter Content Core Capabilities (WCCC), Microsoft SharePoint, Oracle Database, or a CMIS-compliant content repository. Refer to the documentation included with those applications for installation instructions.","Note P6 supports clustering of the Content Repository only when using WebLogic for the application server.","If you plan to use the P6 EPPM Configuration Wizard to connect P6 EPPM to your content repository, see the P6 EPPM Content Repository Configuration Guide for more information about any prerequisites that you may need to complete in your content repository. ","For more information about installing and configuring a content repository for P6 EPPM, refer to the P6 EPPM Content Repository Configuration Guide.","Content Repository Installation and Configuration","12888.htm");
Page[29]=new Array("Consult Oracle Analytics Publisher documentation for installation instructions. For complete overview information about Oracle Analytics Publisher, go to the following web site: https://www.oracle.com/business-analytics/.","Oracle Analytics Publisher Installation","52005.htm");
Page[30]=new Array("The Workflows Repository helps users to keep track of project initiations in P6. For P6 users to utilize the project initiation functionality, you must install the supported Workflows Repository application, BPM. Refer to the documentation included with the Oracle BPM application for installation instructions.","Note BPM is not yet supported for Oracle Autonomous Database.","Workflows Repository Installation","12889.htm");
Page[31]=new Array("If you are using BPM, you must install the Oracle MDS schema using the Repository Creation Unit (RCU) on a separate database instance. See the Tested Configurations document for supported versions.","Installing the Oracle MDS Schema for BPM","79585.htm");
Page[32]=new Array("To configure BPM with P6:","Create a new directory on the host where P6 is running. For example, P6BPMConnector/P6 and P6BPMConnector/BPM.","In the P6 media pack Tools\\BPM Connector\\12c subfolder, locate the following file:","prm-bpm-connector-12c-v2.0.jar","Copy the connector file listed above to the P6BPMConnector/P6 folder you created. Determine the location of the BPM installation that you are using to integrate with P6. If you have multiple SOA Suite installations, ensure that you determine the location of the specific installation that you are integrating with P6.","Copy the following folders and their contents from your BPM installation to the P6BPMConnector/BPM folder you created.&nbsp;Their default locations are listed:","&lt;ORA_HOME&gt;\\soa\\soa\\modules\\oracle.bpm.client_11.1.1 ","&lt;ORA_HOME&gt;\\soa\\soa\\modules\\oracle.bpm.project_11.1.1 ","&lt;ORA_HOME&gt;\\soa\\soa\\modules\\oracle.bpm.runtime_11.1.1 ","Copy all the supporting jars from the BPM installation that you are using to integrate with P6 to the P6BPMConnector/BPM folder you created.&nbsp;Their default locations are listed:","&lt;Oracle_Home&gt;\\soa\\soa\\modules\\oracle.soa.fabric_11.x.x\\bpm-infra.jar","&lt;Oracle_Home&gt;\\soa\\soa\\modules\\oracle.soa.workflow_11.x.x\\bpm-services.jar","&lt;Oracle_Home&gt;\\soa\\soa\\modules\\oracle.soa.fabric_11.x.x\\fabric-runtime.jar","&lt;Oracle_Home&gt;\\oracle_common\\modules\\oracle.jmx_12.x.x\\jmxframework.jar","&lt;Oracle_Home&gt;\\oracle_common\\modules\\oracle.jmx_12.x.x\\jmxspi.jar","&lt;Oracle_Home&gt;\\soa\\bpm\\modules\\oracle.bpm.mgmt_11.x.x\\oracle.bpm.bpmn-em-tools.jar","&lt;Oracle_Home&gt;\\soa\\soa\\modules\\oracle.soa.mgmt_11.x.x\\soa-infra-mgmt.jar","&lt;Oracle_Home&gt;\\wlserver\\server\\lib\\wlclient.jar","&lt;Oracle_Home&gt;\\oracle_common\\modules\\oracle.xdk_12.x.x\\xml.jar","&lt;Oracle_Home&gt;\\oracle_common\\modules\\oracle.xdk_12.x.x\\xmlparserv2.jar","&lt;Oracle_Home&gt;\\soa\\soa\\modules\\oracle.soa.fabric_11.x.x\\tracking-api.jar","&lt;Oracle_Home&gt;\\soa\\soa\\modules\\oracle.rules_11.x.x\\rulesdk2.jar","Note","The jar files must be from the same BPM installation that will be integrated with P6.","Modifying the P6 Environment for BPM","89467.htm");
Page[33]=new Array("IAIK-JCE is a third-party Java Cryptography library that may be used as an alternative to the Java Cryptography Extension functions included in the Oracle/Sun JRE. If your organization requires it, you can choose to use IAIK-JCE libraries while storing/transmitting sensitive information (for example, passwords) in P6 EPPM.","To allow the P6 EPPM installer to recognize and install IAIK-JCE, you must modify your existing java.security settings and copy the iaik_jce.jar file to the correct location in &lt;Java_Home&gt;.","To prepare IAIK-JCE for installation:","Navigate to the following URL: ","http://jce.iaik.tugraz.at/sic/Products/Core-Crypto-Toolkits/JCA_JCE","Download and extract iaik_jce.zip locally. See Tested Configurations for the supported versions of IAIK-JCE.","Navigate to the lib-signed folder and then copy iaik_jce.jar to &lt;Java_Home&gt;/jre/lib/ext.","Navigate to &lt;Java_Home&gt;/jre/lib/security and then add the following to java.security.","security.provider.11=iaik.security.provider.IAIK","Note If the number '11' is being used by another entry, use the next available number.","Save and close the file.","Complete the instructions in the following topic:","Setting an Environment Variable for IAIK-JCE","Installing IAIK-JCE","89631.htm");
Page[34]=new Array("Setting the Environment Variables in Microsoft Windows","To set the JAVA_TOOL_OPTIONS environment variables in Microsoft Windows:","Click Start, Control Panel, System, and then Advanced system settings.","In the System Properties dialog box, on the Advanced tab, click Environment Variables.","Add the JAVA_TOOL_OPTIONS environment variable:","In the System Variables section, click New.","In the Variable name field, type JAVA_TOOL_OPTIONS.","In the Variable value field, type the following:","-Dprimavera.encryptor.provider=&quot;IAIK&quot;","Click OK.","Exit the Control Panel.","Setting the Environment Variables with Unix or Linux","To set the JAVA_TOOL_OPTIONS environment variables with Unix or Linux:","Set the JAVA_TOOL_OPTIONS environment variable by typing the following command:","export JAVA_TOOL_OPTIONS=-Dprimavera.encryptor.provider=&quot;IAIK&quot;","Setting an Environment Variable for IAIK-JCE","89629.htm");
Page[35]=new Array("Before you run the installation wizard, ensure that you have read the Prerequisites for P6 EPPM Configuration. ","You can install the following with the installation wizard:","P6","P6 Professional Cloud Connect (to connect to an EPPM Oracle or Oracle Autonomous Database and P6 APIs using a remote method of access)","Note When you choose to install Cloud Connect, the wizard will also install P6 Integration API (in remote mode) by default.","P6 Integration API (remote mode only)","P6 EPPM Web Services","P6 Team Member (includes P6 Team Member Web and Email Statusing Service)","Once you have completed your installation, the P6 EPPM Configuration Wizard will appear. When the configuration wizard appears, you will have the choice to configure your database, WebLogic server, and extra application settings.","About the P6 EPPM Installation Wizard","53044.htm");
Page[36]=new Array("You can download the media pack that contains the installer and all required install files from the Oracle Software Delivery Cloud website at https://edelivery.oracle.com.","To install the P6 EPPM applications:","Download the Primavera P6 Enterprise Project Portfolio Management &lt;release_level&gt; for &lt;platform&gt; folder and extract the contents.","Go to the location where you extracted the contents, and run one of the following:","If you are installing with Windows, navigate to the P6_R&lt;release_level&gt;\\Disk1\\install folder and double-click setup.exe.","If you are installing with UNIX or Linux, enter the following command:","cd P6_R&lt;release_level&gt;/Disk1/install","chmod 755 runInstaller","chmod 755 unzip","./runInstaller","On the Welcome screen, click Next.","Note Click Next on each wizard screen to advance to the next step.","On the Specify Home Details screen, complete the following: ","In the Name field, enter a name for the installation. ","In the Path field, enter the desired location of the P6 EPPM home folder (for example, C:\\P6EPPM_1).","On the Available Product Components&nbsp;screen, select each component you want to install. Alternatively, if you are reinstalling your P6 EPPM applications for an upgrade, select the components that have Reinstall as the value in the Install Status column.","If you are installing P6, select P6.","Note You can choose Select All if you want to install all P6 EPPM applications.","If you are connecting P6 Professional with a P6 EPPM Oracle or Oracle Autonomous Database and would like to compress your data for cloud or enterprise WAN connections, select P6 Professional Cloud Connect. This installation component is applicable to only Oracle or Oracle Autonomous Database users and is optional. The wizard will also install P6 Integration API (in remote mode) by default.","Note After running the P6 EPPM Configuration wizard, the Configuration Complete screen will display the default URL generated for P6 Professional Cloud Connect. This URL (case-sensitive) must be provided to P6 Professional users to enable them to set up and configure a new database connection to the P6 Professional Cloud Connect server in the P6 Professional database configuration utility.","For more details on establishing the P6 Professional Cloud Connect database connection in P6 Professional, see the P6 Professional Installation and Configuration Guide (P6 EPPM). ","If you are installing P6 Integration API, select P6 Integration API.","Note","The wizard will install the remote version of P6 Integration API.","If you need to install the local version of P6 Integration API or want to install the client-side packages (which include libraries and documentation for remote mode), see Installing Local-mode P6 Integration API and the P6 EPPM and P6 Professional Integration API Programming Guide.","If you are installing P6 EPPM Web Services, select P6 Web Services. The wizard will also install the demo applications for P6 EPPM Web Services.","If you are installing P6 Team Member, select P6 Team Member. This will install the files necessary for P6 Team Member Web, Email Statusing Service, and the server components for P6 mobile.","Note","If you want to use Email Statusing Service, see the P6 EPPM System Administration Guide when you have completed installing and configuring your other applications.","P6 for iOS supports SSL (HTTPS) or HTTP only when it has a certificate signed by a trusted authority.","P6 for Android requires SSL (HTTPS) when you are not using SSO authentication. If you are using SSO authentication, you can use HTTP or HTTPS protocols. HTTPS requires a valid certificate from an Android trusted certifying authority.","On the Specify JDK Home&nbsp;screen, enter or browse to the location where JDK is installed.","On the Summary screen:","Verify that all of the components that you want to install are listed.","Click Install.","On the End of Installation screen, click Exit.","Note The P6 EPPM Configuration Wizard will appear if the installation was successful.","In the Exit dialog box, click Yes.","If you want to use the P6 EPPM Configuration Wizard to configure your P6 EPPM, WebLogic, and other applications, continue to About the P6 EPPM Configuration Wizard.","If you want to configure your applications manually, click Cancel to exit the configuration wizard. See Where to Go From Here - Pre Configuration Wizard to see what guides you will need to configure your applications manually.","Installing P6 EPPM Applications","51961.htm");
Page[37]=new Array("Before installing the local-mode P6 Integration API, you need to install P6 EPPM. Additionally, you must uninstall any earlier versions of the local P6 Integration API before installing the current version.","The local-mode P6 Integration API Installer provides a wizard to guide you through the installation process, which includes:","Choosing the installation mode","Installing the P6 Integration API libraries","Setting up and configuring the P6 Integration API database","To install local-mode P6 Integration API:","Download the P6 Integration API part from the P6 EPPM media pack and then extract it.","Depending on your operating system, change your directory to the media pack part by running one of the following:","With Windows, navigate to the win\\Disk1\\install directory and double-click setup.exe.","With UNIX or Linux, do the following:","Change your directory using the following command: ","cd &lt;Operating_System&gt;\\Disk1\\install","where &lt;Operating_System&gt; is linux64.","Enter the following commands:","chmod 755 runInstaller","chmod 755 unzip","./runInstaller","Click Next.","On the Welcome screen, click Next.","On the Select the Installation Type screen, specify the installation mode.","Local Mode Packages Only: Choose this option to use the P6 Integration API in local mode, without Java RMI. <br />This option installs database configuration tools and javadoc.","Client Side Packages Only: Choose this option to install client-side libraries and documentation. This option is required for the remote API.","Note","The maximum number of clients that can access a remote server at one time is approximately 50. This number might be less, depending on multiple factors (for example, system hardware, network configuration, and so on)","When using the P6 Integration API in Remote Mode with the client and server in different time zones, the time of day fields in the client are based on the local time by default (not the server time). If you want the times to match, you can first set the time zone in your client code to be the same as the server time zone for each thread that calls P6 Integration API code.","In the Specify Home Details screen:","In the Name field, enter a name for the P6 Integration API.","In the Path field, specify the installation location for the P6 Integration API files.","Click Next.","In the Available Product Components screen, select the components to install and click Next.","In the JDK Home Directory&nbsp;screen, enter or browse to the location where JDK is installed.","In the Summary&nbsp;screen, click Install.","Note","If you installed the local mode package, the Configuration Assistants&nbsp;screen appears after the installation finishes. Do not close this screen. After a short time, the Database Configuration dialog box opens.","If you installed the client side package, your installation is complete. You can exit the wizard now and skip the remaining steps in this section.","In the Database Configuration dialog box:","Choose the database type: Oracle, Oracle Autonomous Database, or Microsoft SQL Server.","Note You can later change the database type through the P6 Integration API Database Configuration Setup wizard.","Click Next.","Specify the database connection parameters.","Click Next.","Note The P6 Integration API requires pubuser&nbsp;access (in the User Name field) to the database. The database name, host address, and host port are specific to your Oracle or Microsoft SQL Server installation. Database Host Port displays the default port for the database type you selected. You can edit this port. If you are using an Oracle Autonomous Database, you only need to specify the unzipped Wallet location and service name.","If the installer detects an existing configuration screen, choose the appropriate action.","Note","If your site includes P6, you can share a new P6 Integration API configuration with P6. However, P6 cannot share an existing configuration with P6 Integration API because it will not support the new P6 Integration API configuration settings.","If a configuration does not exist, the The installer has detected an existing. . .&nbsp;screen does not appear and the installation process automatically creates a default configuration named Primavera Configuration. You can edit the settings for this configuration through the Primavera P6 Administrator.","After installation, you can use the Database Configuration Setup wizard to choose or create a different configuration.","See the P6 EPPM System Administration Guide for more information about configurations.","When the message displays to confirm the database configuration has completed successfully, click OK.","Click Exit.","Installing Local-mode P6 Integration API","93144.htm");
Page[38]=new Array("The configuration process provides you with several options to configure your applications to work with P6 EPPM. The following sections describe your options.","Where to Go From Here - Pre Configuration Wizard","53089.htm");
Page[39]=new Array("Oracle recommends you use the P6 EPPM Configuration Wizard to configure P6 EPPM, its applications, and WebLogic. With this option, you can install or upgrade your database, deploy your P6 EPPM applications in WebLogic, and configure a content repository, reporting software, and BPM to work with P6. Continue to About the P6 EPPM Configuration Wizard to use this option.","Using the P6 EPPM Configuration Wizard To Configure P6 EPPM","53140.htm");
Page[40]=new Array("Database","You can manually install or upgrade your database. If you want to install or upgrade your database manually, you can still use the wizard to deploy your P6 EPPM applications in WebLogic and configure a content repository, reporting software, and BPM to work with P6. ","If you want to install or upgrade your database manually, see the P6 EPPM Installation and Configuration Guide for your database.","P6 EPPM Applications","You can manually deploy your P6 EPPM applications in WebLogic. Depending on which applications you are using, use the following:","P6 Server Configuration Guide","WebLogic Configuration Guide","Additional Applications","You can also use the Primavera P6 Administrator to connect additional applications to P6. Depending on your application, use the following:","P6 EPPM Oracle Analytics Publisher Configuration Guide","P6 EPPM BPM Configuration Guide","P6 EPPM Content Repository Configuration Guide","P6 EPPM Oracle Identity Manager Configuration Guide","Primavera Oracle Access Manager Configuration Guide","Primavera Oracle Enterprise Manager Configuration Guide","Manually Configuring Your Applications","53141.htm");
Page[41]=new Array("The P6 EPPM Configuration Wizard will allow you to:","Install or upgrade your database.","Deploy your P6 EPPM applications in WebLogic and setup managed servers.","Configure your P6 reporting software, BPM, and your content repository (WCCC, Microsoft SharePoint, Oracle Database, or CMIS) with P6.","Use the P6 EPPM Configuration Wizard to configure your suite. Before running the configuration wizard, consider the following:","You must be on an Oracle, Oracle Autonomous Database, or Microsoft SQL Server.","You must have a JDK installed. See the Tested Configurations document for information on supported versions.","Note To launch the P6 EPPM Configuration Wizard manually, use eppmconfig.cmd (for Windows) eppmconfig.sh (for UNIX / Linux) from the P6 EPPM installation folder at &lt;P6 EPPM_home&gt;\\P6EPPM_1\\p6.","On the Welcome screen, click Next if you want to use the wizard to configure your suite. Click Cancel if you want to configure your applications manually.","About the P6 EPPM Configuration Wizard","51998.htm");
Page[42]=new Array("To use this wizard, you must either install or upgrade your database, or, already have the latest database installed. If you want to install or upgrade your database manually, leave the P6 EPPM Configuration Wizard open and go to the Manually Installing the P6 EPPM Database or Manually Upgrading the P6 EPPM Database guides. If you want to install or upgrade your database using the configuration wizard, continue to the next section.","Configuring Your Database","53046.htm");
Page[43]=new Array("On the Database Configuration screen:","Choose one of the following:","Select Create a new P6 EPPM database if you are creating a new database.","Select the Install Sample Projects&nbsp;option if you want to include sample project data in a non-production database. If you do not select the Install Sample Projects option, the P6 EPPM database loads empty data in a secure state and includes only the most basic information needed to run.","Select Upgrade an existing P6 EPPM database if you are upgrading your database.","Select Connect to an existing P6 EPPM &lt;release_level&gt; database if you already installed a database and want to configure your applications with it.","Click Next.","Using the Database Configuration Screen","53047.htm");
Page[44]=new Array("On the Database Type &amp; Connection screen:","For the Database Type option, choose one of the following:","Oracle","Oracle Autonomous Database (ATP)","Microsoft SQL Server","Enter the connection details for the database.","If your database is hosted on Oracle or Microsoft SQL:","In the Database Host Address&nbsp;field, enter the server machine name or IP address where you installed the database.","In the Database Host Port&nbsp;field, enter or verify the port number for your database. ","The default for Oracle is 1521.","The default for Microsoft SQL Server is 1433.","In the Database Name field, enter the name of your database.","For Oracle only, select SID (for example, orcl) or Service (for example, orcl.us.oracle.com) based on the database you installed.","In the Keystore Folder field, enter the location of the keystore. ","The P6 EPPM wizard automatically detects keystores located in the primary database folder.","If your database is hosted on Oracle Autonomous Database:","In the Database Wallet Location field, enter or browse to the location of the zipped Database Wallet.","On the Service list, select the service to use.","In the DBA Username field (when installing or upgrading) or Public Username field (when connecting to an upgraded database), enter or verify your user name.","The default username for Oracle is 'system'.","The default username for Oracle Autonomous Database is 'system'.","The default username for Microsoft SQL Server is 'sa'.","The default public username is 'pubuser'.","In the DBA Password field (when installing or upgrading) or Public Password field (when connecting to an upgraded database), enter the password to log in to the database.","Click Next.","Note The Configure Oracle Read Only User option is only intended for use with cloud installations.","Using the Database Type &amp; Connection Screen","53048.htm");
Page[45]=new Array("Use one of these chapters based on your database version:","For 7.0 and earlier ","Using the Database User Validation Screen When Upgrading from a 7.0 and Earlier Oracle Database","For 8.0 ","Using the Database User Validation Screen When Upgrading from an 8.0 Oracle Database","For 8.1 ","Using the Database User Validation Screen When Upgrading from an 8.1 Oracle Database","Using the Database User Validation Screen for an Oracle Database","54134.htm");
Page[46]=new Array("On the Database User Validation screen:","In the Privileged Username field, select your privuser name.","In the Public Username field, select your pubuser name.","In the Public User Password field, enter your pubuser password.","In the Background Username field, create a bgjobuser name.","In the  Background User Password and Confirm Password fields, enter a bgjobuser password.","In the Reporting Username field, create a pxrptuser name.","In the Reporting User Password and Confirm Password fields, enter a pxrptuser password.","Click Next.","Using the Database User Validation Screen When Upgrading from a 7.0 and Earlier Oracle Database","54123.htm");
Page[47]=new Array("On the Database User Validation screen:","In the Privileged Username field, select your privuser name.","In the Public Username field, select your pubuser name.","In the Public User Password field, enter your pubuser password.","In the Background Username field, select your bgjobuser name.","In the  Background User Password field, enter your bgjobuser password.","In the Reporting Username field, create a pxrptuser name.","In the Reporting User Password and Confirm Password fields, enter a pxrptuser password.","Click Next.","Using the Database User Validation Screen When Upgrading from an 8.0 Oracle Database","54124.htm");
Page[48]=new Array("On the Database User Validation screen:","In the Privileged Username field, select your privuser name.","In the Public Username field, select your pubuser name.","In the Public User Password field, enter your pubuser password.","In the Background Username field, select your bgjobuser name.","In the  Background User Password field, enter your bgjobuser password.","In the Reporting Username field, select pxrptuser name.","In the Reporting User Password field, enter your pxrptuser password.","Click Next.","Using the Database User Validation Screen When Upgrading from an 8.1 or Later Oracle Database","53068.htm");
Page[49]=new Array("Use one of these chapters based on your database version:","For 8.0 or earlier","For 8.1 or later","Using the Database User Validation Screen for a Microsoft SQL Server Database","54138.htm");
Page[50]=new Array("On the Database User Validation screen:","In the Public Username field, select your pubuser name.","In the Public User Password field, enter your pubuser password.","In the Use Existing Reporting User field, select the option if you already have a pxrptuser that you want to use.","In the Reporting Username field, enter a pxrptuser name.","In the Reporting User Password and Confirm Password fields, enter a pxrptuser password.","Click Next.","Using the Database User Validation Screen when Upgrading from an 8.0 or Earlier Microsoft SQL Server Database","54139.htm");
Page[51]=new Array("On the Database User Validation screen:","In the Public Username field, select your pubuser name.","In the Public User Password field, enter your pubuser password.","In the Reporting Username field, select a pxrptuser name.","In the Reporting User Password and Confirm Password fields, enter a pxrptuser password.","Click Next.","Using the Database User Validation Screen when Upgrading from an 8.1 or Later Microsoft SQL Server Database","54140.htm");
Page[52]=new Array("In this section, you will configure the P6 EPPM applications you installed with the installation wizard. The P6 EPPM Configuration Wizard will set up managed servers and deploy your P6 EPPM applications in the WebLogic domain that you installed.","Configuring Your WebLogic Server with P6 EPPM","53051.htm");
Page[53]=new Array("On the P6 Configuration Settings screen:","Do one of the following:","If a P6 configuration does not exist, in the Create a new configuration field, enter your new configuration name.","If you already created a configuration, choose it from the Use an existing configuration option, or create a new configuration.","Note","If you are upgrading from a previous version of P6 against the same database, choose the option to create a new configuration. This is necessary to accommodate new configuration settings. See the P6 EPPM System Administration Guide for more information about configurations and the Primavera P6 Administrator.","You can edit the settings for this configuration through the Primavera P6 Administrator.","Click Next.","Using the P6 Configuration Settings Screen","53050.htm");
Page[54]=new Array("On the Application Server Configuration screen:","Select the Configure WebLogic option.","Note","If you do not want to configure WebLogic right now, ensure the Configure WebLogic option is clear and click Next to continue to the next screen. If you want to configure WebLogic manually, refer to the P6 Server Configuration Guide.","Choose one of the following:","Create a new WebLogic domain if you are creating a new domain.","Use an existing WebLogic domain if you already have a WebLogic domain.","Note This is the domain where the wizard will create your managed servers for each application.","(Optional) Select Deploy Oracle WSM Policy Manager if you are integrating with BPM and or select Configure WSM Policy for P6WebServices if you are configuring OWSM authentication for P6 EPPM Web Services. For more information, refer to the P6 EPPM Web Services Programming Guide.","Note By default, the configuration wizard deploys P6 EPPM Web Services with the oracle/wss_username_token_server_policy OWSM policy. This policy does not contain message protection and encryption and needs additional configuration to enable either. Refer to Adding Additional Policies to Oracle Web Services Manager in the P6 EPPM System Administration Guide for details on configuring additional OWSM policies.","Click Next.","Using the Application Server Configuration Screen","53052.htm");
Page[55]=new Array("On the Configure WebLogic screen:","In the WebLogic Server Home field, verify or choose the location of your WebLogic home. For example, C:\\Oracle\\Middleware\\Oracle_Home.","In the Domain Home field, enter or verify your WebLogic domain home name.","In the Port field, enter or verify the port number that your WebLogic domain is using. The default port is 7001.","In the Administration Username field, create or verify your administrative user name for the WebLogic domain you defined on the previous screen.","In the Password and Confirm Password fields, enter the password for your administrative username.","Click Next.","Using the Configure WebLogic Screen","53053.htm");
Page[56]=new Array("If you installed a content repository, reporting software, or BPM, you can use the P6 EPPM Configuration Wizard to configure these applications to work with P6 EPPM. The settings in this wizard correspond to the settings in the Primavera P6 Administrator.","Note","You can configure the settings for these applications later in the Primavera P6 Administrator. See Manually Configuring Your Applications for the guides you will need.","If you are using an existing P6 configuration, the wizard will skip the content repository, reporting software, and BPM screens.","Connecting Applications to P6 EPPM","53054.htm");
Page[57]=new Array("On the Content Repository Selection screen:","Select the Connect to a Content Repository option.","Note If you would rather configure your content repository manually or do not have a content repository installed, ensure the Connect to a Content Repository option is clear and click Next. See the P6 EPPM Content Repository Configuration Guide for more information.","Select one of the following:","Oracle Webcenter Content Core Capabilities","Microsoft SharePoint","CMIS compliant content repositories","Oracle Database","Note","If you select Oracle Database, you will not need to configure your database as a content repository in the P6 EPPM Configuration Wizard. This option is available if your database is hosted on Oracle Server or Oracle Autonomous Database.","If you want to configure Microsoft SharePoint with P6, you must configure it with your CMIS-compliant content repository and then select CMIS for this step. See your CMIS-client content repository documentation for information about how to configure your CMIS-compliant content repository with Microsoft SharePoint.","Click Next.","Using the Content Repository Selection Screen","53055.htm");
Page[58]=new Array("On the Content Repository Configuration screen:","Note Ensure the settings you entered in when you configured the content repository match the settings you enter below.","In the Host field, enter the machine name or IP address of the content repository server.","In the Port field, enter the IntradocServerPort number of the content repository server. By default, this is 4444. To find the port number: ","Navigate to WCCC_Home\\ucm\\cs\\config\\.","Open the config.cfg file.","Find the IntradocServerPort line, which contains the port number.","In the Oracle Home field, enter the path to the P6 EPPM content repository files on the content repository server, as specified when you configured your content repository. This setting is required.","Example:","//Contribution Folders/Production/Oracle Primavera/","In the Oracle Security Group field, enter the name of the Security Group assigned to the document folder created in WebCenter for P6 EPPM documents, as specified when you configured the content repository. ","In the Oracle Security Account field, enter the name of the Security Account for P6 EPPM documents, as specified when you configured the content repository. ","If you did not enable security accounts, leave this setting blank.","In the Oracle Document Type field, enter the document type for P6 EPPM documents, which can be either an existing document type or a new one, as specified when you configured the content repository. ","For example:","Enter the Document Type as Document.","In the Metadata Prefix field, enter the prefix added to P6 EPPM metadata fields, as specified when you configured the content repository. For example, Prm.","In the Admin User field, enter the user name with administrative privileges, as specified when you configured the content repository. This setting is required.","From the Authentication Mode drop-down menu, select the authentication mode used to access the content repository server. P6 EPPM users cannot access content repository functions if you do not configure this setting.","If you choose &quot;Multiple User&quot;, all P6 EPPM content repository-related user names must match the equivalent content repository user name. For example, a P6 EPPM user named &quot;Joe&quot; must have an equivalent user named &quot;Joe&quot; in the content repository. ","If you choose &quot;Single User&quot;, the administrative user specified in the setting above must have access to all appropriate Security Groups to browse to documents outside of the P6 EPPM home folder.","Click Next.","Using the Content Repository Configuration Screen for Oracle Webcenter Content Core Capabilities","53058.htm");
Page[59]=new Array("On the Content Repository Configuration screen:","In the Login Name field, enter the user name for your content repository.","In the Password field, enter the password for the user name you entered above.","In the Authentication Mode field, enter authentication mode used to access the content repository server. P6 EPPM users cannot access content repository functions if you do not configure this setting.","If you choose &quot;Multiple User&quot;, all P6 EPPM content repository-related user names must match the equivalent content repository user name. For example, a P6 EPPM user named &quot;Joe&quot; must have an equivalent user named &quot;Joe&quot; in the content repository.","If you choose &quot;Single User&quot;, the administrative user specified in the setting above must have access to all appropriate Security Groups to browse to documents outside of the P6 EPPM home folder.","In the Repository Name field, enter the name for your content repository.","Note For SharePoint, enter the document library name you created for P6. ","In the Document Home field, enter the location of the folder in the document library where you want to store P6 documents.","In the Web Service URL field, enter the URL for your web services home.","This is Web Service Endpoint with format http://&lt;sharepoint host&gt;/sites/&lt;site name&gt;/_vti_bin/cmissoapwsdl.aspx","Using the Content Repository Configuration Screen for CMIS","78827.htm");
Page[60]=new Array("Note","The SharePoint connector has been removed from version 16.1 and later. New SharePoint users should configure SharePoint with a CMIS-compliant content repository, and then configure P6 EPPM to the CMIS-compliant content repository. ","Do not reconfigure SharePoint with a CMIS-compliant content repository if you previously configured your SharePoint connection using the Primavera P6 Administrator and SharePoint connector. Reconfiguring SharePoint with a CMIS repository will prevent previously stored documents from being visible. For more information, refer to documentation from Version 16.","If you have already used the SharePoint connector to connect P6 EPPM to SharePoint, on the Content Repository Configuration screen:","In the Login Name field, enter a SharePoint user name with administrative privileges.","Note You do not need to include your domain. You just need your user name.","In the Password field, enter the password for the SharePoint login name.","In the Authentication Mode field, select the mode used to connect to the SharePoint content repository database. P6 EPPM users cannot access content repository functions if you do not configure this setting.","If you choose &quot;Multiple User&quot;, all P6 EPPM content repository-related user names must match the equivalent SharePoint user name. For example, a P6 EPPM user named &quot;Joe&quot; must have an equivalent user named &quot;Joe&quot; in SharePoint.","If you choose &quot;Single User&quot;, the administrative user specified in the setting above must have access to all appropriate SharePoint libraries to browse to documents outside of the P6 EPPM home folder.","In the Host Name field, enter the machine name or IP address of the SharePoint server.","In the Domain field, enter the domain where the SharePoint server resides.","In the Document Library URL field, enter the URL of the P6 EPPM document library on SharePoint that you created when you configured SharePoint.&nbsp;The URL includes the machine name (or IP address) of the content repository server and the path to the content repository library.","Example format:","http://&lt;hostname&gt;:&lt;port&gt;/&lt;domain&gt;/&lt;doclib&gt;","Note","Do not put a / at the end of the URL.","Ensure there are no spaces in the URL.","In the Web Service URL field, enter the URL of the Web Service used to connect P6 EPPM to SharePoint, as specified when you configured SharePoint. The URL includes the machine name (or IP address) of the content repository server, port number of the server, and web service name.","Example format:","http://&lt;hostname&gt;:&lt;port&gt;/WS_FPRPC","Note Do not put a / at the end of the URL.","In the External Document Library URL field, enter the URL of an external document library. If you need to connect to a non-P6 EPPM document library, you must configure this setting.","Example format:","http://&lt;hostname&gt;:&lt;port&gt;/&lt;extdoclib&gt;","Note Do not put a / at the end of the URL.","Click Next.","Using the Content Repository Configuration Screen for Microsoft SharePoint","53059.htm");
Page[61]=new Array("On the BI Publisher screen:","Select the Connect to Oracle Analytics Publisher option.","Note If you would rather configure Oracle Analytics Publisher manually or do not have Oracle Analytics Publisher installed, verify the Connect to Oracle Analytics Publisher option is clear and click Next. See the P6 EPPM Oracle Analytics Publisher Configuration Guide for more information.","In the Server URL field, enter the URL used to connect to the Oracle Analytics Publisher web service to P6.","For example, http://serverIP:port/xmlpserver/services/PublicReportService?wsdl","In the Version field, enter the version of Oracle Analytics Publisher that you want to integrate with P6.","In the Folder Paths field, enter the relative path to the Oracle Analytics Publisher P6 reports folder where P6 will search for reports.","Example format (the forward slash is required):","/P6REPORTS","Note You can find the relative path (for example,  /P6Reports) in the following folder: %weblogic_home%\\user_projects\\domains\\bifoundation_domain\\config\\bipublisher\\repository\\P6Reports","In the Admin Username field, enter an Oracle Analytics Publisher web services user name with administrative privileges (for example, PxRptUser).","In the Password field, enter the password for the administrative user name.","Select Personal Folders, to enable personal folders per user. If you do not want to use personal folders, leave the option clear. Users have their own personal folders where they can store their objects. Only the user who created and saved the content in the folder can access the folder.","Select Scrub Username, to enable the setting or leave it clear to ensure it is disabled.","This setting controls whether special characters (non-alphanumeric) are removed from the user name when connecting to Oracle Analytics Publisher. The default is 'false,' meaning special characters will not be removed.","If you are using the P6 EPPM Extended Schema for Oracle Analytics Publisher reporting, leave the setting as false. ","If you are using the P6 ODS Schema for Oracle Analytics Publisher reporting, change the setting to true. Setting the value to true will allow the user's security context (user name) to format properly before it goes to Oracle Analytics Publisher. This allows reporting queries to perform against the ODS tables.","In the Cache Timeout field, enter how long cached report definitions should appear.","The default is 1d.","Click Next.","Using the Oracle Analytics Publisher Screen","53060.htm");
Page[62]=new Array("On the BPM Workflows screen:","Select the Connect to BPM option.","Note If you would rather configure BPM manually or do not have BPM installed, ensure the Connect to BPM option is clear and click Next. For more information, see the P6 EPPM BPM Configuration Guide.","In the Connector file location field, enter the full path (including the file name) where you copied the connector files.","For example:","c:/Software/BPMJars/eppmjars/prm-bpm-connector-12c-v1.0.jar","In the BPM library path field enter the directory where you copied all the jars.","Note","To satisfy these requirements, this admin setting can contain multiple path elements. You must separate multiple path elements with a semicolon.&nbsp;For example: C:\\Software\\BPMJars;C:\\Software\\BPMJars","If the above settings are incorrect or the BPM jar files are incomplete, you will see an error message when you try to configure BPM. Verify that your settings and jar files are correct.","Using the BPM Workflows Screen","53061.htm");
Page[63]=new Array("On the BPM Configuration screen, add the following settings:","In the bpm.user field, enter the BPM user with administrative access to BPM.","In the bpm.password field, enter the password for the user.","In the bpm.t3.url field, enter the T3 URL for your Oracle SOA configuration. For example: t3://&lt;host_name&gt;:&lt;port&gt;/soa-infra","In the bpm.security.realm field, enter the name of the security realm used by BPM.&nbsp;This is jazn.com by default.","In the bpm.soap.url field, enter the URL for the SOAP services. Usually this URL takes the form of http://&lt;host_name&gt;:&lt;port&gt;.","In the bpm.workspace.url field, enter an address in the form of http://&lt;host_name&gt;:&lt;port&gt; that indicates where the BPM Workspace application is hosted.","Note The host can be an IP address or a host name such as a machine name.","In the bpm.partition field, enter the name of the SOA partition containing the BPM composite applications you would like to use in P6.&nbsp;The default partition name is default.","Click Next.","Using the BPM Configuration Screen","54015.htm");
Page[64]=new Array("Once you have finished entering your configuration settings, you can verify all the applications you configured. Once you click Configure, the wizard will setup your P6 EPPM environment and start WebLogic. After the wizard finishes, you will be able to login and use all of your applications.","Completing Your P6 EPPM Installation","53064.htm");
Page[65]=new Array("On the Configuration Review screen:","Verify all your configuration settings are correct.","Click Next.","On the Acknowledgment dialog box, click OK to confirm you have read the information.","If you are upgrading from P6 8.2 or lower version and have been using a content repository configured with P6, you will need to run the Document Migration Utility located in P6 home after the installation completes.","On the Start Configuration? dialog box, click Yes to confirm you want the wizard to configure your applications.","Click No if you do not want to continue with the configuration.","Using the Configuration Review Screen","53065.htm");
Page[66]=new Array("On the Configuration Progress screen, the wizard will let you know when each item is configured. The configuration process will take several minutes. When the configuration is done, all of your applications will have a green check next to them.","The configuration wizard will do any of the following based on the selections you made in the previous screens:","Create your database.","Create or upgrade the Primavera Configuration.","Create a WebLogic domain.","Create bootstrap files for your applications.","Create managed servers and deploy the applications you installed into them.","Configure integrations with other servers for the content repository, your P6 reporting software, and BPM.","Configure URLs to the P6 Help in the Primavera P6 Administrator.","Create Start menu items for P6 EPPM URLs and start/stop scripts. ","Sets your parameters in WebLogic.","For example, it will set your bootstrap variables and Java heap settings for you. This will connect P6 to your other P6 EPPM applications and ensure that your environment is set up for optimal performance.","When the configuration wizard completes this process:","Note the location of the log file. Use the log file to view what happened during setup and see what went wrong if an error occurred.","Click Next.","Using the Configuration Progress Screen","53066.htm");
Page[67]=new Array("On the Configuration Complete screen:","Click any link to go to the default URL for each of your applications.","Click the Save Configuration button.","Note The HTML file you save contains the default URLs and other information for your P6 EPPM applications.","Choose a location where you want to store your HTML file (Oracle recommends using the P6 EPPM directory you created when you installed your applications).","In the File Name field, verify or enter a name for your configuration HTML file.","Click Save.","On the Configuration Saved Successfully dialog box, click OK.","Click Finish.","Note Once you click Finish, the wizard will start WebLogic for you so you can begin using your applications instantly.","Using the Configuration Complete Screen","53067.htm");
Page[68]=new Array("The configuration wizard creates the following defaults.","Oracle Primavera EPPM Home","C:\\p6eppm_1\\ ","Holds all your P6 EPPM applications folders and files","Note","The local drive location is the default the wizard provides. If you changed it, it will be noted in the HTML file you saved in Using the Configuration Complete Screen.","You will need to enter your IP address where it says 'server' in the URLs below.","WebLogic Administration Console","Port: 7001","URL: http://server:7001/console","P6","Port: 8203","URL: http://server:8203/p6","P6 Integration API","Port: 8205","URL: http://server:8205/PrimaveraAPI","P6 EPPM Web Services","Port: 8206","URL: http://server:8206/p6ws/services","P6 mobile","Port: 8207","URL: http://server:8207/p6tmws","Note This is the URL you will enter when you sign into the P6 mobile app on your mobile device. The actual URL will not work in a browser.","P6 Team Member Web","Port: 8207","URL: http://server:8207/p6tmweb","Email Statusing Service","File Name: p6tm-email-service.zip","Default Location: C:\\P6EPPM_1\\tmws or /usr/P6EPPM_1/tmws","Note You will have to unzip the file and configure the email services before you can update status through email. See the P6 EPPM System Administration Guide.","P6 Professional Cloud Connect","Port: 8208","URL: http://server:8208/p6procloudconnect ","Note This URL (case-sensitive) must be provided to P6 Professional users to enable them to setup and configure a new database connection to the P6 Pro Cloud Connect service in the P6 Professional database configuration utility.","For more details on establishing the P6 Pro Cloud Connect connection in P6 Professional, see the P6 ProfessionalInstallation and Configuration Guide (P6 EPPM).","Default Locations Created by the Wizard","54635.htm");
Page[69]=new Array("To verify that the isolation level setting on the upgraded database has been set to &quot;read committed snapshot&quot;:","Open Microsoft SQL Server Management Studio.","Open a new query window for the updated database and run the following command:","dbcc useroptions","Look for isolation level&nbsp;in the Set Option column and verify that the value is set to read committed snapshot.","If the value is read committed snapshot, you do not need to do anything. If the value is set to read committed, proceed to step 5.","Caution Only the connection executing the alter database command is allowed in the database. You must close all connections in the database until the execution of the command finishes.","Run the following command to fix the isolation level setting:","alter database database name set read_committed_snapshot on","Your database is now ready to use with P6 Professional Version 25.","Configuring the Microsoft SQL Server Database","32701.htm");
Page[70]=new Array("Consider the following after you upgrade your database.","Post-Upgrade Procedures","55271.htm");
Page[71]=new Array("To create a Primavera P6 Administrator configuration:","Do one of the following:","On Windows platforms, run dbconfigpv.cmd (located in the p6home directory that you specified when installing P6).","On UNIX platforms, change to the p6home directory that you specified when installing P6, and run dbconfigpv.sh.","On the Setup and Configuration of the Primavera P6 Database dialog box, select the database type.","On the Please enter the following information... dialog box:","Specify the database connection parameters. Type your database user name and password, the database name, host address, and host port. The database name, host address, and host port are specific to your database installation. The Database Host Port field displays the default port for the database type you selected. You can edit this port.","To use the SSL protocol to securely communicate between the P6 application server and the database server, select the SSL option. If you select the SSL option, you must specify an SSL-enabled port number in the Database Host Port field.","Note","See the appropriate database server documentation and the My Oracle Support's Knowledge Articles for information on configuring SSL.","Using the SSL protocol will impact database performance.","Ensure that the Public Group ID is 1 for a standard configuration.","Select Create a new configuration and then enter the name of your new configuration (for example, Team Member Configuration).","Click Next.","Click OK.","Creating a New Primavera P6 Administrator Configuration","89116.htm");
Page[72]=new Array("To update an existing Primavera P6 Administrator configuration:","Do one of the following:","On Windows platforms, run dbconfigpv.cmd (located in the p6home directory that you specified when installing P6).","On UNIX platforms, change to the p6home directory that you specified when installing P6, and run dbconfigpv.sh.","On the Setup and Configuration of the Primavera P6 Database dialog box, select the database type.","On the Please enter the following information dialog box:","Specify the database connection parameters. Type your database user name and password, the database name, host address, and host port. The database name, host address, and host port are specific to your database installation. The Database Host Port field displays the default port for the database type you selected. You can edit this port.","To use the SSL protocol to securely communicate between the P6 application server and the database server, select the SSL option. If you select the SSL option, you must specify an SSL-enabled port number in the Database Host Port field.","Note","See the appropriate database server documentation and the My Oracle Support's Knowledge Articles for information on configuring SSL.","Using the SSL protocol will impact database performance.","Ensure that the Public Group ID is 1 for a standard configuration.","Select Use an existing configuration and then select a configuration from the list.","Click Next.","Click OK.","Updating an Existing Primavera P6 Administrator Configuration","89636.htm");
Page[73]=new Array("Run the migration utility before connecting the upgraded environment back to the Content Repository. Running the migration utility will ensure all project folder names in the Content Repository change from Database IDs to their Project ID field (from P6).","If you upgraded P6 from a previous version, you must:","Go to the P6EPPM_Home/p6 folder.","Run migrationtool.cmd or migrationtool.sh (based on your operating system).","Migrating the Content Repository if Upgrading","78221.htm");
Page[74]=new Array("If you were using a previous version of Universal Content Management (UCM), you will notice many changes when you upgrade to a supported version of WCCC. To maintain your documents from P6, you should ensure that your framework folder has updated correctly. To do this, you should:","Shutdown all the P6 applications connecting to your current content repository. ","Run the migration utility.","Go to the P6EPPM_Home/p6 folder.","Run migrationtool.cmd or migrationtool.sh (based on your operating system).","Note","Users is a restricted folder name for folders within the folder structure in supported versions of WCCC.","Note the folder database converts project IDs to project short names.","Upgrade a previous version of UCM or WCCC to a supported version of WCCC or higher using the upgrade guide provided with the WCCC media packs.","Enable the framework folders components. ","After the migration:","Locate the migration_run**** folder that was created.","Move all the folders and documents under this folder to the Content repository home folder that you want to use.","Ensure you select inhibit propagation to ensure proper movement of documents and folders.","After the move completes, you can start using the documents with the correct content repository home.","Tip","Have 4-6 GB open memory space.","Don't propagate changes when given the option.","Upgrading from Previous Universal Content Management Version to WCCC","65745.htm");
Page[75]=new Array("Before you can use P6 EPPM after your upgrade, you must restart your application server.","Starting the Application Server","89415.htm");
Page[76]=new Array("To start WebLogic:","Navigate to the &lt;weblogic_home&gt;/user_projects/domains/&lt;your_domain&gt; directory.","Run the startWebLogic script.","startWeblogic.cmd on Windows machine","startWeblogic.sh on Unix machine","If prompted for a user name and password in the WebLogic console window, type in the administrative user name and password you specified when creating the domain.","Starting WebLogic for P6 EPPM Applications","89416.htm");
Page[77]=new Array("After you have converted your Methodology Management data to projects and upgraded your database, you can create your project templates.","To create a project template:","Click Projects.","On the Projects navigation bar, click EPS.","On the EPS page, click the Actions&nbsp;@ menu and select Add&nbsp;@ Add Project Template.","In the Add Project Template dialog box, choose the General tab.","On the General tab:","In the Template ID field, type in a unique ID for the template.","In the Template Name field, type in a unique name for the template.","In the EPS field, click the corresponding @ and choose the EPS where you want to store the template.","In the Responsible Manager field, click the corresponding @ and choose a responsible manager.","In the Copy from existing project or template field, click the corresponding @ and choose the methodology project you created in Converting Methodologies to Projects.","Click Create.","Creating a Project Template From Projects","44847.htm");
Page[78]=new Array("From release 18, classic views are no longer available in P6. You can export classic views to import them as standard views. When you import the exported classic views, they are imported as user views. To make the newly imported views accessible to other users, you can cut or copy and paste the views to the Global or Multiple Users groups.","Note Although classic views can no longer be used from release 18, they are not removed from the database during the upgrade process and can still be exported after upgrade.","To convert classic views to standard views:","Click Projects or Resources.","On the Projects navigation bar, click Activities, EPS, or Assignments.","On the Resources navigation bar, click Assignments.","Click the Views&nbsp;@ menu and select Import/Export Views....","In the Import/Export Views dialog box:","Click Export.","Select the Classic Views option.","Select the views you want to export.","Click Export.","Click the Views&nbsp;@ menu and select Import/Export Views....","In the Import/Export Views dialog box:","Click Import.","In the File field, click @&nbsp;Browse and select the file you exported.","Select the views to import.","Click Import.","Tip","When you export classic views, they are exported to a file in your default download location. The file name includes the name of the page the views were exported from, your user name, and the date and time the file was exported. The file extension is .json.","You can export classic views from the EPS, Activities, and Assignments pages and convert them to standard views on each of those pages. You cannot export views from multiple pages into one file.","Some classic view settings cannot be converted to standard views, for example bar color coding. These settings will be lost when you convert your classic views into standard views.","Converting Classic Views to Standard Views","98724.htm");
Page[79]=new Array("The following list summarizes the procedures you need to perform after upgrading P6 EPPM:","User Name and Password Procedures","For security reasons, Oracle strongly recommends that you replace the default database users' (admuser, privuser, pubuser, bgjobuser, and PxRptUser) passwords immediately after a manual database installation or an upgrade from P6 version 7.0 and earlier. Do not use special characters in the database name, privileged user, public user, or PX Reporting user name for example: { } [ ] : ; &lt; &gt; , . ? ! @ # $ % ^ &amp; * ( ) - _ | / \\ ~ `  ","Oracle recommends using strong passwords. Strong passwords in P6 EPPM contain between 8 and 20 characters and at least one numeric and one alpha character. To further strengthen the password, use a mixture of upper and lower case letters.","See Modifying Private Database Logins for P6 EPPM for instructions on how to replace the private database login. For all other database user names and passwords, use the tools included with the database.","Application Configuration Procedures","Install the new P6, P6 Professional, and any additional components.","Assign new or modified privileges to users. See information about defining global security and project security profiles in the P6 EPPM Application Administration Guide. ","Requirements After the Upgrade from R8 or later to 16 R2","49783.htm");
Page[80]=new Array("The following list summarizes the procedures required and recommended to perform AFTER upgrading P6 EPPM:","User Name and Password Procedures","For security reasons, Oracle strongly recommends that you replace the default database users' (admuser, privuser, pubuser, bgjobuser, and PxRptUser) passwords immediately after a manual database installation or an upgrade from P6 version 7.0 and earlier. Do not use special characters in the database name, privileged user, public user, or PX Reporting user name for example: { } [ ] : ; &lt; &gt; , . ? ! @ # $ % ^ &amp; * ( ) - _ | / \\ ~ `  ","Oracle recommends using strong passwords. Strong passwords in P6 EPPM contain between 8 and 20 characters and at least one numeric and one alpha character. To further strengthen the password, use a mixture of upper and lower case letters.","See Modifying Private Database Logins for P6 EPPM for instructions on how to replace the private database login. For all other database user names and passwords, use the tools included with the database.","Application Configuration Procedures","Install the new P6, P6 Professional, and any additional components. ","Starting with P6 EPPM R8, all recurring job service functions are hosted by P6. Due to this change, after upgrading to P6 EPPM R8 or later, you must configure Scheduled Services settings in the Primavera P6 Administrator to use this functionality. Also, if you're upgrading from version 7.0 or earlier, you must RESUMMARIZE ALL PROJECTS to accurately reflect your summary data. See the P6 EPPM System Administration Guide for information on Scheduled Services and configuring separate servers for job services.","Assign new or modified privileges to users. See information about global and project security profiles in the P6 EPPM Application Administration Guide. ","All previously defined module access (except Contributor module access (formerly Team Member)), security profiles, OBS access, and resource security settings will still apply to existing users after the database upgrade. For users who had Contributor and P6 Professional module access, they will keep their access during the database upgrade; however, once you edit these users post-upgrade, P6 will remove Contributor module access to comply with P6 EPPM functionality. The upgrade process will remove only Contributor access during the upgrade if users had Contributor and additional module access assignments other than P6 Professional; all other assignments will remain selected. See the P6 EPPM Application Administration Guide for information on defining module access, security profiles, OBS access, and resource security.","During the upgrade to the latest version of P6 EPPM, some P6 Activity Views settings will reset. After the upgrade, use the Customize Detail Windows feature to modify the settings that should appear for each view. See the P6 Help for information on how to edit Activity Views.","Starting with P6 EPPM R8, P6 saves filter definitions globally. Filters still work for Activity Views, but all standard filter assignments reset during the upgrade. Due to this change, views that had Standard Filters applied will show all activities after the upgrade. Reapply filters after the upgrade finishes. See the P6 Help for information on how to edit Activity Views.","Security Procedures","For security reasons, Oracle strongly recommends that on-premises users replace the default Admin Superuser (admin) immediately after a manual database installation or an upgrade from P6 version 7.0 and earlier. See information on the default Admin Superuser in the P6 EPPM Application Administration Guide for guidelines on this process.","Requirements After the Upgrade from Version 6.2.1 through 7.0 to 16 R2","49789.htm");
Page[81]=new Array("Once you have updated all of your configurations, you should clear the cache in your browser. If you do not clear your cache, the P6 EPPM Help might not display correctly. For more information about clearing the cache in your browser, see your browser help.","Clearing the Cache","89635.htm");
Page[82]=new Array("Now that you've installed all of your P6 EPPM applications, you can begin using P6. You may find the following guides useful to get started:","P6 EPPM System Administration Guide","Note You can use this guide to configure Email Statusing Service.","P6 EPPM Application Administration Guide","P6 Help","Where To Go From Here - Post Configuration Wizard","52007.htm");
Page[83]=new Array("After you have installed and configured your P6 EPPM applications, you can launch your applications by doing the following:","Go to the scripts folder where you installed P6 EPPM (for example, C:\\P6EPPM_1\\scripts or /usr/P6EPPM_1/scripts).","If you are on Windows, launch the start_Primavera.bat.","If you are on Linux, launch the start_Primavera.sh.","Note You need to launch the file only once unless you stop the server or need to restart the machine.","Open the HTML file you saved when you finished your configuration and choose the URL for the application you want to launch.","Login to the application.","Tip","If you are on Windows, you can use the Start menu to launch your applications.","Go to Start, P6 EPPM.","Select the start_Primavera.bat file and wait for it to say running.","Select the application you want to launch and login.","If you want to set up the WebLogic Admin Server and Managed Servers to run as Windows Services, see WebLogic's documentation.","Launching Your P6 EPPM Applications","53676.htm");
Page[84]=new Array("You have several options for starting and stopping managed servers. Oracle recommends that you use the startNodeManager file and start the server in the WebLogic Administration Console (see Starting a Managed Server). However, you can view other ways to stop and start managed servers at &quot;Managing Server Startup and Shutdown for Oracle WebLogic Server&quot; at https://docs.oracle.com/middleware/1221/wls/START/overview.htm.","Note You can use different ways to start the managed servers, but you must ensure that the managed servers recognize the arguments required for your application (for example, the argument for where the bootstrap is located) and how the application environment will start.","Starting and Stopping Managed Servers","48157.htm");
Page[85]=new Array("Note When starting/stopping an environment using the node manager, the StartScriptEnabled setting in the nodemanager.properties file must equal true. Example: StartScriptEnabled=true","To start a managed server in the WebLogic Administration Console:","Run one of the following:","(with Windows)","&lt;weblogic_home&gt;\\server\\bin\\startNodeManager.cmd","(with UNIX or Linux)","&lt;weblogic_home&gt;\\server\\bin\\startNodeManager.sh","Launch the WebLogic Administration Console.","Note You can open the Administration Console via a web browser at http://&lt;serverIP&gt;:&lt;listenport&gt;/console. The default &lt;listenport&gt; is 7001.","In the Welcome&nbsp;window, log in using the user name and password that you created when you created your WebLogic domain.","On the Change Center pane of the Administration Console, click Lock &amp; Edit.","In the Domain Structure pane:","Expand Environment.","Click Servers.","In the Summary of Servers pane:","Select the Control tab.","Select the option for your managed server.","Click Start.","In the Server Life Cycle Assistant pane, click Yes.","In the Summary of Servers pane, click the 'Start Refresh' icon in the middle of the pane to see when the State column says 'RUNNING.'","Starting a Managed Server","50104.htm");
Page[86]=new Array("To stop a managed server:","In the Change Center pane, click Lock &amp; Edit.","In the Domain Structure&nbsp;pane, click Deployments.","In the Summary of Deployments&nbsp;pane, select the managed server that you want to stop.","In the Summary of Deployments&nbsp;pane, navigate to the Control tab and then complete the following:","Click the down arrow to the right of the Stop&nbsp;button.","Click one of the options to stop the managed server.","In the Start Application Assistant&nbsp;pane, click Yes.","In the Change Center pane, click Release Configuration.","Stopping a Managed Server","50105.htm");
Page[87]=new Array("The following applications will work with P6 EPPM, but are not installed or configured with the wizard. See the guides mentioned for more information about each product.","P6 Professional (see the P6 Professional Installation and Configuration Guide)","Oracle Identity Manager (see P6 EPPM Oracle Identity Manager Configuration Guide)","Oracle Enterprise Manager (see Primavera Oracle Enterprise Manager Configuration Guide)","Oracle Access Manager (see Primavera Oracle Access Manager Configuration Guide)","Oracle Analytics Publisher (see P6 EPPM Oracle Analytics Publisher Configuration Guide)","Oracle BPM (see P6 EPPM BPM Configuration Guide)","Installing Additional Applications","53142.htm");
var PageCount=88;


/*
Date: 12/9/2025 11:49 AM
Source: EPPM_25_dev
BookID: 52577
PubProduct: PRIMAVERA_EPPM
BookTitle: Upgrade and Configuration Guide for On-Premises
Version: Version 25
Lang:	en
*/
	var PageLength=Page.length;
	var Result = "";
	var ResultTemp = "";
	var ResultFound = "";
	var ResultTitleOnly = [];
	var ResultTitleAndContent = [];
	var ResultInContent = [];
	var ResultInContentTemp = [];

	var ResultCombinedTemp = [];
	var ResultCombined = [];

	var arrayIndex = 0;
	var NrRes = 0;
	var j = 0;
	var i = 0;
	var k = 0;
	var d = 0;
	var maxItems = 1000;
	var heading = 0;
	var WordPos = -1;
	var WordPosHeading = -1;
	var WordPosContentText = -1;
	var FoundWord = "";
	var FoundWordHead = "";
	var SearchInHeadingOnly = 0;
	var isChecked;
	var size = 10;
	var resGroupCounter = 0;
	var shown = "shown";
	var checkBoxInHeading;
	var searchFlag = 0;
	var DivResult;
	var SearchWord;

if (SearchText && SearchText.length >= 1) {
		SearchWord = SearchText.replace(/\+/g, " ").replace(/&/g, "&amp;").replace(/</g, "&lt;").replace(/>/g, "&gt;").replace(/"/g, "&quot;");
		searchFlag = 1;
	} else {
		SearchWord = "";
		searchFlag = 0;
	}
	

	if (searchFlag === 1) {
		Result = "";

		// checkBoxInHeading = document.getElementById("inHeading");
		if (inHeading) {

			isChecked = true;
		} else {

			isChecked = false;
		}

		if (SearchWord && SearchWord.length >= 1) {
			if (isChecked) {
				SearchInHeadingOnly = 1;
			} else {
				SearchInHeadingOnly = 0;
			}
			SearchWord = SearchWord.toLowerCase();
			window.status = "Searching, please wait...";
			for (j = 0; j < PageLength; j++) {
				k = Page[j].length - 1;
				for (i = 0; i < k; i++) {

					heading = k - 1;

					if (SearchInHeadingOnly === 1) {
						WordPosHeading = Page[j][heading].toLowerCase().indexOf(SearchWord);
						if (WordPosHeading > -1) {
							FoundWordHead = Page[j][heading].substr(WordPosHeading, SearchWord.length);

							NrRes++;
							ResultTemp = "<li>";
							ResultTemp += "<span>";
							ResultTemp += "<a href='" + Page[j][k] + "'>" + Page[j][heading].replace(FoundWordHead, FoundWordHead.bold()) + "</a><br/>\n";

							ResultTemp += "</span>";
							ResultTemp += "</li>";

							ResultTitleOnly[arrayIndex] = ResultTemp;
							arrayIndex++;

							ResultTemp = "";
							WordPosHeading = -1;
							WordPosContentText = -1;
							break;
						}
					} else if (SearchInHeadingOnly === 0) {
						WordPos = Page[j][i].toLowerCase().indexOf(SearchWord);
						WordPosHeading = Page[j][heading].toLowerCase().indexOf(SearchWord);
						if (WordPos > -1) {
							FoundWordHead = Page[j][heading].substr(WordPosHeading, SearchWord.length);
							FoundWord = Page[j][i].substr(WordPos, SearchWord.length);
							FoundWord = Page[j][i].substr(WordPos, SearchWord.length);
							NrRes++;
							ResultTemp += "<li>";
							ResultTemp += "<span>";
							if (WordPosHeading > -1) {
								ResultTemp += "<a href='" + Page[j][k] + "'>" + Page[j][heading].replace(FoundWordHead, FoundWordHead.bold()) + "</a><br/>\n";
							} else {
								// found word is not in the head
								ResultTemp += "<a href='" + Page[j][k] + "'>" + Page[j][heading] + "</a><br/>\n";

							}
							if (i < k - 1) {
								WordPosContentText = Page[j][i].toLowerCase().indexOf(SearchWord);

								if (Page[j][i].length > 300 && (WordPosContentText > -1)) {

									if (WordPosContentText > 75) {
										ResultInContentTemp.push("..." + Page[j][i].substr(WordPosContentText - 75, 175 + FoundWord.length).replace(FoundWord, FoundWord.bold()) + "...");
									} else {
										ResultInContentTemp.push("..." + Page[j][i].substr(0, 175 + FoundWord.length).replace(FoundWord, FoundWord.bold()) + "...");

									}

								} else if (WordPosContentText > -1) {

									ResultInContentTemp.push(Page[j][i].replace(FoundWord, FoundWord.bold()));

								}
							}

							ResultTemp += ResultInContentTemp.join("");

							ResultTemp += "</span>";
							ResultTemp += "</li>";

							if (WordPosHeading > -1) {
								ResultTitleAndContent[arrayIndex] = ResultTemp;
								arrayIndex++;
							} else {
								ResultInContent[arrayIndex] = ResultTemp;
								arrayIndex++;
							}

							ResultInContentTemp.length = 0;
							ResultTemp = "";
							WordPosHeading = -1;
							WordPosContentText = -1;
							break;
						}

					}
				}
			}

			ResultTitleOnly = ResultTitleOnly.filter(function (n) {
				return (n !== undefined && n !== null);
			});
			ResultTitleAndContent = ResultTitleAndContent.filter(function (n) {
				return (n !== undefined && n !== null);
			});
			ResultInContent = ResultInContent.filter(function (n) {
				return (n !== undefined && n !== null);
			});

			ResultCombinedTemp = ResultTitleOnly.concat(ResultTitleAndContent, ResultInContent);

			ResultCombinedTemp = ResultCombinedTemp.filter(function (n) {
				return (n !== undefined && n !== null);
			});

			for (d = 0; d < ResultCombinedTemp.length; d += size) {
				resGroupCounter++
				ResultCombined.push("<div id=" + "'" + "resGroup_" + resGroupCounter + "'" + " class=" + "'" + "resGroup " + shown + "'" + ">" + "<ol class='searchResults'>" + ResultCombinedTemp.slice(d, d + size).join("") + "</ol></div>");
				shown = "notshown";
			}

			ResultFound = ResultCombined.join("");

Result += "<div id='searchDetailsDiv'>";
			Result += "<p class='searchDetails'>Your Search Found&nbsp;" + NrRes + "&nbsp;items.&nbsp;";
			Result += "</p></div>";
			
			Result += "<div class='searchResultsDiv'>";
			Result += "<div id='resultsCollection' class='searchResults'>";
			Result += ResultFound;
			Result += "</div>";
			Result += "</div>";
			Result += "<div class='searchPaging'>";

			Result += '<hr />';

			Result += '<p class="bodytext"><a class="disabledAnchor" id="pBack" onclick="turnPage(\'backPage\')" href="#pBack">Back</a>&nbsp; | &nbsp;';
			
			if (resGroupCounter && resGroupCounter > 1) {
				Result += '<a id="pNext" onclick="turnPage(\'nextPage\')" href="#pNext">Next</a>';
			} else {
				Result += '<a id="pNext"  class="disabledAnchor" href="#pNext">Next</a>';
			}
			Result += '</p>\n';
			Result += '<div id="pagenofn"><p class="bodytext">Page <span id="pagen">1</span> of ' + resGroupCounter + '</p></div>';

			Result += "</div>";
			
			
		}

		DivResult = document.getElementById("s_anchor");
		if (Result && DivResult) {

			//myDivResult.append(Result);
			DivResult.innerHTML = Result;
			

		}
		window.status = "";
		
		

	}
	}())
}
