'use strict';
function search(SearchText, inHeading) {
(function () {
var Page = [];

/* Generated with Author-it 23.4.1.30004  12/11/2025 7:32:50 PM */
Page[0]=new Array("Title and Copyright Information","Copyright  1999, 2025, Oracle and/or its affiliates.","Primary Author: Oracle Corporation","Title and Copyright Information","46576.htm");
Page[1]=new Array("Scope","This guide describes how to:","Determine when an upgrade is appropriate for your organization.","Evaluate common upgrade paths.","Create an upgrade agenda for your organization. ","You should consider upgrading your current P6 EPPM if upgrading will:","Provide access to new functionality and applications that assist your organization in meeting business objectives.","Facilitate compliance at a lower cost through retiring customizations.","Allow you to leverage performance and usability enhancements to increase the efficiency of your applications and your business processes.","Ensure you remain eligible for the highest levels of product support.","When you evaluate an upgrade, you should consider support timeframes, functional capabilities, technical infrastructure, and underlying business needs.","Audience","System and database administrators should use this guide.","Using This Guide","This guide assumes you understand your organization's business procedures and technical environment.","About This Guide","62982.htm");
Page[2]=new Array("Before upgrading, you should review the upgrade process, potential upgrade paths, and your upgrade criteria.","Upgrade Overview","62983.htm");
Page[3]=new Array("An upgrade is similar to an implementation; however, upgrades are more efficient because they leverage your previous implementation, acquired knowledge, and outputs. You can also upgrade within your organization's change management system.","The five phases of an upgrade are:","Scope","Design","Configure","Go-Live","Optimize","The following graphic presents the lifecycle of a typical P6 EPPM upgrade project.","The technology activities associated with an upgrade typically represent one-third of the overall project workload and include upgrading the application objects, master configuration data, and business transactional data that comprise the foundation for development and functional activities.","Upgrade Process","62984.htm");
Page[4]=new Array("Prior to upgrading:","Review your configuration for the hardware and software used to support P6 EPPM. ","Compare the information in the Tested Configurations document for the new release against your inventory to determine gaps in your infrastructure. ","Have your enterprise servers and database servers sized by your hardware partner. ","P6 EPPM may have a different processing footprint than your current release. Many users retire old servers during an upgrade, using the updated server hardware for the upgrade.","Plan how to deploy the Web application server technology in your infrastructure to meet IT and business requirements.","Note Oracle Consulting or an Oracle partner can provide technology assessments and architectural planning workshops to guide you through these processes.","Assessing the Technical Environment","62986.htm");
Page[5]=new Array("To prepare for the upgrade:","Copy the entire production environment into one of the environments you will initially upgrade.","This copy allows the upgrade team to work with the most current set of transactional data for testing and to utilize any custom modifications.","Ensure you have installed all servers and validated them against the minimum technical and software requirements for P6 EPPM.","Ensure you have installed and configured a web application server.","Download the P6 EPPM media pack from Oracle Software Delivery Cloud. ","Also, download the latest service packs available for the P6 EPPM release.","Preparing for the Upgrade","62987.htm");
Page[6]=new Array("Use the P6 EPPM Upgrade and Configuration Guide to help you upgrade P6 EPPM.","Upgrading P6 EPPM","62988.htm");
Page[7]=new Array("After you upgrade:","Apply current service packs available for the release. ","Build and deploy a full set of client and server packages.","Run a series of processes that surface tests the environments.","Give the environment to the appropriate project teams for testing and development.","Post-Upgrade Processes","62989.htm");
Page[8]=new Array("You should consider the following for your upgrade criteria: ","Application functionality","Technological enhancements","Operational considerations","Support availability","Examining Your Upgrade Criteria","62991.htm");
Page[9]=new Array("P6 EPPM delivers role-based interfaces that allow you to tailor functionality for the appropriate members of the project team. Each P6 EPPM module has been designed with specific project leaders in mind. ","When considering an upgrade, you should assess the new capabilities and enhancements to current features provided in the new release to decide if they are worth the time it takes to do an upgrade. Often, the new capabilities can offer several productivity advantages, including increased business value and lower operational costs. When assessing a new P6 EPPM release, think about your current environment and whether it meets your current needs and the demands of your business for the next three to five years.","What's New in P6 EPPM will help you evaluate the changes in the new release. ","Your Oracle Consulting sales representative can help you identify new features, functionality, and processes that may provide value to your organization.","Application Functionality","62992.htm");
Page[10]=new Array("You should consider your technical infrastructure requirements, including client architecture, application server, web services, and database options. Consider what has changed or what will change in terms of platform support, and also be aware of infrastructure enhancements that may provide additional benefits to your production environments. For example, by choosing to leverage Oracle Fusion Middleware and database options, you could experience productivity benefits by having your database and application server running on a single platform.","Technological Enhancements","63007.htm");
Page[11]=new Array("Oracle continues to deliver improvements that will further reduce implementation costs, enhance usability, and increase supportability.","If you are running more than one instance of P6 EPPM, you should consider the cost, risk, and operational value of instance consolidation in your upgrade value analysis.","Operational Considerations","63011.htm");
Page[12]=new Array("Oracle provides visibility into product road maps and helps customers derive continual success from their current applications by delivering development and support. Upgrading will ensure continued access to robust technical support. Oracle Applications Unlimited provides continued enhancements to current Oracle applications beyond the delivery of Oracle Fusion applications. With the guaranteed support announced through the Oracle Lifetime Support initiative, Oracle customers can remain on their P6 EPPM applications and have support for currently supported platforms. ","Support Availability","63093.htm");
Page[13]=new Array("Oracle has gathered tips and techniques from hundreds of experienced systems managers, consultants, and partners. These recommendations will help you manage a successful upgrade.","Upgrade Best Practices","63013.htm");
Page[14]=new Array("To determine your upgrade path:","Use the Tested Configurations document to determine supported upgrade paths for major releases.","Verify whether you can upgrade directly to the target release or whether you must first upgrade to a previous release before moving to the target release. ","Evaluate the complexity of your upgrade based on the number of modules implemented, number of integration points, number of interfaces, total number of business process scripts, and number of customizations to include. ","Determine the metrics and cost associated with each aspect of the upgrade.","Determining Your Upgrade Path","63014.htm");
Page[15]=new Array("To make the upgrade a formal project:","Have a structured approach for managing tasks, resolving issues, and measuring progress.","Define and document the upgrade's scope.","Have someone on the team with experience managing technical projects who can also help you anticipate and manage the effects of this initiative on other parts of the organization including end users, managers, and executives.","Treating Your Upgrade Activity as a Formal Company Project","63015.htm");
Page[16]=new Array("When upgrading, you must:","Manage development, application configuration, and technology changes. ","Freeze metadata and system data in your production environment. ","Ensure you have applied all relevant patches appropriately.","Search for issues throughout your upgrade effort and schedule relevant updates until you reach a &#8220;go/no-go&#8221; milestone. ","Enforce a new release content freeze to stabilize the environment.","Using an Appropriate Change Management Strategy","63024.htm");
Page[17]=new Array("Several different skill sets will be necessary to successfully upgrade your system. Oracle recommends you have the following roles on your upgrade team:","Role","Status","Responsibility","Steering Committee/Executive Sponsor","Required","Oversees the project, assigns additional resources and funding, and decides when the upgrade is ready. Meets regularly.","Project Manager","Required","Manages progress and monitors issues.","Technical Upgrader","Required","Initiates the technical upgrade.","Testers","Required","Validates the new system. You will need coverage across all implemented processes.","System Admin","Required","Manages fixes, patches, and hardware requirements.","Support","Required","Responds to issues, particularly right after go-live.","Performance Tuner","Required","Gets maximum performance from your infrastructure. Consider contracting with a consultant with specific tuning experience.","Developer","Optional","Retrofits custom modifications.","Trainers","Optional","Trains your end users. These can be power users, outside consultants, and so on.","Building an Upgrade Team with Broad and Complementary Skills","63025.htm");
Page[18]=new Array("Use Oracle resources to help you gather current information for your project and work with Oracle Support for critical case management throughout your conversion timeframe. Start with My Oracle Support Product Advisors (formally known as Product Information Centers) for upgrade information. Finally, make sure you get the most current documentation available. Oracle provides several types of documentation to help you navigate a successful upgrade project.","Most organizations upgrade infrequently; it helps to leverage the experiences of others as much as possible. Use the following links to interact with other P6 EPPM users:","Customer Forums","Facebook/OracleConstEng","X (Formerly Twitter)/OracleConstEng","Oracle Primavera LinkedIn","Utilizing Peer and Oracle Resources","63026.htm");
Page[19]=new Array("When upgrading, you should answer the following:","Are you upgrading to implement the new functionality?","Are you upgrading your current processes without changing functionality, but may implement the new functionality later?","Implementing your current processes in a new system can mitigate risk in the upgrade. However, your business realities may preclude this approach, especially if the updated processes in the software can improve operations. For example, the business might choose to take advantage of new capabilities as quickly as possible, or it may be more appropriate to modify processes and engage in a coordinated training effort to increase user adoption of the new solution.","Weigh the pros and cons of these approaches to choose the best strategy for your organization.","Deciding When to Change or Add Business Processes","63027.htm");
Page[20]=new Array("The upgrade team should:","Create an issues list, update it regularly, and assign owners to issues.","Identify specific applications, forms, and actions that could have issues. ","Log issues early and include appropriate trace files, environment information, and business and technical milestone dates to help determine its priority in getting fixed. Contact Oracle Support if you believe you are experiencing application issues. ","Oracle recommends reviewing escalation policies and assigning Severity 1 (Sev1) issues as appropriate. These issues are typically on the critical path for your go-live and resolving them early will help you stay on schedule. You should always log Sev1 cases via My Oracle Support to document the issue fully, but the best practice is to follow-up with a call to Support to ensure efficient follow-through.","Even when you encounter noncritical issues (non-Sev1s), Oracle recommends reporting issues on the My Oracle Support site. Issues logged on the site are resolved faster than calls to the Support Center.","Managing Issues","63029.htm");
Page[21]=new Array("To prepare your organization for the upgrade:","Develop a project charter to capture baseline information. ","Obtain formal buy-in from the stakeholder organizations. You should discuss both the business impact of the change and the associated change schedule. For example, secure agreement on all business blackout periods necessary for system changes.","Kick off the project in a face-to-face meeting.","Preparing the Organization","63030.htm");
Page[22]=new Array("Before an upgrade:","Review what practices are in place for handling data.","Review what practices you need to create to ensure that your data is relevant and reliable. ","Ensure your data is accurate by having a standard practice to:","Handle duplicate records.","Verify data integrity.","Verify the overall health of your data.","Ensuring the Quality of Your Data","63031.htm");
Page[23]=new Array("To ensure you take accurate inventory:","Create a preliminary upgrade questionnaire that includes all configuration elements of your enterprise system.","Inventory the following:","Customizations, extensions, and modifications","Localizations","Interfaces, APIs, and integrations","Third-party products","Hardware","Software releases and patches, including operating system, database, and P6 EPPM applications","Copy the current versions and store them for technical change management control.","Taking Inventory for Your System","63032.htm");
Page[24]=new Array("Once you have completed the initial planning:","Create a checklist of criteria to guide deploying the upgrade. ","Assess appropriate &#8220;go/no-go&#8221; criteria based on your planning activities. ","Organize project goals.","Identify your success criteria.","Validate your plan.","Keep the checklist updated as the project progresses and document completion times for individual tasks.","Preparing a Go-Live Checklist","63033.htm");
Page[25]=new Array("To control project risks:","Do a risk analysis early in the upgrade process. ","Look for key failure points, especially with resource loading for your technical and business specialists. ","If you lack resources, develop a plan to supplement and backup critical personnel.","Determine project risks such as resource contention and other projects going live at the same time. ","For risks that have a high probability of occurring and have a large impact, develop specific mitigation plans that describe what actions to take if the risk becomes reality. ","Review the analysis and plans on a regular basis. ","Understanding and Mitigating Project Risks","63034.htm");
Page[26]=new Array("Changing the architecture may be mandatory depending on the version of the applications you are using. If you are going to change your architecture:","Determine when to make this change.","Account for the technical work involved. ","Communicate the architecture change to your organization and create consensus to minimize disruptions. ","Evaluate whether you need to change the following architectures:","Hardware Platform The hardware change should take place prior to the upgrade or after the upgrade finishes. You may need to change the hardware prior to the upgrade for the following reasons: new data size requirements, CPU capacity, platform age (generally lasts about 3 to 5 years), changing the complete hardware stack to a different technology. Review the Tested Configurations document to determine which platforms support which versions of P6 EPPM, related tools, hardware drivers, and required patches. ","Database Size requirements and database features will affect upgrading the database. You should evaluate availability and disaster recovery when determining which database platform to use. Refer to the Tested Configurations document when making upgrade decisions. P6 EPPM will not support all versions of a database.","Middleware P6 EPPM supports Oracle Fusion Middleware products (for example, WebLogic).","Unicode You may need to convert your database to Unicode. Most have data in a non-Unicode format. Knowing which option you will use will clarify hardware and project requirements.","Web Architecture P6 EPPM products are mostly online, with optional desktop clients. This allows flexibility as to where clients can reside, but may require architecture changes. Refer to the Tested Configurations document to determine client hardware and software requirements. Remember to consider whether you need remote development.","Evaluating Your Architecture","63035.htm");
Page[27]=new Array("The following could impact your sizing requirements:","Expanded P6 EPPM product functionality","Technological changes","Changes in the way you use the applications","Implementation of new modules","Accurate sizing information will help you decide whether you can reuse current hardware, need to increase hardware resources, or should consider upgrading one or more of your servers. Performance and load testing can help determine if the hardware will support your production requirements. For more information, refer to the P6 EPPM Performance and Sizing Guide.","Calculating New Hardware Sizing","63036.htm");
Page[28]=new Array("An upgrade can impact custom code integrated with P6 EPPM. The upgrade brings your custom changes into the new release based on system code associated with objects. The upgrade will consider objects that are incorrectly coded to system codes obsolete and will not bring them into the upgraded version. To avoid this:","Ensure all custom changes are coded correctly.","Test all interfaces and customizations to ensure changes to tables, APIs, or Web Services in the upgraded software do not affect them. ","Review and update custom responsibilities and menus. ","Note In some cases, you can remove customizations after an upgrade if new features and functionality satisfy these business requirements.","Identifying Custom Code and Scripting","63037.htm");
Page[29]=new Array("Review requirements in the Tested Configurations document early to ensure you have the right components and understand any updates or changes and how they will affect your upgrade.","Adhering to Current Tested Configurations Requirements","63048.htm");
Page[30]=new Array("Ensure you have the most current code before you invest in the testing, configuration, and validation associated with going live. This process involves applying the most recent patches to your environment. For all P6 EPPM release upgrades, you should install the current service packs immediately after you install P6 EPPM.","Implementing the Current P6 EPPM Release and Patches","63049.htm");
Page[31]=new Array("Minimize the amount of data you need to upgrade by archiving and purging your data before the upgrade. If you do not have a strategy for archiving and purging data, you should create one before you begin the upgrade process.","Minimizing Application Data to Upgrade","63050.htm");
Page[32]=new Array("Working with a current copy of your production data will give you information about how to structure the testing process and how long it will take to complete. Typically, your first conversion will be the longest and the most difficult.","Copy your production data into your development or prototyping environment before beginning the technical upgrade steps. ","As you progress through the upgrade project, continue to work with accurate, current data.","Maintain a fresh copy of your data. This ensures the highest data quality and will accurately estimate how long the upgrade data will take to convert.","Testing a Copy of the Production Database","63070.htm");
Page[33]=new Array("To prepare test scripts for testing cycles:","Use the test scripts utilized when you initially implemented P6 EPPM.","Add the new features and functionality test scripts to your existing test scripts.","Modify the process flow as needed for the upgrade.","If test materials do not exist from the original implementation or previous upgrade, create them and store them in a library.","Leveraging Existing Test Scripts and Plans","63078.htm");
Page[34]=new Array("If you created custom indexes in your current release, you need to evaluate whether you need them for the new release. You will need to re-create them after the upgrade finishes.","Performing Index Management","63079.htm");
Page[35]=new Array("Provide your end users and those testing the system with information about how the upgrade is different (e.g., functional changes, user interface, or technical changes). This information will prevent users from reporting non-issues and allow them to better work with the upgrade. Oracle University can also provide training, and My Oracle Support provides training and informational Webcasts.","Training End Users on the New Solution","63080.htm");
Page[36]=new Array("Review the following best practices for what you should do after you complete the upgrade.","Post-Upgrade Best Practices","63083.htm");
Page[37]=new Array("Most projects require functional users to leave their main responsibilities to test the upgrade. Ensure you have both management and individual support of the upgrade. Once you have the support, ensure you allocate enough time to complete a thorough testing cycle.","Securing Functional User Buy-In","63082.htm");
Page[38]=new Array("To go live:","Perform comprehensive testing on the upgrade. ","Treat testing of the upgrade as a major software update. ","Perform user acceptance testing and performance testing to test all business processes the organization will use. ","Note You can also use automated testing tools, but you should use them with user testing as well.","Testing Scope","63084.htm");
Page[39]=new Array("The upgrade team should:","Ensure they have enough information to defend a &quot;go&quot; or &quot;no go&quot; decision.","Utilize the go-live checklist created earlier in the upgrade process to verify that the upgrade meets all success criteria. ","Involve both business and IT groups in this decision. ","Gather input from all stakeholders ahead of time to allow for an informed and supported decision.","Deciding to Go Live","63085.htm");
var PageCount=40;


/*
Date: 12/11/2025 7:32 PM
Source: EPPM_25_dev
BookID: 62981
PubProduct: PRIMAVERA_EPPM
BookTitle: Upgrade Best Practices Guide for On-Premises
Version: Version 25
Lang:	en
*/
	var PageLength=Page.length;
	var Result = "";
	var ResultTemp = "";
	var ResultFound = "";
	var ResultTitleOnly = [];
	var ResultTitleAndContent = [];
	var ResultInContent = [];
	var ResultInContentTemp = [];

	var ResultCombinedTemp = [];
	var ResultCombined = [];

	var arrayIndex = 0;
	var NrRes = 0;
	var j = 0;
	var i = 0;
	var k = 0;
	var d = 0;
	var maxItems = 1000;
	var heading = 0;
	var WordPos = -1;
	var WordPosHeading = -1;
	var WordPosContentText = -1;
	var FoundWord = "";
	var FoundWordHead = "";
	var SearchInHeadingOnly = 0;
	var isChecked;
	var size = 10;
	var resGroupCounter = 0;
	var shown = "shown";
	var checkBoxInHeading;
	var searchFlag = 0;
	var DivResult;
	var SearchWord;

if (SearchText && SearchText.length >= 1) {
		SearchWord = SearchText.replace(/\+/g, " ").replace(/&/g, "&amp;").replace(/</g, "&lt;").replace(/>/g, "&gt;").replace(/"/g, "&quot;");
		searchFlag = 1;
	} else {
		SearchWord = "";
		searchFlag = 0;
	}
	

	if (searchFlag === 1) {
		Result = "";

		// checkBoxInHeading = document.getElementById("inHeading");
		if (inHeading) {

			isChecked = true;
		} else {

			isChecked = false;
		}

		if (SearchWord && SearchWord.length >= 1) {
			if (isChecked) {
				SearchInHeadingOnly = 1;
			} else {
				SearchInHeadingOnly = 0;
			}
			SearchWord = SearchWord.toLowerCase();
			window.status = "Searching, please wait...";
			for (j = 0; j < PageLength; j++) {
				k = Page[j].length - 1;
				for (i = 0; i < k; i++) {

					heading = k - 1;

					if (SearchInHeadingOnly === 1) {
						WordPosHeading = Page[j][heading].toLowerCase().indexOf(SearchWord);
						if (WordPosHeading > -1) {
							FoundWordHead = Page[j][heading].substr(WordPosHeading, SearchWord.length);

							NrRes++;
							ResultTemp = "<li>";
							ResultTemp += "<span>";
							ResultTemp += "<a href='" + Page[j][k] + "'>" + Page[j][heading].replace(FoundWordHead, FoundWordHead.bold()) + "</a><br/>\n";

							ResultTemp += "</span>";
							ResultTemp += "</li>";

							ResultTitleOnly[arrayIndex] = ResultTemp;
							arrayIndex++;

							ResultTemp = "";
							WordPosHeading = -1;
							WordPosContentText = -1;
							break;
						}
					} else if (SearchInHeadingOnly === 0) {
						WordPos = Page[j][i].toLowerCase().indexOf(SearchWord);
						WordPosHeading = Page[j][heading].toLowerCase().indexOf(SearchWord);
						if (WordPos > -1) {
							FoundWordHead = Page[j][heading].substr(WordPosHeading, SearchWord.length);
							FoundWord = Page[j][i].substr(WordPos, SearchWord.length);
							FoundWord = Page[j][i].substr(WordPos, SearchWord.length);
							NrRes++;
							ResultTemp += "<li>";
							ResultTemp += "<span>";
							if (WordPosHeading > -1) {
								ResultTemp += "<a href='" + Page[j][k] + "'>" + Page[j][heading].replace(FoundWordHead, FoundWordHead.bold()) + "</a><br/>\n";
							} else {
								// found word is not in the head
								ResultTemp += "<a href='" + Page[j][k] + "'>" + Page[j][heading] + "</a><br/>\n";

							}
							if (i < k - 1) {
								WordPosContentText = Page[j][i].toLowerCase().indexOf(SearchWord);

								if (Page[j][i].length > 300 && (WordPosContentText > -1)) {

									if (WordPosContentText > 75) {
										ResultInContentTemp.push("..." + Page[j][i].substr(WordPosContentText - 75, 175 + FoundWord.length).replace(FoundWord, FoundWord.bold()) + "...");
									} else {
										ResultInContentTemp.push("..." + Page[j][i].substr(0, 175 + FoundWord.length).replace(FoundWord, FoundWord.bold()) + "...");

									}

								} else if (WordPosContentText > -1) {

									ResultInContentTemp.push(Page[j][i].replace(FoundWord, FoundWord.bold()));

								}
							}

							ResultTemp += ResultInContentTemp.join("");

							ResultTemp += "</span>";
							ResultTemp += "</li>";

							if (WordPosHeading > -1) {
								ResultTitleAndContent[arrayIndex] = ResultTemp;
								arrayIndex++;
							} else {
								ResultInContent[arrayIndex] = ResultTemp;
								arrayIndex++;
							}

							ResultInContentTemp.length = 0;
							ResultTemp = "";
							WordPosHeading = -1;
							WordPosContentText = -1;
							break;
						}

					}
				}
			}

			ResultTitleOnly = ResultTitleOnly.filter(function (n) {
				return (n !== undefined && n !== null);
			});
			ResultTitleAndContent = ResultTitleAndContent.filter(function (n) {
				return (n !== undefined && n !== null);
			});
			ResultInContent = ResultInContent.filter(function (n) {
				return (n !== undefined && n !== null);
			});

			ResultCombinedTemp = ResultTitleOnly.concat(ResultTitleAndContent, ResultInContent);

			ResultCombinedTemp = ResultCombinedTemp.filter(function (n) {
				return (n !== undefined && n !== null);
			});

			for (d = 0; d < ResultCombinedTemp.length; d += size) {
				resGroupCounter++
				ResultCombined.push("<div id=" + "'" + "resGroup_" + resGroupCounter + "'" + " class=" + "'" + "resGroup " + shown + "'" + ">" + "<ol class='searchResults'>" + ResultCombinedTemp.slice(d, d + size).join("") + "</ol></div>");
				shown = "notshown";
			}

			ResultFound = ResultCombined.join("");

Result += "<div id='searchDetailsDiv'>";
			Result += "<p class='searchDetails'>Your Search Found&nbsp;" + NrRes + "&nbsp;items.&nbsp;";
			Result += "</p></div>";
			
			Result += "<div class='searchResultsDiv'>";
			Result += "<div id='resultsCollection' class='searchResults'>";
			Result += ResultFound;
			Result += "</div>";
			Result += "</div>";
			Result += "<div class='searchPaging'>";

			Result += '<hr />';

			Result += '<p class="bodytext"><a class="disabledAnchor" id="pBack" onclick="turnPage(\'backPage\')" href="#pBack">Back</a>&nbsp; | &nbsp;';
			
			if (resGroupCounter && resGroupCounter > 1) {
				Result += '<a id="pNext" onclick="turnPage(\'nextPage\')" href="#pNext">Next</a>';
			} else {
				Result += '<a id="pNext"  class="disabledAnchor" href="#pNext">Next</a>';
			}
			Result += '</p>\n';
			Result += '<div id="pagenofn"><p class="bodytext">Page <span id="pagen">1</span> of ' + resGroupCounter + '</p></div>';

			Result += "</div>";
			
			
		}

		DivResult = document.getElementById("s_anchor");
		if (Result && DivResult) {

			//myDivResult.append(Result);
			DivResult.innerHTML = Result;
			

		}
		window.status = "";
		
		

	}
	}())
}
