'use strict';
function search(SearchText, inHeading) {
(function () {
var Page = [];

/* Generated with Author-it 23.4.1.30004  12/8/2025 10:22:48 AM */
Page[0]=new Array("Title and Copyright Information","Copyright  1999,  2025, Oracle and/or its affiliates.","Primary Author: Oracle Corporation","Title and Copyright Information","46576.htm");
Page[1]=new Array("Scope","This guide describes how to manually convert your P6 version 7.0 or later database to P6 EPPM. Complete the following sections in the order specified: ","Back up the existing P6 database (also known as PMDB).","If you are upgrading from Version 7.0, migrate all your methodologies. You cannot use Project Architect after you upgrade, so you will want to migrate your methodologies before you upgrade. (See Converting Methodologies to Projects and Creating a Project Template From Projects for manual migration instructions.) ","Run the appropriate scripts to upgrade the P6 database structure to P6 EPPM.","Perform required and recommended processes after the upgrade is complete. ","To configure an Oracle database server for SSL, see the Advanced Security Administrator's Guide included with the Oracle Database Server Documentation for configuring the Oracle Server and Oracle Client(s) for SSL.","To configure a SQL database server for SSL, use Microsoft's documentation for instructions on configuring SQL Database Server SSL. Direct questions about Installation / Configurations to the database vendor, Microsoft.","Note Prior to 15.1, any user who was granted P6 Professional module access could access both P6 Professional and P6 Visualizer applications. When you upgrade your instance of P6 EPPM to the current release, users who have P6 Professional module access will also be granted a separate P6 Visualizer module access. For more information about module access rights, see P6 Reference Manual.","Audience","Database administrators should use this guide.","Using This Guide","This guide assumes you can perform common database administration procedures and have experience using the command line.","About This Guide","46869.htm");
Page[2]=new Array("You can upgrade your existing P6 EPPM database (version 7.0 and later) to the current release. You must upgrade your P6 EPPM database so it will work with the new version.","Database Upgrade Considerations for P6 EPPM","46884.htm");
Page[3]=new Array("You must upgrade your P6 EPPM database so it will work with the new version. The following list summarizes the procedures required to manually upgrade your database from P6 EPPM version 7.0:","Note","All risk data fields are migrated when upgrading; existing fields are mapped to new fields and others will be mapped to text fields. See Risks Migration for more information.","Back up your P6 EPPM database before beginning the upgrade process to ensure you will not lose any data due to unexpected problems. You should back up your database before you perform any of the steps in this document since the upgrade is not reversible. If you are unsure how to back up your database, do not proceed with the upgrade. Contact your database administrator or database vendor for assistance with backing up your database before performing the database upgrade. ","Manually run all scripts required to upgrade your existing P6 EPPM database.","Test the new database to ensure that the upgrade succeeded.","See Data Not Migrated During P6 EPPM Database Upgrade for details on what information will not migrate.","Convert your Methodology Management data to projects before you upgrade P6 EPPM. See Converting Methodologies to Projects and Creating a Project Template From Projects for manual migration instructions.","Cautions:","If you are a current Apache JackRabbit user and want to upgrade to the latest version of P6 EPPM, JackRabbit documents data will not migrate automatically. Refer to My Oracle Support's Knowledge Articles for information on manually migrating JackRabbit documents to Oracle Universal Content Management. Oracle recommends that you migrate the data before upgrading.","If you are a current jBPM user and want to upgrade P6 EPPM, workflows and reviews data will not be available. You should close all workflows and reviews that are in progress before upgrading. You cannot migrate any of this data to the latest version of P6 EPPM.","Requirements to Manually Upgrade from Version 7","49793.htm");
Page[4]=new Array("The following list summarizes requirements to upgrade from P6 EPPM R8.0 or later:","Back up your P6 EPPM database before beginning the upgrade process to ensure you will not lose any data due to unexpected problems. You should back up your database before you perform any of the steps in this document since the upgrade is not reversible. If you are unsure how to back up your database, do not proceed with the upgrade. Contact your database administrator or database vendor for assistance with backing up your database before performing the database upgrade. ","Manually run all scripts required to upgrade your existing P6 EPPM database.","Test the new database to ensure that the upgrade succeeded.","Requirements to Manually Upgrade from Version 8 or Later","49796.htm");
Page[5]=new Array("Consider the following tips before you manually upgrade P6 EPPM:","User Name and Password Tips","All new users must create a password with at least one character, regardless of whether Password Policy is enabled. P6 EPPM will prompt existing users to follow the new requirement if they reset their password and the Password Policy is disabled.","The ADMUSER role must have DBA privileges when upgrading or applying patches.","Security Tips","P6 EPPM includes an encryption algorithm that provides enhanced security for private database logins; however, when you manually configure your database, the database does not automatically enforce the encryption algorithm. If you manually configure your database, Oracle recommends that you use this encryption algorithm. To do so, you must reset the private database login. See Resetting Private Database Passwords for instructions. If automatically installing or upgrading your database, you do not need to configure the encryption algorithm. User logins and passwords are not affected.","Starting with P6 EPPM R8, P6 performs all user security and administration. Due to this change, all Admin Superusers receive Projects module access during the upgrade.","To configure an Oracle database server for SSL, see the Advanced Security Administrator's Guide included with the Oracle Database Server Documentation for configuring the Oracle Server and Oracle Client(s) for SSL.","To configure a SQL database server for SSL, use Microsoft's documentation for instructions on configuring SQL Database Server SSL. Direct questions about Installation / Configurations to the database vendor, Microsoft.","Application Tips","P6 EPPM does not support Summary-Only projects. During the P6 EPPM database upgrade, existing Summary-Only projects convert to standard projects, but lose all summary data. You can import the summary project from Microsoft Project into the converted blank project, then summarize the data. See the P6 Professional Help.","P6 Professional no longer performs recurring job services. Use the Windows command line interface to run batch reports and export projects as a service. To view P6 Professional reports in P6, select the &quot;Store report in Work Products and Documents&quot; option when creating report batches or printing reports. See the P6 Professional Help for more information.","P6 EPPM Manual Upgrade Tips","48531.htm");
Page[6]=new Array("When upgrading P6 EPPM, the following data will not migrate from previous releases:","When upgrading from 16 R1 or earlier, SharePoint configuration details in Primavera P6 Administrator are not automatically migrated to the CMIS configuration settings in Primavera P6 Administrator.","When upgrading from 16 R1 or earlier, AutoVue markup and rendition does not migrate if upgrading from a configuration with VueLink enabled to a configuration without VueLink enabled. If you want to retain AutoVue markup and rendition with VueLink enabled, ensure VueLink is enabled when upgrading.","When upgrading from 16 R1 or earlier, AutoVue configuration details that are associated with a specific content repository in Primavera P6 Administrator will not migrate to the new location of the AutoVue configuration settings in Primavera P6 Administrator.","Workflows Repository (supported configuration changed from jBPM to Oracle BPM).","Content Repository (if previously an Apache JackRabbit user). Refer to Knowledge Articles on My Oracle Support for information on manually migrating JackRabbit documents to Oracle Universal Content Management.","Top Down Estimation, including estimated weights (removed).","Issue Form Categories (removed).","Summary Data (new summary tables incompatible with old summary tables). Refer to My Oracle Support's Knowledge Articles for information on manually migrating Scenarios data to the new summary tables.","Methodology Management (replaced with Project Templates). See Converting Methodologies to Projects and Creating a Project Template From Projects for manual migration instructions.","Data Not Migrated During P6 EPPM Database Upgrade","45315.htm");
Page[7]=new Array("The following table illustrates the risks data field mapping when upgrading from P6 EPPM database (7.0 or 7.0 service packs).","Note Some fields will migrate to text fields instead of new fields because certain fields no longer correspond. The new text fields are noted below.","Risks Fields Migration Table","P6 EPPM database (version 7.0 and 7.0 service packs) Risks Fields","P6 EPPM Risks Field","Risk Id","id","risk_name","name","risk_descr","description","status_code","status","risk_type_id","category_id","risk_control","Note","table_name","table_name","wbs_id","cause (with heading 'Applies to WBS' &lt;WBS name&gt;)","rsrc_id","cause (with heading 'Applies to Resource' &lt;resource name&gt;)","obs_id","cause (with heading 'Responsible Manager' &lt;OBS name&gt;)","priority_type","cause (with heading 'Priority' &lt;priority type&gt;)","add_date","cause (with heading 'Date Identified' &lt;add_date in mmm-dd-yyyy format &gt;)","impact_date","cause (with heading 'Date Identified' &lt;add_date in mmm-dd-yyyy format &gt;)","prbly_pct","cause (with heading 'Probability' &lt;prbly_pct&gt;)","impact_work_qty","cause (with heading 'Impact - Labor Units' &lt;impact_work_qty&gt; - 2 decimals)","impact_equip_qty","cause (with heading 'Impact - Nonlabor Units' &lt;impact_equip_qty&gt; - 2 decimals)","impact_mat_qty","cause (with heading 'Impact - Material Units' &lt;impact_mat_qty&gt; - 2 decimals)","Impact_expense_cost","cause (with heading 'Impact - Expenses' &lt;impact_expense_cost&gt; - 2 decimals)","Risks Migration","38528.htm");
Page[8]=new Array("Perform the tasks in the following topics before upgrading your database.","Pre-Upgrade Procedures","55267.htm");
Page[9]=new Array("Use the validate tool to ensure your database is not missing objects that could cause the database to fail to upgrade. You must perform the steps below before you download the latest media pack. For example, if you are attempting to upgrade to Version 25 and you run the Version 25 validate tool against a version 20 database, then the validate tool will not work.","Double-click validate.bat&nbsp;(validate.sh for Linux) in your current Database folder of the P6 EPPM physical media or download to start the validate tool.","Note Schema validation of Oracle Autonomous Databases is not yet supported.","Provide the following:","In the Username field, enter your administrative user name (for example, admuser).","In the Database host address field, enter your database server name or TCP/IP address.","In the Database host port field, enter the port number that Oracle is using. The default is 1521.","In the Database name field, enter the Oracle Service Name. You can find it in the TNSNAMES.ORA file, which you created when you set up the Oracle client.","View the HTML page that the tool creates to ensure your database is not missing objects.","If upgrading from 7.0, go to the 'Client Application' media pack, then locate the \\install\\database\\scripts\\ folder to find the scripts you need to fix.","If upgrading from 8.0 or later, go to the database folder of the P6 EPPM physical media or download, then locate the \\database\\scripts\\install\\ to find the scripts you need to fix.","Running the Validate Tool for a Version 7 or Later Oracle Database","50527.htm");
Page[10]=new Array("To migrate Methodology Management version 7.0 data to the latest P6 Project Templates, you must first use Project Architect in the Project Management module to convert the data from a methodology to a project.","To convert Methodology Management data to a project:","Create a new EPS node in P6 Professional version 7.0 where you can store all your Methodology Management projects.","Use Project Architect in P6 Professional version 7.0 to create projects from Methodology Management data. For more information on using Project Architect, see version 7.0 of the Oracle Primavera P6 Project Management Reference Manual.","Note You can create only one project at a time. If you want all of your Methodology Management data moved to P6 Project Templates, contact Oracle Consulting to automate the process.","After you have converted all your Methodology Management data to projects, upgrade P6 EPPM.","Launch P6.","Convert your upgraded projects (formerly methodologies) to project templates. See Creating a Project Template From Projects.","Converting Methodologies to Projects","44845.htm");
Page[11]=new Array("When using an Oracle database, you must install Oracle Multimedia, along with these supporting components: Oracle JVM, Oracle XML DB (XDB), and XML Developer's Kit (XDK). Unless you specify otherwise, all these components automatically get installed with the latest versions of an Oracle database. If you chose not to install these components, you will need to install them before you upgrade P6 EPPM. See the Oracle Multimedia's User's Guide for information on how to install these components.","Installing Oracle Multimedia for an Oracle Database","61563.htm");
Page[12]=new Array("To upgrade the P6 EPPM Oracle Database:","If you haven't done so, download the Primavera P6 Enterprise Project Portfolio Management &lt;release_level&gt; for &lt;platform&gt; folder and extract the contents.","Go to the location of the extracted contents and locate the P6_&lt;release_level&gt;\\p6suite\\database folder.","Note Make a backup copy of any files you will modify before you edit them.","Navigate to the following locations, open the designated scripts in a text editor, and modify the schema user references to match your actual schema user names:","\\scripts\\install\\PM_&lt;release level&gt;\\manual_script_before_upgrade.sql","If you are not using the schema names admuser or pxrptuser, update the references with your actual admuser and pxrptuser names.","\\scripts\\install\\PM_&lt;release level&gt;\\manual_script_before_install.sql","You must apply grant options to the SYSTEM schema user or a custom user associated with the Oracle DBA role. If you plan to use a custom schema user, other than SYSTEM, to complete steps which require a DBA role, then you must update the references to SYSTEM in the script with the new custom schema user associated with the DBA role.","\\scripts\\install\\PM_&lt;release level&gt;\\orpm_grant_privileges.sql","If you are not using the schema names admuser, privuser, bgjobuser, pubuser, and pxrptuser update the references with your actual admuser, privuser, bgjobuser, pubuser, and pxrptuser names.","Note If you are upgrading from 8.1 or later, you can skip steps d, e, f, and g.","\\scripts\\install\\PM_&lt;release_level&gt;\\orpm_create_bguser_upgrade.sql script.","Modify the tablespace or bgjobuser name in this script if you changed the default tablespace name (PMDB_DAT1) or the default bgjobuser name.","\\scripts\\install\\PM_&lt;release_level&gt;\\orpm_init_px.sql","Modify the tablespace name in this script if you changed the default tablespace name (PMDB_PX_DAT1).","\\scripts\\install\\PM_&lt;release_level&gt;\\orpm_create_plus_users.sql","If you want to create a user without a default name, you need to update pxrptuser with your actual pxrptuser name.","If you are using a custom admuser name, you need to modify the reference to admuser with your actual admuser name.","Note Do not use special characters in the database name, privileged user, public user, or PX reporting user name, for example: { } [ ] : ; &lt; &gt; , . ? ! @ # $ % ^ &amp; * ( ) - _ | / \\ ~ `","Complete the following steps:","From the command line, run the following and provide the password when prompted: sqlplus sys@&lt;db_tns_names_entry&gt; as sysdba","Go to \\scripts\\install\\PM_&lt;release_level&gt; and run the manual_script_before_upgrade.sql script.","Go to \\scripts\\install\\PM_&lt;release_level&gt; and run the manual_script_before_install.sql script.","Note If you are upgrading from 8.1 or later, you can skip steps d, e, f, and g and then continue to step h.","Go to \\scripts\\install\\PM_&lt;release_level&gt; and run orpm_create_bguser_upgrade.sql script.","Go to \\scripts\\install\\PM_&lt;release_level&gt; and run orpm_init_px.sql script.","Go to \\scripts\\install\\PM_&lt;release_level&gt; and run orpm_create_plus_users.sql script.","Go to \\scripts\\install\\PM_&lt;release_level&gt;, update the user in the script, and then run the orpm_grant_privileges.sql script.","Complete the following steps:","From the command line, run the following and provide the password when prompted: sqlplus &lt;admuser&gt;@&lt;db_tns_names_entry&gt;","Go to \\scripts\\common\\PM_&lt;release_level&gt; and run the or_disable_triggers.sql script.","Go to \\scripts\\upgrade\\PM_&lt;release_level&gt; and run the script closest to the version of P6 EPPM that you are trying to upgrade. For example: ","ORPM_p70sp1.sql, if upgrading from P6 version 7.0, 7.0 service pack 1, or 7.0 service pack 2","ORPM_p7.0sp3.sql, if upgrading from P6 version 7.0 service pack 3","ORPM_p70sp5.sql, if upgrading from P6 version 7.0 service pack 5","ORPM_p80.sql, if upgrading from P6 version 8.0","ORPM_p81.sql, if upgrading from P6 version 8.1","ORPM_p81sp3.sql, if upgrading from P6 version 8.1 service pack 3","ORPM_p82.sql, if upgrading from P6 version 8.2","ORPM_p82sp2.sql, if upgrading from P6 version 8.2 service pack 2","ORPM_p82sp2f10.sql, if upgrading from P6 version 8.2 patch set 2 Hotfix 10","ORPM_p83.sql, if upgrading from P6 version 8.3","ORPM_p832.sql, if upgrading from P6 version 8.3 or 8.3 service pack 2","ORPM_p833.sql, if upgrading from P6 version 8.3 or 8.3 service pack 3","ORPM_p834.sql, if upgrading from P6 version 8.3 or 8.3 service pack 4","ORPM_p835.sql, if upgrading from P6 version 8.3 or 8.3 service pack 5","ORPM_p84.sql, if upgrading from P6 version 8.4 or 8.4 patch set 1","ORPM_p841.sql, if upgrading from P6 version 8.4 or 8.4 patch set 1","ORPM_p843.sql, if upgrading from P6 version 8.4 or 8.4 patch set 3","ORPM_P151.sql, if upgrading from P6 version 15.1","ORPM_P152.sql, if upgrading from P6 15 R2","ORPM_P161.sql, if upgrading from P6 16 R1","ORPM_P162.sql, if upgrading from P6 16 R2","Note","If you did not run the orpm_init_px.sql script to create a PX tablespace or you changed the name of the PMDB_PX_DAT1 tablespace, modify all occurrences of PMDB_PX_DAT1 in the upgrade script with the name you used for the tablespace.","If you changed the default privuser name, update the name in this script with your custom user name.","Complete the following steps:","From the command line, run the following and provide the password when prompted: sqlplus &lt;admuser&gt;@&lt;db_tns_names_entry&gt;","Go to \\scripts\\source\\PM_&lt;release_level&gt; and run the orpm_admuser_upgrade.sql script.","Complete the following steps:","From the command line, run the following and provide the password when prompted: sqlplus &lt;privuser&gt;@&lt;db_tns_names_entry&gt;","Go to \\scripts\\source\\PM_&lt;release_level&gt; and run the orpm_privuser.sql script.","Complete the following steps:","From the command line, run the following and provide the password when prompted: sqlplus &lt;pxrptuser&gt;@&lt;db_tns_names_entry&gt;","Go to \\scripts\\source\\PM_&lt;release_level&gt; and run the orpm_pxrptuser.sql script.","Complete the following steps:","From the command line, run the following and provide the password when prompted: sqlplus &lt;system&gt;@&lt;db_tns_names_entry&gt;","Note If you changed the system username to a custom dba user in step 3b, you need to run orpm_reset_priv.sql as the custom dba user instead of the default system user. ","Go to \\scripts\\install\\PM_&lt;release_level&gt; and run the orpm_reset_priv.sql script.","Run the databaselogins.bat (on Windows) or databaselogins.sh (on Linux) to upgrade the encryption of privilege user passwords.","Upgrading the P6 EPPM Oracle Database","46876.htm");
Page[13]=new Array("Consider the following after you upgrade your database.","Post-Upgrade Procedures","55271.htm");
Page[14]=new Array("After you have converted your Methodology Management data to projects and upgraded your database, you can create your project templates.","To create a project template:","Click Projects.","On the Projects navigation bar, click EPS.","On the EPS page, click the Actions&nbsp;@ menu and select Add&nbsp;@ Add Project Template.","In the Add Project Template dialog box, choose the General tab.","On the General tab:","In the Template ID field, type in a unique ID for the template.","In the Template Name field, type in a unique name for the template.","In the EPS field, click the corresponding @ and choose the EPS where you want to store the template.","In the Responsible Manager field, click the corresponding @ and choose a responsible manager.","In the Copy from existing project or template field, click the corresponding @ and choose the methodology project you created in Converting Methodologies to Projects.","Click Create.","Creating a Project Template From Projects","44847.htm");
Page[15]=new Array("From release 18, classic views are no longer available in P6. You can export classic views to import them as standard views. When you import the exported classic views, they are imported as user views. To make the newly imported views accessible to other users, you can cut or copy and paste the views to the Global or Multiple Users groups.","Note Although classic views can no longer be used from release 18, they are not removed from the database during the upgrade process and can still be exported after upgrade.","To convert classic views to standard views:","Click Projects or Resources.","On the Projects navigation bar, click Activities, EPS, or Assignments.","On the Resources navigation bar, click Assignments.","Click the Views&nbsp;@ menu and select Import/Export Views....","In the Import/Export Views dialog box:","Click Export.","Select the Classic Views option.","Select the views you want to export.","Click Export.","Click the Views&nbsp;@ menu and select Import/Export Views....","In the Import/Export Views dialog box:","Click Import.","In the File field, click @&nbsp;Browse and select the file you exported.","Select the views to import.","Click Import.","Tip","When you export classic views, they are exported to a file in your default download location. The file name includes the name of the page the views were exported from, your user name, and the date and time the file was exported. The file extension is .json.","You can export classic views from the EPS, Activities, and Assignments pages and convert them to standard views on each of those pages. You cannot export views from multiple pages into one file.","Some classic view settings cannot be converted to standard views, for example bar color coding. These settings will be lost when you convert your classic views into standard views.","Converting Classic Views to Standard Views","98724.htm");
Page[16]=new Array("The following list summarizes the procedures you need to perform after the P6 EPPM upgrade:","Backup Procedures","Oracle recommends that you make a backup of your newly upgraded database.","User Name and Password Procedures","For security reasons, Oracle strongly recommends you replace the default database users' (admuser, privuser, pubuser, bgjobuser, and pxrptuser) passwords immediately after a manual database installation or an upgrade from P6 version 7.0. Do not use special characters in the database name, privileged user, public user, or PX reporting user name, for example: { } [ ] : ; &lt; &gt; , . ? ! @ # $ % ^ &amp; * ( ) - _ | / \\ ~ ` ","For instructions on how to replace the private database login, follow the instructions in Modifying Private Database Logins for P6 EPPM. For all other database user names and passwords, use the tools included with Oracle Database. The background job user has to be reset only for manual installations. ","Oracle recommends using strong passwords. Strong passwords in P6 EPPM contain between 8 and 20 characters and at least one numeric and one alpha character. To further strengthen the password, use a mixture of upper and lower case letters.","Application Configuration Procedures","Install the new P6, P6 Professional, and any additional components.","Starting with P6 EPPM R8, all recurring job service functions are hosted by P6. Due to this change, after upgrading to P6 EPPM R8 or later, you must configure Scheduled Services settings in the Primavera P6 Administrator to use this functionality. See the P6 EPPM System Administration Guide for more information. ","Resummarize all projects to accurately reflect your summary data. See information about configuring a separate server for job services in the P6 EPPM System Administration Guide.","Assign new or modified privileges to users. See information about security profiles in the P6 EPPM Application Administration Guide.","All previously defined module access (except Contributor module access (formerly Team Member)), security profiles, OBS access, and resource security settings will still apply to existing users after the database upgrade. For users who had Contributor and P6 Professional module access, they will keep their access during the database upgrade; however, once you edit these users post-upgrade, P6 will remove Contributor module access to comply with P6 EPPM functionality. The upgrade process will remove only Contributor access during the upgrade if users had Contributor and additional module access assignments other than P6 Professional; all other assignments will remain selected. See the P6 EPPM Application Administration Guide for information on defining module access, security profiles, OBS access, and resource security.","During the upgrade to the latest version of P6 EPPM, some P6 Activity Views settings will reset. After the upgrade, use the Customize Detail Windows feature to modify the settings that should appear for each view. See the P6 Help for information on how to edit Activity Views.","Starting with P6 EPPM R8, P6 saves filter definitions globally. Filters still work for Activity Views, but all standard filter assignments reset during the upgrade. Due to this change, views that had Standard Filters applied will show all activities after the upgrade. Reapply filters after the upgrade finishes. See the P6 Help for information on how to edit Activity Views.","Security Procedures","For security reasons, Oracle strongly recommends that on-premises users replace the default Admin Superuser (admin) immediately after a manual database installation or an upgrade from P6 version 7.0 and earlier. See information on the default Admin Superuser in the P6 EPPM Application Administration Guide for guidelines on this process. See the P6 EPPM Application Administration Guide for information on changing the default admin superuser.","Requirements After the Upgrade from 7.0 to P6 EPPM","48530.htm");
Page[17]=new Array("The following list summarizes the procedures to perform after the P6 EPPM upgrade:","Backup Procedures","Oracle recommends you make a backup of your newly upgraded database.","User Name and Password Procedures","For security reasons, Oracle strongly recommends that you replace the default database users' (admuser, privuser, pubuser, bgjobuser, and pxrptuser) passwords immediately after a manual database installation or an upgrade from P6 version 7.0. Do not use special characters in the database name, privileged user, public user, or PX reporting user name, for example: { } [ ] : ; &lt; &gt; , . ? ! @ # $ % ^ &amp; * ( ) - _ | / \\ ~ `","For instructions on how to replace the private database login, follow the instructions in Modifying Private Database Logins for P6 EPPM. For all other database user names and passwords, use the tools included with the database. The background job user has to be reset only for manual installations. ","Oracle recommends using strong passwords. Strong passwords in P6 EPPM contain between 8 and 20 characters and at least one numeric and one alpha character. To further strengthen the password, use a mixture of upper and lower case letters.","Application Configuration Procedures","Install the new P6, P6 Professional, and any additional components.","Starting with P6 EPPM R8, all recurring job service functions are hosted by P6. Due to this change, after upgrading to P6 EPPM R8 or later, you must configure Scheduled Services settings in the Primavera P6 Administrator to use this functionality. See the P6 EPPM System Administration Guide for details.","Assign new or modified privileges to users. See information about security profiles in the P6 EPPM Application Administration Guide.","Security Procedures","For security reasons, Oracle strongly recommends that on-premises users replace the default Admin Superuser (admin) immediately after a manual database installation or an upgrade from P6 version 7.0 and earlier. See information on the default Admin Superuser in the P6 EPPM Application Administration Guide for guidelines on this process. See the P6 EPPM Application Administration Guide for details on the default admin superuser.","Requirements After the Upgrade from P6 EPPM R8 or later","49798.htm");
Page[18]=new Array("The P6 server and P6 Professional components obtain their run-time database connection credentials from a credential configuration table in the P6 EPPM database. The P6 run-time database credentials (known as privuser or P6 private database login) are stored in an encrypted format in this special P6 configuration table. Any time that you change or rotate the privuser password credentials in your Oracle, Oracle Autonomous Database, or MS SQL Server database, you must re-synchronize the stored credentials in the P6 credential table by using the Database Login tool.","Because encryption algorithms are often enhanced in newer releases, Oracle highly recommends that you reset these stored privuser credentials when you perform a major version upgrade of P6 EPPM. By resetting the stored credentials, the new encryption algorithm can be applied to other stored credentials (for example, pubuser) in the P6 EPPM credential table. For information about resetting private database passwords, see Resetting Private Database Passwords.","Note","This tool does not reset database user logins or passwords. Administrators should use SQL Developer or other DBA consoles to set or reset database user passwords.","Private Database Credentials for P6 EPPM","43428.htm");
Page[19]=new Array("Password encryption algorithms are frequently improved in new releases of P6 Professional and P6 Professional. You should reset private database passwords in order to use improved password encryption algorithms.","To reset private database passwords to use the new encryption algorithm:","Go to P6 EPPM &lt;release_level&gt;\\database or P6 Professional &lt;release_level&gt;\\database.","Run databaselogins.bat (with Windows) databaselogins.sh (with UNIX or Linux).","In the Database Connection dialog box:","Select the database.","Type the user name and password of a privileged database user (for example, privuser). This login should have administrative rights on the database.","Enter the connection details for the database.","For an Oracle Database, enter the host address, host port, and database/instance name specific to your installation. The Port field displays the default port for the database type you selected.","For an Oracle Autonomous Database, enter the location of the unzipped wallet file and the service name.","For a Microsoft SQL Server Database, enter the host address, host port, and database/instance name specific to your installation. The Port field displays the default port for the database type you selected.","Click Next.","In the Private Database Logins dialog box:","Select the private database user name that you wish to reset.","Highlight the password and change it (or re-enter the existing password).","Click Update Password.","Click Save.","Click OK.","Resetting Private Database Passwords","46563.htm");
Page[20]=new Array("You can update the passwords and usernames of the private database users on your P6 EPPM database. ","To modify private database logins:","Go to P6 EPPM &lt;release_level&gt;\\database and run databaselogins.bat (with Windows) databaselogins.sh (with UNIX or Linux).","On the Database Connection dialog box:","Select the database.","Type the user name and password of a privileged database user (for example, privuser). This login should have administrative rights on the database.","Enter the connection details for the database.","For an Oracle Database, enter the host address, host port, and database/instance name specific to your installation. The Port field displays the default port for the database type you selected.","For an Oracle Autonomous Database, enter the location of the unzipped wallet file and the service name.","For a Microsoft SQL Server Database, enter the host address, host port, and database/instance name specific to your installation. The Port field displays the default port for the database type you selected.","Click Next.","On the Private Database Logins dialog box:","Select the private database user name that you wish to modify.","Enter a new user name.","Highlight the password, and change it.","Click the Update Password button.","Note To reverse a change, click Undo. Undo will reverse any changes made during the current session.","Click Save.","Click OK to exit the Database Logins tool.","Modifying Private Database Logins for P6 EPPM","46565.htm");
Page[21]=new Array("You can download the media pack that contains the installer and all required install files from the Oracle Software Delivery Cloud website at https://edelivery.oracle.com.","Run setup.exe in the Primavera P6 Enterprise Project Portfolio Management physical media or download to install the following P6 EPPM applications:","Note","You do not have to install all applications; you can pick and choose what you install. However, you must install P6 to run the other P6 EPPM applications.","P6 Team Member (includes P6 Team Member Web and Email Statusing Service)","Note","You will need to configure Email Statusing Service separately. The installation wizard will provide the Email Statusing Service files and you will use the config.properties file to set up this service. See the P6 EPPM System Administration Guide.","P6 mobile supports SSL (https) only when it has a certificate signed by a valid authority.","P6 EPPM Web Services","P6 Professional Cloud Connect ","Select the P6 Professional Cloud Connect install option if you plan to use P6 Professional with an P6 EPPM Oracle or Oracle Autonomous Database database on the cloud by connecting to a remote service. The wizard sets up a remote method of access to connect to the EPPM database and the P6 APIs. For more details on establishing the P6 Professional Cloud Connect database connection in P6 Professional, see the P6 Professional Installation and Configuration Guide (P6 EPPM). ","Note The wizard will also install P6 Integration API (in remote mode) by default.","P6 Integration API (remote mode only)","Note Oracle provides a separate installer for P6 Integration API local mode. See the P6 Integration API Configuration Guide.","P6 mobile","Note","P6 mobile apps are downloaded through the Apple App Store or the Google Play Store. See the P6 Team Member User's Guide.","P6 mobile supports SSL (https) only when it has a certificate signed by a valid authority.","Based on whether you are installing or upgrading, see one of the following books:","P6 EPPM Installation and Configuration Guide","P6 EPPM Upgrade and Configuration Guide","Installing P6 EPPM Applications","53137.htm");
var PageCount=22;


/*
Date: 12/8/2025 10:22 AM
Source: EPPM_25_dev
BookID: 46552
PubProduct: PRIMAVERA_EPPM
BookTitle: Manual Upgrade Guide (Oracle Database) for On-Premises
Version: Version 25
Lang:	en
*/
	var PageLength=Page.length;
	var Result = "";
	var ResultTemp = "";
	var ResultFound = "";
	var ResultTitleOnly = [];
	var ResultTitleAndContent = [];
	var ResultInContent = [];
	var ResultInContentTemp = [];

	var ResultCombinedTemp = [];
	var ResultCombined = [];

	var arrayIndex = 0;
	var NrRes = 0;
	var j = 0;
	var i = 0;
	var k = 0;
	var d = 0;
	var maxItems = 1000;
	var heading = 0;
	var WordPos = -1;
	var WordPosHeading = -1;
	var WordPosContentText = -1;
	var FoundWord = "";
	var FoundWordHead = "";
	var SearchInHeadingOnly = 0;
	var isChecked;
	var size = 10;
	var resGroupCounter = 0;
	var shown = "shown";
	var checkBoxInHeading;
	var searchFlag = 0;
	var DivResult;
	var SearchWord;

if (SearchText && SearchText.length >= 1) {
		SearchWord = SearchText.replace(/\+/g, " ").replace(/&/g, "&amp;").replace(/</g, "&lt;").replace(/>/g, "&gt;").replace(/"/g, "&quot;");
		searchFlag = 1;
	} else {
		SearchWord = "";
		searchFlag = 0;
	}
	

	if (searchFlag === 1) {
		Result = "";

		// checkBoxInHeading = document.getElementById("inHeading");
		if (inHeading) {

			isChecked = true;
		} else {

			isChecked = false;
		}

		if (SearchWord && SearchWord.length >= 1) {
			if (isChecked) {
				SearchInHeadingOnly = 1;
			} else {
				SearchInHeadingOnly = 0;
			}
			SearchWord = SearchWord.toLowerCase();
			window.status = "Searching, please wait...";
			for (j = 0; j < PageLength; j++) {
				k = Page[j].length - 1;
				for (i = 0; i < k; i++) {

					heading = k - 1;

					if (SearchInHeadingOnly === 1) {
						WordPosHeading = Page[j][heading].toLowerCase().indexOf(SearchWord);
						if (WordPosHeading > -1) {
							FoundWordHead = Page[j][heading].substr(WordPosHeading, SearchWord.length);

							NrRes++;
							ResultTemp = "<li>";
							ResultTemp += "<span>";
							ResultTemp += "<a href='" + Page[j][k] + "'>" + Page[j][heading].replace(FoundWordHead, FoundWordHead.bold()) + "</a><br/>\n";

							ResultTemp += "</span>";
							ResultTemp += "</li>";

							ResultTitleOnly[arrayIndex] = ResultTemp;
							arrayIndex++;

							ResultTemp = "";
							WordPosHeading = -1;
							WordPosContentText = -1;
							break;
						}
					} else if (SearchInHeadingOnly === 0) {
						WordPos = Page[j][i].toLowerCase().indexOf(SearchWord);
						WordPosHeading = Page[j][heading].toLowerCase().indexOf(SearchWord);
						if (WordPos > -1) {
							FoundWordHead = Page[j][heading].substr(WordPosHeading, SearchWord.length);
							FoundWord = Page[j][i].substr(WordPos, SearchWord.length);
							FoundWord = Page[j][i].substr(WordPos, SearchWord.length);
							NrRes++;
							ResultTemp += "<li>";
							ResultTemp += "<span>";
							if (WordPosHeading > -1) {
								ResultTemp += "<a href='" + Page[j][k] + "'>" + Page[j][heading].replace(FoundWordHead, FoundWordHead.bold()) + "</a><br/>\n";
							} else {
								// found word is not in the head
								ResultTemp += "<a href='" + Page[j][k] + "'>" + Page[j][heading] + "</a><br/>\n";

							}
							if (i < k - 1) {
								WordPosContentText = Page[j][i].toLowerCase().indexOf(SearchWord);

								if (Page[j][i].length > 300 && (WordPosContentText > -1)) {

									if (WordPosContentText > 75) {
										ResultInContentTemp.push("..." + Page[j][i].substr(WordPosContentText - 75, 175 + FoundWord.length).replace(FoundWord, FoundWord.bold()) + "...");
									} else {
										ResultInContentTemp.push("..." + Page[j][i].substr(0, 175 + FoundWord.length).replace(FoundWord, FoundWord.bold()) + "...");

									}

								} else if (WordPosContentText > -1) {

									ResultInContentTemp.push(Page[j][i].replace(FoundWord, FoundWord.bold()));

								}
							}

							ResultTemp += ResultInContentTemp.join("");

							ResultTemp += "</span>";
							ResultTemp += "</li>";

							if (WordPosHeading > -1) {
								ResultTitleAndContent[arrayIndex] = ResultTemp;
								arrayIndex++;
							} else {
								ResultInContent[arrayIndex] = ResultTemp;
								arrayIndex++;
							}

							ResultInContentTemp.length = 0;
							ResultTemp = "";
							WordPosHeading = -1;
							WordPosContentText = -1;
							break;
						}

					}
				}
			}

			ResultTitleOnly = ResultTitleOnly.filter(function (n) {
				return (n !== undefined && n !== null);
			});
			ResultTitleAndContent = ResultTitleAndContent.filter(function (n) {
				return (n !== undefined && n !== null);
			});
			ResultInContent = ResultInContent.filter(function (n) {
				return (n !== undefined && n !== null);
			});

			ResultCombinedTemp = ResultTitleOnly.concat(ResultTitleAndContent, ResultInContent);

			ResultCombinedTemp = ResultCombinedTemp.filter(function (n) {
				return (n !== undefined && n !== null);
			});

			for (d = 0; d < ResultCombinedTemp.length; d += size) {
				resGroupCounter++
				ResultCombined.push("<div id=" + "'" + "resGroup_" + resGroupCounter + "'" + " class=" + "'" + "resGroup " + shown + "'" + ">" + "<ol class='searchResults'>" + ResultCombinedTemp.slice(d, d + size).join("") + "</ol></div>");
				shown = "notshown";
			}

			ResultFound = ResultCombined.join("");

Result += "<div id='searchDetailsDiv'>";
			Result += "<p class='searchDetails'>Your Search Found&nbsp;" + NrRes + "&nbsp;items.&nbsp;";
			Result += "</p></div>";
			
			Result += "<div class='searchResultsDiv'>";
			Result += "<div id='resultsCollection' class='searchResults'>";
			Result += ResultFound;
			Result += "</div>";
			Result += "</div>";
			Result += "<div class='searchPaging'>";

			Result += '<hr />';

			Result += '<p class="bodytext"><a class="disabledAnchor" id="pBack" onclick="turnPage(\'backPage\')" href="#pBack">Back</a>&nbsp; | &nbsp;';
			
			if (resGroupCounter && resGroupCounter > 1) {
				Result += '<a id="pNext" onclick="turnPage(\'nextPage\')" href="#pNext">Next</a>';
			} else {
				Result += '<a id="pNext"  class="disabledAnchor" href="#pNext">Next</a>';
			}
			Result += '</p>\n';
			Result += '<div id="pagenofn"><p class="bodytext">Page <span id="pagen">1</span> of ' + resGroupCounter + '</p></div>';

			Result += "</div>";
			
			
		}

		DivResult = document.getElementById("s_anchor");
		if (Result && DivResult) {

			//myDivResult.append(Result);
			DivResult.innerHTML = Result;
			

		}
		window.status = "";
		
		

	}
	}())
}
