'use strict';
function search(SearchText, inHeading) {
(function () {
var Page = [];

/* Generated with Author-it 23.4.1.30004  12/9/2025 11:30:41 AM */
Page[0]=new Array("Title and Copyright Information","Copyright  1999,  2025, Oracle and/or its affiliates.","Primary Author: Oracle Corporation","Title and Copyright Information","46576.htm");
Page[1]=new Array("Oracle Primavera P6 Enterprise Project Portfolio Management (P6 EPPM) is a robust and easy-to-use integrated solution for globally prioritizing, planning, managing, and implementing projects, programs, and portfolios. It optimizes role-specific functionality to satisfy each team member's needs, responsibilities, and skills. It provides a single solution for managing projects of any size, adapts to various levels of complexity within a project, and intelligently scales to meet the needs of various roles, functions, or skill levels in your organization and on your project team. ","Thousands of companies rely on P6 EPPM to:","Plan, schedule, and manage the right strategic mix of projects","Make informed project, cost, and resource management decisions","Enhance team collaboration and workflow productivity","Maximize each project contributor's skills and responsibilities","Track progress and optimize capacity for maximum profitability","Deliver programs and projects on time and within budget","Share data with human capital, financial management, and enterprise resource planning systems","Actual deployments require a variety of databases, servers, applications, and supporting technologies. P6 EPPM also integrates with many other optional solutions such as Oracle Primavera Cloud, Primavera Unifier, Oracle Primavera Risk Analysis, Oracle PPM, and Primavera Earned Value Management.","Within our documentation, some content might be specific for cloud deployments while other content is relevant for on-premises deployments. Any content that applies to only one of these deployments is labeled accordingly.","About Oracle Primavera P6 Enterprise Project Portfolio Management","6603.htm");
Page[2]=new Array("Depending on your organization's specific deployment, P6 EPPM generally consists of the applications, functions, and databases depicted below.","Applications:","P6: Most users will rely almost exclusively on the P6 web application running in a standard web browser. Simply termed P6, it is the primary interface for administering and managing projects. ","P6 mobile: Allows team members to provide status on their tasks and to enter timesheets while working &quot;on the go&quot;. ","P6 Team Member Web: This web interface allows team members to provide status on their tasks and record time in timesheets using a web browser. ","P6 Team Member Email Statusing Service: This method allows team members to provide status on their tasks using any HTML or plain text email application.","P6 Professional for EPPM: The P6 web application is the main interface for all project management functionality. You can also use the P6 Professional software to take advantage of its core project planning and scheduling functionality. The P6 Professional application and its features, including P6 Visualizer, run on Microsoft Windows. P6 Professional is also available for users who need to work on their projects in an offline mode.","P6 Professional Cloud Connect: Connects P6 Professional to an EPPM Oracle database on the cloud. P6 Integration API (in remote mode) is installed by default.","P6 Integration API: A Java-based application programming interface (API) enabling your P6 EPPM deployment to interface with other components and systems (on-premises).","P6 EPPM Web Services : P6 EPPM Web Services is an integration technology that extends P6 business objects and functionality. Based on open standards including SOAP, XML and WSDL, P6 EPPM Web Services enables developers to leverage standard interfaces to create integrated software solutions that interoperate with a wide variety of enterprise software applications running on a diversity of hardware and operating system platforms.","Primavera Gateway: Primavera Gateway is a highly configurable application that integrates P6 EPPM with other products for increased risk and scope management.","Functionality (included with P6 EPPM):","Core Enterprise Functionality: Use P6 for all of the following core enterprise functionality:","Administration and Enterprise Data: Administer user accounts, preferences, views, application settings, and enterprise data.","Project, Portfolio, and Resource Management: P6 provides an extensive array of features designed to optimize all phases of Project Management, Resource Management, and Portfolio Management. It includes full support for activities, work breakdown structures, planning and scheduling, costs, resource administration and assignment, roles, teams, portfolio analysis, capacity planning, Return on Investment (ROI), and convenient dashboards for measuring performance at every level at any moment.","Documents: P6 includes document management support with or without the optional document repository option. Use the optional document collaboration features to conduct document reviews with key stakeholders to keep projects moving or meet regulatory compliance.","Workflows: The workflow engine bundled with P6 EPPM provides Business Process Modeling Notation (BPMN) compliant graphical notation that depicts the steps in your project initiation workflows. Use the integrated Workflows portlet to coordinate the sequence of tasks that flow between different process participants in a series of stages.","Reports: Generate and view reports using your standard web browser running P6. Reports can be generated and routed via email, saved to a shared or local file, or printed to a traditional printer.","Planning and Scheduling: The P6 Professional component of the suite can be used standalone or connected to an EPPM database. It provides a robust set of features primarily for planners and schedulers, including Reflection Projects and a report designer. Use the P6 Visualizer feature to create and customize visual depictions of complex project schedule information, including Gantt charts with Grid data, Timescaled Logic Diagrams, and Schedule Comparison. Some functionality of P6 Professional is available only when connected to an EPPM database.","Time Reporting: P6 EPPM includes timesheet entry in P6 Team Member Web, P6 for Android, and P6 for iOS with review and approval support in P6.","Integrated Solutions: Build or deploy other systems and use the P6 Integration API (on-premises), P6 EPPM Web Services, or Primavera Gateway to integrate them with P6 EPPM. Integrate Risk and Scope functionality from Oracle Primavera Cloud with P6 EPPM via Primavera Gateway. Leverage P6 EPPM's project planning and scheduling system against Primavera Unifier's cost control system via integration with Primavera Gateway.","Technology:","The P6 EPPM Database: The main database for all your P6 EPPM data. The EPPM database includes the P6 Extended Schema optimized for reporting.","BPM Workflow: The separate workflow engine bundled with P6 EPPM.","Reporting Software: Use a supported reporting tool to report on the data that is exposed in the database reporting views.","The Content Repository: Use an Oracle content repository or any CMIS-compliant repository to host documents in a shared repository enabling collaborative functionality such as document check-in/check-out and versioning.","Working with the Oracle Primavera P6 EPPM Suite","39346.htm");
var PageCount=3;


/*
Date: 12/9/2025 11:30 AM
Source: EPPM_25_dev
BookID: 55518
PubProduct: PRIMAVERA_EPPM
BookTitle: System Architecture Data Sheet for On-Premises
Version: Version 25
Lang:	en
*/
	var PageLength=Page.length;
	var Result = "";
	var ResultTemp = "";
	var ResultFound = "";
	var ResultTitleOnly = [];
	var ResultTitleAndContent = [];
	var ResultInContent = [];
	var ResultInContentTemp = [];

	var ResultCombinedTemp = [];
	var ResultCombined = [];

	var arrayIndex = 0;
	var NrRes = 0;
	var j = 0;
	var i = 0;
	var k = 0;
	var d = 0;
	var maxItems = 1000;
	var heading = 0;
	var WordPos = -1;
	var WordPosHeading = -1;
	var WordPosContentText = -1;
	var FoundWord = "";
	var FoundWordHead = "";
	var SearchInHeadingOnly = 0;
	var isChecked;
	var size = 10;
	var resGroupCounter = 0;
	var shown = "shown";
	var checkBoxInHeading;
	var searchFlag = 0;
	var DivResult;
	var SearchWord;

if (SearchText && SearchText.length >= 1) {
		SearchWord = SearchText.replace(/\+/g, " ").replace(/&/g, "&amp;").replace(/</g, "&lt;").replace(/>/g, "&gt;").replace(/"/g, "&quot;");
		searchFlag = 1;
	} else {
		SearchWord = "";
		searchFlag = 0;
	}
	

	if (searchFlag === 1) {
		Result = "";

		// checkBoxInHeading = document.getElementById("inHeading");
		if (inHeading) {

			isChecked = true;
		} else {

			isChecked = false;
		}

		if (SearchWord && SearchWord.length >= 1) {
			if (isChecked) {
				SearchInHeadingOnly = 1;
			} else {
				SearchInHeadingOnly = 0;
			}
			SearchWord = SearchWord.toLowerCase();
			window.status = "Searching, please wait...";
			for (j = 0; j < PageLength; j++) {
				k = Page[j].length - 1;
				for (i = 0; i < k; i++) {

					heading = k - 1;

					if (SearchInHeadingOnly === 1) {
						WordPosHeading = Page[j][heading].toLowerCase().indexOf(SearchWord);
						if (WordPosHeading > -1) {
							FoundWordHead = Page[j][heading].substr(WordPosHeading, SearchWord.length);

							NrRes++;
							ResultTemp = "<li>";
							ResultTemp += "<span>";
							ResultTemp += "<a href='" + Page[j][k] + "'>" + Page[j][heading].replace(FoundWordHead, FoundWordHead.bold()) + "</a><br/>\n";

							ResultTemp += "</span>";
							ResultTemp += "</li>";

							ResultTitleOnly[arrayIndex] = ResultTemp;
							arrayIndex++;

							ResultTemp = "";
							WordPosHeading = -1;
							WordPosContentText = -1;
							break;
						}
					} else if (SearchInHeadingOnly === 0) {
						WordPos = Page[j][i].toLowerCase().indexOf(SearchWord);
						WordPosHeading = Page[j][heading].toLowerCase().indexOf(SearchWord);
						if (WordPos > -1) {
							FoundWordHead = Page[j][heading].substr(WordPosHeading, SearchWord.length);
							FoundWord = Page[j][i].substr(WordPos, SearchWord.length);
							FoundWord = Page[j][i].substr(WordPos, SearchWord.length);
							NrRes++;
							ResultTemp += "<li>";
							ResultTemp += "<span>";
							if (WordPosHeading > -1) {
								ResultTemp += "<a href='" + Page[j][k] + "'>" + Page[j][heading].replace(FoundWordHead, FoundWordHead.bold()) + "</a><br/>\n";
							} else {
								// found word is not in the head
								ResultTemp += "<a href='" + Page[j][k] + "'>" + Page[j][heading] + "</a><br/>\n";

							}
							if (i < k - 1) {
								WordPosContentText = Page[j][i].toLowerCase().indexOf(SearchWord);

								if (Page[j][i].length > 300 && (WordPosContentText > -1)) {

									if (WordPosContentText > 75) {
										ResultInContentTemp.push("..." + Page[j][i].substr(WordPosContentText - 75, 175 + FoundWord.length).replace(FoundWord, FoundWord.bold()) + "...");
									} else {
										ResultInContentTemp.push("..." + Page[j][i].substr(0, 175 + FoundWord.length).replace(FoundWord, FoundWord.bold()) + "...");

									}

								} else if (WordPosContentText > -1) {

									ResultInContentTemp.push(Page[j][i].replace(FoundWord, FoundWord.bold()));

								}
							}

							ResultTemp += ResultInContentTemp.join("");

							ResultTemp += "</span>";
							ResultTemp += "</li>";

							if (WordPosHeading > -1) {
								ResultTitleAndContent[arrayIndex] = ResultTemp;
								arrayIndex++;
							} else {
								ResultInContent[arrayIndex] = ResultTemp;
								arrayIndex++;
							}

							ResultInContentTemp.length = 0;
							ResultTemp = "";
							WordPosHeading = -1;
							WordPosContentText = -1;
							break;
						}

					}
				}
			}

			ResultTitleOnly = ResultTitleOnly.filter(function (n) {
				return (n !== undefined && n !== null);
			});
			ResultTitleAndContent = ResultTitleAndContent.filter(function (n) {
				return (n !== undefined && n !== null);
			});
			ResultInContent = ResultInContent.filter(function (n) {
				return (n !== undefined && n !== null);
			});

			ResultCombinedTemp = ResultTitleOnly.concat(ResultTitleAndContent, ResultInContent);

			ResultCombinedTemp = ResultCombinedTemp.filter(function (n) {
				return (n !== undefined && n !== null);
			});

			for (d = 0; d < ResultCombinedTemp.length; d += size) {
				resGroupCounter++
				ResultCombined.push("<div id=" + "'" + "resGroup_" + resGroupCounter + "'" + " class=" + "'" + "resGroup " + shown + "'" + ">" + "<ol class='searchResults'>" + ResultCombinedTemp.slice(d, d + size).join("") + "</ol></div>");
				shown = "notshown";
			}

			ResultFound = ResultCombined.join("");

Result += "<div id='searchDetailsDiv'>";
			Result += "<p class='searchDetails'>Your Search Found&nbsp;" + NrRes + "&nbsp;items.&nbsp;";
			Result += "</p></div>";
			
			Result += "<div class='searchResultsDiv'>";
			Result += "<div id='resultsCollection' class='searchResults'>";
			Result += ResultFound;
			Result += "</div>";
			Result += "</div>";
			Result += "<div class='searchPaging'>";

			Result += '<hr />';

			Result += '<p class="bodytext"><a class="disabledAnchor" id="pBack" onclick="turnPage(\'backPage\')" href="#pBack">Back</a>&nbsp; | &nbsp;';
			
			if (resGroupCounter && resGroupCounter > 1) {
				Result += '<a id="pNext" onclick="turnPage(\'nextPage\')" href="#pNext">Next</a>';
			} else {
				Result += '<a id="pNext"  class="disabledAnchor" href="#pNext">Next</a>';
			}
			Result += '</p>\n';
			Result += '<div id="pagenofn"><p class="bodytext">Page <span id="pagen">1</span> of ' + resGroupCounter + '</p></div>';

			Result += "</div>";
			
			
		}

		DivResult = document.getElementById("s_anchor");
		if (Result && DivResult) {

			//myDivResult.append(Result);
			DivResult.innerHTML = Result;
			

		}
		window.status = "";
		
		

	}
	}())
}
