'use strict';
function search(SearchText, inHeading) {
(function () {
var Page = [];

/* Generated with Author-it 23.4.1.30004  12/8/2025 4:36:41 PM */
Page[0]=new Array("Title and Copyright Information","Copyright  1999, 2025, Oracle and/or its affiliates.","Primary Author: Oracle Corporation","Title and Copyright Information","46576.htm");
Page[1]=new Array("Scope","This guide describes how to plan your P6 EPPM implementation. It provides an installation process overview, frequently asked questions, client and server requirements, and security information.","Audience","System and database administrators should use this guide.","Using This Guide","This guide assumes you understand the constraints and specifications of the hardware and technical environment on which you will deploy P6 EPPM.","About This Guide","50774.htm");
Page[2]=new Array("Your organization needs several types of employees to install and configure P6 EPPM applications. The following section describes the basic roles, and the responsibilities given to those roles when installing your products. Roles might vary or overlap depending on the structure of your organization.","Network administrators","Network administrators configure an organization's network environment (local- and wide-area networks) for optimal performance with P6 EPPM applications. They install and maintain the server and client modules in the P6 EPPM solution. They manage user access to project data and develop and maintain a comprehensive security policy to protect project data from unauthorized access, theft, or damage. Network administrators ensure that the hardware and software supporting P6 EPPM function reliably by:","Setting up and maintaining the network to ensure reliable connections and the fastest possible data transfer.","Creating and maintaining accurate lists of network resources and users so that each has a unique network identity.","Providing secure connections among applications using SSL/TLS to protect data in transit.","Database administrators","Database administrators (DBAs) are responsible for setting up, managing, and assigning access rights for P6 EPPM.&nbsp;They set and oversee rules on how to use corporate databases, maintain data integrity, and set interoperability standards. Database administrators ensure reliable access to the P6 EPPM database by:","Installing, configuring, and upgrading database server software and related products.","Creating and implementing the databases.","Implementing and maintaining database security, including creating and maintaining users, roles, and privileges for the databases.","Monitoring database performance and tuning.","Planning for growth and changes.","Establishing and maintaining backup and recovery policies and procedures.","P6 EPPM administrators","P6 EPPM administrators&nbsp;ensure that P6 EPPM&nbsp;applications are&nbsp;implemented properly and operate&nbsp;smoothly. They play a key role during implementation by:","Working with senior management to establish the enterprise project structure, resource hierarchy, and organizational breakdown structure (OBS); set up basic calendars; and define organization-wide codes in P6.","Working with the network administrator to create user accounts and user groups for P6 EPPM.","Assigning security rights to P6 EPPM users in P6.","Working with the Human Resources (HR) department to keep the resource hierarchy in P6&nbsp;up-to-date and complete.","Configuring user interface views in P6 to provide efficient, role-based navigation to features.","Web Application administrators","Web Application administrators are responsible for installing, configuring, and deploying P6 EPPM on one of the supported Java application servers. Along with network administrators, they help to maintain server components in the P6 EPPM solution and configure access to P6 EPPM web applications.","Web application administrators ensure reliable access to P6 EPPM applications by:","Installing, configuring, and upgrading application server software and related products.","Configuring secure access to all web applications, including proxy servers.","Monitoring server performance and tuning.","Planning for growth and changes.","Establishing and maintaining scalability.","LDAP administrators","LDAP administrators are responsible for configuring unified access to P6 EPPM via existing LDAP connection details. They are also responsible for assisting web application administrators and network administrators when configuring single sign-on access to P6 EPPM.","Program and project managers","Program and project managers might also become involved in the initial configuration of the P6 EPPM solution, though they are not normally involved in the installation. They are responsible for managing one or more projects and use P6 or P6 Professional for:","Adding projects to the P6 EPPM database.","Prioritizing resources across projects.","Planning and managing projects.","Who Should Help with the Installation?","6727.htm");
Page[3]=new Array("The network administrator, database administrator, and P6 Administrator should work together to successfully install the P6 EPPM solution for your organization.","Oracle recommends installing and configuring the P6 EPPM solution in phases. Each phase is explained below.","Phase 1: Plan your P6 EPPM configuration","Before you begin the installation:","Decide how your organization will implement the P6 EPPM solution. See Planning Your Implementation.","Identify the servers and network hardware you will need to support the implementation. See Client and Server Requirements.","Identify the security requirements for your installation. See Security Guidance Overview.","Install and configure the third-party database server software (Oracle, Oracle Autonomous Database, or Microsoft SQL Server).","Perform any upgrade procedures to roll projects from previous versions into the new version. ","Phase 2: Configure your P6 EPPM servers","Once you have set up your network and prepared your servers, you can begin to configure the servers. Start by setting up the P6 EPPM database on the database server. You can choose an automated or a manual method to complete this process. Oracle recommends the automated method. ","Phase 3: Install and configure your P6 EPPM applications","You can use the P6 EPPM Installation Wizard to install all of your P6 EPPM applications. You do not need to install each application one at a time. ","The wizard installs the following:","P6 Team Member (includes P6 Team Member Web and Email Statusing Service)","Note You will need to configure Email Statusing Service separately. The installation wizard will provide the Email Statusing Service files and you will use the config.properties file to set up this service.","P6 EPPM Web Services","P6 Integration API (remote mode only)","Note Oracle provides a separate installer for P6 Integration API local mode.","If you use reporting software, BPM or a content repository, you will need to install and configure them to work with P6 EPPM before you connect them with the wizard.","Once you install your applications, you can use the P6 EPPM Configuration Wizard to configure your database; deploy your P6 EPPM applications in WebLogic and create managed servers; connect your P6 reporting software and BPM to P6 EPPM. ","Phase 4: Configure P6 Professional","Once your servers are configured and the databases are installed, you can begin to install P6 Professional on your client workstations according to your implementation plan. You can then perform application configuration tasks for your implementation.","Phase 5: Finalize Your Applications","Use the P6 EPPM System Administrator's Guide and P6 EPPM Application Administrator's Guide to finalize the applications so your users can use these applications successfully.","Installation and Configuration Process Phases","6731.htm");
Page[4]=new Array("When deploying P6 components, Oracle recommends maintaining non-production environments in addition to your production environment. Non-production environments are typically known as: Development Environment, Testing Environment, and Staging Environment. Non-production environments allow you to safely test and integrate changes into the system. These changes could include software upgrades, version upgrades, platform and operating system upgrades, configuration changes, and adding new modules. A general description of each environment is shown below. You may choose to maintain only some of them based on the size of your deployment; however, you should consider all of them when setting up your system.","Development Environment","In-house developers or administrators should use development environments to deploy components to develop integrations or proof-of-concept projects.","Testing Environment","Use the testing environment to validate new features of upgraded components, configuration setting changes, or regression testing of existing features.","Staging Environment","This environment is very similar to the Production Environment because it contains all (or mostly all) deployed components of the system. Use it for further testing so you can resolve any integration issues before going live to the Production Environment.","Production Environment (required)","This is the environment where users actually do their work and contains all deployed components of the system.","Technical Environments","62909.htm");
Page[5]=new Array("Read this chapter when you are ready to plan your implementation. For more detailed information and assistance, please consult with Oracle Global Customer Support (if you have questions about installation) or Oracle Primavera GBU Consulting (if you want Oracle Primavera to assist you with your implementation.)","Planning Your Implementation","6726.htm");
Page[6]=new Array("The day one checklists are intended for you to better navigate the P6 EPPM installation library and to assist you in finding the topics that you must complete in order to successfully install, configure, and upgrade an instance of P6 EPPM.","Please note that these checklists might not correspond to your exact installation, configuration, or upgrade scenario. You should make sure that you read and understand each document that is associated with the tasks that you plan to complete in order to determine if this applies to you or not.","The checklists that you find in these sections contain the following information:","The technology specifications for the particular scenario that the checklist covers, such as:","Application Server: WebLogic","Database: Oracle, Oracle Autonomous Database, SQL Server, or a combination","A table that includes many rows and the following four columns:","Done (Y/N): The implementation checklists are intended for you to print out for your own record. As you complete a sequence in the checklist, you should check the cell with the appropriate status. For example, you should mark a cell with Y if you have completed a task or you should mark it with an N if you were not able to complete a task.","Sequence: Establishes the order in which you should complete the steps associated with each topic.","Topic: The name of the topic that you will use to complete the steps for each sequence in the checklist.","Document: The name of the document in which you will find the Topic for the relevant sequence in the checklist.","Day One Checklists","89523.htm");
Page[7]=new Array("The following checklist represents the steps that you need to complete in order to prepare your environment for a P6 EPPM implementation. ","Application Server: WebLogic","Database: Oracle, Oracle Autonomous Database, or SQL Server","Done (Y/N)","Sequence","Topic","Document","1","JDK Installation","Installing and Configuring P6 EPPM","2","Setting an Environment Variable for Java","Installing and Configuring P6 EPPM","3","Installing WebLogic","Installing and Configuring P6 EPPM","4","Installing a Database","Installing and Configuring P6 EPPM","Pre-Installation Checklist","89524.htm");
Page[8]=new Array("The following checklist represents the steps that you need to complete in order to install an instance of P6 EPPM that does not include a content repository, reporting software, or BPM.","Application Server: WebLogic","Database: Oracle, Oracle Autonomous Database, or SQL Server","Done (Y/N)","Sequence","Topic","Document","1","Grant Privileges to the SYSTEM User","P6 EPPM Installation and Configuration Guide","2","Installing Your P6 EPPM Suite","P6 EPPM Installation and Configuration Guide","3","Using the Database Configuration Screen","P6 EPPM Installation and Configuration Guide","4","Using the Database Type &amp; Connection Screen","P6 EPPM Installation and Configuration Guide","5","Using the Create Users Screen","P6 EPPM Installation and Configuration Guide","6","Using the P6 Configuration Settings Screen","P6 EPPM Installation and Configuration Guide","7","Using the Application Server Configuration Screen","P6 EPPM Installation and Configuration Guide","8","Using the Configure WebLogic Screen","P6 EPPM Installation and Configuration Guide","9","Using the Configuration Review Screen","P6 EPPM Installation and Configuration Guide","10","Using the Configuration Progress Screen","P6 EPPM Installation and Configuration Guide","11","Using the Configuration Complete Screen","P6 EPPM Installation and Configuration Guide","P6 EPPM Installation and Configuration Checklist","89526.htm");
Page[9]=new Array("The following checklist represents the steps that you need to complete in order to upgrade your instance of P6 EPPM that: is either version 7.0 or later and uses both WebLogic and an Oracle or Oracle Autonomous Database.","Application Server: WebLogic","Database: Oracle, Oracle Autonomous Database, or SQL Server","Done (Y/N)","Sequence","Topic","Document","1","Stopping WebLogic for P6 EPPM Applications","P6 EPPM Upgrade and Configuration Guide","2","Uninstalling the P6 EPPM","P6 EPPM Upgrade and Configuration Guide","3","Grant Privileges to the System User","P6 EPPM Upgrade and Configuration Guide","4","Running the Validate Tool for a 7.0 or Later Oracle Database (not applicable for Oracle Autonomous Database)","P6 EPPM Upgrade and Configuration Guide","5","Upgrading an Oracle or Oracle Autonomous Database P6 EPPM Database","P6 EPPM Upgrade and Configuration Guide","6","Installing Your P6 EPPM Suite","P6 EPPM Upgrade and Configuration Guide","7","Using the Database Configuration Screen","P6 EPPM Upgrade and Configuration Guide","8","Using the Database Type &amp; Connection Screen","P6 EPPM Upgrade and Configuration Guide","9","Using the Database User Validation Screen","P6 EPPM Upgrade and Configuration Guide","10","Using the P6 Configuration Settings Screen","P6 EPPM Upgrade and Configuration Guide","11","Using the Application Server Configuration Screen","P6 EPPM Upgrade and Configuration Guide","12","Using the Configure WebLogic Screen","P6 EPPM Upgrade and Configuration Guide","13","Using the Configuration Review Screen","P6 EPPM Upgrade and Configuration Guide","14","Using the Configuration Progress Screen","P6 EPPM Upgrade and Configuration Guide","15","Using the Configuration Complete Screen","P6 EPPM Upgrade and Configuration Guide","16","Updating an Existing Primavera P6 Administrator Configuration","P6 EPPM Upgrade and Configuration Guide","17","Starting WebLogic for P6 EPPM Applications","P6 EPPM Upgrade and Configuration Guide","18","Clearing the Cache","P6 EPPM Upgrade and Configuration Guide","P6 EPPM Upgrade Checklist","89736.htm");
Page[10]=new Array("When planning your implementation, you will first need to know which client modules and server components you will need to install and configure, and where those modules and components need to be installed. The following is a set of questions that you will want to answer before you begin.","Which relational database management system (RDBMS) will you use on your database server?","You can use Oracle, Oracle Autonomous Database, or Microsoft SQL Server on your database server. If your P6 EPPM database is a Microsoft SQL Server database, you must first install and configure the Oracle Gateway to use Primavera Data Warehouse with P6 EPPM. Installation and configuration of the Oracle Gateway is explained in the Primavera Data Warehouse Installation and Configuration Guide.","Which workstations will require P6 Professional?","All P6 Professional users will need access to the database server. If using Oracle or Oracle Autonomous Database as the RDBMS, you will need to install the Oracle client software on each computer that runs this client module. If using Microsoft SQL Server as the RDBMS, the required Microsoft SQL Server files have already been included with Windows.","Do you want your administrators to install P6 Professional using standardized preconfigured settings?","If you want your client module to be configured identically, your administrators can run an unattended setup based on a standard configuration. You can create one or more sets of unattended setup files and share them on a network server. Alternatively, you can use configure and deploy P6 Professional using ClickOnce.","Do you need to integrate your project data with other&nbsp;global systems?","If you need to integrate your project data with other global&nbsp;systems, such as Accounting or Human Resources applications, you will need to install P6 Integration API or P6 EPPM Web Services&nbsp;on computers that require access to the data. The P6 Integration API requires knowledge of Java programming. P6 EPPM Web Services seamlessly integrates P6 EPPM functionality into other applications via open standards, including XML, SOAP, and WSDL.","Do some users require the ability to manage their projects in Microsoft Project while utilizing P6 EPPM to manage global data? ","Your organization might currently use Microsoft Project to manage projects. Use P6 and P6 Professional import/export functionality to share projects, resources, and roles data with Microsoft Project. For more information, see the P6 Help or the P6 Professional Help.","Do you want to utilize password security features?","When the authentication mode is set to &quot;Native, P6 EPPM offers a strong password policy feature. When enabled, this feature requires that all new and modified passwords be between 8 and 20 characters and contain at least one number and one letter. P6 offers additional password security enhancements when using Native mode, such as a login lockout count and login lockout duration. If using Single Sign-On or LDAP authentication, the security set on the host authentication server overrides the password security features in P6 EPPM.","What technologies do I need to support my integrations?","You will need these technologies to support your integrations:","For reporting, you'll need Oracle Analytics Publisher.","To support project initiations for Workflows, you'll need Oracle BPM. ","For visualization support in documents, you'll need Oracle AutoVue. ","Also, you can use Oracle Identity Manager to:","Centrally administer user accounts and access privileges","Deploy a P6 EPPM plugin in Oracle Enterprise Manager to display P6 EPPM metrics. ","For more information about P6 EPPM's integration with Oracle Identity Manager see P6 EPPM Oracle Identity Manager Configuration Guide.","Which Components Do I Need?","6748.htm");
Page[11]=new Array("P6 provides access to project data via a Web browser. It supports creating and managing projects within the company, provides resource availability and allocation details, and provides project portfolio reporting features to support strategic decision-making.","The following table lists each client component and the corresponding server-based components that it requires."," ","RDBMS server","P6 server","Content and Workflows Repositories server","P6 Professional module","X1","X","P6 module","X","X","X3","1&nbsp;&nbsp;If using Oracle or Oracle Autonomous Database as the RDBMS, these modules require the Oracle client software to be on the client computer (unless connecting via Cloud Connect).","2&nbsp;&nbsp;The Content and Workflows Repositories are optional components of P6. They can serve as aids in document management and project initiation processes.","Required Server Components for Web-based Access in P6 EPPM","12796.htm");
Page[12]=new Array("After determining your P6 EPPM implementation plan, ensure that your hardware and software can support it. ","For the full list of system requirements, versions, and tested configurations, see the Tested Configurations document.  For guidance on hardware and software requirements, see the P6 EPPM Performance and Sizing Guide.","Client and Server Requirements","6749.htm");
Page[13]=new Array("Installing the entire P6 EPPM suite requires 1GB of hard disk space. Configuring the WebLogic domain requires 1.75 GB of hard disk space as well as 4 GB of available system memory.","Note These numbers do not include the space required by the database, which is dependent on the configuration. ","Minimum Hard Disk Space","55350.htm");
Page[14]=new Array("During the installation and configuration process for P6 EPPM, several options are available that impact security. Depending on your organization's needs, you might need to create a highly secure environment for all P6 EPPM environments. Use the following guidelines to plan your security strategy for P6 EPPM:","Review all security documentation for applications and hardware components that interact or integrate with P6 EPPM. Oracle recommends you harden your environment. See Additional Sources for Security Guidance for links to information that can help you get started.","Read through the summary of considerations for P6 EPPM included in this document. Areas covered include: safe deployment, authentication options, authorization, confidentiality, sensitive data, reliability, and cookies usage.","Tip","As with any software product, be aware that security changes made for third party applications might affect P6 EPPM applications. For example, if you configure WebLogic to use only SSL v3.0, you must disable TLS v1.0 for the client JRE for P6 to launch properly.","Security Guidance Overview","34203.htm");
Page[15]=new Array("To ensure overall safe deployment of P6 EPPM, you should carefully plan security for all components, such as database servers and client computers that are required for and interact with P6 EPPM. In addition to the documentation included with other applications and hardware components, follow the P6 EPPM-specific guidance below.","Safe Deployment of P6 EPPM","43896.htm");
Page[16]=new Array("As the P6 EPPM Administrator, you should consider the minimum administrative privileges or permissions needed to install, configure, and operate P6 EPPM. For example, to successfully install the required JRE for the P6 application server components, you must have administrative access on that server during the installation or update.","Administrative Privileges Needed for Installation and Operation","43898.htm");
Page[17]=new Array("Because P6 and P6 Team Member Web are Web applications, users do not have to be administrators on their machines to run them. Instead, you can successfully run these applications with security at the highest level to create a more secure environment.","Minimum Client Permissions Needed for P6 and P6 Team Member Web","44872.htm");
Page[18]=new Array("Users do not have to be administrators on their machines to run P6 Professional. Instead, you can grant minimum permissions to create a more secure environment.","The default installation folder for P6 Professional is:","local drive\\Program Files\\Oracle\\Primavera P6\\P6 Professional","However, because the install location can be modified, we will refer instead to \\\\&lt;Install directory&gt;\\ in these instructions.","The following list summarizes the minimum system requirements needed to access and run components of P6 Professional Version 25:","Files within Folders:","To run P6 Professional, users require Read &amp; Execute permissions for the following files:","\\\\&lt;Install directory&gt;\\","dbexpsda40.dll","dbexpsqlite40.dll","dbexpoda40.dll","dbxadapter.dll","To log into P6 Professional applications, users require Read&amp;Execute/Read/Write permissions to access the ini file.","\\\\&lt;Install directory&gt;\\Data\\pm.ini","To run the Database Configuration setup and the Primavera P6 Administrator users require Read&amp;Execute/Read permissions for the following files:","\\\\&lt;Install directory&gt;\\","dbconfig.exe","primavera.adminconfig.exe","During installation, the PrmBootStrapV2.xml file is copied from the install location to the user location. It will also be copied to this location if it is not present when P6 Professional starts or during database configuration. The version of the file stored in the install location will never be modified while using P6 Professional, so it can be copied to the current user location if you need to revert P6 Professional back to its original state (for example, if files become corrupted).","To run P6 Professional, users require Read permission to the following file:","\\\\&lt;Install directory&gt;\\Data\\ PrmBootStrapV2.xml","To run P6 Professional, users require Read&amp;Execute/Read/Write permissions to the following file:","%APPDATA%\\Oracle\\Primavera P6\\P6 Professional\\&lt;VERSION&gt;\\PrmBootStrapV2.xml ","To export data and for log files to be created, users require Read&amp;Execute/Read/Write permissions to any location that will be used as an output directory. Depending on your configuration, this might include the %APPDATA% and %LOCALAPPDATA% directories.","Minimum Client Permissions Needed for P6 Professional","32016.htm");
Page[19]=new Array("You should physically secure all hardware hosting P6 EPPM to maintain a safe implementation environment. Consider the following when planning your physical security strategy:","You should install, configure, manage, and maintain your environment according to guidance in all applicable installation and configuration documentation for P6 EPPM.","You should install P6 EPPM components in controlled access facilities to prevent unauthorized access. Only authorized administrators for the systems hosting P6 EPPM should have physical access to those systems. Such administrators include the Operating System Administrators, Application Server Administrators, and Database Administrators.","You should use Administrator access to client machines only when you install and configure P6 EPPM modules.","Physical Security Requirements for P6 EPPM","43900.htm");
Page[20]=new Array("P6 EPPM contains a number of security settings at the application level. The P6 EPPM Application Administrator's Guide details these settings.","To help you organize your planning, the following are options Oracle recommends:","In your production environment, opt for empty data instead of sample data during the P6 EPPM database setup. ","If using P6 EPPM native authentication, enable Password Policy in Application Settings.","If using LDAP and SSO authentication, configure the LDAP and SSO components to enforce high quality passwords within their password policy settings.","Enable firewall software on the application server and database server. Based on your installation, add exceptions for appropriate ports. ","For instance, P6 EPPM SQL Server Database runs on 1433 port and Oracle Database runs on 1521 port by default. P6 EPPM and P6 Team Member Web run on 8203 and 8207 ports respectively in the default installation. ","In the Primavera P6 Administrator:","evaluate the Login Lockout Count; the default is 5.","set the Enable Cross Site Request Forgery Checking Filter setting to true.","set the Enable Session Hijack Checking setting to true.","Caution If this setting is set to true, the server will bind the user's IP Address with session id for authentication and authorization. If a user's IP address changes, this setting may cause authentication issues. Oracle recommends testing this setting thoroughly before implementation.","keep Multiple User for the Content Repository authentication mode.","use Security Accounts if using Oracle Universal Content Management for the Content Repository.","use STRONG for the Directory Services security level.","keep the Enable Cross Site Scripting Filter setting set to true.","enable LDAP or WebSSO for authentication.","if using WebSSO, set &quot;Application\\Logout URL&quot; in the Primavera P6 Administrator to your SSO logout URL to ensure that the SSO sessions end.","Note The HTTPS authentication setting requires that web server and application server settings support SSL.","Application Security Settings in P6 EPPM","43901.htm");
Page[21]=new Array("While P6 EPPM requires specific files for installation and configuration, you do not need some for daily operations. The following is not a comprehensive list, but you should protect these files and their corresponding folders from unauthorized access after installation is complete:","DatabaseSetup.log","Captures processes performed during P6 EPPM database installation.","Default Location = user home directory (for example, C:\\Documents and Settings\\Administrator)","adminpv.cmd (or adminpv.sh for Linux)","Launches the Primavera P6 Administrator.","Default location = P6 EPPM home directory, as specified during installation.","dbconfigpv.cmd (or dbconfig.sh for Linux)","Used to create the connection between the P6 EPPM database and P6.","Default location = P6 EPPM home directory, as specified during installation.","Files to Protect after Implementation","11703.htm");
Page[22]=new Array("Authentication determines the identity of users before granting access to P6 EPPM modules. P6 EPPM offers the following authentication modes:","Native is the default mode for P6 EPPM. In Native mode, the P6 EPPM database acts as the authority and the application handles the authentication of the user who is logging into that application.","Single Sign-On (SSO) controls access to Web applications. In SSO mode, the applications are protected resources. When a user tries to log in, a Web agent intercepts the request and prompts the user for login credentials. The Web agent passes the user's credentials to a policy server, which authenticates them against a user data store. With SSO, once the users log in, they are logged in to all Web applications during their browser session (as long as all Web applications authenticate against the same policy server). ","Lightweight Directory Access Protocol (LDAP) authenticates users through a directory and is available for all applications. You can use LDAP referrals&nbsp;with Oracle Internet Directory and Microsoft Windows Active Directory. LDAP referrals allow authentication to extend to another domain. You can also configure multiple LDAP servers, which supports failover and enables you to search for users in multiple LDAP stores. An LDAP directory server database confirms the user's identity when they attempt to login to the application.","Single Sign-On or LDAP will help you to create the most secure authentication environment available in P6 EPPM.","P6 EPPM Web Services offers its own authentication options. If you use SAML for P6 EPPM Web Services, you must use Single Sign-on or LDAP authentication for P6 EPPM. See the P6 EPPM System Administrator's Guide for more information on P6 EPPM Web Services authentication options.","Authentication Options for P6 EPPM","43902.htm");
Page[23]=new Array("Grant authorization carefully to all appropriate P6 EPPM users. The P6 EPPM Application Administration Guide details the most secure application security options.","To help you with security planning, consider the following authorization-related options:","Use Module Access rights to limit access to P6 EPPM modules.","Use Global profiles to limit privileges to global data. Assign the Admin Superuser account sparingly. ","Use Project profiles to limit privileges to project data. Assign the Project Superuser account sparingly.","Assign OBS elements to EPS nodes to limit access to projects.","Assign resource access limitations to each user.","Authorization for P6 EPPM","43905.htm");
Page[24]=new Array("Confidentiality ensures only authorized users see stored and transmitted information. In addition to the documentation included with other applications and hardware components, follow the P6 EPPM-specific guidance below.","For data in transit, use SSL/TLS to protect network connections among modules. If you use LDAP or SSO authentication, ensure you use LDAPS to connect to the directory server.","For data in transit, disable http listener on your application server or fronting web server, only allow https connections from browsers.","For data at rest, refer to the documentation included with the database server for instructions on securing the database.","Confidentiality for P6 EPPM","43907.htm");
Page[25]=new Array("Protect sensitive data in P6 EPPM, such as user names, passwords, and e-mail addresses. Use the process below to help during your security planning:","Identify which P6 EPPM modules you will use.","Determine which modules and interacting applications display or transmit data that your organization considers sensitive. For example, P6 displays sensitive data, such as costs and secure codes.","Implement security measures in P6 EPPM to carefully grant users access to sensitive data. For example, use a combination of Global Profiles, Project Profiles, and OBS access to limit access to data.","Implement security measures for applications that interact with P6 EPPM, as detailed in the documentation included with those applications. For example, follow the security guidance provided with Oracle WebLogic.","Implement consent notices in P6 EPPM to gather the consent of users to store, use, process and transmit personal information (PI) and to alert users when there is a risk of PI being exposed.","Sensitive Data for P6 EPPM","43908.htm");
Page[26]=new Array("Protect against attacks that could deny a service by:","Installing the latest security patches.","Replacing the default Admin Superuser (admin) immediately after a manual database installation or an upgrade from P6 version 7.0 and earlier.","Ensuring log settings meet the operational needs of the server environment. Do not use &quot;Debug&quot; log level in production environments.","Documenting the configuration settings used for servers and create a process for changing them.","Setting a maximum age for the session cookie on the application server.","Protecting access to configuration files with physical and file system security.","Reliability for P6 EPPM","43909.htm");
Page[27]=new Array("View the details below for information on cookies in P6 and P6 Team Member Web.","Cookies Usage in P6 EPPM","46784.htm");
Page[28]=new Array("Oracle might use cookies for authentication, session management, remembering application behavior preferences and performance characteristics, and to provide documentation support.","Also, Oracle might use cookies to remember your log-in details, collect statistics to optimize site functionality, and deliver marketing based on your interests.","Cookies Usage in P6","46788.htm");
Page[29]=new Array("Oracle might use cookies for authentication, session management, remembering application behavior preferences and performance characteristics, and to provide documentation support.","Also, Oracle might use cookies to remember your log-in details, collect statistics to optimize site functionality, and deliver marketing based on your interests.","Cookies Usage in P6 Team Member Web","79464.htm");
Page[30]=new Array("Oracle might use cookies for authentication, session management, remembering application behavior preferences and performance characteristics, and to provide documentation support.","Also, Oracle might use cookies to remember your log-in details, collect statistics to optimize site functionality, and deliver marketing based on your interests.","Cookies Usage in P6 Professional","97607.htm");
Page[31]=new Array("You should properly secure the databases, platforms, and servers that you use for P6 EPPM. You might find the links below helpful when planning your security strategy (not a comprehensive list).","Note The URLs below might have changed after Oracle published this guide.","Oracle Database","http://download.oracle.com/docs/cd/B19306_01/network.102/b14266/toc.htm ","Oracle Linux Security Guide","http://www.oracle.com/technetwork/articles/servers-storage-admin/secure-linux-env-1841089.html","Microsoft SQL Server 2014 SP1 Database","https://www.microsoft.com/en-us/server-cloud/products/sql-server/Resources.aspx","Microsoft Windows 2012 R2 Server","https://www.microsoft.com/en-us/server-cloud/products/sql-server-editions/overview.aspx","Oracle WebLogic","http://www.oracle.com/technetwork/middleware/weblogic/documentation/index.html","http://download.oracle.com/docs/cd/E12840_01/wls/docs103/secmanage/ssl.html","Oracle Fusion Middleware Security Guides","http://download.oracle.com/docs/cd/E12839_01/security.htm","Additional Sources for Security Guidance","80312.htm");
Page[32]=new Array("Once you know your components and client and server requirements, you can begin your installation and configuration. P6 EPPM provides a simple way to install and configure your database, web server, and applications by allowing you to install all of your applications at once and configure them with one configuration wizard.","You can choose to install and configure your applications automatically or you can choose a manual process for configuring your database, application server, and applications.","Note Manual creation of the P6 database is not yet supported for Oracle Autonomous Database.","Choosing Your Installation and Configuration Process","51448.htm");
Page[33]=new Array("You can download the media pack that contains the installer and all required install files from the Oracle Software Delivery Cloud website at https://edelivery.oracle.com.","Run setup.exe in the Primavera P6 Enterprise Project Portfolio Management physical media or download to install the following P6 EPPM applications:","Note","You do not have to install all applications; you can pick and choose what you install. However, you must install P6 to run the other P6 EPPM applications.","P6 Team Member (includes P6 Team Member Web and Email Statusing Service)","Note","You will need to configure Email Statusing Service separately. The installation wizard will provide the Email Statusing Service files and you will use the config.properties file to set up this service. See the P6 EPPM System Administration Guide.","P6 mobile supports SSL (https) only when it has a certificate signed by a valid authority.","P6 EPPM Web Services","P6 Professional Cloud Connect ","Select the P6 Professional Cloud Connect install option if you plan to use P6 Professional with an P6 EPPM Oracle or Oracle Autonomous Database database on the cloud by connecting to a remote service. The wizard sets up a remote method of access to connect to the EPPM database and the P6 APIs. For more details on establishing the P6 Professional Cloud Connect database connection in P6 Professional, see the P6 Professional Installation and Configuration Guide (P6 EPPM). ","Note The wizard will also install P6 Integration API (in remote mode) by default.","P6 Integration API (remote mode only)","Note Oracle provides a separate installer for P6 Integration API local mode. See the P6 Integration API Configuration Guide.","P6 mobile","Note","P6 mobile apps are downloaded through the Apple App Store or the Google Play Store. See the P6 Team Member User's Guide.","P6 mobile supports SSL (https) only when it has a certificate signed by a valid authority.","Based on whether you are installing or upgrading, see one of the following books:","P6 EPPM Installation and Configuration Guide","P6 EPPM Upgrade and Configuration Guide","Installing P6 EPPM Applications","53137.htm");
Page[34]=new Array("Oracle recommends you use the P6 EPPM Configuration Wizard to configure P6 EPPM, its applications, and WebLogic. With this option, you can install or upgrade your database, deploy your P6 EPPM applications in WebLogic, and configure a content repository, reporting software, and BPM to work with P6.","See P6 EPPM Installation and Configuration Guide for information on how to automatically configure P6 EPPM.","Configuring Your P6 EPPM Applications with the P6 EPPM Configuration Wizard","53138.htm");
Page[35]=new Array("Database","You can manually install or upgrade your database. If you want to install or upgrade your database manually, you can still use the wizard to deploy your P6 EPPM applications in WebLogic and configure a content repository, reporting software, and BPM to work with P6. ","If you want to install or upgrade your database manually, see the P6 EPPM Installation and Configuration Guide for your database.","P6 EPPM Applications","You can manually deploy your P6 EPPM applications in WebLogic. Depending on which applications you are using, use the following:","P6 Server Configuration Guide","WebLogic Configuration Guide","Additional Applications ","You can also use the Primavera P6 Administrator to connect additional applications to P6. Depending on your application, use the following:","P6 EPPM Oracle Analytics Publisher Configuration Guide","P6 EPPM BPM Configuration Guide","P6 EPPM Content Repository Configuration Guide","P6 EPPM Oracle Identity Manager Configuration Guide","Primavera Oracle Access Manager Configuration Guide","Primavera Oracle Enterprise Manager Configuration Guide","Configuring Your P6 EPPM Applications Manually","53139.htm");
Page[36]=new Array("The following applications will work with P6 EPPM, but are not installed or configured with the wizard. See the guides mentioned for more information about each product.","P6 Professional (see the P6 Professional Installation and Configuration Guide)","Oracle Identity Manager (see P6 EPPM Oracle Identity Manager Configuration Guide)","Oracle Enterprise Manager (see Primavera Oracle Enterprise Manager Configuration Guide)","Oracle Access Manager (see Primavera Oracle Access Manager Configuration Guide)","Oracle Analytics Publisher (see P6 EPPM Oracle Analytics Publisher Configuration Guide)","Oracle BPM (see P6 EPPM BPM Configuration Guide)","Installing Additional Applications","53142.htm");
Page[37]=new Array("Now that you have planned your installation and configuration process, you can begin. Follow these steps to get started:","Install your applications. See Installing and Configuring Your P6 EPPM Database or Upgrading and Configuring Your P6 EPPM Database.","If you are automatically configuring your applications, continue using one of the books mentioned above.","If you are manually configuring your applications, use any of the books mentioned in Configuring Your P6 EPPM Applications Manually.","Install any additional applications. See Installing Additional Applications.","Where to Go From Here - Post Planning","53865.htm");
var PageCount=38;


/*
Date: 12/8/2025 4:36 PM
Source: EPPM_25_dev
BookID: 50764
PubProduct: PRIMAVERA_EPPM
BookTitle: Planning and Implementation Guide for On-Premises
Version: Version 25
Lang:	en
*/
	var PageLength=Page.length;
	var Result = "";
	var ResultTemp = "";
	var ResultFound = "";
	var ResultTitleOnly = [];
	var ResultTitleAndContent = [];
	var ResultInContent = [];
	var ResultInContentTemp = [];

	var ResultCombinedTemp = [];
	var ResultCombined = [];

	var arrayIndex = 0;
	var NrRes = 0;
	var j = 0;
	var i = 0;
	var k = 0;
	var d = 0;
	var maxItems = 1000;
	var heading = 0;
	var WordPos = -1;
	var WordPosHeading = -1;
	var WordPosContentText = -1;
	var FoundWord = "";
	var FoundWordHead = "";
	var SearchInHeadingOnly = 0;
	var isChecked;
	var size = 10;
	var resGroupCounter = 0;
	var shown = "shown";
	var checkBoxInHeading;
	var searchFlag = 0;
	var DivResult;
	var SearchWord;

if (SearchText && SearchText.length >= 1) {
		SearchWord = SearchText.replace(/\+/g, " ").replace(/&/g, "&amp;").replace(/</g, "&lt;").replace(/>/g, "&gt;").replace(/"/g, "&quot;");
		searchFlag = 1;
	} else {
		SearchWord = "";
		searchFlag = 0;
	}
	

	if (searchFlag === 1) {
		Result = "";

		// checkBoxInHeading = document.getElementById("inHeading");
		if (inHeading) {

			isChecked = true;
		} else {

			isChecked = false;
		}

		if (SearchWord && SearchWord.length >= 1) {
			if (isChecked) {
				SearchInHeadingOnly = 1;
			} else {
				SearchInHeadingOnly = 0;
			}
			SearchWord = SearchWord.toLowerCase();
			window.status = "Searching, please wait...";
			for (j = 0; j < PageLength; j++) {
				k = Page[j].length - 1;
				for (i = 0; i < k; i++) {

					heading = k - 1;

					if (SearchInHeadingOnly === 1) {
						WordPosHeading = Page[j][heading].toLowerCase().indexOf(SearchWord);
						if (WordPosHeading > -1) {
							FoundWordHead = Page[j][heading].substr(WordPosHeading, SearchWord.length);

							NrRes++;
							ResultTemp = "<li>";
							ResultTemp += "<span>";
							ResultTemp += "<a href='" + Page[j][k] + "'>" + Page[j][heading].replace(FoundWordHead, FoundWordHead.bold()) + "</a><br/>\n";

							ResultTemp += "</span>";
							ResultTemp += "</li>";

							ResultTitleOnly[arrayIndex] = ResultTemp;
							arrayIndex++;

							ResultTemp = "";
							WordPosHeading = -1;
							WordPosContentText = -1;
							break;
						}
					} else if (SearchInHeadingOnly === 0) {
						WordPos = Page[j][i].toLowerCase().indexOf(SearchWord);
						WordPosHeading = Page[j][heading].toLowerCase().indexOf(SearchWord);
						if (WordPos > -1) {
							FoundWordHead = Page[j][heading].substr(WordPosHeading, SearchWord.length);
							FoundWord = Page[j][i].substr(WordPos, SearchWord.length);
							FoundWord = Page[j][i].substr(WordPos, SearchWord.length);
							NrRes++;
							ResultTemp += "<li>";
							ResultTemp += "<span>";
							if (WordPosHeading > -1) {
								ResultTemp += "<a href='" + Page[j][k] + "'>" + Page[j][heading].replace(FoundWordHead, FoundWordHead.bold()) + "</a><br/>\n";
							} else {
								// found word is not in the head
								ResultTemp += "<a href='" + Page[j][k] + "'>" + Page[j][heading] + "</a><br/>\n";

							}
							if (i < k - 1) {
								WordPosContentText = Page[j][i].toLowerCase().indexOf(SearchWord);

								if (Page[j][i].length > 300 && (WordPosContentText > -1)) {

									if (WordPosContentText > 75) {
										ResultInContentTemp.push("..." + Page[j][i].substr(WordPosContentText - 75, 175 + FoundWord.length).replace(FoundWord, FoundWord.bold()) + "...");
									} else {
										ResultInContentTemp.push("..." + Page[j][i].substr(0, 175 + FoundWord.length).replace(FoundWord, FoundWord.bold()) + "...");

									}

								} else if (WordPosContentText > -1) {

									ResultInContentTemp.push(Page[j][i].replace(FoundWord, FoundWord.bold()));

								}
							}

							ResultTemp += ResultInContentTemp.join("");

							ResultTemp += "</span>";
							ResultTemp += "</li>";

							if (WordPosHeading > -1) {
								ResultTitleAndContent[arrayIndex] = ResultTemp;
								arrayIndex++;
							} else {
								ResultInContent[arrayIndex] = ResultTemp;
								arrayIndex++;
							}

							ResultInContentTemp.length = 0;
							ResultTemp = "";
							WordPosHeading = -1;
							WordPosContentText = -1;
							break;
						}

					}
				}
			}

			ResultTitleOnly = ResultTitleOnly.filter(function (n) {
				return (n !== undefined && n !== null);
			});
			ResultTitleAndContent = ResultTitleAndContent.filter(function (n) {
				return (n !== undefined && n !== null);
			});
			ResultInContent = ResultInContent.filter(function (n) {
				return (n !== undefined && n !== null);
			});

			ResultCombinedTemp = ResultTitleOnly.concat(ResultTitleAndContent, ResultInContent);

			ResultCombinedTemp = ResultCombinedTemp.filter(function (n) {
				return (n !== undefined && n !== null);
			});

			for (d = 0; d < ResultCombinedTemp.length; d += size) {
				resGroupCounter++
				ResultCombined.push("<div id=" + "'" + "resGroup_" + resGroupCounter + "'" + " class=" + "'" + "resGroup " + shown + "'" + ">" + "<ol class='searchResults'>" + ResultCombinedTemp.slice(d, d + size).join("") + "</ol></div>");
				shown = "notshown";
			}

			ResultFound = ResultCombined.join("");

Result += "<div id='searchDetailsDiv'>";
			Result += "<p class='searchDetails'>Your Search Found&nbsp;" + NrRes + "&nbsp;items.&nbsp;";
			Result += "</p></div>";
			
			Result += "<div class='searchResultsDiv'>";
			Result += "<div id='resultsCollection' class='searchResults'>";
			Result += ResultFound;
			Result += "</div>";
			Result += "</div>";
			Result += "<div class='searchPaging'>";

			Result += '<hr />';

			Result += '<p class="bodytext"><a class="disabledAnchor" id="pBack" onclick="turnPage(\'backPage\')" href="#pBack">Back</a>&nbsp; | &nbsp;';
			
			if (resGroupCounter && resGroupCounter > 1) {
				Result += '<a id="pNext" onclick="turnPage(\'nextPage\')" href="#pNext">Next</a>';
			} else {
				Result += '<a id="pNext"  class="disabledAnchor" href="#pNext">Next</a>';
			}
			Result += '</p>\n';
			Result += '<div id="pagenofn"><p class="bodytext">Page <span id="pagen">1</span> of ' + resGroupCounter + '</p></div>';

			Result += "</div>";
			
			
		}

		DivResult = document.getElementById("s_anchor");
		if (Result && DivResult) {

			//myDivResult.append(Result);
			DivResult.innerHTML = Result;
			

		}
		window.status = "";
		
		

	}
	}())
}
