'use strict';
function search(SearchText, inHeading) {
(function () {
var Page = [];

/* Generated with Author-it 23.4.1.30004  12/8/2025 4:37:46 PM */
Page[0]=new Array("Title and Copyright Information","Copyright  1999, 2025, Oracle and/or its affiliates.","Primary Author: Oracle Corporation","Title and Copyright Information","46576.htm");
Page[1]=new Array("P6 Enterprise Project Portfolio Management (EPPM) is a robust and easy-to-use integrated solution for globally prioritizing, planning, managing, and executing projects, programs, and portfolios.","Use this guide to help estimate the hardware required for you to deploy P6 EPPM.","This guide provides recommendations for three deployment scenarios (Small, Medium, and Large), depending on the number of end-users. See Deployment Categories for more details. ","Audience","System, network, and database administrators should use this guide.","Using This Guide","This guide assumes you desire a highly available production environment and that you follow current database high availability, backup, and recovery best practices.","Note Hardware and Software requirements for load balancing and network devices are beyond the scope of this document.","About This Guide","61480.htm");
Page[2]=new Array("P6 EPPM is a Java 2 Enterprise Edition (J2EE platform) web application. P6 EPPM uses the J2EE specification to build a flexible and scalable cross-platform solution. The J2EE platform consists of a set of industry-standard services, APIs, and protocols that provide functionality for developing multi-tiered, web-based, enterprise applications. ","The division of tiers enables the application to scale according to customers' performance demands. The main tiers of P6 EPPM are:","The application layer &#8211; A web server layer rendering JSPs, JavaScript, Applets, and so on to present a feature-rich user interface accessible through supported browsers.","The functional layer &#8211; A J2EE application server forms the middle tier where all business logic for P6 EPPM is implemented. This layer runs the business logic for both P6 and P6 Services.","The database layer &#8211;The database layer consists of a standalone or clustered RDBMS environment utilizing Java Database Connectivity (JDBC) to integrate with the functional layer.","The following image provides an overview of the P6 EPPM architecture.","P6 EPPM resides on an application server, and the application data repository resides on the database server.","Typical P6 EPPM deployments consist of the following components:","A clustered web server load balanced using a load balancing router or software solution. End-users, including administrators, interact with P6 through these web servers.","A clustered J2EE application server on which P6 EPPM is deployed.","RDBMS as a data repository for P6 EPPM. Depending on the dataset size, the database server can be a standalone or clustered server. In the following sample architecture, the database is clustered. For optimized performance, Oracle recommends that the application servers and RDBMS are co-located, for example, within the same subnet, to avoid network latency.","The following illustrates a sample P6 EPPM deployment.","Architecture Overview","61481.htm");
Page[3]=new Array("While there are multiple ways to achieve the desired performance and scalability levels in P6 EPPM, the performance considerations can be grouped into two categories:","Vertical Scaling","Horizontal Scaling","There are several advantages (and disadvantages) for each category. Your organization can decide which to use, based on:","The desired level of performance","Availability requirements","Short-term versus long-term outlook of system usage","Seasonality and frequently used application areas","Number of concurrent users","Performance and Scalability Considerations","61482.htm");
Page[4]=new Array("Vertical scaling involves adding additional resources, or upgrading resources on an existing system. Vertical is a preferred approach if the application bottlenecks are related to processor and memory.","Vertical Scaling (Scaling up)","61483.htm");
Page[5]=new Array("The objects (such as Projects, Activities, Assignments, etc.) are stored in the Java Virtual Machine (JVM) heap allocation. Most of these objects are short-lived and are periodically cleaned up by the JVM's garbage collection mechanism.","An increase of concurrent users causes the number of objects in the heap to increase. The resulting congestion and higher frequency of garbage collection can impact the performance and scalability of the system.","Increasing the JVM heap (with the adequate physical memory provisioned) is an efficient way to achieve the desired performance and scalability. See Deployment Categories for guidelines on configuring the optimal JVM heap size.","JVM Heap Size","61484.htm");
Page[6]=new Array("Desired performance and scalability can also be achieved by:","Upgrading the CPU","Adding additional cores","Adding physical memory","Upgrading to faster I/O devices","While vertical scaling is easier to achieve, it does not address availability completely.","If the desired level of availability is high, then vertical scaling alone will not be sufficient. Horizontal scaling can help achieve a higher availability.","Hardware Upgrade","61485.htm");
Page[7]=new Array("The recommended OS upgrades can improve the performance and scalability of P6 EPPM. Ensure that you are:","Upgrading to the latest versions of the operating system.","Installing the latest patch updates","Upgrading to a 64-bit version","Note For the full list of system requirements, applications, and application version levels refer to the Tested Configurations document.","Operating System Upgrade","61486.htm");
Page[8]=new Array("As the demand for applications grows, additional nodes can be added to an existing application server cluster to handle the increased system load. For high availability requirements, horizontal scaling is the better option.","The following figure explains a scaling out deployment.","Horizontal Scaling (Scaling out)","61487.htm");
Page[9]=new Array("As the application use grows within your organization, adding additional server nodes is the best way to achieve required performance and scalability.","If your application usage exhibits a seasonal or periodic variation (for example, the average load on the system quadruples during month-end closing or a plant closes for a week every quarter), then consider adding, or removing, application server nodes to manage these seasonality usage spikes.","To mitigate risk of degraded performance and undesired downtime, it is crucial to understand the business cycles of the organization and to plan for the required level of performance, availability, and scalability.","There are two ways to add application server nodes in a deployment:","Vertical clustering","Horizontal clustering","Application Clustering","61488.htm");
Page[10]=new Array("When you observe that application transaction response times are throttled from increased usage, but the hardware resources of the server (memory and CPU) have enough head room, you can implement vertical clustering by adding two or more server nodes of the application on the same physical server.","The following figure depicts vertical clustering.","Vertical Clustering","79164.htm");
Page[11]=new Array("When you observe that application transaction response times are throttled from increased usage, but the hardware resources of the server (memory and CPU) do not have enough head room, you can implement horizontal clustering by adding another server and installing a P6 instance on the added server.","Horizontal Clustering is depicted in Horizontal Scaling (Scaling out) section of this document. For high availability scenarios Oracle recommends horizontal clustering in production systems. A mix of horizontal and vertical clustering is recommended for large deployments.","Note While creating application clusters, the Administrators should monitor the Database server performance. If performance worsens, they should tune the database or upgrade the hardware.","Horizontal Clustering","79165.htm");
Page[12]=new Array("Database server scaling options are available and have been widely adopted and implemented. Database clustering enables multiple nodes in a clustered system to mount and open a single database that resides on shared disk storage. This configuration provides high availability in the database environment. One example of database clustering is Oracle Real Application Clusters (RAC).","Database Scaling and Clustering","61489.htm");
Page[13]=new Array("P6 EPPM performance depends on the load and the response characteristics of each tier. Performance-affecting factors are identified and discussed in the following sections. These factors should be considered during deployment planning.","Deployment Considerations","61490.htm");
Page[14]=new Array("The number of concurrent users accessing the system directly affects web client performance. Performance is also affected by the web browser being used and the activities performed within each user session (for example, Activity Gantt, Resource Planning, Scheduling, Leveling, Summarizing, Reporting, and so on). Concurrent users and their system activities largely affect the CPU and memory requirements of the application server.","P6 Client","61491.htm");
Page[15]=new Array("P6 EPPM server is a J2EE application that uses J2EE technologies to interact with end-users, target systems, the database repository, etc. Following are some components of server operation that need to be considered during P6 EPPM sizing.","P6 Server","61492.htm");
Page[16]=new Array("This service process can run as a standalone application for better performance and scalability, and it is platform independent. Services are responsible for executing real-time and scheduled application jobs. The following application areas are processed as jobs:","Summarizer","Scheduler","Leveler","Publications","Update Baseline","Add/Create Baseline","Apply Actual","Copy/Paste Project","Export Project XER","Import Project XML","Export Project XML","Services are capable of processing large number of projects, activities, and resource assignments. The number of concurrent jobs greatly affects the CPU, memory requirements of the application server, and load on the database servers.","For medium to large deployments, Oracle recommends setting up a dedicated application server node for services. This application server should not be part of the cluster that processes HTTP requests from the web client. In addition, Oracle recommends turning off services on the application servers in the cluster that are serving web client requests. Adding more dedicated application server nodes for services (horizontally scaling) can address increased performance requirements.","For long-running jobs, Oracle recommends job scheduling off-peak hours. For example, scheduling a job to run when the load on the system is low.","For the initial run of Publication Services, after installing or upgrading P6, Oracle recommends off-peak hours. For example, run Publication Services over the weekend.","For heavily data-intensive jobs (such as summarizing an entire EPS), Oracle recommends sequential, rather than concurrent scheduling. For example, do not schedule two large EPS summarization jobs to run at the same time.","Consider the following while planning for infrastructure for job services.","Heap usage increases as the number of activities increases.","Garbage collection overhead on the application server may increase as the thread count increases. Thread count can increase as the result of high throughput.","Oracle recommends that you use a minimum of 4 GB Java heap (Xms) for the optimum performance of job services.","Database server utilization increases as thread count increases.","A high number of threads does not guarantee high throughput. The number of threads should be configured to a break-even value between throughput and server utilizations.","For more information on P6 Services, see http://www.oracle.com/webfolder/technetwork/tutorials/primavera/OnlineLearning/WhitePapers/P6JobServicesPerformanceTuning.pdf.","P6 Services","61493.htm");
Page[17]=new Array("The following factors could impact the response time and resources for Publication:","Number of activities/assignments","Length of project","Length of publication date range","Length of activities/assignments","Number of financial periods","Publication","61494.htm");
Page[18]=new Array("The Activity Gantt feature can load up to 100,000 activities.","The following factors could impact the response of the Activity Gantt feature:","Number of activities/assignments","Number of activity relationships","Number of open projects","Project length","Depth of WBS hierarchy","Activities/assignments length","Amount of client-side memory allocated to the JRE and applets","Other load on the application server","Activity Gantt","61495.htm");
Page[19]=new Array("The following factors could impact the response time of the Resource Management feature:","Number of resources","Number of resource assignments to activities","Number of open projects","Filter usage","Project length","Depth of WBS hierarchy","Amount of client-side memory allocated to the JRE and applets","Other load on the application server","Resource Management","61496.htm");
Page[20]=new Array("The following factors could impact the response of the Risk feature:","Number of risks","Number of activity assignments to risk","Number of open projects","Number of risk scoring matrix assignments","Number of response plan assignments","Amount of client side memory allocated to the JRE and applets","Other load on the application server","Risks","61497.htm");
Page[21]=new Array("The P6 EPPM Web Services platform employs web-based technology to handle requests from external programs. External client programs use P6 EPPM Web Services by creating a request and sending it to the application server using SOAP (Simple Object Access Protocol). Having received the request, P6 EPPM uses the appropriate business logic required to service the request. The client application does not need to understand the semantics of this processing. Responses or requests from P6 EPPM simply follow the same path in reverse.","P6 EPPM Web Services can be divided into four categories:","Business Object Based Services (CRUD operations)","Job Services","Spread Services","Import and Export Services","Many data set characteristics can impact the performance of P6 EPPM Web Services. All requests should make use of meaningful filters to reduce the amount of data returned by the service. Other factors that can affect the performance of P6 EPPM Web Services are:","System usage &#8211; P6 features in use","Environment","Level of hardware P6 EPPM Web Services","P6 EPPM Web Services","61498.htm");
Page[22]=new Array("You can scale your database servers. Database clustering enables multiple nodes in a clustered system to mount and open a single database that resides on shared disk storage. This configuration provides high availability in the database environment. One example of database clustering is Oracle Real Application Clusters (RAC).","Database Scaling and Clustering","94077.htm");
Page[23]=new Array("P6 EPPM deployments can be classified into three categories (small, medium, and large). The following table includes the criteria used to classify P6 EPPM deployments.","Attributes","Small Deployment","Medium Deployment","Large Deployment","Number of Named Users","&lt; 250","251 - 750 ","751 - 1500","Maximum Concurrent Users (with an average of 20 seconds think time)","50","100","200","Number of Projects","250","1,000","5,000","Number of Activities","100,000","1,000,000","5,000,000","Number of Activities per Project","7,500","25,000","75,000","Number of Resources","500","1,000","4,000","Number of Resource Assignments","100,000","1,000,000","5,000,000","Number of Resource Assignments per Project","5,000","10,000","25,000","Number of Risks","100","500","2,500","These attributes influence the hardware and software specifications of P6 EPPM deployments. The following section outlines server and storage requirements for the above defined deployment categories.","Note","A named user is a user who has an account with the application but may not be logged in. ","A concurrent user is logged in to the application with active interactions.","This document considers 20 second intervals been interactions (the think time).","Hardware sizing is based on the maximum number of concurrent users for each deployment category.","Deployment Categories","61499.htm");
Page[24]=new Array("For appropriate application scalability, performance, and availability, Oracle recommends that you scale your hardware to a minimum of the values in the following tables:","Important information about Configuration for Deployment Categories","The recommended JVM Heap and CPU requirements are the overall sizing needs to accommodate the Deployment Category. These recommendations can be distributed across managed server instances in case of clustering.","The CPU and JVM Heap recommendations are intended for the P6 EPPM application instances only. Operating System and other services or processes demands must be sized separately.","The CPU and JVM Heap recommendations are appropriate for the configurations supported as mentioned in the Tested Configurations document.","For optimal system performance, Oracle recommends that you deploy P6 EPPM on a 64-bit architecture. A 64-bit architecture includes a 64-bit hardware, 64-bit operation system, 64-bit application servers, and databases deployments using 64-bit Java JDK.","P6 - Application Server Configuration","Considerations","Small","Medium","Large","JVM Heap","6 GB","12 GB","24 GB","CPU <br />64 bit, 1 Core @ 2.90 GHz, Intel Xeon CPU E5-2690, or equivalent","2 Cores","4 Cores","8 Cores","Server/VM Disk Space","40 GB","80 GB","120 GB","Managed Server Instances","1","2","4","P6 Team Member - Application Server Configuration","Considerations","Small","Medium","Large","JVM Heap","6 GB","12 GB","24 GB","CPU<br />64 bit, 1 Core @ 2.90 GHz, Intel Xeon CPU E5-2690, or equivalent","2 Cores","4 Cores","8 Cores","Server/VM Disk Space","40 GB","80 GB","120 GB","Managed Server Instances","1","2","4","P6 EPPM Web Services - Application Server Configuration","Considerations","Small","Medium","Large","JVM Heap","2 GB","4 GB","8 GB","Managed Server Instances","1","1","2","CPU<br />64 bit, 1 Core @ 2.90 GHz, Intel Xeon CPU E5-2690, or equivalent","1 Core","1 Core","2 Cores","Server/ VM Disk Space","20 GB","40 GB","60 GB","P6 Integration API - Application Server Configuration","Considerations","Small","Medium","Large","JVM Heap","2 GB","2 GB","4 GB","Managed Server Instances","1","1","2","CPU<br />64 bit, 1 Core @ 2.90 GHz, Intel Xeon CPU E5-2690, or equivalent","1 Core","1 Core","2 Cores","Server/ VM Disk Space","20 GB","40 GB","60 GB","P6 Services - Application Server Configuration ","Considerations","Small","Medium","Large","JVM Heap","4 GB","8 GB","16 GB","CPU<br />64 bit, 1 Core @ 2.90 GHz, Intel Xeon CPU E5-2690, or equivalent","2 Cores","4 Cores","8 Cores","Server/VM Disk Space","20 GB","40 GB","60 GB","Managed Server Instances","1","2","4","P6 Professional Cloud Connect &#8211; Application Server Configuration ","Considerations","Small","Medium","Large","JVM Heap","6 GB","12 GB","24 GB","CPU<br />64 bit, 1 Core @ 2.90 GHz, Intel Xeon CPU E5-2690, or equivalent","1 Core","2 Cores","4 Cores","Server/VM Disk Space","40 GB","60 GB","80 GB","Managed Server Instances","1","2","4","Database Server Configuration","Considerations","Small","Medium","Large","CPU","64 bit, 1 Core @ 2.90 GHz, Intel Xeon CPU E5-2690 or equivalent","4 Cores","6 Cores","12 Cores","Memory","16 GB","24 GB","48 GB","Database Storage Size","500 GB","1000 GB","1500 GB","Note If you use Oracle database for storing documents, you may need to increase storage space on the database server based on the expected number of documents stored.","Oracle HTTP Server (OHS) Configuration","Considerations","Small","Medium","Large","CPU","64 bit, 1 Core @ 2.90 GHz, Intel Xeon CPU E5-2690, or equivalent","1 Core","1 Core","1 Core","Memory","4 GB","4 GB","4 GB","Storage","20 GB","20 GB","20 GB","Note The recommended OHS configuration supports the large deployment category and any smaller deployment categories. Follow standard OHS best practices to accommodate the resource demands of deployments with greater load levels than the large deployment category. For more information about deployment categories see Deployment Categories.","P6 Professional - Desktop/Laptop","CPU","Intel Core i5-5300U CPU @ 2.30 GHzz, 2301 Mhz, 2 Core(s), 4 Logical Processors(s), or equivalent","Memory","4 GB (minimum), 8 GB (recommended)","Storage","20 GB (minimum)","Configurations for Deployment Categories","93017.htm");
Page[25]=new Array("As P6 EPPM users make requests to the P6 server using various browsers, the browsers store static content in the cache and only dynamic requests will be sent to the server. You can use the following table to estimate the amount of bandwidth that you may need for a set number of users. However, Oracle recommends that you calculate your applications' bandwidth requirements in order to better represent the number of people actually using the applications assuming varying levels of intensity.","Concurrent Users","&lt;= 10","11 - 25","26 - 50","51 - 100","101 - 150","151 - 300","Recommended Bandwidth (Mbps)","5","12","20","40","65","115","Note","Oracle recommends that you enable compression on the OHS server. The network bandwidth recommendations that are described above are based on compression being enabled in OHS.","The recommended bandwidth estimates take caching into consideration. First page hits to the server are not taken into consideration for bandwidth estimation. The first hit to the server produces a spike in bandwidth because all of static web components will be fetched from the server. After static content is cached, all subsequent requests contact the server for dynamic content.","You can calculate the bandwidth requirements for an application using the following process:","Calculate the weighted average of the request and compressed response payload-sizes (s) in KB considering the frequency in which your organization views pages and performs actions on them.","Calculate the bandwidth of one user regarding transmission time (n):","Bandwidth (Kbps) = (8 *s) / n","Calculate the bandwidth for a percentage (c%) of the total number of users (u) that are concurrently logged in and are using the system, assuming that think-time and server-side / client-side processing times are negligible:","Bandwidth for named users with zero think / processing time (Kbps) = (8*s*u*c%) / n","Calculate the bandwidth for a percentage (c%) of the total number of users (u) that are concurrently logged in and are using the system, including think-time (t) and server-side / client-side processing times (p):","Bandwidth for named users with think and processing time (Kbps) = (8*s*u*c%) / (n + t + p)","Tip","If a high number of users can access the application, use a low percentage of the total users to estimate your bandwidth. If a low number of users can access the application, use a high percentage of the total users to estimate your bandwidth.","Oracle recommends that you at least provision the bandwidth for a single user even if the value received in this step is smaller. Repeat this process for each application that you deploy.","Calculate your overall bandwidth requirement by adding the highest bandwidth estimates that you calculated for each application.","Network Bandwidth Considerations","79166.htm");
Page[26]=new Array("The following factors can impact application server performance:","Number of worker threads configured in the application server","Number of configured and available database connections","Number of users that will be concurrently uploading data","Other applications running on the application server (CPU utilization before P6 EPPM is installed/started)","The following factors an impact database performance:","Number of database instances on a server (dedicated versus shared)","Disk storage system performance (I/O speed, buffer, mirroring)","Table space layout and extent sizing","Table data, index, and LOB distributions on table spaces","Table and index fill factor definition","Database block sizing","Connection management (dedicated versus MTS)","RAM allocations (automatic, SGA, PGA, shared pool, buffer pool)","CBO optimizer parameter configuration setting","Database table and index statistics gathering mechanism and frequency","Additional database jobs","Factors that Affect Application Performance","61513.htm");
Page[27]=new Array("The following factors can also impact the application performance:","Hardware architecture and operating system","Amount of memory and Swap/Virtual Memory configurations","Anti-virus software","Amount of I/O being performed by other applications running on the servers","Network interfaces (number of NICs, speed and duplex settings)","Network throughput (for example, the time it takes to download a 5 K file between the application server and the browser)","Network bandwidth consumed by other applications","Network hops, latency between the browser and the application server","Amount of memory available on the client for the browser","Configuration, Hardware, and Environmental Factors","94079.htm");
Page[28]=new Array("Some of the other actions that can also impact P6 EPPM application performance include the following:","User actions","User actions play a key role when scaling your application. When sizing a configuration, you need to understand the operations that users plan to perform. For example, if you have 200 users in the system loading activities, then you can expect the application to perform slowly. However, if you have 200 users who log in to look at different light weight operations (for example, dashboards or the ROI page) then the application will perform more quickly. Also, you must consider user roles when determining your scaling options.","Server hardware","You need to evaluate your hardware to see if it will work with the application. If the server is old, it may not handle as many users as a newer server. In some cases, the server may also be virtualized or segmented; this means there are fewer resources for the application. Consider this when planning for the number of users a configuration can handle.","Storage types","All P6 EPPM tests are performed with local disks. You can use server-side disk storage or a SAN configuration for your servers; however, a SAN configuration can be more complex for system set up. You need to ensure that the connections to the SAN are working.","Network","You must ensure your network infrastructure is up-to-date and running efficiently. The application server and the database servers must be in the same location.","Network locations of end-users","Performance can also be affected by the network location of the end user relative to the application server. Any user that has many network hops to the application server will likely experience poor performance. More hops and high latency are key factors that you need to consider when planning an installation.","Other Actions That Affect Performance","94080.htm");
Page[29]=new Array("For creating and managing business processes and workflows, P6 EPPM utilizes Oracle Business Process Management (BPM) technology. For information on hardware and sizing requirements, refer to the BPM documentation at  http://www.oracle.com/us/technologies/bpm/index.html.","Oracle BPM","61515.htm");
Page[30]=new Array("For enterprise reporting, P6 EPPM utilizes BI Publisher. For information on hardware and sizing requirements, refer to the BI Publisher documentation at https://docs.oracle.com/en/middleware/bi/index.html.","BI Publisher","61516.htm");
Page[31]=new Array("For enhanced analytical and advanced reporting capabilities, P6 EPPM utilizes Oracle Business Intelligence Enterprise Edition (OBIEE). For information on hardware and sizing requirements, refer to the OBIEE documentation at https://docs.oracle.com/en/middleware/.","OBIEE","61517.htm");
Page[32]=new Array("For document management and collaboration, P6 EPPM can be configured to use Oracle WebCenter Content Core Capabilities (WCCC) or a CMIS-compliant content repository. For information on hardware and sizing requirements for WCCC, refer to the WCCC documentation at http://www.oracle.com/technetwork/middleware/content-management/overview/index.html.","Content Management System","61518.htm");
Page[33]=new Array("P6 Professional Cloud Connect allows P6 Professional to connect to an EPPM database across a wide area network, for example the internet. Cloud Connect enables P6 Professional to communicate with your P6 EPPM Cloud database.","P6 Professional Cloud Connect","90197.htm");
Page[34]=new Array("Following a systematic approach to evaluating, planning, and testing the architecture for your P6 EPPM deployment is the only way to assure a successful deployment. With careful examination of the performance and scalability objectives, system availability requirements, short-term versus long-term outlook of system usage, seasonality, data structure, and frequently used application areas, the appropriate hardware choices can be made early in the process.","Conclusion","79383.htm");
Page[35]=new Array("Q1. How much hardware does a P6 installation require?","A description of the recommended hardware for each deployment size is described in Configurations for Deployment Categories.","Q2. How much disk space does P6 require?  ","The P6 application requires little space. However, you do need enough space to run the application server software (such as WebLogic) and to keep historic log files. You must also ensure that you have the appropriate amount of disk space available on your database server. If you use Oracle Database for storing documents, you may need to increase storage space on the database server based on the expected number of documents stored.","Disk space recommendations can be found in Configurations for Deployment Categories.","Q3. Do P6 Services affect performance? ","Yes. P6 Services do affect performance for the P6 application. Performance depends on the following factors of P6 Services deployment:","Hardware size","Data size","Service recurring schedules","P6 feature usage","Data change rate","Q4. Should P6 Services be installed on the same server as P6 Web? ","Oracle recommends installing P6 Services on a dedicated server.","Q5. Will I need more space when upgrading to the latest release with Publications from a release lower than 15.2?","Yes. The Publication feature requires additional drive space on the database. A good estimate is to calculate your currently used disk space and double it.","Q6. Do I require more java heap space if my projects have large number of activities?","Heap usage varies with the size of live objects in the heap. Large objects will be created for projects having high number of activities. Oracle recommends a minimum heap size of 4GB (-Xms4096m). However, you might choose to revisit this figure and set it to larger value if the application faces memory issues while loading projects with large number of activities. Heap recommendations can be found in Configurations for Deployment Categories.","Q7. How can I make P6 Services run faster? ","You can make P6 Services faster by:","Ensuring P6 Services are installed on a dedicated server. ","Separating P6 Services onto multiple servers. If performance is a concern, it is a good idea to install all global services on one server and the Project Publication Service on its own dedicated server.","Increasing default thread counts, when working with the Publication feature. This only affects the Project Service.","Verifying that the database has settings optimal for efficiency:","Enough memory","Fast disks","No other database instance running","You can find more information at http://www.oracle.com/webfolder/technetwork/tutorials/primavera/OnlineLearning/WhitePapers/P6JobServicesPerformanceTuning.pdf.","Q8. Should the database be installed in a shared database environment?  ","No. Oracle recommends a dedicated database server for P6 EPPM.","Q9. What is the best way to monitor performance for P6?  ","You can use Oracle Enterprise Manager to monitor many aspects of the database (Oracle database only) in addition to OS and WebLogic exposed metrics.","Q10. What is considered acceptable network latency for P6? ","P6 has been tested within simulated latency environments and offers acceptable performance up to 100 ms (round-trip, browser to application server). Higher latency environments have been tested, but higher network latency results in proportionally slower response times.","Q11. How much disk space will the database schema require for tablespaces?","A description of the recommended disk space for each deployment size is described in Configurations for Deployment Categories.","Q12. How does P6 perform on EXA hardware?","Exalogic and Exadata are engineered systems designed to provide extreme high performance, reliability, ease-of-use and versatility. ","For medium and large deployment categories, Oracle recommends P6 on Exalogic server and Oracle database on Exadata for better performance and scalability.","Frequently Asked Questions","61521.htm");
var PageCount=36;


/*
Date: 12/8/2025 4:37 PM
Source: EPPM_25_dev
BookID: 61479
PubProduct: PRIMAVERA_EPPM
BookTitle: Performance and Sizing Guide for On-Premises
Version: Version 25
Lang:	en
*/
	var PageLength=Page.length;
	var Result = "";
	var ResultTemp = "";
	var ResultFound = "";
	var ResultTitleOnly = [];
	var ResultTitleAndContent = [];
	var ResultInContent = [];
	var ResultInContentTemp = [];

	var ResultCombinedTemp = [];
	var ResultCombined = [];

	var arrayIndex = 0;
	var NrRes = 0;
	var j = 0;
	var i = 0;
	var k = 0;
	var d = 0;
	var maxItems = 1000;
	var heading = 0;
	var WordPos = -1;
	var WordPosHeading = -1;
	var WordPosContentText = -1;
	var FoundWord = "";
	var FoundWordHead = "";
	var SearchInHeadingOnly = 0;
	var isChecked;
	var size = 10;
	var resGroupCounter = 0;
	var shown = "shown";
	var checkBoxInHeading;
	var searchFlag = 0;
	var DivResult;
	var SearchWord;

if (SearchText && SearchText.length >= 1) {
		SearchWord = SearchText.replace(/\+/g, " ").replace(/&/g, "&amp;").replace(/</g, "&lt;").replace(/>/g, "&gt;").replace(/"/g, "&quot;");
		searchFlag = 1;
	} else {
		SearchWord = "";
		searchFlag = 0;
	}
	

	if (searchFlag === 1) {
		Result = "";

		// checkBoxInHeading = document.getElementById("inHeading");
		if (inHeading) {

			isChecked = true;
		} else {

			isChecked = false;
		}

		if (SearchWord && SearchWord.length >= 1) {
			if (isChecked) {
				SearchInHeadingOnly = 1;
			} else {
				SearchInHeadingOnly = 0;
			}
			SearchWord = SearchWord.toLowerCase();
			window.status = "Searching, please wait...";
			for (j = 0; j < PageLength; j++) {
				k = Page[j].length - 1;
				for (i = 0; i < k; i++) {

					heading = k - 1;

					if (SearchInHeadingOnly === 1) {
						WordPosHeading = Page[j][heading].toLowerCase().indexOf(SearchWord);
						if (WordPosHeading > -1) {
							FoundWordHead = Page[j][heading].substr(WordPosHeading, SearchWord.length);

							NrRes++;
							ResultTemp = "<li>";
							ResultTemp += "<span>";
							ResultTemp += "<a href='" + Page[j][k] + "'>" + Page[j][heading].replace(FoundWordHead, FoundWordHead.bold()) + "</a><br/>\n";

							ResultTemp += "</span>";
							ResultTemp += "</li>";

							ResultTitleOnly[arrayIndex] = ResultTemp;
							arrayIndex++;

							ResultTemp = "";
							WordPosHeading = -1;
							WordPosContentText = -1;
							break;
						}
					} else if (SearchInHeadingOnly === 0) {
						WordPos = Page[j][i].toLowerCase().indexOf(SearchWord);
						WordPosHeading = Page[j][heading].toLowerCase().indexOf(SearchWord);
						if (WordPos > -1) {
							FoundWordHead = Page[j][heading].substr(WordPosHeading, SearchWord.length);
							FoundWord = Page[j][i].substr(WordPos, SearchWord.length);
							FoundWord = Page[j][i].substr(WordPos, SearchWord.length);
							NrRes++;
							ResultTemp += "<li>";
							ResultTemp += "<span>";
							if (WordPosHeading > -1) {
								ResultTemp += "<a href='" + Page[j][k] + "'>" + Page[j][heading].replace(FoundWordHead, FoundWordHead.bold()) + "</a><br/>\n";
							} else {
								// found word is not in the head
								ResultTemp += "<a href='" + Page[j][k] + "'>" + Page[j][heading] + "</a><br/>\n";

							}
							if (i < k - 1) {
								WordPosContentText = Page[j][i].toLowerCase().indexOf(SearchWord);

								if (Page[j][i].length > 300 && (WordPosContentText > -1)) {

									if (WordPosContentText > 75) {
										ResultInContentTemp.push("..." + Page[j][i].substr(WordPosContentText - 75, 175 + FoundWord.length).replace(FoundWord, FoundWord.bold()) + "...");
									} else {
										ResultInContentTemp.push("..." + Page[j][i].substr(0, 175 + FoundWord.length).replace(FoundWord, FoundWord.bold()) + "...");

									}

								} else if (WordPosContentText > -1) {

									ResultInContentTemp.push(Page[j][i].replace(FoundWord, FoundWord.bold()));

								}
							}

							ResultTemp += ResultInContentTemp.join("");

							ResultTemp += "</span>";
							ResultTemp += "</li>";

							if (WordPosHeading > -1) {
								ResultTitleAndContent[arrayIndex] = ResultTemp;
								arrayIndex++;
							} else {
								ResultInContent[arrayIndex] = ResultTemp;
								arrayIndex++;
							}

							ResultInContentTemp.length = 0;
							ResultTemp = "";
							WordPosHeading = -1;
							WordPosContentText = -1;
							break;
						}

					}
				}
			}

			ResultTitleOnly = ResultTitleOnly.filter(function (n) {
				return (n !== undefined && n !== null);
			});
			ResultTitleAndContent = ResultTitleAndContent.filter(function (n) {
				return (n !== undefined && n !== null);
			});
			ResultInContent = ResultInContent.filter(function (n) {
				return (n !== undefined && n !== null);
			});

			ResultCombinedTemp = ResultTitleOnly.concat(ResultTitleAndContent, ResultInContent);

			ResultCombinedTemp = ResultCombinedTemp.filter(function (n) {
				return (n !== undefined && n !== null);
			});

			for (d = 0; d < ResultCombinedTemp.length; d += size) {
				resGroupCounter++
				ResultCombined.push("<div id=" + "'" + "resGroup_" + resGroupCounter + "'" + " class=" + "'" + "resGroup " + shown + "'" + ">" + "<ol class='searchResults'>" + ResultCombinedTemp.slice(d, d + size).join("") + "</ol></div>");
				shown = "notshown";
			}

			ResultFound = ResultCombined.join("");

Result += "<div id='searchDetailsDiv'>";
			Result += "<p class='searchDetails'>Your Search Found&nbsp;" + NrRes + "&nbsp;items.&nbsp;";
			Result += "</p></div>";
			
			Result += "<div class='searchResultsDiv'>";
			Result += "<div id='resultsCollection' class='searchResults'>";
			Result += ResultFound;
			Result += "</div>";
			Result += "</div>";
			Result += "<div class='searchPaging'>";

			Result += '<hr />';

			Result += '<p class="bodytext"><a class="disabledAnchor" id="pBack" onclick="turnPage(\'backPage\')" href="#pBack">Back</a>&nbsp; | &nbsp;';
			
			if (resGroupCounter && resGroupCounter > 1) {
				Result += '<a id="pNext" onclick="turnPage(\'nextPage\')" href="#pNext">Next</a>';
			} else {
				Result += '<a id="pNext"  class="disabledAnchor" href="#pNext">Next</a>';
			}
			Result += '</p>\n';
			Result += '<div id="pagenofn"><p class="bodytext">Page <span id="pagen">1</span> of ' + resGroupCounter + '</p></div>';

			Result += "</div>";
			
			
		}

		DivResult = document.getElementById("s_anchor");
		if (Result && DivResult) {

			//myDivResult.append(Result);
			DivResult.innerHTML = Result;
			

		}
		window.status = "";
		
		

	}
	}())
}
