'use strict';
function search(SearchText, inHeading) {
(function () {
var Page = [];

/* Generated with Author-it 23.4.1.30004  12/11/2025 7:36:08 PM */
Page[0]=new Array("Title and Copyright Information","Copyright  1999, 2025, Oracle and/or its affiliates.","Primary Author: Oracle Corporation","Title and Copyright Information","46576.htm");
Page[1]=new Array("Scope","This guide describes how to install and configure  P6 Professional, P6 Visualizer, and Job Service for deployment in production environments.","Audience","Database administrators should use this guide.","Using This Guide","This guide assumes you can perform common database administration procedures and have experience using the command line.","About This Guide","94272.htm");
Page[2]=new Array("This section describes how to install P6 Professional, P6 Visualizer, and Job Service. Run the Installation Wizard on the client/desktop computers that will be used by project personnel.","Install P6 Professional only after you install and configure the database server. The Setup wizard needs to connect to the database server when installing P6 Professional.","You can download the media pack that contains the installer and all required install files from the Oracle Software Delivery Cloud website at https://edelivery.oracle.com.","Installing P6 Professional","54955.htm");
Page[3]=new Array("Before you install P6 Professional, first install the client software for the database you will be using. The database client software enables the client computer to connect over the network to the database on the server computer.","Database Client Software","7579.htm");
Page[4]=new Array("If your database is installed on Oracle Server, use your Oracle database installer to set up an application user and configure your Oracle Net Services client files to match your network. If you are unfamiliar with this process, contact your database administrator.","Note","If your database is installed on Oracle Server, during P6 Professional installation, use the Oracle EZCONNECT string (//&lt;server name&gt;:&lt;listen port&gt;/&lt;service name&gt;) to connect to the P6 Professional database. If you prefer, you can also use the TNSNAMES file instead of EZCONNECT. The TNSNAMES file is in the Oracle home folder on the client computer, not in a shared location. Reference the TNSPING.EXE location in your path environment variable.","If you plan to launch content repository documents from P6 Professional, you must use the TNSNAMES method. ","Ensure that all clients are configured to use TCP/IP as the default network protocol.","Oracle Server Database Client Software","9062.htm");
Page[5]=new Array("If your database is installed on Oracle Autonomous Database, download and install Oracle Instant Client from https://www.oracle.com/database/technologies/instant-client.htmll","Note","If your database is installed on Oracle Autonomous Database, during P6 Professional installation, specify the location of the Wallet file supplied to you and the service you will use. Oracle recommends that you use a service that includes &quot;tp&quot; in the service name.","Ensure that all clients are configured to use TCP/IP as the default network protocol.","Oracle Autonomous Database Client Software","102512.htm");
Page[6]=new Array("If your database is hosted on Oracle Server or on Oracle Autonomous Database, you must configure client computers to use the Oracle Instant Client.","To configure a client computer for Oracle Instant Client:","Copy Oracle Instant Client to a local drive.","Open the Windows Control Panel and click System.","Click Advanced System Settings.","On the Advanced tab, click Environment Variables.","In the System variables pane, locate the Path variable.","Click Edit.","In the Variable Value field, add the location of the Oracle Instant Client (specified in step 1).","Click OK.","Click OK.","Click OK.","Configuring Client Computers for Oracle Instant Client","32738.htm");
Page[7]=new Array("When you install P6 Professional on a client computer, the Microsoft SQL Server client files necessary to connect to P6 Professional are automatically installed for you. Alternatively, you can use your Microsoft SQL Server installation CD to install the client network utility. If you are unfamiliar with this process, contact your database administrator.","Microsoft SQL Server Database Client Software","9061.htm");
Page[8]=new Array("When you run the Installation Wizard, you are presented with the following installation options: Typical and Advanced.","Use the Typical installation option to install typical components.","Use the Advanced installation option when the Typical option does not apply. For example if you want to control the installation of specific P6 Professional components, such as Visualizer and the P6 Professional Database Tools. ","Before You Begin","Before you run the Installation Wizard, review the following items that may impact a successful installation:","You must have full administrative rights to the computer on which you are installing P6 Professional.","Download and extract (unzip) the software to a folder on the local hard drive, such as C:\\Temp.","Avoid downloading the software too deep within the Windows folder structure. It can limit the file name to 256 characters.","Even though you are running P6 Professional as a standalone, a network interface card or modem must be installed and TCP/IP networking software must be running on the computer.","Ensure the DEP (Data Execution Prevention) setting, Turn on DEP for all programs and services except those I select, is not enabled as it can block the creation of the database.","Ensure anti-virus software, anti-spyware software, security software and/or any firewalls are not enabled as they may block programs, protocols, or ports necessary for database creation.","Ensure the UAC (User Account Control) is not enabled as it may block the installation and creation of the database.","Running the Installation Wizard","92677.htm");
Page[9]=new Array("To install P6 Professional with the Typical option:","Download and extract the media zip file locally to the client computer.","In the extracted media zip file, in the Client_Applications folder, double-click P6ProfessionalSetup.exe to launch the installation wizard.","Note Microsoft .NET Framework and Windows Installer are required to run P6 Professional. If they are not installed, follow the prompts to install them and then restart your computer as needed. AllowP6ProfessionalSetup.exe  to run when your computer restarts and follow the prompts to complete installation of the required components.","Select the Typical option.","Click OK.","Click Install.","When P6 Professional is installed, the Next Steps window appears.","Click OK to automatically run Database Configuration immediately after installation. See Running Database Configuration After Installation for details.","Note You do not need to run Database Configuration immediately after installation, however you do need to run it before you can use P6 Professional. You can run Database Configuration manually at any time. See Running Database Configuration Manually for details.","Typical Installation","99675.htm");
Page[10]=new Array("Use the Advanced installation option when the Typical option does not apply. For example if you want to control the installation of specific P6 Professional components, such as Visualizer and the P6 Professional Database Tools. ","To install P6 Professional Standalone with the Advanced option:","Download and extract the media zip file locally to the client computer.","In the extracted media zip file, in the Client_Applications folder, double-click P6ProfessionalSetup.exe to launch the installation wizard.","Note Microsoft .NET Framework and Windows Installer are required to run P6 Professional. If they are not installed, follow the prompts to install them and then restart your computer as needed. AllowP6ProfessionalSetup.exe  to run when your computer restarts and follow the prompts to complete installation of the required components.","Select the Advanced option.","Click OK.","Select the options to be installed.","Click Next.","Click Install.","Click OK to automatically run Database Configuration immediately after installation. See Running Database Configuration After Installation for details.","Note","You do not need to run Database Configuration immediately after installation, however you do need to run it before you can use P6 Professional. You can run Database Configuration manually at any time. See Running Database Configuration Manually for details.","Advanced Installation","92908.htm");
Page[11]=new Array("Under certain circumstances, you might want to restrict the drivers available with a P6 EPPM installation. For example, if you want to prevent users from installing standalone instances of the application. It is possible to exclude unnecessary drivers from the installation whether you install from the installation wizard, deploy ClickOnce, or install from the command line.","Install Wizard: During the advanced installation process, in the Primavera Professional Common Components branch of the installer, you can expand the Drivers section and clear the options for any drivers you do not wish to install.","ClickOnce Deployments:","On Premises: In the P6 Pro Enterprise Deployment Utility, in the Supported Drivers section, clear the options for any drivers you do not wish to install.","Cloud: Submit a Service Request in My Oracle Support","Command Line Installations: Use the /action parameter with the value DeleteDriver and specify the driver type to delete using the /dbtype parameter to update the bootstrap file. For example:","Primavera.Launcher.DBConfig.exe /action=DeleteDriver /dbtype=SQLite","For more information, see: How to Disable Specific Database Drivers (such as SQLite) When Installing P6 Professional (KB584939)","Removing Specific Drivers from Installation","101585.htm");
Page[12]=new Array("If you selected the Run Database Configuration option during installation, the Database Configuration wizard launches automatically after P6 Professional installation is complete. Use Database Configuration to create a database connection for P6 Professional and Job Services.","You can also run Database Configuration manually at any time. See Running Database Configuration Manually for details.","Note","To change database connection settings, the Database Configuration wizard must access the PrmBootStrapV2.xml file. This file is located in &lt;local drive&gt;\\%LOCALAPPDATA%\\Oracle\\Primavera P6\\P6 Professional\\&lt;version number&gt;\\.","Tips","The PrmBootStrapV2.xml file is used regardless of the driver type.","If you create a new database alias for a module, the PrmBootStrapV2.xml file is updated to reflect the change. If multiple modules are installed on one client computer, changing the database alias for one module does not affect the other modules.","If you change the database connection settings for a database alias and multiple modules share that alias to access the database, your changes affect all the modules that share the alias.","Running Database Configuration After Installation","32657.htm");
Page[13]=new Array("Before connecting to a database hosted on Oracle Autonomous Database, you must install client software (for example, Oracle Instant Client), download the wallet containing client credentials, and configure certain files and environment variables.","To prepare for connection to an Autonomous Database:","If you have not already installed an Oracle Database client, see:Oracle Server Database Client Software","Download the wallet from the URL provided by your sales contact.","Extract the wallet file to a suitable location on your local machine, for example, C:\\OracleWallet.","Open the sqlnet.ora file at the extracted wallet location in a text editor.","Find the following line, and replace the text in quotation marks with the location of the extracted wallet file.","(DIRECTORY=&quot;?/network/admin&quot;)","For example, (DIRECTORY=&quot;C:\\OracleWallet&quot;)","Save the file.","Create the TNS_ADMIN environment variable and set it to the location of the credentials file.","On Windows, open the command line and enter:","set TNS_ADMIN=&lt;wallet_location&gt;","Where &lt;wallet_location&gt; is the path to the extracted wallet files.","On Linux, open a terminal and enter:","export TNS_ADMIN=&lt;wallet_location&gt;","Where &lt;wallet_location&gt; is the path to the extracted wallet files.","Prerequisites for Connecting to Autonomous Databases","102513.htm");
Page[14]=new Array("To run Database Configuration after installation with an Oracle database driver, complete the following steps:","On the login screen, click Edit database configuration.","On the Database Configuration wizard, select an alias from the list, or click Add to create a new alias. If you create a new alias, enter a name in the Database Alias field.","In the Driver Type list, select Oracle.","In the Oracle Connection String field:","If you are using Oracle EZCONNECT, enter the connection string in the format, //&lt;server name&gt;:&lt;listen port&gt;/&lt;service name&gt;.","Note The two leading slashes are mandatory for API applications like Update Baseline, XML Export/import, and Schedule Comparison.","If you are using the TNSNAMES file, enter the Oracle Database name.","If your database is encrypted using a database key, in the Keystore section:","If you want to use the default key for the database, select Use default database keystore.","If you do not want to use the default key:","In the Keystore file field, click @&nbsp;Browse.","In the Open dialog box, browse to your key file and click Open.","In the Key Name list select the key to use.","Click Next.","In the Enter public login Information section, enter your public login information that was defined by your administrator.","Click Test&nbsp;to test the database connection. If the connection is successful, click Save. If the connection is not successful, revise the database connection information you provided.","Running Database Configuration After Installation with an Oracle Database Driver","92924.htm");
Page[15]=new Array("To run Database Configuration after installation with a Microsoft SQL Server database driver, complete the following steps:","On the login screen, click Edit database configuration.","On the Database Configuration wizard, select an alias from the list, or click Add to create a new alias. If you create a new alias, enter a name in the Database Alias field.","In the Driver Type list, select Microsoft SQL Server / SQL Express.","In the Connection String field, enter the connection string to your database.","If you are not using a named instance, enter the connection string in the format &lt;server name&gt;,&lt;port&gt;/&lt;database name&gt;.","For example, p6server.nesbidcorp.com,1234/PMDB","If you are using a named instance, enter the connection string in the format &lt;server name&gt;\\&lt;instance name&gt;/&lt;database name&gt;.","For example, p6server.nesbidcorp.com\\primavera/PMDB","Optionally, select the Enable Project Checker option if you want users assigned the Admin Superuser or Project Superuser security profiles to be able to run the Project Checker feature from the Tools menu.","Optionally, select the Enable SQL Logging option if you want to be able to analyze SQL logs.","If your database is encrypted using a database key, in the Keystore section:","If you want to use the default key for the database, select Use default database keystore.","If you do not want to use the default key:","In the Keystore file field, click @&nbsp;Browse.","In the Open dialog box, browse to your key file and click Open.","In the Key Name list select the key to use.","Click Next.","In the Enter public login Information section, enter your public login information that was defined by your administrator.","Click Test&nbsp;to test the database connection. If the connection is successful, click Save. If the connection is not successful, revise the database connection information you provided.","Running Database Configuration After Installation with a Microsoft SQL Server Database Driver","92925.htm");
Page[16]=new Array("To run Database Configuration after installation with a Cloud Connect database driver, complete the following steps:","On the login screen, click Edit database configuration.","On the Database Configuration wizard, select an alias from the list, or click Add to create a new alias. If you create a new alias, enter a name in the Database Alias field.","In the Driver Type list, select P6 Professional Cloud Connect.","Note Select P6 Professional Cloud Connect only if you installed P6 Professional Cloud Connect in P6 EPPM to set up a remote method of access to connect to the EPPM Oracle database and the P6 APIs. P6 Professional Cloud Connect is not supported with SQL Server.","In the Connection String field, enter the connection string to your database in the format &lt;database name&gt;@http://&lt;host name&gt;:&lt;port number&gt;/p6cloudconnect.","For example, p6cloud@/http://p6server.nesbidcorp.com:1234/p6cloudconnect","Note Contact your P6 EPPM administrator to obtain the URL for P6 Professional Cloud Connect.","In the Read Timeout field, enter the number of seconds to wait for a response to a query sent to the Cloud Connect database. Oracle recommends a value of 900.","If P6 Professional Cloud Connect service uses SAML, select the Use SAML SSO option.","If your organization allows the use of a local cache database, to improve performance with the P6 Professional Cloud Connect service, select the Enable Client-side Cache option.","Click Test&nbsp;to test the database connection. If the connection is successful, click Save. If the connection is not successful, revise the database connection information you provided.","Tips","The PrmBootStrapV2.xml file is used regardless of the driver type.","If you create a new database alias for a module, the PrmBootStrapV2.xml file is updated to reflect the change. If multiple modules are installed on one client computer, changing the database alias for one module does not affect the other modules.","If you change the database connection settings for a database alias and multiple modules share that alias to access the database, your changes affect all the modules that share the alias.","Running Database Configuration After Installation with a Cloud Connect Database Driver","92926.htm");
Page[17]=new Array("Note Configuring a database from the command line requires that you pass the password you intend to use in plain text on the command line. Oracle recommends that after configuring the database, you change the password for security. Alternatively, use the graphical user interface for configuring databases, which does not require passing the password in plain text.","You can configure the database connection by opening a command window as an Administrator and running Primavera.Launcher.DBconfig.exe. You can find Primavera.Launcher.DBconfig.exe in the install location of P6 Professional. The default location for Primavera.Launcher.DBconfig.exe is: &lt;local drive&gt;\\Program Files\\Oracle\\Primavera P6\\P6 Professional ","When you run Primavera.Launcher.DBconfig.exe you must also pass certain parameters. You can pass the parameters in any order, however you must include a space between each parameter and there must be no space between a parameter and its value. All parameters are case-sensitive except the boolean values &quot;yes&quot; and &quot;no&quot;.","The following command line parameters are available:","Parameter","Description","/action=","Use this parameter to specify whether to Add a new database, or Edit or Delete an existing database. This parameter can also be used to AddorEdit a database alias, adding the alias if it does not exist, or editing it if it does. You can also use this parameter to DeleteDriver if you wish to exclude the specific driver types listed with the /dbtype parameter from the bootstrap file.","This parameter is optional. If you do not pass this parameter, the default value will be used. The default value is  Add.","/alias=","Use this parameter to set the name of the database alias.","This parameter is mandatory.","/bcurrname=","This parameter is only valid when creating a new standalone database.","Use this parameter to set the name of the base currency for the database.","This parameter is optional, but the value is mandatory. If you do not pass this parameter, the default value will be used. The default value is US Dollar.","/bcurrshortname=","This parameter is only valid when creating a new standalone database.","Use this parameter to set the abbreviation of the base currency for the database.","This parameter is optional, but the value is mandatory. If you do not pass this parameter, the default value will be used. The default value is USD.","/bcurrsymbol=","This parameter is only valid when creating a new standalone database.","Use this parameter to set the symbol of the base currency for the database.","This parameter is optional, but the value is mandatory. If you do not pass this parameter, the default value will be used. The default value is $.","/connectionString=","Use this parameter to provide the connection string for a Cloud, Oracle or SQL Server database, or the location for an SQLite database.","This parameter is mandatory.","/dbtype=","Use this parameter to specify the driver type to use for the database. Valid values are Oracle, SQLServer, CloudServer, and SQLite.","This parameter is mandatory.","/groupid=","Use this parameter to provide the public group ID for the database. This ID must be an integer.","This parameter is optional, but the value is mandatory. If you do not pass this parameter, the default value will be used. The default value is 1.","/hidedbconfig=","Use this parameter to hide access to the database configuration screens from the launcher dialog box. Valid values are Yes and No.","This parameter is optional. The default value is no.","/keypath=","Use this parameter to provide the key name and the path your P6.key file. The value should be expressed as &lt;Key Name&gt;@&lt;Key Store File Path&gt;. Alternatively, use this parameter to switch on the option to use the default database keystore, by passing a null value, i.e. &quot;&quot;.","This parameter is optional if you choose to use the default database keystore.","/loadsampledata=","This parameter is only valid when creating a new standalone database.","Use this parameter to specify whether to load sample data into the new database. Valid values are Yes and No.","This parameter is optional. The default value is yes.","/logfile=","Use this parameter provide the path and name for a log file.","This parameter is optional. If you do not pass this parameter, the default log file will be created as Primavera.Launcher.DBConfig.log in the user's %TEMP% folder.","/password=","This parameter is only valid when creating a new standalone database.","Use this parameter to provide the password for the user of the new standalone instance of P6 Professional.","This parameter is mandatory when creating a new standalone database.","/projectCheckerEnabled=","This parameter is valid for Oracle, Microsoft SQL, and Cloud Connect databases only.","Use this parameter to specify whether the Tools, Project Checker menu item is available to Superusers. Valid values are true and false.","This parameter is optional. The default value is false.","/pusername=","Use this parameter to provide the pubuser name for the database.","This parameter is mandatory, but applies only to Oracle and SQLServer databases.","/puserpwd=","Use this parameter to provide the password for the pubuser in the database.","This parameter is mandatory, but applies only to Oracle and SQLServer databases.","/readtimeout=","Use this parameter to specify the number of seconds to wait for a response from the cloud database.","This parameter is optional, but the value is mandatory. If you do not pass this parameter, the default value will be used. The default value is 900.","/runtest=","Use this parameter to specify whether to test the database connection. Valid values are Yes and No.","This parameter is optional. If you do not pass this parameter, the database will not be tested.","/uselocalrepository=","This parameter is only valid when connecting to a CloudServer database.","Use this parameter to specify whether to enable the local cache database. Valid values are Yes and No.","This parameter is optional. If you do not pass this parameter, the local cache database will be enabled.","/username=","This parameter is only valid when creating a new standalone database.","Use this parameter to provide the username for the user of the new standalone instance of P6 Professional.","This parameter is mandatory when creating a new standalone database.","/usesaml=","This parameter is only valid when connecting to a CloudServer database.","Use this parameter to specify whether to use SAML authentication. Valid values are Yes and No.","This parameter is optional. If you do not pass this parameter, SAML authentication will not be enabled.","Examples","Delete an alias:","Primavera.Launcher.DBconfig.exe /dbtype=&quot;Oracle&quot; /runsilent=&quot;Yes&quot; /action=&quot;Delete&quot; /alias=&quot;MyAlias&quot;","Add a cloud server alias with SAML authentication enabled and the local cache database not enabled:","Primavera.Launcher.DBconfig.exe /runsilent=&quot;Yes&quot; /dbtype=&quot;CloudServer&quot; /alias=&quot;MyCloudAlias&quot; /connectionString=&quot;myclouddatabase@https://mycloudserver/p6procloudconnect&quot; /usesaml=&quot;Yes&quot; /uselocalrepository=&quot;No&quot;","Edit an Oracle alias to change the database key to KeyTwo:","Primavera.Launcher.DBconfig.exe /runsilent=&quot;Yes&quot; /action=&quot;Edit&quot; /dbtype=&quot;Oracle&quot; /alias=&quot;MyOracleAlias&quot; /connectionString=&quot;//myoracleserverdatabase:1234/orcl&quot; /pusername=&quot;databasepublic&quot; /puserpwd=&quot;databasepublicpassword&quot; /keypath=&quot;KeyTwo@C:\\p6.key&quot;","Configuring an Oracle Database Connection From the Command Line","81041.htm");
Page[18]=new Array("Note Configuring a database from the command line requires that you pass the password you intend to use in plain text on the command line. Oracle recommends that after configuring the database, you change the password for security. Alternatively, use the graphical user interface for configuring databases, which does not require passing the password in plain text.","You can configure the database connection by opening a command window as an Administrator and running Primavera.Launcher.DBconfig.exe. You can find Primavera.Launcher.DBconfig.exe in the install location of P6 Professional. The default location for Primavera.Launcher.DBconfig.exe is: &lt;local drive&gt;\\Program Files\\Oracle\\Primavera P6\\P6 Professional ","When you run Primavera.Launcher.DBconfig.exe you must also pass certain parameters. You can pass the parameters in any order, however you must include a space between each parameter and there must be no space between a parameter and its value. All parameters are case-sensitive except the boolean values &quot;yes&quot; and &quot;no&quot;.","The following command line parameters are available:","Parameter","Description","/action=","Use this parameter to specify whether to Add a new database, or Edit or Delete an existing database. This parameter can also be used to AddorEdit a database alias, adding the alias if it does not exist, or editing it if it does. You can also use this parameter to DeleteDriver if you wish to exclude the specific driver types listed with the /dbtype parameter from the bootstrap file.","This parameter is optional. If you do not pass this parameter, the default value will be used. The default value is  Add.","/alias=","Use this parameter to set the name of the database alias.","This parameter is mandatory.","/bcurrname=","This parameter is only valid when creating a new standalone database.","Use this parameter to set the name of the base currency for the database.","This parameter is optional, but the value is mandatory. If you do not pass this parameter, the default value will be used. The default value is US Dollar.","/bcurrshortname=","This parameter is only valid when creating a new standalone database.","Use this parameter to set the abbreviation of the base currency for the database.","This parameter is optional, but the value is mandatory. If you do not pass this parameter, the default value will be used. The default value is USD.","/bcurrsymbol=","This parameter is only valid when creating a new standalone database.","Use this parameter to set the symbol of the base currency for the database.","This parameter is optional, but the value is mandatory. If you do not pass this parameter, the default value will be used. The default value is $.","/connectionString=","Use this parameter to provide the connection string for a Cloud, Oracle or SQL Server database, or the location for an SQLite database.","This parameter is mandatory.","/dbtype=","Use this parameter to specify the driver type to use for the database. Valid values are Oracle, SQLServer, CloudServer, and SQLite.","This parameter is mandatory.","/groupid=","Use this parameter to provide the public group ID for the database. This ID must be an integer.","This parameter is optional, but the value is mandatory. If you do not pass this parameter, the default value will be used. The default value is 1.","/hidedbconfig=","Use this parameter to hide access to the database configuration screens from the launcher dialog box. Valid values are Yes and No.","This parameter is optional. The default value is no.","/keypath=","Use this parameter to provide the key name and the path your P6.key file. The value should be expressed as &lt;Key Name&gt;@&lt;Key Store File Path&gt;. Alternatively, use this parameter to switch on the option to use the default database keystore, by passing a null value, i.e. &quot;&quot;.","This parameter is optional if you choose to use the default database keystore.","/loadsampledata=","This parameter is only valid when creating a new standalone database.","Use this parameter to specify whether to load sample data into the new database. Valid values are Yes and No.","This parameter is optional. The default value is yes.","/logfile=","Use this parameter provide the path and name for a log file.","This parameter is optional. If you do not pass this parameter, the default log file will be created as Primavera.Launcher.DBConfig.log in the user's %TEMP% folder.","/password=","This parameter is only valid when creating a new standalone database.","Use this parameter to provide the password for the user of the new standalone instance of P6 Professional.","This parameter is mandatory when creating a new standalone database.","/projectCheckerEnabled=","This parameter is valid for Oracle, Microsoft SQL, and Cloud Connect databases only.","Use this parameter to specify whether the Tools, Project Checker menu item is available to Superusers. Valid values are true and false.","This parameter is optional. The default value is false.","/pusername=","Use this parameter to provide the pubuser name for the database.","This parameter is mandatory, but applies only to Oracle and SQLServer databases.","/puserpwd=","Use this parameter to provide the password for the pubuser in the database.","This parameter is mandatory, but applies only to Oracle and SQLServer databases.","/readtimeout=","Use this parameter to specify the number of seconds to wait for a response from the cloud database.","This parameter is optional, but the value is mandatory. If you do not pass this parameter, the default value will be used. The default value is 900.","/runtest=","Use this parameter to specify whether to test the database connection. Valid values are Yes and No.","This parameter is optional. If you do not pass this parameter, the database will not be tested.","/uselocalrepository=","This parameter is only valid when connecting to a CloudServer database.","Use this parameter to specify whether to enable the local cache database. Valid values are Yes and No.","This parameter is optional. If you do not pass this parameter, the local cache database will be enabled.","/username=","This parameter is only valid when creating a new standalone database.","Use this parameter to provide the username for the user of the new standalone instance of P6 Professional.","This parameter is mandatory when creating a new standalone database.","/usesaml=","This parameter is only valid when connecting to a CloudServer database.","Use this parameter to specify whether to use SAML authentication. Valid values are Yes and No.","This parameter is optional. If you do not pass this parameter, SAML authentication will not be enabled.","Examples","Delete an alias:","Primavera.Launcher.DBconfig.exe /dbtype=&quot;SQLServer&quot; /runsilent=&quot;Yes&quot; /action=&quot;Delete&quot; /alias=&quot;MyAlias&quot;","Add an alias that does not use the default database key:","Primavera.Launcher.DBconfig.exe /runsilent=&quot;Yes&quot; /dbtype=&quot;SQLServer&quot; /alias=&quot;MySqlServerAlias&quot; /connectionString=&quot;mysqlserver,4321/mysqldatabase&quot;  /pusername=&quot;sqlpubuser&quot; /puserpwd=&quot;sqlpubuserpassword&quot; /groupid=2 /keypath=&quot;mykey@C:\\database key file\\p6.key&quot;","Create a new standalone database with the base currency as Euro:","Primavera.Launcher.DBconfig.exe /runsilent=&quot;Yes&quot; /dbtype=&quot;SQLite&quot; /alias=&quot;MyStandaloneAlias&quot; /connectionString=&quot;C:\\My P6 Database\\MyStandaloneDatabase.db&quot; /username=&quot;myuser&quot; /password=&quot;mypassword&quot;  /bcurrshortname=&quot;EUR&quot; /bcurrname=&quot;Euro&quot; /bcurrsymbol=&quot;&quot; /loadsampledata=&quot;No&quot;","Configuring a Microsoft SQL Server Database Connection From the Command Line","81039.htm");
Page[19]=new Array("P6 Professional requires you to choose an industry type. The industry type determines the terminology and default calculation settings that display in P6 Professional. You choose an industry type from P6, Application Settings, General link.","The following table lists each industry type and its corresponding terminology and default settings. Choose the option that best matches your industry. ","Industry Types","Industry Type","Industry Terminology Examples","Default startup window in P6 Professional","Engineering and Construction","Budgeted Units<br />Budgeted Cost<br />Original Duration","Activities window","Government, Aerospace, and Defense","Planned Units<br />Planned Cost<br />Planned Duration","Projects window","High-Technology, Manufacturing","Planned Units<br />Planned Cost<br />Planned Duration","Projects window","Utilities, Oil, and Gas","Budgeted Units<br />Budgeted Cost<br />Original Duration","Projects window","Note","If you choose the Engineering and Construction or the Utilities, Oil, and Gas industry type, P6 Professional users will see different terminology and defaults when switching to other P6 EPPM applications, such as P6.","If you set the industry type and later change it, the new industry setting is immediately effective for new users. However, the change will not take effect for users who have logged in since it was last set. For information on how to make it effective for existing users, refer to My Oracle Support's Knowledge article How To Change The P6 Industry Type In P6 PPM (Professional), P6 EPPM R8.2 And Later Releases (Doc ID 1386047.1).","Set the Industry Type (P6 EPPM Only)","6747.htm");
Page[20]=new Array("By default, online help for P6 Professional and Visualizer is hosted by Oracle. If you prefer to access Help locally, you can install a local copy of the Help.","Note The hosted versions always contain the most current version of P6 Professional and Visualizer help.","To install a local of the P6 Professional and Visualizer help, complete the following steps:","Download the Downloadable P6 Professional Help and extract it locally.","In the extracted zip file, double-click P6ProHelpInstaller.msi to launch the installation wizard.","Click Next.","Expand Local Help Files.","Do the following to install a local copy of P6 Professional help.","Expand PM Help.","Click the drop-down for the language you use in the P6 Professional user interface and select Will be installed on local hard drive. ","Note P6 Professional Help is available in English, French, German, Japanese, and simplified Chinese.  Selecting any other language installs Help in English. ","Do the following to install a local copy of Visualizer Help.","Expand Visualizer Help.","Click the drop-down for the language you use in the Visualizer user interface and select Will be installed on local hard drive.","Note Visualizer Help is available in English only. Selecting any other language installs Help in English.","Click Next.","Click Install.","Click Finish.","Installing Local Copies of P6 Professional and Visualizer Help","88570.htm");
Page[21]=new Array("To enable users to utilize P6 Integration API functionality within P6 Professional when using a non-default Microsoft SQL Server port, add an ADMINISTRATOR_SETTINGS row to the SETTINGS table for each Microsoft SQL Server database you use with P6 Professional. The table below summarizes the settings.","ADMINISTRATOR_SETTINGS Settings","Setting Description:&nbsp;Points to the JDBC connection URL for a P6 Professional Microsoft SQL Server database.","Namespace","Administrator_Settings","Setting Name","JdbcConnectionURL","Setting Value","&lt;jdbc connection url&gt;","When entering a value for jdbc connection url for Microsoft SQL Server, use the standard connection string. For example:","jdbc:sqlserver://&lt;servername&gt;:&lt;portnumber&gt;;database=&lt;databasename&gt;;","Database Administrator Settings for a Non-Default Microsoft SQL Server Port","79647.htm");
Page[22]=new Array("P6 Professional comes with built-in applications that use P6 Integration API technology. You must configure these plug-ins separately for Single Sign-On or LDAP authentication. These applications read a configuration stored in the database (called INTERNAL_PLUGINS by default) to determine how to authenticate.","Note","This procedure is not applicable for the P6 Professional Cloud Connect driver type.","For information to enable SAML authentication for P6 Professional, refer to the Primavera Oracle Access Manager Configuration Guide.","This procedure uses two utilities:","dbconfig.cmd: To create a new temporary configuration to launch the Internal API Administration utility, admin.cmd.","admin.cmd: To access and modify the INTERNAL_PLUGINS configuration used by the Internal API tools.","To change the authentication type, complete the following steps:","Launch the Internal API Database Configuration utility, dbconfig.cmd. The database configuration utility is located in %P6PROFESSIONAL_HOME%\\P6 Professional\\PRO\\Java\\dbconfig.cmd","Create a new temporary configuration called TEMP_CLIENT_SETUP, to access the administration utility.","Launch the Internal API administration utility admin.cmd. The API administration utility is located in %P6PROFESSIONAL_HOME%\\P6 Professional\\PRO\\Java\\admin.cmd","Log in using the Privileged Database username and password.","Click on the Authentication tab.","Expand the INTERNAL_PLUGINS configuration.","In the Authentication folder, set the Login Mode equal to the authentication mode configured for P6.","In the Database Instance: &lt;your_instance_name&gt; folder, set the Authentication Mode equal to the authentication mode configured for P6.","In the Configurations tab, select the TEMP_CLIENT_SETUP configuration.","Right-click and delete TEMP_CLIENT_SETUP.","Click OK in the Confirmation window.","Click Save, and OK in the Confirmation window.","Exit the administration utility, admin.cmd.","Delete the BREBOOTSTRAP.XML file located in %P6PROFESSIONAL_HOME%\\P6 Professional\\EPPM\\Java\\","Tip","For more information on P6 Integration API, see the P6 EPPM and P6 Professional Integration API Reference Guide.","Configuring P6 Professional Internal Plug-ins for Authentication","7664.htm");
Page[23]=new Array("P6 Visualizer is installed by default when installing P6 Professional. You can also install P6 Visualizer as a standalone.","To install P6 Visualizer only:","Download and extract the media zip file locally to the client computer.","In the extracted media zip file, in the Client_Applications folder, double-click P6ProfessionalSetup.exe to launch the installation wizard.","Note Microsoft .NET Framework and Windows Installer are required to run P6 Professional. If they are not installed, follow the prompts to install them and then restart your computer as needed. AllowP6ProfessionalSetup.exe  to run when your computer restarts and follow the prompts to complete installation of the required components.","Select the Advanced option.","Click OK.","Deselect the Primavera P6 Professional option.","Expand Primavera P6 Professional, P6 Professional Common Components.","Select the Visualizer option.","Click Next.","Click Install.","Click OK to automatically run Database Configuration immediately after installation. See Running Database Configuration After Installation for details.","Note You do not need to run Database Configuration immediately after installation, however you do need to run it before you can use P6 Professional. You can run Database Configuration manually at any time. See Running Database Configuration Manually for details.","Installing P6 Visualizer Only","92937.htm");
Page[24]=new Array("By default, online Help for Visualizer is hosted by Oracle. If you prefer to access Help locally, you can install a local copy of the Help.","Note The hosted version always contains the most current version of Visualizer help.","To install a local of the Visualizer Help, complete the following steps:","Download the Downloadable P6 Professional Help and extract it locally.","In the extracted zip file, double-click P6ProHelpInstaller.msi to launch the installation wizard.","Click Next.","Expand Local Help Files.","Expand Visualizer Help.","Click the drop-down for the language you use in the Visualizer user interface and select Will be installed on local hard drive.","Note Visualizer Help is available in English only. Selecting any other language installs Help in English.","Click Next.","Click Install.","Click Finish.","Installing Local Copies of Visualizer Help","88996.htm");
Page[25]=new Array("This chapter provides instructions for performing unattended setup of P6 Professional. An unattended setup enables administrators to run setup in silent mode and ensures that each user receives the same configuration.","As an administrator, you have several options for installing P6 Professional on client computers using the unattended setup. For example, you can physically run the unattended setup on each computer, write scripts that will run the unattended setup on the client computers you specify, or provide these instructions to users with administrator privileges, who can run the unattended setup on their computer.","Unattended Setup for P6 Professional","49492.htm");
Page[26]=new Array("Unattended setup allows an administrator to install P6 Professional on a client computer without having to answer the configuration prompts of the P6 Professional Setup wizard. All configuration details for the installation are specified in the command line. Unattended installations ensure that the client module is configured identically at setup.","To create an unattended setup, format command lines to silently launch setup.","Unattended setup can be run by an administrator on client computers by entering the appropriate command lines. The unattended setup will silently install P6 Professional according to the parameters you specify in the command line.","The following prerequisite, available in the Client_Applications folder of the P6 Professional physical media or download, must be installed on each client computer before running unattended setup:","Microsoft .NET Framework","An administrator should push these prerequisites to client computers before running unattended setup.","Unattended Setup","55343.htm");
Page[27]=new Array("Complete the following steps to run unattended setup:","Copy the contents of the files in the Client_Applications folder to a local folder.","Oracle recommends creating a new folder, such as Installer. Do not include spaces in the folder name.","Open a command line by choosing Start, Run. Enter cmd and click OK.","On the command line window, go to location of the Installer folder. For example,","cd c:\\Installer","On the command line window, enter the following command:","P6ProfessionalSetup.exe /q","Note This command silently runs a Typical Installation, which installs P6 Professional and Visualizer to the default location (&lt;local drive&gt;\\Program Files\\Oracle\\Primavera P6\\P6 Professional).","Installing Typical Components (P6 Professional and Visualizer)","To install P6 Professional and Visualizer, enter the following command:","P6ProfessionalSetup.exe /package /q msi_p6pro_64_INSTALLDIR=C:\\Temp","Installing Individual Components","Visualizer Only","To install Visualizer, enter the following command:","P6ProfessionalSetup.exe /package /q ADDLOCAL=msi_p6pro_64;Visualizer REMOVE=msi_p6pro_64;PM,msi_p6pro_64;PrmJob,msi_p6pro_64;DBSchema,msi_p6pro_64;Standalone_Migration,msi_p6pro_64;AdminConfig msi_p6pro_64_INSTALLDIR=C:\\Temp ","P6 Professional Only","To install P6 Professional, enter the following command:","P6ProfessionalSetup.exe /package /q ADDLOCAL=msi_p6pro_64;PM REMOVE=msi_p6pro_64;Visualizer,msi_p6pro_64;DBSchema,msi_p6pro_64;AdminConfig,msi_p6pro_64;Standalone_Migration,msi_p6pro_64;PrmJob msi_p6pro_64_INSTALLDIR=C:\\Temp","Job Service only ","To install Job Service, enter the following command:","P6ProfessionalSetup.exe /package /q ADDLOCAL=msi_p6pro_64;PrmJob REMOVE=msi_p6pro_64;Visualizer,msi_p6pro_64;PM,msi_p6pro_64;DBSchema,msi_p6pro_64;Standalone_Migration msi_p6pro_64_INSTALLDIR=C:\\Temp","Admin Configuration only ","To install Admin Configuration, enter the following command:","P6ProfessionalSetup.exe /package /q ADDLOCAL=msi_p6pro_64;AdminConfig REMOVE=msi_p6pro_64;Visualizer,msi_p6pro_64;PM,msi_p6pro_64;PrmJob,msi_p6pro_64;Standalone_Migration msi_p6pro_64_INSTALLDIR=C:\\Temp","Standalone Database Migration Tool only","To install the Standalone Database Migration Tool, enter the following command:","P6ProfessionalSetup.exe /package /q ADDLOCAL=msi_p6pro_64;Standalone_Migration REMOVE=msi_p6pro_64;PM,msi_p6pro_64;Visualizer,msi_p6pro_64;PrmJob,msi_p6pro_64;DBSchema,msi_p6pro_64;AdminConfig msi_p6pro_64_INSTALLDIR=C:\\Temp","Standalone Upgrade Tool only","To install Standalone Upgrade Tool, enter the following command:","P6ProfessionalSetup.exe /package /q ADDLOCAL=msi_p6pro_64;DBSchema REMOVE=msi_p6pro_64;PM,msi_p6pro_64;Visualizer,msi_p6pro_64;PrmJob,msi_p6pro_64;Standalone_Migration,msi_p6pro_64;AdminConfig msi_p6pro_64_INSTALLDIR=C:\\Temp","SDEF Conversion Tools only","To install SDEF conversion tools, enter the following command:","P6ProfessionalSetup.exe /package /q ADDLOCAL=msi_p6pro_64;Feature_P3 REMOVE=msi_p6pro_64;Visualizer,msi_p6pro_64;PM,msi_p6pro_64;PrmJob,msi_p6pro_64;Standalone_Migration msi_p6pro_64_INSTALLDIR=C:\\Temp","Tip","PM and Visualizer components will be installed by default if you do not use the REMOVE parameter.","Component names are case-sensitive.","If you do not specify the INSTALLDIR property, the default location is used. The default location is &lt;local drive&gt;\\Program Files\\Oracle\\Primavera P6\\P6 Professional.","To create a installer log file, add the /log parameter. For example:","P6ProfessionalSetup.exe /package /q ADDLOCAL=msi_p6pro_64;PM REMOVE=msi_p6pro_64;Visualizer msi_p6pro_64_INSTALLDIR=C:\\Temp /log &quot;&lt;LogFileLocation&gt;/install.log&quot; ","where &lt;LogFileLocation&gt; is the folder where you want to save the log file.","You can save your setup command line in a batch file in the install directory and run the batch file.","Enter P6ProfessionalSetup.exe /help to access documentation for command-line parameters.","To keep existing installations and install an additional version alongside the existing version, use the command line argument RELATED_BUNDLE_ACTION=PRESERVE. If the RELATED_BUNDLE_ACTION command line argument is missing or set to a different value from PRESERVE, existing installations will be removed.","Running Unattended Setup","50109.htm");
Page[28]=new Array("Create the database connection on one administrator computer. After configuring the database connection, push the PrmBootStrapV2.xml file from the administrator computer (host computer) with database configuration details to each target client computer.","Install P6 Professional on one administrator computer (host computer).","Create the database connection on the host computer.","See Running Database Configuration Manually for details.","The default location of PrmBootStrapV2.xml for the host computer is:"," \\%APPDATA%\\Oracle\\Primavera P6\\P6 Professional\\&lt;major version&gt;.&lt;minor version&gt;.&lt;build version&gt;","The default location of PrmBootStrapV2.xml for the target computer is:","\\&lt;application install location&gt;\\Data\\","Creating Database Connections for Unattended Setup","50389.htm");
Page[29]=new Array("Use Database Configuration to change connection settings for the client module if your database server configuration changes. For example, if the database is moved to a new server, run Database Configuration to configure the connection to the new server.","Note","To change database connection settings, the Database Configuration wizard must access the PrmBootStrapV2.xml file. This file is located in &lt;local drive&gt;\\%LOCALAPPDATA%\\Oracle\\Primavera P6\\P6 Professional\\&lt;version number&gt;\\.","Tips","The PrmBootStrapV2.xml file is used regardless of the driver type.","If you create a new database alias for a module, the PrmBootStrapV2.xml file is updated to reflect the change. If multiple modules are installed on one client computer, changing the database alias for one module does not affect the other modules.","If you change the database connection settings for a database alias and multiple modules share that alias to access the database, your changes affect all the modules that share the alias.","Running Database Configuration Manually","32751.htm");
Page[30]=new Array("To run Database Configuration manually with an Oracle database driver, complete the following steps:","If Database Configuration does not launch automatically, click Start, All Programs, Oracle - Primavera P6, P6 Professional &lt;release level&gt;, P6 Professional &lt;release level&gt; Help and Tools, Database Configuration.","On the Database Configuration wizard, click Add to create a new alias.","In the Database alias field, enter a name for the new alias. ","In the Driver type field, select Oracle.","In the Oracle Connection String field:","If you are using Oracle EZCONNECT, enter the connection string in the format, //&lt;server name&gt;:&lt;listen port&gt;/&lt;service name&gt;.","Note The two leading slashes are mandatory for API applications like Update Baseline, XML Export/import, and Schedule Comparison.","If you are using the TNSNAMES file, enter the Oracle Database name.","If your database is encrypted using a database key, in the Keystore section:","If you want to use the default key for the database, select Use default database keystore.","If you do not want to use the default key:","In the Keystore file field, click @&nbsp;Browse.","In the Open dialog box, browse to your key file and click Open.","In the Key Name list select the key to use.","Click Next.","In the Enter public login Information section, enter your public login information that was defined by your administrator.","Click Test&nbsp;to test the database connection. If the connection is successful, click Save. If the connection is not successful, revise the database connection information you provided.","Running Database Configuration Manually with an Oracle Database Driver","92927.htm");
Page[31]=new Array("To run Database Configuration manually with a Microsoft SQL Server database driver, complete the following steps:","If Database Configuration does not launch automatically, click Start, All Programs, Oracle - Primavera P6, P6 Professional &lt;release level&gt;, P6 Professional &lt;release level&gt; Help and Tools, Database Configuration.","On the Database Configuration wizard, click Add to create a new alias.","In the Database alias field, enter a name for the new alias. ","In the Driver type field, select Microsoft SQL Server / SQL Express.","In the Connection String field, enter the connection string to your database.","If you are not using a named instance, enter the connection string in the format &lt;server name&gt;,&lt;port&gt;/&lt;database name&gt;.","For example, p6server.nesbidcorp.com,1234/PMDB","If you are using a named instance, enter the connection string in the format &lt;server name&gt;\\&lt;instance name&gt;/&lt;database name&gt;.","For example, p6server.nesbidcorp.com\\primavera/PMDB","Optionally, select the Enable Project Checker option if you want users assigned the Admin Superuser or Project Superuser security profiles to be able to run the Project Checker feature from the Tools menu.","Optionally, select the Enable SQL Logging option if you want to be able to analyze SQL logs.","If your database is encrypted using a database key, in the Keystore section:","If you want to use the default key for the database, select Use default database keystore.","If you do not want to use the default key:","In the Keystore file field, click @&nbsp;Browse.","In the Open dialog box, browse to your key file and click Open.","In the Key Name list select the key to use.","Click Next.","In the Enter public login Information section, enter your public login information that was defined by your administrator.","Click Test&nbsp;to test the database connection. If the connection is successful, click Save. If the connection is not successful, revise the database connection information you provided.","Running Database Configuration Manually with a Microsoft SQL Server Database Driver","92928.htm");
Page[32]=new Array("To run Database Configuration manually with a Cloud Connect database driver, complete the following steps:","If Database Configuration does not launch automatically, click Start, All Programs, Oracle - Primavera P6, P6 Professional &lt;release level&gt;, P6 Professional &lt;release level&gt; Help and Tools, Database Configuration.","On the Database Configuration wizard, click Add to create a new alias.","In the Database alias field, enter a name for the new alias. ","In the Driver type field, select P6 Professional Cloud Connect.","Note Select P6 Professional Cloud Connect only if you installed P6 Professional Cloud Connect in P6 EPPM to set up a remote method of access to connect to the EPPM Oracle database and the P6 APIs. P6 Professional Cloud Connect is not supported with SQL Server.","In the Connection String field, enter the connection string to your database in the format &lt;database name&gt;@http://&lt;host name&gt;:&lt;port number&gt;/p6cloudconnect.","For example, p6cloud@/http://p6server.nesbidcorp.com:1234/p6cloudconnect","Note Contact your P6 EPPM administrator to obtain the URL for P6 Professional Cloud Connect.","In the Read Timeout field, enter the number of seconds to wait for a response to a query sent to the Cloud Connect database. Oracle recommends a value of 900.","If P6 Professional Cloud Connect service uses SAML, select the Use SAML SSO option.","If your organization allows the use of a local cache database, to improve performance with the P6 Professional Cloud Connect service, select the Enable Client-side Cache option.","In the Enter public login Information section, enter your public login information that was defined by your administrator.","Click Test&nbsp;to test the database connection. If the connection is successful, click Save. If the connection is not successful, revise the database connection information you provided.","Running Database Configuration Manually with a Cloud Connect Database Driver","92929.htm");
Page[33]=new Array("ClickOnce enables your users to install and run P6 Professional by clicking a link in a web page.  You can configure ClickOnce in advance, so your users do not need to perform any configuration in order to install and run P6 Professional. ","This section describes how you to configure and deploy ClickOnce with Oracle WebLogic. You have two choices to configure ClickOnce:","Configure ClickOnce on a staging computer and then deploy it to the WebLogic server.","Configure ClickOnce directly on the WebLogic server. ","Note","The instructions in this section assume you will use a staging computer.","The staging computer must be running Windows. If the WebLogic server is installed with UNIX or Linux, you must use a staging computer.","ClickOnce is only supported for theP6 Pro Cloud Connect driver type. If your users need to connect using a different driver type, they can still download and install from the ClickOnce page, however they will need to configure the connection separately using Database Configuration. See the P6 Professional Installation and Configuration Guide (Oracle Database) or P6 Professional Installation and Configuration Guide (Microsoft SQL Server Database) for details.","If you have installed an earlier version P6 Professional or Visualizer from any media pack version, you must uninstall that version before installing with ClickOnce. If you have installed an earlier version of P6 Professional or Visualizer using ClickOnce, you must uninstall that version before installing from the media pack.","System administrators should update .NET and other prerequisites on all client computers before upgrading or installing P6 Professional.","Using ClickOnce","89121.htm");
Page[34]=new Array("The staging computer must meet the following prerequisites in order for you to be able to configure ClickOnce:","It must be running a version of Windows Server that we support. See: P6 EPPM Tested Configurations.","The latest Java Development Kit (JDK) must be installed. See http://www.oracle.com/technetwork/indexes/downloads/index.html#java for details.","Windows SDK is required for signing ClickOnce files. See: https://developer.microsoft.com/en-us/windows/downloads/windows-sdk/ and https://developer.microsoft.com/en-us/windows/downloads/sdk-archive/","The location of the Windows SDK for .NET Framework must exist in the Path environment variable.","In addition, depending on the code signing method you will use, you must obtain either:","a digital certificate from a certificate authority (for example, VeriSign) for signing the ClickOnce files. The certificate must be in Personal Information Exchange (PFX) format and must include the private key created on your staging computer.","a hardware token from a suitable supplier (for example, YubiKey) for signing ClickOnce files. The hardware token must be connected to the staging computer.","System administrators should also update the following prerequisites on all client computers before upgrading or installing P6 Professional:","Windows Operating System",".NET Framework","If you do not have the required version of .NET, the ClickOnce installation will fail and you should contact your system administrator.","Tip","You must ensure all client computers have .NET 4.6.2 installed. If .NET 4.6.2 is not installed on your client machines, the update will fail. System administrators should update .NET and other prerequisites on all client computers before upgrading or installing P6 Professional.","Prerequisites for Signing and Deploying P6 Professional Using ClickOnce","89128.htm");
Page[35]=new Array("Organization Validation code signing (also known as OV or Standard code signing) requires the use of a PFX certificate file. See Prerequisites for Signing and Deploying P6 Professional Using ClickOnce","To configure ClickOnce using standard code signing, complete the following steps:","On the staging computer, create the following folders:","c:\\source","c:\\destination","Download and extract the media zip file locally on the staging computer.","In the extracted media file, in the Client_Applications folder, copy the ClickOnce_EPPM.zip file to the c:\\source folder on the staging computer.","In the extracted media file, in the Client_Applications folder, double-click Primavera.Deployment.EPPM.exe.","On the P6 Pro Enterprise Deployment Utility screen, do the following:","In the ClickOnce Server Name field, enter the fully qualified domain name for the WebLogic server to be used for deployment. For example:","myservername.domainname.com    ","Note Do not enter http:// or https://.","In the ClickOnce Server Port field, enter the WebLogic port where the ClickOnce managed server is running.","Note If you are using port redirection, do not change the default value, which is 0.","Select or clear the HTTPS option, as needed. Oracle recommends that you select this option.","In the Published Version field, do not enter anything. The value auto-populates based on the Source Location value.","Select the Mandatory Update option to automatically replace any previously installed version of P6 Professional. Otherwise, users will be prompted to replace any previously installed versions. ","Caution If you select Mandatory Update P6 Professional prerequisites are not automatically updated. For more information on P6 Professional prerequisites see Prerequisites for Signing and Deploying P6 Professional Using ClickOnce.","In the Password field, enter the password for the PFX file.","In the Certificate File Path field, enter the location of the PFX file.","In the SignTool.exe File Path field, enter the location of SignTool.exe. For example, C:\\Program Files (x86)\\Windows Kits\\10\\bin\\10.0.20348.0\\x86.","In the Additional SignTool.exe arguments field, valid values are /fd SHA1 and /fd SHA256.","Click Add Alias to create a new row in the grid.","Note You can create multiple aliases in the grid. The first alias you create will become the default. To change which alias is the default, mark the Default option for a different alias.","In the new grid row:","In the Alias Name column, enter the alias is used by P6 Professional to connect to Cloud Connect Server.","In the Connection String column, enter the connection string to the database in one the following formats:","&lt;database&gt;@&lt;hostname&gt;:&lt;port&gt;/p6procloudconnect","&lt;database&gt;@http://&lt;hostname&gt;:&lt;port&gt;/p6procloudconnect","&lt;database&gt;@https://&lt;hostname&gt;:&lt;port&gt;/p6procloudconnect","In the SAML Web SSO column, if the P6 Professional Cloud Connect service associated with the alias uses SAML, mark the option.","In the Client-Side Cache column, to improve performance with the P6 Professional Cloud Connect service mark the option.","Optionally, in the Read Timeout field, enter the number of seconds for the cloud read timeout. Oracle recommends you use the default value, which is 900.","Optionally, clear the options for any driver types you do not want users to be able to use to create new aliases.","In the Source Location field, do not enter anything. This is the location of the clickonceEPPM.zip file, which you copied to the c:\\source folder earlier.","In the MAGE Path file, enter the location of mage.exe. For example, C:\\Program Files (x86)\\Windows Kits\\10\\bin\\10.0.20348.0\\x86.","In the Destination Location field, do not enter anything.","In the JDK Path field, enter the path for the Java Development Kit (JDK). The default is the JAVA_HOME value.","If you want to save your ClickOnce configuration to a file, click Export.","Click Deploy.","The p6professionalcloud_customer.war file is created in the specified location and is ready to be deployed. See Deploying ClickOnce for details.","Configuring Clickonce using Organization Validation (Standard) Code Signing","89122.htm");
Page[36]=new Array("Extended Validation code signing (also known as EV code signing) requires a hardware token. The staging computer must be a physical windows machine, to which you attach the hardware token via a suitable USB port.","To configure ClickOnce using extended validation code signing, complete the following steps:","On the staging computer, create the following folders:","c:\\source","c:\\destination","Download and extract the media zip file locally on the staging computer.","In the extracted media file, in the Client_Applications folder, copy the ClickOnce_EPPM.zip file to the c:\\source folder on the staging computer.","In the extracted media file, in the Client_Applications folder, double-click Primavera.Deployment.EPPM.exe.","On the P6 Pro Enterprise Deployment Utility screen, do the following:","In the ClickOnce Server Name field, enter the fully qualified domain name for the WebLogic server to be used for deployment. For example:","myservername.domainname.com    ","Note Do not enter http:// or https://.","In the ClickOnce Server Port field, enter the WebLogic port where the ClickOnce managed server is running.","Note If you are using port redirection, do not change the default value, which is 0.","Select or clear the HTTPS option, as needed. Oracle recommends that you select this option.","In the Published Version field, do not enter anything. The value auto-populates based on the Source Location value.","Select the Mandatory Update option to automatically replace any previously installed version of P6 Professional. Otherwise, users will be prompted to replace any previously installed versions. ","Caution If you select Mandatory Update P6 Professional prerequisites are not automatically updated. For more information on P6 Professional prerequisites see Prerequisites for Signing and Deploying P6 Professional Using ClickOnce.","In the SignTool.exe File Path field, enter the location of SignTool.exe. For example, C:\\Program Files (x86)\\Windows Kits\\10\\bin\\10.0.20348.0\\x86.","In the Additional SignTool.exe arguments field, valid values are /fd SHA1 and /fd SHA256.","Click Add Alias to create a new row in the grid.","Note You can create multiple aliases in the grid. The first alias you create will become the default. To change which alias is the default, mark the Default option for a different alias.","In the new grid row:","In the Alias Name column, enter the alias is used by P6 Professional to connect to Cloud Connect Server.","In the Connection String column, enter the connection string to the database in one the following formats:","&lt;database&gt;@&lt;hostname&gt;:&lt;port&gt;/p6procloudconnect","&lt;database&gt;@http://&lt;hostname&gt;:&lt;port&gt;/p6procloudconnect","&lt;database&gt;@https://&lt;hostname&gt;:&lt;port&gt;/p6procloudconnect","In the SAML Web SSO column, if the P6 Professional Cloud Connect service associated with the alias uses SAML, mark the option.","In the Client-Side Cache column, to improve performance with the P6 Professional Cloud Connect service mark the option.","Optionally, in the Read Timeout field, enter the number of seconds for the cloud read timeout. Oracle recommends you use the default value, which is 900.","Optionally, clear the options for any driver types you do not want users to be able to use to create new aliases.","In the Source Location field, do not enter anything. This is the location of the clickonceEPPM.zip file, which you copied to the c:\\source folder earlier.","In the MAGE Path file, enter the location of mage.exe. For example, C:\\Program Files (x86)\\Windows Kits\\10\\bin\\10.0.20348.0\\x86.","In the Destination Location field, do not enter anything.","Select the Enable EV signing option.","Click Browse, navigate to the USB port to which your hardware token is attached, then select the certificate.","If requested, enter the PIN provided when you purchased the hardware token.","If you want to save your ClickOnce configuration to a file, click Export.","Click Deploy.","The p6professionalcloud_customer.war file is created in the specified location and is ready to be deployed. See Deploying ClickOnce for details.","Configuring Clickonce using Extended Validation Code Signing","102760.htm");
Page[37]=new Array("To deploy ClickOnce:","Note Oracle recommends that before completing these steps, you delete any instance of an existing folder called combined or a file called p6professionalcloud_customer.war in the destination folder.","On the staging computer where the p6professionalcloud_customer.war file was created, open the command prompt and enter the following commands:","set JAVA_HOME=&lt;jdkpath&gt;","Where &lt;jdkpath&gt; is the path to your JDK home with no spaces. If your path does include spaces, you can determine the windows short path by entering dir /x from the command prompt.","cd /d &lt;destination_path&gt;\\Destination","Where &lt;destination_path&gt;is the path to the destination folder you created when you configured ClickOnce.","mkdir combined","cd combined","%JAVA_HOME%\\bin\\jar -xvf ../p6professionalcloud_Template.war","%JAVA_HOME%\\bin\\jar -xvf ../p6professionalcloud_customer.war","%JAVA_HOME%\\bin\\jar -cvf ../p6professionalcloud.war *","rmdir /s /q combined","del /s /q p6professionalcloud_customer.war","Copy the p6professionalcloud.war file to your WebLogic Server.","Deploy p6professionalcloud.war in WebLogic. See the WebLogic documentation for details.","Deploying ClickOnce","89129.htm");
Page[38]=new Array("Note","System administrators should update .NET and other prerequisites on all client computers before upgrading or installing P6 Professional.","To install P6 Professional using ClickOnce:","On a client computer, open a browser and navigate to the ClickOnce URL.","Click the Install link.","Note","The ClickOnce URL follows the format https://&lt;deployment machine&gt;:&lt;port&gt;/p6professionalcloud/en/publishP6.html.","ClickOnce is only supported for theP6 Pro Cloud Connect driver type. If your users need to connect using a different driver type, they can still download and install from the ClickOnce page, however they will need to configure the connection separately using Database Configuration. See the P6 Professional Installation and Configuration Guide (Oracle Database) or P6 Professional Installation and Configuration Guide (Microsoft SQL Server Database) for details.","Installing P6 Professional Using ClickOnce","89131.htm");
Page[39]=new Array("Caution You must ensure all client computers have .NET 4.6.2 installed. If .NET 4.6.2 is not installed on your client machines, the update will fail. System administrators should update .NET and other prerequisites on all client computers before upgrading or installing P6 Professional.","To upgrade P6 Professional with ClickOnce:","If the currently installed version of P6 Professional is 32-bit, uninstall the existing version before upgrading to version 18.8 or later.","On a client computer, open a browser and navigate to the ClickOnce URL.","Click the Install link.","Note","You might not receive a notification dialog when an update is available. Check with your system administrator to ensure you have the latest version of P6 Professional.","Upgrades can be found on the ClickOnce landing page.","The ClickOnce URL follows the format https://&lt;deployment machine&gt;:&lt;port&gt;/p6professionalcloud/en/publishP6.html.","When you initiate the installer, previous versions of P6 Professional will be removed.","If the ClickOnce Maintenance dialog stays, you must choose the Remove option.","Upgrading P6 Professional Using ClickOnce","90338.htm");
Page[40]=new Array("It is not always possible to have a steady connection to the internet. Offline mode uses the Primavera Cache Service to allow users to continue working in P6 Professional while their internet connection is unavailable. When internet connectivity is restored, users can reconnect to the cloud database and synchronize the data in the local cache database with the Cloud Connect database.","Before users can work in offline mode, you must complete the following steps:","Enabling Offline Mode","Assigning the Global Security Privilege","Configuring the Client-side Cache","Considerations For Working In Offline Mode","There are several factors which can influence the decision about whether to allow users to work offline.","How many people are working on a schedule at any one time? If there is typically only one planner or scheduler making updates to a project or set of projects, or if multiple planners or schedulers are working on a project but they are working with unrelated data working offline might be a good fit for your organization. However if multiple planners or schedulers regularly update the same data in the same projects, working offline will not be good fit.","Offline Mode","99211.htm");
Page[41]=new Array("An application setting in P6 controls the availability of the global security privilege which allows users to work in offline mode.","To enable offline mode:","Login to P6 as a user with the Edit Application Settings global security privilege.","Click Administration.","On the Administration navigation bar, click Application Settings.","On the Application Settings page, click General.","In the General pane, select Enable offline mode.","Click Save.","Note If you clear the Enable offline mode option, users will no longer be able to go offline. Users who are already working offline at the time that the option is cleared will be able to continue working offline until the next time they connect to the cloud connect database, after which they will not be able to go offline again.","Enabling Offline Mode","99212.htm");
Page[42]=new Array("To allow users to work in offline mode, you must assign them to a global security profile which includes the correct privileges.","To assign the global security privilege to a profile:","Login to P6 as a user with the Add/Edit/Delete Users global security privilege.","Click Administration.","On the Administration navigation bar, click User Administration.","On the User Administration page, click Global Security Profiles.","On the Global Security Profiles page:","Select a profile to which you want to add the offline mode privilege.","Click the Tools detail window.","Enable the Enable Work Offline option.","Note To see this privilege, select the Enable offline mode option in the General pane of Application Settings.","Click Save.","Assigning the Global Security Privilege","99213.htm");
Page[43]=new Array("Offline mode is available with the P6 Pro Cloud Connect database alias and requires the Primavera Cache Service to be configured in the database alias.","To configure the database alias to use Client-side Cache:","Start P6 Professional.","In the login dialog box:","Click Edit database configuration.","In the Database Configuration dialog box:","Select a database using the P6 Pro Cloud Connect driver type.","Select Enable local cache.","Configuring the Local Cache","99214.htm");
Page[44]=new Array("P6 Professional fully supports Microsoft Windows Remote Desktop Services along with Citrix XenApp (Citrix), check the tested configurations for supported versions.","Running P6 Professional under Windows Remote Desktop Services published through Citrix is recommended in the following cases:","P6 Professional users running through a WAN connection are having performance issues whereas users on the local LAN are achieving acceptable performance.","The connect speed between the desktop client and database server is a T1/T3 WAN link or slower with 50 milliseconds or more of latency.","You have sensitive project data that you want to secure through an SSL connection (Citrix supports SSL/High RCA encryption technologies).","You do not want to upgrade the hardware of all your desktop clients or maintain remote client configurations, but would rather centralize your users for easier administration.","Windows Remote Desktop Session Host with Citrix provides users with the ability to run P6 Professional over a slower asynchronous dial-up or WAN connection from Windows, UNIX, and Macintosh terminals and get better performance since only screen refreshes and keystrokes are sent across the communication line. Windows Remote Desktop Session Host without Citrix can also be used to run P6 Professional, but other considerations need to be taken into account.","The Citrix add-on enhances Windows Remote Desktop Session Host by adding the ICA protocol, which supports IPX/SPX, NetBIOS, and TCP/IP protocols. Using Citrix adds support for UNIX, Linux, and Macintosh, as well as Microsoft clients. Also, Citrix automatically configures clients as they connect and has the ability to auto-configure local printers.","Windows Remote Desktop Services and Citrix","47540.htm");
Page[45]=new Array("You need a knowledge of Windows Remote Desktop Services and Citrix","You need the Local Administrator account for software installation and Citrix publishing","It is recommended that a shared drive be used on the LAN local to the Windows Remote Desktop Session Host for project imports and exports due to WAN performance considerations.","It is recommended that the users' home directories reside on the same LAN as the Windows Remote Desktop Session Host/Citrix server due to potential performance issues across various functions in P6 Professional","P6 Professional User requirements","To run on Windows Remote Desktop Services published through Citrix:","Each P6 Professional user must use a unique Windows account","Each P6 Professional user must use a unique account in P6 Professional.","PM.ini Logic","At launch, P6 Professional checks for the PM.ini file in the following order in the following locations:","In the same directory as the executable file.","In the user's roaming app data folder.","In the user's local app data folder.","If the PM.ini file is not in the base install location of &lt;P6 Professional Install Directory&gt;\\&lt;version&gt;, the PM.ini will be copied from the &lt;P6 Professional Install Directory&gt;\\&lt;version&gt;\\Data folder to the roaming directory that is automatically created for each user at \\Users\\&lt;username&gt;\\AppData\\Roaming\\Oracle\\Primavera P6\\P6 Professional\\&lt;version&gt;. ","Pre-Installation Considerations","47541.htm");
Page[46]=new Array("To install P6 Professional, the Administrator or an account in the local Administrators group must log in to the Remote Desktop Server.","Prerequisites","If P6 Professional has previously been installed, follow this procedure to remove the installation from every user's machine:","Uninstall all versions of P6 Professional from the machine.","Delete any remaining files or folders in the install directory.","Delete the Primavera P6 folder at %appdata%\\oracle.","Install Oracle or SQL Server Client drivers as appropriate on the Windows Remote Desktop Session Hosts as described in their respective docs.","During the process of setting up Remote Desktop Services:","Click Start, and then click Run.","In the Open box, type cmd, and then click OK.","At the command prompt, type change user /query","This enables application install mode.","At the command prompt, type change user /install","This ensures the user session is ready to install applications.","At the command prompt, type change user /execute","This ensures the user session is ready to execute applications.","With Oracle database, confirm the Create Global Objects Windows Security Policy is set up on the Windows Remote Desktop Session Hosts and add the domain Users or Groups of the end-users who will be accessing the published application.  If the local security policy is not set up, complete the following steps to add the policy:","Click Start, Programs, Administrative Tools, and then click Local Security Policy.","Expand Local Policies, and then click User Rights Assignments.","In the right pane, double-click Create Global Objects.","In the Local Security Policy Setting dialog box, click Add.","In the Select Users or Group dialog box, select the user group that these end users are a part of, click Add, and then click OK.","Click OK.","With Oracle database, the Oracle client software also requires that you give the Authenticated User Group, Read and Execute privilege to the Oracle Home Directory and ALL its subdirectories and files on the Windows Remote Desktop Session Hosts.","Installation Steps","On the remote desktop server, open the control panel and click Application on Remote Desktop Tool.","From that tool, run the P6 Professional setup.","Note Remote Desktop Services automatically runs setup in Remote Desktop Services install mode. ","Install P6 Professional.","When setup completes, click the Finish dialog to the Remote Desktop Services install mode.","After configuring database connections as described in the installation documentation, back up the PrmBootStrapV2.xml file the &lt;P6 Professional Install Directory&gt;\\Data folder.","Deploy PrmBootStrapV2.xml from the %APPDATA% folder to the &lt;P6 Professional Install Directory&gt;\\Data folder.","Note This will ensure that users who launch P6 for the first time will inherit the PrmBootStrapV2.xml file with existing database configurations","If you maintain multiple databases for your remote desktop users, increment the DeploymentVersion in the default version of PrmBootstrap.xml. ","For example, increment the deployment version from 0 to 1:","&lt;BootStrap MajorVersion=&quot;8&quot; MinorVersion=&quot;2&quot; PatchVersion=&quot;0&quot; DeploymentVersion=&quot;1&quot;","Note","This will force a new deployment of the PrmBootstrapV2.xml file to users who have an existing PrmBootstrapV2.xml. If the deployment version is not incremented and a user already has a PrmBootstrap.xml file in their local profile, P6 Professional will use that user's existing file rather than a newly deployed copy.","Never change MajorVersion or MinorVersion.","The default location for PRMBootStrapV2.xml is &lt;P6 Professional Install Directory&gt;\\Data.","Test the application by logging up to two users into the Windows Remote Desktop Session Host. If errors occur, contact Oracle Support for assistance.","Note The Citrix Administrator Application can also publish the application through Citrix.","Installing P6 Professional on Remote Desktop Services","47539.htm");
Page[47]=new Array("You can use Oracle Secure Global Desktop to publish P6 EPPM and P6 Professional to remote users.","See the Tested Configurations document for supported versions of Oracle Secure Global Desktop.","For details on publishing Windows desktops, see the Oracle Secure Global Desktop Administration Guide. You will find the Secure Global Desktop documentation library here: http://www.oracle.com/technetwork/documentation/sgd-193668.html.","Using Oracle Secure Global Desktop","62800.htm");
Page[48]=new Array("This topic describes the P6 Application Settings that are relevant to P6 Professional with P6 EPPM. All of these settings are on the General tab of the Applications Settings page in P6. See the P6 Help in the P6 EPPM User and Integration Documentation for details.","Industry Selection section","Industry to use for terminology and default calculation settings in the P6 Professional module list","Use the arrow to choose the type of industry in which you use this application. The industry you choose causes P6 Professional to use terminology and default settings for calculations that most closely align with the selected industry.","Engineering and Construction: Determines the use of terminology and default settings for calculations aligned with the engineering and construction industries.","Government, Aerospace, and Defense: Determines the use of terminology and default settings for calculations aligned with government and with aerospace and defense industries.","High Tech, Manufacturing, and Others: Determines the use of terminology and default settings for calculations aligned with high-technology, manufacturing, and other industries.","Utilities, Oil, and Gas: Determines the use of terminology and default settings for calculations aligned with the utility, oil, and gas industries.","Note Until an industry is selected P6 Professional users will see a message each time they log in which explains that this option has not been set.","Online Help section","Online Help URL field","The help URL that will allow users to access help for P6 Professional. If this field is left blank, the Online Help option will not be available and Local help will always launch when the F1 key or Help shortcut are used.","Leave the default URL to launch the version of the help hosted by Oracle when Online Help is selected from the Help menu.<br /><br />Remove the URL to disable the Online Help option from the Help menu for all users. Users will only be able to access the local version of the help.<br /><br />Specify a new URL location to launch when Online Help is selected from the Help menu.","Using the hosted version ensures that you always have the most current help content. ","Always launch the Online Help for the F1 shortcut key and context sensitive help option","Switch on this option if your users have access to the internet and need to be able to see the most up to date version of Help. If this option is switched off, accessing Help via the F1 key and Help shortcuts will always show local help. This option is off by default.","Document Management section","P6 URL field","This URL enables P6 Professional users to download exported Primavera XML files.","P6 Professional Application section","Run in Secure Global Desktop environment option","Switch on this option if you want P6 Professional users to run the application in Secure Global Desktop.","Note If this option is selected, P6 Professional users will not be able to see database details and system information on the System tab of the About page.","P6 Application Settings for P6 Professional","91633.htm");
var PageCount=49;


/*
Date: 12/11/2025 7:36 PM
Source: EPPM_25_dev
BookID: 54651
PubProduct: PRIMAVERA_EPPM
BookTitle: Installation and Configuration Guide (P6 EPPM) for On-Premises
Version: Version 25
Lang:	en
*/
	var PageLength=Page.length;
	var Result = "";
	var ResultTemp = "";
	var ResultFound = "";
	var ResultTitleOnly = [];
	var ResultTitleAndContent = [];
	var ResultInContent = [];
	var ResultInContentTemp = [];

	var ResultCombinedTemp = [];
	var ResultCombined = [];

	var arrayIndex = 0;
	var NrRes = 0;
	var j = 0;
	var i = 0;
	var k = 0;
	var d = 0;
	var maxItems = 1000;
	var heading = 0;
	var WordPos = -1;
	var WordPosHeading = -1;
	var WordPosContentText = -1;
	var FoundWord = "";
	var FoundWordHead = "";
	var SearchInHeadingOnly = 0;
	var isChecked;
	var size = 10;
	var resGroupCounter = 0;
	var shown = "shown";
	var checkBoxInHeading;
	var searchFlag = 0;
	var DivResult;
	var SearchWord;

if (SearchText && SearchText.length >= 1) {
		SearchWord = SearchText.replace(/\+/g, " ").replace(/&/g, "&amp;").replace(/</g, "&lt;").replace(/>/g, "&gt;").replace(/"/g, "&quot;");
		searchFlag = 1;
	} else {
		SearchWord = "";
		searchFlag = 0;
	}
	

	if (searchFlag === 1) {
		Result = "";

		// checkBoxInHeading = document.getElementById("inHeading");
		if (inHeading) {

			isChecked = true;
		} else {

			isChecked = false;
		}

		if (SearchWord && SearchWord.length >= 1) {
			if (isChecked) {
				SearchInHeadingOnly = 1;
			} else {
				SearchInHeadingOnly = 0;
			}
			SearchWord = SearchWord.toLowerCase();
			window.status = "Searching, please wait...";
			for (j = 0; j < PageLength; j++) {
				k = Page[j].length - 1;
				for (i = 0; i < k; i++) {

					heading = k - 1;

					if (SearchInHeadingOnly === 1) {
						WordPosHeading = Page[j][heading].toLowerCase().indexOf(SearchWord);
						if (WordPosHeading > -1) {
							FoundWordHead = Page[j][heading].substr(WordPosHeading, SearchWord.length);

							NrRes++;
							ResultTemp = "<li>";
							ResultTemp += "<span>";
							ResultTemp += "<a href='" + Page[j][k] + "'>" + Page[j][heading].replace(FoundWordHead, FoundWordHead.bold()) + "</a><br/>\n";

							ResultTemp += "</span>";
							ResultTemp += "</li>";

							ResultTitleOnly[arrayIndex] = ResultTemp;
							arrayIndex++;

							ResultTemp = "";
							WordPosHeading = -1;
							WordPosContentText = -1;
							break;
						}
					} else if (SearchInHeadingOnly === 0) {
						WordPos = Page[j][i].toLowerCase().indexOf(SearchWord);
						WordPosHeading = Page[j][heading].toLowerCase().indexOf(SearchWord);
						if (WordPos > -1) {
							FoundWordHead = Page[j][heading].substr(WordPosHeading, SearchWord.length);
							FoundWord = Page[j][i].substr(WordPos, SearchWord.length);
							FoundWord = Page[j][i].substr(WordPos, SearchWord.length);
							NrRes++;
							ResultTemp += "<li>";
							ResultTemp += "<span>";
							if (WordPosHeading > -1) {
								ResultTemp += "<a href='" + Page[j][k] + "'>" + Page[j][heading].replace(FoundWordHead, FoundWordHead.bold()) + "</a><br/>\n";
							} else {
								// found word is not in the head
								ResultTemp += "<a href='" + Page[j][k] + "'>" + Page[j][heading] + "</a><br/>\n";

							}
							if (i < k - 1) {
								WordPosContentText = Page[j][i].toLowerCase().indexOf(SearchWord);

								if (Page[j][i].length > 300 && (WordPosContentText > -1)) {

									if (WordPosContentText > 75) {
										ResultInContentTemp.push("..." + Page[j][i].substr(WordPosContentText - 75, 175 + FoundWord.length).replace(FoundWord, FoundWord.bold()) + "...");
									} else {
										ResultInContentTemp.push("..." + Page[j][i].substr(0, 175 + FoundWord.length).replace(FoundWord, FoundWord.bold()) + "...");

									}

								} else if (WordPosContentText > -1) {

									ResultInContentTemp.push(Page[j][i].replace(FoundWord, FoundWord.bold()));

								}
							}

							ResultTemp += ResultInContentTemp.join("");

							ResultTemp += "</span>";
							ResultTemp += "</li>";

							if (WordPosHeading > -1) {
								ResultTitleAndContent[arrayIndex] = ResultTemp;
								arrayIndex++;
							} else {
								ResultInContent[arrayIndex] = ResultTemp;
								arrayIndex++;
							}

							ResultInContentTemp.length = 0;
							ResultTemp = "";
							WordPosHeading = -1;
							WordPosContentText = -1;
							break;
						}

					}
				}
			}

			ResultTitleOnly = ResultTitleOnly.filter(function (n) {
				return (n !== undefined && n !== null);
			});
			ResultTitleAndContent = ResultTitleAndContent.filter(function (n) {
				return (n !== undefined && n !== null);
			});
			ResultInContent = ResultInContent.filter(function (n) {
				return (n !== undefined && n !== null);
			});

			ResultCombinedTemp = ResultTitleOnly.concat(ResultTitleAndContent, ResultInContent);

			ResultCombinedTemp = ResultCombinedTemp.filter(function (n) {
				return (n !== undefined && n !== null);
			});

			for (d = 0; d < ResultCombinedTemp.length; d += size) {
				resGroupCounter++
				ResultCombined.push("<div id=" + "'" + "resGroup_" + resGroupCounter + "'" + " class=" + "'" + "resGroup " + shown + "'" + ">" + "<ol class='searchResults'>" + ResultCombinedTemp.slice(d, d + size).join("") + "</ol></div>");
				shown = "notshown";
			}

			ResultFound = ResultCombined.join("");

Result += "<div id='searchDetailsDiv'>";
			Result += "<p class='searchDetails'>Your Search Found&nbsp;" + NrRes + "&nbsp;items.&nbsp;";
			Result += "</p></div>";
			
			Result += "<div class='searchResultsDiv'>";
			Result += "<div id='resultsCollection' class='searchResults'>";
			Result += ResultFound;
			Result += "</div>";
			Result += "</div>";
			Result += "<div class='searchPaging'>";

			Result += '<hr />';

			Result += '<p class="bodytext"><a class="disabledAnchor" id="pBack" onclick="turnPage(\'backPage\')" href="#pBack">Back</a>&nbsp; | &nbsp;';
			
			if (resGroupCounter && resGroupCounter > 1) {
				Result += '<a id="pNext" onclick="turnPage(\'nextPage\')" href="#pNext">Next</a>';
			} else {
				Result += '<a id="pNext"  class="disabledAnchor" href="#pNext">Next</a>';
			}
			Result += '</p>\n';
			Result += '<div id="pagenofn"><p class="bodytext">Page <span id="pagen">1</span> of ' + resGroupCounter + '</p></div>';

			Result += "</div>";
			
			
		}

		DivResult = document.getElementById("s_anchor");
		if (Result && DivResult) {

			//myDivResult.append(Result);
			DivResult.innerHTML = Result;
			

		}
		window.status = "";
		
		

	}
	}())
}
