'use strict';
function search(SearchText, inHeading) {
(function () {
var Page = [];

/* Generated with Author-it 23.4.1.30004  12/8/2025 10:26:44 AM */
Page[0]=new Array("Title and Copyright Information","Copyright  1999, 2025, Oracle and/or its affiliates.","Primary Author: Oracle Corporation","Title and Copyright Information","46576.htm");
Page[1]=new Array("Scope","P6 EPPM requires a database in order to store your application data. This guide describes how to manually install P6 EPPM while using Microsoft SQL Server as a storage solution. Alternatively, you may use the P6 EPPM installation and configuration wizard to install and configure your applications. For more information, see the P6 EPPM Installation and Configuration Guide.","Audience","Database administrators should use this guide.","Using This Guide","This guide assumes you can perform common database administration procedures, and have experience using the command line.","About This Guide","94270.htm");
Page[2]=new Array("The P6 EPPM database stores P6 EPPM data used by the P6 EPPM applications.","The database administrator (DBA) should perform the steps in this chapter. You must install the database server before you can create the database. See the P6 EPPM Planning and Implementation Guide for details on product versions P6 EPPM supports. See the P6 EPPM Installation and Configuration Guide to use a wizard that automatically creates the database structures and loads the data.","P6 EPPM includes an encryption algorithm that provides enhanced security for private database logins; however, when you manually configure your database, the database does not automatically enforce the encryption algorithm. If you manually configure your database, Oracle recommends that you use this encryption algorithm. To do so, you must reset the private database login. See Resetting Private Database Passwords to Use the New Encryption Algorithm for instructions. If you automatically configure your database, you do not need to configure the encryption algorithm.","User logins and passwords are not affected.","User Name and Password Tips","P6 EPPM does not support passwords with multi-byte characters.","For security reasons, Oracle strongly recommends that you replace the default database users' (admuser, privuser, pubuser, bgjobuser, and PxRptUser) passwords immediately after a manual database installation or an upgrade from P6 version 7.0 and earlier. Do not use special characters in the database name, privileged user, public user, or PX Reporting user name for example: { } [ ] : ; &lt; &gt; , . ? ! @ # $ % ^ &amp; * ( ) - _ | / \\ ~ `  ","Oracle recommends using strong passwords. Strong passwords in P6 EPPM contain between 8 and 20 characters and at least one numeric and one alpha character. To further strengthen the password, use a mixture of upper and lower case letters.","See Modifying Private Database Logins for P6 EPPM for instructions on how to replace the private database login. For all other database user names and passwords, use the tools included with the database. ","For security reasons, Oracle strongly recommends that on-premises users replace the default Admin Superuser (admin) immediately after a manual database installation or an upgrade from P6 version 7.0 and earlier. See information on the default Admin Superuser in the P6 EPPM Application Administration Guide for guidelines on this process. See information on the default Admin Superuser in the P6 EPPM Application Administration Guide for guidelines on this process.","Security Tips","To configure the Microsoft SQL database server for SSL, see Microsoft's Documentation for instructions on configuring SQL Database Server SSL.&nbsp;Direct questions about Installation and Configurations to Microsoft.","ANSI_PADDING for a Microsoft SQL Server Database Tips ","To prevent duplicate values in P6 EPPM modules appearing due to leading or trailing spaces, ensure that the ANSI_PADDING setting in Microsoft SQL Server is Off. For example, if one user enters &quot;Equipment&quot; and another user enters &quot; Equipment&quot; (with a leading space) for resource codes, the database will store both of these as valid values if ANSI_PADDING is On. If ANSI_PADDING is Off, the database will remove the leading space in the second entry and tell the user to enter a unique ID. See the documentation included with Microsoft SQL Server for more information.","Other Tips","A SQL database name must not contain a space.","Microsoft SQL Server Database Manual Configuration Overview","54234.htm");
Page[3]=new Array("The Microsoft SQL Server DBA creates the P6 EPPM database, then runs P6 EPPM SQL scripts that create each database's structure (tables, indexes, relationships, etc.).","These instructions assume you are a DBA or are familiar with how to administer Microsoft SQL Server databases. You must complete these steps in the order specified. If you have any questions about the manual setup process, please contact Oracle Global Customer Support before proceeding.","Creating the Database Structure for Microsoft SQL Server and Loading Application Data","6834.htm");
Page[4]=new Array("Before you create the Microsoft SQL Server database structure, you should first register to the server as a system administrator (SA) and review the following server-level configuration changes in the Microsoft SQL Server Management Studio:","Max Worker Threads&nbsp;Specify the number of threads used to support the users connected to the server. The default setting (255) might be too high for some configurations, depending on the number of simultaneous users. Each worker thread allocates, even if it is not being used; if you have fewer simultaneous connections than allocated worker threads, you could be wasting memory.","Memory&nbsp;Keep the setting as Dynamic. Microsoft SQL Server dynamically acquires and frees memory as needed, up to the maximum available memory on your server.","Open Objects&nbsp;Keep the setting as Dynamic. This setting determines the maximum number of objects that can open simultaneously on Microsoft SQL Server. The value is set automatically depending on the current system. You should not have to change this value.","User Connections&nbsp;Keep the setting as 0. This setting designates Microsoft SQL Server to adjust the number of simultaneous user connections allowed based on how many are needed, up to the maximum value.","Network Packet Size Set to 16384.","Ensure that you have FILESTREAM enabled. For information on how to enable FILESTREAM, refer to the Microsoft SQL Server documentation for your version.","Note jobsvc.job_data_x is used to store XML data for XML import processes using the Varbinary(Max) datatype. In order to support the Varbinary(Max) datatype, you must enable FILESTREAM.","After configuring the server, stop and start Microsoft SQL Server to ensure that the changes take effect.","Prerequisites for SQL Server Configuration","53584.htm");
Page[5]=new Array("Complete the following steps to create the P6 EPPM database Microsoft SQL Server database structure.","Creating the P6 EPPM Database Structure for Microsoft SQL Server","32690.htm");
Page[6]=new Array("To copy the script files:","Copy the \\database folder to&nbsp;a local drive from the physical media or download.","Copying the Script Files to a Local Drive for Microsoft SQL Server","43348.htm");
Page[7]=new Array("To create the database:","Register to the server as SA user.","Open Microsoft SQL Server Management Studio. Go to \\database\\scripts\\install\\PM_&lt;release_level&gt; and run the sspm_init_db.sql script. This script creates a database called PMDB. If you want to change it, you must modify the sspm_init_db.sql script.","Note","Instead of running the sspm_init_db.sql script, you can manually create a database named PMDB with a data file of 500 MB or more and a log file of 200 MB or more.","Do not use special characters in the database name, privileged user, public user, or PX reporting user name, for example: { } [ ] : ; &lt; &gt; , . ? ! @ # $ % ^ &amp; * ( ) - _ | / \\ ~ `","You can change the initial data file and log file sizes and increase or decrease these amounts depending on how much data you plan to store in the database. You can also select the Automatically Grow File option to specify that these values automatically increase based on need.","Creating the Database for Microsoft SQL Server","32692.htm");
Page[8]=new Array("Note Oracle recommends that you use Microsoft SQL Server Management Studio to perform the following steps.","The scripts in this task are located in:","Install scripts: \\database\\scripts\\install\\PM_&lt;release_level&gt;","To create users and tables:","Log into the P6 EPPM database as SA user.","Run the sspm_create_users.sql script.","Note","Running the sspm_create_users.sql script creates the following user names: privuser, pubuser, and PxRptUser. If you have created other user names and wish to use those when running P6 EPPM database scripts, make sure to replace the private and public user names with your custom user names in all applicable scripts before running them.","Do not use special characters in the database name, privileged user, public user, or PX reporting user name, for example: { } [ ] : ; &lt; &gt; , . ? ! @ # $ % ^ &amp; * ( ) - _ | / \\ ~ `","Run the sspm_tables.sql script in the database you created when you ran the sspm_init_db.sql script.","Note","If you changed database or user names, you will need to update the sspm_tables.sql script. You will need to update the PMDB name and the privuser, pubuser, and pxrptuser names.","Creating Users and Tables for Microsoft SQL Server","32693.htm");
Page[9]=new Array("To install sample data:","Open a command prompt and change your directory to the location of the rundataloader.bat file, which is on the root of the database folder by default.","Run a statement similar to one of the following:","Use this command if you want to load sample data.","rundataloader.bat sample:pmdb_mk.zip<br />sa@sqlserver:host:port:instance","where sa is the administrator for the system database, host is the server machine name or IP address where Microsoft SQL Server is installed, sa is the system administrator or database user, port is the port number that Microsoft SQL Server is using (the default is 1433), and instance is the database name (for example, PMDB).","Use this command if you do not want to load sample data. Empty data is loaded in a secure state and includes only the most basic information needed to run the P6 EPPM database.","rundataloader.bat sample:pmdb_mk_empty.zip<br />sa@sqlserver:host:port:instance","where sa is the administrator for the system database, host is the server machine name or IP address where Microsoft SQL Server is installed, port is the port number that Microsoft SQL Server is using (the default is 1433), and instance is the database name (for example, PMDB).","In the Please select a password for the P6 'admin' SuperUser account prompt, enter or verify your superuser password.","Installing Sample Data and Creating Your P6 Admin Superuser Password for Microsoft SQL Server","32694.htm");
Page[10]=new Array("The scripts in this task are located in:","Install scripts: \\database\\scripts\\install\\PM_&lt;release_level&gt;","Source scripts: \\database\\scripts\\source\\PM_&lt;release_level&gt;","Common scripts: \\database\\scripts\\common\\PM_&lt;release_level&gt;","To create remaining database objects:","Log on to the P6 EPPM database as SA user.","Run the ss_set_currency.sql common script.","Run the sspm_querylib.sql install script.","Run the sspm_ins_aux.sql install script.","Note","The sspm_ins_aux.sql script has a grant that reads: GRANT SELECT ON PUBUSER TO PUBUSER. If you changed the default pubuser name, do not change the name of the PUBUSER table, only change the user name. For example: GRANT SELECT ON PUBUSER TO NEW_PUBUSER_USERNAME","If you changed the default privuser and pubuser names, you must update the sspm_ins_aux.sql script with your custom privuser and pubuser names.","Do not use special characters in the database name, privileged user, public user, or PX reporting user name, for example: { } [ ] : ; &lt; &gt; , . ? ! @ # $ % ^ &amp; * ( ) - _ | / \\ ~ `","Run the sspm_synonyms.sql source script.","Run the sspm_type_synonym.sql install script.","Run the sspm_src.plb source script.","Note","If you changed the default privuser name, you must update the sspm_src.plb script with your custom privuser name.","Do not use special characters in the database name, privileged user, public user, or PX reporting user name, for example: { } [ ] : ; &lt; &gt; , . ? ! @ # $ % ^ &amp; * ( ) - _ | / \\ ~ `","Run the sspm_init_bgjobs.sql script.","Run the sspm_settings.sql install script.","Run the sspm_database_version.sql install script.","Log into the SQL Server Management Studio as pxrptuser, or use your custom PX reporting user name if you created one, and then run the sspm_px_rpt_src.sql source script.","Note","If you changed the default pxrptuser name, you must update the sspm_px_rpt_src.sql script with your custom pxrptuser name.","Do not use special characters in the database name, privileged user, public user, or PX reporting user name, for example: { } [ ] : ; &lt; &gt; , . ? ! @ # $ % ^ &amp; * ( ) - _ | / \\ ~ `","If you used a non-default privuser name, you must do the following:","Log into the databaselogins.bat (on Windows) or databaselogins.sh (on Unix) database as privuser (use your custom privuser name if you created a custom user name and password).","Update the privuser name and password to match what you used when you created users in Creating Users and Tables for Microsoft SQL Server.","Creating Remaining Database Objects for Microsoft SQL Server","32695.htm");
Page[11]=new Array("If you make a mistake or want to recreate the database objects for the P6 EPPM database:","Login to Microsoft SQL Server Management Studio as SA user.","Expand Databases.","Select the database you want to delete (for example, PMDB).","Right-click the database and select Delete.","In the Delete Object dialog box, click OK.","Start over at Creating the P6 EPPM Database Structure for Microsoft SQL Server.","Dropping P6 EPPM Database Objects for Microsoft SQL Server","12826.htm");
Page[12]=new Array("Caution You cannot change the base currency once projects begin.","After manually creating and configuring the P6 EPPM database, you must change the base currency if you do not want the databases to use US dollars ($) as the base currency.","Changing the Database Base Currency","6825.htm");
Page[13]=new Array("The base currency is the monetary unit used to store cost data for all projects in the database and is controlled by a global administrative setting. The default base currency for P6 EPPM is US dollars ($). The view currency is the monetary unit used to display cost data in P6 EPPM and is controlled by a user preference.","The&nbsp;exchange rate for the base currency is always 1.0. When a user selects a different currency than the base currency to view cost data, the base currency value is multiplied times the current exchange rate for the view currency to calculate the values displayed in cost and price fields.","For example, if the base currency is US Dollars, the view currency is Euros, and the exchange rate for Euros is $1 = 0.75, a value of $10 stored in the database is displayed as 7.5 in cost and price fields. Similarly, if you enter 7.5 in a cost or price field, it is stored in the database as $10.","When data is displayed in a view currency that is different than the base currency, some cost and price values can vary slightly (e.g., due to rounding). As long as the correct base currency is selected during database installation, a user can view completely accurate cost and price data by changing the view currency to match the base currency.","The Base Currency","12803.htm");
Page[14]=new Array("To change the base currency you need to edit and run the P6 EPPM script provided. By default, US dollars is the base currency, and USD is the short name used in the script. To know which short name to use, review the list of available short names for P6 EPPM by running the following query on the P6 EPPM database:","select curr_type, curr_short_name from currtype;","Reviewing Currency Choices","32697.htm");
Page[15]=new Array("To change the base currency:","On the P6 EPPM physical media or download:","Browse to \\Database\\scripts\\common. ","Copy this script to a local drive:","For Microsoft SQL Server: ss_set_currency.sql","If you copied the script from the physical media, turn off the script's read-only attribute.","Since files on physical media are read-only, this attribute turns on when you copy a file from a CD or DVD. ","In Windows Explorer, right-click the file.","Choose Properties.","Clear the Read-Only option.","Open the script for editing and locate the line containing v_new_base_currency: = &#8216;USD'","Replace USD with the currency short name of your choice.","Save your changes and run the modified script.","Changing the Base Currency For MS SQL","95929.htm");
Page[16]=new Array("The P6 server and P6 Professional components obtain their run-time database connection credentials from a credential configuration table in the P6 EPPM database. The P6 run-time database credentials (known as privuser or P6 private database login) are stored in an encrypted format in this special P6 configuration table. Any time that you change or rotate the privuser password credentials in your Oracle, Oracle Autonomous Database, or MS SQL Server database, you must re-synchronize the stored credentials in the P6 credential table by using the Database Login tool.","Because encryption algorithms are often enhanced in newer releases, Oracle highly recommends that you reset these stored privuser credentials when you perform a major version upgrade of P6 EPPM. By resetting the stored credentials, the new encryption algorithm can be applied to other stored credentials (for example, pubuser) in the P6 EPPM credential table. For information about resetting private database passwords, see Resetting Private Database Passwords.","Note","This tool does not reset database user logins or passwords. Administrators should use SQL Developer or other DBA consoles to set or reset database user passwords.","Private Database Credentials for P6 EPPM","43428.htm");
Page[17]=new Array("Password encryption algorithms are frequently improved in new releases of P6 Professional and P6 Professional. You should reset private database passwords in order to use improved password encryption algorithms.","To reset private database passwords to use the new encryption algorithm:","Go to P6 EPPM &lt;release_level&gt;\\database or P6 Professional &lt;release_level&gt;\\database.","Run databaselogins.bat (with Windows) databaselogins.sh (with UNIX or Linux).","In the Database Connection dialog box:","Select the database.","Type the user name and password of a privileged database user (for example, privuser). This login should have administrative rights on the database.","Enter the connection details for the database.","For an Oracle Database, enter the host address, host port, and database/instance name specific to your installation. The Port field displays the default port for the database type you selected.","For an Oracle Autonomous Database, enter the location of the unzipped wallet file and the service name.","For a Microsoft SQL Server Database, enter the host address, host port, and database/instance name specific to your installation. The Port field displays the default port for the database type you selected.","Click Next.","In the Private Database Logins dialog box:","Select the private database user name that you wish to reset.","Highlight the password and change it (or re-enter the existing password).","Click Update Password.","Click Save.","Click OK.","Resetting Private Database Passwords","46563.htm");
Page[18]=new Array("You can add private database users to your P6 EPPM database. ","To add private database logins for P6 EPPM:","Go to P6 EPPM &lt;release_level&gt;\\database and run databaselogins.bat (with Windows) databaselogins.sh (with UNIX or Linux).","On the Database Connection dialog box:","Select the database.","Type the user name and password of a privileged database user (for example, privuser). This login should have administrative rights on the database.","Enter the connection details for the database.","For an Oracle Database, enter the host address, host port, and database/instance name specific to your installation. The Port field displays the default port for the database type you selected.","For an Oracle Autonomous Database, enter the location of the unzipped wallet file and the service name.","For a Microsoft SQL Server Database, enter the host address, host port, and database/instance name specific to your installation. The Port field displays the default port for the database type you selected.","Click Next.","On the Private Database Logins dialog box:","Click Add.","Enter a user name.","Enter a password.","Note To reverse a change, click Undo. Undo will reverse any changes made during the current session.","Click Save.","Click OK to exit.","Adding Private Database Logins for P6 EPPM","46566.htm");
Page[19]=new Array("You can update the passwords and usernames of the private database users on your P6 EPPM database. ","To modify private database logins:","Go to P6 EPPM &lt;release_level&gt;\\database and run databaselogins.bat (with Windows) databaselogins.sh (with UNIX or Linux).","On the Database Connection dialog box:","Select the database.","Type the user name and password of a privileged database user (for example, privuser). This login should have administrative rights on the database.","Enter the connection details for the database.","For an Oracle Database, enter the host address, host port, and database/instance name specific to your installation. The Port field displays the default port for the database type you selected.","For an Oracle Autonomous Database, enter the location of the unzipped wallet file and the service name.","For a Microsoft SQL Server Database, enter the host address, host port, and database/instance name specific to your installation. The Port field displays the default port for the database type you selected.","Click Next.","On the Private Database Logins dialog box:","Select the private database user name that you wish to modify.","Enter a new user name.","Highlight the password, and change it.","Click the Update Password button.","Note To reverse a change, click Undo. Undo will reverse any changes made during the current session.","Click Save.","Click OK to exit the Database Logins tool.","Modifying Private Database Logins for P6 EPPM","46565.htm");
Page[20]=new Array("If you no longer need your private database users you can delete them. ","To delete private database logins for P6 EPPM:","Go to P6 EPPM &lt;release_level&gt;\\database and run databaselogins.bat (with Windows) databaselogins.sh (with UNIX or Linux).","On the Database Connection dialog box:","Select the database.","Type the user name and password of a privileged database user (for example, privuser). This login should have administrative rights on the database.","Enter the connection details for the database.","For an Oracle Database, enter the host address, host port, and database/instance name specific to your installation. The Port field displays the default port for the database type you selected.","For an Oracle Autonomous Database, enter the location of the unzipped wallet file and the service name.","For a Microsoft SQL Server Database, enter the host address, host port, and database/instance name specific to your installation. The Port field displays the default port for the database type you selected.","Click Next.","On the Private Database Logins dialog box:","Select the private database user name that you wish to remove.","NoteYou must have at least one private user name for the P6 EPPM database at all times.","Click Delete.","Note To reverse a change, click Undo. Undo will reverse any changes made during the current session.","Click Save.","Click OK to exit the Database Logins tool.","Deleting Private Database Logins for P6 EPPM","46567.htm");
Page[21]=new Array("You can download the media pack that contains the installer and all required install files from the Oracle Software Delivery Cloud website at https://edelivery.oracle.com.","Run setup.exe in the Primavera P6 Enterprise Project Portfolio Management physical media or download to install the following P6 EPPM applications:","Note","You do not have to install all applications; you can pick and choose what you install. However, you must install P6 to run the other P6 EPPM applications.","P6 Team Member (includes P6 Team Member Web and Email Statusing Service)","Note","You will need to configure Email Statusing Service separately. The installation wizard will provide the Email Statusing Service files and you will use the config.properties file to set up this service. See the P6 EPPM System Administration Guide.","P6 mobile supports SSL (https) only when it has a certificate signed by a valid authority.","P6 EPPM Web Services","P6 Professional Cloud Connect ","Select the P6 Professional Cloud Connect install option if you plan to use P6 Professional with an P6 EPPM Oracle or Oracle Autonomous Database database on the cloud by connecting to a remote service. The wizard sets up a remote method of access to connect to the EPPM database and the P6 APIs. For more details on establishing the P6 Professional Cloud Connect database connection in P6 Professional, see the P6 Professional Installation and Configuration Guide (P6 EPPM). ","Note The wizard will also install P6 Integration API (in remote mode) by default.","P6 Integration API (remote mode only)","Note Oracle provides a separate installer for P6 Integration API local mode. See the P6 Integration API Configuration Guide.","P6 mobile","Note","P6 mobile apps are downloaded through the Apple App Store or the Google Play Store. See the P6 Team Member User's Guide.","P6 mobile supports SSL (https) only when it has a certificate signed by a valid authority.","Based on whether you are installing or upgrading, see one of the following books:","P6 EPPM Installation and Configuration Guide","P6 EPPM Upgrade and Configuration Guide","Installing P6 EPPM Applications","53137.htm");
var PageCount=22;


/*
Date: 12/8/2025 10:26 AM
Source: EPPM_25_dev
BookID: 53899
PubProduct: PRIMAVERA_EPPM
BookTitle: Manual Installation Guide (Microsoft SQL Server Database) for On-Premises
Version: Version 25
Lang:	en
*/
	var PageLength=Page.length;
	var Result = "";
	var ResultTemp = "";
	var ResultFound = "";
	var ResultTitleOnly = [];
	var ResultTitleAndContent = [];
	var ResultInContent = [];
	var ResultInContentTemp = [];

	var ResultCombinedTemp = [];
	var ResultCombined = [];

	var arrayIndex = 0;
	var NrRes = 0;
	var j = 0;
	var i = 0;
	var k = 0;
	var d = 0;
	var maxItems = 1000;
	var heading = 0;
	var WordPos = -1;
	var WordPosHeading = -1;
	var WordPosContentText = -1;
	var FoundWord = "";
	var FoundWordHead = "";
	var SearchInHeadingOnly = 0;
	var isChecked;
	var size = 10;
	var resGroupCounter = 0;
	var shown = "shown";
	var checkBoxInHeading;
	var searchFlag = 0;
	var DivResult;
	var SearchWord;

if (SearchText && SearchText.length >= 1) {
		SearchWord = SearchText.replace(/\+/g, " ").replace(/&/g, "&amp;").replace(/</g, "&lt;").replace(/>/g, "&gt;").replace(/"/g, "&quot;");
		searchFlag = 1;
	} else {
		SearchWord = "";
		searchFlag = 0;
	}
	

	if (searchFlag === 1) {
		Result = "";

		// checkBoxInHeading = document.getElementById("inHeading");
		if (inHeading) {

			isChecked = true;
		} else {

			isChecked = false;
		}

		if (SearchWord && SearchWord.length >= 1) {
			if (isChecked) {
				SearchInHeadingOnly = 1;
			} else {
				SearchInHeadingOnly = 0;
			}
			SearchWord = SearchWord.toLowerCase();
			window.status = "Searching, please wait...";
			for (j = 0; j < PageLength; j++) {
				k = Page[j].length - 1;
				for (i = 0; i < k; i++) {

					heading = k - 1;

					if (SearchInHeadingOnly === 1) {
						WordPosHeading = Page[j][heading].toLowerCase().indexOf(SearchWord);
						if (WordPosHeading > -1) {
							FoundWordHead = Page[j][heading].substr(WordPosHeading, SearchWord.length);

							NrRes++;
							ResultTemp = "<li>";
							ResultTemp += "<span>";
							ResultTemp += "<a href='" + Page[j][k] + "'>" + Page[j][heading].replace(FoundWordHead, FoundWordHead.bold()) + "</a><br/>\n";

							ResultTemp += "</span>";
							ResultTemp += "</li>";

							ResultTitleOnly[arrayIndex] = ResultTemp;
							arrayIndex++;

							ResultTemp = "";
							WordPosHeading = -1;
							WordPosContentText = -1;
							break;
						}
					} else if (SearchInHeadingOnly === 0) {
						WordPos = Page[j][i].toLowerCase().indexOf(SearchWord);
						WordPosHeading = Page[j][heading].toLowerCase().indexOf(SearchWord);
						if (WordPos > -1) {
							FoundWordHead = Page[j][heading].substr(WordPosHeading, SearchWord.length);
							FoundWord = Page[j][i].substr(WordPos, SearchWord.length);
							FoundWord = Page[j][i].substr(WordPos, SearchWord.length);
							NrRes++;
							ResultTemp += "<li>";
							ResultTemp += "<span>";
							if (WordPosHeading > -1) {
								ResultTemp += "<a href='" + Page[j][k] + "'>" + Page[j][heading].replace(FoundWordHead, FoundWordHead.bold()) + "</a><br/>\n";
							} else {
								// found word is not in the head
								ResultTemp += "<a href='" + Page[j][k] + "'>" + Page[j][heading] + "</a><br/>\n";

							}
							if (i < k - 1) {
								WordPosContentText = Page[j][i].toLowerCase().indexOf(SearchWord);

								if (Page[j][i].length > 300 && (WordPosContentText > -1)) {

									if (WordPosContentText > 75) {
										ResultInContentTemp.push("..." + Page[j][i].substr(WordPosContentText - 75, 175 + FoundWord.length).replace(FoundWord, FoundWord.bold()) + "...");
									} else {
										ResultInContentTemp.push("..." + Page[j][i].substr(0, 175 + FoundWord.length).replace(FoundWord, FoundWord.bold()) + "...");

									}

								} else if (WordPosContentText > -1) {

									ResultInContentTemp.push(Page[j][i].replace(FoundWord, FoundWord.bold()));

								}
							}

							ResultTemp += ResultInContentTemp.join("");

							ResultTemp += "</span>";
							ResultTemp += "</li>";

							if (WordPosHeading > -1) {
								ResultTitleAndContent[arrayIndex] = ResultTemp;
								arrayIndex++;
							} else {
								ResultInContent[arrayIndex] = ResultTemp;
								arrayIndex++;
							}

							ResultInContentTemp.length = 0;
							ResultTemp = "";
							WordPosHeading = -1;
							WordPosContentText = -1;
							break;
						}

					}
				}
			}

			ResultTitleOnly = ResultTitleOnly.filter(function (n) {
				return (n !== undefined && n !== null);
			});
			ResultTitleAndContent = ResultTitleAndContent.filter(function (n) {
				return (n !== undefined && n !== null);
			});
			ResultInContent = ResultInContent.filter(function (n) {
				return (n !== undefined && n !== null);
			});

			ResultCombinedTemp = ResultTitleOnly.concat(ResultTitleAndContent, ResultInContent);

			ResultCombinedTemp = ResultCombinedTemp.filter(function (n) {
				return (n !== undefined && n !== null);
			});

			for (d = 0; d < ResultCombinedTemp.length; d += size) {
				resGroupCounter++
				ResultCombined.push("<div id=" + "'" + "resGroup_" + resGroupCounter + "'" + " class=" + "'" + "resGroup " + shown + "'" + ">" + "<ol class='searchResults'>" + ResultCombinedTemp.slice(d, d + size).join("") + "</ol></div>");
				shown = "notshown";
			}

			ResultFound = ResultCombined.join("");

Result += "<div id='searchDetailsDiv'>";
			Result += "<p class='searchDetails'>Your Search Found&nbsp;" + NrRes + "&nbsp;items.&nbsp;";
			Result += "</p></div>";
			
			Result += "<div class='searchResultsDiv'>";
			Result += "<div id='resultsCollection' class='searchResults'>";
			Result += ResultFound;
			Result += "</div>";
			Result += "</div>";
			Result += "<div class='searchPaging'>";

			Result += '<hr />';

			Result += '<p class="bodytext"><a class="disabledAnchor" id="pBack" onclick="turnPage(\'backPage\')" href="#pBack">Back</a>&nbsp; | &nbsp;';
			
			if (resGroupCounter && resGroupCounter > 1) {
				Result += '<a id="pNext" onclick="turnPage(\'nextPage\')" href="#pNext">Next</a>';
			} else {
				Result += '<a id="pNext"  class="disabledAnchor" href="#pNext">Next</a>';
			}
			Result += '</p>\n';
			Result += '<div id="pagenofn"><p class="bodytext">Page <span id="pagen">1</span> of ' + resGroupCounter + '</p></div>';

			Result += "</div>";
			
			
		}

		DivResult = document.getElementById("s_anchor");
		if (Result && DivResult) {

			//myDivResult.append(Result);
			DivResult.innerHTML = Result;
			

		}
		window.status = "";
		
		

	}
	}())
}
