'use strict';
function search(SearchText, inHeading) {
(function () {
var Page = [];

/* Generated with Author-it 23.4.1.30004  12/8/2025 10:25:40 AM */
Page[0]=new Array("Title and Copyright Information","Copyright  1999, 2025, Oracle and/or its affiliates.","Primary Author: Oracle Corporation","Title and Copyright Information","46576.htm");
Page[1]=new Array("Scope","P6 EPPM requires a database to store your application data. This guide describes how to manually install P6 EPPM while using Oracle database as a storage solution. Alternatively, you may use the P6 EPPM installation and configuration wizard to install and configure your applications. For more information, see the P6 EPPM Installation and Configuration Guide.","Audience","Database administrators should use this guide.","Using This Guide","This guide assumes you can perform common database administration procedures, and have experience using the command line.","About This Guide","94269.htm");
Page[2]=new Array("The P6 EPPM database stores P6 EPPM data used by the P6 EPPM applications.","The database administrator (DBA) should perform the steps in this chapter. You must install the database server before you can create the database. See the P6 EPPM Planning and Implementation Guide for details on product versions P6 EPPM supports. See the P6 EPPM Installation and Configuration Guide to use a wizard that automatically creates the database structures and loads the data.","P6 EPPM includes an encryption algorithm that provides enhanced security for private database logins; however, when you manually configure your database, the database does not automatically enforce the encryption algorithm. If you manually configure your database, Oracle recommends that you use this encryption algorithm. To do so, you must reset the private database login. See Resetting Private Database Passwords to Use the New Encryption Algorithm for instructions. If you automatically configure your database, you do not need to configure the encryption algorithm.","User logins and passwords are not affected.","User Name and Password Tips","P6 EPPM does not support passwords with multi-byte characters.","For security reasons, Oracle strongly recommends that you replace the default database users' (admuser, privuser, pubuser, bgjobuser, and PxRptUser) passwords immediately after a manual database installation or an upgrade from P6 version 7.0 and earlier. Do not use special characters in the database name, privileged user, public user, or PX Reporting user name for example: { } [ ] : ; &lt; &gt; , . ? ! @ # $ % ^ &amp; * ( ) - _ | / \\ ~ `  ","Oracle recommends using strong passwords. Strong passwords in P6 EPPM contain between 8 and 20 characters and at least one numeric and one alpha character. To further strengthen the password, use a mixture of upper and lower case letters.","See Modifying Private Database Logins for P6 EPPM for instructions on how to replace the private database login. For all other database user names and passwords, use the tools included with the database. ","For security reasons, Oracle strongly recommends that on-premises users replace the default Admin Superuser (admin) immediately after a manual database installation or an upgrade from P6 version 7.0 and earlier. See information on the default Admin Superuser in the P6 EPPM Application Administration Guide for guidelines on this process. See information on the default Admin Superuser in the P6 EPPM Application Administration Guide for guidelines on this process.","Security Tips","To configure the Oracle database server for SSL, please see the P6 EPPM Security Guide included with the Oracle Database Server Documentation for configuring the Oracle Server and Oracle Client(s) for SSL.","Oracle Database Manual Configuration Overview","6810.htm");
Page[3]=new Array("You can use an Oracle Database on your database server for P6 EPPM installations. You must install the database server before you can create the P6 EPPM database.","Note","When you attempt to create an Oracle Database the option to create a pluggable database will be enabled by default. If you do not want to create a container database, deselect the Create As Container Database check box during the database creation process. If you create a container database, you must also create a pluggable database on which to install your P6 EPPM instance.","When using an Oracle Database, you must install Oracle Multimedia, along with these supporting components: Oracle JVM, Oracle XML DB (XDB), and XML Developer's Kit (XDK). Unless you specify otherwise, these components are automatically installed. If you chose not to install these components, you will need to install them before you install P6 EPPM. See the Oracle Multimedia's User's Guide for information on how to install these components.","Oracle Database Installation","61562.htm");
Page[4]=new Array("The Oracle database administrator (DBA) creates the P6 EPPM database, then runs P6 EPPM SQL scripts, which create each database's structure (tables, indexes, relationships, etc.).","Note","Oracle must be run in Dedicated Mode (rather than MTS mode).","If you need to use the Euro symbol in any Western European language, you must use codepage WE8MSWIN1252 or UTF8. Please note, if you change the NLS_LENGTH_SEMANTICS parameter from BYTE to CHAR, you will not affect the software. Oracle recommends using CHAR if using UTF8 because some characters are two or three bytes.","These instructions assume you are an Oracle DBA or are familiar with administering Oracle databases. They also assume you have set up an Oracle server instance and configured your network. You must complete the steps in the order specified. If you have any questions about the manual setup process, please contact Oracle Global Customer Support before proceeding.","You can also use a wizard that automatically creates the database structures and loads the data for you. For more information, see the P6 EPPM Installation and Configuration Guide.","Oracle recommends that you use SQL Plus to run scripts referenced in the following instructions.","Creating the Database Structure for Oracle and Loading Application Data","6817.htm");
Page[5]=new Array("Complete the following steps to create the P6 EPPM Oracle database structure.","Creating the P6 EPPM Database Structure for Oracle","32688.htm");
Page[6]=new Array("To copy the script files:","Copy the \\database folder to&nbsp;a local drive from the physical media or download.","Copying the Script Files to a Local Drive","32691.htm");
Page[7]=new Array("Before installing P6 EPPM, you must complete the following steps to grant required privileges to your database SYSTEM user.","To grant privileges to the SYSTEM user:","Navigate to the following location, open the designated script in a text editor, and modify the schema user reference to match your actual schema user name:","\\scripts\\install\\PM_&lt;release level&gt;\\manual_script_before_install.sql","You must apply grant options to the SYSTEM schema user or a custom user associated with the Oracle DBA role. If you plan to use a custom schema user (other than SYSTEM) to run steps which require a DBA role, then you must update the references to SYSTEM in the script with the new custom schema user associated with the DBA role.","From the command line, run the following and provide the password when prompted: sqlplus sys@&lt;db_tns_names_entry&gt; as sysdba","Go to p6suite\\database\\scripts\\install\\PM_&lt;release_level&gt;, and run manual_script_before_install.sql.","This script grants SELECT and EXECUTE privileges with grant option to SYSTEM, or a custom DBA username if you prefer to use one, for the following sys objects:","SELECT","sys.DBA_VIEWS","sys.V_$TRANSACTION","sys.GV_$TRANSACTION","EXECUTE","sys.DBMS_REPUTIL","sys.DBMS_LOB","sys.DBMS_SQL","sys.DBMS_JOB","sys.DBMS_RANDOM","Note For more information about the listed sys objects, refer to the Oracle Database documentation.","Grant Privileges to the SYSTEM User","85043.htm");
Page[8]=new Array("You must create specific tablespaces to use an Oracle database with your P6 EPPM installation.  ","To create database tablespaces:","Complete the following steps:","From the command line, run: sqlplus &lt;system&gt;/password@&lt;db_tns_names_entry&gt;:","Go to \\database\\scripts\\install\\PM_&lt;release_level&gt; and run the orpm_init_db.sql script.","This script creates the following tablespaces:","PMDB_DAT1","PMDB_NDX1","PMDB_LOB1","PMDB_PX_DAT1","If you want to change the names of the tablespaces that are listed above, you must modify the orpm_init_db.sql script before you run it.","Note","Do not use special characters in the database name, privileged user, public user, or PX reporting user name, for example: { } [ ] : ; &lt; &gt; , . ? ! @ # $ % ^ &amp; * ( ) - _ | / \\ ~ `","Instead of running the orpm_init_db.sql script, you can manually create a database with system, temporary, and undo tablespaces. Oracle recommends that you create a database with a 500 MB temporary tablespace and a 500 MB undo tablespace. Make sure that the Oracle client can connect to the database. Refer to your Oracle database documentation if you are unfamiliar with this process.","Creating the Database Tablespaces for Oracle","32678.htm");
Page[9]=new Array("You must create specific users and tables within your Oracle database to use it with your P6 EPPM installation.","Note","The scripts in this task are located in:","\\database\\scripts\\install\\PM_&lt;release_level&gt;","To create users and tables:","Complete the following steps:","From the command line, run the following and provide the password when prompted: sqlplus system@&lt;db_tns_names_entry&gt;","Run the orpm_create_users.sql script.","Running the orpm_create_users.sql script automatically creates database user names: admuser, privuser, pubuser, pxrptuser, and bgjobuser. If you want to create non-default usernames, you must first open the script in a text editor and then replace the default references before you run the script.","Running the orpm_create_users.sql script references the following default tablespace names: PMDB_DAT1, PMDB_NDX1, PMDB_LOB1, and PMDB_PX_DAT1. If you created the tablespaces using non-default names, you must first open the script in a text editor and replace the default references before you run the script.","Note Do not use special characters in the database name, privileged user, public user, or PX reporting user name, for example: { } [ ] : ; &lt; &gt; , . ? ! @ # $ % ^ &amp; * ( ) - _ | / \\ ~ `","Run the orpm_grant_privileges.sql script.","Running the orpm_grant_privileges.sql script references the following database user names: admuser, privuser, pubuser, pxrptuser, and bgjobuser. If you want to create non-default usernames, you must first open the script in a text editor and then replace the default references prior to running the script.","Complete the following steps:","From the command line, run the following and provide the password when prompted: sqlplus &lt;admuser&gt;@&lt;db_tns_names_entry&gt;","Run the orpm_tables.sql script.","Running the orpm_tables.sql script references the following default user names: privuser, pubuser, and pxrptuser. If you created non-default user names, you must first open the script in a text editor and replace the default references before you run the script.","Running the orpm_tables.sql script references the following default tablespace names:  PMDB_DAT1, PMDB_LOB1, and PMDB_PX_DAT1. If you created the tablespaces using non-default names, you must first open the script in a text editor and replace the default references before you run the script.","Creating Users and Tables for Oracle","32679.htm");
Page[10]=new Array("You can install sample data within your P6 EPPM database. Sample data enables you to familiarize yourself with P6 EPPM applications by emulating business scenarios. ","To install sample data:","Open command prompt (if Windows) or terminal (if UNIX) and connect to your database using the following command:","sqlplus sys/password@dbservicename as sysdba","Run the following commands in the same window:","noaudit policy ORA_SECURECONFIG;","noaudit policy ORA_LOGON_FAILURES;","Close the window.","Open a fresh command prompt (if windows) or terminal (if UNIX) and then change your directory to the location of the rundataloader.bat (.sh) file, which is on the root of the database folder by default.","Run a statement similar to one of the following:","Use this command if you want to load sample data into a non-production environment.","If you are using Windows","rundataloader.bat sample:pmdb_mk.zip &lt;admuser&gt;@oracle:&lt;host&gt;:&lt;port&gt;:&lt;SID_name&gt;","rundataloader.bat sample:pmdb_mk.zip &lt;admuser&gt;/&lt;admuser_password&gt;@oracle:&lt;host&gt;:&lt;port&gt;/&lt;service_name&gt;","If you are using Unix","./rundataloader.sh sample:pmdb_mk.zip admuser@oracle:host:port:&lt;SID_name&gt;","./rundataloader.sh sample:pmdb_mk.zip &lt;admuser&gt;/&lt;admuser_password&gt;@oracle:&lt;host&gt;:&lt;port&gt;/&lt;service_name&gt;","Use this command if you do not want to load sample data. Empty data is loaded in a secure state and includes only the basic information needed to run the P6 EPPM database.","If you are using Windows ","rundataloader.bat sample:pmdb_mk_empty.zip admuser@oracle:host:port:&lt;SID_name&gt;","rundataloader.bat sample:pmdb_mk_empty.zip &lt;admuser&gt;/&lt;admuser_password&gt;@oracle:&lt;host&gt;:&lt;port&gt;/&lt;service_name&gt;","If you are using Unix","./rundataloader.sh sample:pmdb_mk_empty.zip &lt;admuser&gt;@oracle:host:port:&lt;SID_name&gt;","./rundataloader.sh sample:pmdb_mk_empty.zip &lt;admuser&gt;/&lt;admuser_password&gt;@oracle:&lt;host&gt;:&lt;port&gt;/&lt;service_name&gt;","Note","For the connection strings above: &lt;admuser&gt; is the database admin user that you created, &lt;admuser_password&gt; is the password for the database admin user, &lt;host&gt; is the server machine name or IP address where Oracle is installed, &lt;port&gt; is the port number that Oracle is using (the default is 1521), &lt;SID_name&gt; is the database SID (for example, PMDB), and &lt;service_name&gt; is the database service name (for example, orcl.us.oracle.com)","If you use the connection string that is associated with a service name and do not include &lt;admuser_password&gt; in your connection string, you will experience a Java error and no data will be loaded into your environment.","Do the following:","In the &quot;WARNING:This operation will destroy existing data in the database: Do you wish to continue? (Y or N)&quot; prompt, enter: Y.","In the &quot;Password for admuser:&quot; prompt, enter the the password of your admuser or custom administrative user that you created.","In the &quot;Please select a password for the P6 'admin' SuperUser account&quot; prompt, enter or verify your superuser password.","Installing Sample Data and Creating Your P6 EPPM Admin Superuser Password for Oracle","32681.htm");
Page[11]=new Array("To finalize the creation of your P6 EPPM database structure, you must create the remaining database objects within your database.","To create the remaining database objects:","Note","After each step, log out of the database.","Complete the following steps:","From the command line, run the following and provide the password when prompted: sqlplus &lt;admuser&gt;@&lt;db_tns_names_entry&gt;","Go to \\scripts\\install\\PM_&lt;release_level&gt; and run the orpm_admuser.sql script.","Running the orpm_admuser.sql script references the following default user names: admuser, privuser, and pxrptuser. If you created non-default user names, you must open the script in a text editor and then replace the default references before you run the script.","Running the orpm_admuser.sql script references the following default tablespace names:  PMDB_NDX1 and PMDB_PX_DAT1. If you created the tablespaces using non-default names, you must open the script in a text editor and then replace the default references before you run the script","Complete the following steps:","From the command line, run the following and provide the password when prompted: sqlplus &lt;privuser&gt;@&lt;db_tns_names_entry&gt;","Go to \\scripts\\source\\PM_&lt;release_level&gt; and run the orpm_privuser.sql script.","Running the orpm_privuser.sql script references the admuser name. If you created non-default user names, you must open the script in a text editor and then replace the default references before you run the script.","Complete the following steps:","From the command line, run the following and provide the password when prompted: sqlplus &lt;pubuser&gt;@&lt;db_tns_names_entry&gt;","Go to \\scripts\\source\\PM_&lt;release_level&gt; and run the orpm_pubuser.sqlscript.","Running the orpm_pubuser.sql script references the admuser name. If you created non-default user names, you must open the script in a text editor and then replace the default references before you run the script.","Complete the following steps:","From the command line, run the following and provide the password when prompted: sqlplus &lt;pxrptuser&gt;@&lt;db_tns_names_entry&gt;","Go to \\scripts\\source\\PM_&lt;release_level&gt; and run the orpm_pxrptuser.sqlscript.","Running the orpm_pxrptuser.sql script references the admuser name. If you created non-default user names, you must open the script in a text editor and then replace the default references before you run the script.","Complete the following steps:","From the command line, run the following and provide the password when prompted: sqlplus &lt;bgjobuser&gt;@&lt;db_tns_names_entry&gt;","Go to \\scripts\\source\\PM_&lt;release_level&gt; and run the orpm_bguser.sql script","Running the orpm_bguser.sql script references the admuser name. If you created non-default user names, you must open the script in a text editor and then replace the default references before you run the script.","Complete the following steps:","From the command line, run the following and provide the password when prompted: sqlplus &lt;system&gt;@&lt;db_tns_names_entry&gt;","Go to \\scripts\\install\\PM_&lt;release_level&gt; and run the orpm_reset_priv.sql script.","Running the orpm_reset_priv.sql script references the following default user names: admuser, pxrptuser, and bgjobuser.&nbsp;If you created non-default user names, you must open the script in a text editor and then replace the default references before you run the script.","Running the orpm_reset_priv.sql script references the following default tablespace names:&nbsp; PMDB_DAT1, PMDB_NDX1, PMDB_LOB1, and PMDB_PX_DAT1. If you created the tablespaces using non-default names, you must open the script in a text editor and then replace the default references prior to running the script.","Do the following:","Log into the databaselogins.bat (on Windows) or databaselogins.sh (on Unix) database as admuser, or use your custom administrative user name if you created one.","Update the privuser name and password to match what you used when you created your user names and passwords.","Creating Remaining Database Objects for Oracle","32682.htm");
Page[12]=new Array("You can drop the P6 EPPM database objects from your database if you make a mistake during database setup or want to recreate your database structure.","To drop the database objects for the P6 EPPM database:","Go to \\database\\scripts\\install\\PM_&lt;release_level&gt; and run the orpm_drop_users.sql script. This will drop admuser, privuser, pubuser, bgjobuser, and PxRptUser and their objects.","Start over at Creating Users and Tables for Oracle.","Dropping P6 EPPM Database Objects for Oracle","12824.htm");
Page[13]=new Array("Caution You cannot change the base currency once projects begin.","After manually creating and configuring the P6 EPPM database, you must change the base currency if you do not want the databases to use US dollars ($) as the base currency.","Changing the Database Base Currency","6825.htm");
Page[14]=new Array("The base currency is the monetary unit used to store cost data for all projects in the database and is controlled by a global administrative setting. The default base currency for P6 EPPM is US dollars ($). The view currency is the monetary unit used to display cost data in P6 EPPM and is controlled by a user preference.","The&nbsp;exchange rate for the base currency is always 1.0. When a user selects a different currency than the base currency to view cost data, the base currency value is multiplied times the current exchange rate for the view currency to calculate the values displayed in cost and price fields.","For example, if the base currency is US Dollars, the view currency is Euros, and the exchange rate for Euros is $1 = 0.75, a value of $10 stored in the database is displayed as 7.5 in cost and price fields. Similarly, if you enter 7.5 in a cost or price field, it is stored in the database as $10.","When data is displayed in a view currency that is different than the base currency, some cost and price values can vary slightly (e.g., due to rounding). As long as the correct base currency is selected during database installation, a user can view completely accurate cost and price data by changing the view currency to match the base currency.","The Base Currency","12803.htm");
Page[15]=new Array("To change the base currency you need to edit and run the P6 EPPM script provided. By default, US dollars is the base currency, and USD is the short name used in the script. To know which short name to use, review the list of available short names for P6 EPPM by running the following query on the P6 EPPM database:","select curr_type, curr_short_name from currtype;","Reviewing Currency Choices","32697.htm");
Page[16]=new Array("To change the base currency:","On the P6 EPPM physical media or download:","Browse to \\Database\\scripts\\common. ","Copy this script to a local drive:","or_set_currency.sql","If you copied the script from the physical media, turn off the script's read-only attribute.","Since files on physical media are read-only, this attribute turns on when you copy a file from a CD or DVD. ","In Windows Explorer, right-click the file.","Choose Properties.","Clear the Read-Only option.","Open the script for editing and locate the line containing v_new_base_currency: = &#8216;USD'","Replace USD with the currency short name of your choice.","Save your changes and run the modified script.","Changing the Base Currency","32698.htm");
Page[17]=new Array("The P6 server and P6 Professional components obtain their run-time database connection credentials from a credential configuration table in the P6 EPPM database. The P6 run-time database credentials (known as privuser or P6 private database login) are stored in an encrypted format in this special P6 configuration table. Any time that you change or rotate the privuser password credentials in your Oracle, Oracle Autonomous Database, or MS SQL Server database, you must re-synchronize the stored credentials in the P6 credential table by using the Database Login tool.","Because encryption algorithms are often enhanced in newer releases, Oracle highly recommends that you reset these stored privuser credentials when you perform a major version upgrade of P6 EPPM. By resetting the stored credentials, the new encryption algorithm can be applied to other stored credentials (for example, pubuser) in the P6 EPPM credential table. For information about resetting private database passwords, see Resetting Private Database Passwords.","Note","This tool does not reset database user logins or passwords. Administrators should use SQL Developer or other DBA consoles to set or reset database user passwords.","Private Database Credentials for P6 EPPM","43428.htm");
Page[18]=new Array("Password encryption algorithms are frequently improved in new releases of P6 Professional and P6 Professional. You should reset private database passwords in order to use improved password encryption algorithms.","To reset private database passwords to use the new encryption algorithm:","Go to P6 EPPM &lt;release_level&gt;\\database or P6 Professional &lt;release_level&gt;\\database.","Run databaselogins.bat (with Windows) databaselogins.sh (with UNIX or Linux).","In the Database Connection dialog box:","Select the database.","Type the user name and password of a privileged database user (for example, privuser). This login should have administrative rights on the database.","Enter the connection details for the database.","For an Oracle Database, enter the host address, host port, and database/instance name specific to your installation. The Port field displays the default port for the database type you selected.","For an Oracle Autonomous Database, enter the location of the unzipped wallet file and the service name.","For a Microsoft SQL Server Database, enter the host address, host port, and database/instance name specific to your installation. The Port field displays the default port for the database type you selected.","Click Next.","In the Private Database Logins dialog box:","Select the private database user name that you wish to reset.","Highlight the password and change it (or re-enter the existing password).","Click Update Password.","Click Save.","Click OK.","Resetting Private Database Passwords","46563.htm");
Page[19]=new Array("You can add private database users to your P6 EPPM database. ","To add private database logins for P6 EPPM:","Go to P6 EPPM &lt;release_level&gt;\\database and run databaselogins.bat (with Windows) databaselogins.sh (with UNIX or Linux).","On the Database Connection dialog box:","Select the database.","Type the user name and password of a privileged database user (for example, privuser). This login should have administrative rights on the database.","Enter the connection details for the database.","For an Oracle Database, enter the host address, host port, and database/instance name specific to your installation. The Port field displays the default port for the database type you selected.","For an Oracle Autonomous Database, enter the location of the unzipped wallet file and the service name.","For a Microsoft SQL Server Database, enter the host address, host port, and database/instance name specific to your installation. The Port field displays the default port for the database type you selected.","Click Next.","On the Private Database Logins dialog box:","Click Add.","Enter a user name.","Enter a password.","Note To reverse a change, click Undo. Undo will reverse any changes made during the current session.","Click Save.","Click OK to exit.","Adding Private Database Logins for P6 EPPM","46566.htm");
Page[20]=new Array("You can update the passwords and usernames of the private database users on your P6 EPPM database. ","To modify private database logins:","Go to P6 EPPM &lt;release_level&gt;\\database and run databaselogins.bat (with Windows) databaselogins.sh (with UNIX or Linux).","On the Database Connection dialog box:","Select the database.","Type the user name and password of a privileged database user (for example, privuser). This login should have administrative rights on the database.","Enter the connection details for the database.","For an Oracle Database, enter the host address, host port, and database/instance name specific to your installation. The Port field displays the default port for the database type you selected.","For an Oracle Autonomous Database, enter the location of the unzipped wallet file and the service name.","For a Microsoft SQL Server Database, enter the host address, host port, and database/instance name specific to your installation. The Port field displays the default port for the database type you selected.","Click Next.","On the Private Database Logins dialog box:","Select the private database user name that you wish to modify.","Enter a new user name.","Highlight the password, and change it.","Click the Update Password button.","Note To reverse a change, click Undo. Undo will reverse any changes made during the current session.","Click Save.","Click OK to exit the Database Logins tool.","Modifying Private Database Logins for P6 EPPM","46565.htm");
Page[21]=new Array("If you no longer need your private database users you can delete them. ","To delete private database logins for P6 EPPM:","Go to P6 EPPM &lt;release_level&gt;\\database and run databaselogins.bat (with Windows) databaselogins.sh (with UNIX or Linux).","On the Database Connection dialog box:","Select the database.","Type the user name and password of a privileged database user (for example, privuser). This login should have administrative rights on the database.","Enter the connection details for the database.","For an Oracle Database, enter the host address, host port, and database/instance name specific to your installation. The Port field displays the default port for the database type you selected.","For an Oracle Autonomous Database, enter the location of the unzipped wallet file and the service name.","For a Microsoft SQL Server Database, enter the host address, host port, and database/instance name specific to your installation. The Port field displays the default port for the database type you selected.","Click Next.","On the Private Database Logins dialog box:","Select the private database user name that you wish to remove.","NoteYou must have at least one private user name for the P6 EPPM database at all times.","Click Delete.","Note To reverse a change, click Undo. Undo will reverse any changes made during the current session.","Click Save.","Click OK to exit the Database Logins tool.","Deleting Private Database Logins for P6 EPPM","46567.htm");
Page[22]=new Array("You can download the media pack that contains the installer and all required install files from the Oracle Software Delivery Cloud website at https://edelivery.oracle.com.","Run setup.exe in the Primavera P6 Enterprise Project Portfolio Management physical media or download to install the following P6 EPPM applications:","Note","You do not have to install all applications; you can pick and choose what you install. However, you must install P6 to run the other P6 EPPM applications.","P6 Team Member (includes P6 Team Member Web and Email Statusing Service)","Note","You will need to configure Email Statusing Service separately. The installation wizard will provide the Email Statusing Service files and you will use the config.properties file to set up this service. See the P6 EPPM System Administration Guide.","P6 mobile supports SSL (https) only when it has a certificate signed by a valid authority.","P6 EPPM Web Services","P6 Professional Cloud Connect ","Select the P6 Professional Cloud Connect install option if you plan to use P6 Professional with an P6 EPPM Oracle or Oracle Autonomous Database database on the cloud by connecting to a remote service. The wizard sets up a remote method of access to connect to the EPPM database and the P6 APIs. For more details on establishing the P6 Professional Cloud Connect database connection in P6 Professional, see the P6 Professional Installation and Configuration Guide (P6 EPPM). ","Note The wizard will also install P6 Integration API (in remote mode) by default.","P6 Integration API (remote mode only)","Note Oracle provides a separate installer for P6 Integration API local mode. See the P6 Integration API Configuration Guide.","P6 mobile","Note","P6 mobile apps are downloaded through the Apple App Store or the Google Play Store. See the P6 Team Member User's Guide.","P6 mobile supports SSL (https) only when it has a certificate signed by a valid authority.","Based on whether you are installing or upgrading, see one of the following books:","P6 EPPM Installation and Configuration Guide","P6 EPPM Upgrade and Configuration Guide","Installing P6 EPPM Applications","53137.htm");
var PageCount=23;


/*
Date: 12/8/2025 10:25 AM
Source: EPPM_25_dev
BookID: 50759
PubProduct: PRIMAVERA_EPPM
BookTitle: Manual Installation Guide (Oracle Database) for On-Premises
Version: Version 25
Lang:	en
*/
	var PageLength=Page.length;
	var Result = "";
	var ResultTemp = "";
	var ResultFound = "";
	var ResultTitleOnly = [];
	var ResultTitleAndContent = [];
	var ResultInContent = [];
	var ResultInContentTemp = [];

	var ResultCombinedTemp = [];
	var ResultCombined = [];

	var arrayIndex = 0;
	var NrRes = 0;
	var j = 0;
	var i = 0;
	var k = 0;
	var d = 0;
	var maxItems = 1000;
	var heading = 0;
	var WordPos = -1;
	var WordPosHeading = -1;
	var WordPosContentText = -1;
	var FoundWord = "";
	var FoundWordHead = "";
	var SearchInHeadingOnly = 0;
	var isChecked;
	var size = 10;
	var resGroupCounter = 0;
	var shown = "shown";
	var checkBoxInHeading;
	var searchFlag = 0;
	var DivResult;
	var SearchWord;

if (SearchText && SearchText.length >= 1) {
		SearchWord = SearchText.replace(/\+/g, " ").replace(/&/g, "&amp;").replace(/</g, "&lt;").replace(/>/g, "&gt;").replace(/"/g, "&quot;");
		searchFlag = 1;
	} else {
		SearchWord = "";
		searchFlag = 0;
	}
	

	if (searchFlag === 1) {
		Result = "";

		// checkBoxInHeading = document.getElementById("inHeading");
		if (inHeading) {

			isChecked = true;
		} else {

			isChecked = false;
		}

		if (SearchWord && SearchWord.length >= 1) {
			if (isChecked) {
				SearchInHeadingOnly = 1;
			} else {
				SearchInHeadingOnly = 0;
			}
			SearchWord = SearchWord.toLowerCase();
			window.status = "Searching, please wait...";
			for (j = 0; j < PageLength; j++) {
				k = Page[j].length - 1;
				for (i = 0; i < k; i++) {

					heading = k - 1;

					if (SearchInHeadingOnly === 1) {
						WordPosHeading = Page[j][heading].toLowerCase().indexOf(SearchWord);
						if (WordPosHeading > -1) {
							FoundWordHead = Page[j][heading].substr(WordPosHeading, SearchWord.length);

							NrRes++;
							ResultTemp = "<li>";
							ResultTemp += "<span>";
							ResultTemp += "<a href='" + Page[j][k] + "'>" + Page[j][heading].replace(FoundWordHead, FoundWordHead.bold()) + "</a><br/>\n";

							ResultTemp += "</span>";
							ResultTemp += "</li>";

							ResultTitleOnly[arrayIndex] = ResultTemp;
							arrayIndex++;

							ResultTemp = "";
							WordPosHeading = -1;
							WordPosContentText = -1;
							break;
						}
					} else if (SearchInHeadingOnly === 0) {
						WordPos = Page[j][i].toLowerCase().indexOf(SearchWord);
						WordPosHeading = Page[j][heading].toLowerCase().indexOf(SearchWord);
						if (WordPos > -1) {
							FoundWordHead = Page[j][heading].substr(WordPosHeading, SearchWord.length);
							FoundWord = Page[j][i].substr(WordPos, SearchWord.length);
							FoundWord = Page[j][i].substr(WordPos, SearchWord.length);
							NrRes++;
							ResultTemp += "<li>";
							ResultTemp += "<span>";
							if (WordPosHeading > -1) {
								ResultTemp += "<a href='" + Page[j][k] + "'>" + Page[j][heading].replace(FoundWordHead, FoundWordHead.bold()) + "</a><br/>\n";
							} else {
								// found word is not in the head
								ResultTemp += "<a href='" + Page[j][k] + "'>" + Page[j][heading] + "</a><br/>\n";

							}
							if (i < k - 1) {
								WordPosContentText = Page[j][i].toLowerCase().indexOf(SearchWord);

								if (Page[j][i].length > 300 && (WordPosContentText > -1)) {

									if (WordPosContentText > 75) {
										ResultInContentTemp.push("..." + Page[j][i].substr(WordPosContentText - 75, 175 + FoundWord.length).replace(FoundWord, FoundWord.bold()) + "...");
									} else {
										ResultInContentTemp.push("..." + Page[j][i].substr(0, 175 + FoundWord.length).replace(FoundWord, FoundWord.bold()) + "...");

									}

								} else if (WordPosContentText > -1) {

									ResultInContentTemp.push(Page[j][i].replace(FoundWord, FoundWord.bold()));

								}
							}

							ResultTemp += ResultInContentTemp.join("");

							ResultTemp += "</span>";
							ResultTemp += "</li>";

							if (WordPosHeading > -1) {
								ResultTitleAndContent[arrayIndex] = ResultTemp;
								arrayIndex++;
							} else {
								ResultInContent[arrayIndex] = ResultTemp;
								arrayIndex++;
							}

							ResultInContentTemp.length = 0;
							ResultTemp = "";
							WordPosHeading = -1;
							WordPosContentText = -1;
							break;
						}

					}
				}
			}

			ResultTitleOnly = ResultTitleOnly.filter(function (n) {
				return (n !== undefined && n !== null);
			});
			ResultTitleAndContent = ResultTitleAndContent.filter(function (n) {
				return (n !== undefined && n !== null);
			});
			ResultInContent = ResultInContent.filter(function (n) {
				return (n !== undefined && n !== null);
			});

			ResultCombinedTemp = ResultTitleOnly.concat(ResultTitleAndContent, ResultInContent);

			ResultCombinedTemp = ResultCombinedTemp.filter(function (n) {
				return (n !== undefined && n !== null);
			});

			for (d = 0; d < ResultCombinedTemp.length; d += size) {
				resGroupCounter++
				ResultCombined.push("<div id=" + "'" + "resGroup_" + resGroupCounter + "'" + " class=" + "'" + "resGroup " + shown + "'" + ">" + "<ol class='searchResults'>" + ResultCombinedTemp.slice(d, d + size).join("") + "</ol></div>");
				shown = "notshown";
			}

			ResultFound = ResultCombined.join("");

Result += "<div id='searchDetailsDiv'>";
			Result += "<p class='searchDetails'>Your Search Found&nbsp;" + NrRes + "&nbsp;items.&nbsp;";
			Result += "</p></div>";
			
			Result += "<div class='searchResultsDiv'>";
			Result += "<div id='resultsCollection' class='searchResults'>";
			Result += ResultFound;
			Result += "</div>";
			Result += "</div>";
			Result += "<div class='searchPaging'>";

			Result += '<hr />';

			Result += '<p class="bodytext"><a class="disabledAnchor" id="pBack" onclick="turnPage(\'backPage\')" href="#pBack">Back</a>&nbsp; | &nbsp;';
			
			if (resGroupCounter && resGroupCounter > 1) {
				Result += '<a id="pNext" onclick="turnPage(\'nextPage\')" href="#pNext">Next</a>';
			} else {
				Result += '<a id="pNext"  class="disabledAnchor" href="#pNext">Next</a>';
			}
			Result += '</p>\n';
			Result += '<div id="pagenofn"><p class="bodytext">Page <span id="pagen">1</span> of ' + resGroupCounter + '</p></div>';

			Result += "</div>";
			
			
		}

		DivResult = document.getElementById("s_anchor");
		if (Result && DivResult) {

			//myDivResult.append(Result);
			DivResult.innerHTML = Result;
			

		}
		window.status = "";
		
		

	}
	}())
}
