'use strict';
function search(SearchText, inHeading) {
(function () {
var Page = [];

/* Generated with Author-it 23.4.1.30004  12/11/2025 7:37:43 PM */
Page[0]=new Array("Title and Copyright Information","Copyright  1999, 2025, Oracle and/or its affiliates.","Primary Author: Oracle Corporation","Title and Copyright Information","46576.htm");
Page[1]=new Array("Scope","This guide describes how to automatically install and configure your applications. Before you begin, read the Prerequisites for P6 EPPM Configuration.","Installing P6 EPPM","You can download the media pack that contains the installer and all required install files from the Oracle Software Delivery Cloud website at https://edelivery.oracle.com.","You will use the setup.exe (for Windows) or ./runinstaller (for Linux or UNIX) in the Primavera P6 Enterprise Project Portfolio Management physical media, or download to install the following P6 EPPM applications:","Note You do not have to install all applications. However, you must install P6 to run the other P6 EPPM applications.","P6 (and its help and tutorials)","P6 Team Member Interfaces (includes P6 Team Member Web, Email Statusing Service, and the server-side components for P6 mobile)","Note","You need to configure Email Statusing Service separately. See the P6 EPPM System Administration Guide.","P6 for iOS supports SSL (https) or HTTP only when it has a certificate signed by a trusted authority.","P6 for Android requires SSL (https) when you are not using SSO authentication. If you are using SSO authentication, you can use HTTP or HTTPs protocols. HTTPS requires a valid certificate from an Android trusted certifying authority.","P6 Professional Cloud Connect","Select the P6 Professional Cloud Connect install option if you plan to use P6 Professional with an EPPM Oracle or Oracle Autonomous Database by connecting to a remote service. The wizard sets up a remote method of access to connect to the EPPM database and the P6 APIs. For more details on establishing the P6 Professional Cloud Connect database connection in P6 Professional, see the P6 Professional Installation and Configuration Guide (P6 EPPM). ","Note","When you install P6 Professional Cloud Connect, the wizard also installs the P6 Integration API (in remote mode) by default. ","P6 Professional Cloud Connect does not support Microsoft SQL Server database.","P6 Integration API","Note The wizard installs the remote P6 Integration API. If you want to use the local-mode P6 Integration API, see the P6 EPPM Integration API Configuration Guide.","P6 EPPM Web Services","Configuring P6 EPPM","Use the P6 EPPM Configuration Wizard to configure P6 EPPM. The P6 EPPM Configuration Wizard creates a P6 configuration in Primavera P6 Administrator and configures supporting technology, including:","A connection to an Oracle, Oracle Autonomous Database, or Microsoft SQL Server database","A WebLogic domain","Connections to optional enabling technologies, such as a content repository (Oracle Webcenter Content Core Capabilities (WCCC), Microsoft SharePoint, or CMIS-compliant repositories), reporting software, and or BPM","By default, the P6 EPPM Configuration Wizard runs automatically after you install your P6 EPPM applications. If you need to manually launch the P6 EPPM Configuration Wizard, use eppmconfig.cmd (for Windows) or eppmconfig.sh (for Linux) from the P6 EPPM installation folder at C:\\P6EPPM_1\\p6 (for Windows) or /u01/P6EPPM_1/p6 (for Unix).","After you use the P6 EPPM Configuration Wizard, use Primavera P6 Administrator to configure P6 EPPM administration settings. For more information about Primavera P6 Administrator, see the P6 EPPM System Administration Guide.","Audience","System administrators should use this guide.","Using this Guide","This guide assumes you have already installed a supported version of WebLogic and a JDK. For more information, see the Tested Configurations document.","About This Guide","53678.htm");
Page[2]=new Array("Review and complete the prerequisites before configuring any P6 EPPM applications.","Prerequisites for P6 EPPM Configuration","12885.htm");
Page[3]=new Array("Installing the entire P6 EPPM suite requires 1GB of hard disk space. Configuring the WebLogic domain requires 1.75 GB of hard disk space as well as 4 GB of available system memory.","Note These numbers do not include the space required by the database, which is dependent on the configuration. ","Minimum Hard Disk Space","55350.htm");
Page[4]=new Array("WebLogic Server requires that you have a Java Development Kit (JDK) installed on your machine. You must manually download and install the required JDK. For a list of supported JDK versions for P6 EPPM, see the Tested Configurations document. As new releases of the software become available, you can find them at http://www.oracle.com/technetwork/java/archive-139210.html.","JDK Installation","35523.htm");
Page[5]=new Array("After installing the JDK, you must set environment variables to ensure the P6 EPPM installation scripts can locate your Java libraries","To set Java environment variables:","JAVA_HOME","PATH","Setting the Environment Variables in Microsoft Windows","To set the JAVA_HOME and PATH environment variables in Microsoft Windows:","Click Start, Control Panel, System, and then Advanced system settings.","In the System Properties dialog box, on the Advanced tab, click Environment Variables.","Add the JAVA_HOME environment variable:","In the System Variables section, click New.","In the Variable name field, enter JAVA_HOME.","In the Variable value field, enter the location where the JDK software is installed (for example, C:\\Program Files\\Java\\&lt;java_version&gt;)","Click OK.","Update the PATH environment variable to include the location of the Java executable files:","In the System Variables section, select the PATH variable, and click Edit.","In the Variable value field, insert %JAVA_HOME%\\bin; in front of all the existing directories. Do not delete any existing entries; otherwise, some existing applications may not run.","Click OK.","Exit the Control Panel.","Setting the Environment Variables with Unix or Linux","To set the JAVA_HOME and PATH environment variables with Unix or Linux:","Set the JAVA_HOME environment variable by typing the following command:","export JAVA_HOME=&lt;JDK_installation_path&gt;","Set the PATH environment variable by typing the following command:","export PATH=$PATH:$JAVA_HOME/bin","Setting an Environment Variable for Java","89522.htm");
Page[6]=new Array("You will need to install WebLogic to deploy P6 EPPM. For supported versions, see the Tested Configurations document. For more information about how to install WebLogic, see http://www.oracle.com/technetwork/middleware/weblogic/documentation/index.html","Note Oracle recommends that you install Oracle Access Manager on a new WebLogic Middleware home.","If existing Middleware applications are installed into the Middleware home (for example, Identity Management), Access Manager will fail to deploy.","Tip","After you finish installing WebLogic, ensure you can run the startNodeManager.cmd (with Windows) or startNodeManager.sh (with UNIX or Linux) before installing P6 EPPM. If you cannot run this file, contact your WebLogic administrator for help.","Installing WebLogic","35520.htm");
Page[7]=new Array("You can use Oracle, Microsoft SQL Server, or Oracle Autonomous Database on your database server for P6 EPPM deployments. For more information about supported database versions, refer to Tested Configurations. You must install the database server before you can create the P6 EPPM database.","If you are using an Oracle or Oracle Autonomous Database, you must make sure to create a database with the Oracle Text option enabled. Oracle Text supports the Oracle or Oracle Autonomous Database content repository by using standard SQL to index, search, and analyze text and documents stored in the database, in files, and on the web. For more details, refer to the Oracle or Oracle Autonomous Database documentation.","If you are using a Microsoft SQL Server Database, you must make sure that you enable FILESTREAM before attempting your P6 EPPM installation or upgrade. For information about how to enable FILESTREAM, refer to the Microsoft SQL Server documentation for your version.","Note","If you attempt to create a database using an Oracle database, the option to create a container database is enabled by default. If you do not want to create a container database, clear the Create As Container Database option during the database creation process. If you create a container database, you must also create a pluggable database on which to install your P6 EPPM instance.","Oracle Text is enabled by default.","jobsvc.job_data_x is used to store XML data for XML import processes using the Varbinary(Max) datatype. In order to support the Varbinary(Max) datatype, you must enable FILESTREAM.","A SQL database name must not contain a space.","Installing a Database","61564.htm");
Page[8]=new Array("For an Oracle Autonomous Database, you will need to download the Client Credentials Wallet file. For more information, about accessing and downloading the Wallet, see Oracle Cloud Infrastructure documentation.","Unzip the file to a suitable location on your local machine for example, C:/OracleWallet.","Preparing the Wallet for Oracle Autonomous Databases","102514.htm");
Page[9]=new Array("Before installing P6 EPPM, you must complete the following steps to grant required privileges to your database SYSTEM user.","To grant privileges to the SYSTEM user:","Navigate to the following location, open the designated script in a text editor, and modify the schema user reference to match your actual schema user name:","\\scripts\\install\\PM_&lt;release level&gt;\\manual_script_before_install.sql","You must apply grant options to the SYSTEM schema user or a custom user associated with the Oracle DBA role. If you plan to use a custom schema user (other than SYSTEM) to run steps which require a DBA role, then you must update the references to SYSTEM in the script with the new custom schema user associated with the DBA role.","From the command line, run the following and provide the password when prompted: sqlplus sys@&lt;db_tns_names_entry&gt; as sysdba","Go to p6suite\\database\\scripts\\install\\PM_&lt;release_level&gt;, and run manual_script_before_install.sql.","This script grants SELECT and EXECUTE privileges with grant option to SYSTEM, or a custom DBA username if you prefer to use one, for the following sys objects:","SELECT","sys.DBA_VIEWS","sys.V_$TRANSACTION","sys.GV_$TRANSACTION","EXECUTE","sys.DBMS_REPUTIL","sys.DBMS_LOB","sys.DBMS_SQL","sys.DBMS_JOB","sys.DBMS_RANDOM","Note For more information about the listed sys objects, refer to the Oracle Database documentation.","Grant Privileges to the SYSTEM User","85043.htm");
Page[10]=new Array("The Content Repository allows users to collaboratively share and manage documents in P6. For P6 EPPM users to utilize the enhanced document management functionality, you must install Oracle Webcenter Content Core Capabilities (WCCC), Microsoft SharePoint, Oracle Database, or a CMIS-compliant content repository. Refer to the documentation included with those applications for installation instructions.","Note P6 supports clustering of the Content Repository only when using WebLogic for the application server.","If you plan to use the P6 EPPM Configuration Wizard to connect P6 EPPM to your content repository, see the P6 EPPM Content Repository Configuration Guide for more information about any prerequisites that you may need to complete in your content repository. ","For more information about installing and configuring a content repository for P6 EPPM, refer to the P6 EPPM Content Repository Configuration Guide.","Content Repository Installation and Configuration","12888.htm");
Page[11]=new Array("Consult Oracle Analytics Publisher documentation for installation instructions. For complete overview information about Oracle Analytics Publisher, go to the following web site: https://www.oracle.com/business-analytics/.","Oracle Analytics Publisher Installation","52005.htm");
Page[12]=new Array("The Workflows Repository helps users to keep track of project initiations in P6. For P6 users to utilize the project initiation functionality, you must install the supported Workflows Repository application, BPM. Refer to the documentation included with the Oracle BPM application for installation instructions.","Note BPM is not yet supported for Oracle Autonomous Database.","Workflows Repository Installation","12889.htm");
Page[13]=new Array("If you are using BPM, you must install the Oracle MDS schema using the Repository Creation Unit (RCU) on a separate database instance. See the Tested Configurations document for supported versions.","Installing the Oracle MDS Schema for BPM","79585.htm");
Page[14]=new Array("To configure BPM with P6:","Create a new directory on the host where P6 is running. For example, P6BPMConnector/P6 and P6BPMConnector/BPM.","In the P6 media pack Tools\\BPM Connector\\12c subfolder, locate the following file:","prm-bpm-connector-12c-v2.0.jar","Copy the connector file listed above to the P6BPMConnector/P6 folder you created. Determine the location of the BPM installation that you are using to integrate with P6. If you have multiple SOA Suite installations, ensure that you determine the location of the specific installation that you are integrating with P6.","Copy the following folders and their contents from your BPM installation to the P6BPMConnector/BPM folder you created.&nbsp;Their default locations are listed:","&lt;ORA_HOME&gt;\\soa\\soa\\modules\\oracle.bpm.client_11.1.1 ","&lt;ORA_HOME&gt;\\soa\\soa\\modules\\oracle.bpm.project_11.1.1 ","&lt;ORA_HOME&gt;\\soa\\soa\\modules\\oracle.bpm.runtime_11.1.1 ","Copy all the supporting jars from the BPM installation that you are using to integrate with P6 to the P6BPMConnector/BPM folder you created.&nbsp;Their default locations are listed:","&lt;Oracle_Home&gt;\\soa\\soa\\modules\\oracle.soa.fabric_11.x.x\\bpm-infra.jar","&lt;Oracle_Home&gt;\\soa\\soa\\modules\\oracle.soa.workflow_11.x.x\\bpm-services.jar","&lt;Oracle_Home&gt;\\soa\\soa\\modules\\oracle.soa.fabric_11.x.x\\fabric-runtime.jar","&lt;Oracle_Home&gt;\\oracle_common\\modules\\oracle.jmx_12.x.x\\jmxframework.jar","&lt;Oracle_Home&gt;\\oracle_common\\modules\\oracle.jmx_12.x.x\\jmxspi.jar","&lt;Oracle_Home&gt;\\soa\\bpm\\modules\\oracle.bpm.mgmt_11.x.x\\oracle.bpm.bpmn-em-tools.jar","&lt;Oracle_Home&gt;\\soa\\soa\\modules\\oracle.soa.mgmt_11.x.x\\soa-infra-mgmt.jar","&lt;Oracle_Home&gt;\\wlserver\\server\\lib\\wlclient.jar","&lt;Oracle_Home&gt;\\oracle_common\\modules\\oracle.xdk_12.x.x\\xml.jar","&lt;Oracle_Home&gt;\\oracle_common\\modules\\oracle.xdk_12.x.x\\xmlparserv2.jar","&lt;Oracle_Home&gt;\\soa\\soa\\modules\\oracle.soa.fabric_11.x.x\\tracking-api.jar","&lt;Oracle_Home&gt;\\soa\\soa\\modules\\oracle.rules_11.x.x\\rulesdk2.jar","Note","The jar files must be from the same BPM installation that will be integrated with P6.","Modifying the P6 Environment for BPM","89467.htm");
Page[15]=new Array("IAIK-JCE is a third-party Java Cryptography library that may be used as an alternative to the Java Cryptography Extension functions included in the Oracle/Sun JRE. If your organization requires it, you can choose to use IAIK-JCE libraries while storing/transmitting sensitive information (for example, passwords) in P6 EPPM.","To allow the P6 EPPM installer to recognize and install IAIK-JCE, you must modify your existing java.security settings and copy the iaik_jce.jar file to the correct location in &lt;Java_Home&gt;.","To prepare IAIK-JCE for installation:","Navigate to the following URL: ","http://jce.iaik.tugraz.at/sic/Products/Core-Crypto-Toolkits/JCA_JCE","Download and extract iaik_jce.zip locally. See Tested Configurations for the supported versions of IAIK-JCE.","Navigate to the lib-signed folder and then copy iaik_jce.jar to &lt;Java_Home&gt;/jre/lib/ext.","Navigate to &lt;Java_Home&gt;/jre/lib/security and then add the following to java.security.","security.provider.11=iaik.security.provider.IAIK","Note If the number '11' is being used by another entry, use the next available number.","Save and close the file.","Complete the instructions in the following topic:","Setting an Environment Variable for IAIK-JCE","Installing IAIK-JCE","89631.htm");
Page[16]=new Array("Setting the Environment Variables in Microsoft Windows","To set the JAVA_TOOL_OPTIONS environment variables in Microsoft Windows:","Click Start, Control Panel, System, and then Advanced system settings.","In the System Properties dialog box, on the Advanced tab, click Environment Variables.","Add the JAVA_TOOL_OPTIONS environment variable:","In the System Variables section, click New.","In the Variable name field, type JAVA_TOOL_OPTIONS.","In the Variable value field, type the following:","-Dprimavera.encryptor.provider=&quot;IAIK&quot;","Click OK.","Exit the Control Panel.","Setting the Environment Variables with Unix or Linux","To set the JAVA_TOOL_OPTIONS environment variables with Unix or Linux:","Set the JAVA_TOOL_OPTIONS environment variable by typing the following command:","export JAVA_TOOL_OPTIONS=-Dprimavera.encryptor.provider=&quot;IAIK&quot;","Setting an Environment Variable for IAIK-JCE","89629.htm");
Page[17]=new Array("Before you run the installation wizard, ensure that you have read the Prerequisites for P6 EPPM Configuration. ","You can install the following with the installation wizard:","P6","P6 Professional Cloud Connect (to connect to an EPPM Oracle or Oracle Autonomous Database and P6 APIs using a remote method of access)","Note When you choose to install Cloud Connect, the wizard will also install P6 Integration API (in remote mode) by default.","P6 Integration API (remote mode only)","P6 EPPM Web Services","P6 Team Member (includes P6 Team Member Web and Email Statusing Service)","Once you have completed your installation, the P6 EPPM Configuration Wizard will appear. When the configuration wizard appears, you will have the choice to configure your database, WebLogic server, and extra application settings.","About the P6 EPPM Installation Wizard","53044.htm");
Page[18]=new Array("You can download the media pack that contains the installer and all required install files from the Oracle Software Delivery Cloud website at https://edelivery.oracle.com.","To install the P6 EPPM applications:","Download the Primavera P6 Enterprise Project Portfolio Management &lt;release_level&gt; for &lt;platform&gt; folder and extract the contents.","Go to the location where you extracted the contents, and run one of the following:","If you are installing with Windows, navigate to the P6_R&lt;release_level&gt;\\Disk1\\install folder and double-click setup.exe.","If you are installing with UNIX or Linux, enter the following command:","cd P6_R&lt;release_level&gt;/Disk1/install","chmod 755 runInstaller","chmod 755 unzip","./runInstaller","On the Welcome screen, click Next.","Note Click Next on each wizard screen to advance to the next step.","On the Specify Home Details screen, complete the following: ","In the Name field, enter a name for the installation. ","In the Path field, enter the desired location of the P6 EPPM home folder (for example, C:\\P6EPPM_1).","On the Available Product Components&nbsp;screen, select each component you want to install. Alternatively, if you are reinstalling your P6 EPPM applications for an upgrade, select the components that have Reinstall as the value in the Install Status column.","If you are installing P6, select P6.","Note You can choose Select All if you want to install all P6 EPPM applications.","If you are connecting P6 Professional with a P6 EPPM Oracle or Oracle Autonomous Database and would like to compress your data for cloud or enterprise WAN connections, select P6 Professional Cloud Connect. This installation component is applicable to only Oracle or Oracle Autonomous Database users and is optional. The wizard will also install P6 Integration API (in remote mode) by default.","Note After running the P6 EPPM Configuration wizard, the Configuration Complete screen will display the default URL generated for P6 Professional Cloud Connect. This URL (case-sensitive) must be provided to P6 Professional users to enable them to set up and configure a new database connection to the P6 Professional Cloud Connect server in the P6 Professional database configuration utility.","For more details on establishing the P6 Professional Cloud Connect database connection in P6 Professional, see the P6 Professional Installation and Configuration Guide (P6 EPPM). ","If you are installing P6 Integration API, select P6 Integration API.","Note","The wizard will install the remote version of P6 Integration API.","If you need to install the local version of P6 Integration API or want to install the client-side packages (which include libraries and documentation for remote mode), see Installing Local-mode P6 Integration API and the P6 EPPM and P6 Professional Integration API Programming Guide.","If you are installing P6 EPPM Web Services, select P6 Web Services. The wizard will also install the demo applications for P6 EPPM Web Services.","If you are installing P6 Team Member, select P6 Team Member. This will install the files necessary for P6 Team Member Web, Email Statusing Service, and the server components for P6 mobile.","Note","If you want to use Email Statusing Service, see the P6 EPPM System Administration Guide when you have completed installing and configuring your other applications.","P6 for iOS supports SSL (HTTPS) or HTTP only when it has a certificate signed by a trusted authority.","P6 for Android requires SSL (HTTPS) when you are not using SSO authentication. If you are using SSO authentication, you can use HTTP or HTTPS protocols. HTTPS requires a valid certificate from an Android trusted certifying authority.","On the Specify JDK Home&nbsp;screen, enter or browse to the location where JDK is installed.","On the Summary screen:","Verify that all of the components that you want to install are listed.","Click Install.","On the End of Installation screen, click Exit.","Note The P6 EPPM Configuration Wizard will appear if the installation was successful.","In the Exit dialog box, click Yes.","If you want to use the P6 EPPM Configuration Wizard to configure your P6 EPPM, WebLogic, and other applications, continue to About the P6 EPPM Configuration Wizard.","If you want to configure your applications manually, click Cancel to exit the configuration wizard. See Where to Go From Here - Pre Configuration Wizard to see what guides you will need to configure your applications manually.","Installing P6 EPPM Applications","51961.htm");
Page[19]=new Array("Before installing the local-mode P6 Integration API, you need to install P6 EPPM. Additionally, you must uninstall any earlier versions of the local P6 Integration API before installing the current version.","The local-mode P6 Integration API Installer provides a wizard to guide you through the installation process, which includes:","Choosing the installation mode","Installing the P6 Integration API libraries","Setting up and configuring the P6 Integration API database","To install local-mode P6 Integration API:","Download the P6 Integration API part from the P6 EPPM media pack and then extract it.","Depending on your operating system, change your directory to the media pack part by running one of the following:","With Windows, navigate to the win\\Disk1\\install directory and double-click setup.exe.","With UNIX or Linux, do the following:","Change your directory using the following command: ","cd &lt;Operating_System&gt;\\Disk1\\install","where &lt;Operating_System&gt; is linux64.","Enter the following commands:","chmod 755 runInstaller","chmod 755 unzip","./runInstaller","Click Next.","On the Welcome screen, click Next.","On the Select the Installation Type screen, specify the installation mode.","Local Mode Packages Only: Choose this option to use the P6 Integration API in local mode, without Java RMI. <br />This option installs database configuration tools and javadoc.","Client Side Packages Only: Choose this option to install client-side libraries and documentation. This option is required for the remote API.","Note","The maximum number of clients that can access a remote server at one time is approximately 50. This number might be less, depending on multiple factors (for example, system hardware, network configuration, and so on)","When using the P6 Integration API in Remote Mode with the client and server in different time zones, the time of day fields in the client are based on the local time by default (not the server time). If you want the times to match, you can first set the time zone in your client code to be the same as the server time zone for each thread that calls P6 Integration API code.","In the Specify Home Details screen:","In the Name field, enter a name for the P6 Integration API.","In the Path field, specify the installation location for the P6 Integration API files.","Click Next.","In the Available Product Components screen, select the components to install and click Next.","In the JDK Home Directory&nbsp;screen, enter or browse to the location where JDK is installed.","In the Summary&nbsp;screen, click Install.","Note","If you installed the local mode package, the Configuration Assistants&nbsp;screen appears after the installation finishes. Do not close this screen. After a short time, the Database Configuration dialog box opens.","If you installed the client side package, your installation is complete. You can exit the wizard now and skip the remaining steps in this section.","In the Database Configuration dialog box:","Choose the database type: Oracle, Oracle Autonomous Database, or Microsoft SQL Server.","Note You can later change the database type through the P6 Integration API Database Configuration Setup wizard.","Click Next.","Specify the database connection parameters.","Click Next.","Note The P6 Integration API requires pubuser&nbsp;access (in the User Name field) to the database. The database name, host address, and host port are specific to your Oracle or Microsoft SQL Server installation. Database Host Port displays the default port for the database type you selected. You can edit this port. If you are using an Oracle Autonomous Database, you only need to specify the unzipped Wallet location and service name.","If the installer detects an existing configuration screen, choose the appropriate action.","Note","If your site includes P6, you can share a new P6 Integration API configuration with P6. However, P6 cannot share an existing configuration with P6 Integration API because it will not support the new P6 Integration API configuration settings.","If a configuration does not exist, the The installer has detected an existing. . .&nbsp;screen does not appear and the installation process automatically creates a default configuration named Primavera Configuration. You can edit the settings for this configuration through the Primavera P6 Administrator.","After installation, you can use the Database Configuration Setup wizard to choose or create a different configuration.","See the P6 EPPM System Administration Guide for more information about configurations.","When the message displays to confirm the database configuration has completed successfully, click OK.","Click Exit.","Installing Local-mode P6 Integration API","93144.htm");
Page[20]=new Array("The configuration process provides you with several options to configure your applications to work with P6 EPPM. The following sections describe your options.","Where to Go From Here - Pre Configuration Wizard","53089.htm");
Page[21]=new Array("Oracle recommends you use the P6 EPPM Configuration Wizard to configure P6 EPPM, its applications, and WebLogic. With this option, you can install or upgrade your database, deploy your P6 EPPM applications in WebLogic, and configure a content repository, reporting software, and BPM to work with P6. Continue to About the P6 EPPM Configuration Wizard to use this option.","Using the P6 EPPM Configuration Wizard To Configure P6 EPPM","53140.htm");
Page[22]=new Array("Database","You can manually install or upgrade your database. If you want to install or upgrade your database manually, you can still use the wizard to deploy your P6 EPPM applications in WebLogic and configure a content repository, reporting software, and BPM to work with P6. ","If you want to install or upgrade your database manually, see the P6 EPPM Installation and Configuration Guide for your database.","P6 EPPM Applications","You can manually deploy your P6 EPPM applications in WebLogic. Depending on which applications you are using, use the following:","P6 Server Configuration Guide","WebLogic Configuration Guide","Additional Applications","You can also use the Primavera P6 Administrator to connect additional applications to P6. Depending on your application, use the following:","P6 EPPM Oracle Analytics Publisher Configuration Guide","P6 EPPM BPM Configuration Guide","P6 EPPM Content Repository Configuration Guide","P6 EPPM Oracle Identity Manager Configuration Guide","Primavera Oracle Access Manager Configuration Guide","Primavera Oracle Enterprise Manager Configuration Guide","Manually Configuring Your Applications","53141.htm");
Page[23]=new Array("The P6 EPPM Configuration Wizard will allow you to:","Install or upgrade your database.","Deploy your P6 EPPM applications in WebLogic and setup managed servers.","Configure your P6 reporting software, BPM, and your content repository (WCCC, Microsoft SharePoint, Oracle Database, or CMIS) with P6.","Use the P6 EPPM Configuration Wizard to configure your suite. Before running the configuration wizard, consider the following:","You must be on an Oracle, Oracle Autonomous Database, or Microsoft SQL Server.","You must have a JDK installed. See the Tested Configurations document for information on supported versions.","Note To launch the P6 EPPM Configuration Wizard manually, use eppmconfig.cmd (for Windows) eppmconfig.sh (for UNIX / Linux) from the P6 EPPM installation folder at &lt;P6 EPPM_home&gt;\\P6EPPM_1\\p6.","On the Welcome screen, click Next if you want to use the wizard to configure your suite. Click Cancel if you want to configure your applications manually.","About the P6 EPPM Configuration Wizard","51998.htm");
Page[24]=new Array("To use this wizard, you must either install or upgrade your database, or, already have the latest database installed. If you want to install or upgrade your database manually, leave the P6 EPPM Configuration Wizard open and go to the Manually Installing the P6 EPPM Database or Manually Upgrading the P6 EPPM Database guides. If you want to install or upgrade your database using the configuration wizard, continue to the next section.","Configuring Your Database","53046.htm");
Page[25]=new Array("On the Database Configuration screen:","Choose one of the following:","Select Create a new P6 EPPM database if you are creating a new database.","Select the Install Sample Projects&nbsp;option if you want to include sample project data in a non-production database. If you do not select the Install Sample Projects option, the P6 EPPM database loads empty data in a secure state and includes only the most basic information needed to run.","Select Upgrade an existing P6 EPPM database if you are upgrading your database.","Select Connect to an existing P6 EPPM &lt;release_level&gt; database if you already installed a database and want to configure your applications with it.","Click Next.","Using the Database Configuration Screen","53047.htm");
Page[26]=new Array("On the Database Type &amp; Connection screen:","For the Database Type option, choose one of the following:","Oracle","Oracle Autonomous Database (ATP)","Microsoft SQL Server","Enter the connection details for the database.","If your database is hosted on Oracle or Microsoft SQL:","In the Database Host Address&nbsp;field, enter the server machine name or IP address where you installed the database.","In the Database Host Port&nbsp;field, enter or verify the port number for your database. ","The default for Oracle is 1521.","The default for Microsoft SQL Server is 1433.","In the Database Name field, enter the name of your database.","For Oracle only, select SID (for example, orcl) or Service (for example, orcl.us.oracle.com) based on the database you installed.","In the Keystore Folder field, enter the location of the keystore. ","The P6 EPPM wizard automatically detects keystores located in the primary database folder.","If your database is hosted on Oracle Autonomous Database:","In the Database Wallet Location field, enter or browse to the location of the zipped Database Wallet.","On the Service list, select the service to use.","In the DBA Username field (when installing or upgrading) or Public Username field (when connecting to an upgraded database), enter or verify your user name.","The default username for Oracle is 'system'.","The default username for Oracle Autonomous Database is 'system'.","The default username for Microsoft SQL Server is 'sa'.","The default public username is 'pubuser'.","In the DBA Password field (when installing or upgrading) or Public Password field (when connecting to an upgraded database), enter the password to log in to the database.","Click Next.","Note The Configure Oracle Read Only User option is only intended for use with cloud installations.","Using the Database Type &amp; Connection Screen","53048.htm");
Page[27]=new Array("On the Create Keystore Screen:","Select the Create a New Keystore option","Note If there is no existing keystore and you do not want to create a new keystore, ensure all fields are clear and click Next to continue to the next screen.","In the Enter Keystore Password and Confirm Keystore Password fields enter the password for the new keystore.","Note","P6 EPPM does not support passwords with multi-byte characters.","Oracle recommends using strong passwords. Strong passwords in P6 EPPM contain between 8 and 20 characters and at least one numeric and one alpha character. To further strengthen the password, use a mixture of upper and lower case letters.","In the Existing Keystore Password field enter the password for the existing keystore.","Click Next.","Using the Create Keystore Screen","95928.htm");
Page[28]=new Array("On the Create Users screen:","In the Database Users section, specify the user names and passwords for these users:","Administrative (Oracle and Oracle Autonomous Database only) is the schema owner for all P6 EPPM data.","Privileged has read and write access to most P6 EPPM data.","Public has restricted access to the database.","Background (Oracle and Oracle Autonomous Database only) runs background processes.","Reporting is the PX Reporting user who owns tables and views for reporting data.","Roadmuser (Cloud only) is a read only administrative user.","Caution Use a unique name for all of your user names; do not use duplicate names. For example, do not enter privuser as the administrative user name or pubuser as your PX reporting user name. Repeating user names will cause conflicts.","Note","A red X will appear if the Password and Confirm Password fields do not match. A green check will appear when the two fields match.","P6 EPPM does not support passwords with multi-byte characters.","Oracle recommends using strong passwords. Strong passwords in P6 EPPM contain between 8 and 20 characters and at least one numeric and one alpha character. To further strengthen the password, use a mixture of upper and lower case letters.","Do not use special characters in the database name, privileged user, public user, or PX reporting user name, for example: { } [ ] : ; &lt; &gt; , . ? ! @ # $ % ^ &amp; * ( ) - _ | / \\ ~ `","In the Application User section, enter the P6 EPPM application administrative user name and password. By default, the application administrative user will receive Admin Superuser access rights to all applications.","Note","A red X will appear if the Password and Confirm Password fields do not match. A green check will appear when the two fields match.","Oracle recommends using strong passwords. Strong passwords in P6 EPPM contain between 8 and 20 characters and at least one numeric and one alpha character. To further strengthen the password, use a mixture of upper and lower case letters.","Click Next.","Using the Create Users Screen","53049.htm");
Page[29]=new Array("In this section, you will configure the P6 EPPM applications you installed with the installation wizard. The P6 EPPM Configuration Wizard will set up managed servers and deploy your P6 EPPM applications in the WebLogic domain that you installed.","Configuring Your WebLogic Server with P6 EPPM","53051.htm");
Page[30]=new Array("On the P6 Configuration Settings screen:","Do one of the following:","If a P6 configuration does not exist, in the Create a new configuration field, enter your new configuration name.","If you already created a configuration, choose it from the Use an existing configuration option, or create a new configuration.","Note","If you are upgrading from a previous version of P6 against the same database, choose the option to create a new configuration. This is necessary to accommodate new configuration settings. See the P6 EPPM System Administration Guide for more information about configurations and the Primavera P6 Administrator.","You can edit the settings for this configuration through the Primavera P6 Administrator.","Click Next.","Using the P6 Configuration Settings Screen","53050.htm");
Page[31]=new Array("You can modify the default values the P6 EPPM configuration wizard uses when configuring your WebLogic Server.","To customize the value of your P6 EPPM WebLogic domain properties:","Navigate to the folder in which P6 EPPM is installed, then navigate to the \\scripts folder.","Open domain.properties in a text editor of your choice.","Modify the values of the properties specified in the domain properties table below to modify the default domain properties used when configuring the WebLogic server.","Property","Description","Default Value","Example Value","p6_server","The name of the managed server on which the P6 application is deployed.","P6","p6WebServer","p6server_port","The port on which the P6 application server is hosted.","8203","4000","p6server_minmax","The minimum and maximum amounts of memory the P6 server can utilize. The Xms value specifies the server's initial JVM heap size and the Xmx value specifies the server's maximum JVM heap size.","Xms512m Xmx1024m","Xms256m Xmx512m","tm_server","The name of the managed server on which the P6 Team Member Web application is deployed.","TeamMember","tmServer","tmserver_port","The port on which the P6 Team Member Web application server is hosted.","8207","4002","tmserver_minmax","The minimum and maximum amounts of memory the P6 Team Member Web server can utilize. The Xms value specifies the server's initial JVM heap size and the Xmx value specifies the server's maximum JVM heap size.","Xms256m Xmx512m","Xms512m Xmx1024m","api_server","The name of the managed server on which the P6 Integration API is deployed.","P6IntegrationAPI","apiServer","apiserver_port","The port on which the P6 Integration API is hosted.","8205","4004","apiserver_minmax","The minimum and maximum amounts of memory the P6 Integration API  server can utilize. The Xms value specifies the server's initial JVM heap size and the Xmx value specifies the server's maximum JVM heap size.","Xms256m Xmx512m","Xms512m Xmx1024m","ws_server","The name of the managed server on which the P6 EPPM Web Services is deployed.","P6WebServices","wsServer","wssever_port","The port on which the P6 EPPM Web Services is hosted.","8206","4006","wsserver_minmax","The minimum and maximum amounts of memory the P6 EPPM Web Services server can utilize. The Xms value specifies the server's initial JVM heap size and the Xmx value specifies the server's maximum JVM heap size.","Xms256m Xmx512m","Xms512m Xmx1024m","p6pro_server","The name of the managed server on which the P6 Professional application is deployed.","p6procloudconnect","proServer","p6pro_port","The port on which the P6 Professional server is hosted.","8208","4008","p6pro_minmax","The minimum and maximum amounts of memory the P6 Professional server can utilize. The Xms value specifies the server's initial JVM heap size and the Xmx value specifies the server's maximum JVM heap size.","Xms1024m Xmd1024m","Xms526m Xmd1024m","nodeManagerPort","The port on which the WebLogic domain nodeManager is hosted.","5556","8000","Setting WebLogic Configuration Properties","94259.htm");
Page[32]=new Array("On the Application Server Configuration screen:","Select the Configure WebLogic option.","Note","If you do not want to configure WebLogic right now, ensure the Configure WebLogic option is clear and click Next to continue to the next screen. If you want to configure WebLogic manually, refer to the P6 Server Configuration Guide.","Choose one of the following:","Create a new WebLogic domain if you are creating a new domain.","Use an existing WebLogic domain if you already have a WebLogic domain.","Note This is the domain where the wizard will create your managed servers for each application.","(Optional) Select Deploy Oracle WSM Policy Manager if you are integrating with BPM and or select Configure WSM Policy for P6WebServices if you are configuring OWSM authentication for P6 EPPM Web Services. For more information, refer to the P6 EPPM Web Services Programming Guide.","Note By default, the configuration wizard deploys P6 EPPM Web Services with the oracle/wss_username_token_server_policy OWSM policy. This policy does not contain message protection and encryption and needs additional configuration to enable either. Refer to Adding Additional Policies to Oracle Web Services Manager in the P6 EPPM System Administration Guide for details on configuring additional OWSM policies.","Click Next.","Using the Application Server Configuration Screen","53052.htm");
Page[33]=new Array("On the Configure WebLogic screen:","In the WebLogic Server Home field, verify or choose the location of your WebLogic home. For example, C:\\Oracle\\Middleware\\Oracle_Home.","In the Domain Home field, enter or verify your WebLogic domain home name.","In the Port field, enter or verify the port number that your WebLogic domain is using. The default port is 7001.","In the Administration Username field, create or verify your administrative user name for the WebLogic domain you defined on the previous screen.","In the Password and Confirm Password fields, enter the password for your administrative username.","Click Next.","Using the Configure WebLogic Screen","53053.htm");
Page[34]=new Array("On the Configure Component Schema screen:","Note","This screen will only appear if you selected the Deploy Oracle WSM Policy Manager option above. If you did not select the option, the wizard will skip this screen.","You must create the required schema for BPM before you deploy the P6 EPPM Configuration Wizard. For more information about the schema required for BPM, see the Oracle Fusion Middleware Installing and Configuring Oracle SOA Suite and Business Process Management guide.","On the Component Schema screen:","For the Configure Component Schema Connection option, choose Oracle, ATP, or Microsoft SQL Server.","If you are using Oracle Database, select SID or Service.","Do the following for the schema in the Component Schema fields:","In the Host Name field, enter the server machine name or IP address where you installed the database. ","In the Port field, enter or verify the port number for your database.","The default for Oracle is 1521.","The default for Microsoft SQL Server is 1433.","In the Schema Owner field, enter or verify the name of the schema owner.","In the Password field, enter the password to log into the database.","In the SID/Service field, enter the SID or Service based on the database you installed.","Click Next.","Using the Configure Component Schema Screen","78993.htm");
Page[35]=new Array("If you installed a content repository, reporting software, or BPM, you can use the P6 EPPM Configuration Wizard to configure these applications to work with P6 EPPM. The settings in this wizard correspond to the settings in the Primavera P6 Administrator.","Note","You can configure the settings for these applications later in the Primavera P6 Administrator. See Manually Configuring Your Applications for the guides you will need.","If you are using an existing P6 configuration, the wizard will skip the content repository, reporting software, and BPM screens.","Connecting Applications to P6 EPPM","53054.htm");
Page[36]=new Array("On the Content Repository Selection screen:","Select the Connect to a Content Repository option.","Note If you would rather configure your content repository manually or do not have a content repository installed, ensure the Connect to a Content Repository option is clear and click Next. See the P6 EPPM Content Repository Configuration Guide for more information.","Select one of the following:","Oracle Webcenter Content Core Capabilities","Microsoft SharePoint","CMIS compliant content repositories","Oracle Database","Note","If you select Oracle Database, you will not need to configure your database as a content repository in the P6 EPPM Configuration Wizard. This option is available if your database is hosted on Oracle Server or Oracle Autonomous Database.","If you want to configure Microsoft SharePoint with P6, you must configure it with your CMIS-compliant content repository and then select CMIS for this step. See your CMIS-client content repository documentation for information about how to configure your CMIS-compliant content repository with Microsoft SharePoint.","Click Next.","Using the Content Repository Selection Screen","53055.htm");
Page[37]=new Array("On the Content Repository Configuration screen:","Note Ensure the settings you entered in when you configured the content repository match the settings you enter below.","In the Host field, enter the machine name or IP address of the content repository server.","In the Port field, enter the IntradocServerPort number of the content repository server. By default, this is 4444. To find the port number: ","Navigate to WCCC_Home\\ucm\\cs\\config\\.","Open the config.cfg file.","Find the IntradocServerPort line, which contains the port number.","In the Oracle Home field, enter the path to the P6 EPPM content repository files on the content repository server, as specified when you configured your content repository. This setting is required.","Example:","//Contribution Folders/Production/Oracle Primavera/","In the Oracle Security Group field, enter the name of the Security Group assigned to the document folder created in WebCenter for P6 EPPM documents, as specified when you configured the content repository. ","In the Oracle Security Account field, enter the name of the Security Account for P6 EPPM documents, as specified when you configured the content repository. ","If you did not enable security accounts, leave this setting blank.","In the Oracle Document Type field, enter the document type for P6 EPPM documents, which can be either an existing document type or a new one, as specified when you configured the content repository. ","For example:","Enter the Document Type as Document.","In the Metadata Prefix field, enter the prefix added to P6 EPPM metadata fields, as specified when you configured the content repository. For example, Prm.","In the Admin User field, enter the user name with administrative privileges, as specified when you configured the content repository. This setting is required.","From the Authentication Mode drop-down menu, select the authentication mode used to access the content repository server. P6 EPPM users cannot access content repository functions if you do not configure this setting.","If you choose &quot;Multiple User&quot;, all P6 EPPM content repository-related user names must match the equivalent content repository user name. For example, a P6 EPPM user named &quot;Joe&quot; must have an equivalent user named &quot;Joe&quot; in the content repository. ","If you choose &quot;Single User&quot;, the administrative user specified in the setting above must have access to all appropriate Security Groups to browse to documents outside of the P6 EPPM home folder.","Click Next.","Using the Content Repository Configuration Screen for Oracle Webcenter Content Core Capabilities","53058.htm");
Page[38]=new Array("Note","The SharePoint connector has been removed from version 16.1 and later. New SharePoint users should configure SharePoint with a CMIS-compliant content repository, and then configure P6 EPPM to the CMIS-compliant content repository. ","Do not reconfigure SharePoint with a CMIS-compliant content repository if you previously configured your SharePoint connection using the Primavera P6 Administrator and SharePoint connector. Reconfiguring SharePoint with a CMIS repository will prevent previously stored documents from being visible. For more information, refer to documentation from Version 16.","If you have already used the SharePoint connector to connect P6 EPPM to SharePoint, on the Content Repository Configuration screen:","In the Login Name field, enter a SharePoint user name with administrative privileges.","Note You do not need to include your domain. You just need your user name.","In the Password field, enter the password for the SharePoint login name.","In the Authentication Mode field, select the mode used to connect to the SharePoint content repository database. P6 EPPM users cannot access content repository functions if you do not configure this setting.","If you choose &quot;Multiple User&quot;, all P6 EPPM content repository-related user names must match the equivalent SharePoint user name. For example, a P6 EPPM user named &quot;Joe&quot; must have an equivalent user named &quot;Joe&quot; in SharePoint.","If you choose &quot;Single User&quot;, the administrative user specified in the setting above must have access to all appropriate SharePoint libraries to browse to documents outside of the P6 EPPM home folder.","In the Host Name field, enter the machine name or IP address of the SharePoint server.","In the Domain field, enter the domain where the SharePoint server resides.","In the Document Library URL field, enter the URL of the P6 EPPM document library on SharePoint that you created when you configured SharePoint.&nbsp;The URL includes the machine name (or IP address) of the content repository server and the path to the content repository library.","Example format:","http://&lt;hostname&gt;:&lt;port&gt;/&lt;domain&gt;/&lt;doclib&gt;","Note","Do not put a / at the end of the URL.","Ensure there are no spaces in the URL.","In the Web Service URL field, enter the URL of the Web Service used to connect P6 EPPM to SharePoint, as specified when you configured SharePoint. The URL includes the machine name (or IP address) of the content repository server, port number of the server, and web service name.","Example format:","http://&lt;hostname&gt;:&lt;port&gt;/WS_FPRPC","Note Do not put a / at the end of the URL.","In the External Document Library URL field, enter the URL of an external document library. If you need to connect to a non-P6 EPPM document library, you must configure this setting.","Example format:","http://&lt;hostname&gt;:&lt;port&gt;/&lt;extdoclib&gt;","Note Do not put a / at the end of the URL.","Click Next.","Using the Content Repository Configuration Screen for Microsoft SharePoint","53059.htm");
Page[39]=new Array("On the Content Repository Configuration screen:","In the Login Name field, enter the user name for your content repository.","In the Password field, enter the password for the user name you entered above.","In the Authentication Mode field, enter authentication mode used to access the content repository server. P6 EPPM users cannot access content repository functions if you do not configure this setting.","If you choose &quot;Multiple User&quot;, all P6 EPPM content repository-related user names must match the equivalent content repository user name. For example, a P6 EPPM user named &quot;Joe&quot; must have an equivalent user named &quot;Joe&quot; in the content repository.","If you choose &quot;Single User&quot;, the administrative user specified in the setting above must have access to all appropriate Security Groups to browse to documents outside of the P6 EPPM home folder.","In the Repository Name field, enter the name for your content repository.","Note For SharePoint, enter the document library name you created for P6. ","In the Document Home field, enter the location of the folder in the document library where you want to store P6 documents.","In the Web Service URL field, enter the URL for your web services home.","This is Web Service Endpoint with format http://&lt;sharepoint host&gt;/sites/&lt;site name&gt;/_vti_bin/cmissoapwsdl.aspx","Using the Content Repository Configuration Screen for CMIS","78827.htm");
Page[40]=new Array("On the BI Publisher screen:","Select the Connect to Oracle Analytics Publisher option.","Note If you would rather configure Oracle Analytics Publisher manually or do not have Oracle Analytics Publisher installed, verify the Connect to Oracle Analytics Publisher option is clear and click Next. See the P6 EPPM Oracle Analytics Publisher Configuration Guide for more information.","In the Server URL field, enter the URL used to connect to the Oracle Analytics Publisher web service to P6.","For example, http://serverIP:port/xmlpserver/services/PublicReportService?wsdl","In the Version field, enter the version of Oracle Analytics Publisher that you want to integrate with P6.","In the Folder Paths field, enter the relative path to the Oracle Analytics Publisher P6 reports folder where P6 will search for reports.","Example format (the forward slash is required):","/P6REPORTS","Note You can find the relative path (for example,  /P6Reports) in the following folder: %weblogic_home%\\user_projects\\domains\\bifoundation_domain\\config\\bipublisher\\repository\\P6Reports","In the Admin Username field, enter an Oracle Analytics Publisher web services user name with administrative privileges (for example, PxRptUser).","In the Password field, enter the password for the administrative user name.","Select Personal Folders, to enable personal folders per user. If you do not want to use personal folders, leave the option clear. Users have their own personal folders where they can store their objects. Only the user who created and saved the content in the folder can access the folder.","Select Scrub Username, to enable the setting or leave it clear to ensure it is disabled.","This setting controls whether special characters (non-alphanumeric) are removed from the user name when connecting to Oracle Analytics Publisher. The default is 'false,' meaning special characters will not be removed.","If you are using the P6 EPPM Extended Schema for Oracle Analytics Publisher reporting, leave the setting as false. ","If you are using the P6 ODS Schema for Oracle Analytics Publisher reporting, change the setting to true. Setting the value to true will allow the user's security context (user name) to format properly before it goes to Oracle Analytics Publisher. This allows reporting queries to perform against the ODS tables.","In the Cache Timeout field, enter how long cached report definitions should appear.","The default is 1d.","Click Next.","Using the Oracle Analytics Publisher Screen","53060.htm");
Page[41]=new Array("On the BPM Workflows screen:","Select the Connect to BPM option.","Note If you would rather configure BPM manually or do not have BPM installed, ensure the Connect to BPM option is clear and click Next. For more information, see the P6 EPPM BPM Configuration Guide.","In the Connector file location field, enter the full path (including the file name) where you copied the connector files.","For example:","c:/Software/BPMJars/eppmjars/prm-bpm-connector-12c-v1.0.jar","In the BPM library path field enter the directory where you copied all the jars.","Note","To satisfy these requirements, this admin setting can contain multiple path elements. You must separate multiple path elements with a semicolon.&nbsp;For example: C:\\Software\\BPMJars;C:\\Software\\BPMJars","If the above settings are incorrect or the BPM jar files are incomplete, you will see an error message when you try to configure BPM. Verify that your settings and jar files are correct.","Using the BPM Workflows Screen","53061.htm");
Page[42]=new Array("On the BPM Configuration screen, add the following settings:","In the bpm.user field, enter the BPM user with administrative access to BPM.","In the bpm.password field, enter the password for the user.","In the bpm.t3.url field, enter the T3 URL for your Oracle SOA configuration. For example: t3://&lt;host_name&gt;:&lt;port&gt;/soa-infra","In the bpm.security.realm field, enter the name of the security realm used by BPM.&nbsp;This is jazn.com by default.","In the bpm.soap.url field, enter the URL for the SOAP services. Usually this URL takes the form of http://&lt;host_name&gt;:&lt;port&gt;.","In the bpm.workspace.url field, enter an address in the form of http://&lt;host_name&gt;:&lt;port&gt; that indicates where the BPM Workspace application is hosted.","Note The host can be an IP address or a host name such as a machine name.","In the bpm.partition field, enter the name of the SOA partition containing the BPM composite applications you would like to use in P6.&nbsp;The default partition name is default.","Click Next.","Using the BPM Configuration Screen","54015.htm");
Page[43]=new Array("Once you have finished entering your configuration settings, you can verify all the applications you configured. Once you click Configure, the wizard will setup your P6 EPPM environment and start WebLogic. After the wizard finishes, you will be able to login and use all of your applications.","Completing Your P6 EPPM Installation","53064.htm");
Page[44]=new Array("On the Configuration Review screen:","Verify all your configuration settings are correct.","Click Next.","On the Acknowledgment dialog box, click OK to confirm you have read the information.","If you are upgrading from P6 8.2 or lower version and have been using a content repository configured with P6, you will need to run the Document Migration Utility located in P6 home after the installation completes.","On the Start Configuration? dialog box, click Yes to confirm you want the wizard to configure your applications.","Click No if you do not want to continue with the configuration.","Using the Configuration Review Screen","53065.htm");
Page[45]=new Array("On the Configuration Progress screen, the wizard will let you know when each item is configured. The configuration process will take several minutes. When the configuration is done, all of your applications will have a green check next to them.","The configuration wizard will do any of the following based on the selections you made in the previous screens:","Create your database.","Create or upgrade the Primavera Configuration.","Create a WebLogic domain.","Create bootstrap files for your applications.","Create managed servers and deploy the applications you installed into them.","Configure integrations with other servers for the content repository, your P6 reporting software, and BPM.","Configure URLs to the P6 Help in the Primavera P6 Administrator.","Create Start menu items for P6 EPPM URLs and start/stop scripts. ","Sets your parameters in WebLogic.","For example, it will set your bootstrap variables and Java heap settings for you. This will connect P6 to your other P6 EPPM applications and ensure that your environment is set up for optimal performance.","When the configuration wizard completes this process:","Note the location of the log file. Use the log file to view what happened during setup and see what went wrong if an error occurred.","Click Next.","Using the Configuration Progress Screen","53066.htm");
Page[46]=new Array("On the Configuration Complete screen:","Click any link to go to the default URL for each of your applications.","Click the Save Configuration button.","Note The HTML file you save contains the default URLs and other information for your P6 EPPM applications.","Choose a location where you want to store your HTML file (Oracle recommends using the P6 EPPM directory you created when you installed your applications).","In the File Name field, verify or enter a name for your configuration HTML file.","Click Save.","On the Configuration Saved Successfully dialog box, click OK.","Click Finish.","Note Once you click Finish, the wizard will start WebLogic for you so you can begin using your applications instantly.","Using the Configuration Complete Screen","53067.htm");
Page[47]=new Array("The configuration wizard creates the following defaults.","Oracle Primavera EPPM Home","C:\\p6eppm_1\\ ","Holds all your P6 EPPM applications folders and files","Note","The local drive location is the default the wizard provides. If you changed it, it will be noted in the HTML file you saved in Using the Configuration Complete Screen.","You will need to enter your IP address where it says 'server' in the URLs below.","WebLogic Administration Console","Port: 7001","URL: http://server:7001/console","P6","Port: 8203","URL: http://server:8203/p6","P6 Integration API","Port: 8205","URL: http://server:8205/PrimaveraAPI","P6 EPPM Web Services","Port: 8206","URL: http://server:8206/p6ws/services","P6 mobile","Port: 8207","URL: http://server:8207/p6tmws","Note This is the URL you will enter when you sign into the P6 mobile app on your mobile device. The actual URL will not work in a browser.","P6 Team Member Web","Port: 8207","URL: http://server:8207/p6tmweb","Email Statusing Service","File Name: p6tm-email-service.zip","Default Location: C:\\P6EPPM_1\\tmws or /usr/P6EPPM_1/tmws","Note You will have to unzip the file and configure the email services before you can update status through email. See the P6 EPPM System Administration Guide.","P6 Professional Cloud Connect","Port: 8208","URL: http://server:8208/p6procloudconnect ","Note This URL (case-sensitive) must be provided to P6 Professional users to enable them to setup and configure a new database connection to the P6 Pro Cloud Connect service in the P6 Professional database configuration utility.","For more details on establishing the P6 Pro Cloud Connect connection in P6 Professional, see the P6 ProfessionalInstallation and Configuration Guide (P6 EPPM).","Default Locations Created by the Wizard","54635.htm");
Page[48]=new Array("The Java Heap settings will provide most environments with optimal performance. Do not change them unless you know your environment requires different settings. Xms is the initial heap size. Xmx is the maximum heap size.","WebLogic Administration Console Java Heap","-Xms512m -Xmx1024m","P6 Java Heap","-Xms512m -Xmx1024m","P6 ProfessionalCloud Connect","-Xms1024m -Xmx1024m","P6 Integration API Java Heap","-Xms256m -Xmx512m","P6 EPPM Web Services Java Heap","-Xms256m -Xmx512m","P6 mobile Java Heap","-Xms256m -Xmx512m","P6 Team Member Web Java Heap","-Xms256m -Xmx512m","Default Java Heap Settings Created by the Wizard","79187.htm");
Page[49]=new Array("Now that you've installed all of your P6 EPPM applications, you can begin using P6. You may find the following guides useful to get started:","P6 EPPM System Administration Guide","Note You can use this guide to configure Email Statusing Service.","P6 EPPM Application Administration Guide","P6 Help","Where To Go From Here - Post Configuration Wizard","52007.htm");
Page[50]=new Array("After you have installed and configured your P6 EPPM applications, you can launch your applications by doing the following:","Go to the scripts folder where you installed P6 EPPM (for example, C:\\P6EPPM_1\\scripts or /usr/P6EPPM_1/scripts).","If you are on Windows, launch the start_Primavera.bat.","If you are on Linux, launch the start_Primavera.sh.","Note You need to launch the file only once unless you stop the server or need to restart the machine.","Open the HTML file you saved when you finished your configuration and choose the URL for the application you want to launch.","Login to the application.","Tip","If you are on Windows, you can use the Start menu to launch your applications.","Go to Start, P6 EPPM.","Select the start_Primavera.bat file and wait for it to say running.","Select the application you want to launch and login.","If you want to set up the WebLogic Admin Server and Managed Servers to run as Windows Services, see WebLogic's documentation.","Launching Your P6 EPPM Applications","53676.htm");
Page[51]=new Array("You have several options for starting and stopping managed servers. Oracle recommends that you use the startNodeManager file and start the server in the WebLogic Remote Console (see Starting a Managed Server). However, you can view other ways to stop and start managed servers at &quot;Managing Server Startup and Shutdown for Oracle WebLogic Server&quot; at https://docs.oracle.com/middleware/1221/wls/START/overview.htm.","Note You can use different ways to start the managed servers, but you must ensure that the managed servers recognize the arguments required for your application (for example, the argument for where the bootstrap is located) and how the application environment will start.","Starting and Stopping Managed Servers","48157.htm");
Page[52]=new Array("To start a managed server:","Launch the WebLogic Remote Console from the Start menu.","Click [Missing information: how to open the menu shown in the screenshot? That area to the left is called the &quot;NavStrip&quot; in WL docs] ","In the Navigation Tree, expand Deployments, then Application Management.","In the Monitoring Tree page, select the applications you want to stop, then click Start and choose Servicing all requests.","Starting a Managed Server","50104.htm");
Page[53]=new Array("To stop a managed server:","Launch the WebLogic Remote Console from the Start menu.","Click [Missing information: how to open the menu shown in the screenshot? That area to the left is called the &quot;NavStrip&quot; in WL docs] ","In the Navigation Tree, expand Deployments, then Application Management.","In the Monitoring Tree page, select the applications you want to stop, then click Stop and choose Force stop now.","Stopping a Managed Server","50105.htm");
Page[54]=new Array("The following lists things you must set in P6 before you begin using it. Use the P6 EPPM System Administration Guide and the P6 EPPM Application Administration Guide for instructions on how to set the following:","Set the base currency","Note You must choose the base currency if you do not want the database to use US dollars ($) as the base currency. You cannot change the base currency once projects are in progress.","Add users and assign them the appropriate security privileges.","Configure the Primavera P6 Administrator for your environment.","Settings You Must Configure in P6 Before You Begin","53147.htm");
Page[55]=new Array("The following applications will work with P6 EPPM, but are not installed or configured with the wizard. See the guides mentioned for more information about each product.","P6 Professional (see the P6 Professional Installation and Configuration Guide)","Oracle Identity Manager (see P6 EPPM Oracle Identity Manager Configuration Guide)","Oracle Enterprise Manager (see Primavera Oracle Enterprise Manager Configuration Guide)","Oracle Access Manager (see Primavera Oracle Access Manager Configuration Guide)","Oracle Analytics Publisher (see P6 EPPM Oracle Analytics Publisher Configuration Guide)","Oracle BPM (see P6 EPPM BPM Configuration Guide)","Installing Additional Applications","53142.htm");
var PageCount=56;


/*
Date: 12/11/2025 7:37 PM
Source: EPPM_25_dev
BookID: 51993
PubProduct: PRIMAVERA_EPPM
BookTitle: Installation and Configuration Guide for On-Premises
Version: Version 25
Lang:	en
*/
	var PageLength=Page.length;
	var Result = "";
	var ResultTemp = "";
	var ResultFound = "";
	var ResultTitleOnly = [];
	var ResultTitleAndContent = [];
	var ResultInContent = [];
	var ResultInContentTemp = [];

	var ResultCombinedTemp = [];
	var ResultCombined = [];

	var arrayIndex = 0;
	var NrRes = 0;
	var j = 0;
	var i = 0;
	var k = 0;
	var d = 0;
	var maxItems = 1000;
	var heading = 0;
	var WordPos = -1;
	var WordPosHeading = -1;
	var WordPosContentText = -1;
	var FoundWord = "";
	var FoundWordHead = "";
	var SearchInHeadingOnly = 0;
	var isChecked;
	var size = 10;
	var resGroupCounter = 0;
	var shown = "shown";
	var checkBoxInHeading;
	var searchFlag = 0;
	var DivResult;
	var SearchWord;

if (SearchText && SearchText.length >= 1) {
		SearchWord = SearchText.replace(/\+/g, " ").replace(/&/g, "&amp;").replace(/</g, "&lt;").replace(/>/g, "&gt;").replace(/"/g, "&quot;");
		searchFlag = 1;
	} else {
		SearchWord = "";
		searchFlag = 0;
	}
	

	if (searchFlag === 1) {
		Result = "";

		// checkBoxInHeading = document.getElementById("inHeading");
		if (inHeading) {

			isChecked = true;
		} else {

			isChecked = false;
		}

		if (SearchWord && SearchWord.length >= 1) {
			if (isChecked) {
				SearchInHeadingOnly = 1;
			} else {
				SearchInHeadingOnly = 0;
			}
			SearchWord = SearchWord.toLowerCase();
			window.status = "Searching, please wait...";
			for (j = 0; j < PageLength; j++) {
				k = Page[j].length - 1;
				for (i = 0; i < k; i++) {

					heading = k - 1;

					if (SearchInHeadingOnly === 1) {
						WordPosHeading = Page[j][heading].toLowerCase().indexOf(SearchWord);
						if (WordPosHeading > -1) {
							FoundWordHead = Page[j][heading].substr(WordPosHeading, SearchWord.length);

							NrRes++;
							ResultTemp = "<li>";
							ResultTemp += "<span>";
							ResultTemp += "<a href='" + Page[j][k] + "'>" + Page[j][heading].replace(FoundWordHead, FoundWordHead.bold()) + "</a><br/>\n";

							ResultTemp += "</span>";
							ResultTemp += "</li>";

							ResultTitleOnly[arrayIndex] = ResultTemp;
							arrayIndex++;

							ResultTemp = "";
							WordPosHeading = -1;
							WordPosContentText = -1;
							break;
						}
					} else if (SearchInHeadingOnly === 0) {
						WordPos = Page[j][i].toLowerCase().indexOf(SearchWord);
						WordPosHeading = Page[j][heading].toLowerCase().indexOf(SearchWord);
						if (WordPos > -1) {
							FoundWordHead = Page[j][heading].substr(WordPosHeading, SearchWord.length);
							FoundWord = Page[j][i].substr(WordPos, SearchWord.length);
							FoundWord = Page[j][i].substr(WordPos, SearchWord.length);
							NrRes++;
							ResultTemp += "<li>";
							ResultTemp += "<span>";
							if (WordPosHeading > -1) {
								ResultTemp += "<a href='" + Page[j][k] + "'>" + Page[j][heading].replace(FoundWordHead, FoundWordHead.bold()) + "</a><br/>\n";
							} else {
								// found word is not in the head
								ResultTemp += "<a href='" + Page[j][k] + "'>" + Page[j][heading] + "</a><br/>\n";

							}
							if (i < k - 1) {
								WordPosContentText = Page[j][i].toLowerCase().indexOf(SearchWord);

								if (Page[j][i].length > 300 && (WordPosContentText > -1)) {

									if (WordPosContentText > 75) {
										ResultInContentTemp.push("..." + Page[j][i].substr(WordPosContentText - 75, 175 + FoundWord.length).replace(FoundWord, FoundWord.bold()) + "...");
									} else {
										ResultInContentTemp.push("..." + Page[j][i].substr(0, 175 + FoundWord.length).replace(FoundWord, FoundWord.bold()) + "...");

									}

								} else if (WordPosContentText > -1) {

									ResultInContentTemp.push(Page[j][i].replace(FoundWord, FoundWord.bold()));

								}
							}

							ResultTemp += ResultInContentTemp.join("");

							ResultTemp += "</span>";
							ResultTemp += "</li>";

							if (WordPosHeading > -1) {
								ResultTitleAndContent[arrayIndex] = ResultTemp;
								arrayIndex++;
							} else {
								ResultInContent[arrayIndex] = ResultTemp;
								arrayIndex++;
							}

							ResultInContentTemp.length = 0;
							ResultTemp = "";
							WordPosHeading = -1;
							WordPosContentText = -1;
							break;
						}

					}
				}
			}

			ResultTitleOnly = ResultTitleOnly.filter(function (n) {
				return (n !== undefined && n !== null);
			});
			ResultTitleAndContent = ResultTitleAndContent.filter(function (n) {
				return (n !== undefined && n !== null);
			});
			ResultInContent = ResultInContent.filter(function (n) {
				return (n !== undefined && n !== null);
			});

			ResultCombinedTemp = ResultTitleOnly.concat(ResultTitleAndContent, ResultInContent);

			ResultCombinedTemp = ResultCombinedTemp.filter(function (n) {
				return (n !== undefined && n !== null);
			});

			for (d = 0; d < ResultCombinedTemp.length; d += size) {
				resGroupCounter++
				ResultCombined.push("<div id=" + "'" + "resGroup_" + resGroupCounter + "'" + " class=" + "'" + "resGroup " + shown + "'" + ">" + "<ol class='searchResults'>" + ResultCombinedTemp.slice(d, d + size).join("") + "</ol></div>");
				shown = "notshown";
			}

			ResultFound = ResultCombined.join("");

Result += "<div id='searchDetailsDiv'>";
			Result += "<p class='searchDetails'>Your Search Found&nbsp;" + NrRes + "&nbsp;items.&nbsp;";
			Result += "</p></div>";
			
			Result += "<div class='searchResultsDiv'>";
			Result += "<div id='resultsCollection' class='searchResults'>";
			Result += ResultFound;
			Result += "</div>";
			Result += "</div>";
			Result += "<div class='searchPaging'>";

			Result += '<hr />';

			Result += '<p class="bodytext"><a class="disabledAnchor" id="pBack" onclick="turnPage(\'backPage\')" href="#pBack">Back</a>&nbsp; | &nbsp;';
			
			if (resGroupCounter && resGroupCounter > 1) {
				Result += '<a id="pNext" onclick="turnPage(\'nextPage\')" href="#pNext">Next</a>';
			} else {
				Result += '<a id="pNext"  class="disabledAnchor" href="#pNext">Next</a>';
			}
			Result += '</p>\n';
			Result += '<div id="pagenofn"><p class="bodytext">Page <span id="pagen">1</span> of ' + resGroupCounter + '</p></div>';

			Result += "</div>";
			
			
		}

		DivResult = document.getElementById("s_anchor");
		if (Result && DivResult) {

			//myDivResult.append(Result);
			DivResult.innerHTML = Result;
			

		}
		window.status = "";
		
		

	}
	}())
}
